/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.demangler.swift.nodes;

import ghidra.app.util.demangler.Demangled;
import ghidra.app.util.demangler.DemangledException;
import ghidra.app.util.demangler.DemangledFunction;
import ghidra.app.util.demangler.swift.SwiftDemangler;
import ghidra.app.util.demangler.swift.datatypes.SwiftFunction;
import ghidra.app.util.demangler.swift.nodes.SwiftNode;

public class SwiftConstructorNode
extends SwiftNode {
    @Override
    public Demangled demangle(SwiftDemangler demangler) throws DemangledException {
        String name = null;
        Demangled namespace = null;
        Demangled type = null;
        Demangled labelList = null;
        block5: for (SwiftNode child : this.getChildren()) {
            switch (child.getKind()) {
                case Class: {
                    namespace = child.demangle(demangler);
                    name = "init";
                    continue block5;
                }
                case Type: {
                    type = child.demangle(demangler);
                    continue block5;
                }
                case LabelList: {
                    labelList = child.demangle(demangler);
                    continue block5;
                }
            }
            this.skip(child);
        }
        if (name == null) {
            return this.getUnknown();
        }
        SwiftFunction function = new SwiftFunction(this.properties.mangled(), this.properties.originalDemangled(), name, namespace, "__thiscall");
        if (type instanceof DemangledFunction) {
            DemangledFunction functionType = (DemangledFunction)type;
            function.setType(functionType, labelList);
        }
        return function;
    }
}

