/*
 * Decompiled with CFR 0.152.
 */
package sarif.export.code;

import com.google.gson.JsonElement;
import generic.stl.Pair;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.listing.FlowOverride;
import ghidra.program.model.listing.Instruction;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import sarif.export.AbstractExtWriter;
import sarif.export.SarifObject;
import sarif.export.code.ExtCodeBlock;
import sarif.export.code.ExtCodeOverride;
import sarif.managers.CodeSarifMgr;

public class SarifCodeWriter
extends AbstractExtWriter {
    private List<AddressRange> blocks;
    private List<Pair<Instruction, FlowOverride>> overrides;

    public SarifCodeWriter(List<AddressRange> target0, List<Pair<Instruction, FlowOverride>> target1, Writer baseWriter) throws IOException {
        super(baseWriter);
        this.blocks = target0;
        this.overrides = target1;
    }

    @Override
    protected void genRoot(TaskMonitor monitor) throws CancelledException, IOException {
        this.genCode(monitor);
        this.genOverrides(monitor);
        this.root.add("code", (JsonElement)this.objects);
    }

    private void genCode(TaskMonitor monitor) throws CancelledException, IOException {
        monitor.initialize((long)this.blocks.size());
        for (AddressRange range : this.blocks) {
            ExtCodeBlock isf = new ExtCodeBlock(range);
            SarifObject sarif = new SarifObject(CodeSarifMgr.SUBKEY, CodeSarifMgr.KEY, this.getTree(isf), range.getMinAddress(), range.getMaxAddress());
            this.objects.add(this.getTree(sarif));
            monitor.increment();
        }
    }

    private void genOverrides(TaskMonitor monitor) throws CancelledException, IOException {
        monitor.initialize((long)this.overrides.size());
        for (Pair<Instruction, FlowOverride> pair : this.overrides) {
            Instruction inst = (Instruction)pair.first;
            ExtCodeOverride isf = new ExtCodeOverride(pair);
            SarifObject sarif = new SarifObject(CodeSarifMgr.SUBKEY2, CodeSarifMgr.KEY, this.getTree(isf), inst.getMinAddress(), inst.getMaxAddress());
            this.objects.add(this.getTree(sarif));
            monitor.increment();
        }
    }
}

