/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.listing;

import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolType;

public interface Library
extends Namespace {
    public static final String UNKNOWN = "<EXTERNAL>";

    @Override
    default public Namespace.Type getType() {
        return Namespace.Type.LIBRARY;
    }

    public String getAssociatedProgramPath();

    public static Library getContainingLibrary(Symbol symbol) {
        if (symbol == null) {
            return null;
        }
        if (symbol.getSymbolType() == SymbolType.LIBRARY) {
            return (Library)symbol.getObject();
        }
        if (symbol.getSymbolType() == SymbolType.NAMESPACE || symbol.getSymbolType() == SymbolType.CLASS) {
            while (symbol != null && symbol.isExternal()) {
                Namespace n = (Namespace)symbol.getObject();
                if (n instanceof Library) {
                    Library lib = (Library)n;
                    return lib;
                }
                symbol = n.getParentNamespace().getSymbol();
            }
        }
        return null;
    }
}

