/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.languages.sleigh;

import ghidra.app.plugin.assembler.sleigh.sem.AssemblyDefaultContext;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyPatternBlock;
import ghidra.app.plugin.languages.sleigh.ConstructorEntryVisitor;
import ghidra.app.plugin.languages.sleigh.SleighLanguages;
import ghidra.app.plugin.processors.sleigh.Constructor;
import ghidra.app.plugin.processors.sleigh.ContextChange;
import ghidra.app.plugin.processors.sleigh.ContextCommit;
import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.app.plugin.processors.sleigh.pattern.DisjointPattern;
import ghidra.app.plugin.processors.sleigh.symbol.SubtableSymbol;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class InputContextScraper {
    private final SleighLanguage language;

    public InputContextScraper(SleighLanguage language) {
        this.language = language;
    }

    public Set<AssemblyPatternBlock> scrapeInputContexts() {
        AssemblyPatternBlock defaultCtx = new AssemblyDefaultContext(this.language).getDefault();
        Arrays.fill(defaultCtx.getVals(), (byte)0);
        GlobalSetScraper globalSetScraper = new GlobalSetScraper(defaultCtx);
        SleighLanguages.traverseConstructors(this.language, globalSetScraper);
        AssemblyPatternBlock nonInputCtxMask = globalSetScraper.getContextMask().invertMask();
        ConstraintScraper constraintScraper = new ConstraintScraper(nonInputCtxMask, this.language.getContextBaseRegister().getNumBytes());
        SleighLanguages.traverseConstructors(this.language, constraintScraper);
        return constraintScraper.getInputContexts();
    }

    private static class GlobalSetScraper
    implements ConstructorEntryVisitor {
        private AssemblyPatternBlock contextMask;

        GlobalSetScraper(AssemblyPatternBlock contextMask) {
            this.contextMask = contextMask;
        }

        public AssemblyPatternBlock getContextMask() {
            return this.contextMask;
        }

        @Override
        public int visit(SubtableSymbol subtable, DisjointPattern pattern, Constructor cons) {
            for (ContextChange chg : cons.getContextChanges()) {
                if (!(chg instanceof ContextCommit)) continue;
                ContextCommit cc = (ContextCommit)chg;
                this.contextMask = this.contextMask.writeContextCommitMask(cc);
            }
            return 0;
        }
    }

    private static class ConstraintScraper
    implements ConstructorEntryVisitor {
        private final AssemblyPatternBlock nonInputMask;
        private final AssemblyPatternBlock blankContext;
        private final Set<AssemblyPatternBlock> inputContexts;

        ConstraintScraper(AssemblyPatternBlock mask, int contextRegLen) {
            this.nonInputMask = mask;
            this.blankContext = AssemblyPatternBlock.fromLength(contextRegLen);
            this.inputContexts = new HashSet<AssemblyPatternBlock>();
        }

        public Set<AssemblyPatternBlock> getInputContexts() {
            return this.inputContexts;
        }

        @Override
        public int visit(SubtableSymbol subtable, DisjointPattern pattern, Constructor cons) {
            AssemblyPatternBlock inputCtx;
            AssemblyPatternBlock contextConstraint = AssemblyPatternBlock.fromPattern(pattern, pattern.getLength(true), true);
            if (contextConstraint.getMask().length > 0 && (inputCtx = this.blankContext.combine(contextConstraint).maskOut(this.nonInputMask)).getSpecificity() > 0) {
                this.inputContexts.add(inputCtx);
            }
            return 0;
        }
    }
}

