/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.model;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.Tool;
import docking.WindowPosition;
import docking.action.DockingAction;
import docking.action.ToggleDockingAction;
import docking.action.builder.ActionBuilder;
import docking.action.builder.ToggleActionBuilder;
import docking.widgets.table.RangeCursorTableHeaderRenderer;
import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.support.GTreeSelectionEvent;
import generic.theme.GColor;
import generic.theme.GIcon;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.gui.MultiProviderSaveBehavior;
import ghidra.app.plugin.core.debug.gui.control.TargetActionTask;
import ghidra.app.plugin.core.debug.gui.model.AbstractQueryTablePanel;
import ghidra.app.plugin.core.debug.gui.model.Adapters;
import ghidra.app.plugin.core.debug.gui.model.DebuggerModelPlugin;
import ghidra.app.plugin.core.debug.gui.model.ModelQuery;
import ghidra.app.plugin.core.debug.gui.model.ObjectDefaultActionsMixin;
import ghidra.app.plugin.core.debug.gui.model.ObjectTableModel;
import ghidra.app.plugin.core.debug.gui.model.ObjectTreeModel;
import ghidra.app.plugin.core.debug.gui.model.ObjectsTablePanel;
import ghidra.app.plugin.core.debug.gui.model.ObjectsTreePanel;
import ghidra.app.plugin.core.debug.gui.model.PathTableModel;
import ghidra.app.plugin.core.debug.gui.model.PathsTablePanel;
import ghidra.app.services.DebuggerListingService;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.debug.api.model.DebuggerObjectActionContext;
import ghidra.debug.api.target.ActionName;
import ghidra.debug.api.target.Target;
import ghidra.debug.api.tracemgr.DebuggerCoordinates;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.AutoConfigState;
import ghidra.framework.plugintool.AutoService;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.annotation.AutoConfigStateField;
import ghidra.framework.plugintool.annotation.AutoServiceConsumed;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.TraceObjectManager;
import ghidra.trace.model.target.TraceObjectValue;
import ghidra.trace.model.target.path.KeyPath;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.tree.TreePath;

public class DebuggerModelProvider
extends ComponentProvider
implements MultiProviderSaveBehavior.SaveableProvider {
    private static final GColor COLOR_BORDER_DISCONNECTED = new GColor("color.border.provider.disconnected");
    private static final AutoConfigState.ClassHandler<DebuggerModelProvider> CONFIG_STATE_HANDLER = AutoConfigState.wireHandler(DebuggerModelProvider.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final String KEY_DEBUGGER_COORDINATES = "DebuggerCoordinates";
    private static final String KEY_PATH = "Path";
    private final DebuggerModelPlugin plugin;
    private final boolean isClone;
    private JPanel mainPanel;
    protected MyTextField pathField;
    protected JButton goButton;
    protected JPanel queryPanel;
    protected ObjectsTreePanel objectsTreePanel;
    protected ObjectsTablePanel elementsTablePanel;
    protected PathsTablePanel attributesTablePanel;
    DebuggerCoordinates current = DebuggerCoordinates.NOWHERE;
    KeyPath path = KeyPath.of((String[])new String[0]);
    @AutoServiceConsumed
    protected DebuggerTraceManagerService traceManager;
    @AutoServiceConsumed
    protected DebuggerListingService listingService;
    private final AutoService.Wiring autoServiceWiring;
    @AutoConfigStateField
    private boolean showObjectsTree = true;
    @AutoConfigStateField
    private boolean showElementsTable = true;
    @AutoConfigStateField
    private boolean showAttributesTable = true;
    @AutoConfigStateField
    private double lrResizeWeight = 0.2;
    @AutoConfigStateField
    private double tbResizeWeight = 0.7;
    @AutoConfigStateField
    private boolean limitToSnap = true;
    @AutoConfigStateField
    private boolean showHidden = false;
    @AutoConfigStateField
    private boolean showPrimitivesInTree = false;
    @AutoConfigStateField
    private boolean showMethodsInTree = false;
    DockingAction actionCloneWindow;
    ToggleDockingAction actionShowObjectsTree;
    ToggleDockingAction actionShowElementsTable;
    ToggleDockingAction actionShowAttributesTable;
    ToggleDockingAction actionLimitToCurrentSnap;
    ToggleDockingAction actionShowHidden;
    ToggleDockingAction actionShowPrimitivesInTree;
    ToggleDockingAction actionShowMethodsInTree;
    DockingAction actionFollowLink;
    DebuggerObjectActionContext myActionContext;
    final ObjectsTreeListener objectsTreeListener = new ObjectsTreeListener();
    final ElementsTableListener elementsTableListener = new ElementsTableListener();
    final AttributesTableListener attributesTableListener = new AttributesTableListener();
    private final RangeCursorTableHeaderRenderer.SeekListener seekListener = pos -> {
        long max;
        long snap = Math.round(pos);
        if (snap < 0L) {
            snap = 0L;
        }
        long l = max = this.current.getTrace() == null ? 0L : this.current.getTrace().getTimeManager().getMaxSnap();
        if (snap > max) {
            snap = max;
        }
        this.traceManager.activateSnap(snap);
    };

    public DebuggerModelProvider(DebuggerModelPlugin plugin, boolean isClone) {
        super((Tool)plugin.getTool(), "Model", plugin.getName());
        this.autoServiceWiring = AutoService.wireServicesConsumed((Plugin)plugin, (Object)this);
        this.plugin = plugin;
        this.isClone = isClone;
        this.setIcon(DebuggerResources.ICON_PROVIDER_MODEL);
        this.setHelpLocation(DebuggerResources.HELP_PROVIDER_MODEL);
        this.setWindowMenuGroup("Debugger");
        this.buildMainPanel();
        this.setDefaultWindowPosition(WindowPosition.LEFT);
        this.createActions();
        if (isClone) {
            this.setTitle("[Model]");
            this.setWindowGroup("Debugger.Core.disconnected");
            this.setIntraGroupPosition(WindowPosition.STACK);
            this.mainPanel.setBorder(BorderFactory.createLineBorder((Color)COLOR_BORDER_DISCONNECTED, 2));
            this.setTransient();
        } else {
            this.setTitle("Model");
            this.setWindowGroup("Debugger.Core");
        }
        this.doSetLimitToCurrentSnap(this.limitToSnap);
        this.setVisible(true);
        this.contextChanged();
    }

    public void removeFromTool() {
        this.plugin.providerRemoved(this);
        super.removeFromTool();
    }

    protected static double computeResizeWeight(JSplitPane split) {
        Function<Dimension, Integer> axis = switch (split.getOrientation()) {
            case 1 -> dim -> dim.width;
            case 0 -> dim -> dim.height;
            default -> throw new AssertionError();
        };
        Component lComp = split.getLeftComponent();
        int lMin = axis.apply(lComp.getMinimumSize());
        int lSize = axis.apply(lComp.getSize());
        Component rComp = split.getRightComponent();
        int rMin = axis.apply(rComp.getMinimumSize());
        int rSize = axis.apply(rComp.getSize());
        int totalExtra = lSize + rSize - lMin - rMin;
        int lExtra = lSize - lMin;
        return (double)lExtra / (double)totalExtra;
    }

    protected JSplitPane createLrSplit() {
        JSplitPane split = new JSplitPane(1);
        split.setResizeWeight(this.lrResizeWeight);
        split.addPropertyChangeListener("dividerLocation", pce -> {
            this.lrResizeWeight = DebuggerModelProvider.computeResizeWeight(split);
        });
        return split;
    }

    protected JSplitPane createTbSplit() {
        JSplitPane split = new JSplitPane(0);
        split.setResizeWeight(this.tbResizeWeight);
        split.addPropertyChangeListener("dividerLocation", pce -> {
            this.tbResizeWeight = DebuggerModelProvider.computeResizeWeight(split);
        });
        return split;
    }

    protected JPanel createLabeledElementsTable() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add(this.elementsTablePanel);
        panel.add((Component)new JLabel("Elements"), "North");
        return panel;
    }

    protected JPanel createLabeledAttributesTable() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add(this.attributesTablePanel);
        panel.add((Component)new JLabel("Attributes"), "North");
        return panel;
    }

    protected void rebuildPanels() {
        if (this.mainPanel == null) {
            return;
        }
        this.mainPanel.removeAll();
        this.mainPanel.add((Component)this.queryPanel, "North");
        if (this.showObjectsTree && this.showElementsTable && this.showAttributesTable) {
            JSplitPane lrSplit = this.createLrSplit();
            this.mainPanel.add((Component)lrSplit, "Center");
            JSplitPane tbSplit = this.createTbSplit();
            lrSplit.setRightComponent(tbSplit);
            lrSplit.setLeftComponent(this.objectsTreePanel);
            tbSplit.setLeftComponent(this.createLabeledElementsTable());
            tbSplit.setRightComponent(this.createLabeledAttributesTable());
        } else if (this.showObjectsTree && this.showElementsTable) {
            JSplitPane lrSplit = this.createLrSplit();
            this.mainPanel.add((Component)lrSplit, "Center");
            lrSplit.setLeftComponent(this.objectsTreePanel);
            lrSplit.setRightComponent(this.elementsTablePanel);
        } else if (this.showObjectsTree && this.showAttributesTable) {
            JSplitPane lrSplit = this.createLrSplit();
            this.mainPanel.add((Component)lrSplit, "Center");
            lrSplit.setLeftComponent(this.objectsTreePanel);
            lrSplit.setRightComponent(this.attributesTablePanel);
        } else if (this.showElementsTable && this.showAttributesTable) {
            JSplitPane tbSplit = this.createTbSplit();
            tbSplit.setLeftComponent(this.createLabeledElementsTable());
            tbSplit.setRightComponent(this.createLabeledAttributesTable());
            this.mainPanel.add((Component)tbSplit, "Center");
        } else if (this.showObjectsTree) {
            this.mainPanel.add(this.objectsTreePanel);
        } else if (this.showElementsTable) {
            this.mainPanel.add(this.elementsTablePanel);
        } else if (this.showAttributesTable) {
            this.mainPanel.add(this.attributesTablePanel);
        } else {
            this.mainPanel.add(new JLabel("<html>Well, you should probably enable at least one panel.\nUse the local toolbar buttons."));
        }
        this.mainPanel.revalidate();
    }

    protected void activatePath(KeyPath path) {
        if (this.current.getTrace() == null) {
            return;
        }
        try {
            this.traceManager.activate(this.current.pathNonCanonical(path));
        }
        catch (IllegalArgumentException e) {
            this.plugin.getTool().setStatusInfo(e.getMessage(), true);
        }
    }

    protected void buildMainPanel() {
        this.mainPanel = new JPanel(new BorderLayout());
        this.pathField = new MyTextField();
        this.pathField.setInputVerifier(new InputVerifier(){

            @Override
            public boolean verify(JComponent input) {
                try {
                    KeyPath path = KeyPath.parse((String)DebuggerModelProvider.this.pathField.getText());
                    DebuggerModelProvider.this.setPath(path, null, GTreeSelectionEvent.EventOrigin.USER_GENERATED);
                    return true;
                }
                catch (IllegalArgumentException e) {
                    DebuggerModelProvider.this.plugin.getTool().setStatusInfo("Invalid Path: " + DebuggerModelProvider.this.pathField.getText(), true);
                    return false;
                }
            }
        });
        this.goButton = new JButton("Go");
        ActionListener gotoPath = evt -> {
            try {
                KeyPath path = KeyPath.parse((String)this.pathField.getText());
                this.activatePath(path);
                KeyboardFocusManager.getCurrentKeyboardFocusManager().clearGlobalFocusOwner();
            }
            catch (IllegalArgumentException e) {
                Msg.showError((Object)this, (Component)this.mainPanel, (String)"Model", (Object)("Invalid Query: " + this.pathField.getText()));
            }
        };
        this.goButton.addActionListener(gotoPath);
        this.pathField.addActionListener(gotoPath);
        this.pathField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    DebuggerModelProvider.this.pathField.setText(DebuggerModelProvider.this.path.toString());
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().clearGlobalFocusOwner();
                }
            }
        });
        this.objectsTreePanel = new ObjectsTreePanel();
        this.elementsTablePanel = new ObjectsTablePanel(this.plugin);
        this.attributesTablePanel = new PathsTablePanel(this.plugin);
        JSplitPane lrSplit = new JSplitPane(1);
        lrSplit.setResizeWeight(0.2);
        JSplitPane tbSplit = new JSplitPane(0);
        tbSplit.setResizeWeight(0.7);
        lrSplit.setRightComponent(tbSplit);
        this.queryPanel = new JPanel(new BorderLayout());
        this.queryPanel.add((Component)new JLabel("Path: "), "West");
        this.queryPanel.add((Component)this.pathField, "Center");
        this.queryPanel.add((Component)this.goButton, "East");
        this.objectsTreePanel.addTreeSelectionListener(this.objectsTreeListener::selectionChanged);
        this.objectsTreePanel.tree.tree().addFocusListener(this.objectsTreeListener);
        this.objectsTreePanel.tree.addTreeExpansionListener(this.objectsTreeListener);
        this.objectsTreePanel.tree.addMouseListener(this.objectsTreeListener);
        this.objectsTreePanel.tree.tree().addKeyListener(this.objectsTreeListener);
        this.elementsTablePanel.addSelectionListener(this.elementsTableListener::selectionChanged);
        this.elementsTablePanel.table.addFocusListener((FocusListener)this.elementsTableListener);
        this.elementsTablePanel.addCellActivationListener(this.elementsTableListener);
        this.elementsTablePanel.addSeekListener(this.seekListener);
        this.attributesTablePanel.addSelectionListener(this.attributesTableListener::selectionChanged);
        this.attributesTablePanel.table.addFocusListener((FocusListener)this.attributesTableListener);
        this.attributesTablePanel.addCellActivationListener(this.attributesTableListener);
        this.attributesTablePanel.addSeekListener(this.seekListener);
        this.rebuildPanels();
    }

    private TraceObjectValue getObject(TreePath path) {
        Object object = path.getLastPathComponent();
        if (object instanceof ObjectTreeModel.CanonicalNode) {
            ObjectTreeModel.CanonicalNode node = (ObjectTreeModel.CanonicalNode)((Object)object);
            return node.getValue();
        }
        object = path.getLastPathComponent();
        if (object instanceof ObjectTreeModel.RootNode) {
            ObjectTreeModel.RootNode node = (ObjectTreeModel.RootNode)((Object)object);
            return node.getValue();
        }
        return null;
    }

    private void refreshTargetChildren(TreePath path) {
        TraceObjectValue value = this.getObject(path);
        if (value == null) {
            return;
        }
        DebuggerCoordinates current = this.traceManager.getCurrentFor(value.getTrace());
        if (!current.isAliveAndPresent() && this.limitToSnap) {
            return;
        }
        Target target = current.getTarget();
        if (target == null) {
            return;
        }
        Target.ActionEntry ent = target.collectActions(ActionName.REFRESH, (ActionContext)new DebuggerObjectActionContext(List.of(value), (ComponentProvider)this, (Component)this.objectsTreePanel, current.getSnap()), Target.ObjectArgumentPolicy.CONTEXT_ONLY).values().stream().filter(e -> !e.requiresPrompt()).sorted(Comparator.comparing(e -> -e.specificity())).findFirst().orElse(null);
        if (ent == null) {
            return;
        }
        ObjectTreeModel.AbstractNode node = (ObjectTreeModel.AbstractNode)((Object)path.getLastPathComponent());
        ObjectTreeModel.PendingNode pending = new ObjectTreeModel.PendingNode();
        node.addNode(0, (GTreeNode)pending);
        CompletableFuture<Void> future = TargetActionTask.runAction(this.plugin.getTool(), ent.display(), ent);
        future.handle((__, ex) -> {
            node.removeNode((GTreeNode)pending);
            return null;
        });
    }

    public ActionContext getActionContext(MouseEvent event) {
        if (event != null) {
            if (event.getComponent() == this.objectsTreePanel.tree.tree()) {
                return this.objectsTreeListener.computeContext(true);
            }
            if (event.getComponent() == this.elementsTablePanel.table) {
                return this.elementsTableListener.computeContext(true);
            }
            if (event.getComponent() == this.attributesTablePanel.table) {
                return this.attributesTableListener.computeContext(true);
            }
        }
        if (this.myActionContext != null) {
            return this.myActionContext;
        }
        return super.getActionContext(event);
    }

    protected void createActions() {
        this.actionCloneWindow = (DockingAction)((ActionBuilder)((ActionBuilder)DebuggerResources.CloneWindowAction.builder(this.plugin).enabledWhen(c -> this.current.getTrace() != null)).onAction(c -> this.activatedCloneWindow())).buildAndInstallLocal((ComponentProvider)this);
        this.actionShowObjectsTree = (ToggleDockingAction)((ToggleActionBuilder)ShowObjectsTreeAction.builder(this.plugin).onAction(this::toggledShowObjectsTree)).selected(this.showObjectsTree).buildAndInstallLocal((ComponentProvider)this);
        this.actionShowElementsTable = (ToggleDockingAction)((ToggleActionBuilder)ShowElementsTableAction.builder(this.plugin).onAction(this::toggledShowElementsTable)).selected(this.showElementsTable).buildAndInstallLocal((ComponentProvider)this);
        this.actionShowAttributesTable = (ToggleDockingAction)((ToggleActionBuilder)ShowAttributesTableAction.builder(this.plugin).onAction(this::toggledShowAttributesTable)).selected(this.showAttributesTable).buildAndInstallLocal((ComponentProvider)this);
        this.actionLimitToCurrentSnap = (ToggleDockingAction)((ToggleActionBuilder)LimitToCurrentSnapAction.builder(this.plugin).onAction(this::toggledLimitToCurrentSnap)).buildAndInstallLocal((ComponentProvider)this);
        this.actionShowHidden = (ToggleDockingAction)((ToggleActionBuilder)ShowHiddenAction.builder(this.plugin).onAction(this::toggledShowHidden)).buildAndInstallLocal((ComponentProvider)this);
        this.actionShowPrimitivesInTree = (ToggleDockingAction)((ToggleActionBuilder)ShowPrimitivesInTreeAction.builder(this.plugin).onAction(this::toggledShowPrimitivesInTree)).buildAndInstallLocal((ComponentProvider)this);
        this.actionShowMethodsInTree = (ToggleDockingAction)((ToggleActionBuilder)ShowMethodsInTreeAction.builder(this.plugin).onAction(this::toggledShowMethodsInTree)).buildAndInstallLocal((ComponentProvider)this);
        this.actionFollowLink = (DockingAction)FollowLinkAction.builder(this.plugin).withContext(DebuggerObjectActionContext.class).enabledWhen(this::hasSingleLink).onAction(this::activatedFollowLink).buildAndInstallLocal((ComponentProvider)this);
    }

    private void activatedCloneWindow() {
        DebuggerModelProvider clone = this.plugin.createDisconnectedProvider();
        SaveState configState = new SaveState();
        this.writeConfigState(configState);
        clone.readConfigState(configState);
        SaveState dataState = new SaveState();
        this.writeDataState(dataState);
        Set<KeyPath> selection = this.objectsTreePanel.getSelectedKeyPaths();
        clone.coordinatesActivated(this.current);
        clone.readDataState(dataState);
        clone.objectsTreePanel.setSelectedKeyPaths(selection);
        this.plugin.getTool().showComponentProvider((ComponentProvider)clone, true);
    }

    private void toggledShowObjectsTree(ActionContext ctx) {
        this.setShowObjectsTree(this.actionShowObjectsTree.isSelected());
    }

    private void toggledShowElementsTable(ActionContext ctx) {
        this.setShowElementsTable(this.actionShowElementsTable.isSelected());
    }

    private void toggledShowAttributesTable(ActionContext ctx) {
        this.setShowAttributesTable(this.actionShowAttributesTable.isSelected());
    }

    private void toggledLimitToCurrentSnap(ActionContext ctx) {
        this.setLimitToCurrentSnap(this.actionLimitToCurrentSnap.isSelected());
    }

    private void toggledShowHidden(ActionContext ctx) {
        this.setShowHidden(this.actionShowHidden.isSelected());
    }

    private void toggledShowPrimitivesInTree(ActionContext ctx) {
        this.setShowPrimitivesInTree(this.actionShowPrimitivesInTree.isSelected());
    }

    private void toggledShowMethodsInTree(ActionContext ctx) {
        this.setShowMethodsInTree(this.actionShowMethodsInTree.isSelected());
    }

    private boolean hasSingleLink(DebuggerObjectActionContext ctx) {
        List values = ctx.getObjectValues();
        if (values.size() != 1) {
            return false;
        }
        TraceObjectValue val = (TraceObjectValue)values.get(0);
        return !val.isCanonical() && val.isObject();
    }

    private void activatedFollowLink(DebuggerObjectActionContext ctx) {
        List values = ctx.getObjectValues();
        if (values.size() != 1) {
            return;
        }
        KeyPath canonicalPath = ((TraceObjectValue)values.get(0)).getChild().getCanonicalPath();
        this.setPath(canonicalPath);
    }

    public JComponent getComponent() {
        return this.mainPanel;
    }

    protected KeyPath findAsSibling(TraceObject object) {
        Trace trace = this.current.getTrace();
        if (trace == null) {
            return null;
        }
        KeyPath parentPath = this.path.parent();
        if (parentPath == null) {
            return null;
        }
        TraceObject parent = trace.getObjectManager().getObjectByCanonicalPath(parentPath);
        if (parent == null) {
            return null;
        }
        for (TraceObjectValue value : parent.getValues((Lifespan)(this.isLimitToCurrentSnap() ? Lifespan.at((long)this.current.getSnap()) : Lifespan.ALL))) {
            if (!Objects.equals(object, value.getValue())) continue;
            return value.getCanonicalPath();
        }
        return null;
    }

    protected KeyPath findAsParent(TraceObject object) {
        Trace trace = this.current.getTrace();
        if (trace == null) {
            return null;
        }
        TraceObjectManager objectManager = trace.getObjectManager();
        if (objectManager.getRootObject() == null) {
            return null;
        }
        TraceObjectValue sel = this.getTreeSelection();
        if (sel == null) {
            return null;
        }
        for (KeyPath p = sel.getCanonicalPath(); p != null; p = p.parent()) {
            if (objectManager.getObjectByCanonicalPath(p) != object) continue;
            return p;
        }
        return null;
    }

    public void coordinatesActivated(DebuggerCoordinates coords) {
        this.current = coords;
        this.objectsTreePanel.goToCoordinates(coords);
        this.elementsTablePanel.goToCoordinates(coords);
        this.attributesTablePanel.goToCoordinates(coords);
        if (this.isClone) {
            return;
        }
        TraceObject object = coords.getObject();
        if (object == null) {
            return;
        }
        if (this.attributesTablePanel.trySelect(object)) {
            return;
        }
        if (this.elementsTablePanel.trySelect(object)) {
            return;
        }
        if (this.findAsParent(object) != null) {
            return;
        }
        KeyPath sibling = this.findAsSibling(object);
        if (sibling != null) {
            this.objectsTreePanel.setSelectedKeyPaths(List.of(sibling));
            this.setPath(sibling);
        } else {
            this.objectsTreePanel.setSelectedObject(object);
            this.setPath(object.getCanonicalPath());
        }
    }

    public void traceClosed(Trace trace) {
        if (this.current.getTrace() == trace) {
            this.coordinatesActivated(DebuggerCoordinates.NOWHERE);
        }
    }

    protected void setPath(KeyPath path, JComponent source, GTreeSelectionEvent.EventOrigin origin) {
        if (Objects.equals(this.path, path) && this.getTreeSelection() != null) {
            return;
        }
        this.path = path;
        if (source != this.objectsTreePanel) {
            this.setTreeSelection(path, origin);
        }
        this.pathField.setText(path.toString());
        this.objectsTreePanel.repaint();
        this.elementsTablePanel.setQuery(ModelQuery.elementsOf(path));
        this.attributesTablePanel.setQuery(ModelQuery.attributesOf(path));
    }

    public void setPath(KeyPath path) {
        this.setPath(path, null, GTreeSelectionEvent.EventOrigin.API_GENERATED);
    }

    public KeyPath getPath() {
        return this.path;
    }

    protected void doSetShowObjectsTree(boolean showObjectsTree) {
        this.showObjectsTree = showObjectsTree;
        this.actionShowObjectsTree.setSelected(showObjectsTree);
        this.rebuildPanels();
    }

    protected void doSetShowElementsTable(boolean showElementsTable) {
        this.showElementsTable = showElementsTable;
        this.actionShowElementsTable.setSelected(showElementsTable);
        this.rebuildPanels();
    }

    protected void doSetShowAttributesTable(boolean showAttributesTable) {
        this.showAttributesTable = showAttributesTable;
        this.actionShowAttributesTable.setSelected(showAttributesTable);
        this.rebuildPanels();
    }

    public void setShowObjectsTree(boolean showObjectsTree) {
        if (this.showObjectsTree == showObjectsTree) {
            return;
        }
        this.doSetShowObjectsTree(showObjectsTree);
    }

    public void setShowElementsTable(boolean showElementsTable) {
        if (this.showElementsTable == showElementsTable) {
            return;
        }
        this.doSetShowElementsTable(showElementsTable);
    }

    public void setShowAttributesTable(boolean showAttributesTable) {
        if (this.showAttributesTable == showAttributesTable) {
            return;
        }
        this.doSetShowAttributesTable(showAttributesTable);
    }

    protected void doSetLimitToCurrentSnap(boolean limitToSnap) {
        this.limitToSnap = limitToSnap;
        this.actionLimitToCurrentSnap.setSelected(limitToSnap);
        this.objectsTreePanel.setLimitToSnap(limitToSnap);
        this.elementsTablePanel.setLimitToSnap(limitToSnap);
        this.attributesTablePanel.setLimitToSnap(limitToSnap);
    }

    public void setLimitToCurrentSnap(boolean limitToSnap) {
        if (this.limitToSnap == limitToSnap) {
            return;
        }
        this.doSetLimitToCurrentSnap(limitToSnap);
    }

    public boolean isLimitToCurrentSnap() {
        return this.limitToSnap;
    }

    protected void doSetShowHidden(boolean showHidden) {
        this.showHidden = showHidden;
        this.actionShowHidden.setSelected(showHidden);
        this.objectsTreePanel.setShowHidden(showHidden);
        this.elementsTablePanel.setShowHidden(showHidden);
        this.attributesTablePanel.setShowHidden(showHidden);
    }

    public void setShowHidden(boolean showHidden) {
        if (this.showHidden == showHidden) {
            return;
        }
        this.doSetShowHidden(showHidden);
    }

    public boolean isShowHidden() {
        return this.showHidden;
    }

    protected void doSetShowPrimitivesInTree(boolean showPrimitivesInTree) {
        this.showPrimitivesInTree = showPrimitivesInTree;
        this.actionShowPrimitivesInTree.setSelected(showPrimitivesInTree);
        this.objectsTreePanel.setShowPrimitives(showPrimitivesInTree);
    }

    public void setShowPrimitivesInTree(boolean showPrimitivesInTree) {
        if (this.showPrimitivesInTree == showPrimitivesInTree) {
            return;
        }
        this.doSetShowPrimitivesInTree(showPrimitivesInTree);
    }

    public boolean isShowPrimitivesInTree() {
        return this.showPrimitivesInTree;
    }

    protected void doSetShowMethodsInTree(boolean showMethodsInTree) {
        this.showMethodsInTree = showMethodsInTree;
        this.actionShowMethodsInTree.setSelected(showMethodsInTree);
        this.objectsTreePanel.setShowMethods(showMethodsInTree);
    }

    public void setShowMethodsInTree(boolean showMethodsInTree) {
        if (this.showMethodsInTree == showMethodsInTree) {
            return;
        }
        this.doSetShowMethodsInTree(showMethodsInTree);
    }

    public boolean isShowMethodsInTree() {
        return this.showMethodsInTree;
    }

    protected void setTreeSelection(KeyPath path, GTreeSelectionEvent.EventOrigin origin) {
        this.objectsTreePanel.setSelectedKeyPaths(List.of(path), origin);
    }

    protected void setTreeSelection(KeyPath path) {
        this.setTreeSelection(path, GTreeSelectionEvent.EventOrigin.API_GENERATED);
    }

    protected TraceObjectValue getTreeSelection() {
        ObjectTreeModel.AbstractNode sel = this.objectsTreePanel.getSelectedItem();
        return sel == null ? null : sel.getValue();
    }

    @Override
    public void writeConfigState(SaveState saveState) {
        CONFIG_STATE_HANDLER.writeConfigState((Object)this, saveState);
    }

    @Override
    public void readConfigState(SaveState saveState) {
        CONFIG_STATE_HANDLER.readConfigState((Object)this, saveState);
        this.actionShowObjectsTree.setSelected(this.showObjectsTree);
        this.actionShowElementsTable.setSelected(this.showElementsTable);
        this.actionShowAttributesTable.setSelected(this.showAttributesTable);
        this.rebuildPanels();
        this.doSetLimitToCurrentSnap(this.limitToSnap);
        this.doSetShowHidden(this.showHidden);
        this.doSetShowPrimitivesInTree(this.showPrimitivesInTree);
        this.doSetShowMethodsInTree(this.showMethodsInTree);
    }

    @Override
    public void writeDataState(SaveState saveState) {
        if (this.isClone) {
            this.current.writeDataState(this.plugin.getTool(), saveState, KEY_DEBUGGER_COORDINATES);
        }
        saveState.putString(KEY_PATH, this.path.toString());
    }

    @Override
    public void readDataState(SaveState saveState) {
        DebuggerCoordinates coords;
        if (this.isClone && (coords = DebuggerCoordinates.readDataState((PluginTool)this.plugin.getTool(), (SaveState)saveState, (String)KEY_DEBUGGER_COORDINATES)) != DebuggerCoordinates.NOWHERE) {
            this.coordinatesActivated(coords);
        }
        this.setPath(KeyPath.parse((String)saveState.getString(KEY_PATH, "")));
    }

    protected class ObjectsTreeListener
    extends MyMixin
    implements Adapters.FocusListener,
    Adapters.TreeExpansionListener,
    Adapters.MouseListener,
    Adapters.KeyListener {
        protected ObjectsTreeListener() {
        }

        private void activateObjectSelectedInTree() {
            List<ObjectTreeModel.AbstractNode> sel = DebuggerModelProvider.this.objectsTreePanel.getSelectedItems();
            if (sel.size() != 1) {
                return;
            }
            TraceObjectValue value = sel.get(0).getValue();
            this.performDefaultAction(value);
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                this.activateObjectSelectedInTree();
                e.consume();
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2 && e.getButton() == 1) {
                this.activateObjectSelectedInTree();
                e.consume();
            }
        }

        @Override
        public void treeExpanded(TreeExpansionEvent event) {
            InputEvent inputEvent;
            AWTEvent aWTEvent = EventQueue.getCurrentEvent();
            if (aWTEvent instanceof InputEvent && !(inputEvent = (InputEvent)aWTEvent).isShiftDown()) {
                DebuggerModelProvider.this.refreshTargetChildren(event.getPath());
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
            this.setContextFromSelection();
        }

        public void selectionChanged(GTreeSelectionEvent evt) {
            this.setContextFromSelection();
            List<ObjectTreeModel.AbstractNode> sel = DebuggerModelProvider.this.objectsTreePanel.getSelectedItems();
            if (sel.size() == 1) {
                TraceObjectValue value = sel.get(0).getValue();
                DebuggerModelProvider.this.setPath(value == null ? KeyPath.of((String[])new String[0]) : value.getCanonicalPath(), DebuggerModelProvider.this.objectsTreePanel, GTreeSelectionEvent.EventOrigin.INTERNAL_GENERATED);
            }
        }

        private void setContextFromSelection() {
            DebuggerModelProvider.this.myActionContext = this.computeContext(false);
            DebuggerModelProvider.this.contextChanged();
        }

        DebuggerObjectActionContext computeContext(boolean ignoreFocus) {
            if (!DebuggerModelProvider.this.objectsTreePanel.tree.tree().isFocusOwner() && !ignoreFocus) {
                return null;
            }
            Trace trace = DebuggerModelProvider.this.current.getTrace();
            if (trace == null) {
                return null;
            }
            if (trace.getObjectManager().getRootObject() == null) {
                return null;
            }
            List<ObjectTreeModel.AbstractNode> sel = DebuggerModelProvider.this.objectsTreePanel.getSelectedItems();
            if (sel.isEmpty()) {
                return null;
            }
            return new DebuggerObjectActionContext((Collection)sel.stream().map(n -> n.getValue()).filter(o -> o != null).collect(Collectors.toList()), (ComponentProvider)DebuggerModelProvider.this, (Component)DebuggerModelProvider.this.objectsTreePanel, DebuggerModelProvider.this.current.getSnap());
        }
    }

    protected class ElementsTableListener
    extends MyMixin
    implements Adapters.FocusListener,
    AbstractQueryTablePanel.CellActivationListener {
        protected ElementsTableListener() {
        }

        @Override
        public void cellActivated(JTable table) {
            if (this.performElementCellDefaultAction(table)) {
                return;
            }
            ObjectTableModel.ValueRow sel = (ObjectTableModel.ValueRow)DebuggerModelProvider.this.elementsTablePanel.getSelectedItem();
            if (this.performValueRowDefaultAction(sel)) {
                return;
            }
            if (sel == null) {
                return;
            }
            DebuggerModelProvider.this.setPath(sel.currentObject().getCanonicalPath(), table, GTreeSelectionEvent.EventOrigin.USER_GENERATED);
        }

        @Override
        public void focusGained(FocusEvent e) {
            this.setContextFromSelection();
        }

        public void selectionChanged(ListSelectionEvent evt) {
            if (evt.getValueIsAdjusting()) {
                return;
            }
            this.setContextFromSelection();
            List sel = DebuggerModelProvider.this.elementsTablePanel.getSelectedItems();
            if (sel.size() != 1) {
                DebuggerModelProvider.this.attributesTablePanel.setQuery(ModelQuery.attributesOf(DebuggerModelProvider.this.path));
                return;
            }
            TraceObjectValue value = ((ObjectTableModel.ValueRow)sel.get(0)).getValue();
            if (!value.isObject()) {
                return;
            }
            TraceObject object = value.getChild();
            DebuggerModelProvider.this.attributesTablePanel.setQuery(ModelQuery.attributesOf(object.getCanonicalPath()));
        }

        private void setContextFromSelection() {
            DebuggerModelProvider.this.myActionContext = this.computeContext(false);
            DebuggerModelProvider.this.contextChanged();
        }

        DebuggerObjectActionContext computeContext(boolean ignoreFocus) {
            if (!DebuggerModelProvider.this.elementsTablePanel.table.isFocusOwner() && !ignoreFocus) {
                return null;
            }
            Trace trace = DebuggerModelProvider.this.current.getTrace();
            if (trace == null) {
                return null;
            }
            if (trace.getObjectManager().getRootObject() == null) {
                return null;
            }
            List sel = DebuggerModelProvider.this.elementsTablePanel.getSelectedItems();
            if (sel.isEmpty()) {
                return null;
            }
            return new DebuggerObjectActionContext((Collection)sel.stream().map(r -> r.getValue()).collect(Collectors.toList()), (ComponentProvider)DebuggerModelProvider.this, (Component)DebuggerModelProvider.this.elementsTablePanel, DebuggerModelProvider.this.current.getSnap());
        }
    }

    protected class AttributesTableListener
    extends MyMixin
    implements Adapters.FocusListener,
    AbstractQueryTablePanel.CellActivationListener {
        protected AttributesTableListener() {
        }

        @Override
        public void cellActivated(JTable table) {
            Object object;
            PathTableModel.PathRow sel = (PathTableModel.PathRow)DebuggerModelProvider.this.attributesTablePanel.getSelectedItem();
            if (this.performPathRowDefaultAction(sel)) {
                return;
            }
            if (sel == null || !((object = sel.getValue()) instanceof TraceObject)) {
                return;
            }
            TraceObject obj = (TraceObject)object;
            DebuggerModelProvider.this.setPath(obj.getCanonicalPath(), table, GTreeSelectionEvent.EventOrigin.USER_GENERATED);
        }

        @Override
        public void focusGained(FocusEvent e) {
            this.setContextFromSelection();
        }

        public void selectionChanged(ListSelectionEvent evt) {
            if (evt.getValueIsAdjusting()) {
                return;
            }
            this.setContextFromSelection();
        }

        private void setContextFromSelection() {
            DebuggerModelProvider.this.myActionContext = this.computeContext(false);
            DebuggerModelProvider.this.contextChanged();
        }

        DebuggerObjectActionContext computeContext(boolean ignoreFocus) {
            if (!DebuggerModelProvider.this.attributesTablePanel.table.isFocusOwner() && !ignoreFocus) {
                return null;
            }
            Trace trace = DebuggerModelProvider.this.current.getTrace();
            if (trace == null) {
                return null;
            }
            if (trace.getObjectManager().getRootObject() == null) {
                return null;
            }
            List sel = DebuggerModelProvider.this.attributesTablePanel.getSelectedItems();
            if (sel.isEmpty()) {
                return null;
            }
            return new DebuggerObjectActionContext((Collection)sel.stream().map(r -> Objects.requireNonNull(r.getPath().getLastEntry())).collect(Collectors.toList()), (ComponentProvider)DebuggerModelProvider.this, (Component)DebuggerModelProvider.this.attributesTablePanel, DebuggerModelProvider.this.current.getSnap());
        }
    }

    static class MyTextField
    extends JTextField {
        MyTextField() {
        }

        @Override
        protected void processEvent(AWTEvent e) {
            super.processEvent(e);
        }
    }

    static interface ShowObjectsTreeAction {
        public static final String NAME = "Show Objects Tree";
        public static final Icon ICON = new GIcon("icon.debugger.model.tree.objects");
        public static final String DESCRIPTION = "Toggle display of the Objects Tree pane";
        public static final String GROUP = "Dbg3. Views";
        public static final String ORDER = "1";
        public static final String HELP_ANCHOR = "show_objects_tree";

        public static ToggleActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)new ToggleActionBuilder(NAME, ownerName).description(DESCRIPTION)).toolBarIcon(ICON)).toolBarGroup(GROUP, ORDER)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    static interface ShowElementsTableAction {
        public static final String NAME = "Show Elements Table";
        public static final Icon ICON = new GIcon("icon.debugger.model.table.elements");
        public static final String DESCRIPTION = "Toggle display of the Elements Table pane";
        public static final String GROUP = "Dbg3. Views";
        public static final String ORDER = "2";
        public static final String HELP_ANCHOR = "show_elements_table";

        public static ToggleActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)new ToggleActionBuilder(NAME, ownerName).description(DESCRIPTION)).toolBarIcon(ICON)).toolBarGroup(GROUP, ORDER)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    static interface ShowAttributesTableAction {
        public static final String NAME = "Show Attributes Table";
        public static final Icon ICON = new GIcon("icon.debugger.model.table.attributes");
        public static final String DESCRIPTION = "Toggle display of the Attributes Table pane";
        public static final String GROUP = "Dbg3. Views";
        public static final String ORDER = "3";
        public static final String HELP_ANCHOR = "show_attributes_table";

        public static ToggleActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)new ToggleActionBuilder(NAME, ownerName).description(DESCRIPTION)).toolBarIcon(ICON)).toolBarGroup(GROUP, ORDER)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    static interface LimitToCurrentSnapAction {
        public static final String NAME = "Limit to Current Snap";
        public static final String DESCRIPTION = "Choose whether displayed objects must be alive at the current snap";
        public static final String GROUP = "Dbg1. General";
        public static final String HELP_ANCHOR = "limit_to_current_snap";

        public static ToggleActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)new ToggleActionBuilder(NAME, ownerName).description(DESCRIPTION)).menuPath(new String[]{NAME})).menuGroup(GROUP)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    static interface ShowHiddenAction {
        public static final String NAME = "Show Hidden";
        public static final String DESCRIPTION = "Choose whether to display hidden children";
        public static final String GROUP = "Dbg1. General";
        public static final String HELP_ANCHOR = "show_hidden";

        public static ToggleActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)new ToggleActionBuilder(NAME, ownerName).description(DESCRIPTION)).menuPath(new String[]{NAME})).menuGroup(GROUP)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    static interface ShowPrimitivesInTreeAction {
        public static final String NAME = "Show Primitives in Tree";
        public static final String DESCRIPTION = "Choose whether to display primitive values in the tree";
        public static final String GROUP = "Dbg1. General";
        public static final String HELP_ANCHOR = "show_primitives";

        public static ToggleActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)new ToggleActionBuilder(NAME, ownerName).description(DESCRIPTION)).menuPath(new String[]{NAME})).menuGroup(GROUP)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    static interface ShowMethodsInTreeAction {
        public static final String NAME = "Show Methods in Tree";
        public static final String DESCRIPTION = "Choose whether to display methods in the tree";
        public static final String GROUP = "Dbg1. General";
        public static final String HELP_ANCHOR = "show_methods";

        public static ToggleActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)new ToggleActionBuilder(NAME, ownerName).description(DESCRIPTION)).menuPath(new String[]{NAME})).menuGroup(GROUP)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    static interface FollowLinkAction {
        public static final String NAME = "Follow Link";
        public static final String DESCRIPTION = "Navigate to the link target";
        public static final String GROUP = "Dbg1. General";
        public static final String HELP_ANCHOR = "follow_link";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).popupMenuPath(new String[]{NAME})).popupMenuGroup(GROUP)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    protected class MyMixin
    implements ObjectDefaultActionsMixin {
        protected MyMixin() {
        }

        @Override
        public DebuggerCoordinates getCurrent() {
            return DebuggerModelProvider.this.current;
        }

        @Override
        public PluginTool getTool() {
            return DebuggerModelProvider.this.plugin.getTool();
        }

        @Override
        public void activatePath(KeyPath path) {
            DebuggerModelProvider.this.activatePath(path);
        }
    }
}

