/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import ghidra.app.util.MemoryBlockUtils;
import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.format.som.SomDltEntry;
import ghidra.app.util.bin.format.som.SomDynamicLoaderHeader;
import ghidra.app.util.bin.format.som.SomExecAuxHeader;
import ghidra.app.util.bin.format.som.SomExportEntry;
import ghidra.app.util.bin.format.som.SomHeader;
import ghidra.app.util.bin.format.som.SomImportEntry;
import ghidra.app.util.bin.format.som.SomPltEntry;
import ghidra.app.util.bin.format.som.SomShlibListEntry;
import ghidra.app.util.bin.format.som.SomSpace;
import ghidra.app.util.bin.format.som.SomSubspace;
import ghidra.app.util.bin.format.som.SomSymbol;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.opinion.AbstractProgramLoader;
import ghidra.app.util.opinion.AbstractProgramWrapperLoader;
import ghidra.app.util.opinion.LoadSpec;
import ghidra.app.util.opinion.Loader;
import ghidra.app.util.opinion.QueryOpinionService;
import ghidra.app.util.opinion.QueryResult;
import ghidra.program.database.mem.FileBytes;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.model.symbol.ExternalManager;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SomLoader
extends AbstractProgramWrapperLoader {
    public static final String SOM_NAME = "System Object Model (SOM)";

    @Override
    public Collection<LoadSpec> findSupportedLoadSpecs(ByteProvider provider) throws IOException {
        ArrayList<LoadSpec> loadSpecs = new ArrayList<LoadSpec>();
        if (provider.length() < 128L) {
            return loadSpecs;
        }
        try {
            SomHeader header = new SomHeader(new BinaryReader(provider, false));
            if (header.hasValidMagic() && header.hasValidVersionId()) {
                List<QueryResult> results = QueryOpinionService.query(this.getName(), Integer.toString(header.getSystemId()), null);
                for (QueryResult result : results) {
                    loadSpecs.add(new LoadSpec((Loader)this, 0L, result));
                }
                if (loadSpecs.isEmpty()) {
                    loadSpecs.add(new LoadSpec((Loader)this, 0L, true));
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return loadSpecs;
    }

    @Override
    protected void load(Program program, Loader.ImporterSettings settings) throws IOException, CancelledException {
        MessageLog log = settings.log();
        TaskMonitor monitor = settings.monitor();
        FileBytes fileBytes = MemoryBlockUtils.createFileBytes(program, settings.provider(), monitor);
        BinaryReader reader = new BinaryReader(settings.provider(), false);
        try {
            SomHeader header = new SomHeader(reader);
            this.processMemoryBlocks(program, fileBytes, header, log, monitor);
            SomDynamicLoaderHeader dlHeader = new SomDynamicLoaderHeader(program, header.getTextAddress(program), header.getDataAddress(program));
            this.processEntryPoint(program, header, log, monitor);
            this.processSymbols(program, header, log, monitor);
            this.processImports(program, dlHeader, log, monitor);
            this.processExports(program, dlHeader, log, monitor);
            this.processLibraries(program, dlHeader, log, monitor);
            this.markupHeaders(program, fileBytes, header, dlHeader, log, monitor);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private void processMemoryBlocks(Program program, FileBytes fileBytes, SomHeader header, MessageLog log, TaskMonitor monitor) throws Exception {
        monitor.setMessage("Processing memory blocks...");
        AddressSpace addrSpace = program.getAddressFactory().getDefaultAddressSpace();
        List<SomSpace> spaces = header.getSpaces();
        List<SomSubspace> subspaces = header.getSubspaces();
        for (SomSubspace subspace : subspaces) {
            Address addr;
            SomSpace space = spaces.get(subspace.getSpaceIndex());
            long initSize = subspace.getInitializationLength();
            long size = subspace.getSubspaceLength();
            if (size == 0L) continue;
            Address address = addr = subspace.isLoadable() ? addrSpace.getAddress(subspace.getSubspaceStart()) : AddressSpace.OTHER_SPACE.getAddress(subspace.getSubspaceStart());
            if (initSize > 0L) {
                MemoryBlockUtils.createInitializedBlock(program, !subspace.isLoadable(), subspace.getName(), addr, fileBytes, (long)subspace.getFileLocInitValue(), initSize, "", space.getName(), subspace.isRead(), subspace.isWrite(), subspace.isExecute(), log);
                addr = addr.add(initSize);
            }
            if (size <= initSize) continue;
            MemoryBlockUtils.createUninitializedBlock(program, !subspace.isLoadable(), subspace.getName(), addr, size - initSize, "", space.getName(), subspace.isRead(), subspace.isWrite(), subspace.isExecute(), log);
        }
    }

    private void processEntryPoint(Program program, SomHeader header, MessageLog log, TaskMonitor monitor) throws Exception {
        long execEntry;
        monitor.setMessage("Processing entry point...");
        SymbolTable symbolTable = program.getSymbolTable();
        AddressSpace addrSpace = program.getAddressFactory().getDefaultAddressSpace();
        SomSpace space = header.getSpaces().get((int)header.getEntrySpace());
        SomSubspace subspace = header.getSubspaces().get((int)((long)space.getSubspaceIndex() + header.getEntrySubspace()));
        Address subspaceAddr = addrSpace.getAddress(subspace.getSubspaceStart());
        long entryOffset = 0L;
        SomExecAuxHeader execHeader = header.getFirstAuxHeader(SomExecAuxHeader.class);
        if (execHeader != null && (execEntry = execHeader.getExecEntry()) != 0L) {
            entryOffset = execEntry;
        }
        if (entryOffset == 0L) {
            entryOffset = header.getEntryOffset();
        }
        if (entryOffset != 0L) {
            Address addr = subspaceAddr.add(entryOffset);
            addr = addrSpace.getAddress(entryOffset);
            AbstractProgramLoader.markAsFunction(program, "entry", addr);
            symbolTable.addExternalEntryPoint(addr);
        }
    }

    private void processSymbols(Program program, SomHeader header, MessageLog log, TaskMonitor monitor) throws Exception {
        SymbolTable symbolTable = program.getSymbolTable();
        AddressSpace addrSpace = program.getAddressFactory().getDefaultAddressSpace();
        List<SomSymbol> somSymbols = header.getSymbols();
        monitor.initialize((long)somSymbols.size(), "Processing symbols...");
        for (SomSymbol somSymbol : somSymbols) {
            monitor.increment();
            if (somSymbol.getSymbolScope() == 0) continue;
            Address addr = addrSpace.getAddress(somSymbol.getSymbolValue());
            String name = SymbolUtilities.replaceInvalidChars((String)somSymbol.getName(), (boolean)true);
            switch (somSymbol.getSymbolType()) {
                case 3: 
                case 6: 
                case 12: {
                    addr = addr.getNewAddress(addr.getOffset() & 0xFFFFFFFFFFFFFFFCL);
                }
            }
            switch (somSymbol.getSymbolType()) {
                case 2: 
                case 3: 
                case 6: 
                case 8: 
                case 12: {
                    symbolTable.createLabel(addr, name, SourceType.IMPORTED);
                }
            }
            switch (somSymbol.getSymbolType()) {
                case 6: 
                case 12: {
                    AbstractProgramLoader.markAsFunction(program, name, addr);
                }
            }
        }
    }

    private void processImports(Program program, SomDynamicLoaderHeader dlHeader, MessageLog log, TaskMonitor monitor) throws Exception {
        SomImportEntry importEntry;
        int importCounter = 0;
        List<SomImportEntry> imports = dlHeader.getImports();
        List<SomDltEntry> dlt = dlHeader.getDlt();
        List<SomPltEntry> plt = dlHeader.getPlt();
        SymbolTable symbolTable = program.getSymbolTable();
        FunctionManager functionMgr = program.getFunctionManager();
        ExternalManager extMgr = program.getExternalManager();
        Address dataAddr = dlHeader.getDataAddress();
        monitor.initialize((long)dlt.size(), "Processing DLT imports...");
        int i = 0;
        while (i < dlt.size()) {
            monitor.increment();
            importEntry = imports.get(importCounter);
            String importName = importEntry.getName();
            if (importName != null) {
                SomDltEntry dltEntry = dlt.get(i);
                Address target = dataAddr.getNewAddress((long)dltEntry.getValue());
                symbolTable.createLabel(target, importName, SourceType.IMPORTED);
                extMgr.addExtLocation("<EXTERNAL>", importName, null, SourceType.IMPORTED);
            }
            ++i;
            ++importCounter;
        }
        monitor.initialize((long)plt.size(), "Processing PLT imports...");
        i = 0;
        while (i < plt.size()) {
            monitor.increment();
            importEntry = imports.get(importCounter);
            SomPltEntry pltEntry = plt.get(i);
            Address target = dataAddr.getNewAddress((long)pltEntry.getProcAddr());
            String name = importEntry.getName();
            Function stubFunc = functionMgr.getFunctionAt(target);
            if (stubFunc == null) {
                stubFunc = functionMgr.createFunction(name, target, (AddressSetView)new AddressSet(target), SourceType.IMPORTED);
            }
            ExternalLocation loc = extMgr.addExtLocation("<EXTERNAL>", name, null, SourceType.IMPORTED);
            stubFunc.setThunkedFunction(loc.createFunction());
            ++i;
            ++importCounter;
        }
    }

    private void processExports(Program program, SomDynamicLoaderHeader dlHeader, MessageLog log, TaskMonitor monitor) throws Exception {
        SymbolTable symbolTable = program.getSymbolTable();
        AddressSpace addrSpace = program.getAddressFactory().getDefaultAddressSpace();
        List<SomExportEntry> exports = dlHeader.getExports();
        monitor.initialize((long)exports.size(), "Processing exports...");
        for (SomExportEntry export : dlHeader.getExports()) {
            String name = export.getName();
            if (name == null) continue;
            Address addr = addrSpace.getAddress((long)export.getValue());
            SymbolIterator iter = symbolTable.getSymbols(name);
            if (!iter.hasNext()) {
                symbolTable.createLabel(addr, name, SourceType.IMPORTED);
                symbolTable.addExternalEntryPoint(addr);
                continue;
            }
            for (Symbol symbol : iter) {
                if (symbol.getAddress().getOffset() != (long)export.getValue()) continue;
                symbolTable.addExternalEntryPoint(addr);
            }
        }
    }

    private void processLibraries(Program program, SomDynamicLoaderHeader dlHeader, MessageLog log, TaskMonitor monitor) throws Exception {
        monitor.initialize((long)dlHeader.getShlibListCount(), "Processing libraries...");
        for (SomShlibListEntry entry : dlHeader.getShlibs()) {
            String name = SymbolUtilities.replaceInvalidChars((String)entry.getShlibName(), (boolean)true);
            try {
                program.getExternalManager().addExternalLibraryName(name, SourceType.IMPORTED);
            }
            catch (DuplicateNameException duplicateNameException) {
            }
            catch (Exception e) {
                log.appendMsg("Unable to add external library name: " + e.getMessage());
            }
        }
    }

    private void markupHeaders(Program program, FileBytes fileBytes, SomHeader header, SomDynamicLoaderHeader dlHeader, MessageLog log, TaskMonitor monitor) {
        monitor.setMessage("Marking up headers...");
        Address headerSpaceAddr = AddressSpace.OTHER_SPACE.getAddress(0L);
        try {
            MemoryBlock headerBlock = MemoryBlockUtils.createInitializedBlock(program, true, "FILE", headerSpaceAddr, fileBytes, 0L, fileBytes.getSize(), "", "", false, false, false, log);
            header.markup(program, headerBlock.getStart(), monitor);
        }
        catch (Exception e) {
            log.appendMsg("Failed to markup headers: " + e.getMessage());
        }
        try {
            dlHeader.markup(program, monitor);
        }
        catch (Exception e) {
            log.appendMsg("Failed to markup dynamic loader headers: " + e.getMessage());
        }
    }

    @Override
    public String getName() {
        return SOM_NAME;
    }
}

