/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.ne;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.ne.ResourceName;
import ghidra.app.util.bin.format.ne.ResourceType;
import java.io.IOException;
import java.util.ArrayList;

public class ResourceTable {
    private short index;
    private short alignmentShiftCount;
    private ResourceType[] types;
    private ResourceName[] names;

    ResourceTable(BinaryReader reader, short index) throws IOException {
        ResourceName rn;
        ResourceType rt;
        this.index = index;
        long oldIndex = reader.getPointerIndex();
        reader.setPointerIndex(Short.toUnsignedInt(index));
        this.alignmentShiftCount = reader.readNextShort();
        ArrayList<ResourceType> typeList = new ArrayList<ResourceType>();
        while ((rt = new ResourceType(reader, this)).getTypeID() != 0) {
            typeList.add(rt);
        }
        this.types = new ResourceType[typeList.size()];
        typeList.toArray(this.types);
        ArrayList<ResourceName> nameList = new ArrayList<ResourceName>();
        while ((rn = new ResourceName(reader)).getLength() != 0) {
            nameList.add(rn);
        }
        this.names = new ResourceName[nameList.size()];
        nameList.toArray(this.names);
        reader.setPointerIndex(oldIndex);
    }

    public short getAlignmentShiftCount() {
        return this.alignmentShiftCount;
    }

    public ResourceType[] getResourceTypes() {
        return this.types;
    }

    public ResourceName[] getResourceNames() {
        return this.names;
    }

    public short getIndex() {
        return this.index;
    }
}

