/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.merge.datatypes;

import generic.theme.GAttributes;
import generic.theme.GThemeDefaults;
import generic.theme.Gui;
import ghidra.program.model.data.ArchiveType;
import ghidra.program.model.data.SourceArchive;
import ghidra.util.Msg;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.Date;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyledDocument;

class SourceArchivePanel
extends JPanel {
    private SourceArchive sourceArchive;
    private JTextPane textPane;
    private StyledDocument doc;
    private SimpleAttributeSet headingAttrs;
    private SimpleAttributeSet valueAttrs;
    private SimpleAttributeSet deletedAttrs;

    SourceArchivePanel() {
        super(new BorderLayout());
        this.create();
    }

    public void setSourceArchive(SourceArchive sourceArchive) {
        this.sourceArchive = sourceArchive;
        this.textPane.setText("");
        this.formatSourceArchive();
        this.textPane.setCaretPosition(0);
    }

    private void create() {
        this.textPane = new JTextPane();
        this.doc = this.textPane.getStyledDocument();
        this.add((Component)this.textPane, "Center");
        this.textPane.setEditable(false);
        Font monospaced = Gui.getFont((String)"font.monospaced");
        Font bold = Gui.getFont((String)"font.standard.bold");
        this.headingAttrs = new GAttributes(monospaced, (Color)GThemeDefaults.Colors.Palette.BLUE);
        this.valueAttrs = new GAttributes(bold);
        this.deletedAttrs = new GAttributes(bold, (Color)GThemeDefaults.Colors.Palette.RED);
        this.setSourceArchive(null);
    }

    private void formatSourceArchive() {
        if (this.sourceArchive == null) {
            this.insertString("\n\nDeleted", this.deletedAttrs);
            return;
        }
        this.formatName();
        this.formatSyncTime();
        this.formatDirtyFlag();
    }

    private void formatArchiveID() {
        this.insertString("    Archive ID: ", this.headingAttrs);
        this.insertString(this.sourceArchive.getSourceArchiveID().getValue() + "\n", this.valueAttrs);
    }

    private void formatName() {
        this.insertString("Name: ", this.headingAttrs);
        this.insertString(this.sourceArchive.getName() + "\n", this.valueAttrs);
    }

    private void formatFileID() {
        this.insertString("       File ID: ", this.headingAttrs);
        this.insertString(this.sourceArchive.getDomainFileID() + "\n", this.valueAttrs);
    }

    private void formatType() {
        ArchiveType archiveType = this.sourceArchive.getArchiveType();
        String typeString = archiveType == ArchiveType.FILE ? "File Archive" : (archiveType == ArchiveType.PROGRAM ? "Program" : (archiveType == ArchiveType.PROJECT ? "Project Archive" : (archiveType == ArchiveType.BUILT_IN ? "Built-In" : "Invalid")));
        this.insertString("          Type: ", this.headingAttrs);
        this.insertString(typeString + "\n", this.valueAttrs);
    }

    private void formatSyncTime() {
        String syncTime = new Date(this.sourceArchive.getLastSyncTime()).toString();
        this.insertString("Last Sync Time: ", this.headingAttrs);
        this.insertString(syncTime + "\n", this.valueAttrs);
    }

    private void formatDirtyFlag() {
        this.insertString("Changed Since Last Sync? ", this.headingAttrs);
        this.insertString((this.sourceArchive.isDirty() ? "yes" : "no") + "\n", this.valueAttrs);
    }

    private void insertString(String str, SimpleAttributeSet attributeSet) {
        int offset = this.doc.getLength();
        try {
            this.doc.insertString(offset, str, attributeSet);
        }
        catch (BadLocationException e1) {
            Msg.debug((Object)this, (Object)"Exception entering text", (Throwable)e1);
        }
    }
}

