/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.inline;

import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.fo.flow.Footnote;
import org.apache.fop.layoutmgr.FootnoteBodyLayoutManager;
import org.apache.fop.layoutmgr.InlineKnuthSequence;
import org.apache.fop.layoutmgr.KnuthElement;
import org.apache.fop.layoutmgr.KnuthSequence;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LayoutManager;
import org.apache.fop.layoutmgr.ListElement;
import org.apache.fop.layoutmgr.NonLeafPosition;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.PositionIterator;
import org.apache.fop.layoutmgr.inline.InlineLayoutManager;
import org.apache.fop.layoutmgr.inline.InlineStackingLayoutManager;
import org.apache.fop.layoutmgr.inline.KnuthInlineBox;

public class FootnoteLayoutManager
extends InlineStackingLayoutManager {
    private static Log log = LogFactory.getLog(FootnoteLayoutManager.class);
    private Footnote footnote;
    private InlineStackingLayoutManager citationLM;
    private FootnoteBodyLayoutManager bodyLM;
    private KnuthElement forcedAnchor;

    public FootnoteLayoutManager(Footnote node) {
        super(node);
        this.footnote = node;
    }

    @Override
    public void initialize() {
        this.citationLM = new InlineLayoutManager(this.footnote.getFootnoteCitation());
        this.bodyLM = new FootnoteBodyLayoutManager(this.footnote.getFootnoteBody());
    }

    @Override
    public List<KnuthSequence> getNextKnuthElements(LayoutContext context, int alignment) {
        this.citationLM.setParent(this);
        this.citationLM.initialize();
        this.bodyLM.setParent(this);
        this.bodyLM.initialize();
        LinkedList<KnuthSequence> returnedList = new LinkedList<KnuthSequence>();
        while (!this.citationLM.isFinished()) {
            List partialList = this.citationLM.getNextKnuthElements(context, alignment);
            if (partialList == null) continue;
            returnedList.addAll(partialList);
        }
        if (returnedList.size() == 0) {
            InlineKnuthSequence seq = new InlineKnuthSequence();
            this.forcedAnchor = new KnuthInlineBox(0, null, null, true);
            seq.add(this.forcedAnchor);
            returnedList.add(seq);
        }
        this.setFinished(true);
        this.addAnchor(returnedList);
        ListIterator listIterator = returnedList.listIterator();
        ListIterator elementIterator = null;
        KnuthSequence list = null;
        KnuthElement element = null;
        while (listIterator.hasNext()) {
            list = (KnuthSequence)listIterator.next();
            elementIterator = list.listIterator();
            while (elementIterator.hasNext()) {
                element = (KnuthElement)elementIterator.next();
                element.setPosition(this.notifyPos(new NonLeafPosition((LayoutManager)this, element.getPosition())));
            }
        }
        return returnedList;
    }

    @Override
    public List<ListElement> getChangedKnuthElements(List<ListElement> oldList, int alignment, int depth) {
        List<ListElement> returnedList = super.getChangedKnuthElements(oldList, alignment, depth);
        this.addAnchor(returnedList);
        return returnedList;
    }

    @Override
    public void addAreas(PositionIterator posIter, LayoutContext context) {
        LayoutManager childLM;
        LinkedList<Position> positionList = new LinkedList<Position>();
        while (posIter.hasNext()) {
            Position pos = posIter.next();
            if (pos == null || pos.getPosition() == null) continue;
            positionList.add(pos.getPosition());
        }
        this.citationLM.setParent(this.getParent());
        LayoutContext childContext = LayoutContext.copyOf(context);
        PositionIterator childPosIter = new PositionIterator(positionList.listIterator());
        while ((childLM = childPosIter.getNextChildLM()) != null) {
            childLM.setFromFootnote(true);
            childLM.addAreas(childPosIter, childContext);
            childContext.setLeadingSpace(childContext.getTrailingSpace());
            childContext.setFlags(16, true);
        }
    }

    private void addAnchor(List citationList) {
        KnuthInlineBox lastBox = null;
        ListIterator citationIterator = citationList.listIterator(citationList.size());
        while (citationIterator.hasPrevious() && lastBox == null) {
            Object obj = citationIterator.previous();
            if (obj instanceof KnuthElement) {
                KnuthElement element = (KnuthElement)obj;
                if (!(element instanceof KnuthInlineBox)) continue;
                lastBox = (KnuthInlineBox)element;
                continue;
            }
            KnuthSequence seq = (KnuthSequence)obj;
            ListIterator nestedIterator = seq.listIterator(seq.size());
            while (nestedIterator.hasPrevious() && lastBox == null) {
                KnuthElement element = (KnuthElement)nestedIterator.previous();
                if ((!(element instanceof KnuthInlineBox) || element.isAuxiliary()) && element != this.forcedAnchor) continue;
                lastBox = (KnuthInlineBox)element;
            }
        }
        if (lastBox != null) {
            lastBox.setFootnoteBodyLM(this.bodyLM);
        }
    }
}

