/* This file is automatically generated by Lemon from input grammar
** source file "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon". */
/* protobuf_lang_parser.lemon
 *
 * C Protocol Buffers Language (PBL) Parser (for *.proto files)
 * Copyright 2020, Huang Qiangxiong <qiangxiong.huang@qq.com>
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 */

/* This parser is mainly to get MESSAGE, ENUM, and FIELD information from *.proto files.
 * There are three formats of *.proto files:
 * 1) Protocol Buffers Edition 2023 Language Specification
 *      https://protobuf.dev/reference/protobuf/edition-2023-spec
 * 2) Protocol Buffers Version 3 Language Specification:
 *      https://developers.google.com/protocol-buffers/docs/reference/proto3-spec
 * 3) Protocol Buffers Version 2 Language Specification:
 *      https://developers.google.com/protocol-buffers/docs/reference/proto2-spec
 * There are some errors about 'proto', 'option' (value), 'extensions',  and 'reserved' (fieldName) definitions on that sites.
 * This parser is created because Wireshark is mainly implemented in plain ANSI C but the official
 * Protocol Buffers Language parser is implemented in C++.
 */
#include "config.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <glib.h>
#include <assert.h>
#include <ws_diag_control.h>
#include <wsutil/file_util.h>
#include "protobuf_lang_tree.h"
#include "protobuf_lang_parser.h"
#include "protobuf_lang_scanner_lex.h"

#define NAME_TO_BE_SET "<NAME_TO_BE_SET>"
#define NEED_NOT_NAME "<NEED_NOT_NAME>"

static void *ProtobufLangParserAlloc(void *(*mallocProc)(size_t));
static void ProtobufLangParser(void *yyp, int yymajor, protobuf_lang_token_t *yyminor, protobuf_lang_state_t *state);
static void ProtobufLangParserFree(void *p, void (*freeProc)(void*));

/* Error handling function for parser */
void protobuf_lang_error(void* yyscanner, protobuf_lang_state_t *state, const char *msg);

/* Extended error handling function */
void pbl_parser_error(protobuf_lang_state_t *state, const char *fmt, ...);

/* It's just the approximate line number which is gotten when a grammar rule is reduced
   by the parser (lemon). That might be overridden by the lineno argument of
   pbl_set_node_name() later. */
#define CUR_LINENO (protobuf_lang_get_lineno(state->scanner))

DIAG_OFF_LEMON()
#line 81 "./protobuf_lang_parser.c"
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols.
***************** Begin token definitions *************************************/
#ifndef PT_IDENT
#define PT_IDENT                        1
#define PT_SYNTAX                       2
#define PT_EDITION                      3
#define PT_IMPORT                       4
#define PT_WEAK                         5
#define PT_PUBLIC                       6
#define PT_PACKAGE                      7
#define PT_OPTION                       8
#define PT_REQUIRED                     9
#define PT_OPTIONAL                    10
#define PT_REPEATED                    11
#define PT_ONEOF                       12
#define PT_MAP                         13
#define PT_RESERVED                    14
#define PT_ENUM                        15
#define PT_GROUP                       16
#define PT_EXTEND                      17
#define PT_EXTENSIONS                  18
#define PT_MESSAGE                     19
#define PT_SERVICE                     20
#define PT_RPC                         21
#define PT_STREAM                      22
#define PT_RETURNS                     23
#define PT_TO                          24
#define PT_ASSIGN                      25
#define PT_SEMICOLON                   26
#define PT_LPAREN                      27
#define PT_RPAREN                      28
#define PT_DOT                         29
#define PT_LCURLY                      30
#define PT_RCURLY                      31
#define PT_STRLIT                      32
#define PT_LBRACKET                    33
#define PT_RBRACKET                    34
#define PT_EQUAL                       35
#define PT_NOTEQUAL                    36
#define PT_NOTEQUAL2                   37
#define PT_GEQUAL                      38
#define PT_LEQUAL                      39
#define PT_ASSIGN_PLUS                 40
#define PT_PLUS                        41
#define PT_MINUS                       42
#define PT_MULTIPLY                    43
#define PT_DIV                         44
#define PT_LOGIC_OR                    45
#define PT_OR                          46
#define PT_LOGIC_AND                   47
#define PT_AND                         48
#define PT_NOT                         49
#define PT_NEG                         50
#define PT_XOR                         51
#define PT_SHL                         52
#define PT_SHR                         53
#define PT_PERCENT                     54
#define PT_DOLLAR                      55
#define PT_COND                        56
#define PT_COMMA                       57
#define PT_COLON                       58
#define PT_LESS                        59
#define PT_GREATER                     60
#define PT_DECIMALLIT                  61
#define PT_OCTALLIT                    62
#define PT_HEXLIT                      63
#endif
/**************** End token definitions ***************************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ProtobufLangParserTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ProtobufLangParserTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ProtobufLangParserARG_SDECL     A static variable declaration for the %extra_argument
**    ProtobufLangParserARG_PDECL     A parameter declaration for the %extra_argument
**    ProtobufLangParserARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ProtobufLangParserARG_STORE     Code to store %extra_argument into yypParser
**    ProtobufLangParserARG_FETCH     Code to extract %extra_argument from yypParser
**    ProtobufLangParserCTX_*         As ProtobufLangParserARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned char
#define YYNOCODE 131
#define YYACTIONTYPE unsigned short int
#define ProtobufLangParserTOKENTYPE  protobuf_lang_token_t* 
typedef union {
  int yyinit;
  ProtobufLangParserTOKENTYPE yy0;
  pbl_node_t* yy93;
  int yy116;
  protobuf_lang_token_t* yy118;
  uint64_t yy180;
  gchar* yy254;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ProtobufLangParserARG_SDECL  protobuf_lang_state_t *state ;
#define ProtobufLangParserARG_PDECL , protobuf_lang_state_t *state 
#define ProtobufLangParserARG_PARAM ,state 
#define ProtobufLangParserARG_FETCH  protobuf_lang_state_t *state =yypParser->state ;
#define ProtobufLangParserARG_STORE yypParser->state =state ;
#define ProtobufLangParserCTX_SDECL
#define ProtobufLangParserCTX_PDECL
#define ProtobufLangParserCTX_PARAM
#define ProtobufLangParserCTX_FETCH
#define ProtobufLangParserCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             166
#define YYNRULE              191
#define YYNRULE_WITH_ACTION  78
#define YYNTOKEN             64
#define YY_MAX_SHIFT         165
#define YY_MIN_SHIFTREDUCE   338
#define YY_MAX_SHIFTREDUCE   528
#define YY_ERROR_ACTION      529
#define YY_ACCEPT_ACTION     530
#define YY_NO_ACTION         531
#define YY_MIN_REDUCE        532
#define YY_MAX_REDUCE        722
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (518)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   558,  528,  155,  579,  113,  112,  578,   99,  578,  101,
 /*    10 */   578,  141,  578,  143,  578,  103,  578,  105,  135,   39,
 /*    20 */    39,  593,  687,  688,  528,  444,  461,  434,  435,  462,
 /*    30 */    91,  427,  430,  436,  437,  438,  439,  440,  441,  442,
 /*    40 */   443,  445,  446,  447,  448,  449,  450,  451,  452,  453,
 /*    50 */   454,  455,  456,  457,  458,  459,  460,  463,  464,  465,
 /*    60 */   466,  405,  406,  407,  528,   39,  528,   27,   27,   33,
 /*    70 */    33,   25,  380,  381,  382,   60,  136,    5,   66,   61,
 /*    80 */    55,   24,   67,  563,   96,  682,  683,   50,  119,  526,
 /*    90 */   598,  528,  564,   95,  390,   98,  580,  560,   25,  380,
 /*   100 */   381,  382,   60,  136,    5,   66,   61,   55,   24,   67,
 /*   110 */   133,  677,  678,   27,  160,   33,  526,  133,  528,  697,
 /*   120 */   602,  391,  528,    4,  696,   25,  380,  381,  382,   60,
 /*   130 */   136,    5,   66,   61,   55,   24,   67,   46,   64,  405,
 /*   140 */   406,  407,  577,  526,   25,   25,  536,  536,  351,  530,
 /*   150 */   165,   69,   68,  536,  603,  549,  536,   53,   49,  547,
 /*   160 */   528,  548,  526,  526,  499,  698,  536,  367,  491,  111,
 /*   170 */   551,   14,  552,  550,  665,  613,  614,  615,  616,  542,
 /*   180 */   528,   52,  405,  406,  407,  667,  669,  124,  559,  598,
 /*   190 */    73,  666,  668,   79,   25,   42,  150,   27,   27,  139,
 /*   200 */    59,   66,  149,   55,  577,   67,   54,  149,  528,   91,
 /*   210 */   414,  414,  526,  528,  528,   25,  380,  381,  382,  528,
 /*   220 */    38,   37,  588,   61,   93,  544,  160,  380,  381,  382,
 /*   230 */   153,  582,  602,  526,   61,  691,  153,  623,  392,   78,
 /*   240 */   405,  406,  407,   27,  526,  414,  153,  690,  692,  400,
 /*   250 */   706,   92,   94,   97,   97,  142,   92,  107,   46,   64,
 /*   260 */   106,  151,  107,  577,  160,  142,  603,  156,   25,  675,
 /*   270 */   602,  626,  703,  160,  405,  406,  407,  583,  162,  602,
 /*   280 */   596,  528,  627,   63,  705,  625,  526,  577,  555,   36,
 /*   290 */    36,  486,   33,   33,  597,  127,  528,  598,   80,   81,
 /*   300 */    33,   33,   51,   25,  603,   33,   33,  711,  117,    5,
 /*   310 */   671,  672,  117,  603,  607,  676,  606,  670,  100,  580,
 /*   320 */   144,  526,   72,   71,  161,  414,  359,  581,   33,   33,
 /*   330 */   144,  102,  580,   36,   36,   36,  528,  528,   33,  152,
 /*   340 */   108,  108,  405,  406,  407,   70,   33,  528,  605,  128,
 /*   350 */   604,   33,   62,  129,  104,  580,  528,  115,  128,  598,
 /*   360 */     9,  129,   78,    4,   77,  405,  406,  407,  528,   78,
 /*   370 */   116,   10,  598,   78,   33,   77,  118,  543,  598,   36,
 /*   380 */    11,  122,   78,  598,   77,  674,  123,  130,  598,  598,
 /*   390 */   114,  134,   12,  138,   78,  577,   77,  140,  138,  146,
 /*   400 */   148,  710,    4,  140,  146,  148,  710,  157,  340,  158,
 /*   410 */   157,  158,  339,  490,  415,  485,  109,   82,  415,   83,
 /*   420 */   398,  396,  131,  378,  132,  137,  145,   15,   16,  164,
 /*   430 */    17,  376,  147,  506,  505,  154,  345,  344,   18,  159,
 /*   440 */   343,  163,  415,  415,  110,   21,  415,   22,   22,   22,
 /*   450 */    40,   41,    8,    7,    1,   22,    6,    2,   23,    3,
 /*   460 */    20,   74,   13,   75,   76,   42,  612,  375,   48,   47,
 /*   470 */   374,  372,   43,  120,  121,  373,  371,  125,   44,   84,
 /*   480 */   126,   28,   45,   85,  500,  397,   56,   57,   58,  395,
 /*   490 */    29,   62,   86,   30,   87,   31,   32,   88,  379,  377,
 /*   500 */   611,   34,   35,  507,  610,  362,  415,   26,  531,  424,
 /*   510 */   531,   89,  347,   19,   65,   90,  423,  346,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   104,    1,  106,  104,    2,    3,  104,  105,  104,  105,
 /*    10 */   104,  105,  104,  105,  104,  105,  104,  105,   67,   70,
 /*    20 */    71,   70,  113,  114,    1,   25,   26,   27,   28,   29,
 /*    30 */    30,   31,   32,   33,   34,   35,   36,   37,   38,   39,
 /*    40 */    40,   41,   42,   43,   44,   45,   46,   47,   48,   49,
 /*    50 */    50,   51,   52,   53,   54,   55,   56,   57,   58,   59,
 /*    60 */    60,   61,   62,   63,    1,  116,    1,   70,   71,   70,
 /*    70 */    71,    8,    9,   10,   11,   12,   13,   14,   15,   16,
 /*    80 */    17,   18,   19,   85,   86,  113,  114,   22,   68,   26,
 /*    90 */    70,    1,   94,   95,   31,   96,   97,  104,    8,    9,
 /*   100 */    10,   11,   12,   13,   14,   15,   16,   17,   18,   19,
 /*   110 */    70,  113,  114,  116,   64,  116,   26,   77,    1,   69,
 /*   120 */    70,   31,    1,   81,  127,    8,    9,   10,   11,   12,
 /*   130 */    13,   14,   15,   16,   17,   18,   19,   65,   66,   61,
 /*   140 */    62,   63,   70,   26,    8,    8,   82,   83,   31,  107,
 /*   150 */   108,  109,  110,   89,  104,   83,   92,   21,   22,   87,
 /*   160 */     1,   89,   26,   26,   26,  115,  102,   31,   31,   64,
 /*   170 */    98,   33,  100,  101,  102,  111,  112,  113,  114,   70,
 /*   180 */     1,   22,   61,   62,   63,  113,  114,   68,  104,   70,
 /*   190 */     4,  119,  120,    7,    8,   57,   64,   70,   71,   65,
 /*   200 */    66,   15,   70,   17,   70,   19,   20,   75,    1,   30,
 /*   210 */    32,   32,   26,    1,    1,    8,    9,   10,   11,    1,
 /*   220 */    41,   42,   88,   16,   64,  116,   64,    9,   10,   11,
 /*   230 */   104,   69,   70,   26,   16,  101,  104,   70,   31,   27,
 /*   240 */    61,   62,   63,  116,   26,   32,  104,  113,  114,   31,
 /*   250 */    70,  125,   64,  126,  127,   70,  130,  125,   65,   66,
 /*   260 */   128,  129,  130,   70,   64,   80,  104,   70,    8,   69,
 /*   270 */    70,  104,  130,   64,   61,   62,   63,  115,   69,   70,
 /*   280 */    87,    1,  115,   66,  104,  118,   26,   70,   91,   70,
 /*   290 */    71,   31,   70,   71,  101,   68,    1,   70,    5,    6,
 /*   300 */    70,   71,   22,    8,  104,   70,   71,  114,   70,   14,
 /*   310 */   113,  114,   74,  104,   70,  115,   70,  120,   96,   97,
 /*   320 */    70,   26,   41,   42,  115,   32,   31,   97,   70,   71,
 /*   330 */    80,   96,   97,   70,   71,  116,    1,    1,  116,   64,
 /*   340 */   121,  122,   61,   62,   63,   41,  116,    1,  104,   70,
 /*   350 */   104,  116,   16,   70,   96,   97,    1,   68,   79,   70,
 /*   360 */    25,   78,   27,   81,   29,   61,   62,   63,    1,   27,
 /*   370 */    68,   25,   70,   27,  116,   29,   68,  116,   70,  116,
 /*   380 */    25,   68,   27,   70,   29,  122,   68,   68,   70,   70,
 /*   390 */   108,   66,   25,   70,   27,   70,   29,   70,   75,   70,
 /*   400 */    70,   70,   81,   76,   75,   75,   75,   70,   26,   70,
 /*   410 */    73,   72,   26,   26,   32,   26,   64,   30,   32,   30,
 /*   420 */    26,   26,   34,   26,   34,   34,   34,   33,   33,  108,
 /*   430 */    33,   26,   34,   26,   26,   34,   26,   26,   33,   70,
 /*   440 */    26,   70,   32,   32,   64,   57,   32,   57,   57,   57,
 /*   450 */   124,  123,   93,  103,   84,   57,   99,   84,   57,   84,
 /*   460 */   117,   25,   90,   25,   57,   57,    0,   28,   27,   57,
 /*   470 */    28,   28,   27,   23,   28,   28,   28,   23,   27,   30,
 /*   480 */    28,   25,   27,   30,   26,   26,   60,   57,   59,   26,
 /*   490 */    25,   16,   30,   25,   30,   25,   25,   30,   26,   26,
 /*   500 */     0,   25,   24,   26,    0,   26,   32,   25,  131,   26,
 /*   510 */   131,   30,   28,   33,   57,   30,   26,   26,  131,  131,
 /*   520 */   131,  131,  131,  131,  131,  131,  131,  131,  131,  131,
 /*   530 */   131,  131,  131,  131,  131,  131,  131,  131,  131,  131,
 /*   540 */   131,  131,  131,  131,  131,  131,  131,  131,  131,  131,
 /*   550 */   131,  131,  131,  131,  131,  131,  131,  131,  131,  131,
 /*   560 */   131,  131,  131,  131,  131,  131,  131,  131,  131,  131,
 /*   570 */   131,  131,  131,  131,  131,  131,  131,  131,  131,  131,
 /*   580 */   131,  131,
};
#define YY_SHIFT_COUNT    (165)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (504)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */     2,   63,   90,  117,  186,  213,  207,  218,  136,  179,
 /*    10 */   179,  179,  179,  295,  212,  212,  212,  212,  212,  212,
 /*    20 */     0,  212,  212,  212,   78,  212,  281,  335,  304,  304,
 /*    30 */   304,  304,  304,  346,  304,  121,  355,  121,  121,  367,
 /*    40 */   137,  260,   78,   65,  159,  280,  336,   23,   23,   23,
 /*    50 */    23,   23,   23,   23,   23,   23,   23,   23,   23,   23,
 /*    60 */    23,   23,   23,   23,   23,   23,   23,   23,  518,  518,
 /*    70 */    78,   78,   78,  293,  178,  178,  178,  342,   23,   23,
 /*    80 */   178,  178,  518,  518,  518,  518,  518,  518,  518,  518,
 /*    90 */   518,  518,  138,  382,  386,  387,  389,  388,  390,  394,
 /*   100 */   391,  395,  392,  397,  398,  405,  407,  408,  401,  410,
 /*   110 */   411,  414,  436,  438,  466,  439,  412,  441,  442,  443,
 /*   120 */   445,  450,  446,  447,  448,  451,  454,  452,  455,  449,
 /*   130 */   453,  458,  459,  456,  426,  430,  429,  463,  465,  475,
 /*   140 */   462,  464,  468,  467,  470,  472,  471,  473,  476,  457,
 /*   150 */   474,  477,  474,  478,  479,  480,  482,  481,  485,  484,
 /*   160 */   474,  483,  490,  491,  500,  504,
};
#define YY_REDUCE_COUNT (91)
#define YY_REDUCE_MIN   (-104)
#define YY_REDUCE_MAX   (380)
static const short yy_reduce_ofst[] = {
 /*     0 */    42,   72,   72,   72,   64,  132,  134,  193,   -2,   50,
 /*    10 */   162,  200,  209,  197,  127,   -1,  222,  235,  258,  219,
 /*    20 */   167,   -3,  230,  263,  126,  -51, -104,  109,  -98,  -96,
 /*    30 */   -94,  -92,  -90,  109,  -88,  180,  109,  244,  246,  109,
 /*    40 */   -91,  -28,  142,   20,  119,  227,  217,  289,  302,  238,
 /*    50 */   308,  313,  318,  279,  283,  319,   40,  325,  -49,  323,
 /*    60 */   327,  185,  250,  329,  330,  331,  337,  339,  282,  321,
 /*    70 */  -101,   -7,   84,  105,  160,  188,  275,  261,  369,  371,
 /*    80 */   352,  380,  326,  328,  359,  350,  357,  370,  373,  372,
 /*    90 */   375,  343,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */   535,  529,  529,  529,  532,  529,  529,  529,  529,  529,
 /*    10 */   529,  529,  529,  529,  529,  529,  529,  529,  529,  529,
 /*    20 */   529,  529,  529,  529,  529,  529,  529,  529,  529,  529,
 /*    30 */   529,  529,  529,  529,  529,  529,  529,  529,  529,  529,
 /*    40 */   529,  529,  529,  529,  529,  529,  529,  529,  529,  529,
 /*    50 */   529,  529,  529,  529,  529,  529,  529,  529,  529,  529,
 /*    60 */   529,  529,  529,  529,  529,  529,  529,  529,  535,  535,
 /*    70 */   529,  529,  529,  529,  529,  529,  529,  529,  529,  529,
 /*    80 */   529,  529,  686,  681,  562,  595,  587,  546,  546,  554,
 /*    90 */   546,  622,  529,  529,  529,  529,  529,  529,  529,  529,
 /*   100 */   529,  529,  529,  529,  529,  529,  529,  529,  529,  529,
 /*   110 */   529,  529,  529,  529,  529,  529,  529,  529,  529,  529,
 /*   120 */   529,  529,  529,  529,  529,  529,  529,  529,  529,  529,
 /*   130 */   529,  529,  529,  529,  529,  529,  529,  529,  529,  529,
 /*   140 */   529,  529,  529,  529,  529,  529,  529,  529,  529,  709,
 /*   150 */   707,  529,  708,  704,  529,  557,  529,  529,  529,  529,
 /*   160 */   721,  529,  529,  529,  529,  529,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.
** If a construct like the following:
**
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*   PT_IDENT => nothing */
    1,  /*  PT_SYNTAX => PT_IDENT */
    1,  /* PT_EDITION => PT_IDENT */
    1,  /*  PT_IMPORT => PT_IDENT */
    1,  /*    PT_WEAK => PT_IDENT */
    1,  /*  PT_PUBLIC => PT_IDENT */
    1,  /* PT_PACKAGE => PT_IDENT */
    1,  /*  PT_OPTION => PT_IDENT */
    1,  /* PT_REQUIRED => PT_IDENT */
    1,  /* PT_OPTIONAL => PT_IDENT */
    1,  /* PT_REPEATED => PT_IDENT */
    1,  /*   PT_ONEOF => PT_IDENT */
    1,  /*     PT_MAP => PT_IDENT */
    1,  /* PT_RESERVED => PT_IDENT */
    1,  /*    PT_ENUM => PT_IDENT */
    1,  /*   PT_GROUP => PT_IDENT */
    1,  /*  PT_EXTEND => PT_IDENT */
    1,  /* PT_EXTENSIONS => PT_IDENT */
    1,  /* PT_MESSAGE => PT_IDENT */
    1,  /* PT_SERVICE => PT_IDENT */
    1,  /*     PT_RPC => PT_IDENT */
    1,  /*  PT_STREAM => PT_IDENT */
    1,  /* PT_RETURNS => PT_IDENT */
    1,  /*      PT_TO => PT_IDENT */
    0,  /*  PT_ASSIGN => nothing */
    0,  /* PT_SEMICOLON => nothing */
    0,  /*  PT_LPAREN => nothing */
    0,  /*  PT_RPAREN => nothing */
    0,  /*     PT_DOT => nothing */
    0,  /*  PT_LCURLY => nothing */
    0,  /*  PT_RCURLY => nothing */
    0,  /*  PT_STRLIT => nothing */
    0,  /* PT_LBRACKET => nothing */
    0,  /* PT_RBRACKET => nothing */
    0,  /*   PT_EQUAL => nothing */
    0,  /* PT_NOTEQUAL => nothing */
    0,  /* PT_NOTEQUAL2 => nothing */
    0,  /*  PT_GEQUAL => nothing */
    0,  /*  PT_LEQUAL => nothing */
    0,  /* PT_ASSIGN_PLUS => nothing */
    0,  /*    PT_PLUS => nothing */
    0,  /*   PT_MINUS => nothing */
    0,  /* PT_MULTIPLY => nothing */
    0,  /*     PT_DIV => nothing */
    0,  /* PT_LOGIC_OR => nothing */
    0,  /*      PT_OR => nothing */
    0,  /* PT_LOGIC_AND => nothing */
    0,  /*     PT_AND => nothing */
    0,  /*     PT_NOT => nothing */
    0,  /*     PT_NEG => nothing */
    0,  /*     PT_XOR => nothing */
    0,  /*     PT_SHL => nothing */
    0,  /*     PT_SHR => nothing */
    0,  /* PT_PERCENT => nothing */
    0,  /*  PT_DOLLAR => nothing */
    0,  /*    PT_COND => nothing */
    0,  /*   PT_COMMA => nothing */
    0,  /*   PT_COLON => nothing */
    0,  /*    PT_LESS => nothing */
    0,  /* PT_GREATER => nothing */
    0,  /* PT_DECIMALLIT => nothing */
    0,  /* PT_OCTALLIT => nothing */
    0,  /*  PT_HEXLIT => nothing */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ProtobufLangParserARG_SDECL                /* A place to hold %extra_argument */
  ProtobufLangParserCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#include <assert.h>
#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/*
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ProtobufLangParserTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = {
  /*    0 */ "$",
  /*    1 */ "PT_IDENT",
  /*    2 */ "PT_SYNTAX",
  /*    3 */ "PT_EDITION",
  /*    4 */ "PT_IMPORT",
  /*    5 */ "PT_WEAK",
  /*    6 */ "PT_PUBLIC",
  /*    7 */ "PT_PACKAGE",
  /*    8 */ "PT_OPTION",
  /*    9 */ "PT_REQUIRED",
  /*   10 */ "PT_OPTIONAL",
  /*   11 */ "PT_REPEATED",
  /*   12 */ "PT_ONEOF",
  /*   13 */ "PT_MAP",
  /*   14 */ "PT_RESERVED",
  /*   15 */ "PT_ENUM",
  /*   16 */ "PT_GROUP",
  /*   17 */ "PT_EXTEND",
  /*   18 */ "PT_EXTENSIONS",
  /*   19 */ "PT_MESSAGE",
  /*   20 */ "PT_SERVICE",
  /*   21 */ "PT_RPC",
  /*   22 */ "PT_STREAM",
  /*   23 */ "PT_RETURNS",
  /*   24 */ "PT_TO",
  /*   25 */ "PT_ASSIGN",
  /*   26 */ "PT_SEMICOLON",
  /*   27 */ "PT_LPAREN",
  /*   28 */ "PT_RPAREN",
  /*   29 */ "PT_DOT",
  /*   30 */ "PT_LCURLY",
  /*   31 */ "PT_RCURLY",
  /*   32 */ "PT_STRLIT",
  /*   33 */ "PT_LBRACKET",
  /*   34 */ "PT_RBRACKET",
  /*   35 */ "PT_EQUAL",
  /*   36 */ "PT_NOTEQUAL",
  /*   37 */ "PT_NOTEQUAL2",
  /*   38 */ "PT_GEQUAL",
  /*   39 */ "PT_LEQUAL",
  /*   40 */ "PT_ASSIGN_PLUS",
  /*   41 */ "PT_PLUS",
  /*   42 */ "PT_MINUS",
  /*   43 */ "PT_MULTIPLY",
  /*   44 */ "PT_DIV",
  /*   45 */ "PT_LOGIC_OR",
  /*   46 */ "PT_OR",
  /*   47 */ "PT_LOGIC_AND",
  /*   48 */ "PT_AND",
  /*   49 */ "PT_NOT",
  /*   50 */ "PT_NEG",
  /*   51 */ "PT_XOR",
  /*   52 */ "PT_SHL",
  /*   53 */ "PT_SHR",
  /*   54 */ "PT_PERCENT",
  /*   55 */ "PT_DOLLAR",
  /*   56 */ "PT_COND",
  /*   57 */ "PT_COMMA",
  /*   58 */ "PT_COLON",
  /*   59 */ "PT_LESS",
  /*   60 */ "PT_GREATER",
  /*   61 */ "PT_DECIMALLIT",
  /*   62 */ "PT_OCTALLIT",
  /*   63 */ "PT_HEXLIT",
  /*   64 */ "strLit",
  /*   65 */ "label",
  /*   66 */ "type",
  /*   67 */ "keyType",
  /*   68 */ "messageType",
  /*   69 */ "constant",
  /*   70 */ "exIdent",
  /*   71 */ "optionName",
  /*   72 */ "messageName",
  /*   73 */ "enumName",
  /*   74 */ "streamName",
  /*   75 */ "fieldName",
  /*   76 */ "oneofName",
  /*   77 */ "mapName",
  /*   78 */ "serviceName",
  /*   79 */ "rpcName",
  /*   80 */ "groupName",
  /*   81 */ "protoBody",
  /*   82 */ "topLevelDef",
  /*   83 */ "message",
  /*   84 */ "messageBody",
  /*   85 */ "rpc",
  /*   86 */ "rpcDecl",
  /*   87 */ "field",
  /*   88 */ "oneofField",
  /*   89 */ "enum",
  /*   90 */ "enumBody",
  /*   91 */ "enumField",
  /*   92 */ "service",
  /*   93 */ "serviceBody",
  /*   94 */ "stream",
  /*   95 */ "streamDecl",
  /*   96 */ "fieldOptions",
  /*   97 */ "fieldOption",
  /*   98 */ "oneof",
  /*   99 */ "oneofBody",
  /*  100 */ "mapField",
  /*  101 */ "group",
  /*  102 */ "extend",
  /*  103 */ "extendBody",
  /*  104 */ "intLit",
  /*  105 */ "fieldNumber",
  /*  106 */ "enumNumber",
  /*  107 */ "proto",
  /*  108 */ "wholeProtoBody",
  /*  109 */ "syntax",
  /*  110 */ "edition",
  /*  111 */ "import",
  /*  112 */ "package",
  /*  113 */ "option",
  /*  114 */ "emptyStatement",
  /*  115 */ "customOptionValue",
  /*  116 */ "extIdentInParentheses",
  /*  117 */ "customOptionBody",
  /*  118 */ "symbolsWithoutCurly",
  /*  119 */ "extensions",
  /*  120 */ "reserved",
  /*  121 */ "enumValueOptions",
  /*  122 */ "enumValueOption",
  /*  123 */ "rpcBody",
  /*  124 */ "streamBody",
  /*  125 */ "ranges",
  /*  126 */ "declarations",
  /*  127 */ "declaration",
  /*  128 */ "quoteFieldNames",
  /*  129 */ "reservedIdent",
  /*  130 */ "range",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "wholeProtoBody ::= protoBody",
 /*   1 */ "syntax ::= PT_SYNTAX PT_ASSIGN strLit PT_SEMICOLON",
 /*   2 */ "edition ::= PT_EDITION PT_ASSIGN strLit PT_SEMICOLON",
 /*   3 */ "protoBody ::=",
 /*   4 */ "protoBody ::= protoBody topLevelDef",
 /*   5 */ "import ::= PT_IMPORT strLit PT_SEMICOLON",
 /*   6 */ "import ::= PT_IMPORT PT_PUBLIC strLit PT_SEMICOLON",
 /*   7 */ "import ::= PT_IMPORT PT_WEAK strLit PT_SEMICOLON",
 /*   8 */ "package ::= PT_PACKAGE exIdent PT_SEMICOLON",
 /*   9 */ "extIdentInParentheses ::= PT_LPAREN exIdent PT_RPAREN",
 /*  10 */ "optionName ::= optionName exIdent",
 /*  11 */ "optionName ::= optionName PT_DOT extIdentInParentheses",
 /*  12 */ "optionName ::= optionName extIdentInParentheses",
 /*  13 */ "message ::= PT_MESSAGE messageName PT_LCURLY messageBody PT_RCURLY",
 /*  14 */ "messageBody ::=",
 /*  15 */ "messageBody ::= messageBody field",
 /*  16 */ "messageBody ::= messageBody enum",
 /*  17 */ "messageBody ::= messageBody message",
 /*  18 */ "messageBody ::= messageBody group",
 /*  19 */ "messageBody ::= messageBody oneof",
 /*  20 */ "messageBody ::= messageBody mapField",
 /*  21 */ "enum ::= PT_ENUM enumName PT_LCURLY enumBody PT_RCURLY",
 /*  22 */ "enumBody ::=",
 /*  23 */ "enumBody ::= enumBody enumField",
 /*  24 */ "enumField ::= exIdent PT_ASSIGN enumNumber PT_LBRACKET enumValueOptions PT_RBRACKET PT_SEMICOLON",
 /*  25 */ "enumField ::= exIdent PT_ASSIGN enumNumber",
 /*  26 */ "enumNumber ::= intLit",
 /*  27 */ "enumNumber ::= PT_PLUS intLit",
 /*  28 */ "enumNumber ::= PT_MINUS intLit",
 /*  29 */ "service ::= PT_SERVICE serviceName PT_LCURLY serviceBody PT_RCURLY",
 /*  30 */ "serviceBody ::=",
 /*  31 */ "serviceBody ::= serviceBody rpc",
 /*  32 */ "serviceBody ::= serviceBody stream",
 /*  33 */ "rpcDecl ::= PT_RPC rpcName PT_LPAREN messageType PT_RPAREN PT_RETURNS PT_LPAREN messageType PT_RPAREN",
 /*  34 */ "rpcDecl ::= PT_RPC rpcName PT_LPAREN PT_STREAM messageType PT_RPAREN PT_RETURNS PT_LPAREN messageType PT_RPAREN",
 /*  35 */ "rpcDecl ::= PT_RPC rpcName PT_LPAREN messageType PT_RPAREN PT_RETURNS PT_LPAREN PT_STREAM messageType PT_RPAREN",
 /*  36 */ "rpcDecl ::= PT_RPC rpcName PT_LPAREN PT_STREAM messageType PT_RPAREN PT_RETURNS PT_LPAREN PT_STREAM messageType PT_RPAREN",
 /*  37 */ "streamDecl ::= PT_STREAM streamName PT_LPAREN messageType PT_COMMA messageType PT_RPAREN",
 /*  38 */ "field ::= type fieldName PT_ASSIGN fieldNumber PT_SEMICOLON",
 /*  39 */ "field ::= type fieldName PT_ASSIGN fieldNumber PT_LBRACKET fieldOptions PT_RBRACKET PT_SEMICOLON",
 /*  40 */ "field ::= label type fieldName PT_ASSIGN fieldNumber PT_SEMICOLON",
 /*  41 */ "field ::= label type fieldName PT_ASSIGN fieldNumber PT_LBRACKET fieldOptions PT_RBRACKET PT_SEMICOLON",
 /*  42 */ "label ::= PT_REQUIRED",
 /*  43 */ "label ::= PT_OPTIONAL",
 /*  44 */ "label ::= PT_REPEATED",
 /*  45 */ "type ::= exIdent",
 /*  46 */ "fieldNumber ::= intLit",
 /*  47 */ "fieldNumber ::= PT_PLUS intLit",
 /*  48 */ "fieldOptions ::= fieldOption",
 /*  49 */ "fieldOptions ::= fieldOptions PT_COMMA fieldOption",
 /*  50 */ "fieldOption ::= optionName PT_ASSIGN constant",
 /*  51 */ "fieldOption ::= optionName PT_ASSIGN customOptionValue",
 /*  52 */ "group ::= PT_GROUP groupName PT_ASSIGN fieldNumber PT_LCURLY messageBody PT_RCURLY",
 /*  53 */ "group ::= label PT_GROUP groupName PT_ASSIGN fieldNumber PT_LCURLY messageBody PT_RCURLY",
 /*  54 */ "oneof ::= PT_ONEOF oneofName PT_LCURLY oneofBody PT_RCURLY",
 /*  55 */ "oneofBody ::=",
 /*  56 */ "oneofBody ::= oneofBody oneofField",
 /*  57 */ "oneofField ::= type fieldName PT_ASSIGN fieldNumber PT_LBRACKET fieldOptions PT_RBRACKET PT_SEMICOLON",
 /*  58 */ "oneofField ::= type fieldName PT_ASSIGN fieldNumber PT_SEMICOLON",
 /*  59 */ "mapField ::= PT_MAP PT_LESS keyType PT_COMMA type PT_GREATER mapName PT_ASSIGN fieldNumber PT_LBRACKET fieldOptions PT_RBRACKET PT_SEMICOLON",
 /*  60 */ "mapField ::= PT_MAP PT_LESS keyType PT_COMMA type PT_GREATER mapName PT_ASSIGN fieldNumber PT_SEMICOLON",
 /*  61 */ "keyType ::= exIdent",
 /*  62 */ "extend ::= PT_EXTEND messageType PT_LCURLY extendBody PT_RCURLY",
 /*  63 */ "extendBody ::=",
 /*  64 */ "extendBody ::= extendBody field",
 /*  65 */ "extendBody ::= extendBody group",
 /*  66 */ "messageType ::= exIdent",
 /*  67 */ "intLit ::= PT_DECIMALLIT",
 /*  68 */ "intLit ::= PT_OCTALLIT",
 /*  69 */ "intLit ::= PT_HEXLIT",
 /*  70 */ "constant ::= exIdent",
 /*  71 */ "constant ::= intLit",
 /*  72 */ "constant ::= PT_PLUS intLit",
 /*  73 */ "constant ::= PT_MINUS intLit",
 /*  74 */ "constant ::= PT_PLUS exIdent",
 /*  75 */ "constant ::= PT_MINUS exIdent",
 /*  76 */ "strLit ::= PT_STRLIT",
 /*  77 */ "strLit ::= strLit PT_STRLIT",
 /*  78 */ "proto ::= wholeProtoBody",
 /*  79 */ "proto ::= syntax wholeProtoBody",
 /*  80 */ "proto ::= edition wholeProtoBody",
 /*  81 */ "protoBody ::= protoBody import",
 /*  82 */ "protoBody ::= protoBody package",
 /*  83 */ "protoBody ::= protoBody option",
 /*  84 */ "protoBody ::= protoBody emptyStatement",
 /*  85 */ "option ::= PT_OPTION optionName PT_ASSIGN constant PT_SEMICOLON",
 /*  86 */ "option ::= PT_OPTION optionName PT_ASSIGN customOptionValue PT_SEMICOLON",
 /*  87 */ "optionName ::= exIdent",
 /*  88 */ "optionName ::= extIdentInParentheses",
 /*  89 */ "customOptionValue ::= PT_LCURLY customOptionBody PT_RCURLY",
 /*  90 */ "customOptionBody ::=",
 /*  91 */ "customOptionBody ::= customOptionBody exIdent",
 /*  92 */ "customOptionBody ::= customOptionBody PT_STRLIT",
 /*  93 */ "customOptionBody ::= customOptionBody symbolsWithoutCurly",
 /*  94 */ "customOptionBody ::= customOptionBody intLit",
 /*  95 */ "customOptionBody ::= customOptionBody customOptionValue",
 /*  96 */ "symbolsWithoutCurly ::= PT_LPAREN",
 /*  97 */ "symbolsWithoutCurly ::= PT_RPAREN",
 /*  98 */ "symbolsWithoutCurly ::= PT_LBRACKET",
 /*  99 */ "symbolsWithoutCurly ::= PT_RBRACKET",
 /* 100 */ "symbolsWithoutCurly ::= PT_EQUAL",
 /* 101 */ "symbolsWithoutCurly ::= PT_NOTEQUAL",
 /* 102 */ "symbolsWithoutCurly ::= PT_NOTEQUAL2",
 /* 103 */ "symbolsWithoutCurly ::= PT_GEQUAL",
 /* 104 */ "symbolsWithoutCurly ::= PT_LEQUAL",
 /* 105 */ "symbolsWithoutCurly ::= PT_ASSIGN_PLUS",
 /* 106 */ "symbolsWithoutCurly ::= PT_ASSIGN",
 /* 107 */ "symbolsWithoutCurly ::= PT_PLUS",
 /* 108 */ "symbolsWithoutCurly ::= PT_MINUS",
 /* 109 */ "symbolsWithoutCurly ::= PT_MULTIPLY",
 /* 110 */ "symbolsWithoutCurly ::= PT_DIV",
 /* 111 */ "symbolsWithoutCurly ::= PT_LOGIC_OR",
 /* 112 */ "symbolsWithoutCurly ::= PT_OR",
 /* 113 */ "symbolsWithoutCurly ::= PT_LOGIC_AND",
 /* 114 */ "symbolsWithoutCurly ::= PT_AND",
 /* 115 */ "symbolsWithoutCurly ::= PT_NOT",
 /* 116 */ "symbolsWithoutCurly ::= PT_NEG",
 /* 117 */ "symbolsWithoutCurly ::= PT_XOR",
 /* 118 */ "symbolsWithoutCurly ::= PT_SHL",
 /* 119 */ "symbolsWithoutCurly ::= PT_SHR",
 /* 120 */ "symbolsWithoutCurly ::= PT_PERCENT",
 /* 121 */ "symbolsWithoutCurly ::= PT_DOLLAR",
 /* 122 */ "symbolsWithoutCurly ::= PT_COND",
 /* 123 */ "symbolsWithoutCurly ::= PT_SEMICOLON",
 /* 124 */ "symbolsWithoutCurly ::= PT_DOT",
 /* 125 */ "symbolsWithoutCurly ::= PT_COMMA",
 /* 126 */ "symbolsWithoutCurly ::= PT_COLON",
 /* 127 */ "symbolsWithoutCurly ::= PT_LESS",
 /* 128 */ "symbolsWithoutCurly ::= PT_GREATER",
 /* 129 */ "topLevelDef ::= message",
 /* 130 */ "topLevelDef ::= enum",
 /* 131 */ "topLevelDef ::= extend",
 /* 132 */ "topLevelDef ::= service",
 /* 133 */ "messageBody ::= messageBody extend",
 /* 134 */ "messageBody ::= messageBody extensions",
 /* 135 */ "messageBody ::= messageBody option",
 /* 136 */ "messageBody ::= messageBody reserved",
 /* 137 */ "messageBody ::= messageBody emptyStatement",
 /* 138 */ "enumBody ::= enumBody reserved",
 /* 139 */ "enumBody ::= enumBody option",
 /* 140 */ "enumBody ::= enumBody emptyStatement",
 /* 141 */ "enumValueOptions ::= enumValueOption",
 /* 142 */ "enumValueOptions ::= enumValueOptions PT_COMMA enumValueOption",
 /* 143 */ "enumValueOption ::= optionName PT_ASSIGN constant",
 /* 144 */ "enumValueOption ::= optionName PT_ASSIGN customOptionValue",
 /* 145 */ "serviceBody ::= serviceBody option",
 /* 146 */ "serviceBody ::= serviceBody emptyStatement",
 /* 147 */ "rpc ::= rpcDecl PT_SEMICOLON",
 /* 148 */ "rpc ::= rpcDecl PT_LCURLY rpcBody PT_RCURLY",
 /* 149 */ "rpcBody ::=",
 /* 150 */ "rpcBody ::= rpcBody option",
 /* 151 */ "rpcBody ::= rpcBody emptyStatement",
 /* 152 */ "stream ::= streamDecl PT_SEMICOLON",
 /* 153 */ "stream ::= streamDecl PT_LCURLY streamBody PT_RCURLY",
 /* 154 */ "streamBody ::=",
 /* 155 */ "streamBody ::= streamBody option",
 /* 156 */ "streamBody ::= streamBody emptyStatement",
 /* 157 */ "groupName ::= exIdent",
 /* 158 */ "oneofBody ::= oneofBody option",
 /* 159 */ "oneofBody ::= oneofBody group",
 /* 160 */ "oneofBody ::= oneofBody emptyStatement",
 /* 161 */ "extensions ::= PT_EXTENSIONS ranges PT_SEMICOLON",
 /* 162 */ "extensions ::= PT_EXTENSIONS ranges PT_LBRACKET declarations PT_RBRACKET PT_SEMICOLON",
 /* 163 */ "declarations ::= declaration",
 /* 164 */ "declarations ::= declarations PT_COMMA declaration",
 /* 165 */ "declaration ::= optionName PT_ASSIGN constant",
 /* 166 */ "declaration ::= optionName PT_ASSIGN customOptionValue",
 /* 167 */ "reserved ::= PT_RESERVED ranges PT_SEMICOLON",
 /* 168 */ "reserved ::= PT_RESERVED quoteFieldNames PT_SEMICOLON",
 /* 169 */ "reserved ::= PT_RESERVED reservedIdent PT_SEMICOLON",
 /* 170 */ "ranges ::= range",
 /* 171 */ "ranges ::= ranges PT_COMMA range",
 /* 172 */ "range ::= intLit",
 /* 173 */ "range ::= intLit PT_TO intLit",
 /* 174 */ "range ::= intLit PT_TO exIdent",
 /* 175 */ "quoteFieldNames ::= strLit",
 /* 176 */ "quoteFieldNames ::= quoteFieldNames PT_COMMA strLit",
 /* 177 */ "reservedIdent ::= fieldName",
 /* 178 */ "reservedIdent ::= fieldName PT_COMMA fieldName",
 /* 179 */ "extendBody ::= extendBody emptyStatement",
 /* 180 */ "messageName ::= exIdent",
 /* 181 */ "enumName ::= exIdent",
 /* 182 */ "streamName ::= exIdent",
 /* 183 */ "fieldName ::= exIdent",
 /* 184 */ "oneofName ::= exIdent",
 /* 185 */ "mapName ::= exIdent",
 /* 186 */ "serviceName ::= exIdent",
 /* 187 */ "rpcName ::= exIdent",
 /* 188 */ "emptyStatement ::= PT_SEMICOLON",
 /* 189 */ "constant ::= strLit",
 /* 190 */ "exIdent ::= PT_IDENT",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0;
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ProtobufLangParserAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ProtobufLangParserInit(void *yypRawParser ProtobufLangParserCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ProtobufLangParserCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef ProtobufLangParser_ENGINEALWAYSONSTACK
/*
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to ProtobufLangParser and ProtobufLangParserFree.
*/
void *ProtobufLangParserAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ProtobufLangParserCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ProtobufLangParserCTX_STORE
    ProtobufLangParserInit(yypParser ProtobufLangParserCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* ProtobufLangParser_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ProtobufLangParserARG_FETCH
  ProtobufLangParserCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* TERMINAL Destructor */
    case 1: /* PT_IDENT */
    case 2: /* PT_SYNTAX */
    case 3: /* PT_EDITION */
    case 4: /* PT_IMPORT */
    case 5: /* PT_WEAK */
    case 6: /* PT_PUBLIC */
    case 7: /* PT_PACKAGE */
    case 8: /* PT_OPTION */
    case 9: /* PT_REQUIRED */
    case 10: /* PT_OPTIONAL */
    case 11: /* PT_REPEATED */
    case 12: /* PT_ONEOF */
    case 13: /* PT_MAP */
    case 14: /* PT_RESERVED */
    case 15: /* PT_ENUM */
    case 16: /* PT_GROUP */
    case 17: /* PT_EXTEND */
    case 18: /* PT_EXTENSIONS */
    case 19: /* PT_MESSAGE */
    case 20: /* PT_SERVICE */
    case 21: /* PT_RPC */
    case 22: /* PT_STREAM */
    case 23: /* PT_RETURNS */
    case 24: /* PT_TO */
    case 25: /* PT_ASSIGN */
    case 26: /* PT_SEMICOLON */
    case 27: /* PT_LPAREN */
    case 28: /* PT_RPAREN */
    case 29: /* PT_DOT */
    case 30: /* PT_LCURLY */
    case 31: /* PT_RCURLY */
    case 32: /* PT_STRLIT */
    case 33: /* PT_LBRACKET */
    case 34: /* PT_RBRACKET */
    case 35: /* PT_EQUAL */
    case 36: /* PT_NOTEQUAL */
    case 37: /* PT_NOTEQUAL2 */
    case 38: /* PT_GEQUAL */
    case 39: /* PT_LEQUAL */
    case 40: /* PT_ASSIGN_PLUS */
    case 41: /* PT_PLUS */
    case 42: /* PT_MINUS */
    case 43: /* PT_MULTIPLY */
    case 44: /* PT_DIV */
    case 45: /* PT_LOGIC_OR */
    case 46: /* PT_OR */
    case 47: /* PT_LOGIC_AND */
    case 48: /* PT_AND */
    case 49: /* PT_NOT */
    case 50: /* PT_NEG */
    case 51: /* PT_XOR */
    case 52: /* PT_SHL */
    case 53: /* PT_SHR */
    case 54: /* PT_PERCENT */
    case 55: /* PT_DOLLAR */
    case 56: /* PT_COND */
    case 57: /* PT_COMMA */
    case 58: /* PT_COLON */
    case 59: /* PT_LESS */
    case 60: /* PT_GREATER */
    case 61: /* PT_DECIMALLIT */
    case 62: /* PT_OCTALLIT */
    case 63: /* PT_HEXLIT */
{
#line 66 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"

    /* We manage memory allocated for token values by ourself */
    (void) state; /* Mark unused, similar to Q_UNUSED */
    (void) (yypminor->yy0); /* Mark unused, similar to Q_UNUSED */

#line 1178 "./protobuf_lang_parser.c"
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ProtobufLangParserFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef ProtobufLangParser_ENGINEALWAYSONSTACK
/*
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ProtobufLangParserFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ProtobufLangParserFinalize(p);
  (*freeProc)(p);
}
#endif /* ProtobufLangParser_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ProtobufLangParserStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ProtobufLangParserCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    assert( i<=YY_ACTTAB_COUNT );
    assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD );
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    assert( i<(int)YY_NLOOKAHEAD );
    if( yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      assert( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0]) );
      iFallback = yyFallback[iLookAhead];
      if( iFallback!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        assert( j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) );
        if( yy_lookahead[j]==YYWILDCARD && iLookAhead>0 ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      assert( i>=0 && i<(int)(sizeof(yy_action)/sizeof(yy_action[0])) );
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ProtobufLangParserARG_FETCH
   ProtobufLangParserCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ProtobufLangParserARG_STORE /* Suppress warning about unused %extra_argument var */
   ProtobufLangParserCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ProtobufLangParserTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* For rule J, yyRuleInfoLhs[J] contains the symbol on the left-hand side
** of that rule */
static const YYCODETYPE yyRuleInfoLhs[] = {
   108,  /* (0) wholeProtoBody ::= protoBody */
   109,  /* (1) syntax ::= PT_SYNTAX PT_ASSIGN strLit PT_SEMICOLON */
   110,  /* (2) edition ::= PT_EDITION PT_ASSIGN strLit PT_SEMICOLON */
    81,  /* (3) protoBody ::= */
    81,  /* (4) protoBody ::= protoBody topLevelDef */
   111,  /* (5) import ::= PT_IMPORT strLit PT_SEMICOLON */
   111,  /* (6) import ::= PT_IMPORT PT_PUBLIC strLit PT_SEMICOLON */
   111,  /* (7) import ::= PT_IMPORT PT_WEAK strLit PT_SEMICOLON */
   112,  /* (8) package ::= PT_PACKAGE exIdent PT_SEMICOLON */
   116,  /* (9) extIdentInParentheses ::= PT_LPAREN exIdent PT_RPAREN */
    71,  /* (10) optionName ::= optionName exIdent */
    71,  /* (11) optionName ::= optionName PT_DOT extIdentInParentheses */
    71,  /* (12) optionName ::= optionName extIdentInParentheses */
    83,  /* (13) message ::= PT_MESSAGE messageName PT_LCURLY messageBody PT_RCURLY */
    84,  /* (14) messageBody ::= */
    84,  /* (15) messageBody ::= messageBody field */
    84,  /* (16) messageBody ::= messageBody enum */
    84,  /* (17) messageBody ::= messageBody message */
    84,  /* (18) messageBody ::= messageBody group */
    84,  /* (19) messageBody ::= messageBody oneof */
    84,  /* (20) messageBody ::= messageBody mapField */
    89,  /* (21) enum ::= PT_ENUM enumName PT_LCURLY enumBody PT_RCURLY */
    90,  /* (22) enumBody ::= */
    90,  /* (23) enumBody ::= enumBody enumField */
    91,  /* (24) enumField ::= exIdent PT_ASSIGN enumNumber PT_LBRACKET enumValueOptions PT_RBRACKET PT_SEMICOLON */
    91,  /* (25) enumField ::= exIdent PT_ASSIGN enumNumber */
   106,  /* (26) enumNumber ::= intLit */
   106,  /* (27) enumNumber ::= PT_PLUS intLit */
   106,  /* (28) enumNumber ::= PT_MINUS intLit */
    92,  /* (29) service ::= PT_SERVICE serviceName PT_LCURLY serviceBody PT_RCURLY */
    93,  /* (30) serviceBody ::= */
    93,  /* (31) serviceBody ::= serviceBody rpc */
    93,  /* (32) serviceBody ::= serviceBody stream */
    86,  /* (33) rpcDecl ::= PT_RPC rpcName PT_LPAREN messageType PT_RPAREN PT_RETURNS PT_LPAREN messageType PT_RPAREN */
    86,  /* (34) rpcDecl ::= PT_RPC rpcName PT_LPAREN PT_STREAM messageType PT_RPAREN PT_RETURNS PT_LPAREN messageType PT_RPAREN */
    86,  /* (35) rpcDecl ::= PT_RPC rpcName PT_LPAREN messageType PT_RPAREN PT_RETURNS PT_LPAREN PT_STREAM messageType PT_RPAREN */
    86,  /* (36) rpcDecl ::= PT_RPC rpcName PT_LPAREN PT_STREAM messageType PT_RPAREN PT_RETURNS PT_LPAREN PT_STREAM messageType PT_RPAREN */
    95,  /* (37) streamDecl ::= PT_STREAM streamName PT_LPAREN messageType PT_COMMA messageType PT_RPAREN */
    87,  /* (38) field ::= type fieldName PT_ASSIGN fieldNumber PT_SEMICOLON */
    87,  /* (39) field ::= type fieldName PT_ASSIGN fieldNumber PT_LBRACKET fieldOptions PT_RBRACKET PT_SEMICOLON */
    87,  /* (40) field ::= label type fieldName PT_ASSIGN fieldNumber PT_SEMICOLON */
    87,  /* (41) field ::= label type fieldName PT_ASSIGN fieldNumber PT_LBRACKET fieldOptions PT_RBRACKET PT_SEMICOLON */
    65,  /* (42) label ::= PT_REQUIRED */
    65,  /* (43) label ::= PT_OPTIONAL */
    65,  /* (44) label ::= PT_REPEATED */
    66,  /* (45) type ::= exIdent */
   105,  /* (46) fieldNumber ::= intLit */
   105,  /* (47) fieldNumber ::= PT_PLUS intLit */
    96,  /* (48) fieldOptions ::= fieldOption */
    96,  /* (49) fieldOptions ::= fieldOptions PT_COMMA fieldOption */
    97,  /* (50) fieldOption ::= optionName PT_ASSIGN constant */
    97,  /* (51) fieldOption ::= optionName PT_ASSIGN customOptionValue */
   101,  /* (52) group ::= PT_GROUP groupName PT_ASSIGN fieldNumber PT_LCURLY messageBody PT_RCURLY */
   101,  /* (53) group ::= label PT_GROUP groupName PT_ASSIGN fieldNumber PT_LCURLY messageBody PT_RCURLY */
    98,  /* (54) oneof ::= PT_ONEOF oneofName PT_LCURLY oneofBody PT_RCURLY */
    99,  /* (55) oneofBody ::= */
    99,  /* (56) oneofBody ::= oneofBody oneofField */
    88,  /* (57) oneofField ::= type fieldName PT_ASSIGN fieldNumber PT_LBRACKET fieldOptions PT_RBRACKET PT_SEMICOLON */
    88,  /* (58) oneofField ::= type fieldName PT_ASSIGN fieldNumber PT_SEMICOLON */
   100,  /* (59) mapField ::= PT_MAP PT_LESS keyType PT_COMMA type PT_GREATER mapName PT_ASSIGN fieldNumber PT_LBRACKET fieldOptions PT_RBRACKET PT_SEMICOLON */
   100,  /* (60) mapField ::= PT_MAP PT_LESS keyType PT_COMMA type PT_GREATER mapName PT_ASSIGN fieldNumber PT_SEMICOLON */
    67,  /* (61) keyType ::= exIdent */
   102,  /* (62) extend ::= PT_EXTEND messageType PT_LCURLY extendBody PT_RCURLY */
   103,  /* (63) extendBody ::= */
   103,  /* (64) extendBody ::= extendBody field */
   103,  /* (65) extendBody ::= extendBody group */
    68,  /* (66) messageType ::= exIdent */
   104,  /* (67) intLit ::= PT_DECIMALLIT */
   104,  /* (68) intLit ::= PT_OCTALLIT */
   104,  /* (69) intLit ::= PT_HEXLIT */
    69,  /* (70) constant ::= exIdent */
    69,  /* (71) constant ::= intLit */
    69,  /* (72) constant ::= PT_PLUS intLit */
    69,  /* (73) constant ::= PT_MINUS intLit */
    69,  /* (74) constant ::= PT_PLUS exIdent */
    69,  /* (75) constant ::= PT_MINUS exIdent */
    64,  /* (76) strLit ::= PT_STRLIT */
    64,  /* (77) strLit ::= strLit PT_STRLIT */
   107,  /* (78) proto ::= wholeProtoBody */
   107,  /* (79) proto ::= syntax wholeProtoBody */
   107,  /* (80) proto ::= edition wholeProtoBody */
    81,  /* (81) protoBody ::= protoBody import */
    81,  /* (82) protoBody ::= protoBody package */
    81,  /* (83) protoBody ::= protoBody option */
    81,  /* (84) protoBody ::= protoBody emptyStatement */
   113,  /* (85) option ::= PT_OPTION optionName PT_ASSIGN constant PT_SEMICOLON */
   113,  /* (86) option ::= PT_OPTION optionName PT_ASSIGN customOptionValue PT_SEMICOLON */
    71,  /* (87) optionName ::= exIdent */
    71,  /* (88) optionName ::= extIdentInParentheses */
   115,  /* (89) customOptionValue ::= PT_LCURLY customOptionBody PT_RCURLY */
   117,  /* (90) customOptionBody ::= */
   117,  /* (91) customOptionBody ::= customOptionBody exIdent */
   117,  /* (92) customOptionBody ::= customOptionBody PT_STRLIT */
   117,  /* (93) customOptionBody ::= customOptionBody symbolsWithoutCurly */
   117,  /* (94) customOptionBody ::= customOptionBody intLit */
   117,  /* (95) customOptionBody ::= customOptionBody customOptionValue */
   118,  /* (96) symbolsWithoutCurly ::= PT_LPAREN */
   118,  /* (97) symbolsWithoutCurly ::= PT_RPAREN */
   118,  /* (98) symbolsWithoutCurly ::= PT_LBRACKET */
   118,  /* (99) symbolsWithoutCurly ::= PT_RBRACKET */
   118,  /* (100) symbolsWithoutCurly ::= PT_EQUAL */
   118,  /* (101) symbolsWithoutCurly ::= PT_NOTEQUAL */
   118,  /* (102) symbolsWithoutCurly ::= PT_NOTEQUAL2 */
   118,  /* (103) symbolsWithoutCurly ::= PT_GEQUAL */
   118,  /* (104) symbolsWithoutCurly ::= PT_LEQUAL */
   118,  /* (105) symbolsWithoutCurly ::= PT_ASSIGN_PLUS */
   118,  /* (106) symbolsWithoutCurly ::= PT_ASSIGN */
   118,  /* (107) symbolsWithoutCurly ::= PT_PLUS */
   118,  /* (108) symbolsWithoutCurly ::= PT_MINUS */
   118,  /* (109) symbolsWithoutCurly ::= PT_MULTIPLY */
   118,  /* (110) symbolsWithoutCurly ::= PT_DIV */
   118,  /* (111) symbolsWithoutCurly ::= PT_LOGIC_OR */
   118,  /* (112) symbolsWithoutCurly ::= PT_OR */
   118,  /* (113) symbolsWithoutCurly ::= PT_LOGIC_AND */
   118,  /* (114) symbolsWithoutCurly ::= PT_AND */
   118,  /* (115) symbolsWithoutCurly ::= PT_NOT */
   118,  /* (116) symbolsWithoutCurly ::= PT_NEG */
   118,  /* (117) symbolsWithoutCurly ::= PT_XOR */
   118,  /* (118) symbolsWithoutCurly ::= PT_SHL */
   118,  /* (119) symbolsWithoutCurly ::= PT_SHR */
   118,  /* (120) symbolsWithoutCurly ::= PT_PERCENT */
   118,  /* (121) symbolsWithoutCurly ::= PT_DOLLAR */
   118,  /* (122) symbolsWithoutCurly ::= PT_COND */
   118,  /* (123) symbolsWithoutCurly ::= PT_SEMICOLON */
   118,  /* (124) symbolsWithoutCurly ::= PT_DOT */
   118,  /* (125) symbolsWithoutCurly ::= PT_COMMA */
   118,  /* (126) symbolsWithoutCurly ::= PT_COLON */
   118,  /* (127) symbolsWithoutCurly ::= PT_LESS */
   118,  /* (128) symbolsWithoutCurly ::= PT_GREATER */
    82,  /* (129) topLevelDef ::= message */
    82,  /* (130) topLevelDef ::= enum */
    82,  /* (131) topLevelDef ::= extend */
    82,  /* (132) topLevelDef ::= service */
    84,  /* (133) messageBody ::= messageBody extend */
    84,  /* (134) messageBody ::= messageBody extensions */
    84,  /* (135) messageBody ::= messageBody option */
    84,  /* (136) messageBody ::= messageBody reserved */
    84,  /* (137) messageBody ::= messageBody emptyStatement */
    90,  /* (138) enumBody ::= enumBody reserved */
    90,  /* (139) enumBody ::= enumBody option */
    90,  /* (140) enumBody ::= enumBody emptyStatement */
   121,  /* (141) enumValueOptions ::= enumValueOption */
   121,  /* (142) enumValueOptions ::= enumValueOptions PT_COMMA enumValueOption */
   122,  /* (143) enumValueOption ::= optionName PT_ASSIGN constant */
   122,  /* (144) enumValueOption ::= optionName PT_ASSIGN customOptionValue */
    93,  /* (145) serviceBody ::= serviceBody option */
    93,  /* (146) serviceBody ::= serviceBody emptyStatement */
    85,  /* (147) rpc ::= rpcDecl PT_SEMICOLON */
    85,  /* (148) rpc ::= rpcDecl PT_LCURLY rpcBody PT_RCURLY */
   123,  /* (149) rpcBody ::= */
   123,  /* (150) rpcBody ::= rpcBody option */
   123,  /* (151) rpcBody ::= rpcBody emptyStatement */
    94,  /* (152) stream ::= streamDecl PT_SEMICOLON */
    94,  /* (153) stream ::= streamDecl PT_LCURLY streamBody PT_RCURLY */
   124,  /* (154) streamBody ::= */
   124,  /* (155) streamBody ::= streamBody option */
   124,  /* (156) streamBody ::= streamBody emptyStatement */
    80,  /* (157) groupName ::= exIdent */
    99,  /* (158) oneofBody ::= oneofBody option */
    99,  /* (159) oneofBody ::= oneofBody group */
    99,  /* (160) oneofBody ::= oneofBody emptyStatement */
   119,  /* (161) extensions ::= PT_EXTENSIONS ranges PT_SEMICOLON */
   119,  /* (162) extensions ::= PT_EXTENSIONS ranges PT_LBRACKET declarations PT_RBRACKET PT_SEMICOLON */
   126,  /* (163) declarations ::= declaration */
   126,  /* (164) declarations ::= declarations PT_COMMA declaration */
   127,  /* (165) declaration ::= optionName PT_ASSIGN constant */
   127,  /* (166) declaration ::= optionName PT_ASSIGN customOptionValue */
   120,  /* (167) reserved ::= PT_RESERVED ranges PT_SEMICOLON */
   120,  /* (168) reserved ::= PT_RESERVED quoteFieldNames PT_SEMICOLON */
   120,  /* (169) reserved ::= PT_RESERVED reservedIdent PT_SEMICOLON */
   125,  /* (170) ranges ::= range */
   125,  /* (171) ranges ::= ranges PT_COMMA range */
   130,  /* (172) range ::= intLit */
   130,  /* (173) range ::= intLit PT_TO intLit */
   130,  /* (174) range ::= intLit PT_TO exIdent */
   128,  /* (175) quoteFieldNames ::= strLit */
   128,  /* (176) quoteFieldNames ::= quoteFieldNames PT_COMMA strLit */
   129,  /* (177) reservedIdent ::= fieldName */
   129,  /* (178) reservedIdent ::= fieldName PT_COMMA fieldName */
   103,  /* (179) extendBody ::= extendBody emptyStatement */
    72,  /* (180) messageName ::= exIdent */
    73,  /* (181) enumName ::= exIdent */
    74,  /* (182) streamName ::= exIdent */
    75,  /* (183) fieldName ::= exIdent */
    76,  /* (184) oneofName ::= exIdent */
    77,  /* (185) mapName ::= exIdent */
    78,  /* (186) serviceName ::= exIdent */
    79,  /* (187) rpcName ::= exIdent */
   114,  /* (188) emptyStatement ::= PT_SEMICOLON */
    69,  /* (189) constant ::= strLit */
    70,  /* (190) exIdent ::= PT_IDENT */
};

/* For rule J, yyRuleInfoNRhs[J] contains the negative of the number
** of symbols on the right-hand side of that rule. */
static const signed char yyRuleInfoNRhs[] = {
   -1,  /* (0) wholeProtoBody ::= protoBody */
   -4,  /* (1) syntax ::= PT_SYNTAX PT_ASSIGN strLit PT_SEMICOLON */
   -4,  /* (2) edition ::= PT_EDITION PT_ASSIGN strLit PT_SEMICOLON */
    0,  /* (3) protoBody ::= */
   -2,  /* (4) protoBody ::= protoBody topLevelDef */
   -3,  /* (5) import ::= PT_IMPORT strLit PT_SEMICOLON */
   -4,  /* (6) import ::= PT_IMPORT PT_PUBLIC strLit PT_SEMICOLON */
   -4,  /* (7) import ::= PT_IMPORT PT_WEAK strLit PT_SEMICOLON */
   -3,  /* (8) package ::= PT_PACKAGE exIdent PT_SEMICOLON */
   -3,  /* (9) extIdentInParentheses ::= PT_LPAREN exIdent PT_RPAREN */
   -2,  /* (10) optionName ::= optionName exIdent */
   -3,  /* (11) optionName ::= optionName PT_DOT extIdentInParentheses */
   -2,  /* (12) optionName ::= optionName extIdentInParentheses */
   -5,  /* (13) message ::= PT_MESSAGE messageName PT_LCURLY messageBody PT_RCURLY */
    0,  /* (14) messageBody ::= */
   -2,  /* (15) messageBody ::= messageBody field */
   -2,  /* (16) messageBody ::= messageBody enum */
   -2,  /* (17) messageBody ::= messageBody message */
   -2,  /* (18) messageBody ::= messageBody group */
   -2,  /* (19) messageBody ::= messageBody oneof */
   -2,  /* (20) messageBody ::= messageBody mapField */
   -5,  /* (21) enum ::= PT_ENUM enumName PT_LCURLY enumBody PT_RCURLY */
    0,  /* (22) enumBody ::= */
   -2,  /* (23) enumBody ::= enumBody enumField */
   -7,  /* (24) enumField ::= exIdent PT_ASSIGN enumNumber PT_LBRACKET enumValueOptions PT_RBRACKET PT_SEMICOLON */
   -3,  /* (25) enumField ::= exIdent PT_ASSIGN enumNumber */
   -1,  /* (26) enumNumber ::= intLit */
   -2,  /* (27) enumNumber ::= PT_PLUS intLit */
   -2,  /* (28) enumNumber ::= PT_MINUS intLit */
   -5,  /* (29) service ::= PT_SERVICE serviceName PT_LCURLY serviceBody PT_RCURLY */
    0,  /* (30) serviceBody ::= */
   -2,  /* (31) serviceBody ::= serviceBody rpc */
   -2,  /* (32) serviceBody ::= serviceBody stream */
   -9,  /* (33) rpcDecl ::= PT_RPC rpcName PT_LPAREN messageType PT_RPAREN PT_RETURNS PT_LPAREN messageType PT_RPAREN */
  -10,  /* (34) rpcDecl ::= PT_RPC rpcName PT_LPAREN PT_STREAM messageType PT_RPAREN PT_RETURNS PT_LPAREN messageType PT_RPAREN */
  -10,  /* (35) rpcDecl ::= PT_RPC rpcName PT_LPAREN messageType PT_RPAREN PT_RETURNS PT_LPAREN PT_STREAM messageType PT_RPAREN */
  -11,  /* (36) rpcDecl ::= PT_RPC rpcName PT_LPAREN PT_STREAM messageType PT_RPAREN PT_RETURNS PT_LPAREN PT_STREAM messageType PT_RPAREN */
   -7,  /* (37) streamDecl ::= PT_STREAM streamName PT_LPAREN messageType PT_COMMA messageType PT_RPAREN */
   -5,  /* (38) field ::= type fieldName PT_ASSIGN fieldNumber PT_SEMICOLON */
   -8,  /* (39) field ::= type fieldName PT_ASSIGN fieldNumber PT_LBRACKET fieldOptions PT_RBRACKET PT_SEMICOLON */
   -6,  /* (40) field ::= label type fieldName PT_ASSIGN fieldNumber PT_SEMICOLON */
   -9,  /* (41) field ::= label type fieldName PT_ASSIGN fieldNumber PT_LBRACKET fieldOptions PT_RBRACKET PT_SEMICOLON */
   -1,  /* (42) label ::= PT_REQUIRED */
   -1,  /* (43) label ::= PT_OPTIONAL */
   -1,  /* (44) label ::= PT_REPEATED */
   -1,  /* (45) type ::= exIdent */
   -1,  /* (46) fieldNumber ::= intLit */
   -2,  /* (47) fieldNumber ::= PT_PLUS intLit */
   -1,  /* (48) fieldOptions ::= fieldOption */
   -3,  /* (49) fieldOptions ::= fieldOptions PT_COMMA fieldOption */
   -3,  /* (50) fieldOption ::= optionName PT_ASSIGN constant */
   -3,  /* (51) fieldOption ::= optionName PT_ASSIGN customOptionValue */
   -7,  /* (52) group ::= PT_GROUP groupName PT_ASSIGN fieldNumber PT_LCURLY messageBody PT_RCURLY */
   -8,  /* (53) group ::= label PT_GROUP groupName PT_ASSIGN fieldNumber PT_LCURLY messageBody PT_RCURLY */
   -5,  /* (54) oneof ::= PT_ONEOF oneofName PT_LCURLY oneofBody PT_RCURLY */
    0,  /* (55) oneofBody ::= */
   -2,  /* (56) oneofBody ::= oneofBody oneofField */
   -8,  /* (57) oneofField ::= type fieldName PT_ASSIGN fieldNumber PT_LBRACKET fieldOptions PT_RBRACKET PT_SEMICOLON */
   -5,  /* (58) oneofField ::= type fieldName PT_ASSIGN fieldNumber PT_SEMICOLON */
  -13,  /* (59) mapField ::= PT_MAP PT_LESS keyType PT_COMMA type PT_GREATER mapName PT_ASSIGN fieldNumber PT_LBRACKET fieldOptions PT_RBRACKET PT_SEMICOLON */
  -10,  /* (60) mapField ::= PT_MAP PT_LESS keyType PT_COMMA type PT_GREATER mapName PT_ASSIGN fieldNumber PT_SEMICOLON */
   -1,  /* (61) keyType ::= exIdent */
   -5,  /* (62) extend ::= PT_EXTEND messageType PT_LCURLY extendBody PT_RCURLY */
    0,  /* (63) extendBody ::= */
   -2,  /* (64) extendBody ::= extendBody field */
   -2,  /* (65) extendBody ::= extendBody group */
   -1,  /* (66) messageType ::= exIdent */
   -1,  /* (67) intLit ::= PT_DECIMALLIT */
   -1,  /* (68) intLit ::= PT_OCTALLIT */
   -1,  /* (69) intLit ::= PT_HEXLIT */
   -1,  /* (70) constant ::= exIdent */
   -1,  /* (71) constant ::= intLit */
   -2,  /* (72) constant ::= PT_PLUS intLit */
   -2,  /* (73) constant ::= PT_MINUS intLit */
   -2,  /* (74) constant ::= PT_PLUS exIdent */
   -2,  /* (75) constant ::= PT_MINUS exIdent */
   -1,  /* (76) strLit ::= PT_STRLIT */
   -2,  /* (77) strLit ::= strLit PT_STRLIT */
   -1,  /* (78) proto ::= wholeProtoBody */
   -2,  /* (79) proto ::= syntax wholeProtoBody */
   -2,  /* (80) proto ::= edition wholeProtoBody */
   -2,  /* (81) protoBody ::= protoBody import */
   -2,  /* (82) protoBody ::= protoBody package */
   -2,  /* (83) protoBody ::= protoBody option */
   -2,  /* (84) protoBody ::= protoBody emptyStatement */
   -5,  /* (85) option ::= PT_OPTION optionName PT_ASSIGN constant PT_SEMICOLON */
   -5,  /* (86) option ::= PT_OPTION optionName PT_ASSIGN customOptionValue PT_SEMICOLON */
   -1,  /* (87) optionName ::= exIdent */
   -1,  /* (88) optionName ::= extIdentInParentheses */
   -3,  /* (89) customOptionValue ::= PT_LCURLY customOptionBody PT_RCURLY */
    0,  /* (90) customOptionBody ::= */
   -2,  /* (91) customOptionBody ::= customOptionBody exIdent */
   -2,  /* (92) customOptionBody ::= customOptionBody PT_STRLIT */
   -2,  /* (93) customOptionBody ::= customOptionBody symbolsWithoutCurly */
   -2,  /* (94) customOptionBody ::= customOptionBody intLit */
   -2,  /* (95) customOptionBody ::= customOptionBody customOptionValue */
   -1,  /* (96) symbolsWithoutCurly ::= PT_LPAREN */
   -1,  /* (97) symbolsWithoutCurly ::= PT_RPAREN */
   -1,  /* (98) symbolsWithoutCurly ::= PT_LBRACKET */
   -1,  /* (99) symbolsWithoutCurly ::= PT_RBRACKET */
   -1,  /* (100) symbolsWithoutCurly ::= PT_EQUAL */
   -1,  /* (101) symbolsWithoutCurly ::= PT_NOTEQUAL */
   -1,  /* (102) symbolsWithoutCurly ::= PT_NOTEQUAL2 */
   -1,  /* (103) symbolsWithoutCurly ::= PT_GEQUAL */
   -1,  /* (104) symbolsWithoutCurly ::= PT_LEQUAL */
   -1,  /* (105) symbolsWithoutCurly ::= PT_ASSIGN_PLUS */
   -1,  /* (106) symbolsWithoutCurly ::= PT_ASSIGN */
   -1,  /* (107) symbolsWithoutCurly ::= PT_PLUS */
   -1,  /* (108) symbolsWithoutCurly ::= PT_MINUS */
   -1,  /* (109) symbolsWithoutCurly ::= PT_MULTIPLY */
   -1,  /* (110) symbolsWithoutCurly ::= PT_DIV */
   -1,  /* (111) symbolsWithoutCurly ::= PT_LOGIC_OR */
   -1,  /* (112) symbolsWithoutCurly ::= PT_OR */
   -1,  /* (113) symbolsWithoutCurly ::= PT_LOGIC_AND */
   -1,  /* (114) symbolsWithoutCurly ::= PT_AND */
   -1,  /* (115) symbolsWithoutCurly ::= PT_NOT */
   -1,  /* (116) symbolsWithoutCurly ::= PT_NEG */
   -1,  /* (117) symbolsWithoutCurly ::= PT_XOR */
   -1,  /* (118) symbolsWithoutCurly ::= PT_SHL */
   -1,  /* (119) symbolsWithoutCurly ::= PT_SHR */
   -1,  /* (120) symbolsWithoutCurly ::= PT_PERCENT */
   -1,  /* (121) symbolsWithoutCurly ::= PT_DOLLAR */
   -1,  /* (122) symbolsWithoutCurly ::= PT_COND */
   -1,  /* (123) symbolsWithoutCurly ::= PT_SEMICOLON */
   -1,  /* (124) symbolsWithoutCurly ::= PT_DOT */
   -1,  /* (125) symbolsWithoutCurly ::= PT_COMMA */
   -1,  /* (126) symbolsWithoutCurly ::= PT_COLON */
   -1,  /* (127) symbolsWithoutCurly ::= PT_LESS */
   -1,  /* (128) symbolsWithoutCurly ::= PT_GREATER */
   -1,  /* (129) topLevelDef ::= message */
   -1,  /* (130) topLevelDef ::= enum */
   -1,  /* (131) topLevelDef ::= extend */
   -1,  /* (132) topLevelDef ::= service */
   -2,  /* (133) messageBody ::= messageBody extend */
   -2,  /* (134) messageBody ::= messageBody extensions */
   -2,  /* (135) messageBody ::= messageBody option */
   -2,  /* (136) messageBody ::= messageBody reserved */
   -2,  /* (137) messageBody ::= messageBody emptyStatement */
   -2,  /* (138) enumBody ::= enumBody reserved */
   -2,  /* (139) enumBody ::= enumBody option */
   -2,  /* (140) enumBody ::= enumBody emptyStatement */
   -1,  /* (141) enumValueOptions ::= enumValueOption */
   -3,  /* (142) enumValueOptions ::= enumValueOptions PT_COMMA enumValueOption */
   -3,  /* (143) enumValueOption ::= optionName PT_ASSIGN constant */
   -3,  /* (144) enumValueOption ::= optionName PT_ASSIGN customOptionValue */
   -2,  /* (145) serviceBody ::= serviceBody option */
   -2,  /* (146) serviceBody ::= serviceBody emptyStatement */
   -2,  /* (147) rpc ::= rpcDecl PT_SEMICOLON */
   -4,  /* (148) rpc ::= rpcDecl PT_LCURLY rpcBody PT_RCURLY */
    0,  /* (149) rpcBody ::= */
   -2,  /* (150) rpcBody ::= rpcBody option */
   -2,  /* (151) rpcBody ::= rpcBody emptyStatement */
   -2,  /* (152) stream ::= streamDecl PT_SEMICOLON */
   -4,  /* (153) stream ::= streamDecl PT_LCURLY streamBody PT_RCURLY */
    0,  /* (154) streamBody ::= */
   -2,  /* (155) streamBody ::= streamBody option */
   -2,  /* (156) streamBody ::= streamBody emptyStatement */
   -1,  /* (157) groupName ::= exIdent */
   -2,  /* (158) oneofBody ::= oneofBody option */
   -2,  /* (159) oneofBody ::= oneofBody group */
   -2,  /* (160) oneofBody ::= oneofBody emptyStatement */
   -3,  /* (161) extensions ::= PT_EXTENSIONS ranges PT_SEMICOLON */
   -6,  /* (162) extensions ::= PT_EXTENSIONS ranges PT_LBRACKET declarations PT_RBRACKET PT_SEMICOLON */
   -1,  /* (163) declarations ::= declaration */
   -3,  /* (164) declarations ::= declarations PT_COMMA declaration */
   -3,  /* (165) declaration ::= optionName PT_ASSIGN constant */
   -3,  /* (166) declaration ::= optionName PT_ASSIGN customOptionValue */
   -3,  /* (167) reserved ::= PT_RESERVED ranges PT_SEMICOLON */
   -3,  /* (168) reserved ::= PT_RESERVED quoteFieldNames PT_SEMICOLON */
   -3,  /* (169) reserved ::= PT_RESERVED reservedIdent PT_SEMICOLON */
   -1,  /* (170) ranges ::= range */
   -3,  /* (171) ranges ::= ranges PT_COMMA range */
   -1,  /* (172) range ::= intLit */
   -3,  /* (173) range ::= intLit PT_TO intLit */
   -3,  /* (174) range ::= intLit PT_TO exIdent */
   -1,  /* (175) quoteFieldNames ::= strLit */
   -3,  /* (176) quoteFieldNames ::= quoteFieldNames PT_COMMA strLit */
   -1,  /* (177) reservedIdent ::= fieldName */
   -3,  /* (178) reservedIdent ::= fieldName PT_COMMA fieldName */
   -2,  /* (179) extendBody ::= extendBody emptyStatement */
   -1,  /* (180) messageName ::= exIdent */
   -1,  /* (181) enumName ::= exIdent */
   -1,  /* (182) streamName ::= exIdent */
   -1,  /* (183) fieldName ::= exIdent */
   -1,  /* (184) oneofName ::= exIdent */
   -1,  /* (185) mapName ::= exIdent */
   -1,  /* (186) serviceName ::= exIdent */
   -1,  /* (187) rpcName ::= exIdent */
   -1,  /* (188) emptyStatement ::= PT_SEMICOLON */
   -1,  /* (189) constant ::= strLit */
   -1,  /* (190) exIdent ::= PT_IDENT */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ProtobufLangParserTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ProtobufLangParserCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ProtobufLangParserARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* wholeProtoBody ::= protoBody */
#line 155 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{
        /* set real package name */
        pbl_set_node_name(yymsp[0].minor.yy93, state->file->package_name_lineno, state->file->package_name);
        /* use the allocate mem of the name of the package node */
        state->file->package_name = pbl_get_node_name(yymsp[0].minor.yy93);
        /* put this file data into package tables */
        pbl_node_t* packnode = (pbl_node_t*)g_hash_table_lookup(state->pool->packages, state->file->package_name);
        if (packnode) {
            pbl_merge_children(packnode, yymsp[0].minor.yy93);
            pbl_free_node(yymsp[0].minor.yy93);
        } else {
            g_hash_table_insert(state->pool->packages, g_strdup(state->file->package_name), yymsp[0].minor.yy93);
        }
    }
#line 1911 "./protobuf_lang_parser.c"
        break;
      case 1: /* syntax ::= PT_SYNTAX PT_ASSIGN strLit PT_SEMICOLON */
{  yy_destructor(yypParser,2,&yymsp[-3].minor);
#line 173 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{
        if (!strcmp(yymsp[-1].minor.yy254, "proto3")) {
            state->file->syntax_version = 3;
        } else if (!strcmp(yymsp[-1].minor.yy254, "proto2")) {
            state->file->syntax_version = 2;
        } else {
            pbl_parser_error(state, "Unrecognized syntax identifier [%s]. This parser only recognizes \"proto3\" or \"proto2\"!", yymsp[-1].minor.yy254);
            state->grammar_error = TRUE;
        }
    }
#line 1926 "./protobuf_lang_parser.c"
  yy_destructor(yypParser,25,&yymsp[-2].minor);
  yy_destructor(yypParser,26,&yymsp[0].minor);
}
        break;
      case 2: /* edition ::= PT_EDITION PT_ASSIGN strLit PT_SEMICOLON */
{  yy_destructor(yypParser,3,&yymsp[-3].minor);
#line 189 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{
    if (strcmp(yymsp[-1].minor.yy254, "2024") == 0) {
        state->file->syntax_version = 3;
    } else if (strcmp(yymsp[-1].minor.yy254, "2023") == 0) {
        state->file->syntax_version = 3;
    } else {
        pbl_parser_error(state, "unsupported edition %s", yymsp[-1].minor.yy254);
    }
}
#line 1943 "./protobuf_lang_parser.c"
  yy_destructor(yypParser,25,&yymsp[-2].minor);
  yy_destructor(yypParser,26,&yymsp[0].minor);
}
        break;
      case 3: /* protoBody ::= */
#line 199 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{ yymsp[1].minor.yy93 = pbl_create_node(state->file, CUR_LINENO, PBL_PACKAGE, NAME_TO_BE_SET); }
#line 1951 "./protobuf_lang_parser.c"
        break;
      case 4: /* protoBody ::= protoBody topLevelDef */
      case 15: /* messageBody ::= messageBody field */ yytestcase(yyruleno==15);
      case 16: /* messageBody ::= messageBody enum */ yytestcase(yyruleno==16);
      case 17: /* messageBody ::= messageBody message */ yytestcase(yyruleno==17);
      case 18: /* messageBody ::= messageBody group */ yytestcase(yyruleno==18);
      case 20: /* messageBody ::= messageBody mapField */ yytestcase(yyruleno==20);
      case 23: /* enumBody ::= enumBody enumField */ yytestcase(yyruleno==23);
      case 31: /* serviceBody ::= serviceBody rpc */ yytestcase(yyruleno==31);
      case 32: /* serviceBody ::= serviceBody stream */ yytestcase(yyruleno==32);
      case 56: /* oneofBody ::= oneofBody oneofField */ yytestcase(yyruleno==56);
      case 64: /* extendBody ::= extendBody field */ yytestcase(yyruleno==64);
      case 65: /* extendBody ::= extendBody group */ yytestcase(yyruleno==65);
#line 203 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{ yylhsminor.yy93 = yymsp[-1].minor.yy93; pbl_add_child(yylhsminor.yy93, yymsp[0].minor.yy93); }
#line 1967 "./protobuf_lang_parser.c"
  yymsp[-1].minor.yy93 = yylhsminor.yy93;
        break;
      case 5: /* import ::= PT_IMPORT strLit PT_SEMICOLON */
{  yy_destructor(yypParser,4,&yymsp[-2].minor);
#line 207 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{ pbl_add_proto_file_to_be_parsed(state->pool, yymsp[-1].minor.yy254); }
#line 1974 "./protobuf_lang_parser.c"
  yy_destructor(yypParser,26,&yymsp[0].minor);
}
        break;
      case 6: /* import ::= PT_IMPORT PT_PUBLIC strLit PT_SEMICOLON */
{  yy_destructor(yypParser,4,&yymsp[-3].minor);
#line 208 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{ pbl_add_proto_file_to_be_parsed(state->pool, yymsp[-1].minor.yy254); }
#line 1982 "./protobuf_lang_parser.c"
  yy_destructor(yypParser,6,&yymsp[-2].minor);
  yy_destructor(yypParser,26,&yymsp[0].minor);
}
        break;
      case 7: /* import ::= PT_IMPORT PT_WEAK strLit PT_SEMICOLON */
{  yy_destructor(yypParser,4,&yymsp[-3].minor);
#line 209 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{ pbl_add_proto_file_to_be_parsed(state->pool, yymsp[-1].minor.yy254); }
#line 1991 "./protobuf_lang_parser.c"
  yy_destructor(yypParser,5,&yymsp[-2].minor);
  yy_destructor(yypParser,26,&yymsp[0].minor);
}
        break;
      case 8: /* package ::= PT_PACKAGE exIdent PT_SEMICOLON */
{  yy_destructor(yypParser,7,&yymsp[-2].minor);
#line 213 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{   /* The memory of (yymsp[-1].minor.yy118) will be freed after parsing, but the package_name will
           be replaced by the new-allocated name of package node late */
        state->file->package_name = yymsp[-1].minor.yy118->v;
        state->file->package_name_lineno = yymsp[-1].minor.yy118->ln;
    }
#line 2004 "./protobuf_lang_parser.c"
  yy_destructor(yypParser,26,&yymsp[0].minor);
}
        break;
      case 9: /* extIdentInParentheses ::= PT_LPAREN exIdent PT_RPAREN */
{  yy_destructor(yypParser,27,&yymsp[-2].minor);
#line 227 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{ yymsp[-2].minor.yy0 = yymsp[-1].minor.yy118; yymsp[-2].minor.yy0->v = pbl_store_string_token(state, g_strconcat("(", yymsp[-1].minor.yy118->v, ")", NULL)); }
#line 2012 "./protobuf_lang_parser.c"
  yy_destructor(yypParser,28,&yymsp[0].minor);
}
        break;
      case 10: /* optionName ::= optionName exIdent */
#line 231 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{ yylhsminor.yy118 = yymsp[-1].minor.yy118; yylhsminor.yy118->v = pbl_store_string_token(state, g_strconcat(yymsp[-1].minor.yy118->v, yymsp[0].minor.yy118->v, NULL)); }
#line 2019 "./protobuf_lang_parser.c"
  yymsp[-1].minor.yy118 = yylhsminor.yy118;
        break;
      case 11: /* optionName ::= optionName PT_DOT extIdentInParentheses */
#line 233 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{ yylhsminor.yy118 = yymsp[-2].minor.yy118; yylhsminor.yy118->v = pbl_store_string_token(state, g_strconcat(yymsp[-2].minor.yy118->v, ".", yymsp[0].minor.yy0->v, NULL)); }
#line 2025 "./protobuf_lang_parser.c"
  yy_destructor(yypParser,29,&yymsp[-1].minor);
  yymsp[-2].minor.yy118 = yylhsminor.yy118;
        break;
      case 12: /* optionName ::= optionName extIdentInParentheses */
#line 235 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{ yylhsminor.yy118 = yymsp[-1].minor.yy118; yylhsminor.yy118->v = pbl_store_string_token(state, g_strconcat(yymsp[-1].minor.yy118->v, ".", yymsp[0].minor.yy0->v, NULL)); }
#line 2032 "./protobuf_lang_parser.c"
  yymsp[-1].minor.yy118 = yylhsminor.yy118;
        break;
      case 13: /* message ::= PT_MESSAGE messageName PT_LCURLY messageBody PT_RCURLY */
{  yy_destructor(yypParser,19,&yymsp[-4].minor);
#line 315 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{ yymsp[-4].minor.yy93 = yymsp[-1].minor.yy93; pbl_set_node_name(yymsp[-4].minor.yy93, yymsp[-3].minor.yy118->ln, yymsp[-3].minor.yy118->v); }
#line 2039 "./protobuf_lang_parser.c"
  yy_destructor(yypParser,30,&yymsp[-2].minor);
  yy_destructor(yypParser,31,&yymsp[0].minor);
}
        break;
      case 14: /* messageBody ::= */
      case 63: /* extendBody ::= */ yytestcase(yyruleno==63);
#line 319 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{ yymsp[1].minor.yy93 = pbl_create_node(state->file, CUR_LINENO, PBL_MESSAGE, NAME_TO_BE_SET); }
#line 2048 "./protobuf_lang_parser.c"
        break;
      case 19: /* messageBody ::= messageBody oneof */
#line 327 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{ yylhsminor.yy93 = yymsp[-1].minor.yy93; pbl_merge_children(yylhsminor.yy93, yymsp[0].minor.yy93); pbl_free_node(yymsp[0].minor.yy93); }
#line 2053 "./protobuf_lang_parser.c"
  yymsp[-1].minor.yy93 = yylhsminor.yy93;
        break;
      case 21: /* enum ::= PT_ENUM enumName PT_LCURLY enumBody PT_RCURLY */
{  yy_destructor(yypParser,15,&yymsp[-4].minor);
#line 334 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{ yymsp[-4].minor.yy93 = yymsp[-1].minor.yy93; pbl_set_node_name(yymsp[-4].minor.yy93, yymsp[-3].minor.yy118->ln, yymsp[-3].minor.yy118->v); }
#line 2060 "./protobuf_lang_parser.c"
  yy_destructor(yypParser,30,&yymsp[-2].minor);
  yy_destructor(yypParser,31,&yymsp[0].minor);
}
        break;
      case 22: /* enumBody ::= */
#line 338 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{ yymsp[1].minor.yy93 = pbl_create_node(state->file, CUR_LINENO, PBL_ENUM, NAME_TO_BE_SET); }
#line 2068 "./protobuf_lang_parser.c"
        break;
      case 24: /* enumField ::= exIdent PT_ASSIGN enumNumber PT_LBRACKET enumValueOptions PT_RBRACKET PT_SEMICOLON */
#line 346 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{ yylhsminor.yy93 = pbl_create_enum_value_node(state->file, yymsp[-6].minor.yy118->ln, yymsp[-6].minor.yy118->v, yymsp[-4].minor.yy116); }
#line 2073 "./protobuf_lang_parser.c"
  yy_destructor(yypParser,25,&yymsp[-5].minor);
  yy_destructor(yypParser,33,&yymsp[-3].minor);
  yy_destructor(yypParser,34,&yymsp[-1].minor);
  yy_destructor(yypParser,26,&yymsp[0].minor);
  yymsp[-6].minor.yy93 = yylhsminor.yy93;
        break;
      case 25: /* enumField ::= exIdent PT_ASSIGN enumNumber */
#line 348 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{ yylhsminor.yy93 = pbl_create_enum_value_node(state->file, yymsp[-2].minor.yy118->ln, yymsp[-2].minor.yy118->v, yymsp[0].minor.yy116); }
#line 2083 "./protobuf_lang_parser.c"
  yy_destructor(yypParser,25,&yymsp[-1].minor);
  yymsp[-2].minor.yy93 = yylhsminor.yy93;
        break;
      case 26: /* enumNumber ::= intLit */
      case 46: /* fieldNumber ::= intLit */ yytestcase(yyruleno==46);
#line 351 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{ yylhsminor.yy116 = (int)yymsp[0].minor.yy180; }
#line 2091 "./protobuf_lang_parser.c"
  yymsp[0].minor.yy116 = yylhsminor.yy116;
        break;
      case 27: /* enumNumber ::= PT_PLUS intLit */
      case 47: /* fieldNumber ::= PT_PLUS intLit */ yytestcase(yyruleno==47);
{  yy_destructor(yypParser,41,&yymsp[-1].minor);
#line 352 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{ yymsp[-1].minor.yy116 = (int)yymsp[0].minor.yy180; }
#line 2099 "./protobuf_lang_parser.c"
}
        break;
      case 28: /* enumNumber ::= PT_MINUS intLit */
{  yy_destructor(yypParser,42,&yymsp[-1].minor);
#line 353 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{ yymsp[-1].minor.yy116 = -(int)yymsp[0].minor.yy180; }
#line 2106 "./protobuf_lang_parser.c"
}
        break;
      case 29: /* service ::= PT_SERVICE serviceName PT_LCURLY serviceBody PT_RCURLY */
{  yy_destructor(yypParser,20,&yymsp[-4].minor);
#line 367 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{ yymsp[-4].minor.yy93 = yymsp[-1].minor.yy93; pbl_set_node_name(yymsp[-4].minor.yy93, yymsp[-3].minor.yy118->ln, yymsp[-3].minor.yy118->v); }
#line 2113 "./protobuf_lang_parser.c"
  yy_destructor(yypParser,30,&yymsp[-2].minor);
  yy_destructor(yypParser,31,&yymsp[0].minor);
}
        break;
      case 30: /* serviceBody ::= */
#line 369 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{ yymsp[1].minor.yy93 = pbl_create_node(state->file, CUR_LINENO, PBL_SERVICE, NAME_TO_BE_SET); }
#line 2121 "./protobuf_lang_parser.c"
        break;
      case 33: /* rpcDecl ::= PT_RPC rpcName PT_LPAREN messageType PT_RPAREN PT_RETURNS PT_LPAREN messageType PT_RPAREN */
{  yy_destructor(yypParser,21,&yymsp[-8].minor);
#line 381 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{ yymsp[-8].minor.yy93 = pbl_create_method_node(state->file, yymsp[-7].minor.yy118->ln, yymsp[-7].minor.yy118->v, yymsp[-5].minor.yy254, FALSE, yymsp[-1].minor.yy254, FALSE); }
#line 2127 "./protobuf_lang_parser.c"
  yy_destructor(yypParser,27,&yymsp[-6].minor);
  yy_destructor(yypParser,28,&yymsp[-4].minor);
  yy_destructor(yypParser,23,&yymsp[-3].minor);
  yy_destructor(yypParser,27,&yymsp[-2].minor);
  yy_destructor(yypParser,28,&yymsp[0].minor);
}
        break;
      case 34: /* rpcDecl ::= PT_RPC rpcName PT_LPAREN PT_STREAM messageType PT_RPAREN PT_RETURNS PT_LPAREN messageType PT_RPAREN */
{  yy_destructor(yypParser,21,&yymsp[-9].minor);
#line 383 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{ yymsp[-9].minor.yy93 = pbl_create_method_node(state->file, yymsp[-8].minor.yy118->ln, yymsp[-8].minor.yy118->v, yymsp[-5].minor.yy254, TRUE, yymsp[-1].minor.yy254, FALSE); }
#line 2139 "./protobuf_lang_parser.c"
  yy_destructor(yypParser,27,&yymsp[-7].minor);
  yy_destructor(yypParser,22,&yymsp[-6].minor);
  yy_destructor(yypParser,28,&yymsp[-4].minor);
  yy_destructor(yypParser,23,&yymsp[-3].minor);
  yy_destructor(yypParser,27,&yymsp[-2].minor);
  yy_destructor(yypParser,28,&yymsp[0].minor);
}
        break;
      case 35: /* rpcDecl ::= PT_RPC rpcName PT_LPAREN messageType PT_RPAREN PT_RETURNS PT_LPAREN PT_STREAM messageType PT_RPAREN */
{  yy_destructor(yypParser,21,&yymsp[-9].minor);
#line 385 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{ yymsp[-9].minor.yy93 = pbl_create_method_node(state->file, yymsp[-8].minor.yy118->ln, yymsp[-8].minor.yy118->v, yymsp[-6].minor.yy254, FALSE, yymsp[-1].minor.yy254, TRUE); }
#line 2152 "./protobuf_lang_parser.c"
  yy_destructor(yypParser,27,&yymsp[-7].minor);
  yy_destructor(yypParser,28,&yymsp[-5].minor);
  yy_destructor(yypParser,23,&yymsp[-4].minor);
  yy_destructor(yypParser,27,&yymsp[-3].minor);
  yy_destructor(yypParser,22,&yymsp[-2].minor);
  yy_destructor(yypParser,28,&yymsp[0].minor);
}
        break;
      case 36: /* rpcDecl ::= PT_RPC rpcName PT_LPAREN PT_STREAM messageType PT_RPAREN PT_RETURNS PT_LPAREN PT_STREAM messageType PT_RPAREN */
{  yy_destructor(yypParser,21,&yymsp[-10].minor);
#line 387 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{ yymsp[-10].minor.yy93 = pbl_create_method_node(state->file, yymsp[-9].minor.yy118->ln, yymsp[-9].minor.yy118->v, yymsp[-6].minor.yy254, TRUE, yymsp[-1].minor.yy254, TRUE); }
#line 2165 "./protobuf_lang_parser.c"
  yy_destructor(yypParser,27,&yymsp[-8].minor);
  yy_destructor(yypParser,22,&yymsp[-7].minor);
  yy_destructor(yypParser,28,&yymsp[-5].minor);
  yy_destructor(yypParser,23,&yymsp[-4].minor);
  yy_destructor(yypParser,27,&yymsp[-3].minor);
  yy_destructor(yypParser,22,&yymsp[-2].minor);
  yy_destructor(yypParser,28,&yymsp[0].minor);
}
        break;
      case 37: /* streamDecl ::= PT_STREAM streamName PT_LPAREN messageType PT_COMMA messageType PT_RPAREN */
{  yy_destructor(yypParser,22,&yymsp[-6].minor);
#line 399 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{ yymsp[-6].minor.yy93 = pbl_create_method_node(state->file, yymsp[-5].minor.yy118->ln, yymsp[-5].minor.yy118->v, yymsp[-3].minor.yy254, TRUE, yymsp[-1].minor.yy254, TRUE); }
#line 2179 "./protobuf_lang_parser.c"
  yy_destructor(yypParser,27,&yymsp[-4].minor);
  yy_destructor(yypParser,57,&yymsp[-2].minor);
  yy_destructor(yypParser,28,&yymsp[0].minor);
}
        break;
      case 38: /* field ::= type fieldName PT_ASSIGN fieldNumber PT_SEMICOLON */
      case 58: /* oneofField ::= type fieldName PT_ASSIGN fieldNumber PT_SEMICOLON */ yytestcase(yyruleno==58);
#line 409 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{ yylhsminor.yy93 = pbl_create_field_node(state->file, yymsp[-3].minor.yy118->ln, NULL, yymsp[-4].minor.yy254, yymsp[-3].minor.yy118->v, yymsp[-1].minor.yy116, NULL); }
#line 2189 "./protobuf_lang_parser.c"
  yy_destructor(yypParser,25,&yymsp[-2].minor);
  yy_destructor(yypParser,26,&yymsp[0].minor);
  yymsp[-4].minor.yy93 = yylhsminor.yy93;
        break;
      case 39: /* field ::= type fieldName PT_ASSIGN fieldNumber PT_LBRACKET fieldOptions PT_RBRACKET PT_SEMICOLON */
      case 57: /* oneofField ::= type fieldName PT_ASSIGN fieldNumber PT_LBRACKET fieldOptions PT_RBRACKET PT_SEMICOLON */ yytestcase(yyruleno==57);
#line 411 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{ yylhsminor.yy93 = pbl_create_field_node(state->file, yymsp[-6].minor.yy118->ln, NULL, yymsp[-7].minor.yy254, yymsp[-6].minor.yy118->v, yymsp[-4].minor.yy116, yymsp[-2].minor.yy93); }
#line 2198 "./protobuf_lang_parser.c"
  yy_destructor(yypParser,25,&yymsp[-5].minor);
  yy_destructor(yypParser,33,&yymsp[-3].minor);
  yy_destructor(yypParser,34,&yymsp[-1].minor);
  yy_destructor(yypParser,26,&yymsp[0].minor);
  yymsp[-7].minor.yy93 = yylhsminor.yy93;
        break;
      case 40: /* field ::= label type fieldName PT_ASSIGN fieldNumber PT_SEMICOLON */
#line 413 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{ yylhsminor.yy93 = pbl_create_field_node(state->file, yymsp[-3].minor.yy118->ln, yymsp[-5].minor.yy254, yymsp[-4].minor.yy254, yymsp[-3].minor.yy118->v, yymsp[-1].minor.yy116, NULL); }
#line 2208 "./protobuf_lang_parser.c"
  yy_destructor(yypParser,25,&yymsp[-2].minor);
  yy_destructor(yypParser,26,&yymsp[0].minor);
  yymsp[-5].minor.yy93 = yylhsminor.yy93;
        break;
      case 41: /* field ::= label type fieldName PT_ASSIGN fieldNumber PT_LBRACKET fieldOptions PT_RBRACKET PT_SEMICOLON */
#line 415 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{ yylhsminor.yy93 = pbl_create_field_node(state->file, yymsp[-6].minor.yy118->ln, yymsp[-8].minor.yy254, yymsp[-7].minor.yy254, yymsp[-6].minor.yy118->v, yymsp[-4].minor.yy116, yymsp[-2].minor.yy93); }
#line 2216 "./protobuf_lang_parser.c"
  yy_destructor(yypParser,25,&yymsp[-5].minor);
  yy_destructor(yypParser,33,&yymsp[-3].minor);
  yy_destructor(yypParser,34,&yymsp[-1].minor);
  yy_destructor(yypParser,26,&yymsp[0].minor);
  yymsp[-8].minor.yy93 = yylhsminor.yy93;
        break;
      case 42: /* label ::= PT_REQUIRED */
      case 43: /* label ::= PT_OPTIONAL */ yytestcase(yyruleno==43);
      case 44: /* label ::= PT_REPEATED */ yytestcase(yyruleno==44);
#line 418 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{ yylhsminor.yy254 = yymsp[0].minor.yy0->v; }
#line 2228 "./protobuf_lang_parser.c"
  yymsp[0].minor.yy254 = yylhsminor.yy254;
        break;
      case 45: /* type ::= exIdent */
      case 61: /* keyType ::= exIdent */ yytestcase(yyruleno==61);
      case 66: /* messageType ::= exIdent */ yytestcase(yyruleno==66);
      case 70: /* constant ::= exIdent */ yytestcase(yyruleno==70);
#line 426 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{ yylhsminor.yy254 = yymsp[0].minor.yy118->v; }
#line 2237 "./protobuf_lang_parser.c"
  yymsp[0].minor.yy254 = yylhsminor.yy254;
        break;
      case 48: /* fieldOptions ::= fieldOption */
#line 434 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{ yylhsminor.yy93 = pbl_create_node(state->file, CUR_LINENO, PBL_OPTIONS, NEED_NOT_NAME); pbl_add_child(yylhsminor.yy93, yymsp[0].minor.yy93); }
#line 2243 "./protobuf_lang_parser.c"
  yymsp[0].minor.yy93 = yylhsminor.yy93;
        break;
      case 49: /* fieldOptions ::= fieldOptions PT_COMMA fieldOption */
#line 436 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{ yylhsminor.yy93 = yymsp[-2].minor.yy93; pbl_add_child(yylhsminor.yy93, yymsp[0].minor.yy93); }
#line 2249 "./protobuf_lang_parser.c"
  yy_destructor(yypParser,57,&yymsp[-1].minor);
  yymsp[-2].minor.yy93 = yylhsminor.yy93;
        break;
      case 50: /* fieldOption ::= optionName PT_ASSIGN constant */
#line 441 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{ yylhsminor.yy93 = pbl_create_option_node(state->file, yymsp[-2].minor.yy118->ln, yymsp[-2].minor.yy118->v, yymsp[0].minor.yy254); }
#line 2256 "./protobuf_lang_parser.c"
  yy_destructor(yypParser,25,&yymsp[-1].minor);
  yymsp[-2].minor.yy93 = yylhsminor.yy93;
        break;
      case 51: /* fieldOption ::= optionName PT_ASSIGN customOptionValue */
#line 443 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{ yylhsminor.yy93 = pbl_create_option_node(state->file, yymsp[-2].minor.yy118->ln, yymsp[-2].minor.yy118->v, pbl_store_string_token(state, g_strdup("{ ... }"))); }
#line 2263 "./protobuf_lang_parser.c"
  yy_destructor(yypParser,25,&yymsp[-1].minor);
  yymsp[-2].minor.yy93 = yylhsminor.yy93;
        break;
      case 52: /* group ::= PT_GROUP groupName PT_ASSIGN fieldNumber PT_LCURLY messageBody PT_RCURLY */
{  yy_destructor(yypParser,16,&yymsp[-6].minor);
#line 448 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{ yymsp[-6].minor.yy93 = yymsp[-1].minor.yy93; pbl_set_node_name(yymsp[-6].minor.yy93, yymsp[-5].minor.yy118->ln, yymsp[-5].minor.yy118->v); }
#line 2271 "./protobuf_lang_parser.c"
  yy_destructor(yypParser,25,&yymsp[-4].minor);
  yy_destructor(yypParser,30,&yymsp[-2].minor);
  yy_destructor(yypParser,31,&yymsp[0].minor);
}
        break;
      case 53: /* group ::= label PT_GROUP groupName PT_ASSIGN fieldNumber PT_LCURLY messageBody PT_RCURLY */
#line 450 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{ yymsp[-7].minor.yy93 = yymsp[-1].minor.yy93; pbl_set_node_name(yymsp[-7].minor.yy93, yymsp[-5].minor.yy118->ln, yymsp[-5].minor.yy118->v); }
#line 2280 "./protobuf_lang_parser.c"
  yy_destructor(yypParser,16,&yymsp[-6].minor);
  yy_destructor(yypParser,25,&yymsp[-4].minor);
  yy_destructor(yypParser,30,&yymsp[-2].minor);
  yy_destructor(yypParser,31,&yymsp[0].minor);
        break;
      case 54: /* oneof ::= PT_ONEOF oneofName PT_LCURLY oneofBody PT_RCURLY */
{  yy_destructor(yypParser,12,&yymsp[-4].minor);
#line 457 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{ yymsp[-4].minor.yy93 = yymsp[-1].minor.yy93; pbl_set_node_name(yymsp[-4].minor.yy93, yymsp[-3].minor.yy118->ln, yymsp[-3].minor.yy118->v); }
#line 2290 "./protobuf_lang_parser.c"
  yy_destructor(yypParser,30,&yymsp[-2].minor);
  yy_destructor(yypParser,31,&yymsp[0].minor);
}
        break;
      case 55: /* oneofBody ::= */
#line 459 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{ yymsp[1].minor.yy93 = pbl_create_node(state->file, CUR_LINENO, PBL_ONEOF, NAME_TO_BE_SET); }
#line 2298 "./protobuf_lang_parser.c"
        break;
      case 59: /* mapField ::= PT_MAP PT_LESS keyType PT_COMMA type PT_GREATER mapName PT_ASSIGN fieldNumber PT_LBRACKET fieldOptions PT_RBRACKET PT_SEMICOLON */
{  yy_destructor(yypParser,13,&yymsp[-12].minor);
#line 473 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{
        yymsp[-12].minor.yy93 = pbl_create_map_field_node(state->file, yymsp[-6].minor.yy118->ln, yymsp[-6].minor.yy118->v, yymsp[-4].minor.yy116, yymsp[-2].minor.yy93);
        pbl_add_child(yymsp[-12].minor.yy93, pbl_create_field_node(state->file, yymsp[-6].minor.yy118->ln, NULL, yymsp[-10].minor.yy254, "key", 1, NULL)); /* add key field */
        pbl_add_child(yymsp[-12].minor.yy93, pbl_create_field_node(state->file, yymsp[-6].minor.yy118->ln, NULL, yymsp[-8].minor.yy254, "value", 2, NULL)); /* add value field */
    }
#line 2308 "./protobuf_lang_parser.c"
  yy_destructor(yypParser,59,&yymsp[-11].minor);
  yy_destructor(yypParser,57,&yymsp[-9].minor);
  yy_destructor(yypParser,60,&yymsp[-7].minor);
  yy_destructor(yypParser,25,&yymsp[-5].minor);
  yy_destructor(yypParser,33,&yymsp[-3].minor);
  yy_destructor(yypParser,34,&yymsp[-1].minor);
  yy_destructor(yypParser,26,&yymsp[0].minor);
}
        break;
      case 60: /* mapField ::= PT_MAP PT_LESS keyType PT_COMMA type PT_GREATER mapName PT_ASSIGN fieldNumber PT_SEMICOLON */
{  yy_destructor(yypParser,13,&yymsp[-9].minor);
#line 479 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{
        yymsp[-9].minor.yy93 = pbl_create_map_field_node(state->file, yymsp[-3].minor.yy118->ln, yymsp[-3].minor.yy118->v, yymsp[-1].minor.yy116, NULL);
        pbl_add_child(yymsp[-9].minor.yy93, pbl_create_field_node(state->file, yymsp[-3].minor.yy118->ln, NULL, yymsp[-7].minor.yy254, "key", 1, NULL)); /* add key field */
        pbl_add_child(yymsp[-9].minor.yy93, pbl_create_field_node(state->file, yymsp[-3].minor.yy118->ln, NULL, yymsp[-5].minor.yy254, "value", 2, NULL)); /* add value field */
    }
#line 2326 "./protobuf_lang_parser.c"
  yy_destructor(yypParser,59,&yymsp[-8].minor);
  yy_destructor(yypParser,57,&yymsp[-6].minor);
  yy_destructor(yypParser,60,&yymsp[-4].minor);
  yy_destructor(yypParser,25,&yymsp[-2].minor);
  yy_destructor(yypParser,26,&yymsp[0].minor);
}
        break;
      case 62: /* extend ::= PT_EXTEND messageType PT_LCURLY extendBody PT_RCURLY */
{  yy_destructor(yypParser,17,&yymsp[-4].minor);
#line 555 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{ yymsp[-4].minor.yy93 = NULL; pbl_free_node(yymsp[-1].minor.yy93); }
#line 2338 "./protobuf_lang_parser.c"
  yy_destructor(yypParser,30,&yymsp[-2].minor);
  yy_destructor(yypParser,31,&yymsp[0].minor);
}
        break;
      case 67: /* intLit ::= PT_DECIMALLIT */
#line 578 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{ yylhsminor.yy180 = g_ascii_strtoull(yymsp[0].minor.yy0->v, NULL, 10); }
#line 2346 "./protobuf_lang_parser.c"
  yymsp[0].minor.yy180 = yylhsminor.yy180;
        break;
      case 68: /* intLit ::= PT_OCTALLIT */
#line 579 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{ yylhsminor.yy180 = g_ascii_strtoull(yymsp[0].minor.yy0->v+1, NULL, 8); }
#line 2352 "./protobuf_lang_parser.c"
  yymsp[0].minor.yy180 = yylhsminor.yy180;
        break;
      case 69: /* intLit ::= PT_HEXLIT */
#line 580 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{ yylhsminor.yy180 = g_ascii_strtoull(yymsp[0].minor.yy0->v+2, NULL, 16); }
#line 2358 "./protobuf_lang_parser.c"
  yymsp[0].minor.yy180 = yylhsminor.yy180;
        break;
      case 71: /* constant ::= intLit */
#line 588 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{ yylhsminor.yy254 = pbl_store_string_token(state, ws_strdup_printf("%" PRIu64, yymsp[0].minor.yy180)); }
#line 2364 "./protobuf_lang_parser.c"
  yymsp[0].minor.yy254 = yylhsminor.yy254;
        break;
      case 72: /* constant ::= PT_PLUS intLit */
{  yy_destructor(yypParser,41,&yymsp[-1].minor);
#line 589 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{ yymsp[-1].minor.yy254 = pbl_store_string_token(state, ws_strdup_printf("%" PRIu64, yymsp[0].minor.yy180)); }
#line 2371 "./protobuf_lang_parser.c"
}
        break;
      case 73: /* constant ::= PT_MINUS intLit */
{  yy_destructor(yypParser,42,&yymsp[-1].minor);
#line 590 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{ yymsp[-1].minor.yy254 = pbl_store_string_token(state, ws_strdup_printf("-%" PRIu64, yymsp[0].minor.yy180)); }
#line 2378 "./protobuf_lang_parser.c"
}
        break;
      case 74: /* constant ::= PT_PLUS exIdent */
{  yy_destructor(yypParser,41,&yymsp[-1].minor);
#line 591 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{ yymsp[-1].minor.yy254 = pbl_store_string_token(state, g_strconcat("+", yymsp[0].minor.yy118->v, NULL)); }
#line 2385 "./protobuf_lang_parser.c"
}
        break;
      case 75: /* constant ::= PT_MINUS exIdent */
{  yy_destructor(yypParser,42,&yymsp[-1].minor);
#line 592 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{ yymsp[-1].minor.yy254 = pbl_store_string_token(state, g_strconcat("-", yymsp[0].minor.yy118->v, NULL)); }
#line 2392 "./protobuf_lang_parser.c"
}
        break;
      case 76: /* strLit ::= PT_STRLIT */
#line 596 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{ yylhsminor.yy254 = pbl_store_string_token(state, g_strndup(yymsp[0].minor.yy0->v + 1, strlen(yymsp[0].minor.yy0->v) - 2)); }
#line 2398 "./protobuf_lang_parser.c"
  yymsp[0].minor.yy254 = yylhsminor.yy254;
        break;
      case 77: /* strLit ::= strLit PT_STRLIT */
#line 598 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{ gchar *v = g_strndup(yymsp[0].minor.yy0->v + 1, strlen(yymsp[0].minor.yy0->v) - 2); yylhsminor.yy254 = pbl_store_string_token(state, g_strconcat(yymsp[-1].minor.yy254, v, NULL)); g_free(v); }
#line 2404 "./protobuf_lang_parser.c"
  yymsp[-1].minor.yy254 = yylhsminor.yy254;
        break;
      case 85: /* option ::= PT_OPTION optionName PT_ASSIGN constant PT_SEMICOLON */
      case 86: /* option ::= PT_OPTION optionName PT_ASSIGN customOptionValue PT_SEMICOLON */ yytestcase(yyruleno==86);
{  yy_destructor(yypParser,8,&yymsp[-4].minor);
#line 221 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{
}
#line 2413 "./protobuf_lang_parser.c"
  yy_destructor(yypParser,25,&yymsp[-2].minor);
  yy_destructor(yypParser,26,&yymsp[0].minor);
}
        break;
      case 89: /* customOptionValue ::= PT_LCURLY customOptionBody PT_RCURLY */
{  yy_destructor(yypParser,30,&yymsp[-2].minor);
#line 242 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{
}
#line 2423 "./protobuf_lang_parser.c"
  yy_destructor(yypParser,31,&yymsp[0].minor);
}
        break;
      case 92: /* customOptionBody ::= customOptionBody PT_STRLIT */
#line 267 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{
}
#line 2431 "./protobuf_lang_parser.c"
  yy_destructor(yypParser,32,&yymsp[0].minor);
        break;
      case 96: /* symbolsWithoutCurly ::= PT_LPAREN */
{  yy_destructor(yypParser,27,&yymsp[0].minor);
#line 272 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{
}
#line 2439 "./protobuf_lang_parser.c"
}
        break;
      case 97: /* symbolsWithoutCurly ::= PT_RPAREN */
{  yy_destructor(yypParser,28,&yymsp[0].minor);
#line 273 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{
}
#line 2447 "./protobuf_lang_parser.c"
}
        break;
      case 98: /* symbolsWithoutCurly ::= PT_LBRACKET */
{  yy_destructor(yypParser,33,&yymsp[0].minor);
#line 274 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{
}
#line 2455 "./protobuf_lang_parser.c"
}
        break;
      case 99: /* symbolsWithoutCurly ::= PT_RBRACKET */
{  yy_destructor(yypParser,34,&yymsp[0].minor);
#line 275 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{
}
#line 2463 "./protobuf_lang_parser.c"
}
        break;
      case 100: /* symbolsWithoutCurly ::= PT_EQUAL */
{  yy_destructor(yypParser,35,&yymsp[0].minor);
#line 276 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{
}
#line 2471 "./protobuf_lang_parser.c"
}
        break;
      case 101: /* symbolsWithoutCurly ::= PT_NOTEQUAL */
{  yy_destructor(yypParser,36,&yymsp[0].minor);
#line 277 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{
}
#line 2479 "./protobuf_lang_parser.c"
}
        break;
      case 102: /* symbolsWithoutCurly ::= PT_NOTEQUAL2 */
{  yy_destructor(yypParser,37,&yymsp[0].minor);
#line 278 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{
}
#line 2487 "./protobuf_lang_parser.c"
}
        break;
      case 103: /* symbolsWithoutCurly ::= PT_GEQUAL */
{  yy_destructor(yypParser,38,&yymsp[0].minor);
#line 279 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{
}
#line 2495 "./protobuf_lang_parser.c"
}
        break;
      case 104: /* symbolsWithoutCurly ::= PT_LEQUAL */
{  yy_destructor(yypParser,39,&yymsp[0].minor);
#line 280 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{
}
#line 2503 "./protobuf_lang_parser.c"
}
        break;
      case 105: /* symbolsWithoutCurly ::= PT_ASSIGN_PLUS */
{  yy_destructor(yypParser,40,&yymsp[0].minor);
#line 281 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{
}
#line 2511 "./protobuf_lang_parser.c"
}
        break;
      case 106: /* symbolsWithoutCurly ::= PT_ASSIGN */
{  yy_destructor(yypParser,25,&yymsp[0].minor);
#line 282 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{
}
#line 2519 "./protobuf_lang_parser.c"
}
        break;
      case 107: /* symbolsWithoutCurly ::= PT_PLUS */
{  yy_destructor(yypParser,41,&yymsp[0].minor);
#line 283 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{
}
#line 2527 "./protobuf_lang_parser.c"
}
        break;
      case 108: /* symbolsWithoutCurly ::= PT_MINUS */
{  yy_destructor(yypParser,42,&yymsp[0].minor);
#line 284 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{
}
#line 2535 "./protobuf_lang_parser.c"
}
        break;
      case 109: /* symbolsWithoutCurly ::= PT_MULTIPLY */
{  yy_destructor(yypParser,43,&yymsp[0].minor);
#line 285 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{
}
#line 2543 "./protobuf_lang_parser.c"
}
        break;
      case 110: /* symbolsWithoutCurly ::= PT_DIV */
{  yy_destructor(yypParser,44,&yymsp[0].minor);
#line 286 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{
}
#line 2551 "./protobuf_lang_parser.c"
}
        break;
      case 111: /* symbolsWithoutCurly ::= PT_LOGIC_OR */
{  yy_destructor(yypParser,45,&yymsp[0].minor);
#line 287 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{
}
#line 2559 "./protobuf_lang_parser.c"
}
        break;
      case 112: /* symbolsWithoutCurly ::= PT_OR */
{  yy_destructor(yypParser,46,&yymsp[0].minor);
#line 288 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{
}
#line 2567 "./protobuf_lang_parser.c"
}
        break;
      case 113: /* symbolsWithoutCurly ::= PT_LOGIC_AND */
{  yy_destructor(yypParser,47,&yymsp[0].minor);
#line 289 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{
}
#line 2575 "./protobuf_lang_parser.c"
}
        break;
      case 114: /* symbolsWithoutCurly ::= PT_AND */
{  yy_destructor(yypParser,48,&yymsp[0].minor);
#line 290 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{
}
#line 2583 "./protobuf_lang_parser.c"
}
        break;
      case 115: /* symbolsWithoutCurly ::= PT_NOT */
{  yy_destructor(yypParser,49,&yymsp[0].minor);
#line 291 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{
}
#line 2591 "./protobuf_lang_parser.c"
}
        break;
      case 116: /* symbolsWithoutCurly ::= PT_NEG */
{  yy_destructor(yypParser,50,&yymsp[0].minor);
#line 292 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{
}
#line 2599 "./protobuf_lang_parser.c"
}
        break;
      case 117: /* symbolsWithoutCurly ::= PT_XOR */
{  yy_destructor(yypParser,51,&yymsp[0].minor);
#line 293 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{
}
#line 2607 "./protobuf_lang_parser.c"
}
        break;
      case 118: /* symbolsWithoutCurly ::= PT_SHL */
{  yy_destructor(yypParser,52,&yymsp[0].minor);
#line 294 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{
}
#line 2615 "./protobuf_lang_parser.c"
}
        break;
      case 119: /* symbolsWithoutCurly ::= PT_SHR */
{  yy_destructor(yypParser,53,&yymsp[0].minor);
#line 295 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{
}
#line 2623 "./protobuf_lang_parser.c"
}
        break;
      case 120: /* symbolsWithoutCurly ::= PT_PERCENT */
{  yy_destructor(yypParser,54,&yymsp[0].minor);
#line 296 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{
}
#line 2631 "./protobuf_lang_parser.c"
}
        break;
      case 121: /* symbolsWithoutCurly ::= PT_DOLLAR */
{  yy_destructor(yypParser,55,&yymsp[0].minor);
#line 297 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{
}
#line 2639 "./protobuf_lang_parser.c"
}
        break;
      case 122: /* symbolsWithoutCurly ::= PT_COND */
{  yy_destructor(yypParser,56,&yymsp[0].minor);
#line 298 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{
}
#line 2647 "./protobuf_lang_parser.c"
}
        break;
      case 123: /* symbolsWithoutCurly ::= PT_SEMICOLON */
      case 188: /* emptyStatement ::= PT_SEMICOLON */ yytestcase(yyruleno==188);
{  yy_destructor(yypParser,26,&yymsp[0].minor);
#line 299 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{
}
#line 2656 "./protobuf_lang_parser.c"
}
        break;
      case 124: /* symbolsWithoutCurly ::= PT_DOT */
{  yy_destructor(yypParser,29,&yymsp[0].minor);
#line 300 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{
}
#line 2664 "./protobuf_lang_parser.c"
}
        break;
      case 125: /* symbolsWithoutCurly ::= PT_COMMA */
{  yy_destructor(yypParser,57,&yymsp[0].minor);
#line 301 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{
}
#line 2672 "./protobuf_lang_parser.c"
}
        break;
      case 126: /* symbolsWithoutCurly ::= PT_COLON */
{  yy_destructor(yypParser,58,&yymsp[0].minor);
#line 302 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{
}
#line 2680 "./protobuf_lang_parser.c"
}
        break;
      case 127: /* symbolsWithoutCurly ::= PT_LESS */
{  yy_destructor(yypParser,59,&yymsp[0].minor);
#line 303 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{
}
#line 2688 "./protobuf_lang_parser.c"
}
        break;
      case 128: /* symbolsWithoutCurly ::= PT_GREATER */
{  yy_destructor(yypParser,60,&yymsp[0].minor);
#line 304 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{
}
#line 2696 "./protobuf_lang_parser.c"
}
        break;
      case 142: /* enumValueOptions ::= enumValueOptions PT_COMMA enumValueOption */
      case 164: /* declarations ::= declarations PT_COMMA declaration */ yytestcase(yyruleno==164);
      case 171: /* ranges ::= ranges PT_COMMA range */ yytestcase(yyruleno==171);
      case 176: /* quoteFieldNames ::= quoteFieldNames PT_COMMA strLit */ yytestcase(yyruleno==176);
      case 178: /* reservedIdent ::= fieldName PT_COMMA fieldName */ yytestcase(yyruleno==178);
#line 357 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{
}
#line 2707 "./protobuf_lang_parser.c"
  yy_destructor(yypParser,57,&yymsp[-1].minor);
        break;
      case 143: /* enumValueOption ::= optionName PT_ASSIGN constant */
      case 144: /* enumValueOption ::= optionName PT_ASSIGN customOptionValue */ yytestcase(yyruleno==144);
      case 165: /* declaration ::= optionName PT_ASSIGN constant */ yytestcase(yyruleno==165);
      case 166: /* declaration ::= optionName PT_ASSIGN customOptionValue */ yytestcase(yyruleno==166);
#line 361 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{
}
#line 2717 "./protobuf_lang_parser.c"
  yy_destructor(yypParser,25,&yymsp[-1].minor);
        break;
      case 147: /* rpc ::= rpcDecl PT_SEMICOLON */
      case 152: /* stream ::= streamDecl PT_SEMICOLON */ yytestcase(yyruleno==152);
#line 376 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{
}
#line 2725 "./protobuf_lang_parser.c"
  yy_destructor(yypParser,26,&yymsp[0].minor);
        break;
      case 148: /* rpc ::= rpcDecl PT_LCURLY rpcBody PT_RCURLY */
      case 153: /* stream ::= streamDecl PT_LCURLY streamBody PT_RCURLY */ yytestcase(yyruleno==153);
#line 377 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{
}
#line 2733 "./protobuf_lang_parser.c"
  yy_destructor(yypParser,30,&yymsp[-2].minor);
  yy_destructor(yypParser,31,&yymsp[0].minor);
        break;
      case 161: /* extensions ::= PT_EXTENSIONS ranges PT_SEMICOLON */
{  yy_destructor(yypParser,18,&yymsp[-2].minor);
#line 511 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{
}
#line 2742 "./protobuf_lang_parser.c"
  yy_destructor(yypParser,26,&yymsp[0].minor);
}
        break;
      case 162: /* extensions ::= PT_EXTENSIONS ranges PT_LBRACKET declarations PT_RBRACKET PT_SEMICOLON */
{  yy_destructor(yypParser,18,&yymsp[-5].minor);
#line 512 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{
}
#line 2751 "./protobuf_lang_parser.c"
  yy_destructor(yypParser,33,&yymsp[-3].minor);
  yy_destructor(yypParser,34,&yymsp[-1].minor);
  yy_destructor(yypParser,26,&yymsp[0].minor);
}
        break;
      case 167: /* reserved ::= PT_RESERVED ranges PT_SEMICOLON */
      case 168: /* reserved ::= PT_RESERVED quoteFieldNames PT_SEMICOLON */ yytestcase(yyruleno==168);
      case 169: /* reserved ::= PT_RESERVED reservedIdent PT_SEMICOLON */ yytestcase(yyruleno==169);
{  yy_destructor(yypParser,14,&yymsp[-2].minor);
#line 524 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{
}
#line 2764 "./protobuf_lang_parser.c"
  yy_destructor(yypParser,26,&yymsp[0].minor);
}
        break;
      case 173: /* range ::= intLit PT_TO intLit */
      case 174: /* range ::= intLit PT_TO exIdent */ yytestcase(yyruleno==174);
#line 535 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{
}
#line 2773 "./protobuf_lang_parser.c"
  yy_destructor(yypParser,24,&yymsp[-1].minor);
        break;
      case 190: /* exIdent ::= PT_IDENT */
{  yy_destructor(yypParser,1,&yymsp[0].minor);
#line 594 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"
{
}
#line 2781 "./protobuf_lang_parser.c"
}
        break;
      default:
      /* (78) proto ::= wholeProtoBody */ yytestcase(yyruleno==78);
      /* (79) proto ::= syntax wholeProtoBody */ yytestcase(yyruleno==79);
      /* (80) proto ::= edition wholeProtoBody */ yytestcase(yyruleno==80);
      /* (81) protoBody ::= protoBody import */ yytestcase(yyruleno==81);
      /* (82) protoBody ::= protoBody package */ yytestcase(yyruleno==82);
      /* (83) protoBody ::= protoBody option */ yytestcase(yyruleno==83);
      /* (84) protoBody ::= protoBody emptyStatement */ yytestcase(yyruleno==84);
      /* (87) optionName ::= exIdent (OPTIMIZED OUT) */ assert(yyruleno!=87);
      /* (88) optionName ::= extIdentInParentheses (OPTIMIZED OUT) */ assert(yyruleno!=88);
      /* (90) customOptionBody ::= */ yytestcase(yyruleno==90);
      /* (91) customOptionBody ::= customOptionBody exIdent */ yytestcase(yyruleno==91);
      /* (93) customOptionBody ::= customOptionBody symbolsWithoutCurly */ yytestcase(yyruleno==93);
      /* (94) customOptionBody ::= customOptionBody intLit */ yytestcase(yyruleno==94);
      /* (95) customOptionBody ::= customOptionBody customOptionValue */ yytestcase(yyruleno==95);
      /* (129) topLevelDef ::= message (OPTIMIZED OUT) */ assert(yyruleno!=129);
      /* (130) topLevelDef ::= enum (OPTIMIZED OUT) */ assert(yyruleno!=130);
      /* (131) topLevelDef ::= extend (OPTIMIZED OUT) */ assert(yyruleno!=131);
      /* (132) topLevelDef ::= service (OPTIMIZED OUT) */ assert(yyruleno!=132);
      /* (133) messageBody ::= messageBody extend */ yytestcase(yyruleno==133);
      /* (134) messageBody ::= messageBody extensions */ yytestcase(yyruleno==134);
      /* (135) messageBody ::= messageBody option */ yytestcase(yyruleno==135);
      /* (136) messageBody ::= messageBody reserved */ yytestcase(yyruleno==136);
      /* (137) messageBody ::= messageBody emptyStatement */ yytestcase(yyruleno==137);
      /* (138) enumBody ::= enumBody reserved */ yytestcase(yyruleno==138);
      /* (139) enumBody ::= enumBody option */ yytestcase(yyruleno==139);
      /* (140) enumBody ::= enumBody emptyStatement */ yytestcase(yyruleno==140);
      /* (141) enumValueOptions ::= enumValueOption (OPTIMIZED OUT) */ assert(yyruleno!=141);
      /* (145) serviceBody ::= serviceBody option */ yytestcase(yyruleno==145);
      /* (146) serviceBody ::= serviceBody emptyStatement */ yytestcase(yyruleno==146);
      /* (149) rpcBody ::= */ yytestcase(yyruleno==149);
      /* (150) rpcBody ::= rpcBody option */ yytestcase(yyruleno==150);
      /* (151) rpcBody ::= rpcBody emptyStatement */ yytestcase(yyruleno==151);
      /* (154) streamBody ::= */ yytestcase(yyruleno==154);
      /* (155) streamBody ::= streamBody option */ yytestcase(yyruleno==155);
      /* (156) streamBody ::= streamBody emptyStatement */ yytestcase(yyruleno==156);
      /* (157) groupName ::= exIdent (OPTIMIZED OUT) */ assert(yyruleno!=157);
      /* (158) oneofBody ::= oneofBody option */ yytestcase(yyruleno==158);
      /* (159) oneofBody ::= oneofBody group */ yytestcase(yyruleno==159);
      /* (160) oneofBody ::= oneofBody emptyStatement */ yytestcase(yyruleno==160);
      /* (163) declarations ::= declaration (OPTIMIZED OUT) */ assert(yyruleno!=163);
      /* (170) ranges ::= range (OPTIMIZED OUT) */ assert(yyruleno!=170);
      /* (172) range ::= intLit */ yytestcase(yyruleno==172);
      /* (175) quoteFieldNames ::= strLit */ yytestcase(yyruleno==175);
      /* (177) reservedIdent ::= fieldName */ yytestcase(yyruleno==177);
      /* (179) extendBody ::= extendBody emptyStatement */ yytestcase(yyruleno==179);
      /* (180) messageName ::= exIdent (OPTIMIZED OUT) */ assert(yyruleno!=180);
      /* (181) enumName ::= exIdent (OPTIMIZED OUT) */ assert(yyruleno!=181);
      /* (182) streamName ::= exIdent (OPTIMIZED OUT) */ assert(yyruleno!=182);
      /* (183) fieldName ::= exIdent (OPTIMIZED OUT) */ assert(yyruleno!=183);
      /* (184) oneofName ::= exIdent (OPTIMIZED OUT) */ assert(yyruleno!=184);
      /* (185) mapName ::= exIdent (OPTIMIZED OUT) */ assert(yyruleno!=185);
      /* (186) serviceName ::= exIdent (OPTIMIZED OUT) */ assert(yyruleno!=186);
      /* (187) rpcName ::= exIdent (OPTIMIZED OUT) */ assert(yyruleno!=187);
      /* (189) constant ::= strLit */ yytestcase(yyruleno==189);
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfoLhs)/sizeof(yyRuleInfoLhs[0]) );
  yygoto = yyRuleInfoLhs[yyruleno];
  yysize = yyRuleInfoNRhs[yyruleno];
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ProtobufLangParserARG_FETCH
  ProtobufLangParserCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
#line 81 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"

    pbl_parser_error(state, "Parse Error");
    state->grammar_error = TRUE;
#line 2884 "./protobuf_lang_parser.c"
/************ End %parse_failure code *****************************************/
  ProtobufLangParserARG_STORE /* Suppress warning about unused %extra_argument variable */
  ProtobufLangParserCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ProtobufLangParserTOKENTYPE yyminor         /* The minor type of the error token */
){
  ProtobufLangParserARG_FETCH
  ProtobufLangParserCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/
#line 72 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"

    if (yyminor) {
        pbl_parser_error(state, "Syntax Error: unexpected token \"%s\"", yyminor->v);
    } else {
        pbl_parser_error(state, "Syntax Error: missing token");
    }
    state->grammar_error = TRUE;
#line 2911 "./protobuf_lang_parser.c"
/************ End %syntax_error code ******************************************/
  ProtobufLangParserARG_STORE /* Suppress warning about unused %extra_argument variable */
  ProtobufLangParserCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ProtobufLangParserARG_FETCH
  ProtobufLangParserCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ProtobufLangParserARG_STORE /* Suppress warning about unused %extra_argument variable */
  ProtobufLangParserCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ProtobufLangParserAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void ProtobufLangParser(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ProtobufLangParserTOKENTYPE yyminor       /* The value for the token */
  ProtobufLangParserARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ProtobufLangParserCTX_FETCH
  ProtobufLangParserARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  while(1){ /* Exit by "break" */
    assert( yypParser->yytos>=yypParser->yystack );
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      unsigned int yyruleno = yyact - YY_MIN_REDUCE; /* Reduce by this rule */
#ifndef NDEBUG
      assert( yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) );
      if( yyTraceFILE ){
        int yysize = yyRuleInfoNRhs[yyruleno];
        if( yysize ){
          fprintf(yyTraceFILE, "%sReduce %d [%s]%s, pop back to state %d.\n",
            yyTracePrompt,
            yyruleno, yyRuleName[yyruleno],
            yyruleno<YYNRULE_WITH_ACTION ? "" : " without external action",
            yypParser->yytos[yysize].stateno);
        }else{
          fprintf(yyTraceFILE, "%sReduce %d [%s]%s.\n",
            yyTracePrompt, yyruleno, yyRuleName[yyruleno],
            yyruleno<YYNRULE_WITH_ACTION ? "" : " without external action");
        }
      }
#endif /* NDEBUG */

      /* Check that the stack is large enough to grow by a single entry
      ** if the RHS of the rule is empty.  This ensures that there is room
      ** enough on the stack to push the LHS value */
      if( yyRuleInfoNRhs[yyruleno]==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
        if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
          yypParser->yyhwm++;
          assert( yypParser->yyhwm ==
                  (int)(yypParser->yytos - yypParser->yystack));
        }
#endif
#if YYSTACKDEPTH>0
        if( yypParser->yytos>=yypParser->yystackEnd ){
          yyStackOverflow(yypParser);
          break;
        }
#else
        if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
          if( yyGrowStack(yypParser) ){
            yyStackOverflow(yypParser);
            break;
          }
        }
#endif
      }
      yyact = yy_reduce(yypParser,yyruleno,yymajor,yyminor ProtobufLangParserCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos > yypParser->yystack ){
          yyact = yy_find_reduce_action(yypParser->yytos->stateno,
                                        YYERRORSYMBOL);
          if( yyact<=YY_MAX_SHIFTREDUCE ) break;
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos <= yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ProtobufLangParserFallback(int iToken){
#ifdef YYFALLBACK
  assert( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) );
  return yyFallback[iToken];
#else
  (void)iToken;
  return 0;
#endif
}
#line 56 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"

DIAG_ON_LEMON()
#line 600 "/build/wireshark/src/wireshark/epan/protobuf_lang_parser.lemon"


void
protobuf_lang_error(void* yyscanner, protobuf_lang_state_t *state, const char *msg)
{
    int lineno;
    void(*error_cb)(const char *format, ...);
    const char* filepath = (state && state->file) ?
                            state->file->filename : "UNKNOWN";

    error_cb = (state && state->pool->error_cb) ?
                state->pool->error_cb : pbl_printf;

    lineno = yyscanner ? protobuf_lang_get_lineno(yyscanner) : -1;

    if (lineno > -1) {
        error_cb("Protobuf: Parsing file [%s:%d] failed: %s\n", filepath, lineno, msg);
    } else {
        error_cb("Protobuf: Parsing file [%s] failed: %s\n", filepath, msg);
    }
}

void
pbl_parser_error(protobuf_lang_state_t *state, const char *fmt, ...)
{
    char* msg;
    void* scanner;
    va_list ap;
    va_start(ap, fmt);
    msg = ws_strdup_vprintf(fmt, ap);
    scanner = state ? state->scanner : NULL;
    protobuf_lang_error(scanner, state, msg);
    va_end(ap);
    g_free(msg);
}

static void
pbl_clear_state(protobuf_lang_state_t *state, pbl_descriptor_pool_t* pool)
{
    if (state == NULL) {
        return;
    }

    state->pool = NULL;
    state->file = NULL;
    state->grammar_error = FALSE;
    state->tmp_token = NULL;

    if (state->scanner) {
        protobuf_lang_lex_destroy(state->scanner);
        state->scanner = NULL;
    }

    if (state->pParser) {
        ProtobufLangParserFree(state->pParser, g_free);
        state->pParser = NULL;
    }

    if (state->lex_string_tokens) {
        g_slist_free_full(state->lex_string_tokens, g_free);
        state->lex_string_tokens = NULL;
    }

    if (state->lex_struct_tokens) {
        g_slist_free_full(state->lex_struct_tokens, g_free);
        state->lex_struct_tokens = NULL;
    }

    if (pool) {
        pool->parser_state = NULL;
    }
}

static void
pbl_reinit_state(protobuf_lang_state_t *state, pbl_descriptor_pool_t* pool, const char* filepath)
{
    if (state == NULL) {
        return;
    }
    pbl_clear_state(state, pool);

    state->pool = pool;
    state->file = (pbl_file_descriptor_t*) g_hash_table_lookup(pool->proto_files, filepath);
    state->pParser = ProtobufLangParserAlloc(g_malloc0);

    if (pool) {
        pool->parser_state = state;
    }
}

int run_pbl_parser(pbl_descriptor_pool_t* pool)
{
    protobuf_lang_state_t state = {0};
    yyscan_t scanner;
    FILE * fp;
    int status = 0;
    int token_id;
    const char* filepath;

    while (!g_queue_is_empty(pool->proto_files_to_be_parsed)) {
        filepath = (const char*) g_queue_peek_head(pool->proto_files_to_be_parsed);
        /* reinit state and scanner */
        pbl_reinit_state(&state, pool, filepath);
        scanner = NULL;

        /* Note that filepath is absolute path in proto_files */
        fp = ws_fopen(filepath, "r");
        if (fp == NULL) {
            pbl_parser_error(&state, "File does not exists!");
            status = -1;
            goto finish;
        }

        status = protobuf_lang_lex_init(&scanner);
        if (status != 0) {
            pbl_parser_error(&state, "Initialize Protocol Buffers Language scanner failed!\n");
            fclose(fp);
            goto finish;
        }

        /* associate the parser state with the lexical analyzer state */
        protobuf_lang_set_extra(&state, scanner);
        state.scanner = scanner;

        protobuf_lang_restart(fp, scanner);
        /* uncomment the next line for debugging */
        /* ProtobufLangParserTrace(stdout, ">>>"); */
        while (!state.grammar_error && (token_id = protobuf_lang_lex(scanner))) {
            /* state.tmp_token contains token string value and lineno information */
            ProtobufLangParser(state.pParser, token_id, state.tmp_token, &state);
        }
        fclose(fp);

        if (state.grammar_error) {
            status = -2;
            goto finish;
        } else {
            ProtobufLangParser(state.pParser, 0, NULL, &state);
        }

        /* remove the parsed file from list */
        g_queue_pop_head(pool->proto_files_to_be_parsed);
    }

finish:
    pbl_clear_state(&state, pool);
    return status;
}

#line 3340 "./protobuf_lang_parser.c"
