/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSNavigatorUAData.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "DOMPromiseProxy.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertPromise.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSDOMWrapperCache.h"
#include "JSNavigatorUABrandVersion.h"
#include "JSUADataValues.h"
#include "JSUALowEntropyJSON.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsNavigatorUADataPrototypeFunction_getHighEntropyValues);
static JSC_DECLARE_HOST_FUNCTION(jsNavigatorUADataPrototypeFunction_toJSON);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsNavigatorUADataConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsNavigatorUAData_brands);
static JSC_DECLARE_CUSTOM_GETTER(jsNavigatorUAData_mobile);
static JSC_DECLARE_CUSTOM_GETTER(jsNavigatorUAData_platform);

class JSNavigatorUADataPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSNavigatorUADataPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSNavigatorUADataPrototype* ptr = new (NotNull, JSC::allocateCell<JSNavigatorUADataPrototype>(vm)) JSNavigatorUADataPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSNavigatorUADataPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSNavigatorUADataPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSNavigatorUADataPrototype, JSNavigatorUADataPrototype::Base);

using JSNavigatorUADataDOMConstructor = JSDOMConstructorNotConstructable<JSNavigatorUAData>;

template<> const ClassInfo JSNavigatorUADataDOMConstructor::s_info = { "NavigatorUAData"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSNavigatorUADataDOMConstructor) };

template<> JSValue JSNavigatorUADataDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSNavigatorUADataDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "NavigatorUAData"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSNavigatorUAData::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 6> JSNavigatorUADataPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsNavigatorUADataConstructor, 0 } },
    HashTableValue { "brands"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsNavigatorUAData_brands, 0 } },
    HashTableValue { "mobile"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsNavigatorUAData_mobile, 0 } },
    HashTableValue { "platform"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsNavigatorUAData_platform, 0 } },
    HashTableValue { "getHighEntropyValues"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsNavigatorUADataPrototypeFunction_getHighEntropyValues, 1 } },
    HashTableValue { "toJSON"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsNavigatorUADataPrototypeFunction_toJSON, 0 } },
};

const ClassInfo JSNavigatorUADataPrototype::s_info = { "NavigatorUAData"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSNavigatorUADataPrototype) };

void JSNavigatorUADataPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSNavigatorUAData::info(), JSNavigatorUADataPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSNavigatorUAData::s_info = { "NavigatorUAData"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSNavigatorUAData) };

JSNavigatorUAData::JSNavigatorUAData(Structure* structure, JSDOMGlobalObject& globalObject, Ref<NavigatorUAData>&& impl)
    : JSDOMWrapper<NavigatorUAData>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, NavigatorUAData>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSNavigatorUAData::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSNavigatorUADataPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSNavigatorUADataPrototype::create(vm, &globalObject, structure);
}

JSObject* JSNavigatorUAData::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSNavigatorUAData>(vm, globalObject);
}

JSValue JSNavigatorUAData::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSNavigatorUADataDOMConstructor, DOMConstructorID::NavigatorUAData>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSNavigatorUAData::destroy(JSC::JSCell* cell)
{
    JSNavigatorUAData* thisObject = static_cast<JSNavigatorUAData*>(cell);
    thisObject->JSNavigatorUAData::~JSNavigatorUAData();
}

JSC_DEFINE_CUSTOM_GETTER(jsNavigatorUADataConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSNavigatorUADataPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSNavigatorUAData::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsNavigatorUAData_brandsGetter(JSGlobalObject& lexicalGlobalObject, JSNavigatorUAData& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLFrozenArray<IDLDictionary<NavigatorUABrandVersion>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.brands())));
}

JSC_DEFINE_CUSTOM_GETTER(jsNavigatorUAData_brands, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSNavigatorUAData>::get<jsNavigatorUAData_brandsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsNavigatorUAData_mobileGetter(JSGlobalObject& lexicalGlobalObject, JSNavigatorUAData& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.mobile())));
}

JSC_DEFINE_CUSTOM_GETTER(jsNavigatorUAData_mobile, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSNavigatorUAData>::get<jsNavigatorUAData_mobileGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsNavigatorUAData_platformGetter(JSGlobalObject& lexicalGlobalObject, JSNavigatorUAData& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.platform())));
}

JSC_DEFINE_CUSTOM_GETTER(jsNavigatorUAData_platform, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSNavigatorUAData>::get<jsNavigatorUAData_platformGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSC::EncodedJSValue jsNavigatorUADataPrototypeFunction_getHighEntropyValuesBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSNavigatorUAData>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto hintsConversionResult = convert<IDLSequence<IDLDOMString>>(*lexicalGlobalObject, argument0.value());
    if (hintsConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLDictionary<UADataValues>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.getHighEntropyValues(hintsConversionResult.releaseReturnValue(), WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsNavigatorUADataPrototypeFunction_getHighEntropyValues, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSNavigatorUAData>::call<jsNavigatorUADataPrototypeFunction_getHighEntropyValuesBody>(*lexicalGlobalObject, *callFrame, "getHighEntropyValues");
}

static inline JSC::EncodedJSValue jsNavigatorUADataPrototypeFunction_toJSONBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSNavigatorUAData>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLDictionary<UALowEntropyJSON>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.toJSON())));
}

JSC_DEFINE_HOST_FUNCTION(jsNavigatorUADataPrototypeFunction_toJSON, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSNavigatorUAData>::call<jsNavigatorUADataPrototypeFunction_toJSONBody>(*lexicalGlobalObject, *callFrame, "toJSON");
}

JSC::GCClient::IsoSubspace* JSNavigatorUAData::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSNavigatorUAData, UseCustomHeapCellType::No>(vm, "JSNavigatorUAData"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForNavigatorUAData.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForNavigatorUAData = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForNavigatorUAData.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForNavigatorUAData = std::forward<decltype(space)>(space); }
    );
}

void JSNavigatorUAData::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSNavigatorUAData*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSNavigatorUADataOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSNavigatorUADataOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsNavigatorUAData = static_cast<JSNavigatorUAData*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsNavigatorUAData->protectedWrapped().ptr(), jsNavigatorUAData);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7NavigatorUAData@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore15NavigatorUADataE[]; }
#endif
template<std::same_as<NavigatorUAData> T>
static inline void verifyVTable(NavigatorUAData* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7NavigatorUAData@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore15NavigatorUADataE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // NavigatorUAData has subclasses. If NavigatorUAData has subclasses that get passed
        // to toJS() we currently require NavigatorUAData you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<NavigatorUAData>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<NavigatorUAData>(impl.ptr());
#endif
    return createWrapper<NavigatorUAData>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, NavigatorUAData& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

NavigatorUAData* JSNavigatorUAData::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSNavigatorUAData*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
