/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPUStorageTextureBindingLayout.h"

#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertOptional.h"
#include "JSGPUStorageTextureAccess.h"
#include "JSGPUTextureFormat.h"
#include "JSGPUTextureViewDimension.h"
#include <JavaScriptCore/JSCInlines.h>



namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<GPUStorageTextureBindingLayout>> convertDictionary<GPUStorageTextureBindingLayout>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    GPUStorageTextureBindingLayout result;
    JSValue accessValue;
    if (isNullOrUndefined)
        accessValue = jsUndefined();
    else {
        accessValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "access"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto accessConversionResult = convertOptionalWithDefault<IDLEnumeration<GPUStorageTextureAccess>>(lexicalGlobalObject, accessValue, [&]() -> ConversionResult<IDLEnumeration<GPUStorageTextureAccess>> { return Converter<IDLEnumeration<GPUStorageTextureAccess>>::ReturnType { GPUStorageTextureAccess::WriteOnly }; });
    if (accessConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.access = accessConversionResult.releaseReturnValue();
    JSValue formatValue;
    if (isNullOrUndefined)
        formatValue = jsUndefined();
    else {
        formatValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "format"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (formatValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "format"_s, "GPUStorageTextureBindingLayout"_s, "GPUTextureFormat"_s);
        return ConversionResultException { };
    }
    auto formatConversionResult = convert<IDLEnumeration<GPUTextureFormat>>(lexicalGlobalObject, formatValue);
    if (formatConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.format = formatConversionResult.releaseReturnValue();
    JSValue viewDimensionValue;
    if (isNullOrUndefined)
        viewDimensionValue = jsUndefined();
    else {
        viewDimensionValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "viewDimension"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto viewDimensionConversionResult = convertOptionalWithDefault<IDLEnumeration<GPUTextureViewDimension>>(lexicalGlobalObject, viewDimensionValue, [&]() -> ConversionResult<IDLEnumeration<GPUTextureViewDimension>> { return Converter<IDLEnumeration<GPUTextureViewDimension>>::ReturnType { GPUTextureViewDimension::_2d }; });
    if (viewDimensionConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.viewDimension = viewDimensionConversionResult.releaseReturnValue();
    return result;
}

} // namespace WebCore

