/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPUTextureViewDescriptor.h"

#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMGlobalObject.h"
#include "JSGPUTextureAspect.h"
#include "JSGPUTextureFormat.h"
#include "JSGPUTextureViewDimension.h"
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/ObjectConstructor.h>



namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<GPUTextureViewDescriptor>> convertDictionary<GPUTextureViewDescriptor>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    GPUTextureViewDescriptor result;
    JSValue labelValue;
    if (isNullOrUndefined)
        labelValue = jsUndefined();
    else {
        labelValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "label"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!labelValue.isUndefined()) {
        auto labelConversionResult = convert<IDLUSVString>(lexicalGlobalObject, labelValue);
        if (labelConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.label = labelConversionResult.releaseReturnValue();
    }
    JSValue arrayLayerCountValue;
    if (isNullOrUndefined)
        arrayLayerCountValue = jsUndefined();
    else {
        arrayLayerCountValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "arrayLayerCount"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!arrayLayerCountValue.isUndefined()) {
        auto arrayLayerCountConversionResult = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, arrayLayerCountValue);
        if (arrayLayerCountConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.arrayLayerCount = arrayLayerCountConversionResult.releaseReturnValue();
    }
    JSValue aspectValue;
    if (isNullOrUndefined)
        aspectValue = jsUndefined();
    else {
        aspectValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "aspect"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto aspectConversionResult = convertOptionalWithDefault<IDLEnumeration<GPUTextureAspect>>(lexicalGlobalObject, aspectValue, [&]() -> ConversionResult<IDLEnumeration<GPUTextureAspect>> { return Converter<IDLEnumeration<GPUTextureAspect>>::ReturnType { GPUTextureAspect::All }; });
    if (aspectConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.aspect = aspectConversionResult.releaseReturnValue();
    JSValue baseArrayLayerValue;
    if (isNullOrUndefined)
        baseArrayLayerValue = jsUndefined();
    else {
        baseArrayLayerValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "baseArrayLayer"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto baseArrayLayerConversionResult = convertOptionalWithDefault<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, baseArrayLayerValue, [&]() -> ConversionResult<IDLEnforceRangeAdaptor<IDLUnsignedLong>> { return Converter<IDLEnforceRangeAdaptor<IDLUnsignedLong>>::ReturnType { 0 }; });
    if (baseArrayLayerConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.baseArrayLayer = baseArrayLayerConversionResult.releaseReturnValue();
    JSValue baseMipLevelValue;
    if (isNullOrUndefined)
        baseMipLevelValue = jsUndefined();
    else {
        baseMipLevelValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "baseMipLevel"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto baseMipLevelConversionResult = convertOptionalWithDefault<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, baseMipLevelValue, [&]() -> ConversionResult<IDLEnforceRangeAdaptor<IDLUnsignedLong>> { return Converter<IDLEnforceRangeAdaptor<IDLUnsignedLong>>::ReturnType { 0 }; });
    if (baseMipLevelConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.baseMipLevel = baseMipLevelConversionResult.releaseReturnValue();
    JSValue dimensionValue;
    if (isNullOrUndefined)
        dimensionValue = jsUndefined();
    else {
        dimensionValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "dimension"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!dimensionValue.isUndefined()) {
        auto dimensionConversionResult = convert<IDLEnumeration<GPUTextureViewDimension>>(lexicalGlobalObject, dimensionValue);
        if (dimensionConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.dimension = dimensionConversionResult.releaseReturnValue();
    }
    JSValue formatValue;
    if (isNullOrUndefined)
        formatValue = jsUndefined();
    else {
        formatValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "format"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!formatValue.isUndefined()) {
        auto formatConversionResult = convert<IDLEnumeration<GPUTextureFormat>>(lexicalGlobalObject, formatValue);
        if (formatConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.format = formatConversionResult.releaseReturnValue();
    }
    JSValue mipLevelCountValue;
    if (isNullOrUndefined)
        mipLevelCountValue = jsUndefined();
    else {
        mipLevelCountValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "mipLevelCount"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!mipLevelCountValue.isUndefined()) {
        auto mipLevelCountConversionResult = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, mipLevelCountValue);
        if (mipLevelCountConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.mipLevelCount = mipLevelCountConversionResult.releaseReturnValue();
    }
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const GPUTextureViewDescriptor& dictionary)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    if (!IDLUSVString::isNullValue(dictionary.label)) {
        auto labelValue = toJS<IDLUSVString>(lexicalGlobalObject, throwScope, IDLUSVString::extractValueFromNullable(dictionary.label));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "label"_s), labelValue);
    }
    if (!IDLEnforceRangeAdaptor<IDLUnsignedLong>::isNullValue(dictionary.arrayLayerCount)) {
        auto arrayLayerCountValue = toJS<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, throwScope, IDLEnforceRangeAdaptor<IDLUnsignedLong>::extractValueFromNullable(dictionary.arrayLayerCount));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "arrayLayerCount"_s), arrayLayerCountValue);
    }
    auto aspectValue = toJS<IDLEnumeration<GPUTextureAspect>>(lexicalGlobalObject, throwScope, dictionary.aspect);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "aspect"_s), aspectValue);
    auto baseArrayLayerValue = toJS<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, throwScope, dictionary.baseArrayLayer);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "baseArrayLayer"_s), baseArrayLayerValue);
    auto baseMipLevelValue = toJS<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, throwScope, dictionary.baseMipLevel);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "baseMipLevel"_s), baseMipLevelValue);
    if (!IDLEnumeration<GPUTextureViewDimension>::isNullValue(dictionary.dimension)) {
        auto dimensionValue = toJS<IDLEnumeration<GPUTextureViewDimension>>(lexicalGlobalObject, throwScope, IDLEnumeration<GPUTextureViewDimension>::extractValueFromNullable(dictionary.dimension));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "dimension"_s), dimensionValue);
    }
    if (!IDLEnumeration<GPUTextureFormat>::isNullValue(dictionary.format)) {
        auto formatValue = toJS<IDLEnumeration<GPUTextureFormat>>(lexicalGlobalObject, throwScope, IDLEnumeration<GPUTextureFormat>::extractValueFromNullable(dictionary.format));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "format"_s), formatValue);
    }
    if (!IDLEnforceRangeAdaptor<IDLUnsignedLong>::isNullValue(dictionary.mipLevelCount)) {
        auto mipLevelCountValue = toJS<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, throwScope, IDLEnforceRangeAdaptor<IDLUnsignedLong>::extractValueFromNullable(dictionary.mipLevelCount));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "mipLevelCount"_s), mipLevelCountValue);
    }
    return result;
}

} // namespace WebCore

