/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPUFeatureName.h"

#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>
#include <wtf/SortedArrayMap.h>



namespace WebCore {
using namespace JSC;

String convertEnumerationToString(GPUFeatureName enumerationValue)
{
    static const std::array<NeverDestroyed<String>, 19> values {
        MAKE_STATIC_STRING_IMPL("depth-clip-control"),
        MAKE_STATIC_STRING_IMPL("depth32float-stencil8"),
        MAKE_STATIC_STRING_IMPL("texture-compression-bc"),
        MAKE_STATIC_STRING_IMPL("texture-compression-bc-sliced-3d"),
        MAKE_STATIC_STRING_IMPL("texture-compression-etc2"),
        MAKE_STATIC_STRING_IMPL("texture-compression-astc"),
        MAKE_STATIC_STRING_IMPL("texture-compression-astc-sliced-3d"),
        MAKE_STATIC_STRING_IMPL("timestamp-query"),
        MAKE_STATIC_STRING_IMPL("indirect-first-instance"),
        MAKE_STATIC_STRING_IMPL("shader-f16"),
        MAKE_STATIC_STRING_IMPL("rg11b10ufloat-renderable"),
        MAKE_STATIC_STRING_IMPL("bgra8unorm-storage"),
        MAKE_STATIC_STRING_IMPL("float32-filterable"),
        MAKE_STATIC_STRING_IMPL("float32-blendable"),
        MAKE_STATIC_STRING_IMPL("clip-distances"),
        MAKE_STATIC_STRING_IMPL("dual-source-blending"),
        MAKE_STATIC_STRING_IMPL("float16-renderable"),
        MAKE_STATIC_STRING_IMPL("float32-renderable"),
        MAKE_STATIC_STRING_IMPL("core-features-and-limits"),
    };
    static_assert(static_cast<size_t>(GPUFeatureName::DepthClipControl) == 0, "GPUFeatureName::DepthClipControl is not 0 as expected");
    static_assert(static_cast<size_t>(GPUFeatureName::Depth32floatStencil8) == 1, "GPUFeatureName::Depth32floatStencil8 is not 1 as expected");
    static_assert(static_cast<size_t>(GPUFeatureName::TextureCompressionBc) == 2, "GPUFeatureName::TextureCompressionBc is not 2 as expected");
    static_assert(static_cast<size_t>(GPUFeatureName::TextureCompressionBcSliced3d) == 3, "GPUFeatureName::TextureCompressionBcSliced3d is not 3 as expected");
    static_assert(static_cast<size_t>(GPUFeatureName::TextureCompressionEtc2) == 4, "GPUFeatureName::TextureCompressionEtc2 is not 4 as expected");
    static_assert(static_cast<size_t>(GPUFeatureName::TextureCompressionAstc) == 5, "GPUFeatureName::TextureCompressionAstc is not 5 as expected");
    static_assert(static_cast<size_t>(GPUFeatureName::TextureCompressionAstcSliced3d) == 6, "GPUFeatureName::TextureCompressionAstcSliced3d is not 6 as expected");
    static_assert(static_cast<size_t>(GPUFeatureName::TimestampQuery) == 7, "GPUFeatureName::TimestampQuery is not 7 as expected");
    static_assert(static_cast<size_t>(GPUFeatureName::IndirectFirstInstance) == 8, "GPUFeatureName::IndirectFirstInstance is not 8 as expected");
    static_assert(static_cast<size_t>(GPUFeatureName::ShaderF16) == 9, "GPUFeatureName::ShaderF16 is not 9 as expected");
    static_assert(static_cast<size_t>(GPUFeatureName::Rg11b10ufloatRenderable) == 10, "GPUFeatureName::Rg11b10ufloatRenderable is not 10 as expected");
    static_assert(static_cast<size_t>(GPUFeatureName::Bgra8unormStorage) == 11, "GPUFeatureName::Bgra8unormStorage is not 11 as expected");
    static_assert(static_cast<size_t>(GPUFeatureName::Float32Filterable) == 12, "GPUFeatureName::Float32Filterable is not 12 as expected");
    static_assert(static_cast<size_t>(GPUFeatureName::Float32Blendable) == 13, "GPUFeatureName::Float32Blendable is not 13 as expected");
    static_assert(static_cast<size_t>(GPUFeatureName::ClipDistances) == 14, "GPUFeatureName::ClipDistances is not 14 as expected");
    static_assert(static_cast<size_t>(GPUFeatureName::DualSourceBlending) == 15, "GPUFeatureName::DualSourceBlending is not 15 as expected");
    static_assert(static_cast<size_t>(GPUFeatureName::Float16Renderable) == 16, "GPUFeatureName::Float16Renderable is not 16 as expected");
    static_assert(static_cast<size_t>(GPUFeatureName::Float32Renderable) == 17, "GPUFeatureName::Float32Renderable is not 17 as expected");
    static_assert(static_cast<size_t>(GPUFeatureName::CoreFeaturesAndLimits) == 18, "GPUFeatureName::CoreFeaturesAndLimits is not 18 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, GPUFeatureName enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<GPUFeatureName> parseEnumerationFromString<GPUFeatureName>(const String& stringValue)
{
    static constexpr std::array<std::pair<ComparableASCIILiteral, GPUFeatureName>, 19> mappings {
        std::pair<ComparableASCIILiteral, GPUFeatureName> { "bgra8unorm-storage"_s, GPUFeatureName::Bgra8unormStorage },
        std::pair<ComparableASCIILiteral, GPUFeatureName> { "clip-distances"_s, GPUFeatureName::ClipDistances },
        std::pair<ComparableASCIILiteral, GPUFeatureName> { "core-features-and-limits"_s, GPUFeatureName::CoreFeaturesAndLimits },
        std::pair<ComparableASCIILiteral, GPUFeatureName> { "depth-clip-control"_s, GPUFeatureName::DepthClipControl },
        std::pair<ComparableASCIILiteral, GPUFeatureName> { "depth32float-stencil8"_s, GPUFeatureName::Depth32floatStencil8 },
        std::pair<ComparableASCIILiteral, GPUFeatureName> { "dual-source-blending"_s, GPUFeatureName::DualSourceBlending },
        std::pair<ComparableASCIILiteral, GPUFeatureName> { "float16-renderable"_s, GPUFeatureName::Float16Renderable },
        std::pair<ComparableASCIILiteral, GPUFeatureName> { "float32-blendable"_s, GPUFeatureName::Float32Blendable },
        std::pair<ComparableASCIILiteral, GPUFeatureName> { "float32-filterable"_s, GPUFeatureName::Float32Filterable },
        std::pair<ComparableASCIILiteral, GPUFeatureName> { "float32-renderable"_s, GPUFeatureName::Float32Renderable },
        std::pair<ComparableASCIILiteral, GPUFeatureName> { "indirect-first-instance"_s, GPUFeatureName::IndirectFirstInstance },
        std::pair<ComparableASCIILiteral, GPUFeatureName> { "rg11b10ufloat-renderable"_s, GPUFeatureName::Rg11b10ufloatRenderable },
        std::pair<ComparableASCIILiteral, GPUFeatureName> { "shader-f16"_s, GPUFeatureName::ShaderF16 },
        std::pair<ComparableASCIILiteral, GPUFeatureName> { "texture-compression-astc"_s, GPUFeatureName::TextureCompressionAstc },
        std::pair<ComparableASCIILiteral, GPUFeatureName> { "texture-compression-astc-sliced-3d"_s, GPUFeatureName::TextureCompressionAstcSliced3d },
        std::pair<ComparableASCIILiteral, GPUFeatureName> { "texture-compression-bc"_s, GPUFeatureName::TextureCompressionBc },
        std::pair<ComparableASCIILiteral, GPUFeatureName> { "texture-compression-bc-sliced-3d"_s, GPUFeatureName::TextureCompressionBcSliced3d },
        std::pair<ComparableASCIILiteral, GPUFeatureName> { "texture-compression-etc2"_s, GPUFeatureName::TextureCompressionEtc2 },
        std::pair<ComparableASCIILiteral, GPUFeatureName> { "timestamp-query"_s, GPUFeatureName::TimestampQuery },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); enumerationValue) [[likely]]
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<GPUFeatureName> parseEnumeration<GPUFeatureName>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<GPUFeatureName>(value.toWTFString(&lexicalGlobalObject));
}

template<> ASCIILiteral expectedEnumerationValues<GPUFeatureName>()
{
    return "\"depth-clip-control\", \"depth32float-stencil8\", \"texture-compression-bc\", \"texture-compression-bc-sliced-3d\", \"texture-compression-etc2\", \"texture-compression-astc\", \"texture-compression-astc-sliced-3d\", \"timestamp-query\", \"indirect-first-instance\", \"shader-f16\", \"rg11b10ufloat-renderable\", \"bgra8unorm-storage\", \"float32-filterable\", \"float32-blendable\", \"clip-distances\", \"dual-source-blending\", \"float16-renderable\", \"float32-renderable\", \"core-features-and-limits\""_s;
}

} // namespace WebCore

