// This file is generated by "./lib/proto/generate"

package proto

/*

Performance

*/

// PerformanceMetric Run-time execution metric.
type PerformanceMetric struct {
	// Name Metric name.
	Name string `json:"name"`

	// Value Metric value.
	Value float64 `json:"value"`
}

// PerformanceDisable Disable collecting and reporting metrics.
type PerformanceDisable struct{}

// ProtoReq name.
func (m PerformanceDisable) ProtoReq() string { return "Performance.disable" }

// Call sends the request.
func (m PerformanceDisable) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// PerformanceEnableTimeDomain enum.
type PerformanceEnableTimeDomain string

const (
	// PerformanceEnableTimeDomainTimeTicks enum const.
	PerformanceEnableTimeDomainTimeTicks PerformanceEnableTimeDomain = "timeTicks"

	// PerformanceEnableTimeDomainThreadTicks enum const.
	PerformanceEnableTimeDomainThreadTicks PerformanceEnableTimeDomain = "threadTicks"
)

// PerformanceEnable Enable collecting and reporting metrics.
type PerformanceEnable struct {
	// TimeDomain (optional) Time domain to use for collecting and reporting duration metrics.
	TimeDomain PerformanceEnableTimeDomain `json:"timeDomain,omitempty"`
}

// ProtoReq name.
func (m PerformanceEnable) ProtoReq() string { return "Performance.enable" }

// Call sends the request.
func (m PerformanceEnable) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// PerformanceSetTimeDomainTimeDomain enum.
type PerformanceSetTimeDomainTimeDomain string

const (
	// PerformanceSetTimeDomainTimeDomainTimeTicks enum const.
	PerformanceSetTimeDomainTimeDomainTimeTicks PerformanceSetTimeDomainTimeDomain = "timeTicks"

	// PerformanceSetTimeDomainTimeDomainThreadTicks enum const.
	PerformanceSetTimeDomainTimeDomainThreadTicks PerformanceSetTimeDomainTimeDomain = "threadTicks"
)

// PerformanceSetTimeDomain (deprecated) (experimental) Sets time domain to use for collecting and reporting duration metrics.
// Note that this must be called before enabling metrics collection. Calling
// this method while metrics collection is enabled returns an error.
type PerformanceSetTimeDomain struct {
	// TimeDomain Time domain
	TimeDomain PerformanceSetTimeDomainTimeDomain `json:"timeDomain"`
}

// ProtoReq name.
func (m PerformanceSetTimeDomain) ProtoReq() string { return "Performance.setTimeDomain" }

// Call sends the request.
func (m PerformanceSetTimeDomain) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// PerformanceGetMetrics Retrieve current values of run-time metrics.
type PerformanceGetMetrics struct{}

// ProtoReq name.
func (m PerformanceGetMetrics) ProtoReq() string { return "Performance.getMetrics" }

// Call the request.
func (m PerformanceGetMetrics) Call(c Client) (*PerformanceGetMetricsResult, error) {
	var res PerformanceGetMetricsResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// PerformanceGetMetricsResult ...
type PerformanceGetMetricsResult struct {
	// Metrics Current values for run-time metrics.
	Metrics []*PerformanceMetric `json:"metrics"`
}

// PerformanceMetrics Current values of the metrics.
type PerformanceMetrics struct {
	// Metrics Current values of the metrics.
	Metrics []*PerformanceMetric `json:"metrics"`

	// Title Timestamp title.
	Title string `json:"title"`
}

// ProtoEvent name.
func (evt PerformanceMetrics) ProtoEvent() string {
	return "Performance.metrics"
}
