// python wrapper for ttkContourTree
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "ttkContourTree.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_ttkContourTree(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyttkContourTree_ClassNew(); }


static PyObject *
PyttkContourTree_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = ttkContourTree::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkContourTree_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkContourTree *op = static_cast<ttkContourTree *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->ttkContourTree::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkContourTree_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    ttkContourTree *tempr = ttkContourTree::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkContourTree_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkContourTree *op = static_cast<ttkContourTree *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    ttkContourTree *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->ttkContourTree::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkContourTree_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = ttkContourTree::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkContourTree_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkContourTree *op = static_cast<ttkContourTree *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->ttkContourTree::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkContourTree_GetForceInputOffsetScalarField(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetForceInputOffsetScalarField");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkContourTree *op = static_cast<ttkContourTree *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetForceInputOffsetScalarField() :
      op->ttkContourTree::GetForceInputOffsetScalarField());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkContourTree_SetForceInputOffsetScalarField(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetForceInputOffsetScalarField");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkContourTree *op = static_cast<ttkContourTree *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetForceInputOffsetScalarField(temp0);
    }
    else
    {
      op->ttkContourTree::SetForceInputOffsetScalarField(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkContourTree_SetWithSegmentation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetWithSegmentation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkContourTree *op = static_cast<ttkContourTree *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetWithSegmentation(temp0);
    }
    else
    {
      op->ttkContourTree::SetWithSegmentation(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkContourTree_GetWithSegmentation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetWithSegmentation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkContourTree *op = static_cast<ttkContourTree *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetWithSegmentation() :
      op->ttkContourTree::GetWithSegmentation());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkContourTree_SetWithNormalize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetWithNormalize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkContourTree *op = static_cast<ttkContourTree *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetWithNormalize(temp0);
    }
    else
    {
      op->ttkContourTree::SetWithNormalize(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkContourTree_GetWithNormalize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetWithNormalize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkContourTree *op = static_cast<ttkContourTree *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetWithNormalize() :
      op->ttkContourTree::GetWithNormalize());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkContourTree_SetWithAdvStats(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetWithAdvStats");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkContourTree *op = static_cast<ttkContourTree *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetWithAdvStats(temp0);
    }
    else
    {
      op->ttkContourTree::SetWithAdvStats(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkContourTree_GetWithAdvStats(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetWithAdvStats");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkContourTree *op = static_cast<ttkContourTree *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetWithAdvStats() :
      op->ttkContourTree::GetWithAdvStats());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkContourTree_SetSuperArcSamplingLevel(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSuperArcSamplingLevel");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkContourTree *op = static_cast<ttkContourTree *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetSuperArcSamplingLevel(temp0);
    }
    else
    {
      op->ttkContourTree::SetSuperArcSamplingLevel(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkContourTree_GetSuperArcSamplingLevel(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSuperArcSamplingLevel");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkContourTree *op = static_cast<ttkContourTree *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetSuperArcSamplingLevel() :
      op->ttkContourTree::GetSuperArcSamplingLevel());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkContourTree_preconditionTriangulation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "preconditionTriangulation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkContourTree *op = static_cast<ttkContourTree *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->preconditionTriangulation() :
      op->ttkContourTree::preconditionTriangulation());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkContourTree_getScalars(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "getScalars");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkContourTree *op = static_cast<ttkContourTree *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->getScalars() :
      op->ttkContourTree::getScalars());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkContourTree_getOffsets(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "getOffsets");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkContourTree *op = static_cast<ttkContourTree *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->getOffsets() :
      op->ttkContourTree::getOffsets());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyttkContourTree_Methods[] = {
  {"IsTypeOf", PyttkContourTree_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyttkContourTree_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyttkContourTree_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> ttkContourTree\nC++: static ttkContourTree *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyttkContourTree_NewInstance, METH_VARARGS,
   "NewInstance(self) -> ttkContourTree\nC++: ttkContourTree *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyttkContourTree_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyttkContourTree_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetForceInputOffsetScalarField", PyttkContourTree_GetForceInputOffsetScalarField, METH_VARARGS,
   "GetForceInputOffsetScalarField(self) -> bool\nC++: virtual bool GetForceInputOffsetScalarField()\n\n"},
  {"SetForceInputOffsetScalarField", PyttkContourTree_SetForceInputOffsetScalarField, METH_VARARGS,
   "SetForceInputOffsetScalarField(self, _arg:bool) -> None\nC++: virtual void SetForceInputOffsetScalarField(bool _arg)\n\n"},
  {"SetWithSegmentation", PyttkContourTree_SetWithSegmentation, METH_VARARGS,
   "SetWithSegmentation(self, segm:bool) -> None\nC++: void SetWithSegmentation(const bool segm)\n\n"},
  {"GetWithSegmentation", PyttkContourTree_GetWithSegmentation, METH_VARARGS,
   "GetWithSegmentation(self) -> bool\nC++: bool GetWithSegmentation()\n\n"},
  {"SetWithNormalize", PyttkContourTree_SetWithNormalize, METH_VARARGS,
   "SetWithNormalize(self, norm:bool) -> None\nC++: void SetWithNormalize(const bool norm)\n\n"},
  {"GetWithNormalize", PyttkContourTree_GetWithNormalize, METH_VARARGS,
   "GetWithNormalize(self) -> bool\nC++: bool GetWithNormalize()\n\n"},
  {"SetWithAdvStats", PyttkContourTree_SetWithAdvStats, METH_VARARGS,
   "SetWithAdvStats(self, adv:bool) -> None\nC++: void SetWithAdvStats(const bool adv)\n\n"},
  {"GetWithAdvStats", PyttkContourTree_GetWithAdvStats, METH_VARARGS,
   "GetWithAdvStats(self) -> bool\nC++: bool GetWithAdvStats()\n\n"},
  {"SetSuperArcSamplingLevel", PyttkContourTree_SetSuperArcSamplingLevel, METH_VARARGS,
   "SetSuperArcSamplingLevel(self, lvl:int) -> None\nC++: void SetSuperArcSamplingLevel(int lvl)\n\n"},
  {"GetSuperArcSamplingLevel", PyttkContourTree_GetSuperArcSamplingLevel, METH_VARARGS,
   "GetSuperArcSamplingLevel(self) -> int\nC++: int GetSuperArcSamplingLevel()\n\n"},
  {"preconditionTriangulation", PyttkContourTree_preconditionTriangulation, METH_VARARGS,
   "preconditionTriangulation(self) -> int\nC++: int preconditionTriangulation()\n\n"},
  {"getScalars", PyttkContourTree_getScalars, METH_VARARGS,
   "getScalars(self) -> int\nC++: int getScalars()\n\n"},
  {"getOffsets", PyttkContourTree_getOffsets, METH_VARARGS,
   "getOffsets(self) -> int\nC++: int getOffsets()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyttkContourTree_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("force_input_offset_scalar_field"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkContourTree_GetForceInputOffsetScalarField(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkContourTree_SetForceInputOffsetScalarField(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkContourTree_SetForceInputOffsetScalarField(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetForceInputOffsetScalarField/SetForceInputOffsetScalarField\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("with_segmentation"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkContourTree_GetWithSegmentation(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkContourTree_SetWithSegmentation(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkContourTree_SetWithSegmentation(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetWithSegmentation/SetWithSegmentation\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("with_normalize"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkContourTree_GetWithNormalize(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkContourTree_SetWithNormalize(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkContourTree_SetWithNormalize(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetWithNormalize/SetWithNormalize\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("with_adv_stats"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkContourTree_GetWithAdvStats(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkContourTree_SetWithAdvStats(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkContourTree_SetWithAdvStats(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetWithAdvStats/SetWithAdvStats\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("super_arc_sampling_level"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkContourTree_GetSuperArcSamplingLevel(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkContourTree_SetSuperArcSamplingLevel(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkContourTree_SetSuperArcSamplingLevel(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetSuperArcSamplingLevel/SetSuperArcSamplingLevel\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyttkContourTree_Doc =
  "ttkContourTree - \\ingroup vtk\n\n"
  "Superclass: ttkAlgorithm\n\n"
  "\\author Charles Gueunet <charles.gueunet@kitware.com>\\date June 2017.\n\n"
  "\\sa ttk::ftm::FTMTree\n\n"
  "TTK filter for the computation of contour trees.\n\n"
  "The computation of the contour tree done by this package is done in\n"
  "parallel if TTK_ENABLE_OPENMP is set to ON, using a task based\n"
  "approach described in the article mention below. The VTK wrapper will\n"
  "first call a connectivity filter, and then call a contour tree\n"
  "computation for each connected components. The final tree is then\n"
  "aggregated.\n\n"
  "\\param Input Input scalar field, either 2D or 3D, regular\n"
  "grid or triangulation (vtkDataSet)\n"
  "\\param Segmentation control wethear or not the output should be\n"
  "    augmented\n"
  "with the segmentation.\n"
  "\\param SuperArcSamplingLevel control the number of subdivision of\n"
  "    each\n"
  "superarc. Intermediate point will be located on the barycenter of the\n"
  "corresponding portion of vertex.\n"
  "\\param Output the output of this filter is composed of:\n\n"
  "1. The nodes of the tree\n"
  "2. The arcs of the tree\n"
  "3. The semgentation of the initial dataset\n"
  "The structure of the tree (Nodes+Arcs) have a concept of nodeId,\n"
  "which is an id that is consistent between execution if\n"
  "SetWithNormalize is set to True. The downNodeId of an arc is its\n"
  "starting node (directed towards the leaves as the computation starts\n"
  "here) and the upNodeId it the ending node, in direction of the Root\n"
  "of the tree. The segmentation also contains some basics metrics like\n"
  "the size of each region (RegionSpan) or its number of vertex\n"
  "(RegionSize)\n\n"
  "This filter can be used as any other VTK filter (for instance, by\n"
  "using the sequence of calls SetInputData(), Update(), GetOutput()).\n\n"
  "Related publication\n\n"
  "\"Task-based Augmented Merge Trees with Fibonacci Heaps\"\n\n"
  "Charles Gueunet, Pierre Fortin, Julien Jomier, Julien Tierny\n\n"
  "2017 IEEE 7th Symposium on Large Data Analysis and Visualization\n"
  "(LDAV), doi: 10.1109/LDAV.2017.8231846.\n\n"
  "\"Task-based augmented contour trees with fibonacci heaps\"\n\n"
  "Charles Gueunet, Pierre Fortin, Julien Jomier, Julien Tierny\n\n"
  "IEEE Transactions on Parallel and Distributed Systems, Volume 30,\n"
  "Issue 8, Pages 1889-1905\n\n"
  "Online examples:\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/contourTreeAlignment/\"\n"
  "  >Contour Tree Alignment example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/dragon/\">Dragon\n"
  "  example\\n\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyttkContourTree_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "ttkContourTree.ttkContourTree", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyttkContourTree_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyttkContourTree_StaticNew()
{
  return ttkContourTree::New();
}

PyObject *PyttkContourTree_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyttkContourTree_Type, PyttkContourTree_Methods,
    "ttkContourTree",
 &PyttkContourTree_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("ttkAlgorithm");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyttkContourTree_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_ttkContourTree(
  PyObject *dict)
{
  PyObject *o;
  o = PyttkContourTree_ClassNew();

  if (o && PyDict_SetItemString(dict, "ttkContourTree", o) != 0)
  {
    Py_DECREF(o);
  }

}

