const char iconv_lua[] =
"local ffi    = require('ffi')\n"
"local errno  = require('errno')\n"
"local buffer = require('buffer')\n"
"local cord_ibuf_take = buffer.internal.cord_ibuf_take\n"
"local cord_ibuf_put = buffer.internal.cord_ibuf_put\n"
"\n"
"ffi.cdef[[\n"
"typedef struct iconv *iconv_t;\n"
"iconv_t tnt_iconv_open(const char *tocode, const char *fromcode);\n"
"void    tnt_iconv_close(iconv_t cd);\n"
"size_t  tnt_iconv(iconv_t cd, const char **inbuf, size_t *inbytesleft,\n"
"                   char **outbuf, size_t *outbytesleft);\n"
"]]\n"
"\n"
"local iconv_t         = ffi.typeof('struct iconv')\n"
"local char_ptr_arr_t  = ffi.typeof('char *[1]')\n"
"local cchar_ptr_arr_t = ffi.typeof('const char *[1]')\n"
"local cchar_ptr_t     = ffi.typeof('const char *')\n"
"local size_t_arr_t    = ffi.typeof('size_t [1]')\n"
"\n"
"local E2BIG    = errno['E2BIG']\n"
"local EINVAL   = errno['EINVAL']\n"
"local EILSEQ   = errno['EILSEQ']\n"
"local BUF_SIZE = 64\n"
"\n"
"local conv_rv_error = ffi.cast('void *', -1)\n"
"\n"
"local function iconv_convert(iconv, data)\n"
"    if not ffi.istype(iconv_t, iconv) then\n"
"        error(\"Usage: iconv:convert(data: string)\")\n"
"    end\n"
"    local data_len   = data:len()\n"
"    local data_ptr   = cchar_ptr_arr_t(cchar_ptr_t(data))\n"
"    local data_left  = size_t_arr_t(data_len)\n"
"\n"
"    -- prepare at lease BUF_SIZE and at most data_len bytes in shared buffer\n"
"    local output_len = data_len >= BUF_SIZE and data_len or BUF_SIZE\n"
"    local buf      = cord_ibuf_take();\n"
"    local buf_ptr  = char_ptr_arr_t()\n"
"    local buf_left = size_t_arr_t()\n"
"\n"
"    while data_left[0] > 0 do\n"
"        buf_ptr[0]  = buf:reserve(output_len)\n"
"        buf_left[0] = buf:unused()\n"
"        local res = ffi.C.tnt_iconv(iconv, data_ptr, data_left,\n"
"                                buf_ptr, buf_left)\n"
"        if res == ffi.cast('size_t', -1) then\n"
"            local err = errno()\n"
"            if err ~= E2BIG then\n"
"                cord_ibuf_put(buf)\n"
"                ffi.C.tnt_iconv(iconv, nil, nil, nil, nil)\n"
"                if err == EINVAL then\n"
"                    error('Invalid multibyte sequence')\n"
"                end\n"
"                if err == EILSEQ then\n"
"                    error('Incomplete multibyte sequence')\n"
"                end\n"
"                error('Unknown conversion error: ' .. errno.strerror(err))\n"
"            end\n"
"        end\n"
"        buf:alloc(buf:unused() - buf_left[0])\n"
"    end\n"
"\n"
"    -- iconv function sets cd's conversion state to the initial state\n"
"    ffi.C.tnt_iconv(iconv, nil, nil, nil, nil)\n"
"    local result = ffi.string(buf.rpos, buf:size())\n"
"    cord_ibuf_put(buf)\n"
"    return result\n"
"end\n"
"\n"
"local iconv_mt = {\n"
"    __call = iconv_convert,\n"
"    __tostring = function(iconv) return string.format(\"iconv: %p\", iconv) end\n"
"}\n"
"\n"
"ffi.metatype(iconv_t, iconv_mt)\n"
"\n"
"local function iconv_new(to, from)\n"
"    if type(to) ~= 'string' or type(from) ~= 'string' then\n"
"        error('Usage: iconv.new(\"CP1251\", \"KOI8-R\")')\n"
"    end\n"
"    local iconv = ffi.C.tnt_iconv_open(to, from)\n"
"    if iconv == conv_rv_error then\n"
"        error('iconv: '..errno.strerror())\n"
"    end\n"
"    ffi.gc(iconv, ffi.C.tnt_iconv_close)\n"
"    return iconv;\n"
"end\n"
"\n"
"return {\n"
"    new = iconv_new,\n"
"}\n"
""
;
