/* VPNPage.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from VPNPage.vala, do not modify */

/*-
 * Copyright (c) 2015-2019 elementary, Inc. (https://elementary.io)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Adam Bieńkowski <donadigos159@gmail.com>
 */

#include "network.h"
#include <gee.h>
#include <glib-object.h>
#include <NetworkManager.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <granite-7.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <switchboard.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	NETWORK_VPN_PAGE_0_PROPERTY,
	NETWORK_VPN_PAGE_NUM_PROPERTIES
};
static GParamSpec* network_vpn_page_properties[NETWORK_VPN_PAGE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block5Data Block5Data;
typedef struct _Block6Data Block6Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block7Data Block7Data;

struct _NetworkVPNPagePrivate {
	GeeList* active_connections;
	GtkListBox* vpn_list;
	guint timeout_id;
	NetworkVPNMenuItem* sel_row;
	GraniteToast* remove_vpn_toast;
};

struct _Block5Data {
	int _ref_count_;
	NetworkVPNPage* self;
	NetworkVPNMenuItem* item;
};

struct _Block6Data {
	int _ref_count_;
	NetworkVPNPage* self;
	NetworkNetworkManager* network_manager;
};

struct _Block7Data {
	int _ref_count_;
	NetworkVPNPage* self;
	NetworkNetworkManager* network_manager;
};

static gint NetworkVPNPage_private_offset;
static gpointer network_vpn_page_parent_class = NULL;

static void network_vpn_page_real_update (NetworkWidgetsPage* base);
static void network_vpn_page_update_active_connections (NetworkVPNPage* self);
static NetworkVPNMenuItem* network_vpn_page_get_item_by_uuid (NetworkVPNPage* self,
                                                       const gchar* uuid);
static void network_vpn_page_real_update_switch (NetworkWidgetsPage* base);
static void network_vpn_page_real_control_switch_activated (NetworkWidgetsPage* base);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void __lambda14_ (Block5Data* _data5_);
static gboolean __lambda15_ (Block5Data* _data5_);
static void network_vpn_page_delete_connection (NetworkVPNPage* self,
                                         NetworkVPNMenuItem* item);
static gboolean ___lambda15__gsource_func (gpointer self);
static void ___lambda14__network_vpn_menu_item_remove_request (NetworkVPNMenuItem* _sender,
                                                        gpointer self);
static void __lambda13_ (NetworkVPNPage* self,
                  NMActiveConnection* ac);
static void _network_widgets_page_update_nm_vpn_connection_vpn_state_changed (NMVpnConnection* _sender,
                                                                       guint object,
                                                                       guint p0,
                                                                       gpointer self);
static void _network_widgets_page_update_nm_active_connection_state_changed (NMActiveConnection* _sender,
                                                                      guint state,
                                                                      guint reason,
                                                                      gpointer self);
static void ___lambda13__gfunc (gconstpointer data,
                         gpointer self);
static void network_vpn_page_connect_vpn_cb (NetworkVPNPage* self,
                                      NetworkVPNMenuItem* item);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static void __lambda16_ (Block6Data* _data6_,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda16__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void network_vpn_page_disconnect_vpn_cb (NetworkVPNPage* self,
                                         NetworkVPNMenuItem* item);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static void _____lambda17_ (Block7Data* _data7_,
                     GObject* obj,
                     GAsyncResult* res);
static void ______lambda17__gasync_ready_callback (GObject* source_object,
                                            GAsyncResult* res,
                                            gpointer self);
static void network_vpn_page_try_connection_editor (NetworkVPNPage* self,
                                             const gchar* args);
static void _gtk_window_destroy_gtk_dialog_response (GtkDialog* _sender,
                                              gint response_id,
                                              gpointer self);
static gint network_vpn_page_compare_rows (NetworkVPNMenuItem* row1,
                                    NetworkVPNMenuItem* row2,
                                    NetworkVPNPage* self);
static GObject * network_vpn_page_constructor (GType type,
                                        guint n_construct_properties,
                                        GObjectConstructParam * construct_properties);
static void _network_vpn_page___lambda18_ (NetworkVPNPage* self);
static void __network_vpn_page___lambda18__gtk_button_clicked (GtkButton* _sender,
                                                        gpointer self);
static void _network_vpn_page___lambda19_ (NetworkVPNPage* self);
static void __network_vpn_page___lambda19__granite_toast_default_action (GraniteToast* _sender,
                                                                  gpointer self);
static void _network_vpn_page___lambda20_ (NetworkVPNPage* self,
                                    GtkListBoxRow* row);
static void __network_vpn_page___lambda20__gtk_list_box_row_activated (GtkListBox* _sender,
                                                                GtkListBoxRow* row,
                                                                gpointer self);
static void _network_vpn_page_update_active_connections_g_object_notify (GObject* _sender,
                                                                  GParamSpec* pspec,
                                                                  gpointer self);
static void network_vpn_page_finalize (GObject * obj);
static GType network_vpn_page_get_type_once (void);

static inline gpointer
network_vpn_page_get_instance_private (NetworkVPNPage* self)
{
	return G_STRUCT_MEMBER_P (self, NetworkVPNPage_private_offset);
}

NetworkVPNPage*
network_vpn_page_construct (GType object_type)
{
	NetworkVPNPage * self = NULL;
	GThemedIcon* _tmp0_;
	GThemedIcon* _tmp1_;
	_tmp0_ = (GThemedIcon*) g_themed_icon_new ("network-vpn");
	_tmp1_ = _tmp0_;
	self = (NetworkVPNPage*) g_object_new (object_type, "title", _ ("VPN"), "description", _ ("A Virtual Private Network can hide network traffic on public networks " \
"or from your internet service provider. It can't protect passwords fro" \
"m attackers or prevent websites from identifying you."), "icon", _tmp1_, NULL);
	_g_object_unref0 (_tmp1_);
	return self;
}

NetworkVPNPage*
network_vpn_page_new (void)
{
	return network_vpn_page_construct (NETWORK_TYPE_VPN_PAGE);
}

static void
network_vpn_page_real_update (NetworkWidgetsPage* base)
{
	NetworkVPNPage * self;
	NetworkVPNMenuItem* item = NULL;
	NMDeviceState _tmp24_;
	NMDeviceState _tmp25_;
	NMDeviceState _tmp26_;
	NMDeviceState _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	self = (NetworkVPNPage*) base;
	network_vpn_page_update_active_connections (self);
	item = NULL;
	{
		GeeList* _ac_list = NULL;
		GeeList* _tmp0_;
		gint _ac_size = 0;
		GeeList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _ac_index = 0;
		_tmp0_ = self->priv->active_connections;
		_ac_list = _tmp0_;
		_tmp1_ = _ac_list;
		_tmp2_ = gee_collection_get_size ((GeeCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_ac_size = _tmp3_;
		_ac_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			NMActiveConnection* ac = NULL;
			GeeList* _tmp6_;
			gpointer _tmp7_;
			NMActiveConnection* _tmp8_;
			NetworkVPNMenuItem* _tmp20_;
			_ac_index = _ac_index + 1;
			_tmp4_ = _ac_index;
			_tmp5_ = _ac_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _ac_list;
			_tmp7_ = gee_list_get (_tmp6_, _ac_index);
			ac = (NMActiveConnection*) _tmp7_;
			_tmp8_ = ac;
			if (_tmp8_ != NULL) {
				const gchar* connection_type = NULL;
				NMActiveConnection* _tmp9_;
				const gchar* _tmp10_;
				const gchar* _tmp11_;
				NMActiveConnection* _tmp17_;
				const gchar* _tmp18_;
				NetworkVPNMenuItem* _tmp19_;
				_tmp9_ = ac;
				_tmp10_ = nm_active_connection_get_connection_type (_tmp9_);
				connection_type = _tmp10_;
				_tmp11_ = connection_type;
				if (g_strcmp0 (_tmp11_, NM_SETTING_VPN_SETTING_NAME) == 0) {
					NMActiveConnection* _tmp12_;
					NMVpnConnectionState _tmp13_;
					NMVpnConnectionState _tmp14_;
					_tmp12_ = ac;
					_tmp13_ = nm_vpn_connection_get_vpn_state (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, nm_vpn_connection_get_type (), NMVpnConnection));
					_tmp14_ = _tmp13_;
					switch (_tmp14_) {
						case NM_VPN_CONNECTION_STATE_UNKNOWN:
						case NM_VPN_CONNECTION_STATE_DISCONNECTED:
						{
							network_widgets_page_set_state ((NetworkWidgetsPage*) self, NM_DEVICE_STATE_DISCONNECTED);
							break;
						}
						case NM_VPN_CONNECTION_STATE_PREPARE:
						case NM_VPN_CONNECTION_STATE_NEED_AUTH:
						case NM_VPN_CONNECTION_STATE_IP_CONFIG_GET:
						case NM_VPN_CONNECTION_STATE_CONNECT:
						{
							network_widgets_page_set_state ((NetworkWidgetsPage*) self, NM_DEVICE_STATE_PREPARE);
							break;
						}
						case NM_VPN_CONNECTION_STATE_FAILED:
						{
							network_widgets_page_set_state ((NetworkWidgetsPage*) self, NM_DEVICE_STATE_FAILED);
							break;
						}
						case NM_VPN_CONNECTION_STATE_ACTIVATED:
						{
							network_widgets_page_set_state ((NetworkWidgetsPage*) self, NM_DEVICE_STATE_ACTIVATED);
							break;
						}
						default:
						break;
					}
				} else {
					const gchar* _tmp15_;
					_tmp15_ = connection_type;
					if (g_strcmp0 (_tmp15_, NM_SETTING_WIREGUARD_SETTING_NAME) == 0) {
						NMActiveConnection* _tmp16_;
						_tmp16_ = ac;
						switch (nm_active_connection_get_state (_tmp16_)) {
							case NM_ACTIVE_CONNECTION_STATE_UNKNOWN:
							case NM_ACTIVE_CONNECTION_STATE_DEACTIVATED:
							case NM_ACTIVE_CONNECTION_STATE_DEACTIVATING:
							{
								network_widgets_page_set_state ((NetworkWidgetsPage*) self, NM_DEVICE_STATE_DISCONNECTED);
								break;
							}
							case NM_ACTIVE_CONNECTION_STATE_ACTIVATING:
							{
								network_widgets_page_set_state ((NetworkWidgetsPage*) self, NM_DEVICE_STATE_PREPARE);
								break;
							}
							case NM_ACTIVE_CONNECTION_STATE_ACTIVATED:
							{
								network_widgets_page_set_state ((NetworkWidgetsPage*) self, NM_DEVICE_STATE_ACTIVATED);
								break;
							}
							default:
							break;
						}
					}
				}
				_tmp17_ = ac;
				_tmp18_ = nm_active_connection_get_uuid (_tmp17_);
				_tmp19_ = network_vpn_page_get_item_by_uuid (self, _tmp18_);
				_g_object_unref0 (item);
				item = _tmp19_;
			} else {
				network_widgets_page_set_state ((NetworkWidgetsPage*) self, NM_DEVICE_STATE_DISCONNECTED);
			}
			_tmp20_ = item;
			if (_tmp20_ != NULL) {
				NetworkVPNMenuItem* _tmp21_;
				NMDeviceState _tmp22_;
				NMDeviceState _tmp23_;
				_tmp21_ = item;
				_tmp22_ = network_widgets_page_get_state ((NetworkWidgetsPage*) self);
				_tmp23_ = _tmp22_;
				network_vpn_menu_item_set_state (_tmp21_, _tmp23_);
			}
			_g_object_unref0 (ac);
		}
	}
	_tmp24_ = network_widgets_page_get_state ((NetworkWidgetsPage*) self);
	_tmp25_ = _tmp24_;
	switch (_tmp25_) {
		case NM_DEVICE_STATE_ACTIVATED:
		{
			switchboard_settings_page_set_status_type ((SwitchboardSettingsPage*) self, SWITCHBOARD_SETTINGS_PAGE_STATUS_TYPE_SUCCESS);
			break;
		}
		case NM_DEVICE_STATE_DISCONNECTED:
		{
			switchboard_settings_page_set_status_type ((SwitchboardSettingsPage*) self, SWITCHBOARD_SETTINGS_PAGE_STATUS_TYPE_OFFLINE);
			break;
		}
		case NM_DEVICE_STATE_FAILED:
		{
			switchboard_settings_page_set_status_type ((SwitchboardSettingsPage*) self, SWITCHBOARD_SETTINGS_PAGE_STATUS_TYPE_ERROR);
			break;
		}
		default:
		{
			switchboard_settings_page_set_status_type ((SwitchboardSettingsPage*) self, SWITCHBOARD_SETTINGS_PAGE_STATUS_TYPE_WARNING);
			break;
		}
	}
	_tmp26_ = network_widgets_page_get_state ((NetworkWidgetsPage*) self);
	_tmp27_ = _tmp26_;
	_tmp28_ = network_utils_state_to_string (_tmp27_);
	_tmp29_ = _tmp28_;
	switchboard_settings_page_set_status ((SwitchboardSettingsPage*) self, _tmp29_);
	_g_free0 (_tmp29_);
	_g_object_unref0 (item);
}

static void
network_vpn_page_real_update_switch (NetworkWidgetsPage* base)
{
	NetworkVPNPage * self;
	self = (NetworkVPNPage*) base;
}

static void
network_vpn_page_real_control_switch_activated (NetworkWidgetsPage* base)
{
	NetworkVPNPage * self;
	self = (NetworkVPNPage*) base;
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		NetworkVPNPage* self;
		self = _data5_->self;
		_g_object_unref0 (_data5_->item);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
__lambda15_ (Block5Data* _data5_)
{
	NetworkVPNPage* self;
	gboolean result;
	self = _data5_->self;
	self->priv->timeout_id = (guint) 0;
	network_vpn_page_delete_connection (self, _data5_->item);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda15__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda15_ (self);
	return result;
}

static void
__lambda14_ (Block5Data* _data5_)
{
	NetworkVPNPage* self;
	NetworkVPNMenuItem* _tmp0_;
	GraniteToast* _tmp1_;
	self = _data5_->self;
	_tmp0_ = _g_object_ref0 (_data5_->item);
	_g_object_unref0 (self->priv->sel_row);
	self->priv->sel_row = _tmp0_;
	_tmp1_ = self->priv->remove_vpn_toast;
	granite_toast_send_notification (_tmp1_);
	self->priv->timeout_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 3600, ___lambda15__gsource_func, block5_data_ref (_data5_), block5_data_unref);
}

static void
___lambda14__network_vpn_menu_item_remove_request (NetworkVPNMenuItem* _sender,
                                                   gpointer self)
{
	__lambda14_ (self);
}

void
network_vpn_page_add_connection (NetworkVPNPage* self,
                                 NMRemoteConnection* connection)
{
	Block5Data* _data5_;
	NetworkVPNMenuItem* _tmp0_;
	GtkListBox* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (connection != NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_tmp0_ = network_vpn_menu_item_new (connection);
	g_object_ref_sink (_tmp0_);
	_data5_->item = _tmp0_;
	g_signal_connect_data (_data5_->item, "remove-request", (GCallback) ___lambda14__network_vpn_menu_item_remove_request, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
	_tmp1_ = self->priv->vpn_list;
	gtk_list_box_append (_tmp1_, (GtkWidget*) _data5_->item);
	network_widgets_page_update ((NetworkWidgetsPage*) self);
	block5_data_unref (_data5_);
	_data5_ = NULL;
}

void
network_vpn_page_remove_connection (NetworkVPNPage* self,
                                    NMRemoteConnection* connection)
{
	NetworkVPNMenuItem* item = NULL;
	const gchar* _tmp0_;
	NetworkVPNMenuItem* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (connection != NULL);
	_tmp0_ = nm_connection_get_uuid ((NMConnection*) connection);
	_tmp1_ = network_vpn_page_get_item_by_uuid (self, _tmp0_);
	item = _tmp1_;
	g_signal_emit_by_name ((GtkWidget*) item, "destroy");
	_g_object_unref0 (item);
}

static NetworkVPNMenuItem*
network_vpn_page_get_item_by_uuid (NetworkVPNPage* self,
                                   const gchar* uuid)
{
	NetworkVPNMenuItem* item = NULL;
	GtkWidget* child = NULL;
	GtkListBox* _tmp0_;
	GtkWidget* _tmp1_;
	NetworkVPNMenuItem* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (uuid != NULL, NULL);
	item = NULL;
	_tmp0_ = self->priv->vpn_list;
	_tmp1_ = gtk_widget_get_first_child ((GtkWidget*) _tmp0_);
	child = _tmp1_;
	while (TRUE) {
		gboolean _tmp2_ = FALSE;
		GtkWidget* _tmp3_;
		GtkWidget* _tmp5_;
		GtkWidget* _tmp18_;
		GtkWidget* _tmp19_;
		_tmp3_ = child;
		if (_tmp3_ != NULL) {
			NetworkVPNMenuItem* _tmp4_;
			_tmp4_ = item;
			_tmp2_ = _tmp4_ == NULL;
		} else {
			_tmp2_ = FALSE;
		}
		if (!_tmp2_) {
			break;
		}
		_tmp5_ = child;
		if (NETWORK_IS_VPN_MENU_ITEM (_tmp5_)) {
			NetworkVPNMenuItem* _item = NULL;
			GtkWidget* _tmp6_;
			NetworkVPNMenuItem* _tmp7_;
			gboolean _tmp8_ = FALSE;
			NetworkVPNMenuItem* _tmp9_;
			NMRemoteConnection* _tmp10_;
			NMRemoteConnection* _tmp11_;
			_tmp6_ = child;
			_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, NETWORK_TYPE_VPN_MENU_ITEM, NetworkVPNMenuItem));
			_item = _tmp7_;
			_tmp9_ = _item;
			_tmp10_ = network_vpn_menu_item_get_connection (_tmp9_);
			_tmp11_ = _tmp10_;
			if (_tmp11_ != NULL) {
				NetworkVPNMenuItem* _tmp12_;
				NMRemoteConnection* _tmp13_;
				NMRemoteConnection* _tmp14_;
				const gchar* _tmp15_;
				_tmp12_ = _item;
				_tmp13_ = network_vpn_menu_item_get_connection (_tmp12_);
				_tmp14_ = _tmp13_;
				_tmp15_ = nm_connection_get_uuid ((NMConnection*) _tmp14_);
				_tmp8_ = g_strcmp0 (_tmp15_, uuid) == 0;
			} else {
				_tmp8_ = FALSE;
			}
			if (_tmp8_) {
				GtkWidget* _tmp16_;
				NetworkVPNMenuItem* _tmp17_;
				_tmp16_ = child;
				_tmp17_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, NETWORK_TYPE_VPN_MENU_ITEM, NetworkVPNMenuItem));
				_g_object_unref0 (item);
				item = _tmp17_;
			}
			_g_object_unref0 (_item);
		}
		_tmp18_ = child;
		_tmp19_ = gtk_widget_get_next_sibling (_tmp18_);
		child = _tmp19_;
	}
	result = item;
	return result;
}

static void
_network_widgets_page_update_nm_vpn_connection_vpn_state_changed (NMVpnConnection* _sender,
                                                                  guint object,
                                                                  guint p0,
                                                                  gpointer self)
{
	network_widgets_page_update ((NetworkWidgetsPage*) self);
}

static void
_network_widgets_page_update_nm_active_connection_state_changed (NMActiveConnection* _sender,
                                                                 guint state,
                                                                 guint reason,
                                                                 gpointer self)
{
	network_widgets_page_update ((NetworkWidgetsPage*) self);
}

static void
__lambda13_ (NetworkVPNPage* self,
             NMActiveConnection* ac)
{
	const gchar* connection_type = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GeeList* _tmp8_;
	g_return_if_fail (ac != NULL);
	_tmp0_ = nm_active_connection_get_connection_type (ac);
	connection_type = _tmp0_;
	_tmp1_ = connection_type;
	if (g_strcmp0 (_tmp1_, NM_SETTING_VPN_SETTING_NAME) == 0) {
		NMVpnConnection* _connection = NULL;
		NMVpnConnection* _tmp2_;
		NMVpnConnection* _tmp3_;
		guint _tmp4_;
		NMVpnConnection* _tmp5_;
		_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (ac, nm_vpn_connection_get_type (), NMVpnConnection));
		_connection = _tmp2_;
		_tmp3_ = _connection;
		g_signal_parse_name ("vpn-state-changed", nm_vpn_connection_get_type (), &_tmp4_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp3_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, 0, NULL, (GCallback) _network_widgets_page_update_nm_vpn_connection_vpn_state_changed, (NetworkWidgetsPage*) self);
		_tmp5_ = _connection;
		g_signal_connect_object (_tmp5_, "vpn-state-changed", (GCallback) _network_widgets_page_update_nm_vpn_connection_vpn_state_changed, (NetworkWidgetsPage*) self, 0);
		_g_object_unref0 (_connection);
	} else {
		const gchar* _tmp6_;
		_tmp6_ = connection_type;
		if (g_strcmp0 (_tmp6_, NM_SETTING_WIREGUARD_SETTING_NAME) == 0) {
			guint _tmp7_;
			g_signal_parse_name ("state-changed", nm_active_connection_get_type (), &_tmp7_, NULL, FALSE);
			g_signal_handlers_disconnect_matched (ac, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, 0, NULL, (GCallback) _network_widgets_page_update_nm_active_connection_state_changed, (NetworkWidgetsPage*) self);
			g_signal_connect_object (ac, "state-changed", (GCallback) _network_widgets_page_update_nm_active_connection_state_changed, (NetworkWidgetsPage*) self, 0);
		} else {
			return;
		}
	}
	_tmp8_ = self->priv->active_connections;
	gee_collection_add ((GeeCollection*) _tmp8_, ac);
}

static void
___lambda13__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda13_ ((NetworkVPNPage*) self, (NMActiveConnection*) data);
}

static void
network_vpn_page_update_active_connections (NetworkVPNPage* self)
{
	GeeList* _tmp0_;
	NetworkNetworkManager* network_manager = NULL;
	NetworkNetworkManager* _tmp1_;
	NMClient* _tmp2_;
	NMClient* _tmp3_;
	GPtrArray* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->active_connections;
	gee_collection_clear ((GeeCollection*) _tmp0_);
	_tmp1_ = network_network_manager_get_default ();
	network_manager = _tmp1_;
	_tmp2_ = network_network_manager_get_client (network_manager);
	_tmp3_ = _tmp2_;
	_tmp4_ = nm_client_get_active_connections (_tmp3_);
	g_ptr_array_foreach (_tmp4_, ___lambda13__gfunc, self);
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		NetworkVPNPage* self;
		self = _data6_->self;
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}

static void
__lambda16_ (Block6Data* _data6_,
             GObject* obj,
             GAsyncResult* res)
{
	NetworkVPNPage* self;
	GError* _inner_error0_ = NULL;
	self = _data6_->self;
	g_return_if_fail (res != NULL);
	{
		NMClient* _tmp0_;
		NMClient* _tmp1_;
		NMActiveConnection* _tmp2_;
		NMActiveConnection* _tmp3_;
		_tmp0_ = network_network_manager_get_client (_data6_->network_manager);
		_tmp1_ = _tmp0_;
		_tmp2_ = nm_client_activate_connection_finish (_tmp1_, res, &_inner_error0_);
		_tmp3_ = _tmp2_;
		_g_object_unref0 (_tmp3_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("VPNPage.vala:269: %s", _tmp5_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	network_widgets_page_update ((NetworkWidgetsPage*) self);
}

static void
___lambda16__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda16_ (self, source_object, res);
	block6_data_unref (self);
}

static void
network_vpn_page_connect_vpn_cb (NetworkVPNPage* self,
                                 NetworkVPNMenuItem* item)
{
	Block6Data* _data6_;
	NetworkNetworkManager* _tmp0_;
	NMClient* _tmp1_;
	NMClient* _tmp2_;
	NMRemoteConnection* _tmp3_;
	NMRemoteConnection* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_data6_->self = g_object_ref (self);
	_tmp0_ = network_network_manager_get_default ();
	_data6_->network_manager = _tmp0_;
	_tmp1_ = network_network_manager_get_client (_data6_->network_manager);
	_tmp2_ = _tmp1_;
	_tmp3_ = network_vpn_menu_item_get_connection (item);
	_tmp4_ = _tmp3_;
	nm_client_activate_connection_async (_tmp2_, (NMConnection*) _tmp4_, NULL, NULL, NULL, ___lambda16__gasync_ready_callback, block6_data_ref (_data6_));
	block6_data_unref (_data6_);
	_data6_ = NULL;
}

static Block7Data*
block7_data_ref (Block7Data* _data7_)
{
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}

static void
block7_data_unref (void * _userdata_)
{
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		NetworkVPNPage* self;
		self = _data7_->self;
		_g_object_unref0 (self);
		g_slice_free (Block7Data, _data7_);
	}
}

static void
_____lambda17_ (Block7Data* _data7_,
                GObject* obj,
                GAsyncResult* res)
{
	NetworkVPNPage* self;
	GError* _inner_error0_ = NULL;
	self = _data7_->self;
	g_return_if_fail (res != NULL);
	{
		NetworkNetworkManager* _tmp0_;
		NMClient* _tmp1_;
		NMClient* _tmp2_;
		_tmp0_ = _data7_->network_manager;
		_tmp1_ = network_network_manager_get_client (_tmp0_);
		_tmp2_ = _tmp1_;
		nm_client_deactivate_connection_finish (_tmp2_, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("VPNPage.vala:285: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	network_widgets_page_update ((NetworkWidgetsPage*) self);
}

static void
______lambda17__gasync_ready_callback (GObject* source_object,
                                       GAsyncResult* res,
                                       gpointer self)
{
	_____lambda17_ (self, source_object, res);
	block7_data_unref (self);
}

static void
network_vpn_page_disconnect_vpn_cb (NetworkVPNPage* self,
                                    NetworkVPNMenuItem* item)
{
	Block7Data* _data7_;
	NetworkNetworkManager* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	_data7_ = g_slice_new0 (Block7Data);
	_data7_->_ref_count_ = 1;
	_data7_->self = g_object_ref (self);
	network_vpn_page_update_active_connections (self);
	_tmp0_ = network_network_manager_get_default ();
	_data7_->network_manager = _tmp0_;
	{
		GeeList* _ac_list = NULL;
		GeeList* _tmp1_;
		gint _ac_size = 0;
		GeeList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _ac_index = 0;
		_tmp1_ = self->priv->active_connections;
		_ac_list = _tmp1_;
		_tmp2_ = _ac_list;
		_tmp3_ = gee_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_ac_size = _tmp4_;
		_ac_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			NMActiveConnection* ac = NULL;
			GeeList* _tmp7_;
			gpointer _tmp8_;
			NMActiveConnection* _tmp9_;
			NMRemoteConnection* _tmp10_;
			NMRemoteConnection* _tmp11_;
			NMRemoteConnection* _tmp12_;
			_ac_index = _ac_index + 1;
			_tmp5_ = _ac_index;
			_tmp6_ = _ac_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _ac_list;
			_tmp8_ = gee_list_get (_tmp7_, _ac_index);
			ac = (NMActiveConnection*) _tmp8_;
			_tmp9_ = ac;
			_tmp10_ = nm_active_connection_get_connection (_tmp9_);
			_tmp11_ = network_vpn_menu_item_get_connection (item);
			_tmp12_ = _tmp11_;
			if (_tmp10_ == _tmp12_) {
				NetworkNetworkManager* _tmp13_;
				NMClient* _tmp14_;
				NMClient* _tmp15_;
				NMActiveConnection* _tmp16_;
				_tmp13_ = _data7_->network_manager;
				_tmp14_ = network_network_manager_get_client (_tmp13_);
				_tmp15_ = _tmp14_;
				_tmp16_ = ac;
				nm_client_deactivate_connection_async (_tmp15_, _tmp16_, NULL, ______lambda17__gasync_ready_callback, block7_data_ref (_data7_));
				_g_object_unref0 (ac);
				break;
			}
			_g_object_unref0 (ac);
		}
	}
	block7_data_unref (_data7_);
	_data7_ = NULL;
}

static void
_gtk_window_destroy_gtk_dialog_response (GtkDialog* _sender,
                                         gint response_id,
                                         gpointer self)
{
	gtk_window_destroy ((GtkWindow*) self);
}

static void
network_vpn_page_try_connection_editor (NetworkVPNPage* self,
                                        const gchar* args)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (args != NULL);
	{
		GAppInfo* appinfo = NULL;
		gchar* _tmp0_;
		gchar* _tmp1_;
		GAppInfo* _tmp2_;
		GAppInfo* _tmp3_;
		GAppInfo* _tmp4_;
		_tmp0_ = g_strdup_printf ("nm-connection-editor %s", args);
		_tmp1_ = _tmp0_;
		_tmp2_ = g_app_info_create_from_commandline (_tmp1_, NULL, G_APP_INFO_CREATE_NONE, &_inner_error0_);
		_tmp3_ = _tmp2_;
		_g_free0 (_tmp1_);
		appinfo = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp4_ = appinfo;
		g_app_info_launch (_tmp4_, NULL, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (appinfo);
			goto __catch0_g_error;
		}
		_g_object_unref0 (appinfo);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GraniteMessageDialog* dialog = NULL;
		GThemedIcon* _tmp5_;
		GThemedIcon* _tmp6_;
		GThemedIcon* _tmp7_;
		GtkRoot* _tmp8_;
		GtkWindow* _tmp9_;
		GraniteMessageDialog* _tmp10_ = NULL;
		GraniteMessageDialog* _tmp11_;
		GraniteMessageDialog* _tmp12_;
		GError* _tmp13_;
		const gchar* _tmp14_;
		GraniteMessageDialog* _tmp15_;
		GraniteMessageDialog* _tmp16_;
		GraniteMessageDialog* _tmp17_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = (GThemedIcon*) g_themed_icon_new ("network-vpn");
		_tmp6_ = _tmp5_;
		_tmp7_ = (GThemedIcon*) g_themed_icon_new ("dialog-error");
		_tmp8_ = gtk_widget_get_root ((GtkWidget*) self);
		_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_window_get_type (), GtkWindow));
		_tmp10_ = granite_message_dialog_new (_ ("Failed to run Connection Editor"), _ ("The program \"nm-connection-editor\" may not be installed."), (GIcon*) _tmp6_, GTK_BUTTONS_CLOSE);
		granite_message_dialog_set_badge_icon (_tmp10_, (GIcon*) _tmp7_);
		_g_object_unref0 (_tmp7_);
		gtk_window_set_modal ((GtkWindow*) _tmp10_, TRUE);
		gtk_window_set_transient_for ((GtkWindow*) _tmp10_, _tmp9_);
		_g_object_unref0 (_tmp9_);
		g_object_ref_sink (_tmp10_);
		_tmp11_ = _tmp10_;
		_g_object_unref0 (_tmp6_);
		dialog = _tmp11_;
		_tmp12_ = dialog;
		_tmp13_ = _error_;
		_tmp14_ = _tmp13_->message;
		granite_message_dialog_show_error_details (_tmp12_, _tmp14_);
		_tmp15_ = dialog;
		gtk_window_present ((GtkWindow*) _tmp15_);
		_tmp16_ = dialog;
		_tmp17_ = dialog;
		g_signal_connect_object ((GtkDialog*) _tmp16_, "response", (GCallback) _gtk_window_destroy_gtk_dialog_response, (GtkWindow*) _tmp17_, 0);
		_g_object_unref0 (dialog);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
network_vpn_page_delete_connection (NetworkVPNPage* self,
                                    NetworkVPNMenuItem* item)
{
	gboolean _tmp0_ = FALSE;
	NetworkVPNMenuItem* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	_tmp1_ = self->priv->sel_row;
	if (_tmp1_ != NULL) {
		NetworkVPNMenuItem* _tmp2_;
		_tmp2_ = self->priv->sel_row;
		_tmp0_ = _tmp2_ == item;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		{
			NMRemoteConnection* _tmp3_;
			NMRemoteConnection* _tmp4_;
			_tmp3_ = network_vpn_menu_item_get_connection (item);
			_tmp4_ = _tmp3_;
			nm_remote_connection_delete (_tmp4_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp5_;
			const gchar* _tmp6_;
			GraniteMessageDialog* dialog = NULL;
			GThemedIcon* _tmp7_;
			GThemedIcon* _tmp8_;
			GThemedIcon* _tmp9_;
			GtkRoot* _tmp10_;
			GtkWindow* _tmp11_;
			GraniteMessageDialog* _tmp12_ = NULL;
			GraniteMessageDialog* _tmp13_;
			GraniteMessageDialog* _tmp14_;
			GError* _tmp15_;
			const gchar* _tmp16_;
			GraniteMessageDialog* _tmp17_;
			GraniteMessageDialog* _tmp18_;
			GraniteMessageDialog* _tmp19_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp5_ = e;
			_tmp6_ = _tmp5_->message;
			g_warning ("VPNPage.vala:324: %s", _tmp6_);
			_tmp7_ = (GThemedIcon*) g_themed_icon_new ("network-vpn");
			_tmp8_ = _tmp7_;
			_tmp9_ = (GThemedIcon*) g_themed_icon_new ("dialog-error");
			_tmp10_ = gtk_widget_get_root ((GtkWidget*) self);
			_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_window_get_type (), GtkWindow));
			_tmp12_ = granite_message_dialog_new (_ ("Failed to remove VPN connection"), "", (GIcon*) _tmp8_, GTK_BUTTONS_CLOSE);
			granite_message_dialog_set_badge_icon (_tmp12_, (GIcon*) _tmp9_);
			_g_object_unref0 (_tmp9_);
			gtk_window_set_modal ((GtkWindow*) _tmp12_, TRUE);
			gtk_window_set_transient_for ((GtkWindow*) _tmp12_, _tmp11_);
			_g_object_unref0 (_tmp11_);
			g_object_ref_sink (_tmp12_);
			_tmp13_ = _tmp12_;
			_g_object_unref0 (_tmp8_);
			dialog = _tmp13_;
			_tmp14_ = dialog;
			_tmp15_ = e;
			_tmp16_ = _tmp15_->message;
			granite_message_dialog_show_error_details (_tmp14_, _tmp16_);
			_tmp17_ = dialog;
			gtk_window_present ((GtkWindow*) _tmp17_);
			_tmp18_ = dialog;
			_tmp19_ = dialog;
			g_signal_connect_object ((GtkDialog*) _tmp18_, "response", (GCallback) _gtk_window_destroy_gtk_dialog_response, (GtkWindow*) _tmp19_, 0);
			_g_object_unref0 (dialog);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	} else {
		NetworkVPNMenuItem* _tmp20_;
		g_warning ("VPNPage.vala:340: Row selection changed between operations. Cancelling" \
" removal of VPN.");
		g_source_remove (self->priv->timeout_id);
		self->priv->timeout_id = (guint) 0;
		_tmp20_ = self->priv->sel_row;
		gtk_widget_show ((GtkWidget*) _tmp20_);
	}
}

static gint
network_vpn_page_compare_rows (NetworkVPNMenuItem* row1,
                               NetworkVPNMenuItem* row2,
                               NetworkVPNPage* self)
{
	NMSettingConnection* vpn_menu_item1 = NULL;
	NMRemoteConnection* _tmp0_;
	NMRemoteConnection* _tmp1_;
	NMSettingConnection* _tmp2_;
	NMSettingConnection* vpn_menu_item2 = NULL;
	NMRemoteConnection* _tmp3_;
	NMRemoteConnection* _tmp4_;
	NMSettingConnection* _tmp5_;
	gboolean _tmp6_ = FALSE;
	NMSettingConnection* _tmp7_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (row1 != NULL, 0);
	g_return_val_if_fail (row2 != NULL, 0);
	_tmp0_ = network_vpn_menu_item_get_connection (row1);
	_tmp1_ = _tmp0_;
	_tmp2_ = nm_connection_get_setting_connection ((NMConnection*) _tmp1_);
	vpn_menu_item1 = _tmp2_;
	_tmp3_ = network_vpn_menu_item_get_connection (row2);
	_tmp4_ = _tmp3_;
	_tmp5_ = nm_connection_get_setting_connection ((NMConnection*) _tmp4_);
	vpn_menu_item2 = _tmp5_;
	_tmp7_ = vpn_menu_item1;
	if (_tmp7_ != NULL) {
		NMSettingConnection* _tmp8_;
		_tmp8_ = vpn_menu_item2;
		_tmp6_ = _tmp8_ != NULL;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		NMSettingConnection* _tmp9_;
		NMSettingConnection* _tmp10_;
		_tmp9_ = vpn_menu_item1;
		_tmp10_ = vpn_menu_item2;
		if (nm_setting_connection_get_timestamp (_tmp9_) > nm_setting_connection_get_timestamp (_tmp10_)) {
			result = -1;
			return result;
		}
	}
	result = 1;
	return result;
}

static void
_network_vpn_page___lambda18_ (NetworkVPNPage* self)
{
	network_vpn_page_try_connection_editor (self, "--create --type=vpn");
}

static void
__network_vpn_page___lambda18__gtk_button_clicked (GtkButton* _sender,
                                                   gpointer self)
{
	_network_vpn_page___lambda18_ ((NetworkVPNPage*) self);
}

static void
_network_vpn_page___lambda19_ (NetworkVPNPage* self)
{
	NetworkVPNMenuItem* _tmp0_;
	g_source_remove (self->priv->timeout_id);
	self->priv->timeout_id = (guint) 0;
	_tmp0_ = self->priv->sel_row;
	gtk_widget_show ((GtkWidget*) _tmp0_);
}

static void
__network_vpn_page___lambda19__granite_toast_default_action (GraniteToast* _sender,
                                                             gpointer self)
{
	_network_vpn_page___lambda19_ ((NetworkVPNPage*) self);
}

static void
_network_vpn_page___lambda20_ (NetworkVPNPage* self,
                               GtkListBoxRow* row)
{
	NMDeviceState _tmp0_;
	NMDeviceState _tmp1_;
	g_return_if_fail (row != NULL);
	_tmp0_ = network_vpn_menu_item_get_state (G_TYPE_CHECK_INSTANCE_CAST (row, NETWORK_TYPE_VPN_MENU_ITEM, NetworkVPNMenuItem));
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NM_DEVICE_STATE_ACTIVATED) {
		network_vpn_page_disconnect_vpn_cb (self, G_TYPE_CHECK_INSTANCE_CAST (row, NETWORK_TYPE_VPN_MENU_ITEM, NetworkVPNMenuItem));
	} else {
		network_vpn_page_connect_vpn_cb (self, G_TYPE_CHECK_INSTANCE_CAST (row, NETWORK_TYPE_VPN_MENU_ITEM, NetworkVPNMenuItem));
	}
}

static void
__network_vpn_page___lambda20__gtk_list_box_row_activated (GtkListBox* _sender,
                                                           GtkListBoxRow* row,
                                                           gpointer self)
{
	_network_vpn_page___lambda20_ ((NetworkVPNPage*) self, row);
}

static void
_network_vpn_page_update_active_connections_g_object_notify (GObject* _sender,
                                                             GParamSpec* pspec,
                                                             gpointer self)
{
	network_vpn_page_update_active_connections ((NetworkVPNPage*) self);
}

static GObject *
network_vpn_page_constructor (GType type,
                              guint n_construct_properties,
                              GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	NetworkVPNPage * self;
	GraniteToast* _tmp0_;
	GraniteToast* _tmp1_;
	GranitePlaceholder* placeholder = NULL;
	gchar* _tmp2_;
	GranitePlaceholder* _tmp3_ = NULL;
	GtkListBox* _tmp4_ = NULL;
	GtkListBox* _tmp5_;
	GranitePlaceholder* _tmp6_;
	GtkListBox* _tmp7_;
	GtkListBox* _tmp8_;
	GtkLabel* add_button_label = NULL;
	GtkLabel* _tmp9_;
	GtkBox* add_button_box = NULL;
	GtkBox* _tmp10_;
	GtkBox* _tmp11_;
	GtkImage* _tmp12_;
	GtkImage* _tmp13_;
	GtkBox* _tmp14_;
	GtkLabel* _tmp15_;
	GtkButton* add_button = NULL;
	GtkBox* _tmp16_;
	GtkWidget* _tmp17_;
	GtkButton* _tmp18_ = NULL;
	GtkLabel* _tmp19_;
	GtkButton* _tmp20_;
	GtkActionBar* actionbar = NULL;
	GtkActionBar* _tmp21_;
	GtkActionBar* _tmp22_;
	GtkActionBar* _tmp23_;
	GtkButton* _tmp24_;
	GtkScrolledWindow* scrolled = NULL;
	GtkListBox* _tmp25_;
	GtkWidget* _tmp26_;
	GtkScrolledWindow* _tmp27_ = NULL;
	GtkBox* vpn_box = NULL;
	GtkBox* _tmp28_;
	GtkBox* _tmp29_;
	GtkScrolledWindow* _tmp30_;
	GtkBox* _tmp31_;
	GtkActionBar* _tmp32_;
	GtkFrame* frame = NULL;
	GtkBox* _tmp33_;
	GtkWidget* _tmp34_;
	GtkFrame* _tmp35_ = NULL;
	GtkOverlay* main_overlay = NULL;
	GtkFrame* _tmp36_;
	GtkWidget* _tmp37_;
	GtkOverlay* _tmp38_ = NULL;
	GtkOverlay* _tmp39_;
	GraniteToast* _tmp40_;
	GtkOverlay* _tmp41_;
	GtkButton* _tmp42_;
	GraniteToast* _tmp43_;
	GtkListBox* _tmp44_;
	GeeArrayList* _tmp45_;
	NetworkNetworkManager* network_manager = NULL;
	NetworkNetworkManager* _tmp46_;
	NetworkNetworkManager* _tmp47_;
	NMClient* _tmp48_;
	NMClient* _tmp49_;
	parent_class = G_OBJECT_CLASS (network_vpn_page_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETWORK_TYPE_VPN_PAGE, NetworkVPNPage);
	_tmp0_ = granite_toast_new (_ ("VPN removed"));
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->remove_vpn_toast);
	self->priv->remove_vpn_toast = _tmp0_;
	_tmp1_ = self->priv->remove_vpn_toast;
	granite_toast_set_default_action (_tmp1_, _ ("Undo"));
	_tmp2_ = g_strdup (_ ("Add a new VPN connection to begin."));
	_tmp3_ = granite_placeholder_new (_ ("No VPN Connections"));
	granite_placeholder_set_description (_tmp3_, _tmp2_);
	_g_free0 (_tmp2_);
	g_object_ref_sink (_tmp3_);
	placeholder = _tmp3_;
	_tmp4_ = (GtkListBox*) gtk_list_box_new ();
	gtk_list_box_set_activate_on_single_click (_tmp4_, FALSE);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp4_, TRUE);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp4_, TRUE);
	gtk_list_box_set_selection_mode (_tmp4_, GTK_SELECTION_BROWSE);
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->vpn_list);
	self->priv->vpn_list = _tmp4_;
	_tmp5_ = self->priv->vpn_list;
	_tmp6_ = placeholder;
	gtk_list_box_set_placeholder (_tmp5_, (GtkWidget*) _tmp6_);
	_tmp7_ = self->priv->vpn_list;
	gtk_list_box_set_sort_func (_tmp7_, (GtkListBoxSortFunc) network_vpn_page_compare_rows, g_object_ref (self), g_object_unref);
	_tmp8_ = self->priv->vpn_list;
	gtk_widget_add_css_class ((GtkWidget*) _tmp8_, GRANITE_STYLE_CLASS_RICH_LIST);
	_tmp9_ = (GtkLabel*) gtk_label_new (_ ("Add Connection…"));
	g_object_ref_sink (_tmp9_);
	add_button_label = _tmp9_;
	_tmp10_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp10_);
	add_button_box = _tmp10_;
	_tmp11_ = add_button_box;
	_tmp12_ = (GtkImage*) gtk_image_new_from_icon_name ("list-add-symbolic");
	g_object_ref_sink (_tmp12_);
	_tmp13_ = _tmp12_;
	gtk_box_append (_tmp11_, (GtkWidget*) _tmp13_);
	_g_object_unref0 (_tmp13_);
	_tmp14_ = add_button_box;
	_tmp15_ = add_button_label;
	gtk_box_append (_tmp14_, (GtkWidget*) _tmp15_);
	_tmp16_ = add_button_box;
	_tmp17_ = _g_object_ref0 ((GtkWidget*) _tmp16_);
	_tmp18_ = (GtkButton*) gtk_button_new ();
	gtk_button_set_child (_tmp18_, _tmp17_);
	_g_object_unref0 (_tmp17_);
	gtk_button_set_has_frame (_tmp18_, FALSE);
	g_object_ref_sink (_tmp18_);
	add_button = _tmp18_;
	_tmp19_ = add_button_label;
	_tmp20_ = add_button;
	gtk_label_set_mnemonic_widget (_tmp19_, (GtkWidget*) _tmp20_);
	_tmp21_ = (GtkActionBar*) gtk_action_bar_new ();
	g_object_ref_sink (_tmp21_);
	actionbar = _tmp21_;
	_tmp22_ = actionbar;
	gtk_widget_add_css_class ((GtkWidget*) _tmp22_, GRANITE_STYLE_CLASS_FLAT);
	_tmp23_ = actionbar;
	_tmp24_ = add_button;
	gtk_action_bar_pack_start (_tmp23_, (GtkWidget*) _tmp24_);
	_tmp25_ = self->priv->vpn_list;
	_tmp26_ = _g_object_ref0 ((GtkWidget*) _tmp25_);
	_tmp27_ = (GtkScrolledWindow*) gtk_scrolled_window_new ();
	gtk_scrolled_window_set_child (_tmp27_, _tmp26_);
	_g_object_unref0 (_tmp26_);
	g_object_ref_sink (_tmp27_);
	scrolled = _tmp27_;
	_tmp28_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp28_);
	vpn_box = _tmp28_;
	_tmp29_ = vpn_box;
	_tmp30_ = scrolled;
	gtk_box_append (_tmp29_, (GtkWidget*) _tmp30_);
	_tmp31_ = vpn_box;
	_tmp32_ = actionbar;
	gtk_box_append (_tmp31_, (GtkWidget*) _tmp32_);
	_tmp33_ = vpn_box;
	_tmp34_ = _g_object_ref0 ((GtkWidget*) _tmp33_);
	_tmp35_ = (GtkFrame*) gtk_frame_new (NULL);
	gtk_frame_set_child (_tmp35_, _tmp34_);
	_g_object_unref0 (_tmp34_);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp35_, TRUE);
	g_object_ref_sink (_tmp35_);
	frame = _tmp35_;
	_tmp36_ = frame;
	_tmp37_ = _g_object_ref0 ((GtkWidget*) _tmp36_);
	_tmp38_ = (GtkOverlay*) gtk_overlay_new ();
	gtk_overlay_set_child (_tmp38_, _tmp37_);
	_g_object_unref0 (_tmp37_);
	g_object_ref_sink (_tmp38_);
	main_overlay = _tmp38_;
	_tmp39_ = main_overlay;
	_tmp40_ = self->priv->remove_vpn_toast;
	gtk_overlay_add_overlay (_tmp39_, (GtkWidget*) _tmp40_);
	_tmp41_ = main_overlay;
	switchboard_settings_page_set_child ((SwitchboardSettingsPage*) self, (GtkWidget*) _tmp41_);
	_tmp42_ = add_button;
	g_signal_connect_object (_tmp42_, "clicked", (GCallback) __network_vpn_page___lambda18__gtk_button_clicked, self, 0);
	_tmp43_ = self->priv->remove_vpn_toast;
	g_signal_connect_object (_tmp43_, "default-action", (GCallback) __network_vpn_page___lambda19__granite_toast_default_action, self, 0);
	_tmp44_ = self->priv->vpn_list;
	g_signal_connect_object (_tmp44_, "row-activated", (GCallback) __network_vpn_page___lambda20__gtk_list_box_row_activated, self, 0);
	_tmp45_ = gee_array_list_new (nm_active_connection_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->active_connections);
	self->priv->active_connections = (GeeList*) _tmp45_;
	network_widgets_page_update ((NetworkWidgetsPage*) self);
	_tmp46_ = network_network_manager_get_default ();
	network_manager = _tmp46_;
	_tmp47_ = network_manager;
	_tmp48_ = network_network_manager_get_client (_tmp47_);
	_tmp49_ = _tmp48_;
	g_signal_connect_object ((GObject*) _tmp49_, "notify::active-connections", (GCallback) _network_vpn_page_update_active_connections_g_object_notify, self, 0);
	_g_object_unref0 (main_overlay);
	_g_object_unref0 (frame);
	_g_object_unref0 (vpn_box);
	_g_object_unref0 (scrolled);
	_g_object_unref0 (actionbar);
	_g_object_unref0 (add_button);
	_g_object_unref0 (add_button_box);
	_g_object_unref0 (add_button_label);
	_g_object_unref0 (placeholder);
	return obj;
}

static void
network_vpn_page_class_init (NetworkVPNPageClass * klass,
                             gpointer klass_data)
{
	network_vpn_page_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &NetworkVPNPage_private_offset);
	((NetworkWidgetsPageClass *) klass)->update = (void (*) (NetworkWidgetsPage*)) network_vpn_page_real_update;
	((NetworkWidgetsPageClass *) klass)->update_switch = (void (*) (NetworkWidgetsPage*)) network_vpn_page_real_update_switch;
	((NetworkWidgetsPageClass *) klass)->control_switch_activated = (void (*) (NetworkWidgetsPage*)) network_vpn_page_real_control_switch_activated;
	G_OBJECT_CLASS (klass)->constructor = network_vpn_page_constructor;
	G_OBJECT_CLASS (klass)->finalize = network_vpn_page_finalize;
}

static void
network_vpn_page_instance_init (NetworkVPNPage * self,
                                gpointer klass)
{
	self->priv = network_vpn_page_get_instance_private (self);
	self->priv->timeout_id = (guint) 0;
}

static void
network_vpn_page_finalize (GObject * obj)
{
	NetworkVPNPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETWORK_TYPE_VPN_PAGE, NetworkVPNPage);
	_g_object_unref0 (self->priv->active_connections);
	_g_object_unref0 (self->priv->vpn_list);
	_g_object_unref0 (self->priv->sel_row);
	_g_object_unref0 (self->priv->remove_vpn_toast);
	G_OBJECT_CLASS (network_vpn_page_parent_class)->finalize (obj);
}

static GType
network_vpn_page_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (NetworkVPNPageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) network_vpn_page_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetworkVPNPage), 0, (GInstanceInitFunc) network_vpn_page_instance_init, NULL };
	GType network_vpn_page_type_id;
	network_vpn_page_type_id = g_type_register_static (NETWORK_WIDGETS_TYPE_PAGE, "NetworkVPNPage", &g_define_type_info, 0);
	NetworkVPNPage_private_offset = g_type_add_instance_private (network_vpn_page_type_id, sizeof (NetworkVPNPagePrivate));
	return network_vpn_page_type_id;
}

GType
network_vpn_page_get_type (void)
{
	static volatile gsize network_vpn_page_type_id__once = 0;
	if (g_once_init_enter (&network_vpn_page_type_id__once)) {
		GType network_vpn_page_type_id;
		network_vpn_page_type_id = network_vpn_page_get_type_once ();
		g_once_init_leave (&network_vpn_page_type_id__once, network_vpn_page_type_id);
	}
	return network_vpn_page_type_id__once;
}

