/* Utils.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Utils.vala, do not modify */

/*
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: 2025 elementary, Inc. (https://elementary.io)
 */

#include "keyboard.h"
#include <gio/gdesktopappinfo.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

GIcon*
keyboard_shortcuts_utils_get_action_icon (GDesktopAppInfo* app_info,
                                          const gchar* action)
{
	GtkIconTheme* icon_theme = NULL;
	GdkDisplay* _tmp0_;
	GtkIconTheme* _tmp1_;
	GIcon* action_icon = NULL;
	GError* _inner_error0_ = NULL;
	GIcon* result;
	g_return_val_if_fail (app_info != NULL, NULL);
	g_return_val_if_fail (action != NULL, NULL);
	_tmp0_ = gdk_display_get_default ();
	_tmp1_ = gtk_icon_theme_get_for_display (_tmp0_);
	icon_theme = _tmp1_;
	action_icon = NULL;
	{
		GKeyFile* keyfile = NULL;
		GKeyFile* _tmp2_;
		GKeyFile* _tmp3_;
		const gchar* _tmp4_;
		gchar* group = NULL;
		gchar* _tmp5_;
		gboolean _tmp6_ = FALSE;
		GKeyFile* _tmp7_;
		const gchar* _tmp8_;
		_tmp2_ = g_key_file_new ();
		keyfile = _tmp2_;
		_tmp3_ = keyfile;
		_tmp4_ = g_desktop_app_info_get_filename (app_info);
		g_key_file_load_from_file (_tmp3_, _tmp4_, G_KEY_FILE_NONE, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_key_file_unref0 (keyfile);
			goto __catch0_g_error;
		}
		_tmp5_ = g_strdup_printf ("Desktop Action %s", action);
		group = _tmp5_;
		_tmp7_ = keyfile;
		_tmp8_ = group;
		_tmp6_ = g_key_file_has_key (_tmp7_, _tmp8_, G_KEY_FILE_DESKTOP_KEY_ICON, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (group);
			_g_key_file_unref0 (keyfile);
			goto __catch0_g_error;
		}
		if (_tmp6_) {
			gchar* icon_name = NULL;
			GKeyFile* _tmp9_;
			const gchar* _tmp10_;
			gchar* _tmp11_;
			GtkIconTheme* _tmp12_;
			const gchar* _tmp13_;
			_tmp9_ = keyfile;
			_tmp10_ = group;
			_tmp11_ = g_key_file_get_string (_tmp9_, _tmp10_, G_KEY_FILE_DESKTOP_KEY_ICON, &_inner_error0_);
			icon_name = _tmp11_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (group);
				_g_key_file_unref0 (keyfile);
				goto __catch0_g_error;
			}
			_tmp12_ = icon_theme;
			_tmp13_ = icon_name;
			if (gtk_icon_theme_has_icon (_tmp12_, _tmp13_)) {
				const gchar* _tmp14_;
				GThemedIcon* _tmp15_;
				_tmp14_ = icon_name;
				_tmp15_ = (GThemedIcon*) g_themed_icon_new (_tmp14_);
				_g_object_unref0 (action_icon);
				action_icon = (GIcon*) _tmp15_;
			}
			_g_free0 (icon_name);
		}
		_g_free0 (group);
		_g_key_file_unref0 (keyfile);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp16_;
		const gchar* _tmp17_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp16_ = e;
		_tmp17_ = _tmp16_->message;
		g_warning ("Utils.vala:24: %s", _tmp17_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (action_icon);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = action_icon;
	return result;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

