/*
qsynth - A fluidsynth Qt GUI Interface.

   Copyright (C) 2003-2024, rncbc aka Rui Nuno Capela. All rights reserved.

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along
   with this program; if not, write to the Free Software Foundation, Inc.,
   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

 
*/

/********************************************************************************
** Form generated from reading UI file 'qsynthSetupForm.ui'
**
** Created by: Qt User Interface Compiler version 6.10.0
**
** WARNING! All changes made in this file will be lost when recompiling UI file!
********************************************************************************/

#ifndef UI_QSYNTHSETUPFORM_H
#define UI_QSYNTHSETUPFORM_H

#include <QtCore/QVariant>
#include <QtGui/QIcon>
#include <QtWidgets/QAbstractButton>
#include <QtWidgets/QApplication>
#include <QtWidgets/QCheckBox>
#include <QtWidgets/QComboBox>
#include <QtWidgets/QDialog>
#include <QtWidgets/QDialogButtonBox>
#include <QtWidgets/QGridLayout>
#include <QtWidgets/QHBoxLayout>
#include <QtWidgets/QHeaderView>
#include <QtWidgets/QLabel>
#include <QtWidgets/QLineEdit>
#include <QtWidgets/QPushButton>
#include <QtWidgets/QSpacerItem>
#include <QtWidgets/QSpinBox>
#include <QtWidgets/QTabWidget>
#include <QtWidgets/QTreeWidget>
#include <QtWidgets/QVBoxLayout>
#include <QtWidgets/QWidget>

QT_BEGIN_NAMESPACE

class Ui_qsynthSetupForm
{
public:
    QVBoxLayout *vboxLayout;
    QHBoxLayout *hboxLayout;
    QLabel *DisplayNameTextLabel;
    QLineEdit *DisplayNameLineEdit;
    QSpacerItem *spacerItem;
    QTabWidget *SetupTabWidget;
    QWidget *MidiTabPage;
    QGridLayout *gridLayout;
    QCheckBox *MidiInCheckBox;
    QLabel *MidiDriverTextLabel;
    QComboBox *MidiDriverComboBox;
    QSpacerItem *spacerItem1;
    QLabel *MidiDeviceTextLabel;
    QComboBox *MidiDeviceComboBox;
    QLabel *MidiChannelsTextLabel;
    QSpinBox *MidiChannelsSpinBox;
    QSpacerItem *spacerItem2;
    QLabel *MidiBankSelectTextLabel;
    QComboBox *MidiBankSelectComboBox;
    QSpacerItem *spacerItem3;
    QHBoxLayout *hboxLayout1;
    QLabel *MidiNameTextLabel;
    QComboBox *MidiNameComboBox;
    QSpacerItem *spacerItem4;
    QCheckBox *MidiAutoConnectCheckBox;
    QCheckBox *VerboseCheckBox;
    QCheckBox *MidiDumpCheckBox;
    QWidget *AudioTabPage;
    QGridLayout *gridLayout1;
    QSpacerItem *spacerItem5;
    QGridLayout *gridLayout2;
    QLabel *AudioDriverTextLabel;
    QComboBox *AudioDriverComboBox;
    QLabel *SampleFormatTextLabel;
    QComboBox *SampleFormatComboBox;
    QLabel *SampleRateTextLabel;
    QComboBox *SampleRateComboBox;
    QLabel *AudioBufSizeTextLabel;
    QComboBox *AudioBufSizeComboBox;
    QLabel *AudioBufCountTextLabel;
    QComboBox *AudioBufCountComboBox;
    QGridLayout *gridLayout3;
    QLabel *AudioDeviceTextLabel;
    QLabel *AudioChannelsTextLabel;
    QSpinBox *AudioGroupsSpinBox;
    QSpinBox *PolyphonySpinBox;
    QSpinBox *AudioChannelsSpinBox;
    QComboBox *AudioDeviceComboBox;
    QLabel *PolyphonyTextLabel;
    QSpacerItem *spacerItem6;
    QLabel *AudioGroupsTextLabel;
    QHBoxLayout *hboxLayout2;
    QLabel *JackNameTextLabel;
    QComboBox *JackNameComboBox;
    QSpacerItem *spacerItem7;
    QCheckBox *JackAutoConnectCheckBox;
    QCheckBox *JackMultiCheckBox;
    QSpacerItem *spacerItem8;
    QCheckBox *WasapiExclusiveCheckBox;
    QWidget *SoundFontTabPage;
    QGridLayout *gridLayout4;
    QTreeWidget *SoundFontListView;
    QVBoxLayout *vboxLayout1;
    QPushButton *SoundFontOpenPushButton;
    QPushButton *SoundFontEditPushButton;
    QPushButton *SoundFontRemovePushButton;
    QSpacerItem *spacerItem9;
    QPushButton *SoundFontMoveUpPushButton;
    QPushButton *SoundFontMoveDownPushButton;
    QWidget *SettingsTabPage;
    QVBoxLayout *vboxLayout2;
    QTreeWidget *SettingsListView;
    QDialogButtonBox *DialogButtonBox;

    void setupUi(QDialog *qsynthSetupForm)
    {
        if (qsynthSetupForm->objectName().isEmpty())
            qsynthSetupForm->setObjectName("qsynthSetupForm");
        qsynthSetupForm->resize(540, 360);
        const QIcon icon = QIcon(QString::fromUtf8(":/images/setup1.png"));
        qsynthSetupForm->setWindowIcon(icon);
        qsynthSetupForm->setSizeGripEnabled(true);
        vboxLayout = new QVBoxLayout(qsynthSetupForm);
        vboxLayout->setSpacing(8);
        vboxLayout->setContentsMargins(8, 8, 8, 8);
        vboxLayout->setObjectName("vboxLayout");
        hboxLayout = new QHBoxLayout();
        hboxLayout->setSpacing(4);
        hboxLayout->setContentsMargins(4, 4, 4, 4);
        hboxLayout->setObjectName("hboxLayout");
        DisplayNameTextLabel = new QLabel(qsynthSetupForm);
        DisplayNameTextLabel->setObjectName("DisplayNameTextLabel");
        DisplayNameTextLabel->setWordWrap(false);

        hboxLayout->addWidget(DisplayNameTextLabel);

        DisplayNameLineEdit = new QLineEdit(qsynthSetupForm);
        DisplayNameLineEdit->setObjectName("DisplayNameLineEdit");
        DisplayNameLineEdit->setMaxLength(32);

        hboxLayout->addWidget(DisplayNameLineEdit);

        spacerItem = new QSpacerItem(8, 8, QSizePolicy::Policy::Expanding, QSizePolicy::Policy::Minimum);

        hboxLayout->addItem(spacerItem);


        vboxLayout->addLayout(hboxLayout);

        SetupTabWidget = new QTabWidget(qsynthSetupForm);
        SetupTabWidget->setObjectName("SetupTabWidget");
        MidiTabPage = new QWidget();
        MidiTabPage->setObjectName("MidiTabPage");
        gridLayout = new QGridLayout(MidiTabPage);
        gridLayout->setSpacing(8);
        gridLayout->setContentsMargins(8, 8, 8, 8);
        gridLayout->setObjectName("gridLayout");
        MidiInCheckBox = new QCheckBox(MidiTabPage);
        MidiInCheckBox->setObjectName("MidiInCheckBox");

        gridLayout->addWidget(MidiInCheckBox, 0, 0, 1, 7);

        MidiDriverTextLabel = new QLabel(MidiTabPage);
        MidiDriverTextLabel->setObjectName("MidiDriverTextLabel");
        MidiDriverTextLabel->setWordWrap(false);

        gridLayout->addWidget(MidiDriverTextLabel, 1, 0, 1, 1);

        MidiDriverComboBox = new QComboBox(MidiTabPage);
        MidiDriverComboBox->setObjectName("MidiDriverComboBox");
        MidiDriverComboBox->setEditable(false);

        gridLayout->addWidget(MidiDriverComboBox, 1, 1, 1, 2);

        spacerItem1 = new QSpacerItem(8, 8, QSizePolicy::Policy::Expanding, QSizePolicy::Policy::Minimum);

        gridLayout->addItem(spacerItem1, 1, 3, 2, 1);

        MidiDeviceTextLabel = new QLabel(MidiTabPage);
        MidiDeviceTextLabel->setObjectName("MidiDeviceTextLabel");
        MidiDeviceTextLabel->setAlignment(Qt::AlignRight|Qt::AlignTrailing|Qt::AlignVCenter);
        MidiDeviceTextLabel->setWordWrap(false);

        gridLayout->addWidget(MidiDeviceTextLabel, 1, 4, 1, 1);

        MidiDeviceComboBox = new QComboBox(MidiTabPage);
        MidiDeviceComboBox->setObjectName("MidiDeviceComboBox");
        MidiDeviceComboBox->setMinimumSize(QSize(180, 0));
        MidiDeviceComboBox->setEditable(true);

        gridLayout->addWidget(MidiDeviceComboBox, 1, 5, 1, 2);

        MidiChannelsTextLabel = new QLabel(MidiTabPage);
        MidiChannelsTextLabel->setObjectName("MidiChannelsTextLabel");
        MidiChannelsTextLabel->setWordWrap(false);

        gridLayout->addWidget(MidiChannelsTextLabel, 2, 0, 1, 1);

        MidiChannelsSpinBox = new QSpinBox(MidiTabPage);
        MidiChannelsSpinBox->setObjectName("MidiChannelsSpinBox");
        QSizePolicy sizePolicy(QSizePolicy::Policy::MinimumExpanding, QSizePolicy::Policy::Fixed);
        sizePolicy.setHorizontalStretch(2);
        sizePolicy.setVerticalStretch(0);
        sizePolicy.setHeightForWidth(MidiChannelsSpinBox->sizePolicy().hasHeightForWidth());
        MidiChannelsSpinBox->setSizePolicy(sizePolicy);
        MidiChannelsSpinBox->setMinimum(1);
        MidiChannelsSpinBox->setMaximum(256);
        MidiChannelsSpinBox->setSingleStep(1);

        gridLayout->addWidget(MidiChannelsSpinBox, 2, 1, 1, 1);

        spacerItem2 = new QSpacerItem(8, 8, QSizePolicy::Policy::Expanding, QSizePolicy::Policy::Minimum);

        gridLayout->addItem(spacerItem2, 2, 2, 1, 1);

        MidiBankSelectTextLabel = new QLabel(MidiTabPage);
        MidiBankSelectTextLabel->setObjectName("MidiBankSelectTextLabel");
        MidiBankSelectTextLabel->setAlignment(Qt::AlignRight|Qt::AlignTrailing|Qt::AlignVCenter);

        gridLayout->addWidget(MidiBankSelectTextLabel, 2, 4, 1, 2);

        MidiBankSelectComboBox = new QComboBox(MidiTabPage);
        MidiBankSelectComboBox->addItem(QString());
        MidiBankSelectComboBox->addItem(QString());
        MidiBankSelectComboBox->addItem(QString());
        MidiBankSelectComboBox->addItem(QString());
        MidiBankSelectComboBox->setObjectName("MidiBankSelectComboBox");
        MidiBankSelectComboBox->setFrame(true);

        gridLayout->addWidget(MidiBankSelectComboBox, 2, 6, 1, 1);

        spacerItem3 = new QSpacerItem(8, 8, QSizePolicy::Policy::Minimum, QSizePolicy::Policy::Expanding);

        gridLayout->addItem(spacerItem3, 3, 0, 1, 7);

        hboxLayout1 = new QHBoxLayout();
        hboxLayout1->setSpacing(4);
        hboxLayout1->setObjectName("hboxLayout1");
        MidiNameTextLabel = new QLabel(MidiTabPage);
        MidiNameTextLabel->setObjectName("MidiNameTextLabel");
        MidiNameTextLabel->setFrameShape(QFrame::NoFrame);
        MidiNameTextLabel->setFrameShadow(QFrame::Plain);
        MidiNameTextLabel->setWordWrap(false);

        hboxLayout1->addWidget(MidiNameTextLabel);

        MidiNameComboBox = new QComboBox(MidiTabPage);
        MidiNameComboBox->addItem(QString());
        MidiNameComboBox->addItem(QString());
        MidiNameComboBox->setObjectName("MidiNameComboBox");
        MidiNameComboBox->setEditable(true);

        hboxLayout1->addWidget(MidiNameComboBox);

        spacerItem4 = new QSpacerItem(8, 8, QSizePolicy::Policy::Expanding, QSizePolicy::Policy::Minimum);

        hboxLayout1->addItem(spacerItem4);


        gridLayout->addLayout(hboxLayout1, 4, 0, 1, 7);

        MidiAutoConnectCheckBox = new QCheckBox(MidiTabPage);
        MidiAutoConnectCheckBox->setObjectName("MidiAutoConnectCheckBox");

        gridLayout->addWidget(MidiAutoConnectCheckBox, 5, 0, 1, 7);

        VerboseCheckBox = new QCheckBox(MidiTabPage);
        VerboseCheckBox->setObjectName("VerboseCheckBox");

        gridLayout->addWidget(VerboseCheckBox, 6, 0, 1, 7);

        MidiDumpCheckBox = new QCheckBox(MidiTabPage);
        MidiDumpCheckBox->setObjectName("MidiDumpCheckBox");

        gridLayout->addWidget(MidiDumpCheckBox, 7, 0, 1, 7);

        SetupTabWidget->addTab(MidiTabPage, QString());
        AudioTabPage = new QWidget();
        AudioTabPage->setObjectName("AudioTabPage");
        gridLayout1 = new QGridLayout(AudioTabPage);
        gridLayout1->setSpacing(8);
        gridLayout1->setContentsMargins(8, 8, 8, 8);
        gridLayout1->setObjectName("gridLayout1");
        spacerItem5 = new QSpacerItem(8, 8, QSizePolicy::Policy::Minimum, QSizePolicy::Policy::Expanding);

        gridLayout1->addItem(spacerItem5, 1, 1, 2, 1);

        gridLayout2 = new QGridLayout();
        gridLayout2->setSpacing(4);
        gridLayout2->setObjectName("gridLayout2");
        AudioDriverTextLabel = new QLabel(AudioTabPage);
        AudioDriverTextLabel->setObjectName("AudioDriverTextLabel");
        AudioDriverTextLabel->setWordWrap(false);

        gridLayout2->addWidget(AudioDriverTextLabel, 0, 0, 1, 1);

        AudioDriverComboBox = new QComboBox(AudioTabPage);
        AudioDriverComboBox->setObjectName("AudioDriverComboBox");
        AudioDriverComboBox->setEditable(false);

        gridLayout2->addWidget(AudioDriverComboBox, 0, 1, 1, 1);

        SampleFormatTextLabel = new QLabel(AudioTabPage);
        SampleFormatTextLabel->setObjectName("SampleFormatTextLabel");
        SampleFormatTextLabel->setWordWrap(false);

        gridLayout2->addWidget(SampleFormatTextLabel, 1, 0, 1, 1);

        SampleFormatComboBox = new QComboBox(AudioTabPage);
        SampleFormatComboBox->setObjectName("SampleFormatComboBox");

        gridLayout2->addWidget(SampleFormatComboBox, 1, 1, 1, 1);

        SampleRateTextLabel = new QLabel(AudioTabPage);
        SampleRateTextLabel->setObjectName("SampleRateTextLabel");
        SampleRateTextLabel->setFrameShape(QFrame::NoFrame);
        SampleRateTextLabel->setFrameShadow(QFrame::Plain);
        SampleRateTextLabel->setWordWrap(false);

        gridLayout2->addWidget(SampleRateTextLabel, 2, 0, 1, 1);

        SampleRateComboBox = new QComboBox(AudioTabPage);
        SampleRateComboBox->addItem(QString());
        SampleRateComboBox->addItem(QString());
        SampleRateComboBox->addItem(QString());
        SampleRateComboBox->addItem(QString());
        SampleRateComboBox->addItem(QString());
        SampleRateComboBox->setObjectName("SampleRateComboBox");
        SampleRateComboBox->setEditable(true);

        gridLayout2->addWidget(SampleRateComboBox, 2, 1, 1, 1);

        AudioBufSizeTextLabel = new QLabel(AudioTabPage);
        AudioBufSizeTextLabel->setObjectName("AudioBufSizeTextLabel");
        AudioBufSizeTextLabel->setWordWrap(false);

        gridLayout2->addWidget(AudioBufSizeTextLabel, 3, 0, 1, 1);

        AudioBufSizeComboBox = new QComboBox(AudioTabPage);
        AudioBufSizeComboBox->addItem(QString());
        AudioBufSizeComboBox->addItem(QString());
        AudioBufSizeComboBox->addItem(QString());
        AudioBufSizeComboBox->addItem(QString());
        AudioBufSizeComboBox->addItem(QString());
        AudioBufSizeComboBox->addItem(QString());
        AudioBufSizeComboBox->addItem(QString());
        AudioBufSizeComboBox->addItem(QString());
        AudioBufSizeComboBox->setObjectName("AudioBufSizeComboBox");
        AudioBufSizeComboBox->setEditable(true);

        gridLayout2->addWidget(AudioBufSizeComboBox, 3, 1, 1, 1);

        AudioBufCountTextLabel = new QLabel(AudioTabPage);
        AudioBufCountTextLabel->setObjectName("AudioBufCountTextLabel");
        AudioBufCountTextLabel->setWordWrap(false);

        gridLayout2->addWidget(AudioBufCountTextLabel, 4, 0, 1, 1);

        AudioBufCountComboBox = new QComboBox(AudioTabPage);
        AudioBufCountComboBox->addItem(QString());
        AudioBufCountComboBox->addItem(QString());
        AudioBufCountComboBox->addItem(QString());
        AudioBufCountComboBox->addItem(QString());
        AudioBufCountComboBox->addItem(QString());
        AudioBufCountComboBox->addItem(QString());
        AudioBufCountComboBox->setObjectName("AudioBufCountComboBox");
        AudioBufCountComboBox->setEditable(true);

        gridLayout2->addWidget(AudioBufCountComboBox, 4, 1, 1, 1);


        gridLayout1->addLayout(gridLayout2, 0, 0, 2, 1);

        gridLayout3 = new QGridLayout();
        gridLayout3->setSpacing(4);
        gridLayout3->setObjectName("gridLayout3");
        AudioDeviceTextLabel = new QLabel(AudioTabPage);
        AudioDeviceTextLabel->setObjectName("AudioDeviceTextLabel");
        AudioDeviceTextLabel->setAlignment(Qt::AlignRight|Qt::AlignTrailing|Qt::AlignVCenter);
        AudioDeviceTextLabel->setWordWrap(false);

        gridLayout3->addWidget(AudioDeviceTextLabel, 0, 0, 1, 1);

        AudioChannelsTextLabel = new QLabel(AudioTabPage);
        AudioChannelsTextLabel->setObjectName("AudioChannelsTextLabel");
        AudioChannelsTextLabel->setAlignment(Qt::AlignRight|Qt::AlignTrailing|Qt::AlignVCenter);
        AudioChannelsTextLabel->setWordWrap(false);

        gridLayout3->addWidget(AudioChannelsTextLabel, 1, 0, 1, 1);

        AudioGroupsSpinBox = new QSpinBox(AudioTabPage);
        AudioGroupsSpinBox->setObjectName("AudioGroupsSpinBox");
        QSizePolicy sizePolicy1(QSizePolicy::Policy::MinimumExpanding, QSizePolicy::Policy::Fixed);
        sizePolicy1.setHorizontalStretch(0);
        sizePolicy1.setVerticalStretch(0);
        sizePolicy1.setHeightForWidth(AudioGroupsSpinBox->sizePolicy().hasHeightForWidth());
        AudioGroupsSpinBox->setSizePolicy(sizePolicy1);
        AudioGroupsSpinBox->setMinimum(1);
        AudioGroupsSpinBox->setMaximum(256);

        gridLayout3->addWidget(AudioGroupsSpinBox, 2, 1, 1, 1);

        PolyphonySpinBox = new QSpinBox(AudioTabPage);
        PolyphonySpinBox->setObjectName("PolyphonySpinBox");
        sizePolicy1.setHeightForWidth(PolyphonySpinBox->sizePolicy().hasHeightForWidth());
        PolyphonySpinBox->setSizePolicy(sizePolicy1);
        PolyphonySpinBox->setMinimum(16);
        PolyphonySpinBox->setMaximum(4096);
        PolyphonySpinBox->setValue(256);

        gridLayout3->addWidget(PolyphonySpinBox, 3, 1, 1, 1);

        AudioChannelsSpinBox = new QSpinBox(AudioTabPage);
        AudioChannelsSpinBox->setObjectName("AudioChannelsSpinBox");
        sizePolicy1.setHeightForWidth(AudioChannelsSpinBox->sizePolicy().hasHeightForWidth());
        AudioChannelsSpinBox->setSizePolicy(sizePolicy1);
        AudioChannelsSpinBox->setMinimum(1);
        AudioChannelsSpinBox->setMaximum(256);

        gridLayout3->addWidget(AudioChannelsSpinBox, 1, 1, 1, 1);

        AudioDeviceComboBox = new QComboBox(AudioTabPage);
        AudioDeviceComboBox->setObjectName("AudioDeviceComboBox");
        AudioDeviceComboBox->setMinimumSize(QSize(180, 0));
        AudioDeviceComboBox->setEditable(true);

        gridLayout3->addWidget(AudioDeviceComboBox, 0, 1, 1, 2);

        PolyphonyTextLabel = new QLabel(AudioTabPage);
        PolyphonyTextLabel->setObjectName("PolyphonyTextLabel");
        PolyphonyTextLabel->setAlignment(Qt::AlignRight|Qt::AlignTrailing|Qt::AlignVCenter);
        PolyphonyTextLabel->setWordWrap(false);

        gridLayout3->addWidget(PolyphonyTextLabel, 3, 0, 1, 1);

        spacerItem6 = new QSpacerItem(8, 8, QSizePolicy::Policy::Expanding, QSizePolicy::Policy::Minimum);

        gridLayout3->addItem(spacerItem6, 2, 2, 1, 1);

        AudioGroupsTextLabel = new QLabel(AudioTabPage);
        AudioGroupsTextLabel->setObjectName("AudioGroupsTextLabel");
        AudioGroupsTextLabel->setWordWrap(false);

        gridLayout3->addWidget(AudioGroupsTextLabel, 2, 0, 1, 1);


        gridLayout1->addLayout(gridLayout3, 0, 1, 1, 1);

        hboxLayout2 = new QHBoxLayout();
        hboxLayout2->setSpacing(4);
        hboxLayout2->setObjectName("hboxLayout2");
        JackNameTextLabel = new QLabel(AudioTabPage);
        JackNameTextLabel->setObjectName("JackNameTextLabel");
        JackNameTextLabel->setFrameShape(QFrame::NoFrame);
        JackNameTextLabel->setFrameShadow(QFrame::Plain);
        JackNameTextLabel->setWordWrap(false);

        hboxLayout2->addWidget(JackNameTextLabel);

        JackNameComboBox = new QComboBox(AudioTabPage);
        JackNameComboBox->addItem(QString());
        JackNameComboBox->addItem(QString());
        JackNameComboBox->setObjectName("JackNameComboBox");
        JackNameComboBox->setEditable(true);

        hboxLayout2->addWidget(JackNameComboBox);

        spacerItem7 = new QSpacerItem(8, 8, QSizePolicy::Policy::Expanding, QSizePolicy::Policy::Minimum);

        hboxLayout2->addItem(spacerItem7);


        gridLayout1->addLayout(hboxLayout2, 3, 0, 1, 2);

        JackAutoConnectCheckBox = new QCheckBox(AudioTabPage);
        JackAutoConnectCheckBox->setObjectName("JackAutoConnectCheckBox");

        gridLayout1->addWidget(JackAutoConnectCheckBox, 4, 0, 1, 1);

        JackMultiCheckBox = new QCheckBox(AudioTabPage);
        JackMultiCheckBox->setObjectName("JackMultiCheckBox");

        gridLayout1->addWidget(JackMultiCheckBox, 5, 0, 1, 1);

        spacerItem8 = new QSpacerItem(8, 8, QSizePolicy::Policy::Minimum, QSizePolicy::Policy::Expanding);

        gridLayout1->addItem(spacerItem8, 2, 0, 1, 1);

        WasapiExclusiveCheckBox = new QCheckBox(AudioTabPage);
        WasapiExclusiveCheckBox->setObjectName("WasapiExclusiveCheckBox");

        gridLayout1->addWidget(WasapiExclusiveCheckBox, 6, 0, 1, 1);

        SetupTabWidget->addTab(AudioTabPage, QString());
        SoundFontTabPage = new QWidget();
        SoundFontTabPage->setObjectName("SoundFontTabPage");
        gridLayout4 = new QGridLayout(SoundFontTabPage);
        gridLayout4->setSpacing(8);
        gridLayout4->setContentsMargins(8, 8, 8, 8);
        gridLayout4->setObjectName("gridLayout4");
        SoundFontListView = new QTreeWidget(SoundFontTabPage);
        SoundFontListView->setObjectName("SoundFontListView");
        SoundFontListView->setContextMenuPolicy(Qt::CustomContextMenu);
        SoundFontListView->setAlternatingRowColors(true);
        SoundFontListView->setIndentation(4);
        SoundFontListView->setRootIsDecorated(false);
        SoundFontListView->setUniformRowHeights(true);
        SoundFontListView->setItemsExpandable(false);
        SoundFontListView->setAllColumnsShowFocus(true);

        gridLayout4->addWidget(SoundFontListView, 0, 0, 1, 1);

        vboxLayout1 = new QVBoxLayout();
        vboxLayout1->setSpacing(4);
        vboxLayout1->setObjectName("vboxLayout1");
        SoundFontOpenPushButton = new QPushButton(SoundFontTabPage);
        SoundFontOpenPushButton->setObjectName("SoundFontOpenPushButton");
        const QIcon icon1 = QIcon(QString::fromUtf8(":/images/open1.png"));
        SoundFontOpenPushButton->setIcon(icon1);

        vboxLayout1->addWidget(SoundFontOpenPushButton);

        SoundFontEditPushButton = new QPushButton(SoundFontTabPage);
        SoundFontEditPushButton->setObjectName("SoundFontEditPushButton");
        const QIcon icon2 = QIcon(QString::fromUtf8(":/images/edit1.png"));
        SoundFontEditPushButton->setIcon(icon2);

        vboxLayout1->addWidget(SoundFontEditPushButton);

        SoundFontRemovePushButton = new QPushButton(SoundFontTabPage);
        SoundFontRemovePushButton->setObjectName("SoundFontRemovePushButton");
        const QIcon icon3 = QIcon(QString::fromUtf8(":/images/remove1.png"));
        SoundFontRemovePushButton->setIcon(icon3);

        vboxLayout1->addWidget(SoundFontRemovePushButton);

        spacerItem9 = new QSpacerItem(8, 8, QSizePolicy::Policy::Minimum, QSizePolicy::Policy::Expanding);

        vboxLayout1->addItem(spacerItem9);

        SoundFontMoveUpPushButton = new QPushButton(SoundFontTabPage);
        SoundFontMoveUpPushButton->setObjectName("SoundFontMoveUpPushButton");
        const QIcon icon4 = QIcon(QString::fromUtf8(":/images/up1.png"));
        SoundFontMoveUpPushButton->setIcon(icon4);

        vboxLayout1->addWidget(SoundFontMoveUpPushButton);

        SoundFontMoveDownPushButton = new QPushButton(SoundFontTabPage);
        SoundFontMoveDownPushButton->setObjectName("SoundFontMoveDownPushButton");
        const QIcon icon5 = QIcon(QString::fromUtf8(":/images/down1.png"));
        SoundFontMoveDownPushButton->setIcon(icon5);

        vboxLayout1->addWidget(SoundFontMoveDownPushButton);


        gridLayout4->addLayout(vboxLayout1, 0, 1, 1, 1);

        SetupTabWidget->addTab(SoundFontTabPage, QString());
        SettingsTabPage = new QWidget();
        SettingsTabPage->setObjectName("SettingsTabPage");
        vboxLayout2 = new QVBoxLayout(SettingsTabPage);
        vboxLayout2->setSpacing(8);
        vboxLayout2->setContentsMargins(8, 8, 8, 8);
        vboxLayout2->setObjectName("vboxLayout2");
        SettingsListView = new QTreeWidget(SettingsTabPage);
        SettingsListView->setObjectName("SettingsListView");
        QSizePolicy sizePolicy2(QSizePolicy::Policy::Expanding, QSizePolicy::Policy::Expanding);
        sizePolicy2.setHorizontalStretch(0);
        sizePolicy2.setVerticalStretch(0);
        sizePolicy2.setHeightForWidth(SettingsListView->sizePolicy().hasHeightForWidth());
        SettingsListView->setSizePolicy(sizePolicy2);
        SettingsListView->setMinimumSize(QSize(320, 0));
        SettingsListView->setAlternatingRowColors(true);
        SettingsListView->setSelectionMode(QAbstractItemView::SingleSelection);
        SettingsListView->setSelectionBehavior(QAbstractItemView::SelectRows);
        SettingsListView->setIndentation(4);
        SettingsListView->setRootIsDecorated(false);
        SettingsListView->setUniformRowHeights(true);
        SettingsListView->setItemsExpandable(false);
        SettingsListView->setAllColumnsShowFocus(true);

        vboxLayout2->addWidget(SettingsListView);

        SetupTabWidget->addTab(SettingsTabPage, QString());

        vboxLayout->addWidget(SetupTabWidget);

        DialogButtonBox = new QDialogButtonBox(qsynthSetupForm);
        DialogButtonBox->setObjectName("DialogButtonBox");
        DialogButtonBox->setOrientation(Qt::Horizontal);
        DialogButtonBox->setStandardButtons(QDialogButtonBox::Cancel|QDialogButtonBox::Ok);

        vboxLayout->addWidget(DialogButtonBox);

#if QT_CONFIG(shortcut)
        DisplayNameTextLabel->setBuddy(DisplayNameLineEdit);
        MidiDriverTextLabel->setBuddy(MidiDriverComboBox);
        MidiDeviceTextLabel->setBuddy(MidiDeviceComboBox);
        MidiChannelsTextLabel->setBuddy(MidiChannelsSpinBox);
        MidiBankSelectTextLabel->setBuddy(MidiBankSelectComboBox);
        MidiNameTextLabel->setBuddy(MidiNameComboBox);
        AudioDriverTextLabel->setBuddy(AudioDriverComboBox);
        SampleFormatTextLabel->setBuddy(SampleFormatComboBox);
        SampleRateTextLabel->setBuddy(SampleRateComboBox);
        AudioBufSizeTextLabel->setBuddy(AudioBufSizeComboBox);
        AudioBufCountTextLabel->setBuddy(AudioBufCountComboBox);
        AudioDeviceTextLabel->setBuddy(AudioDeviceComboBox);
        AudioChannelsTextLabel->setBuddy(AudioChannelsSpinBox);
        PolyphonyTextLabel->setBuddy(PolyphonySpinBox);
        AudioGroupsTextLabel->setBuddy(AudioGroupsSpinBox);
        JackNameTextLabel->setBuddy(JackNameComboBox);
#endif // QT_CONFIG(shortcut)
        QWidget::setTabOrder(DisplayNameLineEdit, SetupTabWidget);
        QWidget::setTabOrder(SetupTabWidget, MidiInCheckBox);
        QWidget::setTabOrder(MidiInCheckBox, MidiDriverComboBox);
        QWidget::setTabOrder(MidiDriverComboBox, MidiDeviceComboBox);
        QWidget::setTabOrder(MidiDeviceComboBox, MidiChannelsSpinBox);
        QWidget::setTabOrder(MidiChannelsSpinBox, MidiBankSelectComboBox);
        QWidget::setTabOrder(MidiBankSelectComboBox, MidiNameComboBox);
        QWidget::setTabOrder(MidiNameComboBox, MidiAutoConnectCheckBox);
        QWidget::setTabOrder(MidiAutoConnectCheckBox, VerboseCheckBox);
        QWidget::setTabOrder(VerboseCheckBox, MidiDumpCheckBox);
        QWidget::setTabOrder(MidiDumpCheckBox, AudioDriverComboBox);
        QWidget::setTabOrder(AudioDriverComboBox, AudioDeviceComboBox);
        QWidget::setTabOrder(AudioDeviceComboBox, SampleFormatComboBox);
        QWidget::setTabOrder(SampleFormatComboBox, AudioChannelsSpinBox);
        QWidget::setTabOrder(AudioChannelsSpinBox, SampleRateComboBox);
        QWidget::setTabOrder(SampleRateComboBox, AudioGroupsSpinBox);
        QWidget::setTabOrder(AudioGroupsSpinBox, AudioBufSizeComboBox);
        QWidget::setTabOrder(AudioBufSizeComboBox, PolyphonySpinBox);
        QWidget::setTabOrder(PolyphonySpinBox, AudioBufCountComboBox);
        QWidget::setTabOrder(AudioBufCountComboBox, JackNameComboBox);
        QWidget::setTabOrder(JackNameComboBox, JackAutoConnectCheckBox);
        QWidget::setTabOrder(JackAutoConnectCheckBox, JackMultiCheckBox);
        QWidget::setTabOrder(JackMultiCheckBox, WasapiExclusiveCheckBox);
        QWidget::setTabOrder(WasapiExclusiveCheckBox, SoundFontListView);
        QWidget::setTabOrder(SoundFontListView, SoundFontOpenPushButton);
        QWidget::setTabOrder(SoundFontOpenPushButton, SoundFontEditPushButton);
        QWidget::setTabOrder(SoundFontEditPushButton, SoundFontRemovePushButton);
        QWidget::setTabOrder(SoundFontRemovePushButton, SoundFontMoveUpPushButton);
        QWidget::setTabOrder(SoundFontMoveUpPushButton, SoundFontMoveDownPushButton);
        QWidget::setTabOrder(SoundFontMoveDownPushButton, SettingsListView);
        QWidget::setTabOrder(SettingsListView, DialogButtonBox);

        retranslateUi(qsynthSetupForm);

        SetupTabWidget->setCurrentIndex(0);
        SampleRateComboBox->setCurrentIndex(1);
        JackNameComboBox->setCurrentIndex(1);


        QMetaObject::connectSlotsByName(qsynthSetupForm);
    } // setupUi

    void retranslateUi(QDialog *qsynthSetupForm)
    {
        qsynthSetupForm->setWindowTitle(QCoreApplication::translate("qsynthSetupForm", "Setup", nullptr));
        DisplayNameTextLabel->setText(QCoreApplication::translate("qsynthSetupForm", "Engine &Name:", nullptr));
#if QT_CONFIG(tooltip)
        DisplayNameLineEdit->setToolTip(QCoreApplication::translate("qsynthSetupForm", "Engine display name", nullptr));
#endif // QT_CONFIG(tooltip)
#if QT_CONFIG(tooltip)
        MidiInCheckBox->setToolTip(QCoreApplication::translate("qsynthSetupForm", "Enable MIDI input", nullptr));
#endif // QT_CONFIG(tooltip)
        MidiInCheckBox->setText(QCoreApplication::translate("qsynthSetupForm", "Enable MIDI &Input", nullptr));
        MidiDriverTextLabel->setText(QCoreApplication::translate("qsynthSetupForm", "MIDI &Driver:", nullptr));
#if QT_CONFIG(tooltip)
        MidiDriverComboBox->setToolTip(QCoreApplication::translate("qsynthSetupForm", "Input MIDI driver", nullptr));
#endif // QT_CONFIG(tooltip)
        MidiDeviceTextLabel->setText(QCoreApplication::translate("qsynthSetupForm", "MIDI D&evice:", nullptr));
#if QT_CONFIG(tooltip)
        MidiDeviceComboBox->setToolTip(QCoreApplication::translate("qsynthSetupForm", "MIDI device name", nullptr));
#endif // QT_CONFIG(tooltip)
#if QT_CONFIG(tooltip)
        MidiChannelsTextLabel->setToolTip(QString());
#endif // QT_CONFIG(tooltip)
        MidiChannelsTextLabel->setText(QCoreApplication::translate("qsynthSetupForm", "MIDI &Channels:", nullptr));
#if QT_CONFIG(tooltip)
        MidiChannelsSpinBox->setToolTip(QCoreApplication::translate("qsynthSetupForm", "Number of MIDI channels", nullptr));
#endif // QT_CONFIG(tooltip)
        MidiBankSelectTextLabel->setText(QCoreApplication::translate("qsynthSetupForm", "MIDI &Bank Select mode:", nullptr));
        MidiBankSelectComboBox->setItemText(0, QCoreApplication::translate("qsynthSetupForm", "gm", nullptr));
        MidiBankSelectComboBox->setItemText(1, QCoreApplication::translate("qsynthSetupForm", "gs", nullptr));
        MidiBankSelectComboBox->setItemText(2, QCoreApplication::translate("qsynthSetupForm", "mma", nullptr));
        MidiBankSelectComboBox->setItemText(3, QCoreApplication::translate("qsynthSetupForm", "xs", nullptr));

#if QT_CONFIG(tooltip)
        MidiBankSelectComboBox->setToolTip(QCoreApplication::translate("qsynthSetupForm", "MIDI Bank Select mode", nullptr));
#endif // QT_CONFIG(tooltip)
        MidiNameTextLabel->setText(QCoreApplication::translate("qsynthSetupForm", "MIDI Client &Name ID (ALSA/CoreMidi):", nullptr));
        MidiNameComboBox->setItemText(0, QCoreApplication::translate("qsynthSetupForm", "pid", nullptr));
        MidiNameComboBox->setItemText(1, QCoreApplication::translate("qsynthSetupForm", "qsynth", nullptr));

#if QT_CONFIG(tooltip)
        MidiNameComboBox->setToolTip(QCoreApplication::translate("qsynthSetupForm", "ALSA Sequencer client name identification", nullptr));
#endif // QT_CONFIG(tooltip)
#if QT_CONFIG(tooltip)
        MidiAutoConnectCheckBox->setToolTip(QCoreApplication::translate("qsynthSetupForm", "Attempt to connect the MIDI inputs to the physical ports", nullptr));
#endif // QT_CONFIG(tooltip)
        MidiAutoConnectCheckBox->setText(QCoreApplication::translate("qsynthSetupForm", "&Auto Connect MIDI Inputs", nullptr));
#if QT_CONFIG(tooltip)
        VerboseCheckBox->setToolTip(QCoreApplication::translate("qsynthSetupForm", "Print out verbose messages about MIDI events", nullptr));
#endif // QT_CONFIG(tooltip)
        VerboseCheckBox->setText(QCoreApplication::translate("qsynthSetupForm", "&Verbose MIDI event messages", nullptr));
#if QT_CONFIG(tooltip)
        MidiDumpCheckBox->setToolTip(QCoreApplication::translate("qsynthSetupForm", "Whether to show MIDI router events on messages window", nullptr));
#endif // QT_CONFIG(tooltip)
        MidiDumpCheckBox->setText(QCoreApplication::translate("qsynthSetupForm", "D&ump MIDI router events", nullptr));
        SetupTabWidget->setTabText(SetupTabWidget->indexOf(MidiTabPage), QCoreApplication::translate("qsynthSetupForm", "&MIDI", nullptr));
        AudioDriverTextLabel->setText(QCoreApplication::translate("qsynthSetupForm", "Audio &Driver:", nullptr));
#if QT_CONFIG(tooltip)
        AudioDriverComboBox->setToolTip(QCoreApplication::translate("qsynthSetupForm", "Output audio driver", nullptr));
#endif // QT_CONFIG(tooltip)
        SampleFormatTextLabel->setText(QCoreApplication::translate("qsynthSetupForm", "Sample &Format:", nullptr));
#if QT_CONFIG(tooltip)
        SampleFormatComboBox->setToolTip(QCoreApplication::translate("qsynthSetupForm", "Sample format", nullptr));
#endif // QT_CONFIG(tooltip)
        SampleRateTextLabel->setText(QCoreApplication::translate("qsynthSetupForm", "Sample &Rate:", nullptr));
        SampleRateComboBox->setItemText(0, QCoreApplication::translate("qsynthSetupForm", "22050", nullptr));
        SampleRateComboBox->setItemText(1, QCoreApplication::translate("qsynthSetupForm", "44100", nullptr));
        SampleRateComboBox->setItemText(2, QCoreApplication::translate("qsynthSetupForm", "48000", nullptr));
        SampleRateComboBox->setItemText(3, QCoreApplication::translate("qsynthSetupForm", "88200", nullptr));
        SampleRateComboBox->setItemText(4, QCoreApplication::translate("qsynthSetupForm", "96000", nullptr));

#if QT_CONFIG(tooltip)
        SampleRateComboBox->setToolTip(QCoreApplication::translate("qsynthSetupForm", "Sample rate in samples per second (Hz)", nullptr));
#endif // QT_CONFIG(tooltip)
        AudioBufSizeTextLabel->setText(QCoreApplication::translate("qsynthSetupForm", "Buffer &Size:", nullptr));
        AudioBufSizeComboBox->setItemText(0, QCoreApplication::translate("qsynthSetupForm", "64", nullptr));
        AudioBufSizeComboBox->setItemText(1, QCoreApplication::translate("qsynthSetupForm", "128", nullptr));
        AudioBufSizeComboBox->setItemText(2, QCoreApplication::translate("qsynthSetupForm", "256", nullptr));
        AudioBufSizeComboBox->setItemText(3, QCoreApplication::translate("qsynthSetupForm", "512", nullptr));
        AudioBufSizeComboBox->setItemText(4, QCoreApplication::translate("qsynthSetupForm", "1024", nullptr));
        AudioBufSizeComboBox->setItemText(5, QCoreApplication::translate("qsynthSetupForm", "2048", nullptr));
        AudioBufSizeComboBox->setItemText(6, QCoreApplication::translate("qsynthSetupForm", "4096", nullptr));
        AudioBufSizeComboBox->setItemText(7, QCoreApplication::translate("qsynthSetupForm", "8192", nullptr));

#if QT_CONFIG(tooltip)
        AudioBufSizeComboBox->setToolTip(QCoreApplication::translate("qsynthSetupForm", "Period size in bytes (audio buffer size)", nullptr));
#endif // QT_CONFIG(tooltip)
        AudioBufCountTextLabel->setText(QCoreApplication::translate("qsynthSetupForm", "Buffer Cou&nt:", nullptr));
        AudioBufCountComboBox->setItemText(0, QCoreApplication::translate("qsynthSetupForm", "2", nullptr));
        AudioBufCountComboBox->setItemText(1, QCoreApplication::translate("qsynthSetupForm", "4", nullptr));
        AudioBufCountComboBox->setItemText(2, QCoreApplication::translate("qsynthSetupForm", "8", nullptr));
        AudioBufCountComboBox->setItemText(3, QCoreApplication::translate("qsynthSetupForm", "16", nullptr));
        AudioBufCountComboBox->setItemText(4, QCoreApplication::translate("qsynthSetupForm", "32", nullptr));
        AudioBufCountComboBox->setItemText(5, QCoreApplication::translate("qsynthSetupForm", "64", nullptr));

#if QT_CONFIG(tooltip)
        AudioBufCountComboBox->setToolTip(QCoreApplication::translate("qsynthSetupForm", "Period count (number of audio buffers)", nullptr));
#endif // QT_CONFIG(tooltip)
        AudioDeviceTextLabel->setText(QCoreApplication::translate("qsynthSetupForm", "Audio D&evice:", nullptr));
#if QT_CONFIG(tooltip)
        AudioChannelsTextLabel->setToolTip(QString());
#endif // QT_CONFIG(tooltip)
        AudioChannelsTextLabel->setText(QCoreApplication::translate("qsynthSetupForm", "Audio &Channels:", nullptr));
#if QT_CONFIG(tooltip)
        AudioGroupsSpinBox->setToolTip(QCoreApplication::translate("qsynthSetupForm", "Number of audio groups", nullptr));
#endif // QT_CONFIG(tooltip)
#if QT_CONFIG(tooltip)
        PolyphonySpinBox->setToolTip(QCoreApplication::translate("qsynthSetupForm", "Number of enabled polyphonic voices", nullptr));
#endif // QT_CONFIG(tooltip)
#if QT_CONFIG(tooltip)
        AudioChannelsSpinBox->setToolTip(QCoreApplication::translate("qsynthSetupForm", "Number of stereo audio channels", nullptr));
#endif // QT_CONFIG(tooltip)
#if QT_CONFIG(tooltip)
        AudioDeviceComboBox->setToolTip(QCoreApplication::translate("qsynthSetupForm", "MIDI device name", nullptr));
#endif // QT_CONFIG(tooltip)
#if QT_CONFIG(tooltip)
        PolyphonyTextLabel->setToolTip(QString());
#endif // QT_CONFIG(tooltip)
        PolyphonyTextLabel->setText(QCoreApplication::translate("qsynthSetupForm", "&Polyphony:", nullptr));
#if QT_CONFIG(tooltip)
        AudioGroupsTextLabel->setToolTip(QString());
#endif // QT_CONFIG(tooltip)
        AudioGroupsTextLabel->setText(QCoreApplication::translate("qsynthSetupForm", "Audio &Groups:", nullptr));
        JackNameTextLabel->setText(QCoreApplication::translate("qsynthSetupForm", "JACK Client &Name ID:", nullptr));
        JackNameComboBox->setItemText(0, QCoreApplication::translate("qsynthSetupForm", "fluidsynth", nullptr));
        JackNameComboBox->setItemText(1, QCoreApplication::translate("qsynthSetupForm", "qsynth", nullptr));

#if QT_CONFIG(tooltip)
        JackNameComboBox->setToolTip(QCoreApplication::translate("qsynthSetupForm", "JACK client name identification", nullptr));
#endif // QT_CONFIG(tooltip)
#if QT_CONFIG(tooltip)
        JackAutoConnectCheckBox->setToolTip(QCoreApplication::translate("qsynthSetupForm", "Attempt to connect the JACK outputs to the physical ports", nullptr));
#endif // QT_CONFIG(tooltip)
        JackAutoConnectCheckBox->setText(QCoreApplication::translate("qsynthSetupForm", "&Auto Connect JACK Outputs", nullptr));
#if QT_CONFIG(tooltip)
        JackMultiCheckBox->setToolTip(QCoreApplication::translate("qsynthSetupForm", "Create multiple JACK output ports for channels, groups and effects", nullptr));
#endif // QT_CONFIG(tooltip)
        JackMultiCheckBox->setText(QCoreApplication::translate("qsynthSetupForm", "&Multiple JACK Outputs", nullptr));
        WasapiExclusiveCheckBox->setText(QCoreApplication::translate("qsynthSetupForm", "&WASAPI Exclusive Mode", nullptr));
        SetupTabWidget->setTabText(SetupTabWidget->indexOf(AudioTabPage), QCoreApplication::translate("qsynthSetupForm", "&Audio", nullptr));
        QTreeWidgetItem *___qtreewidgetitem = SoundFontListView->headerItem();
        ___qtreewidgetitem->setText(2, QCoreApplication::translate("qsynthSetupForm", "Offset", nullptr));
        ___qtreewidgetitem->setText(1, QCoreApplication::translate("qsynthSetupForm", "Name", nullptr));
        ___qtreewidgetitem->setText(0, QCoreApplication::translate("qsynthSetupForm", "SFID", nullptr));
#if QT_CONFIG(tooltip)
        SoundFontListView->setToolTip(QCoreApplication::translate("qsynthSetupForm", "Soundfont stack", nullptr));
#endif // QT_CONFIG(tooltip)
#if QT_CONFIG(tooltip)
        SoundFontOpenPushButton->setToolTip(QCoreApplication::translate("qsynthSetupForm", "Open soundfont file for loading", nullptr));
#endif // QT_CONFIG(tooltip)
        SoundFontOpenPushButton->setText(QCoreApplication::translate("qsynthSetupForm", "&Open...", nullptr));
#if QT_CONFIG(tooltip)
        SoundFontEditPushButton->setToolTip(QCoreApplication::translate("qsynthSetupForm", "Edit selected soundfont bank offset", nullptr));
#endif // QT_CONFIG(tooltip)
        SoundFontEditPushButton->setText(QCoreApplication::translate("qsynthSetupForm", "&Edit", nullptr));
#if QT_CONFIG(tooltip)
        SoundFontRemovePushButton->setToolTip(QCoreApplication::translate("qsynthSetupForm", "Remove selected soundfont from stack", nullptr));
#endif // QT_CONFIG(tooltip)
        SoundFontRemovePushButton->setText(QCoreApplication::translate("qsynthSetupForm", "&Remove", nullptr));
#if QT_CONFIG(tooltip)
        SoundFontMoveUpPushButton->setToolTip(QCoreApplication::translate("qsynthSetupForm", "Move up selected soundfont towards the top of stack", nullptr));
#endif // QT_CONFIG(tooltip)
        SoundFontMoveUpPushButton->setText(QCoreApplication::translate("qsynthSetupForm", "&Up", nullptr));
#if QT_CONFIG(tooltip)
        SoundFontMoveDownPushButton->setToolTip(QCoreApplication::translate("qsynthSetupForm", "Move down selected soundfont towards the bottom of stack", nullptr));
#endif // QT_CONFIG(tooltip)
        SoundFontMoveDownPushButton->setText(QCoreApplication::translate("qsynthSetupForm", "&Down", nullptr));
        SetupTabWidget->setTabText(SetupTabWidget->indexOf(SoundFontTabPage), QCoreApplication::translate("qsynthSetupForm", "&Soundfonts", nullptr));
        QTreeWidgetItem *___qtreewidgetitem1 = SettingsListView->headerItem();
        ___qtreewidgetitem1->setText(7, QCoreApplication::translate("qsynthSetupForm", "Options", nullptr));
        ___qtreewidgetitem1->setText(6, QCoreApplication::translate("qsynthSetupForm", "Max", nullptr));
        ___qtreewidgetitem1->setText(5, QCoreApplication::translate("qsynthSetupForm", "Min", nullptr));
        ___qtreewidgetitem1->setText(4, QCoreApplication::translate("qsynthSetupForm", "Default", nullptr));
        ___qtreewidgetitem1->setText(3, QCoreApplication::translate("qsynthSetupForm", "Current", nullptr));
        ___qtreewidgetitem1->setText(2, QCoreApplication::translate("qsynthSetupForm", "Realtime", nullptr));
        ___qtreewidgetitem1->setText(1, QCoreApplication::translate("qsynthSetupForm", "Type", nullptr));
        ___qtreewidgetitem1->setText(0, QCoreApplication::translate("qsynthSetupForm", "Name", nullptr));
        SetupTabWidget->setTabText(SetupTabWidget->indexOf(SettingsTabPage), QCoreApplication::translate("qsynthSetupForm", "S&ettings", nullptr));
    } // retranslateUi

};

namespace Ui {
    class qsynthSetupForm: public Ui_qsynthSetupForm {};
} // namespace Ui

QT_END_NAMESPACE

#endif // UI_QSYNTHSETUPFORM_H
