/* This file is autogenerated by scripts/decodetree.py.  */

typedef struct {
    int rd;
    int bit;
} arg_decode_insn10;

typedef struct {
    int rd;
} arg_decode_insn2;

typedef struct {
    int imm;
} arg_decode_insn3;

typedef struct {
    int bit;
} arg_decode_insn4;

typedef struct {
    int imm;
    int bit;
} arg_decode_insn5;

typedef struct {
} arg_decode_insn6;

typedef struct {
    int rr;
    int bit;
} arg_decode_insn7;

typedef struct {
    int reg;
    int bit;
} arg_decode_insn8;

typedef struct {
    int rr;
} arg_decode_insn9;

typedef struct {
    int rd;
    int imm;
} arg_rd_imm;

typedef struct {
    int rd;
    int rr;
} arg_rd_rr;

typedef arg_rd_rr arg_ADD;
static bool trans_ADD(DisasContext *ctx, arg_ADD *a);
typedef arg_rd_rr arg_ADC;
static bool trans_ADC(DisasContext *ctx, arg_ADC *a);
typedef arg_rd_imm arg_ADIW;
static bool trans_ADIW(DisasContext *ctx, arg_ADIW *a);
typedef arg_rd_rr arg_SUB;
static bool trans_SUB(DisasContext *ctx, arg_SUB *a);
typedef arg_rd_imm arg_SUBI;
static bool trans_SUBI(DisasContext *ctx, arg_SUBI *a);
typedef arg_rd_rr arg_SBC;
static bool trans_SBC(DisasContext *ctx, arg_SBC *a);
typedef arg_rd_imm arg_SBCI;
static bool trans_SBCI(DisasContext *ctx, arg_SBCI *a);
typedef arg_rd_imm arg_SBIW;
static bool trans_SBIW(DisasContext *ctx, arg_SBIW *a);
typedef arg_rd_rr arg_AND;
static bool trans_AND(DisasContext *ctx, arg_AND *a);
typedef arg_rd_imm arg_ANDI;
static bool trans_ANDI(DisasContext *ctx, arg_ANDI *a);
typedef arg_rd_rr arg_OR;
static bool trans_OR(DisasContext *ctx, arg_OR *a);
typedef arg_rd_imm arg_ORI;
static bool trans_ORI(DisasContext *ctx, arg_ORI *a);
typedef arg_rd_rr arg_EOR;
static bool trans_EOR(DisasContext *ctx, arg_EOR *a);
typedef arg_decode_insn2 arg_COM;
static bool trans_COM(DisasContext *ctx, arg_COM *a);
typedef arg_decode_insn2 arg_NEG;
static bool trans_NEG(DisasContext *ctx, arg_NEG *a);
typedef arg_decode_insn2 arg_INC;
static bool trans_INC(DisasContext *ctx, arg_INC *a);
typedef arg_decode_insn2 arg_DEC;
static bool trans_DEC(DisasContext *ctx, arg_DEC *a);
typedef arg_rd_rr arg_MUL;
static bool trans_MUL(DisasContext *ctx, arg_MUL *a);
typedef arg_rd_rr arg_MULS;
static bool trans_MULS(DisasContext *ctx, arg_MULS *a);
typedef arg_rd_rr arg_MULSU;
static bool trans_MULSU(DisasContext *ctx, arg_MULSU *a);
typedef arg_rd_rr arg_FMUL;
static bool trans_FMUL(DisasContext *ctx, arg_FMUL *a);
typedef arg_rd_rr arg_FMULS;
static bool trans_FMULS(DisasContext *ctx, arg_FMULS *a);
typedef arg_rd_rr arg_FMULSU;
static bool trans_FMULSU(DisasContext *ctx, arg_FMULSU *a);
typedef arg_decode_insn3 arg_DES;
static bool trans_DES(DisasContext *ctx, arg_DES *a);
typedef arg_decode_insn3 arg_RJMP;
static bool trans_RJMP(DisasContext *ctx, arg_RJMP *a);
typedef arg_decode_insn6 arg_IJMP;
static bool trans_IJMP(DisasContext *ctx, arg_IJMP *a);
typedef arg_decode_insn6 arg_EIJMP;
static bool trans_EIJMP(DisasContext *ctx, arg_EIJMP *a);
typedef arg_decode_insn3 arg_JMP;
static bool trans_JMP(DisasContext *ctx, arg_JMP *a);
typedef arg_decode_insn3 arg_RCALL;
static bool trans_RCALL(DisasContext *ctx, arg_RCALL *a);
typedef arg_decode_insn6 arg_ICALL;
static bool trans_ICALL(DisasContext *ctx, arg_ICALL *a);
typedef arg_decode_insn6 arg_EICALL;
static bool trans_EICALL(DisasContext *ctx, arg_EICALL *a);
typedef arg_decode_insn3 arg_CALL;
static bool trans_CALL(DisasContext *ctx, arg_CALL *a);
typedef arg_decode_insn6 arg_RET;
static bool trans_RET(DisasContext *ctx, arg_RET *a);
typedef arg_decode_insn6 arg_RETI;
static bool trans_RETI(DisasContext *ctx, arg_RETI *a);
typedef arg_rd_rr arg_CPSE;
static bool trans_CPSE(DisasContext *ctx, arg_CPSE *a);
typedef arg_rd_rr arg_CP;
static bool trans_CP(DisasContext *ctx, arg_CP *a);
typedef arg_rd_rr arg_CPC;
static bool trans_CPC(DisasContext *ctx, arg_CPC *a);
typedef arg_rd_imm arg_CPI;
static bool trans_CPI(DisasContext *ctx, arg_CPI *a);
typedef arg_decode_insn7 arg_SBRC;
static bool trans_SBRC(DisasContext *ctx, arg_SBRC *a);
typedef arg_decode_insn7 arg_SBRS;
static bool trans_SBRS(DisasContext *ctx, arg_SBRS *a);
typedef arg_decode_insn8 arg_SBIC;
static bool trans_SBIC(DisasContext *ctx, arg_SBIC *a);
typedef arg_decode_insn8 arg_SBIS;
static bool trans_SBIS(DisasContext *ctx, arg_SBIS *a);
typedef arg_decode_insn5 arg_BRBS;
static bool trans_BRBS(DisasContext *ctx, arg_BRBS *a);
typedef arg_decode_insn5 arg_BRBC;
static bool trans_BRBC(DisasContext *ctx, arg_BRBC *a);
typedef arg_rd_rr arg_MOV;
static bool trans_MOV(DisasContext *ctx, arg_MOV *a);
typedef arg_rd_rr arg_MOVW;
static bool trans_MOVW(DisasContext *ctx, arg_MOVW *a);
typedef arg_rd_imm arg_LDI;
static bool trans_LDI(DisasContext *ctx, arg_LDI *a);
typedef arg_rd_imm arg_LDS;
static bool trans_LDS(DisasContext *ctx, arg_LDS *a);
typedef arg_decode_insn2 arg_LDX1;
static bool trans_LDX1(DisasContext *ctx, arg_LDX1 *a);
typedef arg_decode_insn2 arg_LDX2;
static bool trans_LDX2(DisasContext *ctx, arg_LDX2 *a);
typedef arg_decode_insn2 arg_LDX3;
static bool trans_LDX3(DisasContext *ctx, arg_LDX3 *a);
typedef arg_decode_insn2 arg_LDY2;
static bool trans_LDY2(DisasContext *ctx, arg_LDY2 *a);
typedef arg_decode_insn2 arg_LDY3;
static bool trans_LDY3(DisasContext *ctx, arg_LDY3 *a);
typedef arg_decode_insn2 arg_LDZ2;
static bool trans_LDZ2(DisasContext *ctx, arg_LDZ2 *a);
typedef arg_decode_insn2 arg_LDZ3;
static bool trans_LDZ3(DisasContext *ctx, arg_LDZ3 *a);
typedef arg_rd_imm arg_LDDY;
static bool trans_LDDY(DisasContext *ctx, arg_LDDY *a);
typedef arg_rd_imm arg_LDDZ;
static bool trans_LDDZ(DisasContext *ctx, arg_LDDZ *a);
typedef arg_rd_imm arg_STS;
static bool trans_STS(DisasContext *ctx, arg_STS *a);
typedef arg_decode_insn9 arg_STX1;
static bool trans_STX1(DisasContext *ctx, arg_STX1 *a);
typedef arg_decode_insn9 arg_STX2;
static bool trans_STX2(DisasContext *ctx, arg_STX2 *a);
typedef arg_decode_insn9 arg_STX3;
static bool trans_STX3(DisasContext *ctx, arg_STX3 *a);
typedef arg_decode_insn2 arg_STY2;
static bool trans_STY2(DisasContext *ctx, arg_STY2 *a);
typedef arg_decode_insn2 arg_STY3;
static bool trans_STY3(DisasContext *ctx, arg_STY3 *a);
typedef arg_decode_insn2 arg_STZ2;
static bool trans_STZ2(DisasContext *ctx, arg_STZ2 *a);
typedef arg_decode_insn2 arg_STZ3;
static bool trans_STZ3(DisasContext *ctx, arg_STZ3 *a);
typedef arg_rd_imm arg_STDY;
static bool trans_STDY(DisasContext *ctx, arg_STDY *a);
typedef arg_rd_imm arg_STDZ;
static bool trans_STDZ(DisasContext *ctx, arg_STDZ *a);
typedef arg_decode_insn6 arg_LPM1;
static bool trans_LPM1(DisasContext *ctx, arg_LPM1 *a);
typedef arg_decode_insn2 arg_LPM2;
static bool trans_LPM2(DisasContext *ctx, arg_LPM2 *a);
typedef arg_decode_insn2 arg_LPMX;
static bool trans_LPMX(DisasContext *ctx, arg_LPMX *a);
typedef arg_decode_insn6 arg_ELPM1;
static bool trans_ELPM1(DisasContext *ctx, arg_ELPM1 *a);
typedef arg_decode_insn2 arg_ELPM2;
static bool trans_ELPM2(DisasContext *ctx, arg_ELPM2 *a);
typedef arg_decode_insn2 arg_ELPMX;
static bool trans_ELPMX(DisasContext *ctx, arg_ELPMX *a);
typedef arg_decode_insn6 arg_SPM;
static bool trans_SPM(DisasContext *ctx, arg_SPM *a);
typedef arg_decode_insn6 arg_SPMX;
static bool trans_SPMX(DisasContext *ctx, arg_SPMX *a);
typedef arg_rd_imm arg_IN;
static bool trans_IN(DisasContext *ctx, arg_IN *a);
typedef arg_rd_imm arg_OUT;
static bool trans_OUT(DisasContext *ctx, arg_OUT *a);
typedef arg_decode_insn2 arg_PUSH;
static bool trans_PUSH(DisasContext *ctx, arg_PUSH *a);
typedef arg_decode_insn2 arg_POP;
static bool trans_POP(DisasContext *ctx, arg_POP *a);
typedef arg_decode_insn2 arg_XCH;
static bool trans_XCH(DisasContext *ctx, arg_XCH *a);
typedef arg_decode_insn2 arg_LAC;
static bool trans_LAC(DisasContext *ctx, arg_LAC *a);
typedef arg_decode_insn2 arg_LAS;
static bool trans_LAS(DisasContext *ctx, arg_LAS *a);
typedef arg_decode_insn2 arg_LAT;
static bool trans_LAT(DisasContext *ctx, arg_LAT *a);
typedef arg_decode_insn2 arg_LSR;
static bool trans_LSR(DisasContext *ctx, arg_LSR *a);
typedef arg_decode_insn2 arg_ROR;
static bool trans_ROR(DisasContext *ctx, arg_ROR *a);
typedef arg_decode_insn2 arg_ASR;
static bool trans_ASR(DisasContext *ctx, arg_ASR *a);
typedef arg_decode_insn2 arg_SWAP;
static bool trans_SWAP(DisasContext *ctx, arg_SWAP *a);
typedef arg_decode_insn8 arg_SBI;
static bool trans_SBI(DisasContext *ctx, arg_SBI *a);
typedef arg_decode_insn8 arg_CBI;
static bool trans_CBI(DisasContext *ctx, arg_CBI *a);
typedef arg_decode_insn10 arg_BST;
static bool trans_BST(DisasContext *ctx, arg_BST *a);
typedef arg_decode_insn10 arg_BLD;
static bool trans_BLD(DisasContext *ctx, arg_BLD *a);
typedef arg_decode_insn4 arg_BSET;
static bool trans_BSET(DisasContext *ctx, arg_BSET *a);
typedef arg_decode_insn4 arg_BCLR;
static bool trans_BCLR(DisasContext *ctx, arg_BCLR *a);
typedef arg_decode_insn6 arg_BREAK;
static bool trans_BREAK(DisasContext *ctx, arg_BREAK *a);
typedef arg_decode_insn6 arg_NOP;
static bool trans_NOP(DisasContext *ctx, arg_NOP *a);
typedef arg_decode_insn6 arg_SLEEP;
static bool trans_SLEEP(DisasContext *ctx, arg_SLEEP *a);
typedef arg_decode_insn6 arg_WDR;
static bool trans_WDR(DisasContext *ctx, arg_WDR *a);

static void decode_insn_extract_decode_insn_Fmt_10(DisasContext *ctx, arg_decode_insn6 *a, uint16_t insn)
{
}

static void decode_insn_extract_decode_insn_Fmt_11(DisasContext *ctx, arg_decode_insn3 *a, uint16_t insn)
{
    a->imm = append_16(ctx, deposit32(extract32(insn, 0, 1), 1, 31, extract32(insn, 4, 5)));
}

static void decode_insn_extract_decode_insn_Fmt_12(DisasContext *ctx, arg_decode_insn7 *a, uint16_t insn)
{
    a->rr = extract32(insn, 4, 5);
    a->bit = extract32(insn, 0, 3);
}

static void decode_insn_extract_decode_insn_Fmt_13(DisasContext *ctx, arg_decode_insn8 *a, uint16_t insn)
{
    a->reg = extract32(insn, 3, 5);
    a->bit = extract32(insn, 0, 3);
}

static void decode_insn_extract_decode_insn_Fmt_17(DisasContext *ctx, arg_rd_rr *a, uint16_t insn)
{
    a->rd = to_regs_00_30_by_two(ctx, extract32(insn, 4, 4));
    a->rr = to_regs_00_30_by_two(ctx, extract32(insn, 0, 4));
}

static void decode_insn_extract_decode_insn_Fmt_18(DisasContext *ctx, arg_decode_insn9 *a, uint16_t insn)
{
    a->rr = extract32(insn, 4, 5);
}

static void decode_insn_extract_decode_insn_Fmt_19(DisasContext *ctx, arg_decode_insn10 *a, uint16_t insn)
{
    a->rd = extract32(insn, 4, 5);
    a->bit = extract32(insn, 0, 3);
}

static void decode_insn_extract_decode_insn_Fmt_4(DisasContext *ctx, arg_decode_insn2 *a, uint16_t insn)
{
    a->rd = extract32(insn, 4, 5);
}

static void decode_insn_extract_decode_insn_Fmt_5(DisasContext *ctx, arg_rd_rr *a, uint16_t insn)
{
    a->rd = to_regs_16_31_by_one(ctx, extract32(insn, 4, 4));
    a->rr = to_regs_16_31_by_one(ctx, extract32(insn, 0, 4));
}

static void decode_insn_extract_decode_insn_Fmt_6(DisasContext *ctx, arg_decode_insn3 *a, uint16_t insn)
{
    a->imm = extract32(insn, 4, 4);
}

static void decode_insn_extract_decode_insn_Fmt_9(DisasContext *ctx, arg_decode_insn3 *a, uint16_t insn)
{
    a->imm = sextract32(insn, 0, 12);
}

static void decode_insn_extract_fmul(DisasContext *ctx, arg_rd_rr *a, uint16_t insn)
{
    a->rd = to_regs_16_23_by_one(ctx, extract32(insn, 4, 3));
    a->rr = to_regs_16_23_by_one(ctx, extract32(insn, 0, 3));
}

static void decode_insn_extract_io_rd_imm(DisasContext *ctx, arg_rd_imm *a, uint16_t insn)
{
    a->rd = extract32(insn, 4, 5);
    a->imm = deposit32(extract32(insn, 0, 4), 4, 28, extract32(insn, 9, 2));
}

static void decode_insn_extract_ldst_d(DisasContext *ctx, arg_rd_imm *a, uint16_t insn)
{
    a->rd = extract32(insn, 4, 5);
    a->imm = deposit32(deposit32(extract32(insn, 0, 3), 3, 29, extract32(insn, 10, 2)), 5, 27, extract32(insn, 13, 1));
}

static void decode_insn_extract_ldst_s(DisasContext *ctx, arg_rd_imm *a, uint16_t insn)
{
    a->rd = extract32(insn, 4, 5);
    a->imm = next_word(ctx);
}

static void decode_insn_extract_op_bit(DisasContext *ctx, arg_decode_insn4 *a, uint16_t insn)
{
    a->bit = extract32(insn, 4, 3);
}

static void decode_insn_extract_op_bit_imm(DisasContext *ctx, arg_decode_insn5 *a, uint16_t insn)
{
    a->bit = extract32(insn, 0, 3);
    a->imm = sextract32(insn, 3, 7);
}

static void decode_insn_extract_op_rd_imm6(DisasContext *ctx, arg_rd_imm *a, uint16_t insn)
{
    a->rd = to_regs_24_30_by_two(ctx, extract32(insn, 4, 2));
    a->imm = deposit32(extract32(insn, 0, 4), 4, 28, extract32(insn, 6, 2));
}

static void decode_insn_extract_op_rd_imm8(DisasContext *ctx, arg_rd_imm *a, uint16_t insn)
{
    a->rd = to_regs_16_31_by_one(ctx, extract32(insn, 4, 4));
    a->imm = deposit32(extract32(insn, 0, 4), 4, 28, extract32(insn, 8, 4));
}

static void decode_insn_extract_op_rd_rr(DisasContext *ctx, arg_rd_rr *a, uint16_t insn)
{
    a->rd = extract32(insn, 4, 5);
    a->rr = deposit32(extract32(insn, 0, 4), 4, 28, extract32(insn, 9, 1));
}

bool decode_insn(DisasContext *ctx, uint16_t insn)
{
    union {
        arg_decode_insn10 f_decode_insn10;
        arg_decode_insn2 f_decode_insn2;
        arg_decode_insn3 f_decode_insn3;
        arg_decode_insn4 f_decode_insn4;
        arg_decode_insn5 f_decode_insn5;
        arg_decode_insn6 f_decode_insn6;
        arg_decode_insn7 f_decode_insn7;
        arg_decode_insn8 f_decode_insn8;
        arg_decode_insn9 f_decode_insn9;
        arg_rd_imm f_rd_imm;
        arg_rd_rr f_rd_rr;
    } u;

    switch (insn & 0xd000) {
    case 0x0000:
        /* 00.0.... ........ */
        switch (insn & 0x2c00) {
        case 0x0000:
            /* 000000.. ........ */
            switch ((insn >> 8) & 0x3) {
            case 0x0:
                /* 00000000 ........ */
                decode_insn_extract_decode_insn_Fmt_10(ctx, &u.f_decode_insn6, insn);
                switch (insn & 0x00ff) {
                case 0x0000:
                    /* 00000000 00000000 */
                    /* ../qemu-10.2.0/target/avr/insn.decode:182 */
                    if (trans_NOP(ctx, &u.f_decode_insn6)) return true;
                    break;
                }
                break;
            case 0x1:
                /* 00000001 ........ */
                /* ../qemu-10.2.0/target/avr/insn.decode:125 */
                decode_insn_extract_decode_insn_Fmt_17(ctx, &u.f_rd_rr, insn);
                if (trans_MOVW(ctx, &u.f_rd_rr)) return true;
                break;
            case 0x2:
                /* 00000010 ........ */
                /* ../qemu-10.2.0/target/avr/insn.decode:71 */
                decode_insn_extract_decode_insn_Fmt_5(ctx, &u.f_rd_rr, insn);
                if (trans_MULS(ctx, &u.f_rd_rr)) return true;
                break;
            case 0x3:
                /* 00000011 ........ */
                decode_insn_extract_fmul(ctx, &u.f_rd_rr, insn);
                switch (insn & 0x0088) {
                case 0x0000:
                    /* 00000011 0...0... */
                    /* ../qemu-10.2.0/target/avr/insn.decode:72 */
                    if (trans_MULSU(ctx, &u.f_rd_rr)) return true;
                    break;
                case 0x0008:
                    /* 00000011 0...1... */
                    /* ../qemu-10.2.0/target/avr/insn.decode:73 */
                    if (trans_FMUL(ctx, &u.f_rd_rr)) return true;
                    break;
                case 0x0080:
                    /* 00000011 1...0... */
                    /* ../qemu-10.2.0/target/avr/insn.decode:74 */
                    if (trans_FMULS(ctx, &u.f_rd_rr)) return true;
                    break;
                case 0x0088:
                    /* 00000011 1...1... */
                    /* ../qemu-10.2.0/target/avr/insn.decode:75 */
                    if (trans_FMULSU(ctx, &u.f_rd_rr)) return true;
                    break;
                }
                break;
            }
            break;
        case 0x0400:
            /* 000001.. ........ */
            /* ../qemu-10.2.0/target/avr/insn.decode:102 */
            decode_insn_extract_op_rd_rr(ctx, &u.f_rd_rr, insn);
            if (trans_CPC(ctx, &u.f_rd_rr)) return true;
            break;
        case 0x0800:
            /* 000010.. ........ */
            /* ../qemu-10.2.0/target/avr/insn.decode:58 */
            decode_insn_extract_op_rd_rr(ctx, &u.f_rd_rr, insn);
            if (trans_SBC(ctx, &u.f_rd_rr)) return true;
            break;
        case 0x0c00:
            /* 000011.. ........ */
            /* ../qemu-10.2.0/target/avr/insn.decode:53 */
            decode_insn_extract_op_rd_rr(ctx, &u.f_rd_rr, insn);
            if (trans_ADD(ctx, &u.f_rd_rr)) return true;
            break;
        case 0x2000:
            /* 001000.. ........ */
            /* ../qemu-10.2.0/target/avr/insn.decode:61 */
            decode_insn_extract_op_rd_rr(ctx, &u.f_rd_rr, insn);
            if (trans_AND(ctx, &u.f_rd_rr)) return true;
            break;
        case 0x2400:
            /* 001001.. ........ */
            /* ../qemu-10.2.0/target/avr/insn.decode:65 */
            decode_insn_extract_op_rd_rr(ctx, &u.f_rd_rr, insn);
            if (trans_EOR(ctx, &u.f_rd_rr)) return true;
            break;
        case 0x2800:
            /* 001010.. ........ */
            /* ../qemu-10.2.0/target/avr/insn.decode:63 */
            decode_insn_extract_op_rd_rr(ctx, &u.f_rd_rr, insn);
            if (trans_OR(ctx, &u.f_rd_rr)) return true;
            break;
        case 0x2c00:
            /* 001011.. ........ */
            /* ../qemu-10.2.0/target/avr/insn.decode:124 */
            decode_insn_extract_op_rd_rr(ctx, &u.f_rd_rr, insn);
            if (trans_MOV(ctx, &u.f_rd_rr)) return true;
            break;
        }
        break;
    case 0x1000:
        /* 00.1.... ........ */
        switch ((insn >> 13) & 0x1) {
        case 0x0:
            /* 0001.... ........ */
            decode_insn_extract_op_rd_rr(ctx, &u.f_rd_rr, insn);
            switch ((insn >> 10) & 0x3) {
            case 0x0:
                /* 000100.. ........ */
                /* ../qemu-10.2.0/target/avr/insn.decode:100 */
                if (trans_CPSE(ctx, &u.f_rd_rr)) return true;
                break;
            case 0x1:
                /* 000101.. ........ */
                /* ../qemu-10.2.0/target/avr/insn.decode:101 */
                if (trans_CP(ctx, &u.f_rd_rr)) return true;
                break;
            case 0x2:
                /* 000110.. ........ */
                /* ../qemu-10.2.0/target/avr/insn.decode:56 */
                if (trans_SUB(ctx, &u.f_rd_rr)) return true;
                break;
            case 0x3:
                /* 000111.. ........ */
                /* ../qemu-10.2.0/target/avr/insn.decode:54 */
                if (trans_ADC(ctx, &u.f_rd_rr)) return true;
                break;
            }
            break;
        case 0x1:
            /* 0011.... ........ */
            /* ../qemu-10.2.0/target/avr/insn.decode:103 */
            decode_insn_extract_op_rd_imm8(ctx, &u.f_rd_imm, insn);
            if (trans_CPI(ctx, &u.f_rd_imm)) return true;
            break;
        }
        break;
    case 0x4000:
        /* 01.0.... ........ */
        decode_insn_extract_op_rd_imm8(ctx, &u.f_rd_imm, insn);
        switch ((insn >> 13) & 0x1) {
        case 0x0:
            /* 0100.... ........ */
            /* ../qemu-10.2.0/target/avr/insn.decode:59 */
            if (trans_SBCI(ctx, &u.f_rd_imm)) return true;
            break;
        case 0x1:
            /* 0110.... ........ */
            /* ../qemu-10.2.0/target/avr/insn.decode:64 */
            if (trans_ORI(ctx, &u.f_rd_imm)) return true;
            break;
        }
        break;
    case 0x5000:
        /* 01.1.... ........ */
        decode_insn_extract_op_rd_imm8(ctx, &u.f_rd_imm, insn);
        switch ((insn >> 13) & 0x1) {
        case 0x0:
            /* 0101.... ........ */
            /* ../qemu-10.2.0/target/avr/insn.decode:57 */
            if (trans_SUBI(ctx, &u.f_rd_imm)) return true;
            break;
        case 0x1:
            /* 0111.... ........ */
            /* ../qemu-10.2.0/target/avr/insn.decode:62 */
            if (trans_ANDI(ctx, &u.f_rd_imm)) return true;
            break;
        }
        break;
    case 0x8000:
        /* 10.0.... ........ */
        decode_insn_extract_ldst_d(ctx, &u.f_rd_imm, insn);
        switch (insn & 0x0208) {
        case 0x0000:
            /* 10.0..0. ....0... */
            /* ../qemu-10.2.0/target/avr/insn.decode:136 */
            if (trans_LDDZ(ctx, &u.f_rd_imm)) return true;
            break;
        case 0x0008:
            /* 10.0..0. ....1... */
            /* ../qemu-10.2.0/target/avr/insn.decode:135 */
            if (trans_LDDY(ctx, &u.f_rd_imm)) return true;
            break;
        case 0x0200:
            /* 10.0..1. ....0... */
            /* ../qemu-10.2.0/target/avr/insn.decode:146 */
            if (trans_STDZ(ctx, &u.f_rd_imm)) return true;
            break;
        case 0x0208:
            /* 10.0..1. ....1... */
            /* ../qemu-10.2.0/target/avr/insn.decode:145 */
            if (trans_STDY(ctx, &u.f_rd_imm)) return true;
            break;
        }
        break;
    case 0x9000:
        /* 10.1.... ........ */
        switch (insn & 0x2800) {
        case 0x0000:
            /* 10010... ........ */
            switch ((insn >> 9) & 0x3) {
            case 0x0:
                /* 1001000. ........ */
                switch (insn & 0x000f) {
                case 0x0000:
                    /* 1001000. ....0000 */
                    /* ../qemu-10.2.0/target/avr/insn.decode:127 */
                    decode_insn_extract_ldst_s(ctx, &u.f_rd_imm, insn);
                    if (trans_LDS(ctx, &u.f_rd_imm)) return true;
                    break;
                case 0x0001:
                    /* 1001000. ....0001 */
                    /* ../qemu-10.2.0/target/avr/insn.decode:133 */
                    decode_insn_extract_decode_insn_Fmt_4(ctx, &u.f_decode_insn2, insn);
                    if (trans_LDZ2(ctx, &u.f_decode_insn2)) return true;
                    break;
                case 0x0002:
                    /* 1001000. ....0010 */
                    /* ../qemu-10.2.0/target/avr/insn.decode:134 */
                    decode_insn_extract_decode_insn_Fmt_4(ctx, &u.f_decode_insn2, insn);
                    if (trans_LDZ3(ctx, &u.f_decode_insn2)) return true;
                    break;
                case 0x0004:
                    /* 1001000. ....0100 */
                    /* ../qemu-10.2.0/target/avr/insn.decode:148 */
                    decode_insn_extract_decode_insn_Fmt_4(ctx, &u.f_decode_insn2, insn);
                    if (trans_LPM2(ctx, &u.f_decode_insn2)) return true;
                    break;
                case 0x0005:
                    /* 1001000. ....0101 */
                    /* ../qemu-10.2.0/target/avr/insn.decode:149 */
                    decode_insn_extract_decode_insn_Fmt_4(ctx, &u.f_decode_insn2, insn);
                    if (trans_LPMX(ctx, &u.f_decode_insn2)) return true;
                    break;
                case 0x0006:
                    /* 1001000. ....0110 */
                    /* ../qemu-10.2.0/target/avr/insn.decode:151 */
                    decode_insn_extract_decode_insn_Fmt_4(ctx, &u.f_decode_insn2, insn);
                    if (trans_ELPM2(ctx, &u.f_decode_insn2)) return true;
                    break;
                case 0x0007:
                    /* 1001000. ....0111 */
                    /* ../qemu-10.2.0/target/avr/insn.decode:152 */
                    decode_insn_extract_decode_insn_Fmt_4(ctx, &u.f_decode_insn2, insn);
                    if (trans_ELPMX(ctx, &u.f_decode_insn2)) return true;
                    break;
                case 0x0009:
                    /* 1001000. ....1001 */
                    /* ../qemu-10.2.0/target/avr/insn.decode:131 */
                    decode_insn_extract_decode_insn_Fmt_4(ctx, &u.f_decode_insn2, insn);
                    if (trans_LDY2(ctx, &u.f_decode_insn2)) return true;
                    break;
                case 0x000a:
                    /* 1001000. ....1010 */
                    /* ../qemu-10.2.0/target/avr/insn.decode:132 */
                    decode_insn_extract_decode_insn_Fmt_4(ctx, &u.f_decode_insn2, insn);
                    if (trans_LDY3(ctx, &u.f_decode_insn2)) return true;
                    break;
                case 0x000c:
                    /* 1001000. ....1100 */
                    /* ../qemu-10.2.0/target/avr/insn.decode:128 */
                    decode_insn_extract_decode_insn_Fmt_4(ctx, &u.f_decode_insn2, insn);
                    if (trans_LDX1(ctx, &u.f_decode_insn2)) return true;
                    break;
                case 0x000d:
                    /* 1001000. ....1101 */
                    /* ../qemu-10.2.0/target/avr/insn.decode:129 */
                    decode_insn_extract_decode_insn_Fmt_4(ctx, &u.f_decode_insn2, insn);
                    if (trans_LDX2(ctx, &u.f_decode_insn2)) return true;
                    break;
                case 0x000e:
                    /* 1001000. ....1110 */
                    /* ../qemu-10.2.0/target/avr/insn.decode:130 */
                    decode_insn_extract_decode_insn_Fmt_4(ctx, &u.f_decode_insn2, insn);
                    if (trans_LDX3(ctx, &u.f_decode_insn2)) return true;
                    break;
                case 0x000f:
                    /* 1001000. ....1111 */
                    /* ../qemu-10.2.0/target/avr/insn.decode:158 */
                    decode_insn_extract_decode_insn_Fmt_4(ctx, &u.f_decode_insn2, insn);
                    if (trans_POP(ctx, &u.f_decode_insn2)) return true;
                    break;
                }
                break;
            case 0x1:
                /* 1001001. ........ */
                switch (insn & 0x000f) {
                case 0x0000:
                    /* 1001001. ....0000 */
                    /* ../qemu-10.2.0/target/avr/insn.decode:137 */
                    decode_insn_extract_ldst_s(ctx, &u.f_rd_imm, insn);
                    if (trans_STS(ctx, &u.f_rd_imm)) return true;
                    break;
                case 0x0001:
                    /* 1001001. ....0001 */
                    /* ../qemu-10.2.0/target/avr/insn.decode:143 */
                    decode_insn_extract_decode_insn_Fmt_4(ctx, &u.f_decode_insn2, insn);
                    if (trans_STZ2(ctx, &u.f_decode_insn2)) return true;
                    break;
                case 0x0002:
                    /* 1001001. ....0010 */
                    /* ../qemu-10.2.0/target/avr/insn.decode:144 */
                    decode_insn_extract_decode_insn_Fmt_4(ctx, &u.f_decode_insn2, insn);
                    if (trans_STZ3(ctx, &u.f_decode_insn2)) return true;
                    break;
                case 0x0004:
                    /* 1001001. ....0100 */
                    /* ../qemu-10.2.0/target/avr/insn.decode:159 */
                    decode_insn_extract_decode_insn_Fmt_4(ctx, &u.f_decode_insn2, insn);
                    if (trans_XCH(ctx, &u.f_decode_insn2)) return true;
                    break;
                case 0x0005:
                    /* 1001001. ....0101 */
                    /* ../qemu-10.2.0/target/avr/insn.decode:161 */
                    decode_insn_extract_decode_insn_Fmt_4(ctx, &u.f_decode_insn2, insn);
                    if (trans_LAS(ctx, &u.f_decode_insn2)) return true;
                    break;
                case 0x0006:
                    /* 1001001. ....0110 */
                    /* ../qemu-10.2.0/target/avr/insn.decode:160 */
                    decode_insn_extract_decode_insn_Fmt_4(ctx, &u.f_decode_insn2, insn);
                    if (trans_LAC(ctx, &u.f_decode_insn2)) return true;
                    break;
                case 0x0007:
                    /* 1001001. ....0111 */
                    /* ../qemu-10.2.0/target/avr/insn.decode:162 */
                    decode_insn_extract_decode_insn_Fmt_4(ctx, &u.f_decode_insn2, insn);
                    if (trans_LAT(ctx, &u.f_decode_insn2)) return true;
                    break;
                case 0x0009:
                    /* 1001001. ....1001 */
                    /* ../qemu-10.2.0/target/avr/insn.decode:141 */
                    decode_insn_extract_decode_insn_Fmt_4(ctx, &u.f_decode_insn2, insn);
                    if (trans_STY2(ctx, &u.f_decode_insn2)) return true;
                    break;
                case 0x000a:
                    /* 1001001. ....1010 */
                    /* ../qemu-10.2.0/target/avr/insn.decode:142 */
                    decode_insn_extract_decode_insn_Fmt_4(ctx, &u.f_decode_insn2, insn);
                    if (trans_STY3(ctx, &u.f_decode_insn2)) return true;
                    break;
                case 0x000c:
                    /* 1001001. ....1100 */
                    /* ../qemu-10.2.0/target/avr/insn.decode:138 */
                    decode_insn_extract_decode_insn_Fmt_18(ctx, &u.f_decode_insn9, insn);
                    if (trans_STX1(ctx, &u.f_decode_insn9)) return true;
                    break;
                case 0x000d:
                    /* 1001001. ....1101 */
                    /* ../qemu-10.2.0/target/avr/insn.decode:139 */
                    decode_insn_extract_decode_insn_Fmt_18(ctx, &u.f_decode_insn9, insn);
                    if (trans_STX2(ctx, &u.f_decode_insn9)) return true;
                    break;
                case 0x000e:
                    /* 1001001. ....1110 */
                    /* ../qemu-10.2.0/target/avr/insn.decode:140 */
                    decode_insn_extract_decode_insn_Fmt_18(ctx, &u.f_decode_insn9, insn);
                    if (trans_STX3(ctx, &u.f_decode_insn9)) return true;
                    break;
                case 0x000f:
                    /* 1001001. ....1111 */
                    /* ../qemu-10.2.0/target/avr/insn.decode:157 */
                    decode_insn_extract_decode_insn_Fmt_4(ctx, &u.f_decode_insn2, insn);
                    if (trans_PUSH(ctx, &u.f_decode_insn2)) return true;
                    break;
                }
                break;
            case 0x2:
                /* 1001010. ........ */
                switch ((insn >> 1) & 0x7) {
                case 0x0:
                    /* 1001010. ....000. */
                    decode_insn_extract_decode_insn_Fmt_4(ctx, &u.f_decode_insn2, insn);
                    switch (insn & 0x0001) {
                    case 0x0000:
                        /* 1001010. ....0000 */
                        /* ../qemu-10.2.0/target/avr/insn.decode:66 */
                        if (trans_COM(ctx, &u.f_decode_insn2)) return true;
                        break;
                    case 0x0001:
                        /* 1001010. ....0001 */
                        /* ../qemu-10.2.0/target/avr/insn.decode:67 */
                        if (trans_NEG(ctx, &u.f_decode_insn2)) return true;
                        break;
                    }
                    break;
                case 0x1:
                    /* 1001010. ....001. */
                    decode_insn_extract_decode_insn_Fmt_4(ctx, &u.f_decode_insn2, insn);
                    switch (insn & 0x0001) {
                    case 0x0000:
                        /* 1001010. ....0010 */
                        /* ../qemu-10.2.0/target/avr/insn.decode:170 */
                        if (trans_SWAP(ctx, &u.f_decode_insn2)) return true;
                        break;
                    case 0x0001:
                        /* 1001010. ....0011 */
                        /* ../qemu-10.2.0/target/avr/insn.decode:68 */
                        if (trans_INC(ctx, &u.f_decode_insn2)) return true;
                        break;
                    }
                    break;
                case 0x2:
                    /* 1001010. ....010. */
                    decode_insn_extract_decode_insn_Fmt_4(ctx, &u.f_decode_insn2, insn);
                    switch (insn & 0x0001) {
                    case 0x0001:
                        /* 1001010. ....0101 */
                        /* ../qemu-10.2.0/target/avr/insn.decode:169 */
                        if (trans_ASR(ctx, &u.f_decode_insn2)) return true;
                        break;
                    }
                    break;
                case 0x3:
                    /* 1001010. ....011. */
                    decode_insn_extract_decode_insn_Fmt_4(ctx, &u.f_decode_insn2, insn);
                    switch (insn & 0x0001) {
                    case 0x0000:
                        /* 1001010. ....0110 */
                        /* ../qemu-10.2.0/target/avr/insn.decode:167 */
                        if (trans_LSR(ctx, &u.f_decode_insn2)) return true;
                        break;
                    case 0x0001:
                        /* 1001010. ....0111 */
                        /* ../qemu-10.2.0/target/avr/insn.decode:168 */
                        if (trans_ROR(ctx, &u.f_decode_insn2)) return true;
                        break;
                    }
                    break;
                case 0x4:
                    /* 1001010. ....100. */
                    switch (insn & 0x0181) {
                    case 0x0000:
                        /* 10010100 0...1000 */
                        /* ../qemu-10.2.0/target/avr/insn.decode:175 */
                        decode_insn_extract_op_bit(ctx, &u.f_decode_insn4, insn);
                        if (trans_BSET(ctx, &u.f_decode_insn4)) return true;
                        break;
                    case 0x0001:
                        /* 10010100 0...1001 */
                        decode_insn_extract_decode_insn_Fmt_10(ctx, &u.f_decode_insn6, insn);
                        switch ((insn >> 4) & 0x7) {
                        case 0x0:
                            /* 10010100 00001001 */
                            /* ../qemu-10.2.0/target/avr/insn.decode:91 */
                            if (trans_IJMP(ctx, &u.f_decode_insn6)) return true;
                            break;
                        case 0x1:
                            /* 10010100 00011001 */
                            /* ../qemu-10.2.0/target/avr/insn.decode:92 */
                            if (trans_EIJMP(ctx, &u.f_decode_insn6)) return true;
                            break;
                        }
                        break;
                    case 0x0080:
                        /* 10010100 1...1000 */
                        /* ../qemu-10.2.0/target/avr/insn.decode:176 */
                        decode_insn_extract_op_bit(ctx, &u.f_decode_insn4, insn);
                        if (trans_BCLR(ctx, &u.f_decode_insn4)) return true;
                        break;
                    case 0x0100:
                        /* 10010101 0...1000 */
                        decode_insn_extract_decode_insn_Fmt_10(ctx, &u.f_decode_insn6, insn);
                        switch ((insn >> 4) & 0x7) {
                        case 0x0:
                            /* 10010101 00001000 */
                            /* ../qemu-10.2.0/target/avr/insn.decode:98 */
                            if (trans_RET(ctx, &u.f_decode_insn6)) return true;
                            break;
                        case 0x1:
                            /* 10010101 00011000 */
                            /* ../qemu-10.2.0/target/avr/insn.decode:99 */
                            if (trans_RETI(ctx, &u.f_decode_insn6)) return true;
                            break;
                        }
                        break;
                    case 0x0101:
                        /* 10010101 0...1001 */
                        decode_insn_extract_decode_insn_Fmt_10(ctx, &u.f_decode_insn6, insn);
                        switch ((insn >> 4) & 0x7) {
                        case 0x0:
                            /* 10010101 00001001 */
                            /* ../qemu-10.2.0/target/avr/insn.decode:95 */
                            if (trans_ICALL(ctx, &u.f_decode_insn6)) return true;
                            break;
                        case 0x1:
                            /* 10010101 00011001 */
                            /* ../qemu-10.2.0/target/avr/insn.decode:96 */
                            if (trans_EICALL(ctx, &u.f_decode_insn6)) return true;
                            break;
                        }
                        break;
                    case 0x0180:
                        /* 10010101 1...1000 */
                        decode_insn_extract_decode_insn_Fmt_10(ctx, &u.f_decode_insn6, insn);
                        switch ((insn >> 4) & 0x7) {
                        case 0x0:
                            /* 10010101 10001000 */
                            /* ../qemu-10.2.0/target/avr/insn.decode:183 */
                            if (trans_SLEEP(ctx, &u.f_decode_insn6)) return true;
                            break;
                        case 0x1:
                            /* 10010101 10011000 */
                            /* ../qemu-10.2.0/target/avr/insn.decode:181 */
                            if (trans_BREAK(ctx, &u.f_decode_insn6)) return true;
                            break;
                        case 0x2:
                            /* 10010101 10101000 */
                            /* ../qemu-10.2.0/target/avr/insn.decode:184 */
                            if (trans_WDR(ctx, &u.f_decode_insn6)) return true;
                            break;
                        case 0x4:
                            /* 10010101 11001000 */
                            /* ../qemu-10.2.0/target/avr/insn.decode:147 */
                            if (trans_LPM1(ctx, &u.f_decode_insn6)) return true;
                            break;
                        case 0x5:
                            /* 10010101 11011000 */
                            /* ../qemu-10.2.0/target/avr/insn.decode:150 */
                            if (trans_ELPM1(ctx, &u.f_decode_insn6)) return true;
                            break;
                        case 0x6:
                            /* 10010101 11101000 */
                            /* ../qemu-10.2.0/target/avr/insn.decode:153 */
                            if (trans_SPM(ctx, &u.f_decode_insn6)) return true;
                            break;
                        case 0x7:
                            /* 10010101 11111000 */
                            /* ../qemu-10.2.0/target/avr/insn.decode:154 */
                            if (trans_SPMX(ctx, &u.f_decode_insn6)) return true;
                            break;
                        }
                        break;
                    }
                    break;
                case 0x5:
                    /* 1001010. ....101. */
                    switch (insn & 0x0001) {
                    case 0x0000:
                        /* 1001010. ....1010 */
                        /* ../qemu-10.2.0/target/avr/insn.decode:69 */
                        decode_insn_extract_decode_insn_Fmt_4(ctx, &u.f_decode_insn2, insn);
                        if (trans_DEC(ctx, &u.f_decode_insn2)) return true;
                        break;
                    case 0x0001:
                        /* 1001010. ....1011 */
                        decode_insn_extract_decode_insn_Fmt_6(ctx, &u.f_decode_insn3, insn);
                        switch ((insn >> 8) & 0x1) {
                        case 0x0:
                            /* 10010100 ....1011 */
                            /* ../qemu-10.2.0/target/avr/insn.decode:76 */
                            if (trans_DES(ctx, &u.f_decode_insn3)) return true;
                            break;
                        }
                        break;
                    }
                    break;
                case 0x6:
                    /* 1001010. ....110. */
                    /* ../qemu-10.2.0/target/avr/insn.decode:93 */
                    decode_insn_extract_decode_insn_Fmt_11(ctx, &u.f_decode_insn3, insn);
                    if (trans_JMP(ctx, &u.f_decode_insn3)) return true;
                    break;
                case 0x7:
                    /* 1001010. ....111. */
                    /* ../qemu-10.2.0/target/avr/insn.decode:97 */
                    decode_insn_extract_decode_insn_Fmt_11(ctx, &u.f_decode_insn3, insn);
                    if (trans_CALL(ctx, &u.f_decode_insn3)) return true;
                    break;
                }
                break;
            case 0x3:
                /* 1001011. ........ */
                decode_insn_extract_op_rd_imm6(ctx, &u.f_rd_imm, insn);
                switch ((insn >> 8) & 0x1) {
                case 0x0:
                    /* 10010110 ........ */
                    /* ../qemu-10.2.0/target/avr/insn.decode:55 */
                    if (trans_ADIW(ctx, &u.f_rd_imm)) return true;
                    break;
                case 0x1:
                    /* 10010111 ........ */
                    /* ../qemu-10.2.0/target/avr/insn.decode:60 */
                    if (trans_SBIW(ctx, &u.f_rd_imm)) return true;
                    break;
                }
                break;
            }
            break;
        case 0x0800:
            /* 10011... ........ */
            switch ((insn >> 10) & 0x1) {
            case 0x0:
                /* 100110.. ........ */
                decode_insn_extract_decode_insn_Fmt_13(ctx, &u.f_decode_insn8, insn);
                switch ((insn >> 8) & 0x3) {
                case 0x0:
                    /* 10011000 ........ */
                    /* ../qemu-10.2.0/target/avr/insn.decode:172 */
                    if (trans_CBI(ctx, &u.f_decode_insn8)) return true;
                    break;
                case 0x1:
                    /* 10011001 ........ */
                    /* ../qemu-10.2.0/target/avr/insn.decode:106 */
                    if (trans_SBIC(ctx, &u.f_decode_insn8)) return true;
                    break;
                case 0x2:
                    /* 10011010 ........ */
                    /* ../qemu-10.2.0/target/avr/insn.decode:171 */
                    if (trans_SBI(ctx, &u.f_decode_insn8)) return true;
                    break;
                case 0x3:
                    /* 10011011 ........ */
                    /* ../qemu-10.2.0/target/avr/insn.decode:107 */
                    if (trans_SBIS(ctx, &u.f_decode_insn8)) return true;
                    break;
                }
                break;
            case 0x1:
                /* 100111.. ........ */
                /* ../qemu-10.2.0/target/avr/insn.decode:70 */
                decode_insn_extract_op_rd_rr(ctx, &u.f_rd_rr, insn);
                if (trans_MUL(ctx, &u.f_rd_rr)) return true;
                break;
            }
            break;
        case 0x2000:
            /* 10110... ........ */
            /* ../qemu-10.2.0/target/avr/insn.decode:155 */
            decode_insn_extract_io_rd_imm(ctx, &u.f_rd_imm, insn);
            if (trans_IN(ctx, &u.f_rd_imm)) return true;
            break;
        case 0x2800:
            /* 10111... ........ */
            /* ../qemu-10.2.0/target/avr/insn.decode:156 */
            decode_insn_extract_io_rd_imm(ctx, &u.f_rd_imm, insn);
            if (trans_OUT(ctx, &u.f_rd_imm)) return true;
            break;
        }
        break;
    case 0xc000:
        /* 11.0.... ........ */
        switch ((insn >> 13) & 0x1) {
        case 0x0:
            /* 1100.... ........ */
            /* ../qemu-10.2.0/target/avr/insn.decode:90 */
            decode_insn_extract_decode_insn_Fmt_9(ctx, &u.f_decode_insn3, insn);
            if (trans_RJMP(ctx, &u.f_decode_insn3)) return true;
            break;
        case 0x1:
            /* 1110.... ........ */
            /* ../qemu-10.2.0/target/avr/insn.decode:126 */
            decode_insn_extract_op_rd_imm8(ctx, &u.f_rd_imm, insn);
            if (trans_LDI(ctx, &u.f_rd_imm)) return true;
            break;
        }
        break;
    case 0xd000:
        /* 11.1.... ........ */
        switch ((insn >> 13) & 0x1) {
        case 0x0:
            /* 1101.... ........ */
            /* ../qemu-10.2.0/target/avr/insn.decode:94 */
            decode_insn_extract_decode_insn_Fmt_9(ctx, &u.f_decode_insn3, insn);
            if (trans_RCALL(ctx, &u.f_decode_insn3)) return true;
            break;
        case 0x1:
            /* 1111.... ........ */
            switch ((insn >> 10) & 0x3) {
            case 0x0:
                /* 111100.. ........ */
                /* ../qemu-10.2.0/target/avr/insn.decode:108 */
                decode_insn_extract_op_bit_imm(ctx, &u.f_decode_insn5, insn);
                if (trans_BRBS(ctx, &u.f_decode_insn5)) return true;
                break;
            case 0x1:
                /* 111101.. ........ */
                /* ../qemu-10.2.0/target/avr/insn.decode:109 */
                decode_insn_extract_op_bit_imm(ctx, &u.f_decode_insn5, insn);
                if (trans_BRBC(ctx, &u.f_decode_insn5)) return true;
                break;
            case 0x2:
                /* 111110.. ........ */
                decode_insn_extract_decode_insn_Fmt_19(ctx, &u.f_decode_insn10, insn);
                switch (insn & 0x0208) {
                case 0x0000:
                    /* 1111100. ....0... */
                    /* ../qemu-10.2.0/target/avr/insn.decode:174 */
                    if (trans_BLD(ctx, &u.f_decode_insn10)) return true;
                    break;
                case 0x0200:
                    /* 1111101. ....0... */
                    /* ../qemu-10.2.0/target/avr/insn.decode:173 */
                    if (trans_BST(ctx, &u.f_decode_insn10)) return true;
                    break;
                }
                break;
            case 0x3:
                /* 111111.. ........ */
                decode_insn_extract_decode_insn_Fmt_12(ctx, &u.f_decode_insn7, insn);
                switch (insn & 0x0208) {
                case 0x0000:
                    /* 1111110. ....0... */
                    /* ../qemu-10.2.0/target/avr/insn.decode:104 */
                    if (trans_SBRC(ctx, &u.f_decode_insn7)) return true;
                    break;
                case 0x0200:
                    /* 1111111. ....0... */
                    /* ../qemu-10.2.0/target/avr/insn.decode:105 */
                    if (trans_SBRS(ctx, &u.f_decode_insn7)) return true;
                    break;
                }
                break;
            }
            break;
        }
        break;
    }
    return false;
}
