/*
 * This file was generated automatically by ExtUtils::ParseXS version 3.57 from the
 * contents of SchedulerHeap.xxs. Do not edit this file, edit SchedulerHeap.xxs instead.
 *
 *    ANY CHANGES MADE HERE WILL BE LOST!
 *
 */

#line 1 "/build/polymake/src/polymake-4.15/lib/core/src/perl/SchedulerHeap.xxs"
/* Copyright (c) 1997-2024
   Ewgenij Gawrilow, Michael Joswig, and the polymake team
   Technische Universität Berlin, Germany
   https://polymake.org

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 2, or (at your option) any
   later version: http://www.gnu.org/licenses/gpl.txt.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
--------------------------------------------------------------------------------
*/

#include "polymake/perl/glue.h"
#include "polymake/perl/macros.h"
#include "polymake/perl/wrappers.h"

#include "polymake/FacetList.h"
#include "polymake/Heap.h"
#include "polymake/Set.h"

namespace pm { namespace perl {

class SchedulerHeap : public fl_internal::Table
{
public:
   using super = fl_internal::Table;

   class ChainAgent : public fl_internal::facet
   {
   public:
      explicit ChainAgent() : heap_index(-1) {}

      void zero_weight(int max_weight)
      {
         std::fill(weight+0, weight+max_weight+1, 0);
      }
      void copy_weight(const ChainAgent* ancestor, int max_weight)
      {
         std::copy(ancestor->weight+0, ancestor->weight+max_weight+1, weight+0);
      }

      const fl_internal::Facet& as_vertex_set() const
      {
         return reinterpret_cast<const fl_internal::Facet&>(static_cast<const fl_internal::facet&>(*this));
      }

      Int heap_index;
      int weight[1];
   };

   class weight_comparator
   {
   public:
      explicit weight_comparator(int max_weight_arg)
         : max_weight(max_weight_arg) {}

      int operator() (const ChainAgent& c1, const ChainAgent& c2) const
      {
         int diff = 0;
         for (int i = 0; i <= max_weight; ++i) {
            diff = c1.weight[i] - c2.weight[i];
            if (diff != 0) break;
         }
         return diff;
      }

      int get_max_weight() const { return max_weight; }

   private:
      const int max_weight;
   };

   class HeapPolicy {
   public:
      using value_type = SV*;

      explicit HeapPolicy(int max_weight_arg)
         : wt_cmp(max_weight_arg) {}

      static const ChainAgent& key(value_type sv)
      {
         return *extract_agent(sv);
      }

      const weight_comparator& key_comparator() const { return wt_cmp; }

      static Int position(value_type sv)
      {
         return extract_agent(sv)->heap_index;
      }

      static void update_position(value_type sv, Int old_pos, Int new_pos)
      {
         ChainAgent* agent = extract_agent(sv);
         assert(agent->heap_index == old_pos);
         agent->heap_index = new_pos;
      }

   private:
      const weight_comparator wt_cmp;
   };

   using heap_t = Heap<HeapPolicy>;

   SchedulerHeap(pTHX_ int max_weight, int n_props)
      : super(sizeof(ChainAgent) + sizeof(int) * max_weight, n_props)
      , heap(64, max_weight)
      , tell_dropped(nullptr)
      , chain_in_progress(nullptr)
      , ancestor_agent(nullptr)
      , tentative_agent(nullptr)
      , popcount(0)
      , maxsize(0)
   {}

   ~SchedulerHeap() { kill_chains(); }

   void clear();

   SV* pop() { ++popcount; return heap.pop(); }
   bool push(SV* chain);

   const heap_t::queue_t& get_queue() const { return heap.get_queue(); }

   int get_max_weight() const { return heap.key_comparator().get_max_weight(); }
   size_t get_popcount() const { return popcount; }
   size_t get_maxsize() const { return maxsize; }
   size_t get_totalsize() const { return size_; }

   void new_tentative_agent(SV* chain);

   ChainAgent* get_tentative_agent() { return tentative_agent; }

   void clear_vertex_filter() { vertex_filter.clear(); }

   void set_tell_dropped(SV* sub) { tell_dropped = sub; }

   static int RuleChain_agent_index;
   static SV* class_descr;

   static ChainAgent* extract_agent(SV* sv)
   {
      sv=PmArray(sv)[RuleChain_agent_index];
      assert(SvIOK_UV(sv));
      return INT2PTR(ChainAgent*, SvUVX(sv));
   }

   static ChainAgent* extract_agent_wary(SV* sv, bool deref=true)
   {
      if (deref) sv=SvRV(sv);
      sv=AvARRAY(sv)[RuleChain_agent_index];
      if (SvIOK_UV(sv))
         return INT2PTR(ChainAgent*, SvUVX(sv));
      else
         return nullptr;
   }

   void add_to_vertex_filter(AV* set_list);

   bool is_promising(AV* set_list);

#if POLYMAKE_DEBUG
   void sanity_check() const;
#endif
private:
   void kill_chains();

   heap_t heap;
   Set<Int> vertex_filter;
   Set<Int> tentative_vertex_set;

   SV* tell_dropped;
   SV* chain_in_progress;
   ChainAgent* ancestor_agent;
   ChainAgent* tentative_agent;
   size_t popcount, maxsize;
};

void SchedulerHeap::new_tentative_agent(SV* chain)
{
   if (!tentative_agent)
      tentative_agent=new(facet_alloc.allocate()) ChainAgent();

   if ((ancestor_agent=extract_agent_wary(chain)) != nullptr) {
      tentative_agent->copy_weight(ancestor_agent, get_max_weight());
      tentative_vertex_set=ancestor_agent->as_vertex_set();
   } else {
      // first descendant of the initial chain
      tentative_agent->zero_weight(get_max_weight());
      tentative_vertex_set.clear();
   }

   chain_in_progress=SvRV(chain);
}

bool SchedulerHeap::push(SV* chain)
{
   dTHX;
   if (SvRV(chain) != chain_in_progress) return false;
   SV* agent_sv=PmArray(chain)[RuleChain_agent_index];
   sv_setuv(agent_sv, PTR2UV(tentative_agent));
   SvIsUV_on(agent_sv);

   for (auto subs_it = findSubsets(tentative_vertex_set, std::false_type());  !subs_it.at_end();  ++subs_it) {
      const ChainAgent* smaller_chain_agent = static_cast<const ChainAgent*>(subs_it.operator->());
      if (smaller_chain_agent != ancestor_agent &&
          heap.key_comparator()(*smaller_chain_agent, *tentative_agent) >= 0) {
         // found an inferior chain with the same or less new properties and equal or higher weight
         if (smaller_chain_agent->heap_index >= 0) {
            SV* smaller_chain=heap.erase_at(smaller_chain_agent->heap_index);
            if (tell_dropped) {
               PmStartFuncall(1);
               PUSHs(smaller_chain);
               PUTBACK;
               glue::call_func_void(aTHX_ tell_dropped);
            }
            SvREFCNT_dec(smaller_chain);
         }
         erase_facet(*smaller_chain_agent);
      }
   }

   push_back_new_facet(tentative_agent);
   insert_cells(tentative_agent, entire(tentative_vertex_set));

   heap.push(SvREFCNT_inc_simple_NN(chain));
   assign_max(maxsize, heap.get_queue().size());

   chain_in_progress=nullptr;
   ancestor_agent=nullptr;
   tentative_agent=nullptr;
   tentative_vertex_set.clear();

   return true;
}

void SchedulerHeap::kill_chains()
{
   dTHX;
   for (auto q_it=entire(heap.get_queue());  !q_it.at_end();  ++q_it)
      SvREFCNT_dec(*q_it);
}

void SchedulerHeap::clear()
{
   kill_chains();
   super::clear_facets();
   heap.clear();
   chain_in_progress=nullptr;
   ancestor_agent=nullptr;
   tentative_agent=nullptr;
   popcount=0;
   maxsize=0;
}

void SchedulerHeap::add_to_vertex_filter(AV* set_list)
{
   for (SV **setref_p = AvARRAY(set_list), ** const setref_last = setref_p + AvFILLp(set_list);  setref_p <= setref_last;  ++setref_p) {
      AV* vertex_list = (AV*)SvRV(*setref_p);
      for (SV **vertex_p = AvARRAY(vertex_list), ** const vertex_last = vertex_p + AvFILLp(vertex_list);  vertex_p<=vertex_last;  ++vertex_p) {
         vertex_filter += static_cast<Int>(SvIVX(*vertex_p));
      }
   }
}

bool SchedulerHeap::is_promising(AV* set_list)
{
   const Int ancestor_vertices = tentative_vertex_set.size();

   for (SV **setref_p = AvARRAY(set_list), ** const setref_last = setref_p + AvFILLp(set_list);  setref_p <= setref_last;  ++setref_p) {
      AV* vertex_list = (AV*)SvRV(*setref_p);
      for (SV **vertex_p = AvARRAY(vertex_list), ** const vertex_last = vertex_p + AvFILLp(vertex_list);  vertex_p <= vertex_last;  ++vertex_p) {
         const Int v = SvIVX(*vertex_p);
         if (!vertex_filter.contains(v))
            tentative_vertex_set += v;
      }
   }
   if (tentative_vertex_set.size() == ancestor_vertices)
      // no new properties added - no progress
      return false;

   for (fl_internal::superset_iterator ss_it=findSupersets(tentative_vertex_set, false);
        !ss_it.at_end();  ++ss_it) {
      if (heap.key_comparator()(static_cast<const ChainAgent&>(*ss_it), *tentative_agent) <= 0)
         // found another chain with at least the same new properties and weight not exceeding that of the new chain
         return false;
   }

   return true;
}

#if POLYMAKE_DEBUG
void SchedulerHeap::sanity_check() const
{
   dTHX;
   int pos=0;
   for (auto q_it = entire(heap.get_queue());  !q_it.at_end();  ++q_it, ++pos) {
      const ChainAgent* agent = extract_agent_wary(*q_it);
      if (!agent || agent->heap_index != pos) {
         Perl_croak(aTHX_ "corruption in element %d", pos);
      }
   }
   if (!heap.sanity_check()) {
      Perl_croak(aTHX_ "corruption in heap");
   }
}
#endif

int SchedulerHeap::RuleChain_agent_index = 0;
SV* SchedulerHeap::class_descr = nullptr;

} }

using namespace pm::perl;
using namespace pm::perl::glue;

#define RetrieveHeapArg(...) \
   MAGIC* mg=get_cpp_magic(SvRV(self)); \
   __VA_ARGS__ SchedulerHeap* heap=reinterpret_cast<__VA_ARGS__ SchedulerHeap*>(mg->mg_ptr)

#line 336 "/build/polymake/src/polymake-4.15/build/perlx/5.42.0/x86_64-linux-thread-multi/SchedulerHeap.cc"
#ifndef PERL_UNUSED_VAR
#  define PERL_UNUSED_VAR(var) if (0) var = var
#endif

#ifndef dVAR
#  define dVAR		dNOOP
#endif


/* This stuff is not part of the API! You have been warned. */
#ifndef PERL_VERSION_DECIMAL
#  define PERL_VERSION_DECIMAL(r,v,s) (r*1000000 + v*1000 + s)
#endif
#ifndef PERL_DECIMAL_VERSION
#  define PERL_DECIMAL_VERSION \
	  PERL_VERSION_DECIMAL(PERL_REVISION,PERL_VERSION,PERL_SUBVERSION)
#endif
#ifndef PERL_VERSION_GE
#  define PERL_VERSION_GE(r,v,s) \
	  (PERL_DECIMAL_VERSION >= PERL_VERSION_DECIMAL(r,v,s))
#endif
#ifndef PERL_VERSION_LE
#  define PERL_VERSION_LE(r,v,s) \
	  (PERL_DECIMAL_VERSION <= PERL_VERSION_DECIMAL(r,v,s))
#endif

/* XS_INTERNAL is the explicit static-linkage variant of the default
 * XS macro.
 *
 * XS_EXTERNAL is the same as XS_INTERNAL except it does not include
 * "STATIC", ie. it exports XSUB symbols. You probably don't want that
 * for anything but the BOOT XSUB.
 *
 * See XSUB.h in core!
 */


/* TODO: This might be compatible further back than 5.10.0. */
#if PERL_VERSION_GE(5, 10, 0) && PERL_VERSION_LE(5, 15, 1)
#  undef XS_EXTERNAL
#  undef XS_INTERNAL
#  if defined(__CYGWIN__) && defined(USE_DYNAMIC_LOADING)
#    define XS_EXTERNAL(name) __declspec(dllexport) XSPROTO(name)
#    define XS_INTERNAL(name) STATIC XSPROTO(name)
#  endif
#  if defined(__SYMBIAN32__)
#    define XS_EXTERNAL(name) EXPORT_C XSPROTO(name)
#    define XS_INTERNAL(name) EXPORT_C STATIC XSPROTO(name)
#  endif
#  ifndef XS_EXTERNAL
#    if defined(HASATTRIBUTE_UNUSED) && !defined(__cplusplus)
#      define XS_EXTERNAL(name) void name(pTHX_ CV* cv __attribute__unused__)
#      define XS_INTERNAL(name) STATIC void name(pTHX_ CV* cv __attribute__unused__)
#    else
#      ifdef __cplusplus
#        define XS_EXTERNAL(name) extern "C" XSPROTO(name)
#        define XS_INTERNAL(name) static XSPROTO(name)
#      else
#        define XS_EXTERNAL(name) XSPROTO(name)
#        define XS_INTERNAL(name) STATIC XSPROTO(name)
#      endif
#    endif
#  endif
#endif

/* perl >= 5.10.0 && perl <= 5.15.1 */


/* The XS_EXTERNAL macro is used for functions that must not be static
 * like the boot XSUB of a module. If perl didn't have an XS_EXTERNAL
 * macro defined, the best we can do is assume XS is the same.
 * Dito for XS_INTERNAL.
 */
#ifndef XS_EXTERNAL
#  define XS_EXTERNAL(name) XS(name)
#endif
#ifndef XS_INTERNAL
#  define XS_INTERNAL(name) XS(name)
#endif

/* Now, finally, after all this mess, we want an ExtUtils::ParseXS
 * internal macro that we're free to redefine for varying linkage due
 * to the EXPORT_XSUB_SYMBOLS XS keyword. This is internal, use
 * XS_EXTERNAL(name) or XS_INTERNAL(name) in your code if you need to!
 */

#undef XS_EUPXS
#if defined(PERL_EUPXS_ALWAYS_EXPORT)
#  define XS_EUPXS(name) XS_EXTERNAL(name)
#else
   /* default to internal */
#  define XS_EUPXS(name) XS_INTERNAL(name)
#endif

#ifndef PERL_ARGS_ASSERT_CROAK_XS_USAGE
#define PERL_ARGS_ASSERT_CROAK_XS_USAGE assert(cv); assert(params)

/* prototype to pass -Wmissing-prototypes */
STATIC void
S_croak_xs_usage(const CV *const cv, const char *const params);

STATIC void
S_croak_xs_usage(const CV *const cv, const char *const params)
{
    const GV *const gv = CvGV(cv);

    PERL_ARGS_ASSERT_CROAK_XS_USAGE;

    if (gv) {
        const char *const gvname = GvNAME(gv);
        const HV *const stash = GvSTASH(gv);
        const char *const hvname = stash ? HvNAME(stash) : NULL;

        if (hvname)
	    Perl_croak_nocontext("Usage: %s::%s(%s)", hvname, gvname, params);
        else
	    Perl_croak_nocontext("Usage: %s(%s)", gvname, params);
    } else {
        /* Pants. I don't think that it should be possible to get here. */
	Perl_croak_nocontext("Usage: CODE(0x%" UVxf ")(%s)", PTR2UV(cv), params);
    }
}
#undef  PERL_ARGS_ASSERT_CROAK_XS_USAGE

#define croak_xs_usage        S_croak_xs_usage

#endif

/* NOTE: the prototype of newXSproto() is different in versions of perls,
 * so we define a portable version of newXSproto()
 */
#ifdef newXS_flags
#define newXSproto_portable(name, c_impl, file, proto) newXS_flags(name, c_impl, file, proto, 0)
#else
#define newXSproto_portable(name, c_impl, file, proto) (PL_Sv=(SV*)newXS(name, c_impl, file), sv_setpv(PL_Sv, proto), (CV*)PL_Sv)
#endif /* !defined(newXS_flags) */

#if PERL_VERSION_LE(5, 21, 5)
#  define newXS_deffile(a,b) Perl_newXS(aTHX_ a,b,file)
#else
#  define newXS_deffile(a,b) Perl_newXS_deffile(aTHX_ a,b)
#endif

/* simple backcompat versions of the TARGx() macros with no optimisation */
#ifndef TARGi
#  define TARGi(iv, do_taint) sv_setiv_mg(TARG, iv)
#  define TARGu(uv, do_taint) sv_setuv_mg(TARG, uv)
#  define TARGn(nv, do_taint) sv_setnv_mg(TARG, nv)
#endif

#line 487 "/build/polymake/src/polymake-4.15/build/perlx/5.42.0/x86_64-linux-thread-multi/SchedulerHeap.cc"

XS_EUPXS(XS_Polymake__Core__Scheduler__Heap_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Polymake__Core__Scheduler__Heap_new)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "pkg, max_weight, n_props");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV *	pkg = ST(0)
;
	I32	max_weight = (I32)SvIV(ST(1))
;
	I32	n_props = (I32)SvIV(ST(2))
;
#line 332 "/build/polymake/src/polymake-4.15/lib/core/src/perl/SchedulerHeap.xxs"
{
   if (!SchedulerHeap::class_descr) {
      // this initialization can't be done in the BOOT block because CPlusPlus is not yet initialized that early
      SchedulerHeap::class_descr = OpaqueClassRegistrator<SchedulerHeap>::register_it("Polymake::Core::Scheduler::Heap", nullptr, nullptr);
      SchedulerHeap::RuleChain_agent_index = CvDEPTH(get_cv("Polymake::Core::Scheduler::TentativeRuleChain::heap_agent", false));
   }
   SV* ref = newSV_type(SVt_NULL);
   MAGIC* mg = glue::allocate_canned_magic(aTHX_ ref, SchedulerHeap::class_descr, ValueFlags::alloc_magic, 0);
   new(mg->mg_ptr) SchedulerHeap(aTHX_ max_weight, n_props);
   PUSHs(sv_2mortal(ref));
   PERL_UNUSED_ARG(pkg);
}
#line 517 "/build/polymake/src/polymake-4.15/build/perlx/5.42.0/x86_64-linux-thread-multi/SchedulerHeap.cc"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Polymake__Core__Scheduler__Heap_size); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Polymake__Core__Scheduler__Heap_size)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV *	self = ST(0)
;
#line 347 "/build/polymake/src/polymake-4.15/lib/core/src/perl/SchedulerHeap.xxs"
{
   dTARGET;
   RetrieveHeapArg(const);
   PUSHi(heap->get_queue().size());
}
#line 541 "/build/polymake/src/polymake-4.15/build/perlx/5.42.0/x86_64-linux-thread-multi/SchedulerHeap.cc"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Polymake__Core__Scheduler__Heap_maxsize); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Polymake__Core__Scheduler__Heap_maxsize)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV *	self = ST(0)
;
#line 355 "/build/polymake/src/polymake-4.15/lib/core/src/perl/SchedulerHeap.xxs"
{
   dTARGET;
   RetrieveHeapArg(const);
   PUSHi(heap->get_maxsize());
}
#line 565 "/build/polymake/src/polymake-4.15/build/perlx/5.42.0/x86_64-linux-thread-multi/SchedulerHeap.cc"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Polymake__Core__Scheduler__Heap_totalsize); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Polymake__Core__Scheduler__Heap_totalsize)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV *	self = ST(0)
;
#line 363 "/build/polymake/src/polymake-4.15/lib/core/src/perl/SchedulerHeap.xxs"
{
   dTARGET;
   RetrieveHeapArg(const);
   PUSHi(heap->get_totalsize());
}
#line 589 "/build/polymake/src/polymake-4.15/build/perlx/5.42.0/x86_64-linux-thread-multi/SchedulerHeap.cc"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Polymake__Core__Scheduler__Heap_popcount); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Polymake__Core__Scheduler__Heap_popcount)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV *	self = ST(0)
;
#line 371 "/build/polymake/src/polymake-4.15/lib/core/src/perl/SchedulerHeap.xxs"
{
   dTARGET;
   RetrieveHeapArg(const);
   PUSHi(heap->get_popcount());
}
#line 613 "/build/polymake/src/polymake-4.15/build/perlx/5.42.0/x86_64-linux-thread-multi/SchedulerHeap.cc"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Polymake__Core__Scheduler__Heap_reset); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Polymake__Core__Scheduler__Heap_reset)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV *	self = ST(0)
;
#line 379 "/build/polymake/src/polymake-4.15/lib/core/src/perl/SchedulerHeap.xxs"
{
   RetrieveHeapArg();
   heap->clear();
}
#line 636 "/build/polymake/src/polymake-4.15/build/perlx/5.42.0/x86_64-linux-thread-multi/SchedulerHeap.cc"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Polymake__Core__Scheduler__Heap_pop); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Polymake__Core__Scheduler__Heap_pop)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV *	self = ST(0)
;
#line 386 "/build/polymake/src/polymake-4.15/lib/core/src/perl/SchedulerHeap.xxs"
{
   RetrieveHeapArg();
   if (!heap->get_queue().empty()) {
      SV* chain_ref = heap->pop();
      PUSHs(sv_2mortal(chain_ref));
   } else {
      PUSHs(&PL_sv_undef);
   }
}
#line 664 "/build/polymake/src/polymake-4.15/build/perlx/5.42.0/x86_64-linux-thread-multi/SchedulerHeap.cc"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Polymake__Core__Scheduler__Heap_new_tentative_chain); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Polymake__Core__Scheduler__Heap_new_tentative_chain)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, chain");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV *	self = ST(0)
;
	SV *	chain = ST(1)
;
#line 398 "/build/polymake/src/polymake-4.15/lib/core/src/perl/SchedulerHeap.xxs"
{
   RetrieveHeapArg();
   heap->new_tentative_agent(chain);
}
#line 689 "/build/polymake/src/polymake-4.15/build/perlx/5.42.0/x86_64-linux-thread-multi/SchedulerHeap.cc"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Polymake__Core__Scheduler__Heap_add_weight); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Polymake__Core__Scheduler__Heap_add_weight)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, wt_ref");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV *	self = ST(0)
;
	SV *	wt_ref = ST(1)
;
#line 405 "/build/polymake/src/polymake-4.15/lib/core/src/perl/SchedulerHeap.xxs"
{
   RetrieveHeapArg();
   SchedulerHeap::ChainAgent* agent = heap->get_tentative_agent();
   const int major = int(SvIVX(PmArray(wt_ref)[0]));
   const int minor = int(SvIVX(PmArray(wt_ref)[1]));
   agent->weight[heap->get_max_weight() - major] += minor;
}
#line 717 "/build/polymake/src/polymake-4.15/build/perlx/5.42.0/x86_64-linux-thread-multi/SchedulerHeap.cc"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Polymake__Core__Scheduler__Heap_push); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Polymake__Core__Scheduler__Heap_push)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, chain");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV *	self = ST(0)
;
	SV *	chain = ST(1)
;
#line 415 "/build/polymake/src/polymake-4.15/lib/core/src/perl/SchedulerHeap.xxs"
{
   RetrieveHeapArg();
   if (!heap->push(chain))
      Perl_croak(aTHX_ "Scheduler::Heap - wrong usage: push() without preceding new_tentative_chain()");
}
#line 743 "/build/polymake/src/polymake-4.15/build/perlx/5.42.0/x86_64-linux-thread-multi/SchedulerHeap.cc"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Polymake__Core__Scheduler__Heap_clear_vertex_filter); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Polymake__Core__Scheduler__Heap_clear_vertex_filter)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV *	self = ST(0)
;
#line 423 "/build/polymake/src/polymake-4.15/lib/core/src/perl/SchedulerHeap.xxs"
{
   RetrieveHeapArg();
   heap->clear_vertex_filter();
}
#line 766 "/build/polymake/src/polymake-4.15/build/perlx/5.42.0/x86_64-linux-thread-multi/SchedulerHeap.cc"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Polymake__Core__Scheduler__Heap_add_to_vertex_filter); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Polymake__Core__Scheduler__Heap_add_to_vertex_filter)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, set_list_ref");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV*	self = ST(0)
;
	SV*	set_list_ref = ST(1)
;
#line 431 "/build/polymake/src/polymake-4.15/lib/core/src/perl/SchedulerHeap.xxs"
{
   AV* set_list;
   if (!SvROK(set_list_ref) ||
       (set_list = (AV*)SvRV(set_list_ref), SvTYPE(set_list) != SVt_PVAV) ||
       (AvFILLp(set_list) < 0))
      croak_xs_usage(cv, "[ non-empty list ]");

   RetrieveHeapArg();
   heap->add_to_vertex_filter(set_list);
}
#line 797 "/build/polymake/src/polymake-4.15/build/perlx/5.42.0/x86_64-linux-thread-multi/SchedulerHeap.cc"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Polymake__Core__Scheduler__Heap_is_promising); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Polymake__Core__Scheduler__Heap_is_promising)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, set_list_ref");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV *	self = ST(0)
;
	SV *	set_list_ref = ST(1)
;
#line 444 "/build/polymake/src/polymake-4.15/lib/core/src/perl/SchedulerHeap.xxs"
{
   AV* set_list;
   if (!SvROK(set_list_ref) ||
       (set_list = (AV*)SvRV(set_list_ref), SvTYPE(set_list) != SVt_PVAV) ||
       (AvFILLp(set_list) < 0))
      croak_xs_usage(cv, "[ non-empty list ]");

   RetrieveHeapArg();
   if (heap->is_promising(set_list))
      PUSHs(&PL_sv_yes);
   else
      PUSHs(&PL_sv_no);
}
#line 831 "/build/polymake/src/polymake-4.15/build/perlx/5.42.0/x86_64-linux-thread-multi/SchedulerHeap.cc"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Polymake__Core__Scheduler__Heap_unpack_weight); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Polymake__Core__Scheduler__Heap_unpack_weight)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, chain");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV *	self = ST(0)
;
	SV *	chain = ST(1)
;
#line 460 "/build/polymake/src/polymake-4.15/lib/core/src/perl/SchedulerHeap.xxs"
{
   RetrieveHeapArg(const);
   const SchedulerHeap::ChainAgent* agent = SchedulerHeap::extract_agent_wary(chain);
   if (agent) {
      const int limbs = heap->get_max_weight()+1;
      EXTEND(SP, limbs);
      for (const int* l = agent->weight+0, * const end = l+limbs; l < end; ++l)
         PUSHs(sv_2mortal(newSViv(*l)));
   }
}
#line 862 "/build/polymake/src/polymake-4.15/build/perlx/5.42.0/x86_64-linux-thread-multi/SchedulerHeap.cc"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Polymake__Core__Scheduler__Heap_describe_facet); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Polymake__Core__Scheduler__Heap_describe_facet)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, chain");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV *	self = ST(0)
;
	SV *	chain = ST(1)
;
#line 473 "/build/polymake/src/polymake-4.15/lib/core/src/perl/SchedulerHeap.xxs"
{
   PERL_UNUSED_ARG(self);
   const SchedulerHeap::ChainAgent* agent = SchedulerHeap::extract_agent_wary(chain);
   if (agent) {
      EXTEND(SP, agent->size()+1);
      mPUSHi(agent->get_id());
      for (auto cell_it = agent->begin();  !cell_it.at_end();  ++cell_it)
         mPUSHi(cell_it.index());
   }
}
#line 893 "/build/polymake/src/polymake-4.15/build/perlx/5.42.0/x86_64-linux-thread-multi/SchedulerHeap.cc"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Polymake__Core__Scheduler__Heap_tell_dropped); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Polymake__Core__Scheduler__Heap_tell_dropped)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, subref");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV *	self = ST(0)
;
	SV *	subref = ST(1)
;
#line 486 "/build/polymake/src/polymake-4.15/lib/core/src/perl/SchedulerHeap.xxs"
{
   SV* sub;
   if (!SvROK(subref) || (sub = SvRV(subref), SvTYPE(sub) != SVt_PVCV))
      croak_xs_usage(cv, "\\&sub");
   RetrieveHeapArg();
   heap->set_tell_dropped(sub);
}
#line 921 "/build/polymake/src/polymake-4.15/build/perlx/5.42.0/x86_64-linux-thread-multi/SchedulerHeap.cc"
	PUTBACK;
	return;
    }
}

#ifdef __cplusplus
extern "C" {
#endif
XS_EXTERNAL(boot_Polymake__Core__Scheduler__Heap); /* prototype to pass -Wmissing-prototypes */
XS_EXTERNAL(boot_Polymake__Core__Scheduler__Heap)
{
#if PERL_VERSION_LE(5, 21, 5)
    dVAR; dXSARGS;
#else
    dVAR; dXSBOOTARGSXSAPIVERCHK;
#endif
#if PERL_VERSION_LE(5, 8, 999) /* PERL_VERSION_LT is 5.33+ */
    char* file = __FILE__;
#else
    const char* file = __FILE__;
#endif

    PERL_UNUSED_VAR(file);

    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
#if PERL_VERSION_LE(5, 21, 5)
    XS_VERSION_BOOTCHECK;
#  ifdef XS_APIVERSION_BOOTCHECK
    XS_APIVERSION_BOOTCHECK;
#  endif
#endif

        newXS_deffile("Polymake::Core::Scheduler::Heap::new", XS_Polymake__Core__Scheduler__Heap_new);
        newXS_deffile("Polymake::Core::Scheduler::Heap::size", XS_Polymake__Core__Scheduler__Heap_size);
        newXS_deffile("Polymake::Core::Scheduler::Heap::maxsize", XS_Polymake__Core__Scheduler__Heap_maxsize);
        newXS_deffile("Polymake::Core::Scheduler::Heap::totalsize", XS_Polymake__Core__Scheduler__Heap_totalsize);
        newXS_deffile("Polymake::Core::Scheduler::Heap::popcount", XS_Polymake__Core__Scheduler__Heap_popcount);
        newXS_deffile("Polymake::Core::Scheduler::Heap::reset", XS_Polymake__Core__Scheduler__Heap_reset);
        newXS_deffile("Polymake::Core::Scheduler::Heap::pop", XS_Polymake__Core__Scheduler__Heap_pop);
        newXS_deffile("Polymake::Core::Scheduler::Heap::new_tentative_chain", XS_Polymake__Core__Scheduler__Heap_new_tentative_chain);
        newXS_deffile("Polymake::Core::Scheduler::Heap::add_weight", XS_Polymake__Core__Scheduler__Heap_add_weight);
        newXS_deffile("Polymake::Core::Scheduler::Heap::push", XS_Polymake__Core__Scheduler__Heap_push);
        newXS_deffile("Polymake::Core::Scheduler::Heap::clear_vertex_filter", XS_Polymake__Core__Scheduler__Heap_clear_vertex_filter);
        newXS_deffile("Polymake::Core::Scheduler::Heap::add_to_vertex_filter", XS_Polymake__Core__Scheduler__Heap_add_to_vertex_filter);
        newXS_deffile("Polymake::Core::Scheduler::Heap::is_promising", XS_Polymake__Core__Scheduler__Heap_is_promising);
        newXS_deffile("Polymake::Core::Scheduler::Heap::unpack_weight", XS_Polymake__Core__Scheduler__Heap_unpack_weight);
        newXS_deffile("Polymake::Core::Scheduler::Heap::describe_facet", XS_Polymake__Core__Scheduler__Heap_describe_facet);
        newXS_deffile("Polymake::Core::Scheduler::Heap::tell_dropped", XS_Polymake__Core__Scheduler__Heap_tell_dropped);
#if PERL_VERSION_LE(5, 21, 5)
#  if PERL_VERSION_GE(5, 9, 0)
    if (PL_unitcheckav)
        call_list(PL_scopestack_ix, PL_unitcheckav);
#  endif
    XSRETURN_YES;
#else
    Perl_xs_boot_epilog(aTHX_ ax);
#endif
}

#ifdef __cplusplus
}
#endif
