/* SettingsPopover.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from SettingsPopover.vala, do not modify */

/*
 * SPDX-License-Identifier: LGPL-3.0-or-later
 * SPDX-FileCopyrightText: 2023-2025 elementary, Inc. (https://elementary.io)
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <vte/vte.h>
#include <gio/gio.h>
#include <gdk/gdk.h>
#include <granite.h>
#include <glib/gi18n-lib.h>

#define TERMINAL_SETTINGS_POPOVER_ACTION_GROUP_NAME "settings"
#define TERMINAL_SETTINGS_POPOVER_THEME_CHECK_BUTTON_STYLE_CSS "\n" \
"            .color-button.%s check {\n" \
"                background-color: %s;\n" \
"                color: %s;\n" \
"                padding: 0.8rem; /* FIXME: Remove during GTK4 port */\n" \
"            }\n" \
"        "
#define TERMINAL_THEMES_PALETTE_SIZE 19
#define TERMINAL_THEMES_HIGH_CONTRAST "high-contrast"
#define TERMINAL_THEMES_LIGHT "solarized-light"
#define TERMINAL_THEMES_DARK "dark"
#define TERMINAL_THEMES_CUSTOM "custom"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TERMINAL_TYPE_SETTINGS_POPOVER (terminal_settings_popover_get_type ())
#define TERMINAL_SETTINGS_POPOVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TERMINAL_TYPE_SETTINGS_POPOVER, TerminalSettingsPopover))
#define TERMINAL_SETTINGS_POPOVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TERMINAL_TYPE_SETTINGS_POPOVER, TerminalSettingsPopoverClass))
#define TERMINAL_IS_SETTINGS_POPOVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TERMINAL_TYPE_SETTINGS_POPOVER))
#define TERMINAL_IS_SETTINGS_POPOVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TERMINAL_TYPE_SETTINGS_POPOVER))
#define TERMINAL_SETTINGS_POPOVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TERMINAL_TYPE_SETTINGS_POPOVER, TerminalSettingsPopoverClass))

typedef struct _TerminalSettingsPopover TerminalSettingsPopover;
typedef struct _TerminalSettingsPopoverClass TerminalSettingsPopoverClass;
typedef struct _TerminalSettingsPopoverPrivate TerminalSettingsPopoverPrivate;
enum  {
	TERMINAL_SETTINGS_POPOVER_0_PROPERTY,
	TERMINAL_SETTINGS_POPOVER_TERMINAL_PROPERTY,
	TERMINAL_SETTINGS_POPOVER_NUM_PROPERTIES
};
static GParamSpec* terminal_settings_popover_properties[TERMINAL_SETTINGS_POPOVER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TERMINAL_TYPE_TERMINAL_WIDGET (terminal_terminal_widget_get_type ())
#define TERMINAL_TERMINAL_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TERMINAL_TYPE_TERMINAL_WIDGET, TerminalTerminalWidget))
#define TERMINAL_TERMINAL_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TERMINAL_TYPE_TERMINAL_WIDGET, TerminalTerminalWidgetClass))
#define TERMINAL_IS_TERMINAL_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TERMINAL_TYPE_TERMINAL_WIDGET))
#define TERMINAL_IS_TERMINAL_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TERMINAL_TYPE_TERMINAL_WIDGET))
#define TERMINAL_TERMINAL_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TERMINAL_TYPE_TERMINAL_WIDGET, TerminalTerminalWidgetClass))

typedef struct _TerminalTerminalWidget TerminalTerminalWidget;
typedef struct _TerminalTerminalWidgetClass TerminalTerminalWidgetClass;

#define TERMINAL_SETTINGS_POPOVER_TYPE_THEME_CHECK_BUTTON (terminal_settings_popover_theme_check_button_get_type ())
#define TERMINAL_SETTINGS_POPOVER_THEME_CHECK_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TERMINAL_SETTINGS_POPOVER_TYPE_THEME_CHECK_BUTTON, TerminalSettingsPopoverThemeCheckButton))
#define TERMINAL_SETTINGS_POPOVER_THEME_CHECK_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TERMINAL_SETTINGS_POPOVER_TYPE_THEME_CHECK_BUTTON, TerminalSettingsPopoverThemeCheckButtonClass))
#define TERMINAL_SETTINGS_POPOVER_IS_THEME_CHECK_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TERMINAL_SETTINGS_POPOVER_TYPE_THEME_CHECK_BUTTON))
#define TERMINAL_SETTINGS_POPOVER_IS_THEME_CHECK_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TERMINAL_SETTINGS_POPOVER_TYPE_THEME_CHECK_BUTTON))
#define TERMINAL_SETTINGS_POPOVER_THEME_CHECK_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TERMINAL_SETTINGS_POPOVER_TYPE_THEME_CHECK_BUTTON, TerminalSettingsPopoverThemeCheckButtonClass))

typedef struct _TerminalSettingsPopoverThemeCheckButton TerminalSettingsPopoverThemeCheckButton;
typedef struct _TerminalSettingsPopoverThemeCheckButtonClass TerminalSettingsPopoverThemeCheckButtonClass;
typedef struct _TerminalSettingsPopoverThemeCheckButtonPrivate TerminalSettingsPopoverThemeCheckButtonPrivate;
enum  {
	TERMINAL_SETTINGS_POPOVER_THEME_CHECK_BUTTON_0_PROPERTY,
	TERMINAL_SETTINGS_POPOVER_THEME_CHECK_BUTTON_THEME_PROPERTY,
	TERMINAL_SETTINGS_POPOVER_THEME_CHECK_BUTTON_NUM_PROPERTIES
};
static GParamSpec* terminal_settings_popover_theme_check_button_properties[TERMINAL_SETTINGS_POPOVER_THEME_CHECK_BUTTON_NUM_PROPERTIES];
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _Block2Data Block2Data;
enum  {
	TERMINAL_SETTINGS_POPOVER_SHOW_THEME_EDITOR_SIGNAL,
	TERMINAL_SETTINGS_POPOVER_NUM_SIGNALS
};
static guint terminal_settings_popover_signals[TERMINAL_SETTINGS_POPOVER_NUM_SIGNALS] = {0};

struct _TerminalSettingsPopover {
	GtkPopover parent_instance;
	TerminalSettingsPopoverPrivate * priv;
};

struct _TerminalSettingsPopoverClass {
	GtkPopoverClass parent_class;
};

struct _TerminalSettingsPopoverPrivate {
	GBindingGroup* terminal_binding;
	GtkBox* theme_buttons;
};

struct _TerminalSettingsPopoverThemeCheckButton {
	GtkCheckButton parent_instance;
	TerminalSettingsPopoverThemeCheckButtonPrivate * priv;
};

struct _TerminalSettingsPopoverThemeCheckButtonClass {
	GtkCheckButtonClass parent_class;
};

struct _TerminalSettingsPopoverThemeCheckButtonPrivate {
	gchar* _theme;
	GtkCssProvider* css_provider;
};

struct _Block2Data {
	int _ref_count_;
	TerminalSettingsPopover* self;
	TerminalSettingsPopoverThemeCheckButton* custom_button;
	GraniteSwitchModelButton* auto_hide_button;
};

static gint TerminalSettingsPopover_private_offset;
static gpointer terminal_settings_popover_parent_class = NULL;
static gint TerminalSettingsPopoverThemeCheckButton_private_offset;
static gpointer terminal_settings_popover_theme_check_button_parent_class = NULL;
VALA_EXTERN GSettings* terminal_application_settings;

VALA_EXTERN GType terminal_settings_popover_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TerminalSettingsPopover, g_object_unref)
static gboolean terminal_settings_popover_font_scale_to_zoom (GBinding* binding,
                                                       GValue* font_scale,
                                                       GValue* label);
VALA_EXTERN TerminalSettingsPopover* terminal_settings_popover_new (void);
VALA_EXTERN TerminalSettingsPopover* terminal_settings_popover_construct (GType object_type);
VALA_EXTERN GType terminal_terminal_widget_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TerminalTerminalWidget, g_object_unref)
VALA_EXTERN TerminalTerminalWidget* terminal_settings_popover_get_terminal (TerminalSettingsPopover* self);
VALA_EXTERN void terminal_settings_popover_set_terminal (TerminalSettingsPopover* self,
                                             TerminalTerminalWidget* value);
static GType terminal_settings_popover_theme_check_button_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TerminalSettingsPopoverThemeCheckButton, g_object_unref)
static TerminalSettingsPopoverThemeCheckButton* terminal_settings_popover_theme_check_button_new (const gchar* theme);
static TerminalSettingsPopoverThemeCheckButton* terminal_settings_popover_theme_check_button_construct (GType object_type,
                                                                                                 const gchar* theme);
static void terminal_settings_popover_theme_check_button_update_theme_provider (TerminalSettingsPopoverThemeCheckButton* self);
VALA_EXTERN GdkRGBA* terminal_themes_get_rgba_palette (const gchar* theme,
                                           gint* result_length1);
static const gchar* terminal_settings_popover_theme_check_button_get_theme (TerminalSettingsPopoverThemeCheckButton* self);
static void terminal_settings_popover_theme_check_button_set_theme (TerminalSettingsPopoverThemeCheckButton* self,
                                                             const gchar* value);
static GObject * terminal_settings_popover_theme_check_button_constructor (GType type,
                                                                    guint n_construct_properties,
                                                                    GObjectConstructParam * construct_properties);
static void terminal_settings_popover_theme_check_button_finalize (GObject * obj);
static GType terminal_settings_popover_theme_check_button_get_type_once (void);
static void _vala_terminal_settings_popover_theme_check_button_get_property (GObject * object,
                                                                      guint property_id,
                                                                      GValue * value,
                                                                      GParamSpec * pspec);
static void _vala_terminal_settings_popover_theme_check_button_set_property (GObject * object,
                                                                      guint property_id,
                                                                      const GValue * value,
                                                                      GParamSpec * pspec);
static GObject * terminal_settings_popover_constructor (GType type,
                                                 guint n_construct_properties,
                                                 GObjectConstructParam * construct_properties);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void _terminal_settings_popover___lambda17_ (TerminalSettingsPopover* self);
static void __terminal_settings_popover___lambda17__gtk_button_clicked (GtkButton* _sender,
                                                                 gpointer self);
static void _terminal_settings_popover___lambda18_ (TerminalSettingsPopover* self);
VALA_EXTERN void terminal_terminal_widget_default_font_size (TerminalTerminalWidget* self);
static void __terminal_settings_popover___lambda18__gtk_button_clicked (GtkButton* _sender,
                                                                 gpointer self);
static void _terminal_settings_popover___lambda19_ (TerminalSettingsPopover* self);
static void __terminal_settings_popover___lambda19__gtk_button_clicked (GtkButton* _sender,
                                                                 gpointer self);
static void _terminal_settings_popover___lambda20_ (Block2Data* _data2_);
static void __terminal_settings_popover___lambda20__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                        gpointer self);
static void _terminal_settings_popover___lambda21_ (Block2Data* _data2_);
static void __terminal_settings_popover___lambda21__gtk_button_clicked (GtkButton* _sender,
                                                                 gpointer self);
static gboolean _terminal_settings_popover_font_scale_to_zoom_gbinding_transform_func (GBinding* binding,
                                                                                GValue* from_value,
                                                                                GValue* to_value,
                                                                                gpointer self);
static void _terminal_settings_popover___lambda22_ (Block2Data* _data2_,
                                             GSettings* s,
                                             const gchar* n);
static void __terminal_settings_popover___lambda22__g_settings_changed (GSettings* _sender,
                                                                 const gchar* key,
                                                                 gpointer self);
static void _gtk_widget_show_all_gtk_widget_show (GtkWidget* _sender,
                                           gpointer self);
static void terminal_settings_popover_finalize (GObject * obj);
static GType terminal_settings_popover_get_type_once (void);
static void _vala_terminal_settings_popover_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec);
static void _vala_terminal_settings_popover_set_property (GObject * object,
                                                   guint property_id,
                                                   const GValue * value,
                                                   GParamSpec * pspec);

VALA_EXTERN const gchar* TERMINAL_TERMINAL_WIDGET_ACCELS_ZOOM_OUT[3];
VALA_EXTERN const gchar* TERMINAL_TERMINAL_WIDGET_ACCELS_ZOOM_DEFAULT[3];
VALA_EXTERN const gchar* TERMINAL_TERMINAL_WIDGET_ACCELS_ZOOM_IN[4];

static inline gpointer
terminal_settings_popover_get_instance_private (TerminalSettingsPopover* self)
{
	return G_STRUCT_MEMBER_P (self, TerminalSettingsPopover_private_offset);
}

static gboolean
terminal_settings_popover_font_scale_to_zoom (GBinding* binding,
                                              GValue* font_scale,
                                              GValue* label)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean result;
	g_return_val_if_fail (binding != NULL, FALSE);
	g_return_val_if_fail (font_scale != NULL, FALSE);
	g_return_val_if_fail (label != NULL, FALSE);
	_tmp0_ = g_strdup_printf ("%.0f%%", g_value_get_double (font_scale) * 100);
	_tmp1_ = _tmp0_;
	g_value_set_string (label, _tmp1_);
	_g_free0 (_tmp1_);
	result = TRUE;
	return result;
}

TerminalSettingsPopover*
terminal_settings_popover_construct (GType object_type)
{
	TerminalSettingsPopover * self = NULL;
	self = (TerminalSettingsPopover*) g_object_new (object_type, NULL);
	return self;
}

TerminalSettingsPopover*
terminal_settings_popover_new (void)
{
	return terminal_settings_popover_construct (TERMINAL_TYPE_SETTINGS_POPOVER);
}

TerminalTerminalWidget*
terminal_settings_popover_get_terminal (TerminalSettingsPopover* self)
{
	TerminalTerminalWidget* result;
	GBindingGroup* _tmp0_;
	GObject* _tmp1_;
	GObject* _tmp2_;
	TerminalTerminalWidget* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->terminal_binding;
	g_object_get (_tmp0_, "source", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = TERMINAL_IS_TERMINAL_WIDGET (_tmp2_) ? ((TerminalTerminalWidget*) _tmp2_) : NULL;
	if (_tmp3_ == NULL) {
		_g_object_unref0 (_tmp2_);
	}
	result = _tmp3_;
	return result;
}

void
terminal_settings_popover_set_terminal (TerminalSettingsPopover* self,
                                        TerminalTerminalWidget* value)
{
	GBindingGroup* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->terminal_binding;
	g_object_set (_tmp0_, "source", (GObject*) value, NULL);
	if (value != NULL) {
		GActionGroup* _tmp1_;
		_tmp1_ = gtk_widget_get_action_group ((GtkWidget*) value, "term");
		gtk_widget_insert_action_group ((GtkWidget*) self, "term", _tmp1_);
	}
	g_object_notify_by_pspec ((GObject *) self, terminal_settings_popover_properties[TERMINAL_SETTINGS_POPOVER_TERMINAL_PROPERTY]);
}

static inline gpointer
terminal_settings_popover_theme_check_button_get_instance_private (TerminalSettingsPopoverThemeCheckButton* self)
{
	return G_STRUCT_MEMBER_P (self, TerminalSettingsPopoverThemeCheckButton_private_offset);
}

static TerminalSettingsPopoverThemeCheckButton*
terminal_settings_popover_theme_check_button_construct (GType object_type,
                                                        const gchar* theme)
{
	TerminalSettingsPopoverThemeCheckButton * self = NULL;
	g_return_val_if_fail (theme != NULL, NULL);
	self = (TerminalSettingsPopoverThemeCheckButton*) g_object_new (object_type, "theme", theme, NULL);
	return self;
}

static TerminalSettingsPopoverThemeCheckButton*
terminal_settings_popover_theme_check_button_new (const gchar* theme)
{
	return terminal_settings_popover_theme_check_button_construct (TERMINAL_SETTINGS_POPOVER_TYPE_THEME_CHECK_BUTTON, theme);
}

static void
terminal_settings_popover_theme_check_button_update_theme_provider (TerminalSettingsPopoverThemeCheckButton* self)
{
	GdkRGBA* theme_palette = NULL;
	const gchar* _tmp0_;
	gint _tmp1_ = 0;
	GdkRGBA* _tmp2_;
	gint theme_palette_length1;
	gint _theme_palette_size_;
	gchar* background = NULL;
	gchar* _tmp3_;
	gchar* foreground = NULL;
	gchar* _tmp4_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_theme;
	_tmp2_ = terminal_themes_get_rgba_palette (_tmp0_, &_tmp1_);
	theme_palette = _tmp2_;
	theme_palette_length1 = _tmp1_;
	_theme_palette_size_ = theme_palette_length1;
	_tmp3_ = gdk_rgba_to_string (&theme_palette[TERMINAL_THEMES_PALETTE_SIZE - 3]);
	background = _tmp3_;
	_tmp4_ = gdk_rgba_to_string (&theme_palette[TERMINAL_THEMES_PALETTE_SIZE - 2]);
	foreground = _tmp4_;
	{
		GtkCssProvider* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp5_ = self->priv->css_provider;
		_tmp6_ = self->priv->_theme;
		_tmp7_ = g_strdup_printf (TERMINAL_SETTINGS_POPOVER_THEME_CHECK_BUTTON_STYLE_CSS, _tmp6_, background, foreground);
		_tmp8_ = _tmp7_;
		gtk_css_provider_load_from_data (_tmp5_, _tmp8_, (gssize) -1, &_inner_error0_);
		_g_free0 (_tmp8_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp9_;
		const gchar* _tmp10_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp9_ = e;
		_tmp10_ = _tmp9_->message;
		g_critical ("SettingsPopover.vala:227: Unable to style color button: %s", _tmp10_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (foreground);
		_g_free0 (background);
		theme_palette = (g_free (theme_palette), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (foreground);
	_g_free0 (background);
	theme_palette = (g_free (theme_palette), NULL);
}

static const gchar*
terminal_settings_popover_theme_check_button_get_theme (TerminalSettingsPopoverThemeCheckButton* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_theme;
	result = _tmp0_;
	return result;
}

static void
terminal_settings_popover_theme_check_button_set_theme (TerminalSettingsPopoverThemeCheckButton* self,
                                                        const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = terminal_settings_popover_theme_check_button_get_theme (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_theme);
		self->priv->_theme = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, terminal_settings_popover_theme_check_button_properties[TERMINAL_SETTINGS_POPOVER_THEME_CHECK_BUTTON_THEME_PROPERTY]);
	}
}

static GObject *
terminal_settings_popover_theme_check_button_constructor (GType type,
                                                          guint n_construct_properties,
                                                          GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	TerminalSettingsPopoverThemeCheckButton * self;
	const gchar* _tmp0_;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	GtkStyleContext* _tmp3_;
	GtkStyleContext* _tmp4_;
	const gchar* _tmp5_;
	GtkCssProvider* _tmp6_;
	GdkScreen* _tmp7_;
	GtkCssProvider* _tmp8_;
	parent_class = G_OBJECT_CLASS (terminal_settings_popover_theme_check_button_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TERMINAL_SETTINGS_POPOVER_TYPE_THEME_CHECK_BUTTON, TerminalSettingsPopoverThemeCheckButton);
	gtk_actionable_set_action_name ((GtkActionable*) self, TERMINAL_SETTINGS_POPOVER_ACTION_GROUP_NAME ".theme");
	_tmp0_ = self->priv->_theme;
	_tmp1_ = g_variant_new_string (_tmp0_);
	g_variant_ref_sink (_tmp1_);
	_tmp2_ = _tmp1_;
	g_object_set ((GtkActionable*) self, "action-target", _tmp2_, NULL);
	_g_variant_unref0 (_tmp2_);
	gtk_widget_set_halign ((GtkWidget*) self, GTK_ALIGN_CENTER);
	_tmp3_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp3_, GRANITE_STYLE_CLASS_COLOR_BUTTON);
	_tmp4_ = gtk_widget_get_style_context ((GtkWidget*) self);
	_tmp5_ = self->priv->_theme;
	gtk_style_context_add_class (_tmp4_, _tmp5_);
	_tmp6_ = gtk_css_provider_new ();
	_g_object_unref0 (self->priv->css_provider);
	self->priv->css_provider = _tmp6_;
	_tmp7_ = gdk_screen_get_default ();
	_tmp8_ = self->priv->css_provider;
	gtk_style_context_add_provider_for_screen (_tmp7_, (GtkStyleProvider*) _tmp8_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	terminal_settings_popover_theme_check_button_update_theme_provider (self);
	return obj;
}

static void
terminal_settings_popover_theme_check_button_class_init (TerminalSettingsPopoverThemeCheckButtonClass * klass,
                                                         gpointer klass_data)
{
	terminal_settings_popover_theme_check_button_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &TerminalSettingsPopoverThemeCheckButton_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_terminal_settings_popover_theme_check_button_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_terminal_settings_popover_theme_check_button_set_property;
	G_OBJECT_CLASS (klass)->constructor = terminal_settings_popover_theme_check_button_constructor;
	G_OBJECT_CLASS (klass)->finalize = terminal_settings_popover_theme_check_button_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TERMINAL_SETTINGS_POPOVER_THEME_CHECK_BUTTON_THEME_PROPERTY, terminal_settings_popover_theme_check_button_properties[TERMINAL_SETTINGS_POPOVER_THEME_CHECK_BUTTON_THEME_PROPERTY] = g_param_spec_string ("theme", "theme", "theme", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
terminal_settings_popover_theme_check_button_instance_init (TerminalSettingsPopoverThemeCheckButton * self,
                                                            gpointer klass)
{
	self->priv = terminal_settings_popover_theme_check_button_get_instance_private (self);
}

static void
terminal_settings_popover_theme_check_button_finalize (GObject * obj)
{
	TerminalSettingsPopoverThemeCheckButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TERMINAL_SETTINGS_POPOVER_TYPE_THEME_CHECK_BUTTON, TerminalSettingsPopoverThemeCheckButton);
	_g_free0 (self->priv->_theme);
	_g_object_unref0 (self->priv->css_provider);
	G_OBJECT_CLASS (terminal_settings_popover_theme_check_button_parent_class)->finalize (obj);
}

static GType
terminal_settings_popover_theme_check_button_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (TerminalSettingsPopoverThemeCheckButtonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) terminal_settings_popover_theme_check_button_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TerminalSettingsPopoverThemeCheckButton), 0, (GInstanceInitFunc) terminal_settings_popover_theme_check_button_instance_init, NULL };
	GType terminal_settings_popover_theme_check_button_type_id;
	terminal_settings_popover_theme_check_button_type_id = g_type_register_static (gtk_check_button_get_type (), "TerminalSettingsPopoverThemeCheckButton", &g_define_type_info, 0);
	TerminalSettingsPopoverThemeCheckButton_private_offset = g_type_add_instance_private (terminal_settings_popover_theme_check_button_type_id, sizeof (TerminalSettingsPopoverThemeCheckButtonPrivate));
	return terminal_settings_popover_theme_check_button_type_id;
}

static GType
terminal_settings_popover_theme_check_button_get_type (void)
{
	static volatile gsize terminal_settings_popover_theme_check_button_type_id__once = 0;
	if (g_once_init_enter (&terminal_settings_popover_theme_check_button_type_id__once)) {
		GType terminal_settings_popover_theme_check_button_type_id;
		terminal_settings_popover_theme_check_button_type_id = terminal_settings_popover_theme_check_button_get_type_once ();
		g_once_init_leave (&terminal_settings_popover_theme_check_button_type_id__once, terminal_settings_popover_theme_check_button_type_id);
	}
	return terminal_settings_popover_theme_check_button_type_id__once;
}

static void
_vala_terminal_settings_popover_theme_check_button_get_property (GObject * object,
                                                                 guint property_id,
                                                                 GValue * value,
                                                                 GParamSpec * pspec)
{
	TerminalSettingsPopoverThemeCheckButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TERMINAL_SETTINGS_POPOVER_TYPE_THEME_CHECK_BUTTON, TerminalSettingsPopoverThemeCheckButton);
	switch (property_id) {
		case TERMINAL_SETTINGS_POPOVER_THEME_CHECK_BUTTON_THEME_PROPERTY:
		g_value_set_string (value, terminal_settings_popover_theme_check_button_get_theme (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_terminal_settings_popover_theme_check_button_set_property (GObject * object,
                                                                 guint property_id,
                                                                 const GValue * value,
                                                                 GParamSpec * pspec)
{
	TerminalSettingsPopoverThemeCheckButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TERMINAL_SETTINGS_POPOVER_TYPE_THEME_CHECK_BUTTON, TerminalSettingsPopoverThemeCheckButton);
	switch (property_id) {
		case TERMINAL_SETTINGS_POPOVER_THEME_CHECK_BUTTON_THEME_PROPERTY:
		terminal_settings_popover_theme_check_button_set_theme (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		TerminalSettingsPopover* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->auto_hide_button);
		_g_object_unref0 (_data2_->custom_button);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static void
_terminal_settings_popover___lambda17_ (TerminalSettingsPopover* self)
{
	TerminalTerminalWidget* _tmp0_;
	TerminalTerminalWidget* _tmp1_;
	TerminalTerminalWidget* _tmp2_;
	_tmp0_ = terminal_settings_popover_get_terminal (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	g_signal_emit_by_name ((VteTerminal*) _tmp2_, "decrease-font-size");
	_g_object_unref0 (_tmp2_);
}

static void
__terminal_settings_popover___lambda17__gtk_button_clicked (GtkButton* _sender,
                                                            gpointer self)
{
	_terminal_settings_popover___lambda17_ ((TerminalSettingsPopover*) self);
}

static void
_terminal_settings_popover___lambda18_ (TerminalSettingsPopover* self)
{
	TerminalTerminalWidget* _tmp0_;
	TerminalTerminalWidget* _tmp1_;
	TerminalTerminalWidget* _tmp2_;
	_tmp0_ = terminal_settings_popover_get_terminal (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	terminal_terminal_widget_default_font_size (_tmp2_);
	_g_object_unref0 (_tmp2_);
}

static void
__terminal_settings_popover___lambda18__gtk_button_clicked (GtkButton* _sender,
                                                            gpointer self)
{
	_terminal_settings_popover___lambda18_ ((TerminalSettingsPopover*) self);
}

static void
_terminal_settings_popover___lambda19_ (TerminalSettingsPopover* self)
{
	TerminalTerminalWidget* _tmp0_;
	TerminalTerminalWidget* _tmp1_;
	TerminalTerminalWidget* _tmp2_;
	_tmp0_ = terminal_settings_popover_get_terminal (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	g_signal_emit_by_name ((VteTerminal*) _tmp2_, "increase-font-size");
	_g_object_unref0 (_tmp2_);
}

static void
__terminal_settings_popover___lambda19__gtk_button_clicked (GtkButton* _sender,
                                                            gpointer self)
{
	_terminal_settings_popover___lambda19_ ((TerminalSettingsPopover*) self);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_terminal_settings_popover___lambda20_ (Block2Data* _data2_)
{
	TerminalSettingsPopover* self;
	gint _tmp0_ = 0;
	GraniteSwitchModelButton* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GSettings* _tmp4_;
	self = _data2_->self;
	_tmp1_ = _data2_->auto_hide_button;
	_tmp2_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		_tmp0_ = 1;
	} else {
		_tmp0_ = 0;
	}
	_tmp4_ = terminal_application_settings;
	g_settings_set_enum (_tmp4_, "tab-bar-behavior", _tmp0_);
}

static void
__terminal_settings_popover___lambda20__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                   gpointer self)
{
	_terminal_settings_popover___lambda20_ (self);
}

static void
_terminal_settings_popover___lambda21_ (Block2Data* _data2_)
{
	TerminalSettingsPopover* self;
	TerminalSettingsPopoverThemeCheckButton* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	self = _data2_->self;
	_tmp0_ = _data2_->custom_button;
	_tmp1_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		g_signal_emit (self, terminal_settings_popover_signals[TERMINAL_SETTINGS_POPOVER_SHOW_THEME_EDITOR_SIGNAL], 0);
		gtk_popover_popdown ((GtkPopover*) self);
	}
}

static void
__terminal_settings_popover___lambda21__gtk_button_clicked (GtkButton* _sender,
                                                            gpointer self)
{
	_terminal_settings_popover___lambda21_ (self);
}

static gboolean
_terminal_settings_popover_font_scale_to_zoom_gbinding_transform_func (GBinding* binding,
                                                                       GValue* from_value,
                                                                       GValue* to_value,
                                                                       gpointer self)
{
	gboolean result;
	result = terminal_settings_popover_font_scale_to_zoom (binding, from_value, to_value);
	return result;
}

static void
_terminal_settings_popover___lambda22_ (Block2Data* _data2_,
                                        GSettings* s,
                                        const gchar* n)
{
	TerminalSettingsPopover* self;
	gboolean _tmp0_ = FALSE;
	self = _data2_->self;
	g_return_if_fail (s != NULL);
	g_return_if_fail (n != NULL);
	if (g_strcmp0 (n, "background") == 0) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (n, "foreground") == 0;
	}
	if (_tmp0_) {
		TerminalSettingsPopoverThemeCheckButton* _tmp1_;
		_tmp1_ = _data2_->custom_button;
		terminal_settings_popover_theme_check_button_update_theme_provider (_tmp1_);
	} else {
		if (g_strcmp0 (n, "tab-bar-behavior") == 0) {
			GraniteSwitchModelButton* _tmp2_;
			GSettings* _tmp3_;
			_tmp2_ = _data2_->auto_hide_button;
			_tmp3_ = terminal_application_settings;
			gtk_toggle_button_set_active ((GtkToggleButton*) _tmp2_, g_settings_get_enum (_tmp3_, "tab-bar-behavior") == 1);
		}
	}
}

static void
__terminal_settings_popover___lambda22__g_settings_changed (GSettings* _sender,
                                                            const gchar* key,
                                                            gpointer self)
{
	_terminal_settings_popover___lambda22_ (self, _sender, key);
}

static void
_gtk_widget_show_all_gtk_widget_show (GtkWidget* _sender,
                                      gpointer self)
{
	gtk_widget_show_all ((GtkWidget*) self);
}

static GObject *
terminal_settings_popover_constructor (GType type,
                                       guint n_construct_properties,
                                       GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	TerminalSettingsPopover * self;
	Block2Data* _data2_;
	GtkButton* zoom_out_button = NULL;
	gchar* _tmp0_;
	GtkButton* _tmp1_ = NULL;
	GtkButton* _tmp2_;
	GtkButton* zoom_default_button = NULL;
	gchar* _tmp3_;
	GtkButton* _tmp4_ = NULL;
	GtkButton* _tmp5_;
	GtkButton* zoom_in_button = NULL;
	gchar* _tmp6_;
	GtkButton* _tmp7_ = NULL;
	GtkButton* _tmp8_;
	GtkBox* font_size_box = NULL;
	GtkBox* _tmp9_ = NULL;
	GtkBox* _tmp10_;
	GtkButton* _tmp11_;
	GtkBox* _tmp12_;
	GtkButton* _tmp13_;
	GtkBox* _tmp14_;
	GtkButton* _tmp15_;
	GtkBox* _tmp16_;
	GtkStyleContext* _tmp17_;
	GraniteSwitchModelButton* follow_system_button = NULL;
	GSettings* _tmp18_;
	GraniteSwitchModelButton* _tmp19_ = NULL;
	TerminalSettingsPopoverThemeCheckButton* hc_button = NULL;
	gchar* _tmp20_;
	TerminalSettingsPopoverThemeCheckButton* _tmp21_ = NULL;
	TerminalSettingsPopoverThemeCheckButton* light_button = NULL;
	gchar* _tmp22_;
	TerminalSettingsPopoverThemeCheckButton* _tmp23_ = NULL;
	TerminalSettingsPopoverThemeCheckButton* dark_button = NULL;
	gchar* _tmp24_;
	TerminalSettingsPopoverThemeCheckButton* _tmp25_ = NULL;
	gchar* _tmp26_;
	TerminalSettingsPopoverThemeCheckButton* _tmp27_ = NULL;
	GtkBox* _tmp28_ = NULL;
	GtkBox* _tmp29_;
	TerminalSettingsPopoverThemeCheckButton* _tmp30_;
	GtkBox* _tmp31_;
	TerminalSettingsPopoverThemeCheckButton* _tmp32_;
	GtkBox* _tmp33_;
	TerminalSettingsPopoverThemeCheckButton* _tmp34_;
	GtkBox* _tmp35_;
	TerminalSettingsPopoverThemeCheckButton* _tmp36_;
	GtkRevealer* theme_revealer = NULL;
	GtkBox* _tmp37_;
	GtkWidget* _tmp38_;
	GtkRevealer* _tmp39_ = NULL;
	GtkBox* theme_box = NULL;
	GtkBox* _tmp40_;
	GtkBox* _tmp41_;
	GraniteSwitchModelButton* _tmp42_;
	GtkBox* _tmp43_;
	GtkRevealer* _tmp44_;
	GraniteSwitchModelButton* natural_copy_paste_button = NULL;
	gchar* _tmp45_;
	GSettings* _tmp46_;
	GraniteSwitchModelButton* _tmp47_ = NULL;
	GraniteSwitchModelButton* unsafe_paste_alert_button = NULL;
	gchar* _tmp48_;
	GSettings* _tmp49_;
	GraniteSwitchModelButton* _tmp50_ = NULL;
	GraniteSwitchModelButton* audible_bell_button = NULL;
	gchar* _tmp51_;
	GSettings* _tmp52_;
	GraniteSwitchModelButton* _tmp53_ = NULL;
	gchar* _tmp54_;
	GSettings* _tmp55_;
	GraniteSwitchModelButton* _tmp56_ = NULL;
	GraniteSwitchModelButton* _tmp57_;
	GtkBox* box = NULL;
	GtkBox* _tmp58_ = NULL;
	GtkBox* _tmp59_;
	GtkBox* _tmp60_;
	GtkBox* _tmp61_;
	GtkSeparator* _tmp62_;
	GtkSeparator* _tmp63_;
	GtkBox* _tmp64_;
	GtkBox* _tmp65_;
	GtkBox* _tmp66_;
	GtkSeparator* _tmp67_;
	GtkSeparator* _tmp68_;
	GtkBox* _tmp69_;
	GraniteSwitchModelButton* _tmp70_;
	GtkBox* _tmp71_;
	GraniteSwitchModelButton* _tmp72_;
	GtkBox* _tmp73_;
	GraniteSwitchModelButton* _tmp74_;
	GtkBox* _tmp75_;
	GraniteSwitchModelButton* _tmp76_;
	GtkBox* _tmp77_;
	GAction* settings_action = NULL;
	GSettings* _tmp78_;
	GAction* _tmp79_;
	GSimpleActionGroup* action_group = NULL;
	GSimpleActionGroup* _tmp80_;
	GSimpleActionGroup* _tmp81_;
	GAction* _tmp82_;
	GSimpleActionGroup* _tmp83_;
	TerminalSettingsPopoverThemeCheckButton* _tmp84_;
	GBindingGroup* _tmp85_;
	GBindingGroup* _tmp86_;
	GtkButton* _tmp87_;
	GraniteSwitchModelButton* _tmp88_;
	GtkRevealer* _tmp89_;
	GSettings* _tmp90_;
	GraniteSwitchModelButton* _tmp91_;
	GSettings* _tmp92_;
	GraniteSwitchModelButton* _tmp93_;
	GSettings* _tmp94_;
	GraniteSwitchModelButton* _tmp95_;
	GSettings* _tmp96_;
	GraniteSwitchModelButton* _tmp97_;
	GSettings* _tmp98_;
	GtkWidget* _tmp99_;
	parent_class = G_OBJECT_CLASS (terminal_settings_popover_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TERMINAL_TYPE_SETTINGS_POPOVER, TerminalSettingsPopover);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = granite_markup_accel_tooltip (TERMINAL_TERMINAL_WIDGET_ACCELS_ZOOM_OUT, (gint) G_N_ELEMENTS (TERMINAL_TERMINAL_WIDGET_ACCELS_ZOOM_OUT), _ ("Zoom out"));
	_tmp1_ = (GtkButton*) gtk_button_new_from_icon_name ("zoom-out-symbolic", (GtkIconSize) GTK_ICON_SIZE_BUTTON);
	gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp1_, _tmp0_);
	_g_free0 (_tmp0_);
	g_object_ref_sink (_tmp1_);
	zoom_out_button = _tmp1_;
	_tmp2_ = zoom_out_button;
	g_signal_connect_object (_tmp2_, "clicked", (GCallback) __terminal_settings_popover___lambda17__gtk_button_clicked, self, 0);
	_tmp3_ = granite_markup_accel_tooltip (TERMINAL_TERMINAL_WIDGET_ACCELS_ZOOM_DEFAULT, (gint) G_N_ELEMENTS (TERMINAL_TERMINAL_WIDGET_ACCELS_ZOOM_DEFAULT), _ ("Default zoom level"));
	_tmp4_ = (GtkButton*) gtk_button_new ();
	gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp4_, _tmp3_);
	_g_free0 (_tmp3_);
	g_object_ref_sink (_tmp4_);
	zoom_default_button = _tmp4_;
	_tmp5_ = zoom_default_button;
	g_signal_connect_object (_tmp5_, "clicked", (GCallback) __terminal_settings_popover___lambda18__gtk_button_clicked, self, 0);
	_tmp6_ = granite_markup_accel_tooltip (TERMINAL_TERMINAL_WIDGET_ACCELS_ZOOM_IN, (gint) G_N_ELEMENTS (TERMINAL_TERMINAL_WIDGET_ACCELS_ZOOM_IN), _ ("Zoom in"));
	_tmp7_ = (GtkButton*) gtk_button_new_from_icon_name ("zoom-in-symbolic", (GtkIconSize) GTK_ICON_SIZE_BUTTON);
	gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp7_, _tmp6_);
	_g_free0 (_tmp6_);
	g_object_ref_sink (_tmp7_);
	zoom_in_button = _tmp7_;
	_tmp8_ = zoom_in_button;
	g_signal_connect_object (_tmp8_, "clicked", (GCallback) __terminal_settings_popover___lambda19__gtk_button_clicked, self, 0);
	_tmp9_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	gtk_box_set_homogeneous (_tmp9_, TRUE);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp9_, TRUE);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp9_, 12);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp9_, 12);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp9_, 6);
	g_object_ref_sink (_tmp9_);
	font_size_box = _tmp9_;
	_tmp10_ = font_size_box;
	_tmp11_ = zoom_out_button;
	gtk_container_add ((GtkContainer*) _tmp10_, (GtkWidget*) _tmp11_);
	_tmp12_ = font_size_box;
	_tmp13_ = zoom_default_button;
	gtk_container_add ((GtkContainer*) _tmp12_, (GtkWidget*) _tmp13_);
	_tmp14_ = font_size_box;
	_tmp15_ = zoom_in_button;
	gtk_container_add ((GtkContainer*) _tmp14_, (GtkWidget*) _tmp15_);
	_tmp16_ = font_size_box;
	_tmp17_ = gtk_widget_get_style_context ((GtkWidget*) _tmp16_);
	gtk_style_context_add_class (_tmp17_, GTK_STYLE_CLASS_LINKED);
	_tmp18_ = terminal_application_settings;
	_tmp19_ = granite_switch_model_button_new (_ ("Follow System Style"));
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp19_, g_settings_get_boolean (_tmp18_, "follow-system-style"));
	g_object_ref_sink (_tmp19_);
	follow_system_button = _tmp19_;
	_tmp20_ = g_strdup (_ ("High Contrast"));
	_tmp21_ = terminal_settings_popover_theme_check_button_new (TERMINAL_THEMES_HIGH_CONTRAST);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp21_, _tmp20_);
	_g_free0 (_tmp20_);
	g_object_ref_sink (_tmp21_);
	hc_button = _tmp21_;
	_tmp22_ = g_strdup (_ ("Solarized Light"));
	_tmp23_ = terminal_settings_popover_theme_check_button_new (TERMINAL_THEMES_LIGHT);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp23_, _tmp22_);
	_g_free0 (_tmp22_);
	g_object_ref_sink (_tmp23_);
	light_button = _tmp23_;
	_tmp24_ = g_strdup (_ ("Dark"));
	_tmp25_ = terminal_settings_popover_theme_check_button_new (TERMINAL_THEMES_DARK);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp25_, _tmp24_);
	_g_free0 (_tmp24_);
	g_object_ref_sink (_tmp25_);
	dark_button = _tmp25_;
	_tmp26_ = g_strdup (_ ("Custom"));
	_tmp27_ = terminal_settings_popover_theme_check_button_new (TERMINAL_THEMES_CUSTOM);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp27_, _tmp26_);
	_g_free0 (_tmp26_);
	g_object_ref_sink (_tmp27_);
	_data2_->custom_button = _tmp27_;
	_tmp28_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	gtk_box_set_homogeneous (_tmp28_, TRUE);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp28_, 6);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp28_, 6);
	g_object_ref_sink (_tmp28_);
	_g_object_unref0 (self->priv->theme_buttons);
	self->priv->theme_buttons = _tmp28_;
	_tmp29_ = self->priv->theme_buttons;
	_tmp30_ = hc_button;
	gtk_container_add ((GtkContainer*) _tmp29_, (GtkWidget*) _tmp30_);
	_tmp31_ = self->priv->theme_buttons;
	_tmp32_ = light_button;
	gtk_container_add ((GtkContainer*) _tmp31_, (GtkWidget*) _tmp32_);
	_tmp33_ = self->priv->theme_buttons;
	_tmp34_ = dark_button;
	gtk_container_add ((GtkContainer*) _tmp33_, (GtkWidget*) _tmp34_);
	_tmp35_ = self->priv->theme_buttons;
	_tmp36_ = _data2_->custom_button;
	gtk_container_add ((GtkContainer*) _tmp35_, (GtkWidget*) _tmp36_);
	_tmp37_ = self->priv->theme_buttons;
	_tmp38_ = _g_object_ref0 ((GtkWidget*) _tmp37_);
	_tmp39_ = (GtkRevealer*) gtk_revealer_new ();
	g_object_set ((GtkContainer*) _tmp39_, "child", _tmp38_, NULL);
	_g_object_unref0 (_tmp38_);
	g_object_ref_sink (_tmp39_);
	theme_revealer = _tmp39_;
	_tmp40_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp40_);
	theme_box = _tmp40_;
	_tmp41_ = theme_box;
	_tmp42_ = follow_system_button;
	gtk_container_add ((GtkContainer*) _tmp41_, (GtkWidget*) _tmp42_);
	_tmp43_ = theme_box;
	_tmp44_ = theme_revealer;
	gtk_container_add ((GtkContainer*) _tmp43_, (GtkWidget*) _tmp44_);
	_tmp45_ = g_strdup (_ ("Shortcuts don’t require Shift; may interfere with CLI apps"));
	_tmp46_ = terminal_application_settings;
	_tmp47_ = granite_switch_model_button_new (_ ("Natural Copy/Paste"));
	granite_switch_model_button_set_description (_tmp47_, _tmp45_);
	_g_free0 (_tmp45_);
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp47_, g_settings_get_boolean (_tmp46_, "natural-copy-paste"));
	g_object_ref_sink (_tmp47_);
	natural_copy_paste_button = _tmp47_;
	_tmp48_ = g_strdup (_ ("Warn when pasted text contains multiple or administrative commands"));
	_tmp49_ = terminal_application_settings;
	_tmp50_ = granite_switch_model_button_new (_ ("Unsafe Paste Alert"));
	granite_switch_model_button_set_description (_tmp50_, _tmp48_);
	_g_free0 (_tmp48_);
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp50_, g_settings_get_boolean (_tmp49_, "unsafe-paste-alert"));
	g_object_ref_sink (_tmp50_);
	unsafe_paste_alert_button = _tmp50_;
	_tmp51_ = g_strdup (_ ("Notify for invalid input or multiple possible completions (subject to " \
"System Settings → Sound)"));
	_tmp52_ = terminal_application_settings;
	_tmp53_ = granite_switch_model_button_new (_ ("Event Alerts"));
	granite_switch_model_button_set_description (_tmp53_, _tmp51_);
	_g_free0 (_tmp51_);
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp53_, g_settings_get_boolean (_tmp52_, "audible-bell"));
	g_object_ref_sink (_tmp53_);
	audible_bell_button = _tmp53_;
	_tmp54_ = g_strdup (_ ("Hide the tab bar when there is only one tab"));
	_tmp55_ = terminal_application_settings;
	_tmp56_ = granite_switch_model_button_new (_ ("Auto-hide Tab Bar"));
	granite_switch_model_button_set_description (_tmp56_, _tmp54_);
	_g_free0 (_tmp54_);
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp56_, g_settings_get_enum (_tmp55_, "tab-bar-behavior") == 1);
	g_object_ref_sink (_tmp56_);
	_data2_->auto_hide_button = _tmp56_;
	_tmp57_ = _data2_->auto_hide_button;
	g_signal_connect_data ((GtkToggleButton*) _tmp57_, "toggled", (GCallback) __terminal_settings_popover___lambda20__gtk_toggle_button_toggled, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	_tmp58_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 6);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp58_, 6);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp58_, 12);
	g_object_ref_sink (_tmp58_);
	box = _tmp58_;
	_tmp59_ = box;
	_tmp60_ = font_size_box;
	gtk_container_add ((GtkContainer*) _tmp59_, (GtkWidget*) _tmp60_);
	_tmp61_ = box;
	_tmp62_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
	g_object_ref_sink (_tmp62_);
	_tmp63_ = _tmp62_;
	gtk_container_add ((GtkContainer*) _tmp61_, (GtkWidget*) _tmp63_);
	_g_object_unref0 (_tmp63_);
	_tmp64_ = box;
	_tmp65_ = theme_box;
	gtk_container_add ((GtkContainer*) _tmp64_, (GtkWidget*) _tmp65_);
	_tmp66_ = box;
	_tmp67_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
	g_object_ref_sink (_tmp67_);
	_tmp68_ = _tmp67_;
	gtk_container_add ((GtkContainer*) _tmp66_, (GtkWidget*) _tmp68_);
	_g_object_unref0 (_tmp68_);
	_tmp69_ = box;
	_tmp70_ = natural_copy_paste_button;
	gtk_container_add ((GtkContainer*) _tmp69_, (GtkWidget*) _tmp70_);
	_tmp71_ = box;
	_tmp72_ = unsafe_paste_alert_button;
	gtk_container_add ((GtkContainer*) _tmp71_, (GtkWidget*) _tmp72_);
	_tmp73_ = box;
	_tmp74_ = audible_bell_button;
	gtk_container_add ((GtkContainer*) _tmp73_, (GtkWidget*) _tmp74_);
	_tmp75_ = box;
	_tmp76_ = _data2_->auto_hide_button;
	gtk_container_add ((GtkContainer*) _tmp75_, (GtkWidget*) _tmp76_);
	_tmp77_ = box;
	g_object_set ((GtkContainer*) self, "child", (GtkWidget*) _tmp77_, NULL);
	_tmp78_ = terminal_application_settings;
	_tmp79_ = g_settings_create_action (_tmp78_, "theme");
	settings_action = _tmp79_;
	_tmp80_ = g_simple_action_group_new ();
	action_group = _tmp80_;
	_tmp81_ = action_group;
	_tmp82_ = settings_action;
	g_action_map_add_action ((GActionMap*) _tmp81_, _tmp82_);
	_tmp83_ = action_group;
	gtk_widget_insert_action_group ((GtkWidget*) self, TERMINAL_SETTINGS_POPOVER_ACTION_GROUP_NAME, (GActionGroup*) _tmp83_);
	_tmp84_ = _data2_->custom_button;
	g_signal_connect_data ((GtkButton*) _tmp84_, "clicked", (GCallback) __terminal_settings_popover___lambda21__gtk_button_clicked, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	_tmp85_ = g_binding_group_new ();
	_g_object_unref0 (self->priv->terminal_binding);
	self->priv->terminal_binding = _tmp85_;
	_tmp86_ = self->priv->terminal_binding;
	_tmp87_ = zoom_default_button;
	g_binding_group_bind_with_closures (_tmp86_, "font-scale", (GObject*) _tmp87_, "label", G_BINDING_SYNC_CREATE, (GClosure*) g_cclosure_new ((GCallback) _terminal_settings_popover_font_scale_to_zoom_gbinding_transform_func, NULL, (GClosureNotify) NULL), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp88_ = follow_system_button;
	_tmp89_ = theme_revealer;
	g_object_bind_property_with_closures ((GObject*) _tmp88_, "active", (GObject*) _tmp89_, "reveal-child", G_BINDING_SYNC_CREATE | G_BINDING_INVERT_BOOLEAN, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp90_ = terminal_application_settings;
	_tmp91_ = follow_system_button;
	g_settings_bind (_tmp90_, "follow-system-style", (GObject*) _tmp91_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp92_ = terminal_application_settings;
	_tmp93_ = natural_copy_paste_button;
	g_settings_bind (_tmp92_, "natural-copy-paste", (GObject*) _tmp93_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp94_ = terminal_application_settings;
	_tmp95_ = unsafe_paste_alert_button;
	g_settings_bind (_tmp94_, "unsafe-paste-alert", (GObject*) _tmp95_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp96_ = terminal_application_settings;
	_tmp97_ = audible_bell_button;
	g_settings_bind (_tmp96_, "audible-bell", (GObject*) _tmp97_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp98_ = terminal_application_settings;
	g_signal_connect_data (_tmp98_, "changed", (GCallback) __terminal_settings_popover___lambda22__g_settings_changed, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	_tmp99_ = gtk_bin_get_child ((GtkBin*) self);
	g_signal_connect_object ((GtkWidget*) self, "show", (GCallback) _gtk_widget_show_all_gtk_widget_show, _tmp99_, 0);
	_g_object_unref0 (action_group);
	_g_object_unref0 (settings_action);
	_g_object_unref0 (box);
	_g_object_unref0 (audible_bell_button);
	_g_object_unref0 (unsafe_paste_alert_button);
	_g_object_unref0 (natural_copy_paste_button);
	_g_object_unref0 (theme_box);
	_g_object_unref0 (theme_revealer);
	_g_object_unref0 (dark_button);
	_g_object_unref0 (light_button);
	_g_object_unref0 (hc_button);
	_g_object_unref0 (follow_system_button);
	_g_object_unref0 (font_size_box);
	_g_object_unref0 (zoom_in_button);
	_g_object_unref0 (zoom_default_button);
	_g_object_unref0 (zoom_out_button);
	block2_data_unref (_data2_);
	_data2_ = NULL;
	return obj;
}

static void
terminal_settings_popover_class_init (TerminalSettingsPopoverClass * klass,
                                      gpointer klass_data)
{
	terminal_settings_popover_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &TerminalSettingsPopover_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_terminal_settings_popover_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_terminal_settings_popover_set_property;
	G_OBJECT_CLASS (klass)->constructor = terminal_settings_popover_constructor;
	G_OBJECT_CLASS (klass)->finalize = terminal_settings_popover_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TERMINAL_SETTINGS_POPOVER_TERMINAL_PROPERTY, terminal_settings_popover_properties[TERMINAL_SETTINGS_POPOVER_TERMINAL_PROPERTY] = g_param_spec_object ("terminal", "terminal", "terminal", TERMINAL_TYPE_TERMINAL_WIDGET, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	terminal_settings_popover_signals[TERMINAL_SETTINGS_POPOVER_SHOW_THEME_EDITOR_SIGNAL] = g_signal_new ("show-theme-editor", TERMINAL_TYPE_SETTINGS_POPOVER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
terminal_settings_popover_instance_init (TerminalSettingsPopover * self,
                                         gpointer klass)
{
	self->priv = terminal_settings_popover_get_instance_private (self);
}

static void
terminal_settings_popover_finalize (GObject * obj)
{
	TerminalSettingsPopover * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TERMINAL_TYPE_SETTINGS_POPOVER, TerminalSettingsPopover);
	_g_object_unref0 (self->priv->terminal_binding);
	_g_object_unref0 (self->priv->theme_buttons);
	G_OBJECT_CLASS (terminal_settings_popover_parent_class)->finalize (obj);
}

static GType
terminal_settings_popover_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (TerminalSettingsPopoverClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) terminal_settings_popover_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TerminalSettingsPopover), 0, (GInstanceInitFunc) terminal_settings_popover_instance_init, NULL };
	GType terminal_settings_popover_type_id;
	terminal_settings_popover_type_id = g_type_register_static (gtk_popover_get_type (), "TerminalSettingsPopover", &g_define_type_info, 0);
	TerminalSettingsPopover_private_offset = g_type_add_instance_private (terminal_settings_popover_type_id, sizeof (TerminalSettingsPopoverPrivate));
	return terminal_settings_popover_type_id;
}

GType
terminal_settings_popover_get_type (void)
{
	static volatile gsize terminal_settings_popover_type_id__once = 0;
	if (g_once_init_enter (&terminal_settings_popover_type_id__once)) {
		GType terminal_settings_popover_type_id;
		terminal_settings_popover_type_id = terminal_settings_popover_get_type_once ();
		g_once_init_leave (&terminal_settings_popover_type_id__once, terminal_settings_popover_type_id);
	}
	return terminal_settings_popover_type_id__once;
}

static void
_vala_terminal_settings_popover_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec)
{
	TerminalSettingsPopover * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TERMINAL_TYPE_SETTINGS_POPOVER, TerminalSettingsPopover);
	switch (property_id) {
		case TERMINAL_SETTINGS_POPOVER_TERMINAL_PROPERTY:
		g_value_take_object (value, terminal_settings_popover_get_terminal (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_terminal_settings_popover_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec)
{
	TerminalSettingsPopover * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TERMINAL_TYPE_SETTINGS_POPOVER, TerminalSettingsPopover);
	switch (property_id) {
		case TERMINAL_SETTINGS_POPOVER_TERMINAL_PROPERTY:
		terminal_settings_popover_set_terminal (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

