/* DirectWindow.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from DirectWindow.vala, do not modify */

/*
* Copyright (c) 2009-2013 Yorba Foundation
*               2018 elementary LLC. (https://elementary.io)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include "io.elementary.photos.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <gee.h>
#include <handy.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	DIRECT_WINDOW_0_PROPERTY,
	DIRECT_WINDOW_NUM_PROPERTIES
};
static GParamSpec* direct_window_properties[DIRECT_WINDOW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _data_collection_unref0(var) ((var == NULL) ? NULL : (var = (data_collection_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _DirectWindowPrivate {
	DirectPhotoPage* direct_photo_page;
};

static gint DirectWindow_private_offset;
static gpointer direct_window_parent_class = NULL;

static void direct_window_on_photo_changed (DirectWindow* self);
static void _direct_window_on_photo_changed_data_collection_items_altered (DataCollection* _sender,
                                                                    GeeMap* items,
                                                                    gpointer self);
static void _direct_window_on_photo_changed_view_collection_items_state_changed (ViewCollection* _sender,
                                                                          GeeIterable* changed,
                                                                          gpointer self);
static void direct_window_real_on_fullscreen (AppWindow* base);
static gchar* direct_window_real_get_app_role (AppWindow* base);
static void direct_window_real_on_quit (AppWindow* base);
static gboolean direct_window_real_delete_event (GtkWidget* base,
                                          GdkEventAny* event);
static gboolean direct_window_real_key_press_event (GtkWidget* base,
                                             GdkEventKey* event);
static GObject * direct_window_constructor (GType type,
                                     guint n_construct_properties,
                                     GObjectConstructParam * construct_properties);
static void direct_window_finalize (GObject * obj);
static GType direct_window_get_type_once (void);

static inline gpointer
direct_window_get_instance_private (DirectWindow* self)
{
	return G_STRUCT_MEMBER_P (self, DirectWindow_private_offset);
}

static void
_direct_window_on_photo_changed_data_collection_items_altered (DataCollection* _sender,
                                                               GeeMap* items,
                                                               gpointer self)
{
	direct_window_on_photo_changed ((DirectWindow*) self);
}

static void
_direct_window_on_photo_changed_view_collection_items_state_changed (ViewCollection* _sender,
                                                                     GeeIterable* changed,
                                                                     gpointer self)
{
	direct_window_on_photo_changed ((DirectWindow*) self);
}

DirectWindow*
direct_window_construct (GType object_type,
                         GFile* file)
{
	DirectWindow * self = NULL;
	DirectPhotoPage* _tmp0_;
	DirectPhotoPage* _tmp1_;
	DirectPhotoPage* _tmp2_;
	ViewCollection* _tmp3_;
	ViewCollection* _tmp4_;
	DirectPhotoPage* _tmp5_;
	ViewCollection* _tmp6_;
	ViewCollection* _tmp7_;
	DirectPhotoPage* _tmp8_;
	DirectPhotoPage* _tmp9_;
	GtkGrid* layout = NULL;
	GtkGrid* _tmp10_;
	HdyHeaderBar* _tmp11_;
	DirectPhotoPage* _tmp12_;
	DirectPhotoPage* _tmp13_;
	GtkActionBar* _tmp14_;
	GtkActionBar* _tmp15_;
	GtkButton* save_btn = NULL;
	GtkButton* _tmp16_;
	DirectPhotoPage* _tmp17_;
	DirectPhotoPage* _tmp18_;
	GtkAction* _tmp19_;
	GtkAction* _tmp20_;
	GtkImage* _tmp21_;
	GtkImage* _tmp22_;
	GtkButton* save_as_btn = NULL;
	GtkButton* _tmp23_;
	DirectPhotoPage* _tmp24_;
	DirectPhotoPage* _tmp25_;
	GtkAction* _tmp26_;
	GtkAction* _tmp27_;
	GtkImage* _tmp28_;
	GtkImage* _tmp29_;
	HdyHeaderBar* _tmp30_;
	HdyHeaderBar* _tmp31_;
	HdyHeaderBar* _tmp32_;
	HdyHeaderBar* _tmp33_;
	GtkButton* _tmp34_;
	HdyHeaderBar* _tmp35_;
	GtkButton* _tmp36_;
	DirectPhotoPage* _tmp37_;
	gboolean _tmp38_ = FALSE;
	g_return_val_if_fail (file != NULL, NULL);
	self = (DirectWindow*) app_window_construct (object_type);
	_tmp0_ = direct_photo_page_new (file, FALSE);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->direct_photo_page);
	self->priv->direct_photo_page = _tmp0_;
	_tmp1_ = self->priv->direct_photo_page;
	g_object_set ((GtkWidget*) _tmp1_, "expand", TRUE, NULL);
	_tmp2_ = self->priv->direct_photo_page;
	_tmp3_ = page_get_view ((Page*) _tmp2_);
	_tmp4_ = _tmp3_;
	g_signal_connect_object ((DataCollection*) _tmp4_, "items-altered", (GCallback) _direct_window_on_photo_changed_data_collection_items_altered, self, 0);
	_data_collection_unref0 (_tmp4_);
	_tmp5_ = self->priv->direct_photo_page;
	_tmp6_ = page_get_view ((Page*) _tmp5_);
	_tmp7_ = _tmp6_;
	g_signal_connect_object (_tmp7_, "items-state-changed", (GCallback) _direct_window_on_photo_changed_view_collection_items_state_changed, self, 0);
	_data_collection_unref0 (_tmp7_);
	_tmp8_ = self->priv->direct_photo_page;
	page_window_set_current_page ((PageWindow*) self, (Page*) _tmp8_);
	direct_window_update_title (self, file, FALSE);
	_tmp9_ = self->priv->direct_photo_page;
	page_switched_to ((Page*) _tmp9_);
	_tmp10_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp10_);
	layout = _tmp10_;
	gtk_orientable_set_orientation ((GtkOrientable*) layout, GTK_ORIENTATION_VERTICAL);
	_tmp11_ = ((AppWindow*) self)->header;
	gtk_container_add ((GtkContainer*) layout, (GtkWidget*) _tmp11_);
	_tmp12_ = self->priv->direct_photo_page;
	gtk_container_add ((GtkContainer*) layout, (GtkWidget*) _tmp12_);
	_tmp13_ = self->priv->direct_photo_page;
	_tmp14_ = page_get_toolbar ((Page*) _tmp13_, NULL, GTK_PACK_START);
	_tmp15_ = _tmp14_;
	gtk_container_add ((GtkContainer*) layout, (GtkWidget*) _tmp15_);
	_g_object_unref0 (_tmp15_);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) layout);
	_tmp16_ = (GtkButton*) gtk_button_new ();
	g_object_ref_sink (_tmp16_);
	save_btn = _tmp16_;
	_tmp17_ = direct_window_get_direct_page (self);
	_tmp18_ = _tmp17_;
	_tmp19_ = page_get_action ((Page*) _tmp18_, "Save");
	_tmp20_ = _tmp19_;
	gtk_activatable_set_related_action ((GtkActivatable*) save_btn, _tmp20_);
	_g_object_unref0 (_tmp20_);
	_g_object_unref0 (_tmp18_);
	_tmp21_ = (GtkImage*) gtk_image_new_from_icon_name ("document-save", (GtkIconSize) GTK_ICON_SIZE_LARGE_TOOLBAR);
	g_object_ref_sink (_tmp21_);
	_tmp22_ = _tmp21_;
	gtk_button_set_image (save_btn, (GtkWidget*) _tmp22_);
	_g_object_unref0 (_tmp22_);
	gtk_widget_set_tooltip_text ((GtkWidget*) save_btn, _ ("Save photo"));
	_tmp23_ = (GtkButton*) gtk_button_new ();
	g_object_ref_sink (_tmp23_);
	save_as_btn = _tmp23_;
	_tmp24_ = direct_window_get_direct_page (self);
	_tmp25_ = _tmp24_;
	_tmp26_ = page_get_action ((Page*) _tmp25_, "SaveAs");
	_tmp27_ = _tmp26_;
	gtk_activatable_set_related_action ((GtkActivatable*) save_as_btn, _tmp27_);
	_g_object_unref0 (_tmp27_);
	_g_object_unref0 (_tmp25_);
	_tmp28_ = (GtkImage*) gtk_image_new_from_icon_name ("document-save-as", (GtkIconSize) GTK_ICON_SIZE_LARGE_TOOLBAR);
	g_object_ref_sink (_tmp28_);
	_tmp29_ = _tmp28_;
	gtk_button_set_image (save_as_btn, (GtkWidget*) _tmp29_);
	_g_object_unref0 (_tmp29_);
	gtk_widget_set_tooltip_text ((GtkWidget*) save_as_btn, _ ("Save photo with a different name"));
	_tmp30_ = ((AppWindow*) self)->header;
	hdy_header_bar_set_has_subtitle (_tmp30_, FALSE);
	_tmp31_ = ((AppWindow*) self)->header;
	hdy_header_bar_pack_start (_tmp31_, (GtkWidget*) save_btn);
	_tmp32_ = ((AppWindow*) self)->header;
	hdy_header_bar_pack_start (_tmp32_, (GtkWidget*) save_as_btn);
	_tmp33_ = ((AppWindow*) self)->header;
	_tmp34_ = ((AppWindow*) self)->redo_btn;
	hdy_header_bar_pack_end (_tmp33_, (GtkWidget*) _tmp34_);
	_tmp35_ = ((AppWindow*) self)->header;
	_tmp36_ = ((AppWindow*) self)->undo_btn;
	hdy_header_bar_pack_end (_tmp35_, (GtkWidget*) _tmp36_);
	_tmp37_ = self->priv->direct_photo_page;
	g_signal_emit_by_name ((GtkWidget*) _tmp37_, "focus", GTK_DIR_DOWN, &_tmp38_);
	_g_object_unref0 (save_as_btn);
	_g_object_unref0 (save_btn);
	_g_object_unref0 (layout);
	return self;
}

DirectWindow*
direct_window_new (GFile* file)
{
	return direct_window_construct (TYPE_DIRECT_WINDOW, file);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

DirectWindow*
direct_window_get_app (void)
{
	AppWindow* _tmp0_;
	DirectWindow* _tmp1_;
	DirectWindow* result;
	_tmp0_ = app_window_instance;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_DIRECT_WINDOW, DirectWindow));
	result = _tmp1_;
	return result;
}

DirectPhotoPage*
direct_window_get_direct_page (DirectWindow* self)
{
	Page* _tmp0_;
	DirectPhotoPage* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = page_window_get_current_page ((PageWindow*) self);
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_DIRECT_PHOTO_PAGE, DirectPhotoPage);
	return result;
}

void
direct_window_update_title (DirectWindow* self,
                            GFile* file,
                            gboolean modified)
{
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	HdyHeaderBar* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	if (modified) {
		_tmp0_ = "*";
	} else {
		_tmp0_ = "";
	}
	_tmp1_ = g_file_get_basename (file);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_file_get_parent (file);
	_tmp4_ = _tmp3_;
	_tmp5_ = get_display_pathname (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strdup_printf ("%s%s (%s) - %s", _tmp0_, _tmp2_, _tmp6_, _ (RESOURCES_APP_TITLE));
	_tmp8_ = _tmp7_;
	gtk_window_set_title ((GtkWindow*) self, _tmp8_);
	_g_free0 (_tmp8_);
	_g_free0 (_tmp6_);
	_g_object_unref0 (_tmp4_);
	_g_free0 (_tmp2_);
	_tmp9_ = ((AppWindow*) self)->header;
	_tmp10_ = gtk_window_get_title ((GtkWindow*) self);
	_tmp11_ = _tmp10_;
	hdy_header_bar_set_title (_tmp9_, _tmp11_);
}

static void
direct_window_real_on_fullscreen (AppWindow* base)
{
	DirectWindow * self;
	GFile* file = NULL;
	DirectPhotoPage* _tmp0_;
	DirectPhotoPage* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	DirectPhotoPage* _tmp4_;
	DirectPhotoPage* _tmp5_;
	self = (DirectWindow*) base;
	_tmp0_ = direct_window_get_direct_page (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = direct_photo_page_get_current_file (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	file = _tmp3_;
	_tmp4_ = direct_photo_page_new (file, TRUE);
	g_object_ref_sink (_tmp4_);
	_tmp5_ = _tmp4_;
	app_window_go_fullscreen ((AppWindow*) self, (Page*) _tmp5_);
	_g_object_unref0 (_tmp5_);
	_g_object_unref0 (file);
}

static gchar*
direct_window_real_get_app_role (AppWindow* base)
{
	DirectWindow * self;
	gchar* _tmp0_;
	gchar* result;
	self = (DirectWindow*) base;
	_tmp0_ = g_strdup (RESOURCES_APP_DIRECT_ROLE);
	result = _tmp0_;
	return result;
}

static void
direct_window_on_photo_changed (DirectWindow* self)
{
	Photo* photo = NULL;
	DirectPhotoPage* _tmp0_;
	Photo* _tmp1_;
	Photo* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->direct_photo_page;
	_tmp1_ = editing_host_page_get_photo ((EditingHostPage*) _tmp0_);
	photo = _tmp1_;
	_tmp2_ = photo;
	if (_tmp2_ != NULL) {
		Photo* _tmp3_;
		GFile* _tmp4_;
		GFile* _tmp5_;
		Photo* _tmp6_;
		_tmp3_ = photo;
		_tmp4_ = media_source_get_file ((MediaSource*) _tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = photo;
		direct_window_update_title (self, _tmp5_, photo_has_alterations (_tmp6_));
		_g_object_unref0 (_tmp5_);
	}
	_g_object_unref0 (photo);
}

static void
direct_window_real_on_quit (AppWindow* base)
{
	DirectWindow * self;
	DirectPhotoPage* _tmp0_;
	DirectPhotoPage* _tmp1_;
	gboolean _tmp2_;
	GSettings* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	GSettings* _tmp6_;
	Dimensions _tmp7_;
	GSettings* _tmp8_;
	Dimensions _tmp9_;
	self = (DirectWindow*) base;
	_tmp0_ = direct_window_get_direct_page (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = !direct_photo_page_check_quit (_tmp1_);
	_g_object_unref0 (_tmp1_);
	if (_tmp2_) {
		return;
	}
	_tmp3_ = ((AppWindow*) self)->window_settings;
	g_object_get ((GtkWindow*) self, "is-maximized", &_tmp4_, NULL);
	_tmp5_ = _tmp4_;
	g_settings_set_boolean (_tmp3_, "direct-maximize", _tmp5_);
	_tmp6_ = ((AppWindow*) self)->window_settings;
	_tmp7_ = ((AppWindow*) self)->dimensions;
	g_settings_set_int (_tmp6_, "direct-width", _tmp7_.width);
	_tmp8_ = ((AppWindow*) self)->window_settings;
	_tmp9_ = ((AppWindow*) self)->dimensions;
	g_settings_set_int (_tmp8_, "direct-height", _tmp9_.height);
	APP_WINDOW_CLASS (direct_window_parent_class)->on_quit (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_APP_WINDOW, AppWindow));
}

static gboolean
direct_window_real_delete_event (GtkWidget* base,
                                 GdkEventAny* event)
{
	DirectWindow * self;
	DirectPhotoPage* _tmp0_;
	DirectPhotoPage* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean result;
	self = (DirectWindow*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = direct_window_get_direct_page (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = !direct_photo_page_check_quit (_tmp1_);
	_g_object_unref0 (_tmp1_);
	if (_tmp2_) {
		result = TRUE;
		return result;
	}
	if (GTK_WIDGET_CLASS (direct_window_parent_class)->delete_event != NULL) {
		_tmp3_ = GTK_WIDGET_CLASS (direct_window_parent_class)->delete_event ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_APP_WINDOW, AppWindow), event);
	} else {
		_tmp3_ = FALSE;
	}
	result = _tmp3_;
	return result;
}

static gboolean
direct_window_real_key_press_event (GtkWidget* base,
                                    GdkEventKey* event)
{
	DirectWindow * self;
	const gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean result;
	self = (DirectWindow*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = gdk_keyval_name (event->keyval);
	if (g_strcmp0 (_tmp0_, "Escape") == 0) {
		app_window_on_quit ((AppWindow*) self);
		result = TRUE;
		return result;
	}
	if (GTK_WIDGET_CLASS (direct_window_parent_class)->key_press_event != NULL) {
		_tmp1_ = GTK_WIDGET_CLASS (direct_window_parent_class)->key_press_event ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_APP_WINDOW, AppWindow), event);
	} else {
		_tmp1_ = FALSE;
	}
	result = _tmp1_;
	return result;
}

static GObject *
direct_window_constructor (GType type,
                           guint n_construct_properties,
                           GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	DirectWindow * self;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	parent_class = G_OBJECT_CLASS (direct_window_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DIRECT_WINDOW, DirectWindow);
	_tmp0_ = ((AppWindow*) self)->window_settings;
	_tmp1_ = ((AppWindow*) self)->window_settings;
	gtk_window_set_default_size ((GtkWindow*) self, g_settings_get_int (_tmp0_, "direct-width"), g_settings_get_int (_tmp1_, "direct-height"));
	_tmp2_ = ((AppWindow*) self)->window_settings;
	if (g_settings_get_boolean (_tmp2_, "direct-maximize")) {
		gtk_window_maximize ((GtkWindow*) self);
	}
	return obj;
}

static void
direct_window_class_init (DirectWindowClass * klass,
                          gpointer klass_data)
{
	direct_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &DirectWindow_private_offset);
	((AppWindowClass *) klass)->on_fullscreen = (void (*) (AppWindow*)) direct_window_real_on_fullscreen;
	((AppWindowClass *) klass)->get_app_role = (gchar* (*) (AppWindow*)) direct_window_real_get_app_role;
	((AppWindowClass *) klass)->on_quit = (void (*) (AppWindow*)) direct_window_real_on_quit;
	((GtkWidgetClass *) klass)->delete_event = (gboolean (*) (GtkWidget*, GdkEventAny*)) direct_window_real_delete_event;
	((GtkWidgetClass *) klass)->key_press_event = (gboolean (*) (GtkWidget*, GdkEventKey*)) direct_window_real_key_press_event;
	G_OBJECT_CLASS (klass)->constructor = direct_window_constructor;
	G_OBJECT_CLASS (klass)->finalize = direct_window_finalize;
}

static void
direct_window_instance_init (DirectWindow * self,
                             gpointer klass)
{
	self->priv = direct_window_get_instance_private (self);
}

static void
direct_window_finalize (GObject * obj)
{
	DirectWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DIRECT_WINDOW, DirectWindow);
	_g_object_unref0 (self->priv->direct_photo_page);
	G_OBJECT_CLASS (direct_window_parent_class)->finalize (obj);
}

static GType
direct_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DirectWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) direct_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DirectWindow), 0, (GInstanceInitFunc) direct_window_instance_init, NULL };
	GType direct_window_type_id;
	direct_window_type_id = g_type_register_static (TYPE_APP_WINDOW, "DirectWindow", &g_define_type_info, 0);
	DirectWindow_private_offset = g_type_add_instance_private (direct_window_type_id, sizeof (DirectWindowPrivate));
	return direct_window_type_id;
}

GType
direct_window_get_type (void)
{
	static volatile gsize direct_window_type_id__once = 0;
	if (g_once_init_enter (&direct_window_type_id__once)) {
		GType direct_window_type_id;
		direct_window_type_id = direct_window_get_type_once ();
		g_once_init_leave (&direct_window_type_id__once, direct_window_type_id);
	}
	return direct_window_type_id__once;
}

