/* CircleEffect.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from CircleEffect.vala, do not modify */

/*
* Copyright (c) 2011-2013 Yorba Foundation
*               2013 Jens Bav
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include "pantheon-photos-transitions.h"
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "io.elementary.photos.h"
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <cairo-gobject.h>
#include <float.h>
#include <math.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gdk/gdk.h>

#define CIRCLE_EFFECT_DESIRED_FPS 25
#define CIRCLE_EFFECT_MIN_FPS 15
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define TYPE_CIRCLE_EFFECT_DESCRIPTOR (circle_effect_descriptor_get_type ())
#define CIRCLE_EFFECT_DESCRIPTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CIRCLE_EFFECT_DESCRIPTOR, CircleEffectDescriptor))
#define CIRCLE_EFFECT_DESCRIPTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CIRCLE_EFFECT_DESCRIPTOR, CircleEffectDescriptorClass))
#define IS_CIRCLE_EFFECT_DESCRIPTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CIRCLE_EFFECT_DESCRIPTOR))
#define IS_CIRCLE_EFFECT_DESCRIPTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CIRCLE_EFFECT_DESCRIPTOR))
#define CIRCLE_EFFECT_DESCRIPTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CIRCLE_EFFECT_DESCRIPTOR, CircleEffectDescriptorClass))

typedef struct _CircleEffectDescriptor CircleEffectDescriptor;
typedef struct _CircleEffectDescriptorClass CircleEffectDescriptorClass;
typedef struct _CircleEffectDescriptorPrivate CircleEffectDescriptorPrivate;
enum  {
	CIRCLE_EFFECT_DESCRIPTOR_0_PROPERTY,
	CIRCLE_EFFECT_DESCRIPTOR_NUM_PROPERTIES
};
static GParamSpec* circle_effect_descriptor_properties[CIRCLE_EFFECT_DESCRIPTOR_NUM_PROPERTIES];

#define TYPE_CIRCLE_EFFECT (circle_effect_get_type ())
#define CIRCLE_EFFECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CIRCLE_EFFECT, CircleEffect))
#define CIRCLE_EFFECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CIRCLE_EFFECT, CircleEffectClass))
#define IS_CIRCLE_EFFECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CIRCLE_EFFECT))
#define IS_CIRCLE_EFFECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CIRCLE_EFFECT))
#define CIRCLE_EFFECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CIRCLE_EFFECT, CircleEffectClass))

typedef struct _CircleEffect CircleEffect;
typedef struct _CircleEffectClass CircleEffectClass;
typedef struct _CircleEffectPrivate CircleEffectPrivate;
enum  {
	CIRCLE_EFFECT_0_PROPERTY,
	CIRCLE_EFFECT_NUM_PROPERTIES
};
static GParamSpec* circle_effect_properties[CIRCLE_EFFECT_NUM_PROPERTIES];

struct _CircleEffectDescriptor {
	ShotwellTransitionDescriptor parent_instance;
	CircleEffectDescriptorPrivate * priv;
};

struct _CircleEffectDescriptorClass {
	ShotwellTransitionDescriptorClass parent_class;
};

struct _CircleEffect {
	GObject parent_instance;
	CircleEffectPrivate * priv;
};

struct _CircleEffectClass {
	GObjectClass parent_class;
};

static gpointer circle_effect_descriptor_parent_class = NULL;
static gpointer circle_effect_parent_class = NULL;
static SpitTransitionsEffectIface * circle_effect_spit_transitions_effect_parent_iface = NULL;

VALA_EXTERN GType circle_effect_descriptor_get_type (void) G_GNUC_CONST ;
VALA_EXTERN CircleEffectDescriptor* circle_effect_descriptor_new (GFile* resource_directory);
VALA_EXTERN CircleEffectDescriptor* circle_effect_descriptor_construct (GType object_type,
                                                            GFile* resource_directory);
static const gchar* circle_effect_descriptor_real_get_id (ShotwellTransitionDescriptor* base);
static const gchar* circle_effect_descriptor_real_get_pluggable_name (ShotwellTransitionDescriptor* base);
static SpitTransitionsEffect* circle_effect_descriptor_real_create (ShotwellTransitionDescriptor* base,
                                                             SpitHostInterface* host);
VALA_EXTERN CircleEffect* circle_effect_new (void);
VALA_EXTERN CircleEffect* circle_effect_construct (GType object_type);
VALA_EXTERN GType circle_effect_get_type (void) G_GNUC_CONST ;
static GType circle_effect_descriptor_get_type_once (void);
static void circle_effect_real_get_fps (SpitTransitionsEffect* base,
                                 gint* desired_fps,
                                 gint* min_fps);
static void circle_effect_real_start (SpitTransitionsEffect* base,
                               SpitTransitionsVisuals* visuals,
                               SpitTransitionsMotion* motion);
static gboolean circle_effect_real_needs_clear_background (SpitTransitionsEffect* base);
static void circle_effect_real_paint (SpitTransitionsEffect* base,
                               SpitTransitionsVisuals* visuals,
                               SpitTransitionsMotion* motion,
                               cairo_t* ctx,
                               gint width,
                               gint height,
                               gint frame_number);
static void circle_effect_real_advance (SpitTransitionsEffect* base,
                                 SpitTransitionsVisuals* visuals,
                                 SpitTransitionsMotion* motion,
                                 gint frame_number);
static void circle_effect_real_cancel (SpitTransitionsEffect* base);
static GType circle_effect_get_type_once (void);

CircleEffectDescriptor*
circle_effect_descriptor_construct (GType object_type,
                                    GFile* resource_directory)
{
	CircleEffectDescriptor * self = NULL;
	g_return_val_if_fail (resource_directory != NULL, NULL);
	self = (CircleEffectDescriptor*) shotwell_transition_descriptor_construct (object_type, resource_directory);
	return self;
}

CircleEffectDescriptor*
circle_effect_descriptor_new (GFile* resource_directory)
{
	return circle_effect_descriptor_construct (TYPE_CIRCLE_EFFECT_DESCRIPTOR, resource_directory);
}

static const gchar*
circle_effect_descriptor_real_get_id (ShotwellTransitionDescriptor* base)
{
	CircleEffectDescriptor * self;
	const gchar* result;
	self = (CircleEffectDescriptor*) base;
	result = "io.elementary.photos.transitions.circle";
	return result;
}

static const gchar*
circle_effect_descriptor_real_get_pluggable_name (ShotwellTransitionDescriptor* base)
{
	CircleEffectDescriptor * self;
	const gchar* result;
	self = (CircleEffectDescriptor*) base;
	result = _ ("Circle");
	return result;
}

static SpitTransitionsEffect*
circle_effect_descriptor_real_create (ShotwellTransitionDescriptor* base,
                                      SpitHostInterface* host)
{
	CircleEffectDescriptor * self;
	CircleEffect* _tmp0_;
	SpitTransitionsEffect* result;
	self = (CircleEffectDescriptor*) base;
	g_return_val_if_fail (host != NULL, NULL);
	_tmp0_ = circle_effect_new ();
	result = (SpitTransitionsEffect*) _tmp0_;
	return result;
}

static void
circle_effect_descriptor_class_init (CircleEffectDescriptorClass * klass,
                                     gpointer klass_data)
{
	circle_effect_descriptor_parent_class = g_type_class_peek_parent (klass);
	((ShotwellTransitionDescriptorClass *) klass)->get_id = (const gchar* (*) (ShotwellTransitionDescriptor*)) circle_effect_descriptor_real_get_id;
	((ShotwellTransitionDescriptorClass *) klass)->get_pluggable_name = (const gchar* (*) (ShotwellTransitionDescriptor*)) circle_effect_descriptor_real_get_pluggable_name;
	((ShotwellTransitionDescriptorClass *) klass)->create = (SpitTransitionsEffect* (*) (ShotwellTransitionDescriptor*, SpitHostInterface*)) circle_effect_descriptor_real_create;
}

static void
circle_effect_descriptor_instance_init (CircleEffectDescriptor * self,
                                        gpointer klass)
{
}

static GType
circle_effect_descriptor_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (CircleEffectDescriptorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) circle_effect_descriptor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CircleEffectDescriptor), 0, (GInstanceInitFunc) circle_effect_descriptor_instance_init, NULL };
	GType circle_effect_descriptor_type_id;
	circle_effect_descriptor_type_id = g_type_register_static (TYPE_SHOTWELL_TRANSITION_DESCRIPTOR, "CircleEffectDescriptor", &g_define_type_info, 0);
	return circle_effect_descriptor_type_id;
}

GType
circle_effect_descriptor_get_type (void)
{
	static volatile gsize circle_effect_descriptor_type_id__once = 0;
	if (g_once_init_enter (&circle_effect_descriptor_type_id__once)) {
		GType circle_effect_descriptor_type_id;
		circle_effect_descriptor_type_id = circle_effect_descriptor_get_type_once ();
		g_once_init_leave (&circle_effect_descriptor_type_id__once, circle_effect_descriptor_type_id);
	}
	return circle_effect_descriptor_type_id__once;
}

CircleEffect*
circle_effect_construct (GType object_type)
{
	CircleEffect * self = NULL;
	self = (CircleEffect*) g_object_new (object_type, NULL);
	return self;
}

CircleEffect*
circle_effect_new (void)
{
	return circle_effect_construct (TYPE_CIRCLE_EFFECT);
}

static void
circle_effect_real_get_fps (SpitTransitionsEffect* base,
                            gint* desired_fps,
                            gint* min_fps)
{
	CircleEffect * self;
	gint _vala_desired_fps = 0;
	gint _vala_min_fps = 0;
	self = (CircleEffect*) base;
	_vala_desired_fps = CIRCLE_EFFECT_DESIRED_FPS;
	_vala_min_fps = CIRCLE_EFFECT_MIN_FPS;
	if (desired_fps) {
		*desired_fps = _vala_desired_fps;
	}
	if (min_fps) {
		*min_fps = _vala_min_fps;
	}
}

static void
circle_effect_real_start (SpitTransitionsEffect* base,
                          SpitTransitionsVisuals* visuals,
                          SpitTransitionsMotion* motion)
{
	CircleEffect * self;
	self = (CircleEffect*) base;
	g_return_if_fail (visuals != NULL);
	g_return_if_fail (motion != NULL);
}

static gboolean
circle_effect_real_needs_clear_background (SpitTransitionsEffect* base)
{
	CircleEffect * self;
	gboolean result;
	self = (CircleEffect*) base;
	result = TRUE;
	return result;
}

static void
circle_effect_real_paint (SpitTransitionsEffect* base,
                          SpitTransitionsVisuals* visuals,
                          SpitTransitionsMotion* motion,
                          cairo_t* ctx,
                          gint width,
                          gint height,
                          gint frame_number)
{
	CircleEffect * self;
	gdouble alpha = 0.0;
	gint radius = 0;
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp1_;
	GdkPixbuf* _tmp8_;
	GdkPixbuf* _tmp9_;
	self = (CircleEffect*) base;
	g_return_if_fail (visuals != NULL);
	g_return_if_fail (motion != NULL);
	g_return_if_fail (ctx != NULL);
	alpha = spit_transitions_motion_get_alpha (motion, frame_number);
	radius = (gint) (alpha * fmax ((gdouble) width, (gdouble) height));
	_tmp0_ = spit_transitions_visuals_get_from_pixbuf (visuals);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		GdkPixbuf* _tmp2_;
		GdkPixbuf* _tmp3_;
		GdkRectangle _tmp4_ = {0};
		GdkRectangle _tmp5_;
		GdkRectangle _tmp6_ = {0};
		GdkRectangle _tmp7_;
		_tmp2_ = spit_transitions_visuals_get_from_pixbuf (visuals);
		_tmp3_ = _tmp2_;
		spit_transitions_visuals_get_from_pos (visuals, &_tmp4_);
		_tmp5_ = _tmp4_;
		spit_transitions_visuals_get_from_pos (visuals, &_tmp6_);
		_tmp7_ = _tmp6_;
		gdk_cairo_set_source_pixbuf (ctx, _tmp3_, (gdouble) _tmp5_.x, (gdouble) _tmp7_.y);
		cairo_paint_with_alpha (ctx, 1 - alpha);
	}
	_tmp8_ = spit_transitions_visuals_get_to_pixbuf (visuals);
	_tmp9_ = _tmp8_;
	if (_tmp9_ != NULL) {
		GdkPixbuf* _tmp10_;
		GdkPixbuf* _tmp11_;
		GdkRectangle _tmp12_ = {0};
		GdkRectangle _tmp13_;
		GdkRectangle _tmp14_ = {0};
		GdkRectangle _tmp15_;
		_tmp10_ = spit_transitions_visuals_get_to_pixbuf (visuals);
		_tmp11_ = _tmp10_;
		spit_transitions_visuals_get_to_pos (visuals, &_tmp12_);
		_tmp13_ = _tmp12_;
		spit_transitions_visuals_get_to_pos (visuals, &_tmp14_);
		_tmp15_ = _tmp14_;
		gdk_cairo_set_source_pixbuf (ctx, _tmp11_, (gdouble) _tmp13_.x, (gdouble) _tmp15_.y);
		cairo_arc (ctx, (gdouble) (((gint) width) / 2), (gdouble) (((gint) height) / 2), (gdouble) radius, (gdouble) 0, 2 * G_PI);
		cairo_clip (ctx);
		cairo_paint (ctx);
	}
}

static void
circle_effect_real_advance (SpitTransitionsEffect* base,
                            SpitTransitionsVisuals* visuals,
                            SpitTransitionsMotion* motion,
                            gint frame_number)
{
	CircleEffect * self;
	self = (CircleEffect*) base;
	g_return_if_fail (visuals != NULL);
	g_return_if_fail (motion != NULL);
}

static void
circle_effect_real_cancel (SpitTransitionsEffect* base)
{
	CircleEffect * self;
	self = (CircleEffect*) base;
}

static void
circle_effect_class_init (CircleEffectClass * klass,
                          gpointer klass_data)
{
	circle_effect_parent_class = g_type_class_peek_parent (klass);
}

static void
circle_effect_spit_transitions_effect_interface_init (SpitTransitionsEffectIface * iface,
                                                      gpointer iface_data)
{
	circle_effect_spit_transitions_effect_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_fps = (void (*) (SpitTransitionsEffect*, gint*, gint*)) circle_effect_real_get_fps;
	iface->start = (void (*) (SpitTransitionsEffect*, SpitTransitionsVisuals*, SpitTransitionsMotion*)) circle_effect_real_start;
	iface->needs_clear_background = (gboolean (*) (SpitTransitionsEffect*)) circle_effect_real_needs_clear_background;
	iface->paint = (void (*) (SpitTransitionsEffect*, SpitTransitionsVisuals*, SpitTransitionsMotion*, cairo_t*, gint, gint, gint)) circle_effect_real_paint;
	iface->advance = (void (*) (SpitTransitionsEffect*, SpitTransitionsVisuals*, SpitTransitionsMotion*, gint)) circle_effect_real_advance;
	iface->cancel = (void (*) (SpitTransitionsEffect*)) circle_effect_real_cancel;
}

static void
circle_effect_instance_init (CircleEffect * self,
                             gpointer klass)
{
}

static GType
circle_effect_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (CircleEffectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) circle_effect_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CircleEffect), 0, (GInstanceInitFunc) circle_effect_instance_init, NULL };
	static const GInterfaceInfo spit_transitions_effect_info = { (GInterfaceInitFunc) circle_effect_spit_transitions_effect_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType circle_effect_type_id;
	circle_effect_type_id = g_type_register_static (G_TYPE_OBJECT, "CircleEffect", &g_define_type_info, 0);
	g_type_add_interface_static (circle_effect_type_id, SPIT_TRANSITIONS_TYPE_EFFECT, &spit_transitions_effect_info);
	return circle_effect_type_id;
}

GType
circle_effect_get_type (void)
{
	static volatile gsize circle_effect_type_id__once = 0;
	if (g_once_init_enter (&circle_effect_type_id__once)) {
		GType circle_effect_type_id;
		circle_effect_type_id = circle_effect_get_type_once ();
		g_once_init_leave (&circle_effect_type_id__once, circle_effect_type_id);
	}
	return circle_effect_type_id__once;
}

