/* SearchResults.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from SearchResults.vala, do not modify */

/* Copyright 2015-2024 elementary, Inc. <https://elementary.io>
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include <gtk/gtk.h>
#include "pantheon-files-core.h"
#include <glib-object.h>
#include <glib.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <zeitgeist.h>
#include <zeitgeist-datamodel.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <pango/pango.h>

#define FILES_VIEW_CHROME_SEARCH_RESULTS_ELLIPSIS_NAME "ELLIPSIS"
#define FILES_VIEW_CHROME_SEARCH_RESULTS_MAX_RESULTS 10
#define FILES_VIEW_CHROME_SEARCH_RESULTS_MAX_DEPTH 5
#define FILES_VIEW_CHROME_SEARCH_RESULTS_DELAY_ADDING_RESULTS 150
#define FILES_VIEW_CHROME_SEARCH_RESULTS_ATTRIBUTES G_FILE_ATTRIBUTE_STANDARD_NAME "," G_FILE_ATTRIBUTE_STANDARD_DISPLAY_NAME "," G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE "," G_FILE_ATTRIBUTE_STANDARD_IS_HIDDEN "," G_FILE_ATTRIBUTE_STANDARD_TYPE "," G_FILE_ATTRIBUTE_STANDARD_ICON
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define FILES_VIEW_CHROME_TYPE_SEARCH_RESULTS (files_view_chrome_search_results_get_type ())
#define FILES_VIEW_CHROME_SEARCH_RESULTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_VIEW_CHROME_TYPE_SEARCH_RESULTS, FilesViewChromeSearchResults))
#define FILES_VIEW_CHROME_SEARCH_RESULTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_VIEW_CHROME_TYPE_SEARCH_RESULTS, FilesViewChromeSearchResultsClass))
#define FILES_VIEW_CHROME_IS_SEARCH_RESULTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_VIEW_CHROME_TYPE_SEARCH_RESULTS))
#define FILES_VIEW_CHROME_IS_SEARCH_RESULTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_VIEW_CHROME_TYPE_SEARCH_RESULTS))
#define FILES_VIEW_CHROME_SEARCH_RESULTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_VIEW_CHROME_TYPE_SEARCH_RESULTS, FilesViewChromeSearchResultsClass))

typedef struct _FilesViewChromeSearchResults FilesViewChromeSearchResults;
typedef struct _FilesViewChromeSearchResultsClass FilesViewChromeSearchResultsClass;
typedef struct _FilesViewChromeSearchResultsPrivate FilesViewChromeSearchResultsPrivate;
enum  {
	FILES_VIEW_CHROME_SEARCH_RESULTS_0_PROPERTY,
	FILES_VIEW_CHROME_SEARCH_RESULTS_WORKING_PROPERTY,
	FILES_VIEW_CHROME_SEARCH_RESULTS_IS_ACTIVE_PROPERTY,
	FILES_VIEW_CHROME_SEARCH_RESULTS_N_RESULTS_PROPERTY,
	FILES_VIEW_CHROME_SEARCH_RESULTS_DELEGATE_WIDGET_PROPERTY,
	FILES_VIEW_CHROME_SEARCH_RESULTS_NUM_PROPERTIES
};
static GParamSpec* files_view_chrome_search_results_properties[FILES_VIEW_CHROME_SEARCH_RESULTS_NUM_PROPERTIES];
typedef enum  {
	FILES_VIEW_CHROME_SEARCH_RESULTS_CATEGORY_CURRENT_HEADER,
	FILES_VIEW_CHROME_SEARCH_RESULTS_CATEGORY_CURRENT_BEGINS,
	FILES_VIEW_CHROME_SEARCH_RESULTS_CATEGORY_CURRENT_CONTAINS,
	FILES_VIEW_CHROME_SEARCH_RESULTS_CATEGORY_CURRENT_ELLIPSIS,
	FILES_VIEW_CHROME_SEARCH_RESULTS_CATEGORY_DEEP_HEADER,
	FILES_VIEW_CHROME_SEARCH_RESULTS_CATEGORY_DEEP_BEGINS,
	FILES_VIEW_CHROME_SEARCH_RESULTS_CATEGORY_DEEP_CONTAINS,
	FILES_VIEW_CHROME_SEARCH_RESULTS_CATEGORY_DEEP_ELLIPSIS,
	FILES_VIEW_CHROME_SEARCH_RESULTS_CATEGORY_ZEITGEIST_HEADER,
	FILES_VIEW_CHROME_SEARCH_RESULTS_CATEGORY_ZEITGEIST_BEGINS,
	FILES_VIEW_CHROME_SEARCH_RESULTS_CATEGORY_ZEITGEIST_CONTAINS,
	FILES_VIEW_CHROME_SEARCH_RESULTS_CATEGORY_ZEITGEIST_ELLIPSIS,
	FILES_VIEW_CHROME_SEARCH_RESULTS_CATEGORY_BOOKMARK_HEADER,
	FILES_VIEW_CHROME_SEARCH_RESULTS_CATEGORY_BOOKMARK_BEGINS,
	FILES_VIEW_CHROME_SEARCH_RESULTS_CATEGORY_BOOKMARK_CONTAINS,
	FILES_VIEW_CHROME_SEARCH_RESULTS_CATEGORY_BOOKMARK_ELLIPSIS
} FilesViewChromeSearchResultsCategory;

#define FILES_VIEW_CHROME_SEARCH_RESULTS_TYPE_CATEGORY (files_view_chrome_search_results_category_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define __vala_GtkTreeIter_free0(var) ((var == NULL) ? NULL : (var = (_vala_GtkTreeIter_free (var), NULL)))
typedef struct _Block61Data Block61Data;
typedef struct _Block62Data Block62Data;

#define FILES_VIEW_CHROME_SEARCH_RESULTS_TYPE_MATCH (files_view_chrome_search_results_match_get_type ())
#define FILES_VIEW_CHROME_SEARCH_RESULTS_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_VIEW_CHROME_SEARCH_RESULTS_TYPE_MATCH, FilesViewChromeSearchResultsMatch))
#define FILES_VIEW_CHROME_SEARCH_RESULTS_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_VIEW_CHROME_SEARCH_RESULTS_TYPE_MATCH, FilesViewChromeSearchResultsMatchClass))
#define FILES_VIEW_CHROME_SEARCH_RESULTS_IS_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_VIEW_CHROME_SEARCH_RESULTS_TYPE_MATCH))
#define FILES_VIEW_CHROME_SEARCH_RESULTS_IS_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_VIEW_CHROME_SEARCH_RESULTS_TYPE_MATCH))
#define FILES_VIEW_CHROME_SEARCH_RESULTS_MATCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_VIEW_CHROME_SEARCH_RESULTS_TYPE_MATCH, FilesViewChromeSearchResultsMatchClass))

typedef struct _FilesViewChromeSearchResultsMatch FilesViewChromeSearchResultsMatch;
typedef struct _FilesViewChromeSearchResultsMatchClass FilesViewChromeSearchResultsMatchClass;
#define _g_thread_unref0(var) ((var == NULL) ? NULL : (var = (g_thread_unref (var), NULL)))
#define _files_bookmark_unref0(var) ((var == NULL) ? NULL : (var = (files_bookmark_unref (var), NULL)))
#define __vala_GtkTreePath_free0(var) ((var == NULL) ? NULL : (var = (_vala_GtkTreePath_free (var), NULL)))
typedef struct _Block63Data Block63Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _FilesViewChromeSearchResultsGetZgResultsData FilesViewChromeSearchResultsGetZgResultsData;
typedef struct _FilesViewChromeSearchResultsMatchPrivate FilesViewChromeSearchResultsMatchPrivate;
enum  {
	FILES_VIEW_CHROME_SEARCH_RESULTS_MATCH_0_PROPERTY,
	FILES_VIEW_CHROME_SEARCH_RESULTS_MATCH_NAME_PROPERTY,
	FILES_VIEW_CHROME_SEARCH_RESULTS_MATCH_MIME_PROPERTY,
	FILES_VIEW_CHROME_SEARCH_RESULTS_MATCH_PATH_STRING_PROPERTY,
	FILES_VIEW_CHROME_SEARCH_RESULTS_MATCH_ICON_PROPERTY,
	FILES_VIEW_CHROME_SEARCH_RESULTS_MATCH_FILE_PROPERTY,
	FILES_VIEW_CHROME_SEARCH_RESULTS_MATCH_SORTKEY_PROPERTY,
	FILES_VIEW_CHROME_SEARCH_RESULTS_MATCH_CATEGORY_PROPERTY,
	FILES_VIEW_CHROME_SEARCH_RESULTS_MATCH_NUM_PROPERTIES
};
static GParamSpec* files_view_chrome_search_results_match_properties[FILES_VIEW_CHROME_SEARCH_RESULTS_MATCH_NUM_PROPERTIES];

struct _FilesViewChromeSearchResults {
	GtkPopover parent_instance;
	FilesViewChromeSearchResultsPrivate * priv;
};

struct _FilesViewChromeSearchResultsClass {
	GtkPopoverClass parent_class;
};

struct _FilesViewChromeSearchResultsPrivate {
	gboolean _working;
	GtkWidget* parent;
	gint _n_results;
	GFile* current_root;
	gchar* search_term;
	GeeQueue* directory_queue;
	gulong waiting_handler;
	guint adding_timeout;
	gboolean allow_adding_results;
	GeeMap* waiting_results;
	GCancellable* current_operation;
	GCancellable* file_search_operation;
	ZeitgeistIndex* zg_index;
	GPtrArray* templates;
	gint current_count;
	gint deep_count;
	gint max_results;
	gint max_depth;
	gboolean local_search_finished;
	gboolean global_search_finished;
	GtkTreeIter* local_results;
	GtkTreeIter* deep_results;
	GtkTreeIter* zeitgeist_results;
	GtkTreeIter* bookmark_results;
	gchar* header_markup;
	gchar* result_location_markup;
	GtkTreeView* search_tree_view;
	GtkTreeStore* list;
	GtkTreeModelFilter* filter;
	GtkScrolledWindow* scroll;
	GtkWidget* _delegate_widget;
	GtkGestureMultiPress* search_tree_view_button_controller;
	GtkEventControllerKey* key_controller;
	guint search_timeout_id;
};

struct _Block61Data {
	int _ref_count_;
	FilesViewChromeSearchResults* self;
	gchar* term;
	GFile* root;
};

struct _Block62Data {
	int _ref_count_;
	FilesViewChromeSearchResults* self;
	gboolean include_hidden;
	GFile* folder;
};

struct _Block63Data {
	int _ref_count_;
	FilesViewChromeSearchResults* self;
	gboolean in_root;
	GeeLinkedList* new_results;
};

struct _FilesViewChromeSearchResultsGetZgResultsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FilesViewChromeSearchResults* self;
	gchar* term;
	ZeitgeistResultSet* results;
	ZeitgeistResultSet* _tmp0_;
	ZeitgeistIndex* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	ZeitgeistTimeRange* _tmp6_;
	ZeitgeistTimeRange* _tmp7_;
	GPtrArray* _tmp8_;
	GCancellable* _tmp9_;
	ZeitgeistResultSet* _tmp10_;
	ZeitgeistResultSet* _tmp11_;
	ZeitgeistResultSet* _tmp12_;
	GError* e;
	GError* _tmp13_;
	const gchar* _tmp14_;
	GeeLinkedList* matches;
	GeeLinkedList* _tmp15_;
	GFile* home;
	const gchar* _tmp16_;
	GFile* _tmp17_;
	FilesViewChromeSearchResultsCategory cat;
	gint i;
	gboolean _tmp18_;
	gboolean _tmp19_;
	ZeitgeistResultSet* _tmp20_;
	GCancellable* _tmp21_;
	ZeitgeistEvent* _result_;
	ZeitgeistResultSet* _tmp22_;
	ZeitgeistEvent* _tmp23_;
	ZeitgeistEvent* _tmp24_;
	GPtrArray* _tmp25_;
	GPtrArray* _tmp26_;
	gpointer* _tmp27_;
	gint _tmp27__length1;
	ZeitgeistSubject** subject_collection;
	gint subject_collection_length1;
	gint _subject_collection_size_;
	gint subject_it;
	ZeitgeistSubject* _tmp28_;
	ZeitgeistSubject* subject;
	GeeLinkedList* _tmp29_;
	FilesViewChromeSearchResultsMatch* _tmp30_;
	FilesViewChromeSearchResultsMatch* _tmp31_;
	GFile* file;
	ZeitgeistSubject* _tmp32_;
	const gchar* _tmp33_;
	const gchar* _tmp34_;
	GFile* _tmp35_;
	gboolean _tmp36_;
	GFile* _tmp37_;
	GFile* _tmp38_;
	gchar* _tmp39_;
	gchar* _tmp40_;
	GFile* _tmp41_;
	GFile* _tmp42_;
	GFile* _tmp43_;
	gchar* path_string;
	gchar* _tmp44_;
	GFile* parent;
	GFile* _tmp45_;
	GFile* _tmp46_;
	GFile* _tmp47_;
	GFile* _tmp48_;
	GFile* _tmp49_;
	GFile* _tmp50_;
	GFile* _tmp51_;
	GFile* _tmp52_;
	GFile* _tmp53_;
	const gchar* _tmp54_;
	gchar* _tmp55_;
	const gchar* _tmp56_;
	GFile* _tmp57_;
	gchar* _tmp58_;
	GFile* _tmp59_;
	gchar* _tmp60_;
	gchar* _tmp61_;
	const gchar* _tmp62_;
	gchar* _tmp63_;
	gboolean found;
	GeeLinkedList* _m_list;
	GeeLinkedList* _tmp64_;
	gint _m_size;
	GeeLinkedList* _tmp65_;
	gint _tmp66_;
	gint _tmp67_;
	gint _m_index;
	gint _tmp68_;
	gint _tmp69_;
	FilesViewChromeSearchResultsMatch* m;
	GeeLinkedList* _tmp70_;
	gpointer _tmp71_;
	FilesViewChromeSearchResultsMatch* _tmp72_;
	const gchar* _tmp73_;
	const gchar* _tmp74_;
	const gchar* _tmp75_;
	GFileInfo* info;
	GFile* _tmp76_;
	GCancellable* _tmp77_;
	GFileInfo* _tmp78_;
	gchar* name;
	GFileInfo* _tmp79_;
	const gchar* _tmp80_;
	gchar* _tmp81_;
	FilesViewChromeSearchResultsCategory _tmp82_;
	const gchar* _tmp83_;
	GeeLinkedList* _tmp84_;
	GFileInfo* _tmp85_;
	const gchar* _tmp86_;
	GFile* _tmp87_;
	GFile* _tmp88_;
	GFile* _tmp89_;
	FilesViewChromeSearchResultsMatch* _tmp90_;
	FilesViewChromeSearchResultsMatch* _tmp91_;
	gint _tmp92_;
	GCancellable* _tmp93_;
	GeeLinkedList* _tmp94_;
	GtkTreeIter* _tmp95_;
	GtkTreeIter _tmp96_;
	GError* _inner_error0_;
};

struct _FilesViewChromeSearchResultsMatch {
	GObject parent_instance;
	FilesViewChromeSearchResultsMatchPrivate * priv;
};

struct _FilesViewChromeSearchResultsMatchClass {
	GObjectClass parent_class;
};

struct _FilesViewChromeSearchResultsMatchPrivate {
	gchar* _name;
	gchar* _mime;
	gchar* _path_string;
	GIcon* _icon;
	GFile* _file;
	gchar* _sortkey;
	FilesViewChromeSearchResultsCategory _category;
};

static gint FilesViewChromeSearchResults_private_offset;
static gpointer files_view_chrome_search_results_parent_class = NULL;
static gint FilesViewChromeSearchResultsMatch_private_offset;
static gpointer files_view_chrome_search_results_match_parent_class = NULL;
static FilesViewChromeSearchableIface * files_view_chrome_search_results_files_view_chrome_searchable_parent_iface = NULL;

VALA_EXTERN GType files_view_chrome_search_results_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesViewChromeSearchResults, g_object_unref)
static GType files_view_chrome_search_results_category_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static gchar* files_view_chrome_search_results_category_to_string (FilesViewChromeSearchResultsCategory self);
static void _vala_GtkTreeIter_free (GtkTreeIter* self);
VALA_EXTERN FilesViewChromeSearchResults* files_view_chrome_search_results_new (GtkWidget* _delegate_widget);
VALA_EXTERN FilesViewChromeSearchResults* files_view_chrome_search_results_construct (GType object_type,
                                                                          GtkWidget* _delegate_widget);
static void files_view_chrome_search_results_update_category_headers (FilesViewChromeSearchResults* self);
static void files_view_chrome_search_results_real_cancel (FilesViewChromeSearchable* base);
VALA_EXTERN void files_view_chrome_search_results_clear (FilesViewChromeSearchResults* self);
VALA_EXTERN void files_view_chrome_search_results_begin_search (FilesViewChromeSearchResults* self,
                                                    const gchar* term,
                                                    GFile* root);
static Block61Data* block61_data_ref (Block61Data* _data61_);
static void block61_data_unref (void * _userdata_);
static gboolean __lambda28_ (Block61Data* _data61_);
static gboolean ___lambda28__gsource_func (gpointer self);
static void files_view_chrome_search_results_real_search (FilesViewChromeSearchable* base,
                                                   const gchar* term,
                                                   GFile* folder);
static Block62Data* block62_data_ref (Block62Data* _data62_);
static void block62_data_unref (void * _userdata_);
static void files_view_chrome_search_results_set_working (FilesViewChromeSearchResults* self,
                                                   gboolean value);
VALA_EXTERN gboolean files_view_chrome_search_results_get_working (FilesViewChromeSearchResults* self);
static void ___lambda29_ (Block62Data* _data62_);
static void ____lambda29__g_object_notify (GObject* _sender,
                                    GParamSpec* pspec,
                                    gpointer self);
static GtkTreeIter* _vala_GtkTreeIter_copy (GtkTreeIter* self);
static void _g_cancellable_cancel_g_cancellable_cancelled (GCancellable* _sender,
                                                    gpointer self);
static void files_view_chrome_search_results_set_n_results (FilesViewChromeSearchResults* self,
                                                     gint value);
static gboolean __lambda30_ (FilesViewChromeSearchResults* self);
static GType files_view_chrome_search_results_match_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesViewChromeSearchResultsMatch, g_object_unref)
static void files_view_chrome_search_results_add_results (FilesViewChromeSearchResults* self,
                                                   GeeList* new_results,
                                                   GtkTreeIter* parent);
static gboolean files_view_chrome_search_results_send_search_finished (FilesViewChromeSearchResults* self);
static gboolean ___lambda30__gsource_func (gpointer self);
static void* __lambda31_ (Block62Data* _data62_);
static void files_view_chrome_search_results_visit (FilesViewChromeSearchResults* self,
                                             const gchar* term,
                                             gboolean include_hidden,
                                             GCancellable* cancel,
                                             GFile* root_folder);
static gboolean _files_view_chrome_search_results_send_search_finished_gsource_func (gpointer self);
static gpointer ___lambda31__gthread_func (gpointer self);
static void files_view_chrome_search_results_get_zg_results (FilesViewChromeSearchResults* self,
                                                      const gchar* term,
                                                      GAsyncReadyCallback _callback_,
                                                      gpointer _user_data_);
static void files_view_chrome_search_results_get_zg_results_finish (FilesViewChromeSearchResults* self,
                                                             GAsyncResult* _res_);
static gboolean files_view_chrome_search_results_term_matches (FilesViewChromeSearchResults* self,
                                                        const gchar* term,
                                                        const gchar* name,
                                                        gboolean* begins_with);
static FilesViewChromeSearchResultsMatch* files_view_chrome_search_results_match_new_from_bookmark (FilesBookmark* bookmark,
                                                                                             FilesViewChromeSearchResultsCategory category);
static FilesViewChromeSearchResultsMatch* files_view_chrome_search_results_match_construct_from_bookmark (GType object_type,
                                                                                                   FilesBookmark* bookmark,
                                                                                                   FilesViewChromeSearchResultsCategory category);
static void files_view_chrome_search_results_on_cursor_changed (FilesViewChromeSearchResults* self);
static GtkTreePath* _vala_GtkTreePath_copy (GtkTreePath* self);
static void _vala_GtkTreePath_free (GtkTreePath* self);
static GFile* files_view_chrome_search_results_get_file_at_iter (FilesViewChromeSearchResults* self,
                                                          GtkTreeIter* iter);
static void __vala_GtkTreePath_free0_ (gpointer var);
static inline void _g_list_free___vala_GtkTreePath_free0_ (GList* self);
static gboolean files_view_chrome_search_results_on_key_pressed_event (FilesViewChromeSearchResults* self,
                                                                guint keyval,
                                                                guint kecode,
                                                                GdkModifierType state);
VALA_EXTERN GtkWidget* files_view_chrome_search_results_get_delegate_widget (FilesViewChromeSearchResults* self);
static void files_view_chrome_search_results_accept (FilesViewChromeSearchResults* self,
                                              GtkTreeIter* accepted,
                                              gboolean activate);
static gboolean files_view_chrome_search_results_list_empty (FilesViewChromeSearchResults* self);
static void files_view_chrome_search_results_select_last (FilesViewChromeSearchResults* self);
static void files_view_chrome_search_results_select_first (FilesViewChromeSearchResults* self);
static void files_view_chrome_search_results_select_adjacent (FilesViewChromeSearchResults* self,
                                                       gboolean up);
static void files_view_chrome_search_results_select_iter (FilesViewChromeSearchResults* self,
                                                   GtkTreeIter* iter);
static gboolean files_view_chrome_search_results_get_iter_at_cursor (FilesViewChromeSearchResults* self,
                                                              GtkTreeIter* iter);
static gint files_view_chrome_search_results_n_matches (FilesViewChromeSearchResults* self,
                                                 gint* n_headers);
static void files_view_chrome_search_results_resize_popup (FilesViewChromeSearchResults* self);
static void files_view_chrome_search_results_disconnect_view_cursor_changed_signal (FilesViewChromeSearchResults* self);
static void files_view_chrome_search_results_connect_view_cursor_changed_signal (FilesViewChromeSearchResults* self);
static gboolean _gtk_tree_iter_equal (const GtkTreeIter * s1,
                               const GtkTreeIter * s2);
static GFile* files_view_chrome_search_results_match_get_file (FilesViewChromeSearchResultsMatch* self);
static const gchar* files_view_chrome_search_results_match_get_path_string (FilesViewChromeSearchResultsMatch* self);
static const gchar* files_view_chrome_search_results_match_get_name (FilesViewChromeSearchResultsMatch* self);
static GIcon* files_view_chrome_search_results_match_get_icon (FilesViewChromeSearchResultsMatch* self);
static const gchar* files_view_chrome_search_results_match_get_sortkey (FilesViewChromeSearchResultsMatch* self);
VALA_EXTERN gint files_view_chrome_search_results_get_n_results (FilesViewChromeSearchResults* self);
static Block63Data* block63_data_ref (Block63Data* _data63_);
static void block63_data_unref (void * _userdata_);
static FilesViewChromeSearchResultsMatch* files_view_chrome_search_results_match_new (GFileInfo* info,
                                                                               const gchar* path_string,
                                                                               GFile* parent,
                                                                               FilesViewChromeSearchResultsCategory category);
static FilesViewChromeSearchResultsMatch* files_view_chrome_search_results_match_construct (GType object_type,
                                                                                     GFileInfo* info,
                                                                                     const gchar* path_string,
                                                                                     GFile* parent,
                                                                                     FilesViewChromeSearchResultsCategory category);
static FilesViewChromeSearchResultsMatch* files_view_chrome_search_results_match_new_ellipsis (FilesViewChromeSearchResultsCategory category);
static FilesViewChromeSearchResultsMatch* files_view_chrome_search_results_match_construct_ellipsis (GType object_type,
                                                                                              FilesViewChromeSearchResultsCategory category);
static gboolean ____lambda32_ (Block63Data* _data63_);
static gboolean _____lambda32__gsource_func (gpointer self);
static void files_view_chrome_search_results_get_zg_results_data_free (gpointer _data);
static gboolean files_view_chrome_search_results_get_zg_results_co (FilesViewChromeSearchResultsGetZgResultsData* _data_);
static void files_view_chrome_search_results_get_zg_results_ready (GObject* source_object,
                                                            GAsyncResult* _res_,
                                                            gpointer _user_data_);
static void _files_view_chrome_search_results_on_cursor_changed_gtk_tree_view_cursor_changed (GtkTreeView* _sender,
                                                                                       gpointer self);
VALA_EXTERN gboolean files_view_chrome_search_results_get_is_active (FilesViewChromeSearchResults* self);
static void files_view_chrome_search_results_set_delegate_widget (FilesViewChromeSearchResults* self,
                                                           GtkWidget* value);
static void files_view_chrome_search_results_match_set_name (FilesViewChromeSearchResultsMatch* self,
                                                      const gchar* value);
static const gchar* files_view_chrome_search_results_match_get_mime (FilesViewChromeSearchResultsMatch* self);
static void files_view_chrome_search_results_match_set_mime (FilesViewChromeSearchResultsMatch* self,
                                                      const gchar* value);
static void files_view_chrome_search_results_match_set_path_string (FilesViewChromeSearchResultsMatch* self,
                                                             const gchar* value);
static void files_view_chrome_search_results_match_set_icon (FilesViewChromeSearchResultsMatch* self,
                                                      GIcon* value);
static void files_view_chrome_search_results_match_set_file (FilesViewChromeSearchResultsMatch* self,
                                                      GFile* value);
static void files_view_chrome_search_results_match_set_sortkey (FilesViewChromeSearchResultsMatch* self,
                                                         const gchar* value);
static FilesViewChromeSearchResultsCategory files_view_chrome_search_results_match_get_category (FilesViewChromeSearchResultsMatch* self);
static void files_view_chrome_search_results_match_set_category (FilesViewChromeSearchResultsMatch* self,
                                                          FilesViewChromeSearchResultsCategory value);
static void files_view_chrome_search_results_match_finalize (GObject * obj);
static GType files_view_chrome_search_results_match_get_type_once (void);
static void _vala_files_view_chrome_search_results_match_get_property (GObject * object,
                                                                guint property_id,
                                                                GValue * value,
                                                                GParamSpec * pspec);
static void _vala_files_view_chrome_search_results_match_set_property (GObject * object,
                                                                guint property_id,
                                                                const GValue * value,
                                                                GParamSpec * pspec);
static GObject * files_view_chrome_search_results_constructor (GType type,
                                                        guint n_construct_properties,
                                                        GObjectConstructParam * construct_properties);
static void _g_object_unref0_ (gpointer var);
static gboolean _files_view_chrome_search_results___lambda33_ (FilesViewChromeSearchResults* self,
                                                        GtkTreeSelection* selection,
                                                        GtkTreeModel* list,
                                                        GtkTreePath* path,
                                                        gboolean path_selected);
static gboolean __files_view_chrome_search_results___lambda33__gtk_tree_selection_func (GtkTreeSelection* selection,
                                                                                 GtkTreeModel* model,
                                                                                 GtkTreePath* path,
                                                                                 gboolean path_currently_selected,
                                                                                 gpointer self);
static gboolean _files_view_chrome_search_results___lambda34_ (FilesViewChromeSearchResults* self,
                                                        GtkTreeModel* model,
                                                        GtkTreeIter* iter);
static gboolean __files_view_chrome_search_results___lambda34__gtk_tree_model_filter_visible_func (GtkTreeModel* model,
                                                                                            GtkTreeIter* iter,
                                                                                            gpointer self);
static void _files_view_chrome_search_results___lambda35_ (FilesViewChromeSearchResults* self,
                                                    GtkTreePath* path,
                                                    GtkTreeIter* iter);
static void __files_view_chrome_search_results___lambda35__gtk_tree_model_row_changed (GtkTreeModel* _sender,
                                                                                GtkTreePath* path,
                                                                                GtkTreeIter* iter,
                                                                                gpointer self);
static void _files_view_chrome_search_results___lambda36_ (FilesViewChromeSearchResults* self,
                                                    gint n_press,
                                                    gdouble x,
                                                    gdouble y);
static void __files_view_chrome_search_results___lambda36__gtk_gesture_multi_press_pressed (GtkGestureMultiPress* _sender,
                                                                                     gint n_press,
                                                                                     gdouble x,
                                                                                     gdouble y,
                                                                                     gpointer self);
static gboolean _files_view_chrome_search_results_on_key_pressed_event_gtk_event_controller_key_key_pressed (GtkEventControllerKey* _sender,
                                                                                                      guint keyval,
                                                                                                      guint keycode,
                                                                                                      GdkModifierType state,
                                                                                                      gpointer self);
static void files_view_chrome_search_results_finalize (GObject * obj);
static GType files_view_chrome_search_results_get_type_once (void);
static void _vala_files_view_chrome_search_results_get_property (GObject * object,
                                                          guint property_id,
                                                          GValue * value,
                                                          GParamSpec * pspec);
static void _vala_files_view_chrome_search_results_set_property (GObject * object,
                                                          guint property_id,
                                                          const GValue * value,
                                                          GParamSpec * pspec);

static inline gpointer
files_view_chrome_search_results_get_instance_private (FilesViewChromeSearchResults* self)
{
	return G_STRUCT_MEMBER_P (self, FilesViewChromeSearchResults_private_offset);
}

static gunichar
string_get_char (const gchar* self,
                 glong index)
{
	gunichar result;
	g_return_val_if_fail (self != NULL, 0U);
	result = g_utf8_get_char (((gchar*) self) + index);
	return result;
}

static gchar*
g_unichar_to_string (gunichar self)
{
	gchar* str = NULL;
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, 7);
	str = (gchar*) _tmp0_;
	g_unichar_to_utf8 (self, str);
	result = str;
	return result;
}

static gchar*
files_view_chrome_search_results_category_to_string (FilesViewChromeSearchResultsCategory self)
{
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = g_unichar_to_string (string_get_char (G_CSET_A_2_Z, (glong) ((guint) self)));
	result = _tmp0_;
	return result;
}

 G_GNUC_NO_INLINE static GType
files_view_chrome_search_results_category_get_type_once (void)
{
	static const GEnumValue values[] = {{FILES_VIEW_CHROME_SEARCH_RESULTS_CATEGORY_CURRENT_HEADER, "FILES_VIEW_CHROME_SEARCH_RESULTS_CATEGORY_CURRENT_HEADER", "current-header"}, {FILES_VIEW_CHROME_SEARCH_RESULTS_CATEGORY_CURRENT_BEGINS, "FILES_VIEW_CHROME_SEARCH_RESULTS_CATEGORY_CURRENT_BEGINS", "current-begins"}, {FILES_VIEW_CHROME_SEARCH_RESULTS_CATEGORY_CURRENT_CONTAINS, "FILES_VIEW_CHROME_SEARCH_RESULTS_CATEGORY_CURRENT_CONTAINS", "current-contains"}, {FILES_VIEW_CHROME_SEARCH_RESULTS_CATEGORY_CURRENT_ELLIPSIS, "FILES_VIEW_CHROME_SEARCH_RESULTS_CATEGORY_CURRENT_ELLIPSIS", "current-ellipsis"}, {FILES_VIEW_CHROME_SEARCH_RESULTS_CATEGORY_DEEP_HEADER, "FILES_VIEW_CHROME_SEARCH_RESULTS_CATEGORY_DEEP_HEADER", "deep-header"}, {FILES_VIEW_CHROME_SEARCH_RESULTS_CATEGORY_DEEP_BEGINS, "FILES_VIEW_CHROME_SEARCH_RESULTS_CATEGORY_DEEP_BEGINS", "deep-begins"}, {FILES_VIEW_CHROME_SEARCH_RESULTS_CATEGORY_DEEP_CONTAINS, "FILES_VIEW_CHROME_SEARCH_RESULTS_CATEGORY_DEEP_CONTAINS", "deep-contains"}, {FILES_VIEW_CHROME_SEARCH_RESULTS_CATEGORY_DEEP_ELLIPSIS, "FILES_VIEW_CHROME_SEARCH_RESULTS_CATEGORY_DEEP_ELLIPSIS", "deep-ellipsis"}, {FILES_VIEW_CHROME_SEARCH_RESULTS_CATEGORY_ZEITGEIST_HEADER, "FILES_VIEW_CHROME_SEARCH_RESULTS_CATEGORY_ZEITGEIST_HEADER", "zeitgeist-header"}, {FILES_VIEW_CHROME_SEARCH_RESULTS_CATEGORY_ZEITGEIST_BEGINS, "FILES_VIEW_CHROME_SEARCH_RESULTS_CATEGORY_ZEITGEIST_BEGINS", "zeitgeist-begins"}, {FILES_VIEW_CHROME_SEARCH_RESULTS_CATEGORY_ZEITGEIST_CONTAINS, "FILES_VIEW_CHROME_SEARCH_RESULTS_CATEGORY_ZEITGEIST_CONTAINS", "zeitgeist-contains"}, {FILES_VIEW_CHROME_SEARCH_RESULTS_CATEGORY_ZEITGEIST_ELLIPSIS, "FILES_VIEW_CHROME_SEARCH_RESULTS_CATEGORY_ZEITGEIST_ELLIPSIS", "zeitgeist-ellipsis"}, {FILES_VIEW_CHROME_SEARCH_RESULTS_CATEGORY_BOOKMARK_HEADER, "FILES_VIEW_CHROME_SEARCH_RESULTS_CATEGORY_BOOKMARK_HEADER", "bookmark-header"}, {FILES_VIEW_CHROME_SEARCH_RESULTS_CATEGORY_BOOKMARK_BEGINS, "FILES_VIEW_CHROME_SEARCH_RESULTS_CATEGORY_BOOKMARK_BEGINS", "bookmark-begins"}, {FILES_VIEW_CHROME_SEARCH_RESULTS_CATEGORY_BOOKMARK_CONTAINS, "FILES_VIEW_CHROME_SEARCH_RESULTS_CATEGORY_BOOKMARK_CONTAINS", "bookmark-contains"}, {FILES_VIEW_CHROME_SEARCH_RESULTS_CATEGORY_BOOKMARK_ELLIPSIS, "FILES_VIEW_CHROME_SEARCH_RESULTS_CATEGORY_BOOKMARK_ELLIPSIS", "bookmark-ellipsis"}, {0, NULL, NULL}};
	GType files_view_chrome_search_results_category_type_id;
	files_view_chrome_search_results_category_type_id = g_enum_register_static ("FilesViewChromeSearchResultsCategory", values);
	return files_view_chrome_search_results_category_type_id;
}

static GType
files_view_chrome_search_results_category_get_type (void)
{
	static volatile gsize files_view_chrome_search_results_category_type_id__once = 0;
	if (g_once_init_enter (&files_view_chrome_search_results_category_type_id__once)) {
		GType files_view_chrome_search_results_category_type_id;
		files_view_chrome_search_results_category_type_id = files_view_chrome_search_results_category_get_type_once ();
		g_once_init_leave (&files_view_chrome_search_results_category_type_id__once, files_view_chrome_search_results_category_type_id);
	}
	return files_view_chrome_search_results_category_type_id__once;
}

static void
_vala_GtkTreeIter_free (GtkTreeIter* self)
{
	g_boxed_free (gtk_tree_iter_get_type (), self);
}

FilesViewChromeSearchResults*
files_view_chrome_search_results_construct (GType object_type,
                                            GtkWidget* _delegate_widget)
{
	FilesViewChromeSearchResults * self = NULL;
	g_return_val_if_fail (_delegate_widget != NULL, NULL);
	self = (FilesViewChromeSearchResults*) g_object_new (object_type, "delegate-widget", _delegate_widget, NULL);
	return self;
}

FilesViewChromeSearchResults*
files_view_chrome_search_results_new (GtkWidget* _delegate_widget)
{
	return files_view_chrome_search_results_construct (FILES_VIEW_CHROME_TYPE_SEARCH_RESULTS, _delegate_widget);
}

static void
files_view_chrome_search_results_update_category_headers (FilesViewChromeSearchResults* self)
{
	GdkRGBA rgba = {0};
	gchar* color = NULL;
	gchar* _tmp0_;
	gchar* header_markup_start = NULL;
	gchar* _tmp1_;
	gchar* result_location_markup_start = NULL;
	gchar* _tmp2_;
	gboolean colored = FALSE;
	GtkStyleContext* _tmp3_;
	GdkRGBA _tmp4_ = {0};
	gboolean _tmp5_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	GtkTreeStore* _tmp21_;
	GtkTreeIter* _tmp22_;
	const gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	GtkTreeIter _tmp28_;
	GtkTreeStore* _tmp29_;
	GtkTreeIter* _tmp30_;
	const gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	GtkTreeIter _tmp36_;
	GtkTreeStore* _tmp37_;
	GtkTreeIter* _tmp38_;
	const gchar* _tmp39_;
	gchar* _tmp40_;
	gchar* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	GtkTreeIter _tmp44_;
	GtkTreeStore* _tmp45_;
	GtkTreeIter* _tmp46_;
	const gchar* _tmp47_;
	gchar* _tmp48_;
	gchar* _tmp49_;
	gchar* _tmp50_;
	gchar* _tmp51_;
	GtkTreeIter _tmp52_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("");
	color = _tmp0_;
	_tmp1_ = g_strdup ("<span weight = 'bold' %s>");
	header_markup_start = _tmp1_;
	_tmp2_ = g_strdup ("<span %s>");
	result_location_markup_start = _tmp2_;
	_tmp3_ = gtk_widget_get_style_context ((GtkWidget*) self);
	_tmp5_ = gtk_style_context_lookup_color (_tmp3_, "placeholder_text_color", &_tmp4_);
	rgba = _tmp4_;
	colored = _tmp5_;
	if (colored) {
		GdkRGBA _tmp6_;
		GdkRGBA _tmp7_;
		GdkRGBA _tmp8_;
		GdkRGBA _tmp9_;
		gchar* _tmp10_;
		_tmp6_ = rgba;
		_tmp7_ = rgba;
		_tmp8_ = rgba;
		_tmp9_ = rgba;
		_tmp10_ = g_strdup_printf ("color='#%2x%2x%2x%2x'", (guint) (_tmp6_.red * 255), (guint) (_tmp7_.green * 255), (guint) (_tmp8_.blue * 255), (guint) (_tmp9_.alpha * 255));
		_g_free0 (color);
		color = _tmp10_;
	}
	_tmp11_ = header_markup_start;
	_tmp12_ = color;
	_tmp13_ = g_strdup_printf (_tmp11_, _tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = g_strconcat (_tmp14_, "%s</span>", NULL);
	_g_free0 (self->priv->header_markup);
	self->priv->header_markup = _tmp15_;
	_g_free0 (_tmp14_);
	_tmp16_ = result_location_markup_start;
	_tmp17_ = color;
	_tmp18_ = g_strdup_printf (_tmp16_, _tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = g_strconcat (_tmp19_, "%s</span>", NULL);
	_g_free0 (self->priv->result_location_markup);
	self->priv->result_location_markup = _tmp20_;
	_g_free0 (_tmp19_);
	_tmp21_ = self->priv->list;
	_tmp22_ = self->priv->local_results;
	_tmp23_ = self->priv->header_markup;
	_tmp24_ = g_strdup_printf (_tmp23_, _ ("In This Folder"));
	_tmp25_ = _tmp24_;
	_tmp26_ = files_view_chrome_search_results_category_to_string (FILES_VIEW_CHROME_SEARCH_RESULTS_CATEGORY_CURRENT_HEADER);
	_tmp27_ = _tmp26_;
	_tmp28_ = *_tmp22_;
	gtk_tree_store_set (_tmp21_, &_tmp28_, 0, _tmp25_, 5, _tmp27_, -1);
	_g_free0 (_tmp27_);
	_g_free0 (_tmp25_);
	_tmp29_ = self->priv->list;
	_tmp30_ = self->priv->deep_results;
	_tmp31_ = self->priv->header_markup;
	_tmp32_ = g_strdup_printf (_tmp31_, _ ("Below This Folder"));
	_tmp33_ = _tmp32_;
	_tmp34_ = files_view_chrome_search_results_category_to_string (FILES_VIEW_CHROME_SEARCH_RESULTS_CATEGORY_CURRENT_HEADER);
	_tmp35_ = _tmp34_;
	_tmp36_ = *_tmp30_;
	gtk_tree_store_set (_tmp29_, &_tmp36_, 0, _tmp33_, 5, _tmp35_, -1);
	_g_free0 (_tmp35_);
	_g_free0 (_tmp33_);
	_tmp37_ = self->priv->list;
	_tmp38_ = self->priv->bookmark_results;
	_tmp39_ = self->priv->header_markup;
	_tmp40_ = g_strdup_printf (_tmp39_, _ ("Bookmarks"));
	_tmp41_ = _tmp40_;
	_tmp42_ = files_view_chrome_search_results_category_to_string (FILES_VIEW_CHROME_SEARCH_RESULTS_CATEGORY_CURRENT_HEADER);
	_tmp43_ = _tmp42_;
	_tmp44_ = *_tmp38_;
	gtk_tree_store_set (_tmp37_, &_tmp44_, 0, _tmp41_, 5, _tmp43_, -1);
	_g_free0 (_tmp43_);
	_g_free0 (_tmp41_);
	_tmp45_ = self->priv->list;
	_tmp46_ = self->priv->zeitgeist_results;
	_tmp47_ = self->priv->header_markup;
	_tmp48_ = g_strdup_printf (_tmp47_, _ ("Recently Used"));
	_tmp49_ = _tmp48_;
	_tmp50_ = files_view_chrome_search_results_category_to_string (FILES_VIEW_CHROME_SEARCH_RESULTS_CATEGORY_CURRENT_HEADER);
	_tmp51_ = _tmp50_;
	_tmp52_ = *_tmp46_;
	gtk_tree_store_set (_tmp45_, &_tmp52_, 0, _tmp49_, 5, _tmp51_, -1);
	_g_free0 (_tmp51_);
	_g_free0 (_tmp49_);
	_g_free0 (result_location_markup_start);
	_g_free0 (header_markup_start);
	_g_free0 (color);
}

/** Search interface functions **/
static void
files_view_chrome_search_results_real_cancel (FilesViewChromeSearchable* base)
{
	FilesViewChromeSearchResults * self;
	GCancellable* _tmp0_;
	gchar* _tmp2_;
	self = (FilesViewChromeSearchResults*) base;
	gtk_popover_popdown ((GtkPopover*) self);
	_tmp0_ = self->priv->current_operation;
	if (_tmp0_ != NULL) {
		GCancellable* _tmp1_;
		_tmp1_ = self->priv->current_operation;
		g_cancellable_cancel (_tmp1_);
	}
	files_view_chrome_search_results_clear (self);
	_tmp2_ = g_strdup ("");
	_g_free0 (self->priv->search_term);
	self->priv->search_term = _tmp2_;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block61Data*
block61_data_ref (Block61Data* _data61_)
{
	g_atomic_int_inc (&_data61_->_ref_count_);
	return _data61_;
}

static void
block61_data_unref (void * _userdata_)
{
	Block61Data* _data61_;
	_data61_ = (Block61Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data61_->_ref_count_)) {
		FilesViewChromeSearchResults* self;
		self = _data61_->self;
		_g_free0 (_data61_->term);
		_g_object_unref0 (_data61_->root);
		_g_object_unref0 (self);
		g_slice_free (Block61Data, _data61_);
	}
}

static gboolean
__lambda28_ (Block61Data* _data61_)
{
	FilesViewChromeSearchResults* self;
	gboolean result;
	self = _data61_->self;
	files_view_chrome_searchable_search ((FilesViewChromeSearchable*) self, _data61_->term, _data61_->root);
	self->priv->search_timeout_id = (guint) 0;
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda28__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda28_ (self);
	return result;
}

void
files_view_chrome_search_results_begin_search (FilesViewChromeSearchResults* self,
                                               const gchar* term,
                                               GFile* root)
{
	Block61Data* _data61_;
	gchar* _tmp0_;
	GFile* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (term != NULL);
	g_return_if_fail (root != NULL);
	_data61_ = g_slice_new0 (Block61Data);
	_data61_->_ref_count_ = 1;
	_data61_->self = g_object_ref (self);
	_tmp0_ = g_strdup (term);
	_g_free0 (_data61_->term);
	_data61_->term = _tmp0_;
	_tmp1_ = _g_object_ref0 (root);
	_g_object_unref0 (_data61_->root);
	_data61_->root = _tmp1_;
	if (self->priv->search_timeout_id > ((guint) 0)) {
		g_source_remove (self->priv->search_timeout_id);
	}
	gtk_popover_popdown ((GtkPopover*) self);
	self->priv->search_timeout_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 100, ___lambda28__gsource_func, block61_data_ref (_data61_), block61_data_unref);
	block61_data_unref (_data61_);
	_data61_ = NULL;
}

static Block62Data*
block62_data_ref (Block62Data* _data62_)
{
	g_atomic_int_inc (&_data62_->_ref_count_);
	return _data62_;
}

static void
block62_data_unref (void * _userdata_)
{
	Block62Data* _data62_;
	_data62_ = (Block62Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data62_->_ref_count_)) {
		FilesViewChromeSearchResults* self;
		self = _data62_->self;
		_g_object_unref0 (_data62_->folder);
		_g_object_unref0 (self);
		g_slice_free (Block62Data, _data62_);
	}
}

static void
___lambda29_ (Block62Data* _data62_)
{
	FilesViewChromeSearchResults* self;
	const gchar* _tmp0_;
	self = _data62_->self;
	g_signal_handler_disconnect (self, self->priv->waiting_handler);
	self->priv->waiting_handler = (gulong) 0;
	_tmp0_ = self->priv->search_term;
	files_view_chrome_searchable_search ((FilesViewChromeSearchable*) self, _tmp0_, _data62_->folder);
}

static void
____lambda29__g_object_notify (GObject* _sender,
                               GParamSpec* pspec,
                               gpointer self)
{
	___lambda29_ (self);
}

static GtkTreeIter*
_vala_GtkTreeIter_copy (GtkTreeIter* self)
{
	return g_boxed_copy (gtk_tree_iter_get_type (), self);
}

static void
_g_cancellable_cancel_g_cancellable_cancelled (GCancellable* _sender,
                                               gpointer self)
{
	g_cancellable_cancel ((GCancellable*) self);
}

static gboolean
__lambda30_ (FilesViewChromeSearchResults* self)
{
	GeeMapIterator* it = NULL;
	GeeMap* _tmp0_;
	GeeMapIterator* _tmp1_;
	gboolean result;
	self->priv->adding_timeout = (guint) 0;
	self->priv->allow_adding_results = TRUE;
	_tmp0_ = self->priv->waiting_results;
	_tmp1_ = gee_map_map_iterator (_tmp0_);
	it = _tmp1_;
	while (TRUE) {
		GeeMapIterator* _tmp2_;
		GeeMapIterator* _tmp3_;
		gpointer _tmp4_;
		GeeList* _tmp5_;
		GeeMapIterator* _tmp6_;
		gpointer _tmp7_;
		GtkTreeIter* _tmp8_;
		GtkTreeIter _tmp9_;
		_tmp2_ = it;
		if (!gee_map_iterator_next (_tmp2_)) {
			break;
		}
		_tmp3_ = it;
		_tmp4_ = gee_map_iterator_get_value (_tmp3_);
		_tmp5_ = (GeeList*) _tmp4_;
		_tmp6_ = it;
		_tmp7_ = gee_map_iterator_get_key (_tmp6_);
		_tmp8_ = (GtkTreeIter*) _tmp7_;
		_tmp9_ = *_tmp8_;
		files_view_chrome_search_results_add_results (self, _tmp5_, &_tmp9_);
		__vala_GtkTreeIter_free0 (_tmp8_);
		_g_object_unref0 (_tmp5_);
	}
	files_view_chrome_search_results_send_search_finished (self);
	result = G_SOURCE_REMOVE;
	_g_object_unref0 (it);
	return result;
}

static gboolean
___lambda30__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda30_ ((FilesViewChromeSearchResults*) self);
	return result;
}

static gboolean
_files_view_chrome_search_results_send_search_finished_gsource_func (gpointer self)
{
	gboolean result;
	result = files_view_chrome_search_results_send_search_finished ((FilesViewChromeSearchResults*) self);
	return result;
}

static void*
__lambda31_ (Block62Data* _data62_)
{
	FilesViewChromeSearchResults* self;
	void* result;
	self = _data62_->self;
	self->priv->local_search_finished = FALSE;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		GCancellable* _tmp1_;
		const gchar* _tmp5_;
		GCancellable* _tmp6_;
		_tmp1_ = self->priv->file_search_operation;
		if (!g_cancellable_is_cancelled (_tmp1_)) {
			GeeQueue* _tmp2_;
			gint _tmp3_;
			gint _tmp4_;
			_tmp2_ = self->priv->directory_queue;
			_tmp3_ = gee_collection_get_size ((GeeCollection*) _tmp2_);
			_tmp4_ = _tmp3_;
			_tmp0_ = _tmp4_ > 0;
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		_tmp5_ = self->priv->search_term;
		_tmp6_ = self->priv->file_search_operation;
		files_view_chrome_search_results_visit (self, _tmp5_, _data62_->include_hidden, _tmp6_, _data62_->folder);
	}
	self->priv->local_search_finished = TRUE;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _files_view_chrome_search_results_send_search_finished_gsource_func, g_object_ref (self), g_object_unref);
	result = NULL;
	return result;
}

static gpointer
___lambda31__gthread_func (gpointer self)
{
	gpointer result;
	result = __lambda31_ (self);
	block62_data_unref (self);
	return result;
}

static gpointer
_files_bookmark_ref0 (gpointer self)
{
	return self ? files_bookmark_ref (self) : NULL;
}

static void
files_view_chrome_search_results_real_search (FilesViewChromeSearchable* base,
                                              const gchar* term,
                                              GFile* folder)
{
	FilesViewChromeSearchResults * self;
	Block62Data* _data62_;
	GFile* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gboolean _tmp6_;
	GCancellable* _tmp10_;
	gboolean _tmp13_;
	FilesPreferences* _tmp15_;
	FilesPreferences* _tmp16_;
	gboolean _tmp17_;
	gboolean _tmp18_;
	gboolean _tmp19_;
	GeeLinkedList* _tmp20_;
	GeeHashMap* _tmp21_;
	GFile* _tmp22_;
	GCancellable* _tmp23_;
	GCancellable* _tmp24_;
	GCancellable* _tmp25_;
	GCancellable* _tmp26_;
	GeeQueue* _tmp27_;
	GThread* _tmp28_;
	GThread* _tmp29_;
	const gchar* _tmp30_;
	GeeLinkedList* bookmarks_matched = NULL;
	GeeLinkedList* _tmp31_;
	gboolean begins_with = FALSE;
	FilesBookmarkList* _tmp32_;
	FilesBookmarkList* _tmp33_;
	GList* _tmp34_;
	GList* _tmp35_;
	GList* _tmp36_;
	GeeLinkedList* _tmp55_;
	GtkTreeIter* _tmp56_;
	GtkTreeIter _tmp57_;
	self = (FilesViewChromeSearchResults*) base;
	g_return_if_fail (term != NULL);
	g_return_if_fail (folder != NULL);
	_data62_ = g_slice_new0 (Block62Data);
	_data62_->_ref_count_ = 1;
	_data62_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (folder);
	_g_object_unref0 (_data62_->folder);
	_data62_->folder = _tmp0_;
	files_view_chrome_search_results_update_category_headers (self);
	_tmp1_ = g_utf8_normalize (term, (gssize) -1, G_NORMALIZE_DEFAULT);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_utf8_casefold (_tmp2_, (gssize) -1);
	_tmp4_ = _tmp3_;
	_tmp5_ = self->priv->search_term;
	_tmp6_ = g_strcmp0 (_tmp4_, _tmp5_) != 0;
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	if (_tmp6_) {
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp7_ = g_utf8_normalize (term, (gssize) -1, G_NORMALIZE_DEFAULT);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_utf8_casefold (_tmp8_, (gssize) -1);
		_g_free0 (self->priv->search_term);
		self->priv->search_term = _tmp9_;
		_g_free0 (_tmp8_);
		self->priv->max_results = FILES_VIEW_CHROME_SEARCH_RESULTS_MAX_RESULTS;
		self->priv->max_depth = FILES_VIEW_CHROME_SEARCH_RESULTS_MAX_DEPTH;
	}
	_tmp10_ = self->priv->current_operation;
	if (!g_cancellable_is_cancelled (_tmp10_)) {
		GCancellable* _tmp11_;
		_tmp11_ = self->priv->current_operation;
		g_cancellable_cancel (_tmp11_);
	}
	if (self->priv->adding_timeout != ((guint) 0)) {
		gboolean _tmp12_ = FALSE;
		g_source_remove (self->priv->adding_timeout);
		self->priv->adding_timeout = (guint) 0;
		self->priv->allow_adding_results = TRUE;
		if (self->priv->global_search_finished) {
			_tmp12_ = self->priv->local_search_finished;
		} else {
			_tmp12_ = FALSE;
		}
		if (_tmp12_) {
			files_view_chrome_search_results_set_working (self, FALSE);
		}
	}
	_tmp13_ = self->priv->_working;
	if (_tmp13_) {
		gulong _tmp14_;
		if (self->priv->waiting_handler != ((gulong) 0)) {
			g_signal_handler_disconnect (self, self->priv->waiting_handler);
		}
		_tmp14_ = g_signal_connect_data ((GObject*) self, "notify::working", (GCallback) ____lambda29__g_object_notify, block62_data_ref (_data62_), (GClosureNotify) block62_data_unref, 0);
		self->priv->waiting_handler = _tmp14_;
		block62_data_unref (_data62_);
		_data62_ = NULL;
		return;
	}
	_tmp15_ = files_preferences_get_default ();
	_tmp16_ = _tmp15_;
	_tmp17_ = files_preferences_get_show_hidden_files (_tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = _tmp18_;
	_g_object_unref0 (_tmp16_);
	_data62_->include_hidden = _tmp19_;
	self->priv->current_count = 0;
	self->priv->deep_count = 0;
	_tmp20_ = gee_linked_list_new (g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->directory_queue);
	self->priv->directory_queue = (GeeQueue*) _tmp20_;
	_tmp21_ = gee_hash_map_new (gtk_tree_iter_get_type (), (GBoxedCopyFunc) _vala_GtkTreeIter_copy, (GDestroyNotify) _vala_GtkTreeIter_free, GEE_TYPE_LIST, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->waiting_results);
	self->priv->waiting_results = (GeeMap*) _tmp21_;
	_tmp22_ = _g_object_ref0 (_data62_->folder);
	_g_object_unref0 (self->priv->current_root);
	self->priv->current_root = _tmp22_;
	_tmp23_ = g_cancellable_new ();
	_g_object_unref0 (self->priv->current_operation);
	self->priv->current_operation = _tmp23_;
	_tmp24_ = g_cancellable_new ();
	_g_object_unref0 (self->priv->file_search_operation);
	self->priv->file_search_operation = _tmp24_;
	_tmp25_ = self->priv->current_operation;
	_tmp26_ = self->priv->file_search_operation;
	g_signal_connect_object (_tmp25_, "cancelled", (GCallback) _g_cancellable_cancel_g_cancellable_cancelled, _tmp26_, 0);
	files_view_chrome_search_results_clear (self);
	files_view_chrome_search_results_set_n_results (self, 0);
	if (g_strcmp0 (term, "") == 0) {
		block62_data_unref (_data62_);
		_data62_ = NULL;
		return;
	}
	files_view_chrome_search_results_set_working (self, TRUE);
	_tmp27_ = self->priv->directory_queue;
	gee_collection_add ((GeeCollection*) _tmp27_, _data62_->folder);
	self->priv->allow_adding_results = FALSE;
	self->priv->adding_timeout = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) FILES_VIEW_CHROME_SEARCH_RESULTS_DELAY_ADDING_RESULTS, ___lambda30__gsource_func, g_object_ref (self), g_object_unref);
	_tmp28_ = g_thread_new (NULL, ___lambda31__gthread_func, block62_data_ref (_data62_));
	_tmp29_ = _tmp28_;
	_g_thread_unref0 (_tmp29_);
	_tmp30_ = self->priv->search_term;
	files_view_chrome_search_results_get_zg_results (self, _tmp30_, NULL, NULL);
	_tmp31_ = gee_linked_list_new (FILES_VIEW_CHROME_SEARCH_RESULTS_TYPE_MATCH, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	bookmarks_matched = _tmp31_;
	begins_with = FALSE;
	_tmp32_ = files_bookmark_list_get_instance ();
	_tmp33_ = _tmp32_;
	_tmp34_ = files_bookmark_list_get_list (_tmp33_);
	_tmp35_ = _tmp34_;
	_tmp36_ = _tmp35_;
	_g_object_unref0 (_tmp33_);
	{
		GList* bookmark_collection = NULL;
		GList* bookmark_it = NULL;
		bookmark_collection = _tmp36_;
		for (bookmark_it = bookmark_collection; bookmark_it != NULL; bookmark_it = bookmark_it->next) {
			FilesBookmark* _tmp37_;
			FilesBookmark* bookmark = NULL;
			_tmp37_ = _files_bookmark_ref0 ((FilesBookmark*) bookmark_it->data);
			bookmark = _tmp37_;
			{
				const gchar* _tmp38_;
				FilesBookmark* _tmp39_;
				const gchar* _tmp40_;
				const gchar* _tmp41_;
				FilesBookmark* _tmp42_;
				const gchar* _tmp43_;
				const gchar* _tmp44_;
				gchar* _tmp45_;
				gchar* _tmp46_;
				gboolean _tmp47_ = FALSE;
				gboolean _tmp48_;
				gboolean _tmp49_;
				_tmp38_ = self->priv->search_term;
				_tmp39_ = bookmark;
				_tmp40_ = files_bookmark_get_basename (_tmp39_);
				_tmp41_ = _tmp40_;
				_tmp42_ = bookmark;
				_tmp43_ = files_bookmark_get_custom_name (_tmp42_);
				_tmp44_ = _tmp43_;
				_tmp45_ = g_strconcat (_tmp41_, _tmp44_, NULL);
				_tmp46_ = _tmp45_;
				_tmp48_ = files_view_chrome_search_results_term_matches (self, _tmp38_, _tmp46_, &_tmp47_);
				begins_with = _tmp47_;
				_tmp49_ = _tmp48_;
				_g_free0 (_tmp46_);
				if (_tmp49_) {
					FilesViewChromeSearchResultsCategory _tmp50_ = 0;
					FilesViewChromeSearchResultsCategory category = 0;
					GeeLinkedList* _tmp51_;
					FilesBookmark* _tmp52_;
					FilesViewChromeSearchResultsMatch* _tmp53_;
					FilesViewChromeSearchResultsMatch* _tmp54_;
					if (begins_with) {
						_tmp50_ = FILES_VIEW_CHROME_SEARCH_RESULTS_CATEGORY_BOOKMARK_BEGINS;
					} else {
						_tmp50_ = FILES_VIEW_CHROME_SEARCH_RESULTS_CATEGORY_BOOKMARK_CONTAINS;
					}
					category = _tmp50_;
					_tmp51_ = bookmarks_matched;
					_tmp52_ = bookmark;
					_tmp53_ = files_view_chrome_search_results_match_new_from_bookmark (_tmp52_, category);
					_tmp54_ = _tmp53_;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp51_, _tmp54_);
					_g_object_unref0 (_tmp54_);
				}
				_files_bookmark_unref0 (bookmark);
			}
		}
	}
	_tmp55_ = bookmarks_matched;
	_tmp56_ = self->priv->bookmark_results;
	_tmp57_ = *_tmp56_;
	files_view_chrome_search_results_add_results (self, (GeeList*) _tmp55_, &_tmp57_);
	_g_object_unref0 (bookmarks_matched);
	block62_data_unref (_data62_);
	_data62_ = NULL;
}

/** Signal handlers **/
static GtkTreePath*
_vala_GtkTreePath_copy (GtkTreePath* self)
{
	return g_boxed_copy (gtk_tree_path_get_type (), self);
}

static gpointer
__vala_GtkTreePath_copy0 (gpointer self)
{
	return self ? _vala_GtkTreePath_copy (self) : NULL;
}

static void
_vala_GtkTreePath_free (GtkTreePath* self)
{
	g_boxed_free (gtk_tree_path_get_type (), self);
}

static void
__vala_GtkTreePath_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (_vala_GtkTreePath_free (var), NULL));
}

static inline void
_g_list_free___vala_GtkTreePath_free0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) __vala_GtkTreePath_free0_);
}

static void
files_view_chrome_search_results_on_cursor_changed (FilesViewChromeSearchResults* self)
{
	GtkTreeIter iter = {0};
	GtkTreePath* path = NULL;
	GList* selected_paths = NULL;
	GtkTreeView* _tmp0_;
	GtkTreeSelection* _tmp1_;
	GList* _tmp2_;
	GList* _tmp3_;
	GtkTreePath* _tmp7_;
	g_return_if_fail (self != NULL);
	path = NULL;
	_tmp0_ = self->priv->search_tree_view;
	_tmp1_ = gtk_tree_view_get_selection (_tmp0_);
	_tmp2_ = gtk_tree_selection_get_selected_rows (_tmp1_, NULL);
	selected_paths = _tmp2_;
	_tmp3_ = selected_paths;
	if (_tmp3_ != NULL) {
		GList* _tmp4_;
		gconstpointer _tmp5_;
		GtkTreePath* _tmp6_;
		_tmp4_ = selected_paths;
		_tmp5_ = _tmp4_->data;
		_tmp6_ = __vala_GtkTreePath_copy0 ((GtkTreePath*) _tmp5_);
		__vala_GtkTreePath_free0 (path);
		path = _tmp6_;
	}
	_tmp7_ = path;
	if (_tmp7_ != NULL) {
		GtkTreeModelFilter* _tmp8_;
		GtkTreePath* _tmp9_;
		GtkTreeIter _tmp10_ = {0};
		GtkTreeModelFilter* _tmp11_;
		GtkTreeIter _tmp12_;
		GtkTreeIter _tmp13_ = {0};
		GtkTreeIter _tmp14_;
		GFile* _tmp15_;
		GFile* _tmp16_;
		_tmp8_ = self->priv->filter;
		_tmp9_ = path;
		gtk_tree_model_get_iter ((GtkTreeModel*) _tmp8_, &_tmp10_, _tmp9_);
		iter = _tmp10_;
		_tmp11_ = self->priv->filter;
		_tmp12_ = iter;
		gtk_tree_model_filter_convert_iter_to_child_iter (_tmp11_, &_tmp13_, &_tmp12_);
		iter = _tmp13_;
		_tmp14_ = iter;
		_tmp15_ = files_view_chrome_search_results_get_file_at_iter (self, &_tmp14_);
		_tmp16_ = _tmp15_;
		g_signal_emit_by_name ((FilesViewChromeSearchable*) self, "cursor-changed", _tmp16_);
		_g_object_unref0 (_tmp16_);
	}
	(selected_paths == NULL) ? NULL : (selected_paths = (_g_list_free___vala_GtkTreePath_free0_ (selected_paths), NULL));
	__vala_GtkTreePath_free0 (path);
}

static gboolean
files_view_chrome_search_results_on_key_pressed_event (FilesViewChromeSearchResults* self,
                                                       guint keyval,
                                                       guint kecode,
                                                       GdkModifierType state)
{
	GdkModifierType mods = 0U;
	gboolean only_control_pressed = FALSE;
	gboolean shift_pressed = FALSE;
	gboolean alt_pressed = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean only_shift_pressed = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean only_alt_pressed = FALSE;
	gboolean _tmp2_ = FALSE;
	GtkEventControllerKey* _tmp11_;
	GtkWidget* _tmp12_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	mods = state & gtk_accelerator_get_default_mod_mask ();
	only_control_pressed = mods == GDK_CONTROL_MASK;
	shift_pressed = (mods & GDK_SHIFT_MASK) != 0;
	alt_pressed = (mods & GDK_MOD1_MASK) != 0;
	if (shift_pressed) {
		_tmp0_ = (mods & (~GDK_SHIFT_MASK)) == 0;
	} else {
		_tmp0_ = FALSE;
	}
	only_shift_pressed = _tmp0_;
	if (alt_pressed) {
		_tmp1_ = (mods & (~GDK_MOD1_MASK)) == 0;
	} else {
		_tmp1_ = FALSE;
	}
	only_alt_pressed = _tmp1_;
	if (mods != 0) {
		_tmp2_ = !only_shift_pressed;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		if (only_control_pressed) {
			if (keyval == GDK_KEY_l) {
				files_view_chrome_searchable_cancel ((FilesViewChromeSearchable*) self);
				g_signal_emit_by_name ((FilesViewChromeSearchable*) self, "exit", FALSE);
				result = TRUE;
				return result;
			} else {
				GtkEventControllerKey* _tmp3_;
				GtkWidget* _tmp4_;
				_tmp3_ = self->priv->key_controller;
				_tmp4_ = self->priv->_delegate_widget;
				result = gtk_event_controller_key_forward (_tmp3_, _tmp4_);
				return result;
			}
		} else {
			gboolean _tmp5_ = FALSE;
			gboolean _tmp6_ = FALSE;
			gboolean _tmp7_ = FALSE;
			if (only_alt_pressed) {
				_tmp7_ = keyval == GDK_KEY_Return;
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				_tmp6_ = TRUE;
			} else {
				_tmp6_ = keyval == GDK_KEY_KP_Enter;
			}
			if (_tmp6_) {
				_tmp5_ = TRUE;
			} else {
				_tmp5_ = keyval == GDK_KEY_ISO_Enter;
			}
			if (_tmp5_) {
				files_view_chrome_search_results_accept (self, NULL, TRUE);
				result = TRUE;
				return result;
			}
		}
	}
	switch (keyval) {
		case GDK_KEY_Return:
		case GDK_KEY_KP_Enter:
		case GDK_KEY_ISO_Enter:
		{
			files_view_chrome_search_results_accept (self, NULL, FALSE);
			result = TRUE;
			return result;
		}
		case GDK_KEY_Up:
		case GDK_KEY_Down:
		case GDK_KEY_Tab:
		case GDK_KEY_ISO_Left_Tab:
		{
			gboolean _tmp8_ = FALSE;
			gboolean up = FALSE;
			GtkTreeView* _tmp9_;
			GtkTreeSelection* _tmp10_;
			if (files_view_chrome_search_results_list_empty (self)) {
				result = TRUE;
				return result;
			}
			if (keyval == GDK_KEY_Up) {
				_tmp8_ = TRUE;
			} else {
				_tmp8_ = keyval == GDK_KEY_ISO_Left_Tab;
			}
			up = _tmp8_;
			_tmp9_ = self->priv->search_tree_view;
			_tmp10_ = gtk_tree_view_get_selection (_tmp9_);
			if (gtk_tree_selection_count_selected_rows (_tmp10_) < 1) {
				if (up) {
					files_view_chrome_search_results_select_last (self);
				} else {
					files_view_chrome_search_results_select_first (self);
				}
				result = TRUE;
				return result;
			}
			files_view_chrome_search_results_select_adjacent (self, up);
			result = TRUE;
			return result;
		}
		case GDK_KEY_Escape:
		{
			files_view_chrome_searchable_cancel ((FilesViewChromeSearchable*) self);
			g_signal_emit_by_name ((FilesViewChromeSearchable*) self, "exit", TRUE);
			result = TRUE;
			return result;
		}
		default:
		{
			break;
		}
	}
	_tmp11_ = self->priv->key_controller;
	_tmp12_ = self->priv->_delegate_widget;
	result = gtk_event_controller_key_forward (_tmp11_, _tmp12_);
	return result;
}

static void
files_view_chrome_search_results_select_first (FilesViewChromeSearchResults* self)
{
	GtkTreeIter iter = {0};
	GtkTreeStore* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	GtkScrolledWindow* _tmp11_;
	GtkAdjustment* _tmp12_;
	GtkAdjustment* _tmp13_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->list;
	gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp0_, &_tmp1_);
	iter = _tmp1_;
	{
		gboolean _tmp2_ = FALSE;
		_tmp2_ = TRUE;
		while (TRUE) {
			GtkTreeStore* _tmp5_;
			GtkTreeIter _tmp6_;
			GtkTreeStore* _tmp7_;
			GtkTreeIter _tmp8_;
			GtkTreeIter _tmp9_ = {0};
			GtkTreeIter _tmp10_;
			if (!_tmp2_) {
				GtkTreeStore* _tmp3_;
				gboolean _tmp4_;
				_tmp3_ = self->priv->list;
				_tmp4_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp3_, &iter);
				if (!_tmp4_) {
					break;
				}
			}
			_tmp2_ = FALSE;
			_tmp5_ = self->priv->list;
			_tmp6_ = iter;
			if (!gtk_tree_model_iter_has_child ((GtkTreeModel*) _tmp5_, &_tmp6_)) {
				continue;
			}
			_tmp7_ = self->priv->list;
			_tmp8_ = iter;
			gtk_tree_model_iter_nth_child ((GtkTreeModel*) _tmp7_, &_tmp9_, &_tmp8_, 0);
			iter = _tmp9_;
			_tmp10_ = iter;
			files_view_chrome_search_results_select_iter (self, &_tmp10_);
			break;
		}
	}
	_tmp11_ = self->priv->scroll;
	_tmp12_ = gtk_scrolled_window_get_vadjustment (_tmp11_);
	_tmp13_ = _tmp12_;
	gtk_adjustment_set_value (_tmp13_, (gdouble) 0);
}

static void
files_view_chrome_search_results_select_last (FilesViewChromeSearchResults* self)
{
	GtkTreeIter iter = {0};
	GtkTreeStore* _tmp0_;
	GtkTreeModelFilter* _tmp1_;
	GtkTreeIter _tmp2_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->list;
	_tmp1_ = self->priv->filter;
	gtk_tree_model_iter_nth_child ((GtkTreeModel*) _tmp0_, &_tmp2_, NULL, gtk_tree_model_iter_n_children ((GtkTreeModel*) _tmp1_, NULL) - 1);
	iter = _tmp2_;
	{
		gboolean _tmp3_ = FALSE;
		_tmp3_ = TRUE;
		while (TRUE) {
			GtkTreeStore* _tmp6_;
			GtkTreeIter _tmp7_;
			GtkTreeStore* _tmp8_;
			GtkTreeIter _tmp9_;
			GtkTreeStore* _tmp10_;
			GtkTreeIter _tmp11_;
			GtkTreeIter _tmp12_ = {0};
			GtkTreeIter _tmp13_;
			if (!_tmp3_) {
				GtkTreeStore* _tmp4_;
				gboolean _tmp5_;
				_tmp4_ = self->priv->list;
				_tmp5_ = gtk_tree_model_iter_previous ((GtkTreeModel*) _tmp4_, &iter);
				if (!_tmp5_) {
					break;
				}
			}
			_tmp3_ = FALSE;
			_tmp6_ = self->priv->list;
			_tmp7_ = iter;
			if (!gtk_tree_model_iter_has_child ((GtkTreeModel*) _tmp6_, &_tmp7_)) {
				continue;
			}
			_tmp8_ = self->priv->list;
			_tmp9_ = iter;
			_tmp10_ = self->priv->list;
			_tmp11_ = iter;
			gtk_tree_model_iter_nth_child ((GtkTreeModel*) _tmp8_, &_tmp12_, &_tmp9_, gtk_tree_model_iter_n_children ((GtkTreeModel*) _tmp10_, &_tmp11_) - 1);
			iter = _tmp12_;
			_tmp13_ = iter;
			files_view_chrome_search_results_select_iter (self, &_tmp13_);
			break;
		}
	}
}

static void
files_view_chrome_search_results_select_adjacent (FilesViewChromeSearchResults* self,
                                                  gboolean up)
{
	GtkTreeIter iter = {0};
	GtkTreeIter parent = {0};
	GtkTreeIter _tmp0_ = {0};
	gboolean _tmp1_ = FALSE;
	GtkTreeIter _tmp7_ = {0};
	GtkTreeStore* _tmp8_;
	GtkTreeIter _tmp9_;
	GtkTreeIter _tmp10_ = {0};
	gint _tmp19_ = 0;
	GtkTreeStore* _tmp22_;
	GtkTreeIter _tmp23_;
	GtkTreeIter _tmp24_ = {0};
	GtkTreeIter _tmp25_;
	g_return_if_fail (self != NULL);
	files_view_chrome_search_results_get_iter_at_cursor (self, &_tmp0_);
	iter = _tmp0_;
	if (up) {
		GtkTreeStore* _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = self->priv->list;
		_tmp3_ = gtk_tree_model_iter_previous ((GtkTreeModel*) _tmp2_, &iter);
		_tmp1_ = _tmp3_;
	} else {
		GtkTreeStore* _tmp4_;
		gboolean _tmp5_;
		_tmp4_ = self->priv->list;
		_tmp5_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp4_, &iter);
		_tmp1_ = _tmp5_;
	}
	if (_tmp1_) {
		GtkTreeIter _tmp6_;
		_tmp6_ = iter;
		files_view_chrome_search_results_select_iter (self, &_tmp6_);
		return;
	}
	files_view_chrome_search_results_get_iter_at_cursor (self, &_tmp7_);
	iter = _tmp7_;
	_tmp8_ = self->priv->list;
	_tmp9_ = iter;
	gtk_tree_model_iter_parent ((GtkTreeModel*) _tmp8_, &_tmp10_, &_tmp9_);
	parent = _tmp10_;
	{
		gboolean _tmp11_ = FALSE;
		_tmp11_ = TRUE;
		while (TRUE) {
			gboolean _tmp14_ = FALSE;
			if (!_tmp11_) {
				GtkTreeStore* _tmp12_;
				GtkTreeIter _tmp13_;
				_tmp12_ = self->priv->list;
				_tmp13_ = parent;
				if (!(!gtk_tree_model_iter_has_child ((GtkTreeModel*) _tmp12_, &_tmp13_))) {
					break;
				}
			}
			_tmp11_ = FALSE;
			if (up) {
				GtkTreeStore* _tmp15_;
				gboolean _tmp16_;
				_tmp15_ = self->priv->list;
				_tmp16_ = gtk_tree_model_iter_previous ((GtkTreeModel*) _tmp15_, &parent);
				_tmp14_ = !_tmp16_;
			} else {
				GtkTreeStore* _tmp17_;
				gboolean _tmp18_;
				_tmp17_ = self->priv->list;
				_tmp18_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp17_, &parent);
				_tmp14_ = !_tmp18_;
			}
			if (_tmp14_) {
				if (up) {
					files_view_chrome_search_results_select_last (self);
				} else {
					files_view_chrome_search_results_select_first (self);
				}
				return;
			}
		}
	}
	if (up) {
		GtkTreeStore* _tmp20_;
		GtkTreeIter _tmp21_;
		_tmp20_ = self->priv->list;
		_tmp21_ = parent;
		_tmp19_ = gtk_tree_model_iter_n_children ((GtkTreeModel*) _tmp20_, &_tmp21_) - 1;
	} else {
		_tmp19_ = 0;
	}
	_tmp22_ = self->priv->list;
	_tmp23_ = parent;
	gtk_tree_model_iter_nth_child ((GtkTreeModel*) _tmp22_, &_tmp24_, &_tmp23_, _tmp19_);
	iter = _tmp24_;
	_tmp25_ = iter;
	files_view_chrome_search_results_select_iter (self, &_tmp25_);
	return;
}

static gboolean
files_view_chrome_search_results_list_empty (FilesViewChromeSearchResults* self)
{
	GtkTreeIter iter = {0};
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		gboolean valid = FALSE;
		GtkTreeStore* _tmp0_;
		GtkTreeIter _tmp1_ = {0};
		gboolean _tmp2_;
		_tmp0_ = self->priv->list;
		_tmp2_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp0_, &_tmp1_);
		iter = _tmp1_;
		valid = _tmp2_;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				GtkTreeStore* _tmp6_;
				GtkTreeIter _tmp7_;
				if (!_tmp3_) {
					GtkTreeStore* _tmp4_;
					gboolean _tmp5_;
					_tmp4_ = self->priv->list;
					_tmp5_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp4_, &iter);
					valid = _tmp5_;
				}
				_tmp3_ = FALSE;
				if (!valid) {
					break;
				}
				_tmp6_ = self->priv->list;
				_tmp7_ = iter;
				if (gtk_tree_model_iter_has_child ((GtkTreeModel*) _tmp6_, &_tmp7_)) {
					result = FALSE;
					return result;
				}
			}
		}
	}
	result = TRUE;
	return result;
}

static gint
files_view_chrome_search_results_n_matches (FilesViewChromeSearchResults* self,
                                            gint* n_headers)
{
	gint _vala_n_headers = 0;
	gint matches = 0;
	GtkTreeIter iter = {0};
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	matches = 0;
	_vala_n_headers = 0;
	{
		gboolean valid = FALSE;
		GtkTreeStore* _tmp0_;
		GtkTreeIter _tmp1_ = {0};
		gboolean _tmp2_;
		_tmp0_ = self->priv->list;
		_tmp2_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp0_, &_tmp1_);
		iter = _tmp1_;
		valid = _tmp2_;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gint n_children = 0;
				GtkTreeStore* _tmp6_;
				GtkTreeIter _tmp7_;
				if (!_tmp3_) {
					GtkTreeStore* _tmp4_;
					gboolean _tmp5_;
					_tmp4_ = self->priv->list;
					_tmp5_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp4_, &iter);
					valid = _tmp5_;
				}
				_tmp3_ = FALSE;
				if (!valid) {
					break;
				}
				_tmp6_ = self->priv->list;
				_tmp7_ = iter;
				n_children = gtk_tree_model_iter_n_children ((GtkTreeModel*) _tmp6_, &_tmp7_);
				if (n_children > 0) {
					gint _tmp8_;
					_tmp8_ = _vala_n_headers;
					_vala_n_headers = _tmp8_ + 1;
				}
				matches += n_children;
			}
		}
	}
	result = matches;
	if (n_headers) {
		*n_headers = _vala_n_headers;
	}
	return result;
}

static void
files_view_chrome_search_results_resize_popup (FilesViewChromeSearchResults* self)
{
	gint items = 0;
	gint headers = 0;
	gint _tmp0_ = 0;
	gint _tmp1_;
	g_return_if_fail (self != NULL);
	headers = 0;
	_tmp1_ = files_view_chrome_search_results_n_matches (self, &_tmp0_);
	headers = _tmp0_;
	items = _tmp1_;
	if ((items + headers) <= 1) {
		files_view_chrome_search_results_disconnect_view_cursor_changed_signal (self);
		gtk_popover_popdown ((GtkPopover*) self);
	} else {
		GtkWindow* toplevel = NULL;
		GtkWidget* _tmp2_;
		GtkWidget* _tmp3_;
		GtkWindow* _tmp4_;
		GtkScrolledWindow* _tmp5_;
		GtkWindow* _tmp6_;
		GtkScrolledWindow* _tmp7_;
		GtkWidget* _tmp8_;
		gtk_widget_show_all ((GtkWidget*) self);
		files_view_chrome_search_results_connect_view_cursor_changed_signal (self);
		_tmp2_ = gtk_popover_get_relative_to ((GtkPopover*) self);
		_tmp3_ = gtk_widget_get_ancestor (_tmp2_, gtk_window_get_type ());
		_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_window_get_type (), GtkWindow));
		toplevel = _tmp4_;
		_tmp5_ = self->priv->scroll;
		_tmp6_ = toplevel;
		gtk_scrolled_window_set_min_content_height (_tmp5_, MIN (gtk_widget_get_allocated_height ((GtkWidget*) _tmp6_), (items + headers) * 24));
		_tmp7_ = self->priv->scroll;
		_tmp8_ = gtk_popover_get_relative_to ((GtkPopover*) self);
		g_object_set ((GtkWidget*) _tmp7_, "width-request", MAX (200, gtk_widget_get_allocated_width (_tmp8_)), NULL);
		gtk_popover_popup ((GtkPopover*) self);
		_g_object_unref0 (toplevel);
	}
}

static gboolean
files_view_chrome_search_results_get_iter_at_cursor (FilesViewChromeSearchResults* self,
                                                     GtkTreeIter* iter)
{
	GtkTreeIter _vala_iter = {0};
	GtkTreePath* path = NULL;
	GtkTreeIter filter_iter = {0};
	GtkTreeView* _tmp0_;
	GtkTreePath* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GtkTreePath* _tmp3_;
	GtkTreeModelFilter* _tmp8_;
	GtkTreeIter _tmp9_;
	GtkTreeIter _tmp10_ = {0};
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	path = NULL;
	memset (&filter_iter, 0, sizeof (GtkTreeIter));
	memset (&_vala_iter, 0, sizeof (GtkTreeIter));
	_tmp0_ = self->priv->search_tree_view;
	gtk_tree_view_get_cursor (_tmp0_, &_tmp1_, NULL);
	__vala_GtkTreePath_free0 (path);
	path = _tmp1_;
	_tmp3_ = path;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		GtkTreeModelFilter* _tmp4_;
		GtkTreePath* _tmp5_;
		GtkTreeIter _tmp6_ = {0};
		gboolean _tmp7_;
		_tmp4_ = self->priv->filter;
		_tmp5_ = path;
		_tmp7_ = gtk_tree_model_get_iter ((GtkTreeModel*) _tmp4_, &_tmp6_, _tmp5_);
		filter_iter = _tmp6_;
		_tmp2_ = !_tmp7_;
	}
	if (_tmp2_) {
		result = FALSE;
		__vala_GtkTreePath_free0 (path);
		if (iter) {
			*iter = _vala_iter;
		}
		return result;
	}
	_tmp8_ = self->priv->filter;
	_tmp9_ = filter_iter;
	gtk_tree_model_filter_convert_iter_to_child_iter (_tmp8_, &_tmp10_, &_tmp9_);
	_vala_iter = _tmp10_;
	result = TRUE;
	__vala_GtkTreePath_free0 (path);
	if (iter) {
		*iter = _vala_iter;
	}
	return result;
}

static void
files_view_chrome_search_results_select_iter (FilesViewChromeSearchResults* self,
                                              GtkTreeIter* iter)
{
	GtkTreeModelFilter* _tmp0_;
	GtkTreeIter _tmp1_;
	GtkTreeIter _tmp2_ = {0};
	GtkTreePath* path = NULL;
	GtkTreeModelFilter* _tmp3_;
	GtkTreeIter _tmp4_;
	GtkTreePath* _tmp5_;
	GtkTreeView* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = self->priv->filter;
	_tmp1_ = *iter;
	gtk_tree_model_filter_convert_child_iter_to_iter (_tmp0_, &_tmp2_, &_tmp1_);
	*iter = _tmp2_;
	_tmp3_ = self->priv->filter;
	_tmp4_ = *iter;
	_tmp5_ = gtk_tree_model_get_path ((GtkTreeModel*) _tmp3_, &_tmp4_);
	path = _tmp5_;
	_tmp6_ = self->priv->search_tree_view;
	gtk_tree_view_set_cursor (_tmp6_, path, NULL, FALSE);
	__vala_GtkTreePath_free0 (path);
}

static gboolean
_gtk_tree_iter_equal (const GtkTreeIter * s1,
                      const GtkTreeIter * s2)
{
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	if (s1->stamp != s2->stamp) {
		return FALSE;
	}
	if (s1->user_data != s2->user_data) {
		return FALSE;
	}
	if (s1->user_data2 != s2->user_data2) {
		return FALSE;
	}
	if (s1->user_data3 != s2->user_data3) {
		return FALSE;
	}
	return TRUE;
}

static gpointer
__vala_GtkTreeIter_copy0 (gpointer self)
{
	return self ? _vala_GtkTreeIter_copy (self) : NULL;
}

static void
files_view_chrome_search_results_add_results (FilesViewChromeSearchResults* self,
                                              GeeList* new_results,
                                              GtkTreeIter* parent)
{
	GCancellable* _tmp0_;
	gboolean _tmp151_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (new_results != NULL);
	g_return_if_fail (parent != NULL);
	_tmp0_ = self->priv->current_operation;
	if (g_cancellable_is_cancelled (_tmp0_)) {
		return;
	}
	if (!self->priv->allow_adding_results) {
		GeeList* list = NULL;
		GeeMap* _tmp1_;
		GtkTreeIter _tmp2_;
		gpointer _tmp3_;
		GeeList* _tmp4_;
		GeeList* _tmp9_;
		GeeList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		_tmp1_ = self->priv->waiting_results;
		_tmp2_ = *parent;
		_tmp3_ = gee_map_get (_tmp1_, &_tmp2_);
		_g_object_unref0 (list);
		list = (GeeList*) _tmp3_;
		_tmp4_ = list;
		if (_tmp4_ == NULL) {
			GeeLinkedList* _tmp5_;
			GeeMap* _tmp6_;
			GtkTreeIter _tmp7_;
			GeeList* _tmp8_;
			_tmp5_ = gee_linked_list_new (FILES_VIEW_CHROME_SEARCH_RESULTS_TYPE_MATCH, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
			_g_object_unref0 (list);
			list = (GeeList*) _tmp5_;
			_tmp6_ = self->priv->waiting_results;
			_tmp7_ = *parent;
			_tmp8_ = list;
			gee_map_set (_tmp6_, &_tmp7_, _tmp8_);
		}
		_tmp9_ = list;
		_tmp10_ = list;
		_tmp11_ = gee_collection_get_size ((GeeCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		gee_list_insert_all (_tmp9_, _tmp12_, (GeeCollection*) new_results);
		_g_object_unref0 (list);
		return;
	}
	{
		GeeList* _match_list = NULL;
		gint _match_size = 0;
		GeeList* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gint _match_index = 0;
		_match_list = new_results;
		_tmp13_ = _match_list;
		_tmp14_ = gee_collection_get_size ((GeeCollection*) _tmp13_);
		_tmp15_ = _tmp14_;
		_match_size = _tmp15_;
		_match_index = -1;
		while (TRUE) {
			gint _tmp16_;
			gint _tmp17_;
			FilesViewChromeSearchResultsMatch* match = NULL;
			GeeList* _tmp18_;
			gpointer _tmp19_;
			GtkTreeIter* iter = NULL;
			GFile* file = NULL;
			GtkTreeIter _tmp20_;
			GtkTreeIter* _tmp21_;
			gchar* location = NULL;
			const gchar* _tmp120_;
			FilesViewChromeSearchResultsMatch* _tmp121_;
			const gchar* _tmp122_;
			const gchar* _tmp123_;
			gchar* _tmp124_;
			gchar* _tmp125_;
			gchar* _tmp126_;
			gchar* _tmp127_;
			GtkTreeStore* _tmp128_;
			GtkTreeIter _tmp129_;
			GtkTreeIter _tmp130_ = {0};
			GtkTreeIter _tmp131_;
			GtkTreeIter* _tmp132_;
			GtkTreeStore* _tmp133_;
			GtkTreeIter* _tmp134_;
			FilesViewChromeSearchResultsMatch* _tmp135_;
			const gchar* _tmp136_;
			const gchar* _tmp137_;
			FilesViewChromeSearchResultsMatch* _tmp138_;
			GIcon* _tmp139_;
			GIcon* _tmp140_;
			const gchar* _tmp141_;
			FilesViewChromeSearchResultsMatch* _tmp142_;
			GFile* _tmp143_;
			GFile* _tmp144_;
			FilesViewChromeSearchResultsMatch* _tmp145_;
			const gchar* _tmp146_;
			const gchar* _tmp147_;
			GtkTreeIter _tmp148_;
			gint _tmp149_;
			GtkTreeView* _tmp150_;
			_match_index = _match_index + 1;
			_tmp16_ = _match_index;
			_tmp17_ = _match_size;
			if (!(_tmp16_ < _tmp17_)) {
				break;
			}
			_tmp18_ = _match_list;
			_tmp19_ = gee_list_get (_tmp18_, _match_index);
			match = (FilesViewChromeSearchResultsMatch*) _tmp19_;
			iter = NULL;
			_tmp20_ = *parent;
			_tmp21_ = self->priv->zeitgeist_results;
			if (_gtk_tree_iter_equal (&_tmp20_, _tmp21_) == TRUE) {
				gboolean already_added = FALSE;
				already_added = FALSE;
				{
					gboolean valid = FALSE;
					GtkTreeStore* _tmp22_;
					GtkTreeIter* _tmp23_;
					GtkTreeIter _tmp24_ = {0};
					gboolean _tmp25_;
					GtkTreeIter _tmp26_;
					GtkTreeIter* _tmp27_;
					_tmp22_ = self->priv->list;
					_tmp23_ = self->priv->local_results;
					_tmp25_ = gtk_tree_model_iter_nth_child ((GtkTreeModel*) _tmp22_, &_tmp24_, _tmp23_, 0);
					__vala_GtkTreeIter_free0 (iter);
					_tmp26_ = _tmp24_;
					_tmp27_ = __vala_GtkTreeIter_copy0 (&_tmp26_);
					iter = _tmp27_;
					valid = _tmp25_;
					{
						gboolean _tmp28_ = FALSE;
						_tmp28_ = TRUE;
						while (TRUE) {
							GtkTreeStore* _tmp31_;
							GtkTreeIter* _tmp32_;
							GtkTreeIter _tmp33_;
							GFile* _tmp34_ = NULL;
							gboolean _tmp35_ = FALSE;
							gboolean _tmp36_ = FALSE;
							GFile* _tmp37_;
							if (!_tmp28_) {
								GtkTreeStore* _tmp29_;
								gboolean _tmp30_;
								_tmp29_ = self->priv->list;
								_tmp30_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp29_, iter);
								valid = _tmp30_;
							}
							_tmp28_ = FALSE;
							if (!valid) {
								break;
							}
							_tmp31_ = self->priv->list;
							_tmp32_ = iter;
							_tmp33_ = *_tmp32_;
							gtk_tree_model_get ((GtkTreeModel*) _tmp31_, &_tmp33_, 3, &_tmp34_, -1);
							_g_object_unref0 (file);
							file = _tmp34_;
							_tmp37_ = file;
							if (_tmp37_ != NULL) {
								FilesViewChromeSearchResultsMatch* _tmp38_;
								GFile* _tmp39_;
								GFile* _tmp40_;
								_tmp38_ = match;
								_tmp39_ = files_view_chrome_search_results_match_get_file (_tmp38_);
								_tmp40_ = _tmp39_;
								_tmp36_ = _tmp40_ != NULL;
							} else {
								_tmp36_ = FALSE;
							}
							if (_tmp36_) {
								GFile* _tmp41_;
								FilesViewChromeSearchResultsMatch* _tmp42_;
								GFile* _tmp43_;
								GFile* _tmp44_;
								_tmp41_ = file;
								_tmp42_ = match;
								_tmp43_ = files_view_chrome_search_results_match_get_file (_tmp42_);
								_tmp44_ = _tmp43_;
								_tmp35_ = g_file_equal (_tmp41_, _tmp44_);
							} else {
								_tmp35_ = FALSE;
							}
							if (_tmp35_) {
								already_added = TRUE;
								break;
							}
						}
					}
				}
				if (!already_added) {
					{
						gboolean valid = FALSE;
						GtkTreeStore* _tmp45_;
						GtkTreeIter* _tmp46_;
						GtkTreeIter _tmp47_ = {0};
						gboolean _tmp48_;
						GtkTreeIter _tmp49_;
						GtkTreeIter* _tmp50_;
						_tmp45_ = self->priv->list;
						_tmp46_ = self->priv->deep_results;
						_tmp48_ = gtk_tree_model_iter_nth_child ((GtkTreeModel*) _tmp45_, &_tmp47_, _tmp46_, 0);
						__vala_GtkTreeIter_free0 (iter);
						_tmp49_ = _tmp47_;
						_tmp50_ = __vala_GtkTreeIter_copy0 (&_tmp49_);
						iter = _tmp50_;
						valid = _tmp48_;
						{
							gboolean _tmp51_ = FALSE;
							_tmp51_ = TRUE;
							while (TRUE) {
								GtkTreeStore* _tmp54_;
								GtkTreeIter* _tmp55_;
								GtkTreeIter _tmp56_;
								GFile* _tmp57_ = NULL;
								gboolean _tmp58_ = FALSE;
								gboolean _tmp59_ = FALSE;
								GFile* _tmp60_;
								if (!_tmp51_) {
									GtkTreeStore* _tmp52_;
									gboolean _tmp53_;
									_tmp52_ = self->priv->list;
									_tmp53_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp52_, iter);
									valid = _tmp53_;
								}
								_tmp51_ = FALSE;
								if (!valid) {
									break;
								}
								_tmp54_ = self->priv->list;
								_tmp55_ = iter;
								_tmp56_ = *_tmp55_;
								gtk_tree_model_get ((GtkTreeModel*) _tmp54_, &_tmp56_, 3, &_tmp57_, -1);
								_g_object_unref0 (file);
								file = _tmp57_;
								_tmp60_ = file;
								if (_tmp60_ != NULL) {
									FilesViewChromeSearchResultsMatch* _tmp61_;
									GFile* _tmp62_;
									GFile* _tmp63_;
									_tmp61_ = match;
									_tmp62_ = files_view_chrome_search_results_match_get_file (_tmp61_);
									_tmp63_ = _tmp62_;
									_tmp59_ = _tmp63_ != NULL;
								} else {
									_tmp59_ = FALSE;
								}
								if (_tmp59_) {
									GFile* _tmp64_;
									FilesViewChromeSearchResultsMatch* _tmp65_;
									GFile* _tmp66_;
									GFile* _tmp67_;
									_tmp64_ = file;
									_tmp65_ = match;
									_tmp66_ = files_view_chrome_search_results_match_get_file (_tmp65_);
									_tmp67_ = _tmp66_;
									_tmp58_ = g_file_equal (_tmp64_, _tmp67_);
								} else {
									_tmp58_ = FALSE;
								}
								if (_tmp58_) {
									already_added = TRUE;
									break;
								}
							}
						}
					}
				}
				if (already_added) {
					_g_object_unref0 (file);
					__vala_GtkTreeIter_free0 (iter);
					_g_object_unref0 (match);
					continue;
				}
			} else {
				GtkTreeIter _tmp68_;
				GtkTreeIter* _tmp69_;
				_tmp68_ = *parent;
				_tmp69_ = self->priv->local_results;
				if (_gtk_tree_iter_equal (&_tmp68_, _tmp69_) == TRUE) {
					{
						gboolean valid = FALSE;
						GtkTreeStore* _tmp70_;
						GtkTreeIter* _tmp71_;
						GtkTreeIter _tmp72_ = {0};
						gboolean _tmp73_;
						GtkTreeIter _tmp74_;
						GtkTreeIter* _tmp75_;
						_tmp70_ = self->priv->list;
						_tmp71_ = self->priv->zeitgeist_results;
						_tmp73_ = gtk_tree_model_iter_nth_child ((GtkTreeModel*) _tmp70_, &_tmp72_, _tmp71_, 0);
						__vala_GtkTreeIter_free0 (iter);
						_tmp74_ = _tmp72_;
						_tmp75_ = __vala_GtkTreeIter_copy0 (&_tmp74_);
						iter = _tmp75_;
						valid = _tmp73_;
						{
							gboolean _tmp76_ = FALSE;
							_tmp76_ = TRUE;
							while (TRUE) {
								GtkTreeStore* _tmp79_;
								GtkTreeIter* _tmp80_;
								GtkTreeIter _tmp81_;
								GFile* _tmp82_ = NULL;
								gboolean _tmp83_ = FALSE;
								gboolean _tmp84_ = FALSE;
								GFile* _tmp85_;
								if (!_tmp76_) {
									GtkTreeStore* _tmp77_;
									gboolean _tmp78_;
									_tmp77_ = self->priv->list;
									_tmp78_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp77_, iter);
									valid = _tmp78_;
								}
								_tmp76_ = FALSE;
								if (!valid) {
									break;
								}
								_tmp79_ = self->priv->list;
								_tmp80_ = iter;
								_tmp81_ = *_tmp80_;
								gtk_tree_model_get ((GtkTreeModel*) _tmp79_, &_tmp81_, 3, &_tmp82_, -1);
								_g_object_unref0 (file);
								file = _tmp82_;
								_tmp85_ = file;
								if (_tmp85_ != NULL) {
									FilesViewChromeSearchResultsMatch* _tmp86_;
									GFile* _tmp87_;
									GFile* _tmp88_;
									_tmp86_ = match;
									_tmp87_ = files_view_chrome_search_results_match_get_file (_tmp86_);
									_tmp88_ = _tmp87_;
									_tmp84_ = _tmp88_ != NULL;
								} else {
									_tmp84_ = FALSE;
								}
								if (_tmp84_) {
									GFile* _tmp89_;
									FilesViewChromeSearchResultsMatch* _tmp90_;
									GFile* _tmp91_;
									GFile* _tmp92_;
									_tmp89_ = file;
									_tmp90_ = match;
									_tmp91_ = files_view_chrome_search_results_match_get_file (_tmp90_);
									_tmp92_ = _tmp91_;
									_tmp83_ = g_file_equal (_tmp89_, _tmp92_);
								} else {
									_tmp83_ = FALSE;
								}
								if (_tmp83_) {
									GtkTreeStore* _tmp93_;
									_tmp93_ = self->priv->list;
									gtk_tree_store_remove (_tmp93_, iter);
									break;
								}
							}
						}
					}
				} else {
					GtkTreeIter _tmp94_;
					GtkTreeIter* _tmp95_;
					_tmp94_ = *parent;
					_tmp95_ = self->priv->deep_results;
					if (_gtk_tree_iter_equal (&_tmp94_, _tmp95_) == TRUE) {
						{
							gboolean valid = FALSE;
							GtkTreeStore* _tmp96_;
							GtkTreeIter* _tmp97_;
							GtkTreeIter _tmp98_ = {0};
							gboolean _tmp99_;
							GtkTreeIter _tmp100_;
							GtkTreeIter* _tmp101_;
							_tmp96_ = self->priv->list;
							_tmp97_ = self->priv->zeitgeist_results;
							_tmp99_ = gtk_tree_model_iter_nth_child ((GtkTreeModel*) _tmp96_, &_tmp98_, _tmp97_, 0);
							__vala_GtkTreeIter_free0 (iter);
							_tmp100_ = _tmp98_;
							_tmp101_ = __vala_GtkTreeIter_copy0 (&_tmp100_);
							iter = _tmp101_;
							valid = _tmp99_;
							{
								gboolean _tmp102_ = FALSE;
								_tmp102_ = TRUE;
								while (TRUE) {
									GtkTreeStore* _tmp105_;
									GtkTreeIter* _tmp106_;
									GtkTreeIter _tmp107_;
									GFile* _tmp108_ = NULL;
									gboolean _tmp109_ = FALSE;
									gboolean _tmp110_ = FALSE;
									GFile* _tmp111_;
									if (!_tmp102_) {
										GtkTreeStore* _tmp103_;
										gboolean _tmp104_;
										_tmp103_ = self->priv->list;
										_tmp104_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp103_, iter);
										valid = _tmp104_;
									}
									_tmp102_ = FALSE;
									if (!valid) {
										break;
									}
									_tmp105_ = self->priv->list;
									_tmp106_ = iter;
									_tmp107_ = *_tmp106_;
									gtk_tree_model_get ((GtkTreeModel*) _tmp105_, &_tmp107_, 3, &_tmp108_, -1);
									_g_object_unref0 (file);
									file = _tmp108_;
									_tmp111_ = file;
									if (_tmp111_ != NULL) {
										FilesViewChromeSearchResultsMatch* _tmp112_;
										GFile* _tmp113_;
										GFile* _tmp114_;
										_tmp112_ = match;
										_tmp113_ = files_view_chrome_search_results_match_get_file (_tmp112_);
										_tmp114_ = _tmp113_;
										_tmp110_ = _tmp114_ != NULL;
									} else {
										_tmp110_ = FALSE;
									}
									if (_tmp110_) {
										GFile* _tmp115_;
										FilesViewChromeSearchResultsMatch* _tmp116_;
										GFile* _tmp117_;
										GFile* _tmp118_;
										_tmp115_ = file;
										_tmp116_ = match;
										_tmp117_ = files_view_chrome_search_results_match_get_file (_tmp116_);
										_tmp118_ = _tmp117_;
										_tmp109_ = g_file_equal (_tmp115_, _tmp118_);
									} else {
										_tmp109_ = FALSE;
									}
									if (_tmp109_) {
										GtkTreeStore* _tmp119_;
										_tmp119_ = self->priv->list;
										gtk_tree_store_remove (_tmp119_, iter);
										break;
									}
								}
							}
						}
					}
				}
			}
			_tmp120_ = self->priv->result_location_markup;
			_tmp121_ = match;
			_tmp122_ = files_view_chrome_search_results_match_get_path_string (_tmp121_);
			_tmp123_ = _tmp122_;
			_tmp124_ = g_markup_escape_text (_tmp123_, (gssize) -1);
			_tmp125_ = _tmp124_;
			_tmp126_ = g_strdup_printf (_tmp120_, _tmp125_);
			_tmp127_ = _tmp126_;
			_g_free0 (_tmp125_);
			location = _tmp127_;
			_tmp128_ = self->priv->list;
			_tmp129_ = *parent;
			gtk_tree_store_append (_tmp128_, &_tmp130_, &_tmp129_);
			__vala_GtkTreeIter_free0 (iter);
			_tmp131_ = _tmp130_;
			_tmp132_ = __vala_GtkTreeIter_copy0 (&_tmp131_);
			iter = _tmp132_;
			_tmp133_ = self->priv->list;
			_tmp134_ = iter;
			_tmp135_ = match;
			_tmp136_ = files_view_chrome_search_results_match_get_name (_tmp135_);
			_tmp137_ = _tmp136_;
			_tmp138_ = match;
			_tmp139_ = files_view_chrome_search_results_match_get_icon (_tmp138_);
			_tmp140_ = _tmp139_;
			_tmp141_ = location;
			_tmp142_ = match;
			_tmp143_ = files_view_chrome_search_results_match_get_file (_tmp142_);
			_tmp144_ = _tmp143_;
			_tmp145_ = match;
			_tmp146_ = files_view_chrome_search_results_match_get_sortkey (_tmp145_);
			_tmp147_ = _tmp146_;
			_tmp148_ = *_tmp134_;
			gtk_tree_store_set (_tmp133_, &_tmp148_, 0, _tmp137_, 1, _tmp140_, 2, _tmp141_, 3, _tmp144_, 4, TRUE, 5, _tmp147_, -1);
			_tmp149_ = self->priv->_n_results;
			files_view_chrome_search_results_set_n_results (self, _tmp149_ + 1);
			_tmp150_ = self->priv->search_tree_view;
			gtk_tree_view_expand_all (_tmp150_);
			_g_free0 (location);
			_g_object_unref0 (file);
			__vala_GtkTreeIter_free0 (iter);
			_g_object_unref0 (match);
		}
	}
	_tmp151_ = self->priv->_working;
	if (!_tmp151_) {
		files_view_chrome_search_results_resize_popup (self);
	}
}

static void
files_view_chrome_search_results_accept (FilesViewChromeSearchResults* self,
                                         GtkTreeIter* accepted,
                                         gboolean activate)
{
	gboolean _tmp0_ = FALSE;
	GFile* file = NULL;
	gchar* sortkey = NULL;
	gchar* _tmp4_;
	GtkTreeStore* _tmp5_;
	GtkTreeIter _tmp6_;
	GFile* _tmp7_ = NULL;
	GtkTreeStore* _tmp8_;
	GtkTreeIter _tmp9_;
	gchar* _tmp10_ = NULL;
	GFile* _tmp11_;
	g_return_if_fail (self != NULL);
	if (accepted == NULL) {
		GtkTreeIter _tmp1_ = {0};
		gboolean _tmp2_;
		GtkTreeIter _tmp3_;
		_tmp2_ = files_view_chrome_search_results_get_iter_at_cursor (self, &_tmp1_);
		_tmp3_ = _tmp1_;
		accepted = &_tmp3_;
		_tmp0_ = !_tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	file = NULL;
	_tmp4_ = g_strdup ("");
	sortkey = _tmp4_;
	_tmp5_ = self->priv->list;
	_tmp6_ = *accepted;
	gtk_tree_model_get ((GtkTreeModel*) _tmp5_, &_tmp6_, 3, &_tmp7_, -1);
	_g_object_unref0 (file);
	file = _tmp7_;
	_tmp8_ = self->priv->list;
	_tmp9_ = *accepted;
	gtk_tree_model_get ((GtkTreeModel*) _tmp8_, &_tmp9_, 5, &_tmp10_, -1);
	_g_free0 (sortkey);
	sortkey = _tmp10_;
	_tmp11_ = file;
	if (_tmp11_ == NULL) {
		const gchar* _tmp12_;
		_tmp12_ = sortkey;
		if (g_str_has_suffix (_tmp12_, FILES_VIEW_CHROME_SEARCH_RESULTS_ELLIPSIS_NAME)) {
			const gchar* _tmp13_;
			GFile* _tmp14_;
			self->priv->max_results = self->priv->max_results + FILES_VIEW_CHROME_SEARCH_RESULTS_MAX_RESULTS;
			self->priv->max_depth = self->priv->max_depth + 1;
			_tmp13_ = self->priv->search_term;
			_tmp14_ = self->priv->current_root;
			files_view_chrome_searchable_search ((FilesViewChromeSearchable*) self, _tmp13_, _tmp14_);
		} else {
			g_critical ("SearchResults.vala:767: Search match with no associated file and not a" \
"n ellipsis");
		}
		_g_free0 (sortkey);
		_g_object_unref0 (file);
		return;
	}
	files_view_chrome_searchable_cancel ((FilesViewChromeSearchable*) self);
	if (activate) {
		GFile* _tmp15_;
		_tmp15_ = file;
		g_signal_emit_by_name ((FilesViewChromeSearchable*) self, "file-activated", _tmp15_);
	} else {
		GFile* _tmp16_;
		_tmp16_ = file;
		g_signal_emit_by_name ((FilesViewChromeSearchable*) self, "file-selected", _tmp16_);
	}
	_g_free0 (sortkey);
	_g_object_unref0 (file);
}

static GFile*
files_view_chrome_search_results_get_file_at_iter (FilesViewChromeSearchResults* self,
                                                   GtkTreeIter* iter)
{
	GFile* file = NULL;
	GFile* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (iter == NULL) {
		GtkTreeIter _tmp0_ = {0};
		GtkTreeIter _tmp1_;
		files_view_chrome_search_results_get_iter_at_cursor (self, &_tmp0_);
		_tmp1_ = _tmp0_;
		iter = &_tmp1_;
	}
	file = NULL;
	if (iter != NULL) {
		GtkTreeStore* _tmp2_;
		GtkTreeIter _tmp3_;
		GFile* _tmp4_ = NULL;
		_tmp2_ = self->priv->list;
		_tmp3_ = *iter;
		gtk_tree_model_get ((GtkTreeModel*) _tmp2_, &_tmp3_, 3, &_tmp4_, -1);
		_g_object_unref0 (file);
		file = _tmp4_;
	}
	result = file;
	return result;
}

void
files_view_chrome_search_results_clear (FilesViewChromeSearchResults* self)
{
	GtkTreeIter parent = {0};
	GtkTreeIter iter = {0};
	g_return_if_fail (self != NULL);
	{
		gboolean valid = FALSE;
		GtkTreeStore* _tmp0_;
		GtkTreeIter _tmp1_ = {0};
		gboolean _tmp2_;
		_tmp0_ = self->priv->list;
		_tmp2_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp0_, &_tmp1_);
		parent = _tmp1_;
		valid = _tmp2_;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				GtkTreeStore* _tmp6_;
				GtkTreeIter _tmp7_;
				GtkTreeIter _tmp8_ = {0};
				gboolean _tmp9_;
				if (!_tmp3_) {
					GtkTreeStore* _tmp4_;
					gboolean _tmp5_;
					_tmp4_ = self->priv->list;
					_tmp5_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp4_, &parent);
					valid = _tmp5_;
				}
				_tmp3_ = FALSE;
				if (!valid) {
					break;
				}
				_tmp6_ = self->priv->list;
				_tmp7_ = parent;
				_tmp9_ = gtk_tree_model_iter_nth_child ((GtkTreeModel*) _tmp6_, &_tmp8_, &_tmp7_, 0);
				iter = _tmp8_;
				if (!_tmp9_) {
					continue;
				}
				while (TRUE) {
					GtkTreeStore* _tmp10_;
					gboolean _tmp11_;
					_tmp10_ = self->priv->list;
					_tmp11_ = gtk_tree_store_remove (_tmp10_, &iter);
					if (!_tmp11_) {
						break;
					}
				}
			}
		}
	}
}

static gboolean
files_view_chrome_search_results_send_search_finished (FilesViewChromeSearchResults* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GCancellable* _tmp2_;
	GtkTreeModelFilter* _tmp3_;
	gboolean _tmp4_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (!self->priv->local_search_finished) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = !self->priv->global_search_finished;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = !self->priv->allow_adding_results;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	files_view_chrome_search_results_set_working (self, FALSE);
	_tmp2_ = self->priv->current_operation;
	if (g_cancellable_is_cancelled (_tmp2_)) {
		result = FALSE;
		return result;
	}
	_tmp3_ = self->priv->filter;
	gtk_tree_model_filter_refilter (_tmp3_);
	if (self->priv->local_search_finished) {
		_tmp4_ = self->priv->global_search_finished;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		if (files_view_chrome_search_results_list_empty (self)) {
			GtkTreeView* _tmp5_;
			GtkTreeSelection* _tmp6_;
			_tmp5_ = self->priv->search_tree_view;
			_tmp6_ = gtk_tree_view_get_selection (_tmp5_);
			gtk_tree_selection_unselect_all (_tmp6_);
			g_signal_emit_by_name ((FilesViewChromeSearchable*) self, "first-match-found", NULL);
		} else {
			files_view_chrome_search_results_resize_popup (self);
			files_view_chrome_search_results_select_first (self);
		}
	}
	result = FALSE;
	return result;
}

static Block63Data*
block63_data_ref (Block63Data* _data63_)
{
	g_atomic_int_inc (&_data63_->_ref_count_);
	return _data63_;
}

static void
block63_data_unref (void * _userdata_)
{
	Block63Data* _data63_;
	_data63_ = (Block63Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data63_->_ref_count_)) {
		FilesViewChromeSearchResults* self;
		self = _data63_->self;
		_g_object_unref0 (_data63_->new_results);
		_g_object_unref0 (self);
		g_slice_free (Block63Data, _data63_);
	}
}

static gboolean
____lambda32_ (Block63Data* _data63_)
{
	FilesViewChromeSearchResults* self;
	GtkTreeIter* _tmp0_ = NULL;
	GeeLinkedList* _tmp3_;
	GtkTreeIter _tmp4_;
	gboolean result;
	self = _data63_->self;
	if (_data63_->in_root) {
		GtkTreeIter* _tmp1_;
		_tmp1_ = self->priv->local_results;
		_tmp0_ = _tmp1_;
	} else {
		GtkTreeIter* _tmp2_;
		_tmp2_ = self->priv->deep_results;
		_tmp0_ = _tmp2_;
	}
	_tmp3_ = _data63_->new_results;
	_tmp4_ = *_tmp0_;
	files_view_chrome_search_results_add_results (self, (GeeList*) _tmp3_, &_tmp4_);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
_____lambda32__gsource_func (gpointer self)
{
	gboolean result;
	result = ____lambda32_ (self);
	return result;
}

static void
files_view_chrome_search_results_visit (FilesViewChromeSearchResults* self,
                                        const gchar* term,
                                        gboolean include_hidden,
                                        GCancellable* cancel,
                                        GFile* root_folder)
{
	Block63Data* _data63_;
	GFile* folder = NULL;
	GeeQueue* _tmp0_;
	gpointer _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	gint _tmp4_ = 0;
	gint category_count = 0;
	gint depth = 0;
	GFile* f = NULL;
	GFile* _tmp5_;
	GFile* _tmp6_;
	gchar* path_string = NULL;
	gchar* _tmp7_;
	GFileEnumerator* enumerator = NULL;
	GeeLinkedList* _tmp28_;
	GFileInfo* info = NULL;
	FilesViewChromeSearchResultsCategory cat = 0;
	GeeLinkedList* _tmp58_;
	gint _tmp59_;
	gint _tmp60_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (term != NULL);
	g_return_if_fail (cancel != NULL);
	g_return_if_fail (root_folder != NULL);
	_data63_ = g_slice_new0 (Block63Data);
	_data63_->_ref_count_ = 1;
	_data63_->self = g_object_ref (self);
	_tmp0_ = self->priv->directory_queue;
	_tmp1_ = gee_queue_poll (_tmp0_);
	folder = (GFile*) _tmp1_;
	_tmp2_ = folder;
	if (_tmp2_ == NULL) {
		_g_object_unref0 (folder);
		block63_data_unref (_data63_);
		_data63_ = NULL;
		return;
	}
	_tmp3_ = folder;
	_data63_->in_root = g_file_equal (_tmp3_, root_folder);
	if (_data63_->in_root) {
		_tmp4_ = self->priv->current_count;
	} else {
		_tmp4_ = self->priv->deep_count;
	}
	category_count = _tmp4_;
	depth = 0;
	_tmp5_ = folder;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	f = _tmp6_;
	_tmp7_ = g_strdup ("");
	path_string = _tmp7_;
	while (TRUE) {
		gboolean _tmp8_ = FALSE;
		GFile* _tmp9_;
		gchar* _tmp12_ = NULL;
		const gchar* _tmp13_;
		GFile* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		GFile* _tmp21_;
		GFile* _tmp22_;
		gint _tmp23_;
		_tmp9_ = f;
		if (_tmp9_ != NULL) {
			GFile* _tmp10_;
			GFile* _tmp11_;
			_tmp10_ = f;
			_tmp11_ = self->priv->current_root;
			_tmp8_ = !g_file_equal (_tmp10_, _tmp11_);
		} else {
			_tmp8_ = FALSE;
		}
		if (!_tmp8_) {
			break;
		}
		_tmp13_ = path_string;
		if (g_strcmp0 (_tmp13_, "") == 0) {
			gchar* _tmp14_;
			_tmp14_ = g_strdup ("");
			_g_free0 (_tmp12_);
			_tmp12_ = _tmp14_;
		} else {
			const gchar* _tmp15_;
			gchar* _tmp16_;
			_tmp15_ = path_string;
			_tmp16_ = g_strconcat (G_DIR_SEPARATOR_S, _tmp15_, NULL);
			_g_free0 (_tmp12_);
			_tmp12_ = _tmp16_;
		}
		_tmp17_ = f;
		_tmp18_ = g_file_get_basename (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = g_strconcat (_tmp19_, _tmp12_, NULL);
		_g_free0 (path_string);
		path_string = _tmp20_;
		_g_free0 (_tmp19_);
		_tmp21_ = f;
		_tmp22_ = g_file_get_parent (_tmp21_);
		_g_object_unref0 (f);
		f = _tmp22_;
		_tmp23_ = depth;
		depth = _tmp23_ + 1;
		_g_free0 (_tmp12_);
	}
	if (depth > self->priv->max_depth) {
		_g_free0 (path_string);
		_g_object_unref0 (f);
		_g_object_unref0 (folder);
		block63_data_unref (_data63_);
		_data63_ = NULL;
		return;
	}
	{
		GFileEnumerator* _tmp24_ = NULL;
		GFile* _tmp25_;
		GFileEnumerator* _tmp26_;
		GFileEnumerator* _tmp27_;
		_tmp25_ = folder;
		_tmp26_ = g_file_enumerate_children (_tmp25_, FILES_VIEW_CHROME_SEARCH_RESULTS_ATTRIBUTES, 0, cancel, &_inner_error0_);
		_tmp24_ = _tmp26_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp27_ = _tmp24_;
		_tmp24_ = NULL;
		_g_object_unref0 (enumerator);
		enumerator = _tmp27_;
		_g_object_unref0 (_tmp24_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		_g_object_unref0 (enumerator);
		_g_free0 (path_string);
		_g_object_unref0 (f);
		_g_object_unref0 (folder);
		block63_data_unref (_data63_);
		_data63_ = NULL;
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (enumerator);
		_g_free0 (path_string);
		_g_object_unref0 (f);
		_g_object_unref0 (folder);
		block63_data_unref (_data63_);
		_data63_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp28_ = gee_linked_list_new (FILES_VIEW_CHROME_SEARCH_RESULTS_TYPE_MATCH, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_data63_->new_results = _tmp28_;
	info = NULL;
	{
		while (TRUE) {
			gboolean _tmp29_ = FALSE;
			gboolean _tmp30_ = FALSE;
			gboolean _tmp36_ = FALSE;
			GFileInfo* _tmp37_;
			GFileInfo* _tmp38_;
			gboolean begins_with = FALSE;
			GFileInfo* _tmp45_;
			const gchar* _tmp46_;
			gboolean _tmp47_ = FALSE;
			gboolean _tmp48_;
			if (!g_cancellable_is_cancelled (cancel)) {
				GFileInfo* _tmp31_ = NULL;
				GFileEnumerator* _tmp32_;
				GFileInfo* _tmp33_;
				GFileInfo* _tmp34_;
				GFileInfo* _tmp35_;
				_tmp32_ = enumerator;
				_tmp33_ = g_file_enumerator_next_file (_tmp32_, NULL, &_inner_error0_);
				_tmp31_ = _tmp33_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch1_g_error;
				}
				_tmp34_ = _tmp31_;
				_tmp31_ = NULL;
				_g_object_unref0 (info);
				info = _tmp34_;
				_tmp35_ = info;
				_tmp30_ = _tmp35_ != NULL;
				_g_object_unref0 (_tmp31_);
			} else {
				_tmp30_ = FALSE;
			}
			if (_tmp30_) {
				_tmp29_ = category_count < self->priv->max_results;
			} else {
				_tmp29_ = FALSE;
			}
			if (!_tmp29_) {
				break;
			}
			_tmp37_ = info;
			if (g_file_info_get_attribute_boolean (_tmp37_, G_FILE_ATTRIBUTE_STANDARD_IS_HIDDEN)) {
				_tmp36_ = !include_hidden;
			} else {
				_tmp36_ = FALSE;
			}
			if (_tmp36_) {
				continue;
			}
			_tmp38_ = info;
			if (g_file_info_get_file_type (_tmp38_) == G_FILE_TYPE_DIRECTORY) {
				GeeQueue* _tmp39_;
				GFile* _tmp40_;
				GFileInfo* _tmp41_;
				const gchar* _tmp42_;
				GFile* _tmp43_;
				GFile* _tmp44_;
				_tmp39_ = self->priv->directory_queue;
				_tmp40_ = folder;
				_tmp41_ = info;
				_tmp42_ = g_file_info_get_name (_tmp41_);
				_tmp43_ = g_file_resolve_relative_path (_tmp40_, _tmp42_);
				_tmp44_ = _tmp43_;
				gee_collection_add ((GeeCollection*) _tmp39_, _tmp44_);
				_g_object_unref0 (_tmp44_);
			}
			_tmp45_ = info;
			_tmp46_ = g_file_info_get_display_name (_tmp45_);
			_tmp48_ = files_view_chrome_search_results_term_matches (self, term, _tmp46_, &_tmp47_);
			begins_with = _tmp47_;
			if (_tmp48_) {
				GeeLinkedList* _tmp51_;
				GFileInfo* _tmp52_;
				const gchar* _tmp53_;
				GFile* _tmp54_;
				FilesViewChromeSearchResultsMatch* _tmp55_;
				FilesViewChromeSearchResultsMatch* _tmp56_;
				gint _tmp57_;
				if (_data63_->in_root) {
					FilesViewChromeSearchResultsCategory _tmp49_ = 0;
					if (begins_with) {
						_tmp49_ = FILES_VIEW_CHROME_SEARCH_RESULTS_CATEGORY_CURRENT_BEGINS;
					} else {
						_tmp49_ = FILES_VIEW_CHROME_SEARCH_RESULTS_CATEGORY_CURRENT_CONTAINS;
					}
					cat = _tmp49_;
				} else {
					FilesViewChromeSearchResultsCategory _tmp50_ = 0;
					if (begins_with) {
						_tmp50_ = FILES_VIEW_CHROME_SEARCH_RESULTS_CATEGORY_DEEP_BEGINS;
					} else {
						_tmp50_ = FILES_VIEW_CHROME_SEARCH_RESULTS_CATEGORY_DEEP_CONTAINS;
					}
					cat = _tmp50_;
				}
				_tmp51_ = _data63_->new_results;
				_tmp52_ = info;
				_tmp53_ = path_string;
				_tmp54_ = folder;
				_tmp55_ = files_view_chrome_search_results_match_new (_tmp52_, _tmp53_, _tmp54_, cat);
				_tmp56_ = _tmp55_;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp51_, _tmp56_);
				_g_object_unref0 (_tmp56_);
				_tmp57_ = category_count;
				category_count = _tmp57_ + 1;
			}
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		g_clear_error (&_inner_error0_);
		g_warning ("SearchResults.vala:903: Error enumerating in visit");
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (info);
		_g_object_unref0 (enumerator);
		_g_free0 (path_string);
		_g_object_unref0 (f);
		_g_object_unref0 (folder);
		block63_data_unref (_data63_);
		_data63_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp58_ = _data63_->new_results;
	_tmp59_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp58_);
	_tmp60_ = _tmp59_;
	if (_tmp60_ < 1) {
		FilesViewChromeSearchResultsCategory _tmp61_ = 0;
		GeeLinkedList* _tmp62_;
		FilesViewChromeSearchResultsMatch* _tmp63_;
		FilesViewChromeSearchResultsMatch* _tmp64_;
		if (_data63_->in_root) {
			_tmp61_ = FILES_VIEW_CHROME_SEARCH_RESULTS_CATEGORY_CURRENT_ELLIPSIS;
		} else {
			_tmp61_ = FILES_VIEW_CHROME_SEARCH_RESULTS_CATEGORY_DEEP_ELLIPSIS;
		}
		cat = _tmp61_;
		_tmp62_ = _data63_->new_results;
		_tmp63_ = files_view_chrome_search_results_match_new_ellipsis (cat);
		_tmp64_ = _tmp63_;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp62_, _tmp64_);
		_g_object_unref0 (_tmp64_);
		_g_object_unref0 (info);
		_g_object_unref0 (enumerator);
		_g_free0 (path_string);
		_g_object_unref0 (f);
		_g_object_unref0 (folder);
		block63_data_unref (_data63_);
		_data63_ = NULL;
		return;
	} else {
		if (!g_cancellable_is_cancelled (cancel)) {
			gboolean _tmp69_ = FALSE;
			if (_data63_->in_root) {
				self->priv->current_count = category_count;
			} else {
				self->priv->deep_count = category_count;
			}
			g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _____lambda32__gsource_func, block63_data_ref (_data63_), block63_data_unref);
			if (category_count >= self->priv->max_results) {
				FilesViewChromeSearchResultsCategory _tmp65_ = 0;
				GeeLinkedList* _tmp66_;
				FilesViewChromeSearchResultsMatch* _tmp67_;
				FilesViewChromeSearchResultsMatch* _tmp68_;
				if (_data63_->in_root) {
					_tmp65_ = FILES_VIEW_CHROME_SEARCH_RESULTS_CATEGORY_CURRENT_ELLIPSIS;
				} else {
					_tmp65_ = FILES_VIEW_CHROME_SEARCH_RESULTS_CATEGORY_DEEP_ELLIPSIS;
				}
				cat = _tmp65_;
				_tmp66_ = _data63_->new_results;
				_tmp67_ = files_view_chrome_search_results_match_new_ellipsis (cat);
				_tmp68_ = _tmp67_;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp66_, _tmp68_);
				_g_object_unref0 (_tmp68_);
				_g_object_unref0 (info);
				_g_object_unref0 (enumerator);
				_g_free0 (path_string);
				_g_object_unref0 (f);
				_g_object_unref0 (folder);
				block63_data_unref (_data63_);
				_data63_ = NULL;
				return;
			}
			if (self->priv->current_count >= self->priv->max_results) {
				_tmp69_ = self->priv->deep_count >= self->priv->max_results;
			} else {
				_tmp69_ = FALSE;
			}
			if (_tmp69_) {
				g_cancellable_cancel (cancel);
			}
		}
	}
	_g_object_unref0 (info);
	_g_object_unref0 (enumerator);
	_g_free0 (path_string);
	_g_object_unref0 (f);
	_g_object_unref0 (folder);
	block63_data_unref (_data63_);
	_data63_ = NULL;
}

static void
files_view_chrome_search_results_get_zg_results_data_free (gpointer _data)
{
	FilesViewChromeSearchResultsGetZgResultsData* _data_;
	_data_ = _data;
	_g_free0 (_data_->term);
	_g_object_unref0 (_data_->self);
	g_slice_free (FilesViewChromeSearchResultsGetZgResultsData, _data_);
}

static void
files_view_chrome_search_results_get_zg_results (FilesViewChromeSearchResults* self,
                                                 const gchar* term,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_)
{
	FilesViewChromeSearchResultsGetZgResultsData* _data_;
	FilesViewChromeSearchResults* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (term != NULL);
	_data_ = g_slice_new0 (FilesViewChromeSearchResultsGetZgResultsData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, files_view_chrome_search_results_get_zg_results_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (term);
	_g_free0 (_data_->term);
	_data_->term = _tmp1_;
	files_view_chrome_search_results_get_zg_results_co (_data_);
}

static void
files_view_chrome_search_results_get_zg_results_finish (FilesViewChromeSearchResults* self,
                                                        GAsyncResult* _res_)
{
	FilesViewChromeSearchResultsGetZgResultsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
files_view_chrome_search_results_get_zg_results_ready (GObject* source_object,
                                                       GAsyncResult* _res_,
                                                       gpointer _user_data_)
{
	FilesViewChromeSearchResultsGetZgResultsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	files_view_chrome_search_results_get_zg_results_co (_data_);
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gboolean
files_view_chrome_search_results_get_zg_results_co (FilesViewChromeSearchResultsGetZgResultsData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->self->priv->global_search_finished = FALSE;
	{
		_data_->_tmp1_ = _data_->self->priv->zg_index;
		_data_->_tmp2_ = g_strconcat ("name:", _data_->term, NULL);
		_data_->_tmp3_ = _data_->_tmp2_;
		_data_->_tmp4_ = g_strconcat (_data_->_tmp3_, "*", NULL);
		_data_->_tmp5_ = _data_->_tmp4_;
		_data_->_tmp6_ = zeitgeist_time_range_new_anytime ();
		_data_->_tmp7_ = _data_->_tmp6_;
		_data_->_tmp8_ = _data_->self->priv->templates;
		_data_->_tmp9_ = _data_->self->priv->current_operation;
		_data_->_state_ = 1;
		zeitgeist_index_search (_data_->_tmp1_, _data_->_tmp5_, _data_->_tmp7_, _data_->_tmp8_, (guint32) 0, (guint32) (_data_->self->priv->max_results * 3), ZEITGEIST_RESULT_TYPE_MOST_POPULAR_SUBJECTS, _data_->_tmp9_, files_view_chrome_search_results_get_zg_results_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp10_ = zeitgeist_index_search_finish (_data_->_tmp1_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp11_ = _data_->_tmp10_;
		_g_object_unref0 (_data_->_tmp7_);
		_g_free0 (_data_->_tmp5_);
		_g_free0 (_data_->_tmp3_);
		_data_->_tmp0_ = _data_->_tmp11_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			if (g_error_matches (_data_->_inner_error0_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
				goto __catch0_g_io_error_cancelled;
			}
			goto __catch0_g_error;
		}
		_data_->_tmp12_ = _data_->_tmp0_;
		_data_->_tmp0_ = NULL;
		_g_object_unref0 (_data_->results);
		_data_->results = _data_->_tmp12_;
		_g_object_unref0 (_data_->_tmp0_);
	}
	goto __finally0;
	__catch0_g_io_error_cancelled:
	{
		g_clear_error (&_data_->_inner_error0_);
		_data_->self->priv->global_search_finished = TRUE;
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _files_view_chrome_search_results_send_search_finished_gsource_func, g_object_ref (_data_->self), g_object_unref);
		_g_object_unref0 (_data_->results);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp13_ = _data_->e;
		_data_->_tmp14_ = _data_->_tmp13_->message;
		g_warning ("SearchResults.vala:952: Fetching results for term '%s' from zeitgeist " \
"failed: %s", _data_->term, _data_->_tmp14_);
		_data_->self->priv->global_search_finished = TRUE;
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _files_view_chrome_search_results_send_search_finished_gsource_func, g_object_ref (_data_->self), g_object_unref);
		_g_error_free0 (_data_->e);
		_g_object_unref0 (_data_->results);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->results);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp15_ = gee_linked_list_new (FILES_VIEW_CHROME_SEARCH_RESULTS_TYPE_MATCH, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_data_->matches = _data_->_tmp15_;
	_data_->_tmp16_ = g_get_home_dir ();
	_data_->_tmp17_ = g_file_new_for_path (_data_->_tmp16_);
	_data_->home = _data_->_tmp17_;
	_data_->i = 0;
	while (TRUE) {
		_data_->_tmp20_ = _data_->results;
		if (zeitgeist_result_set_has_next (_data_->_tmp20_)) {
			_data_->_tmp21_ = _data_->self->priv->current_operation;
			_data_->_tmp19_ = !g_cancellable_is_cancelled (_data_->_tmp21_);
		} else {
			_data_->_tmp19_ = FALSE;
		}
		if (_data_->_tmp19_) {
			_data_->_tmp18_ = !_data_->self->priv->global_search_finished;
		} else {
			_data_->_tmp18_ = FALSE;
		}
		if (!_data_->_tmp18_) {
			break;
		}
		_data_->_tmp22_ = _data_->results;
		_data_->_tmp23_ = zeitgeist_result_set_next_value (_data_->_tmp22_);
		_data_->_result_ = _data_->_tmp23_;
		_data_->_tmp24_ = _data_->_result_;
		_data_->_tmp25_ = zeitgeist_event_get_subjects (_data_->_tmp24_);
		_data_->_tmp26_ = _data_->_tmp25_;
		_data_->_tmp27_ = _data_->_tmp26_->pdata;
		_data_->_tmp27__length1 = _data_->_tmp26_->len;
		{
			_data_->subject_collection_length1 = 0;
			_data_->_subject_collection_size_ = 0;
			_data_->subject_collection = _data_->_tmp27_;
			_data_->subject_collection_length1 = _data_->_tmp27__length1;
			for (_data_->subject_it = 0; _data_->subject_it < _data_->subject_collection_length1; _data_->subject_it = _data_->subject_it + 1) {
				_data_->_tmp28_ = _g_object_ref0 (_data_->subject_collection[_data_->subject_it]);
				_data_->subject = _data_->_tmp28_;
				{
					if (_data_->i == _data_->self->priv->max_results) {
						_data_->_tmp29_ = _data_->matches;
						_data_->_tmp30_ = files_view_chrome_search_results_match_new_ellipsis (FILES_VIEW_CHROME_SEARCH_RESULTS_CATEGORY_ZEITGEIST_ELLIPSIS);
						_data_->_tmp31_ = _data_->_tmp30_;
						gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp29_, _data_->_tmp31_);
						_g_object_unref0 (_data_->_tmp31_);
						_data_->self->priv->global_search_finished = TRUE;
						_g_object_unref0 (_data_->subject);
						break;
					}
					{
						_data_->_tmp32_ = _data_->subject;
						_data_->_tmp33_ = zeitgeist_subject_get_uri (_data_->_tmp32_);
						_data_->_tmp34_ = _data_->_tmp33_;
						_data_->_tmp35_ = g_file_new_for_uri (_data_->_tmp34_);
						_data_->file = _data_->_tmp35_;
						while (TRUE) {
							_data_->_tmp37_ = _data_->file;
							if (_data_->_tmp37_ != NULL) {
								_data_->_tmp38_ = _data_->file;
								_data_->_tmp39_ = g_file_get_basename (_data_->_tmp38_);
								_data_->_tmp40_ = _data_->_tmp39_;
								_data_->_tmp36_ = !string_contains (_data_->_tmp40_, _data_->term);
								_g_free0 (_data_->_tmp40_);
							} else {
								_data_->_tmp36_ = FALSE;
							}
							if (!_data_->_tmp36_) {
								break;
							}
							_data_->_tmp41_ = _data_->file;
							_data_->_tmp42_ = g_file_get_parent (_data_->_tmp41_);
							_g_object_unref0 (_data_->file);
							_data_->file = _data_->_tmp42_;
						}
						_data_->_tmp43_ = _data_->file;
						if (_data_->_tmp43_ != NULL) {
							_data_->_tmp44_ = g_strdup ("");
							_data_->path_string = _data_->_tmp44_;
							_data_->_tmp45_ = _data_->file;
							_data_->_tmp46_ = _g_object_ref0 (_data_->_tmp45_);
							_data_->parent = _data_->_tmp46_;
							while (TRUE) {
								_data_->_tmp47_ = _data_->parent;
								_data_->_tmp48_ = g_file_get_parent (_data_->_tmp47_);
								_g_object_unref0 (_data_->parent);
								_data_->parent = _data_->_tmp48_;
								_data_->_tmp49_ = _data_->parent;
								if (!(_data_->_tmp49_ != NULL)) {
									break;
								}
								_data_->_tmp50_ = _data_->parent;
								_data_->_tmp51_ = _data_->self->priv->current_root;
								if (g_file_equal (_data_->_tmp50_, _data_->_tmp51_)) {
									break;
								}
								_data_->_tmp52_ = _data_->parent;
								_data_->_tmp53_ = _data_->home;
								if (g_file_equal (_data_->_tmp52_, _data_->_tmp53_)) {
									_data_->_tmp54_ = _data_->path_string;
									_data_->_tmp55_ = g_strconcat ("~/", _data_->_tmp54_, NULL);
									_g_free0 (_data_->path_string);
									_data_->path_string = _data_->_tmp55_;
									break;
								}
								_data_->_tmp56_ = _data_->path_string;
								if (g_strcmp0 (_data_->_tmp56_, "") == 0) {
									_data_->_tmp57_ = _data_->parent;
									_data_->_tmp58_ = g_file_get_basename (_data_->_tmp57_);
									_g_free0 (_data_->path_string);
									_data_->path_string = _data_->_tmp58_;
								} else {
									_data_->_tmp59_ = _data_->parent;
									_data_->_tmp60_ = g_file_get_basename (_data_->_tmp59_);
									_data_->_tmp61_ = _data_->_tmp60_;
									_data_->_tmp62_ = _data_->path_string;
									_data_->_tmp63_ = g_build_path (G_DIR_SEPARATOR_S, _data_->_tmp61_, _data_->_tmp62_, NULL);
									_g_free0 (_data_->path_string);
									_data_->path_string = _data_->_tmp63_;
									_g_free0 (_data_->_tmp61_);
								}
							}
							_data_->found = FALSE;
							{
								_data_->_tmp64_ = _data_->matches;
								_data_->_m_list = _data_->_tmp64_;
								_data_->_tmp65_ = _data_->_m_list;
								_data_->_tmp66_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data_->_tmp65_);
								_data_->_tmp67_ = _data_->_tmp66_;
								_data_->_m_size = _data_->_tmp67_;
								_data_->_m_index = -1;
								while (TRUE) {
									_data_->_m_index = _data_->_m_index + 1;
									_data_->_tmp68_ = _data_->_m_index;
									_data_->_tmp69_ = _data_->_m_size;
									if (!(_data_->_tmp68_ < _data_->_tmp69_)) {
										break;
									}
									_data_->_tmp70_ = _data_->_m_list;
									_data_->_tmp71_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp70_, _data_->_m_index);
									_data_->m = (FilesViewChromeSearchResultsMatch*) _data_->_tmp71_;
									_data_->_tmp72_ = _data_->m;
									_data_->_tmp73_ = files_view_chrome_search_results_match_get_path_string (_data_->_tmp72_);
									_data_->_tmp74_ = _data_->_tmp73_;
									_data_->_tmp75_ = _data_->path_string;
									if (g_strcmp0 (_data_->_tmp74_, _data_->_tmp75_) == 0) {
										_data_->found = TRUE;
										_g_object_unref0 (_data_->m);
										break;
									}
									_g_object_unref0 (_data_->m);
								}
							}
							if (!_data_->found) {
								_data_->_tmp76_ = _data_->file;
								_data_->_tmp77_ = _data_->self->priv->current_operation;
								_data_->_state_ = 2;
								g_file_query_info_async (_data_->_tmp76_, FILES_VIEW_CHROME_SEARCH_RESULTS_ATTRIBUTES, 0, G_PRIORITY_DEFAULT, _data_->_tmp77_, files_view_chrome_search_results_get_zg_results_ready, _data_);
								return FALSE;
								_state_2:
								_data_->_tmp78_ = g_file_query_info_finish (_data_->_tmp76_, _data_->_res_, &_data_->_inner_error0_);
								_data_->info = _data_->_tmp78_;
								if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
									_g_object_unref0 (_data_->parent);
									_g_free0 (_data_->path_string);
									_g_object_unref0 (_data_->file);
									goto __catch1_g_error;
								}
								_data_->_tmp79_ = _data_->info;
								_data_->_tmp80_ = g_file_info_get_display_name (_data_->_tmp79_);
								_data_->_tmp81_ = g_strdup (_data_->_tmp80_);
								_data_->name = _data_->_tmp81_;
								_data_->_tmp83_ = _data_->name;
								if (g_str_has_prefix (_data_->_tmp83_, _data_->term)) {
									_data_->_tmp82_ = FILES_VIEW_CHROME_SEARCH_RESULTS_CATEGORY_ZEITGEIST_BEGINS;
								} else {
									_data_->_tmp82_ = FILES_VIEW_CHROME_SEARCH_RESULTS_CATEGORY_ZEITGEIST_CONTAINS;
								}
								_data_->cat = _data_->_tmp82_;
								_data_->_tmp84_ = _data_->matches;
								_data_->_tmp85_ = _data_->info;
								_data_->_tmp86_ = _data_->path_string;
								_data_->_tmp87_ = _data_->file;
								_data_->_tmp88_ = g_file_get_parent (_data_->_tmp87_);
								_data_->_tmp89_ = _data_->_tmp88_;
								_data_->_tmp90_ = files_view_chrome_search_results_match_new (_data_->_tmp85_, _data_->_tmp86_, _data_->_tmp89_, _data_->cat);
								_data_->_tmp91_ = _data_->_tmp90_;
								gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp84_, _data_->_tmp91_);
								_g_object_unref0 (_data_->_tmp91_);
								_g_object_unref0 (_data_->_tmp89_);
								_data_->_tmp92_ = _data_->i;
								_data_->i = _data_->_tmp92_ + 1;
								_g_free0 (_data_->name);
								_g_object_unref0 (_data_->info);
							}
							_g_object_unref0 (_data_->parent);
							_g_free0 (_data_->path_string);
						}
						_g_object_unref0 (_data_->file);
					}
					goto __finally1;
					__catch1_g_error:
					{
						g_clear_error (&_data_->_inner_error0_);
					}
					__finally1:
					if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
						_g_object_unref0 (_data_->subject);
						_g_object_unref0 (_data_->_result_);
						_g_object_unref0 (_data_->home);
						_g_object_unref0 (_data_->matches);
						_g_object_unref0 (_data_->results);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
						g_clear_error (&_data_->_inner_error0_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					}
					_g_object_unref0 (_data_->subject);
				}
			}
		}
		_g_object_unref0 (_data_->_result_);
	}
	_data_->_tmp93_ = _data_->self->priv->current_operation;
	if (!g_cancellable_is_cancelled (_data_->_tmp93_)) {
		_data_->_tmp94_ = _data_->matches;
		_data_->_tmp95_ = _data_->self->priv->zeitgeist_results;
		_data_->_tmp96_ = *_data_->_tmp95_;
		files_view_chrome_search_results_add_results (_data_->self, (GeeList*) _data_->_tmp94_, &_data_->_tmp96_);
	}
	_data_->self->priv->global_search_finished = TRUE;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _files_view_chrome_search_results_send_search_finished_gsource_func, g_object_ref (_data_->self), g_object_unref);
	_g_object_unref0 (_data_->home);
	_g_object_unref0 (_data_->matches);
	_g_object_unref0 (_data_->results);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gboolean
files_view_chrome_search_results_term_matches (FilesViewChromeSearchResults* self,
                                               const gchar* term,
                                               const gchar* name,
                                               gboolean* begins_with)
{
	gboolean _vala_begins_with = FALSE;
	gchar* n = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (term != NULL, FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	_tmp0_ = g_utf8_normalize (name, (gssize) -1, G_NORMALIZE_DEFAULT);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_utf8_casefold (_tmp1_, (gssize) -1);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	n = _tmp3_;
	_vala_begins_with = g_str_has_prefix (n, term);
	result = string_contains (n, term);
	_g_free0 (n);
	if (begins_with) {
		*begins_with = _vala_begins_with;
	}
	return result;
}

static void
_files_view_chrome_search_results_on_cursor_changed_gtk_tree_view_cursor_changed (GtkTreeView* _sender,
                                                                                  gpointer self)
{
	files_view_chrome_search_results_on_cursor_changed ((FilesViewChromeSearchResults*) self);
}

static void
files_view_chrome_search_results_connect_view_cursor_changed_signal (FilesViewChromeSearchResults* self)
{
	GtkTreeView* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->search_tree_view;
	g_signal_connect_object (_tmp0_, "cursor-changed", (GCallback) _files_view_chrome_search_results_on_cursor_changed_gtk_tree_view_cursor_changed, self, 0);
}

static void
files_view_chrome_search_results_disconnect_view_cursor_changed_signal (FilesViewChromeSearchResults* self)
{
	GtkTreeView* _tmp0_;
	guint _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->search_tree_view;
	g_signal_parse_name ("cursor-changed", gtk_tree_view_get_type (), &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _files_view_chrome_search_results_on_cursor_changed_gtk_tree_view_cursor_changed, self);
}

gboolean
files_view_chrome_search_results_get_working (FilesViewChromeSearchResults* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_working;
	return result;
}

static void
files_view_chrome_search_results_set_working (FilesViewChromeSearchResults* self,
                                              gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = files_view_chrome_search_results_get_working (self);
	if (old_value != value) {
		self->priv->_working = value;
		g_object_notify_by_pspec ((GObject *) self, files_view_chrome_search_results_properties[FILES_VIEW_CHROME_SEARCH_RESULTS_WORKING_PROPERTY]);
	}
}

gboolean
files_view_chrome_search_results_get_is_active (FilesViewChromeSearchResults* self)
{
	gboolean result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->search_term;
	result = g_strcmp0 (_tmp0_, "") != 0;
	return result;
}

gint
files_view_chrome_search_results_get_n_results (FilesViewChromeSearchResults* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_n_results;
	return result;
}

static void
files_view_chrome_search_results_set_n_results (FilesViewChromeSearchResults* self,
                                                gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = files_view_chrome_search_results_get_n_results (self);
	if (old_value != value) {
		self->priv->_n_results = value;
		g_object_notify_by_pspec ((GObject *) self, files_view_chrome_search_results_properties[FILES_VIEW_CHROME_SEARCH_RESULTS_N_RESULTS_PROPERTY]);
	}
}

GtkWidget*
files_view_chrome_search_results_get_delegate_widget (FilesViewChromeSearchResults* self)
{
	GtkWidget* result;
	GtkWidget* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_delegate_widget;
	result = _tmp0_;
	return result;
}

static void
files_view_chrome_search_results_set_delegate_widget (FilesViewChromeSearchResults* self,
                                                      GtkWidget* value)
{
	GtkWidget* old_value;
	g_return_if_fail (self != NULL);
	old_value = files_view_chrome_search_results_get_delegate_widget (self);
	if (old_value != value) {
		GtkWidget* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_delegate_widget);
		self->priv->_delegate_widget = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, files_view_chrome_search_results_properties[FILES_VIEW_CHROME_SEARCH_RESULTS_DELEGATE_WIDGET_PROPERTY]);
	}
}

static inline gpointer
files_view_chrome_search_results_match_get_instance_private (FilesViewChromeSearchResultsMatch* self)
{
	return G_STRUCT_MEMBER_P (self, FilesViewChromeSearchResultsMatch_private_offset);
}

static FilesViewChromeSearchResultsMatch*
files_view_chrome_search_results_match_construct (GType object_type,
                                                  GFileInfo* info,
                                                  const gchar* path_string,
                                                  GFile* parent,
                                                  FilesViewChromeSearchResultsCategory category)
{
	FilesViewChromeSearchResultsMatch * self = NULL;
	gchar* _name = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	GObject* _tmp5_;
	const gchar* _tmp6_;
	GFile* _tmp7_;
	GFile* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	g_return_val_if_fail (info != NULL, NULL);
	g_return_val_if_fail (path_string != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	_tmp0_ = g_file_info_get_display_name (info);
	_tmp1_ = g_strdup (_tmp0_);
	_name = _tmp1_;
	_tmp2_ = g_markup_escape_text (_name, (gssize) -1);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_file_info_get_attribute_string (info, G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE);
	_tmp5_ = g_file_info_get_attribute_object (info, G_FILE_ATTRIBUTE_STANDARD_ICON);
	_tmp6_ = g_file_info_get_name (info);
	_tmp7_ = g_file_resolve_relative_path (parent, _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = files_view_chrome_search_results_category_to_string (category);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_strconcat (_tmp10_, _name, NULL);
	_tmp12_ = _tmp11_;
	self = (FilesViewChromeSearchResultsMatch*) g_object_new (object_type, "name", _tmp3_, "mime", _tmp4_, "icon", G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, g_icon_get_type ()) ? ((GIcon*) _tmp5_) : NULL, "path-string", path_string, "file", _tmp8_, "sortkey", _tmp12_, NULL);
	_g_free0 (_tmp12_);
	_g_free0 (_tmp10_);
	_g_object_unref0 (_tmp8_);
	_g_free0 (_tmp3_);
	_g_free0 (_name);
	return self;
}

static FilesViewChromeSearchResultsMatch*
files_view_chrome_search_results_match_new (GFileInfo* info,
                                            const gchar* path_string,
                                            GFile* parent,
                                            FilesViewChromeSearchResultsCategory category)
{
	return files_view_chrome_search_results_match_construct (FILES_VIEW_CHROME_SEARCH_RESULTS_TYPE_MATCH, info, path_string, parent, category);
}

static FilesViewChromeSearchResultsMatch*
files_view_chrome_search_results_match_construct_from_bookmark (GType object_type,
                                                                FilesBookmark* bookmark,
                                                                FilesViewChromeSearchResultsCategory category)
{
	FilesViewChromeSearchResultsMatch * self = NULL;
	gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _name = NULL;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	GIcon* _tmp19_;
	GIcon* _tmp20_;
	GFile* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	g_return_val_if_fail (bookmark != NULL, NULL);
	_tmp2_ = files_bookmark_get_custom_name (bookmark);
	_tmp3_ = _tmp2_;
	if (g_strcmp0 (_tmp3_, "") != 0) {
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		_tmp4_ = files_bookmark_get_custom_name (bookmark);
		_tmp5_ = _tmp4_;
		_tmp6_ = files_bookmark_get_basename (bookmark);
		_tmp7_ = _tmp6_;
		_tmp1_ = g_strcmp0 (_tmp5_, _tmp7_) != 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp8_ = files_bookmark_get_custom_name (bookmark);
		_tmp9_ = _tmp8_;
		_tmp10_ = files_bookmark_get_basename (bookmark);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_strdup_printf (_ ("%s (%s)"), _tmp9_, _tmp11_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp12_;
	} else {
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp13_ = files_bookmark_get_basename (bookmark);
		_tmp14_ = _tmp13_;
		_tmp15_ = g_strdup (_tmp14_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp15_;
	}
	_tmp16_ = g_strdup (_tmp0_);
	_name = _tmp16_;
	_tmp17_ = g_markup_escape_text (_name, (gssize) -1);
	_tmp18_ = _tmp17_;
	_tmp19_ = files_bookmark_get_icon (bookmark);
	_tmp20_ = _tmp19_;
	_tmp21_ = files_bookmark_get_location (bookmark);
	_tmp22_ = files_view_chrome_search_results_category_to_string (category);
	_tmp23_ = _tmp22_;
	_tmp24_ = g_strconcat (_tmp23_, _name, NULL);
	_tmp25_ = _tmp24_;
	self = (FilesViewChromeSearchResultsMatch*) g_object_new (object_type, "name", _tmp18_, "mime", "inode/directory", "icon", _tmp20_, "path-string", "", "file", _tmp21_, "sortkey", _tmp25_, NULL);
	_g_free0 (_tmp25_);
	_g_free0 (_tmp23_);
	_g_object_unref0 (_tmp20_);
	_g_free0 (_tmp18_);
	_g_free0 (_name);
	_g_free0 (_tmp0_);
	return self;
}

static FilesViewChromeSearchResultsMatch*
files_view_chrome_search_results_match_new_from_bookmark (FilesBookmark* bookmark,
                                                          FilesViewChromeSearchResultsCategory category)
{
	return files_view_chrome_search_results_match_construct_from_bookmark (FILES_VIEW_CHROME_SEARCH_RESULTS_TYPE_MATCH, bookmark, category);
}

static FilesViewChromeSearchResultsMatch*
files_view_chrome_search_results_match_construct_ellipsis (GType object_type,
                                                           FilesViewChromeSearchResultsCategory category)
{
	FilesViewChromeSearchResultsMatch * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	_tmp0_ = g_strconcat ("<b>", _ ("More Results …"), NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat (_tmp1_, "</b>", NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = files_view_chrome_search_results_category_to_string (category);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat (_tmp5_, FILES_VIEW_CHROME_SEARCH_RESULTS_ELLIPSIS_NAME, NULL);
	_tmp7_ = _tmp6_;
	self = (FilesViewChromeSearchResultsMatch*) g_object_new (object_type, "name", _tmp3_, "mime", "", "icon", NULL, "path-string", "", "file", NULL, "sortkey", _tmp7_, NULL);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	return self;
}

static FilesViewChromeSearchResultsMatch*
files_view_chrome_search_results_match_new_ellipsis (FilesViewChromeSearchResultsCategory category)
{
	return files_view_chrome_search_results_match_construct_ellipsis (FILES_VIEW_CHROME_SEARCH_RESULTS_TYPE_MATCH, category);
}

static const gchar*
files_view_chrome_search_results_match_get_name (FilesViewChromeSearchResultsMatch* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}

static void
files_view_chrome_search_results_match_set_name (FilesViewChromeSearchResultsMatch* self,
                                                 const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = files_view_chrome_search_results_match_get_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_name);
		self->priv->_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, files_view_chrome_search_results_match_properties[FILES_VIEW_CHROME_SEARCH_RESULTS_MATCH_NAME_PROPERTY]);
	}
}

static const gchar*
files_view_chrome_search_results_match_get_mime (FilesViewChromeSearchResultsMatch* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_mime;
	result = _tmp0_;
	return result;
}

static void
files_view_chrome_search_results_match_set_mime (FilesViewChromeSearchResultsMatch* self,
                                                 const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = files_view_chrome_search_results_match_get_mime (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_mime);
		self->priv->_mime = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, files_view_chrome_search_results_match_properties[FILES_VIEW_CHROME_SEARCH_RESULTS_MATCH_MIME_PROPERTY]);
	}
}

static const gchar*
files_view_chrome_search_results_match_get_path_string (FilesViewChromeSearchResultsMatch* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_path_string;
	result = _tmp0_;
	return result;
}

static void
files_view_chrome_search_results_match_set_path_string (FilesViewChromeSearchResultsMatch* self,
                                                        const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = files_view_chrome_search_results_match_get_path_string (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_path_string);
		self->priv->_path_string = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, files_view_chrome_search_results_match_properties[FILES_VIEW_CHROME_SEARCH_RESULTS_MATCH_PATH_STRING_PROPERTY]);
	}
}

static GIcon*
files_view_chrome_search_results_match_get_icon (FilesViewChromeSearchResultsMatch* self)
{
	GIcon* result;
	GIcon* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_icon;
	result = _tmp0_;
	return result;
}

static void
files_view_chrome_search_results_match_set_icon (FilesViewChromeSearchResultsMatch* self,
                                                 GIcon* value)
{
	GIcon* old_value;
	g_return_if_fail (self != NULL);
	old_value = files_view_chrome_search_results_match_get_icon (self);
	if (old_value != value) {
		GIcon* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_icon);
		self->priv->_icon = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, files_view_chrome_search_results_match_properties[FILES_VIEW_CHROME_SEARCH_RESULTS_MATCH_ICON_PROPERTY]);
	}
}

static GFile*
files_view_chrome_search_results_match_get_file (FilesViewChromeSearchResultsMatch* self)
{
	GFile* result;
	GFile* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_file;
	result = _tmp0_;
	return result;
}

static void
files_view_chrome_search_results_match_set_file (FilesViewChromeSearchResultsMatch* self,
                                                 GFile* value)
{
	GFile* old_value;
	g_return_if_fail (self != NULL);
	old_value = files_view_chrome_search_results_match_get_file (self);
	if (old_value != value) {
		GFile* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_file);
		self->priv->_file = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, files_view_chrome_search_results_match_properties[FILES_VIEW_CHROME_SEARCH_RESULTS_MATCH_FILE_PROPERTY]);
	}
}

static const gchar*
files_view_chrome_search_results_match_get_sortkey (FilesViewChromeSearchResultsMatch* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_sortkey;
	result = _tmp0_;
	return result;
}

static void
files_view_chrome_search_results_match_set_sortkey (FilesViewChromeSearchResultsMatch* self,
                                                    const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = files_view_chrome_search_results_match_get_sortkey (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_sortkey);
		self->priv->_sortkey = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, files_view_chrome_search_results_match_properties[FILES_VIEW_CHROME_SEARCH_RESULTS_MATCH_SORTKEY_PROPERTY]);
	}
}

static FilesViewChromeSearchResultsCategory
files_view_chrome_search_results_match_get_category (FilesViewChromeSearchResultsMatch* self)
{
	FilesViewChromeSearchResultsCategory result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_category;
	return result;
}

static void
files_view_chrome_search_results_match_set_category (FilesViewChromeSearchResultsMatch* self,
                                                     FilesViewChromeSearchResultsCategory value)
{
	FilesViewChromeSearchResultsCategory old_value;
	g_return_if_fail (self != NULL);
	old_value = files_view_chrome_search_results_match_get_category (self);
	if (old_value != value) {
		self->priv->_category = value;
		g_object_notify_by_pspec ((GObject *) self, files_view_chrome_search_results_match_properties[FILES_VIEW_CHROME_SEARCH_RESULTS_MATCH_CATEGORY_PROPERTY]);
	}
}

static void
files_view_chrome_search_results_match_class_init (FilesViewChromeSearchResultsMatchClass * klass,
                                                   gpointer klass_data)
{
	files_view_chrome_search_results_match_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FilesViewChromeSearchResultsMatch_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_files_view_chrome_search_results_match_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_files_view_chrome_search_results_match_set_property;
	G_OBJECT_CLASS (klass)->finalize = files_view_chrome_search_results_match_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_VIEW_CHROME_SEARCH_RESULTS_MATCH_NAME_PROPERTY, files_view_chrome_search_results_match_properties[FILES_VIEW_CHROME_SEARCH_RESULTS_MATCH_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_VIEW_CHROME_SEARCH_RESULTS_MATCH_MIME_PROPERTY, files_view_chrome_search_results_match_properties[FILES_VIEW_CHROME_SEARCH_RESULTS_MATCH_MIME_PROPERTY] = g_param_spec_string ("mime", "mime", "mime", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_VIEW_CHROME_SEARCH_RESULTS_MATCH_PATH_STRING_PROPERTY, files_view_chrome_search_results_match_properties[FILES_VIEW_CHROME_SEARCH_RESULTS_MATCH_PATH_STRING_PROPERTY] = g_param_spec_string ("path-string", "path-string", "path-string", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_VIEW_CHROME_SEARCH_RESULTS_MATCH_ICON_PROPERTY, files_view_chrome_search_results_match_properties[FILES_VIEW_CHROME_SEARCH_RESULTS_MATCH_ICON_PROPERTY] = g_param_spec_object ("icon", "icon", "icon", g_icon_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_VIEW_CHROME_SEARCH_RESULTS_MATCH_FILE_PROPERTY, files_view_chrome_search_results_match_properties[FILES_VIEW_CHROME_SEARCH_RESULTS_MATCH_FILE_PROPERTY] = g_param_spec_object ("file", "file", "file", g_file_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_VIEW_CHROME_SEARCH_RESULTS_MATCH_SORTKEY_PROPERTY, files_view_chrome_search_results_match_properties[FILES_VIEW_CHROME_SEARCH_RESULTS_MATCH_SORTKEY_PROPERTY] = g_param_spec_string ("sortkey", "sortkey", "sortkey", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_VIEW_CHROME_SEARCH_RESULTS_MATCH_CATEGORY_PROPERTY, files_view_chrome_search_results_match_properties[FILES_VIEW_CHROME_SEARCH_RESULTS_MATCH_CATEGORY_PROPERTY] = g_param_spec_enum ("category", "category", "category", FILES_VIEW_CHROME_SEARCH_RESULTS_TYPE_CATEGORY, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
files_view_chrome_search_results_match_instance_init (FilesViewChromeSearchResultsMatch * self,
                                                      gpointer klass)
{
	self->priv = files_view_chrome_search_results_match_get_instance_private (self);
}

static void
files_view_chrome_search_results_match_finalize (GObject * obj)
{
	FilesViewChromeSearchResultsMatch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FILES_VIEW_CHROME_SEARCH_RESULTS_TYPE_MATCH, FilesViewChromeSearchResultsMatch);
	_g_free0 (self->priv->_name);
	_g_free0 (self->priv->_mime);
	_g_free0 (self->priv->_path_string);
	_g_object_unref0 (self->priv->_icon);
	_g_object_unref0 (self->priv->_file);
	_g_free0 (self->priv->_sortkey);
	G_OBJECT_CLASS (files_view_chrome_search_results_match_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
files_view_chrome_search_results_match_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FilesViewChromeSearchResultsMatchClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) files_view_chrome_search_results_match_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FilesViewChromeSearchResultsMatch), 0, (GInstanceInitFunc) files_view_chrome_search_results_match_instance_init, NULL };
	GType files_view_chrome_search_results_match_type_id;
	files_view_chrome_search_results_match_type_id = g_type_register_static (G_TYPE_OBJECT, "FilesViewChromeSearchResultsMatch", &g_define_type_info, 0);
	FilesViewChromeSearchResultsMatch_private_offset = g_type_add_instance_private (files_view_chrome_search_results_match_type_id, sizeof (FilesViewChromeSearchResultsMatchPrivate));
	return files_view_chrome_search_results_match_type_id;
}

static GType
files_view_chrome_search_results_match_get_type (void)
{
	static volatile gsize files_view_chrome_search_results_match_type_id__once = 0;
	if (g_once_init_enter (&files_view_chrome_search_results_match_type_id__once)) {
		GType files_view_chrome_search_results_match_type_id;
		files_view_chrome_search_results_match_type_id = files_view_chrome_search_results_match_get_type_once ();
		g_once_init_leave (&files_view_chrome_search_results_match_type_id__once, files_view_chrome_search_results_match_type_id);
	}
	return files_view_chrome_search_results_match_type_id__once;
}

static void
_vala_files_view_chrome_search_results_match_get_property (GObject * object,
                                                           guint property_id,
                                                           GValue * value,
                                                           GParamSpec * pspec)
{
	FilesViewChromeSearchResultsMatch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FILES_VIEW_CHROME_SEARCH_RESULTS_TYPE_MATCH, FilesViewChromeSearchResultsMatch);
	switch (property_id) {
		case FILES_VIEW_CHROME_SEARCH_RESULTS_MATCH_NAME_PROPERTY:
		g_value_set_string (value, files_view_chrome_search_results_match_get_name (self));
		break;
		case FILES_VIEW_CHROME_SEARCH_RESULTS_MATCH_MIME_PROPERTY:
		g_value_set_string (value, files_view_chrome_search_results_match_get_mime (self));
		break;
		case FILES_VIEW_CHROME_SEARCH_RESULTS_MATCH_PATH_STRING_PROPERTY:
		g_value_set_string (value, files_view_chrome_search_results_match_get_path_string (self));
		break;
		case FILES_VIEW_CHROME_SEARCH_RESULTS_MATCH_ICON_PROPERTY:
		g_value_set_object (value, files_view_chrome_search_results_match_get_icon (self));
		break;
		case FILES_VIEW_CHROME_SEARCH_RESULTS_MATCH_FILE_PROPERTY:
		g_value_set_object (value, files_view_chrome_search_results_match_get_file (self));
		break;
		case FILES_VIEW_CHROME_SEARCH_RESULTS_MATCH_SORTKEY_PROPERTY:
		g_value_set_string (value, files_view_chrome_search_results_match_get_sortkey (self));
		break;
		case FILES_VIEW_CHROME_SEARCH_RESULTS_MATCH_CATEGORY_PROPERTY:
		g_value_set_enum (value, files_view_chrome_search_results_match_get_category (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_files_view_chrome_search_results_match_set_property (GObject * object,
                                                           guint property_id,
                                                           const GValue * value,
                                                           GParamSpec * pspec)
{
	FilesViewChromeSearchResultsMatch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FILES_VIEW_CHROME_SEARCH_RESULTS_TYPE_MATCH, FilesViewChromeSearchResultsMatch);
	switch (property_id) {
		case FILES_VIEW_CHROME_SEARCH_RESULTS_MATCH_NAME_PROPERTY:
		files_view_chrome_search_results_match_set_name (self, g_value_get_string (value));
		break;
		case FILES_VIEW_CHROME_SEARCH_RESULTS_MATCH_MIME_PROPERTY:
		files_view_chrome_search_results_match_set_mime (self, g_value_get_string (value));
		break;
		case FILES_VIEW_CHROME_SEARCH_RESULTS_MATCH_PATH_STRING_PROPERTY:
		files_view_chrome_search_results_match_set_path_string (self, g_value_get_string (value));
		break;
		case FILES_VIEW_CHROME_SEARCH_RESULTS_MATCH_ICON_PROPERTY:
		files_view_chrome_search_results_match_set_icon (self, g_value_get_object (value));
		break;
		case FILES_VIEW_CHROME_SEARCH_RESULTS_MATCH_FILE_PROPERTY:
		files_view_chrome_search_results_match_set_file (self, g_value_get_object (value));
		break;
		case FILES_VIEW_CHROME_SEARCH_RESULTS_MATCH_SORTKEY_PROPERTY:
		files_view_chrome_search_results_match_set_sortkey (self, g_value_get_string (value));
		break;
		case FILES_VIEW_CHROME_SEARCH_RESULTS_MATCH_CATEGORY_PROPERTY:
		files_view_chrome_search_results_match_set_category (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static gboolean
_files_view_chrome_search_results___lambda33_ (FilesViewChromeSearchResults* self,
                                               GtkTreeSelection* selection,
                                               GtkTreeModel* list,
                                               GtkTreePath* path,
                                               gboolean path_selected)
{
	gboolean result;
	g_return_val_if_fail (selection != NULL, FALSE);
	g_return_val_if_fail (list != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	result = gtk_tree_path_get_depth (path) != 0;
	return result;
}

static gboolean
__files_view_chrome_search_results___lambda33__gtk_tree_selection_func (GtkTreeSelection* selection,
                                                                        GtkTreeModel* model,
                                                                        GtkTreePath* path,
                                                                        gboolean path_currently_selected,
                                                                        gpointer self)
{
	gboolean result;
	result = _files_view_chrome_search_results___lambda33_ ((FilesViewChromeSearchResults*) self, selection, model, path, path_currently_selected);
	return result;
}

static gboolean
_files_view_chrome_search_results___lambda34_ (FilesViewChromeSearchResults* self,
                                               GtkTreeModel* model,
                                               GtkTreeIter* iter)
{
	gboolean _tmp0_ = FALSE;
	GtkTreeStore* _tmp1_;
	GtkTreeIter _tmp2_;
	gboolean result;
	g_return_val_if_fail (model != NULL, FALSE);
	g_return_val_if_fail (iter != NULL, FALSE);
	_tmp1_ = self->priv->list;
	_tmp2_ = *iter;
	if (gtk_tree_store_iter_depth (_tmp1_, &_tmp2_) != 0) {
		_tmp0_ = TRUE;
	} else {
		GtkTreeStore* _tmp3_;
		GtkTreeIter _tmp4_;
		_tmp3_ = self->priv->list;
		_tmp4_ = *iter;
		_tmp0_ = gtk_tree_model_iter_has_child ((GtkTreeModel*) _tmp3_, &_tmp4_);
	}
	result = _tmp0_;
	return result;
}

static gboolean
__files_view_chrome_search_results___lambda34__gtk_tree_model_filter_visible_func (GtkTreeModel* model,
                                                                                   GtkTreeIter* iter,
                                                                                   gpointer self)
{
	gboolean result;
	result = _files_view_chrome_search_results___lambda34_ ((FilesViewChromeSearchResults*) self, model, iter);
	return result;
}

static void
_files_view_chrome_search_results___lambda35_ (FilesViewChromeSearchResults* self,
                                               GtkTreePath* path,
                                               GtkTreeIter* iter)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (path != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = gtk_tree_path_to_string (path);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strcmp0 (_tmp1_, "0:0") == 0;
	_g_free0 (_tmp1_);
	if (_tmp2_) {
		GFile* file = NULL;
		GtkTreeStore* _tmp3_;
		GtkTreeIter _tmp4_;
		GFile* _tmp5_ = NULL;
		GFile* _tmp6_;
		_tmp3_ = self->priv->list;
		_tmp4_ = *iter;
		gtk_tree_model_get ((GtkTreeModel*) _tmp3_, &_tmp4_, 3, &_tmp5_, -1);
		_g_object_unref0 (file);
		file = _tmp5_;
		_tmp6_ = file;
		g_signal_emit_by_name ((FilesViewChromeSearchable*) self, "first-match-found", _tmp6_);
		_g_object_unref0 (file);
	}
}

static void
__files_view_chrome_search_results___lambda35__gtk_tree_model_row_changed (GtkTreeModel* _sender,
                                                                           GtkTreePath* path,
                                                                           GtkTreeIter* iter,
                                                                           gpointer self)
{
	_files_view_chrome_search_results___lambda35_ ((FilesViewChromeSearchResults*) self, path, iter);
}

static void
_files_view_chrome_search_results___lambda36_ (FilesViewChromeSearchResults* self,
                                               gint n_press,
                                               gdouble x,
                                               gdouble y)
{
	GtkTreePath* path = NULL;
	GtkTreeIter iter = {0};
	GtkTreeView* _tmp0_;
	GtkTreePath* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GtkTreePath* _tmp3_;
	_tmp0_ = self->priv->search_tree_view;
	gtk_tree_view_get_path_at_pos (_tmp0_, (gint) x, (gint) y, &_tmp1_, NULL, NULL, NULL);
	__vala_GtkTreePath_free0 (path);
	path = _tmp1_;
	_tmp3_ = path;
	if (_tmp3_ != NULL) {
		GtkTreePath* _tmp4_;
		_tmp4_ = path;
		_tmp2_ = gtk_tree_path_get_depth (_tmp4_) > 1;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		GtkTreeModelFilter* _tmp5_;
		GtkTreePath* _tmp6_;
		GtkTreeIter _tmp7_ = {0};
		GtkTreeModelFilter* _tmp8_;
		GtkTreeIter _tmp9_;
		GtkTreeIter _tmp10_ = {0};
		GtkTreeIter _tmp11_;
		GtkGestureMultiPress* _tmp12_;
		_tmp5_ = self->priv->filter;
		_tmp6_ = path;
		gtk_tree_model_get_iter ((GtkTreeModel*) _tmp5_, &_tmp7_, _tmp6_);
		iter = _tmp7_;
		_tmp8_ = self->priv->filter;
		_tmp9_ = iter;
		gtk_tree_model_filter_convert_iter_to_child_iter (_tmp8_, &_tmp10_, &_tmp9_);
		iter = _tmp10_;
		_tmp11_ = iter;
		_tmp12_ = self->priv->search_tree_view_button_controller;
		files_view_chrome_search_results_accept (self, &_tmp11_, gtk_gesture_single_get_current_button ((GtkGestureSingle*) _tmp12_) > ((guint) 1));
	} else {
		gdk_beep ();
	}
	__vala_GtkTreePath_free0 (path);
}

static void
__files_view_chrome_search_results___lambda36__gtk_gesture_multi_press_pressed (GtkGestureMultiPress* _sender,
                                                                                gint n_press,
                                                                                gdouble x,
                                                                                gdouble y,
                                                                                gpointer self)
{
	_files_view_chrome_search_results___lambda36_ ((FilesViewChromeSearchResults*) self, n_press, x, y);
}

static gboolean
_files_view_chrome_search_results_on_key_pressed_event_gtk_event_controller_key_key_pressed (GtkEventControllerKey* _sender,
                                                                                             guint keyval,
                                                                                             guint keycode,
                                                                                             GdkModifierType state,
                                                                                             gpointer self)
{
	gboolean result;
	result = files_view_chrome_search_results_on_key_pressed_event ((FilesViewChromeSearchResults*) self, keyval, keycode, state);
	return result;
}

static GObject *
files_view_chrome_search_results_constructor (GType type,
                                              guint n_construct_properties,
                                              GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	FilesViewChromeSearchResults * self;
	GtkWidget* _tmp0_;
	ZeitgeistEvent* template = NULL;
	ZeitgeistEvent* _tmp1_;
	ZeitgeistSubject* template_subject = NULL;
	gchar* _tmp2_;
	ZeitgeistSubject* _tmp3_ = NULL;
	ZeitgeistEvent* _tmp4_;
	ZeitgeistSubject* _tmp5_;
	GPtrArray* _tmp6_;
	GPtrArray* _tmp7_;
	ZeitgeistEvent* _tmp8_;
	ZeitgeistEvent* _tmp9_;
	ZeitgeistIndex* _tmp10_;
	GtkTreeView* _tmp11_ = NULL;
	GtkTreeView* _tmp12_;
	GtkTreeSelection* _tmp13_;
	GtkTreeView* _tmp14_;
	GtkTreeSelection* _tmp15_;
	GtkTreeView* _tmp16_;
	GtkWidget* _tmp17_;
	GtkScrolledWindow* _tmp18_ = NULL;
	GtkStyleContext* _tmp19_;
	GtkTreeViewColumn* column = NULL;
	GtkTreeViewColumn* _tmp20_ = NULL;
	GtkCellRendererPixbuf* cell = NULL;
	GtkCellRendererPixbuf* _tmp21_;
	GtkTreeViewColumn* _tmp22_;
	GtkCellRendererPixbuf* _tmp23_;
	GtkTreeViewColumn* _tmp24_;
	GtkCellRendererPixbuf* _tmp25_;
	GtkCellRendererText* cell_name = NULL;
	GtkCellRendererText* _tmp26_ = NULL;
	GtkTreeViewColumn* _tmp27_;
	GtkCellRendererText* _tmp28_;
	GtkTreeViewColumn* _tmp29_;
	GtkCellRendererText* _tmp30_;
	GtkCellRendererText* cell_path = NULL;
	GtkCellRendererText* _tmp31_ = NULL;
	GtkTreeViewColumn* _tmp32_;
	GtkCellRendererText* _tmp33_;
	GtkTreeViewColumn* _tmp34_;
	GtkCellRendererText* _tmp35_;
	GtkTreeView* _tmp36_;
	GtkTreeViewColumn* _tmp37_;
	GtkTreeStore* _tmp38_;
	GtkTreeStore* _tmp39_;
	GtkTreeModelFilter* _tmp40_;
	GtkTreeModelFilter* _tmp41_;
	GtkTreeView* _tmp42_;
	GtkTreeModelFilter* _tmp43_;
	GtkTreeStore* _tmp44_;
	GtkTreeStore* _tmp45_;
	GtkTreeStore* _tmp46_;
	GtkTreeIter _tmp47_ = {0};
	GtkTreeIter _tmp48_;
	GtkTreeIter* _tmp49_;
	GtkTreeStore* _tmp50_;
	GtkTreeIter _tmp51_ = {0};
	GtkTreeIter _tmp52_;
	GtkTreeIter* _tmp53_;
	GtkTreeStore* _tmp54_;
	GtkTreeIter _tmp55_ = {0};
	GtkTreeIter _tmp56_;
	GtkTreeIter* _tmp57_;
	GtkTreeStore* _tmp58_;
	GtkTreeIter _tmp59_ = {0};
	GtkTreeIter _tmp60_;
	GtkTreeIter* _tmp61_;
	GtkScrolledWindow* _tmp62_;
	GtkTreeView* _tmp63_;
	GtkGestureMultiPress* _tmp64_ = NULL;
	GtkGestureMultiPress* _tmp65_;
	GtkEventControllerKey* _tmp66_ = NULL;
	GtkEventControllerKey* _tmp67_;
	parent_class = G_OBJECT_CLASS (files_view_chrome_search_results_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FILES_VIEW_CHROME_TYPE_SEARCH_RESULTS, FilesViewChromeSearchResults);
	_tmp0_ = self->priv->_delegate_widget;
	gtk_popover_set_relative_to ((GtkPopover*) self, _tmp0_);
	gtk_popover_set_position ((GtkPopover*) self, GTK_POS_BOTTOM);
	_tmp1_ = zeitgeist_event_new ();
	template = _tmp1_;
	_tmp2_ = g_strdup (ZEITGEIST_NFO_FILE_DATA_OBJECT);
	_tmp3_ = zeitgeist_subject_new ();
	zeitgeist_subject_set_manifestation (_tmp3_, _tmp2_);
	_g_free0 (_tmp2_);
	template_subject = _tmp3_;
	_tmp4_ = template;
	_tmp5_ = template_subject;
	zeitgeist_event_add_subject (_tmp4_, _tmp5_);
	_tmp6_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
	_g_ptr_array_unref0 (self->priv->templates);
	self->priv->templates = _tmp6_;
	_tmp7_ = self->priv->templates;
	_tmp8_ = template;
	_tmp9_ = _g_object_ref0 (_tmp8_);
	g_ptr_array_add (_tmp7_, _tmp9_);
	_tmp10_ = zeitgeist_index_new ();
	_g_object_unref0 (self->priv->zg_index);
	self->priv->zg_index = _tmp10_;
	_tmp11_ = (GtkTreeView*) gtk_tree_view_new ();
	gtk_tree_view_set_headers_visible (_tmp11_, FALSE);
	gtk_tree_view_set_level_indentation (_tmp11_, 12);
	gtk_tree_view_set_show_expanders (_tmp11_, FALSE);
	g_object_ref_sink (_tmp11_);
	_g_object_unref0 (self->priv->search_tree_view);
	self->priv->search_tree_view = _tmp11_;
	_tmp12_ = self->priv->search_tree_view;
	_tmp13_ = gtk_tree_view_get_selection (_tmp12_);
	gtk_tree_selection_set_mode (_tmp13_, GTK_SELECTION_BROWSE);
	_tmp14_ = self->priv->search_tree_view;
	_tmp15_ = gtk_tree_view_get_selection (_tmp14_);
	gtk_tree_selection_set_select_function (_tmp15_, __files_view_chrome_search_results___lambda33__gtk_tree_selection_func, g_object_ref (self), g_object_unref);
	_tmp16_ = self->priv->search_tree_view;
	_tmp17_ = _g_object_ref0 ((GtkWidget*) _tmp16_);
	_tmp18_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_set ((GtkContainer*) _tmp18_, "child", _tmp17_, NULL);
	_g_object_unref0 (_tmp17_);
	g_object_set (_tmp18_, "hscrollbar-policy", GTK_POLICY_NEVER, NULL);
	gtk_scrolled_window_set_propagate_natural_height (_tmp18_, TRUE);
	g_object_ref_sink (_tmp18_);
	_g_object_unref0 (self->priv->scroll);
	self->priv->scroll = _tmp18_;
	_tmp19_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp19_, "completion-popup");
	_tmp20_ = gtk_tree_view_column_new ();
	gtk_tree_view_column_set_sizing (_tmp20_, GTK_TREE_VIEW_COLUMN_FIXED);
	g_object_ref_sink (_tmp20_);
	column = _tmp20_;
	_tmp21_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
	g_object_ref_sink (_tmp21_);
	cell = _tmp21_;
	_tmp22_ = column;
	_tmp23_ = cell;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp22_, (GtkCellRenderer*) _tmp23_, FALSE);
	_tmp24_ = column;
	_tmp25_ = cell;
	gtk_tree_view_column_set_attributes (_tmp24_, (GtkCellRenderer*) _tmp25_, "gicon", 1, "visible", 4, NULL);
	_tmp26_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_set (_tmp26_, "ellipsize", PANGO_ELLIPSIZE_MIDDLE, NULL);
	g_object_ref_sink (_tmp26_);
	cell_name = _tmp26_;
	_tmp27_ = column;
	_tmp28_ = cell_name;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp27_, (GtkCellRenderer*) _tmp28_, TRUE);
	_tmp29_ = column;
	_tmp30_ = cell_name;
	gtk_tree_view_column_set_attributes (_tmp29_, (GtkCellRenderer*) _tmp30_, "markup", 0, NULL);
	_tmp31_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_set ((GtkCellRenderer*) _tmp31_, "xpad", (guint) 6, NULL);
	g_object_set (_tmp31_, "ellipsize", PANGO_ELLIPSIZE_MIDDLE, NULL);
	g_object_ref_sink (_tmp31_);
	cell_path = _tmp31_;
	_tmp32_ = column;
	_tmp33_ = cell_path;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp32_, (GtkCellRenderer*) _tmp33_, FALSE);
	_tmp34_ = column;
	_tmp35_ = cell_path;
	gtk_tree_view_column_set_attributes (_tmp34_, (GtkCellRenderer*) _tmp35_, "markup", 2, NULL);
	_tmp36_ = self->priv->search_tree_view;
	_tmp37_ = column;
	gtk_tree_view_append_column (_tmp36_, _tmp37_);
	_tmp38_ = gtk_tree_store_new (6, G_TYPE_STRING, g_icon_get_type (), G_TYPE_STRING, g_file_get_type (), G_TYPE_BOOLEAN, G_TYPE_STRING);
	_g_object_unref0 (self->priv->list);
	self->priv->list = _tmp38_;
	_tmp39_ = self->priv->list;
	_tmp40_ = (GtkTreeModelFilter*) gtk_tree_model_filter_new ((GtkTreeModel*) _tmp39_, NULL);
	_g_object_unref0 (self->priv->filter);
	self->priv->filter = _tmp40_;
	_tmp41_ = self->priv->filter;
	gtk_tree_model_filter_set_visible_func (_tmp41_, __files_view_chrome_search_results___lambda34__gtk_tree_model_filter_visible_func, g_object_ref (self), g_object_unref);
	_tmp42_ = self->priv->search_tree_view;
	_tmp43_ = self->priv->filter;
	gtk_tree_view_set_model (_tmp42_, (GtkTreeModel*) _tmp43_);
	_tmp44_ = self->priv->list;
	g_signal_connect_object ((GtkTreeModel*) _tmp44_, "row-changed", (GCallback) __files_view_chrome_search_results___lambda35__gtk_tree_model_row_changed, self, 0);
	_tmp45_ = self->priv->list;
	gtk_tree_sortable_set_sort_column_id ((GtkTreeSortable*) _tmp45_, 5, GTK_SORT_ASCENDING);
	_tmp46_ = self->priv->list;
	gtk_tree_store_append (_tmp46_, &_tmp47_, NULL);
	__vala_GtkTreeIter_free0 (self->priv->local_results);
	_tmp48_ = _tmp47_;
	_tmp49_ = __vala_GtkTreeIter_copy0 (&_tmp48_);
	self->priv->local_results = _tmp49_;
	_tmp50_ = self->priv->list;
	gtk_tree_store_append (_tmp50_, &_tmp51_, NULL);
	__vala_GtkTreeIter_free0 (self->priv->deep_results);
	_tmp52_ = _tmp51_;
	_tmp53_ = __vala_GtkTreeIter_copy0 (&_tmp52_);
	self->priv->deep_results = _tmp53_;
	_tmp54_ = self->priv->list;
	gtk_tree_store_append (_tmp54_, &_tmp55_, NULL);
	__vala_GtkTreeIter_free0 (self->priv->bookmark_results);
	_tmp56_ = _tmp55_;
	_tmp57_ = __vala_GtkTreeIter_copy0 (&_tmp56_);
	self->priv->bookmark_results = _tmp57_;
	_tmp58_ = self->priv->list;
	gtk_tree_store_append (_tmp58_, &_tmp59_, NULL);
	__vala_GtkTreeIter_free0 (self->priv->zeitgeist_results);
	_tmp60_ = _tmp59_;
	_tmp61_ = __vala_GtkTreeIter_copy0 (&_tmp60_);
	self->priv->zeitgeist_results = _tmp61_;
	_tmp62_ = self->priv->scroll;
	g_object_set ((GtkContainer*) self, "child", (GtkWidget*) _tmp62_, NULL);
	_tmp63_ = self->priv->search_tree_view;
	_tmp64_ = (GtkGestureMultiPress*) gtk_gesture_multi_press_new ((GtkWidget*) _tmp63_);
	gtk_gesture_single_set_button ((GtkGestureSingle*) _tmp64_, (guint) 0);
	gtk_event_controller_set_propagation_phase ((GtkEventController*) _tmp64_, GTK_PHASE_BUBBLE);
	_g_object_unref0 (self->priv->search_tree_view_button_controller);
	self->priv->search_tree_view_button_controller = _tmp64_;
	_tmp65_ = self->priv->search_tree_view_button_controller;
	g_signal_connect_object (_tmp65_, "pressed", (GCallback) __files_view_chrome_search_results___lambda36__gtk_gesture_multi_press_pressed, self, 0);
	_tmp66_ = (GtkEventControllerKey*) gtk_event_controller_key_new ((GtkWidget*) self);
	gtk_event_controller_set_propagation_phase ((GtkEventController*) _tmp66_, GTK_PHASE_CAPTURE);
	_g_object_unref0 (self->priv->key_controller);
	self->priv->key_controller = _tmp66_;
	_tmp67_ = self->priv->key_controller;
	g_signal_connect_object (_tmp67_, "key-pressed", (GCallback) _files_view_chrome_search_results_on_key_pressed_event_gtk_event_controller_key_key_pressed, self, 0);
	_g_object_unref0 (cell_path);
	_g_object_unref0 (cell_name);
	_g_object_unref0 (cell);
	_g_object_unref0 (column);
	_g_object_unref0 (template_subject);
	_g_object_unref0 (template);
	return obj;
}

static void
files_view_chrome_search_results_class_init (FilesViewChromeSearchResultsClass * klass,
                                             gpointer klass_data)
{
	files_view_chrome_search_results_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FilesViewChromeSearchResults_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_files_view_chrome_search_results_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_files_view_chrome_search_results_set_property;
	G_OBJECT_CLASS (klass)->constructor = files_view_chrome_search_results_constructor;
	G_OBJECT_CLASS (klass)->finalize = files_view_chrome_search_results_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_VIEW_CHROME_SEARCH_RESULTS_WORKING_PROPERTY, files_view_chrome_search_results_properties[FILES_VIEW_CHROME_SEARCH_RESULTS_WORKING_PROPERTY] = g_param_spec_boolean ("working", "working", "working", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_VIEW_CHROME_SEARCH_RESULTS_IS_ACTIVE_PROPERTY, files_view_chrome_search_results_properties[FILES_VIEW_CHROME_SEARCH_RESULTS_IS_ACTIVE_PROPERTY] = g_param_spec_boolean ("is-active", "is-active", "is-active", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_VIEW_CHROME_SEARCH_RESULTS_N_RESULTS_PROPERTY, files_view_chrome_search_results_properties[FILES_VIEW_CHROME_SEARCH_RESULTS_N_RESULTS_PROPERTY] = g_param_spec_int ("n-results", "n-results", "n-results", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_VIEW_CHROME_SEARCH_RESULTS_DELEGATE_WIDGET_PROPERTY, files_view_chrome_search_results_properties[FILES_VIEW_CHROME_SEARCH_RESULTS_DELEGATE_WIDGET_PROPERTY] = g_param_spec_object ("delegate-widget", "delegate-widget", "delegate-widget", gtk_widget_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
files_view_chrome_search_results_files_view_chrome_searchable_interface_init (FilesViewChromeSearchableIface * iface,
                                                                              gpointer iface_data)
{
	files_view_chrome_search_results_files_view_chrome_searchable_parent_iface = g_type_interface_peek_parent (iface);
	iface->cancel = (void (*) (FilesViewChromeSearchable*)) files_view_chrome_search_results_real_cancel;
	iface->search = (void (*) (FilesViewChromeSearchable*, const gchar*, GFile*)) files_view_chrome_search_results_real_search;
}

static void
files_view_chrome_search_results_instance_init (FilesViewChromeSearchResults * self,
                                                gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	self->priv = files_view_chrome_search_results_get_instance_private (self);
	self->priv->_working = FALSE;
	self->priv->_n_results = 0;
	_tmp0_ = g_strdup ("");
	self->priv->search_term = _tmp0_;
	self->priv->allow_adding_results = FALSE;
	self->priv->current_operation = NULL;
	self->priv->file_search_operation = NULL;
	self->priv->max_results = FILES_VIEW_CHROME_SEARCH_RESULTS_MAX_RESULTS;
	self->priv->max_depth = FILES_VIEW_CHROME_SEARCH_RESULTS_MAX_DEPTH;
	self->priv->local_search_finished = FALSE;
	self->priv->global_search_finished = FALSE;
	self->priv->local_results = NULL;
	self->priv->deep_results = NULL;
	self->priv->zeitgeist_results = NULL;
	self->priv->bookmark_results = NULL;
	_tmp1_ = g_strdup ("%s");
	self->priv->header_markup = _tmp1_;
	_tmp2_ = g_strdup ("%s");
	self->priv->result_location_markup = _tmp2_;
	self->priv->search_timeout_id = (guint) 0;
}

static void
files_view_chrome_search_results_finalize (GObject * obj)
{
	FilesViewChromeSearchResults * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FILES_VIEW_CHROME_TYPE_SEARCH_RESULTS, FilesViewChromeSearchResults);
	_g_object_unref0 (self->priv->parent);
	_g_object_unref0 (self->priv->current_root);
	_g_free0 (self->priv->search_term);
	_g_object_unref0 (self->priv->directory_queue);
	_g_object_unref0 (self->priv->waiting_results);
	_g_object_unref0 (self->priv->current_operation);
	_g_object_unref0 (self->priv->file_search_operation);
	_g_object_unref0 (self->priv->zg_index);
	_g_ptr_array_unref0 (self->priv->templates);
	__vala_GtkTreeIter_free0 (self->priv->local_results);
	__vala_GtkTreeIter_free0 (self->priv->deep_results);
	__vala_GtkTreeIter_free0 (self->priv->zeitgeist_results);
	__vala_GtkTreeIter_free0 (self->priv->bookmark_results);
	_g_free0 (self->priv->header_markup);
	_g_free0 (self->priv->result_location_markup);
	_g_object_unref0 (self->priv->search_tree_view);
	_g_object_unref0 (self->priv->list);
	_g_object_unref0 (self->priv->filter);
	_g_object_unref0 (self->priv->scroll);
	_g_object_unref0 (self->priv->_delegate_widget);
	_g_object_unref0 (self->priv->search_tree_view_button_controller);
	_g_object_unref0 (self->priv->key_controller);
	G_OBJECT_CLASS (files_view_chrome_search_results_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
files_view_chrome_search_results_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FilesViewChromeSearchResultsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) files_view_chrome_search_results_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FilesViewChromeSearchResults), 0, (GInstanceInitFunc) files_view_chrome_search_results_instance_init, NULL };
	static const GInterfaceInfo files_view_chrome_searchable_info = { (GInterfaceInitFunc) files_view_chrome_search_results_files_view_chrome_searchable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType files_view_chrome_search_results_type_id;
	files_view_chrome_search_results_type_id = g_type_register_static (gtk_popover_get_type (), "FilesViewChromeSearchResults", &g_define_type_info, 0);
	g_type_add_interface_static (files_view_chrome_search_results_type_id, FILES_VIEW_CHROME_TYPE_SEARCHABLE, &files_view_chrome_searchable_info);
	FilesViewChromeSearchResults_private_offset = g_type_add_instance_private (files_view_chrome_search_results_type_id, sizeof (FilesViewChromeSearchResultsPrivate));
	return files_view_chrome_search_results_type_id;
}

GType
files_view_chrome_search_results_get_type (void)
{
	static volatile gsize files_view_chrome_search_results_type_id__once = 0;
	if (g_once_init_enter (&files_view_chrome_search_results_type_id__once)) {
		GType files_view_chrome_search_results_type_id;
		files_view_chrome_search_results_type_id = files_view_chrome_search_results_get_type_once ();
		g_once_init_leave (&files_view_chrome_search_results_type_id__once, files_view_chrome_search_results_type_id);
	}
	return files_view_chrome_search_results_type_id__once;
}

static void
_vala_files_view_chrome_search_results_get_property (GObject * object,
                                                     guint property_id,
                                                     GValue * value,
                                                     GParamSpec * pspec)
{
	FilesViewChromeSearchResults * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FILES_VIEW_CHROME_TYPE_SEARCH_RESULTS, FilesViewChromeSearchResults);
	switch (property_id) {
		case FILES_VIEW_CHROME_SEARCH_RESULTS_WORKING_PROPERTY:
		g_value_set_boolean (value, files_view_chrome_search_results_get_working (self));
		break;
		case FILES_VIEW_CHROME_SEARCH_RESULTS_IS_ACTIVE_PROPERTY:
		g_value_set_boolean (value, files_view_chrome_search_results_get_is_active (self));
		break;
		case FILES_VIEW_CHROME_SEARCH_RESULTS_N_RESULTS_PROPERTY:
		g_value_set_int (value, files_view_chrome_search_results_get_n_results (self));
		break;
		case FILES_VIEW_CHROME_SEARCH_RESULTS_DELEGATE_WIDGET_PROPERTY:
		g_value_set_object (value, files_view_chrome_search_results_get_delegate_widget (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_files_view_chrome_search_results_set_property (GObject * object,
                                                     guint property_id,
                                                     const GValue * value,
                                                     GParamSpec * pspec)
{
	FilesViewChromeSearchResults * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FILES_VIEW_CHROME_TYPE_SEARCH_RESULTS, FilesViewChromeSearchResults);
	switch (property_id) {
		case FILES_VIEW_CHROME_SEARCH_RESULTS_WORKING_PROPERTY:
		files_view_chrome_search_results_set_working (self, g_value_get_boolean (value));
		break;
		case FILES_VIEW_CHROME_SEARCH_RESULTS_N_RESULTS_PROPERTY:
		files_view_chrome_search_results_set_n_results (self, g_value_get_int (value));
		break;
		case FILES_VIEW_CHROME_SEARCH_RESULTS_DELEGATE_WIDGET_PROPERTY:
		files_view_chrome_search_results_set_delegate_widget (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

