/* BasicBreadcrumbsEntry.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from BasicBreadcrumbsEntry.vala, do not modify */

/*
* Copyright (c) 2018 elementary LLC (https://elementary.io)
*               2011 Lucas Baudin <xapantu@gmail.com>
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/
/** Navigatable Interface **/
/** Signal handling **/
/** Entry functions **/
/** Breadcrumb related functions **/
/** Animation functions **/

#include "pantheon-files-core.h"
#include <glib.h>
#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <float.h>
#include <math.h>
#include <cairo-gobject.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <glib-object.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <glib/gi18n-lib.h>
#include <pango/pango.h>
#include <pango/pangocairo.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	FILES_VIEW_CHROME_BASIC_BREADCRUMBS_ENTRY_0_PROPERTY,
	FILES_VIEW_CHROME_BASIC_BREADCRUMBS_ENTRY_ACTION_ICON_NAME_PROPERTY,
	FILES_VIEW_CHROME_BASIC_BREADCRUMBS_ENTRY_HIDE_BREADCRUMBS_PROPERTY,
	FILES_VIEW_CHROME_BASIC_BREADCRUMBS_ENTRY_NUM_PROPERTIES
};
static GParamSpec* files_view_chrome_basic_breadcrumbs_entry_properties[FILES_VIEW_CHROME_BASIC_BREADCRUMBS_ENTRY_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __vala_GdkEventFocus_free0(var) ((var == NULL) ? NULL : (var = (_vala_GdkEventFocus_free (var), NULL)))
typedef struct _Block40Data Block40Data;
#define _files_view_chrome_breadcrumb_icon_info_unref0(var) ((var == NULL) ? NULL : (var = (files_view_chrome_breadcrumb_icon_info_unref (var), NULL)))
typedef struct _Block41Data Block41Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _FilesViewChromeBasicBreadcrumbsEntryPrivate {
	gboolean _hide_breadcrumbs;
	FilesViewChromeBreadcrumbIconList* breadcrumb_icons;
	gint minimum_width;
	guint animation_timeout_id;
	GdkWindow* entry_window;
	GtkEventControllerKey* key_controller;
	GtkEventControllerMotion* motion_controller;
	guint focus_out_timeout_id;
};

struct _Block40Data {
	int _ref_count_;
	FilesViewChromeBasicBreadcrumbsEntry* self;
	GdkEventFocus* event;
};

struct _Block41Data {
	int _ref_count_;
	FilesViewChromeBasicBreadcrumbsEntry* self;
	gdouble anim_state;
	gint64 start_time;
	GeeCollection* els;
	gdouble initial_offset;
	gdouble final_offset;
};

static gint FilesViewChromeBasicBreadcrumbsEntry_private_offset;
static gpointer files_view_chrome_basic_breadcrumbs_entry_parent_class = NULL;
static FilesViewChromeNavigatableIface * files_view_chrome_basic_breadcrumbs_entry_files_view_chrome_navigatable_parent_iface = NULL;

static void files_view_chrome_basic_breadcrumbs_entry_real_set_breadcrumbs_path (FilesViewChromeNavigatable* base,
                                                                          const gchar* path);
static void files_view_chrome_basic_breadcrumbs_entry_make_element_list_from_protocol_and_path (FilesViewChromeBasicBreadcrumbsEntry* self,
                                                                                         const gchar* protocol,
                                                                                         const gchar* path,
                                                                                         GeeArrayList* newelements);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static gint files_view_chrome_basic_breadcrumbs_entry_get_breadcrumbs_minimum_width (FilesViewChromeBasicBreadcrumbsEntry* self,
                                                                              GList* displayed_breadcrumbs);
static gchar* files_view_chrome_basic_breadcrumbs_entry_real_get_breadcrumbs_path (FilesViewChromeNavigatable* base,
                                                                            gboolean include_file_protocol);
static void files_view_chrome_basic_breadcrumbs_entry_real_set_action_icon_tooltip (FilesViewChromeNavigatable* base,
                                                                             const gchar* tip);
static void files_view_chrome_basic_breadcrumbs_entry_real_hide_action_icon (FilesViewChromeNavigatable* base);
static void files_view_chrome_basic_breadcrumbs_entry_real_set_entry_text (FilesViewChromeNavigatable* base,
                                                                    const gchar* txt);
static gchar* files_view_chrome_basic_breadcrumbs_entry_real_get_entry_text (FilesViewChromeNavigatable* base);
static void files_view_chrome_basic_breadcrumbs_entry_real_reset (FilesViewChromeBasicBreadcrumbsEntry* self);
static void files_view_chrome_basic_breadcrumbs_entry_real_set_animation_visible (FilesViewChromeNavigatable* base,
                                                                           gboolean visible);
static void files_view_chrome_basic_breadcrumbs_entry_real_set_placeholder (FilesViewChromeNavigatable* base,
                                                                     const gchar* txt);
static void files_view_chrome_basic_breadcrumbs_entry_real_show_default_action_icon (FilesViewChromeNavigatable* base);
static void files_view_chrome_basic_breadcrumbs_entry_real_set_default_action_icon_tooltip (FilesViewChromeNavigatable* base);
static gboolean files_view_chrome_basic_breadcrumbs_entry_real_on_key_press_event (FilesViewChromeBasicBreadcrumbsEntry* self,
                                                                            guint keyval,
                                                                            guint keycode,
                                                                            GdkModifierType state);
static void files_view_chrome_basic_breadcrumbs_entry_real_on_button_pressed_event (FilesViewChromeBasicBreadcrumbsEntry* self,
                                                                             gint n_press,
                                                                             gdouble x,
                                                                             gdouble y);
static void files_view_chrome_basic_breadcrumbs_entry_real_on_button_released_event (FilesViewChromeBasicBreadcrumbsEntry* self,
                                                                              gint n_press,
                                                                              gdouble x,
                                                                              gdouble y);
static void files_view_chrome_basic_breadcrumbs_entry_on_icon_press (FilesViewChromeBasicBreadcrumbsEntry* self,
                                                              GtkEntryIconPosition pos);
static void files_view_chrome_basic_breadcrumbs_entry_after_realize (FilesViewChromeBasicBreadcrumbsEntry* self);
static void files_view_chrome_basic_breadcrumbs_entry_on_motion_event (FilesViewChromeBasicBreadcrumbsEntry* self,
                                                                gdouble x,
                                                                gdouble y);
static gboolean files_view_chrome_basic_breadcrumbs_entry_real_on_focus_out (FilesViewChromeBasicBreadcrumbsEntry* self,
                                                                      GdkEventFocus* event);
static GdkEventFocus* _vala_GdkEventFocus_copy (GdkEventFocus* self);
static void _vala_GdkEventFocus_free (GdkEventFocus* self);
static Block40Data* block40_data_ref (Block40Data* _data40_);
static void block40_data_unref (void * _userdata_);
static gboolean ___lambda68_ (Block40Data* _data40_);
static gboolean ____lambda68__gsource_func (gpointer self);
static gboolean files_view_chrome_basic_breadcrumbs_entry_real_on_focus_in (FilesViewChromeBasicBreadcrumbsEntry* self,
                                                                     GdkEventFocus* event);
static void files_view_chrome_basic_breadcrumbs_entry_real_on_activate (FilesViewChromeBasicBreadcrumbsEntry* self);
static void files_view_chrome_basic_breadcrumbs_entry_real_on_entry_text_changed (FilesViewChromeBasicBreadcrumbsEntry* self);
static void files_view_chrome_basic_breadcrumbs_entry_real_go_up (FilesViewChromeBasicBreadcrumbsEntry* self);
static void files_view_chrome_basic_breadcrumbs_entry_real_set_default_entry_tooltip (FilesViewChromeBasicBreadcrumbsEntry* self);
static void files_view_chrome_basic_breadcrumbs_entry_fix_displayed_widths (FilesViewChromeBasicBreadcrumbsEntry* self,
                                                                     GList* elements,
                                                                     gdouble target_width);
static void files_view_chrome_basic_breadcrumbs_entry_distribute_shortfall (FilesViewChromeBasicBreadcrumbsEntry* self,
                                                                     GList* elements,
                                                                     gdouble target_width);
static void files_view_chrome_basic_breadcrumbs_entry_set_element_icons (FilesViewChromeBasicBreadcrumbsEntry* self,
                                                                  const gchar* protocol,
                                                                  GeeArrayList* newelements);
static void files_view_chrome_basic_breadcrumbs_entry_replace_elements (FilesViewChromeBasicBreadcrumbsEntry* self,
                                                                 GeeArrayList* new_elements);
static void files_view_chrome_basic_breadcrumbs_entry_animate_adding_elements (FilesViewChromeBasicBreadcrumbsEntry* self,
                                                                        GeeCollection* els);
static void files_view_chrome_basic_breadcrumbs_entry_animate_removing_elements (FilesViewChromeBasicBreadcrumbsEntry* self,
                                                                          GeeCollection* els);
static void files_view_chrome_basic_breadcrumbs_entry_prepare_to_animate (FilesViewChromeBasicBreadcrumbsEntry* self,
                                                                   GeeCollection* els,
                                                                   gdouble offset);
static gdouble files_view_chrome_basic_breadcrumbs_entry_ease_out_cubic (FilesViewChromeBasicBreadcrumbsEntry* self,
                                                                  gdouble t);
static guint files_view_chrome_basic_breadcrumbs_entry_make_animation (FilesViewChromeBasicBreadcrumbsEntry* self,
                                                                GeeCollection* els,
                                                                gdouble initial_offset,
                                                                gdouble final_offset,
                                                                guint64 time_usec);
static Block41Data* block41_data_ref (Block41Data* _data41_);
static void block41_data_unref (void * _userdata_);
static gboolean __lambda67_ (Block41Data* _data41_,
                      GtkWidget* widget,
                      GdkFrameClock* frame_clock);
static gboolean ___lambda67__gtk_tick_callback (GtkWidget* widget,
                                         GdkFrameClock* frame_clock,
                                         gpointer self);
static gboolean files_view_chrome_basic_breadcrumbs_entry_real_draw (GtkWidget* base,
                                                              cairo_t* cr);
static gint files_view_chrome_basic_breadcrumbs_entry_real_get_minimum_width (FilesViewChromeNavigatable* base);
static GObject * files_view_chrome_basic_breadcrumbs_entry_constructor (GType type,
                                                                 guint n_construct_properties,
                                                                 GObjectConstructParam * construct_properties);
static void _files_view_chrome_basic_breadcrumbs_entry_after_realize_gtk_widget_realize (GtkWidget* _sender,
                                                                                  gpointer self);
static void _files_view_chrome_basic_breadcrumbs_entry_on_activate_gtk_entry_activate (GtkEntry* _sender,
                                                                                gpointer self);
static void _files_view_chrome_basic_breadcrumbs_entry_on_icon_press_gtk_entry_icon_press (GtkEntry* _sender,
                                                                                    GtkEntryIconPosition icon_pos,
                                                                                    GdkEvent* event,
                                                                                    gpointer self);
static gboolean _files_view_chrome_basic_breadcrumbs_entry_on_focus_in_gtk_widget_focus_in_event (GtkWidget* _sender,
                                                                                           GdkEventFocus* event,
                                                                                           gpointer self);
static gboolean _files_view_chrome_basic_breadcrumbs_entry_on_focus_out_gtk_widget_focus_out_event (GtkWidget* _sender,
                                                                                             GdkEventFocus* event,
                                                                                             gpointer self);
static void _files_view_chrome_basic_breadcrumbs_entry_on_entry_text_changed_gtk_editable_changed (GtkEditable* _sender,
                                                                                            gpointer self);
static gboolean _files_view_chrome_basic_breadcrumbs_entry_on_key_press_event_gtk_event_controller_key_key_pressed (GtkEventControllerKey* _sender,
                                                                                                             guint keyval,
                                                                                                             guint keycode,
                                                                                                             GdkModifierType state,
                                                                                                             gpointer self);
static void _files_view_chrome_basic_breadcrumbs_entry_on_button_pressed_event_gtk_gesture_multi_press_pressed (GtkGestureMultiPress* _sender,
                                                                                                         gint n_press,
                                                                                                         gdouble x,
                                                                                                         gdouble y,
                                                                                                         gpointer self);
static void _files_view_chrome_basic_breadcrumbs_entry_on_button_released_event_gtk_gesture_multi_press_released (GtkGestureMultiPress* _sender,
                                                                                                           gint n_press,
                                                                                                           gdouble x,
                                                                                                           gdouble y,
                                                                                                           gpointer self);
static void _files_view_chrome_basic_breadcrumbs_entry_on_motion_event_gtk_event_controller_motion_motion (GtkEventControllerMotion* _sender,
                                                                                                    gdouble x,
                                                                                                    gdouble y,
                                                                                                    gpointer self);
static void _files_view_chrome_basic_breadcrumbs_entry___lambda69_ (FilesViewChromeBasicBreadcrumbsEntry* self);
static void __files_view_chrome_basic_breadcrumbs_entry___lambda69__g_object_notify (GObject* _sender,
                                                                              GParamSpec* pspec,
                                                                              gpointer self);
static void files_view_chrome_basic_breadcrumbs_entry_finalize (GObject * obj);
static GType files_view_chrome_basic_breadcrumbs_entry_get_type_once (void);
static void _vala_files_view_chrome_basic_breadcrumbs_entry_get_property (GObject * object,
                                                                   guint property_id,
                                                                   GValue * value,
                                                                   GParamSpec * pspec);
static void _vala_files_view_chrome_basic_breadcrumbs_entry_set_property (GObject * object,
                                                                   guint property_id,
                                                                   const GValue * value,
                                                                   GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
files_view_chrome_basic_breadcrumbs_entry_get_instance_private (FilesViewChromeBasicBreadcrumbsEntry* self)
{
	return G_STRUCT_MEMBER_P (self, FilesViewChromeBasicBreadcrumbsEntry_private_offset);
}

 G_GNUC_NO_INLINE static GType
files_view_chrome_basic_breadcrumbs_entry_target_type_get_type_once (void)
{
	static const GEnumValue values[] = {{FILES_VIEW_CHROME_BASIC_BREADCRUMBS_ENTRY_TARGET_TYPE_TEXT_URI_LIST, "FILES_VIEW_CHROME_BASIC_BREADCRUMBS_ENTRY_TARGET_TYPE_TEXT_URI_LIST", "text-uri-list"}, {0, NULL, NULL}};
	GType files_view_chrome_basic_breadcrumbs_entry_target_type_type_id;
	files_view_chrome_basic_breadcrumbs_entry_target_type_type_id = g_enum_register_static ("FilesViewChromeBasicBreadcrumbsEntryTargetType", values);
	return files_view_chrome_basic_breadcrumbs_entry_target_type_type_id;
}

GType
files_view_chrome_basic_breadcrumbs_entry_target_type_get_type (void)
{
	static volatile gsize files_view_chrome_basic_breadcrumbs_entry_target_type_type_id__once = 0;
	if (g_once_init_enter (&files_view_chrome_basic_breadcrumbs_entry_target_type_type_id__once)) {
		GType files_view_chrome_basic_breadcrumbs_entry_target_type_type_id;
		files_view_chrome_basic_breadcrumbs_entry_target_type_type_id = files_view_chrome_basic_breadcrumbs_entry_target_type_get_type_once ();
		g_once_init_leave (&files_view_chrome_basic_breadcrumbs_entry_target_type_type_id__once, files_view_chrome_basic_breadcrumbs_entry_target_type_type_id);
	}
	return files_view_chrome_basic_breadcrumbs_entry_target_type_type_id__once;
}

/***************************/
static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
files_view_chrome_basic_breadcrumbs_entry_real_set_breadcrumbs_path (FilesViewChromeNavigatable* base,
                                                                     const gchar* path)
{
	FilesViewChromeBasicBreadcrumbsEntry * self;
	gchar* protocol = NULL;
	gchar* newpath = NULL;
	gchar* sanitized_path = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GeeArrayList* newelements = NULL;
	GeeArrayList* _tmp3_;
	GList* displayed_breadcrumbs = NULL;
	GList* _tmp4_ = NULL;
	GList* _tmp5_;
	self = (FilesViewChromeBasicBreadcrumbsEntry*) base;
	g_return_if_fail (path != NULL);
	_tmp0_ = files_file_utils_sanitize_path (path, NULL, TRUE);
	sanitized_path = _tmp0_;
	files_file_utils_split_protocol_from_path (sanitized_path, &_tmp1_, &_tmp2_);
	_g_free0 (protocol);
	protocol = _tmp1_;
	_g_free0 (newpath);
	newpath = _tmp2_;
	_tmp3_ = gee_array_list_new (FILES_VIEW_CHROME_TYPE_BREADCRUMB_ELEMENT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	newelements = _tmp3_;
	files_view_chrome_basic_breadcrumbs_entry_make_element_list_from_protocol_and_path (self, protocol, newpath, newelements);
	displayed_breadcrumbs = NULL;
	files_view_chrome_basic_breadcrumbs_entry_get_displayed_breadcrumbs_natural_width (self, &_tmp4_);
	(displayed_breadcrumbs == NULL) ? NULL : (displayed_breadcrumbs = (_g_list_free__g_object_unref0_ (displayed_breadcrumbs), NULL));
	displayed_breadcrumbs = _tmp4_;
	_tmp5_ = displayed_breadcrumbs;
	self->priv->minimum_width = files_view_chrome_basic_breadcrumbs_entry_get_breadcrumbs_minimum_width (self, _tmp5_);
	gtk_widget_set_size_request ((GtkWidget*) self, self->priv->minimum_width, -1);
	(displayed_breadcrumbs == NULL) ? NULL : (displayed_breadcrumbs = (_g_list_free__g_object_unref0_ (displayed_breadcrumbs), NULL));
	_g_object_unref0 (newelements);
	_g_free0 (sanitized_path);
	_g_free0 (newpath);
	_g_free0 (protocol);
}

static gchar*
files_view_chrome_basic_breadcrumbs_entry_real_get_breadcrumbs_path (FilesViewChromeNavigatable* base,
                                                                     gboolean include_file_protocol)
{
	FilesViewChromeBasicBreadcrumbsEntry * self;
	gchar* _tmp0_;
	gchar* result;
	self = (FilesViewChromeBasicBreadcrumbsEntry*) base;
	_tmp0_ = files_view_chrome_basic_breadcrumbs_entry_get_path_from_element (self, NULL, include_file_protocol);
	result = _tmp0_;
	return result;
}

static void
files_view_chrome_basic_breadcrumbs_entry_real_set_action_icon_tooltip (FilesViewChromeNavigatable* base,
                                                                        const gchar* tip)
{
	FilesViewChromeBasicBreadcrumbsEntry * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GdkPixbuf* _tmp2_;
	GdkPixbuf* _tmp3_;
	GdkPixbuf* _tmp4_;
	gboolean _tmp5_;
	self = (FilesViewChromeBasicBreadcrumbsEntry*) base;
	g_object_get ((GtkEntry*) self, "secondary-icon-pixbuf", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_ != NULL;
	_g_object_unref0 (_tmp4_);
	if (_tmp5_) {
		_tmp1_ = tip != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gint _tmp6_;
		gint _tmp7_;
		_tmp6_ = strlen (tip);
		_tmp7_ = _tmp6_;
		_tmp0_ = _tmp7_ > 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gtk_entry_set_icon_tooltip_markup ((GtkEntry*) self, GTK_ENTRY_ICON_SECONDARY, tip);
	}
}

gchar*
files_view_chrome_basic_breadcrumbs_entry_get_action_icon_tooltip (FilesViewChromeBasicBreadcrumbsEntry* self)
{
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp1_;
	GdkPixbuf* _tmp2_;
	gboolean _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_object_get ((GtkEntry*) self, "secondary-icon-pixbuf", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_ != NULL;
	_g_object_unref0 (_tmp2_);
	if (_tmp3_) {
		gchar* _tmp4_;
		_tmp4_ = gtk_entry_get_icon_tooltip_markup ((GtkEntry*) self, GTK_ENTRY_ICON_SECONDARY);
		result = _tmp4_;
		return result;
	} else {
		result = NULL;
		return result;
	}
}

static void
files_view_chrome_basic_breadcrumbs_entry_real_hide_action_icon (FilesViewChromeNavigatable* base)
{
	FilesViewChromeBasicBreadcrumbsEntry * self;
	self = (FilesViewChromeBasicBreadcrumbsEntry*) base;
	g_object_set ((GtkEntry*) self, "secondary-icon-pixbuf", NULL, NULL);
}

static void
files_view_chrome_basic_breadcrumbs_entry_real_set_entry_text (FilesViewChromeNavigatable* base,
                                                               const gchar* txt)
{
	FilesViewChromeBasicBreadcrumbsEntry * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	self = (FilesViewChromeBasicBreadcrumbsEntry*) base;
	_tmp0_ = gtk_entry_get_text ((GtkEntry*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		gtk_entry_set_text ((GtkEntry*) self, txt);
		gtk_editable_set_position ((GtkEditable*) self, -1);
	} else {
		gtk_entry_set_text ((GtkEntry*) self, "");
	}
}

static gchar*
files_view_chrome_basic_breadcrumbs_entry_real_get_entry_text (FilesViewChromeNavigatable* base)
{
	FilesViewChromeBasicBreadcrumbsEntry * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	self = (FilesViewChromeBasicBreadcrumbsEntry*) base;
	_tmp0_ = gtk_entry_get_text ((GtkEntry*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup (_tmp1_);
	result = _tmp2_;
	return result;
}

static void
files_view_chrome_basic_breadcrumbs_entry_real_reset (FilesViewChromeBasicBreadcrumbsEntry* self)
{
	files_view_chrome_navigatable_set_entry_text ((FilesViewChromeNavigatable*) self, "");
	files_view_chrome_navigatable_hide_action_icon ((FilesViewChromeNavigatable*) self);
	files_view_chrome_navigatable_set_placeholder ((FilesViewChromeNavigatable*) self, "");
}

void
files_view_chrome_basic_breadcrumbs_entry_reset (FilesViewChromeBasicBreadcrumbsEntry* self)
{
	FilesViewChromeBasicBreadcrumbsEntryClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = FILES_VIEW_CHROME_BASIC_BREADCRUMBS_ENTRY_GET_CLASS (self);
	if (_klass_->reset) {
		_klass_->reset (self);
	}
}

static void
files_view_chrome_basic_breadcrumbs_entry_real_set_animation_visible (FilesViewChromeNavigatable* base,
                                                                      gboolean visible)
{
	FilesViewChromeBasicBreadcrumbsEntry * self;
	self = (FilesViewChromeBasicBreadcrumbsEntry*) base;
	self->animation_visible = visible;
}

static void
files_view_chrome_basic_breadcrumbs_entry_real_set_placeholder (FilesViewChromeNavigatable* base,
                                                                const gchar* txt)
{
	FilesViewChromeBasicBreadcrumbsEntry * self;
	gchar* _tmp0_;
	self = (FilesViewChromeBasicBreadcrumbsEntry*) base;
	g_return_if_fail (txt != NULL);
	_tmp0_ = g_strdup (txt);
	_g_free0 (self->placeholder);
	self->placeholder = _tmp0_;
}

static void
files_view_chrome_basic_breadcrumbs_entry_real_show_default_action_icon (FilesViewChromeNavigatable* base)
{
	FilesViewChromeBasicBreadcrumbsEntry * self;
	self = (FilesViewChromeBasicBreadcrumbsEntry*) base;
	files_view_chrome_navigatable_set_action_icon_name ((FilesViewChromeNavigatable*) self, FILES_ICON_PATHBAR_SECONDARY_NAVIGATE_SYMBOLIC);
	files_view_chrome_navigatable_set_default_action_icon_tooltip ((FilesViewChromeNavigatable*) self);
}

void
files_view_chrome_basic_breadcrumbs_entry_hide_default_action_icon (FilesViewChromeBasicBreadcrumbsEntry* self)
{
	g_return_if_fail (self != NULL);
	files_view_chrome_navigatable_set_action_icon_tooltip ((FilesViewChromeNavigatable*) self, "");
	files_view_chrome_navigatable_set_action_icon_name ((FilesViewChromeNavigatable*) self, NULL);
}

static void
files_view_chrome_basic_breadcrumbs_entry_real_set_default_action_icon_tooltip (FilesViewChromeNavigatable* base)
{
	FilesViewChromeBasicBreadcrumbsEntry * self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	self = (FilesViewChromeBasicBreadcrumbsEntry*) base;
	_tmp0_ = files_view_chrome_navigatable_get_entry_text ((FilesViewChromeNavigatable*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf (_ ("Navigate to %s"), _tmp1_);
	_tmp3_ = _tmp2_;
	files_view_chrome_navigatable_set_action_icon_tooltip ((FilesViewChromeNavigatable*) self, _tmp3_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
}

/*********************/
static gboolean
files_view_chrome_basic_breadcrumbs_entry_real_on_key_press_event (FilesViewChromeBasicBreadcrumbsEntry* self,
                                                                   guint keyval,
                                                                   guint keycode,
                                                                   GdkModifierType state)
{
	GdkModifierType mods = 0U;
	gboolean only_control_pressed = FALSE;
	gboolean result;
	mods = state & gtk_accelerator_get_default_mod_mask ();
	only_control_pressed = mods == GDK_CONTROL_MASK;
	switch (keyval) {
		case GDK_KEY_KP_Down:
		case GDK_KEY_Down:
		{
			if (only_control_pressed) {
				g_signal_emit_by_name ((FilesViewChromeNavigatable*) self, "activate-path", "", FILES_OPEN_FLAG_DEFAULT);
				result = TRUE;
				return result;
			}
			break;
		}
		case GDK_KEY_KP_Up:
		case GDK_KEY_Up:
		{
			if (only_control_pressed) {
				files_view_chrome_basic_breadcrumbs_entry_go_up (self);
				result = TRUE;
				return result;
			}
			break;
		}
		case GDK_KEY_Escape:
		{
			g_signal_emit_by_name ((FilesViewChromeNavigatable*) self, "activate-path", "", FILES_OPEN_FLAG_DEFAULT);
			result = TRUE;
			return result;
		}
		default:
		{
			break;
		}
	}
	result = FALSE;
	return result;
}

gboolean
files_view_chrome_basic_breadcrumbs_entry_on_key_press_event (FilesViewChromeBasicBreadcrumbsEntry* self,
                                                              guint keyval,
                                                              guint keycode,
                                                              GdkModifierType state)
{
	FilesViewChromeBasicBreadcrumbsEntryClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = FILES_VIEW_CHROME_BASIC_BREADCRUMBS_ENTRY_GET_CLASS (self);
	if (_klass_->on_key_press_event) {
		return _klass_->on_key_press_event (self, keyval, keycode, state);
	}
	return FALSE;
}

static void
files_view_chrome_basic_breadcrumbs_entry_real_on_button_pressed_event (FilesViewChromeBasicBreadcrumbsEntry* self,
                                                                        gint n_press,
                                                                        gdouble x,
                                                                        gdouble y)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_object_get ((GtkWidget*) self, "has-focus", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		GtkGestureMultiPress* _tmp2_;
		_tmp2_ = self->button_controller;
		if (gtk_gesture_single_get_current_button ((GtkGestureSingle*) _tmp2_) == ((guint) GDK_BUTTON_SECONDARY)) {
			self->context_menu_showing = TRUE;
		}
	} else {
		if (!files_view_chrome_basic_breadcrumbs_entry_is_icon_event (self, x)) {
			GtkGestureMultiPress* _tmp3_;
			_tmp3_ = self->button_controller;
			gtk_gesture_set_state ((GtkGesture*) _tmp3_, GTK_EVENT_SEQUENCE_CLAIMED);
		}
	}
}

void
files_view_chrome_basic_breadcrumbs_entry_on_button_pressed_event (FilesViewChromeBasicBreadcrumbsEntry* self,
                                                                   gint n_press,
                                                                   gdouble x,
                                                                   gdouble y)
{
	FilesViewChromeBasicBreadcrumbsEntryClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = FILES_VIEW_CHROME_BASIC_BREADCRUMBS_ENTRY_GET_CLASS (self);
	if (_klass_->on_button_pressed_event) {
		_klass_->on_button_pressed_event (self, n_press, x, y);
	}
}

static void
files_view_chrome_basic_breadcrumbs_entry_real_on_button_released_event (FilesViewChromeBasicBreadcrumbsEntry* self,
                                                                         gint n_press,
                                                                         gdouble x,
                                                                         gdouble y)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	GtkGestureMultiPress* _tmp3_;
	gboolean _tmp14_;
	gboolean _tmp15_;
	_tmp3_ = self->button_controller;
	if (gtk_gesture_single_get_current_button ((GtkGestureSingle*) _tmp3_) == ((guint) GDK_BUTTON_PRIMARY)) {
		gboolean _tmp4_;
		gboolean _tmp5_;
		g_object_get ((GtkWidget*) self, "has-focus", &_tmp4_, NULL);
		_tmp5_ = _tmp4_;
		_tmp2_ = !_tmp5_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gboolean _tmp6_;
		gboolean _tmp7_;
		_tmp6_ = files_view_chrome_navigatable_get_hide_breadcrumbs ((FilesViewChromeNavigatable*) self);
		_tmp7_ = _tmp6_;
		_tmp1_ = !_tmp7_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = !files_view_chrome_basic_breadcrumbs_entry_is_icon_event (self, x);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		FilesViewChromeBreadcrumbElement* el = NULL;
		FilesViewChromeBreadcrumbElement* _tmp8_;
		FilesViewChromeBreadcrumbElement* _tmp9_;
		files_view_chrome_basic_breadcrumbs_entry_reset_elements_states (self);
		_tmp8_ = files_view_chrome_basic_breadcrumbs_entry_get_element_from_coordinates (self, x);
		el = _tmp8_;
		_tmp9_ = el;
		if (_tmp9_ != NULL) {
			GtkGestureMultiPress* _tmp10_;
			FilesViewChromeBreadcrumbElement* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			_tmp10_ = self->button_controller;
			gtk_gesture_set_state ((GtkGesture*) _tmp10_, GTK_EVENT_SEQUENCE_CLAIMED);
			_tmp11_ = el;
			_tmp12_ = files_view_chrome_basic_breadcrumbs_entry_get_path_from_element (self, _tmp11_, TRUE);
			_tmp13_ = _tmp12_;
			g_signal_emit_by_name ((FilesViewChromeNavigatable*) self, "activate-path", _tmp13_, FILES_OPEN_FLAG_DEFAULT);
			_g_free0 (_tmp13_);
			_g_object_unref0 (el);
			return;
		}
		_g_object_unref0 (el);
	}
	g_object_get ((GtkWidget*) self, "has-focus", &_tmp14_, NULL);
	_tmp15_ = _tmp14_;
	if (!_tmp15_) {
		gtk_widget_grab_focus ((GtkWidget*) self);
	}
}

void
files_view_chrome_basic_breadcrumbs_entry_on_button_released_event (FilesViewChromeBasicBreadcrumbsEntry* self,
                                                                    gint n_press,
                                                                    gdouble x,
                                                                    gdouble y)
{
	FilesViewChromeBasicBreadcrumbsEntryClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = FILES_VIEW_CHROME_BASIC_BREADCRUMBS_ENTRY_GET_CLASS (self);
	if (_klass_->on_button_released_event) {
		_klass_->on_button_released_event (self, n_press, x, y);
	}
}

gboolean
files_view_chrome_basic_breadcrumbs_entry_is_icon_event (FilesViewChromeBasicBreadcrumbsEntry* self,
                                                         gdouble x)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (x <= ((gdouble) FILES_VIEW_CHROME_BASIC_BREADCRUMBS_ENTRY_ICON_WIDTH)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = x >= ((gdouble) (gtk_widget_get_allocated_width ((GtkWidget*) self) - FILES_VIEW_CHROME_BASIC_BREADCRUMBS_ENTRY_ICON_WIDTH));
	}
	result = _tmp0_;
	return result;
}

static void
files_view_chrome_basic_breadcrumbs_entry_on_icon_press (FilesViewChromeBasicBreadcrumbsEntry* self,
                                                         GtkEntryIconPosition pos)
{
	g_return_if_fail (self != NULL);
	if (pos == GTK_ENTRY_ICON_SECONDARY) {
		g_signal_emit_by_name ((FilesViewChromeNavigatable*) self, "action-icon-press");
	} else {
		g_signal_emit_by_name ((FilesViewChromeNavigatable*) self, "primary-icon-press");
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
files_view_chrome_basic_breadcrumbs_entry_after_realize (FilesViewChromeBasicBreadcrumbsEntry* self)
{
	GdkWindow* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	gconstpointer _tmp3_;
	GdkWindow* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_widget_get_window ((GtkWidget*) self);
	_tmp1_ = gdk_window_get_children_with_user_data (_tmp0_, self);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_->data;
	_tmp4_ = _g_object_ref0 ((GdkWindow*) _tmp3_);
	_g_object_unref0 (self->priv->entry_window);
	self->priv->entry_window = _tmp4_;
	(_tmp2_ == NULL) ? NULL : (_tmp2_ = (g_list_free (_tmp2_), NULL));
}

static void
files_view_chrome_basic_breadcrumbs_entry_on_motion_event (FilesViewChromeBasicBreadcrumbsEntry* self,
                                                           gdouble x,
                                                           gdouble y)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	gchar* tip = NULL;
	GdkPixbuf* _tmp2_;
	GdkPixbuf* _tmp3_;
	GdkPixbuf* _tmp4_;
	gboolean _tmp5_;
	FilesViewChromeBreadcrumbElement* el = NULL;
	FilesViewChromeBreadcrumbElement* _tmp7_;
	gboolean _tmp8_ = FALSE;
	FilesViewChromeBreadcrumbElement* _tmp9_;
	const gchar* _tmp17_;
	g_return_if_fail (self != NULL);
	g_object_get ((GtkWidget*) self, "is-focus", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	tip = NULL;
	g_object_get ((GtkEntry*) self, "secondary-icon-pixbuf", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_ != NULL;
	_g_object_unref0 (_tmp4_);
	if (_tmp5_) {
		gchar* _tmp6_;
		_tmp6_ = gtk_entry_get_icon_tooltip_markup ((GtkEntry*) self, GTK_ENTRY_ICON_SECONDARY);
		_g_free0 (tip);
		tip = _tmp6_;
	}
	gtk_widget_set_tooltip_markup ((GtkWidget*) self, "");
	_tmp7_ = files_view_chrome_basic_breadcrumbs_entry_get_element_from_coordinates (self, x);
	el = _tmp7_;
	_tmp9_ = el;
	if (_tmp9_ != NULL) {
		gboolean _tmp10_;
		gboolean _tmp11_;
		_tmp10_ = files_view_chrome_navigatable_get_hide_breadcrumbs ((FilesViewChromeNavigatable*) self);
		_tmp11_ = _tmp10_;
		_tmp8_ = !_tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		FilesViewChromeBreadcrumbElement* _tmp12_;
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		_tmp12_ = el;
		_tmp13_ = files_view_chrome_breadcrumb_element_get_text_for_display (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = g_strdup_printf (_ ("Go to %s"), _tmp14_);
		_tmp16_ = _tmp15_;
		gtk_widget_set_tooltip_markup ((GtkWidget*) self, _tmp16_);
		_g_free0 (_tmp16_);
		files_view_chrome_basic_breadcrumbs_entry_set_entry_cursor (self, "default");
	} else {
		files_view_chrome_basic_breadcrumbs_entry_set_entry_cursor (self, "text");
		files_view_chrome_basic_breadcrumbs_entry_set_default_entry_tooltip (self);
	}
	_tmp17_ = tip;
	if (_tmp17_ != NULL) {
		const gchar* _tmp18_;
		_tmp18_ = tip;
		gtk_entry_set_icon_tooltip_markup ((GtkEntry*) self, GTK_ENTRY_ICON_SECONDARY, _tmp18_);
	}
	_g_object_unref0 (el);
	_g_free0 (tip);
}

static GdkEventFocus*
_vala_GdkEventFocus_copy (GdkEventFocus* self)
{
	return g_boxed_copy (gdk_event_get_type (), self);
}

static gpointer
__vala_GdkEventFocus_copy0 (gpointer self)
{
	return self ? _vala_GdkEventFocus_copy (self) : NULL;
}

static void
_vala_GdkEventFocus_free (GdkEventFocus* self)
{
	g_boxed_free (gdk_event_get_type (), self);
}

static Block40Data*
block40_data_ref (Block40Data* _data40_)
{
	g_atomic_int_inc (&_data40_->_ref_count_);
	return _data40_;
}

static void
block40_data_unref (void * _userdata_)
{
	Block40Data* _data40_;
	_data40_ = (Block40Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data40_->_ref_count_)) {
		FilesViewChromeBasicBreadcrumbsEntry* self;
		self = _data40_->self;
		__vala_GdkEventFocus_free0 (_data40_->event);
		_g_object_unref0 (self);
		g_slice_free (Block40Data, _data40_);
	}
}

static gboolean
___lambda68_ (Block40Data* _data40_)
{
	FilesViewChromeBasicBreadcrumbsEntry* self;
	gboolean _tmp0_ = FALSE;
	gboolean result;
	self = _data40_->self;
	g_signal_emit_by_name ((GtkWidget*) self, "focus-out-event", _data40_->event, &_tmp0_);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
____lambda68__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda68_ (self);
	return result;
}

static gboolean
files_view_chrome_basic_breadcrumbs_entry_real_on_focus_out (FilesViewChromeBasicBreadcrumbsEntry* self,
                                                             GdkEventFocus* event)
{
	Block40Data* _data40_;
	GdkEventFocus* _tmp0_;
	gboolean result;
	g_return_val_if_fail (event != NULL, FALSE);
	_data40_ = g_slice_new0 (Block40Data);
	_data40_->_ref_count_ = 1;
	_data40_->self = g_object_ref (self);
	_tmp0_ = __vala_GdkEventFocus_copy0 (event);
	__vala_GdkEventFocus_free0 (_data40_->event);
	_data40_->event = _tmp0_;
	if (self->priv->focus_out_timeout_id == ((guint) 0)) {
		self->priv->focus_out_timeout_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 10, ____lambda68__gsource_func, block40_data_ref (_data40_), block40_data_unref);
		result = TRUE;
		block40_data_unref (_data40_);
		_data40_ = NULL;
		return result;
	} else {
		GtkWidget* _tmp1_;
		gboolean _tmp2_;
		gboolean _tmp3_;
		self->priv->focus_out_timeout_id = (guint) 0;
		GTK_WIDGET_CLASS (files_view_chrome_basic_breadcrumbs_entry_parent_class)->focus_out_event ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_entry_get_type (), GtkEntry), _data40_->event);
		if (self->context_menu_showing) {
			result = TRUE;
			block40_data_unref (_data40_);
			_data40_ = NULL;
			return result;
		}
		_tmp1_ = gtk_widget_get_toplevel ((GtkWidget*) self);
		g_object_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_window_get_type (), GtkWindow), "has-toplevel-focus", &_tmp2_, NULL);
		_tmp3_ = _tmp2_;
		if (_tmp3_) {
			files_view_chrome_basic_breadcrumbs_entry_reset (self);
		}
		result = FALSE;
		block40_data_unref (_data40_);
		_data40_ = NULL;
		return result;
	}
}

gboolean
files_view_chrome_basic_breadcrumbs_entry_on_focus_out (FilesViewChromeBasicBreadcrumbsEntry* self,
                                                        GdkEventFocus* event)
{
	FilesViewChromeBasicBreadcrumbsEntryClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = FILES_VIEW_CHROME_BASIC_BREADCRUMBS_ENTRY_GET_CLASS (self);
	if (_klass_->on_focus_out) {
		return _klass_->on_focus_out (self, event);
	}
	return FALSE;
}

static gboolean
files_view_chrome_basic_breadcrumbs_entry_real_on_focus_in (FilesViewChromeBasicBreadcrumbsEntry* self,
                                                            GdkEventFocus* event)
{
	gboolean result;
	g_return_val_if_fail (event != NULL, FALSE);
	if (self->priv->focus_out_timeout_id > ((guint) 0)) {
		g_source_remove (self->priv->focus_out_timeout_id);
		self->priv->focus_out_timeout_id = (guint) 0;
		result = TRUE;
		return result;
	} else {
		gchar* _tmp0_;
		const gchar* _tmp1_;
		self->context_menu_showing = FALSE;
		_tmp0_ = files_view_chrome_navigatable_get_breadcrumbs_path ((FilesViewChromeNavigatable*) self, FALSE);
		_g_free0 (self->current_dir_path);
		self->current_dir_path = _tmp0_;
		_tmp1_ = self->current_dir_path;
		files_view_chrome_navigatable_set_entry_text ((FilesViewChromeNavigatable*) self, _tmp1_);
		result = FALSE;
		return result;
	}
}

gboolean
files_view_chrome_basic_breadcrumbs_entry_on_focus_in (FilesViewChromeBasicBreadcrumbsEntry* self,
                                                       GdkEventFocus* event)
{
	FilesViewChromeBasicBreadcrumbsEntryClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = FILES_VIEW_CHROME_BASIC_BREADCRUMBS_ENTRY_GET_CLASS (self);
	if (_klass_->on_focus_in) {
		return _klass_->on_focus_in (self, event);
	}
	return FALSE;
}

static void
files_view_chrome_basic_breadcrumbs_entry_real_on_activate (FilesViewChromeBasicBreadcrumbsEntry* self)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	_tmp0_ = gtk_entry_get_text ((GtkEntry*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = self->current_dir_path;
	_tmp3_ = files_file_utils_sanitize_path (_tmp1_, _tmp2_, TRUE);
	_tmp4_ = _tmp3_;
	g_signal_emit_by_name ((FilesViewChromeNavigatable*) self, "activate-path", _tmp4_, FILES_OPEN_FLAG_DEFAULT);
	_g_free0 (_tmp4_);
	gtk_entry_set_text ((GtkEntry*) self, "");
}

void
files_view_chrome_basic_breadcrumbs_entry_on_activate (FilesViewChromeBasicBreadcrumbsEntry* self)
{
	FilesViewChromeBasicBreadcrumbsEntryClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = FILES_VIEW_CHROME_BASIC_BREADCRUMBS_ENTRY_GET_CLASS (self);
	if (_klass_->on_activate) {
		_klass_->on_activate (self);
	}
}

static void
files_view_chrome_basic_breadcrumbs_entry_real_on_entry_text_changed (FilesViewChromeBasicBreadcrumbsEntry* self)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	_tmp0_ = gtk_entry_get_text ((GtkEntry*) self);
	_tmp1_ = _tmp0_;
	g_signal_emit_by_name ((FilesViewChromeNavigatable*) self, "entry-text-changed", _tmp1_);
}

void
files_view_chrome_basic_breadcrumbs_entry_on_entry_text_changed (FilesViewChromeBasicBreadcrumbsEntry* self)
{
	FilesViewChromeBasicBreadcrumbsEntryClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = FILES_VIEW_CHROME_BASIC_BREADCRUMBS_ENTRY_GET_CLASS (self);
	if (_klass_->on_entry_text_changed) {
		_klass_->on_entry_text_changed (self);
	}
}

static void
files_view_chrome_basic_breadcrumbs_entry_real_go_up (FilesViewChromeBasicBreadcrumbsEntry* self)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = gtk_entry_get_text ((GtkEntry*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = files_file_utils_get_parent_path_from_path (_tmp1_, TRUE);
	_tmp3_ = _tmp2_;
	gtk_entry_set_text ((GtkEntry*) self, _tmp3_);
	_g_free0 (_tmp3_);
	gtk_editable_set_position ((GtkEditable*) self, -1);
}

void
files_view_chrome_basic_breadcrumbs_entry_go_up (FilesViewChromeBasicBreadcrumbsEntry* self)
{
	FilesViewChromeBasicBreadcrumbsEntryClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = FILES_VIEW_CHROME_BASIC_BREADCRUMBS_ENTRY_GET_CLASS (self);
	if (_klass_->go_up) {
		_klass_->go_up (self);
	}
}

/****************************/
void
files_view_chrome_basic_breadcrumbs_entry_set_entry_cursor (FilesViewChromeBasicBreadcrumbsEntry* self,
                                                            const gchar* cursor_name)
{
	GdkWindow* _tmp0_;
	GdkWindow* _tmp1_;
	GdkDisplay* _tmp2_;
	GdkCursor* _tmp3_;
	GdkCursor* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cursor_name != NULL);
	_tmp0_ = self->priv->entry_window;
	_tmp1_ = self->priv->entry_window;
	_tmp2_ = gdk_window_get_display (_tmp1_);
	_tmp3_ = gdk_cursor_new_from_name (_tmp2_, cursor_name);
	_tmp4_ = _tmp3_;
	gdk_window_set_cursor (_tmp0_, _tmp4_);
	_g_object_unref0 (_tmp4_);
}

static void
files_view_chrome_basic_breadcrumbs_entry_real_set_default_entry_tooltip (FilesViewChromeBasicBreadcrumbsEntry* self)
{
	gtk_widget_set_tooltip_markup ((GtkWidget*) self, _ ("Type Path"));
}

void
files_view_chrome_basic_breadcrumbs_entry_set_default_entry_tooltip (FilesViewChromeBasicBreadcrumbsEntry* self)
{
	FilesViewChromeBasicBreadcrumbsEntryClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = FILES_VIEW_CHROME_BASIC_BREADCRUMBS_ENTRY_GET_CLASS (self);
	if (_klass_->set_default_entry_tooltip) {
		_klass_->set_default_entry_tooltip (self);
	}
}

/****************************/
void
files_view_chrome_basic_breadcrumbs_entry_reset_elements_states (FilesViewChromeBasicBreadcrumbsEntry* self)
{
	g_return_if_fail (self != NULL);
	{
		GeeArrayList* _element_list = NULL;
		GeeArrayList* _tmp0_;
		gint _element_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _element_index = 0;
		_tmp0_ = self->elements;
		_element_list = _tmp0_;
		_tmp1_ = _element_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_element_size = _tmp3_;
		_element_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			FilesViewChromeBreadcrumbElement* element = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			FilesViewChromeBreadcrumbElement* _tmp8_;
			_element_index = _element_index + 1;
			_tmp4_ = _element_index;
			_tmp5_ = _element_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _element_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _element_index);
			element = (FilesViewChromeBreadcrumbElement*) _tmp7_;
			_tmp8_ = element;
			_tmp8_->pressed = FALSE;
			_g_object_unref0 (element);
		}
	}
	gtk_widget_queue_draw ((GtkWidget*) self);
}

/** Returns a list of breadcrumbs that are displayed in natural order - that is, the breadcrumb at the start
          * of the pathbar is at the start of the list
         **/
gdouble
files_view_chrome_basic_breadcrumbs_entry_get_displayed_breadcrumbs_natural_width (FilesViewChromeBasicBreadcrumbsEntry* self,
                                                                                   GList** displayed_breadcrumbs)
{
	GList* _vala_displayed_breadcrumbs = NULL;
	gdouble total_width = 0.0;
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	total_width = 0.0;
	(_vala_displayed_breadcrumbs == NULL) ? NULL : (_vala_displayed_breadcrumbs = (_g_list_free__g_object_unref0_ (_vala_displayed_breadcrumbs), NULL));
	_vala_displayed_breadcrumbs = NULL;
	{
		GeeArrayList* _element_list = NULL;
		GeeArrayList* _tmp0_;
		gint _element_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _element_index = 0;
		_tmp0_ = self->elements;
		_element_list = _tmp0_;
		_tmp1_ = _element_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_element_size = _tmp3_;
		_element_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			FilesViewChromeBreadcrumbElement* element = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			FilesViewChromeBreadcrumbElement* _tmp8_;
			_element_index = _element_index + 1;
			_tmp4_ = _element_index;
			_tmp5_ = _element_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _element_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _element_index);
			element = (FilesViewChromeBreadcrumbElement*) _tmp7_;
			_tmp8_ = element;
			if (_tmp8_->display) {
				FilesViewChromeBreadcrumbElement* _tmp9_;
				gdouble _tmp10_;
				gdouble _tmp11_;
				FilesViewChromeBreadcrumbElement* _tmp12_;
				FilesViewChromeBreadcrumbElement* _tmp13_;
				FilesViewChromeBreadcrumbElement* _tmp14_;
				FilesViewChromeBreadcrumbElement* _tmp15_;
				_tmp9_ = element;
				_tmp10_ = files_view_chrome_breadcrumb_element_get_natural_width (_tmp9_);
				_tmp11_ = _tmp10_;
				total_width += _tmp11_;
				_tmp12_ = element;
				_tmp12_->can_shrink = TRUE;
				_tmp13_ = element;
				_tmp13_->display_width = (gdouble) -1;
				_tmp14_ = element;
				_tmp15_ = _g_object_ref0 (_tmp14_);
				_vala_displayed_breadcrumbs = g_list_prepend (_vala_displayed_breadcrumbs, _tmp15_);
			}
			_g_object_unref0 (element);
		}
	}
	_vala_displayed_breadcrumbs = g_list_reverse (_vala_displayed_breadcrumbs);
	result = total_width;
	if (displayed_breadcrumbs) {
		*displayed_breadcrumbs = _vala_displayed_breadcrumbs;
	} else {
		(_vala_displayed_breadcrumbs == NULL) ? NULL : (_vala_displayed_breadcrumbs = (_g_list_free__g_object_unref0_ (_vala_displayed_breadcrumbs), NULL));
	}
	return result;
}

static gint
files_view_chrome_basic_breadcrumbs_entry_get_breadcrumbs_minimum_width (FilesViewChromeBasicBreadcrumbsEntry* self,
                                                                         GList* displayed_breadcrumbs)
{
	gint l = 0;
	gdouble w = 0.0;
	GList* _tmp0_;
	gconstpointer _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	l = (gint) g_list_length (displayed_breadcrumbs);
	_tmp0_ = g_list_first (displayed_breadcrumbs);
	_tmp1_ = _tmp0_->data;
	_tmp2_ = files_view_chrome_breadcrumb_element_get_natural_width ((FilesViewChromeBreadcrumbElement*) _tmp1_);
	_tmp3_ = _tmp2_;
	w = _tmp3_;
	if (l > 1) {
		GtkStyleContext* style_context = NULL;
		GtkStyleContext* _tmp4_;
		GtkBorder padding = {0};
		GtkStyleContext* _tmp5_;
		GtkStyleContext* _tmp6_;
		GtkBorder _tmp7_ = {0};
		GtkBorder _tmp8_;
		GtkBorder _tmp9_;
		GtkBorder _tmp10_;
		GtkBorder _tmp11_;
		_tmp4_ = gtk_widget_get_style_context ((GtkWidget*) self);
		style_context = _tmp4_;
		_tmp5_ = style_context;
		_tmp6_ = style_context;
		gtk_style_context_get_padding (_tmp5_, gtk_style_context_get_state (_tmp6_), &_tmp7_);
		padding = _tmp7_;
		_tmp8_ = padding;
		_tmp9_ = padding;
		w += (l - 1) * ((FILES_VIEW_CHROME_BASIC_BREADCRUMBS_ENTRY_MINIMUM_BREADCRUMB_WIDTH + _tmp8_.left) + _tmp9_.right);
		_tmp10_ = padding;
		_tmp11_ = padding;
		w += 3 * ((FILES_VIEW_CHROME_BASIC_BREADCRUMBS_ENTRY_MINIMUM_BREADCRUMB_WIDTH + _tmp10_.left) + _tmp11_.right);
	}
	w += ((2 * FILES_VIEW_CHROME_BASIC_BREADCRUMBS_ENTRY_YPAD) + FILES_VIEW_CHROME_BASIC_BREADCRUMBS_ENTRY_MINIMUM_LOCATION_BAR_ENTRY_WIDTH) + FILES_VIEW_CHROME_BASIC_BREADCRUMBS_ENTRY_ICON_WIDTH;
	result = (gint) w;
	return result;
}

static void
files_view_chrome_basic_breadcrumbs_entry_fix_displayed_widths (FilesViewChromeBasicBreadcrumbsEntry* self,
                                                                GList* elements,
                                                                gdouble target_width)
{
	GList* _tmp0_;
	gconstpointer _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_list_first (elements);
	_tmp1_ = _tmp0_->data;
	((FilesViewChromeBreadcrumbElement*) _tmp1_)->can_shrink = FALSE;
	return;
}

static void
files_view_chrome_basic_breadcrumbs_entry_distribute_shortfall (FilesViewChromeBasicBreadcrumbsEntry* self,
                                                                GList* elements,
                                                                gdouble target_width)
{
	gdouble shortfall = 0.0;
	gdouble free_width = 0.0;
	guint index = 0U;
	guint length = 0U;
	gdouble fraction_reduction = 0.0;
	gdouble remaining_shortfall = 0.0;
	g_return_if_fail (self != NULL);
	shortfall = target_width;
	free_width = (gdouble) 0;
	index = (guint) 0;
	length = g_list_length (elements);
	{
		GList* el_collection = NULL;
		GList* el_it = NULL;
		el_collection = elements;
		for (el_it = el_collection; el_it != NULL; el_it = el_it->next) {
			FilesViewChromeBreadcrumbElement* _tmp0_;
			FilesViewChromeBreadcrumbElement* el = NULL;
			_tmp0_ = _g_object_ref0 ((FilesViewChromeBreadcrumbElement*) el_it->data);
			el = _tmp0_;
			{
				FilesViewChromeBreadcrumbElement* _tmp1_;
				gdouble _tmp2_;
				gdouble _tmp3_;
				gboolean _tmp4_ = FALSE;
				guint _tmp5_;
				guint _tmp6_;
				_tmp1_ = el;
				_tmp2_ = files_view_chrome_breadcrumb_element_get_natural_width (_tmp1_);
				_tmp3_ = _tmp2_;
				shortfall -= _tmp3_;
				index = index + 1;
				_tmp5_ = index;
				_tmp6_ = length;
				if (_tmp5_ < _tmp6_) {
					FilesViewChromeBreadcrumbElement* _tmp7_;
					_tmp7_ = el;
					_tmp4_ = _tmp7_->can_shrink;
				} else {
					_tmp4_ = FALSE;
				}
				if (_tmp4_) {
					FilesViewChromeBreadcrumbElement* _tmp8_;
					gdouble _tmp9_;
					gdouble _tmp10_;
					_tmp8_ = el;
					_tmp9_ = files_view_chrome_breadcrumb_element_get_natural_width (_tmp8_);
					_tmp10_ = _tmp9_;
					free_width += _tmp10_ - FILES_VIEW_CHROME_BASIC_BREADCRUMBS_ENTRY_MINIMUM_BREADCRUMB_WIDTH;
				}
				_g_object_unref0 (el);
			}
		}
	}
	fraction_reduction = MAX (0.000, 1.0 + (shortfall / free_width));
	index = (guint) 0;
	{
		GList* el_collection = NULL;
		GList* el_it = NULL;
		el_collection = elements;
		for (el_it = el_collection; el_it != NULL; el_it = el_it->next) {
			FilesViewChromeBreadcrumbElement* _tmp11_;
			FilesViewChromeBreadcrumbElement* el = NULL;
			_tmp11_ = _g_object_ref0 ((FilesViewChromeBreadcrumbElement*) el_it->data);
			el = _tmp11_;
			{
				gboolean _tmp12_ = FALSE;
				guint _tmp13_;
				guint _tmp14_;
				index = index + 1;
				_tmp13_ = index;
				_tmp14_ = length;
				if (_tmp13_ < _tmp14_) {
					FilesViewChromeBreadcrumbElement* _tmp15_;
					_tmp15_ = el;
					_tmp12_ = _tmp15_->can_shrink;
				} else {
					_tmp12_ = FALSE;
				}
				if (_tmp12_) {
					FilesViewChromeBreadcrumbElement* _tmp16_;
					FilesViewChromeBreadcrumbElement* _tmp17_;
					gdouble _tmp18_;
					gdouble _tmp19_;
					_tmp16_ = el;
					_tmp17_ = el;
					_tmp18_ = files_view_chrome_breadcrumb_element_get_natural_width (_tmp17_);
					_tmp19_ = _tmp18_;
					_tmp16_->display_width = ((_tmp19_ - FILES_VIEW_CHROME_BASIC_BREADCRUMBS_ENTRY_MINIMUM_BREADCRUMB_WIDTH) * fraction_reduction) + FILES_VIEW_CHROME_BASIC_BREADCRUMBS_ENTRY_MINIMUM_BREADCRUMB_WIDTH;
				}
				_g_object_unref0 (el);
			}
		}
	}
	remaining_shortfall = shortfall + free_width;
	if (remaining_shortfall < ((gdouble) 0)) {
		FilesViewChromeBreadcrumbElement* el = NULL;
		GList* _tmp20_;
		gconstpointer _tmp21_;
		FilesViewChromeBreadcrumbElement* _tmp22_;
		FilesViewChromeBreadcrumbElement* _tmp23_;
		FilesViewChromeBreadcrumbElement* _tmp24_;
		FilesViewChromeBreadcrumbElement* _tmp25_;
		gdouble _tmp26_;
		gdouble _tmp27_;
		_tmp20_ = g_list_last (elements);
		_tmp21_ = _tmp20_->data;
		_tmp22_ = _g_object_ref0 ((FilesViewChromeBreadcrumbElement*) _tmp21_);
		el = _tmp22_;
		_tmp23_ = el;
		_tmp23_->can_shrink = TRUE;
		_tmp24_ = el;
		_tmp25_ = el;
		_tmp26_ = files_view_chrome_breadcrumb_element_get_natural_width (_tmp25_);
		_tmp27_ = _tmp26_;
		_tmp24_->display_width = MAX (4 * FILES_VIEW_CHROME_BASIC_BREADCRUMBS_ENTRY_MINIMUM_BREADCRUMB_WIDTH, _tmp27_ + remaining_shortfall);
		_g_object_unref0 (el);
	}
}

FilesViewChromeBreadcrumbElement*
files_view_chrome_basic_breadcrumbs_entry_get_element_from_coordinates (FilesViewChromeBasicBreadcrumbsEntry* self,
                                                                        gdouble x)
{
	gdouble width = 0.0;
	gdouble height = 0.0;
	gboolean is_rtl = FALSE;
	GtkStyleContext* _tmp0_;
	gdouble _tmp1_ = 0.0;
	gdouble x_render = 0.0;
	FilesViewChromeBreadcrumbElement* result;
	g_return_val_if_fail (self != NULL, NULL);
	width = (gdouble) (gtk_widget_get_allocated_width ((GtkWidget*) self) - FILES_VIEW_CHROME_BASIC_BREADCRUMBS_ENTRY_ICON_WIDTH);
	height = (gdouble) gtk_widget_get_allocated_height ((GtkWidget*) self);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	is_rtl = (gtk_style_context_get_state (_tmp0_) & GTK_STATE_FLAG_DIR_RTL) == GTK_STATE_FLAG_DIR_RTL;
	if (is_rtl) {
		_tmp1_ = width;
	} else {
		_tmp1_ = (gdouble) 0;
	}
	x_render = _tmp1_;
	{
		GeeArrayList* _element_list = NULL;
		GeeArrayList* _tmp2_;
		gint _element_size = 0;
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _element_index = 0;
		_tmp2_ = self->elements;
		_element_list = _tmp2_;
		_tmp3_ = _element_list;
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_element_size = _tmp5_;
		_element_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			FilesViewChromeBreadcrumbElement* element = NULL;
			GeeArrayList* _tmp8_;
			gpointer _tmp9_;
			FilesViewChromeBreadcrumbElement* _tmp10_;
			_element_index = _element_index + 1;
			_tmp6_ = _element_index;
			_tmp7_ = _element_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _element_list;
			_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _element_index);
			element = (FilesViewChromeBreadcrumbElement*) _tmp9_;
			_tmp10_ = element;
			if (_tmp10_->display) {
				if (is_rtl) {
					FilesViewChromeBreadcrumbElement* _tmp11_;
					gdouble _tmp12_;
					gdouble _tmp13_;
					_tmp11_ = element;
					_tmp12_ = files_view_chrome_breadcrumb_element_get_real_width (_tmp11_);
					_tmp13_ = _tmp12_;
					x_render -= _tmp13_ + (height / 2);
					if (x >= (x_render - 5)) {
						result = element;
						return result;
					}
				} else {
					FilesViewChromeBreadcrumbElement* _tmp14_;
					gdouble _tmp15_;
					gdouble _tmp16_;
					_tmp14_ = element;
					_tmp15_ = files_view_chrome_breadcrumb_element_get_real_width (_tmp14_);
					_tmp16_ = _tmp15_;
					x_render += _tmp16_ + (height / 2);
					if (x <= (x_render - 5)) {
						result = element;
						return result;
					}
				}
			}
			_g_object_unref0 (element);
		}
	}
	result = NULL;
	return result;
}

/** Return an unescaped path from the breadcrumbs **/
gchar*
files_view_chrome_basic_breadcrumbs_entry_get_path_from_element (FilesViewChromeBasicBreadcrumbsEntry* self,
                                                                 FilesViewChromeBreadcrumbElement* el,
                                                                 gboolean include_file_protocol)
{
	gchar* newpath = NULL;
	gchar* _tmp0_;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("");
	newpath = _tmp0_;
	{
		GeeArrayList* _element_list = NULL;
		GeeArrayList* _tmp1_;
		gint _element_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _element_index = 0;
		_tmp1_ = self->elements;
		_element_list = _tmp1_;
		_tmp2_ = _element_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_element_size = _tmp4_;
		_element_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			FilesViewChromeBreadcrumbElement* element = NULL;
			GeeArrayList* _tmp7_;
			gpointer _tmp8_;
			gchar* s = NULL;
			FilesViewChromeBreadcrumbElement* _tmp9_;
			const gchar* _tmp10_;
			const gchar* _tmp11_;
			gchar* _tmp12_;
			const gchar* _tmp13_;
			const gchar* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			gboolean _tmp18_ = FALSE;
			_element_index = _element_index + 1;
			_tmp5_ = _element_index;
			_tmp6_ = _element_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _element_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _element_index);
			element = (FilesViewChromeBreadcrumbElement*) _tmp8_;
			_tmp9_ = element;
			_tmp10_ = files_view_chrome_breadcrumb_element_get_text (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = g_strdup (_tmp11_);
			s = _tmp12_;
			_tmp13_ = newpath;
			_tmp14_ = s;
			_tmp15_ = g_strconcat (_tmp14_, G_DIR_SEPARATOR_S, NULL);
			_tmp16_ = _tmp15_;
			_tmp17_ = g_strconcat (_tmp13_, _tmp16_, NULL);
			_g_free0 (newpath);
			newpath = _tmp17_;
			_g_free0 (_tmp16_);
			if (el != NULL) {
				FilesViewChromeBreadcrumbElement* _tmp19_;
				_tmp19_ = element;
				_tmp18_ = _tmp19_ == el;
			} else {
				_tmp18_ = FALSE;
			}
			if (_tmp18_) {
				_g_free0 (s);
				_g_object_unref0 (element);
				break;
			}
			_g_free0 (s);
			_g_object_unref0 (element);
		}
	}
	_tmp20_ = newpath;
	_tmp21_ = files_file_utils_sanitize_path (_tmp20_, NULL, include_file_protocol);
	result = _tmp21_;
	_g_free0 (newpath);
	return result;
}

static void
files_view_chrome_basic_breadcrumbs_entry_make_element_list_from_protocol_and_path (FilesViewChromeBasicBreadcrumbsEntry* self,
                                                                                    const gchar* protocol,
                                                                                    const gchar* path,
                                                                                    GeeArrayList* newelements)
{
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* newpath = NULL;
	gchar* _tmp3_;
	GtkStyleContext* _tmp4_;
	FilesViewChromeBreadcrumbElement* _tmp5_;
	FilesViewChromeBreadcrumbElement* _tmp6_;
	const gchar* _tmp7_;
	gchar** _tmp8_;
	gchar** _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (protocol != NULL);
	g_return_if_fail (path != NULL);
	g_return_if_fail (newelements != NULL);
	_tmp1_ = g_uri_unescape_string (path, NULL);
	_tmp0_ = _tmp1_;
	if (_tmp0_ == NULL) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (path);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp2_;
	}
	_tmp3_ = files_file_utils_escape_uri (_tmp0_, TRUE, TRUE);
	newpath = _tmp3_;
	_tmp4_ = gtk_widget_get_style_context ((GtkWidget*) self);
	_tmp5_ = files_view_chrome_breadcrumb_element_new (protocol, (GtkWidget*) self, _tmp4_);
	_tmp6_ = _tmp5_;
	gee_abstract_collection_add ((GeeAbstractCollection*) newelements, _tmp6_);
	_g_object_unref0 (_tmp6_);
	_tmp7_ = newpath;
	_tmp9_ = _tmp8_ = g_strsplit (_tmp7_, G_DIR_SEPARATOR_S, 0);
	{
		gchar** dir_collection = NULL;
		gint dir_collection_length1 = 0;
		gint _dir_collection_size_ = 0;
		gint dir_it = 0;
		dir_collection = _tmp9_;
		dir_collection_length1 = _vala_array_length (_tmp8_);
		for (dir_it = 0; dir_it < dir_collection_length1; dir_it = dir_it + 1) {
			gchar* _tmp10_;
			gchar* dir = NULL;
			_tmp10_ = g_strdup (dir_collection[dir_it]);
			dir = _tmp10_;
			{
				const gchar* _tmp11_;
				_tmp11_ = dir;
				if (g_strcmp0 (_tmp11_, "") != 0) {
					const gchar* _tmp12_;
					GtkStyleContext* _tmp13_;
					FilesViewChromeBreadcrumbElement* _tmp14_;
					FilesViewChromeBreadcrumbElement* _tmp15_;
					_tmp12_ = dir;
					_tmp13_ = gtk_widget_get_style_context ((GtkWidget*) self);
					_tmp14_ = files_view_chrome_breadcrumb_element_new (_tmp12_, (GtkWidget*) self, _tmp13_);
					_tmp15_ = _tmp14_;
					gee_abstract_collection_add ((GeeAbstractCollection*) newelements, _tmp15_);
					_g_object_unref0 (_tmp15_);
				}
				_g_free0 (dir);
			}
		}
		dir_collection = (_vala_array_free (dir_collection, dir_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	files_view_chrome_basic_breadcrumbs_entry_set_element_icons (self, protocol, newelements);
	files_view_chrome_basic_breadcrumbs_entry_replace_elements (self, newelements);
	_g_free0 (newpath);
	_g_free0 (_tmp0_);
}

static void
files_view_chrome_basic_breadcrumbs_entry_set_element_icons (FilesViewChromeBasicBreadcrumbsEntry* self,
                                                             const gchar* protocol,
                                                             GeeArrayList* newelements)
{
	gint breadcrumb_icons_list = 0;
	FilesViewChromeBreadcrumbIconList* _tmp0_;
	FilesViewChromeBreadcrumbIconList* _tmp1_;
	FilesViewChromeBreadcrumbIconList* _tmp64_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (protocol != NULL);
	g_return_if_fail (newelements != NULL);
	_tmp0_ = self->priv->breadcrumb_icons;
	breadcrumb_icons_list = files_view_chrome_breadcrumb_icon_list_length (_tmp0_);
	_tmp1_ = self->priv->breadcrumb_icons;
	files_view_chrome_breadcrumb_icon_list_add_mounted_volumes (_tmp1_);
	{
		GeeArrayList* _icon_list = NULL;
		FilesViewChromeBreadcrumbIconList* _tmp2_;
		GeeArrayList* _tmp3_;
		gint _icon_size = 0;
		GeeArrayList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _icon_index = 0;
		_tmp2_ = self->priv->breadcrumb_icons;
		_tmp3_ = files_view_chrome_breadcrumb_icon_list_get_list (_tmp2_);
		_icon_list = _tmp3_;
		_tmp4_ = _icon_list;
		_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_icon_size = _tmp6_;
		_icon_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			FilesViewChromeBreadcrumbIconInfo* icon = NULL;
			GeeArrayList* _tmp9_;
			gpointer _tmp10_;
			gboolean _tmp11_ = FALSE;
			FilesViewChromeBreadcrumbIconInfo* _tmp12_;
			_icon_index = _icon_index + 1;
			_tmp7_ = _icon_index;
			_tmp8_ = _icon_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _icon_list;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _icon_index);
			icon = (FilesViewChromeBreadcrumbIconInfo*) _tmp10_;
			_tmp12_ = icon;
			if (_tmp12_->protocol) {
				FilesViewChromeBreadcrumbIconInfo* _tmp13_;
				const gchar* _tmp14_;
				_tmp13_ = icon;
				_tmp14_ = _tmp13_->path;
				_tmp11_ = g_str_has_prefix (protocol, _tmp14_);
			} else {
				_tmp11_ = FALSE;
			}
			if (_tmp11_) {
				gpointer _tmp15_;
				FilesViewChromeBreadcrumbElement* _tmp16_;
				FilesViewChromeBreadcrumbIconInfo* _tmp17_;
				gpointer _tmp18_;
				FilesViewChromeBreadcrumbElement* _tmp19_;
				FilesViewChromeBreadcrumbIconInfo* _tmp20_;
				const gchar* _tmp21_;
				gpointer _tmp22_;
				FilesViewChromeBreadcrumbElement* _tmp23_;
				FilesViewChromeBreadcrumbIconInfo* _tmp24_;
				const gchar* _tmp25_;
				_tmp15_ = gee_abstract_list_get ((GeeAbstractList*) newelements, 0);
				_tmp16_ = (FilesViewChromeBreadcrumbElement*) _tmp15_;
				_tmp17_ = icon;
				files_view_chrome_breadcrumb_element_set_icon (_tmp16_, _tmp17_);
				_g_object_unref0 (_tmp16_);
				_tmp18_ = gee_abstract_list_get ((GeeAbstractList*) newelements, 0);
				_tmp19_ = (FilesViewChromeBreadcrumbElement*) _tmp18_;
				_tmp20_ = icon;
				_tmp21_ = _tmp20_->text_displayed;
				files_view_chrome_breadcrumb_element_set_text_for_display (_tmp19_, _tmp21_);
				_g_object_unref0 (_tmp19_);
				_tmp22_ = gee_abstract_list_get ((GeeAbstractList*) newelements, 0);
				_tmp23_ = (FilesViewChromeBreadcrumbElement*) _tmp22_;
				_tmp24_ = icon;
				_tmp25_ = _tmp24_->text_displayed;
				_tmp23_->text_is_displayed = _tmp25_ != NULL;
				_g_object_unref0 (_tmp23_);
				_files_view_chrome_breadcrumb_icon_info_unref0 (icon);
				break;
			} else {
				gboolean _tmp26_ = FALSE;
				FilesViewChromeBreadcrumbIconInfo* _tmp27_;
				_tmp27_ = icon;
				if (!_tmp27_->protocol) {
					FilesViewChromeBreadcrumbIconInfo* _tmp28_;
					gchar** _tmp29_;
					gint _tmp29__length1;
					gint _tmp30_;
					gint _tmp31_;
					_tmp28_ = icon;
					_tmp29_ = _tmp28_->exploded;
					_tmp29__length1 = _tmp28_->exploded_length1;
					_tmp30_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) newelements);
					_tmp31_ = _tmp30_;
					_tmp26_ = _tmp29__length1 <= _tmp31_;
				} else {
					_tmp26_ = FALSE;
				}
				if (_tmp26_) {
					gboolean found = FALSE;
					gint h = 0;
					found = TRUE;
					h = 0;
					{
						gint i = 0;
						i = 1;
						{
							gboolean _tmp32_ = FALSE;
							_tmp32_ = TRUE;
							while (TRUE) {
								FilesViewChromeBreadcrumbIconInfo* _tmp34_;
								gchar** _tmp35_;
								gint _tmp35__length1;
								FilesViewChromeBreadcrumbIconInfo* _tmp36_;
								gchar** _tmp37_;
								gint _tmp37__length1;
								const gchar* _tmp38_;
								gpointer _tmp39_;
								FilesViewChromeBreadcrumbElement* _tmp40_;
								const gchar* _tmp41_;
								const gchar* _tmp42_;
								gboolean _tmp43_;
								if (!_tmp32_) {
									gint _tmp33_;
									_tmp33_ = i;
									i = _tmp33_ + 1;
								}
								_tmp32_ = FALSE;
								_tmp34_ = icon;
								_tmp35_ = _tmp34_->exploded;
								_tmp35__length1 = _tmp34_->exploded_length1;
								if (!(i < _tmp35__length1)) {
									break;
								}
								_tmp36_ = icon;
								_tmp37_ = _tmp36_->exploded;
								_tmp37__length1 = _tmp36_->exploded_length1;
								_tmp38_ = _tmp37_[i];
								_tmp39_ = gee_abstract_list_get ((GeeAbstractList*) newelements, i);
								_tmp40_ = (FilesViewChromeBreadcrumbElement*) _tmp39_;
								_tmp41_ = files_view_chrome_breadcrumb_element_get_text (_tmp40_);
								_tmp42_ = _tmp41_;
								_tmp43_ = g_strcmp0 (_tmp38_, _tmp42_) != 0;
								_g_object_unref0 (_tmp40_);
								if (_tmp43_) {
									found = FALSE;
									break;
								}
								h = i;
							}
						}
					}
					if (found) {
						gpointer _tmp48_;
						FilesViewChromeBreadcrumbElement* _tmp49_;
						gpointer _tmp50_;
						FilesViewChromeBreadcrumbElement* _tmp51_;
						FilesViewChromeBreadcrumbIconInfo* _tmp52_;
						gboolean _tmp53_ = FALSE;
						FilesViewChromeBreadcrumbIconInfo* _tmp54_;
						const gchar* _tmp55_;
						gpointer _tmp57_;
						FilesViewChromeBreadcrumbElement* _tmp58_;
						gpointer _tmp59_;
						FilesViewChromeBreadcrumbElement* _tmp60_;
						FilesViewChromeBreadcrumbIconInfo* _tmp61_;
						const gchar* _tmp62_;
						FilesViewChromeBreadcrumbIconInfo* _tmp63_;
						{
							gint j = 0;
							j = 0;
							{
								gboolean _tmp44_ = FALSE;
								_tmp44_ = TRUE;
								while (TRUE) {
									gpointer _tmp46_;
									FilesViewChromeBreadcrumbElement* _tmp47_;
									if (!_tmp44_) {
										gint _tmp45_;
										_tmp45_ = j;
										j = _tmp45_ + 1;
									}
									_tmp44_ = FALSE;
									if (!(j < h)) {
										break;
									}
									_tmp46_ = gee_abstract_list_get ((GeeAbstractList*) newelements, j);
									_tmp47_ = (FilesViewChromeBreadcrumbElement*) _tmp46_;
									_tmp47_->display = FALSE;
									_g_object_unref0 (_tmp47_);
								}
							}
						}
						_tmp48_ = gee_abstract_list_get ((GeeAbstractList*) newelements, h);
						_tmp49_ = (FilesViewChromeBreadcrumbElement*) _tmp48_;
						_tmp49_->display = TRUE;
						_g_object_unref0 (_tmp49_);
						_tmp50_ = gee_abstract_list_get ((GeeAbstractList*) newelements, h);
						_tmp51_ = (FilesViewChromeBreadcrumbElement*) _tmp50_;
						_tmp52_ = icon;
						files_view_chrome_breadcrumb_element_set_icon (_tmp51_, _tmp52_);
						_g_object_unref0 (_tmp51_);
						_tmp54_ = icon;
						_tmp55_ = _tmp54_->text_displayed;
						if (_tmp55_ != NULL) {
							_tmp53_ = TRUE;
						} else {
							FilesViewChromeBreadcrumbIconInfo* _tmp56_;
							_tmp56_ = icon;
							_tmp53_ = !_tmp56_->break_loop;
						}
						_tmp57_ = gee_abstract_list_get ((GeeAbstractList*) newelements, h);
						_tmp58_ = (FilesViewChromeBreadcrumbElement*) _tmp57_;
						_tmp58_->text_is_displayed = _tmp53_;
						_g_object_unref0 (_tmp58_);
						_tmp59_ = gee_abstract_list_get ((GeeAbstractList*) newelements, h);
						_tmp60_ = (FilesViewChromeBreadcrumbElement*) _tmp59_;
						_tmp61_ = icon;
						_tmp62_ = _tmp61_->text_displayed;
						files_view_chrome_breadcrumb_element_set_text_for_display (_tmp60_, _tmp62_);
						_g_object_unref0 (_tmp60_);
						_tmp63_ = icon;
						if (_tmp63_->break_loop) {
							_files_view_chrome_breadcrumb_icon_info_unref0 (icon);
							break;
						}
					}
				}
			}
			_files_view_chrome_breadcrumb_icon_info_unref0 (icon);
		}
	}
	_tmp64_ = self->priv->breadcrumb_icons;
	files_view_chrome_breadcrumb_icon_list_truncate_to_length (_tmp64_, breadcrumb_icons_list);
}

static void
files_view_chrome_basic_breadcrumbs_entry_replace_elements (FilesViewChromeBasicBreadcrumbsEntry* self,
                                                            GeeArrayList* new_elements)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GeeArrayList* _tmp27_;
	GeeArrayList* _tmp28_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (new_elements != NULL);
	if (self->priv->animation_timeout_id > ((guint) 0)) {
		gtk_widget_remove_tick_callback ((GtkWidget*) self, self->priv->animation_timeout_id);
		self->priv->animation_timeout_id = (guint) 0;
	}
	_g_object_unref0 (self->old_elements);
	self->old_elements = NULL;
	g_object_get ((GtkWidget*) self, "has-focus", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		_tmp0_ = self->animation_visible;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint change = 0;
		gint _tmp3_;
		gint _tmp4_;
		GeeArrayList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint max_path = 0;
		GeeArrayList* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) new_elements);
		_tmp4_ = _tmp3_;
		_tmp5_ = self->elements;
		_tmp6_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		change = _tmp4_ - _tmp7_;
		_tmp8_ = self->elements;
		_tmp9_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) new_elements);
		_tmp12_ = _tmp11_;
		max_path = MIN (_tmp10_, _tmp12_);
		if (change > 0) {
			gint _tmp13_;
			gint _tmp14_;
			GeeList* _tmp15_;
			GeeList* _tmp16_;
			_tmp13_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) new_elements);
			_tmp14_ = _tmp13_;
			_tmp15_ = gee_abstract_list_slice ((GeeAbstractList*) new_elements, max_path, _tmp14_);
			_tmp16_ = _tmp15_;
			files_view_chrome_basic_breadcrumbs_entry_animate_adding_elements (self, (GeeCollection*) _tmp16_);
			_g_object_unref0 (_tmp16_);
		} else {
			if (change < 0) {
				GeeArrayList* _tmp17_;
				GeeArrayList* _tmp18_;
				gint _tmp19_;
				gint _tmp20_;
				GeeList* _tmp21_;
				GeeCollection* _tmp22_;
				_tmp17_ = self->elements;
				_tmp18_ = self->elements;
				_tmp19_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp18_);
				_tmp20_ = _tmp19_;
				_tmp21_ = gee_abstract_list_slice ((GeeAbstractList*) _tmp17_, max_path, _tmp20_);
				_g_object_unref0 (self->old_elements);
				self->old_elements = (GeeCollection*) _tmp21_;
				_tmp22_ = self->old_elements;
				files_view_chrome_basic_breadcrumbs_entry_animate_removing_elements (self, _tmp22_);
			} else {
				gint _tmp23_;
				gint _tmp24_;
				GeeList* _tmp25_;
				GeeList* _tmp26_;
				_tmp23_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) new_elements);
				_tmp24_ = _tmp23_;
				_tmp25_ = gee_abstract_list_slice ((GeeAbstractList*) new_elements, max_path, _tmp24_);
				_tmp26_ = _tmp25_;
				files_view_chrome_basic_breadcrumbs_entry_animate_adding_elements (self, (GeeCollection*) _tmp26_);
				_g_object_unref0 (_tmp26_);
			}
		}
	}
	_tmp27_ = self->elements;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp27_);
	_tmp28_ = _g_object_ref0 (new_elements);
	_g_object_unref0 (self->elements);
	self->elements = _tmp28_;
	gtk_widget_queue_draw ((GtkWidget*) self);
}

/****************************/
static void
files_view_chrome_basic_breadcrumbs_entry_prepare_to_animate (FilesViewChromeBasicBreadcrumbsEntry* self,
                                                              GeeCollection* els,
                                                              gdouble offset)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (els != NULL);
	{
		GeeIterator* _bread_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator ((GeeIterable*) els);
		_bread_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			FilesViewChromeBreadcrumbElement* bread = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			FilesViewChromeBreadcrumbElement* _tmp4_;
			_tmp1_ = _bread_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _bread_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			bread = (FilesViewChromeBreadcrumbElement*) _tmp3_;
			_tmp4_ = bread;
			_tmp4_->offset = offset;
			_g_object_unref0 (bread);
		}
		_g_object_unref0 (_bread_it);
	}
}

static gdouble
files_view_chrome_basic_breadcrumbs_entry_ease_out_cubic (FilesViewChromeBasicBreadcrumbsEntry* self,
                                                          gdouble t)
{
	gdouble p = 0.0;
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	p = t - 1;
	result = 1 + ((p * p) * p);
	return result;
}

static Block41Data*
block41_data_ref (Block41Data* _data41_)
{
	g_atomic_int_inc (&_data41_->_ref_count_);
	return _data41_;
}

static void
block41_data_unref (void * _userdata_)
{
	Block41Data* _data41_;
	_data41_ = (Block41Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data41_->_ref_count_)) {
		FilesViewChromeBasicBreadcrumbsEntry* self;
		self = _data41_->self;
		_g_object_unref0 (_data41_->els);
		_g_object_unref0 (self);
		g_slice_free (Block41Data, _data41_);
	}
}

static gboolean
__lambda67_ (Block41Data* _data41_,
             GtkWidget* widget,
             GdkFrameClock* frame_clock)
{
	FilesViewChromeBasicBreadcrumbsEntry* self;
	gint64 time = 0LL;
	gdouble t = 0.0;
	gboolean result;
	self = _data41_->self;
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (frame_clock != NULL, FALSE);
	time = gdk_frame_clock_get_frame_time (frame_clock);
	t = ((gdouble) (time - _data41_->start_time)) / FILES_LOCATION_BAR_ANIMATION_TIME_USEC;
	t = 1 - files_view_chrome_basic_breadcrumbs_entry_ease_out_cubic (self, CLAMP (t, (gdouble) 0, (gdouble) 1));
	_data41_->anim_state = _data41_->final_offset + ((_data41_->initial_offset - _data41_->final_offset) * t);
	{
		GeeIterator* _bread_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator ((GeeIterable*) _data41_->els);
		_bread_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			FilesViewChromeBreadcrumbElement* bread = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			FilesViewChromeBreadcrumbElement* _tmp4_;
			_tmp1_ = _bread_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _bread_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			bread = (FilesViewChromeBreadcrumbElement*) _tmp3_;
			_tmp4_ = bread;
			_tmp4_->offset = _data41_->anim_state;
			_g_object_unref0 (bread);
		}
		_g_object_unref0 (_bread_it);
	}
	gtk_widget_queue_draw ((GtkWidget*) self);
	if (((guint64) time) >= (_data41_->start_time + FILES_LOCATION_BAR_ANIMATION_TIME_USEC)) {
		_g_object_unref0 (self->old_elements);
		self->old_elements = NULL;
		self->priv->animation_timeout_id = (guint) 0;
		result = G_SOURCE_REMOVE;
		return result;
	} else {
		result = G_SOURCE_CONTINUE;
		return result;
	}
}

static gboolean
___lambda67__gtk_tick_callback (GtkWidget* widget,
                                GdkFrameClock* frame_clock,
                                gpointer self)
{
	gboolean result;
	result = __lambda67_ (self, widget, frame_clock);
	return result;
}

static guint
files_view_chrome_basic_breadcrumbs_entry_make_animation (FilesViewChromeBasicBreadcrumbsEntry* self,
                                                          GeeCollection* els,
                                                          gdouble initial_offset,
                                                          gdouble final_offset,
                                                          guint64 time_usec)
{
	Block41Data* _data41_;
	GeeCollection* _tmp0_;
	GtkSettings* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GdkFrameClock* _tmp4_;
	guint anim = 0U;
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	g_return_val_if_fail (els != NULL, 0U);
	_data41_ = g_slice_new0 (Block41Data);
	_data41_->_ref_count_ = 1;
	_data41_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (els);
	_g_object_unref0 (_data41_->els);
	_data41_->els = _tmp0_;
	_data41_->initial_offset = initial_offset;
	_data41_->final_offset = final_offset;
	_tmp1_ = gtk_widget_get_settings ((GtkWidget*) self);
	g_object_get (_tmp1_, "gtk-enable-animations", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	if (!_tmp3_) {
		files_view_chrome_basic_breadcrumbs_entry_prepare_to_animate (self, _data41_->els, _data41_->final_offset);
		result = (guint) 0;
		block41_data_unref (_data41_);
		_data41_ = NULL;
		return result;
	}
	files_view_chrome_basic_breadcrumbs_entry_prepare_to_animate (self, _data41_->els, _data41_->initial_offset);
	_data41_->anim_state = _data41_->initial_offset;
	_tmp4_ = gtk_widget_get_frame_clock ((GtkWidget*) self);
	_data41_->start_time = gdk_frame_clock_get_frame_time (_tmp4_);
	anim = gtk_widget_add_tick_callback ((GtkWidget*) self, ___lambda67__gtk_tick_callback, block41_data_ref (_data41_), block41_data_unref);
	result = anim;
	block41_data_unref (_data41_);
	_data41_ = NULL;
	return result;
}

static void
files_view_chrome_basic_breadcrumbs_entry_animate_adding_elements (FilesViewChromeBasicBreadcrumbsEntry* self,
                                                                   GeeCollection* els)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (els != NULL);
	self->priv->animation_timeout_id = files_view_chrome_basic_breadcrumbs_entry_make_animation (self, els, 1.0, 0.0, FILES_LOCATION_BAR_ANIMATION_TIME_USEC);
}

static void
files_view_chrome_basic_breadcrumbs_entry_animate_removing_elements (FilesViewChromeBasicBreadcrumbsEntry* self,
                                                                     GeeCollection* els)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (els != NULL);
	self->priv->animation_timeout_id = files_view_chrome_basic_breadcrumbs_entry_make_animation (self, els, 0.0, 1.0, FILES_LOCATION_BAR_ANIMATION_TIME_USEC);
}

static gboolean
files_view_chrome_basic_breadcrumbs_entry_real_draw (GtkWidget* base,
                                                     cairo_t* cr)
{
	FilesViewChromeBasicBreadcrumbsEntry * self;
	GtkStyleContext* style_context = NULL;
	GtkStyleContext* _tmp0_;
	GtkStyleContext* _tmp1_;
	gboolean is_rtl = FALSE;
	GtkStyleContext* _tmp7_;
	GtkBorder padding = {0};
	GtkStyleContext* _tmp8_;
	GtkStyleContext* _tmp9_;
	GtkBorder _tmp10_ = {0};
	gdouble height = 0.0;
	gdouble width = 0.0;
	gint scale = 0;
	GtkStyleContext* _tmp11_;
	FilesViewChromeBreadcrumbIconList* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	GtkStyleContext* _tmp28_;
	GtkStyleContext* _tmp29_;
	GtkBorder border = {0};
	GtkStyleContext* _tmp30_;
	GtkStyleContext* _tmp31_;
	GtkBorder _tmp32_ = {0};
	GtkStyleContext* _tmp33_;
	gboolean _tmp34_ = FALSE;
	gboolean _tmp35_;
	gboolean _tmp36_;
	gboolean result;
	self = (FilesViewChromeBasicBreadcrumbsEntry*) base;
	g_return_val_if_fail (cr != NULL, FALSE);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	style_context = _tmp0_;
	_tmp1_ = self->button_context_active;
	if (_tmp1_ == NULL) {
		GtkStyleContext* _tmp2_;
		GtkStyleContext* _tmp3_;
		GtkStyleContext* _tmp4_;
		GtkWidgetPath* _tmp5_;
		GtkStyleContext* _tmp6_;
		_tmp2_ = gtk_style_context_new ();
		_g_object_unref0 (self->button_context_active);
		self->button_context_active = _tmp2_;
		_tmp3_ = self->button_context_active;
		_tmp4_ = style_context;
		_tmp5_ = gtk_style_context_get_path (_tmp4_);
		gtk_style_context_set_path (_tmp3_, _tmp5_);
		_tmp6_ = self->button_context_active;
		gtk_style_context_set_state (_tmp6_, GTK_STATE_FLAG_ACTIVE);
	}
	_tmp7_ = style_context;
	is_rtl = (gtk_style_context_get_state (_tmp7_) & GTK_STATE_FLAG_DIR_RTL) == GTK_STATE_FLAG_DIR_RTL;
	_tmp8_ = style_context;
	_tmp9_ = style_context;
	gtk_style_context_get_padding (_tmp8_, gtk_style_context_get_state (_tmp9_), &_tmp10_);
	padding = _tmp10_;
	GTK_WIDGET_CLASS (files_view_chrome_basic_breadcrumbs_entry_parent_class)->draw ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_entry_get_type (), GtkEntry), cr);
	height = (gdouble) gtk_widget_get_allocated_height ((GtkWidget*) self);
	width = (gdouble) gtk_widget_get_allocated_width ((GtkWidget*) self);
	_tmp11_ = style_context;
	scale = gtk_style_context_get_scale (_tmp11_);
	_tmp12_ = self->priv->breadcrumb_icons;
	_tmp13_ = files_view_chrome_breadcrumb_icon_list_get_scale (_tmp12_);
	_tmp14_ = _tmp13_;
	if (_tmp14_ != scale) {
		FilesViewChromeBreadcrumbIconList* _tmp15_;
		gchar* protocol = NULL;
		gchar* _tmp16_;
		GeeArrayList* _tmp17_;
		gint _tmp18_;
		gint _tmp19_;
		const gchar* _tmp26_;
		GeeArrayList* _tmp27_;
		_tmp15_ = self->priv->breadcrumb_icons;
		files_view_chrome_breadcrumb_icon_list_set_scale (_tmp15_, scale);
		_tmp16_ = g_strdup ("");
		protocol = _tmp16_;
		_tmp17_ = self->elements;
		_tmp18_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp17_);
		_tmp19_ = _tmp18_;
		if (_tmp19_ > 0) {
			GeeArrayList* _tmp20_;
			gpointer _tmp21_;
			FilesViewChromeBreadcrumbElement* _tmp22_;
			const gchar* _tmp23_;
			const gchar* _tmp24_;
			gchar* _tmp25_;
			_tmp20_ = self->elements;
			_tmp21_ = gee_abstract_list_get ((GeeAbstractList*) _tmp20_, 0);
			_tmp22_ = (FilesViewChromeBreadcrumbElement*) _tmp21_;
			_tmp23_ = files_view_chrome_breadcrumb_element_get_text (_tmp22_);
			_tmp24_ = _tmp23_;
			_tmp25_ = g_strdup (_tmp24_);
			_g_free0 (protocol);
			protocol = _tmp25_;
			_g_object_unref0 (_tmp22_);
		}
		_tmp26_ = protocol;
		_tmp27_ = self->elements;
		files_view_chrome_basic_breadcrumbs_entry_set_element_icons (self, _tmp26_, _tmp27_);
		_g_free0 (protocol);
	}
	_tmp28_ = style_context;
	gtk_style_context_save (_tmp28_);
	_tmp29_ = style_context;
	gtk_style_context_set_state (_tmp29_, GTK_STATE_FLAG_ACTIVE);
	_tmp30_ = style_context;
	_tmp31_ = style_context;
	gtk_style_context_get_margin (_tmp30_, gtk_style_context_get_state (_tmp31_), &_tmp32_);
	border = _tmp32_;
	_tmp33_ = style_context;
	gtk_style_context_restore (_tmp33_);
	g_object_get ((GtkWidget*) self, "is-focus", &_tmp35_, NULL);
	_tmp36_ = _tmp35_;
	if (!_tmp36_) {
		gboolean _tmp37_;
		gboolean _tmp38_;
		_tmp37_ = files_view_chrome_navigatable_get_hide_breadcrumbs ((FilesViewChromeNavigatable*) self);
		_tmp38_ = _tmp37_;
		_tmp34_ = !_tmp38_;
	} else {
		_tmp34_ = FALSE;
	}
	if (_tmp34_) {
		gdouble margin = 0.0;
		GtkBorder _tmp39_;
		gdouble width_marged = 0.0;
		gdouble height_marged = 0.0;
		gdouble x_render = 0.0;
		GList* displayed_breadcrumbs = NULL;
		gdouble max_width = 0.0;
		GList* _tmp40_ = NULL;
		gdouble _tmp41_;
		gdouble total_arrow_width = 0.0;
		GList* _tmp42_;
		GtkBorder _tmp43_;
		GList* _tmp47_;
		GeeCollection* _tmp58_;
		_tmp39_ = border;
		margin = (gdouble) _tmp39_.top;
		width_marged = ((width - (2 * margin)) - FILES_VIEW_CHROME_BASIC_BREADCRUMBS_ENTRY_MINIMUM_LOCATION_BAR_ENTRY_WIDTH) - FILES_VIEW_CHROME_BASIC_BREADCRUMBS_ENTRY_ICON_WIDTH;
		height_marged = height - (2 * margin);
		if (is_rtl) {
			x_render = width - margin;
		} else {
			x_render = margin;
		}
		displayed_breadcrumbs = NULL;
		_tmp41_ = files_view_chrome_basic_breadcrumbs_entry_get_displayed_breadcrumbs_natural_width (self, &_tmp40_);
		(displayed_breadcrumbs == NULL) ? NULL : (displayed_breadcrumbs = (_g_list_free__g_object_unref0_ (displayed_breadcrumbs), NULL));
		displayed_breadcrumbs = _tmp40_;
		max_width = _tmp41_;
		_tmp42_ = displayed_breadcrumbs;
		_tmp43_ = padding;
		total_arrow_width = g_list_length (_tmp42_) * ((height_marged / 2) + _tmp43_.left);
		width_marged -= total_arrow_width;
		if (max_width > width_marged) {
			guint unfixed = 0U;
			GList* _tmp44_;
			GList* _tmp45_;
			GList* _tmp46_;
			_tmp44_ = displayed_breadcrumbs;
			unfixed = g_list_length (_tmp44_) - 2;
			if (unfixed > ((guint) 0)) {
				width_marged -= unfixed * FILES_VIEW_CHROME_BASIC_BREADCRUMBS_ENTRY_MINIMUM_BREADCRUMB_WIDTH;
			}
			_tmp45_ = displayed_breadcrumbs;
			files_view_chrome_basic_breadcrumbs_entry_fix_displayed_widths (self, _tmp45_, width_marged);
			_tmp46_ = displayed_breadcrumbs;
			files_view_chrome_basic_breadcrumbs_entry_distribute_shortfall (self, _tmp46_, width_marged);
		}
		cairo_save (cr);
		_tmp47_ = displayed_breadcrumbs;
		{
			GList* element_collection = NULL;
			GList* element_it = NULL;
			element_collection = _tmp47_;
			for (element_it = element_collection; element_it != NULL; element_it = element_it->next) {
				FilesViewChromeBreadcrumbElement* _tmp48_;
				FilesViewChromeBreadcrumbElement* element = NULL;
				_tmp48_ = _g_object_ref0 ((FilesViewChromeBreadcrumbElement*) element_it->data);
				element = _tmp48_;
				{
					FilesViewChromeBreadcrumbElement* _tmp49_;
					_tmp49_ = element;
					x_render = files_view_chrome_breadcrumb_element_draw (_tmp49_, cr, x_render, margin, height_marged, (GtkWidget*) self);
					if (is_rtl) {
						FilesViewChromeBreadcrumbElement* _tmp50_;
						FilesViewChromeBreadcrumbElement* _tmp51_;
						gdouble _tmp52_;
						gdouble _tmp53_;
						_tmp50_ = element;
						_tmp51_ = element;
						_tmp52_ = files_view_chrome_breadcrumb_element_get_real_width (_tmp51_);
						_tmp53_ = _tmp52_;
						_tmp50_->x = x_render + _tmp53_;
					} else {
						FilesViewChromeBreadcrumbElement* _tmp54_;
						FilesViewChromeBreadcrumbElement* _tmp55_;
						gdouble _tmp56_;
						gdouble _tmp57_;
						_tmp54_ = element;
						_tmp55_ = element;
						_tmp56_ = files_view_chrome_breadcrumb_element_get_real_width (_tmp55_);
						_tmp57_ = _tmp56_;
						_tmp54_->x = x_render - _tmp57_;
					}
					_g_object_unref0 (element);
				}
			}
		}
		_tmp58_ = self->old_elements;
		if (_tmp58_ != NULL) {
			{
				GeeIterator* _element_it = NULL;
				GeeCollection* _tmp59_;
				GeeIterator* _tmp60_;
				_tmp59_ = self->old_elements;
				_tmp60_ = gee_iterable_iterator ((GeeIterable*) _tmp59_);
				_element_it = _tmp60_;
				while (TRUE) {
					GeeIterator* _tmp61_;
					FilesViewChromeBreadcrumbElement* element = NULL;
					GeeIterator* _tmp62_;
					gpointer _tmp63_;
					FilesViewChromeBreadcrumbElement* _tmp64_;
					_tmp61_ = _element_it;
					if (!gee_iterator_next (_tmp61_)) {
						break;
					}
					_tmp62_ = _element_it;
					_tmp63_ = gee_iterator_get (_tmp62_);
					element = (FilesViewChromeBreadcrumbElement*) _tmp63_;
					_tmp64_ = element;
					if (_tmp64_->display) {
						FilesViewChromeBreadcrumbElement* _tmp65_;
						_tmp65_ = element;
						x_render = files_view_chrome_breadcrumb_element_draw (_tmp65_, cr, x_render, margin, height_marged, (GtkWidget*) self);
						if (is_rtl) {
							FilesViewChromeBreadcrumbElement* _tmp66_;
							FilesViewChromeBreadcrumbElement* _tmp67_;
							gdouble _tmp68_;
							gdouble _tmp69_;
							_tmp66_ = element;
							_tmp67_ = element;
							_tmp68_ = files_view_chrome_breadcrumb_element_get_real_width (_tmp67_);
							_tmp69_ = _tmp68_;
							_tmp66_->x = x_render + _tmp69_;
						} else {
							FilesViewChromeBreadcrumbElement* _tmp70_;
							FilesViewChromeBreadcrumbElement* _tmp71_;
							gdouble _tmp72_;
							gdouble _tmp73_;
							_tmp70_ = element;
							_tmp71_ = element;
							_tmp72_ = files_view_chrome_breadcrumb_element_get_real_width (_tmp71_);
							_tmp73_ = _tmp72_;
							_tmp70_->x = x_render - _tmp73_;
						}
					}
					_g_object_unref0 (element);
				}
				_g_object_unref0 (_element_it);
			}
		}
		cairo_restore (cr);
		(displayed_breadcrumbs == NULL) ? NULL : (displayed_breadcrumbs = (_g_list_free__g_object_unref0_ (displayed_breadcrumbs), NULL));
	} else {
		const gchar* _tmp74_;
		_tmp74_ = self->placeholder;
		if (g_strcmp0 (_tmp74_, "") != 0) {
			const gchar* _tmp75_;
			const gchar* _tmp76_;
			const gchar* _tmp77_;
			gint layout_width = 0;
			gint layout_height = 0;
			gdouble text_width = 0.0;
			gdouble text_height = 0.0;
			PangoLayout* layout = NULL;
			gint _tmp78_ = 0;
			GdkPixbuf* _tmp79_;
			GdkPixbuf* _tmp80_;
			GdkPixbuf* _tmp81_;
			gboolean _tmp82_;
			gint icon_width = 0;
			GdkRGBA rgba = {0};
			gboolean colored = FALSE;
			GtkStyleContext* _tmp88_;
			GdkRGBA _tmp89_ = {0};
			gboolean _tmp90_;
			GdkRGBA _tmp95_;
			GdkRGBA _tmp96_;
			GdkRGBA _tmp97_;
			PangoLayout* _tmp107_;
			gint _tmp108_ = 0;
			gint _tmp109_ = 0;
			gdouble vertical_offset = 0.0;
			PangoLayout* _tmp110_;
			const gchar* _tmp111_;
			PangoLayout* _tmp112_;
			_tmp75_ = self->placeholder;
			_vala_assert (_tmp75_ != NULL, "placeholder != null");
			_tmp76_ = gtk_entry_get_text ((GtkEntry*) self);
			_tmp77_ = _tmp76_;
			_vala_assert (_tmp77_ != NULL, "text != null");
			g_object_get ((GtkEntry*) self, "primary-icon-pixbuf", &_tmp79_, NULL);
			_tmp80_ = _tmp79_;
			_tmp81_ = _tmp80_;
			_tmp82_ = _tmp81_ != NULL;
			_g_object_unref0 (_tmp81_);
			if (_tmp82_) {
				GdkPixbuf* _tmp83_;
				GdkPixbuf* _tmp84_;
				GdkPixbuf* _tmp85_;
				gint _tmp86_;
				gint _tmp87_;
				g_object_get ((GtkEntry*) self, "primary-icon-pixbuf", &_tmp83_, NULL);
				_tmp84_ = _tmp83_;
				_tmp85_ = _tmp84_;
				_tmp86_ = gdk_pixbuf_get_width (_tmp85_);
				_tmp87_ = _tmp86_;
				_tmp78_ = _tmp87_ + 5;
				_g_object_unref0 (_tmp85_);
			} else {
				_tmp78_ = 0;
			}
			icon_width = _tmp78_;
			_tmp88_ = gtk_widget_get_style_context ((GtkWidget*) self);
			_tmp90_ = gtk_style_context_lookup_color (_tmp88_, "placeholder_text_color", &_tmp89_);
			rgba = _tmp89_;
			colored = _tmp90_;
			if (!colored) {
				GtkStyleContext* _tmp91_;
				GdkRGBA _tmp92_ = {0};
				gboolean _tmp93_;
				_tmp91_ = gtk_widget_get_style_context ((GtkWidget*) self);
				_tmp93_ = gtk_style_context_lookup_color (_tmp91_, "text_color", &_tmp92_);
				rgba = _tmp92_;
				colored = _tmp93_;
				if (!colored) {
					GdkRGBA _tmp94_ = {0};
					_tmp94_.red = 0.6;
					_tmp94_.green = 0.6;
					_tmp94_.blue = 0.5;
					_tmp94_.alpha = (gdouble) 1;
					rgba = _tmp94_;
				}
			}
			_tmp95_ = rgba;
			_tmp96_ = rgba;
			_tmp97_ = rgba;
			cairo_set_source_rgba (cr, _tmp95_.red, _tmp96_.green, _tmp97_.blue, (gdouble) 1);
			if (is_rtl) {
				const gchar* _tmp98_;
				const gchar* _tmp99_;
				const gchar* _tmp100_;
				gchar* _tmp101_;
				gchar* _tmp102_;
				PangoLayout* _tmp103_;
				_tmp98_ = gtk_entry_get_text ((GtkEntry*) self);
				_tmp99_ = _tmp98_;
				_tmp100_ = self->placeholder;
				_tmp101_ = g_strconcat (_tmp99_, _tmp100_, NULL);
				_tmp102_ = _tmp101_;
				_tmp103_ = gtk_widget_create_pango_layout ((GtkWidget*) self, _tmp102_);
				_g_object_unref0 (layout);
				layout = _tmp103_;
				_g_free0 (_tmp102_);
			} else {
				const gchar* _tmp104_;
				const gchar* _tmp105_;
				PangoLayout* _tmp106_;
				_tmp104_ = gtk_entry_get_text ((GtkEntry*) self);
				_tmp105_ = _tmp104_;
				_tmp106_ = gtk_widget_create_pango_layout ((GtkWidget*) self, _tmp105_);
				_g_object_unref0 (layout);
				layout = _tmp106_;
			}
			_tmp107_ = layout;
			pango_layout_get_size (_tmp107_, &_tmp108_, &_tmp109_);
			layout_width = _tmp108_;
			layout_height = _tmp109_;
			text_width = pango_units_to_double (layout_width);
			text_height = pango_units_to_double (layout_height);
			vertical_offset = (gtk_widget_get_allocated_height ((GtkWidget*) self) / 2) - (text_height / 2);
			if (is_rtl) {
				cairo_move_to (cr, width - ((text_width + icon_width) + 6), vertical_offset);
			} else {
				cairo_move_to (cr, (text_width + icon_width) + 6, vertical_offset);
			}
			_tmp110_ = layout;
			_tmp111_ = self->placeholder;
			pango_layout_set_text (_tmp110_, _tmp111_, -1);
			_tmp112_ = layout;
			pango_cairo_show_layout (cr, _tmp112_);
			_g_object_unref0 (layout);
		}
	}
	result = TRUE;
	return result;
}

static gint
files_view_chrome_basic_breadcrumbs_entry_real_get_minimum_width (FilesViewChromeNavigatable* base)
{
	FilesViewChromeBasicBreadcrumbsEntry * self;
	gint result;
	self = (FilesViewChromeBasicBreadcrumbsEntry*) base;
	result = self->priv->minimum_width;
	return result;
}

/**Functions to aid testing **/
gchar*
files_view_chrome_basic_breadcrumbs_entry_get_first_element_icon_name (FilesViewChromeBasicBreadcrumbsEntry* self)
{
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->elements;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ >= 1) {
		GeeArrayList* _tmp3_;
		gpointer _tmp4_;
		FilesViewChromeBreadcrumbElement* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp3_ = self->elements;
		_tmp4_ = gee_abstract_list_get ((GeeAbstractList*) _tmp3_, 0);
		_tmp5_ = (FilesViewChromeBreadcrumbElement*) _tmp4_;
		_tmp6_ = files_view_chrome_breadcrumb_element_get_icon_name (_tmp5_);
		_tmp7_ = _tmp6_;
		_g_object_unref0 (_tmp5_);
		result = _tmp7_;
		return result;
	} else {
		gchar* _tmp8_;
		_tmp8_ = g_strdup ("null");
		result = _tmp8_;
		return result;
	}
}

FilesViewChromeBasicBreadcrumbsEntry*
files_view_chrome_basic_breadcrumbs_entry_construct (GType object_type)
{
	FilesViewChromeBasicBreadcrumbsEntry * self = NULL;
	self = (FilesViewChromeBasicBreadcrumbsEntry*) g_object_new (object_type, NULL);
	return self;
}

FilesViewChromeBasicBreadcrumbsEntry*
files_view_chrome_basic_breadcrumbs_entry_new (void)
{
	return files_view_chrome_basic_breadcrumbs_entry_construct (FILES_VIEW_CHROME_TYPE_BASIC_BREADCRUMBS_ENTRY);
}

static const gchar*
files_view_chrome_basic_breadcrumbs_entry_real_get_action_icon_name (FilesViewChromeNavigatable* base)
{
	const gchar* result;
	FilesViewChromeBasicBreadcrumbsEntry* self;
	const gchar* _tmp0_;
	self = (FilesViewChromeBasicBreadcrumbsEntry*) base;
	_tmp0_ = gtk_entry_get_icon_name ((GtkEntry*) self, GTK_ENTRY_ICON_SECONDARY);
	result = _tmp0_;
	return result;
}

static void
files_view_chrome_basic_breadcrumbs_entry_real_set_action_icon_name (FilesViewChromeNavigatable* base,
                                                                     const gchar* value)
{
	FilesViewChromeBasicBreadcrumbsEntry* self;
	self = (FilesViewChromeBasicBreadcrumbsEntry*) base;
	if (value != NULL) {
		gtk_entry_set_icon_from_icon_name ((GtkEntry*) self, GTK_ENTRY_ICON_SECONDARY, value);
		g_object_set ((GtkEntry*) self, "secondary-icon-activatable", TRUE, NULL);
		g_object_set ((GtkEntry*) self, "secondary-icon-sensitive", TRUE, NULL);
	} else {
		files_view_chrome_navigatable_hide_action_icon ((FilesViewChromeNavigatable*) self);
	}
	g_object_notify_by_pspec ((GObject *) self, files_view_chrome_basic_breadcrumbs_entry_properties[FILES_VIEW_CHROME_BASIC_BREADCRUMBS_ENTRY_ACTION_ICON_NAME_PROPERTY]);
}

static gboolean
files_view_chrome_basic_breadcrumbs_entry_real_get_hide_breadcrumbs (FilesViewChromeNavigatable* base)
{
	gboolean result;
	FilesViewChromeBasicBreadcrumbsEntry* self;
	self = (FilesViewChromeBasicBreadcrumbsEntry*) base;
	result = self->priv->_hide_breadcrumbs;
	return result;
}

static void
files_view_chrome_basic_breadcrumbs_entry_real_set_hide_breadcrumbs (FilesViewChromeNavigatable* base,
                                                                     gboolean value)
{
	FilesViewChromeBasicBreadcrumbsEntry* self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = (FilesViewChromeBasicBreadcrumbsEntry*) base;
	self->priv->_hide_breadcrumbs = value;
	_tmp0_ = files_view_chrome_navigatable_get_hide_breadcrumbs ((FilesViewChromeNavigatable*) self);
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		files_view_chrome_navigatable_set_entry_text ((FilesViewChromeNavigatable*) self, "");
	}
	g_object_notify_by_pspec ((GObject *) self, files_view_chrome_basic_breadcrumbs_entry_properties[FILES_VIEW_CHROME_BASIC_BREADCRUMBS_ENTRY_HIDE_BREADCRUMBS_PROPERTY]);
}

static void
_files_view_chrome_basic_breadcrumbs_entry_after_realize_gtk_widget_realize (GtkWidget* _sender,
                                                                             gpointer self)
{
	files_view_chrome_basic_breadcrumbs_entry_after_realize ((FilesViewChromeBasicBreadcrumbsEntry*) self);
}

static void
_files_view_chrome_basic_breadcrumbs_entry_on_activate_gtk_entry_activate (GtkEntry* _sender,
                                                                           gpointer self)
{
	files_view_chrome_basic_breadcrumbs_entry_on_activate ((FilesViewChromeBasicBreadcrumbsEntry*) self);
}

static void
_files_view_chrome_basic_breadcrumbs_entry_on_icon_press_gtk_entry_icon_press (GtkEntry* _sender,
                                                                               GtkEntryIconPosition icon_pos,
                                                                               GdkEvent* event,
                                                                               gpointer self)
{
	files_view_chrome_basic_breadcrumbs_entry_on_icon_press ((FilesViewChromeBasicBreadcrumbsEntry*) self, icon_pos);
}

static gboolean
_files_view_chrome_basic_breadcrumbs_entry_on_focus_in_gtk_widget_focus_in_event (GtkWidget* _sender,
                                                                                  GdkEventFocus* event,
                                                                                  gpointer self)
{
	gboolean result;
	result = files_view_chrome_basic_breadcrumbs_entry_on_focus_in ((FilesViewChromeBasicBreadcrumbsEntry*) self, event);
	return result;
}

static gboolean
_files_view_chrome_basic_breadcrumbs_entry_on_focus_out_gtk_widget_focus_out_event (GtkWidget* _sender,
                                                                                    GdkEventFocus* event,
                                                                                    gpointer self)
{
	gboolean result;
	result = files_view_chrome_basic_breadcrumbs_entry_on_focus_out ((FilesViewChromeBasicBreadcrumbsEntry*) self, event);
	return result;
}

static void
_files_view_chrome_basic_breadcrumbs_entry_on_entry_text_changed_gtk_editable_changed (GtkEditable* _sender,
                                                                                       gpointer self)
{
	files_view_chrome_basic_breadcrumbs_entry_on_entry_text_changed ((FilesViewChromeBasicBreadcrumbsEntry*) self);
}

static gboolean
_files_view_chrome_basic_breadcrumbs_entry_on_key_press_event_gtk_event_controller_key_key_pressed (GtkEventControllerKey* _sender,
                                                                                                    guint keyval,
                                                                                                    guint keycode,
                                                                                                    GdkModifierType state,
                                                                                                    gpointer self)
{
	gboolean result;
	result = files_view_chrome_basic_breadcrumbs_entry_on_key_press_event ((FilesViewChromeBasicBreadcrumbsEntry*) self, keyval, keycode, state);
	return result;
}

static void
_files_view_chrome_basic_breadcrumbs_entry_on_button_pressed_event_gtk_gesture_multi_press_pressed (GtkGestureMultiPress* _sender,
                                                                                                    gint n_press,
                                                                                                    gdouble x,
                                                                                                    gdouble y,
                                                                                                    gpointer self)
{
	files_view_chrome_basic_breadcrumbs_entry_on_button_pressed_event ((FilesViewChromeBasicBreadcrumbsEntry*) self, n_press, x, y);
}

static void
_files_view_chrome_basic_breadcrumbs_entry_on_button_released_event_gtk_gesture_multi_press_released (GtkGestureMultiPress* _sender,
                                                                                                      gint n_press,
                                                                                                      gdouble x,
                                                                                                      gdouble y,
                                                                                                      gpointer self)
{
	files_view_chrome_basic_breadcrumbs_entry_on_button_released_event ((FilesViewChromeBasicBreadcrumbsEntry*) self, n_press, x, y);
}

static void
_files_view_chrome_basic_breadcrumbs_entry_on_motion_event_gtk_event_controller_motion_motion (GtkEventControllerMotion* _sender,
                                                                                               gdouble x,
                                                                                               gdouble y,
                                                                                               gpointer self)
{
	files_view_chrome_basic_breadcrumbs_entry_on_motion_event ((FilesViewChromeBasicBreadcrumbsEntry*) self, x, y);
}

static void
_files_view_chrome_basic_breadcrumbs_entry___lambda69_ (FilesViewChromeBasicBreadcrumbsEntry* self)
{
	FilesViewChromeBreadcrumbIconList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	_tmp0_ = self->priv->breadcrumb_icons;
	_tmp1_ = gtk_widget_get_scale_factor ((GtkWidget*) self);
	_tmp2_ = _tmp1_;
	files_view_chrome_breadcrumb_icon_list_set_scale (_tmp0_, _tmp2_);
}

static void
__files_view_chrome_basic_breadcrumbs_entry___lambda69__g_object_notify (GObject* _sender,
                                                                         GParamSpec* pspec,
                                                                         gpointer self)
{
	_files_view_chrome_basic_breadcrumbs_entry___lambda69_ ((FilesViewChromeBasicBreadcrumbsEntry*) self);
}

static GObject *
files_view_chrome_basic_breadcrumbs_entry_constructor (GType type,
                                                       guint n_construct_properties,
                                                       GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	FilesViewChromeBasicBreadcrumbsEntry * self;
	GtkStyleContext* style_context = NULL;
	GtkStyleContext* _tmp0_;
	GtkStyleContext* _tmp1_;
	GtkCssProvider* css_provider = NULL;
	GtkCssProvider* _tmp2_;
	GtkStyleContext* _tmp8_;
	FilesViewChromeBreadcrumbIconList* _tmp9_;
	GeeArrayList* _tmp10_;
	GeeArrayList* _tmp11_;
	GtkEventControllerKey* _tmp12_ = NULL;
	GtkEventControllerKey* _tmp13_;
	GtkGestureMultiPress* _tmp14_ = NULL;
	GtkGestureMultiPress* _tmp15_;
	GtkGestureMultiPress* _tmp16_;
	GtkEventControllerMotion* _tmp17_;
	GtkEventControllerMotion* _tmp18_;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (files_view_chrome_basic_breadcrumbs_entry_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FILES_VIEW_CHROME_TYPE_BASIC_BREADCRUMBS_ENTRY, FilesViewChromeBasicBreadcrumbsEntry);
	g_object_set ((GtkEntry*) self, "truncate-multiline", TRUE, NULL);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	style_context = _tmp0_;
	_tmp1_ = style_context;
	gtk_style_context_add_class (_tmp1_, "pathbar");
	_tmp2_ = gtk_css_provider_new ();
	css_provider = _tmp2_;
	{
		GtkCssProvider* _tmp3_;
		GtkStyleContext* _tmp4_;
		GtkCssProvider* _tmp5_;
		_tmp3_ = css_provider;
		gtk_css_provider_load_from_data (_tmp3_, ".noradius-button { border-radius: 0; }", (gssize) -1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp4_ = style_context;
		_tmp5_ = css_provider;
		gtk_style_context_add_provider (_tmp4_, (GtkStyleProvider*) _tmp5_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		g_critical ("BasicBreadcrumbsEntry.vala:93: Unable to style pathbar button: %s", _tmp7_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (css_provider);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	_tmp8_ = style_context;
	_tmp9_ = files_view_chrome_breadcrumb_icon_list_new (_tmp8_);
	_g_object_unref0 (self->priv->breadcrumb_icons);
	self->priv->breadcrumb_icons = _tmp9_;
	_tmp10_ = gee_array_list_new (FILES_VIEW_CHROME_TYPE_BREADCRUMB_ELEMENT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->elements);
	self->elements = _tmp10_;
	_tmp11_ = gee_array_list_new (FILES_VIEW_CHROME_TYPE_BREADCRUMB_ELEMENT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->old_elements);
	self->old_elements = (GeeCollection*) _tmp11_;
	g_signal_connect_object ((GtkWidget*) self, "realize", (GCallback) _files_view_chrome_basic_breadcrumbs_entry_after_realize_gtk_widget_realize, self, G_CONNECT_AFTER);
	g_signal_connect_object ((GtkEntry*) self, "activate", (GCallback) _files_view_chrome_basic_breadcrumbs_entry_on_activate_gtk_entry_activate, self, 0);
	g_signal_connect_object ((GtkEntry*) self, "icon-press", (GCallback) _files_view_chrome_basic_breadcrumbs_entry_on_icon_press_gtk_entry_icon_press, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "focus-in-event", (GCallback) _files_view_chrome_basic_breadcrumbs_entry_on_focus_in_gtk_widget_focus_in_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "focus-out-event", (GCallback) _files_view_chrome_basic_breadcrumbs_entry_on_focus_out_gtk_widget_focus_out_event, self, 0);
	g_signal_connect_object ((GtkEditable*) self, "changed", (GCallback) _files_view_chrome_basic_breadcrumbs_entry_on_entry_text_changed_gtk_editable_changed, self, 0);
	_tmp12_ = (GtkEventControllerKey*) gtk_event_controller_key_new ((GtkWidget*) self);
	gtk_event_controller_set_propagation_phase ((GtkEventController*) _tmp12_, GTK_PHASE_BUBBLE);
	_g_object_unref0 (self->priv->key_controller);
	self->priv->key_controller = _tmp12_;
	_tmp13_ = self->priv->key_controller;
	g_signal_connect_object (_tmp13_, "key-pressed", (GCallback) _files_view_chrome_basic_breadcrumbs_entry_on_key_press_event_gtk_event_controller_key_key_pressed, self, 0);
	_tmp14_ = (GtkGestureMultiPress*) gtk_gesture_multi_press_new ((GtkWidget*) self);
	gtk_gesture_single_set_button ((GtkGestureSingle*) _tmp14_, (guint) 0);
	gtk_event_controller_set_propagation_phase ((GtkEventController*) _tmp14_, GTK_PHASE_CAPTURE);
	_g_object_unref0 (self->button_controller);
	self->button_controller = _tmp14_;
	_tmp15_ = self->button_controller;
	g_signal_connect_object (_tmp15_, "pressed", (GCallback) _files_view_chrome_basic_breadcrumbs_entry_on_button_pressed_event_gtk_gesture_multi_press_pressed, self, 0);
	_tmp16_ = self->button_controller;
	g_signal_connect_object (_tmp16_, "released", (GCallback) _files_view_chrome_basic_breadcrumbs_entry_on_button_released_event_gtk_gesture_multi_press_released, self, 0);
	_tmp17_ = (GtkEventControllerMotion*) gtk_event_controller_motion_new ((GtkWidget*) self);
	_g_object_unref0 (self->priv->motion_controller);
	self->priv->motion_controller = _tmp17_;
	_tmp18_ = self->priv->motion_controller;
	g_signal_connect_object (_tmp18_, "motion", (GCallback) _files_view_chrome_basic_breadcrumbs_entry_on_motion_event_gtk_event_controller_motion_motion, self, 0);
	self->priv->minimum_width = 100;
	g_signal_connect_object ((GObject*) self, "notify::scale-factor", (GCallback) __files_view_chrome_basic_breadcrumbs_entry___lambda69__g_object_notify, self, 0);
	_g_object_unref0 (css_provider);
	return obj;
}

static void
files_view_chrome_basic_breadcrumbs_entry_class_init (FilesViewChromeBasicBreadcrumbsEntryClass * klass,
                                                      gpointer klass_data)
{
	files_view_chrome_basic_breadcrumbs_entry_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FilesViewChromeBasicBreadcrumbsEntry_private_offset);
	((FilesViewChromeBasicBreadcrumbsEntryClass *) klass)->reset = (void (*) (FilesViewChromeBasicBreadcrumbsEntry*)) files_view_chrome_basic_breadcrumbs_entry_real_reset;
	((FilesViewChromeBasicBreadcrumbsEntryClass *) klass)->on_key_press_event = (gboolean (*) (FilesViewChromeBasicBreadcrumbsEntry*, guint, guint, GdkModifierType)) files_view_chrome_basic_breadcrumbs_entry_real_on_key_press_event;
	((FilesViewChromeBasicBreadcrumbsEntryClass *) klass)->on_button_pressed_event = (void (*) (FilesViewChromeBasicBreadcrumbsEntry*, gint, gdouble, gdouble)) files_view_chrome_basic_breadcrumbs_entry_real_on_button_pressed_event;
	((FilesViewChromeBasicBreadcrumbsEntryClass *) klass)->on_button_released_event = (void (*) (FilesViewChromeBasicBreadcrumbsEntry*, gint, gdouble, gdouble)) files_view_chrome_basic_breadcrumbs_entry_real_on_button_released_event;
	((FilesViewChromeBasicBreadcrumbsEntryClass *) klass)->on_focus_out = (gboolean (*) (FilesViewChromeBasicBreadcrumbsEntry*, GdkEventFocus*)) files_view_chrome_basic_breadcrumbs_entry_real_on_focus_out;
	((FilesViewChromeBasicBreadcrumbsEntryClass *) klass)->on_focus_in = (gboolean (*) (FilesViewChromeBasicBreadcrumbsEntry*, GdkEventFocus*)) files_view_chrome_basic_breadcrumbs_entry_real_on_focus_in;
	((FilesViewChromeBasicBreadcrumbsEntryClass *) klass)->on_activate = (void (*) (FilesViewChromeBasicBreadcrumbsEntry*)) files_view_chrome_basic_breadcrumbs_entry_real_on_activate;
	((FilesViewChromeBasicBreadcrumbsEntryClass *) klass)->on_entry_text_changed = (void (*) (FilesViewChromeBasicBreadcrumbsEntry*)) files_view_chrome_basic_breadcrumbs_entry_real_on_entry_text_changed;
	((FilesViewChromeBasicBreadcrumbsEntryClass *) klass)->go_up = (void (*) (FilesViewChromeBasicBreadcrumbsEntry*)) files_view_chrome_basic_breadcrumbs_entry_real_go_up;
	((FilesViewChromeBasicBreadcrumbsEntryClass *) klass)->set_default_entry_tooltip = (void (*) (FilesViewChromeBasicBreadcrumbsEntry*)) files_view_chrome_basic_breadcrumbs_entry_real_set_default_entry_tooltip;
	((GtkWidgetClass *) klass)->draw = (gboolean (*) (GtkWidget*, cairo_t*)) files_view_chrome_basic_breadcrumbs_entry_real_draw;
	G_OBJECT_CLASS (klass)->get_property = _vala_files_view_chrome_basic_breadcrumbs_entry_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_files_view_chrome_basic_breadcrumbs_entry_set_property;
	G_OBJECT_CLASS (klass)->constructor = files_view_chrome_basic_breadcrumbs_entry_constructor;
	G_OBJECT_CLASS (klass)->finalize = files_view_chrome_basic_breadcrumbs_entry_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_VIEW_CHROME_BASIC_BREADCRUMBS_ENTRY_ACTION_ICON_NAME_PROPERTY, files_view_chrome_basic_breadcrumbs_entry_properties[FILES_VIEW_CHROME_BASIC_BREADCRUMBS_ENTRY_ACTION_ICON_NAME_PROPERTY] = g_param_spec_string ("action-icon-name", "action-icon-name", "action-icon-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_VIEW_CHROME_BASIC_BREADCRUMBS_ENTRY_HIDE_BREADCRUMBS_PROPERTY, files_view_chrome_basic_breadcrumbs_entry_properties[FILES_VIEW_CHROME_BASIC_BREADCRUMBS_ENTRY_HIDE_BREADCRUMBS_PROPERTY] = g_param_spec_boolean ("hide-breadcrumbs", "hide-breadcrumbs", "hide-breadcrumbs", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
files_view_chrome_basic_breadcrumbs_entry_files_view_chrome_navigatable_interface_init (FilesViewChromeNavigatableIface * iface,
                                                                                        gpointer iface_data)
{
	files_view_chrome_basic_breadcrumbs_entry_files_view_chrome_navigatable_parent_iface = g_type_interface_peek_parent (iface);
	iface->set_breadcrumbs_path = (void (*) (FilesViewChromeNavigatable*, const gchar*)) files_view_chrome_basic_breadcrumbs_entry_real_set_breadcrumbs_path;
	iface->get_breadcrumbs_path = (gchar* (*) (FilesViewChromeNavigatable*, gboolean)) files_view_chrome_basic_breadcrumbs_entry_real_get_breadcrumbs_path;
	iface->set_action_icon_tooltip = (void (*) (FilesViewChromeNavigatable*, const gchar*)) files_view_chrome_basic_breadcrumbs_entry_real_set_action_icon_tooltip;
	iface->hide_action_icon = (void (*) (FilesViewChromeNavigatable*)) files_view_chrome_basic_breadcrumbs_entry_real_hide_action_icon;
	iface->set_entry_text = (void (*) (FilesViewChromeNavigatable*, const gchar*)) files_view_chrome_basic_breadcrumbs_entry_real_set_entry_text;
	iface->get_entry_text = (gchar* (*) (FilesViewChromeNavigatable*)) files_view_chrome_basic_breadcrumbs_entry_real_get_entry_text;
	iface->reset = (void (*) (FilesViewChromeNavigatable*)) files_view_chrome_basic_breadcrumbs_entry_reset;
	iface->set_animation_visible = (void (*) (FilesViewChromeNavigatable*, gboolean)) files_view_chrome_basic_breadcrumbs_entry_real_set_animation_visible;
	iface->set_placeholder = (void (*) (FilesViewChromeNavigatable*, const gchar*)) files_view_chrome_basic_breadcrumbs_entry_real_set_placeholder;
	iface->show_default_action_icon = (void (*) (FilesViewChromeNavigatable*)) files_view_chrome_basic_breadcrumbs_entry_real_show_default_action_icon;
	iface->set_default_action_icon_tooltip = (void (*) (FilesViewChromeNavigatable*)) files_view_chrome_basic_breadcrumbs_entry_real_set_default_action_icon_tooltip;
	iface->set_default_entry_tooltip = (void (*) (FilesViewChromeNavigatable*)) files_view_chrome_basic_breadcrumbs_entry_set_default_entry_tooltip;
	iface->get_minimum_width = (gint (*) (FilesViewChromeNavigatable*)) files_view_chrome_basic_breadcrumbs_entry_real_get_minimum_width;
	iface->get_action_icon_name = files_view_chrome_basic_breadcrumbs_entry_real_get_action_icon_name;
	iface->set_action_icon_name = files_view_chrome_basic_breadcrumbs_entry_real_set_action_icon_name;
	iface->get_hide_breadcrumbs = files_view_chrome_basic_breadcrumbs_entry_real_get_hide_breadcrumbs;
	iface->set_hide_breadcrumbs = files_view_chrome_basic_breadcrumbs_entry_real_set_hide_breadcrumbs;
}

static void
files_view_chrome_basic_breadcrumbs_entry_instance_init (FilesViewChromeBasicBreadcrumbsEntry * self,
                                                         gpointer klass)
{
	gchar* _tmp0_;
	self->priv = files_view_chrome_basic_breadcrumbs_entry_get_instance_private (self);
	self->priv->_hide_breadcrumbs = FALSE;
	_tmp0_ = g_strdup ("");
	self->placeholder = _tmp0_;
	self->clicked_element = NULL;
	self->current_dir_path = NULL;
	self->animation_visible = TRUE;
	self->priv->animation_timeout_id = (guint) 0;
	self->priv->entry_window = NULL;
	self->context_menu_showing = FALSE;
	self->priv->focus_out_timeout_id = (guint) 0;
}

static void
files_view_chrome_basic_breadcrumbs_entry_finalize (GObject * obj)
{
	FilesViewChromeBasicBreadcrumbsEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FILES_VIEW_CHROME_TYPE_BASIC_BREADCRUMBS_ENTRY, FilesViewChromeBasicBreadcrumbsEntry);
	_g_free0 (self->placeholder);
	_g_object_unref0 (self->clicked_element);
	_g_free0 (self->current_dir_path);
	_g_object_unref0 (self->elements);
	_g_object_unref0 (self->priv->breadcrumb_icons);
	_g_object_unref0 (self->old_elements);
	_g_object_unref0 (self->button_context);
	_g_object_unref0 (self->button_context_active);
	_g_object_unref0 (self->priv->entry_window);
	_g_object_unref0 (self->priv->key_controller);
	_g_object_unref0 (self->button_controller);
	_g_object_unref0 (self->priv->motion_controller);
	G_OBJECT_CLASS (files_view_chrome_basic_breadcrumbs_entry_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
files_view_chrome_basic_breadcrumbs_entry_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FilesViewChromeBasicBreadcrumbsEntryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) files_view_chrome_basic_breadcrumbs_entry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FilesViewChromeBasicBreadcrumbsEntry), 0, (GInstanceInitFunc) files_view_chrome_basic_breadcrumbs_entry_instance_init, NULL };
	static const GInterfaceInfo files_view_chrome_navigatable_info = { (GInterfaceInitFunc) files_view_chrome_basic_breadcrumbs_entry_files_view_chrome_navigatable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType files_view_chrome_basic_breadcrumbs_entry_type_id;
	files_view_chrome_basic_breadcrumbs_entry_type_id = g_type_register_static (gtk_entry_get_type (), "FilesViewChromeBasicBreadcrumbsEntry", &g_define_type_info, 0);
	g_type_add_interface_static (files_view_chrome_basic_breadcrumbs_entry_type_id, FILES_VIEW_CHROME_TYPE_NAVIGATABLE, &files_view_chrome_navigatable_info);
	FilesViewChromeBasicBreadcrumbsEntry_private_offset = g_type_add_instance_private (files_view_chrome_basic_breadcrumbs_entry_type_id, sizeof (FilesViewChromeBasicBreadcrumbsEntryPrivate));
	return files_view_chrome_basic_breadcrumbs_entry_type_id;
}

GType
files_view_chrome_basic_breadcrumbs_entry_get_type (void)
{
	static volatile gsize files_view_chrome_basic_breadcrumbs_entry_type_id__once = 0;
	if (g_once_init_enter (&files_view_chrome_basic_breadcrumbs_entry_type_id__once)) {
		GType files_view_chrome_basic_breadcrumbs_entry_type_id;
		files_view_chrome_basic_breadcrumbs_entry_type_id = files_view_chrome_basic_breadcrumbs_entry_get_type_once ();
		g_once_init_leave (&files_view_chrome_basic_breadcrumbs_entry_type_id__once, files_view_chrome_basic_breadcrumbs_entry_type_id);
	}
	return files_view_chrome_basic_breadcrumbs_entry_type_id__once;
}

static void
_vala_files_view_chrome_basic_breadcrumbs_entry_get_property (GObject * object,
                                                              guint property_id,
                                                              GValue * value,
                                                              GParamSpec * pspec)
{
	FilesViewChromeBasicBreadcrumbsEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FILES_VIEW_CHROME_TYPE_BASIC_BREADCRUMBS_ENTRY, FilesViewChromeBasicBreadcrumbsEntry);
	switch (property_id) {
		case FILES_VIEW_CHROME_BASIC_BREADCRUMBS_ENTRY_ACTION_ICON_NAME_PROPERTY:
		g_value_set_string (value, files_view_chrome_navigatable_get_action_icon_name ((FilesViewChromeNavigatable*) self));
		break;
		case FILES_VIEW_CHROME_BASIC_BREADCRUMBS_ENTRY_HIDE_BREADCRUMBS_PROPERTY:
		g_value_set_boolean (value, files_view_chrome_navigatable_get_hide_breadcrumbs ((FilesViewChromeNavigatable*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_files_view_chrome_basic_breadcrumbs_entry_set_property (GObject * object,
                                                              guint property_id,
                                                              const GValue * value,
                                                              GParamSpec * pspec)
{
	FilesViewChromeBasicBreadcrumbsEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FILES_VIEW_CHROME_TYPE_BASIC_BREADCRUMBS_ENTRY, FilesViewChromeBasicBreadcrumbsEntry);
	switch (property_id) {
		case FILES_VIEW_CHROME_BASIC_BREADCRUMBS_ENTRY_ACTION_ICON_NAME_PROPERTY:
		files_view_chrome_navigatable_set_action_icon_name ((FilesViewChromeNavigatable*) self, g_value_get_string (value));
		break;
		case FILES_VIEW_CHROME_BASIC_BREADCRUMBS_ENTRY_HIDE_BREADCRUMBS_PROPERTY:
		files_view_chrome_navigatable_set_hide_breadcrumbs ((FilesViewChromeNavigatable*) self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

