/* ConnectServerDialog.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from ConnectServerDialog.vala, do not modify */

/*
 * SPDX-License-Identifier: GPL-3.0
 * SPDX-FileCopyrightText: 2015-2023 elementary, Inc. (https://elementary.io)
 *
 * Authored by: Corentin Noël <corentin@elementary.io>
 */

#include "pantheon-files-core.h"
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <granite.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define PF_CONNECT_SERVER_DIALOG_TYPE_METHOD_INFO (pf_connect_server_dialog_method_info_get_type ())
typedef struct _PFConnectServerDialogMethodInfo PFConnectServerDialogMethodInfo;
typedef enum  {
	PF_CONNECT_SERVER_DIALOG_WIDGETS_FLAG_NONE = 1 << 0,
	PF_CONNECT_SERVER_DIALOG_WIDGETS_FLAG_DEFAULT = 1 << 1,
	PF_CONNECT_SERVER_DIALOG_WIDGETS_FLAG_SHARE = 1 << 2,
	PF_CONNECT_SERVER_DIALOG_WIDGETS_FLAG_PORT = 1 << 3,
	PF_CONNECT_SERVER_DIALOG_WIDGETS_FLAG_USER = 1 << 4,
	PF_CONNECT_SERVER_DIALOG_WIDGETS_FLAG_DOMAIN = 1 << 5,
	PF_CONNECT_SERVER_DIALOG_WIDGETS_FLAG_ANONYMOUS = 1 << 6
} PFConnectServerDialogWidgetsFlag;

#define PF_CONNECT_SERVER_DIALOG_TYPE_WIDGETS_FLAG (pf_connect_server_dialog_widgets_flag_get_type ())
enum  {
	PF_CONNECT_SERVER_DIALOG_0_PROPERTY,
	PF_CONNECT_SERVER_DIALOG_SERVER_URI_PROPERTY,
	PF_CONNECT_SERVER_DIALOG_NUM_PROPERTIES
};
static GParamSpec* pf_connect_server_dialog_properties[PF_CONNECT_SERVER_DIALOG_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _PfConnectServerDialogConnectToServerData PfConnectServerDialogConnectToServerData;
typedef struct _PfConnectServerDialogFillDetailsAsyncData PfConnectServerDialogFillDetailsAsyncData;

struct _PFConnectServerDialogMethodInfo {
	gchar* scheme;
	PFConnectServerDialogWidgetsFlag flags;
	gushort port;
	gchar* description;
};

struct _PFConnectServerDialogPrivate {
	PFConnectServerDialogMethodInfo* methods;
	gint methods_length1;
	gint _methods_size_;
	GtkInfoBar* info_bar;
	GraniteValidatedEntry* server_entry;
	GtkSpinButton* port_spinbutton;
	GtkRevealer* port_revealer;
	GtkRevealer* remember_revealer;
	GtkEntry* share_entry;
	GtkComboBox* type_combobox;
	GtkEntry* folder_entry;
	GraniteValidatedEntry* domain_entry;
	GraniteValidatedEntry* user_entry;
	GraniteValidatedEntry* password_entry;
	GtkCheckButton* remember_checkbutton;
	GtkButton* connect_button;
	GtkButton* continue_button;
	GtkButton* cancel_button;
	GraniteHeaderLabel* user_header_label;
	GtkLabel* info_label;
	GtkStack* stack;
	GCancellable* mount_cancellable;
	gboolean needs_password;
	gchar* _server_uri;
};

struct _PfConnectServerDialogConnectToServerData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	PFConnectServerDialog* self;
	GtkTreeIter iter;
	GtkComboBox* _tmp0_;
	GtkTreeIter _tmp1_;
	gboolean _tmp2_;
	GValue val;
	GtkComboBox* _tmp3_;
	GtkTreeModel* _tmp4_;
	GtkTreeIter _tmp5_;
	GValue _tmp6_;
	PFConnectServerDialogMethodInfo* method_info;
	void* _tmp7_;
	gchar* scheme;
	PFConnectServerDialogMethodInfo* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* server;
	GraniteValidatedEntry* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* user;
	PFConnectServerDialogMethodInfo* _tmp16_;
	gchar* _tmp17_;
	GraniteValidatedEntry* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	PFConnectServerDialogMethodInfo* _tmp22_;
	GraniteValidatedEntry* _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp25_;
	const gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* initial_path;
	PFConnectServerDialogMethodInfo* _tmp28_;
	GtkEntry* _tmp29_;
	const gchar* _tmp30_;
	const gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* folder;
	const gchar* _tmp34_;
	GtkEntry* _tmp35_;
	const gchar* _tmp36_;
	const gchar* _tmp37_;
	gchar* _tmp38_;
	const gchar* _tmp39_;
	gchar* _tmp40_;
	gchar* uri;
	const gchar* _tmp41_;
	gchar* _tmp42_;
	const gchar* _tmp43_;
	const gchar* _tmp44_;
	const gchar* _tmp45_;
	gchar* _tmp46_;
	gchar* _tmp47_;
	gchar* _tmp48_;
	const gchar* _tmp49_;
	const gchar* _tmp50_;
	gchar* _tmp51_;
	GtkSpinButton* _tmp52_;
	gdouble _tmp53_;
	gdouble _tmp54_;
	const gchar* _tmp55_;
	GtkSpinButton* _tmp56_;
	gdouble _tmp57_;
	gdouble _tmp58_;
	gchar* _tmp59_;
	gchar* _tmp60_;
	gchar* _tmp61_;
	const gchar* _tmp62_;
	const gchar* _tmp63_;
	gchar* _tmp64_;
	GFile* location;
	const gchar* _tmp65_;
	GFile* _tmp66_;
	FilesConnectServerOperation* operation;
	FilesConnectServerOperation* _tmp67_;
	GCancellable* _tmp68_;
	const gchar* _tmp69_;
	GFile* _tmp70_;
	FilesConnectServerOperation* _tmp71_;
	GCancellable* _tmp72_;
	GError* e;
	GtkInfoBar* _tmp73_;
	GtkLabel* _tmp74_;
	GError* _tmp75_;
	const gchar* _tmp76_;
	GError* _inner_error1_;
	GError* _inner_error0_;
};

struct _PfConnectServerDialogFillDetailsAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	PFConnectServerDialog* self;
	GMountOperation* mount_operation;
	gchar* default_user;
	gchar* default_domain;
	GAskPasswordFlags askpassword_flags;
	gboolean result;
	GAskPasswordFlags set_flags;
	gchar* password;
	GraniteValidatedEntry* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* username;
	GraniteValidatedEntry* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gboolean _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	gchar* domain;
	GraniteValidatedEntry* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	gboolean _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	GAskPasswordFlags need_mask;
	GraniteValidatedEntry* _tmp24_;
	gboolean _tmp25_;
	GraniteValidatedEntry* _tmp26_;
	GraniteValidatedEntry* _tmp27_;
	gboolean _tmp28_;
	GraniteValidatedEntry* _tmp29_;
	GraniteValidatedEntry* _tmp30_;
	GtkCheckButton* _tmp31_;
	GtkCheckButton* _tmp32_;
	GCancellable* _tmp33_;
	GraniteValidatedEntry* _tmp34_;
	const gchar* _tmp35_;
	const gchar* _tmp36_;
	GraniteValidatedEntry* _tmp37_;
	const gchar* _tmp38_;
	const gchar* _tmp39_;
	GraniteValidatedEntry* _tmp40_;
	const gchar* _tmp41_;
	const gchar* _tmp42_;
	gboolean _tmp43_;
	GraniteValidatedEntry* _tmp44_;
	const gchar* _tmp45_;
	const gchar* _tmp46_;
	GtkCheckButton* _tmp47_;
	gboolean _tmp48_;
	gboolean _tmp49_;
	gboolean should_save;
	GPasswordSave _tmp50_;
	GtkButton* _tmp51_;
};

static gint PFConnectServerDialog_private_offset;
static gpointer pf_connect_server_dialog_parent_class = NULL;

static GType pf_connect_server_dialog_method_info_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static GType pf_connect_server_dialog_widgets_flag_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static PFConnectServerDialogMethodInfo* pf_connect_server_dialog_method_info_dup (const PFConnectServerDialogMethodInfo* self);
static void pf_connect_server_dialog_method_info_free (PFConnectServerDialogMethodInfo* self);
static void pf_connect_server_dialog_method_info_copy (const PFConnectServerDialogMethodInfo* self,
                                                PFConnectServerDialogMethodInfo* dest);
static void pf_connect_server_dialog_method_info_destroy (PFConnectServerDialogMethodInfo* self);
static void _vala_PFConnectServerDialogMethodInfo_array_free (PFConnectServerDialogMethodInfo * array,
                                                       gssize array_length);
static void pf_connect_server_dialog_set_button_sensitivity (PFConnectServerDialog* self);
static gboolean pf_connect_server_dialog_valid_entries (PFConnectServerDialog* self);
static void pf_connect_server_dialog_type_changed (PFConnectServerDialog* self);
static void pf_connect_server_dialog_show_connect_button (PFConnectServerDialog* self);
static void pf_connect_server_dialog_dismiss_info (PFConnectServerDialog* self);
static void pf_connect_server_dialog_verify_details (PFConnectServerDialog* self);
static void pf_connect_server_dialog_show_info (PFConnectServerDialog* self);
static void pf_connect_server_dialog_connect_to_server_data_free (gpointer _data);
static void pf_connect_server_dialog_connect_to_server (PFConnectServerDialog* self,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_);
static void pf_connect_server_dialog_connect_to_server_finish (PFConnectServerDialog* self,
                                                        GAsyncResult* _res_);
static gboolean pf_connect_server_dialog_connect_to_server_co (PfConnectServerDialogConnectToServerData* _data_);
static void pf_connect_server_dialog_set_server_uri (PFConnectServerDialog* self,
                                              const gchar* value);
static void pf_connect_server_dialog_connect_to_server_ready (GObject* source_object,
                                                       GAsyncResult* _res_,
                                                       gpointer _user_data_);
static void pf_connect_server_dialog_fill_details_async_data_free (gpointer _data);
static gboolean pf_connect_server_dialog_fill_details_async_co (PfConnectServerDialogFillDetailsAsyncData* _data_);
static void pf_connect_server_dialog_on_connect_clicked (PFConnectServerDialog* self);
static void pf_connect_server_dialog_on_cancel_clicked (PFConnectServerDialog* self);
static void pf_connect_server_dialog_on_continue_clicked (PFConnectServerDialog* self);
static GtkLabel* pf_connect_server_dialog_new_detailed_label (PFConnectServerDialog* self,
                                                       const gchar* label,
                                                       GtkWidget* linked_widget);
static GObject * pf_connect_server_dialog_constructor (GType type,
                                                guint n_construct_properties,
                                                GObjectConstructParam * construct_properties);
static void _pf_connect_server_dialog_on_cancel_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                     gpointer self);
static void _pf_connect_server_dialog_on_connect_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                      gpointer self);
static void _pf_connect_server_dialog_on_continue_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                       gpointer self);
static gboolean _vala_string_array_contains (gchar* * stack,
                                      gssize stack_length,
                                      const gchar* needle);
static void _pf_connect_server_dialog___lambda25_ (PFConnectServerDialog* self);
static void __pf_connect_server_dialog___lambda25__gtk_combo_box_changed (GtkComboBox* _sender,
                                                                   gpointer self);
static void _pf_connect_server_dialog___lambda26_ (PFConnectServerDialog* self);
static void __pf_connect_server_dialog___lambda26__gtk_editable_changed (GtkEditable* _sender,
                                                                  gpointer self);
static void _pf_connect_server_dialog___lambda27_ (PFConnectServerDialog* self);
static void __pf_connect_server_dialog___lambda27__gtk_editable_changed (GtkEditable* _sender,
                                                                  gpointer self);
static void _pf_connect_server_dialog___lambda28_ (PFConnectServerDialog* self);
static void __pf_connect_server_dialog___lambda28__gtk_editable_changed (GtkEditable* _sender,
                                                                  gpointer self);
static void _pf_connect_server_dialog___lambda29_ (PFConnectServerDialog* self);
static void __pf_connect_server_dialog___lambda29__gtk_editable_changed (GtkEditable* _sender,
                                                                  gpointer self);
static void pf_connect_server_dialog_finalize (GObject * obj);
static GType pf_connect_server_dialog_get_type_once (void);
static void _vala_pf_connect_server_dialog_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec);
static void _vala_pf_connect_server_dialog_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec);
static gssize _vala_array_length (gpointer array);

static inline gpointer
pf_connect_server_dialog_get_instance_private (PFConnectServerDialog* self)
{
	return G_STRUCT_MEMBER_P (self, PFConnectServerDialog_private_offset);
}

 G_GNUC_NO_INLINE static GType
pf_connect_server_dialog_widgets_flag_get_type_once (void)
{
	static const GFlagsValue values[] = {{PF_CONNECT_SERVER_DIALOG_WIDGETS_FLAG_NONE, "PF_CONNECT_SERVER_DIALOG_WIDGETS_FLAG_NONE", "none"}, {PF_CONNECT_SERVER_DIALOG_WIDGETS_FLAG_DEFAULT, "PF_CONNECT_SERVER_DIALOG_WIDGETS_FLAG_DEFAULT", "default"}, {PF_CONNECT_SERVER_DIALOG_WIDGETS_FLAG_SHARE, "PF_CONNECT_SERVER_DIALOG_WIDGETS_FLAG_SHARE", "share"}, {PF_CONNECT_SERVER_DIALOG_WIDGETS_FLAG_PORT, "PF_CONNECT_SERVER_DIALOG_WIDGETS_FLAG_PORT", "port"}, {PF_CONNECT_SERVER_DIALOG_WIDGETS_FLAG_USER, "PF_CONNECT_SERVER_DIALOG_WIDGETS_FLAG_USER", "user"}, {PF_CONNECT_SERVER_DIALOG_WIDGETS_FLAG_DOMAIN, "PF_CONNECT_SERVER_DIALOG_WIDGETS_FLAG_DOMAIN", "domain"}, {PF_CONNECT_SERVER_DIALOG_WIDGETS_FLAG_ANONYMOUS, "PF_CONNECT_SERVER_DIALOG_WIDGETS_FLAG_ANONYMOUS", "anonymous"}, {0, NULL, NULL}};
	GType pf_connect_server_dialog_widgets_flag_type_id;
	pf_connect_server_dialog_widgets_flag_type_id = g_flags_register_static ("PFConnectServerDialogWidgetsFlag", values);
	return pf_connect_server_dialog_widgets_flag_type_id;
}

static GType
pf_connect_server_dialog_widgets_flag_get_type (void)
{
	static volatile gsize pf_connect_server_dialog_widgets_flag_type_id__once = 0;
	if (g_once_init_enter (&pf_connect_server_dialog_widgets_flag_type_id__once)) {
		GType pf_connect_server_dialog_widgets_flag_type_id;
		pf_connect_server_dialog_widgets_flag_type_id = pf_connect_server_dialog_widgets_flag_get_type_once ();
		g_once_init_leave (&pf_connect_server_dialog_widgets_flag_type_id__once, pf_connect_server_dialog_widgets_flag_type_id);
	}
	return pf_connect_server_dialog_widgets_flag_type_id__once;
}

static void
_vala_PFConnectServerDialogMethodInfo_array_free (PFConnectServerDialogMethodInfo * array,
                                                  gssize array_length)
{
	if (array != NULL) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			pf_connect_server_dialog_method_info_destroy (&array[i]);
		}
	}
	g_free (array);
}

PFConnectServerDialog*
pf_connect_server_dialog_construct (GType object_type,
                                    GtkWindow* window)
{
	PFConnectServerDialog * self = NULL;
	g_return_val_if_fail (window != NULL, NULL);
	self = (PFConnectServerDialog*) g_object_new (object_type, "transient-for", window, NULL);
	return self;
}

PFConnectServerDialog*
pf_connect_server_dialog_new (GtkWindow* window)
{
	return pf_connect_server_dialog_construct (PF_TYPE_CONNECT_SERVER_DIALOG, window);
}

static void
pf_connect_server_dialog_set_button_sensitivity (PFConnectServerDialog* self)
{
	gboolean valid = FALSE;
	GtkButton* _tmp0_;
	GtkButton* _tmp1_;
	g_return_if_fail (self != NULL);
	valid = pf_connect_server_dialog_valid_entries (self);
	_tmp0_ = self->priv->connect_button;
	_tmp1_ = self->priv->continue_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp1_, valid);
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, valid);
}

static void
pf_connect_server_dialog_type_changed (PFConnectServerDialog* self)
{
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_;
	GValue val = {0};
	GtkComboBox* _tmp3_;
	GtkTreeModel* _tmp4_;
	GtkTreeIter _tmp5_;
	GValue _tmp6_ = {0};
	PFConnectServerDialogMethodInfo* method_info = NULL;
	void* _tmp7_;
	GtkRevealer* _tmp8_;
	PFConnectServerDialogMethodInfo* _tmp9_;
	GtkSpinButton* _tmp10_;
	PFConnectServerDialogMethodInfo* _tmp11_;
	GtkEntry* _tmp12_;
	PFConnectServerDialogMethodInfo* _tmp13_;
	gboolean _tmp14_ = FALSE;
	PFConnectServerDialogMethodInfo* _tmp15_;
	GraniteHeaderLabel* _tmp17_;
	GraniteValidatedEntry* _tmp18_;
	PFConnectServerDialogMethodInfo* _tmp19_;
	GraniteValidatedEntry* _tmp20_;
	PFConnectServerDialogMethodInfo* _tmp21_;
	GraniteValidatedEntry* _tmp22_;
	PFConnectServerDialogMethodInfo* _tmp23_;
	GraniteValidatedEntry* _tmp24_;
	GraniteValidatedEntry* _tmp25_;
	gboolean _tmp26_;
	gboolean _tmp27_;
	gboolean _tmp28_ = FALSE;
	GraniteValidatedEntry* _tmp29_;
	gboolean _tmp30_;
	gboolean _tmp31_;
	GraniteValidatedEntry* _tmp35_;
	GraniteValidatedEntry* _tmp36_;
	GraniteValidatedEntry* _tmp37_;
	gboolean _tmp38_;
	gboolean _tmp39_;
	GtkEntry* _tmp40_;
	GraniteValidatedEntry* _tmp41_;
	gboolean _tmp42_;
	gboolean _tmp43_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->type_combobox;
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	if (!_tmp2_) {
		g_critical ("ConnectServerDialog.vala:337: Error with GVFS");
	}
	_tmp3_ = self->priv->type_combobox;
	_tmp4_ = gtk_combo_box_get_model (_tmp3_);
	_tmp5_ = iter;
	gtk_tree_model_get_value (_tmp4_, &_tmp5_, 0, &_tmp6_);
	G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
	val = _tmp6_;
	_tmp7_ = g_value_get_boxed (&val);
	method_info = (PFConnectServerDialogMethodInfo*) _tmp7_;
	_tmp8_ = self->priv->port_revealer;
	_tmp9_ = method_info;
	gtk_revealer_set_reveal_child (_tmp8_, ((*_tmp9_).flags & PF_CONNECT_SERVER_DIALOG_WIDGETS_FLAG_PORT) == PF_CONNECT_SERVER_DIALOG_WIDGETS_FLAG_PORT);
	_tmp10_ = self->priv->port_spinbutton;
	_tmp11_ = method_info;
	gtk_spin_button_set_value (_tmp10_, (gdouble) (*_tmp11_).port);
	_tmp12_ = self->priv->share_entry;
	_tmp13_ = method_info;
	gtk_widget_set_visible ((GtkWidget*) _tmp12_, ((*_tmp13_).flags & PF_CONNECT_SERVER_DIALOG_WIDGETS_FLAG_SHARE) == PF_CONNECT_SERVER_DIALOG_WIDGETS_FLAG_SHARE);
	_tmp15_ = method_info;
	if (((*_tmp15_).flags & PF_CONNECT_SERVER_DIALOG_WIDGETS_FLAG_USER) == PF_CONNECT_SERVER_DIALOG_WIDGETS_FLAG_USER) {
		_tmp14_ = TRUE;
	} else {
		PFConnectServerDialogMethodInfo* _tmp16_;
		_tmp16_ = method_info;
		_tmp14_ = ((*_tmp16_).flags & PF_CONNECT_SERVER_DIALOG_WIDGETS_FLAG_DOMAIN) == PF_CONNECT_SERVER_DIALOG_WIDGETS_FLAG_DOMAIN;
	}
	_tmp17_ = self->priv->user_header_label;
	gtk_widget_set_visible ((GtkWidget*) _tmp17_, _tmp14_);
	_tmp18_ = self->priv->user_entry;
	_tmp19_ = method_info;
	gtk_widget_set_visible ((GtkWidget*) _tmp18_, ((*_tmp19_).flags & PF_CONNECT_SERVER_DIALOG_WIDGETS_FLAG_USER) == PF_CONNECT_SERVER_DIALOG_WIDGETS_FLAG_USER);
	_tmp20_ = self->priv->password_entry;
	_tmp21_ = method_info;
	gtk_widget_set_visible ((GtkWidget*) _tmp20_, ((*_tmp21_).flags & PF_CONNECT_SERVER_DIALOG_WIDGETS_FLAG_USER) == PF_CONNECT_SERVER_DIALOG_WIDGETS_FLAG_USER);
	_tmp22_ = self->priv->domain_entry;
	_tmp23_ = method_info;
	gtk_widget_set_visible ((GtkWidget*) _tmp22_, ((*_tmp23_).flags & PF_CONNECT_SERVER_DIALOG_WIDGETS_FLAG_DOMAIN) == PF_CONNECT_SERVER_DIALOG_WIDGETS_FLAG_DOMAIN);
	_tmp24_ = self->priv->password_entry;
	_tmp25_ = self->priv->password_entry;
	_tmp26_ = gtk_widget_get_visible ((GtkWidget*) _tmp25_);
	_tmp27_ = _tmp26_;
	gtk_entry_set_activates_default ((GtkEntry*) _tmp24_, _tmp27_);
	_tmp29_ = self->priv->user_entry;
	_tmp30_ = gtk_widget_get_visible ((GtkWidget*) _tmp29_);
	_tmp31_ = _tmp30_;
	if (_tmp31_) {
		GraniteValidatedEntry* _tmp32_;
		gboolean _tmp33_;
		gboolean _tmp34_;
		_tmp32_ = self->priv->password_entry;
		_tmp33_ = gtk_widget_get_visible ((GtkWidget*) _tmp32_);
		_tmp34_ = _tmp33_;
		_tmp28_ = !_tmp34_;
	} else {
		_tmp28_ = FALSE;
	}
	_tmp35_ = self->priv->user_entry;
	gtk_entry_set_activates_default ((GtkEntry*) _tmp35_, _tmp28_);
	_tmp36_ = self->priv->server_entry;
	_tmp37_ = self->priv->user_entry;
	_tmp38_ = gtk_widget_get_visible ((GtkWidget*) _tmp37_);
	_tmp39_ = _tmp38_;
	gtk_entry_set_activates_default ((GtkEntry*) _tmp36_, !_tmp39_);
	_tmp40_ = self->priv->share_entry;
	_tmp41_ = self->priv->server_entry;
	_tmp42_ = gtk_entry_get_activates_default ((GtkEntry*) _tmp41_);
	_tmp43_ = _tmp42_;
	gtk_entry_set_activates_default (_tmp40_, _tmp43_);
	pf_connect_server_dialog_show_connect_button (self);
	pf_connect_server_dialog_dismiss_info (self);
	G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
}

static void
pf_connect_server_dialog_show_connect_button (PFConnectServerDialog* self)
{
	GtkButton* _tmp0_;
	GtkButton* _tmp1_;
	GtkButton* _tmp2_;
	GtkButton* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->connect_button;
	gtk_widget_set_visible ((GtkWidget*) _tmp0_, TRUE);
	_tmp1_ = self->priv->continue_button;
	gtk_widget_set_visible ((GtkWidget*) _tmp1_, FALSE);
	_tmp2_ = self->priv->connect_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp2_, pf_connect_server_dialog_valid_entries (self));
	_tmp3_ = self->priv->connect_button;
	gtk_widget_grab_default ((GtkWidget*) _tmp3_);
}

static gpointer
_g_main_loop_ref0 (gpointer self)
{
	return self ? g_main_loop_ref (self) : NULL;
}

static void
pf_connect_server_dialog_verify_details (PFConnectServerDialog* self)
{
	GMainLoop* loop = NULL;
	GMainLoop* _tmp0_;
	GtkButton* _tmp1_;
	GMainLoop* _tmp2_;
	GtkComboBox* _tmp3_;
	GtkInfoBar* _tmp4_;
	GtkLabel* _tmp5_;
	GtkButton* _tmp6_;
	GtkButton* _tmp7_;
	GtkButton* _tmp8_;
	GtkButton* _tmp9_;
	GtkButton* _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_main_loop_new (NULL, FALSE);
	loop = _tmp0_;
	_tmp1_ = self->priv->continue_button;
	_tmp2_ = _g_main_loop_ref0 (loop);
	g_object_set_data_full ((GObject*) _tmp1_, "loop", _tmp2_, g_main_loop_unref);
	_tmp3_ = self->priv->type_combobox;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp3_, FALSE);
	_tmp4_ = self->priv->info_bar;
	gtk_info_bar_set_message_type (_tmp4_, GTK_MESSAGE_WARNING);
	_tmp5_ = self->priv->info_label;
	gtk_label_set_label (_tmp5_, _ ("Please verify your user details."));
	_tmp6_ = self->priv->connect_button;
	gtk_widget_set_visible ((GtkWidget*) _tmp6_, FALSE);
	_tmp7_ = self->priv->continue_button;
	gtk_widget_set_visible ((GtkWidget*) _tmp7_, TRUE);
	_tmp8_ = self->priv->continue_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp8_, FALSE);
	_tmp9_ = self->priv->continue_button;
	gtk_widget_grab_default ((GtkWidget*) _tmp9_);
	pf_connect_server_dialog_show_info (self);
	g_main_loop_run (loop);
	_tmp10_ = self->priv->continue_button;
	g_object_set_data_full ((GObject*) _tmp10_, "loop", NULL, NULL);
	pf_connect_server_dialog_show_connect_button (self);
	_g_main_loop_unref0 (loop);
}

static void
pf_connect_server_dialog_show_info (PFConnectServerDialog* self)
{
	GtkStack* _tmp0_;
	GtkInfoBar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->stack;
	gtk_stack_set_visible_child_name (_tmp0_, "content");
	_tmp1_ = self->priv->info_bar;
	gtk_info_bar_set_revealed (_tmp1_, TRUE);
}

static void
pf_connect_server_dialog_dismiss_info (PFConnectServerDialog* self)
{
	GtkLabel* _tmp0_;
	GtkInfoBar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->info_label;
	gtk_label_set_label (_tmp0_, "");
	_tmp1_ = self->priv->info_bar;
	gtk_info_bar_set_revealed (_tmp1_, FALSE);
}

static gboolean
pf_connect_server_dialog_valid_entries (PFConnectServerDialog* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	GraniteValidatedEntry* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gboolean valid = FALSE;
	gboolean _tmp27_ = FALSE;
	GtkInfoBar* _tmp33_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp3_ = self->priv->server_entry;
	_tmp4_ = granite_validated_entry_get_is_valid (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_) {
		gboolean _tmp6_ = FALSE;
		GraniteValidatedEntry* _tmp7_;
		gboolean _tmp8_;
		gboolean _tmp9_;
		_tmp7_ = self->priv->user_entry;
		_tmp8_ = granite_validated_entry_get_is_valid (_tmp7_);
		_tmp9_ = _tmp8_;
		if (_tmp9_) {
			_tmp6_ = TRUE;
		} else {
			GraniteValidatedEntry* _tmp10_;
			gboolean _tmp11_;
			gboolean _tmp12_;
			_tmp10_ = self->priv->user_entry;
			_tmp11_ = gtk_widget_get_visible ((GtkWidget*) _tmp10_);
			_tmp12_ = _tmp11_;
			_tmp6_ = !_tmp12_;
		}
		_tmp2_ = _tmp6_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gboolean _tmp13_ = FALSE;
		GraniteValidatedEntry* _tmp14_;
		gboolean _tmp15_;
		gboolean _tmp16_;
		_tmp14_ = self->priv->domain_entry;
		_tmp15_ = granite_validated_entry_get_is_valid (_tmp14_);
		_tmp16_ = _tmp15_;
		if (_tmp16_) {
			_tmp13_ = TRUE;
		} else {
			GraniteValidatedEntry* _tmp17_;
			gboolean _tmp18_;
			gboolean _tmp19_;
			_tmp17_ = self->priv->domain_entry;
			_tmp18_ = gtk_widget_get_visible ((GtkWidget*) _tmp17_);
			_tmp19_ = _tmp18_;
			_tmp13_ = !_tmp19_;
		}
		_tmp1_ = _tmp13_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gboolean _tmp20_ = FALSE;
		GraniteValidatedEntry* _tmp21_;
		gboolean _tmp22_;
		gboolean _tmp23_;
		_tmp21_ = self->priv->password_entry;
		_tmp22_ = granite_validated_entry_get_is_valid (_tmp21_);
		_tmp23_ = _tmp22_;
		if (_tmp23_) {
			_tmp20_ = TRUE;
		} else {
			GraniteValidatedEntry* _tmp24_;
			gboolean _tmp25_;
			gboolean _tmp26_;
			_tmp24_ = self->priv->password_entry;
			_tmp25_ = gtk_widget_get_visible ((GtkWidget*) _tmp24_);
			_tmp26_ = _tmp25_;
			_tmp20_ = !_tmp26_;
		}
		_tmp0_ = _tmp20_;
	} else {
		_tmp0_ = FALSE;
	}
	valid = _tmp0_;
	if (!valid) {
		_tmp27_ = TRUE;
	} else {
		GtkLabel* _tmp28_;
		const gchar* _tmp29_;
		const gchar* _tmp30_;
		gint _tmp31_;
		gint _tmp32_;
		_tmp28_ = self->priv->info_label;
		_tmp29_ = gtk_label_get_label (_tmp28_);
		_tmp30_ = _tmp29_;
		_tmp31_ = strlen (_tmp30_);
		_tmp32_ = _tmp31_;
		_tmp27_ = _tmp32_ > 0;
	}
	_tmp33_ = self->priv->info_bar;
	gtk_info_bar_set_revealed (_tmp33_, _tmp27_);
	result = valid;
	return result;
}

static void
pf_connect_server_dialog_connect_to_server_data_free (gpointer _data)
{
	PfConnectServerDialogConnectToServerData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (PfConnectServerDialogConnectToServerData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
pf_connect_server_dialog_connect_to_server (PFConnectServerDialog* self,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_)
{
	PfConnectServerDialogConnectToServerData* _data_;
	PFConnectServerDialog* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (PfConnectServerDialogConnectToServerData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, pf_connect_server_dialog_connect_to_server_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	pf_connect_server_dialog_connect_to_server_co (_data_);
}

static void
pf_connect_server_dialog_connect_to_server_finish (PFConnectServerDialog* self,
                                                   GAsyncResult* _res_)
{
	PfConnectServerDialogConnectToServerData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
pf_connect_server_dialog_connect_to_server_ready (GObject* source_object,
                                                  GAsyncResult* _res_,
                                                  gpointer _user_data_)
{
	PfConnectServerDialogConnectToServerData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	pf_connect_server_dialog_connect_to_server_co (_data_);
}

static gboolean
pf_connect_server_dialog_connect_to_server_co (PfConnectServerDialogConnectToServerData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->type_combobox;
	memset (&_data_->_tmp1_, 0, sizeof (GtkTreeIter));
	_data_->_tmp2_ = gtk_combo_box_get_active_iter (_data_->_tmp0_, &_data_->_tmp1_);
	_data_->iter = _data_->_tmp1_;
	if (!_data_->_tmp2_) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp3_ = _data_->self->priv->type_combobox;
	_data_->_tmp4_ = gtk_combo_box_get_model (_data_->_tmp3_);
	_data_->_tmp5_ = _data_->iter;
	memset (&_data_->_tmp6_, 0, sizeof (GValue));
	gtk_tree_model_get_value (_data_->_tmp4_, &_data_->_tmp5_, 0, &_data_->_tmp6_);
	G_IS_VALUE (&_data_->val) ? (g_value_unset (&_data_->val), NULL) : NULL;
	_data_->val = _data_->_tmp6_;
	_data_->_tmp7_ = g_value_get_boxed (&_data_->val);
	_data_->method_info = (PFConnectServerDialogMethodInfo*) _data_->_tmp7_;
	_data_->_tmp8_ = _data_->method_info;
	_data_->_tmp9_ = (*_data_->_tmp8_).scheme;
	_data_->_tmp10_ = g_strconcat (_data_->_tmp9_, "://", NULL);
	_data_->scheme = _data_->_tmp10_;
	_data_->_tmp11_ = _data_->self->priv->server_entry;
	_data_->_tmp12_ = gtk_entry_get_text ((GtkEntry*) _data_->_tmp11_);
	_data_->_tmp13_ = _data_->_tmp12_;
	_data_->_tmp14_ = _data_->scheme;
	_data_->_tmp15_ = string_replace (_data_->_tmp13_, _data_->_tmp14_, "");
	_data_->server = _data_->_tmp15_;
	_data_->_tmp16_ = _data_->method_info;
	if (((*_data_->_tmp16_).flags & PF_CONNECT_SERVER_DIALOG_WIDGETS_FLAG_ANONYMOUS) == PF_CONNECT_SERVER_DIALOG_WIDGETS_FLAG_ANONYMOUS) {
		_data_->_tmp17_ = g_strdup ("anonymous");
		_g_free0 (_data_->user);
		_data_->user = _data_->_tmp17_;
	} else {
		_data_->_tmp18_ = _data_->self->priv->user_entry;
		_data_->_tmp19_ = gtk_entry_get_text ((GtkEntry*) _data_->_tmp18_);
		_data_->_tmp20_ = _data_->_tmp19_;
		_data_->_tmp21_ = g_strdup (_data_->_tmp20_);
		_g_free0 (_data_->user);
		_data_->user = _data_->_tmp21_;
	}
	_data_->_tmp22_ = _data_->method_info;
	if (((*_data_->_tmp22_).flags & PF_CONNECT_SERVER_DIALOG_WIDGETS_FLAG_DOMAIN) == PF_CONNECT_SERVER_DIALOG_WIDGETS_FLAG_DOMAIN) {
		_data_->_tmp23_ = _data_->self->priv->domain_entry;
		_data_->_tmp24_ = gtk_entry_get_text ((GtkEntry*) _data_->_tmp23_);
		_data_->_tmp25_ = _data_->_tmp24_;
		_data_->_tmp26_ = _data_->user;
		_data_->_tmp27_ = g_strjoin (";", _data_->_tmp25_, _data_->_tmp26_, NULL);
		_g_free0 (_data_->user);
		_data_->user = _data_->_tmp27_;
	}
	_data_->_tmp28_ = _data_->method_info;
	if (((*_data_->_tmp28_).flags & PF_CONNECT_SERVER_DIALOG_WIDGETS_FLAG_SHARE) == PF_CONNECT_SERVER_DIALOG_WIDGETS_FLAG_SHARE) {
		_data_->_tmp29_ = _data_->self->priv->share_entry;
		_data_->_tmp30_ = gtk_entry_get_text (_data_->_tmp29_);
		_data_->_tmp31_ = _data_->_tmp30_;
		_data_->_tmp32_ = g_build_filename ("/", _data_->_tmp31_, NULL);
		_g_free0 (_data_->initial_path);
		_data_->initial_path = _data_->_tmp32_;
	} else {
		_data_->_tmp33_ = g_strdup ("");
		_g_free0 (_data_->initial_path);
		_data_->initial_path = _data_->_tmp33_;
	}
	_data_->_tmp34_ = _data_->initial_path;
	_data_->_tmp35_ = _data_->self->priv->folder_entry;
	_data_->_tmp36_ = gtk_entry_get_text (_data_->_tmp35_);
	_data_->_tmp37_ = _data_->_tmp36_;
	_data_->_tmp38_ = g_build_filename (_data_->_tmp34_, _data_->_tmp37_, NULL);
	_data_->folder = _data_->_tmp38_;
	_data_->_tmp39_ = _data_->folder;
	_data_->_tmp40_ = g_uri_escape_string (_data_->_tmp39_, G_URI_RESERVED_CHARS_ALLOWED_IN_PATH, FALSE);
	_g_free0 (_data_->folder);
	_data_->folder = _data_->_tmp40_;
	_data_->_tmp41_ = _data_->scheme;
	_data_->_tmp42_ = g_strdup (_data_->_tmp41_);
	_data_->uri = _data_->_tmp42_;
	_data_->_tmp43_ = _data_->user;
	if (g_strcmp0 (_data_->_tmp43_, "") != 0) {
		_data_->_tmp44_ = _data_->uri;
		_data_->_tmp45_ = _data_->user;
		_data_->_tmp46_ = g_strconcat (_data_->_tmp45_, "@", NULL);
		_data_->_tmp47_ = _data_->_tmp46_;
		_data_->_tmp48_ = g_strconcat (_data_->_tmp44_, _data_->_tmp47_, NULL);
		_g_free0 (_data_->uri);
		_data_->uri = _data_->_tmp48_;
		_g_free0 (_data_->_tmp47_);
	}
	_data_->_tmp49_ = _data_->uri;
	_data_->_tmp50_ = _data_->server;
	_data_->_tmp51_ = g_strconcat (_data_->_tmp49_, _data_->_tmp50_, NULL);
	_g_free0 (_data_->uri);
	_data_->uri = _data_->_tmp51_;
	_data_->_tmp52_ = _data_->self->priv->port_spinbutton;
	_data_->_tmp53_ = gtk_spin_button_get_value (_data_->_tmp52_);
	_data_->_tmp54_ = _data_->_tmp53_;
	if (_data_->_tmp54_ > ((gdouble) 0)) {
		_data_->_tmp55_ = _data_->uri;
		_data_->_tmp56_ = _data_->self->priv->port_spinbutton;
		_data_->_tmp57_ = gtk_spin_button_get_value (_data_->_tmp56_);
		_data_->_tmp58_ = _data_->_tmp57_;
		_data_->_tmp59_ = g_strdup_printf (":%u", (guint) _data_->_tmp58_);
		_data_->_tmp60_ = _data_->_tmp59_;
		_data_->_tmp61_ = g_strconcat (_data_->_tmp55_, _data_->_tmp60_, NULL);
		_g_free0 (_data_->uri);
		_data_->uri = _data_->_tmp61_;
		_g_free0 (_data_->_tmp60_);
	}
	_data_->_tmp62_ = _data_->uri;
	_data_->_tmp63_ = _data_->folder;
	_data_->_tmp64_ = g_strconcat (_data_->_tmp62_, _data_->_tmp63_, NULL);
	_g_free0 (_data_->uri);
	_data_->uri = _data_->_tmp64_;
	_data_->_tmp65_ = _data_->uri;
	_data_->_tmp66_ = g_file_new_for_uri (_data_->_tmp65_);
	_data_->location = _data_->_tmp66_;
	_data_->_tmp67_ = files_connect_server_operation_new (_data_->self);
	_data_->operation = _data_->_tmp67_;
	_data_->_tmp68_ = g_cancellable_new ();
	_g_object_unref0 (_data_->self->priv->mount_cancellable);
	_data_->self->priv->mount_cancellable = _data_->_tmp68_;
	{
		_data_->_tmp69_ = _data_->uri;
		pf_connect_server_dialog_set_server_uri (_data_->self, _data_->_tmp69_);
		_data_->_tmp70_ = _data_->location;
		_data_->_tmp71_ = _data_->operation;
		_data_->_tmp72_ = _data_->self->priv->mount_cancellable;
		_data_->_state_ = 1;
		g_file_mount_enclosing_volume (_data_->_tmp70_, G_MOUNT_MOUNT_NONE, (GMountOperation*) _data_->_tmp71_, _data_->_tmp72_, pf_connect_server_dialog_connect_to_server_ready, _data_);
		return FALSE;
		_state_1:
		g_file_mount_enclosing_volume_finish (_data_->_tmp70_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			if (g_error_matches (_data_->_inner_error0_, G_IO_ERROR, G_IO_ERROR_ALREADY_MOUNTED)) {
				goto __catch0_g_io_error_already_mounted;
			}
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_io_error_already_mounted:
	{
		g_clear_error (&_data_->_inner_error0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp73_ = _data_->self->priv->info_bar;
		gtk_info_bar_set_message_type (_data_->_tmp73_, GTK_MESSAGE_ERROR);
		_data_->_tmp74_ = _data_->self->priv->info_label;
		_data_->_tmp75_ = _data_->e;
		_data_->_tmp76_ = _data_->_tmp75_->message;
		gtk_label_set_label (_data_->_tmp74_, _data_->_tmp76_);
		pf_connect_server_dialog_show_info (_data_->self);
		pf_connect_server_dialog_show_connect_button (_data_->self);
		_g_error_free0 (_data_->e);
		{
			_g_object_unref0 (_data_->self->priv->mount_cancellable);
			_data_->self->priv->mount_cancellable = NULL;
		}
		_g_object_unref0 (_data_->operation);
		_g_object_unref0 (_data_->location);
		_g_free0 (_data_->uri);
		_g_free0 (_data_->folder);
		_g_free0 (_data_->initial_path);
		_g_free0 (_data_->user);
		_g_free0 (_data_->server);
		_g_free0 (_data_->scheme);
		G_IS_VALUE (&_data_->val) ? (g_value_unset (&_data_->val), NULL) : NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally0:
	{
		_g_object_unref0 (_data_->self->priv->mount_cancellable);
		_data_->self->priv->mount_cancellable = NULL;
	}
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->operation);
		_g_object_unref0 (_data_->location);
		_g_free0 (_data_->uri);
		_g_free0 (_data_->folder);
		_g_free0 (_data_->initial_path);
		_g_free0 (_data_->user);
		_g_free0 (_data_->server);
		_g_free0 (_data_->scheme);
		G_IS_VALUE (&_data_->val) ? (g_value_unset (&_data_->val), NULL) : NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	gtk_dialog_response ((GtkDialog*) _data_->self, (gint) GTK_RESPONSE_OK);
	_g_object_unref0 (_data_->operation);
	_g_object_unref0 (_data_->location);
	_g_free0 (_data_->uri);
	_g_free0 (_data_->folder);
	_g_free0 (_data_->initial_path);
	_g_free0 (_data_->user);
	_g_free0 (_data_->server);
	_g_free0 (_data_->scheme);
	G_IS_VALUE (&_data_->val) ? (g_value_unset (&_data_->val), NULL) : NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
pf_connect_server_dialog_fill_details_async_data_free (gpointer _data)
{
	PfConnectServerDialogFillDetailsAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->mount_operation);
	_g_free0 (_data_->default_user);
	_g_free0 (_data_->default_domain);
	_g_object_unref0 (_data_->self);
	g_slice_free (PfConnectServerDialogFillDetailsAsyncData, _data_);
}

void
pf_connect_server_dialog_fill_details_async (PFConnectServerDialog* self,
                                             GMountOperation* mount_operation,
                                             const gchar* default_user,
                                             const gchar* default_domain,
                                             GAskPasswordFlags askpassword_flags,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_)
{
	PfConnectServerDialogFillDetailsAsyncData* _data_;
	PFConnectServerDialog* _tmp0_;
	GMountOperation* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (mount_operation != NULL);
	g_return_if_fail (default_user != NULL);
	g_return_if_fail (default_domain != NULL);
	_data_ = g_slice_new0 (PfConnectServerDialogFillDetailsAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, pf_connect_server_dialog_fill_details_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (mount_operation);
	_g_object_unref0 (_data_->mount_operation);
	_data_->mount_operation = _tmp1_;
	_tmp2_ = g_strdup (default_user);
	_g_free0 (_data_->default_user);
	_data_->default_user = _tmp2_;
	_tmp3_ = g_strdup (default_domain);
	_g_free0 (_data_->default_domain);
	_data_->default_domain = _tmp3_;
	_data_->askpassword_flags = askpassword_flags;
	pf_connect_server_dialog_fill_details_async_co (_data_);
}

gboolean
pf_connect_server_dialog_fill_details_finish (PFConnectServerDialog* self,
                                              GAsyncResult* _res_)
{
	gboolean result;
	PfConnectServerDialogFillDetailsAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	return result;
}

static gboolean
pf_connect_server_dialog_fill_details_async_co (PfConnectServerDialogFillDetailsAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->set_flags = _data_->askpassword_flags;
	if ((_data_->askpassword_flags & G_ASK_PASSWORD_NEED_PASSWORD) == G_ASK_PASSWORD_NEED_PASSWORD) {
		_data_->_tmp0_ = _data_->self->priv->password_entry;
		_data_->_tmp1_ = gtk_entry_get_text ((GtkEntry*) _data_->_tmp0_);
		_data_->_tmp2_ = _data_->_tmp1_;
		_data_->_tmp3_ = g_strdup (_data_->_tmp2_);
		_data_->password = _data_->_tmp3_;
		_data_->_tmp5_ = _data_->password;
		if (_data_->_tmp5_ != NULL) {
			_data_->_tmp6_ = _data_->password;
			_data_->_tmp4_ = g_strcmp0 (_data_->_tmp6_, "") != 0;
		} else {
			_data_->_tmp4_ = FALSE;
		}
		if (_data_->_tmp4_) {
			_data_->_tmp7_ = _data_->password;
			g_mount_operation_set_password (_data_->mount_operation, _data_->_tmp7_);
			_data_->set_flags ^= G_ASK_PASSWORD_NEED_PASSWORD;
		} else {
			_data_->self->priv->needs_password = TRUE;
		}
		_g_free0 (_data_->password);
	}
	if ((_data_->askpassword_flags & G_ASK_PASSWORD_NEED_USERNAME) == G_ASK_PASSWORD_NEED_USERNAME) {
		_data_->_tmp8_ = _data_->self->priv->user_entry;
		_data_->_tmp9_ = gtk_entry_get_text ((GtkEntry*) _data_->_tmp8_);
		_data_->_tmp10_ = _data_->_tmp9_;
		_data_->_tmp11_ = g_strdup (_data_->_tmp10_);
		_data_->username = _data_->_tmp11_;
		_data_->_tmp13_ = _data_->username;
		if (_data_->_tmp13_ != NULL) {
			_data_->_tmp14_ = _data_->username;
			_data_->_tmp12_ = g_strcmp0 (_data_->_tmp14_, "") != 0;
		} else {
			_data_->_tmp12_ = FALSE;
		}
		if (_data_->_tmp12_) {
			_data_->_tmp15_ = _data_->username;
			g_mount_operation_set_username (_data_->mount_operation, _data_->_tmp15_);
			_data_->set_flags ^= G_ASK_PASSWORD_NEED_USERNAME;
		}
		_g_free0 (_data_->username);
	}
	if ((_data_->askpassword_flags & G_ASK_PASSWORD_NEED_DOMAIN) == G_ASK_PASSWORD_NEED_DOMAIN) {
		_data_->_tmp16_ = _data_->self->priv->domain_entry;
		_data_->_tmp17_ = gtk_entry_get_text ((GtkEntry*) _data_->_tmp16_);
		_data_->_tmp18_ = _data_->_tmp17_;
		_data_->_tmp19_ = g_strdup (_data_->_tmp18_);
		_data_->domain = _data_->_tmp19_;
		_data_->_tmp21_ = _data_->domain;
		if (_data_->_tmp21_ != NULL) {
			_data_->_tmp22_ = _data_->domain;
			_data_->_tmp20_ = g_strcmp0 (_data_->_tmp22_, "") != 0;
		} else {
			_data_->_tmp20_ = FALSE;
		}
		if (_data_->_tmp20_) {
			_data_->_tmp23_ = _data_->domain;
			g_mount_operation_set_domain (_data_->mount_operation, _data_->_tmp23_);
			_data_->set_flags ^= G_ASK_PASSWORD_NEED_DOMAIN;
		}
		_g_free0 (_data_->domain);
	}
	_data_->need_mask = (G_ASK_PASSWORD_NEED_PASSWORD | G_ASK_PASSWORD_NEED_USERNAME) | G_ASK_PASSWORD_NEED_DOMAIN;
	if ((_data_->set_flags & _data_->need_mask) == 0) {
		_data_->result = TRUE;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	if ((_data_->askpassword_flags & G_ASK_PASSWORD_NEED_PASSWORD) == G_ASK_PASSWORD_NEED_PASSWORD) {
		_data_->_tmp24_ = _data_->self->priv->password_entry;
		granite_validated_entry_set_is_valid (_data_->_tmp24_, FALSE);
	}
	if ((_data_->askpassword_flags & G_ASK_PASSWORD_NEED_USERNAME) == G_ASK_PASSWORD_NEED_USERNAME) {
		if (_data_->default_user != NULL) {
			_data_->_tmp25_ = g_strcmp0 (_data_->default_user, "") != 0;
		} else {
			_data_->_tmp25_ = FALSE;
		}
		if (_data_->_tmp25_) {
			_data_->_tmp26_ = _data_->self->priv->user_entry;
			gtk_entry_set_text ((GtkEntry*) _data_->_tmp26_, _data_->default_user);
		} else {
			_data_->_tmp27_ = _data_->self->priv->user_entry;
			granite_validated_entry_set_is_valid (_data_->_tmp27_, FALSE);
		}
	}
	if ((_data_->askpassword_flags & G_ASK_PASSWORD_NEED_DOMAIN) == G_ASK_PASSWORD_NEED_DOMAIN) {
		if (_data_->default_domain != NULL) {
			_data_->_tmp28_ = g_strcmp0 (_data_->default_domain, "") != 0;
		} else {
			_data_->_tmp28_ = FALSE;
		}
		if (_data_->_tmp28_) {
			_data_->_tmp29_ = _data_->self->priv->domain_entry;
			gtk_entry_set_text ((GtkEntry*) _data_->_tmp29_, _data_->default_domain);
		} else {
			_data_->_tmp30_ = _data_->self->priv->domain_entry;
			granite_validated_entry_set_is_valid (_data_->_tmp30_, FALSE);
		}
	}
	if (!((_data_->askpassword_flags & G_ASK_PASSWORD_SAVING_SUPPORTED) == G_ASK_PASSWORD_SAVING_SUPPORTED)) {
		_data_->_tmp31_ = _data_->self->priv->remember_checkbutton;
		gtk_widget_set_sensitive ((GtkWidget*) _data_->_tmp31_, FALSE);
		_data_->_tmp32_ = _data_->self->priv->remember_checkbutton;
		gtk_toggle_button_set_active ((GtkToggleButton*) _data_->_tmp32_, FALSE);
	}
	pf_connect_server_dialog_verify_details (_data_->self);
	_data_->_tmp33_ = _data_->self->priv->mount_cancellable;
	if (g_cancellable_is_cancelled (_data_->_tmp33_)) {
		_data_->result = FALSE;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		if ((_data_->askpassword_flags & G_ASK_PASSWORD_NEED_PASSWORD) == G_ASK_PASSWORD_NEED_PASSWORD) {
			_data_->_tmp34_ = _data_->self->priv->password_entry;
			_data_->_tmp35_ = gtk_entry_get_text ((GtkEntry*) _data_->_tmp34_);
			_data_->_tmp36_ = _data_->_tmp35_;
			g_mount_operation_set_password (_data_->mount_operation, _data_->_tmp36_);
		}
		if ((_data_->askpassword_flags & G_ASK_PASSWORD_NEED_USERNAME) == G_ASK_PASSWORD_NEED_USERNAME) {
			_data_->_tmp37_ = _data_->self->priv->user_entry;
			_data_->_tmp38_ = gtk_entry_get_text ((GtkEntry*) _data_->_tmp37_);
			_data_->_tmp39_ = _data_->_tmp38_;
			g_mount_operation_set_username (_data_->mount_operation, _data_->_tmp39_);
		}
		if ((_data_->askpassword_flags & G_ASK_PASSWORD_NEED_DOMAIN) == G_ASK_PASSWORD_NEED_DOMAIN) {
			_data_->_tmp40_ = _data_->self->priv->domain_entry;
			_data_->_tmp41_ = gtk_entry_get_text ((GtkEntry*) _data_->_tmp40_);
			_data_->_tmp42_ = _data_->_tmp41_;
			g_mount_operation_set_domain (_data_->mount_operation, _data_->_tmp42_);
		}
		if ((_data_->askpassword_flags & G_ASK_PASSWORD_SAVING_SUPPORTED) == G_ASK_PASSWORD_SAVING_SUPPORTED) {
			_data_->_tmp44_ = _data_->self->priv->password_entry;
			_data_->_tmp45_ = gtk_entry_get_text ((GtkEntry*) _data_->_tmp44_);
			_data_->_tmp46_ = _data_->_tmp45_;
			if (g_strcmp0 (_data_->_tmp46_, "") != 0) {
				_data_->_tmp47_ = _data_->self->priv->remember_checkbutton;
				_data_->_tmp48_ = gtk_toggle_button_get_active ((GtkToggleButton*) _data_->_tmp47_);
				_data_->_tmp49_ = _data_->_tmp48_;
				_data_->_tmp43_ = _data_->_tmp49_;
			} else {
				_data_->_tmp43_ = FALSE;
			}
			_data_->should_save = _data_->_tmp43_;
			if (_data_->should_save) {
				_data_->_tmp50_ = G_PASSWORD_SAVE_PERMANENTLY;
			} else {
				_data_->_tmp50_ = G_PASSWORD_SAVE_NEVER;
			}
			g_mount_operation_set_password_save (_data_->mount_operation, _data_->_tmp50_);
		}
		_data_->_tmp51_ = _data_->self->priv->connect_button;
		gtk_button_clicked (_data_->_tmp51_);
		_data_->result = TRUE;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
}

static void
pf_connect_server_dialog_on_connect_clicked (PFConnectServerDialog* self)
{
	GtkStack* _tmp0_;
	GtkButton* _tmp1_;
	GtkButton* _tmp2_;
	g_return_if_fail (self != NULL);
	pf_connect_server_dialog_dismiss_info (self);
	_tmp0_ = self->priv->stack;
	gtk_stack_set_visible_child_name (_tmp0_, "connecting");
	_tmp1_ = self->priv->connect_button;
	gtk_widget_set_visible ((GtkWidget*) _tmp1_, FALSE);
	_tmp2_ = self->priv->continue_button;
	gtk_widget_set_visible ((GtkWidget*) _tmp2_, FALSE);
	self->priv->needs_password = FALSE;
	pf_connect_server_dialog_connect_to_server (self, NULL, NULL);
}

static void
pf_connect_server_dialog_on_cancel_clicked (PFConnectServerDialog* self)
{
	void* loop = NULL;
	GtkButton* _tmp0_;
	gconstpointer _tmp1_;
	void* _tmp2_;
	gboolean _tmp5_ = FALSE;
	GCancellable* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->continue_button;
	_tmp1_ = g_object_get_data ((GObject*) _tmp0_, "loop");
	loop = _tmp1_;
	_tmp2_ = loop;
	if (_tmp2_ != NULL) {
		GtkComboBox* _tmp3_;
		void* _tmp4_;
		_tmp3_ = self->priv->type_combobox;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp3_, TRUE);
		_tmp4_ = loop;
		g_main_loop_quit ((GMainLoop*) _tmp4_);
	}
	_tmp6_ = self->priv->mount_cancellable;
	if (_tmp6_ != NULL) {
		GCancellable* _tmp7_;
		_tmp7_ = self->priv->mount_cancellable;
		_tmp5_ = !g_cancellable_is_cancelled (_tmp7_);
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		GCancellable* _tmp8_;
		_tmp8_ = self->priv->mount_cancellable;
		g_cancellable_cancel (_tmp8_);
	} else {
		gtk_dialog_response ((GtkDialog*) self, (gint) GTK_RESPONSE_CANCEL);
	}
}

static void
pf_connect_server_dialog_on_continue_clicked (PFConnectServerDialog* self)
{
	void* loop = NULL;
	GtkButton* _tmp0_;
	gconstpointer _tmp1_;
	void* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->continue_button;
	_tmp1_ = g_object_get_data ((GObject*) _tmp0_, "loop");
	loop = _tmp1_;
	_tmp2_ = loop;
	if (_tmp2_ != NULL) {
		void* _tmp3_;
		_tmp3_ = loop;
		g_main_loop_quit ((GMainLoop*) _tmp3_);
	} else {
		g_critical ("ConnectServerDialog.vala:592: unexpected continue button click without" \
" associated mainloop");
	}
}

static GtkLabel*
pf_connect_server_dialog_new_detailed_label (PFConnectServerDialog* self,
                                             const gchar* label,
                                             GtkWidget* linked_widget)
{
	GtkLabel* _label = NULL;
	GtkLabel* _tmp0_ = NULL;
	GtkLabel* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (label != NULL, NULL);
	g_return_val_if_fail (linked_widget != NULL, NULL);
	_tmp0_ = (GtkLabel*) gtk_label_new (label);
	gtk_label_set_xalign (_tmp0_, (gfloat) 1);
	g_object_ref_sink (_tmp0_);
	_label = _tmp0_;
	g_object_bind_property_with_closures ((GObject*) linked_widget, "visible", (GObject*) _label, "visible", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	result = _label;
	return result;
}

const gchar*
pf_connect_server_dialog_get_server_uri (PFConnectServerDialog* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_server_uri;
	result = _tmp0_;
	return result;
}

static void
pf_connect_server_dialog_set_server_uri (PFConnectServerDialog* self,
                                         const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = pf_connect_server_dialog_get_server_uri (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_server_uri);
		self->priv->_server_uri = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, pf_connect_server_dialog_properties[PF_CONNECT_SERVER_DIALOG_SERVER_URI_PROPERTY]);
	}
}

static void
pf_connect_server_dialog_method_info_copy (const PFConnectServerDialogMethodInfo* self,
                                           PFConnectServerDialogMethodInfo* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = (*self).scheme;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).scheme);
	(*dest).scheme = _tmp1_;
	(*dest).flags = (*self).flags;
	(*dest).port = (*self).port;
	_tmp2_ = (*self).description;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).description);
	(*dest).description = _tmp3_;
}

static void
pf_connect_server_dialog_method_info_destroy (PFConnectServerDialogMethodInfo* self)
{
	_g_free0 ((*self).scheme);
	_g_free0 ((*self).description);
}

static PFConnectServerDialogMethodInfo*
pf_connect_server_dialog_method_info_dup (const PFConnectServerDialogMethodInfo* self)
{
	PFConnectServerDialogMethodInfo* dup;
	dup = g_new0 (PFConnectServerDialogMethodInfo, 1);
	pf_connect_server_dialog_method_info_copy (self, dup);
	return dup;
}

static void
pf_connect_server_dialog_method_info_free (PFConnectServerDialogMethodInfo* self)
{
	pf_connect_server_dialog_method_info_destroy (self);
	g_free (self);
}

 G_GNUC_NO_INLINE static GType
pf_connect_server_dialog_method_info_get_type_once (void)
{
	GType pf_connect_server_dialog_method_info_type_id;
	pf_connect_server_dialog_method_info_type_id = g_boxed_type_register_static ("PFConnectServerDialogMethodInfo", (GBoxedCopyFunc) pf_connect_server_dialog_method_info_dup, (GBoxedFreeFunc) pf_connect_server_dialog_method_info_free);
	return pf_connect_server_dialog_method_info_type_id;
}

static GType
pf_connect_server_dialog_method_info_get_type (void)
{
	static volatile gsize pf_connect_server_dialog_method_info_type_id__once = 0;
	if (g_once_init_enter (&pf_connect_server_dialog_method_info_type_id__once)) {
		GType pf_connect_server_dialog_method_info_type_id;
		pf_connect_server_dialog_method_info_type_id = pf_connect_server_dialog_method_info_get_type_once ();
		g_once_init_leave (&pf_connect_server_dialog_method_info_type_id__once, pf_connect_server_dialog_method_info_type_id);
	}
	return pf_connect_server_dialog_method_info_type_id__once;
}

static void
_pf_connect_server_dialog_on_cancel_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                gpointer self)
{
	pf_connect_server_dialog_on_cancel_clicked ((PFConnectServerDialog*) self);
}

static void
_pf_connect_server_dialog_on_connect_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                 gpointer self)
{
	pf_connect_server_dialog_on_connect_clicked ((PFConnectServerDialog*) self);
}

static void
_pf_connect_server_dialog_on_continue_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                  gpointer self)
{
	pf_connect_server_dialog_on_continue_clicked ((PFConnectServerDialog*) self);
}

static gboolean
_vala_string_array_contains (gchar* * stack,
                             gssize stack_length,
                             const gchar* needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

static void
_pf_connect_server_dialog___lambda25_ (PFConnectServerDialog* self)
{
	pf_connect_server_dialog_type_changed (self);
}

static void
__pf_connect_server_dialog___lambda25__gtk_combo_box_changed (GtkComboBox* _sender,
                                                              gpointer self)
{
	_pf_connect_server_dialog___lambda25_ ((PFConnectServerDialog*) self);
}

static void
_pf_connect_server_dialog___lambda26_ (PFConnectServerDialog* self)
{
	GraniteValidatedEntry* _tmp0_;
	GraniteValidatedEntry* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	_tmp0_ = self->priv->server_entry;
	_tmp1_ = self->priv->server_entry;
	_tmp2_ = gtk_entry_get_text ((GtkEntry*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = strlen (_tmp3_);
	_tmp5_ = _tmp4_;
	granite_validated_entry_set_is_valid (_tmp0_, _tmp5_ > 3);
	pf_connect_server_dialog_set_button_sensitivity (self);
}

static void
__pf_connect_server_dialog___lambda26__gtk_editable_changed (GtkEditable* _sender,
                                                             gpointer self)
{
	_pf_connect_server_dialog___lambda26_ ((PFConnectServerDialog*) self);
}

static void
_pf_connect_server_dialog___lambda27_ (PFConnectServerDialog* self)
{
	GraniteValidatedEntry* _tmp0_;
	GraniteValidatedEntry* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	_tmp0_ = self->priv->user_entry;
	_tmp1_ = self->priv->user_entry;
	_tmp2_ = gtk_entry_get_text ((GtkEntry*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = strlen (_tmp3_);
	_tmp5_ = _tmp4_;
	granite_validated_entry_set_is_valid (_tmp0_, _tmp5_ > 0);
	pf_connect_server_dialog_set_button_sensitivity (self);
}

static void
__pf_connect_server_dialog___lambda27__gtk_editable_changed (GtkEditable* _sender,
                                                             gpointer self)
{
	_pf_connect_server_dialog___lambda27_ ((PFConnectServerDialog*) self);
}

static void
_pf_connect_server_dialog___lambda28_ (PFConnectServerDialog* self)
{
	GraniteValidatedEntry* _tmp0_;
	GraniteValidatedEntry* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	_tmp0_ = self->priv->domain_entry;
	_tmp1_ = self->priv->domain_entry;
	_tmp2_ = gtk_entry_get_text ((GtkEntry*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = strlen (_tmp3_);
	_tmp5_ = _tmp4_;
	granite_validated_entry_set_is_valid (_tmp0_, _tmp5_ > 0);
	pf_connect_server_dialog_set_button_sensitivity (self);
}

static void
__pf_connect_server_dialog___lambda28__gtk_editable_changed (GtkEditable* _sender,
                                                             gpointer self)
{
	_pf_connect_server_dialog___lambda28_ ((PFConnectServerDialog*) self);
}

static void
_pf_connect_server_dialog___lambda29_ (PFConnectServerDialog* self)
{
	gboolean _tmp0_ = FALSE;
	GraniteValidatedEntry* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	GraniteValidatedEntry* _tmp6_;
	GtkRevealer* _tmp7_;
	GraniteValidatedEntry* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	_tmp1_ = self->priv->password_entry;
	_tmp2_ = gtk_entry_get_text ((GtkEntry*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = strlen (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ > 0) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = !self->priv->needs_password;
	}
	_tmp6_ = self->priv->password_entry;
	granite_validated_entry_set_is_valid (_tmp6_, _tmp0_);
	_tmp7_ = self->priv->remember_revealer;
	_tmp8_ = self->priv->password_entry;
	_tmp9_ = gtk_entry_get_text ((GtkEntry*) _tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = strlen (_tmp10_);
	_tmp12_ = _tmp11_;
	gtk_revealer_set_reveal_child (_tmp7_, _tmp12_ > 0);
	pf_connect_server_dialog_set_button_sensitivity (self);
}

static void
__pf_connect_server_dialog___lambda29__gtk_editable_changed (GtkEditable* _sender,
                                                             gpointer self)
{
	_pf_connect_server_dialog___lambda29_ ((PFConnectServerDialog*) self);
}

static GObject *
pf_connect_server_dialog_constructor (GType type,
                                      guint n_construct_properties,
                                      GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PFConnectServerDialog * self;
	GtkLabel* _tmp0_;
	GtkInfoBar* _tmp1_ = NULL;
	GtkInfoBar* _tmp2_;
	GtkStyleContext* _tmp3_;
	GtkInfoBar* _tmp4_;
	GtkContainer* _tmp5_;
	GtkLabel* _tmp6_;
	GraniteHeaderLabel* server_header_label = NULL;
	GraniteHeaderLabel* _tmp7_;
	gchar* _tmp8_;
	GraniteValidatedEntry* _tmp9_ = NULL;
	GtkLabel* server_label = NULL;
	GtkLabel* _tmp10_ = NULL;
	GtkSpinButton* _tmp11_ = NULL;
	GtkLabel* port_label = NULL;
	GtkLabel* _tmp12_ = NULL;
	GtkBox* port_box = NULL;
	GtkBox* _tmp13_ = NULL;
	GtkBox* _tmp14_;
	GtkLabel* _tmp15_;
	GtkBox* _tmp16_;
	GtkSpinButton* _tmp17_;
	GtkBox* _tmp18_;
	GtkWidget* _tmp19_;
	GtkRevealer* _tmp20_ = NULL;
	GtkBox* server_port_box = NULL;
	GtkBox* _tmp21_;
	GtkBox* _tmp22_;
	GraniteValidatedEntry* _tmp23_;
	GtkBox* _tmp24_;
	GtkRevealer* _tmp25_;
	GtkListStore* type_store = NULL;
	GtkListStore* _tmp26_;
	GtkListStore* _tmp27_;
	GtkComboBox* _tmp28_;
	GtkCellRendererText* renderer = NULL;
	GtkCellRendererText* _tmp29_;
	GtkComboBox* _tmp30_;
	GtkCellRendererText* _tmp31_;
	GtkComboBox* _tmp32_;
	GtkCellRendererText* _tmp33_;
	GtkLabel* type_label = NULL;
	GtkLabel* _tmp34_ = NULL;
	gchar* _tmp35_;
	GtkEntry* _tmp36_ = NULL;
	GtkLabel* share_label = NULL;
	GtkEntry* _tmp37_;
	GtkLabel* _tmp38_;
	gchar* _tmp39_;
	gchar* _tmp40_;
	GtkEntry* _tmp41_ = NULL;
	GtkLabel* folder_label = NULL;
	GtkLabel* _tmp42_ = NULL;
	GraniteHeaderLabel* _tmp43_;
	gchar* _tmp44_;
	gchar* _tmp45_;
	GraniteValidatedEntry* _tmp46_ = NULL;
	GtkLabel* domain_label = NULL;
	GraniteValidatedEntry* _tmp47_;
	GtkLabel* _tmp48_;
	const gchar* _tmp49_;
	gchar* _tmp50_;
	gchar* _tmp51_;
	GraniteValidatedEntry* _tmp52_ = NULL;
	GtkLabel* user_label = NULL;
	GraniteValidatedEntry* _tmp53_;
	GtkLabel* _tmp54_;
	GraniteValidatedEntry* _tmp55_ = NULL;
	GtkLabel* password_label = NULL;
	GraniteValidatedEntry* _tmp56_;
	GtkLabel* _tmp57_;
	GtkCheckButton* _tmp58_;
	GtkCheckButton* _tmp59_;
	GtkWidget* _tmp60_;
	GtkRevealer* _tmp61_ = NULL;
	GtkButton* _tmp62_;
	GtkButton* _tmp63_;
	GtkButton* _tmp64_ = NULL;
	GtkButton* _tmp65_;
	GtkStyleContext* _tmp66_;
	GtkButton* _tmp67_;
	GtkButton* _tmp68_ = NULL;
	GtkButton* _tmp69_;
	GtkStyleContext* _tmp70_;
	GtkButton* _tmp71_;
	GtkBox* button_box = NULL;
	GtkBox* _tmp72_ = NULL;
	GtkBox* _tmp73_;
	GtkButton* _tmp74_;
	GtkBox* _tmp75_;
	GtkButton* _tmp76_;
	GtkBox* _tmp77_;
	GtkButton* _tmp78_;
	GtkGrid* grid = NULL;
	GtkGrid* _tmp79_ = NULL;
	GtkGrid* _tmp80_;
	GtkInfoBar* _tmp81_;
	GtkGrid* _tmp82_;
	GraniteHeaderLabel* _tmp83_;
	GtkGrid* _tmp84_;
	GtkLabel* _tmp85_;
	GtkGrid* _tmp86_;
	GtkComboBox* _tmp87_;
	GtkGrid* _tmp88_;
	GtkLabel* _tmp89_;
	GtkGrid* _tmp90_;
	GtkBox* _tmp91_;
	GtkGrid* _tmp92_;
	GtkLabel* _tmp93_;
	GtkGrid* _tmp94_;
	GtkEntry* _tmp95_;
	GtkGrid* _tmp96_;
	GtkLabel* _tmp97_;
	GtkGrid* _tmp98_;
	GtkEntry* _tmp99_;
	GtkGrid* _tmp100_;
	GraniteHeaderLabel* _tmp101_;
	GtkGrid* _tmp102_;
	GtkLabel* _tmp103_;
	GtkGrid* _tmp104_;
	GraniteValidatedEntry* _tmp105_;
	GtkGrid* _tmp106_;
	GtkLabel* _tmp107_;
	GtkGrid* _tmp108_;
	GraniteValidatedEntry* _tmp109_;
	GtkGrid* _tmp110_;
	GtkLabel* _tmp111_;
	GtkGrid* _tmp112_;
	GraniteValidatedEntry* _tmp113_;
	GtkGrid* _tmp114_;
	GtkRevealer* _tmp115_;
	GtkSpinner* connecting_spinner = NULL;
	GtkSpinner* _tmp116_;
	GtkSpinner* _tmp117_;
	GtkLabel* connecting_label = NULL;
	GtkLabel* _tmp118_;
	GtkBox* connecting_box = NULL;
	GtkBox* _tmp119_ = NULL;
	GtkBox* _tmp120_;
	GtkLabel* _tmp121_;
	GtkBox* _tmp122_;
	GtkSpinner* _tmp123_;
	GtkStack* _tmp124_ = NULL;
	GtkStack* _tmp125_;
	GtkGrid* _tmp126_;
	GtkStack* _tmp127_;
	GtkBox* _tmp128_;
	GtkBox* content_area = NULL;
	GtkBox* _tmp129_;
	GtkBox* _tmp130_;
	GtkBox* _tmp131_;
	GtkBox* _tmp132_;
	GtkBox* _tmp133_;
	GtkBox* _tmp134_;
	GtkBox* _tmp135_;
	GtkStack* _tmp136_;
	GtkBox* _tmp137_;
	GtkBox* _tmp138_;
	GtkBox* _tmp139_;
	gchar** supported_schemes = NULL;
	GVfs* _tmp140_;
	gchar** _tmp141_;
	gchar** _tmp142_;
	gint supported_schemes_length1;
	gint _supported_schemes_size_;
	PFConnectServerDialogMethodInfo* _tmp143_;
	gint _tmp143__length1;
	GtkComboBox* _tmp156_;
	GtkComboBox* _tmp157_;
	GraniteValidatedEntry* _tmp158_;
	GraniteValidatedEntry* _tmp159_;
	GraniteValidatedEntry* _tmp160_;
	GraniteValidatedEntry* _tmp161_;
	parent_class = G_OBJECT_CLASS (pf_connect_server_dialog_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PF_TYPE_CONNECT_SERVER_DIALOG, PFConnectServerDialog);
	_tmp0_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->info_label);
	self->priv->info_label = _tmp0_;
	_tmp1_ = (GtkInfoBar*) gtk_info_bar_new ();
	gtk_info_bar_set_message_type (_tmp1_, GTK_MESSAGE_INFO);
	gtk_info_bar_set_revealed (_tmp1_, FALSE);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->info_bar);
	self->priv->info_bar = _tmp1_;
	_tmp2_ = self->priv->info_bar;
	_tmp3_ = gtk_widget_get_style_context ((GtkWidget*) _tmp2_);
	gtk_style_context_add_class (_tmp3_, GTK_STYLE_CLASS_FRAME);
	_tmp4_ = self->priv->info_bar;
	_tmp5_ = gtk_info_bar_get_content_area (_tmp4_);
	_tmp6_ = self->priv->info_label;
	gtk_container_add (_tmp5_, (GtkWidget*) _tmp6_);
	_tmp7_ = granite_header_label_new (_ ("Server Details"));
	g_object_ref_sink (_tmp7_);
	server_header_label = _tmp7_;
	_tmp8_ = g_strdup (_ ("Server name or IP address"));
	_tmp9_ = granite_validated_entry_new ();
	gtk_widget_set_hexpand ((GtkWidget*) _tmp9_, TRUE);
	gtk_entry_set_placeholder_text ((GtkEntry*) _tmp9_, _tmp8_);
	_g_free0 (_tmp8_);
	g_object_ref_sink (_tmp9_);
	_g_object_unref0 (self->priv->server_entry);
	self->priv->server_entry = _tmp9_;
	_tmp10_ = (GtkLabel*) gtk_label_new (_ ("Server:"));
	gtk_label_set_xalign (_tmp10_, (gfloat) 1);
	g_object_ref_sink (_tmp10_);
	server_label = _tmp10_;
	_tmp11_ = (GtkSpinButton*) gtk_spin_button_new_with_range ((gdouble) 0, (gdouble) G_MAXUSHORT, (gdouble) 1);
	gtk_spin_button_set_digits (_tmp11_, (guint) 0);
	gtk_spin_button_set_numeric (_tmp11_, TRUE);
	gtk_spin_button_set_update_policy (_tmp11_, GTK_UPDATE_IF_VALID);
	g_object_ref_sink (_tmp11_);
	_g_object_unref0 (self->priv->port_spinbutton);
	self->priv->port_spinbutton = _tmp11_;
	_tmp12_ = (GtkLabel*) gtk_label_new (_ ("Port:"));
	gtk_label_set_xalign (_tmp12_, (gfloat) 1);
	g_object_ref_sink (_tmp12_);
	port_label = _tmp12_;
	_tmp13_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp13_, 6);
	g_object_ref_sink (_tmp13_);
	port_box = _tmp13_;
	_tmp14_ = port_box;
	_tmp15_ = port_label;
	gtk_container_add ((GtkContainer*) _tmp14_, (GtkWidget*) _tmp15_);
	_tmp16_ = port_box;
	_tmp17_ = self->priv->port_spinbutton;
	gtk_container_add ((GtkContainer*) _tmp16_, (GtkWidget*) _tmp17_);
	_tmp18_ = port_box;
	_tmp19_ = _g_object_ref0 ((GtkWidget*) _tmp18_);
	_tmp20_ = (GtkRevealer*) gtk_revealer_new ();
	g_object_set ((GtkContainer*) _tmp20_, "child", _tmp19_, NULL);
	_g_object_unref0 (_tmp19_);
	gtk_revealer_set_transition_type (_tmp20_, GTK_REVEALER_TRANSITION_TYPE_SLIDE_RIGHT);
	g_object_ref_sink (_tmp20_);
	_g_object_unref0 (self->priv->port_revealer);
	self->priv->port_revealer = _tmp20_;
	_tmp21_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp21_);
	server_port_box = _tmp21_;
	_tmp22_ = server_port_box;
	_tmp23_ = self->priv->server_entry;
	gtk_container_add ((GtkContainer*) _tmp22_, (GtkWidget*) _tmp23_);
	_tmp24_ = server_port_box;
	_tmp25_ = self->priv->port_revealer;
	gtk_container_add ((GtkContainer*) _tmp24_, (GtkWidget*) _tmp25_);
	_tmp26_ = gtk_list_store_new (2, PF_CONNECT_SERVER_DIALOG_TYPE_METHOD_INFO, G_TYPE_STRING, -1);
	type_store = _tmp26_;
	_tmp27_ = type_store;
	_tmp28_ = (GtkComboBox*) gtk_combo_box_new_with_model ((GtkTreeModel*) _tmp27_);
	g_object_ref_sink (_tmp28_);
	_g_object_unref0 (self->priv->type_combobox);
	self->priv->type_combobox = _tmp28_;
	_tmp29_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp29_);
	renderer = _tmp29_;
	_tmp30_ = self->priv->type_combobox;
	_tmp31_ = renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp30_, (GtkCellRenderer*) _tmp31_, TRUE);
	_tmp32_ = self->priv->type_combobox;
	_tmp33_ = renderer;
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp32_, (GtkCellRenderer*) _tmp33_, "text", 1);
	_tmp34_ = (GtkLabel*) gtk_label_new (_ ("Type:"));
	gtk_label_set_xalign (_tmp34_, (gfloat) 1);
	g_object_ref_sink (_tmp34_);
	type_label = _tmp34_;
	_tmp35_ = g_strdup (_ ("Name of share on server (Optional)"));
	_tmp36_ = (GtkEntry*) gtk_entry_new ();
	gtk_entry_set_placeholder_text (_tmp36_, _tmp35_);
	_g_free0 (_tmp35_);
	g_object_ref_sink (_tmp36_);
	_g_object_unref0 (self->priv->share_entry);
	self->priv->share_entry = _tmp36_;
	_tmp37_ = self->priv->share_entry;
	_tmp38_ = pf_connect_server_dialog_new_detailed_label (self, _ ("Share:"), (GtkWidget*) _tmp37_);
	share_label = _tmp38_;
	_tmp39_ = g_strdup (_ ("Path of shared folder on server (Optional)"));
	_tmp40_ = g_strdup ("/");
	_tmp41_ = (GtkEntry*) gtk_entry_new ();
	gtk_entry_set_placeholder_text (_tmp41_, _tmp39_);
	_g_free0 (_tmp39_);
	gtk_entry_set_text (_tmp41_, _tmp40_);
	_g_free0 (_tmp40_);
	g_object_ref_sink (_tmp41_);
	_g_object_unref0 (self->priv->folder_entry);
	self->priv->folder_entry = _tmp41_;
	_tmp42_ = (GtkLabel*) gtk_label_new (_ ("Folder:"));
	gtk_label_set_xalign (_tmp42_, (gfloat) 1);
	g_object_ref_sink (_tmp42_);
	folder_label = _tmp42_;
	_tmp43_ = granite_header_label_new (_ ("User Details"));
	g_object_ref_sink (_tmp43_);
	_g_object_unref0 (self->priv->user_header_label);
	self->priv->user_header_label = _tmp43_;
	_tmp44_ = g_strdup ("WORKGROUP");
	_tmp45_ = g_strdup (_ ("Name of Windows domain"));
	_tmp46_ = granite_validated_entry_new ();
	granite_validated_entry_set_is_valid (_tmp46_, TRUE);
	gtk_entry_set_text ((GtkEntry*) _tmp46_, _tmp44_);
	_g_free0 (_tmp44_);
	gtk_entry_set_placeholder_text ((GtkEntry*) _tmp46_, _tmp45_);
	_g_free0 (_tmp45_);
	g_object_ref_sink (_tmp46_);
	_g_object_unref0 (self->priv->domain_entry);
	self->priv->domain_entry = _tmp46_;
	_tmp47_ = self->priv->domain_entry;
	_tmp48_ = pf_connect_server_dialog_new_detailed_label (self, _ ("Domain name:"), (GtkWidget*) _tmp47_);
	domain_label = _tmp48_;
	_tmp49_ = g_get_user_name ();
	_tmp50_ = g_strdup (_tmp49_);
	_tmp51_ = g_strdup (_ ("Name of user on server"));
	_tmp52_ = granite_validated_entry_new ();
	granite_validated_entry_set_is_valid (_tmp52_, TRUE);
	gtk_entry_set_text ((GtkEntry*) _tmp52_, _tmp50_);
	_g_free0 (_tmp50_);
	gtk_entry_set_placeholder_text ((GtkEntry*) _tmp52_, _tmp51_);
	_g_free0 (_tmp51_);
	g_object_ref_sink (_tmp52_);
	_g_object_unref0 (self->priv->user_entry);
	self->priv->user_entry = _tmp52_;
	_tmp53_ = self->priv->user_entry;
	_tmp54_ = pf_connect_server_dialog_new_detailed_label (self, _ ("User name:"), (GtkWidget*) _tmp53_);
	user_label = _tmp54_;
	_tmp55_ = granite_validated_entry_new ();
	gtk_entry_set_input_purpose ((GtkEntry*) _tmp55_, GTK_INPUT_PURPOSE_PASSWORD);
	gtk_entry_set_visibility ((GtkEntry*) _tmp55_, FALSE);
	granite_validated_entry_set_is_valid (_tmp55_, TRUE);
	g_object_ref_sink (_tmp55_);
	_g_object_unref0 (self->priv->password_entry);
	self->priv->password_entry = _tmp55_;
	_tmp56_ = self->priv->password_entry;
	_tmp57_ = pf_connect_server_dialog_new_detailed_label (self, _ ("Password:"), (GtkWidget*) _tmp56_);
	password_label = _tmp57_;
	_tmp58_ = (GtkCheckButton*) gtk_check_button_new_with_label (_ ("Remember this password"));
	g_object_ref_sink (_tmp58_);
	_g_object_unref0 (self->priv->remember_checkbutton);
	self->priv->remember_checkbutton = _tmp58_;
	_tmp59_ = self->priv->remember_checkbutton;
	_tmp60_ = _g_object_ref0 ((GtkWidget*) _tmp59_);
	_tmp61_ = (GtkRevealer*) gtk_revealer_new ();
	g_object_set ((GtkContainer*) _tmp61_, "child", _tmp60_, NULL);
	_g_object_unref0 (_tmp60_);
	gtk_revealer_set_transition_type (_tmp61_, GTK_REVEALER_TRANSITION_TYPE_SLIDE_DOWN);
	g_object_ref_sink (_tmp61_);
	_g_object_unref0 (self->priv->remember_revealer);
	self->priv->remember_revealer = _tmp61_;
	_tmp62_ = (GtkButton*) gtk_button_new_with_label (_ ("Cancel"));
	g_object_ref_sink (_tmp62_);
	_g_object_unref0 (self->priv->cancel_button);
	self->priv->cancel_button = _tmp62_;
	_tmp63_ = self->priv->cancel_button;
	g_signal_connect_object (_tmp63_, "clicked", (GCallback) _pf_connect_server_dialog_on_cancel_clicked_gtk_button_clicked, self, 0);
	_tmp64_ = (GtkButton*) gtk_button_new_with_label (_ ("Connect"));
	gtk_widget_set_can_default ((GtkWidget*) _tmp64_, TRUE);
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp64_, TRUE);
	g_object_ref_sink (_tmp64_);
	_g_object_unref0 (self->priv->connect_button);
	self->priv->connect_button = _tmp64_;
	_tmp65_ = self->priv->connect_button;
	_tmp66_ = gtk_widget_get_style_context ((GtkWidget*) _tmp65_);
	gtk_style_context_add_class (_tmp66_, GTK_STYLE_CLASS_SUGGESTED_ACTION);
	_tmp67_ = self->priv->connect_button;
	g_signal_connect_object (_tmp67_, "clicked", (GCallback) _pf_connect_server_dialog_on_connect_clicked_gtk_button_clicked, self, 0);
	_tmp68_ = (GtkButton*) gtk_button_new_with_label (_ ("Continue"));
	gtk_widget_set_can_default ((GtkWidget*) _tmp68_, TRUE);
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp68_, TRUE);
	g_object_ref_sink (_tmp68_);
	_g_object_unref0 (self->priv->continue_button);
	self->priv->continue_button = _tmp68_;
	_tmp69_ = self->priv->continue_button;
	_tmp70_ = gtk_widget_get_style_context ((GtkWidget*) _tmp69_);
	gtk_style_context_add_class (_tmp70_, GTK_STYLE_CLASS_SUGGESTED_ACTION);
	_tmp71_ = self->priv->continue_button;
	g_signal_connect_object (_tmp71_, "clicked", (GCallback) _pf_connect_server_dialog_on_continue_clicked_gtk_button_clicked, self, 0);
	_tmp72_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	gtk_widget_set_halign ((GtkWidget*) _tmp72_, GTK_ALIGN_END);
	gtk_box_set_homogeneous (_tmp72_, TRUE);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp72_, 24);
	g_object_ref_sink (_tmp72_);
	button_box = _tmp72_;
	_tmp73_ = button_box;
	_tmp74_ = self->priv->cancel_button;
	gtk_container_add ((GtkContainer*) _tmp73_, (GtkWidget*) _tmp74_);
	_tmp75_ = button_box;
	_tmp76_ = self->priv->connect_button;
	gtk_container_add ((GtkContainer*) _tmp75_, (GtkWidget*) _tmp76_);
	_tmp77_ = button_box;
	_tmp78_ = self->priv->continue_button;
	gtk_container_add ((GtkContainer*) _tmp77_, (GtkWidget*) _tmp78_);
	_tmp79_ = (GtkGrid*) gtk_grid_new ();
	gtk_grid_set_row_spacing (_tmp79_, 6);
	gtk_grid_set_column_spacing (_tmp79_, 6);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp79_, TRUE);
	g_object_ref_sink (_tmp79_);
	grid = _tmp79_;
	_tmp80_ = grid;
	_tmp81_ = self->priv->info_bar;
	gtk_grid_attach (_tmp80_, (GtkWidget*) _tmp81_, 0, 0, 2, 1);
	_tmp82_ = grid;
	_tmp83_ = server_header_label;
	gtk_grid_attach (_tmp82_, (GtkWidget*) _tmp83_, 0, 1, 2, 1);
	_tmp84_ = grid;
	_tmp85_ = type_label;
	gtk_grid_attach (_tmp84_, (GtkWidget*) _tmp85_, 0, 2, 1, 1);
	_tmp86_ = grid;
	_tmp87_ = self->priv->type_combobox;
	gtk_grid_attach (_tmp86_, (GtkWidget*) _tmp87_, 1, 2, 1, 1);
	_tmp88_ = grid;
	_tmp89_ = server_label;
	gtk_grid_attach (_tmp88_, (GtkWidget*) _tmp89_, 0, 3, 1, 1);
	_tmp90_ = grid;
	_tmp91_ = server_port_box;
	gtk_grid_attach (_tmp90_, (GtkWidget*) _tmp91_, 1, 3, 1, 1);
	_tmp92_ = grid;
	_tmp93_ = share_label;
	gtk_grid_attach (_tmp92_, (GtkWidget*) _tmp93_, 0, 4, 1, 1);
	_tmp94_ = grid;
	_tmp95_ = self->priv->share_entry;
	gtk_grid_attach (_tmp94_, (GtkWidget*) _tmp95_, 1, 4, 1, 1);
	_tmp96_ = grid;
	_tmp97_ = folder_label;
	gtk_grid_attach (_tmp96_, (GtkWidget*) _tmp97_, 0, 5, 1, 1);
	_tmp98_ = grid;
	_tmp99_ = self->priv->folder_entry;
	gtk_grid_attach (_tmp98_, (GtkWidget*) _tmp99_, 1, 5, 1, 1);
	_tmp100_ = grid;
	_tmp101_ = self->priv->user_header_label;
	gtk_grid_attach (_tmp100_, (GtkWidget*) _tmp101_, 0, 6, 2, 1);
	_tmp102_ = grid;
	_tmp103_ = domain_label;
	gtk_grid_attach (_tmp102_, (GtkWidget*) _tmp103_, 0, 7, 1, 1);
	_tmp104_ = grid;
	_tmp105_ = self->priv->domain_entry;
	gtk_grid_attach (_tmp104_, (GtkWidget*) _tmp105_, 1, 7, 1, 1);
	_tmp106_ = grid;
	_tmp107_ = user_label;
	gtk_grid_attach (_tmp106_, (GtkWidget*) _tmp107_, 0, 8, 1, 1);
	_tmp108_ = grid;
	_tmp109_ = self->priv->user_entry;
	gtk_grid_attach (_tmp108_, (GtkWidget*) _tmp109_, 1, 8, 1, 1);
	_tmp110_ = grid;
	_tmp111_ = password_label;
	gtk_grid_attach (_tmp110_, (GtkWidget*) _tmp111_, 0, 9, 1, 1);
	_tmp112_ = grid;
	_tmp113_ = self->priv->password_entry;
	gtk_grid_attach (_tmp112_, (GtkWidget*) _tmp113_, 1, 9, 1, 1);
	_tmp114_ = grid;
	_tmp115_ = self->priv->remember_revealer;
	gtk_grid_attach (_tmp114_, (GtkWidget*) _tmp115_, 1, 10, 1, 1);
	_tmp116_ = (GtkSpinner*) gtk_spinner_new ();
	g_object_ref_sink (_tmp116_);
	connecting_spinner = _tmp116_;
	_tmp117_ = connecting_spinner;
	gtk_spinner_start (_tmp117_);
	_tmp118_ = (GtkLabel*) gtk_label_new (_ ("Connecting…"));
	g_object_ref_sink (_tmp118_);
	connecting_label = _tmp118_;
	_tmp119_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 6);
	gtk_widget_set_halign ((GtkWidget*) _tmp119_, GTK_ALIGN_CENTER);
	gtk_widget_set_valign ((GtkWidget*) _tmp119_, GTK_ALIGN_CENTER);
	g_object_ref_sink (_tmp119_);
	connecting_box = _tmp119_;
	_tmp120_ = connecting_box;
	_tmp121_ = connecting_label;
	gtk_container_add ((GtkContainer*) _tmp120_, (GtkWidget*) _tmp121_);
	_tmp122_ = connecting_box;
	_tmp123_ = connecting_spinner;
	gtk_container_add ((GtkContainer*) _tmp122_, (GtkWidget*) _tmp123_);
	_tmp124_ = (GtkStack*) gtk_stack_new ();
	gtk_stack_set_transition_type (_tmp124_, GTK_STACK_TRANSITION_TYPE_SLIDE_LEFT_RIGHT);
	g_object_ref_sink (_tmp124_);
	_g_object_unref0 (self->priv->stack);
	self->priv->stack = _tmp124_;
	_tmp125_ = self->priv->stack;
	_tmp126_ = grid;
	gtk_stack_add_named (_tmp125_, (GtkWidget*) _tmp126_, "content");
	_tmp127_ = self->priv->stack;
	_tmp128_ = connecting_box;
	gtk_stack_add_named (_tmp127_, (GtkWidget*) _tmp128_, "connecting");
	_tmp129_ = gtk_dialog_get_content_area ((GtkDialog*) self);
	_tmp130_ = _g_object_ref0 (_tmp129_);
	content_area = _tmp130_;
	_tmp131_ = content_area;
	gtk_container_set_border_width ((GtkContainer*) _tmp131_, (guint) 0);
	_tmp132_ = content_area;
	_tmp133_ = content_area;
	gtk_widget_set_margin_start ((GtkWidget*) _tmp133_, 12);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp132_, 12);
	_tmp134_ = content_area;
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp134_, 2);
	_tmp135_ = content_area;
	_tmp136_ = self->priv->stack;
	gtk_container_add ((GtkContainer*) _tmp135_, (GtkWidget*) _tmp136_);
	_tmp137_ = content_area;
	_tmp138_ = button_box;
	gtk_container_add ((GtkContainer*) _tmp137_, (GtkWidget*) _tmp138_);
	_tmp139_ = content_area;
	gtk_widget_show_all ((GtkWidget*) _tmp139_);
	g_object_set ((GtkWindow*) self, "default-width", 400, NULL);
	_tmp140_ = g_vfs_get_default ();
	_tmp142_ = _tmp141_ = g_vfs_get_supported_uri_schemes (_tmp140_);
	supported_schemes = _tmp142_;
	supported_schemes_length1 = _vala_array_length (_tmp141_);
	_supported_schemes_size_ = supported_schemes_length1;
	_tmp143_ = self->priv->methods;
	_tmp143__length1 = self->priv->methods_length1;
	{
		PFConnectServerDialogMethodInfo* method_collection = NULL;
		gint method_collection_length1 = 0;
		gint _method_collection_size_ = 0;
		gint method_it = 0;
		method_collection = _tmp143_;
		method_collection_length1 = _tmp143__length1;
		for (method_it = 0; method_it < method_collection_length1; method_it = method_it + 1) {
			PFConnectServerDialogMethodInfo _tmp144_;
			PFConnectServerDialogMethodInfo _tmp145_ = {0};
			PFConnectServerDialogMethodInfo method = {0};
			_tmp144_ = method_collection[method_it];
			pf_connect_server_dialog_method_info_copy (&_tmp144_, &_tmp145_);
			method = _tmp145_;
			{
				PFConnectServerDialogMethodInfo _tmp146_;
				const gchar* _tmp147_;
				gchar** _tmp148_;
				gint _tmp148__length1;
				GtkTreeIter iter = {0};
				GtkListStore* _tmp149_;
				GtkTreeIter _tmp150_ = {0};
				GtkListStore* _tmp151_;
				GtkTreeIter _tmp152_;
				PFConnectServerDialogMethodInfo _tmp153_;
				PFConnectServerDialogMethodInfo _tmp154_;
				const gchar* _tmp155_;
				_tmp146_ = method;
				_tmp147_ = _tmp146_.scheme;
				_tmp148_ = supported_schemes;
				_tmp148__length1 = supported_schemes_length1;
				if (!_vala_string_array_contains (_tmp148_, _tmp148__length1, _tmp147_)) {
					pf_connect_server_dialog_method_info_destroy (&method);
					continue;
				}
				_tmp149_ = type_store;
				gtk_list_store_append (_tmp149_, &_tmp150_);
				iter = _tmp150_;
				_tmp151_ = type_store;
				_tmp152_ = iter;
				_tmp153_ = method;
				_tmp154_ = method;
				_tmp155_ = _tmp154_.description;
				gtk_list_store_set (_tmp151_, &_tmp152_, 0, &_tmp153_, 1, _tmp155_, -1);
				pf_connect_server_dialog_method_info_destroy (&method);
			}
		}
	}
	_tmp156_ = self->priv->type_combobox;
	g_signal_connect_object (_tmp156_, "changed", (GCallback) __pf_connect_server_dialog___lambda25__gtk_combo_box_changed, self, 0);
	_tmp157_ = self->priv->type_combobox;
	gtk_combo_box_set_active (_tmp157_, 0);
	_tmp158_ = self->priv->server_entry;
	g_signal_connect_object ((GtkEditable*) _tmp158_, "changed", (GCallback) __pf_connect_server_dialog___lambda26__gtk_editable_changed, self, 0);
	_tmp159_ = self->priv->user_entry;
	g_signal_connect_object ((GtkEditable*) _tmp159_, "changed", (GCallback) __pf_connect_server_dialog___lambda27__gtk_editable_changed, self, 0);
	_tmp160_ = self->priv->domain_entry;
	g_signal_connect_object ((GtkEditable*) _tmp160_, "changed", (GCallback) __pf_connect_server_dialog___lambda28__gtk_editable_changed, self, 0);
	_tmp161_ = self->priv->password_entry;
	g_signal_connect_object ((GtkEditable*) _tmp161_, "changed", (GCallback) __pf_connect_server_dialog___lambda29__gtk_editable_changed, self, 0);
	_g_object_unref0 (content_area);
	_g_object_unref0 (connecting_box);
	_g_object_unref0 (connecting_label);
	_g_object_unref0 (connecting_spinner);
	_g_object_unref0 (grid);
	_g_object_unref0 (button_box);
	_g_object_unref0 (password_label);
	_g_object_unref0 (user_label);
	_g_object_unref0 (domain_label);
	_g_object_unref0 (folder_label);
	_g_object_unref0 (share_label);
	_g_object_unref0 (type_label);
	_g_object_unref0 (renderer);
	_g_object_unref0 (type_store);
	_g_object_unref0 (server_port_box);
	_g_object_unref0 (port_box);
	_g_object_unref0 (port_label);
	_g_object_unref0 (server_label);
	_g_object_unref0 (server_header_label);
	return obj;
}

static void
pf_connect_server_dialog_class_init (PFConnectServerDialogClass * klass,
                                     gpointer klass_data)
{
	pf_connect_server_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PFConnectServerDialog_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_pf_connect_server_dialog_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_pf_connect_server_dialog_set_property;
	G_OBJECT_CLASS (klass)->constructor = pf_connect_server_dialog_constructor;
	G_OBJECT_CLASS (klass)->finalize = pf_connect_server_dialog_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PF_CONNECT_SERVER_DIALOG_SERVER_URI_PROPERTY, pf_connect_server_dialog_properties[PF_CONNECT_SERVER_DIALOG_SERVER_URI_PROPERTY] = g_param_spec_string ("server-uri", "server-uri", "server-uri", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
pf_connect_server_dialog_instance_init (PFConnectServerDialog * self,
                                        gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	PFConnectServerDialogMethodInfo _tmp2_ = {0};
	gchar* _tmp3_;
	gchar* _tmp4_;
	PFConnectServerDialogMethodInfo _tmp5_ = {0};
	gchar* _tmp6_;
	gchar* _tmp7_;
	PFConnectServerDialogMethodInfo _tmp8_ = {0};
	gchar* _tmp9_;
	gchar* _tmp10_;
	PFConnectServerDialogMethodInfo _tmp11_ = {0};
	gchar* _tmp12_;
	gchar* _tmp13_;
	PFConnectServerDialogMethodInfo _tmp14_ = {0};
	gchar* _tmp15_;
	gchar* _tmp16_;
	PFConnectServerDialogMethodInfo _tmp17_ = {0};
	gchar* _tmp18_;
	gchar* _tmp19_;
	PFConnectServerDialogMethodInfo _tmp20_ = {0};
	PFConnectServerDialogMethodInfo* _tmp21_;
	gchar* _tmp22_;
	self->priv = pf_connect_server_dialog_get_instance_private (self);
	_tmp0_ = g_strdup ("ftp");
	_tmp1_ = g_strdup (_ ("Public FTP"));
	memset (&_tmp2_, 0, sizeof (PFConnectServerDialogMethodInfo));
	_g_free0 (_tmp2_.scheme);
	_tmp2_.scheme = _tmp0_;
	_tmp2_.flags = PF_CONNECT_SERVER_DIALOG_WIDGETS_FLAG_ANONYMOUS | PF_CONNECT_SERVER_DIALOG_WIDGETS_FLAG_PORT;
	_tmp2_.port = (gushort) 21;
	_g_free0 (_tmp2_.description);
	_tmp2_.description = _tmp1_;
	_tmp3_ = g_strdup ("ftp");
	_tmp4_ = g_strdup (_ ("FTP (with login)"));
	memset (&_tmp5_, 0, sizeof (PFConnectServerDialogMethodInfo));
	_g_free0 (_tmp5_.scheme);
	_tmp5_.scheme = _tmp3_;
	_tmp5_.flags = PF_CONNECT_SERVER_DIALOG_WIDGETS_FLAG_PORT | PF_CONNECT_SERVER_DIALOG_WIDGETS_FLAG_USER;
	_tmp5_.port = (gushort) 21;
	_g_free0 (_tmp5_.description);
	_tmp5_.description = _tmp4_;
	_tmp6_ = g_strdup ("sftp");
	_tmp7_ = g_strdup (_ ("SSH"));
	memset (&_tmp8_, 0, sizeof (PFConnectServerDialogMethodInfo));
	_g_free0 (_tmp8_.scheme);
	_tmp8_.scheme = _tmp6_;
	_tmp8_.flags = PF_CONNECT_SERVER_DIALOG_WIDGETS_FLAG_PORT | PF_CONNECT_SERVER_DIALOG_WIDGETS_FLAG_USER;
	_tmp8_.port = (gushort) 22;
	_g_free0 (_tmp8_.description);
	_tmp8_.description = _tmp7_;
	_tmp9_ = g_strdup ("afp");
	_tmp10_ = g_strdup (_ ("AFP (Apple Filing Protocol)"));
	memset (&_tmp11_, 0, sizeof (PFConnectServerDialogMethodInfo));
	_g_free0 (_tmp11_.scheme);
	_tmp11_.scheme = _tmp9_;
	_tmp11_.flags = PF_CONNECT_SERVER_DIALOG_WIDGETS_FLAG_PORT | PF_CONNECT_SERVER_DIALOG_WIDGETS_FLAG_USER;
	_tmp11_.port = (gushort) 548;
	_g_free0 (_tmp11_.description);
	_tmp11_.description = _tmp10_;
	_tmp12_ = g_strdup ("smb");
	_tmp13_ = g_strdup (_ ("Windows share"));
	memset (&_tmp14_, 0, sizeof (PFConnectServerDialogMethodInfo));
	_g_free0 (_tmp14_.scheme);
	_tmp14_.scheme = _tmp12_;
	_tmp14_.flags = (PF_CONNECT_SERVER_DIALOG_WIDGETS_FLAG_SHARE | PF_CONNECT_SERVER_DIALOG_WIDGETS_FLAG_USER) | PF_CONNECT_SERVER_DIALOG_WIDGETS_FLAG_DOMAIN;
	_tmp14_.port = (gushort) 0;
	_g_free0 (_tmp14_.description);
	_tmp14_.description = _tmp13_;
	_tmp15_ = g_strdup ("dav");
	_tmp16_ = g_strdup (_ ("WebDAV (HTTP)"));
	memset (&_tmp17_, 0, sizeof (PFConnectServerDialogMethodInfo));
	_g_free0 (_tmp17_.scheme);
	_tmp17_.scheme = _tmp15_;
	_tmp17_.flags = PF_CONNECT_SERVER_DIALOG_WIDGETS_FLAG_PORT | PF_CONNECT_SERVER_DIALOG_WIDGETS_FLAG_USER;
	_tmp17_.port = (gushort) 80;
	_g_free0 (_tmp17_.description);
	_tmp17_.description = _tmp16_;
	_tmp18_ = g_strdup ("davs");
	_tmp19_ = g_strdup (_ ("Secure WebDAV (HTTPS)"));
	memset (&_tmp20_, 0, sizeof (PFConnectServerDialogMethodInfo));
	_g_free0 (_tmp20_.scheme);
	_tmp20_.scheme = _tmp18_;
	_tmp20_.flags = PF_CONNECT_SERVER_DIALOG_WIDGETS_FLAG_PORT | PF_CONNECT_SERVER_DIALOG_WIDGETS_FLAG_USER;
	_tmp20_.port = (gushort) 443;
	_g_free0 (_tmp20_.description);
	_tmp20_.description = _tmp19_;
	_tmp21_ = g_new0 (PFConnectServerDialogMethodInfo, 7);
	_tmp21_[0] = _tmp2_;
	_tmp21_[1] = _tmp5_;
	_tmp21_[2] = _tmp8_;
	_tmp21_[3] = _tmp11_;
	_tmp21_[4] = _tmp14_;
	_tmp21_[5] = _tmp17_;
	_tmp21_[6] = _tmp20_;
	self->priv->methods = _tmp21_;
	self->priv->methods_length1 = 7;
	self->priv->_methods_size_ = self->priv->methods_length1;
	self->priv->needs_password = FALSE;
	_tmp22_ = g_strdup ("");
	self->priv->_server_uri = _tmp22_;
}

static void
pf_connect_server_dialog_finalize (GObject * obj)
{
	PFConnectServerDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PF_TYPE_CONNECT_SERVER_DIALOG, PFConnectServerDialog);
	self->priv->methods = (_vala_PFConnectServerDialogMethodInfo_array_free (self->priv->methods, self->priv->methods_length1), NULL);
	_g_object_unref0 (self->priv->info_bar);
	_g_object_unref0 (self->priv->server_entry);
	_g_object_unref0 (self->priv->port_spinbutton);
	_g_object_unref0 (self->priv->port_revealer);
	_g_object_unref0 (self->priv->remember_revealer);
	_g_object_unref0 (self->priv->share_entry);
	_g_object_unref0 (self->priv->type_combobox);
	_g_object_unref0 (self->priv->folder_entry);
	_g_object_unref0 (self->priv->domain_entry);
	_g_object_unref0 (self->priv->user_entry);
	_g_object_unref0 (self->priv->password_entry);
	_g_object_unref0 (self->priv->remember_checkbutton);
	_g_object_unref0 (self->priv->connect_button);
	_g_object_unref0 (self->priv->continue_button);
	_g_object_unref0 (self->priv->cancel_button);
	_g_object_unref0 (self->priv->user_header_label);
	_g_object_unref0 (self->priv->info_label);
	_g_object_unref0 (self->priv->stack);
	_g_object_unref0 (self->priv->mount_cancellable);
	_g_free0 (self->priv->_server_uri);
	G_OBJECT_CLASS (pf_connect_server_dialog_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
pf_connect_server_dialog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PFConnectServerDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pf_connect_server_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PFConnectServerDialog), 0, (GInstanceInitFunc) pf_connect_server_dialog_instance_init, NULL };
	GType pf_connect_server_dialog_type_id;
	pf_connect_server_dialog_type_id = g_type_register_static (GRANITE_TYPE_DIALOG, "PFConnectServerDialog", &g_define_type_info, 0);
	PFConnectServerDialog_private_offset = g_type_add_instance_private (pf_connect_server_dialog_type_id, sizeof (PFConnectServerDialogPrivate));
	return pf_connect_server_dialog_type_id;
}

GType
pf_connect_server_dialog_get_type (void)
{
	static volatile gsize pf_connect_server_dialog_type_id__once = 0;
	if (g_once_init_enter (&pf_connect_server_dialog_type_id__once)) {
		GType pf_connect_server_dialog_type_id;
		pf_connect_server_dialog_type_id = pf_connect_server_dialog_get_type_once ();
		g_once_init_leave (&pf_connect_server_dialog_type_id__once, pf_connect_server_dialog_type_id);
	}
	return pf_connect_server_dialog_type_id__once;
}

static void
_vala_pf_connect_server_dialog_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec)
{
	PFConnectServerDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PF_TYPE_CONNECT_SERVER_DIALOG, PFConnectServerDialog);
	switch (property_id) {
		case PF_CONNECT_SERVER_DIALOG_SERVER_URI_PROPERTY:
		g_value_set_string (value, pf_connect_server_dialog_get_server_uri (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_pf_connect_server_dialog_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec)
{
	PFConnectServerDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PF_TYPE_CONNECT_SERVER_DIALOG, PFConnectServerDialog);
	switch (property_id) {
		case PF_CONNECT_SERVER_DIALOG_SERVER_URI_PROPERTY:
		pf_connect_server_dialog_set_server_uri (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

