/* Image.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Image.vala, do not modify */

/*
* Copyright (c) 2017 Felipe Escoto (https://github.com/Philip-Scott/Notes-up)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 59 Temple Place - Suite 330,
* Boston, MA 02111-1307, USA.
*
* Authored by: Felipe Escoto <felescoto95@hotmail.com>
*/

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <sqlite3.h>
#include <gio/gio.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <granite.h>
#include <gdk/gdk.h>
#include <cairo-gobject.h>
#include <float.h>
#include <math.h>
#include <glib/gstdio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define ENOTES_TYPE_IMAGE (enotes_image_get_type ())
#define ENOTES_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_TYPE_IMAGE, ENotesImage))
#define ENOTES_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_TYPE_IMAGE, ENotesImageClass))
#define ENOTES_IS_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_TYPE_IMAGE))
#define ENOTES_IS_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_TYPE_IMAGE))
#define ENOTES_IMAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_TYPE_IMAGE, ENotesImageClass))

typedef struct _ENotesImage ENotesImage;
typedef struct _ENotesImageClass ENotesImageClass;
typedef struct _ENotesImagePrivate ENotesImagePrivate;
typedef enum  {
	ENOTES_IMAGE_FORMAT_PNG = 0,
	ENOTES_IMAGE_FORMAT_SVG = 1
} ENotesImageFormat;

#define ENOTES_TYPE_IMAGE_FORMAT (enotes_image_format_get_type ())
enum  {
	ENOTES_IMAGE_0_PROPERTY,
	ENOTES_IMAGE_NUM_PROPERTIES
};
static GParamSpec* enotes_image_properties[ENOTES_IMAGE_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_DATABASE_TABLE (database_table_get_type ())
#define DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_TABLE, DatabaseTable))
#define DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_TABLE, DatabaseTableClass))
#define IS_DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_TABLE))
#define IS_DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_TABLE))
#define DATABASE_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_TABLE, DatabaseTableClass))

typedef struct _DatabaseTable DatabaseTable;
typedef struct _DatabaseTableClass DatabaseTableClass;
typedef struct _DatabaseTablePrivate DatabaseTablePrivate;

#define ENOTES_TYPE_IMAGE_TABLE (enotes_image_table_get_type ())
#define ENOTES_IMAGE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_TYPE_IMAGE_TABLE, ENotesImageTable))
#define ENOTES_IMAGE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_TYPE_IMAGE_TABLE, ENotesImageTableClass))
#define ENOTES_IS_IMAGE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_TYPE_IMAGE_TABLE))
#define ENOTES_IS_IMAGE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_TYPE_IMAGE_TABLE))
#define ENOTES_IMAGE_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_TYPE_IMAGE_TABLE, ENotesImageTableClass))

typedef struct _ENotesImageTable ENotesImageTable;
typedef struct _ENotesImageTableClass ENotesImageTableClass;
typedef struct _ENotesImageTablePrivate ENotesImageTablePrivate;
#define _database_table_unref0(var) ((var == NULL) ? NULL : (var = (database_table_unref (var), NULL)))
#define _sqlite3_finalize0(var) ((var == NULL) ? NULL : (var = (sqlite3_finalize (var), NULL)))
typedef struct _Block12Data Block12Data;
#define _g_array_unref0(var) ((var == NULL) ? NULL : (var = (g_array_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _ENotesImage {
	GObject parent_instance;
	ENotesImagePrivate * priv;
	gint64 id;
	ENotesImageFormat format;
	gchar* data;
};

struct _ENotesImageClass {
	GObjectClass parent_class;
};

struct _DatabaseTable {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DatabaseTablePrivate * priv;
	gchar* table_name;
};

struct _DatabaseTableClass {
	GTypeClass parent_class;
	void (*finalize) (DatabaseTable *self);
};

struct _ENotesImageTable {
	DatabaseTable parent_instance;
	ENotesImageTablePrivate * priv;
};

struct _ENotesImageTableClass {
	DatabaseTableClass parent_class;
};

struct _Block12Data {
	int _ref_count_;
	ENotesImageTable* self;
	GArray* data_raw;
};

static gpointer enotes_image_parent_class = NULL;
static gpointer enotes_image_table_parent_class = NULL;
static ENotesImageTable* enotes_image_table_instance;
static ENotesImageTable* enotes_image_table_instance = NULL;

VALA_EXTERN GType enotes_image_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesImage, g_object_unref)
VALA_EXTERN GType enotes_image_format_get_type (void) G_GNUC_CONST ;
VALA_EXTERN ENotesImage* enotes_image_new (void);
VALA_EXTERN ENotesImage* enotes_image_construct (GType object_type);
static void enotes_image_finalize (GObject * obj);
static GType enotes_image_get_type_once (void);
VALA_EXTERN ENotesImageFormat enotes_image_format_get_format (gint64 value);
VALA_EXTERN gint64 enotes_image_format_get_format_id (const gchar* mime);
VALA_EXTERN gchar* enotes_image_format_get_data (gint64 format);
VALA_EXTERN gpointer database_table_ref (gpointer instance);
VALA_EXTERN void database_table_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_database_table (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
VALA_EXTERN void value_set_database_table (GValue* value,
                               gpointer v_object);
VALA_EXTERN void value_take_database_table (GValue* value,
                                gpointer v_object);
VALA_EXTERN gpointer value_get_database_table (const GValue* value);
VALA_EXTERN GType database_table_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DatabaseTable, database_table_unref)
VALA_EXTERN GType enotes_image_table_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesImageTable, database_table_unref)
VALA_EXTERN ENotesImageTable* enotes_image_table_get_instance (void);
static ENotesImageTable* enotes_image_table_new (void);
static ENotesImageTable* enotes_image_table_construct (GType object_type);
VALA_EXTERN DatabaseTable* database_table_construct (GType object_type);
VALA_EXTERN sqlite3_stmt* database_table_create_stmt (const gchar* data);
VALA_EXTERN void database_table_fatal (const gchar* op,
                           gint res);
VALA_EXTERN void database_table_set_table_name (DatabaseTable* self,
                                    const gchar* table_name);
VALA_EXTERN gint64 enotes_image_table_save (ENotesImageTable* self,
                                gint64 page_id,
                                GFile* file);
static Block12Data* block12_data_ref (Block12Data* _data12_);
static void block12_data_unref (void * _userdata_);
static cairo_status_t ___lambda6_ (Block12Data* _data12_,
                            guchar* raw,
                            gint raw_length1);
static cairo_status_t ____lambda6__cairo_write_func_t (gpointer self,
                                                guchar* data,
                                                gint data_length1);
VALA_EXTERN void database_table_bind_int (sqlite3_stmt* stmt,
                              gint column,
                              gint64 data);
VALA_EXTERN void database_table_bind_text (sqlite3_stmt* stmt,
                               gint column,
                               const gchar* data);
VALA_EXTERN ENotesImage* enotes_image_table_get_image (ENotesImageTable* self,
                                           gint64 page_id,
                                           gint64 photo_id);
VALA_EXTERN void enotes_image_table_delete_all_from_page (ENotesImageTable* self,
                                              gint64 page_id);
VALA_EXTERN void enotes_image_table_reset_instance (void);
static void enotes_image_table_finalize (DatabaseTable * obj);
static GType enotes_image_table_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

ENotesImage*
enotes_image_construct (GType object_type)
{
	ENotesImage * self = NULL;
#line 22 "../Notes-up-2.0.6/src/Services/Image.vala"
	self = (ENotesImage*) g_object_new (object_type, NULL);
#line 22 "../Notes-up-2.0.6/src/Services/Image.vala"
	return self;
#line 231 "Image.c"
}

ENotesImage*
enotes_image_new (void)
{
#line 22 "../Notes-up-2.0.6/src/Services/Image.vala"
	return enotes_image_construct (ENOTES_TYPE_IMAGE);
#line 239 "Image.c"
}

static void
enotes_image_class_init (ENotesImageClass * klass,
                         gpointer klass_data)
{
#line 22 "../Notes-up-2.0.6/src/Services/Image.vala"
	enotes_image_parent_class = g_type_class_peek_parent (klass);
#line 22 "../Notes-up-2.0.6/src/Services/Image.vala"
	G_OBJECT_CLASS (klass)->finalize = enotes_image_finalize;
#line 250 "Image.c"
}

static void
enotes_image_instance_init (ENotesImage * self,
                            gpointer klass)
{
}

static void
enotes_image_finalize (GObject * obj)
{
	ENotesImage * self;
#line 22 "../Notes-up-2.0.6/src/Services/Image.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ENOTES_TYPE_IMAGE, ENotesImage);
#line 25 "../Notes-up-2.0.6/src/Services/Image.vala"
	_g_free0 (self->data);
#line 22 "../Notes-up-2.0.6/src/Services/Image.vala"
	G_OBJECT_CLASS (enotes_image_parent_class)->finalize (obj);
#line 269 "Image.c"
}

static GType
enotes_image_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ENotesImageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) enotes_image_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ENotesImage), 0, (GInstanceInitFunc) enotes_image_instance_init, NULL };
	GType enotes_image_type_id;
	enotes_image_type_id = g_type_register_static (G_TYPE_OBJECT, "ENotesImage", &g_define_type_info, 0);
	return enotes_image_type_id;
}

GType
enotes_image_get_type (void)
{
	static volatile gsize enotes_image_type_id__once = 0;
	if (g_once_init_enter (&enotes_image_type_id__once)) {
		GType enotes_image_type_id;
		enotes_image_type_id = enotes_image_get_type_once ();
		g_once_init_leave (&enotes_image_type_id__once, enotes_image_type_id);
	}
	return enotes_image_type_id__once;
}

ENotesImageFormat
enotes_image_format_get_format (gint64 value)
{
	ENotesImageFormat _tmp0_ = 0;
	ENotesImageFormat result;
#line 33 "../Notes-up-2.0.6/src/Services/Image.vala"
	if (value == ((gint64) 0)) {
#line 33 "../Notes-up-2.0.6/src/Services/Image.vala"
		_tmp0_ = ENOTES_IMAGE_FORMAT_PNG;
#line 302 "Image.c"
	} else {
#line 33 "../Notes-up-2.0.6/src/Services/Image.vala"
		_tmp0_ = ENOTES_IMAGE_FORMAT_SVG;
#line 306 "Image.c"
	}
#line 33 "../Notes-up-2.0.6/src/Services/Image.vala"
	result = _tmp0_;
#line 33 "../Notes-up-2.0.6/src/Services/Image.vala"
	return result;
#line 312 "Image.c"
}

gint64
enotes_image_format_get_format_id (const gchar* mime)
{
	gchar* type = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	GQuark _tmp9_ = 0U;
#line 39 "../Notes-up-2.0.6/src/Services/Image.vala"
	static GQuark _tmp8_label0 = 0;
#line 39 "../Notes-up-2.0.6/src/Services/Image.vala"
	static GQuark _tmp8_label1 = 0;
#line 333 "Image.c"
	gint64 result;
#line 36 "../Notes-up-2.0.6/src/Services/Image.vala"
	g_return_val_if_fail (mime != NULL, 0LL);
#line 37 "../Notes-up-2.0.6/src/Services/Image.vala"
	_tmp1_ = _tmp0_ = g_strsplit (mime, "/", 0);
#line 37 "../Notes-up-2.0.6/src/Services/Image.vala"
	_tmp2_ = _tmp1_;
#line 37 "../Notes-up-2.0.6/src/Services/Image.vala"
	_tmp2__length1 = _vala_array_length (_tmp0_);
#line 37 "../Notes-up-2.0.6/src/Services/Image.vala"
	_tmp3_ = _tmp2_[1];
#line 37 "../Notes-up-2.0.6/src/Services/Image.vala"
	_tmp4_ = g_strdup (_tmp3_);
#line 37 "../Notes-up-2.0.6/src/Services/Image.vala"
	_tmp5_ = _tmp4_;
#line 37 "../Notes-up-2.0.6/src/Services/Image.vala"
	_tmp2_ = (_vala_array_free (_tmp2_, _tmp2__length1, (GDestroyNotify) g_free), NULL);
#line 37 "../Notes-up-2.0.6/src/Services/Image.vala"
	type = _tmp5_;
#line 39 "../Notes-up-2.0.6/src/Services/Image.vala"
	_tmp6_ = type;
#line 39 "../Notes-up-2.0.6/src/Services/Image.vala"
	_tmp7_ = _tmp6_;
#line 39 "../Notes-up-2.0.6/src/Services/Image.vala"
	_tmp9_ = (NULL == _tmp7_) ? 0 : g_quark_from_string (_tmp7_);
#line 39 "../Notes-up-2.0.6/src/Services/Image.vala"
	if ((_tmp9_ == ((0 != _tmp8_label0) ? _tmp8_label0 : (_tmp8_label0 = g_quark_from_static_string ("svg+xml")))) || (_tmp9_ == ((0 != _tmp8_label1) ? _tmp8_label1 : (_tmp8_label1 = g_quark_from_static_string ("svg"))))) {
#line 39 "../Notes-up-2.0.6/src/Services/Image.vala"
		switch (0) {
#line 363 "Image.c"
			default:
			{
#line 42 "../Notes-up-2.0.6/src/Services/Image.vala"
				result = (gint64) 1;
#line 42 "../Notes-up-2.0.6/src/Services/Image.vala"
				_g_free0 (type);
#line 42 "../Notes-up-2.0.6/src/Services/Image.vala"
				return result;
#line 372 "Image.c"
			}
		}
	} else {
#line 39 "../Notes-up-2.0.6/src/Services/Image.vala"
		switch (0) {
#line 378 "Image.c"
			default:
			{
#line 43 "../Notes-up-2.0.6/src/Services/Image.vala"
				result = (gint64) 0;
#line 43 "../Notes-up-2.0.6/src/Services/Image.vala"
				_g_free0 (type);
#line 43 "../Notes-up-2.0.6/src/Services/Image.vala"
				return result;
#line 387 "Image.c"
			}
		}
	}
}

gchar*
enotes_image_format_get_data (gint64 format)
{
	gchar* result;
#line 48 "../Notes-up-2.0.6/src/Services/Image.vala"
	switch (format) {
#line 48 "../Notes-up-2.0.6/src/Services/Image.vala"
		case 1:
#line 401 "Image.c"
		{
			gchar* _tmp0_;
#line 49 "../Notes-up-2.0.6/src/Services/Image.vala"
			_tmp0_ = g_strdup ("data:image/svg+xml;base64");
#line 49 "../Notes-up-2.0.6/src/Services/Image.vala"
			result = _tmp0_;
#line 49 "../Notes-up-2.0.6/src/Services/Image.vala"
			return result;
#line 410 "Image.c"
		}
		default:
		{
			gchar* _tmp1_;
#line 50 "../Notes-up-2.0.6/src/Services/Image.vala"
			_tmp1_ = g_strdup ("data:image/png;base64");
#line 50 "../Notes-up-2.0.6/src/Services/Image.vala"
			result = _tmp1_;
#line 50 "../Notes-up-2.0.6/src/Services/Image.vala"
			return result;
#line 421 "Image.c"
		}
	}
}

static GType
enotes_image_format_get_type_once (void)
{
	static const GEnumValue values[] = {{ENOTES_IMAGE_FORMAT_PNG, "ENOTES_IMAGE_FORMAT_PNG", "png"}, {ENOTES_IMAGE_FORMAT_SVG, "ENOTES_IMAGE_FORMAT_SVG", "svg"}, {0, NULL, NULL}};
	GType enotes_image_format_type_id;
	enotes_image_format_type_id = g_enum_register_static ("ENotesImageFormat", values);
	return enotes_image_format_type_id;
}

GType
enotes_image_format_get_type (void)
{
	static volatile gsize enotes_image_format_type_id__once = 0;
	if (g_once_init_enter (&enotes_image_format_type_id__once)) {
		GType enotes_image_format_type_id;
		enotes_image_format_type_id = enotes_image_format_get_type_once ();
		g_once_init_leave (&enotes_image_format_type_id__once, enotes_image_format_type_id);
	}
	return enotes_image_format_type_id__once;
}

static gpointer
_database_table_ref0 (gpointer self)
{
#line 64 "../Notes-up-2.0.6/src/Services/Image.vala"
	return self ? database_table_ref (self) : NULL;
#line 452 "Image.c"
}

ENotesImageTable*
enotes_image_table_get_instance (void)
{
	ENotesImageTable* _tmp0_;
	ENotesImageTable* _tmp2_;
	ENotesImageTable* _tmp3_;
	ENotesImageTable* result;
#line 60 "../Notes-up-2.0.6/src/Services/Image.vala"
	_tmp0_ = enotes_image_table_instance;
#line 60 "../Notes-up-2.0.6/src/Services/Image.vala"
	if (_tmp0_ == NULL) {
#line 466 "Image.c"
		ENotesImageTable* _tmp1_;
#line 61 "../Notes-up-2.0.6/src/Services/Image.vala"
		_tmp1_ = enotes_image_table_new ();
#line 61 "../Notes-up-2.0.6/src/Services/Image.vala"
		_database_table_unref0 (enotes_image_table_instance);
#line 61 "../Notes-up-2.0.6/src/Services/Image.vala"
		enotes_image_table_instance = _tmp1_;
#line 474 "Image.c"
	}
#line 64 "../Notes-up-2.0.6/src/Services/Image.vala"
	_tmp2_ = enotes_image_table_instance;
#line 64 "../Notes-up-2.0.6/src/Services/Image.vala"
	_tmp3_ = _database_table_ref0 (_tmp2_);
#line 64 "../Notes-up-2.0.6/src/Services/Image.vala"
	result = _tmp3_;
#line 64 "../Notes-up-2.0.6/src/Services/Image.vala"
	return result;
#line 484 "Image.c"
}

static ENotesImageTable*
enotes_image_table_construct (GType object_type)
{
	ENotesImageTable* self = NULL;
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_;
	gint res = 0;
	sqlite3_stmt* _tmp1_;
#line 67 "../Notes-up-2.0.6/src/Services/Image.vala"
	self = (ENotesImageTable*) database_table_construct (object_type);
#line 68 "../Notes-up-2.0.6/src/Services/Image.vala"
	_tmp0_ = database_table_create_stmt ("CREATE TABLE IF NOT EXISTS Image (" "id INTEGER NOT NULL, " "page_id INTEGER NOT NULL, " "format INTEGER, " "data BLOB, " "PRIMARY KEY (id, page_id))");
#line 68 "../Notes-up-2.0.6/src/Services/Image.vala"
	stmt = _tmp0_;
#line 74 "../Notes-up-2.0.6/src/Services/Image.vala"
	_tmp1_ = stmt;
#line 74 "../Notes-up-2.0.6/src/Services/Image.vala"
	res = sqlite3_step (_tmp1_);
#line 76 "../Notes-up-2.0.6/src/Services/Image.vala"
	if (res != SQLITE_DONE) {
#line 77 "../Notes-up-2.0.6/src/Services/Image.vala"
		database_table_fatal ("create image table", res);
#line 509 "Image.c"
	}
#line 80 "../Notes-up-2.0.6/src/Services/Image.vala"
	database_table_set_table_name ((DatabaseTable*) self, "Image");
#line 67 "../Notes-up-2.0.6/src/Services/Image.vala"
	_sqlite3_finalize0 (stmt);
#line 67 "../Notes-up-2.0.6/src/Services/Image.vala"
	return self;
#line 517 "Image.c"
}

static ENotesImageTable*
enotes_image_table_new (void)
{
#line 67 "../Notes-up-2.0.6/src/Services/Image.vala"
	return enotes_image_table_construct (ENOTES_TYPE_IMAGE_TABLE);
#line 525 "Image.c"
}

static Block12Data*
block12_data_ref (Block12Data* _data12_)
{
#line 89 "../Notes-up-2.0.6/src/Services/Image.vala"
	g_atomic_int_inc (&_data12_->_ref_count_);
#line 89 "../Notes-up-2.0.6/src/Services/Image.vala"
	return _data12_;
#line 535 "Image.c"
}

static void
block12_data_unref (void * _userdata_)
{
	Block12Data* _data12_;
	_data12_ = (Block12Data*) _userdata_;
#line 89 "../Notes-up-2.0.6/src/Services/Image.vala"
	if (g_atomic_int_dec_and_test (&_data12_->_ref_count_)) {
#line 545 "Image.c"
		ENotesImageTable* self;
#line 89 "../Notes-up-2.0.6/src/Services/Image.vala"
		self = _data12_->self;
#line 89 "../Notes-up-2.0.6/src/Services/Image.vala"
		_g_array_unref0 (_data12_->data_raw);
#line 89 "../Notes-up-2.0.6/src/Services/Image.vala"
		_database_table_unref0 (self);
#line 89 "../Notes-up-2.0.6/src/Services/Image.vala"
		g_slice_free (Block12Data, _data12_);
#line 555 "Image.c"
	}
}

static cairo_status_t
___lambda6_ (Block12Data* _data12_,
             guchar* raw,
             gint raw_length1)
{
	ENotesImageTable* self;
	GArray* _tmp0_;
	cairo_status_t result;
#line 106 "../Notes-up-2.0.6/src/Services/Image.vala"
	self = _data12_->self;
#line 107 "../Notes-up-2.0.6/src/Services/Image.vala"
	_tmp0_ = _data12_->data_raw;
#line 107 "../Notes-up-2.0.6/src/Services/Image.vala"
	g_array_append_vals (_tmp0_, raw, (guint) raw_length1);
#line 108 "../Notes-up-2.0.6/src/Services/Image.vala"
	result = CAIRO_STATUS_SUCCESS;
#line 108 "../Notes-up-2.0.6/src/Services/Image.vala"
	return result;
#line 577 "Image.c"
}

static cairo_status_t
____lambda6__cairo_write_func_t (gpointer self,
                                 guchar* data,
                                 gint data_length1)
{
	cairo_status_t result;
	result = ___lambda6_ (self, data, data_length1);
#line 106 "../Notes-up-2.0.6/src/Services/Image.vala"
	return result;
#line 589 "Image.c"
}

static gchar*
string_to_utf8 (const gchar* self,
                gint* result_length1)
{
	gint string_length = 0;
	gint _tmp0_;
	gint _tmp1_;
	gchar* _result_ = NULL;
	gchar* _tmp2_;
	gint _result__length1;
	gint __result__size_;
	gint _tmp3_;
	gchar* _tmp4_;
	gint _tmp4__length1;
	gchar* result;
#line 1616 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1617 "glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1617 "glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1617 "glib-2.0.vapi"
	string_length = _tmp1_;
#line 1618 "glib-2.0.vapi"
	_tmp2_ = g_new0 (gchar, string_length + 1);
#line 1618 "glib-2.0.vapi"
	_result_ = _tmp2_;
#line 1618 "glib-2.0.vapi"
	_result__length1 = string_length + 1;
#line 1618 "glib-2.0.vapi"
	__result__size_ = _result__length1;
#line 1619 "glib-2.0.vapi"
	_tmp3_ = _result__length1;
#line 1619 "glib-2.0.vapi"
	_result__length1 = _tmp3_ - 1;
#line 1620 "glib-2.0.vapi"
	memcpy (_result_, self, (gsize) string_length);
#line 1621 "glib-2.0.vapi"
	_tmp4_ = _result_;
#line 1621 "glib-2.0.vapi"
	_tmp4__length1 = _result__length1;
#line 1621 "glib-2.0.vapi"
	if (result_length1) {
#line 1621 "glib-2.0.vapi"
		*result_length1 = _tmp4__length1;
#line 637 "Image.c"
	}
#line 1621 "glib-2.0.vapi"
	result = _tmp4_;
#line 1621 "glib-2.0.vapi"
	return result;
#line 643 "Image.c"
}

gint64
enotes_image_table_save (ENotesImageTable* self,
                         gint64 page_id,
                         GFile* file)
{
	GFileInfo* file_info = NULL;
	GFileInfo* _tmp0_;
	gint64 format = 0LL;
	GFileInfo* _tmp2_;
	const gchar* _tmp3_;
	gchar* data = NULL;
	gchar* _tmp4_;
	sqlite3_stmt* count_stmt = NULL;
	sqlite3_stmt* _tmp41_;
	sqlite3_stmt* _tmp42_;
	sqlite3_stmt* _tmp43_;
	gint64 new_image_id = 0LL;
	sqlite3_stmt* _tmp44_;
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp45_;
	sqlite3_stmt* _tmp46_;
	sqlite3_stmt* _tmp47_;
	sqlite3_stmt* _tmp48_;
	sqlite3_stmt* _tmp49_;
	const gchar* _tmp50_;
	sqlite3_stmt* _tmp51_;
	GError* _inner_error0_ = NULL;
	gint64 result;
#line 83 "../Notes-up-2.0.6/src/Services/Image.vala"
	g_return_val_if_fail (self != NULL, 0LL);
#line 83 "../Notes-up-2.0.6/src/Services/Image.vala"
	g_return_val_if_fail (file != NULL, 0LL);
#line 84 "../Notes-up-2.0.6/src/Services/Image.vala"
	_tmp0_ = g_file_query_info (file, "*", G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
#line 84 "../Notes-up-2.0.6/src/Services/Image.vala"
	file_info = _tmp0_;
#line 84 "../Notes-up-2.0.6/src/Services/Image.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 684 "Image.c"
		gint64 _tmp1_ = -1LL;
#line 84 "../Notes-up-2.0.6/src/Services/Image.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 84 "../Notes-up-2.0.6/src/Services/Image.vala"
		g_clear_error (&_inner_error0_);
#line 84 "../Notes-up-2.0.6/src/Services/Image.vala"
		return _tmp1_;
#line 692 "Image.c"
	}
#line 85 "../Notes-up-2.0.6/src/Services/Image.vala"
	_tmp2_ = file_info;
#line 85 "../Notes-up-2.0.6/src/Services/Image.vala"
	_tmp3_ = g_file_info_get_content_type (_tmp2_);
#line 85 "../Notes-up-2.0.6/src/Services/Image.vala"
	format = enotes_image_format_get_format_id (_tmp3_);
#line 87 "../Notes-up-2.0.6/src/Services/Image.vala"
	_tmp4_ = g_strdup ("");
#line 87 "../Notes-up-2.0.6/src/Services/Image.vala"
	data = _tmp4_;
#line 89 "../Notes-up-2.0.6/src/Services/Image.vala"
	if (format == ((gint64) ENOTES_IMAGE_FORMAT_PNG)) {
#line 706 "Image.c"
		Block12Data* _data12_;
		GdkPixbuf* image = NULL;
		gint width = 0;
		GdkPixbuf* _tmp14_;
		gint height = 0;
		GdkPixbuf* _tmp15_;
		GraniteDrawingBufferSurface* surface = NULL;
		GraniteDrawingBufferSurface* _tmp16_;
		GraniteDrawingBufferSurface* _tmp17_;
		cairo_t* _tmp18_;
		cairo_t* _tmp19_;
		GdkPixbuf* _tmp20_;
		GraniteDrawingBufferSurface* _tmp21_;
		cairo_t* _tmp22_;
		cairo_t* _tmp23_;
		GArray* _tmp24_;
		GraniteDrawingBufferSurface* _tmp25_;
		cairo_surface_t* _tmp26_;
		cairo_surface_t* _tmp27_;
		GArray* _tmp28_;
		gpointer* _tmp29_;
		gint _tmp29__length1;
		gchar* _tmp30_;
#line 89 "../Notes-up-2.0.6/src/Services/Image.vala"
		_data12_ = g_slice_new0 (Block12Data);
#line 89 "../Notes-up-2.0.6/src/Services/Image.vala"
		_data12_->_ref_count_ = 1;
#line 89 "../Notes-up-2.0.6/src/Services/Image.vala"
		_data12_->self = database_table_ref (self);
#line 736 "Image.c"
		{
			GdkPixbuf* _tmp5_ = NULL;
			gchar* _tmp6_;
			gchar* _tmp7_;
			GdkPixbuf* _tmp8_;
			GdkPixbuf* _tmp9_;
			GdkPixbuf* _tmp10_;
#line 92 "../Notes-up-2.0.6/src/Services/Image.vala"
			_tmp6_ = g_file_get_path (file);
#line 92 "../Notes-up-2.0.6/src/Services/Image.vala"
			_tmp7_ = _tmp6_;
#line 92 "../Notes-up-2.0.6/src/Services/Image.vala"
			_tmp8_ = gdk_pixbuf_new_from_file (_tmp7_, &_inner_error0_);
#line 92 "../Notes-up-2.0.6/src/Services/Image.vala"
			_tmp9_ = _tmp8_;
#line 92 "../Notes-up-2.0.6/src/Services/Image.vala"
			_g_free0 (_tmp7_);
#line 92 "../Notes-up-2.0.6/src/Services/Image.vala"
			_tmp5_ = _tmp9_;
#line 92 "../Notes-up-2.0.6/src/Services/Image.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 758 "Image.c"
				goto __catch0_g_error;
			}
#line 92 "../Notes-up-2.0.6/src/Services/Image.vala"
			_tmp10_ = _tmp5_;
#line 92 "../Notes-up-2.0.6/src/Services/Image.vala"
			_tmp5_ = NULL;
#line 92 "../Notes-up-2.0.6/src/Services/Image.vala"
			_g_object_unref0 (image);
#line 92 "../Notes-up-2.0.6/src/Services/Image.vala"
			image = _tmp10_;
#line 91 "../Notes-up-2.0.6/src/Services/Image.vala"
			_g_object_unref0 (_tmp5_);
#line 771 "Image.c"
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp11_;
			const gchar* _tmp12_;
#line 91 "../Notes-up-2.0.6/src/Services/Image.vala"
			e = _inner_error0_;
#line 91 "../Notes-up-2.0.6/src/Services/Image.vala"
			_inner_error0_ = NULL;
#line 94 "../Notes-up-2.0.6/src/Services/Image.vala"
			_tmp11_ = e;
#line 94 "../Notes-up-2.0.6/src/Services/Image.vala"
			_tmp12_ = _tmp11_->message;
#line 94 "../Notes-up-2.0.6/src/Services/Image.vala"
			g_critical ("Image.vala:94: Error on input: %s", _tmp12_);
#line 95 "../Notes-up-2.0.6/src/Services/Image.vala"
			result = (gint64) -1;
#line 95 "../Notes-up-2.0.6/src/Services/Image.vala"
			_g_error_free0 (e);
#line 95 "../Notes-up-2.0.6/src/Services/Image.vala"
			_g_object_unref0 (image);
#line 95 "../Notes-up-2.0.6/src/Services/Image.vala"
			block12_data_unref (_data12_);
#line 95 "../Notes-up-2.0.6/src/Services/Image.vala"
			_data12_ = NULL;
#line 95 "../Notes-up-2.0.6/src/Services/Image.vala"
			_g_free0 (data);
#line 95 "../Notes-up-2.0.6/src/Services/Image.vala"
			_g_object_unref0 (file_info);
#line 95 "../Notes-up-2.0.6/src/Services/Image.vala"
			return result;
#line 805 "Image.c"
		}
		__finally0:
#line 91 "../Notes-up-2.0.6/src/Services/Image.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 810 "Image.c"
			gint64 _tmp13_ = -1LL;
#line 91 "../Notes-up-2.0.6/src/Services/Image.vala"
			_g_object_unref0 (image);
#line 91 "../Notes-up-2.0.6/src/Services/Image.vala"
			block12_data_unref (_data12_);
#line 91 "../Notes-up-2.0.6/src/Services/Image.vala"
			_data12_ = NULL;
#line 91 "../Notes-up-2.0.6/src/Services/Image.vala"
			_g_free0 (data);
#line 91 "../Notes-up-2.0.6/src/Services/Image.vala"
			_g_object_unref0 (file_info);
#line 91 "../Notes-up-2.0.6/src/Services/Image.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 91 "../Notes-up-2.0.6/src/Services/Image.vala"
			g_clear_error (&_inner_error0_);
#line 91 "../Notes-up-2.0.6/src/Services/Image.vala"
			return _tmp13_;
#line 828 "Image.c"
		}
#line 98 "../Notes-up-2.0.6/src/Services/Image.vala"
		_tmp14_ = image;
#line 98 "../Notes-up-2.0.6/src/Services/Image.vala"
		width = gdk_pixbuf_get_width (_tmp14_);
#line 99 "../Notes-up-2.0.6/src/Services/Image.vala"
		_tmp15_ = image;
#line 99 "../Notes-up-2.0.6/src/Services/Image.vala"
		height = gdk_pixbuf_get_height (_tmp15_);
#line 101 "../Notes-up-2.0.6/src/Services/Image.vala"
		_tmp16_ = granite_drawing_buffer_surface_new (width, height);
#line 101 "../Notes-up-2.0.6/src/Services/Image.vala"
		surface = _tmp16_;
#line 102 "../Notes-up-2.0.6/src/Services/Image.vala"
		_tmp17_ = surface;
#line 102 "../Notes-up-2.0.6/src/Services/Image.vala"
		_tmp18_ = granite_drawing_buffer_surface_get_context (_tmp17_);
#line 102 "../Notes-up-2.0.6/src/Services/Image.vala"
		_tmp19_ = _tmp18_;
#line 102 "../Notes-up-2.0.6/src/Services/Image.vala"
		_tmp20_ = image;
#line 102 "../Notes-up-2.0.6/src/Services/Image.vala"
		gdk_cairo_set_source_pixbuf (_tmp19_, _tmp20_, (gdouble) 0, (gdouble) 0);
#line 103 "../Notes-up-2.0.6/src/Services/Image.vala"
		_tmp21_ = surface;
#line 103 "../Notes-up-2.0.6/src/Services/Image.vala"
		_tmp22_ = granite_drawing_buffer_surface_get_context (_tmp21_);
#line 103 "../Notes-up-2.0.6/src/Services/Image.vala"
		_tmp23_ = _tmp22_;
#line 103 "../Notes-up-2.0.6/src/Services/Image.vala"
		cairo_paint (_tmp23_);
#line 105 "../Notes-up-2.0.6/src/Services/Image.vala"
		_tmp24_ = g_array_new (TRUE, TRUE, sizeof (guchar));
#line 105 "../Notes-up-2.0.6/src/Services/Image.vala"
		_data12_->data_raw = _tmp24_;
#line 106 "../Notes-up-2.0.6/src/Services/Image.vala"
		_tmp25_ = surface;
#line 106 "../Notes-up-2.0.6/src/Services/Image.vala"
		_tmp26_ = granite_drawing_buffer_surface_get_surface (_tmp25_);
#line 106 "../Notes-up-2.0.6/src/Services/Image.vala"
		_tmp27_ = _tmp26_;
#line 106 "../Notes-up-2.0.6/src/Services/Image.vala"
		cairo_surface_write_to_png_stream (_tmp27_, ____lambda6__cairo_write_func_t, _data12_);
#line 111 "../Notes-up-2.0.6/src/Services/Image.vala"
		_tmp28_ = _data12_->data_raw;
#line 111 "../Notes-up-2.0.6/src/Services/Image.vala"
		_tmp29_ = _tmp28_->data;
#line 111 "../Notes-up-2.0.6/src/Services/Image.vala"
		_tmp29__length1 = _tmp28_->len;
#line 111 "../Notes-up-2.0.6/src/Services/Image.vala"
		_tmp30_ = g_base64_encode (_tmp29_, (gint) _tmp29__length1);
#line 111 "../Notes-up-2.0.6/src/Services/Image.vala"
		_g_free0 (data);
#line 111 "../Notes-up-2.0.6/src/Services/Image.vala"
		data = _tmp30_;
#line 89 "../Notes-up-2.0.6/src/Services/Image.vala"
		_g_object_unref0 (surface);
#line 89 "../Notes-up-2.0.6/src/Services/Image.vala"
		_g_object_unref0 (image);
#line 89 "../Notes-up-2.0.6/src/Services/Image.vala"
		block12_data_unref (_data12_);
#line 89 "../Notes-up-2.0.6/src/Services/Image.vala"
		_data12_ = NULL;
#line 892 "Image.c"
	} else {
		gsize size = 0UL;
		gchar* data_raw = NULL;
		gchar* _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_ = NULL;
		gsize _tmp34_ = 0UL;
		const gchar* _tmp36_;
		gint _tmp37_ = 0;
		gchar* _tmp38_;
		guchar* _tmp39_;
		gint _tmp39__length1;
		gchar* _tmp40_;
#line 115 "../Notes-up-2.0.6/src/Services/Image.vala"
		_tmp31_ = g_file_get_path (file);
#line 115 "../Notes-up-2.0.6/src/Services/Image.vala"
		_tmp32_ = _tmp31_;
#line 115 "../Notes-up-2.0.6/src/Services/Image.vala"
		g_file_get_contents (_tmp32_, &_tmp33_, &_tmp34_, &_inner_error0_);
#line 115 "../Notes-up-2.0.6/src/Services/Image.vala"
		_g_free0 (data_raw);
#line 115 "../Notes-up-2.0.6/src/Services/Image.vala"
		data_raw = _tmp33_;
#line 115 "../Notes-up-2.0.6/src/Services/Image.vala"
		size = _tmp34_;
#line 115 "../Notes-up-2.0.6/src/Services/Image.vala"
		_g_free0 (_tmp32_);
#line 115 "../Notes-up-2.0.6/src/Services/Image.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 922 "Image.c"
			gint64 _tmp35_ = -1LL;
#line 115 "../Notes-up-2.0.6/src/Services/Image.vala"
			_g_free0 (data_raw);
#line 115 "../Notes-up-2.0.6/src/Services/Image.vala"
			_g_free0 (data);
#line 115 "../Notes-up-2.0.6/src/Services/Image.vala"
			_g_object_unref0 (file_info);
#line 115 "../Notes-up-2.0.6/src/Services/Image.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 115 "../Notes-up-2.0.6/src/Services/Image.vala"
			g_clear_error (&_inner_error0_);
#line 115 "../Notes-up-2.0.6/src/Services/Image.vala"
			return _tmp35_;
#line 936 "Image.c"
		}
#line 116 "../Notes-up-2.0.6/src/Services/Image.vala"
		_tmp36_ = data_raw;
#line 116 "../Notes-up-2.0.6/src/Services/Image.vala"
		_tmp38_ = string_to_utf8 (_tmp36_, &_tmp37_);
#line 116 "../Notes-up-2.0.6/src/Services/Image.vala"
		_tmp39_ = (guchar*) _tmp38_;
#line 116 "../Notes-up-2.0.6/src/Services/Image.vala"
		_tmp39__length1 = (_tmp37_ * sizeof (gchar)) / sizeof (guchar);
#line 116 "../Notes-up-2.0.6/src/Services/Image.vala"
		_tmp40_ = g_base64_encode (_tmp39_, (gint) ((_tmp37_ * sizeof (gchar)) / sizeof (guchar)));
#line 116 "../Notes-up-2.0.6/src/Services/Image.vala"
		_g_free0 (data);
#line 116 "../Notes-up-2.0.6/src/Services/Image.vala"
		data = _tmp40_;
#line 116 "../Notes-up-2.0.6/src/Services/Image.vala"
		_tmp39_ = (g_free (_tmp39_), NULL);
#line 89 "../Notes-up-2.0.6/src/Services/Image.vala"
		_g_free0 (data_raw);
#line 956 "Image.c"
	}
#line 119 "../Notes-up-2.0.6/src/Services/Image.vala"
	_tmp41_ = database_table_create_stmt ("SELECT count(*) FROM Image WHERE page_id = ?");
#line 119 "../Notes-up-2.0.6/src/Services/Image.vala"
	count_stmt = _tmp41_;
#line 120 "../Notes-up-2.0.6/src/Services/Image.vala"
	_tmp42_ = count_stmt;
#line 120 "../Notes-up-2.0.6/src/Services/Image.vala"
	database_table_bind_int (_tmp42_, 1, page_id);
#line 121 "../Notes-up-2.0.6/src/Services/Image.vala"
	_tmp43_ = count_stmt;
#line 121 "../Notes-up-2.0.6/src/Services/Image.vala"
	sqlite3_step (_tmp43_);
#line 123 "../Notes-up-2.0.6/src/Services/Image.vala"
	_tmp44_ = count_stmt;
#line 123 "../Notes-up-2.0.6/src/Services/Image.vala"
	new_image_id = sqlite3_column_int64 (_tmp44_, 0) + 1;
#line 125 "../Notes-up-2.0.6/src/Services/Image.vala"
	_tmp45_ = database_table_create_stmt ("INSERT INTO Image (id, page_id, format, data) values (?, ?, ?, ?)");
#line 125 "../Notes-up-2.0.6/src/Services/Image.vala"
	stmt = _tmp45_;
#line 126 "../Notes-up-2.0.6/src/Services/Image.vala"
	_tmp46_ = stmt;
#line 126 "../Notes-up-2.0.6/src/Services/Image.vala"
	database_table_bind_int (_tmp46_, 1, new_image_id);
#line 127 "../Notes-up-2.0.6/src/Services/Image.vala"
	_tmp47_ = stmt;
#line 127 "../Notes-up-2.0.6/src/Services/Image.vala"
	database_table_bind_int (_tmp47_, 2, page_id);
#line 128 "../Notes-up-2.0.6/src/Services/Image.vala"
	_tmp48_ = stmt;
#line 128 "../Notes-up-2.0.6/src/Services/Image.vala"
	database_table_bind_int (_tmp48_, 3, format);
#line 129 "../Notes-up-2.0.6/src/Services/Image.vala"
	_tmp49_ = stmt;
#line 129 "../Notes-up-2.0.6/src/Services/Image.vala"
	_tmp50_ = data;
#line 129 "../Notes-up-2.0.6/src/Services/Image.vala"
	database_table_bind_text (_tmp49_, 4, _tmp50_);
#line 131 "../Notes-up-2.0.6/src/Services/Image.vala"
	_tmp51_ = stmt;
#line 131 "../Notes-up-2.0.6/src/Services/Image.vala"
	sqlite3_step (_tmp51_);
#line 133 "../Notes-up-2.0.6/src/Services/Image.vala"
	result = new_image_id;
#line 133 "../Notes-up-2.0.6/src/Services/Image.vala"
	_sqlite3_finalize0 (stmt);
#line 133 "../Notes-up-2.0.6/src/Services/Image.vala"
	_sqlite3_finalize0 (count_stmt);
#line 133 "../Notes-up-2.0.6/src/Services/Image.vala"
	_g_free0 (data);
#line 133 "../Notes-up-2.0.6/src/Services/Image.vala"
	_g_object_unref0 (file_info);
#line 133 "../Notes-up-2.0.6/src/Services/Image.vala"
	return result;
#line 1012 "Image.c"
}

ENotesImage*
enotes_image_table_get_image (ENotesImageTable* self,
                              gint64 page_id,
                              gint64 photo_id)
{
	ENotesImage* image = NULL;
	ENotesImage* _tmp0_;
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp1_;
	sqlite3_stmt* _tmp2_;
	sqlite3_stmt* _tmp3_;
	gint res = 0;
	sqlite3_stmt* _tmp4_;
	ENotesImage* _tmp5_;
	ENotesImage* _tmp6_;
	sqlite3_stmt* _tmp7_;
	ENotesImage* _tmp8_;
	sqlite3_stmt* _tmp9_;
	void* _tmp10_;
	gchar* _tmp11_;
	ENotesImage* result;
#line 136 "../Notes-up-2.0.6/src/Services/Image.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 137 "../Notes-up-2.0.6/src/Services/Image.vala"
	_tmp0_ = enotes_image_new ();
#line 137 "../Notes-up-2.0.6/src/Services/Image.vala"
	image = _tmp0_;
#line 139 "../Notes-up-2.0.6/src/Services/Image.vala"
	_tmp1_ = database_table_create_stmt ("SELECT format, data FROM Image WHERE page_id = ? AND id = ?");
#line 139 "../Notes-up-2.0.6/src/Services/Image.vala"
	stmt = _tmp1_;
#line 140 "../Notes-up-2.0.6/src/Services/Image.vala"
	_tmp2_ = stmt;
#line 140 "../Notes-up-2.0.6/src/Services/Image.vala"
	database_table_bind_int (_tmp2_, 1, page_id);
#line 141 "../Notes-up-2.0.6/src/Services/Image.vala"
	_tmp3_ = stmt;
#line 141 "../Notes-up-2.0.6/src/Services/Image.vala"
	database_table_bind_int (_tmp3_, 2, photo_id);
#line 143 "../Notes-up-2.0.6/src/Services/Image.vala"
	_tmp4_ = stmt;
#line 143 "../Notes-up-2.0.6/src/Services/Image.vala"
	res = sqlite3_step (_tmp4_);
#line 144 "../Notes-up-2.0.6/src/Services/Image.vala"
	if (res == SQLITE_DONE) {
#line 145 "../Notes-up-2.0.6/src/Services/Image.vala"
		result = NULL;
#line 145 "../Notes-up-2.0.6/src/Services/Image.vala"
		_sqlite3_finalize0 (stmt);
#line 145 "../Notes-up-2.0.6/src/Services/Image.vala"
		_g_object_unref0 (image);
#line 145 "../Notes-up-2.0.6/src/Services/Image.vala"
		return result;
#line 1068 "Image.c"
	}
#line 148 "../Notes-up-2.0.6/src/Services/Image.vala"
	_tmp5_ = image;
#line 148 "../Notes-up-2.0.6/src/Services/Image.vala"
	_tmp5_->id = photo_id;
#line 149 "../Notes-up-2.0.6/src/Services/Image.vala"
	_tmp6_ = image;
#line 149 "../Notes-up-2.0.6/src/Services/Image.vala"
	_tmp7_ = stmt;
#line 149 "../Notes-up-2.0.6/src/Services/Image.vala"
	_tmp6_->format = enotes_image_format_get_format (sqlite3_column_int64 (_tmp7_, 0));
#line 150 "../Notes-up-2.0.6/src/Services/Image.vala"
	_tmp8_ = image;
#line 150 "../Notes-up-2.0.6/src/Services/Image.vala"
	_tmp9_ = stmt;
#line 150 "../Notes-up-2.0.6/src/Services/Image.vala"
	_tmp10_ = sqlite3_column_blob (_tmp9_, 1);
#line 150 "../Notes-up-2.0.6/src/Services/Image.vala"
	_tmp11_ = g_strdup ((const gchar*) _tmp10_);
#line 150 "../Notes-up-2.0.6/src/Services/Image.vala"
	_g_free0 (_tmp8_->data);
#line 150 "../Notes-up-2.0.6/src/Services/Image.vala"
	_tmp8_->data = _tmp11_;
#line 152 "../Notes-up-2.0.6/src/Services/Image.vala"
	result = image;
#line 152 "../Notes-up-2.0.6/src/Services/Image.vala"
	_sqlite3_finalize0 (stmt);
#line 152 "../Notes-up-2.0.6/src/Services/Image.vala"
	return result;
#line 1098 "Image.c"
}

void
enotes_image_table_delete_all_from_page (ENotesImageTable* self,
                                         gint64 page_id)
{
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_;
#line 155 "../Notes-up-2.0.6/src/Services/Image.vala"
	g_return_if_fail (self != NULL);
#line 156 "../Notes-up-2.0.6/src/Services/Image.vala"
	_tmp0_ = database_table_create_stmt ("DELETE FROM Image WHERE page_id = ?");
#line 156 "../Notes-up-2.0.6/src/Services/Image.vala"
	stmt = _tmp0_;
#line 157 "../Notes-up-2.0.6/src/Services/Image.vala"
	database_table_bind_int (stmt, 1, page_id);
#line 159 "../Notes-up-2.0.6/src/Services/Image.vala"
	sqlite3_step (stmt);
#line 155 "../Notes-up-2.0.6/src/Services/Image.vala"
	_sqlite3_finalize0 (stmt);
#line 1119 "Image.c"
}

void
enotes_image_table_reset_instance (void)
{
#line 163 "../Notes-up-2.0.6/src/Services/Image.vala"
	_database_table_unref0 (enotes_image_table_instance);
#line 163 "../Notes-up-2.0.6/src/Services/Image.vala"
	enotes_image_table_instance = NULL;
#line 1129 "Image.c"
}

static void
enotes_image_table_class_init (ENotesImageTableClass * klass,
                               gpointer klass_data)
{
#line 55 "../Notes-up-2.0.6/src/Services/Image.vala"
	enotes_image_table_parent_class = g_type_class_peek_parent (klass);
#line 55 "../Notes-up-2.0.6/src/Services/Image.vala"
	((DatabaseTableClass *) klass)->finalize = enotes_image_table_finalize;
#line 1140 "Image.c"
}

static void
enotes_image_table_instance_init (ENotesImageTable * self,
                                  gpointer klass)
{
}

static void
enotes_image_table_finalize (DatabaseTable * obj)
{
	ENotesImageTable * self;
#line 55 "../Notes-up-2.0.6/src/Services/Image.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ENOTES_TYPE_IMAGE_TABLE, ENotesImageTable);
#line 55 "../Notes-up-2.0.6/src/Services/Image.vala"
	DATABASE_TABLE_CLASS (enotes_image_table_parent_class)->finalize (obj);
#line 1157 "Image.c"
}

static GType
enotes_image_table_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ENotesImageTableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) enotes_image_table_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ENotesImageTable), 0, (GInstanceInitFunc) enotes_image_table_instance_init, NULL };
	GType enotes_image_table_type_id;
	enotes_image_table_type_id = g_type_register_static (TYPE_DATABASE_TABLE, "ENotesImageTable", &g_define_type_info, 0);
	return enotes_image_table_type_id;
}

GType
enotes_image_table_get_type (void)
{
	static volatile gsize enotes_image_table_type_id__once = 0;
	if (g_once_init_enter (&enotes_image_table_type_id__once)) {
		GType enotes_image_table_type_id;
		enotes_image_table_type_id = enotes_image_table_get_type_once ();
		g_once_init_leave (&enotes_image_table_type_id__once, enotes_image_table_type_id);
	}
	return enotes_image_table_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

