// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/kms/v1/resources.proto

package kmspb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel] specifies how
// cryptographic operations are performed. For more information, see [Protection
// levels] (https://cloud.google.com/kms/docs/algorithms#protection_levels).
type ProtectionLevel int32

const (
	// Not specified.
	ProtectionLevel_PROTECTION_LEVEL_UNSPECIFIED ProtectionLevel = 0
	// Crypto operations are performed in software.
	ProtectionLevel_SOFTWARE ProtectionLevel = 1
	// Crypto operations are performed in a Hardware Security Module.
	ProtectionLevel_HSM ProtectionLevel = 2
	// Crypto operations are performed by an external key manager.
	ProtectionLevel_EXTERNAL ProtectionLevel = 3
	// Crypto operations are performed in an EKM-over-VPC backend.
	ProtectionLevel_EXTERNAL_VPC ProtectionLevel = 4
)

// Enum value maps for ProtectionLevel.
var (
	ProtectionLevel_name = map[int32]string{
		0: "PROTECTION_LEVEL_UNSPECIFIED",
		1: "SOFTWARE",
		2: "HSM",
		3: "EXTERNAL",
		4: "EXTERNAL_VPC",
	}
	ProtectionLevel_value = map[string]int32{
		"PROTECTION_LEVEL_UNSPECIFIED": 0,
		"SOFTWARE":                     1,
		"HSM":                          2,
		"EXTERNAL":                     3,
		"EXTERNAL_VPC":                 4,
	}
)

func (x ProtectionLevel) Enum() *ProtectionLevel {
	p := new(ProtectionLevel)
	*p = x
	return p
}

func (x ProtectionLevel) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ProtectionLevel) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_kms_v1_resources_proto_enumTypes[0].Descriptor()
}

func (ProtectionLevel) Type() protoreflect.EnumType {
	return &file_google_cloud_kms_v1_resources_proto_enumTypes[0]
}

func (x ProtectionLevel) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ProtectionLevel.Descriptor instead.
func (ProtectionLevel) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_kms_v1_resources_proto_rawDescGZIP(), []int{0}
}

// Describes the reason for a data access. Please refer to
// https://cloud.google.com/assured-workloads/key-access-justifications/docs/justification-codes
// for the detailed semantic meaning of justification reason codes.
type AccessReason int32

const (
	// Unspecified access reason.
	AccessReason_REASON_UNSPECIFIED AccessReason = 0
	// Customer-initiated support.
	AccessReason_CUSTOMER_INITIATED_SUPPORT AccessReason = 1
	// Google-initiated access for system management and troubleshooting.
	AccessReason_GOOGLE_INITIATED_SERVICE AccessReason = 2
	// Google-initiated access in response to a legal request or legal process.
	AccessReason_THIRD_PARTY_DATA_REQUEST AccessReason = 3
	// Google-initiated access for security, fraud, abuse, or compliance purposes.
	AccessReason_GOOGLE_INITIATED_REVIEW AccessReason = 4
	// Customer uses their account to perform any access to their own data which
	// their IAM policy authorizes.
	AccessReason_CUSTOMER_INITIATED_ACCESS AccessReason = 5
	// Google systems access customer data to help optimize the structure of the
	// data or quality for future uses by the customer.
	AccessReason_GOOGLE_INITIATED_SYSTEM_OPERATION AccessReason = 6
	// No reason is expected for this key request.
	AccessReason_REASON_NOT_EXPECTED AccessReason = 7
	// Customer uses their account to perform any access to their own data which
	// their IAM policy authorizes, and one of the following is true:
	//
	//   - A Google administrator has reset the root-access account associated with
	//     the user's organization within the past 7 days.
	//   - A Google-initiated emergency access operation has interacted with a
	//     resource in the same project or folder as the currently accessed resource
	//     within the past 7 days.
	AccessReason_MODIFIED_CUSTOMER_INITIATED_ACCESS AccessReason = 8
	// Google systems access customer data to help optimize the structure of the
	// data or quality for future uses by the customer, and one of the following
	// is true:
	//
	//   - A Google administrator has reset the root-access account associated with
	//     the user's organization within the past 7 days.
	//   - A Google-initiated emergency access operation has interacted with a
	//     resource in the same project or folder as the currently accessed resource
	//     within the past 7 days.
	AccessReason_MODIFIED_GOOGLE_INITIATED_SYSTEM_OPERATION AccessReason = 9
	// Google-initiated access to maintain system reliability.
	AccessReason_GOOGLE_RESPONSE_TO_PRODUCTION_ALERT AccessReason = 10
	// One of the following operations is being executed while simultaneously
	// encountering an internal technical issue which prevented a more precise
	// justification code from being generated:
	//
	//   - Your account has been used to perform any access to your own data which
	//     your IAM policy authorizes.
	//   - An automated Google system operates on encrypted customer data which your
	//     IAM policy authorizes.
	//   - Customer-initiated Google support access.
	//   - Google-initiated support access to protect system reliability.
	AccessReason_CUSTOMER_AUTHORIZED_WORKFLOW_SERVICING AccessReason = 11
)

// Enum value maps for AccessReason.
var (
	AccessReason_name = map[int32]string{
		0:  "REASON_UNSPECIFIED",
		1:  "CUSTOMER_INITIATED_SUPPORT",
		2:  "GOOGLE_INITIATED_SERVICE",
		3:  "THIRD_PARTY_DATA_REQUEST",
		4:  "GOOGLE_INITIATED_REVIEW",
		5:  "CUSTOMER_INITIATED_ACCESS",
		6:  "GOOGLE_INITIATED_SYSTEM_OPERATION",
		7:  "REASON_NOT_EXPECTED",
		8:  "MODIFIED_CUSTOMER_INITIATED_ACCESS",
		9:  "MODIFIED_GOOGLE_INITIATED_SYSTEM_OPERATION",
		10: "GOOGLE_RESPONSE_TO_PRODUCTION_ALERT",
		11: "CUSTOMER_AUTHORIZED_WORKFLOW_SERVICING",
	}
	AccessReason_value = map[string]int32{
		"REASON_UNSPECIFIED":                         0,
		"CUSTOMER_INITIATED_SUPPORT":                 1,
		"GOOGLE_INITIATED_SERVICE":                   2,
		"THIRD_PARTY_DATA_REQUEST":                   3,
		"GOOGLE_INITIATED_REVIEW":                    4,
		"CUSTOMER_INITIATED_ACCESS":                  5,
		"GOOGLE_INITIATED_SYSTEM_OPERATION":          6,
		"REASON_NOT_EXPECTED":                        7,
		"MODIFIED_CUSTOMER_INITIATED_ACCESS":         8,
		"MODIFIED_GOOGLE_INITIATED_SYSTEM_OPERATION": 9,
		"GOOGLE_RESPONSE_TO_PRODUCTION_ALERT":        10,
		"CUSTOMER_AUTHORIZED_WORKFLOW_SERVICING":     11,
	}
)

func (x AccessReason) Enum() *AccessReason {
	p := new(AccessReason)
	*p = x
	return p
}

func (x AccessReason) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AccessReason) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_kms_v1_resources_proto_enumTypes[1].Descriptor()
}

func (AccessReason) Type() protoreflect.EnumType {
	return &file_google_cloud_kms_v1_resources_proto_enumTypes[1]
}

func (x AccessReason) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AccessReason.Descriptor instead.
func (AccessReason) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_kms_v1_resources_proto_rawDescGZIP(), []int{1}
}

// [CryptoKeyPurpose][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose]
// describes the cryptographic capabilities of a
// [CryptoKey][google.cloud.kms.v1.CryptoKey]. A given key can only be used
// for the operations allowed by its purpose. For more information, see [Key
// purposes](https://cloud.google.com/kms/docs/algorithms#key_purposes).
type CryptoKey_CryptoKeyPurpose int32

const (
	// Not specified.
	CryptoKey_CRYPTO_KEY_PURPOSE_UNSPECIFIED CryptoKey_CryptoKeyPurpose = 0
	// [CryptoKeys][google.cloud.kms.v1.CryptoKey] with this purpose may be used
	// with [Encrypt][google.cloud.kms.v1.KeyManagementService.Encrypt] and
	// [Decrypt][google.cloud.kms.v1.KeyManagementService.Decrypt].
	CryptoKey_ENCRYPT_DECRYPT CryptoKey_CryptoKeyPurpose = 1
	// [CryptoKeys][google.cloud.kms.v1.CryptoKey] with this purpose may be used
	// with
	// [AsymmetricSign][google.cloud.kms.v1.KeyManagementService.AsymmetricSign]
	// and
	// [GetPublicKey][google.cloud.kms.v1.KeyManagementService.GetPublicKey].
	CryptoKey_ASYMMETRIC_SIGN CryptoKey_CryptoKeyPurpose = 5
	// [CryptoKeys][google.cloud.kms.v1.CryptoKey] with this purpose may be used
	// with
	// [AsymmetricDecrypt][google.cloud.kms.v1.KeyManagementService.AsymmetricDecrypt]
	// and
	// [GetPublicKey][google.cloud.kms.v1.KeyManagementService.GetPublicKey].
	CryptoKey_ASYMMETRIC_DECRYPT CryptoKey_CryptoKeyPurpose = 6
	// [CryptoKeys][google.cloud.kms.v1.CryptoKey] with this purpose may be used
	// with [RawEncrypt][google.cloud.kms.v1.KeyManagementService.RawEncrypt]
	// and [RawDecrypt][google.cloud.kms.v1.KeyManagementService.RawDecrypt].
	// This purpose is meant to be used for interoperable symmetric
	// encryption and does not support automatic CryptoKey rotation.
	CryptoKey_RAW_ENCRYPT_DECRYPT CryptoKey_CryptoKeyPurpose = 7
	// [CryptoKeys][google.cloud.kms.v1.CryptoKey] with this purpose may be used
	// with [MacSign][google.cloud.kms.v1.KeyManagementService.MacSign].
	CryptoKey_MAC CryptoKey_CryptoKeyPurpose = 9
)

// Enum value maps for CryptoKey_CryptoKeyPurpose.
var (
	CryptoKey_CryptoKeyPurpose_name = map[int32]string{
		0: "CRYPTO_KEY_PURPOSE_UNSPECIFIED",
		1: "ENCRYPT_DECRYPT",
		5: "ASYMMETRIC_SIGN",
		6: "ASYMMETRIC_DECRYPT",
		7: "RAW_ENCRYPT_DECRYPT",
		9: "MAC",
	}
	CryptoKey_CryptoKeyPurpose_value = map[string]int32{
		"CRYPTO_KEY_PURPOSE_UNSPECIFIED": 0,
		"ENCRYPT_DECRYPT":                1,
		"ASYMMETRIC_SIGN":                5,
		"ASYMMETRIC_DECRYPT":             6,
		"RAW_ENCRYPT_DECRYPT":            7,
		"MAC":                            9,
	}
)

func (x CryptoKey_CryptoKeyPurpose) Enum() *CryptoKey_CryptoKeyPurpose {
	p := new(CryptoKey_CryptoKeyPurpose)
	*p = x
	return p
}

func (x CryptoKey_CryptoKeyPurpose) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CryptoKey_CryptoKeyPurpose) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_kms_v1_resources_proto_enumTypes[2].Descriptor()
}

func (CryptoKey_CryptoKeyPurpose) Type() protoreflect.EnumType {
	return &file_google_cloud_kms_v1_resources_proto_enumTypes[2]
}

func (x CryptoKey_CryptoKeyPurpose) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CryptoKey_CryptoKeyPurpose.Descriptor instead.
func (CryptoKey_CryptoKeyPurpose) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_kms_v1_resources_proto_rawDescGZIP(), []int{1, 0}
}

// Attestation formats provided by the HSM.
type KeyOperationAttestation_AttestationFormat int32

const (
	// Not specified.
	KeyOperationAttestation_ATTESTATION_FORMAT_UNSPECIFIED KeyOperationAttestation_AttestationFormat = 0
	// Cavium HSM attestation compressed with gzip. Note that this format is
	// defined by Cavium and subject to change at any time.
	//
	// See
	// https://www.marvell.com/products/security-solutions/nitrox-hs-adapters/software-key-attestation.html.
	KeyOperationAttestation_CAVIUM_V1_COMPRESSED KeyOperationAttestation_AttestationFormat = 3
	// Cavium HSM attestation V2 compressed with gzip. This is a new format
	// introduced in Cavium's version 3.2-08.
	KeyOperationAttestation_CAVIUM_V2_COMPRESSED KeyOperationAttestation_AttestationFormat = 4
)

// Enum value maps for KeyOperationAttestation_AttestationFormat.
var (
	KeyOperationAttestation_AttestationFormat_name = map[int32]string{
		0: "ATTESTATION_FORMAT_UNSPECIFIED",
		3: "CAVIUM_V1_COMPRESSED",
		4: "CAVIUM_V2_COMPRESSED",
	}
	KeyOperationAttestation_AttestationFormat_value = map[string]int32{
		"ATTESTATION_FORMAT_UNSPECIFIED": 0,
		"CAVIUM_V1_COMPRESSED":           3,
		"CAVIUM_V2_COMPRESSED":           4,
	}
)

func (x KeyOperationAttestation_AttestationFormat) Enum() *KeyOperationAttestation_AttestationFormat {
	p := new(KeyOperationAttestation_AttestationFormat)
	*p = x
	return p
}

func (x KeyOperationAttestation_AttestationFormat) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (KeyOperationAttestation_AttestationFormat) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_kms_v1_resources_proto_enumTypes[3].Descriptor()
}

func (KeyOperationAttestation_AttestationFormat) Type() protoreflect.EnumType {
	return &file_google_cloud_kms_v1_resources_proto_enumTypes[3]
}

func (x KeyOperationAttestation_AttestationFormat) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use KeyOperationAttestation_AttestationFormat.Descriptor instead.
func (KeyOperationAttestation_AttestationFormat) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_kms_v1_resources_proto_rawDescGZIP(), []int{3, 0}
}

// The algorithm of the
// [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion], indicating what
// parameters must be used for each cryptographic operation.
//
// The
// [GOOGLE_SYMMETRIC_ENCRYPTION][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm.GOOGLE_SYMMETRIC_ENCRYPTION]
// algorithm is usable with
// [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose]
// [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT].
//
// Algorithms beginning with `RSA_SIGN_` are usable with
// [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose]
// [ASYMMETRIC_SIGN][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ASYMMETRIC_SIGN].
//
// The fields in the name after `RSA_SIGN_` correspond to the following
// parameters: padding algorithm, modulus bit length, and digest algorithm.
//
// For PSS, the salt length used is equal to the length of digest
// algorithm. For example,
// [RSA_SIGN_PSS_2048_SHA256][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm.RSA_SIGN_PSS_2048_SHA256]
// will use PSS with a salt length of 256 bits or 32 bytes.
//
// Algorithms beginning with `RSA_DECRYPT_` are usable with
// [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose]
// [ASYMMETRIC_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ASYMMETRIC_DECRYPT].
//
// The fields in the name after `RSA_DECRYPT_` correspond to the following
// parameters: padding algorithm, modulus bit length, and digest algorithm.
//
// Algorithms beginning with `EC_SIGN_` are usable with
// [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose]
// [ASYMMETRIC_SIGN][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ASYMMETRIC_SIGN].
//
// The fields in the name after `EC_SIGN_` correspond to the following
// parameters: elliptic curve, digest algorithm.
//
// Algorithms beginning with `HMAC_` are usable with
// [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose]
// [MAC][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.MAC].
//
// The suffix following `HMAC_` corresponds to the hash algorithm being used
// (eg. SHA256).
//
// For more information, see [Key purposes and algorithms]
// (https://cloud.google.com/kms/docs/algorithms).
type CryptoKeyVersion_CryptoKeyVersionAlgorithm int32

const (
	// Not specified.
	CryptoKeyVersion_CRYPTO_KEY_VERSION_ALGORITHM_UNSPECIFIED CryptoKeyVersion_CryptoKeyVersionAlgorithm = 0
	// Creates symmetric encryption keys.
	CryptoKeyVersion_GOOGLE_SYMMETRIC_ENCRYPTION CryptoKeyVersion_CryptoKeyVersionAlgorithm = 1
	// AES-GCM (Galois Counter Mode) using 128-bit keys.
	CryptoKeyVersion_AES_128_GCM CryptoKeyVersion_CryptoKeyVersionAlgorithm = 41
	// AES-GCM (Galois Counter Mode) using 256-bit keys.
	CryptoKeyVersion_AES_256_GCM CryptoKeyVersion_CryptoKeyVersionAlgorithm = 19
	// AES-CBC (Cipher Block Chaining Mode) using 128-bit keys.
	CryptoKeyVersion_AES_128_CBC CryptoKeyVersion_CryptoKeyVersionAlgorithm = 42
	// AES-CBC (Cipher Block Chaining Mode) using 256-bit keys.
	CryptoKeyVersion_AES_256_CBC CryptoKeyVersion_CryptoKeyVersionAlgorithm = 43
	// AES-CTR (Counter Mode) using 128-bit keys.
	CryptoKeyVersion_AES_128_CTR CryptoKeyVersion_CryptoKeyVersionAlgorithm = 44
	// AES-CTR (Counter Mode) using 256-bit keys.
	CryptoKeyVersion_AES_256_CTR CryptoKeyVersion_CryptoKeyVersionAlgorithm = 45
	// RSASSA-PSS 2048 bit key with a SHA256 digest.
	CryptoKeyVersion_RSA_SIGN_PSS_2048_SHA256 CryptoKeyVersion_CryptoKeyVersionAlgorithm = 2
	// RSASSA-PSS 3072 bit key with a SHA256 digest.
	CryptoKeyVersion_RSA_SIGN_PSS_3072_SHA256 CryptoKeyVersion_CryptoKeyVersionAlgorithm = 3
	// RSASSA-PSS 4096 bit key with a SHA256 digest.
	CryptoKeyVersion_RSA_SIGN_PSS_4096_SHA256 CryptoKeyVersion_CryptoKeyVersionAlgorithm = 4
	// RSASSA-PSS 4096 bit key with a SHA512 digest.
	CryptoKeyVersion_RSA_SIGN_PSS_4096_SHA512 CryptoKeyVersion_CryptoKeyVersionAlgorithm = 15
	// RSASSA-PKCS1-v1_5 with a 2048 bit key and a SHA256 digest.
	CryptoKeyVersion_RSA_SIGN_PKCS1_2048_SHA256 CryptoKeyVersion_CryptoKeyVersionAlgorithm = 5
	// RSASSA-PKCS1-v1_5 with a 3072 bit key and a SHA256 digest.
	CryptoKeyVersion_RSA_SIGN_PKCS1_3072_SHA256 CryptoKeyVersion_CryptoKeyVersionAlgorithm = 6
	// RSASSA-PKCS1-v1_5 with a 4096 bit key and a SHA256 digest.
	CryptoKeyVersion_RSA_SIGN_PKCS1_4096_SHA256 CryptoKeyVersion_CryptoKeyVersionAlgorithm = 7
	// RSASSA-PKCS1-v1_5 with a 4096 bit key and a SHA512 digest.
	CryptoKeyVersion_RSA_SIGN_PKCS1_4096_SHA512 CryptoKeyVersion_CryptoKeyVersionAlgorithm = 16
	// RSASSA-PKCS1-v1_5 signing without encoding, with a 2048 bit key.
	CryptoKeyVersion_RSA_SIGN_RAW_PKCS1_2048 CryptoKeyVersion_CryptoKeyVersionAlgorithm = 28
	// RSASSA-PKCS1-v1_5 signing without encoding, with a 3072 bit key.
	CryptoKeyVersion_RSA_SIGN_RAW_PKCS1_3072 CryptoKeyVersion_CryptoKeyVersionAlgorithm = 29
	// RSASSA-PKCS1-v1_5 signing without encoding, with a 4096 bit key.
	CryptoKeyVersion_RSA_SIGN_RAW_PKCS1_4096 CryptoKeyVersion_CryptoKeyVersionAlgorithm = 30
	// RSAES-OAEP 2048 bit key with a SHA256 digest.
	CryptoKeyVersion_RSA_DECRYPT_OAEP_2048_SHA256 CryptoKeyVersion_CryptoKeyVersionAlgorithm = 8
	// RSAES-OAEP 3072 bit key with a SHA256 digest.
	CryptoKeyVersion_RSA_DECRYPT_OAEP_3072_SHA256 CryptoKeyVersion_CryptoKeyVersionAlgorithm = 9
	// RSAES-OAEP 4096 bit key with a SHA256 digest.
	CryptoKeyVersion_RSA_DECRYPT_OAEP_4096_SHA256 CryptoKeyVersion_CryptoKeyVersionAlgorithm = 10
	// RSAES-OAEP 4096 bit key with a SHA512 digest.
	CryptoKeyVersion_RSA_DECRYPT_OAEP_4096_SHA512 CryptoKeyVersion_CryptoKeyVersionAlgorithm = 17
	// RSAES-OAEP 2048 bit key with a SHA1 digest.
	CryptoKeyVersion_RSA_DECRYPT_OAEP_2048_SHA1 CryptoKeyVersion_CryptoKeyVersionAlgorithm = 37
	// RSAES-OAEP 3072 bit key with a SHA1 digest.
	CryptoKeyVersion_RSA_DECRYPT_OAEP_3072_SHA1 CryptoKeyVersion_CryptoKeyVersionAlgorithm = 38
	// RSAES-OAEP 4096 bit key with a SHA1 digest.
	CryptoKeyVersion_RSA_DECRYPT_OAEP_4096_SHA1 CryptoKeyVersion_CryptoKeyVersionAlgorithm = 39
	// ECDSA on the NIST P-256 curve with a SHA256 digest.
	// Other hash functions can also be used:
	// https://cloud.google.com/kms/docs/create-validate-signatures#ecdsa_support_for_other_hash_algorithms
	CryptoKeyVersion_EC_SIGN_P256_SHA256 CryptoKeyVersion_CryptoKeyVersionAlgorithm = 12
	// ECDSA on the NIST P-384 curve with a SHA384 digest.
	// Other hash functions can also be used:
	// https://cloud.google.com/kms/docs/create-validate-signatures#ecdsa_support_for_other_hash_algorithms
	CryptoKeyVersion_EC_SIGN_P384_SHA384 CryptoKeyVersion_CryptoKeyVersionAlgorithm = 13
	// ECDSA on the non-NIST secp256k1 curve. This curve is only supported for
	// HSM protection level.
	// Other hash functions can also be used:
	// https://cloud.google.com/kms/docs/create-validate-signatures#ecdsa_support_for_other_hash_algorithms
	CryptoKeyVersion_EC_SIGN_SECP256K1_SHA256 CryptoKeyVersion_CryptoKeyVersionAlgorithm = 31
	// EdDSA on the Curve25519 in pure mode (taking data as input).
	CryptoKeyVersion_EC_SIGN_ED25519 CryptoKeyVersion_CryptoKeyVersionAlgorithm = 40
	// HMAC-SHA256 signing with a 256 bit key.
	CryptoKeyVersion_HMAC_SHA256 CryptoKeyVersion_CryptoKeyVersionAlgorithm = 32
	// HMAC-SHA1 signing with a 160 bit key.
	CryptoKeyVersion_HMAC_SHA1 CryptoKeyVersion_CryptoKeyVersionAlgorithm = 33
	// HMAC-SHA384 signing with a 384 bit key.
	CryptoKeyVersion_HMAC_SHA384 CryptoKeyVersion_CryptoKeyVersionAlgorithm = 34
	// HMAC-SHA512 signing with a 512 bit key.
	CryptoKeyVersion_HMAC_SHA512 CryptoKeyVersion_CryptoKeyVersionAlgorithm = 35
	// HMAC-SHA224 signing with a 224 bit key.
	CryptoKeyVersion_HMAC_SHA224 CryptoKeyVersion_CryptoKeyVersionAlgorithm = 36
	// Algorithm representing symmetric encryption by an external key manager.
	CryptoKeyVersion_EXTERNAL_SYMMETRIC_ENCRYPTION CryptoKeyVersion_CryptoKeyVersionAlgorithm = 18
)

// Enum value maps for CryptoKeyVersion_CryptoKeyVersionAlgorithm.
var (
	CryptoKeyVersion_CryptoKeyVersionAlgorithm_name = map[int32]string{
		0:  "CRYPTO_KEY_VERSION_ALGORITHM_UNSPECIFIED",
		1:  "GOOGLE_SYMMETRIC_ENCRYPTION",
		41: "AES_128_GCM",
		19: "AES_256_GCM",
		42: "AES_128_CBC",
		43: "AES_256_CBC",
		44: "AES_128_CTR",
		45: "AES_256_CTR",
		2:  "RSA_SIGN_PSS_2048_SHA256",
		3:  "RSA_SIGN_PSS_3072_SHA256",
		4:  "RSA_SIGN_PSS_4096_SHA256",
		15: "RSA_SIGN_PSS_4096_SHA512",
		5:  "RSA_SIGN_PKCS1_2048_SHA256",
		6:  "RSA_SIGN_PKCS1_3072_SHA256",
		7:  "RSA_SIGN_PKCS1_4096_SHA256",
		16: "RSA_SIGN_PKCS1_4096_SHA512",
		28: "RSA_SIGN_RAW_PKCS1_2048",
		29: "RSA_SIGN_RAW_PKCS1_3072",
		30: "RSA_SIGN_RAW_PKCS1_4096",
		8:  "RSA_DECRYPT_OAEP_2048_SHA256",
		9:  "RSA_DECRYPT_OAEP_3072_SHA256",
		10: "RSA_DECRYPT_OAEP_4096_SHA256",
		17: "RSA_DECRYPT_OAEP_4096_SHA512",
		37: "RSA_DECRYPT_OAEP_2048_SHA1",
		38: "RSA_DECRYPT_OAEP_3072_SHA1",
		39: "RSA_DECRYPT_OAEP_4096_SHA1",
		12: "EC_SIGN_P256_SHA256",
		13: "EC_SIGN_P384_SHA384",
		31: "EC_SIGN_SECP256K1_SHA256",
		40: "EC_SIGN_ED25519",
		32: "HMAC_SHA256",
		33: "HMAC_SHA1",
		34: "HMAC_SHA384",
		35: "HMAC_SHA512",
		36: "HMAC_SHA224",
		18: "EXTERNAL_SYMMETRIC_ENCRYPTION",
	}
	CryptoKeyVersion_CryptoKeyVersionAlgorithm_value = map[string]int32{
		"CRYPTO_KEY_VERSION_ALGORITHM_UNSPECIFIED": 0,
		"GOOGLE_SYMMETRIC_ENCRYPTION":              1,
		"AES_128_GCM":                              41,
		"AES_256_GCM":                              19,
		"AES_128_CBC":                              42,
		"AES_256_CBC":                              43,
		"AES_128_CTR":                              44,
		"AES_256_CTR":                              45,
		"RSA_SIGN_PSS_2048_SHA256":                 2,
		"RSA_SIGN_PSS_3072_SHA256":                 3,
		"RSA_SIGN_PSS_4096_SHA256":                 4,
		"RSA_SIGN_PSS_4096_SHA512":                 15,
		"RSA_SIGN_PKCS1_2048_SHA256":               5,
		"RSA_SIGN_PKCS1_3072_SHA256":               6,
		"RSA_SIGN_PKCS1_4096_SHA256":               7,
		"RSA_SIGN_PKCS1_4096_SHA512":               16,
		"RSA_SIGN_RAW_PKCS1_2048":                  28,
		"RSA_SIGN_RAW_PKCS1_3072":                  29,
		"RSA_SIGN_RAW_PKCS1_4096":                  30,
		"RSA_DECRYPT_OAEP_2048_SHA256":             8,
		"RSA_DECRYPT_OAEP_3072_SHA256":             9,
		"RSA_DECRYPT_OAEP_4096_SHA256":             10,
		"RSA_DECRYPT_OAEP_4096_SHA512":             17,
		"RSA_DECRYPT_OAEP_2048_SHA1":               37,
		"RSA_DECRYPT_OAEP_3072_SHA1":               38,
		"RSA_DECRYPT_OAEP_4096_SHA1":               39,
		"EC_SIGN_P256_SHA256":                      12,
		"EC_SIGN_P384_SHA384":                      13,
		"EC_SIGN_SECP256K1_SHA256":                 31,
		"EC_SIGN_ED25519":                          40,
		"HMAC_SHA256":                              32,
		"HMAC_SHA1":                                33,
		"HMAC_SHA384":                              34,
		"HMAC_SHA512":                              35,
		"HMAC_SHA224":                              36,
		"EXTERNAL_SYMMETRIC_ENCRYPTION":            18,
	}
)

func (x CryptoKeyVersion_CryptoKeyVersionAlgorithm) Enum() *CryptoKeyVersion_CryptoKeyVersionAlgorithm {
	p := new(CryptoKeyVersion_CryptoKeyVersionAlgorithm)
	*p = x
	return p
}

func (x CryptoKeyVersion_CryptoKeyVersionAlgorithm) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CryptoKeyVersion_CryptoKeyVersionAlgorithm) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_kms_v1_resources_proto_enumTypes[4].Descriptor()
}

func (CryptoKeyVersion_CryptoKeyVersionAlgorithm) Type() protoreflect.EnumType {
	return &file_google_cloud_kms_v1_resources_proto_enumTypes[4]
}

func (x CryptoKeyVersion_CryptoKeyVersionAlgorithm) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CryptoKeyVersion_CryptoKeyVersionAlgorithm.Descriptor instead.
func (CryptoKeyVersion_CryptoKeyVersionAlgorithm) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_kms_v1_resources_proto_rawDescGZIP(), []int{4, 0}
}

// The state of a [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion],
// indicating if it can be used.
type CryptoKeyVersion_CryptoKeyVersionState int32

const (
	// Not specified.
	CryptoKeyVersion_CRYPTO_KEY_VERSION_STATE_UNSPECIFIED CryptoKeyVersion_CryptoKeyVersionState = 0
	// This version is still being generated. It may not be used, enabled,
	// disabled, or destroyed yet. Cloud KMS will automatically mark this
	// version
	// [ENABLED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.ENABLED]
	// as soon as the version is ready.
	CryptoKeyVersion_PENDING_GENERATION CryptoKeyVersion_CryptoKeyVersionState = 5
	// This version may be used for cryptographic operations.
	CryptoKeyVersion_ENABLED CryptoKeyVersion_CryptoKeyVersionState = 1
	// This version may not be used, but the key material is still available,
	// and the version can be placed back into the
	// [ENABLED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.ENABLED]
	// state.
	CryptoKeyVersion_DISABLED CryptoKeyVersion_CryptoKeyVersionState = 2
	// This version is destroyed, and the key material is no longer stored.
	// This version may only become
	// [ENABLED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.ENABLED]
	// again if this version is
	// [reimport_eligible][google.cloud.kms.v1.CryptoKeyVersion.reimport_eligible]
	// and the original key material is reimported with a call to
	// [KeyManagementService.ImportCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.ImportCryptoKeyVersion].
	CryptoKeyVersion_DESTROYED CryptoKeyVersion_CryptoKeyVersionState = 3
	// This version is scheduled for destruction, and will be destroyed soon.
	// Call
	// [RestoreCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.RestoreCryptoKeyVersion]
	// to put it back into the
	// [DISABLED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DISABLED]
	// state.
	CryptoKeyVersion_DESTROY_SCHEDULED CryptoKeyVersion_CryptoKeyVersionState = 4
	// This version is still being imported. It may not be used, enabled,
	// disabled, or destroyed yet. Cloud KMS will automatically mark this
	// version
	// [ENABLED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.ENABLED]
	// as soon as the version is ready.
	CryptoKeyVersion_PENDING_IMPORT CryptoKeyVersion_CryptoKeyVersionState = 6
	// This version was not imported successfully. It may not be used, enabled,
	// disabled, or destroyed. The submitted key material has been discarded.
	// Additional details can be found in
	// [CryptoKeyVersion.import_failure_reason][google.cloud.kms.v1.CryptoKeyVersion.import_failure_reason].
	CryptoKeyVersion_IMPORT_FAILED CryptoKeyVersion_CryptoKeyVersionState = 7
	// This version was not generated successfully. It may not be used, enabled,
	// disabled, or destroyed. Additional details can be found in
	// [CryptoKeyVersion.generation_failure_reason][google.cloud.kms.v1.CryptoKeyVersion.generation_failure_reason].
	CryptoKeyVersion_GENERATION_FAILED CryptoKeyVersion_CryptoKeyVersionState = 8
	// This version was destroyed, and it may not be used or enabled again.
	// Cloud KMS is waiting for the corresponding key material residing in an
	// external key manager to be destroyed.
	CryptoKeyVersion_PENDING_EXTERNAL_DESTRUCTION CryptoKeyVersion_CryptoKeyVersionState = 9
	// This version was destroyed, and it may not be used or enabled again.
	// However, Cloud KMS could not confirm that the corresponding key material
	// residing in an external key manager was destroyed. Additional details can
	// be found in
	// [CryptoKeyVersion.external_destruction_failure_reason][google.cloud.kms.v1.CryptoKeyVersion.external_destruction_failure_reason].
	CryptoKeyVersion_EXTERNAL_DESTRUCTION_FAILED CryptoKeyVersion_CryptoKeyVersionState = 10
)

// Enum value maps for CryptoKeyVersion_CryptoKeyVersionState.
var (
	CryptoKeyVersion_CryptoKeyVersionState_name = map[int32]string{
		0:  "CRYPTO_KEY_VERSION_STATE_UNSPECIFIED",
		5:  "PENDING_GENERATION",
		1:  "ENABLED",
		2:  "DISABLED",
		3:  "DESTROYED",
		4:  "DESTROY_SCHEDULED",
		6:  "PENDING_IMPORT",
		7:  "IMPORT_FAILED",
		8:  "GENERATION_FAILED",
		9:  "PENDING_EXTERNAL_DESTRUCTION",
		10: "EXTERNAL_DESTRUCTION_FAILED",
	}
	CryptoKeyVersion_CryptoKeyVersionState_value = map[string]int32{
		"CRYPTO_KEY_VERSION_STATE_UNSPECIFIED": 0,
		"PENDING_GENERATION":                   5,
		"ENABLED":                              1,
		"DISABLED":                             2,
		"DESTROYED":                            3,
		"DESTROY_SCHEDULED":                    4,
		"PENDING_IMPORT":                       6,
		"IMPORT_FAILED":                        7,
		"GENERATION_FAILED":                    8,
		"PENDING_EXTERNAL_DESTRUCTION":         9,
		"EXTERNAL_DESTRUCTION_FAILED":          10,
	}
)

func (x CryptoKeyVersion_CryptoKeyVersionState) Enum() *CryptoKeyVersion_CryptoKeyVersionState {
	p := new(CryptoKeyVersion_CryptoKeyVersionState)
	*p = x
	return p
}

func (x CryptoKeyVersion_CryptoKeyVersionState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CryptoKeyVersion_CryptoKeyVersionState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_kms_v1_resources_proto_enumTypes[5].Descriptor()
}

func (CryptoKeyVersion_CryptoKeyVersionState) Type() protoreflect.EnumType {
	return &file_google_cloud_kms_v1_resources_proto_enumTypes[5]
}

func (x CryptoKeyVersion_CryptoKeyVersionState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CryptoKeyVersion_CryptoKeyVersionState.Descriptor instead.
func (CryptoKeyVersion_CryptoKeyVersionState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_kms_v1_resources_proto_rawDescGZIP(), []int{4, 1}
}

// A view for [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]s.
// Controls the level of detail returned for
// [CryptoKeyVersions][google.cloud.kms.v1.CryptoKeyVersion] in
// [KeyManagementService.ListCryptoKeyVersions][google.cloud.kms.v1.KeyManagementService.ListCryptoKeyVersions]
// and
// [KeyManagementService.ListCryptoKeys][google.cloud.kms.v1.KeyManagementService.ListCryptoKeys].
type CryptoKeyVersion_CryptoKeyVersionView int32

const (
	// Default view for each
	// [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]. Does not
	// include the
	// [attestation][google.cloud.kms.v1.CryptoKeyVersion.attestation] field.
	CryptoKeyVersion_CRYPTO_KEY_VERSION_VIEW_UNSPECIFIED CryptoKeyVersion_CryptoKeyVersionView = 0
	// Provides all fields in each
	// [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion], including the
	// [attestation][google.cloud.kms.v1.CryptoKeyVersion.attestation].
	CryptoKeyVersion_FULL CryptoKeyVersion_CryptoKeyVersionView = 1
)

// Enum value maps for CryptoKeyVersion_CryptoKeyVersionView.
var (
	CryptoKeyVersion_CryptoKeyVersionView_name = map[int32]string{
		0: "CRYPTO_KEY_VERSION_VIEW_UNSPECIFIED",
		1: "FULL",
	}
	CryptoKeyVersion_CryptoKeyVersionView_value = map[string]int32{
		"CRYPTO_KEY_VERSION_VIEW_UNSPECIFIED": 0,
		"FULL":                                1,
	}
)

func (x CryptoKeyVersion_CryptoKeyVersionView) Enum() *CryptoKeyVersion_CryptoKeyVersionView {
	p := new(CryptoKeyVersion_CryptoKeyVersionView)
	*p = x
	return p
}

func (x CryptoKeyVersion_CryptoKeyVersionView) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CryptoKeyVersion_CryptoKeyVersionView) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_kms_v1_resources_proto_enumTypes[6].Descriptor()
}

func (CryptoKeyVersion_CryptoKeyVersionView) Type() protoreflect.EnumType {
	return &file_google_cloud_kms_v1_resources_proto_enumTypes[6]
}

func (x CryptoKeyVersion_CryptoKeyVersionView) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CryptoKeyVersion_CryptoKeyVersionView.Descriptor instead.
func (CryptoKeyVersion_CryptoKeyVersionView) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_kms_v1_resources_proto_rawDescGZIP(), []int{4, 2}
}

// [ImportMethod][google.cloud.kms.v1.ImportJob.ImportMethod] describes the
// key wrapping method chosen for this
// [ImportJob][google.cloud.kms.v1.ImportJob].
type ImportJob_ImportMethod int32

const (
	// Not specified.
	ImportJob_IMPORT_METHOD_UNSPECIFIED ImportJob_ImportMethod = 0
	// This ImportMethod represents the CKM_RSA_AES_KEY_WRAP key wrapping
	// scheme defined in the PKCS #11 standard. In summary, this involves
	// wrapping the raw key with an ephemeral AES key, and wrapping the
	// ephemeral AES key with a 3072 bit RSA key. For more details, see
	// [RSA AES key wrap
	// mechanism](http://docs.oasis-open.org/pkcs11/pkcs11-curr/v2.40/cos01/pkcs11-curr-v2.40-cos01.html#_Toc408226908).
	ImportJob_RSA_OAEP_3072_SHA1_AES_256 ImportJob_ImportMethod = 1
	// This ImportMethod represents the CKM_RSA_AES_KEY_WRAP key wrapping
	// scheme defined in the PKCS #11 standard. In summary, this involves
	// wrapping the raw key with an ephemeral AES key, and wrapping the
	// ephemeral AES key with a 4096 bit RSA key. For more details, see
	// [RSA AES key wrap
	// mechanism](http://docs.oasis-open.org/pkcs11/pkcs11-curr/v2.40/cos01/pkcs11-curr-v2.40-cos01.html#_Toc408226908).
	ImportJob_RSA_OAEP_4096_SHA1_AES_256 ImportJob_ImportMethod = 2
	// This ImportMethod represents the CKM_RSA_AES_KEY_WRAP key wrapping
	// scheme defined in the PKCS #11 standard. In summary, this involves
	// wrapping the raw key with an ephemeral AES key, and wrapping the
	// ephemeral AES key with a 3072 bit RSA key. For more details, see
	// [RSA AES key wrap
	// mechanism](http://docs.oasis-open.org/pkcs11/pkcs11-curr/v2.40/cos01/pkcs11-curr-v2.40-cos01.html#_Toc408226908).
	ImportJob_RSA_OAEP_3072_SHA256_AES_256 ImportJob_ImportMethod = 3
	// This ImportMethod represents the CKM_RSA_AES_KEY_WRAP key wrapping
	// scheme defined in the PKCS #11 standard. In summary, this involves
	// wrapping the raw key with an ephemeral AES key, and wrapping the
	// ephemeral AES key with a 4096 bit RSA key. For more details, see
	// [RSA AES key wrap
	// mechanism](http://docs.oasis-open.org/pkcs11/pkcs11-curr/v2.40/cos01/pkcs11-curr-v2.40-cos01.html#_Toc408226908).
	ImportJob_RSA_OAEP_4096_SHA256_AES_256 ImportJob_ImportMethod = 4
	// This ImportMethod represents RSAES-OAEP with a 3072 bit RSA key. The
	// key material to be imported is wrapped directly with the RSA key. Due
	// to technical limitations of RSA wrapping, this method cannot be used to
	// wrap RSA keys for import.
	ImportJob_RSA_OAEP_3072_SHA256 ImportJob_ImportMethod = 5
	// This ImportMethod represents RSAES-OAEP with a 4096 bit RSA key. The
	// key material to be imported is wrapped directly with the RSA key. Due
	// to technical limitations of RSA wrapping, this method cannot be used to
	// wrap RSA keys for import.
	ImportJob_RSA_OAEP_4096_SHA256 ImportJob_ImportMethod = 6
)

// Enum value maps for ImportJob_ImportMethod.
var (
	ImportJob_ImportMethod_name = map[int32]string{
		0: "IMPORT_METHOD_UNSPECIFIED",
		1: "RSA_OAEP_3072_SHA1_AES_256",
		2: "RSA_OAEP_4096_SHA1_AES_256",
		3: "RSA_OAEP_3072_SHA256_AES_256",
		4: "RSA_OAEP_4096_SHA256_AES_256",
		5: "RSA_OAEP_3072_SHA256",
		6: "RSA_OAEP_4096_SHA256",
	}
	ImportJob_ImportMethod_value = map[string]int32{
		"IMPORT_METHOD_UNSPECIFIED":    0,
		"RSA_OAEP_3072_SHA1_AES_256":   1,
		"RSA_OAEP_4096_SHA1_AES_256":   2,
		"RSA_OAEP_3072_SHA256_AES_256": 3,
		"RSA_OAEP_4096_SHA256_AES_256": 4,
		"RSA_OAEP_3072_SHA256":         5,
		"RSA_OAEP_4096_SHA256":         6,
	}
)

func (x ImportJob_ImportMethod) Enum() *ImportJob_ImportMethod {
	p := new(ImportJob_ImportMethod)
	*p = x
	return p
}

func (x ImportJob_ImportMethod) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ImportJob_ImportMethod) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_kms_v1_resources_proto_enumTypes[7].Descriptor()
}

func (ImportJob_ImportMethod) Type() protoreflect.EnumType {
	return &file_google_cloud_kms_v1_resources_proto_enumTypes[7]
}

func (x ImportJob_ImportMethod) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ImportJob_ImportMethod.Descriptor instead.
func (ImportJob_ImportMethod) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_kms_v1_resources_proto_rawDescGZIP(), []int{6, 0}
}

// The state of the [ImportJob][google.cloud.kms.v1.ImportJob], indicating if
// it can be used.
type ImportJob_ImportJobState int32

const (
	// Not specified.
	ImportJob_IMPORT_JOB_STATE_UNSPECIFIED ImportJob_ImportJobState = 0
	// The wrapping key for this job is still being generated. It may not be
	// used. Cloud KMS will automatically mark this job as
	// [ACTIVE][google.cloud.kms.v1.ImportJob.ImportJobState.ACTIVE] as soon as
	// the wrapping key is generated.
	ImportJob_PENDING_GENERATION ImportJob_ImportJobState = 1
	// This job may be used in
	// [CreateCryptoKey][google.cloud.kms.v1.KeyManagementService.CreateCryptoKey]
	// and
	// [CreateCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.CreateCryptoKeyVersion]
	// requests.
	ImportJob_ACTIVE ImportJob_ImportJobState = 2
	// This job can no longer be used and may not leave this state once entered.
	ImportJob_EXPIRED ImportJob_ImportJobState = 3
)

// Enum value maps for ImportJob_ImportJobState.
var (
	ImportJob_ImportJobState_name = map[int32]string{
		0: "IMPORT_JOB_STATE_UNSPECIFIED",
		1: "PENDING_GENERATION",
		2: "ACTIVE",
		3: "EXPIRED",
	}
	ImportJob_ImportJobState_value = map[string]int32{
		"IMPORT_JOB_STATE_UNSPECIFIED": 0,
		"PENDING_GENERATION":           1,
		"ACTIVE":                       2,
		"EXPIRED":                      3,
	}
)

func (x ImportJob_ImportJobState) Enum() *ImportJob_ImportJobState {
	p := new(ImportJob_ImportJobState)
	*p = x
	return p
}

func (x ImportJob_ImportJobState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ImportJob_ImportJobState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_kms_v1_resources_proto_enumTypes[8].Descriptor()
}

func (ImportJob_ImportJobState) Type() protoreflect.EnumType {
	return &file_google_cloud_kms_v1_resources_proto_enumTypes[8]
}

func (x ImportJob_ImportJobState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ImportJob_ImportJobState.Descriptor instead.
func (ImportJob_ImportJobState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_kms_v1_resources_proto_rawDescGZIP(), []int{6, 1}
}

// A [KeyRing][google.cloud.kms.v1.KeyRing] is a toplevel logical grouping of
// [CryptoKeys][google.cloud.kms.v1.CryptoKey].
type KeyRing struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name for the
	// [KeyRing][google.cloud.kms.v1.KeyRing] in the format
	// `projects/*/locations/*/keyRings/*`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The time at which this [KeyRing][google.cloud.kms.v1.KeyRing]
	// was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
}

func (x *KeyRing) Reset() {
	*x = KeyRing{}
	mi := &file_google_cloud_kms_v1_resources_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *KeyRing) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KeyRing) ProtoMessage() {}

func (x *KeyRing) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_kms_v1_resources_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KeyRing.ProtoReflect.Descriptor instead.
func (*KeyRing) Descriptor() ([]byte, []int) {
	return file_google_cloud_kms_v1_resources_proto_rawDescGZIP(), []int{0}
}

func (x *KeyRing) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *KeyRing) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

// A [CryptoKey][google.cloud.kms.v1.CryptoKey] represents a logical key that
// can be used for cryptographic operations.
//
// A [CryptoKey][google.cloud.kms.v1.CryptoKey] is made up of zero or more
// [versions][google.cloud.kms.v1.CryptoKeyVersion], which represent the actual
// key material used in cryptographic operations.
type CryptoKey struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name for this
	// [CryptoKey][google.cloud.kms.v1.CryptoKey] in the format
	// `projects/*/locations/*/keyRings/*/cryptoKeys/*`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. A copy of the "primary"
	// [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] that will be used
	// by [Encrypt][google.cloud.kms.v1.KeyManagementService.Encrypt] when this
	// [CryptoKey][google.cloud.kms.v1.CryptoKey] is given in
	// [EncryptRequest.name][google.cloud.kms.v1.EncryptRequest.name].
	//
	// The [CryptoKey][google.cloud.kms.v1.CryptoKey]'s primary version can be
	// updated via
	// [UpdateCryptoKeyPrimaryVersion][google.cloud.kms.v1.KeyManagementService.UpdateCryptoKeyPrimaryVersion].
	//
	// Keys with [purpose][google.cloud.kms.v1.CryptoKey.purpose]
	// [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT]
	// may have a primary. For other keys, this field will be omitted.
	Primary *CryptoKeyVersion `protobuf:"bytes,2,opt,name=primary,proto3" json:"primary,omitempty"`
	// Immutable. The immutable purpose of this
	// [CryptoKey][google.cloud.kms.v1.CryptoKey].
	Purpose CryptoKey_CryptoKeyPurpose `protobuf:"varint,3,opt,name=purpose,proto3,enum=google.cloud.kms.v1.CryptoKey_CryptoKeyPurpose" json:"purpose,omitempty"`
	// Output only. The time at which this
	// [CryptoKey][google.cloud.kms.v1.CryptoKey] was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// At [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time],
	// the Key Management Service will automatically:
	//
	// 1. Create a new version of this [CryptoKey][google.cloud.kms.v1.CryptoKey].
	// 2. Mark the new version as primary.
	//
	// Key rotations performed manually via
	// [CreateCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.CreateCryptoKeyVersion]
	// and
	// [UpdateCryptoKeyPrimaryVersion][google.cloud.kms.v1.KeyManagementService.UpdateCryptoKeyPrimaryVersion]
	// do not affect
	// [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time].
	//
	// Keys with [purpose][google.cloud.kms.v1.CryptoKey.purpose]
	// [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT]
	// support automatic rotation. For other keys, this field must be omitted.
	NextRotationTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=next_rotation_time,json=nextRotationTime,proto3" json:"next_rotation_time,omitempty"`
	// Controls the rate of automatic rotation.
	//
	// Types that are assignable to RotationSchedule:
	//
	//	*CryptoKey_RotationPeriod
	RotationSchedule isCryptoKey_RotationSchedule `protobuf_oneof:"rotation_schedule"`
	// A template describing settings for new
	// [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] instances. The
	// properties of new [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]
	// instances created by either
	// [CreateCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.CreateCryptoKeyVersion]
	// or auto-rotation are controlled by this template.
	VersionTemplate *CryptoKeyVersionTemplate `protobuf:"bytes,11,opt,name=version_template,json=versionTemplate,proto3" json:"version_template,omitempty"`
	// Labels with user-defined metadata. For more information, see
	// [Labeling Keys](https://cloud.google.com/kms/docs/labeling-keys).
	Labels map[string]string `protobuf:"bytes,10,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Immutable. Whether this key may contain imported versions only.
	ImportOnly bool `protobuf:"varint,13,opt,name=import_only,json=importOnly,proto3" json:"import_only,omitempty"`
	// Immutable. The period of time that versions of this key spend in the
	// [DESTROY_SCHEDULED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROY_SCHEDULED]
	// state before transitioning to
	// [DESTROYED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROYED].
	// If not specified at creation time, the default duration is 30 days.
	DestroyScheduledDuration *durationpb.Duration `protobuf:"bytes,14,opt,name=destroy_scheduled_duration,json=destroyScheduledDuration,proto3" json:"destroy_scheduled_duration,omitempty"`
	// Immutable. The resource name of the backend environment where the key
	// material for all [CryptoKeyVersions][google.cloud.kms.v1.CryptoKeyVersion]
	// associated with this [CryptoKey][google.cloud.kms.v1.CryptoKey] reside and
	// where all related cryptographic operations are performed. Only applicable
	// if [CryptoKeyVersions][google.cloud.kms.v1.CryptoKeyVersion] have a
	// [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel] of
	// [EXTERNAL_VPC][google.cloud.kms.v1.ProtectionLevel.EXTERNAL_VPC], with the
	// resource name in the format `projects/*/locations/*/ekmConnections/*`.
	// Note, this list is non-exhaustive and may apply to additional
	// [ProtectionLevels][google.cloud.kms.v1.ProtectionLevel] in the future.
	CryptoKeyBackend string `protobuf:"bytes,15,opt,name=crypto_key_backend,json=cryptoKeyBackend,proto3" json:"crypto_key_backend,omitempty"`
	// Optional. The policy used for Key Access Justifications Policy Enforcement.
	// If this field is present and this key is enrolled in Key Access
	// Justifications Policy Enforcement, the policy will be evaluated in encrypt,
	// decrypt, and sign operations, and the operation will fail if rejected by
	// the policy. The policy is defined by specifying zero or more allowed
	// justification codes.
	// https://cloud.google.com/assured-workloads/key-access-justifications/docs/justification-codes
	// By default, this field is absent, and all justification codes are allowed.
	KeyAccessJustificationsPolicy *KeyAccessJustificationsPolicy `protobuf:"bytes,17,opt,name=key_access_justifications_policy,json=keyAccessJustificationsPolicy,proto3" json:"key_access_justifications_policy,omitempty"`
}

func (x *CryptoKey) Reset() {
	*x = CryptoKey{}
	mi := &file_google_cloud_kms_v1_resources_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CryptoKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CryptoKey) ProtoMessage() {}

func (x *CryptoKey) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_kms_v1_resources_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CryptoKey.ProtoReflect.Descriptor instead.
func (*CryptoKey) Descriptor() ([]byte, []int) {
	return file_google_cloud_kms_v1_resources_proto_rawDescGZIP(), []int{1}
}

func (x *CryptoKey) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CryptoKey) GetPrimary() *CryptoKeyVersion {
	if x != nil {
		return x.Primary
	}
	return nil
}

func (x *CryptoKey) GetPurpose() CryptoKey_CryptoKeyPurpose {
	if x != nil {
		return x.Purpose
	}
	return CryptoKey_CRYPTO_KEY_PURPOSE_UNSPECIFIED
}

func (x *CryptoKey) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *CryptoKey) GetNextRotationTime() *timestamppb.Timestamp {
	if x != nil {
		return x.NextRotationTime
	}
	return nil
}

func (m *CryptoKey) GetRotationSchedule() isCryptoKey_RotationSchedule {
	if m != nil {
		return m.RotationSchedule
	}
	return nil
}

func (x *CryptoKey) GetRotationPeriod() *durationpb.Duration {
	if x, ok := x.GetRotationSchedule().(*CryptoKey_RotationPeriod); ok {
		return x.RotationPeriod
	}
	return nil
}

func (x *CryptoKey) GetVersionTemplate() *CryptoKeyVersionTemplate {
	if x != nil {
		return x.VersionTemplate
	}
	return nil
}

func (x *CryptoKey) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *CryptoKey) GetImportOnly() bool {
	if x != nil {
		return x.ImportOnly
	}
	return false
}

func (x *CryptoKey) GetDestroyScheduledDuration() *durationpb.Duration {
	if x != nil {
		return x.DestroyScheduledDuration
	}
	return nil
}

func (x *CryptoKey) GetCryptoKeyBackend() string {
	if x != nil {
		return x.CryptoKeyBackend
	}
	return ""
}

func (x *CryptoKey) GetKeyAccessJustificationsPolicy() *KeyAccessJustificationsPolicy {
	if x != nil {
		return x.KeyAccessJustificationsPolicy
	}
	return nil
}

type isCryptoKey_RotationSchedule interface {
	isCryptoKey_RotationSchedule()
}

type CryptoKey_RotationPeriod struct {
	// [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time]
	// will be advanced by this period when the service automatically rotates a
	// key. Must be at least 24 hours and at most 876,000 hours.
	//
	// If [rotation_period][google.cloud.kms.v1.CryptoKey.rotation_period] is
	// set,
	// [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time]
	// must also be set.
	//
	// Keys with [purpose][google.cloud.kms.v1.CryptoKey.purpose]
	// [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT]
	// support automatic rotation. For other keys, this field must be omitted.
	RotationPeriod *durationpb.Duration `protobuf:"bytes,8,opt,name=rotation_period,json=rotationPeriod,proto3,oneof"`
}

func (*CryptoKey_RotationPeriod) isCryptoKey_RotationSchedule() {}

// A [CryptoKeyVersionTemplate][google.cloud.kms.v1.CryptoKeyVersionTemplate]
// specifies the properties to use when creating a new
// [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion], either manually
// with
// [CreateCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.CreateCryptoKeyVersion]
// or automatically as a result of auto-rotation.
type CryptoKeyVersionTemplate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel] to use when creating
	// a [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] based on this
	// template. Immutable. Defaults to
	// [SOFTWARE][google.cloud.kms.v1.ProtectionLevel.SOFTWARE].
	ProtectionLevel ProtectionLevel `protobuf:"varint,1,opt,name=protection_level,json=protectionLevel,proto3,enum=google.cloud.kms.v1.ProtectionLevel" json:"protection_level,omitempty"`
	// Required.
	// [Algorithm][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm]
	// to use when creating a
	// [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] based on this
	// template.
	//
	// For backwards compatibility, GOOGLE_SYMMETRIC_ENCRYPTION is implied if both
	// this field is omitted and
	// [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose] is
	// [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT].
	Algorithm CryptoKeyVersion_CryptoKeyVersionAlgorithm `protobuf:"varint,3,opt,name=algorithm,proto3,enum=google.cloud.kms.v1.CryptoKeyVersion_CryptoKeyVersionAlgorithm" json:"algorithm,omitempty"`
}

func (x *CryptoKeyVersionTemplate) Reset() {
	*x = CryptoKeyVersionTemplate{}
	mi := &file_google_cloud_kms_v1_resources_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CryptoKeyVersionTemplate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CryptoKeyVersionTemplate) ProtoMessage() {}

func (x *CryptoKeyVersionTemplate) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_kms_v1_resources_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CryptoKeyVersionTemplate.ProtoReflect.Descriptor instead.
func (*CryptoKeyVersionTemplate) Descriptor() ([]byte, []int) {
	return file_google_cloud_kms_v1_resources_proto_rawDescGZIP(), []int{2}
}

func (x *CryptoKeyVersionTemplate) GetProtectionLevel() ProtectionLevel {
	if x != nil {
		return x.ProtectionLevel
	}
	return ProtectionLevel_PROTECTION_LEVEL_UNSPECIFIED
}

func (x *CryptoKeyVersionTemplate) GetAlgorithm() CryptoKeyVersion_CryptoKeyVersionAlgorithm {
	if x != nil {
		return x.Algorithm
	}
	return CryptoKeyVersion_CRYPTO_KEY_VERSION_ALGORITHM_UNSPECIFIED
}

// Contains an HSM-generated attestation about a key operation. For more
// information, see [Verifying attestations]
// (https://cloud.google.com/kms/docs/attest-key).
type KeyOperationAttestation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The format of the attestation data.
	Format KeyOperationAttestation_AttestationFormat `protobuf:"varint,4,opt,name=format,proto3,enum=google.cloud.kms.v1.KeyOperationAttestation_AttestationFormat" json:"format,omitempty"`
	// Output only. The attestation data provided by the HSM when the key
	// operation was performed.
	Content []byte `protobuf:"bytes,5,opt,name=content,proto3" json:"content,omitempty"`
	// Output only. The certificate chains needed to validate the attestation
	CertChains *KeyOperationAttestation_CertificateChains `protobuf:"bytes,6,opt,name=cert_chains,json=certChains,proto3" json:"cert_chains,omitempty"`
}

func (x *KeyOperationAttestation) Reset() {
	*x = KeyOperationAttestation{}
	mi := &file_google_cloud_kms_v1_resources_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *KeyOperationAttestation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KeyOperationAttestation) ProtoMessage() {}

func (x *KeyOperationAttestation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_kms_v1_resources_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KeyOperationAttestation.ProtoReflect.Descriptor instead.
func (*KeyOperationAttestation) Descriptor() ([]byte, []int) {
	return file_google_cloud_kms_v1_resources_proto_rawDescGZIP(), []int{3}
}

func (x *KeyOperationAttestation) GetFormat() KeyOperationAttestation_AttestationFormat {
	if x != nil {
		return x.Format
	}
	return KeyOperationAttestation_ATTESTATION_FORMAT_UNSPECIFIED
}

func (x *KeyOperationAttestation) GetContent() []byte {
	if x != nil {
		return x.Content
	}
	return nil
}

func (x *KeyOperationAttestation) GetCertChains() *KeyOperationAttestation_CertificateChains {
	if x != nil {
		return x.CertChains
	}
	return nil
}

// A [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] represents an
// individual cryptographic key, and the associated key material.
//
// An
// [ENABLED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.ENABLED]
// version can be used for cryptographic operations.
//
// For security reasons, the raw cryptographic key material represented by a
// [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] can never be viewed
// or exported. It can only be used to encrypt, decrypt, or sign data when an
// authorized user or application invokes Cloud KMS.
type CryptoKeyVersion struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name for this
	// [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] in the format
	// `projects/*/locations/*/keyRings/*/cryptoKeys/*/cryptoKeyVersions/*`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The current state of the
	// [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion].
	State CryptoKeyVersion_CryptoKeyVersionState `protobuf:"varint,3,opt,name=state,proto3,enum=google.cloud.kms.v1.CryptoKeyVersion_CryptoKeyVersionState" json:"state,omitempty"`
	// Output only. The [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel]
	// describing how crypto operations are performed with this
	// [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion].
	ProtectionLevel ProtectionLevel `protobuf:"varint,7,opt,name=protection_level,json=protectionLevel,proto3,enum=google.cloud.kms.v1.ProtectionLevel" json:"protection_level,omitempty"`
	// Output only. The
	// [CryptoKeyVersionAlgorithm][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm]
	// that this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]
	// supports.
	Algorithm CryptoKeyVersion_CryptoKeyVersionAlgorithm `protobuf:"varint,10,opt,name=algorithm,proto3,enum=google.cloud.kms.v1.CryptoKeyVersion_CryptoKeyVersionAlgorithm" json:"algorithm,omitempty"`
	// Output only. Statement that was generated and signed by the HSM at key
	// creation time. Use this statement to verify attributes of the key as stored
	// on the HSM, independently of Google. Only provided for key versions with
	// [protection_level][google.cloud.kms.v1.CryptoKeyVersion.protection_level]
	// [HSM][google.cloud.kms.v1.ProtectionLevel.HSM].
	Attestation *KeyOperationAttestation `protobuf:"bytes,8,opt,name=attestation,proto3" json:"attestation,omitempty"`
	// Output only. The time at which this
	// [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time this
	// [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s key material was
	// generated.
	GenerateTime *timestamppb.Timestamp `protobuf:"bytes,11,opt,name=generate_time,json=generateTime,proto3" json:"generate_time,omitempty"`
	// Output only. The time this
	// [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s key material is
	// scheduled for destruction. Only present if
	// [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
	// [DESTROY_SCHEDULED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROY_SCHEDULED].
	DestroyTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=destroy_time,json=destroyTime,proto3" json:"destroy_time,omitempty"`
	// Output only. The time this CryptoKeyVersion's key material was
	// destroyed. Only present if
	// [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
	// [DESTROYED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROYED].
	DestroyEventTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=destroy_event_time,json=destroyEventTime,proto3" json:"destroy_event_time,omitempty"`
	// Output only. The name of the [ImportJob][google.cloud.kms.v1.ImportJob]
	// used in the most recent import of this
	// [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]. Only present if
	// the underlying key material was imported.
	ImportJob string `protobuf:"bytes,14,opt,name=import_job,json=importJob,proto3" json:"import_job,omitempty"`
	// Output only. The time at which this
	// [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s key material was
	// most recently imported.
	ImportTime *timestamppb.Timestamp `protobuf:"bytes,15,opt,name=import_time,json=importTime,proto3" json:"import_time,omitempty"`
	// Output only. The root cause of the most recent import failure. Only present
	// if [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
	// [IMPORT_FAILED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.IMPORT_FAILED].
	ImportFailureReason string `protobuf:"bytes,16,opt,name=import_failure_reason,json=importFailureReason,proto3" json:"import_failure_reason,omitempty"`
	// Output only. The root cause of the most recent generation failure. Only
	// present if [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
	// [GENERATION_FAILED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.GENERATION_FAILED].
	GenerationFailureReason string `protobuf:"bytes,19,opt,name=generation_failure_reason,json=generationFailureReason,proto3" json:"generation_failure_reason,omitempty"`
	// Output only. The root cause of the most recent external destruction
	// failure. Only present if
	// [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
	// [EXTERNAL_DESTRUCTION_FAILED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.EXTERNAL_DESTRUCTION_FAILED].
	ExternalDestructionFailureReason string `protobuf:"bytes,20,opt,name=external_destruction_failure_reason,json=externalDestructionFailureReason,proto3" json:"external_destruction_failure_reason,omitempty"`
	// ExternalProtectionLevelOptions stores a group of additional fields for
	// configuring a [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] that
	// are specific to the
	// [EXTERNAL][google.cloud.kms.v1.ProtectionLevel.EXTERNAL] protection level
	// and [EXTERNAL_VPC][google.cloud.kms.v1.ProtectionLevel.EXTERNAL_VPC]
	// protection levels.
	ExternalProtectionLevelOptions *ExternalProtectionLevelOptions `protobuf:"bytes,17,opt,name=external_protection_level_options,json=externalProtectionLevelOptions,proto3" json:"external_protection_level_options,omitempty"`
	// Output only. Whether or not this key version is eligible for reimport, by
	// being specified as a target in
	// [ImportCryptoKeyVersionRequest.crypto_key_version][google.cloud.kms.v1.ImportCryptoKeyVersionRequest.crypto_key_version].
	ReimportEligible bool `protobuf:"varint,18,opt,name=reimport_eligible,json=reimportEligible,proto3" json:"reimport_eligible,omitempty"`
}

func (x *CryptoKeyVersion) Reset() {
	*x = CryptoKeyVersion{}
	mi := &file_google_cloud_kms_v1_resources_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CryptoKeyVersion) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CryptoKeyVersion) ProtoMessage() {}

func (x *CryptoKeyVersion) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_kms_v1_resources_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CryptoKeyVersion.ProtoReflect.Descriptor instead.
func (*CryptoKeyVersion) Descriptor() ([]byte, []int) {
	return file_google_cloud_kms_v1_resources_proto_rawDescGZIP(), []int{4}
}

func (x *CryptoKeyVersion) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CryptoKeyVersion) GetState() CryptoKeyVersion_CryptoKeyVersionState {
	if x != nil {
		return x.State
	}
	return CryptoKeyVersion_CRYPTO_KEY_VERSION_STATE_UNSPECIFIED
}

func (x *CryptoKeyVersion) GetProtectionLevel() ProtectionLevel {
	if x != nil {
		return x.ProtectionLevel
	}
	return ProtectionLevel_PROTECTION_LEVEL_UNSPECIFIED
}

func (x *CryptoKeyVersion) GetAlgorithm() CryptoKeyVersion_CryptoKeyVersionAlgorithm {
	if x != nil {
		return x.Algorithm
	}
	return CryptoKeyVersion_CRYPTO_KEY_VERSION_ALGORITHM_UNSPECIFIED
}

func (x *CryptoKeyVersion) GetAttestation() *KeyOperationAttestation {
	if x != nil {
		return x.Attestation
	}
	return nil
}

func (x *CryptoKeyVersion) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *CryptoKeyVersion) GetGenerateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.GenerateTime
	}
	return nil
}

func (x *CryptoKeyVersion) GetDestroyTime() *timestamppb.Timestamp {
	if x != nil {
		return x.DestroyTime
	}
	return nil
}

func (x *CryptoKeyVersion) GetDestroyEventTime() *timestamppb.Timestamp {
	if x != nil {
		return x.DestroyEventTime
	}
	return nil
}

func (x *CryptoKeyVersion) GetImportJob() string {
	if x != nil {
		return x.ImportJob
	}
	return ""
}

func (x *CryptoKeyVersion) GetImportTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ImportTime
	}
	return nil
}

func (x *CryptoKeyVersion) GetImportFailureReason() string {
	if x != nil {
		return x.ImportFailureReason
	}
	return ""
}

func (x *CryptoKeyVersion) GetGenerationFailureReason() string {
	if x != nil {
		return x.GenerationFailureReason
	}
	return ""
}

func (x *CryptoKeyVersion) GetExternalDestructionFailureReason() string {
	if x != nil {
		return x.ExternalDestructionFailureReason
	}
	return ""
}

func (x *CryptoKeyVersion) GetExternalProtectionLevelOptions() *ExternalProtectionLevelOptions {
	if x != nil {
		return x.ExternalProtectionLevelOptions
	}
	return nil
}

func (x *CryptoKeyVersion) GetReimportEligible() bool {
	if x != nil {
		return x.ReimportEligible
	}
	return false
}

// The public keys for a given
// [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]. Obtained via
// [GetPublicKey][google.cloud.kms.v1.KeyManagementService.GetPublicKey].
type PublicKey struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The public key, encoded in PEM format. For more information, see the
	// [RFC 7468](https://tools.ietf.org/html/rfc7468) sections for
	// [General Considerations](https://tools.ietf.org/html/rfc7468#section-2) and
	// [Textual Encoding of Subject Public Key Info]
	// (https://tools.ietf.org/html/rfc7468#section-13).
	Pem string `protobuf:"bytes,1,opt,name=pem,proto3" json:"pem,omitempty"`
	// The
	// [Algorithm][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm]
	// associated with this key.
	Algorithm CryptoKeyVersion_CryptoKeyVersionAlgorithm `protobuf:"varint,2,opt,name=algorithm,proto3,enum=google.cloud.kms.v1.CryptoKeyVersion_CryptoKeyVersionAlgorithm" json:"algorithm,omitempty"`
	// Integrity verification field. A CRC32C checksum of the returned
	// [PublicKey.pem][google.cloud.kms.v1.PublicKey.pem]. An integrity check of
	// [PublicKey.pem][google.cloud.kms.v1.PublicKey.pem] can be performed by
	// computing the CRC32C checksum of
	// [PublicKey.pem][google.cloud.kms.v1.PublicKey.pem] and comparing your
	// results to this field. Discard the response in case of non-matching
	// checksum values, and perform a limited number of retries. A persistent
	// mismatch may indicate an issue in your computation of the CRC32C checksum.
	// Note: This field is defined as int64 for reasons of compatibility across
	// different languages. However, it is a non-negative integer, which will
	// never exceed 2^32-1, and can be safely downconverted to uint32 in languages
	// that support this type.
	//
	// NOTE: This field is in Beta.
	PemCrc32C *wrapperspb.Int64Value `protobuf:"bytes,3,opt,name=pem_crc32c,json=pemCrc32c,proto3" json:"pem_crc32c,omitempty"`
	// The [name][google.cloud.kms.v1.CryptoKeyVersion.name] of the
	// [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] public key.
	// Provided here for verification.
	//
	// NOTE: This field is in Beta.
	Name string `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	// The [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel] of the
	// [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] public key.
	ProtectionLevel ProtectionLevel `protobuf:"varint,5,opt,name=protection_level,json=protectionLevel,proto3,enum=google.cloud.kms.v1.ProtectionLevel" json:"protection_level,omitempty"`
}

func (x *PublicKey) Reset() {
	*x = PublicKey{}
	mi := &file_google_cloud_kms_v1_resources_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PublicKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PublicKey) ProtoMessage() {}

func (x *PublicKey) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_kms_v1_resources_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PublicKey.ProtoReflect.Descriptor instead.
func (*PublicKey) Descriptor() ([]byte, []int) {
	return file_google_cloud_kms_v1_resources_proto_rawDescGZIP(), []int{5}
}

func (x *PublicKey) GetPem() string {
	if x != nil {
		return x.Pem
	}
	return ""
}

func (x *PublicKey) GetAlgorithm() CryptoKeyVersion_CryptoKeyVersionAlgorithm {
	if x != nil {
		return x.Algorithm
	}
	return CryptoKeyVersion_CRYPTO_KEY_VERSION_ALGORITHM_UNSPECIFIED
}

func (x *PublicKey) GetPemCrc32C() *wrapperspb.Int64Value {
	if x != nil {
		return x.PemCrc32C
	}
	return nil
}

func (x *PublicKey) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *PublicKey) GetProtectionLevel() ProtectionLevel {
	if x != nil {
		return x.ProtectionLevel
	}
	return ProtectionLevel_PROTECTION_LEVEL_UNSPECIFIED
}

// An [ImportJob][google.cloud.kms.v1.ImportJob] can be used to create
// [CryptoKeys][google.cloud.kms.v1.CryptoKey] and
// [CryptoKeyVersions][google.cloud.kms.v1.CryptoKeyVersion] using pre-existing
// key material, generated outside of Cloud KMS.
//
// When an [ImportJob][google.cloud.kms.v1.ImportJob] is created, Cloud KMS will
// generate a "wrapping key", which is a public/private key pair. You use the
// wrapping key to encrypt (also known as wrap) the pre-existing key material to
// protect it during the import process. The nature of the wrapping key depends
// on the choice of
// [import_method][google.cloud.kms.v1.ImportJob.import_method]. When the
// wrapping key generation is complete, the
// [state][google.cloud.kms.v1.ImportJob.state] will be set to
// [ACTIVE][google.cloud.kms.v1.ImportJob.ImportJobState.ACTIVE] and the
// [public_key][google.cloud.kms.v1.ImportJob.public_key] can be fetched. The
// fetched public key can then be used to wrap your pre-existing key material.
//
// Once the key material is wrapped, it can be imported into a new
// [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] in an existing
// [CryptoKey][google.cloud.kms.v1.CryptoKey] by calling
// [ImportCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.ImportCryptoKeyVersion].
// Multiple [CryptoKeyVersions][google.cloud.kms.v1.CryptoKeyVersion] can be
// imported with a single [ImportJob][google.cloud.kms.v1.ImportJob]. Cloud KMS
// uses the private key portion of the wrapping key to unwrap the key material.
// Only Cloud KMS has access to the private key.
//
// An [ImportJob][google.cloud.kms.v1.ImportJob] expires 3 days after it is
// created. Once expired, Cloud KMS will no longer be able to import or unwrap
// any key material that was wrapped with the
// [ImportJob][google.cloud.kms.v1.ImportJob]'s public key.
//
// For more information, see
// [Importing a key](https://cloud.google.com/kms/docs/importing-a-key).
type ImportJob struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name for this
	// [ImportJob][google.cloud.kms.v1.ImportJob] in the format
	// `projects/*/locations/*/keyRings/*/importJobs/*`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Immutable. The wrapping method to be used for incoming key
	// material.
	ImportMethod ImportJob_ImportMethod `protobuf:"varint,2,opt,name=import_method,json=importMethod,proto3,enum=google.cloud.kms.v1.ImportJob_ImportMethod" json:"import_method,omitempty"`
	// Required. Immutable. The protection level of the
	// [ImportJob][google.cloud.kms.v1.ImportJob]. This must match the
	// [protection_level][google.cloud.kms.v1.CryptoKeyVersionTemplate.protection_level]
	// of the [version_template][google.cloud.kms.v1.CryptoKey.version_template]
	// on the [CryptoKey][google.cloud.kms.v1.CryptoKey] you attempt to import
	// into.
	ProtectionLevel ProtectionLevel `protobuf:"varint,9,opt,name=protection_level,json=protectionLevel,proto3,enum=google.cloud.kms.v1.ProtectionLevel" json:"protection_level,omitempty"`
	// Output only. The time at which this
	// [ImportJob][google.cloud.kms.v1.ImportJob] was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time this [ImportJob][google.cloud.kms.v1.ImportJob]'s key
	// material was generated.
	GenerateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=generate_time,json=generateTime,proto3" json:"generate_time,omitempty"`
	// Output only. The time at which this
	// [ImportJob][google.cloud.kms.v1.ImportJob] is scheduled for expiration and
	// can no longer be used to import key material.
	ExpireTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=expire_time,json=expireTime,proto3" json:"expire_time,omitempty"`
	// Output only. The time this [ImportJob][google.cloud.kms.v1.ImportJob]
	// expired. Only present if [state][google.cloud.kms.v1.ImportJob.state] is
	// [EXPIRED][google.cloud.kms.v1.ImportJob.ImportJobState.EXPIRED].
	ExpireEventTime *timestamppb.Timestamp `protobuf:"bytes,10,opt,name=expire_event_time,json=expireEventTime,proto3" json:"expire_event_time,omitempty"`
	// Output only. The current state of the
	// [ImportJob][google.cloud.kms.v1.ImportJob], indicating if it can be used.
	State ImportJob_ImportJobState `protobuf:"varint,6,opt,name=state,proto3,enum=google.cloud.kms.v1.ImportJob_ImportJobState" json:"state,omitempty"`
	// Output only. The public key with which to wrap key material prior to
	// import. Only returned if [state][google.cloud.kms.v1.ImportJob.state] is
	// [ACTIVE][google.cloud.kms.v1.ImportJob.ImportJobState.ACTIVE].
	PublicKey *ImportJob_WrappingPublicKey `protobuf:"bytes,7,opt,name=public_key,json=publicKey,proto3" json:"public_key,omitempty"`
	// Output only. Statement that was generated and signed by the key creator
	// (for example, an HSM) at key creation time. Use this statement to verify
	// attributes of the key as stored on the HSM, independently of Google.
	// Only present if the chosen
	// [ImportMethod][google.cloud.kms.v1.ImportJob.ImportMethod] is one with a
	// protection level of [HSM][google.cloud.kms.v1.ProtectionLevel.HSM].
	Attestation *KeyOperationAttestation `protobuf:"bytes,8,opt,name=attestation,proto3" json:"attestation,omitempty"`
}

func (x *ImportJob) Reset() {
	*x = ImportJob{}
	mi := &file_google_cloud_kms_v1_resources_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImportJob) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportJob) ProtoMessage() {}

func (x *ImportJob) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_kms_v1_resources_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportJob.ProtoReflect.Descriptor instead.
func (*ImportJob) Descriptor() ([]byte, []int) {
	return file_google_cloud_kms_v1_resources_proto_rawDescGZIP(), []int{6}
}

func (x *ImportJob) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ImportJob) GetImportMethod() ImportJob_ImportMethod {
	if x != nil {
		return x.ImportMethod
	}
	return ImportJob_IMPORT_METHOD_UNSPECIFIED
}

func (x *ImportJob) GetProtectionLevel() ProtectionLevel {
	if x != nil {
		return x.ProtectionLevel
	}
	return ProtectionLevel_PROTECTION_LEVEL_UNSPECIFIED
}

func (x *ImportJob) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *ImportJob) GetGenerateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.GenerateTime
	}
	return nil
}

func (x *ImportJob) GetExpireTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ExpireTime
	}
	return nil
}

func (x *ImportJob) GetExpireEventTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ExpireEventTime
	}
	return nil
}

func (x *ImportJob) GetState() ImportJob_ImportJobState {
	if x != nil {
		return x.State
	}
	return ImportJob_IMPORT_JOB_STATE_UNSPECIFIED
}

func (x *ImportJob) GetPublicKey() *ImportJob_WrappingPublicKey {
	if x != nil {
		return x.PublicKey
	}
	return nil
}

func (x *ImportJob) GetAttestation() *KeyOperationAttestation {
	if x != nil {
		return x.Attestation
	}
	return nil
}

// ExternalProtectionLevelOptions stores a group of additional fields for
// configuring a [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] that
// are specific to the [EXTERNAL][google.cloud.kms.v1.ProtectionLevel.EXTERNAL]
// protection level and
// [EXTERNAL_VPC][google.cloud.kms.v1.ProtectionLevel.EXTERNAL_VPC] protection
// levels.
type ExternalProtectionLevelOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The URI for an external resource that this
	// [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] represents.
	ExternalKeyUri string `protobuf:"bytes,1,opt,name=external_key_uri,json=externalKeyUri,proto3" json:"external_key_uri,omitempty"`
	// The path to the external key material on the EKM when using
	// [EkmConnection][google.cloud.kms.v1.EkmConnection] e.g., "v0/my/key". Set
	// this field instead of external_key_uri when using an
	// [EkmConnection][google.cloud.kms.v1.EkmConnection].
	EkmConnectionKeyPath string `protobuf:"bytes,2,opt,name=ekm_connection_key_path,json=ekmConnectionKeyPath,proto3" json:"ekm_connection_key_path,omitempty"`
}

func (x *ExternalProtectionLevelOptions) Reset() {
	*x = ExternalProtectionLevelOptions{}
	mi := &file_google_cloud_kms_v1_resources_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExternalProtectionLevelOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExternalProtectionLevelOptions) ProtoMessage() {}

func (x *ExternalProtectionLevelOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_kms_v1_resources_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExternalProtectionLevelOptions.ProtoReflect.Descriptor instead.
func (*ExternalProtectionLevelOptions) Descriptor() ([]byte, []int) {
	return file_google_cloud_kms_v1_resources_proto_rawDescGZIP(), []int{7}
}

func (x *ExternalProtectionLevelOptions) GetExternalKeyUri() string {
	if x != nil {
		return x.ExternalKeyUri
	}
	return ""
}

func (x *ExternalProtectionLevelOptions) GetEkmConnectionKeyPath() string {
	if x != nil {
		return x.EkmConnectionKeyPath
	}
	return ""
}

// A
// [KeyAccessJustificationsPolicy][google.cloud.kms.v1.KeyAccessJustificationsPolicy]
// specifies zero or more allowed
// [AccessReason][google.cloud.kms.v1.AccessReason] values for encrypt, decrypt,
// and sign operations on a [CryptoKey][google.cloud.kms.v1.CryptoKey].
type KeyAccessJustificationsPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of allowed reasons for access to a
	// [CryptoKey][google.cloud.kms.v1.CryptoKey]. Zero allowed access reasons
	// means all encrypt, decrypt, and sign operations for the
	// [CryptoKey][google.cloud.kms.v1.CryptoKey] associated with this policy will
	// fail.
	AllowedAccessReasons []AccessReason `protobuf:"varint,1,rep,packed,name=allowed_access_reasons,json=allowedAccessReasons,proto3,enum=google.cloud.kms.v1.AccessReason" json:"allowed_access_reasons,omitempty"`
}

func (x *KeyAccessJustificationsPolicy) Reset() {
	*x = KeyAccessJustificationsPolicy{}
	mi := &file_google_cloud_kms_v1_resources_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *KeyAccessJustificationsPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KeyAccessJustificationsPolicy) ProtoMessage() {}

func (x *KeyAccessJustificationsPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_kms_v1_resources_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KeyAccessJustificationsPolicy.ProtoReflect.Descriptor instead.
func (*KeyAccessJustificationsPolicy) Descriptor() ([]byte, []int) {
	return file_google_cloud_kms_v1_resources_proto_rawDescGZIP(), []int{8}
}

func (x *KeyAccessJustificationsPolicy) GetAllowedAccessReasons() []AccessReason {
	if x != nil {
		return x.AllowedAccessReasons
	}
	return nil
}

// Certificate chains needed to verify the attestation.
// Certificates in chains are PEM-encoded and are ordered based on
// https://tools.ietf.org/html/rfc5246#section-7.4.2.
type KeyOperationAttestation_CertificateChains struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cavium certificate chain corresponding to the attestation.
	CaviumCerts []string `protobuf:"bytes,1,rep,name=cavium_certs,json=caviumCerts,proto3" json:"cavium_certs,omitempty"`
	// Google card certificate chain corresponding to the attestation.
	GoogleCardCerts []string `protobuf:"bytes,2,rep,name=google_card_certs,json=googleCardCerts,proto3" json:"google_card_certs,omitempty"`
	// Google partition certificate chain corresponding to the attestation.
	GooglePartitionCerts []string `protobuf:"bytes,3,rep,name=google_partition_certs,json=googlePartitionCerts,proto3" json:"google_partition_certs,omitempty"`
}

func (x *KeyOperationAttestation_CertificateChains) Reset() {
	*x = KeyOperationAttestation_CertificateChains{}
	mi := &file_google_cloud_kms_v1_resources_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *KeyOperationAttestation_CertificateChains) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KeyOperationAttestation_CertificateChains) ProtoMessage() {}

func (x *KeyOperationAttestation_CertificateChains) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_kms_v1_resources_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KeyOperationAttestation_CertificateChains.ProtoReflect.Descriptor instead.
func (*KeyOperationAttestation_CertificateChains) Descriptor() ([]byte, []int) {
	return file_google_cloud_kms_v1_resources_proto_rawDescGZIP(), []int{3, 0}
}

func (x *KeyOperationAttestation_CertificateChains) GetCaviumCerts() []string {
	if x != nil {
		return x.CaviumCerts
	}
	return nil
}

func (x *KeyOperationAttestation_CertificateChains) GetGoogleCardCerts() []string {
	if x != nil {
		return x.GoogleCardCerts
	}
	return nil
}

func (x *KeyOperationAttestation_CertificateChains) GetGooglePartitionCerts() []string {
	if x != nil {
		return x.GooglePartitionCerts
	}
	return nil
}

// The public key component of the wrapping key. For details of the type of
// key this public key corresponds to, see the
// [ImportMethod][google.cloud.kms.v1.ImportJob.ImportMethod].
type ImportJob_WrappingPublicKey struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The public key, encoded in PEM format. For more information, see the [RFC
	// 7468](https://tools.ietf.org/html/rfc7468) sections for [General
	// Considerations](https://tools.ietf.org/html/rfc7468#section-2) and
	// [Textual Encoding of Subject Public Key Info]
	// (https://tools.ietf.org/html/rfc7468#section-13).
	Pem string `protobuf:"bytes,1,opt,name=pem,proto3" json:"pem,omitempty"`
}

func (x *ImportJob_WrappingPublicKey) Reset() {
	*x = ImportJob_WrappingPublicKey{}
	mi := &file_google_cloud_kms_v1_resources_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImportJob_WrappingPublicKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportJob_WrappingPublicKey) ProtoMessage() {}

func (x *ImportJob_WrappingPublicKey) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_kms_v1_resources_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportJob_WrappingPublicKey.ProtoReflect.Descriptor instead.
func (*ImportJob_WrappingPublicKey) Descriptor() ([]byte, []int) {
	return file_google_cloud_kms_v1_resources_proto_rawDescGZIP(), []int{6, 0}
}

func (x *ImportJob_WrappingPublicKey) GetPem() string {
	if x != nil {
		return x.Pem
	}
	return ""
}

var File_google_cloud_kms_v1_resources_proto protoreflect.FileDescriptor

var file_google_cloud_kms_v1_resources_proto_rawDesc = []byte{
	0x0a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6b,
	0x6d, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x13, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6b, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68,
	0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xc7, 0x01, 0x0a, 0x07, 0x4b, 0x65, 0x79, 0x52,
	0x69, 0x6e, 0x67, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x3a, 0x61,
	0xea, 0x41, 0x5e, 0x0a, 0x1f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x6b, 0x6d, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4b, 0x65, 0x79,
	0x52, 0x69, 0x6e, 0x67, 0x12, 0x3b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6b, 0x65,
	0x79, 0x52, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x7b, 0x6b, 0x65, 0x79, 0x5f, 0x72, 0x69, 0x6e, 0x67,
	0x7d, 0x22, 0xd4, 0x09, 0x0a, 0x09, 0x43, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x12,
	0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x44, 0x0a, 0x07, 0x70, 0x72, 0x69, 0x6d,
	0x61, 0x72, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6b, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x70, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x12, 0x4e,
	0x0a, 0x07, 0x70, 0x75, 0x72, 0x70, 0x6f, 0x73, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6b,
	0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x2e,
	0x43, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x50, 0x75, 0x72, 0x70, 0x6f, 0x73, 0x65,
	0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x07, 0x70, 0x75, 0x72, 0x70, 0x6f, 0x73, 0x65, 0x12, 0x40,
	0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x48, 0x0a, 0x12, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x72, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x10, 0x6e, 0x65, 0x78, 0x74, 0x52, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x44, 0x0a, 0x0f, 0x72, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00,
	0x52, 0x0e, 0x72, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64,
	0x12, 0x58, 0x0a, 0x10, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x65, 0x6d, 0x70,
	0x6c, 0x61, 0x74, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6b, 0x6d, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x0f, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x12, 0x42, 0x0a, 0x06, 0x6c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6b, 0x6d, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x24,
	0x0a, 0x0b, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x0d, 0x20,
	0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x0a, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74,
	0x4f, 0x6e, 0x6c, 0x79, 0x12, 0x5c, 0x0a, 0x1a, 0x64, 0x65, 0x73, 0x74, 0x72, 0x6f, 0x79, 0x5f,
	0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x64, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x18, 0x64, 0x65, 0x73, 0x74, 0x72, 0x6f,
	0x79, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x64, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x37, 0x0a, 0x12, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x5f, 0x6b, 0x65, 0x79,
	0x5f, 0x62, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x09, 0x42, 0x09,
	0xe0, 0x41, 0x05, 0xfa, 0x41, 0x03, 0x0a, 0x01, 0x2a, 0x52, 0x10, 0x63, 0x72, 0x79, 0x70, 0x74,
	0x6f, 0x4b, 0x65, 0x79, 0x42, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x12, 0x80, 0x01, 0x0a, 0x20,
	0x6b, 0x65, 0x79, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x6a, 0x75, 0x73, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x18, 0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6b, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4b, 0x65, 0x79,
	0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x4a, 0x75, 0x73, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x1d, 0x6b, 0x65, 0x79, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x4a, 0x75, 0x73, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x1a, 0x39,
	0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a,
	0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12,
	0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x9a, 0x01, 0x0a, 0x10, 0x43, 0x72,
	0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x50, 0x75, 0x72, 0x70, 0x6f, 0x73, 0x65, 0x12, 0x22,
	0x0a, 0x1e, 0x43, 0x52, 0x59, 0x50, 0x54, 0x4f, 0x5f, 0x4b, 0x45, 0x59, 0x5f, 0x50, 0x55, 0x52,
	0x50, 0x4f, 0x53, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x13, 0x0a, 0x0f, 0x45, 0x4e, 0x43, 0x52, 0x59, 0x50, 0x54, 0x5f, 0x44, 0x45,
	0x43, 0x52, 0x59, 0x50, 0x54, 0x10, 0x01, 0x12, 0x13, 0x0a, 0x0f, 0x41, 0x53, 0x59, 0x4d, 0x4d,
	0x45, 0x54, 0x52, 0x49, 0x43, 0x5f, 0x53, 0x49, 0x47, 0x4e, 0x10, 0x05, 0x12, 0x16, 0x0a, 0x12,
	0x41, 0x53, 0x59, 0x4d, 0x4d, 0x45, 0x54, 0x52, 0x49, 0x43, 0x5f, 0x44, 0x45, 0x43, 0x52, 0x59,
	0x50, 0x54, 0x10, 0x06, 0x12, 0x17, 0x0a, 0x13, 0x52, 0x41, 0x57, 0x5f, 0x45, 0x4e, 0x43, 0x52,
	0x59, 0x50, 0x54, 0x5f, 0x44, 0x45, 0x43, 0x52, 0x59, 0x50, 0x54, 0x10, 0x07, 0x12, 0x07, 0x0a,
	0x03, 0x4d, 0x41, 0x43, 0x10, 0x09, 0x3a, 0x7b, 0xea, 0x41, 0x78, 0x0a, 0x21, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x6b, 0x6d, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x12, 0x53,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6b, 0x65, 0x79, 0x52, 0x69, 0x6e, 0x67, 0x73,
	0x2f, 0x7b, 0x6b, 0x65, 0x79, 0x5f, 0x72, 0x69, 0x6e, 0x67, 0x7d, 0x2f, 0x63, 0x72, 0x79, 0x70,
	0x74, 0x6f, 0x4b, 0x65, 0x79, 0x73, 0x2f, 0x7b, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x5f, 0x6b,
	0x65, 0x79, 0x7d, 0x42, 0x13, 0x0a, 0x11, 0x72, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x22, 0xcf, 0x01, 0x0a, 0x18, 0x43, 0x72, 0x79,
	0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x54, 0x65, 0x6d,
	0x70, 0x6c, 0x61, 0x74, 0x65, 0x12, 0x4f, 0x0a, 0x10, 0x70, 0x72, 0x6f, 0x74, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6b,
	0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x4c, 0x65, 0x76, 0x65, 0x6c, 0x52, 0x0f, 0x70, 0x72, 0x6f, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x62, 0x0a, 0x09, 0x61, 0x6c, 0x67, 0x6f, 0x72, 0x69,
	0x74, 0x68, 0x6d, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6b, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x2e, 0x43, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x41, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x09, 0x61, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x22, 0x83, 0x04, 0x0a, 0x17, 0x4b,
	0x65, 0x79, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x74, 0x74, 0x65, 0x73,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5b, 0x0a, 0x06, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6b, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4b, 0x65, 0x79,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x74, 0x74, 0x65, 0x73, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x41, 0x74, 0x74, 0x65, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x66, 0x6f, 0x72,
	0x6d, 0x61, 0x74, 0x12, 0x1d, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0c, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x12, 0x64, 0x0a, 0x0b, 0x63, 0x65, 0x72, 0x74, 0x5f, 0x63, 0x68, 0x61, 0x69, 0x6e,
	0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6b, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4b, 0x65,
	0x79, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x74, 0x74, 0x65, 0x73, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x65, 0x43, 0x68, 0x61, 0x69, 0x6e, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x65,
	0x72, 0x74, 0x43, 0x68, 0x61, 0x69, 0x6e, 0x73, 0x1a, 0x98, 0x01, 0x0a, 0x11, 0x43, 0x65, 0x72,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x43, 0x68, 0x61, 0x69, 0x6e, 0x73, 0x12, 0x21,
	0x0a, 0x0c, 0x63, 0x61, 0x76, 0x69, 0x75, 0x6d, 0x5f, 0x63, 0x65, 0x72, 0x74, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x63, 0x61, 0x76, 0x69, 0x75, 0x6d, 0x43, 0x65, 0x72, 0x74,
	0x73, 0x12, 0x2a, 0x0a, 0x11, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5f, 0x63, 0x61, 0x72, 0x64,
	0x5f, 0x63, 0x65, 0x72, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x43, 0x61, 0x72, 0x64, 0x43, 0x65, 0x72, 0x74, 0x73, 0x12, 0x34, 0x0a,
	0x16, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x63, 0x65, 0x72, 0x74, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x14, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x65,
	0x72, 0x74, 0x73, 0x22, 0x6b, 0x0a, 0x11, 0x41, 0x74, 0x74, 0x65, 0x73, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x22, 0x0a, 0x1e, 0x41, 0x54, 0x54, 0x45,
	0x53, 0x54, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x46, 0x4f, 0x52, 0x4d, 0x41, 0x54, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x18, 0x0a, 0x14,
	0x43, 0x41, 0x56, 0x49, 0x55, 0x4d, 0x5f, 0x56, 0x31, 0x5f, 0x43, 0x4f, 0x4d, 0x50, 0x52, 0x45,
	0x53, 0x53, 0x45, 0x44, 0x10, 0x03, 0x12, 0x18, 0x0a, 0x14, 0x43, 0x41, 0x56, 0x49, 0x55, 0x4d,
	0x5f, 0x56, 0x32, 0x5f, 0x43, 0x4f, 0x4d, 0x50, 0x52, 0x45, 0x53, 0x53, 0x45, 0x44, 0x10, 0x04,
	0x22, 0x89, 0x15, 0x0a, 0x10, 0x43, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x51,
	0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6b, 0x6d, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x43, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74,
	0x65, 0x12, 0x54, 0x0a, 0x10, 0x70, 0x72, 0x6f, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x6c, 0x65, 0x76, 0x65, 0x6c, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x24, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6b, 0x6d, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x50, 0x72, 0x6f, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x65, 0x76, 0x65,
	0x6c, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x70, 0x72, 0x6f, 0x74, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x62, 0x0a, 0x09, 0x61, 0x6c, 0x67, 0x6f, 0x72,
	0x69, 0x74, 0x68, 0x6d, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6b, 0x6d, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x2e, 0x43, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x41, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x09, 0x61, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x12, 0x53, 0x0a, 0x0b, 0x61,
	0x74, 0x74, 0x65, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6b, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4b, 0x65, 0x79, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x41, 0x74, 0x74, 0x65, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0b, 0x61, 0x74, 0x74, 0x65, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x44, 0x0a, 0x0d, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x67, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x42, 0x0a, 0x0c, 0x64, 0x65, 0x73, 0x74,
	0x72, 0x6f, 0x79, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0b, 0x64, 0x65, 0x73, 0x74, 0x72, 0x6f, 0x79, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x4d, 0x0a, 0x12,
	0x64, 0x65, 0x73, 0x74, 0x72, 0x6f, 0x79, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x10, 0x64, 0x65, 0x73, 0x74, 0x72,
	0x6f, 0x79, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x69,
	0x6d, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x6a, 0x6f, 0x62, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4a, 0x6f, 0x62, 0x12,
	0x40, 0x0a, 0x0b, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0f,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x37, 0x0a, 0x15, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x66, 0x61, 0x69, 0x6c,
	0x75, 0x72, 0x65, 0x5f, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x18, 0x10, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x13, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x46, 0x61, 0x69,
	0x6c, 0x75, 0x72, 0x65, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0x3f, 0x0a, 0x19, 0x67, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65,
	0x5f, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x18, 0x13, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x17, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x61,
	0x69, 0x6c, 0x75, 0x72, 0x65, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0x52, 0x0a, 0x23, 0x65,
	0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x64, 0x65, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x5f, 0x72, 0x65, 0x61, 0x73,
	0x6f, 0x6e, 0x18, 0x14, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x20, 0x65,
	0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x44, 0x65, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12,
	0x7e, 0x0a, 0x21, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x70, 0x72, 0x6f, 0x74,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x5f, 0x6f, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6b, 0x6d, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x50, 0x72, 0x6f, 0x74, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52,
	0x1e, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x50, 0x72, 0x6f, 0x74, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12,
	0x30, 0x0a, 0x11, 0x72, 0x65, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x65, 0x6c, 0x69, 0x67,
	0x69, 0x62, 0x6c, 0x65, 0x18, 0x12, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x10, 0x72, 0x65, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x45, 0x6c, 0x69, 0x67, 0x69, 0x62, 0x6c,
	0x65, 0x22, 0xe2, 0x07, 0x0a, 0x19, 0x43, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x41, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x12,
	0x2c, 0x0a, 0x28, 0x43, 0x52, 0x59, 0x50, 0x54, 0x4f, 0x5f, 0x4b, 0x45, 0x59, 0x5f, 0x56, 0x45,
	0x52, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x41, 0x4c, 0x47, 0x4f, 0x52, 0x49, 0x54, 0x48, 0x4d, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1f, 0x0a,
	0x1b, 0x47, 0x4f, 0x4f, 0x47, 0x4c, 0x45, 0x5f, 0x53, 0x59, 0x4d, 0x4d, 0x45, 0x54, 0x52, 0x49,
	0x43, 0x5f, 0x45, 0x4e, 0x43, 0x52, 0x59, 0x50, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x01, 0x12, 0x0f,
	0x0a, 0x0b, 0x41, 0x45, 0x53, 0x5f, 0x31, 0x32, 0x38, 0x5f, 0x47, 0x43, 0x4d, 0x10, 0x29, 0x12,
	0x0f, 0x0a, 0x0b, 0x41, 0x45, 0x53, 0x5f, 0x32, 0x35, 0x36, 0x5f, 0x47, 0x43, 0x4d, 0x10, 0x13,
	0x12, 0x0f, 0x0a, 0x0b, 0x41, 0x45, 0x53, 0x5f, 0x31, 0x32, 0x38, 0x5f, 0x43, 0x42, 0x43, 0x10,
	0x2a, 0x12, 0x0f, 0x0a, 0x0b, 0x41, 0x45, 0x53, 0x5f, 0x32, 0x35, 0x36, 0x5f, 0x43, 0x42, 0x43,
	0x10, 0x2b, 0x12, 0x0f, 0x0a, 0x0b, 0x41, 0x45, 0x53, 0x5f, 0x31, 0x32, 0x38, 0x5f, 0x43, 0x54,
	0x52, 0x10, 0x2c, 0x12, 0x0f, 0x0a, 0x0b, 0x41, 0x45, 0x53, 0x5f, 0x32, 0x35, 0x36, 0x5f, 0x43,
	0x54, 0x52, 0x10, 0x2d, 0x12, 0x1c, 0x0a, 0x18, 0x52, 0x53, 0x41, 0x5f, 0x53, 0x49, 0x47, 0x4e,
	0x5f, 0x50, 0x53, 0x53, 0x5f, 0x32, 0x30, 0x34, 0x38, 0x5f, 0x53, 0x48, 0x41, 0x32, 0x35, 0x36,
	0x10, 0x02, 0x12, 0x1c, 0x0a, 0x18, 0x52, 0x53, 0x41, 0x5f, 0x53, 0x49, 0x47, 0x4e, 0x5f, 0x50,
	0x53, 0x53, 0x5f, 0x33, 0x30, 0x37, 0x32, 0x5f, 0x53, 0x48, 0x41, 0x32, 0x35, 0x36, 0x10, 0x03,
	0x12, 0x1c, 0x0a, 0x18, 0x52, 0x53, 0x41, 0x5f, 0x53, 0x49, 0x47, 0x4e, 0x5f, 0x50, 0x53, 0x53,
	0x5f, 0x34, 0x30, 0x39, 0x36, 0x5f, 0x53, 0x48, 0x41, 0x32, 0x35, 0x36, 0x10, 0x04, 0x12, 0x1c,
	0x0a, 0x18, 0x52, 0x53, 0x41, 0x5f, 0x53, 0x49, 0x47, 0x4e, 0x5f, 0x50, 0x53, 0x53, 0x5f, 0x34,
	0x30, 0x39, 0x36, 0x5f, 0x53, 0x48, 0x41, 0x35, 0x31, 0x32, 0x10, 0x0f, 0x12, 0x1e, 0x0a, 0x1a,
	0x52, 0x53, 0x41, 0x5f, 0x53, 0x49, 0x47, 0x4e, 0x5f, 0x50, 0x4b, 0x43, 0x53, 0x31, 0x5f, 0x32,
	0x30, 0x34, 0x38, 0x5f, 0x53, 0x48, 0x41, 0x32, 0x35, 0x36, 0x10, 0x05, 0x12, 0x1e, 0x0a, 0x1a,
	0x52, 0x53, 0x41, 0x5f, 0x53, 0x49, 0x47, 0x4e, 0x5f, 0x50, 0x4b, 0x43, 0x53, 0x31, 0x5f, 0x33,
	0x30, 0x37, 0x32, 0x5f, 0x53, 0x48, 0x41, 0x32, 0x35, 0x36, 0x10, 0x06, 0x12, 0x1e, 0x0a, 0x1a,
	0x52, 0x53, 0x41, 0x5f, 0x53, 0x49, 0x47, 0x4e, 0x5f, 0x50, 0x4b, 0x43, 0x53, 0x31, 0x5f, 0x34,
	0x30, 0x39, 0x36, 0x5f, 0x53, 0x48, 0x41, 0x32, 0x35, 0x36, 0x10, 0x07, 0x12, 0x1e, 0x0a, 0x1a,
	0x52, 0x53, 0x41, 0x5f, 0x53, 0x49, 0x47, 0x4e, 0x5f, 0x50, 0x4b, 0x43, 0x53, 0x31, 0x5f, 0x34,
	0x30, 0x39, 0x36, 0x5f, 0x53, 0x48, 0x41, 0x35, 0x31, 0x32, 0x10, 0x10, 0x12, 0x1b, 0x0a, 0x17,
	0x52, 0x53, 0x41, 0x5f, 0x53, 0x49, 0x47, 0x4e, 0x5f, 0x52, 0x41, 0x57, 0x5f, 0x50, 0x4b, 0x43,
	0x53, 0x31, 0x5f, 0x32, 0x30, 0x34, 0x38, 0x10, 0x1c, 0x12, 0x1b, 0x0a, 0x17, 0x52, 0x53, 0x41,
	0x5f, 0x53, 0x49, 0x47, 0x4e, 0x5f, 0x52, 0x41, 0x57, 0x5f, 0x50, 0x4b, 0x43, 0x53, 0x31, 0x5f,
	0x33, 0x30, 0x37, 0x32, 0x10, 0x1d, 0x12, 0x1b, 0x0a, 0x17, 0x52, 0x53, 0x41, 0x5f, 0x53, 0x49,
	0x47, 0x4e, 0x5f, 0x52, 0x41, 0x57, 0x5f, 0x50, 0x4b, 0x43, 0x53, 0x31, 0x5f, 0x34, 0x30, 0x39,
	0x36, 0x10, 0x1e, 0x12, 0x20, 0x0a, 0x1c, 0x52, 0x53, 0x41, 0x5f, 0x44, 0x45, 0x43, 0x52, 0x59,
	0x50, 0x54, 0x5f, 0x4f, 0x41, 0x45, 0x50, 0x5f, 0x32, 0x30, 0x34, 0x38, 0x5f, 0x53, 0x48, 0x41,
	0x32, 0x35, 0x36, 0x10, 0x08, 0x12, 0x20, 0x0a, 0x1c, 0x52, 0x53, 0x41, 0x5f, 0x44, 0x45, 0x43,
	0x52, 0x59, 0x50, 0x54, 0x5f, 0x4f, 0x41, 0x45, 0x50, 0x5f, 0x33, 0x30, 0x37, 0x32, 0x5f, 0x53,
	0x48, 0x41, 0x32, 0x35, 0x36, 0x10, 0x09, 0x12, 0x20, 0x0a, 0x1c, 0x52, 0x53, 0x41, 0x5f, 0x44,
	0x45, 0x43, 0x52, 0x59, 0x50, 0x54, 0x5f, 0x4f, 0x41, 0x45, 0x50, 0x5f, 0x34, 0x30, 0x39, 0x36,
	0x5f, 0x53, 0x48, 0x41, 0x32, 0x35, 0x36, 0x10, 0x0a, 0x12, 0x20, 0x0a, 0x1c, 0x52, 0x53, 0x41,
	0x5f, 0x44, 0x45, 0x43, 0x52, 0x59, 0x50, 0x54, 0x5f, 0x4f, 0x41, 0x45, 0x50, 0x5f, 0x34, 0x30,
	0x39, 0x36, 0x5f, 0x53, 0x48, 0x41, 0x35, 0x31, 0x32, 0x10, 0x11, 0x12, 0x1e, 0x0a, 0x1a, 0x52,
	0x53, 0x41, 0x5f, 0x44, 0x45, 0x43, 0x52, 0x59, 0x50, 0x54, 0x5f, 0x4f, 0x41, 0x45, 0x50, 0x5f,
	0x32, 0x30, 0x34, 0x38, 0x5f, 0x53, 0x48, 0x41, 0x31, 0x10, 0x25, 0x12, 0x1e, 0x0a, 0x1a, 0x52,
	0x53, 0x41, 0x5f, 0x44, 0x45, 0x43, 0x52, 0x59, 0x50, 0x54, 0x5f, 0x4f, 0x41, 0x45, 0x50, 0x5f,
	0x33, 0x30, 0x37, 0x32, 0x5f, 0x53, 0x48, 0x41, 0x31, 0x10, 0x26, 0x12, 0x1e, 0x0a, 0x1a, 0x52,
	0x53, 0x41, 0x5f, 0x44, 0x45, 0x43, 0x52, 0x59, 0x50, 0x54, 0x5f, 0x4f, 0x41, 0x45, 0x50, 0x5f,
	0x34, 0x30, 0x39, 0x36, 0x5f, 0x53, 0x48, 0x41, 0x31, 0x10, 0x27, 0x12, 0x17, 0x0a, 0x13, 0x45,
	0x43, 0x5f, 0x53, 0x49, 0x47, 0x4e, 0x5f, 0x50, 0x32, 0x35, 0x36, 0x5f, 0x53, 0x48, 0x41, 0x32,
	0x35, 0x36, 0x10, 0x0c, 0x12, 0x17, 0x0a, 0x13, 0x45, 0x43, 0x5f, 0x53, 0x49, 0x47, 0x4e, 0x5f,
	0x50, 0x33, 0x38, 0x34, 0x5f, 0x53, 0x48, 0x41, 0x33, 0x38, 0x34, 0x10, 0x0d, 0x12, 0x1c, 0x0a,
	0x18, 0x45, 0x43, 0x5f, 0x53, 0x49, 0x47, 0x4e, 0x5f, 0x53, 0x45, 0x43, 0x50, 0x32, 0x35, 0x36,
	0x4b, 0x31, 0x5f, 0x53, 0x48, 0x41, 0x32, 0x35, 0x36, 0x10, 0x1f, 0x12, 0x13, 0x0a, 0x0f, 0x45,
	0x43, 0x5f, 0x53, 0x49, 0x47, 0x4e, 0x5f, 0x45, 0x44, 0x32, 0x35, 0x35, 0x31, 0x39, 0x10, 0x28,
	0x12, 0x0f, 0x0a, 0x0b, 0x48, 0x4d, 0x41, 0x43, 0x5f, 0x53, 0x48, 0x41, 0x32, 0x35, 0x36, 0x10,
	0x20, 0x12, 0x0d, 0x0a, 0x09, 0x48, 0x4d, 0x41, 0x43, 0x5f, 0x53, 0x48, 0x41, 0x31, 0x10, 0x21,
	0x12, 0x0f, 0x0a, 0x0b, 0x48, 0x4d, 0x41, 0x43, 0x5f, 0x53, 0x48, 0x41, 0x33, 0x38, 0x34, 0x10,
	0x22, 0x12, 0x0f, 0x0a, 0x0b, 0x48, 0x4d, 0x41, 0x43, 0x5f, 0x53, 0x48, 0x41, 0x35, 0x31, 0x32,
	0x10, 0x23, 0x12, 0x0f, 0x0a, 0x0b, 0x48, 0x4d, 0x41, 0x43, 0x5f, 0x53, 0x48, 0x41, 0x32, 0x32,
	0x34, 0x10, 0x24, 0x12, 0x21, 0x0a, 0x1d, 0x45, 0x58, 0x54, 0x45, 0x52, 0x4e, 0x41, 0x4c, 0x5f,
	0x53, 0x59, 0x4d, 0x4d, 0x45, 0x54, 0x52, 0x49, 0x43, 0x5f, 0x45, 0x4e, 0x43, 0x52, 0x59, 0x50,
	0x54, 0x49, 0x4f, 0x4e, 0x10, 0x12, 0x22, 0x9b, 0x02, 0x0a, 0x15, 0x43, 0x72, 0x79, 0x70, 0x74,
	0x6f, 0x4b, 0x65, 0x79, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x12, 0x28, 0x0a, 0x24, 0x43, 0x52, 0x59, 0x50, 0x54, 0x4f, 0x5f, 0x4b, 0x45, 0x59, 0x5f, 0x56,
	0x45, 0x52, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x16, 0x0a, 0x12, 0x50, 0x45,
	0x4e, 0x44, 0x49, 0x4e, 0x47, 0x5f, 0x47, 0x45, 0x4e, 0x45, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e,
	0x10, 0x05, 0x12, 0x0b, 0x0a, 0x07, 0x45, 0x4e, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x01, 0x12,
	0x0c, 0x0a, 0x08, 0x44, 0x49, 0x53, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0d, 0x0a,
	0x09, 0x44, 0x45, 0x53, 0x54, 0x52, 0x4f, 0x59, 0x45, 0x44, 0x10, 0x03, 0x12, 0x15, 0x0a, 0x11,
	0x44, 0x45, 0x53, 0x54, 0x52, 0x4f, 0x59, 0x5f, 0x53, 0x43, 0x48, 0x45, 0x44, 0x55, 0x4c, 0x45,
	0x44, 0x10, 0x04, 0x12, 0x12, 0x0a, 0x0e, 0x50, 0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x5f, 0x49,
	0x4d, 0x50, 0x4f, 0x52, 0x54, 0x10, 0x06, 0x12, 0x11, 0x0a, 0x0d, 0x49, 0x4d, 0x50, 0x4f, 0x52,
	0x54, 0x5f, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x07, 0x12, 0x15, 0x0a, 0x11, 0x47, 0x45,
	0x4e, 0x45, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10,
	0x08, 0x12, 0x20, 0x0a, 0x1c, 0x50, 0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x5f, 0x45, 0x58, 0x54,
	0x45, 0x52, 0x4e, 0x41, 0x4c, 0x5f, 0x44, 0x45, 0x53, 0x54, 0x52, 0x55, 0x43, 0x54, 0x49, 0x4f,
	0x4e, 0x10, 0x09, 0x12, 0x1f, 0x0a, 0x1b, 0x45, 0x58, 0x54, 0x45, 0x52, 0x4e, 0x41, 0x4c, 0x5f,
	0x44, 0x45, 0x53, 0x54, 0x52, 0x55, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x46, 0x41, 0x49, 0x4c,
	0x45, 0x44, 0x10, 0x0a, 0x22, 0x49, 0x0a, 0x14, 0x43, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65,
	0x79, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x56, 0x69, 0x65, 0x77, 0x12, 0x27, 0x0a, 0x23,
	0x43, 0x52, 0x59, 0x50, 0x54, 0x4f, 0x5f, 0x4b, 0x45, 0x59, 0x5f, 0x56, 0x45, 0x52, 0x53, 0x49,
	0x4f, 0x4e, 0x5f, 0x56, 0x49, 0x45, 0x57, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x46, 0x55, 0x4c, 0x4c, 0x10, 0x01, 0x3a,
	0xaa, 0x01, 0xea, 0x41, 0xa6, 0x01, 0x0a, 0x28, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x6b, 0x6d, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x43, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x12, 0x7a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6b, 0x65, 0x79, 0x52, 0x69, 0x6e,
	0x67, 0x73, 0x2f, 0x7b, 0x6b, 0x65, 0x79, 0x5f, 0x72, 0x69, 0x6e, 0x67, 0x7d, 0x2f, 0x63, 0x72,
	0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x73, 0x2f, 0x7b, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f,
	0x5f, 0x6b, 0x65, 0x79, 0x7d, 0x2f, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x5f,
	0x6b, 0x65, 0x79, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x7d, 0x22, 0xce, 0x03, 0x0a,
	0x09, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x70, 0x65,
	0x6d, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x70, 0x65, 0x6d, 0x12, 0x5d, 0x0a, 0x09,
	0x61, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6b,
	0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x43, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x41, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d,
	0x52, 0x09, 0x61, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x12, 0x3a, 0x0a, 0x0a, 0x70,
	0x65, 0x6d, 0x5f, 0x63, 0x72, 0x63, 0x33, 0x32, 0x63, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x09, 0x70, 0x65,
	0x6d, 0x43, 0x72, 0x63, 0x33, 0x32, 0x63, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x4f, 0x0a, 0x10, 0x70,
	0x72, 0x6f, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6b, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x74,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x52, 0x0f, 0x70, 0x72, 0x6f,
	0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x3a, 0xae, 0x01, 0xea,
	0x41, 0xaa, 0x01, 0x0a, 0x21, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x6b, 0x6d, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x75, 0x62,
	0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x12, 0x84, 0x01, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d,
	0x2f, 0x6b, 0x65, 0x79, 0x52, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x7b, 0x6b, 0x65, 0x79, 0x5f, 0x72,
	0x69, 0x6e, 0x67, 0x7d, 0x2f, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x73, 0x2f,
	0x7b, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x5f, 0x6b, 0x65, 0x79, 0x7d, 0x2f, 0x63, 0x72, 0x79,
	0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b,
	0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x7d, 0x2f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x22, 0xd4, 0x09,
	0x0a, 0x09, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4a, 0x6f, 0x62, 0x12, 0x17, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x58, 0x0a, 0x0d, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x6d,
	0x65, 0x74, 0x68, 0x6f, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6b, 0x6d, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4a, 0x6f, 0x62, 0x2e, 0x49, 0x6d, 0x70, 0x6f,
	0x72, 0x74, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x42, 0x06, 0xe0, 0x41, 0x02, 0xe0, 0x41, 0x05,
	0x52, 0x0c, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x12, 0x57,
	0x0a, 0x10, 0x70, 0x72, 0x6f, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6c, 0x65, 0x76,
	0x65, 0x6c, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6b, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50,
	0x72, 0x6f, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x42, 0x06,
	0xe0, 0x41, 0x02, 0xe0, 0x41, 0x05, 0x52, 0x0f, 0x70, 0x72, 0x6f, 0x74, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x44, 0x0a, 0x0d, 0x67, 0x65, 0x6e,
	0x65, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0c, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x40, 0x0a, 0x0b, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x4b, 0x0a, 0x11, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x5f, 0x65, 0x76, 0x65, 0x6e,
	0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x65,
	0x78, 0x70, 0x69, 0x72, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x48,
	0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6b, 0x6d, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4a, 0x6f, 0x62, 0x2e, 0x49, 0x6d,
	0x70, 0x6f, 0x72, 0x74, 0x4a, 0x6f, 0x62, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x54, 0x0a, 0x0a, 0x70, 0x75, 0x62, 0x6c,
	0x69, 0x63, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6b, 0x6d, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4a, 0x6f, 0x62, 0x2e, 0x57, 0x72, 0x61,
	0x70, 0x70, 0x69, 0x6e, 0x67, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x09, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x12, 0x53,
	0x0a, 0x0b, 0x61, 0x74, 0x74, 0x65, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6b, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4b, 0x65, 0x79, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x74, 0x74, 0x65, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x61, 0x74, 0x74, 0x65, 0x73, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x1a, 0x25, 0x0a, 0x11, 0x57, 0x72, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x50,
	0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x70, 0x65, 0x6d, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x70, 0x65, 0x6d, 0x22, 0xe5, 0x01, 0x0a, 0x0c, 0x49,
	0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x12, 0x1d, 0x0a, 0x19, 0x49,
	0x4d, 0x50, 0x4f, 0x52, 0x54, 0x5f, 0x4d, 0x45, 0x54, 0x48, 0x4f, 0x44, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1e, 0x0a, 0x1a, 0x52, 0x53,
	0x41, 0x5f, 0x4f, 0x41, 0x45, 0x50, 0x5f, 0x33, 0x30, 0x37, 0x32, 0x5f, 0x53, 0x48, 0x41, 0x31,
	0x5f, 0x41, 0x45, 0x53, 0x5f, 0x32, 0x35, 0x36, 0x10, 0x01, 0x12, 0x1e, 0x0a, 0x1a, 0x52, 0x53,
	0x41, 0x5f, 0x4f, 0x41, 0x45, 0x50, 0x5f, 0x34, 0x30, 0x39, 0x36, 0x5f, 0x53, 0x48, 0x41, 0x31,
	0x5f, 0x41, 0x45, 0x53, 0x5f, 0x32, 0x35, 0x36, 0x10, 0x02, 0x12, 0x20, 0x0a, 0x1c, 0x52, 0x53,
	0x41, 0x5f, 0x4f, 0x41, 0x45, 0x50, 0x5f, 0x33, 0x30, 0x37, 0x32, 0x5f, 0x53, 0x48, 0x41, 0x32,
	0x35, 0x36, 0x5f, 0x41, 0x45, 0x53, 0x5f, 0x32, 0x35, 0x36, 0x10, 0x03, 0x12, 0x20, 0x0a, 0x1c,
	0x52, 0x53, 0x41, 0x5f, 0x4f, 0x41, 0x45, 0x50, 0x5f, 0x34, 0x30, 0x39, 0x36, 0x5f, 0x53, 0x48,
	0x41, 0x32, 0x35, 0x36, 0x5f, 0x41, 0x45, 0x53, 0x5f, 0x32, 0x35, 0x36, 0x10, 0x04, 0x12, 0x18,
	0x0a, 0x14, 0x52, 0x53, 0x41, 0x5f, 0x4f, 0x41, 0x45, 0x50, 0x5f, 0x33, 0x30, 0x37, 0x32, 0x5f,
	0x53, 0x48, 0x41, 0x32, 0x35, 0x36, 0x10, 0x05, 0x12, 0x18, 0x0a, 0x14, 0x52, 0x53, 0x41, 0x5f,
	0x4f, 0x41, 0x45, 0x50, 0x5f, 0x34, 0x30, 0x39, 0x36, 0x5f, 0x53, 0x48, 0x41, 0x32, 0x35, 0x36,
	0x10, 0x06, 0x22, 0x63, 0x0a, 0x0e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4a, 0x6f, 0x62, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x12, 0x20, 0x0a, 0x1c, 0x49, 0x4d, 0x50, 0x4f, 0x52, 0x54, 0x5f, 0x4a,
	0x4f, 0x42, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x16, 0x0a, 0x12, 0x50, 0x45, 0x4e, 0x44, 0x49, 0x4e,
	0x47, 0x5f, 0x47, 0x45, 0x4e, 0x45, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x01, 0x12, 0x0a,
	0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x02, 0x12, 0x0b, 0x0a, 0x07, 0x45, 0x58,
	0x50, 0x49, 0x52, 0x45, 0x44, 0x10, 0x03, 0x3a, 0x7b, 0xea, 0x41, 0x78, 0x0a, 0x21, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x6b, 0x6d, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4a, 0x6f, 0x62, 0x12,
	0x53, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6b, 0x65, 0x79, 0x52, 0x69, 0x6e, 0x67,
	0x73, 0x2f, 0x7b, 0x6b, 0x65, 0x79, 0x5f, 0x72, 0x69, 0x6e, 0x67, 0x7d, 0x2f, 0x69, 0x6d, 0x70,
	0x6f, 0x72, 0x74, 0x4a, 0x6f, 0x62, 0x73, 0x2f, 0x7b, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x5f,
	0x6a, 0x6f, 0x62, 0x7d, 0x22, 0x81, 0x01, 0x0a, 0x1e, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61,
	0x6c, 0x50, 0x72, 0x6f, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x65, 0x76, 0x65, 0x6c,
	0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x28, 0x0a, 0x10, 0x65, 0x78, 0x74, 0x65, 0x72,
	0x6e, 0x61, 0x6c, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0e, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x4b, 0x65, 0x79, 0x55, 0x72,
	0x69, 0x12, 0x35, 0x0a, 0x17, 0x65, 0x6b, 0x6d, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x14, 0x65, 0x6b, 0x6d, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x4b, 0x65, 0x79, 0x50, 0x61, 0x74, 0x68, 0x22, 0x78, 0x0a, 0x1d, 0x4b, 0x65, 0x79, 0x41,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x4a, 0x75, 0x73, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x57, 0x0a, 0x16, 0x61, 0x6c, 0x6c,
	0x6f, 0x77, 0x65, 0x64, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x72, 0x65, 0x61, 0x73,
	0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6b, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x52, 0x14, 0x61, 0x6c,
	0x6c, 0x6f, 0x77, 0x65, 0x64, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x52, 0x65, 0x61, 0x73, 0x6f,
	0x6e, 0x73, 0x2a, 0x6a, 0x0a, 0x0f, 0x50, 0x72, 0x6f, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x4c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x20, 0x0a, 0x1c, 0x50, 0x52, 0x4f, 0x54, 0x45, 0x43, 0x54,
	0x49, 0x4f, 0x4e, 0x5f, 0x4c, 0x45, 0x56, 0x45, 0x4c, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x53, 0x4f, 0x46, 0x54, 0x57,
	0x41, 0x52, 0x45, 0x10, 0x01, 0x12, 0x07, 0x0a, 0x03, 0x48, 0x53, 0x4d, 0x10, 0x02, 0x12, 0x0c,
	0x0a, 0x08, 0x45, 0x58, 0x54, 0x45, 0x52, 0x4e, 0x41, 0x4c, 0x10, 0x03, 0x12, 0x10, 0x0a, 0x0c,
	0x45, 0x58, 0x54, 0x45, 0x52, 0x4e, 0x41, 0x4c, 0x5f, 0x56, 0x50, 0x43, 0x10, 0x04, 0x2a, 0xab,
	0x03, 0x0a, 0x0c, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12,
	0x16, 0x0a, 0x12, 0x52, 0x45, 0x41, 0x53, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1e, 0x0a, 0x1a, 0x43, 0x55, 0x53, 0x54, 0x4f,
	0x4d, 0x45, 0x52, 0x5f, 0x49, 0x4e, 0x49, 0x54, 0x49, 0x41, 0x54, 0x45, 0x44, 0x5f, 0x53, 0x55,
	0x50, 0x50, 0x4f, 0x52, 0x54, 0x10, 0x01, 0x12, 0x1c, 0x0a, 0x18, 0x47, 0x4f, 0x4f, 0x47, 0x4c,
	0x45, 0x5f, 0x49, 0x4e, 0x49, 0x54, 0x49, 0x41, 0x54, 0x45, 0x44, 0x5f, 0x53, 0x45, 0x52, 0x56,
	0x49, 0x43, 0x45, 0x10, 0x02, 0x12, 0x1c, 0x0a, 0x18, 0x54, 0x48, 0x49, 0x52, 0x44, 0x5f, 0x50,
	0x41, 0x52, 0x54, 0x59, 0x5f, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x52, 0x45, 0x51, 0x55, 0x45, 0x53,
	0x54, 0x10, 0x03, 0x12, 0x1b, 0x0a, 0x17, 0x47, 0x4f, 0x4f, 0x47, 0x4c, 0x45, 0x5f, 0x49, 0x4e,
	0x49, 0x54, 0x49, 0x41, 0x54, 0x45, 0x44, 0x5f, 0x52, 0x45, 0x56, 0x49, 0x45, 0x57, 0x10, 0x04,
	0x12, 0x1d, 0x0a, 0x19, 0x43, 0x55, 0x53, 0x54, 0x4f, 0x4d, 0x45, 0x52, 0x5f, 0x49, 0x4e, 0x49,
	0x54, 0x49, 0x41, 0x54, 0x45, 0x44, 0x5f, 0x41, 0x43, 0x43, 0x45, 0x53, 0x53, 0x10, 0x05, 0x12,
	0x25, 0x0a, 0x21, 0x47, 0x4f, 0x4f, 0x47, 0x4c, 0x45, 0x5f, 0x49, 0x4e, 0x49, 0x54, 0x49, 0x41,
	0x54, 0x45, 0x44, 0x5f, 0x53, 0x59, 0x53, 0x54, 0x45, 0x4d, 0x5f, 0x4f, 0x50, 0x45, 0x52, 0x41,
	0x54, 0x49, 0x4f, 0x4e, 0x10, 0x06, 0x12, 0x17, 0x0a, 0x13, 0x52, 0x45, 0x41, 0x53, 0x4f, 0x4e,
	0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x45, 0x58, 0x50, 0x45, 0x43, 0x54, 0x45, 0x44, 0x10, 0x07, 0x12,
	0x26, 0x0a, 0x22, 0x4d, 0x4f, 0x44, 0x49, 0x46, 0x49, 0x45, 0x44, 0x5f, 0x43, 0x55, 0x53, 0x54,
	0x4f, 0x4d, 0x45, 0x52, 0x5f, 0x49, 0x4e, 0x49, 0x54, 0x49, 0x41, 0x54, 0x45, 0x44, 0x5f, 0x41,
	0x43, 0x43, 0x45, 0x53, 0x53, 0x10, 0x08, 0x12, 0x2e, 0x0a, 0x2a, 0x4d, 0x4f, 0x44, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x5f, 0x47, 0x4f, 0x4f, 0x47, 0x4c, 0x45, 0x5f, 0x49, 0x4e, 0x49, 0x54, 0x49,
	0x41, 0x54, 0x45, 0x44, 0x5f, 0x53, 0x59, 0x53, 0x54, 0x45, 0x4d, 0x5f, 0x4f, 0x50, 0x45, 0x52,
	0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x09, 0x12, 0x27, 0x0a, 0x23, 0x47, 0x4f, 0x4f, 0x47, 0x4c,
	0x45, 0x5f, 0x52, 0x45, 0x53, 0x50, 0x4f, 0x4e, 0x53, 0x45, 0x5f, 0x54, 0x4f, 0x5f, 0x50, 0x52,
	0x4f, 0x44, 0x55, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x41, 0x4c, 0x45, 0x52, 0x54, 0x10, 0x0a,
	0x12, 0x2a, 0x0a, 0x26, 0x43, 0x55, 0x53, 0x54, 0x4f, 0x4d, 0x45, 0x52, 0x5f, 0x41, 0x55, 0x54,
	0x48, 0x4f, 0x52, 0x49, 0x5a, 0x45, 0x44, 0x5f, 0x57, 0x4f, 0x52, 0x4b, 0x46, 0x4c, 0x4f, 0x57,
	0x5f, 0x53, 0x45, 0x52, 0x56, 0x49, 0x43, 0x49, 0x4e, 0x47, 0x10, 0x0b, 0x42, 0x85, 0x01, 0x0a,
	0x17, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6b, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x42, 0x11, 0x4b, 0x6d, 0x73, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x29, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x67, 0x6f, 0x2f, 0x6b, 0x6d, 0x73, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x6b, 0x6d, 0x73,
	0x70, 0x62, 0x3b, 0x6b, 0x6d, 0x73, 0x70, 0x62, 0xaa, 0x02, 0x13, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x4b, 0x6d, 0x73, 0x2e, 0x56, 0x31, 0xca, 0x02,
	0x13, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x4b, 0x6d,
	0x73, 0x5c, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_kms_v1_resources_proto_rawDescOnce sync.Once
	file_google_cloud_kms_v1_resources_proto_rawDescData = file_google_cloud_kms_v1_resources_proto_rawDesc
)

func file_google_cloud_kms_v1_resources_proto_rawDescGZIP() []byte {
	file_google_cloud_kms_v1_resources_proto_rawDescOnce.Do(func() {
		file_google_cloud_kms_v1_resources_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_kms_v1_resources_proto_rawDescData)
	})
	return file_google_cloud_kms_v1_resources_proto_rawDescData
}

var file_google_cloud_kms_v1_resources_proto_enumTypes = make([]protoimpl.EnumInfo, 9)
var file_google_cloud_kms_v1_resources_proto_msgTypes = make([]protoimpl.MessageInfo, 12)
var file_google_cloud_kms_v1_resources_proto_goTypes = []any{
	(ProtectionLevel)(0),                              // 0: google.cloud.kms.v1.ProtectionLevel
	(AccessReason)(0),                                 // 1: google.cloud.kms.v1.AccessReason
	(CryptoKey_CryptoKeyPurpose)(0),                   // 2: google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose
	(KeyOperationAttestation_AttestationFormat)(0),    // 3: google.cloud.kms.v1.KeyOperationAttestation.AttestationFormat
	(CryptoKeyVersion_CryptoKeyVersionAlgorithm)(0),   // 4: google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm
	(CryptoKeyVersion_CryptoKeyVersionState)(0),       // 5: google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState
	(CryptoKeyVersion_CryptoKeyVersionView)(0),        // 6: google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionView
	(ImportJob_ImportMethod)(0),                       // 7: google.cloud.kms.v1.ImportJob.ImportMethod
	(ImportJob_ImportJobState)(0),                     // 8: google.cloud.kms.v1.ImportJob.ImportJobState
	(*KeyRing)(nil),                                   // 9: google.cloud.kms.v1.KeyRing
	(*CryptoKey)(nil),                                 // 10: google.cloud.kms.v1.CryptoKey
	(*CryptoKeyVersionTemplate)(nil),                  // 11: google.cloud.kms.v1.CryptoKeyVersionTemplate
	(*KeyOperationAttestation)(nil),                   // 12: google.cloud.kms.v1.KeyOperationAttestation
	(*CryptoKeyVersion)(nil),                          // 13: google.cloud.kms.v1.CryptoKeyVersion
	(*PublicKey)(nil),                                 // 14: google.cloud.kms.v1.PublicKey
	(*ImportJob)(nil),                                 // 15: google.cloud.kms.v1.ImportJob
	(*ExternalProtectionLevelOptions)(nil),            // 16: google.cloud.kms.v1.ExternalProtectionLevelOptions
	(*KeyAccessJustificationsPolicy)(nil),             // 17: google.cloud.kms.v1.KeyAccessJustificationsPolicy
	nil,                                               // 18: google.cloud.kms.v1.CryptoKey.LabelsEntry
	(*KeyOperationAttestation_CertificateChains)(nil), // 19: google.cloud.kms.v1.KeyOperationAttestation.CertificateChains
	(*ImportJob_WrappingPublicKey)(nil),               // 20: google.cloud.kms.v1.ImportJob.WrappingPublicKey
	(*timestamppb.Timestamp)(nil),                     // 21: google.protobuf.Timestamp
	(*durationpb.Duration)(nil),                       // 22: google.protobuf.Duration
	(*wrapperspb.Int64Value)(nil),                     // 23: google.protobuf.Int64Value
}
var file_google_cloud_kms_v1_resources_proto_depIdxs = []int32{
	21, // 0: google.cloud.kms.v1.KeyRing.create_time:type_name -> google.protobuf.Timestamp
	13, // 1: google.cloud.kms.v1.CryptoKey.primary:type_name -> google.cloud.kms.v1.CryptoKeyVersion
	2,  // 2: google.cloud.kms.v1.CryptoKey.purpose:type_name -> google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose
	21, // 3: google.cloud.kms.v1.CryptoKey.create_time:type_name -> google.protobuf.Timestamp
	21, // 4: google.cloud.kms.v1.CryptoKey.next_rotation_time:type_name -> google.protobuf.Timestamp
	22, // 5: google.cloud.kms.v1.CryptoKey.rotation_period:type_name -> google.protobuf.Duration
	11, // 6: google.cloud.kms.v1.CryptoKey.version_template:type_name -> google.cloud.kms.v1.CryptoKeyVersionTemplate
	18, // 7: google.cloud.kms.v1.CryptoKey.labels:type_name -> google.cloud.kms.v1.CryptoKey.LabelsEntry
	22, // 8: google.cloud.kms.v1.CryptoKey.destroy_scheduled_duration:type_name -> google.protobuf.Duration
	17, // 9: google.cloud.kms.v1.CryptoKey.key_access_justifications_policy:type_name -> google.cloud.kms.v1.KeyAccessJustificationsPolicy
	0,  // 10: google.cloud.kms.v1.CryptoKeyVersionTemplate.protection_level:type_name -> google.cloud.kms.v1.ProtectionLevel
	4,  // 11: google.cloud.kms.v1.CryptoKeyVersionTemplate.algorithm:type_name -> google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm
	3,  // 12: google.cloud.kms.v1.KeyOperationAttestation.format:type_name -> google.cloud.kms.v1.KeyOperationAttestation.AttestationFormat
	19, // 13: google.cloud.kms.v1.KeyOperationAttestation.cert_chains:type_name -> google.cloud.kms.v1.KeyOperationAttestation.CertificateChains
	5,  // 14: google.cloud.kms.v1.CryptoKeyVersion.state:type_name -> google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState
	0,  // 15: google.cloud.kms.v1.CryptoKeyVersion.protection_level:type_name -> google.cloud.kms.v1.ProtectionLevel
	4,  // 16: google.cloud.kms.v1.CryptoKeyVersion.algorithm:type_name -> google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm
	12, // 17: google.cloud.kms.v1.CryptoKeyVersion.attestation:type_name -> google.cloud.kms.v1.KeyOperationAttestation
	21, // 18: google.cloud.kms.v1.CryptoKeyVersion.create_time:type_name -> google.protobuf.Timestamp
	21, // 19: google.cloud.kms.v1.CryptoKeyVersion.generate_time:type_name -> google.protobuf.Timestamp
	21, // 20: google.cloud.kms.v1.CryptoKeyVersion.destroy_time:type_name -> google.protobuf.Timestamp
	21, // 21: google.cloud.kms.v1.CryptoKeyVersion.destroy_event_time:type_name -> google.protobuf.Timestamp
	21, // 22: google.cloud.kms.v1.CryptoKeyVersion.import_time:type_name -> google.protobuf.Timestamp
	16, // 23: google.cloud.kms.v1.CryptoKeyVersion.external_protection_level_options:type_name -> google.cloud.kms.v1.ExternalProtectionLevelOptions
	4,  // 24: google.cloud.kms.v1.PublicKey.algorithm:type_name -> google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm
	23, // 25: google.cloud.kms.v1.PublicKey.pem_crc32c:type_name -> google.protobuf.Int64Value
	0,  // 26: google.cloud.kms.v1.PublicKey.protection_level:type_name -> google.cloud.kms.v1.ProtectionLevel
	7,  // 27: google.cloud.kms.v1.ImportJob.import_method:type_name -> google.cloud.kms.v1.ImportJob.ImportMethod
	0,  // 28: google.cloud.kms.v1.ImportJob.protection_level:type_name -> google.cloud.kms.v1.ProtectionLevel
	21, // 29: google.cloud.kms.v1.ImportJob.create_time:type_name -> google.protobuf.Timestamp
	21, // 30: google.cloud.kms.v1.ImportJob.generate_time:type_name -> google.protobuf.Timestamp
	21, // 31: google.cloud.kms.v1.ImportJob.expire_time:type_name -> google.protobuf.Timestamp
	21, // 32: google.cloud.kms.v1.ImportJob.expire_event_time:type_name -> google.protobuf.Timestamp
	8,  // 33: google.cloud.kms.v1.ImportJob.state:type_name -> google.cloud.kms.v1.ImportJob.ImportJobState
	20, // 34: google.cloud.kms.v1.ImportJob.public_key:type_name -> google.cloud.kms.v1.ImportJob.WrappingPublicKey
	12, // 35: google.cloud.kms.v1.ImportJob.attestation:type_name -> google.cloud.kms.v1.KeyOperationAttestation
	1,  // 36: google.cloud.kms.v1.KeyAccessJustificationsPolicy.allowed_access_reasons:type_name -> google.cloud.kms.v1.AccessReason
	37, // [37:37] is the sub-list for method output_type
	37, // [37:37] is the sub-list for method input_type
	37, // [37:37] is the sub-list for extension type_name
	37, // [37:37] is the sub-list for extension extendee
	0,  // [0:37] is the sub-list for field type_name
}

func init() { file_google_cloud_kms_v1_resources_proto_init() }
func file_google_cloud_kms_v1_resources_proto_init() {
	if File_google_cloud_kms_v1_resources_proto != nil {
		return
	}
	file_google_cloud_kms_v1_resources_proto_msgTypes[1].OneofWrappers = []any{
		(*CryptoKey_RotationPeriod)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_kms_v1_resources_proto_rawDesc,
			NumEnums:      9,
			NumMessages:   12,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_kms_v1_resources_proto_goTypes,
		DependencyIndexes: file_google_cloud_kms_v1_resources_proto_depIdxs,
		EnumInfos:         file_google_cloud_kms_v1_resources_proto_enumTypes,
		MessageInfos:      file_google_cloud_kms_v1_resources_proto_msgTypes,
	}.Build()
	File_google_cloud_kms_v1_resources_proto = out.File
	file_google_cloud_kms_v1_resources_proto_rawDesc = nil
	file_google_cloud_kms_v1_resources_proto_goTypes = nil
	file_google_cloud_kms_v1_resources_proto_depIdxs = nil
}
