/* UndoTextTagRemove.c generated by valac 0.56.18, the Vala compiler
 * generated from UndoTextTagRemove.vala, do not modify */

/*
* Copyright (c) 2020 (https://github.com/phase1geo/Outliner)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Trevor Williams <phase1geo@gmail.com>
*/

#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_UNDO_ITEM (undo_item_get_type ())
#define UNDO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNDO_ITEM, UndoItem))
#define UNDO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNDO_ITEM, UndoItemClass))
#define IS_UNDO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNDO_ITEM))
#define IS_UNDO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNDO_ITEM))
#define UNDO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNDO_ITEM, UndoItemClass))

typedef struct _UndoItem UndoItem;
typedef struct _UndoItemClass UndoItemClass;
typedef struct _UndoItemPrivate UndoItemPrivate;

#define TYPE_DRAW_AREA (draw_area_get_type ())
#define DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DRAW_AREA, DrawArea))
#define DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DRAW_AREA, DrawAreaClass))
#define IS_DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DRAW_AREA))
#define IS_DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DRAW_AREA))
#define DRAW_AREA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DRAW_AREA, DrawAreaClass))

typedef struct _DrawArea DrawArea;
typedef struct _DrawAreaClass DrawAreaClass;

#define TYPE_UNDO_TEXT_ITEM (undo_text_item_get_type ())
#define UNDO_TEXT_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNDO_TEXT_ITEM, UndoTextItem))
#define UNDO_TEXT_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNDO_TEXT_ITEM, UndoTextItemClass))
#define IS_UNDO_TEXT_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNDO_TEXT_ITEM))
#define IS_UNDO_TEXT_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNDO_TEXT_ITEM))
#define UNDO_TEXT_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNDO_TEXT_ITEM, UndoTextItemClass))

typedef struct _UndoTextItem UndoTextItem;
typedef struct _UndoTextItemClass UndoTextItemClass;
typedef struct _UndoTextItemPrivate UndoTextItemPrivate;

#define TYPE_CANVAS_TEXT (canvas_text_get_type ())
#define CANVAS_TEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CANVAS_TEXT, CanvasText))
#define CANVAS_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CANVAS_TEXT, CanvasTextClass))
#define IS_CANVAS_TEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CANVAS_TEXT))
#define IS_CANVAS_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CANVAS_TEXT))
#define CANVAS_TEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CANVAS_TEXT, CanvasTextClass))

typedef struct _CanvasText CanvasText;
typedef struct _CanvasTextClass CanvasTextClass;

#define TYPE_UNDO_TEXT_TAG_REMOVE (undo_text_tag_remove_get_type ())
#define UNDO_TEXT_TAG_REMOVE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNDO_TEXT_TAG_REMOVE, UndoTextTagRemove))
#define UNDO_TEXT_TAG_REMOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNDO_TEXT_TAG_REMOVE, UndoTextTagRemoveClass))
#define IS_UNDO_TEXT_TAG_REMOVE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNDO_TEXT_TAG_REMOVE))
#define IS_UNDO_TEXT_TAG_REMOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNDO_TEXT_TAG_REMOVE))
#define UNDO_TEXT_TAG_REMOVE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNDO_TEXT_TAG_REMOVE, UndoTextTagRemoveClass))

typedef struct _UndoTextTagRemove UndoTextTagRemove;
typedef struct _UndoTextTagRemoveClass UndoTextTagRemoveClass;
typedef struct _UndoTextTagRemovePrivate UndoTextTagRemovePrivate;
typedef enum  {
	FORMAT_TAG_BOLD = 0,
	FORMAT_TAG_ITALICS,
	FORMAT_TAG_UNDERLINE,
	FORMAT_TAG_STRIKETHRU,
	FORMAT_TAG_CODE,
	FORMAT_TAG_SUB,
	FORMAT_TAG_SUPER,
	FORMAT_TAG_HEADER,
	FORMAT_TAG_COLOR,
	FORMAT_TAG_HILITE,
	FORMAT_TAG_URL,
	FORMAT_TAG_SYNTAX,
	FORMAT_TAG_TAG,
	FORMAT_TAG_MATCH,
	FORMAT_TAG_SELECT,
	FORMAT_TAG_LENGTH
} FormatTag;

#define TYPE_FORMAT_TAG (format_tag_get_type ())
enum  {
	UNDO_TEXT_TAG_REMOVE_0_PROPERTY,
	UNDO_TEXT_TAG_REMOVE_START_PROPERTY,
	UNDO_TEXT_TAG_REMOVE_END_PROPERTY,
	UNDO_TEXT_TAG_REMOVE_TAG_PROPERTY,
	UNDO_TEXT_TAG_REMOVE_EXTRA_PROPERTY,
	UNDO_TEXT_TAG_REMOVE_PARSED_PROPERTY,
	UNDO_TEXT_TAG_REMOVE_NUM_PROPERTIES
};
static GParamSpec* undo_text_tag_remove_properties[UNDO_TEXT_TAG_REMOVE_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
typedef enum  {
	UNDO_TEXT_OP_INSERT = 0,
	UNDO_TEXT_OP_DELETE,
	UNDO_TEXT_OP_REPLACE,
	UNDO_TEXT_OP_TAGADD,
	UNDO_TEXT_OP_TAGDEL,
	UNDO_TEXT_OP_TAGCLEAR
} UndoTextOp;

#define TYPE_UNDO_TEXT_OP (undo_text_op_get_type ())

#define TYPE_FORMATTED_TEXT (formatted_text_get_type ())
#define FORMATTED_TEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FORMATTED_TEXT, FormattedText))
#define FORMATTED_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FORMATTED_TEXT, FormattedTextClass))
#define IS_FORMATTED_TEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FORMATTED_TEXT))
#define IS_FORMATTED_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FORMATTED_TEXT))
#define FORMATTED_TEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FORMATTED_TEXT, FormattedTextClass))

typedef struct _FormattedText FormattedText;
typedef struct _FormattedTextClass FormattedTextClass;

struct _UndoItem {
	GObject parent_instance;
	UndoItemPrivate * priv;
};

struct _UndoItemClass {
	GObjectClass parent_class;
	void (*undo) (UndoItem* self, DrawArea* da);
	void (*redo) (UndoItem* self, DrawArea* da);
	gboolean (*matches) (UndoItem* self, UndoItem* item);
	void (*replace_with_item) (UndoItem* self, UndoItem* item);
	gchar* (*to_string) (UndoItem* self);
};

struct _UndoTextItem {
	UndoItem parent_instance;
	UndoTextItemPrivate * priv;
};

struct _UndoTextItemClass {
	UndoItemClass parent_class;
	gboolean (*merge) (UndoTextItem* self, CanvasText* ct, UndoTextItem* item);
	void (*undo_text) (UndoTextItem* self, DrawArea* da, CanvasText* ct);
	void (*redo_text) (UndoTextItem* self, DrawArea* da, CanvasText* ct);
};

struct _UndoTextTagRemove {
	UndoTextItem parent_instance;
	UndoTextTagRemovePrivate * priv;
};

struct _UndoTextTagRemoveClass {
	UndoTextItemClass parent_class;
};

struct _UndoTextTagRemovePrivate {
	gint _start;
	gint _end;
	FormatTag _tag;
	gchar* _extra;
	gboolean _parsed;
};

static gint UndoTextTagRemove_private_offset;
static gpointer undo_text_tag_remove_parent_class = NULL;

VALA_EXTERN GType undo_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UndoItem, g_object_unref)
VALA_EXTERN GType draw_area_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DrawArea, g_object_unref)
VALA_EXTERN GType undo_text_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UndoTextItem, g_object_unref)
VALA_EXTERN GType canvas_text_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CanvasText, g_object_unref)
VALA_EXTERN GType undo_text_tag_remove_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UndoTextTagRemove, g_object_unref)
VALA_EXTERN GType format_tag_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void undo_text_item_undo_text (UndoTextItem* self,
                               DrawArea* da,
                               CanvasText* ct);
VALA_EXTERN void undo_text_item_redo_text (UndoTextItem* self,
                               DrawArea* da,
                               CanvasText* ct);
VALA_EXTERN gboolean undo_text_item_merge (UndoTextItem* self,
                               CanvasText* ct,
                               UndoTextItem* item);
VALA_EXTERN UndoTextTagRemove* undo_text_tag_remove_new (gint start,
                                             gint end,
                                             FormatTag tag,
                                             const gchar* extra,
                                             gboolean parsed,
                                             gint cursor);
VALA_EXTERN UndoTextTagRemove* undo_text_tag_remove_construct (GType object_type,
                                                   gint start,
                                                   gint end,
                                                   FormatTag tag,
                                                   const gchar* extra,
                                                   gboolean parsed,
                                                   gint cursor);
VALA_EXTERN GType undo_text_op_get_type (void) G_GNUC_CONST ;
VALA_EXTERN UndoTextItem* undo_text_item_new (const gchar* name,
                                  UndoTextOp op,
                                  gint start_cursor,
                                  gint end_cursor);
VALA_EXTERN UndoTextItem* undo_text_item_construct (GType object_type,
                                        const gchar* name,
                                        UndoTextOp op,
                                        gint start_cursor,
                                        gint end_cursor);
static void undo_text_tag_remove_set_start (UndoTextTagRemove* self,
                                     gint value);
static void undo_text_tag_remove_set_end (UndoTextTagRemove* self,
                                   gint value);
static void undo_text_tag_remove_set_tag (UndoTextTagRemove* self,
                                   FormatTag value);
static void undo_text_tag_remove_set_extra (UndoTextTagRemove* self,
                                     const gchar* value);
static void undo_text_tag_remove_set_parsed (UndoTextTagRemove* self,
                                      gboolean value);
static void undo_text_tag_remove_real_undo_text (UndoTextItem* base,
                                          DrawArea* da,
                                          CanvasText* ct);
VALA_EXTERN gpointer formatted_text_ref (gpointer instance);
VALA_EXTERN void formatted_text_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_formatted_text (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
VALA_EXTERN void value_set_formatted_text (GValue* value,
                               gpointer v_object);
VALA_EXTERN void value_take_formatted_text (GValue* value,
                                gpointer v_object);
VALA_EXTERN gpointer value_get_formatted_text (const GValue* value);
VALA_EXTERN GType formatted_text_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FormattedText, formatted_text_unref)
VALA_EXTERN FormattedText* canvas_text_get_text (CanvasText* self);
VALA_EXTERN void formatted_text_add_tag (FormattedText* self,
                             FormatTag tag,
                             gint start,
                             gint end,
                             gboolean parsed,
                             const gchar* extra);
VALA_EXTERN FormatTag undo_text_tag_remove_get_tag (UndoTextTagRemove* self);
VALA_EXTERN gint undo_text_tag_remove_get_start (UndoTextTagRemove* self);
VALA_EXTERN gint undo_text_tag_remove_get_end (UndoTextTagRemove* self);
VALA_EXTERN gboolean undo_text_tag_remove_get_parsed (UndoTextTagRemove* self);
VALA_EXTERN const gchar* undo_text_tag_remove_get_extra (UndoTextTagRemove* self);
VALA_EXTERN void canvas_text_set_cursor_only (CanvasText* self,
                                  gint cursor);
VALA_EXTERN gint undo_text_item_get_start_cursor (UndoTextItem* self);
static void undo_text_tag_remove_real_redo_text (UndoTextItem* base,
                                          DrawArea* da,
                                          CanvasText* ct);
VALA_EXTERN void formatted_text_remove_tag (FormattedText* self,
                                FormatTag tag,
                                gint start,
                                gint end);
VALA_EXTERN gint undo_text_item_get_end_cursor (UndoTextItem* self);
static gboolean undo_text_tag_remove_real_merge (UndoTextItem* base,
                                          CanvasText* ct,
                                          UndoTextItem* item);
static void undo_text_tag_remove_finalize (GObject * obj);
static GType undo_text_tag_remove_get_type_once (void);
static void _vala_undo_text_tag_remove_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);
static void _vala_undo_text_tag_remove_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
undo_text_tag_remove_get_instance_private (UndoTextTagRemove* self)
{
	return G_STRUCT_MEMBER_P (self, UndoTextTagRemove_private_offset);
}

UndoTextTagRemove*
undo_text_tag_remove_construct (GType object_type,
                                gint start,
                                gint end,
                                FormatTag tag,
                                const gchar* extra,
                                gboolean parsed,
                                gint cursor)
{
	UndoTextTagRemove * self = NULL;
	self = (UndoTextTagRemove*) undo_text_item_construct (object_type, _ ("format tag remove"), UNDO_TEXT_OP_TAGDEL, cursor, cursor);
	undo_text_tag_remove_set_start (self, start);
	undo_text_tag_remove_set_end (self, end);
	undo_text_tag_remove_set_tag (self, tag);
	undo_text_tag_remove_set_extra (self, extra);
	undo_text_tag_remove_set_parsed (self, parsed);
	return self;
}

UndoTextTagRemove*
undo_text_tag_remove_new (gint start,
                          gint end,
                          FormatTag tag,
                          const gchar* extra,
                          gboolean parsed,
                          gint cursor)
{
	return undo_text_tag_remove_construct (TYPE_UNDO_TEXT_TAG_REMOVE, start, end, tag, extra, parsed, cursor);
}

static void
undo_text_tag_remove_real_undo_text (UndoTextItem* base,
                                     DrawArea* da,
                                     CanvasText* ct)
{
	UndoTextTagRemove * self;
	FormattedText* _tmp0_;
	FormattedText* _tmp1_;
	FormatTag _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gboolean _tmp5_;
	const gchar* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	self = (UndoTextTagRemove*) base;
	g_return_if_fail (da != NULL);
	g_return_if_fail (ct != NULL);
	_tmp0_ = canvas_text_get_text (ct);
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->_tag;
	_tmp3_ = self->priv->_start;
	_tmp4_ = self->priv->_end;
	_tmp5_ = self->priv->_parsed;
	_tmp6_ = self->priv->_extra;
	formatted_text_add_tag (_tmp1_, _tmp2_, _tmp3_, _tmp4_, _tmp5_, _tmp6_);
	_tmp7_ = undo_text_item_get_start_cursor ((UndoTextItem*) self);
	_tmp8_ = _tmp7_;
	canvas_text_set_cursor_only (ct, _tmp8_);
	gtk_widget_queue_draw ((GtkWidget*) da);
}

static void
undo_text_tag_remove_real_redo_text (UndoTextItem* base,
                                     DrawArea* da,
                                     CanvasText* ct)
{
	UndoTextTagRemove * self;
	FormattedText* _tmp0_;
	FormattedText* _tmp1_;
	FormatTag _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	self = (UndoTextTagRemove*) base;
	g_return_if_fail (da != NULL);
	g_return_if_fail (ct != NULL);
	_tmp0_ = canvas_text_get_text (ct);
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->_tag;
	_tmp3_ = self->priv->_start;
	_tmp4_ = self->priv->_end;
	formatted_text_remove_tag (_tmp1_, _tmp2_, _tmp3_, _tmp4_);
	_tmp5_ = undo_text_item_get_end_cursor ((UndoTextItem*) self);
	_tmp6_ = _tmp5_;
	canvas_text_set_cursor_only (ct, _tmp6_);
	gtk_widget_queue_draw ((GtkWidget*) da);
}

static gboolean
undo_text_tag_remove_real_merge (UndoTextItem* base,
                                 CanvasText* ct,
                                 UndoTextItem* item)
{
	UndoTextTagRemove * self;
	gboolean result;
	self = (UndoTextTagRemove*) base;
	g_return_val_if_fail (ct != NULL, FALSE);
	g_return_val_if_fail (item != NULL, FALSE);
	result = FALSE;
	return result;
}

gint
undo_text_tag_remove_get_start (UndoTextTagRemove* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_start;
	return result;
}

static void
undo_text_tag_remove_set_start (UndoTextTagRemove* self,
                                gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = undo_text_tag_remove_get_start (self);
	if (old_value != value) {
		self->priv->_start = value;
		g_object_notify_by_pspec ((GObject *) self, undo_text_tag_remove_properties[UNDO_TEXT_TAG_REMOVE_START_PROPERTY]);
	}
}

gint
undo_text_tag_remove_get_end (UndoTextTagRemove* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_end;
	return result;
}

static void
undo_text_tag_remove_set_end (UndoTextTagRemove* self,
                              gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = undo_text_tag_remove_get_end (self);
	if (old_value != value) {
		self->priv->_end = value;
		g_object_notify_by_pspec ((GObject *) self, undo_text_tag_remove_properties[UNDO_TEXT_TAG_REMOVE_END_PROPERTY]);
	}
}

FormatTag
undo_text_tag_remove_get_tag (UndoTextTagRemove* self)
{
	FormatTag result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_tag;
	return result;
}

static void
undo_text_tag_remove_set_tag (UndoTextTagRemove* self,
                              FormatTag value)
{
	FormatTag old_value;
	g_return_if_fail (self != NULL);
	old_value = undo_text_tag_remove_get_tag (self);
	if (old_value != value) {
		self->priv->_tag = value;
		g_object_notify_by_pspec ((GObject *) self, undo_text_tag_remove_properties[UNDO_TEXT_TAG_REMOVE_TAG_PROPERTY]);
	}
}

const gchar*
undo_text_tag_remove_get_extra (UndoTextTagRemove* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_extra;
	result = _tmp0_;
	return result;
}

static void
undo_text_tag_remove_set_extra (UndoTextTagRemove* self,
                                const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = undo_text_tag_remove_get_extra (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_extra);
		self->priv->_extra = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, undo_text_tag_remove_properties[UNDO_TEXT_TAG_REMOVE_EXTRA_PROPERTY]);
	}
}

gboolean
undo_text_tag_remove_get_parsed (UndoTextTagRemove* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_parsed;
	return result;
}

static void
undo_text_tag_remove_set_parsed (UndoTextTagRemove* self,
                                 gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = undo_text_tag_remove_get_parsed (self);
	if (old_value != value) {
		self->priv->_parsed = value;
		g_object_notify_by_pspec ((GObject *) self, undo_text_tag_remove_properties[UNDO_TEXT_TAG_REMOVE_PARSED_PROPERTY]);
	}
}

static void
undo_text_tag_remove_class_init (UndoTextTagRemoveClass * klass,
                                 gpointer klass_data)
{
	undo_text_tag_remove_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &UndoTextTagRemove_private_offset);
	((UndoTextItemClass *) klass)->undo_text = (void (*) (UndoTextItem*, DrawArea*, CanvasText*)) undo_text_tag_remove_real_undo_text;
	((UndoTextItemClass *) klass)->redo_text = (void (*) (UndoTextItem*, DrawArea*, CanvasText*)) undo_text_tag_remove_real_redo_text;
	((UndoTextItemClass *) klass)->merge = (gboolean (*) (UndoTextItem*, CanvasText*, UndoTextItem*)) undo_text_tag_remove_real_merge;
	G_OBJECT_CLASS (klass)->get_property = _vala_undo_text_tag_remove_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_undo_text_tag_remove_set_property;
	G_OBJECT_CLASS (klass)->finalize = undo_text_tag_remove_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNDO_TEXT_TAG_REMOVE_START_PROPERTY, undo_text_tag_remove_properties[UNDO_TEXT_TAG_REMOVE_START_PROPERTY] = g_param_spec_int ("start", "start", "start", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNDO_TEXT_TAG_REMOVE_END_PROPERTY, undo_text_tag_remove_properties[UNDO_TEXT_TAG_REMOVE_END_PROPERTY] = g_param_spec_int ("end", "end", "end", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNDO_TEXT_TAG_REMOVE_TAG_PROPERTY, undo_text_tag_remove_properties[UNDO_TEXT_TAG_REMOVE_TAG_PROPERTY] = g_param_spec_enum ("tag", "tag", "tag", TYPE_FORMAT_TAG, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNDO_TEXT_TAG_REMOVE_EXTRA_PROPERTY, undo_text_tag_remove_properties[UNDO_TEXT_TAG_REMOVE_EXTRA_PROPERTY] = g_param_spec_string ("extra", "extra", "extra", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNDO_TEXT_TAG_REMOVE_PARSED_PROPERTY, undo_text_tag_remove_properties[UNDO_TEXT_TAG_REMOVE_PARSED_PROPERTY] = g_param_spec_boolean ("parsed", "parsed", "parsed", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
undo_text_tag_remove_instance_init (UndoTextTagRemove * self,
                                    gpointer klass)
{
	self->priv = undo_text_tag_remove_get_instance_private (self);
}

static void
undo_text_tag_remove_finalize (GObject * obj)
{
	UndoTextTagRemove * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_UNDO_TEXT_TAG_REMOVE, UndoTextTagRemove);
	_g_free0 (self->priv->_extra);
	G_OBJECT_CLASS (undo_text_tag_remove_parent_class)->finalize (obj);
}

static GType
undo_text_tag_remove_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (UndoTextTagRemoveClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) undo_text_tag_remove_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UndoTextTagRemove), 0, (GInstanceInitFunc) undo_text_tag_remove_instance_init, NULL };
	GType undo_text_tag_remove_type_id;
	undo_text_tag_remove_type_id = g_type_register_static (TYPE_UNDO_TEXT_ITEM, "UndoTextTagRemove", &g_define_type_info, 0);
	UndoTextTagRemove_private_offset = g_type_add_instance_private (undo_text_tag_remove_type_id, sizeof (UndoTextTagRemovePrivate));
	return undo_text_tag_remove_type_id;
}

GType
undo_text_tag_remove_get_type (void)
{
	static volatile gsize undo_text_tag_remove_type_id__once = 0;
	if (g_once_init_enter (&undo_text_tag_remove_type_id__once)) {
		GType undo_text_tag_remove_type_id;
		undo_text_tag_remove_type_id = undo_text_tag_remove_get_type_once ();
		g_once_init_leave (&undo_text_tag_remove_type_id__once, undo_text_tag_remove_type_id);
	}
	return undo_text_tag_remove_type_id__once;
}

static void
_vala_undo_text_tag_remove_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	UndoTextTagRemove * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_UNDO_TEXT_TAG_REMOVE, UndoTextTagRemove);
	switch (property_id) {
		case UNDO_TEXT_TAG_REMOVE_START_PROPERTY:
		g_value_set_int (value, undo_text_tag_remove_get_start (self));
		break;
		case UNDO_TEXT_TAG_REMOVE_END_PROPERTY:
		g_value_set_int (value, undo_text_tag_remove_get_end (self));
		break;
		case UNDO_TEXT_TAG_REMOVE_TAG_PROPERTY:
		g_value_set_enum (value, undo_text_tag_remove_get_tag (self));
		break;
		case UNDO_TEXT_TAG_REMOVE_EXTRA_PROPERTY:
		g_value_set_string (value, undo_text_tag_remove_get_extra (self));
		break;
		case UNDO_TEXT_TAG_REMOVE_PARSED_PROPERTY:
		g_value_set_boolean (value, undo_text_tag_remove_get_parsed (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_undo_text_tag_remove_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec)
{
	UndoTextTagRemove * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_UNDO_TEXT_TAG_REMOVE, UndoTextTagRemove);
	switch (property_id) {
		case UNDO_TEXT_TAG_REMOVE_START_PROPERTY:
		undo_text_tag_remove_set_start (self, g_value_get_int (value));
		break;
		case UNDO_TEXT_TAG_REMOVE_END_PROPERTY:
		undo_text_tag_remove_set_end (self, g_value_get_int (value));
		break;
		case UNDO_TEXT_TAG_REMOVE_TAG_PROPERTY:
		undo_text_tag_remove_set_tag (self, g_value_get_enum (value));
		break;
		case UNDO_TEXT_TAG_REMOVE_EXTRA_PROPERTY:
		undo_text_tag_remove_set_extra (self, g_value_get_string (value));
		break;
		case UNDO_TEXT_TAG_REMOVE_PARSED_PROPERTY:
		undo_text_tag_remove_set_parsed (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

