/* MainWindow.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from MainWindow.vala, do not modify */

/*
 * SPDX-License-Identifier: GPL-2.0-or-later
 * SPDX-FileCopyrightText: 2018-2025 elementary, Inc. (https://elementary.io)
 *
 * Authors: Corentin Noël <corentin@elementary.io>
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <lightdm.h>
#include "pantheon-desktop-shell-client-protocol.h"
#include <glib.h>
#include <handy.h>
#include <gio/gio.h>
#include <wayland-client.h>
#include <gdk/gdk.h>
#include <gdk/gdkwayland.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdkx.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>
#include <X11/Xregion.h>
#include <granite.h>
#include <glib/gi18n-lib.h>
#include <gio/gdesktopappinfo.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GREETER_TYPE_MAIN_WINDOW (greeter_main_window_get_type ())
#define GREETER_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GREETER_TYPE_MAIN_WINDOW, GreeterMainWindow))
#define GREETER_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GREETER_TYPE_MAIN_WINDOW, GreeterMainWindowClass))
#define GREETER_IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GREETER_TYPE_MAIN_WINDOW))
#define GREETER_IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GREETER_TYPE_MAIN_WINDOW))
#define GREETER_MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GREETER_TYPE_MAIN_WINDOW, GreeterMainWindowClass))

typedef struct _GreeterMainWindow GreeterMainWindow;
typedef struct _GreeterMainWindowClass GreeterMainWindowClass;
typedef struct _GreeterMainWindowPrivate GreeterMainWindowPrivate;

#define GREETER_TYPE_BASE_CARD (greeter_base_card_get_type ())
#define GREETER_BASE_CARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GREETER_TYPE_BASE_CARD, GreeterBaseCard))
#define GREETER_BASE_CARD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GREETER_TYPE_BASE_CARD, GreeterBaseCardClass))
#define GREETER_IS_BASE_CARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GREETER_TYPE_BASE_CARD))
#define GREETER_IS_BASE_CARD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GREETER_TYPE_BASE_CARD))
#define GREETER_BASE_CARD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GREETER_TYPE_BASE_CARD, GreeterBaseCardClass))

typedef struct _GreeterBaseCard GreeterBaseCard;
typedef struct _GreeterBaseCardClass GreeterBaseCardClass;

#define GREETER_TYPE_USER_CARD (greeter_user_card_get_type ())
#define GREETER_USER_CARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GREETER_TYPE_USER_CARD, GreeterUserCard))
#define GREETER_USER_CARD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GREETER_TYPE_USER_CARD, GreeterUserCardClass))
#define GREETER_IS_USER_CARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GREETER_TYPE_USER_CARD))
#define GREETER_IS_USER_CARD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GREETER_TYPE_USER_CARD))
#define GREETER_USER_CARD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GREETER_TYPE_USER_CARD, GreeterUserCardClass))

typedef struct _GreeterUserCard GreeterUserCard;
typedef struct _GreeterUserCardClass GreeterUserCardClass;

#define GREETER_TYPE_SETTINGS (greeter_settings_get_type ())
#define GREETER_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GREETER_TYPE_SETTINGS, GreeterSettings))
#define GREETER_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GREETER_TYPE_SETTINGS, GreeterSettingsClass))
#define GREETER_IS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GREETER_TYPE_SETTINGS))
#define GREETER_IS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GREETER_TYPE_SETTINGS))
#define GREETER_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GREETER_TYPE_SETTINGS, GreeterSettingsClass))

typedef struct _GreeterSettings GreeterSettings;
typedef struct _GreeterSettingsClass GreeterSettingsClass;

#define GREETER_TYPE_DATE_TIME_WIDGET (greeter_date_time_widget_get_type ())
#define GREETER_DATE_TIME_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GREETER_TYPE_DATE_TIME_WIDGET, GreeterDateTimeWidget))
#define GREETER_DATE_TIME_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GREETER_TYPE_DATE_TIME_WIDGET, GreeterDateTimeWidgetClass))
#define GREETER_IS_DATE_TIME_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GREETER_TYPE_DATE_TIME_WIDGET))
#define GREETER_IS_DATE_TIME_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GREETER_TYPE_DATE_TIME_WIDGET))
#define GREETER_DATE_TIME_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GREETER_TYPE_DATE_TIME_WIDGET, GreeterDateTimeWidgetClass))

typedef struct _GreeterDateTimeWidget GreeterDateTimeWidget;
typedef struct _GreeterDateTimeWidgetClass GreeterDateTimeWidgetClass;
enum  {
	GREETER_MAIN_WINDOW_0_PROPERTY,
	GREETER_MAIN_WINDOW_LIGHTDM_GREETER_PROPERTY,
	GREETER_MAIN_WINDOW_NUM_PROPERTIES
};
static GParamSpec* greeter_main_window_properties[GREETER_MAIN_WINDOW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _wl_proxy_destroy0(var) ((var == NULL) ? NULL : (var = (wl_proxy_destroy (var), NULL)))
typedef void (*wl_RegistryListenerGlobal) (void* data, struct wl_registry* wl_registry, guint32 name, const gchar* interface, guint32 version);
#define _wl_registry_destroy0(var) ((var == NULL) ? NULL : (var = (wl_registry_destroy (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef enum  {
	GREETER_FPRINT_UTILS_MESSAGE_TEXT_FPRINT_SWIPE,
	GREETER_FPRINT_UTILS_MESSAGE_TEXT_FPRINT_SWIPE_AGAIN,
	GREETER_FPRINT_UTILS_MESSAGE_TEXT_FPRINT_SWIPE_TOO_SHORT,
	GREETER_FPRINT_UTILS_MESSAGE_TEXT_FPRINT_NOT_CENTERED,
	GREETER_FPRINT_UTILS_MESSAGE_TEXT_FPRINT_REMOVE,
	GREETER_FPRINT_UTILS_MESSAGE_TEXT_FPRINT_PLACE,
	GREETER_FPRINT_UTILS_MESSAGE_TEXT_FPRINT_PLACE_AGAIN,
	GREETER_FPRINT_UTILS_MESSAGE_TEXT_FPRINT_NO_MATCH,
	GREETER_FPRINT_UTILS_MESSAGE_TEXT_FPRINT_TIMEOUT,
	GREETER_FPRINT_UTILS_MESSAGE_TEXT_FPRINT_ERROR,
	GREETER_FPRINT_UTILS_MESSAGE_TEXT_FAILED,
	GREETER_FPRINT_UTILS_MESSAGE_TEXT_OTHER
} GreeterFPrintUtilsMessageText;

#define GREETER_FPRINT_UTILS_TYPE_MESSAGE_TEXT (greeter_fprint_utils_message_text_get_type ())

#define GREETER_TYPE_MANUAL_CARD (greeter_manual_card_get_type ())
#define GREETER_MANUAL_CARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GREETER_TYPE_MANUAL_CARD, GreeterManualCard))
#define GREETER_MANUAL_CARD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GREETER_TYPE_MANUAL_CARD, GreeterManualCardClass))
#define GREETER_IS_MANUAL_CARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GREETER_TYPE_MANUAL_CARD))
#define GREETER_IS_MANUAL_CARD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GREETER_TYPE_MANUAL_CARD))
#define GREETER_MANUAL_CARD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GREETER_TYPE_MANUAL_CARD, GreeterManualCardClass))

typedef struct _GreeterManualCard GreeterManualCard;
typedef struct _GreeterManualCardClass GreeterManualCardClass;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block3Data Block3Data;
typedef struct _GreeterMainWindowLoadUsersData GreeterMainWindowLoadUsersData;
typedef struct _Block4Data Block4Data;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _GreeterMainWindow {
	GtkApplicationWindow parent_instance;
	GreeterMainWindowPrivate * priv;
};

struct _GreeterMainWindowClass {
	GtkApplicationWindowClass parent_class;
};

struct _GreeterMainWindowPrivate {
	LightDMGreeter* _lightdm_greeter;
	struct io_elementary_pantheon_greeter_v1* desktop_greeter;
	GQueue* user_cards;
	GtkSizeGroup* card_size_group;
	HdyCarousel* carousel;
	GreeterSettings* settings;
	GSettings* gsettings;
	GtkRevealer* datetime_revealer;
	GreeterDateTimeWidget* datetime_widget;
	LightDMUserList* lightdm_user_list;
	gint current_user_card_index;
	GreeterBaseCard* current_card;
	gboolean installer_mode;
	GtkEventControllerKey* key_controller;
};

struct _Block3Data {
	int _ref_count_;
	GreeterMainWindow* self;
	gchar* user_to_select;
	gboolean user_selected;
};

struct _GreeterMainWindowLoadUsersData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GreeterMainWindow* self;
	GDesktopAppInfo* installer_desktop;
	GDesktopAppInfo* _tmp0_;
	GDesktopAppInfo* _tmp1_;
	LightDMUserList* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	Block3Data* _data3_;
	GtkRevealer* _tmp5_;
	LightDMUserList* _tmp6_;
	GList* _tmp7_;
	GList* _tmp8_;
	const gchar* select_user;
	LightDMGreeter* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	GSettings* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	GQueue* _tmp19_;
	GList* _tmp20_;
	GreeterUserCard* user_card;
	GQueue* _tmp21_;
	gconstpointer _tmp22_;
	GreeterUserCard* _tmp23_;
	HdyCarousel* _tmp24_;
	GreeterUserCard* _tmp25_;
	GtkRevealer* _tmp26_;
};

struct _Block4Data {
	int _ref_count_;
	GreeterMainWindow* self;
	GtkToggleButton* manual_login_button;
	GreeterManualCard* manual_card;
	GtkStack* manual_login_stack;
};

static gint GreeterMainWindow_private_offset;
static gpointer greeter_main_window_parent_class = NULL;
static struct wl_registry_listener greeter_main_window_registry_listener;
static struct wl_registry_listener greeter_main_window_registry_listener = {0};

VALA_EXTERN GType greeter_main_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GreeterMainWindow, g_object_unref)
VALA_EXTERN GType greeter_base_card_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GreeterBaseCard, g_object_unref)
VALA_EXTERN GType greeter_user_card_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GreeterUserCard, g_object_unref)
VALA_EXTERN GType greeter_settings_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GreeterSettings, g_object_unref)
VALA_EXTERN GType greeter_date_time_widget_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GreeterDateTimeWidget, g_object_unref)
VALA_EXTERN GreeterMainWindow* greeter_main_window_new (LightDMGreeter* lightdm_greeter);
VALA_EXTERN GreeterMainWindow* greeter_main_window_construct (GType object_type,
                                                  LightDMGreeter* lightdm_greeter);
static void greeter_main_window_init_panel (GreeterMainWindow* self);
static void greeter_main_window_init_wl (GreeterMainWindow* self);
static void _greeter_main_window_init_wl_gsource_once_func (gpointer self);
static void greeter_main_window_init_x (GreeterMainWindow* self);
VALA_EXTERN void greeter_main_window_registry_handle_global (GreeterMainWindow* self,
                                                 struct wl_registry* wl_registry,
                                                 guint32 name,
                                                 const gchar* interface,
                                                 guint32 version);
static void _greeter_main_window_registry_handle_global_wl_registrylistenerglobal (void* data,
                                                                            struct wl_registry* wl_registry,
                                                                            guint32 name,
                                                                            const gchar* interface,
                                                                            guint32 version);
static void greeter_main_window_show_message (GreeterMainWindow* self,
                                       const gchar* text,
                                       LightDMMessageType type);
VALA_EXTERN GType greeter_fprint_utils_message_text_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GreeterFPrintUtilsMessageText greeter_fprint_utils_string_to_messagetext (const gchar* text);
VALA_EXTERN void greeter_base_card_set_use_fingerprint (GreeterBaseCard* self,
                                            gboolean value);
static void greeter_main_window_show_prompt (GreeterMainWindow* self,
                                      const gchar* text,
                                      LightDMPromptType type);
VALA_EXTERN GType greeter_manual_card_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GreeterManualCard, g_object_unref)
VALA_EXTERN void greeter_manual_card_ask_password (GreeterManualCard* self);
VALA_EXTERN void greeter_manual_card_wrong_username (GreeterManualCard* self);
static void greeter_main_window_authentication_complete (GreeterMainWindow* self);
VALA_EXTERN LightDMUser* greeter_user_card_get_lightdm_user (GreeterUserCard* self);
static LightDMGreeter* greeter_main_window_get_lightdm_greeter (GreeterMainWindow* self);
static void _gtk_widget_destroy_gtk_dialog_response (GtkDialog* _sender,
                                              gint response_id,
                                              gpointer self);
VALA_EXTERN void greeter_base_card_wrong_credentials (GreeterBaseCard* self);
static void greeter_main_window_load_users_data_free (gpointer _data);
static void greeter_main_window_load_users (GreeterMainWindow* self,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_);
static void greeter_main_window_load_users_finish (GreeterMainWindow* self,
                                            GAsyncResult* _res_);
static gboolean greeter_main_window_load_users_co (GreeterMainWindowLoadUsersData* _data_);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void ___lambda20_ (GreeterMainWindow* self,
                   LightDMUser* user);
static void greeter_main_window_add_card (GreeterMainWindow* self,
                                   LightDMUser* lightdm_user);
static void ____lambda20__gfunc (gconstpointer data,
                          gpointer self);
static void ___lambda24_ (Block3Data* _data3_,
                   GreeterUserCard* card);
static void ____lambda24__gfunc (gconstpointer data,
                          gpointer self);
VALA_EXTERN void greeter_user_card_set_show_input (GreeterUserCard* self,
                                       gboolean value);
static gboolean ___lambda25_ (GreeterMainWindow* self);
static gboolean ____lambda25__gsource_func (gpointer self);
VALA_EXTERN GreeterUserCard* greeter_user_card_new (LightDMUser* lightdm_user);
VALA_EXTERN GreeterUserCard* greeter_user_card_construct (GType object_type,
                                              LightDMUser* lightdm_user);
static void greeter_main_window_do_connect (GreeterMainWindow* self,
                                     const gchar* credential);
static void _greeter_main_window_do_connect_greeter_base_card_do_connect (GreeterBaseCard* _sender,
                                                                   const gchar* credential,
                                                                   gpointer self);
VALA_EXTERN GtkGestureMultiPress* greeter_user_card_get_click_gesture (GreeterUserCard* self);
static void __lambda21_ (GreeterMainWindow* self,
                  GtkGestureMultiPress* gesture,
                  gint n_press,
                  gdouble x,
                  gdouble y);
VALA_EXTERN gboolean greeter_user_card_get_show_input (GreeterUserCard* self);
static void ___lambda21__gtk_gesture_multi_press_pressed (GtkGestureMultiPress* _sender,
                                                   gint n_press,
                                                   gdouble x,
                                                   gdouble y,
                                                   gpointer self);
static void __lambda22_ (GreeterMainWindow* self);
static void greeter_main_window_go_previous (GreeterMainWindow* self);
static void greeter_main_window_go_next (GreeterMainWindow* self);
static void ___lambda22__greeter_base_card_go_left (GreeterBaseCard* _sender,
                                             gpointer self);
static void __lambda23_ (GreeterMainWindow* self);
static void ___lambda23__greeter_base_card_go_right (GreeterBaseCard* _sender,
                                              gpointer self);
static void greeter_main_window_handle_page_changed (GreeterMainWindow* self,
                                              guint index);
VALA_EXTERN gboolean greeter_user_card_get_is_24h (GreeterUserCard* self);
VALA_EXTERN void greeter_date_time_widget_set_is_24h (GreeterDateTimeWidget* self,
                                          gboolean value);
VALA_EXTERN void greeter_user_card_set_settings (GreeterUserCard* self);
static void greeter_main_window_do_connect_username (GreeterMainWindow* self,
                                              const gchar* username);
static void greeter_main_window_set_lightdm_greeter (GreeterMainWindow* self,
                                              LightDMGreeter* value);
static GObject * greeter_main_window_constructor (GType type,
                                           guint n_construct_properties,
                                           GObjectConstructParam * construct_properties);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
VALA_EXTERN GreeterSettings* greeter_settings_new (void);
VALA_EXTERN GreeterSettings* greeter_settings_construct (GType object_type);
static void _greeter_main_window_show_message_lightdm_greeter_show_message (LightDMGreeter* _sender,
                                                                     const gchar* text,
                                                                     LightDMMessageType type,
                                                                     gpointer self);
static void _greeter_main_window_show_prompt_lightdm_greeter_show_prompt (LightDMGreeter* _sender,
                                                                   const gchar* text,
                                                                   LightDMPromptType type,
                                                                   gpointer self);
static void _greeter_main_window_authentication_complete_lightdm_greeter_authentication_complete (LightDMGreeter* _sender,
                                                                                           gpointer self);
VALA_EXTERN GreeterDateTimeWidget* greeter_date_time_widget_new (void);
VALA_EXTERN GreeterDateTimeWidget* greeter_date_time_widget_construct (GType object_type);
VALA_EXTERN GreeterManualCard* greeter_manual_card_new (void);
VALA_EXTERN GreeterManualCard* greeter_manual_card_construct (GType object_type);
static void _greeter_main_window___lambda26_ (Block4Data* _data4_);
static void __greeter_main_window___lambda26__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                  gpointer self);
static void _greeter_main_window___lambda27_ (GreeterMainWindow* self);
static void __greeter_main_window___lambda27__gtk_button_clicked (GtkButton* _sender,
                                                           gpointer self);
static void _greeter_main_window___lambda28_ (GreeterMainWindow* self);
static void __greeter_main_window___lambda28__lightdm_user_list_user_added (LightDMUserList* _sender,
                                                                     LightDMUser* user,
                                                                     gpointer self);
static void _greeter_main_window_do_connect_username_greeter_manual_card_do_connect_username (GreeterManualCard* _sender,
                                                                                       const gchar* username,
                                                                                       gpointer self);
static gboolean _greeter_main_window___lambda29_ (GreeterMainWindow* self,
                                           guint keyval,
                                           guint keycode,
                                           GdkModifierType state);
static gboolean __greeter_main_window___lambda29__gtk_event_controller_key_key_pressed (GtkEventControllerKey* _sender,
                                                                                 guint keyval,
                                                                                 guint keycode,
                                                                                 GdkModifierType state,
                                                                                 gpointer self);
static void _greeter_main_window_handle_page_changed_hdy_carousel_page_changed (HdyCarousel* _sender,
                                                                         guint index,
                                                                         gpointer self);
static void _greeter_main_window___lambda30_ (GreeterMainWindow* self);
static gboolean __lambda31_ (GreeterMainWindow* self);
static gboolean ___lambda31__gsource_func (gpointer self);
static void __greeter_main_window___lambda30__gasync_ready_callback (GObject* source_object,
                                                              GAsyncResult* res,
                                                              gpointer self);
VALA_EXTERN gboolean greeter_settings_get_activate_numlock (GreeterSettings* self);
static void _greeter_main_window_init_panel_gtk_widget_realize (GtkWidget* _sender,
                                                         gpointer self);
static void greeter_main_window_finalize (GObject * obj);
static GType greeter_main_window_get_type_once (void);
static void _vala_greeter_main_window_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);
static void _vala_greeter_main_window_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
greeter_main_window_get_instance_private (GreeterMainWindow* self)
{
	return G_STRUCT_MEMBER_P (self, GreeterMainWindow_private_offset);
}

GreeterMainWindow*
greeter_main_window_construct (GType object_type,
                               LightDMGreeter* lightdm_greeter)
{
	GreeterMainWindow * self = NULL;
	g_return_val_if_fail (lightdm_greeter != NULL, NULL);
	self = (GreeterMainWindow*) g_object_new (object_type, "lightdm-greeter", lightdm_greeter, NULL);
	return self;
}

GreeterMainWindow*
greeter_main_window_new (LightDMGreeter* lightdm_greeter)
{
	return greeter_main_window_construct (GREETER_TYPE_MAIN_WINDOW, lightdm_greeter);
}

static void
_greeter_main_window_init_wl_gsource_once_func (gpointer self)
{
	greeter_main_window_init_wl ((GreeterMainWindow*) self);
}

static void
greeter_main_window_init_panel (GreeterMainWindow* self)
{
	GdkDisplay* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gdk_display_get_default ();
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GDK_TYPE_WAYLAND_DISPLAY)) {
		g_idle_add_once (_greeter_main_window_init_wl_gsource_once_func, self);
	} else {
		greeter_main_window_init_x (self);
	}
}

static void
_greeter_main_window_registry_handle_global_wl_registrylistenerglobal (void* data,
                                                                       struct wl_registry* wl_registry,
                                                                       guint32 name,
                                                                       const gchar* interface,
                                                                       guint32 version)
{
	greeter_main_window_registry_handle_global (data, wl_registry, name, interface, version);
}

static void
greeter_main_window_init_wl (GreeterMainWindow* self)
{
	GdkDisplay* display = NULL;
	GdkDisplay* _tmp0_;
	GdkDisplay* _tmp1_;
	g_return_if_fail (self != NULL);
	greeter_main_window_registry_listener.global = _greeter_main_window_registry_handle_global_wl_registrylistenerglobal;
	_tmp0_ = gdk_display_get_default ();
	display = _tmp0_;
	_tmp1_ = display;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, GDK_TYPE_WAYLAND_DISPLAY)) {
		struct wl_display* wl_display = NULL;
		GdkDisplay* _tmp2_;
		struct wl_display* _tmp3_;
		struct wl_registry* wl_registry = NULL;
		struct wl_display* _tmp4_;
		struct wl_registry* _tmp5_;
		struct wl_registry* _tmp6_;
		struct wl_registry_listener _tmp7_;
		struct wl_display* _tmp8_;
		_tmp2_ = display;
		_tmp3_ = gdk_wayland_display_get_wl_display (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GDK_TYPE_WAYLAND_DISPLAY, GdkWaylandDisplay));
		wl_display = _tmp3_;
		_tmp4_ = wl_display;
		_tmp5_ = wl_display_get_registry (_tmp4_);
		wl_registry = _tmp5_;
		_tmp6_ = wl_registry;
		_tmp7_ = greeter_main_window_registry_listener;
		wl_registry_add_listener (_tmp6_, &_tmp7_, self);
		_tmp8_ = wl_display;
		if (wl_display_roundtrip (_tmp8_) < 0) {
			_wl_registry_destroy0 (wl_registry);
			return;
		}
		_wl_registry_destroy0 (wl_registry);
	}
}

void
greeter_main_window_registry_handle_global (GreeterMainWindow* self,
                                            struct wl_registry* wl_registry,
                                            guint32 name,
                                            const gchar* interface,
                                            guint32 version)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (wl_registry != NULL);
	g_return_if_fail (interface != NULL);
	if (g_strcmp0 (interface, "io_elementary_pantheon_shell_v1") == 0) {
		struct io_elementary_pantheon_shell_v1* desktop_shell = NULL;
		gpointer _tmp0_;
		GdkWindow* window = NULL;
		GdkWindow* _tmp1_;
		GdkWindow* _tmp2_;
		_tmp0_ = wl_registry_bind (wl_registry, name, &io_elementary_pantheon_shell_v1_interface, MIN (version, (guint32) 1));
		desktop_shell = (struct io_elementary_pantheon_shell_v1*) _tmp0_;
		_tmp1_ = gtk_widget_get_window ((GtkWidget*) self);
		window = _tmp1_;
		_tmp2_ = window;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, GDK_TYPE_WAYLAND_WINDOW)) {
			struct wl_surface* wl_surface = NULL;
			GdkWindow* _tmp3_;
			struct wl_surface* _tmp4_;
			struct io_elementary_pantheon_shell_v1* _tmp5_;
			struct wl_surface* _tmp6_;
			struct io_elementary_pantheon_greeter_v1* _tmp7_;
			struct io_elementary_pantheon_greeter_v1* _tmp8_;
			_tmp3_ = window;
			_tmp4_ = gdk_wayland_window_get_wl_surface (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GDK_TYPE_WAYLAND_WINDOW, GdkWaylandWindow));
			wl_surface = _tmp4_;
			_tmp5_ = desktop_shell;
			_tmp6_ = wl_surface;
			_tmp7_ = io_elementary_pantheon_shell_v1_get_greeter (_tmp5_, _tmp6_);
			_wl_proxy_destroy0 (self->priv->desktop_greeter);
			self->priv->desktop_greeter = _tmp7_;
			_tmp8_ = self->priv->desktop_greeter;
			io_elementary_pantheon_greeter_v1_init (_tmp8_);
		}
		_wl_proxy_destroy0 (desktop_shell);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
greeter_main_window_init_x (GreeterMainWindow* self)
{
	GdkDisplay* display = NULL;
	GdkDisplay* _tmp0_;
	GdkDisplay* _tmp1_;
	GdkDisplay* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gdk_display_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	display = _tmp1_;
	_tmp2_ = display;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gdk_x11_display_get_type ())) {
		Display* xdisplay = NULL;
		GdkDisplay* _tmp3_;
		Display* _tmp4_;
		Window window = 0;
		GdkWindow* _tmp5_;
		Atom prop = {0};
		Display* _tmp6_;
		gchar* value = NULL;
		gchar* _tmp7_;
		Display* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		_tmp3_ = display;
		_tmp4_ = gdk_x11_display_get_xdisplay (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gdk_x11_display_get_type (), GdkX11Display));
		xdisplay = _tmp4_;
		_tmp5_ = gtk_widget_get_window ((GtkWidget*) self);
		window = gdk_x11_window_get_xid (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gdk_x11_window_get_type (), GdkX11Window));
		_tmp6_ = xdisplay;
		prop = XInternAtom (_tmp6_, "_MUTTER_HINTS", FALSE);
		_tmp7_ = g_strdup ("greeter=1");
		value = _tmp7_;
		_tmp8_ = xdisplay;
		_tmp9_ = value;
		_tmp10_ = value;
		_tmp11_ = strlen (_tmp10_);
		_tmp12_ = _tmp11_;
		XChangeProperty (_tmp8_, window, prop, XA_STRING, 8, 0, (guchar*) _tmp9_, _tmp12_);
		_g_free0 (value);
	}
	_g_object_unref0 (display);
}

static void
greeter_main_window_show_message (GreeterMainWindow* self,
                                  const gchar* text,
                                  LightDMMessageType type)
{
	GreeterFPrintUtilsMessageText messagetext = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	messagetext = greeter_fprint_utils_string_to_messagetext (text);
	switch (messagetext) {
		case GREETER_FPRINT_UTILS_MESSAGE_TEXT_FPRINT_TIMEOUT:
		case GREETER_FPRINT_UTILS_MESSAGE_TEXT_FPRINT_ERROR:
		case GREETER_FPRINT_UTILS_MESSAGE_TEXT_OTHER:
		{
			GreeterBaseCard* _tmp0_;
			_tmp0_ = self->priv->current_card;
			greeter_base_card_set_use_fingerprint (_tmp0_, FALSE);
			break;
		}
		default:
		{
			GreeterBaseCard* _tmp1_;
			_tmp1_ = self->priv->current_card;
			greeter_base_card_set_use_fingerprint (_tmp1_, TRUE);
			break;
		}
	}
}

static void
greeter_main_window_show_prompt (GreeterMainWindow* self,
                                 const gchar* text,
                                 LightDMPromptType type)
{
	GreeterBaseCard* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = self->priv->current_card;
	if (GREETER_IS_MANUAL_CARD (_tmp0_)) {
		if (type == LIGHTDM_PROMPT_TYPE_SECRET) {
			GreeterBaseCard* _tmp1_;
			_tmp1_ = self->priv->current_card;
			greeter_manual_card_ask_password (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GREETER_TYPE_MANUAL_CARD, GreeterManualCard));
		} else {
			GreeterBaseCard* _tmp2_;
			_tmp2_ = self->priv->current_card;
			greeter_manual_card_wrong_username (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GREETER_TYPE_MANUAL_CARD, GreeterManualCard));
		}
	}
}

static void
_gtk_widget_destroy_gtk_dialog_response (GtkDialog* _sender,
                                         gint response_id,
                                         gpointer self)
{
	gtk_widget_destroy ((GtkWidget*) self);
}

static void
greeter_main_window_authentication_complete (GreeterMainWindow* self)
{
	GreeterUserCard* user_card = NULL;
	GreeterBaseCard* _tmp0_;
	GreeterUserCard* _tmp1_;
	GreeterUserCard* _tmp2_;
	LightDMGreeter* _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp11_;
	GreeterUserCard* _tmp32_;
	GreeterBaseCard* _tmp41_;
	HdyCarousel* _tmp42_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->current_card;
	_tmp1_ = _g_object_ref0 (GREETER_IS_USER_CARD (_tmp0_) ? ((GreeterUserCard*) _tmp0_) : NULL);
	user_card = _tmp1_;
	_tmp2_ = user_card;
	if (_tmp2_ != NULL) {
		GSettings* _tmp3_;
		GreeterUserCard* _tmp4_;
		LightDMUser* _tmp5_;
		LightDMUser* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		_tmp3_ = self->priv->gsettings;
		_tmp4_ = user_card;
		_tmp5_ = greeter_user_card_get_lightdm_user (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = lightdm_user_get_name (_tmp6_);
		_tmp8_ = _tmp7_;
		g_settings_set_string (_tmp3_, "last-user", _tmp8_);
	}
	_tmp9_ = self->priv->_lightdm_greeter;
	_tmp10_ = lightdm_greeter_get_is_authenticated (_tmp9_);
	_tmp11_ = _tmp10_;
	if (_tmp11_) {
		{
			const gchar* session = NULL;
			GtkApplication* _tmp12_;
			GtkApplication* _tmp13_;
			GVariant* _tmp14_;
			GVariant* _tmp15_;
			const gchar* _tmp16_;
			const gchar* _tmp17_;
			GSettings* _tmp21_;
			const gchar* _tmp22_;
			LightDMGreeter* _tmp23_;
			const gchar* _tmp24_;
			_tmp12_ = gtk_window_get_application ((GtkWindow*) self);
			_tmp13_ = _tmp12_;
			_tmp14_ = g_action_group_get_action_state ((GActionGroup*) _tmp13_, "select-session");
			_tmp15_ = _tmp14_;
			_tmp16_ = g_variant_get_string (_tmp15_, NULL);
			_tmp17_ = _tmp16_;
			_g_variant_unref0 (_tmp15_);
			session = _tmp17_;
			if (self->priv->installer_mode) {
				GFile* demo_mode_file = NULL;
				GFile* _tmp18_;
				GFile* _tmp19_;
				_tmp18_ = g_file_new_for_path ("/var/lib/lightdm/demo-mode");
				demo_mode_file = _tmp18_;
				_tmp19_ = demo_mode_file;
				if (g_file_query_exists (_tmp19_, NULL)) {
					GFile* _tmp20_;
					_tmp20_ = demo_mode_file;
					g_file_delete (_tmp20_, NULL, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_object_unref0 (demo_mode_file);
						goto __catch0_g_error;
					}
					session = "pantheon";
				} else {
					session = "installer";
				}
				_g_object_unref0 (demo_mode_file);
			}
			_tmp21_ = self->priv->gsettings;
			_tmp22_ = session;
			g_settings_set_string (_tmp21_, "last-session-type", _tmp22_);
			_tmp23_ = self->priv->_lightdm_greeter;
			_tmp24_ = session;
			lightdm_greeter_start_session_sync (_tmp23_, _tmp24_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_g_object_unref0 (user_card);
			return;
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GraniteMessageDialog* error_dialog = NULL;
			GraniteMessageDialog* _tmp25_;
			GraniteMessageDialog* _tmp26_;
			GError* _tmp27_;
			const gchar* _tmp28_;
			GraniteMessageDialog* _tmp29_;
			GraniteMessageDialog* _tmp30_;
			GraniteMessageDialog* _tmp31_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp25_ = granite_message_dialog_new_with_image_from_icon_name (_ ("Unable to Log In"), _ ("Starting the session has failed."), "dialog-error", GTK_BUTTONS_CLOSE);
			g_object_ref_sink (_tmp25_);
			error_dialog = _tmp25_;
			_tmp26_ = error_dialog;
			_tmp27_ = e;
			_tmp28_ = _tmp27_->message;
			granite_message_dialog_show_error_details (_tmp26_, _tmp28_);
			_tmp29_ = error_dialog;
			gtk_window_present ((GtkWindow*) _tmp29_);
			_tmp30_ = error_dialog;
			_tmp31_ = error_dialog;
			g_signal_connect_object ((GtkDialog*) _tmp30_, "response", (GCallback) _gtk_widget_destroy_gtk_dialog_response, (GtkWidget*) _tmp31_, 0);
			_g_object_unref0 (error_dialog);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (user_card);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp32_ = user_card;
	if (_tmp32_ != NULL) {
		{
			LightDMGreeter* _tmp33_;
			GreeterUserCard* _tmp34_;
			LightDMUser* _tmp35_;
			LightDMUser* _tmp36_;
			const gchar* _tmp37_;
			const gchar* _tmp38_;
			_tmp33_ = self->priv->_lightdm_greeter;
			_tmp34_ = user_card;
			_tmp35_ = greeter_user_card_get_lightdm_user (_tmp34_);
			_tmp36_ = _tmp35_;
			_tmp37_ = lightdm_user_get_name (_tmp36_);
			_tmp38_ = _tmp37_;
			lightdm_greeter_authenticate (_tmp33_, _tmp38_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError* e = NULL;
			GError* _tmp39_;
			const gchar* _tmp40_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp39_ = e;
			_tmp40_ = _tmp39_->message;
			g_critical ("MainWindow.vala:335: %s", _tmp40_);
			_g_error_free0 (e);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (user_card);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp41_ = self->priv->current_card;
	greeter_base_card_wrong_credentials (_tmp41_);
	_tmp42_ = self->priv->carousel;
	hdy_carousel_set_interactive (_tmp42_, TRUE);
	_g_object_unref0 (user_card);
}

static void
greeter_main_window_load_users_data_free (gpointer _data)
{
	GreeterMainWindowLoadUsersData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (GreeterMainWindowLoadUsersData, _data_);
}

static void
greeter_main_window_load_users (GreeterMainWindow* self,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_)
{
	GreeterMainWindowLoadUsersData* _data_;
	GreeterMainWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (GreeterMainWindowLoadUsersData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, greeter_main_window_load_users_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	greeter_main_window_load_users_co (_data_);
}

static void
greeter_main_window_load_users_finish (GreeterMainWindow* self,
                                       GAsyncResult* _res_)
{
	GreeterMainWindowLoadUsersData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		GreeterMainWindow* self;
		self = _data3_->self;
		_g_free0 (_data3_->user_to_select);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static void
___lambda20_ (GreeterMainWindow* self,
              LightDMUser* user)
{
	g_return_if_fail (user != NULL);
	greeter_main_window_add_card (self, user);
}

static void
____lambda20__gfunc (gconstpointer data,
                     gpointer self)
{
	___lambda20_ ((GreeterMainWindow*) self, (LightDMUser*) data);
}

static void
___lambda24_ (Block3Data* _data3_,
              GreeterUserCard* card)
{
	GreeterMainWindow* self;
	LightDMUser* _tmp0_;
	LightDMUser* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	self = _data3_->self;
	g_return_if_fail (card != NULL);
	_tmp0_ = greeter_user_card_get_lightdm_user (card);
	_tmp1_ = _tmp0_;
	_tmp2_ = lightdm_user_get_name (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _data3_->user_to_select;
	if (g_strcmp0 (_tmp3_, _tmp4_) == 0) {
		HdyCarousel* _tmp5_;
		_tmp5_ = self->priv->carousel;
		hdy_carousel_scroll_to (_tmp5_, (GtkWidget*) card);
		_data3_->user_selected = TRUE;
	}
}

static void
____lambda24__gfunc (gconstpointer data,
                     gpointer self)
{
	___lambda24_ (self, (GreeterUserCard*) data);
}

static gboolean
___lambda25_ (GreeterMainWindow* self)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	{
		GAppInfo* initial_setup = NULL;
		GAppInfo* _tmp0_;
		GAppInfo* _tmp1_;
		_tmp0_ = g_app_info_create_from_commandline ("io.elementary.initial-setup", NULL, G_APP_INFO_CREATE_NONE, &_inner_error0_);
		initial_setup = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp1_ = initial_setup;
		g_app_info_launch (_tmp1_, NULL, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (initial_setup);
			goto __catch0_g_error;
		}
		_g_object_unref0 (initial_setup);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		gchar* error_text = NULL;
		gchar* _tmp2_;
		const gchar* _tmp3_;
		GError* _tmp4_;
		const gchar* _tmp5_;
		GraniteMessageDialog* error_dialog = NULL;
		const gchar* _tmp6_;
		GraniteMessageDialog* _tmp7_;
		GraniteMessageDialog* _tmp8_;
		GError* _tmp9_;
		const gchar* _tmp10_;
		GraniteMessageDialog* _tmp11_;
		GraniteMessageDialog* _tmp12_;
		GraniteMessageDialog* _tmp13_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = g_strdup (_ ("Unable to Launch Initial Setup"));
		error_text = _tmp2_;
		_tmp3_ = error_text;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_critical ("MainWindow.vala:384: %s: %s", _tmp3_, _tmp5_);
		_tmp6_ = error_text;
		_tmp7_ = granite_message_dialog_new_with_image_from_icon_name (_tmp6_, _ ("Initial Setup creates your first user. Without it, you will not be abl" \
"e to log in and may need to reinstall the OS."), "dialog-error", GTK_BUTTONS_CLOSE);
		g_object_ref_sink (_tmp7_);
		error_dialog = _tmp7_;
		_tmp8_ = error_dialog;
		_tmp9_ = e;
		_tmp10_ = _tmp9_->message;
		granite_message_dialog_show_error_details (_tmp8_, _tmp10_);
		_tmp11_ = error_dialog;
		gtk_window_present ((GtkWindow*) _tmp11_);
		_tmp12_ = error_dialog;
		_tmp13_ = error_dialog;
		g_signal_connect_object ((GtkDialog*) _tmp12_, "response", (GCallback) _gtk_widget_destroy_gtk_dialog_response, (GtkWidget*) _tmp13_, 0);
		_g_object_unref0 (error_dialog);
		_g_free0 (error_text);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp14_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp14_;
	}
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
____lambda25__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda25_ ((GreeterMainWindow*) self);
	return result;
}

static gboolean
greeter_main_window_load_users_co (GreeterMainWindowLoadUsersData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_desktop_app_info_new ("io.elementary.installer.desktop");
	_data_->installer_desktop = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->installer_desktop;
	if (_data_->_tmp1_ != NULL) {
		_data_->self->priv->installer_mode = TRUE;
	}
	_data_->_tmp2_ = _data_->self->priv->lightdm_user_list;
	_data_->_tmp3_ = lightdm_user_list_get_length (_data_->_tmp2_);
	_data_->_tmp4_ = _data_->_tmp3_;
	if (_data_->_tmp4_ > 0) {
		_data_->_data3_ = g_slice_new0 (Block3Data);
		_data_->_data3_->_ref_count_ = 1;
		_data_->_data3_->self = g_object_ref (_data_->self);
		_data_->_tmp5_ = _data_->self->priv->datetime_revealer;
		gtk_revealer_set_reveal_child (_data_->_tmp5_, TRUE);
		_data_->_tmp6_ = _data_->self->priv->lightdm_user_list;
		_data_->_tmp7_ = lightdm_user_list_get_users (_data_->_tmp6_);
		_data_->_tmp8_ = _data_->_tmp7_;
		g_list_foreach (_data_->_tmp8_, ____lambda20__gfunc, _data_->self);
		_data_->_tmp9_ = _data_->self->priv->_lightdm_greeter;
		_data_->_tmp10_ = lightdm_greeter_get_select_user_hint (_data_->_tmp9_);
		_data_->_tmp11_ = _data_->_tmp10_;
		_data_->select_user = _data_->_tmp11_;
		_data_->_tmp13_ = _data_->select_user;
		if (_data_->_tmp13_ != NULL) {
			_data_->_tmp14_ = _data_->select_user;
			_data_->_tmp15_ = g_strdup (_data_->_tmp14_);
			_g_free0 (_data_->_tmp12_);
			_data_->_tmp12_ = _data_->_tmp15_;
		} else {
			_data_->_tmp16_ = _data_->self->priv->gsettings;
			_data_->_tmp17_ = g_settings_get_string (_data_->_tmp16_, "last-user");
			_g_free0 (_data_->_tmp12_);
			_data_->_tmp12_ = _data_->_tmp17_;
		}
		_data_->_tmp18_ = g_strdup (_data_->_tmp12_);
		_data_->_data3_->user_to_select = _data_->_tmp18_;
		_data_->_data3_->user_selected = FALSE;
		_data_->_tmp19_ = _data_->self->priv->user_cards;
		_data_->_tmp20_ = _data_->_tmp19_->head;
		g_list_foreach (_data_->_tmp20_, ____lambda24__gfunc, _data_->_data3_);
		if (!_data_->_data3_->user_selected) {
			_data_->_tmp21_ = _data_->self->priv->user_cards;
			_data_->_tmp22_ = g_queue_peek_head (_data_->_tmp21_);
			_data_->user_card = (GreeterUserCard*) _data_->_tmp22_;
			_data_->_tmp23_ = _data_->user_card;
			greeter_user_card_set_show_input (_data_->_tmp23_, TRUE);
			_data_->_tmp24_ = _data_->self->priv->carousel;
			_data_->_tmp25_ = _data_->user_card;
			hdy_carousel_scroll_to (_data_->_tmp24_, (GtkWidget*) _data_->_tmp25_);
		}
		_g_free0 (_data_->_tmp12_);
		block3_data_unref (_data_->_data3_);
		_data_->_data3_ = NULL;
	} else {
		_data_->_tmp26_ = _data_->self->priv->datetime_revealer;
		gtk_revealer_set_reveal_child (_data_->_tmp26_, FALSE);
		g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 500, ____lambda25__gsource_func, g_object_ref (_data_->self), g_object_unref);
	}
	_g_object_unref0 (_data_->installer_desktop);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
_greeter_main_window_do_connect_greeter_base_card_do_connect (GreeterBaseCard* _sender,
                                                              const gchar* credential,
                                                              gpointer self)
{
	greeter_main_window_do_connect ((GreeterMainWindow*) self, credential);
}

static void
__lambda21_ (GreeterMainWindow* self,
             GtkGestureMultiPress* gesture,
             gint n_press,
             gdouble x,
             gdouble y)
{
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	GreeterUserCard* _user_card = NULL;
	GtkWidget* _tmp2_;
	GtkWidget* _tmp3_;
	GreeterUserCard* _tmp4_;
	GreeterUserCard* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	g_return_if_fail (gesture != NULL);
	_tmp0_ = gtk_event_controller_get_widget ((GtkEventController*) gesture);
	_tmp1_ = _tmp0_;
	_vala_assert (GREETER_IS_USER_CARD (_tmp1_), "gesture.widget is UserCard");
	_tmp2_ = gtk_event_controller_get_widget ((GtkEventController*) gesture);
	_tmp3_ = _tmp2_;
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GREETER_TYPE_USER_CARD, GreeterUserCard));
	_user_card = _tmp4_;
	_tmp5_ = _user_card;
	_tmp6_ = greeter_user_card_get_show_input (_tmp5_);
	_tmp7_ = _tmp6_;
	if (!_tmp7_) {
		HdyCarousel* _tmp8_;
		GreeterUserCard* _tmp9_;
		GreeterUserCard* _tmp10_;
		_tmp8_ = self->priv->carousel;
		_tmp9_ = _user_card;
		hdy_carousel_scroll_to (_tmp8_, (GtkWidget*) _tmp9_);
		_tmp10_ = _user_card;
		gtk_widget_grab_focus ((GtkWidget*) _tmp10_);
	}
	_g_object_unref0 (_user_card);
}

static void
___lambda21__gtk_gesture_multi_press_pressed (GtkGestureMultiPress* _sender,
                                              gint n_press,
                                              gdouble x,
                                              gdouble y,
                                              gpointer self)
{
	__lambda21_ ((GreeterMainWindow*) self, _sender, n_press, x, y);
}

static void
__lambda22_ (GreeterMainWindow* self)
{
	if ((gtk_widget_get_state_flags ((GtkWidget*) self) & GTK_STATE_FLAG_DIR_LTR) == GTK_STATE_FLAG_DIR_LTR) {
		greeter_main_window_go_previous (self);
	} else {
		greeter_main_window_go_next (self);
	}
}

static void
___lambda22__greeter_base_card_go_left (GreeterBaseCard* _sender,
                                        gpointer self)
{
	__lambda22_ ((GreeterMainWindow*) self);
}

static void
__lambda23_ (GreeterMainWindow* self)
{
	if ((gtk_widget_get_state_flags ((GtkWidget*) self) & GTK_STATE_FLAG_DIR_LTR) == GTK_STATE_FLAG_DIR_LTR) {
		greeter_main_window_go_next (self);
	} else {
		greeter_main_window_go_previous (self);
	}
}

static void
___lambda23__greeter_base_card_go_right (GreeterBaseCard* _sender,
                                         gpointer self)
{
	__lambda23_ ((GreeterMainWindow*) self);
}

static void
greeter_main_window_add_card (GreeterMainWindow* self,
                              LightDMUser* lightdm_user)
{
	GreeterUserCard* user_card = NULL;
	GreeterUserCard* _tmp0_;
	GtkGestureMultiPress* _tmp1_;
	GtkGestureMultiPress* _tmp2_;
	HdyCarousel* _tmp3_;
	GtkSizeGroup* _tmp4_;
	GQueue* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (lightdm_user != NULL);
	_tmp0_ = greeter_user_card_new (lightdm_user);
	g_object_ref_sink (_tmp0_);
	user_card = _tmp0_;
	gtk_widget_show_all ((GtkWidget*) user_card);
	g_signal_connect_object ((GreeterBaseCard*) user_card, "do-connect", (GCallback) _greeter_main_window_do_connect_greeter_base_card_do_connect, self, 0);
	_tmp1_ = greeter_user_card_get_click_gesture (user_card);
	_tmp2_ = _tmp1_;
	g_signal_connect_object (_tmp2_, "pressed", (GCallback) ___lambda21__gtk_gesture_multi_press_pressed, self, 0);
	g_signal_connect_object ((GreeterBaseCard*) user_card, "go-left", (GCallback) ___lambda22__greeter_base_card_go_left, self, 0);
	g_signal_connect_object ((GreeterBaseCard*) user_card, "go-right", (GCallback) ___lambda23__greeter_base_card_go_right, self, 0);
	_tmp3_ = self->priv->carousel;
	gtk_container_add ((GtkContainer*) _tmp3_, (GtkWidget*) user_card);
	_tmp4_ = self->priv->card_size_group;
	gtk_size_group_add_widget (_tmp4_, (GtkWidget*) user_card);
	_tmp5_ = self->priv->user_cards;
	g_queue_push_tail (_tmp5_, user_card);
	_g_object_unref0 (user_card);
}

static void
greeter_main_window_handle_page_changed (GreeterMainWindow* self,
                                         guint index)
{
	GreeterUserCard* user_card = NULL;
	GQueue* _tmp0_;
	gconstpointer _tmp1_;
	GreeterUserCard* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GreeterBaseCard* _tmp4_;
	GreeterUserCard* _tmp7_;
	GreeterDateTimeWidget* _tmp8_;
	GreeterUserCard* _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp11_;
	GreeterUserCard* _tmp12_;
	GreeterUserCard* _tmp13_;
	GreeterUserCard* _tmp14_;
	GreeterUserCard* _tmp15_;
	LightDMUser* _tmp16_;
	LightDMUser* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	LightDMGreeter* _tmp29_;
	gboolean _tmp30_;
	gboolean _tmp31_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	if (index == ((guint) self->priv->current_user_card_index)) {
		return;
	}
	_tmp0_ = self->priv->user_cards;
	_tmp1_ = g_queue_peek_nth (_tmp0_, index);
	user_card = (GreeterUserCard*) _tmp1_;
	_tmp2_ = user_card;
	if (_tmp2_ == NULL) {
		return;
	}
	_tmp4_ = self->priv->current_card;
	if (_tmp4_ != NULL) {
		GreeterBaseCard* _tmp5_;
		_tmp5_ = self->priv->current_card;
		_tmp3_ = GREETER_IS_USER_CARD (_tmp5_);
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		GreeterBaseCard* _tmp6_;
		_tmp6_ = self->priv->current_card;
		greeter_user_card_set_show_input (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GREETER_TYPE_USER_CARD, GreeterUserCard), FALSE);
	}
	self->priv->current_user_card_index = (gint) index;
	_tmp7_ = user_card;
	self->priv->current_card = (GreeterBaseCard*) _tmp7_;
	_tmp8_ = self->priv->datetime_widget;
	_tmp9_ = user_card;
	_tmp10_ = greeter_user_card_get_is_24h (_tmp9_);
	_tmp11_ = _tmp10_;
	greeter_date_time_widget_set_is_24h (_tmp8_, _tmp11_);
	_tmp12_ = user_card;
	greeter_user_card_set_settings (_tmp12_);
	_tmp13_ = user_card;
	greeter_user_card_set_show_input (_tmp13_, TRUE);
	_tmp14_ = user_card;
	gtk_widget_grab_focus ((GtkWidget*) _tmp14_);
	_tmp15_ = user_card;
	_tmp16_ = greeter_user_card_get_lightdm_user (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = lightdm_user_get_session (_tmp17_);
	_tmp19_ = _tmp18_;
	if (_tmp19_ != NULL) {
		GtkApplication* _tmp20_;
		GtkApplication* _tmp21_;
		GreeterUserCard* _tmp22_;
		LightDMUser* _tmp23_;
		LightDMUser* _tmp24_;
		const gchar* _tmp25_;
		const gchar* _tmp26_;
		GVariant* _tmp27_;
		GVariant* _tmp28_;
		_tmp20_ = gtk_window_get_application ((GtkWindow*) self);
		_tmp21_ = _tmp20_;
		_tmp22_ = user_card;
		_tmp23_ = greeter_user_card_get_lightdm_user (_tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = lightdm_user_get_session (_tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = g_variant_new_string (_tmp26_);
		g_variant_ref_sink (_tmp27_);
		_tmp28_ = _tmp27_;
		g_action_group_activate_action ((GActionGroup*) _tmp21_, "select-session", _tmp28_);
		_g_variant_unref0 (_tmp28_);
	}
	_tmp29_ = self->priv->_lightdm_greeter;
	_tmp30_ = lightdm_greeter_get_in_authentication (_tmp29_);
	_tmp31_ = _tmp30_;
	if (_tmp31_) {
		{
			LightDMGreeter* _tmp32_;
			_tmp32_ = self->priv->_lightdm_greeter;
			lightdm_greeter_cancel_authentication (_tmp32_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp33_;
			const gchar* _tmp34_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp33_ = e;
			_tmp34_ = _tmp33_->message;
			g_critical ("MainWindow.vala:467: %s", _tmp34_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	{
		LightDMGreeter* _tmp35_;
		GreeterUserCard* _tmp36_;
		LightDMUser* _tmp37_;
		LightDMUser* _tmp38_;
		const gchar* _tmp39_;
		const gchar* _tmp40_;
		_tmp35_ = self->priv->_lightdm_greeter;
		_tmp36_ = user_card;
		_tmp37_ = greeter_user_card_get_lightdm_user (_tmp36_);
		_tmp38_ = _tmp37_;
		_tmp39_ = lightdm_user_get_name (_tmp38_);
		_tmp40_ = _tmp39_;
		lightdm_greeter_authenticate (_tmp35_, _tmp40_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp41_;
		const gchar* _tmp42_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp41_ = e;
		_tmp42_ = _tmp41_->message;
		g_critical ("MainWindow.vala:474: %s", _tmp42_);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
greeter_main_window_do_connect_username (GreeterMainWindow* self,
                                         const gchar* username)
{
	LightDMGreeter* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (username != NULL);
	_tmp0_ = self->priv->_lightdm_greeter;
	_tmp1_ = lightdm_greeter_get_in_authentication (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		{
			LightDMGreeter* _tmp3_;
			_tmp3_ = self->priv->_lightdm_greeter;
			lightdm_greeter_cancel_authentication (_tmp3_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp4_;
			const gchar* _tmp5_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp4_ = e;
			_tmp5_ = _tmp4_->message;
			g_critical ("MainWindow.vala:483: %s", _tmp5_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	{
		LightDMGreeter* _tmp6_;
		_tmp6_ = self->priv->_lightdm_greeter;
		lightdm_greeter_authenticate (_tmp6_, username, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		g_critical ("MainWindow.vala:490: %s", _tmp8_);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
greeter_main_window_do_connect (GreeterMainWindow* self,
                                const gchar* credential)
{
	HdyCarousel* _tmp3_;
	HdyCarousel* _tmp4_;
	GreeterBaseCard* _tmp5_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	if (credential != NULL) {
		{
			LightDMGreeter* _tmp0_;
			_tmp0_ = self->priv->_lightdm_greeter;
			lightdm_greeter_respond (_tmp0_, credential, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp1_;
			const gchar* _tmp2_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp1_ = e;
			_tmp2_ = _tmp1_->message;
			g_critical ("MainWindow.vala:499: %s", _tmp2_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp3_ = self->priv->carousel;
	hdy_carousel_set_interactive (_tmp3_, FALSE);
	_tmp4_ = self->priv->carousel;
	_tmp5_ = self->priv->current_card;
	hdy_carousel_scroll_to (_tmp4_, (GtkWidget*) _tmp5_);
}

static void
greeter_main_window_go_previous (GreeterMainWindow* self)
{
	HdyCarousel* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GreeterUserCard* next_card = NULL;
	GQueue* _tmp3_;
	gconstpointer _tmp4_;
	GreeterUserCard* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->carousel;
	_tmp1_ = hdy_carousel_get_interactive (_tmp0_);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		return;
	}
	_tmp3_ = self->priv->user_cards;
	_tmp4_ = g_queue_peek_nth (_tmp3_, (guint) (self->priv->current_user_card_index - 1));
	next_card = (GreeterUserCard*) _tmp4_;
	_tmp5_ = next_card;
	if (_tmp5_ != NULL) {
		HdyCarousel* _tmp6_;
		GreeterUserCard* _tmp7_;
		_tmp6_ = self->priv->carousel;
		_tmp7_ = next_card;
		hdy_carousel_scroll_to (_tmp6_, (GtkWidget*) _tmp7_);
	}
}

static void
greeter_main_window_go_next (GreeterMainWindow* self)
{
	HdyCarousel* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GreeterUserCard* next_card = NULL;
	GQueue* _tmp3_;
	gconstpointer _tmp4_;
	GreeterUserCard* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->carousel;
	_tmp1_ = hdy_carousel_get_interactive (_tmp0_);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		return;
	}
	_tmp3_ = self->priv->user_cards;
	_tmp4_ = g_queue_peek_nth (_tmp3_, (guint) (self->priv->current_user_card_index + 1));
	next_card = (GreeterUserCard*) _tmp4_;
	_tmp5_ = next_card;
	if (_tmp5_ != NULL) {
		HdyCarousel* _tmp6_;
		GreeterUserCard* _tmp7_;
		_tmp6_ = self->priv->carousel;
		_tmp7_ = next_card;
		hdy_carousel_scroll_to (_tmp6_, (GtkWidget*) _tmp7_);
	}
}

static LightDMGreeter*
greeter_main_window_get_lightdm_greeter (GreeterMainWindow* self)
{
	LightDMGreeter* result;
	LightDMGreeter* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_lightdm_greeter;
	result = _tmp0_;
	return result;
}

static void
greeter_main_window_set_lightdm_greeter (GreeterMainWindow* self,
                                         LightDMGreeter* value)
{
	LightDMGreeter* old_value;
	g_return_if_fail (self != NULL);
	old_value = greeter_main_window_get_lightdm_greeter (self);
	if (old_value != value) {
		LightDMGreeter* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_lightdm_greeter);
		self->priv->_lightdm_greeter = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, greeter_main_window_properties[GREETER_MAIN_WINDOW_LIGHTDM_GREETER_PROPERTY]);
	}
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		GreeterMainWindow* self;
		self = _data4_->self;
		_g_object_unref0 (_data4_->manual_login_stack);
		_g_object_unref0 (_data4_->manual_card);
		_g_object_unref0 (_data4_->manual_login_button);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static void
_greeter_main_window_show_message_lightdm_greeter_show_message (LightDMGreeter* _sender,
                                                                const gchar* text,
                                                                LightDMMessageType type,
                                                                gpointer self)
{
	greeter_main_window_show_message ((GreeterMainWindow*) self, text, type);
}

static void
_greeter_main_window_show_prompt_lightdm_greeter_show_prompt (LightDMGreeter* _sender,
                                                              const gchar* text,
                                                              LightDMPromptType type,
                                                              gpointer self)
{
	greeter_main_window_show_prompt ((GreeterMainWindow*) self, text, type);
}

static void
_greeter_main_window_authentication_complete_lightdm_greeter_authentication_complete (LightDMGreeter* _sender,
                                                                                      gpointer self)
{
	greeter_main_window_authentication_complete ((GreeterMainWindow*) self);
}

static void
_greeter_main_window___lambda26_ (Block4Data* _data4_)
{
	GreeterMainWindow* self;
	GtkToggleButton* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GError* _inner_error0_ = NULL;
	self = _data4_->self;
	_tmp0_ = _data4_->manual_login_button;
	_tmp1_ = gtk_toggle_button_get_active (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		LightDMGreeter* _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		GtkStack* _tmp9_;
		GreeterManualCard* _tmp10_;
		GreeterManualCard* _tmp11_;
		_tmp3_ = self->priv->_lightdm_greeter;
		_tmp4_ = lightdm_greeter_get_in_authentication (_tmp3_);
		_tmp5_ = _tmp4_;
		if (_tmp5_) {
			{
				LightDMGreeter* _tmp6_;
				_tmp6_ = self->priv->_lightdm_greeter;
				lightdm_greeter_cancel_authentication (_tmp6_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
			}
			goto __finally0;
			__catch0_g_error:
			{
				GError* e = NULL;
				GError* _tmp7_;
				const gchar* _tmp8_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp7_ = e;
				_tmp8_ = _tmp7_->message;
				g_critical ("MainWindow.vala:100: %s", _tmp8_);
				_g_error_free0 (e);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		_tmp9_ = _data4_->manual_login_stack;
		_tmp10_ = _data4_->manual_card;
		gtk_stack_set_visible_child (_tmp9_, (GtkWidget*) _tmp10_);
		_tmp11_ = _data4_->manual_card;
		self->priv->current_card = (GreeterBaseCard*) _tmp11_;
	} else {
		LightDMGreeter* _tmp12_;
		gboolean _tmp13_;
		gboolean _tmp14_;
		GtkStack* _tmp18_;
		HdyCarousel* _tmp19_;
		GQueue* _tmp20_;
		gconstpointer _tmp21_;
		_tmp12_ = self->priv->_lightdm_greeter;
		_tmp13_ = lightdm_greeter_get_in_authentication (_tmp12_);
		_tmp14_ = _tmp13_;
		if (_tmp14_) {
			{
				LightDMGreeter* _tmp15_;
				_tmp15_ = self->priv->_lightdm_greeter;
				lightdm_greeter_cancel_authentication (_tmp15_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch1_g_error;
				}
			}
			goto __finally1;
			__catch1_g_error:
			{
				GError* e = NULL;
				GError* _tmp16_;
				const gchar* _tmp17_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp16_ = e;
				_tmp17_ = _tmp16_->message;
				g_critical ("MainWindow.vala:111: %s", _tmp17_);
				_g_error_free0 (e);
			}
			__finally1:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		_tmp18_ = _data4_->manual_login_stack;
		_tmp19_ = self->priv->carousel;
		gtk_stack_set_visible_child (_tmp18_, (GtkWidget*) _tmp19_);
		_tmp20_ = self->priv->user_cards;
		_tmp21_ = g_queue_peek_nth (_tmp20_, (guint) self->priv->current_user_card_index);
		self->priv->current_card = (GreeterBaseCard*) ((GreeterUserCard*) _tmp21_);
		{
			LightDMGreeter* _tmp22_;
			GreeterBaseCard* _tmp23_;
			LightDMUser* _tmp24_;
			LightDMUser* _tmp25_;
			const gchar* _tmp26_;
			const gchar* _tmp27_;
			_tmp22_ = self->priv->_lightdm_greeter;
			_tmp23_ = self->priv->current_card;
			_tmp24_ = greeter_user_card_get_lightdm_user (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, GREETER_TYPE_USER_CARD, GreeterUserCard));
			_tmp25_ = _tmp24_;
			_tmp26_ = lightdm_user_get_name (_tmp25_);
			_tmp27_ = _tmp26_;
			lightdm_greeter_authenticate (_tmp22_, _tmp27_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch2_g_error;
			}
		}
		goto __finally2;
		__catch2_g_error:
		{
			GError* e = NULL;
			GError* _tmp28_;
			const gchar* _tmp29_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp28_ = e;
			_tmp29_ = _tmp28_->message;
			g_critical ("MainWindow.vala:121: %s", _tmp29_);
			_g_error_free0 (e);
		}
		__finally2:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static void
__greeter_main_window___lambda26__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                             gpointer self)
{
	_greeter_main_window___lambda26_ (self);
}

static void
_greeter_main_window___lambda27_ (GreeterMainWindow* self)
{
	GError* _inner_error0_ = NULL;
	{
		LightDMGreeter* _tmp0_;
		_tmp0_ = self->priv->_lightdm_greeter;
		lightdm_greeter_authenticate_as_guest (_tmp0_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_critical ("MainWindow.vala:130: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
__greeter_main_window___lambda27__gtk_button_clicked (GtkButton* _sender,
                                                      gpointer self)
{
	_greeter_main_window___lambda27_ ((GreeterMainWindow*) self);
}

static void
_greeter_main_window___lambda28_ (GreeterMainWindow* self)
{
	greeter_main_window_load_users (self, NULL, NULL);
}

static void
__greeter_main_window___lambda28__lightdm_user_list_user_added (LightDMUserList* _sender,
                                                                LightDMUser* user,
                                                                gpointer self)
{
	_greeter_main_window___lambda28_ ((GreeterMainWindow*) self);
}

static void
_greeter_main_window_do_connect_username_greeter_manual_card_do_connect_username (GreeterManualCard* _sender,
                                                                                  const gchar* username,
                                                                                  gpointer self)
{
	greeter_main_window_do_connect_username ((GreeterMainWindow*) self, username);
}

static gboolean
_greeter_main_window___lambda29_ (GreeterMainWindow* self,
                                  guint keyval,
                                  guint keycode,
                                  GdkModifierType state)
{
	GreeterBaseCard* _tmp0_;
	GtkEntry* focused_entry = NULL;
	GtkWidget* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	GtkEntry* _tmp4_;
	gboolean ltr = FALSE;
	gboolean result;
	_tmp0_ = self->priv->current_card;
	if (!GREETER_IS_USER_CARD (_tmp0_)) {
		result = GDK_EVENT_PROPAGATE;
		return result;
	}
	_tmp1_ = gtk_window_get_focus ((GtkWindow*) self);
	focused_entry = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_entry_get_type (), GtkEntry);
	_tmp4_ = focused_entry;
	if (_tmp4_ == NULL) {
		_tmp3_ = TRUE;
	} else {
		GtkEntry* _tmp5_;
		GreeterBaseCard* _tmp6_;
		_tmp5_ = focused_entry;
		_tmp6_ = self->priv->current_card;
		_tmp3_ = !gtk_widget_is_ancestor ((GtkWidget*) _tmp5_, (GtkWidget*) _tmp6_);
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		GtkEntry* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		_tmp7_ = focused_entry;
		_tmp8_ = gtk_entry_get_text (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp2_ = g_strcmp0 (_tmp9_, "") != 0;
	}
	if (_tmp2_) {
		result = GDK_EVENT_PROPAGATE;
		return result;
	}
	ltr = (gtk_widget_get_state_flags ((GtkWidget*) self) & GTK_STATE_FLAG_DIR_LTR) == GTK_STATE_FLAG_DIR_LTR;
	if (keyval == GDK_KEY_Left) {
		if (ltr) {
			greeter_main_window_go_previous (self);
		} else {
			greeter_main_window_go_next (self);
		}
		result = GDK_EVENT_STOP;
		return result;
	} else {
		if (keyval == GDK_KEY_Right) {
			if (ltr) {
				greeter_main_window_go_next (self);
			} else {
				greeter_main_window_go_previous (self);
			}
			result = GDK_EVENT_STOP;
			return result;
		}
	}
	result = GDK_EVENT_PROPAGATE;
	return result;
}

static gboolean
__greeter_main_window___lambda29__gtk_event_controller_key_key_pressed (GtkEventControllerKey* _sender,
                                                                        guint keyval,
                                                                        guint keycode,
                                                                        GdkModifierType state,
                                                                        gpointer self)
{
	gboolean result;
	result = _greeter_main_window___lambda29_ ((GreeterMainWindow*) self, keyval, keycode, state);
	return result;
}

static void
_greeter_main_window_handle_page_changed_hdy_carousel_page_changed (HdyCarousel* _sender,
                                                                    guint index,
                                                                    gpointer self)
{
	greeter_main_window_handle_page_changed ((GreeterMainWindow*) self, index);
}

static gboolean
__lambda31_ (GreeterMainWindow* self)
{
	GtkStyleContext* _tmp0_;
	GreeterBaseCard* _tmp1_;
	gboolean result;
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp0_, "initialized");
	_tmp1_ = self->priv->current_card;
	if (_tmp1_ != NULL) {
		GreeterBaseCard* _tmp2_;
		_tmp2_ = self->priv->current_card;
		gtk_widget_grab_focus ((GtkWidget*) _tmp2_);
	}
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda31__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda31_ ((GreeterMainWindow*) self);
	return result;
}

static void
_greeter_main_window___lambda30_ (GreeterMainWindow* self)
{
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 500, ___lambda31__gsource_func, g_object_ref (self), g_object_unref);
}

static void
__greeter_main_window___lambda30__gasync_ready_callback (GObject* source_object,
                                                         GAsyncResult* res,
                                                         gpointer self)
{
	_greeter_main_window___lambda30_ ((GreeterMainWindow*) self);
	g_object_unref (self);
}

static void
_greeter_main_window_init_panel_gtk_widget_realize (GtkWidget* _sender,
                                                    gpointer self)
{
	greeter_main_window_init_panel ((GreeterMainWindow*) self);
}

static GObject *
greeter_main_window_constructor (GType type,
                                 guint n_construct_properties,
                                 GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GreeterMainWindow * self;
	Block4Data* _data4_;
	GdkScreen* _tmp0_;
	GdkVisual* _tmp1_;
	GSettings* _tmp2_;
	GreeterSettings* _tmp3_;
	LightDMGreeter* _tmp4_;
	LightDMGreeter* _tmp5_;
	LightDMGreeter* _tmp6_;
	GtkButton* guest_login_button = NULL;
	GtkButton* _tmp7_;
	GtkToggleButton* _tmp8_;
	GtkBox* extra_login_box = NULL;
	GtkBox* _tmp9_ = NULL;
	LightDMGreeter* _tmp10_;
	gboolean _tmp11_;
	gboolean _tmp12_;
	LightDMGreeter* _tmp15_;
	gboolean _tmp16_;
	gboolean _tmp17_;
	GreeterDateTimeWidget* _tmp20_;
	GreeterDateTimeWidget* _tmp21_;
	GtkWidget* _tmp22_;
	GtkRevealer* _tmp23_ = NULL;
	GQueue* _tmp24_;
	GreeterManualCard* _tmp25_;
	HdyCarousel* _tmp26_ = NULL;
	GtkStack* _tmp27_ = NULL;
	GtkStack* _tmp28_;
	HdyCarousel* _tmp29_;
	GtkStack* _tmp30_;
	GreeterManualCard* _tmp31_;
	GtkBox* main_box = NULL;
	GtkBox* _tmp32_ = NULL;
	GtkBox* _tmp33_;
	GtkRevealer* _tmp34_;
	GtkBox* _tmp35_;
	GtkStack* _tmp36_;
	GtkBox* _tmp37_;
	GtkBox* _tmp38_;
	GtkBox* _tmp39_;
	GtkToggleButton* _tmp40_;
	GtkButton* _tmp41_;
	GtkSizeGroup* _tmp42_;
	GtkSizeGroup* _tmp43_;
	GtkBox* _tmp44_;
	GtkSizeGroup* _tmp45_;
	GreeterManualCard* _tmp46_;
	LightDMGreeter* _tmp47_;
	GtkToggleButton* _tmp48_;
	LightDMGreeter* _tmp49_;
	GtkToggleButton* _tmp50_;
	LightDMUserList* _tmp51_;
	LightDMUserList* _tmp52_;
	GreeterManualCard* _tmp53_;
	GreeterManualCard* _tmp54_;
	GtkEventControllerKey* _tmp55_ = NULL;
	GtkEventControllerKey* _tmp56_;
	HdyCarousel* _tmp57_;
	GreeterSettings* _tmp58_;
	gboolean _tmp59_;
	gboolean _tmp60_;
	GtkBox* _tmp65_;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (greeter_main_window_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GREETER_TYPE_MAIN_WINDOW, GreeterMainWindow);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	gtk_widget_set_app_paintable ((GtkWidget*) self, TRUE);
	gtk_window_set_decorated ((GtkWindow*) self, FALSE);
	_tmp0_ = gtk_window_get_screen ((GtkWindow*) self);
	_tmp1_ = gdk_screen_get_rgba_visual (_tmp0_);
	gtk_widget_set_visual ((GtkWidget*) self, _tmp1_);
	_tmp2_ = g_settings_new ("io.elementary.greeter");
	_g_object_unref0 (self->priv->gsettings);
	self->priv->gsettings = _tmp2_;
	_tmp3_ = greeter_settings_new ();
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp3_;
	_tmp4_ = self->priv->_lightdm_greeter;
	g_signal_connect_object (_tmp4_, "show-message", (GCallback) _greeter_main_window_show_message_lightdm_greeter_show_message, self, 0);
	_tmp5_ = self->priv->_lightdm_greeter;
	g_signal_connect_object (_tmp5_, "show-prompt", (GCallback) _greeter_main_window_show_prompt_lightdm_greeter_show_prompt, self, 0);
	_tmp6_ = self->priv->_lightdm_greeter;
	g_signal_connect_object (_tmp6_, "authentication-complete", (GCallback) _greeter_main_window_authentication_complete_lightdm_greeter_authentication_complete, self, 0);
	_tmp7_ = (GtkButton*) gtk_button_new_with_label (_ ("Log in as Guest"));
	g_object_ref_sink (_tmp7_);
	guest_login_button = _tmp7_;
	_tmp8_ = (GtkToggleButton*) gtk_toggle_button_new_with_label (_ ("Manual Login…"));
	g_object_ref_sink (_tmp8_);
	_data4_->manual_login_button = _tmp8_;
	_tmp9_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 12);
	gtk_box_set_homogeneous (_tmp9_, TRUE);
	gtk_widget_set_halign ((GtkWidget*) _tmp9_, GTK_ALIGN_CENTER);
	gtk_widget_set_valign ((GtkWidget*) _tmp9_, GTK_ALIGN_END);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp9_, TRUE);
	g_object_ref_sink (_tmp9_);
	extra_login_box = _tmp9_;
	_tmp10_ = self->priv->_lightdm_greeter;
	_tmp11_ = lightdm_greeter_get_has_guest_account_hint (_tmp10_);
	_tmp12_ = _tmp11_;
	if (_tmp12_) {
		GtkBox* _tmp13_;
		GtkButton* _tmp14_;
		_tmp13_ = extra_login_box;
		_tmp14_ = guest_login_button;
		gtk_container_add ((GtkContainer*) _tmp13_, (GtkWidget*) _tmp14_);
	}
	_tmp15_ = self->priv->_lightdm_greeter;
	_tmp16_ = lightdm_greeter_get_show_manual_login_hint (_tmp15_);
	_tmp17_ = _tmp16_;
	if (_tmp17_) {
		GtkBox* _tmp18_;
		GtkToggleButton* _tmp19_;
		_tmp18_ = extra_login_box;
		_tmp19_ = _data4_->manual_login_button;
		gtk_container_add ((GtkContainer*) _tmp18_, (GtkWidget*) _tmp19_);
	}
	_tmp20_ = greeter_date_time_widget_new ();
	g_object_ref_sink (_tmp20_);
	_g_object_unref0 (self->priv->datetime_widget);
	self->priv->datetime_widget = _tmp20_;
	_tmp21_ = self->priv->datetime_widget;
	_tmp22_ = _g_object_ref0 ((GtkWidget*) _tmp21_);
	_tmp23_ = (GtkRevealer*) gtk_revealer_new ();
	g_object_set ((GtkContainer*) _tmp23_, "child", _tmp22_, NULL);
	_g_object_unref0 (_tmp22_);
	gtk_revealer_set_transition_type (_tmp23_, GTK_REVEALER_TRANSITION_TYPE_CROSSFADE);
	gtk_widget_set_valign ((GtkWidget*) _tmp23_, GTK_ALIGN_CENTER);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp23_, TRUE);
	g_object_ref_sink (_tmp23_);
	_g_object_unref0 (self->priv->datetime_revealer);
	self->priv->datetime_revealer = _tmp23_;
	_tmp24_ = g_queue_new ();
	(self->priv->user_cards == NULL) ? NULL : (self->priv->user_cards = (g_queue_free (self->priv->user_cards), NULL));
	self->priv->user_cards = _tmp24_;
	_tmp25_ = greeter_manual_card_new ();
	g_object_ref_sink (_tmp25_);
	_data4_->manual_card = _tmp25_;
	_tmp26_ = (HdyCarousel*) hdy_carousel_new ();
	hdy_carousel_set_allow_long_swipes (_tmp26_, TRUE);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp26_, TRUE);
	g_object_ref_sink (_tmp26_);
	_g_object_unref0 (self->priv->carousel);
	self->priv->carousel = _tmp26_;
	_tmp27_ = (GtkStack*) gtk_stack_new ();
	gtk_stack_set_transition_type (_tmp27_, GTK_STACK_TRANSITION_TYPE_CROSSFADE);
	g_object_ref_sink (_tmp27_);
	_data4_->manual_login_stack = _tmp27_;
	_tmp28_ = _data4_->manual_login_stack;
	_tmp29_ = self->priv->carousel;
	gtk_container_add ((GtkContainer*) _tmp28_, (GtkWidget*) _tmp29_);
	_tmp30_ = _data4_->manual_login_stack;
	_tmp31_ = _data4_->manual_card;
	gtk_container_add ((GtkContainer*) _tmp30_, (GtkWidget*) _tmp31_);
	_tmp32_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 24);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp32_, 24);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp32_, 24);
	g_object_ref_sink (_tmp32_);
	main_box = _tmp32_;
	_tmp33_ = main_box;
	_tmp34_ = self->priv->datetime_revealer;
	gtk_container_add ((GtkContainer*) _tmp33_, (GtkWidget*) _tmp34_);
	_tmp35_ = main_box;
	_tmp36_ = _data4_->manual_login_stack;
	gtk_container_add ((GtkContainer*) _tmp35_, (GtkWidget*) _tmp36_);
	_tmp37_ = main_box;
	_tmp38_ = extra_login_box;
	gtk_container_add ((GtkContainer*) _tmp37_, (GtkWidget*) _tmp38_);
	_tmp39_ = main_box;
	g_object_set ((GtkContainer*) self, "child", (GtkWidget*) _tmp39_, NULL);
	_tmp40_ = _data4_->manual_login_button;
	g_signal_connect_data (_tmp40_, "toggled", (GCallback) __greeter_main_window___lambda26__gtk_toggle_button_toggled, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
	_tmp41_ = guest_login_button;
	g_signal_connect_object (_tmp41_, "clicked", (GCallback) __greeter_main_window___lambda27__gtk_button_clicked, self, 0);
	_tmp42_ = gtk_size_group_new (GTK_SIZE_GROUP_HORIZONTAL);
	_g_object_unref0 (self->priv->card_size_group);
	self->priv->card_size_group = _tmp42_;
	_tmp43_ = self->priv->card_size_group;
	_tmp44_ = extra_login_box;
	gtk_size_group_add_widget (_tmp43_, (GtkWidget*) _tmp44_);
	_tmp45_ = self->priv->card_size_group;
	_tmp46_ = _data4_->manual_card;
	gtk_size_group_add_widget (_tmp45_, (GtkWidget*) _tmp46_);
	_tmp47_ = self->priv->_lightdm_greeter;
	_tmp48_ = _data4_->manual_login_button;
	g_object_bind_property_with_closures ((GObject*) _tmp47_, "hide-users-hint", (GObject*) _tmp48_, "sensitive", G_BINDING_SYNC_CREATE | G_BINDING_INVERT_BOOLEAN, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp49_ = self->priv->_lightdm_greeter;
	_tmp50_ = _data4_->manual_login_button;
	g_object_bind_property_with_closures ((GObject*) _tmp49_, "hide-users-hint", (GObject*) _tmp50_, "active", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp51_ = lightdm_user_list_get_instance ();
	self->priv->lightdm_user_list = _tmp51_;
	_tmp52_ = self->priv->lightdm_user_list;
	g_signal_connect_object (_tmp52_, "user-added", (GCallback) __greeter_main_window___lambda28__lightdm_user_list_user_added, self, 0);
	_tmp53_ = _data4_->manual_card;
	g_signal_connect_object (_tmp53_, "do-connect-username", (GCallback) _greeter_main_window_do_connect_username_greeter_manual_card_do_connect_username, self, 0);
	_tmp54_ = _data4_->manual_card;
	g_signal_connect_object ((GreeterBaseCard*) _tmp54_, "do-connect", (GCallback) _greeter_main_window_do_connect_greeter_base_card_do_connect, self, 0);
	_tmp55_ = (GtkEventControllerKey*) gtk_event_controller_key_new ((GtkWidget*) self);
	gtk_event_controller_set_propagation_phase ((GtkEventController*) _tmp55_, GTK_PHASE_CAPTURE);
	_g_object_unref0 (self->priv->key_controller);
	self->priv->key_controller = _tmp55_;
	_tmp56_ = self->priv->key_controller;
	g_signal_connect_object (_tmp56_, "key-pressed", (GCallback) __greeter_main_window___lambda29__gtk_event_controller_key_key_pressed, self, 0);
	_tmp57_ = self->priv->carousel;
	g_signal_connect_object (_tmp57_, "page-changed", (GCallback) _greeter_main_window_handle_page_changed_hdy_carousel_page_changed, self, 0);
	greeter_main_window_load_users (self, __greeter_main_window___lambda30__gasync_ready_callback, g_object_ref (self));
	gtk_window_maximize ((GtkWindow*) self);
	_tmp58_ = self->priv->settings;
	_tmp59_ = greeter_settings_get_activate_numlock (_tmp58_);
	_tmp60_ = _tmp59_;
	if (_tmp60_) {
		{
			gchar* _tmp61_;
			gchar* _tmp62_;
			gchar** _tmp63_;
			gchar** _tmp64_;
			gint _tmp64__length1;
			_tmp61_ = g_strdup ("numlockx");
			_tmp62_ = g_strdup ("on");
			_tmp63_ = g_new0 (gchar*, 2 + 1);
			_tmp63_[0] = _tmp61_;
			_tmp63_[1] = _tmp62_;
			_tmp64_ = _tmp63_;
			_tmp64__length1 = 2;
			g_spawn_async (NULL, _tmp64_, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, NULL, &_inner_error0_);
			_tmp64_ = (_vala_array_free (_tmp64_, _tmp64__length1, (GDestroyNotify) g_free), NULL);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			g_clear_error (&_inner_error0_);
			g_warning ("MainWindow.vala:206: Unable to spawn numlockx to set numlock state");
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (main_box);
			_g_object_unref0 (extra_login_box);
			_g_object_unref0 (guest_login_button);
			block4_data_unref (_data4_);
			_data4_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
		}
	}
	_tmp65_ = main_box;
	g_signal_connect_object ((GtkWidget*) _tmp65_, "realize", (GCallback) _greeter_main_window_init_panel_gtk_widget_realize, self, 0);
	_g_object_unref0 (main_box);
	_g_object_unref0 (extra_login_box);
	_g_object_unref0 (guest_login_button);
	block4_data_unref (_data4_);
	_data4_ = NULL;
	return obj;
}

static void
greeter_main_window_class_init (GreeterMainWindowClass * klass,
                                gpointer klass_data)
{
	greeter_main_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GreeterMainWindow_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_greeter_main_window_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_greeter_main_window_set_property;
	G_OBJECT_CLASS (klass)->constructor = greeter_main_window_constructor;
	G_OBJECT_CLASS (klass)->finalize = greeter_main_window_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GREETER_MAIN_WINDOW_LIGHTDM_GREETER_PROPERTY, greeter_main_window_properties[GREETER_MAIN_WINDOW_LIGHTDM_GREETER_PROPERTY] = g_param_spec_object ("lightdm-greeter", "lightdm-greeter", "lightdm-greeter", lightdm_greeter_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
greeter_main_window_instance_init (GreeterMainWindow * self,
                                   gpointer klass)
{
	self->priv = greeter_main_window_get_instance_private (self);
	self->priv->current_user_card_index = -1;
	self->priv->current_card = NULL;
	self->priv->installer_mode = FALSE;
}

static void
greeter_main_window_finalize (GObject * obj)
{
	GreeterMainWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GREETER_TYPE_MAIN_WINDOW, GreeterMainWindow);
	_g_object_unref0 (self->priv->_lightdm_greeter);
	_wl_proxy_destroy0 (self->priv->desktop_greeter);
	(self->priv->user_cards == NULL) ? NULL : (self->priv->user_cards = (g_queue_free (self->priv->user_cards), NULL));
	_g_object_unref0 (self->priv->card_size_group);
	_g_object_unref0 (self->priv->carousel);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->gsettings);
	_g_object_unref0 (self->priv->datetime_revealer);
	_g_object_unref0 (self->priv->datetime_widget);
	_g_object_unref0 (self->priv->key_controller);
	G_OBJECT_CLASS (greeter_main_window_parent_class)->finalize (obj);
}

static GType
greeter_main_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GreeterMainWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) greeter_main_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GreeterMainWindow), 0, (GInstanceInitFunc) greeter_main_window_instance_init, NULL };
	GType greeter_main_window_type_id;
	greeter_main_window_type_id = g_type_register_static (gtk_application_window_get_type (), "GreeterMainWindow", &g_define_type_info, 0);
	GreeterMainWindow_private_offset = g_type_add_instance_private (greeter_main_window_type_id, sizeof (GreeterMainWindowPrivate));
	return greeter_main_window_type_id;
}

GType
greeter_main_window_get_type (void)
{
	static volatile gsize greeter_main_window_type_id__once = 0;
	if (g_once_init_enter (&greeter_main_window_type_id__once)) {
		GType greeter_main_window_type_id;
		greeter_main_window_type_id = greeter_main_window_get_type_once ();
		g_once_init_leave (&greeter_main_window_type_id__once, greeter_main_window_type_id);
	}
	return greeter_main_window_type_id__once;
}

static void
_vala_greeter_main_window_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	GreeterMainWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GREETER_TYPE_MAIN_WINDOW, GreeterMainWindow);
	switch (property_id) {
		case GREETER_MAIN_WINDOW_LIGHTDM_GREETER_PROPERTY:
		g_value_set_object (value, greeter_main_window_get_lightdm_greeter (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_greeter_main_window_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec)
{
	GreeterMainWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GREETER_TYPE_MAIN_WINDOW, GreeterMainWindow);
	switch (property_id) {
		case GREETER_MAIN_WINDOW_LIGHTDM_GREETER_PROPERTY:
		greeter_main_window_set_lightdm_greeter (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

