/* condition.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from condition.vala, do not modify */

/*      condition.vala*/
/*      */
/*      Copyright 2011 Hong Jen Yee (PCMan) <pcman.tw@pcman.tw@gmail.com>*/
/*      */
/*      This program is free software; you can redistribute it and/or modify*/
/*      it under the terms of the GNU General Public License as published by*/
/*      the Free Software Foundation; either version 2 of the License, or*/
/*      (at your option) any later version.*/
/*      */
/*      This program is distributed in the hope that it will be useful,*/
/*      but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*      GNU General Public License for more details.*/
/*      */
/*      You should have received a copy of the GNU General Public License*/
/*      along with this program; if not, write to the Free Software*/
/*      Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,*/
/*      MA 02110-1301, USA.*/
/*      */
/*      */

#include "fm-actions.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <fm-file-info.h>
#include <glib/gstdio.h>
#include <gio/gio.h>
#include <fm-mime-type.h>
#include <fm-path.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_pattern_spec_free0(var) ((var == NULL) ? NULL : (var = (g_pattern_spec_free (var), NULL)))

static void fm_file_action_condition_instance_init (FmFileActionCondition * self);
VALA_EXTERN gchar** utils_key_file_get_string_list (GKeyFile* kf,
                                        const gchar* group,
                                        const gchar* key,
                                        gchar** def_val,
                                        gint def_val_length1,
                                        gint* result_length1);
VALA_EXTERN gchar* utils_key_file_get_string (GKeyFile* kf,
                                  const gchar* group,
                                  const gchar* key,
                                  const gchar* def_val);
VALA_EXTERN gboolean utils_key_file_get_bool (GKeyFile* kf,
                                  const gchar* group,
                                  const gchar* key,
                                  gboolean def_val);
static inline gboolean fm_file_action_condition_match_try_exec (FmFileActionCondition* self,
                                                  GList* files);
static inline gboolean fm_file_action_condition_match_show_if_registered (FmFileActionCondition* self,
                                                            GList* files);
static inline gboolean fm_file_action_condition_match_show_if_true (FmFileActionCondition* self,
                                                      GList* files);
static inline gboolean fm_file_action_condition_match_show_if_running (FmFileActionCondition* self,
                                                         GList* files);
static inline gboolean fm_file_action_condition_match_mime_type (FmFileActionCondition* self,
                                                   GList* files,
                                                   const gchar* type,
                                                   gboolean negated);
static inline gboolean fm_file_action_condition_match_mime_types (FmFileActionCondition* self,
                                                    GList* files);
static inline gboolean fm_file_action_condition_match_base_name (FmFileActionCondition* self,
                                                   GList* files,
                                                   const gchar* base_name,
                                                   gboolean negated);
static inline gboolean fm_file_action_condition_match_base_names (FmFileActionCondition* self,
                                                    GList* files);
static gboolean fm_file_action_condition_match_scheme (GList* files,
                                                const gchar* scheme,
                                                gboolean negated);
static inline gboolean fm_file_action_condition_match_schemes (FmFileActionCondition* self,
                                                 GList* files);
static gboolean fm_file_action_condition_match_folder (GList* files,
                                                const gchar* folder,
                                                gboolean negated);
static inline gboolean fm_file_action_condition_match_folders (FmFileActionCondition* self,
                                                 GList* files);
static inline gboolean fm_file_action_condition_match_selection_count (FmFileActionCondition* self,
                                                         GList* files);
static inline gboolean fm_file_action_condition_match_capabilities (FmFileActionCondition* self,
                                                      GList* files);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static GType
fm_file_action_capability_get_type_once (void)
{
	static const GEnumValue values[] = {{FM_FILE_ACTION_CAPABILITY_OWNER, "FM_FILE_ACTION_CAPABILITY_OWNER", "owner"}, {FM_FILE_ACTION_CAPABILITY_READABLE, "FM_FILE_ACTION_CAPABILITY_READABLE", "readable"}, {FM_FILE_ACTION_CAPABILITY_WRITABLE, "FM_FILE_ACTION_CAPABILITY_WRITABLE", "writable"}, {FM_FILE_ACTION_CAPABILITY_EXECUTABLE, "FM_FILE_ACTION_CAPABILITY_EXECUTABLE", "executable"}, {FM_FILE_ACTION_CAPABILITY_LOCAL, "FM_FILE_ACTION_CAPABILITY_LOCAL", "local"}, {0, NULL, NULL}};
	GType fm_file_action_capability_type_id;
	fm_file_action_capability_type_id = g_enum_register_static ("FmFileActionCapability", values);
	return fm_file_action_capability_type_id;
}

GType
fm_file_action_capability_get_type (void)
{
	static volatile gsize fm_file_action_capability_type_id__once = 0;
	if (g_once_init_enter (&fm_file_action_capability_type_id__once)) {
		GType fm_file_action_capability_type_id;
		fm_file_action_capability_type_id = fm_file_action_capability_get_type_once ();
		g_once_init_leave (&fm_file_action_capability_type_id__once, fm_file_action_capability_type_id);
	}
	return fm_file_action_capability_type_id__once;
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

FmFileActionCondition*
fm_file_action_condition_new (GKeyFile* kf,
                              const gchar* group)
{
	FmFileActionCondition* self;
	gint _tmp0_ = 0;
	gchar** _tmp1_;
	gint _tmp2_ = 0;
	gchar** _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gint _tmp8_ = 0;
	gchar** _tmp9_;
	gint _tmp10_ = 0;
	gchar** _tmp11_;
	gchar* selection_count_str = NULL;
	gchar* _tmp12_;
	const gchar* _tmp13_;
	gint _tmp19_ = 0;
	gchar** _tmp20_;
	gint _tmp21_ = 0;
	gchar** _tmp22_;
	gchar** caps = NULL;
	gint _tmp23_ = 0;
	gchar** _tmp24_;
	gint caps_length1;
	gint _caps_size_;
	gchar** _tmp25_;
	gint _tmp25__length1;
	g_return_val_if_fail (kf != NULL, NULL);
	g_return_val_if_fail (group != NULL, NULL);
	self = g_slice_new0 (FmFileActionCondition);
	fm_file_action_condition_instance_init (self);
	_tmp1_ = utils_key_file_get_string_list (kf, group, "OnlyShowIn", NULL, (gint) 0, &_tmp0_);
	self->only_show_in = (_vala_array_free (self->only_show_in, self->only_show_in_length1, (GDestroyNotify) g_free), NULL);
	self->only_show_in = _tmp1_;
	self->only_show_in_length1 = _tmp0_;
	_tmp3_ = utils_key_file_get_string_list (kf, group, "NotShowIn", NULL, (gint) 0, &_tmp2_);
	self->not_show_in = (_vala_array_free (self->not_show_in, self->not_show_in_length1, (GDestroyNotify) g_free), NULL);
	self->not_show_in = _tmp3_;
	self->not_show_in_length1 = _tmp2_;
	_tmp4_ = utils_key_file_get_string (kf, group, "TryExec", NULL);
	_g_free0 (self->try_exec);
	self->try_exec = _tmp4_;
	_tmp5_ = utils_key_file_get_string (kf, group, "ShowIfRegistered", NULL);
	_g_free0 (self->show_if_registered);
	self->show_if_registered = _tmp5_;
	_tmp6_ = utils_key_file_get_string (kf, group, "ShowIfTrue", NULL);
	_g_free0 (self->show_if_true);
	self->show_if_true = _tmp6_;
	_tmp7_ = utils_key_file_get_string (kf, group, "ShowIfRunning", NULL);
	_g_free0 (self->show_if_running);
	self->show_if_running = _tmp7_;
	_tmp9_ = utils_key_file_get_string_list (kf, group, "MimeTypes", NULL, (gint) 0, &_tmp8_);
	self->mime_types = (_vala_array_free (self->mime_types, self->mime_types_length1, (GDestroyNotify) g_free), NULL);
	self->mime_types = _tmp9_;
	self->mime_types_length1 = _tmp8_;
	_tmp11_ = utils_key_file_get_string_list (kf, group, "Basenames", NULL, (gint) 0, &_tmp10_);
	self->base_names = (_vala_array_free (self->base_names, self->base_names_length1, (GDestroyNotify) g_free), NULL);
	self->base_names = _tmp11_;
	self->base_names_length1 = _tmp10_;
	self->match_case = utils_key_file_get_bool (kf, group, "Matchcase", FALSE);
	_tmp12_ = utils_key_file_get_string (kf, group, "SelectionCount", NULL);
	selection_count_str = _tmp12_;
	_tmp13_ = selection_count_str;
	if (_tmp13_ != NULL) {
		const gchar* _tmp14_;
		_tmp14_ = selection_count_str;
		switch (string_get (_tmp14_, (glong) 0)) {
			case '<':
			case '>':
			case '=':
			{
				const gchar* _tmp15_;
				gchar tmp = '\0';
				static const char s[] = "%c%d";
				const gchar* _tmp16_;
				gchar _tmp17_ = '\0';
				gint _tmp18_ = 0;
				_tmp15_ = selection_count_str;
				self->selection_count_cmp = string_get (_tmp15_, (glong) 0);
				tmp = (gchar) 0;
				_tmp16_ = selection_count_str;
				sscanf (_tmp16_, s, &_tmp17_, &_tmp18_);
				tmp = _tmp17_;
				self->selection_count = _tmp18_;
				break;
			}
			default:
			{
				self->selection_count_cmp = '>';
				self->selection_count = 0;
				break;
			}
		}
	} else {
		self->selection_count_cmp = '>';
		self->selection_count = 0;
	}
	_tmp20_ = utils_key_file_get_string_list (kf, group, "Schemes", NULL, (gint) 0, &_tmp19_);
	self->schemes = (_vala_array_free (self->schemes, self->schemes_length1, (GDestroyNotify) g_free), NULL);
	self->schemes = _tmp20_;
	self->schemes_length1 = _tmp19_;
	_tmp22_ = utils_key_file_get_string_list (kf, group, "Folders", NULL, (gint) 0, &_tmp21_);
	self->folders = (_vala_array_free (self->folders, self->folders_length1, (GDestroyNotify) g_free), NULL);
	self->folders = _tmp22_;
	self->folders_length1 = _tmp21_;
	_tmp24_ = utils_key_file_get_string_list (kf, group, "Capabilities", NULL, (gint) 0, &_tmp23_);
	caps = _tmp24_;
	caps_length1 = _tmp23_;
	_caps_size_ = caps_length1;
	_tmp25_ = caps;
	_tmp25__length1 = caps_length1;
	{
		gchar** cap_collection = NULL;
		gint cap_collection_length1 = 0;
		gint _cap_collection_size_ = 0;
		gint cap_it = 0;
		cap_collection = _tmp25_;
		cap_collection_length1 = _tmp25__length1;
		for (cap_it = 0; cap_it < cap_collection_length1; cap_it = cap_it + 1) {
			const gchar* cap = NULL;
			cap = cap_collection[cap_it];
			{
				FILE* _tmp26_;
				const gchar* _tmp27_;
				_tmp26_ = stdin;
				_tmp27_ = cap;
				fprintf (_tmp26_, "%s\n", _tmp27_);
			}
		}
	}
	caps = (_vala_array_free (caps, caps_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (selection_count_str);
	return self;
}

static inline gboolean
fm_file_action_condition_match_try_exec (FmFileActionCondition* self,
                                         GList* files)
{
	const gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->try_exec;
	if (_tmp0_ != NULL) {
		gchar* exec_path = NULL;
		const gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		const gchar* _tmp6_;
		_tmp1_ = self->try_exec;
		_tmp2_ = fm_file_action_parameters_expand (_tmp1_, files, FALSE, NULL);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_find_program_in_path (_tmp3_);
		_tmp5_ = _tmp4_;
		_g_free0 (_tmp3_);
		exec_path = _tmp5_;
		_tmp6_ = exec_path;
		if (!g_file_test (_tmp6_, G_FILE_TEST_IS_EXECUTABLE)) {
			result = FALSE;
			_g_free0 (exec_path);
			return result;
		}
		_g_free0 (exec_path);
	}
	result = TRUE;
	return result;
}

static inline gboolean
fm_file_action_condition_match_show_if_registered (FmFileActionCondition* self,
                                                   GList* files)
{
	const gchar* _tmp0_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->show_if_registered;
	if (_tmp0_ != NULL) {
		gchar* service = NULL;
		const gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = self->show_if_registered;
		_tmp2_ = fm_file_action_parameters_expand (_tmp1_, files, FALSE, NULL);
		service = _tmp2_;
		{
			GDBusConnection* con = NULL;
			GDBusConnection* _tmp3_;
			GVariant* _result_ = NULL;
			GDBusConnection* _tmp5_;
			const gchar* _tmp6_;
			GVariant* _tmp7_;
			GVariant* _tmp8_;
			GVariantType* _tmp9_;
			GVariantType* _tmp10_;
			GVariant* _tmp11_;
			GVariant* _tmp12_;
			gboolean name_has_owner = FALSE;
			GVariant* _tmp13_;
			gboolean _tmp14_ = FALSE;
			_tmp3_ = g_bus_get_sync (G_BUS_TYPE_SESSION, NULL, &_inner_error0_);
			con = _tmp3_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gboolean _tmp4_ = FALSE;
				if (_inner_error0_->domain == G_IO_ERROR) {
					goto __catch0_g_io_error;
				}
				_g_free0 (service);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp4_;
			}
			_tmp5_ = con;
			_tmp6_ = service;
			_tmp7_ = g_variant_new ("(s)", _tmp6_, NULL);
			g_variant_ref_sink (_tmp7_);
			_tmp8_ = _tmp7_;
			_tmp9_ = g_variant_type_new ("(b)");
			_tmp10_ = _tmp9_;
			_tmp11_ = g_dbus_connection_call_sync (_tmp5_, "org.freedesktop.DBus", "/org/freedesktop/DBus", "org.freedesktop.DBus", "NameHasOwner", _tmp8_, _tmp10_, G_DBUS_CALL_FLAGS_NONE, -1, NULL, &_inner_error0_);
			_tmp12_ = _tmp11_;
			_g_variant_type_free0 (_tmp10_);
			_g_variant_unref0 (_tmp8_);
			_result_ = _tmp12_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (con);
				if (_inner_error0_->domain == G_IO_ERROR) {
					goto __catch0_g_io_error;
				}
				goto __finally0;
			}
			_tmp13_ = _result_;
			g_variant_get (_tmp13_, "(b)", &_tmp14_, NULL);
			name_has_owner = _tmp14_;
			if (!name_has_owner) {
				result = FALSE;
				_g_variant_unref0 (_result_);
				_g_object_unref0 (con);
				_g_free0 (service);
				return result;
			}
			_g_variant_unref0 (_result_);
			_g_object_unref0 (con);
		}
		goto __finally0;
		__catch0_g_io_error:
		{
			g_clear_error (&_inner_error0_);
			result = FALSE;
			_g_free0 (service);
			return result;
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp15_ = FALSE;
			_g_free0 (service);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp15_;
		}
		_g_free0 (service);
	}
	result = TRUE;
	return result;
}

static inline gboolean
fm_file_action_condition_match_show_if_true (FmFileActionCondition* self,
                                             GList* files)
{
	const gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->show_if_true;
	if (_tmp0_ != NULL) {
		gchar* cmd = NULL;
		const gchar* _tmp1_;
		gchar* _tmp2_;
		gint exit_status = 0;
		const gchar* _tmp3_;
		_tmp1_ = self->show_if_true;
		_tmp2_ = fm_file_action_parameters_expand (_tmp1_, files, FALSE, NULL);
		cmd = _tmp2_;
		_tmp3_ = cmd;
		exit_status = system (_tmp3_);
		if (exit_status != 0) {
			result = FALSE;
			_g_free0 (cmd);
			return result;
		}
		_g_free0 (cmd);
	}
	result = TRUE;
	return result;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static inline gboolean
fm_file_action_condition_match_show_if_running (FmFileActionCondition* self,
                                                GList* files)
{
	const gchar* _tmp0_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->show_if_running;
	if (_tmp0_ != NULL) {
		gchar* process_name = NULL;
		const gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* pgrep = NULL;
		gchar* _tmp3_;
		gboolean running = FALSE;
		const gchar* _tmp4_;
		_tmp1_ = self->show_if_running;
		_tmp2_ = fm_file_action_parameters_expand (_tmp1_, files, FALSE, NULL);
		process_name = _tmp2_;
		_tmp3_ = g_find_program_in_path ("pgrep");
		pgrep = _tmp3_;
		running = FALSE;
		_tmp4_ = pgrep;
		if (_tmp4_ != NULL) {
			gint exit_status = 0;
			gboolean _tmp5_ = FALSE;
			const gchar* _tmp6_;
			const gchar* _tmp7_;
			const gchar* _tmp8_;
			const gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			gint _tmp12_ = 0;
			gboolean _tmp13_;
			gboolean _tmp14_;
			_tmp6_ = pgrep;
			_tmp7_ = string_to_string (_tmp6_);
			_tmp8_ = process_name;
			_tmp9_ = string_to_string (_tmp8_);
			_tmp10_ = g_strconcat (_tmp7_, " -x '", _tmp9_, "'", NULL);
			_tmp11_ = _tmp10_;
			_tmp13_ = g_spawn_command_line_sync (_tmp11_, NULL, NULL, &_tmp12_, &_inner_error0_);
			exit_status = _tmp12_;
			_tmp14_ = _tmp13_;
			_g_free0 (_tmp11_);
			_tmp5_ = _tmp14_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gboolean _tmp15_ = FALSE;
				_g_free0 (pgrep);
				_g_free0 (process_name);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp15_;
			}
			if (_tmp5_) {
				if (exit_status == 0) {
					running = TRUE;
				}
			}
		}
		if (!running) {
			result = FALSE;
			_g_free0 (pgrep);
			_g_free0 (process_name);
			return result;
		}
		_g_free0 (pgrep);
		_g_free0 (process_name);
	}
	result = TRUE;
	return result;
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static inline gboolean
fm_file_action_condition_match_mime_type (FmFileActionCondition* self,
                                          GList* files,
                                          const gchar* type,
                                          gboolean negated)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (type != NULL, FALSE);
	if (g_strcmp0 (type, "all/all") == 0) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (type, "*") == 0;
	}
	if (_tmp0_) {
		gboolean _tmp1_ = FALSE;
		if (negated) {
			_tmp1_ = FALSE;
		} else {
			_tmp1_ = TRUE;
		}
		result = _tmp1_;
		return result;
	} else {
		if (g_strcmp0 (type, "all/allfiles") == 0) {
			if (negated) {
				{
					GList* fi_collection = NULL;
					GList* fi_it = NULL;
					fi_collection = files;
					for (fi_it = fi_collection; fi_it != NULL; fi_it = fi_it->next) {
						FmFileInfo* fi = NULL;
						fi = (FmFileInfo*) fi_it->data;
						{
							FmFileInfo* _tmp2_;
							_tmp2_ = fi;
							if (!fm_file_info_is_dir (_tmp2_)) {
								result = FALSE;
								return result;
							}
						}
					}
				}
			} else {
				{
					GList* fi_collection = NULL;
					GList* fi_it = NULL;
					fi_collection = files;
					for (fi_it = fi_collection; fi_it != NULL; fi_it = fi_it->next) {
						FmFileInfo* fi = NULL;
						fi = (FmFileInfo*) fi_it->data;
						{
							FmFileInfo* _tmp3_;
							_tmp3_ = fi;
							if (fm_file_info_is_dir (_tmp3_)) {
								result = FALSE;
								return result;
							}
						}
					}
				}
			}
		} else {
			if (g_str_has_suffix (type, "/*")) {
				gchar* prefix = NULL;
				gchar* _tmp4_;
				_tmp4_ = string_slice (type, (glong) 0, (glong) -1);
				prefix = _tmp4_;
				if (negated) {
					{
						GList* fi_collection = NULL;
						GList* fi_it = NULL;
						fi_collection = files;
						for (fi_it = fi_collection; fi_it != NULL; fi_it = fi_it->next) {
							FmFileInfo* fi = NULL;
							fi = (FmFileInfo*) fi_it->data;
							{
								FmFileInfo* _tmp5_;
								FmMimeType* _tmp6_;
								const gchar* _tmp7_;
								const gchar* _tmp8_;
								_tmp5_ = fi;
								_tmp6_ = fm_file_info_get_mime_type (_tmp5_);
								_tmp7_ = fm_mime_type_get_type (_tmp6_);
								_tmp8_ = prefix;
								if (g_str_has_prefix (_tmp7_, _tmp8_)) {
									result = FALSE;
									_g_free0 (prefix);
									return result;
								}
							}
						}
					}
				} else {
					{
						GList* fi_collection = NULL;
						GList* fi_it = NULL;
						fi_collection = files;
						for (fi_it = fi_collection; fi_it != NULL; fi_it = fi_it->next) {
							FmFileInfo* fi = NULL;
							fi = (FmFileInfo*) fi_it->data;
							{
								FmFileInfo* _tmp9_;
								FmMimeType* _tmp10_;
								const gchar* _tmp11_;
								const gchar* _tmp12_;
								_tmp9_ = fi;
								_tmp10_ = fm_file_info_get_mime_type (_tmp9_);
								_tmp11_ = fm_mime_type_get_type (_tmp10_);
								_tmp12_ = prefix;
								if (!g_str_has_prefix (_tmp11_, _tmp12_)) {
									result = FALSE;
									_g_free0 (prefix);
									return result;
								}
							}
						}
					}
				}
				_g_free0 (prefix);
			} else {
				if (negated) {
					{
						GList* fi_collection = NULL;
						GList* fi_it = NULL;
						fi_collection = files;
						for (fi_it = fi_collection; fi_it != NULL; fi_it = fi_it->next) {
							FmFileInfo* fi = NULL;
							fi = (FmFileInfo*) fi_it->data;
							{
								FmFileInfo* _tmp13_;
								FmMimeType* _tmp14_;
								const gchar* _tmp15_;
								_tmp13_ = fi;
								_tmp14_ = fm_file_info_get_mime_type (_tmp13_);
								_tmp15_ = fm_mime_type_get_type (_tmp14_);
								if (g_strcmp0 (_tmp15_, type) == 0) {
									result = FALSE;
									return result;
								}
							}
						}
					}
				} else {
					{
						GList* fi_collection = NULL;
						GList* fi_it = NULL;
						fi_collection = files;
						for (fi_it = fi_collection; fi_it != NULL; fi_it = fi_it->next) {
							FmFileInfo* fi = NULL;
							fi = (FmFileInfo*) fi_it->data;
							{
								FmFileInfo* _tmp16_;
								FmMimeType* _tmp17_;
								const gchar* _tmp18_;
								_tmp16_ = fi;
								_tmp17_ = fm_file_info_get_mime_type (_tmp16_);
								_tmp18_ = fm_mime_type_get_type (_tmp17_);
								if (g_strcmp0 (_tmp18_, type) != 0) {
									result = FALSE;
									return result;
								}
							}
						}
					}
				}
			}
		}
	}
	result = TRUE;
	return result;
}

static inline gboolean
fm_file_action_condition_match_mime_types (FmFileActionCondition* self,
                                           GList* files)
{
	gchar** _tmp0_;
	gint _tmp0__length1;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->mime_types;
	_tmp0__length1 = self->mime_types_length1;
	if (_tmp0_ != NULL) {
		gboolean allowed = FALSE;
		gchar** _tmp1_;
		gint _tmp1__length1;
		allowed = FALSE;
		_tmp1_ = self->mime_types;
		_tmp1__length1 = self->mime_types_length1;
		{
			gchar** allowed_type_collection = NULL;
			gint allowed_type_collection_length1 = 0;
			gint _allowed_type_collection_size_ = 0;
			gint allowed_type_it = 0;
			allowed_type_collection = _tmp1_;
			allowed_type_collection_length1 = _tmp1__length1;
			for (allowed_type_it = 0; allowed_type_it < allowed_type_collection_length1; allowed_type_it = allowed_type_it + 1) {
				const gchar* allowed_type = NULL;
				allowed_type = allowed_type_collection[allowed_type_it];
				{
					const gchar* type = NULL;
					gboolean negated = FALSE;
					const gchar* _tmp2_;
					_tmp2_ = allowed_type;
					if (string_get (_tmp2_, (glong) 0) == '!') {
						const gchar* _tmp3_;
						_tmp3_ = allowed_type;
						type = (const gchar*) (((guint8*) _tmp3_) + 1);
						negated = TRUE;
					} else {
						const gchar* _tmp4_;
						_tmp4_ = allowed_type;
						type = _tmp4_;
						negated = FALSE;
					}
					if (negated) {
						gboolean type_is_allowed = FALSE;
						const gchar* _tmp5_;
						_tmp5_ = type;
						type_is_allowed = fm_file_action_condition_match_mime_type (self, files, _tmp5_, negated);
						if (!type_is_allowed) {
							result = FALSE;
							return result;
						}
					} else {
						if (!allowed) {
							const gchar* _tmp6_;
							_tmp6_ = type;
							allowed = fm_file_action_condition_match_mime_type (self, files, _tmp6_, FALSE);
						}
					}
				}
			}
		}
		result = allowed;
		return result;
	}
	result = TRUE;
	return result;
}

static inline gboolean
fm_file_action_condition_match_base_name (FmFileActionCondition* self,
                                          GList* files,
                                          const gchar* base_name,
                                          gboolean negated)
{
	GPatternSpec* pattern = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (base_name != NULL, FALSE);
	if (self->match_case) {
		GPatternSpec* _tmp0_;
		_tmp0_ = g_pattern_spec_new (base_name);
		_g_pattern_spec_free0 (pattern);
		pattern = _tmp0_;
	} else {
		gchar* _tmp1_;
		gchar* _tmp2_;
		GPatternSpec* _tmp3_;
		_tmp1_ = g_utf8_casefold (base_name, (gssize) -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_pattern_spec_new (_tmp2_);
		_g_pattern_spec_free0 (pattern);
		pattern = _tmp3_;
		_g_free0 (_tmp2_);
	}
	{
		GList* fi_collection = NULL;
		GList* fi_it = NULL;
		fi_collection = files;
		for (fi_it = fi_collection; fi_it != NULL; fi_it = fi_it->next) {
			FmFileInfo* fi = NULL;
			fi = (FmFileInfo*) fi_it->data;
			{
				gchar* name = NULL;
				FmFileInfo* _tmp4_;
				const gchar* _tmp5_;
				gchar* _tmp6_;
				_tmp4_ = fi;
				_tmp5_ = fm_file_info_get_name (_tmp4_);
				_tmp6_ = g_strdup (_tmp5_);
				name = _tmp6_;
				if (self->match_case) {
					GPatternSpec* _tmp7_;
					const gchar* _tmp8_;
					_tmp7_ = pattern;
					_tmp8_ = name;
					if (g_pattern_match_string (_tmp7_, _tmp8_)) {
						if (negated) {
							result = FALSE;
							_g_free0 (name);
							_g_pattern_spec_free0 (pattern);
							return result;
						}
					} else {
						if (!negated) {
							result = FALSE;
							_g_free0 (name);
							_g_pattern_spec_free0 (pattern);
							return result;
						}
					}
				} else {
					GPatternSpec* _tmp9_;
					const gchar* _tmp10_;
					gchar* _tmp11_;
					gchar* _tmp12_;
					gboolean _tmp13_;
					_tmp9_ = pattern;
					_tmp10_ = name;
					_tmp11_ = g_utf8_casefold (_tmp10_, (gssize) -1);
					_tmp12_ = _tmp11_;
					_tmp13_ = g_pattern_match_string (_tmp9_, _tmp12_);
					_g_free0 (_tmp12_);
					if (_tmp13_) {
						if (negated) {
							result = FALSE;
							_g_free0 (name);
							_g_pattern_spec_free0 (pattern);
							return result;
						}
					} else {
						if (!negated) {
							result = FALSE;
							_g_free0 (name);
							_g_pattern_spec_free0 (pattern);
							return result;
						}
					}
				}
				_g_free0 (name);
			}
		}
	}
	result = TRUE;
	_g_pattern_spec_free0 (pattern);
	return result;
}

static inline gboolean
fm_file_action_condition_match_base_names (FmFileActionCondition* self,
                                           GList* files)
{
	gchar** _tmp0_;
	gint _tmp0__length1;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->base_names;
	_tmp0__length1 = self->base_names_length1;
	if (_tmp0_ != NULL) {
		gboolean allowed = FALSE;
		gchar** _tmp1_;
		gint _tmp1__length1;
		allowed = FALSE;
		_tmp1_ = self->base_names;
		_tmp1__length1 = self->base_names_length1;
		{
			gchar** allowed_name_collection = NULL;
			gint allowed_name_collection_length1 = 0;
			gint _allowed_name_collection_size_ = 0;
			gint allowed_name_it = 0;
			allowed_name_collection = _tmp1_;
			allowed_name_collection_length1 = _tmp1__length1;
			for (allowed_name_it = 0; allowed_name_it < allowed_name_collection_length1; allowed_name_it = allowed_name_it + 1) {
				const gchar* allowed_name = NULL;
				allowed_name = allowed_name_collection[allowed_name_it];
				{
					const gchar* name = NULL;
					gboolean negated = FALSE;
					const gchar* _tmp2_;
					_tmp2_ = allowed_name;
					if (string_get (_tmp2_, (glong) 0) == '!') {
						const gchar* _tmp3_;
						_tmp3_ = allowed_name;
						name = (const gchar*) (((guint8*) _tmp3_) + 1);
						negated = TRUE;
					} else {
						const gchar* _tmp4_;
						_tmp4_ = allowed_name;
						name = _tmp4_;
						negated = FALSE;
					}
					if (negated) {
						gboolean name_is_allowed = FALSE;
						const gchar* _tmp5_;
						_tmp5_ = name;
						name_is_allowed = fm_file_action_condition_match_base_name (self, files, _tmp5_, negated);
						if (!name_is_allowed) {
							result = FALSE;
							return result;
						}
					} else {
						if (!allowed) {
							const gchar* _tmp6_;
							_tmp6_ = name;
							allowed = fm_file_action_condition_match_base_name (self, files, _tmp6_, FALSE);
						}
					}
				}
			}
		}
		result = allowed;
		return result;
	}
	result = TRUE;
	return result;
}

static gboolean
fm_file_action_condition_match_scheme (GList* files,
                                       const gchar* scheme,
                                       gboolean negated)
{
	gboolean result;
	g_return_val_if_fail (scheme != NULL, FALSE);
	{
		GList* fi_collection = NULL;
		GList* fi_it = NULL;
		fi_collection = files;
		for (fi_it = fi_collection; fi_it != NULL; fi_it = fi_it->next) {
			FmFileInfo* fi = NULL;
			fi = (FmFileInfo*) fi_it->data;
			{
				gchar* uri = NULL;
				FmFileInfo* _tmp0_;
				FmPath* _tmp1_;
				gchar* _tmp2_;
				const gchar* _tmp3_;
				gchar* _tmp4_;
				gchar* _tmp5_;
				gboolean _tmp6_;
				_tmp0_ = fi;
				_tmp1_ = fm_file_info_get_path (_tmp0_);
				_tmp2_ = fm_path_to_uri (_tmp1_);
				uri = _tmp2_;
				_tmp3_ = uri;
				_tmp4_ = g_uri_parse_scheme (_tmp3_);
				_tmp5_ = _tmp4_;
				_tmp6_ = g_strcmp0 (_tmp5_, scheme) == 0;
				_g_free0 (_tmp5_);
				if (_tmp6_) {
					if (negated) {
						result = FALSE;
						_g_free0 (uri);
						return result;
					}
				} else {
					if (!negated) {
						result = FALSE;
						_g_free0 (uri);
						return result;
					}
				}
				_g_free0 (uri);
			}
		}
	}
	result = TRUE;
	return result;
}

static inline gboolean
fm_file_action_condition_match_schemes (FmFileActionCondition* self,
                                        GList* files)
{
	gchar** _tmp0_;
	gint _tmp0__length1;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->schemes;
	_tmp0__length1 = self->schemes_length1;
	if (_tmp0_ != NULL) {
		gboolean allowed = FALSE;
		gchar** _tmp1_;
		gint _tmp1__length1;
		allowed = FALSE;
		_tmp1_ = self->schemes;
		_tmp1__length1 = self->schemes_length1;
		{
			gchar** allowed_scheme_collection = NULL;
			gint allowed_scheme_collection_length1 = 0;
			gint _allowed_scheme_collection_size_ = 0;
			gint allowed_scheme_it = 0;
			allowed_scheme_collection = _tmp1_;
			allowed_scheme_collection_length1 = _tmp1__length1;
			for (allowed_scheme_it = 0; allowed_scheme_it < allowed_scheme_collection_length1; allowed_scheme_it = allowed_scheme_it + 1) {
				const gchar* allowed_scheme = NULL;
				allowed_scheme = allowed_scheme_collection[allowed_scheme_it];
				{
					const gchar* scheme = NULL;
					gboolean negated = FALSE;
					const gchar* _tmp2_;
					_tmp2_ = allowed_scheme;
					if (string_get (_tmp2_, (glong) 0) == '!') {
						const gchar* _tmp3_;
						_tmp3_ = allowed_scheme;
						scheme = (const gchar*) (((guint8*) _tmp3_) + 1);
						negated = TRUE;
					} else {
						const gchar* _tmp4_;
						_tmp4_ = allowed_scheme;
						scheme = _tmp4_;
						negated = FALSE;
					}
					if (negated) {
						gboolean scheme_is_allowed = FALSE;
						const gchar* _tmp5_;
						_tmp5_ = scheme;
						scheme_is_allowed = fm_file_action_condition_match_scheme (files, _tmp5_, negated);
						if (!scheme_is_allowed) {
							result = FALSE;
							return result;
						}
					} else {
						if (!allowed) {
							const gchar* _tmp6_;
							_tmp6_ = scheme;
							allowed = fm_file_action_condition_match_scheme (files, _tmp6_, FALSE);
						}
					}
				}
			}
		}
		result = allowed;
		return result;
	}
	result = TRUE;
	return result;
}

static gboolean
fm_file_action_condition_match_folder (GList* files,
                                       const gchar* folder,
                                       gboolean negated)
{
	GPatternSpec* pattern = NULL;
	gboolean result;
	g_return_val_if_fail (folder != NULL, FALSE);
	if (g_str_has_suffix (folder, "/*")) {
		GPatternSpec* _tmp0_;
		_tmp0_ = g_pattern_spec_new (folder);
		_g_pattern_spec_free0 (pattern);
		pattern = _tmp0_;
	} else {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		GPatternSpec* _tmp4_;
		_tmp1_ = string_to_string (folder);
		_tmp2_ = g_strconcat (_tmp1_, "/*", NULL);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_pattern_spec_new (_tmp3_);
		_g_pattern_spec_free0 (pattern);
		pattern = _tmp4_;
		_g_free0 (_tmp3_);
	}
	{
		GList* fi_collection = NULL;
		GList* fi_it = NULL;
		fi_collection = files;
		for (fi_it = fi_collection; fi_it != NULL; fi_it = fi_it->next) {
			FmFileInfo* fi = NULL;
			fi = (FmFileInfo*) fi_it->data;
			{
				gchar* dirname = NULL;
				FmFileInfo* _tmp5_;
				FmPath* _tmp6_;
				FmPath* _tmp7_;
				gchar* _tmp8_;
				GPatternSpec* _tmp9_;
				const gchar* _tmp10_;
				_tmp5_ = fi;
				_tmp6_ = fm_file_info_get_path (_tmp5_);
				_tmp7_ = fm_path_get_parent (_tmp6_);
				_tmp8_ = fm_path_to_str (_tmp7_);
				dirname = _tmp8_;
				_tmp9_ = pattern;
				_tmp10_ = dirname;
				if (g_pattern_match_string (_tmp9_, _tmp10_)) {
					if (negated) {
						result = FALSE;
						_g_free0 (dirname);
						_g_pattern_spec_free0 (pattern);
						return result;
					}
				} else {
					if (!negated) {
						result = FALSE;
						_g_free0 (dirname);
						_g_pattern_spec_free0 (pattern);
						return result;
					}
				}
				_g_free0 (dirname);
			}
		}
	}
	result = TRUE;
	_g_pattern_spec_free0 (pattern);
	return result;
}

static inline gboolean
fm_file_action_condition_match_folders (FmFileActionCondition* self,
                                        GList* files)
{
	gchar** _tmp0_;
	gint _tmp0__length1;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->folders;
	_tmp0__length1 = self->folders_length1;
	if (_tmp0_ != NULL) {
		gboolean allowed = FALSE;
		gchar** _tmp1_;
		gint _tmp1__length1;
		allowed = FALSE;
		_tmp1_ = self->folders;
		_tmp1__length1 = self->folders_length1;
		{
			gchar** allowed_folder_collection = NULL;
			gint allowed_folder_collection_length1 = 0;
			gint _allowed_folder_collection_size_ = 0;
			gint allowed_folder_it = 0;
			allowed_folder_collection = _tmp1_;
			allowed_folder_collection_length1 = _tmp1__length1;
			for (allowed_folder_it = 0; allowed_folder_it < allowed_folder_collection_length1; allowed_folder_it = allowed_folder_it + 1) {
				const gchar* allowed_folder = NULL;
				allowed_folder = allowed_folder_collection[allowed_folder_it];
				{
					const gchar* folder = NULL;
					gboolean negated = FALSE;
					const gchar* _tmp2_;
					_tmp2_ = allowed_folder;
					if (string_get (_tmp2_, (glong) 0) == '!') {
						const gchar* _tmp3_;
						_tmp3_ = allowed_folder;
						folder = (const gchar*) (((guint8*) _tmp3_) + 1);
						negated = TRUE;
					} else {
						const gchar* _tmp4_;
						_tmp4_ = allowed_folder;
						folder = _tmp4_;
						negated = FALSE;
					}
					if (negated) {
						gboolean folder_is_allowed = FALSE;
						const gchar* _tmp5_;
						_tmp5_ = folder;
						folder_is_allowed = fm_file_action_condition_match_folder (files, _tmp5_, negated);
						if (!folder_is_allowed) {
							result = FALSE;
							return result;
						}
					} else {
						if (!allowed) {
							const gchar* _tmp6_;
							_tmp6_ = folder;
							allowed = fm_file_action_condition_match_folder (files, _tmp6_, FALSE);
						}
					}
				}
			}
		}
		result = allowed;
		return result;
	}
	result = TRUE;
	return result;
}

static inline gboolean
fm_file_action_condition_match_selection_count (FmFileActionCondition* self,
                                                GList* files)
{
	guint n_files = 0U;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	n_files = g_list_length (files);
	switch (self->selection_count_cmp) {
		case '<':
		{
			if (n_files >= ((guint) self->selection_count)) {
				result = FALSE;
				return result;
			}
			break;
		}
		case '=':
		{
			if (n_files != ((guint) self->selection_count)) {
				result = FALSE;
				return result;
			}
			break;
		}
		case '>':
		{
			if (n_files <= ((guint) self->selection_count)) {
				result = FALSE;
				return result;
			}
			break;
		}
		default:
		break;
	}
	result = TRUE;
	return result;
}

static inline gboolean
fm_file_action_condition_match_capabilities (FmFileActionCondition* self,
                                             GList* files)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = TRUE;
	return result;
}

gboolean
fm_file_action_condition_match (FmFileActionCondition* self,
                                GList* files)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (!fm_file_action_condition_match_try_exec (self, files)) {
		result = FALSE;
		return result;
	}
	if (!fm_file_action_condition_match_mime_types (self, files)) {
		result = FALSE;
		return result;
	}
	if (!fm_file_action_condition_match_base_names (self, files)) {
		result = FALSE;
		return result;
	}
	if (!fm_file_action_condition_match_selection_count (self, files)) {
		result = FALSE;
		return result;
	}
	if (!fm_file_action_condition_match_schemes (self, files)) {
		result = FALSE;
		return result;
	}
	if (!fm_file_action_condition_match_folders (self, files)) {
		result = FALSE;
		return result;
	}
	if (!fm_file_action_condition_match_capabilities (self, files)) {
		result = FALSE;
		return result;
	}
	if (!fm_file_action_condition_match_show_if_registered (self, files)) {
		result = FALSE;
		return result;
	}
	if (!fm_file_action_condition_match_show_if_true (self, files)) {
		result = FALSE;
		return result;
	}
	if (!fm_file_action_condition_match_show_if_running (self, files)) {
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}

static void
fm_file_action_condition_instance_init (FmFileActionCondition * self)
{
}

void
fm_file_action_condition_free (FmFileActionCondition * self)
{
	self->only_show_in = (_vala_array_free (self->only_show_in, self->only_show_in_length1, (GDestroyNotify) g_free), NULL);
	self->not_show_in = (_vala_array_free (self->not_show_in, self->not_show_in_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (self->try_exec);
	_g_free0 (self->show_if_registered);
	_g_free0 (self->show_if_true);
	_g_free0 (self->show_if_running);
	self->mime_types = (_vala_array_free (self->mime_types, self->mime_types_length1, (GDestroyNotify) g_free), NULL);
	self->base_names = (_vala_array_free (self->base_names, self->base_names_length1, (GDestroyNotify) g_free), NULL);
	self->schemes = (_vala_array_free (self->schemes, self->schemes_length1, (GDestroyNotify) g_free), NULL);
	self->folders = (_vala_array_free (self->folders, self->folders_length1, (GDestroyNotify) g_free), NULL);
	g_slice_free (FmFileActionCondition, self);
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

