{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Data type containing a set of virtual methods used for
-- accessing various Unicode character properties.
-- 
-- HarfBuzz provides a default function for each of the
-- methods in t'GI.HarfBuzz.Structs.UnicodeFuncsT.UnicodeFuncsT'. Client programs can implement
-- their own replacements for the individual Unicode functions, as
-- needed, and replace the default by calling the setter for a
-- method.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.HarfBuzz.Structs.UnicodeFuncsT
    ( 

-- * Exported types
    UnicodeFuncsT(..)                       ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveUnicodeFuncsTMethod              ,
#endif



    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- | Memory-managed wrapper type.
newtype UnicodeFuncsT = UnicodeFuncsT (SP.ManagedPtr UnicodeFuncsT)
    deriving (Eq)

instance SP.ManagedPtrNewtype UnicodeFuncsT where
    toManagedPtr (UnicodeFuncsT p) = p

foreign import ccall "hb_gobject_unicode_funcs_get_type" c_hb_gobject_unicode_funcs_get_type :: 
    IO GType

type instance O.ParentTypes UnicodeFuncsT = '[]
instance O.HasParentTypes UnicodeFuncsT

instance B.Types.TypedObject UnicodeFuncsT where
    glibType = c_hb_gobject_unicode_funcs_get_type

instance B.Types.GBoxed UnicodeFuncsT

-- | Convert t'UnicodeFuncsT' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe UnicodeFuncsT) where
    gvalueGType_ = c_hb_gobject_unicode_funcs_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_boxed gv (FP.nullPtr :: FP.Ptr UnicodeFuncsT)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_boxed gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_boxed gv :: IO (Ptr UnicodeFuncsT)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newBoxed UnicodeFuncsT ptr
        else return P.Nothing
        
    


#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList UnicodeFuncsT
type instance O.AttributeList UnicodeFuncsT = UnicodeFuncsTAttributeList
type UnicodeFuncsTAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveUnicodeFuncsTMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveUnicodeFuncsTMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveUnicodeFuncsTMethod t UnicodeFuncsT, O.OverloadedMethod info UnicodeFuncsT p) => OL.IsLabel t (UnicodeFuncsT -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveUnicodeFuncsTMethod t UnicodeFuncsT, O.OverloadedMethod info UnicodeFuncsT p, R.HasField t UnicodeFuncsT p) => R.HasField t UnicodeFuncsT p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveUnicodeFuncsTMethod t UnicodeFuncsT, O.OverloadedMethodInfo info UnicodeFuncsT) => OL.IsLabel t (O.MethodProxy info UnicodeFuncsT) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


