{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- The interface vtable for t'GI.Gtk.Interfaces.Actionable.Actionable'.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Structs.ActionableInterface
    ( 

-- * Exported types
    ActionableInterface(..)                 ,
    newZeroActionableInterface              ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveActionableInterfaceMethod        ,
#endif



 -- * Properties


-- ** getActionName #attr:getActionName#
-- | virtual function for 'GI.Gtk.Interfaces.Actionable.actionableGetActionName'

#if defined(ENABLE_OVERLOADING)
    actionableInterface_getActionName       ,
#endif
    clearActionableInterfaceGetActionName   ,
    getActionableInterfaceGetActionName     ,
    setActionableInterfaceGetActionName     ,


-- ** getActionTargetValue #attr:getActionTargetValue#
-- | virtual function for 'GI.Gtk.Interfaces.Actionable.actionableGetActionTargetValue'

#if defined(ENABLE_OVERLOADING)
    actionableInterface_getActionTargetValue,
#endif
    clearActionableInterfaceGetActionTargetValue,
    getActionableInterfaceGetActionTargetValue,
    setActionableInterfaceGetActionTargetValue,


-- ** setActionName #attr:setActionName#
-- | virtual function for 'GI.Gtk.Interfaces.Actionable.actionableSetActionName'

#if defined(ENABLE_OVERLOADING)
    actionableInterface_setActionName       ,
#endif
    clearActionableInterfaceSetActionName   ,
    getActionableInterfaceSetActionName     ,
    setActionableInterfaceSetActionName     ,


-- ** setActionTargetValue #attr:setActionTargetValue#
-- | virtual function for 'GI.Gtk.Interfaces.Actionable.actionableSetActionTargetValue'

#if defined(ENABLE_OVERLOADING)
    actionableInterface_setActionTargetValue,
#endif
    clearActionableInterfaceSetActionTargetValue,
    getActionableInterfaceSetActionTargetValue,
    setActionableInterfaceSetActionTargetValue,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Gtk.Callbacks as Gtk.Callbacks

#else
import qualified GI.Gtk.Callbacks as Gtk.Callbacks

#endif

-- | Memory-managed wrapper type.
newtype ActionableInterface = ActionableInterface (SP.ManagedPtr ActionableInterface)
    deriving (Eq)

instance SP.ManagedPtrNewtype ActionableInterface where
    toManagedPtr (ActionableInterface p) = p

instance BoxedPtr ActionableInterface where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 48 >=> B.ManagedPtr.wrapPtr ActionableInterface)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr ActionableInterface where
    boxedPtrCalloc = callocBytes 48


-- | Construct a t'ActionableInterface' struct initialized to zero.
newZeroActionableInterface :: MonadIO m => m ActionableInterface
newZeroActionableInterface = liftIO $ boxedPtrCalloc >>= wrapPtr ActionableInterface

instance tag ~ 'AttrSet => Constructible ActionableInterface tag where
    new _ attrs = do
        o <- newZeroActionableInterface
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@get_action_name@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' actionableInterface #getActionName
-- @
getActionableInterfaceGetActionName :: MonadIO m => ActionableInterface -> m (Maybe Gtk.Callbacks.ActionableInterfaceGetActionNameFieldCallback)
getActionableInterfaceGetActionName s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 16) :: IO (FunPtr Gtk.Callbacks.C_ActionableInterfaceGetActionNameFieldCallback)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = Gtk.Callbacks.dynamic_ActionableInterfaceGetActionNameFieldCallback val'
        return val''
    return result

-- | Set the value of the “@get_action_name@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' actionableInterface [ #getActionName 'Data.GI.Base.Attributes.:=' value ]
-- @
setActionableInterfaceGetActionName :: MonadIO m => ActionableInterface -> FunPtr Gtk.Callbacks.C_ActionableInterfaceGetActionNameFieldCallback -> m ()
setActionableInterfaceGetActionName s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (val :: FunPtr Gtk.Callbacks.C_ActionableInterfaceGetActionNameFieldCallback)

-- | Set the value of the “@get_action_name@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #getActionName
-- @
clearActionableInterfaceGetActionName :: MonadIO m => ActionableInterface -> m ()
clearActionableInterfaceGetActionName s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (FP.nullFunPtr :: FunPtr Gtk.Callbacks.C_ActionableInterfaceGetActionNameFieldCallback)

#if defined(ENABLE_OVERLOADING)
data ActionableInterfaceGetActionNameFieldInfo
instance AttrInfo ActionableInterfaceGetActionNameFieldInfo where
    type AttrBaseTypeConstraint ActionableInterfaceGetActionNameFieldInfo = (~) ActionableInterface
    type AttrAllowedOps ActionableInterfaceGetActionNameFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint ActionableInterfaceGetActionNameFieldInfo = (~) (FunPtr Gtk.Callbacks.C_ActionableInterfaceGetActionNameFieldCallback)
    type AttrTransferTypeConstraint ActionableInterfaceGetActionNameFieldInfo = (~)Gtk.Callbacks.ActionableInterfaceGetActionNameFieldCallback
    type AttrTransferType ActionableInterfaceGetActionNameFieldInfo = (FunPtr Gtk.Callbacks.C_ActionableInterfaceGetActionNameFieldCallback)
    type AttrGetType ActionableInterfaceGetActionNameFieldInfo = Maybe Gtk.Callbacks.ActionableInterfaceGetActionNameFieldCallback
    type AttrLabel ActionableInterfaceGetActionNameFieldInfo = "get_action_name"
    type AttrOrigin ActionableInterfaceGetActionNameFieldInfo = ActionableInterface
    attrGet = getActionableInterfaceGetActionName
    attrSet = setActionableInterfaceGetActionName
    attrConstruct = undefined
    attrClear = clearActionableInterfaceGetActionName
    attrTransfer _ v = do
        Gtk.Callbacks.mk_ActionableInterfaceGetActionNameFieldCallback (Gtk.Callbacks.wrap_ActionableInterfaceGetActionNameFieldCallback Nothing v)
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Structs.ActionableInterface.getActionName"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-3.0.43/docs/GI-Gtk-Structs-ActionableInterface.html#g:attr:getActionName"
        })

actionableInterface_getActionName :: AttrLabelProxy "getActionName"
actionableInterface_getActionName = AttrLabelProxy

#endif


-- | Get the value of the “@set_action_name@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' actionableInterface #setActionName
-- @
getActionableInterfaceSetActionName :: MonadIO m => ActionableInterface -> m (Maybe Gtk.Callbacks.ActionableInterfaceSetActionNameFieldCallback)
getActionableInterfaceSetActionName s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 24) :: IO (FunPtr Gtk.Callbacks.C_ActionableInterfaceSetActionNameFieldCallback)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = Gtk.Callbacks.dynamic_ActionableInterfaceSetActionNameFieldCallback val'
        return val''
    return result

-- | Set the value of the “@set_action_name@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' actionableInterface [ #setActionName 'Data.GI.Base.Attributes.:=' value ]
-- @
setActionableInterfaceSetActionName :: MonadIO m => ActionableInterface -> FunPtr Gtk.Callbacks.C_ActionableInterfaceSetActionNameFieldCallback -> m ()
setActionableInterfaceSetActionName s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 24) (val :: FunPtr Gtk.Callbacks.C_ActionableInterfaceSetActionNameFieldCallback)

-- | Set the value of the “@set_action_name@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #setActionName
-- @
clearActionableInterfaceSetActionName :: MonadIO m => ActionableInterface -> m ()
clearActionableInterfaceSetActionName s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 24) (FP.nullFunPtr :: FunPtr Gtk.Callbacks.C_ActionableInterfaceSetActionNameFieldCallback)

#if defined(ENABLE_OVERLOADING)
data ActionableInterfaceSetActionNameFieldInfo
instance AttrInfo ActionableInterfaceSetActionNameFieldInfo where
    type AttrBaseTypeConstraint ActionableInterfaceSetActionNameFieldInfo = (~) ActionableInterface
    type AttrAllowedOps ActionableInterfaceSetActionNameFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint ActionableInterfaceSetActionNameFieldInfo = (~) (FunPtr Gtk.Callbacks.C_ActionableInterfaceSetActionNameFieldCallback)
    type AttrTransferTypeConstraint ActionableInterfaceSetActionNameFieldInfo = (~)Gtk.Callbacks.ActionableInterfaceSetActionNameFieldCallback
    type AttrTransferType ActionableInterfaceSetActionNameFieldInfo = (FunPtr Gtk.Callbacks.C_ActionableInterfaceSetActionNameFieldCallback)
    type AttrGetType ActionableInterfaceSetActionNameFieldInfo = Maybe Gtk.Callbacks.ActionableInterfaceSetActionNameFieldCallback
    type AttrLabel ActionableInterfaceSetActionNameFieldInfo = "set_action_name"
    type AttrOrigin ActionableInterfaceSetActionNameFieldInfo = ActionableInterface
    attrGet = getActionableInterfaceSetActionName
    attrSet = setActionableInterfaceSetActionName
    attrConstruct = undefined
    attrClear = clearActionableInterfaceSetActionName
    attrTransfer _ v = do
        Gtk.Callbacks.mk_ActionableInterfaceSetActionNameFieldCallback (Gtk.Callbacks.wrap_ActionableInterfaceSetActionNameFieldCallback Nothing v)
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Structs.ActionableInterface.setActionName"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-3.0.43/docs/GI-Gtk-Structs-ActionableInterface.html#g:attr:setActionName"
        })

actionableInterface_setActionName :: AttrLabelProxy "setActionName"
actionableInterface_setActionName = AttrLabelProxy

#endif


-- | Get the value of the “@get_action_target_value@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' actionableInterface #getActionTargetValue
-- @
getActionableInterfaceGetActionTargetValue :: MonadIO m => ActionableInterface -> m (Maybe Gtk.Callbacks.ActionableInterfaceGetActionTargetValueFieldCallback)
getActionableInterfaceGetActionTargetValue s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 32) :: IO (FunPtr Gtk.Callbacks.C_ActionableInterfaceGetActionTargetValueFieldCallback)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = Gtk.Callbacks.dynamic_ActionableInterfaceGetActionTargetValueFieldCallback val'
        return val''
    return result

-- | Set the value of the “@get_action_target_value@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' actionableInterface [ #getActionTargetValue 'Data.GI.Base.Attributes.:=' value ]
-- @
setActionableInterfaceGetActionTargetValue :: MonadIO m => ActionableInterface -> FunPtr Gtk.Callbacks.C_ActionableInterfaceGetActionTargetValueFieldCallback -> m ()
setActionableInterfaceGetActionTargetValue s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 32) (val :: FunPtr Gtk.Callbacks.C_ActionableInterfaceGetActionTargetValueFieldCallback)

-- | Set the value of the “@get_action_target_value@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #getActionTargetValue
-- @
clearActionableInterfaceGetActionTargetValue :: MonadIO m => ActionableInterface -> m ()
clearActionableInterfaceGetActionTargetValue s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 32) (FP.nullFunPtr :: FunPtr Gtk.Callbacks.C_ActionableInterfaceGetActionTargetValueFieldCallback)

#if defined(ENABLE_OVERLOADING)
data ActionableInterfaceGetActionTargetValueFieldInfo
instance AttrInfo ActionableInterfaceGetActionTargetValueFieldInfo where
    type AttrBaseTypeConstraint ActionableInterfaceGetActionTargetValueFieldInfo = (~) ActionableInterface
    type AttrAllowedOps ActionableInterfaceGetActionTargetValueFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint ActionableInterfaceGetActionTargetValueFieldInfo = (~) (FunPtr Gtk.Callbacks.C_ActionableInterfaceGetActionTargetValueFieldCallback)
    type AttrTransferTypeConstraint ActionableInterfaceGetActionTargetValueFieldInfo = (~)Gtk.Callbacks.ActionableInterfaceGetActionTargetValueFieldCallback
    type AttrTransferType ActionableInterfaceGetActionTargetValueFieldInfo = (FunPtr Gtk.Callbacks.C_ActionableInterfaceGetActionTargetValueFieldCallback)
    type AttrGetType ActionableInterfaceGetActionTargetValueFieldInfo = Maybe Gtk.Callbacks.ActionableInterfaceGetActionTargetValueFieldCallback
    type AttrLabel ActionableInterfaceGetActionTargetValueFieldInfo = "get_action_target_value"
    type AttrOrigin ActionableInterfaceGetActionTargetValueFieldInfo = ActionableInterface
    attrGet = getActionableInterfaceGetActionTargetValue
    attrSet = setActionableInterfaceGetActionTargetValue
    attrConstruct = undefined
    attrClear = clearActionableInterfaceGetActionTargetValue
    attrTransfer _ v = do
        Gtk.Callbacks.mk_ActionableInterfaceGetActionTargetValueFieldCallback (Gtk.Callbacks.wrap_ActionableInterfaceGetActionTargetValueFieldCallback Nothing v)
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Structs.ActionableInterface.getActionTargetValue"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-3.0.43/docs/GI-Gtk-Structs-ActionableInterface.html#g:attr:getActionTargetValue"
        })

actionableInterface_getActionTargetValue :: AttrLabelProxy "getActionTargetValue"
actionableInterface_getActionTargetValue = AttrLabelProxy

#endif


-- | Get the value of the “@set_action_target_value@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' actionableInterface #setActionTargetValue
-- @
getActionableInterfaceSetActionTargetValue :: MonadIO m => ActionableInterface -> m (Maybe Gtk.Callbacks.ActionableInterfaceSetActionTargetValueFieldCallback)
getActionableInterfaceSetActionTargetValue s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 40) :: IO (FunPtr Gtk.Callbacks.C_ActionableInterfaceSetActionTargetValueFieldCallback)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = Gtk.Callbacks.dynamic_ActionableInterfaceSetActionTargetValueFieldCallback val'
        return val''
    return result

-- | Set the value of the “@set_action_target_value@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' actionableInterface [ #setActionTargetValue 'Data.GI.Base.Attributes.:=' value ]
-- @
setActionableInterfaceSetActionTargetValue :: MonadIO m => ActionableInterface -> FunPtr Gtk.Callbacks.C_ActionableInterfaceSetActionTargetValueFieldCallback -> m ()
setActionableInterfaceSetActionTargetValue s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 40) (val :: FunPtr Gtk.Callbacks.C_ActionableInterfaceSetActionTargetValueFieldCallback)

-- | Set the value of the “@set_action_target_value@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #setActionTargetValue
-- @
clearActionableInterfaceSetActionTargetValue :: MonadIO m => ActionableInterface -> m ()
clearActionableInterfaceSetActionTargetValue s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 40) (FP.nullFunPtr :: FunPtr Gtk.Callbacks.C_ActionableInterfaceSetActionTargetValueFieldCallback)

#if defined(ENABLE_OVERLOADING)
data ActionableInterfaceSetActionTargetValueFieldInfo
instance AttrInfo ActionableInterfaceSetActionTargetValueFieldInfo where
    type AttrBaseTypeConstraint ActionableInterfaceSetActionTargetValueFieldInfo = (~) ActionableInterface
    type AttrAllowedOps ActionableInterfaceSetActionTargetValueFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint ActionableInterfaceSetActionTargetValueFieldInfo = (~) (FunPtr Gtk.Callbacks.C_ActionableInterfaceSetActionTargetValueFieldCallback)
    type AttrTransferTypeConstraint ActionableInterfaceSetActionTargetValueFieldInfo = (~)Gtk.Callbacks.ActionableInterfaceSetActionTargetValueFieldCallback
    type AttrTransferType ActionableInterfaceSetActionTargetValueFieldInfo = (FunPtr Gtk.Callbacks.C_ActionableInterfaceSetActionTargetValueFieldCallback)
    type AttrGetType ActionableInterfaceSetActionTargetValueFieldInfo = Maybe Gtk.Callbacks.ActionableInterfaceSetActionTargetValueFieldCallback
    type AttrLabel ActionableInterfaceSetActionTargetValueFieldInfo = "set_action_target_value"
    type AttrOrigin ActionableInterfaceSetActionTargetValueFieldInfo = ActionableInterface
    attrGet = getActionableInterfaceSetActionTargetValue
    attrSet = setActionableInterfaceSetActionTargetValue
    attrConstruct = undefined
    attrClear = clearActionableInterfaceSetActionTargetValue
    attrTransfer _ v = do
        Gtk.Callbacks.mk_ActionableInterfaceSetActionTargetValueFieldCallback (Gtk.Callbacks.wrap_ActionableInterfaceSetActionTargetValueFieldCallback Nothing v)
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Structs.ActionableInterface.setActionTargetValue"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-3.0.43/docs/GI-Gtk-Structs-ActionableInterface.html#g:attr:setActionTargetValue"
        })

actionableInterface_setActionTargetValue :: AttrLabelProxy "setActionTargetValue"
actionableInterface_setActionTargetValue = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList ActionableInterface
type instance O.AttributeList ActionableInterface = ActionableInterfaceAttributeList
type ActionableInterfaceAttributeList = ('[ '("getActionName", ActionableInterfaceGetActionNameFieldInfo), '("setActionName", ActionableInterfaceSetActionNameFieldInfo), '("getActionTargetValue", ActionableInterfaceGetActionTargetValueFieldInfo), '("setActionTargetValue", ActionableInterfaceSetActionTargetValueFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveActionableInterfaceMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveActionableInterfaceMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveActionableInterfaceMethod t ActionableInterface, O.OverloadedMethod info ActionableInterface p) => OL.IsLabel t (ActionableInterface -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveActionableInterfaceMethod t ActionableInterface, O.OverloadedMethod info ActionableInterface p, R.HasField t ActionableInterface p) => R.HasField t ActionableInterface p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveActionableInterfaceMethod t ActionableInterface, O.OverloadedMethodInfo info ActionableInterface) => OL.IsLabel t (O.MethodProxy info ActionableInterface) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


