{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Creates a custom titlebar for a window.
-- 
-- \<picture>
--   \<source srcset=\"headerbar-dark.png\" media=\"(prefers-color-scheme: dark)\">
--   \<img alt=\"An example GtkHeaderBar\" src=\"headerbar.png\">
-- \<\/picture>
-- 
-- @GtkHeaderBar@ is similar to a horizontal @GtkCenterBox@. It allows
-- children to be placed at the start or the end. In addition, it allows
-- the window title to be displayed. The title will be centered with respect
-- to the width of the box, even if the children at either side take up
-- different amounts of space.
-- 
-- @GtkHeaderBar@ can add typical window frame controls, such as minimize,
-- maximize and close buttons, or the window icon.
-- 
-- For these reasons, @GtkHeaderBar@ is the natural choice for use as the
-- custom titlebar widget of a @GtkWindow@ (see 'GI.Gtk.Objects.Window.windowSetTitlebar'),
-- as it gives features typical of titlebars while allowing the addition of
-- child widgets.
-- 
-- == GtkHeaderBar as GtkBuildable
-- 
-- The @GtkHeaderBar@ implementation of the @GtkBuildable@ interface supports
-- adding children at the start or end sides by specifying “start” or “end” as
-- the “type” attribute of a @\<child>@ element, or setting the title widget by
-- specifying “title” value.
-- 
-- By default the @GtkHeaderBar@ uses a @GtkLabel@ displaying the title of the
-- window it is contained in as the title widget, equivalent to the following
-- UI definition:
-- 
-- 
-- === /xml code/
-- ><object class="GtkHeaderBar">
-- >  <property name="title-widget">
-- >    <object class="GtkLabel">
-- >      <property name="label" translatable="yes">Label</property>
-- >      <property name="single-line-mode">True</property>
-- >      <property name="ellipsize">end</property>
-- >      <property name="width-chars">5</property>
-- >      <style>
-- >        <class name="title"/>
-- >      </style>
-- >    </object>
-- >  </property>
-- ></object>
-- 
-- 
-- = CSS nodes
-- 
-- 
-- 	
-- >headerbar
-- >╰── windowhandle
-- >    ╰── box
-- >        ├── box.start
-- >        │   ├── windowcontrols.start
-- >        │   ╰── [other children]
-- >        ├── [Title Widget]
-- >        ╰── box.end
-- >            ├── [other children]
-- >            ╰── windowcontrols.end
-- 
-- 
-- A @GtkHeaderBar@\'s CSS node is called @headerbar@. It contains a @windowhandle@
-- subnode, which contains a @box@ subnode, which contains two @box@ subnodes at
-- the start and end of the header bar, as well as a center node that represents
-- the title.
-- 
-- Each of the boxes contains a @windowcontrols@ subnode, see
-- t'GI.Gtk.Objects.WindowControls.WindowControls' for details, as well as other children.
-- 
-- = Accessibility
-- 
-- @GtkHeaderBar@ uses the 'GI.Gtk.Enums.AccessibleRoleGroup' role.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.HeaderBar
    ( 

-- * Exported types
    HeaderBar(..)                           ,
    IsHeaderBar                             ,
    toHeaderBar                             ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [actionSetEnabled]("GI.Gtk.Objects.Widget#g:method:actionSetEnabled"), [activate]("GI.Gtk.Objects.Widget#g:method:activate"), [activateAction]("GI.Gtk.Objects.Widget#g:method:activateAction"), [activateDefault]("GI.Gtk.Objects.Widget#g:method:activateDefault"), [addController]("GI.Gtk.Objects.Widget#g:method:addController"), [addCssClass]("GI.Gtk.Objects.Widget#g:method:addCssClass"), [addMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:addMnemonicLabel"), [addTickCallback]("GI.Gtk.Objects.Widget#g:method:addTickCallback"), [allocate]("GI.Gtk.Objects.Widget#g:method:allocate"), [announce]("GI.Gtk.Interfaces.Accessible#g:method:announce"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [childFocus]("GI.Gtk.Objects.Widget#g:method:childFocus"), [computeBounds]("GI.Gtk.Objects.Widget#g:method:computeBounds"), [computeExpand]("GI.Gtk.Objects.Widget#g:method:computeExpand"), [computePoint]("GI.Gtk.Objects.Widget#g:method:computePoint"), [computeTransform]("GI.Gtk.Objects.Widget#g:method:computeTransform"), [contains]("GI.Gtk.Objects.Widget#g:method:contains"), [createPangoContext]("GI.Gtk.Objects.Widget#g:method:createPangoContext"), [createPangoLayout]("GI.Gtk.Objects.Widget#g:method:createPangoLayout"), [disposeTemplate]("GI.Gtk.Objects.Widget#g:method:disposeTemplate"), [dragCheckThreshold]("GI.Gtk.Objects.Widget#g:method:dragCheckThreshold"), [errorBell]("GI.Gtk.Objects.Widget#g:method:errorBell"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [grabFocus]("GI.Gtk.Objects.Widget#g:method:grabFocus"), [hasCssClass]("GI.Gtk.Objects.Widget#g:method:hasCssClass"), [hasDefault]("GI.Gtk.Objects.Widget#g:method:hasDefault"), [hasFocus]("GI.Gtk.Objects.Widget#g:method:hasFocus"), [hasVisibleFocus]("GI.Gtk.Objects.Widget#g:method:hasVisibleFocus"), [hide]("GI.Gtk.Objects.Widget#g:method:hide"), [inDestruction]("GI.Gtk.Objects.Widget#g:method:inDestruction"), [initTemplate]("GI.Gtk.Objects.Widget#g:method:initTemplate"), [insertActionGroup]("GI.Gtk.Objects.Widget#g:method:insertActionGroup"), [insertAfter]("GI.Gtk.Objects.Widget#g:method:insertAfter"), [insertBefore]("GI.Gtk.Objects.Widget#g:method:insertBefore"), [isAncestor]("GI.Gtk.Objects.Widget#g:method:isAncestor"), [isDrawable]("GI.Gtk.Objects.Widget#g:method:isDrawable"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isFocus]("GI.Gtk.Objects.Widget#g:method:isFocus"), [isSensitive]("GI.Gtk.Objects.Widget#g:method:isSensitive"), [isVisible]("GI.Gtk.Objects.Widget#g:method:isVisible"), [keynavFailed]("GI.Gtk.Objects.Widget#g:method:keynavFailed"), [listMnemonicLabels]("GI.Gtk.Objects.Widget#g:method:listMnemonicLabels"), [map]("GI.Gtk.Objects.Widget#g:method:map"), [measure]("GI.Gtk.Objects.Widget#g:method:measure"), [mnemonicActivate]("GI.Gtk.Objects.Widget#g:method:mnemonicActivate"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [observeChildren]("GI.Gtk.Objects.Widget#g:method:observeChildren"), [observeControllers]("GI.Gtk.Objects.Widget#g:method:observeControllers"), [packEnd]("GI.Gtk.Objects.HeaderBar#g:method:packEnd"), [packStart]("GI.Gtk.Objects.HeaderBar#g:method:packStart"), [pick]("GI.Gtk.Objects.Widget#g:method:pick"), [queueAllocate]("GI.Gtk.Objects.Widget#g:method:queueAllocate"), [queueDraw]("GI.Gtk.Objects.Widget#g:method:queueDraw"), [queueResize]("GI.Gtk.Objects.Widget#g:method:queueResize"), [realize]("GI.Gtk.Objects.Widget#g:method:realize"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [remove]("GI.Gtk.Objects.HeaderBar#g:method:remove"), [removeController]("GI.Gtk.Objects.Widget#g:method:removeController"), [removeCssClass]("GI.Gtk.Objects.Widget#g:method:removeCssClass"), [removeMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:removeMnemonicLabel"), [removeTickCallback]("GI.Gtk.Objects.Widget#g:method:removeTickCallback"), [resetProperty]("GI.Gtk.Interfaces.Accessible#g:method:resetProperty"), [resetRelation]("GI.Gtk.Interfaces.Accessible#g:method:resetRelation"), [resetState]("GI.Gtk.Interfaces.Accessible#g:method:resetState"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [shouldLayout]("GI.Gtk.Objects.Widget#g:method:shouldLayout"), [show]("GI.Gtk.Objects.Widget#g:method:show"), [sizeAllocate]("GI.Gtk.Objects.Widget#g:method:sizeAllocate"), [snapshotChild]("GI.Gtk.Objects.Widget#g:method:snapshotChild"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [translateCoordinates]("GI.Gtk.Objects.Widget#g:method:translateCoordinates"), [triggerTooltipQuery]("GI.Gtk.Objects.Widget#g:method:triggerTooltipQuery"), [unmap]("GI.Gtk.Objects.Widget#g:method:unmap"), [unparent]("GI.Gtk.Objects.Widget#g:method:unparent"), [unrealize]("GI.Gtk.Objects.Widget#g:method:unrealize"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [unsetStateFlags]("GI.Gtk.Objects.Widget#g:method:unsetStateFlags"), [updateNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:updateNextAccessibleSibling"), [updatePlatformState]("GI.Gtk.Interfaces.Accessible#g:method:updatePlatformState"), [updateProperty]("GI.Gtk.Interfaces.Accessible#g:method:updateProperty"), [updateRelation]("GI.Gtk.Interfaces.Accessible#g:method:updateRelation"), [updateState]("GI.Gtk.Interfaces.Accessible#g:method:updateState"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleParent"), [getAccessibleRole]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleRole"), [getAllocatedBaseline]("GI.Gtk.Objects.Widget#g:method:getAllocatedBaseline"), [getAllocatedHeight]("GI.Gtk.Objects.Widget#g:method:getAllocatedHeight"), [getAllocatedWidth]("GI.Gtk.Objects.Widget#g:method:getAllocatedWidth"), [getAllocation]("GI.Gtk.Objects.Widget#g:method:getAllocation"), [getAncestor]("GI.Gtk.Objects.Widget#g:method:getAncestor"), [getAtContext]("GI.Gtk.Interfaces.Accessible#g:method:getAtContext"), [getBaseline]("GI.Gtk.Objects.Widget#g:method:getBaseline"), [getBounds]("GI.Gtk.Interfaces.Accessible#g:method:getBounds"), [getBuildableId]("GI.Gtk.Interfaces.Buildable#g:method:getBuildableId"), [getCanFocus]("GI.Gtk.Objects.Widget#g:method:getCanFocus"), [getCanTarget]("GI.Gtk.Objects.Widget#g:method:getCanTarget"), [getChildVisible]("GI.Gtk.Objects.Widget#g:method:getChildVisible"), [getClipboard]("GI.Gtk.Objects.Widget#g:method:getClipboard"), [getColor]("GI.Gtk.Objects.Widget#g:method:getColor"), [getCssClasses]("GI.Gtk.Objects.Widget#g:method:getCssClasses"), [getCssName]("GI.Gtk.Objects.Widget#g:method:getCssName"), [getCursor]("GI.Gtk.Objects.Widget#g:method:getCursor"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDecorationLayout]("GI.Gtk.Objects.HeaderBar#g:method:getDecorationLayout"), [getDirection]("GI.Gtk.Objects.Widget#g:method:getDirection"), [getDisplay]("GI.Gtk.Objects.Widget#g:method:getDisplay"), [getFirstAccessibleChild]("GI.Gtk.Interfaces.Accessible#g:method:getFirstAccessibleChild"), [getFirstChild]("GI.Gtk.Objects.Widget#g:method:getFirstChild"), [getFocusChild]("GI.Gtk.Objects.Widget#g:method:getFocusChild"), [getFocusOnClick]("GI.Gtk.Objects.Widget#g:method:getFocusOnClick"), [getFocusable]("GI.Gtk.Objects.Widget#g:method:getFocusable"), [getFontMap]("GI.Gtk.Objects.Widget#g:method:getFontMap"), [getFontOptions]("GI.Gtk.Objects.Widget#g:method:getFontOptions"), [getFrameClock]("GI.Gtk.Objects.Widget#g:method:getFrameClock"), [getHalign]("GI.Gtk.Objects.Widget#g:method:getHalign"), [getHasTooltip]("GI.Gtk.Objects.Widget#g:method:getHasTooltip"), [getHeight]("GI.Gtk.Objects.Widget#g:method:getHeight"), [getHexpand]("GI.Gtk.Objects.Widget#g:method:getHexpand"), [getHexpandSet]("GI.Gtk.Objects.Widget#g:method:getHexpandSet"), [getLastChild]("GI.Gtk.Objects.Widget#g:method:getLastChild"), [getLayoutManager]("GI.Gtk.Objects.Widget#g:method:getLayoutManager"), [getLimitEvents]("GI.Gtk.Objects.Widget#g:method:getLimitEvents"), [getMapped]("GI.Gtk.Objects.Widget#g:method:getMapped"), [getMarginBottom]("GI.Gtk.Objects.Widget#g:method:getMarginBottom"), [getMarginEnd]("GI.Gtk.Objects.Widget#g:method:getMarginEnd"), [getMarginStart]("GI.Gtk.Objects.Widget#g:method:getMarginStart"), [getMarginTop]("GI.Gtk.Objects.Widget#g:method:getMarginTop"), [getName]("GI.Gtk.Objects.Widget#g:method:getName"), [getNative]("GI.Gtk.Objects.Widget#g:method:getNative"), [getNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:getNextAccessibleSibling"), [getNextSibling]("GI.Gtk.Objects.Widget#g:method:getNextSibling"), [getOpacity]("GI.Gtk.Objects.Widget#g:method:getOpacity"), [getOverflow]("GI.Gtk.Objects.Widget#g:method:getOverflow"), [getPangoContext]("GI.Gtk.Objects.Widget#g:method:getPangoContext"), [getParent]("GI.Gtk.Objects.Widget#g:method:getParent"), [getPlatformState]("GI.Gtk.Interfaces.Accessible#g:method:getPlatformState"), [getPreferredSize]("GI.Gtk.Objects.Widget#g:method:getPreferredSize"), [getPrevSibling]("GI.Gtk.Objects.Widget#g:method:getPrevSibling"), [getPrimaryClipboard]("GI.Gtk.Objects.Widget#g:method:getPrimaryClipboard"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRealized]("GI.Gtk.Objects.Widget#g:method:getRealized"), [getReceivesDefault]("GI.Gtk.Objects.Widget#g:method:getReceivesDefault"), [getRequestMode]("GI.Gtk.Objects.Widget#g:method:getRequestMode"), [getRoot]("GI.Gtk.Objects.Widget#g:method:getRoot"), [getScaleFactor]("GI.Gtk.Objects.Widget#g:method:getScaleFactor"), [getSensitive]("GI.Gtk.Objects.Widget#g:method:getSensitive"), [getSettings]("GI.Gtk.Objects.Widget#g:method:getSettings"), [getShowTitleButtons]("GI.Gtk.Objects.HeaderBar#g:method:getShowTitleButtons"), [getSize]("GI.Gtk.Objects.Widget#g:method:getSize"), [getSizeRequest]("GI.Gtk.Objects.Widget#g:method:getSizeRequest"), [getStateFlags]("GI.Gtk.Objects.Widget#g:method:getStateFlags"), [getStyleContext]("GI.Gtk.Objects.Widget#g:method:getStyleContext"), [getTemplateChild]("GI.Gtk.Objects.Widget#g:method:getTemplateChild"), [getTitleWidget]("GI.Gtk.Objects.HeaderBar#g:method:getTitleWidget"), [getTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:getTooltipMarkup"), [getTooltipText]("GI.Gtk.Objects.Widget#g:method:getTooltipText"), [getUseNativeControls]("GI.Gtk.Objects.HeaderBar#g:method:getUseNativeControls"), [getValign]("GI.Gtk.Objects.Widget#g:method:getValign"), [getVexpand]("GI.Gtk.Objects.Widget#g:method:getVexpand"), [getVexpandSet]("GI.Gtk.Objects.Widget#g:method:getVexpandSet"), [getVisible]("GI.Gtk.Objects.Widget#g:method:getVisible"), [getWidth]("GI.Gtk.Objects.Widget#g:method:getWidth").
-- 
-- ==== Setters
-- [setAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:setAccessibleParent"), [setCanFocus]("GI.Gtk.Objects.Widget#g:method:setCanFocus"), [setCanTarget]("GI.Gtk.Objects.Widget#g:method:setCanTarget"), [setChildVisible]("GI.Gtk.Objects.Widget#g:method:setChildVisible"), [setCssClasses]("GI.Gtk.Objects.Widget#g:method:setCssClasses"), [setCursor]("GI.Gtk.Objects.Widget#g:method:setCursor"), [setCursorFromName]("GI.Gtk.Objects.Widget#g:method:setCursorFromName"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDecorationLayout]("GI.Gtk.Objects.HeaderBar#g:method:setDecorationLayout"), [setDirection]("GI.Gtk.Objects.Widget#g:method:setDirection"), [setFocusChild]("GI.Gtk.Objects.Widget#g:method:setFocusChild"), [setFocusOnClick]("GI.Gtk.Objects.Widget#g:method:setFocusOnClick"), [setFocusable]("GI.Gtk.Objects.Widget#g:method:setFocusable"), [setFontMap]("GI.Gtk.Objects.Widget#g:method:setFontMap"), [setFontOptions]("GI.Gtk.Objects.Widget#g:method:setFontOptions"), [setHalign]("GI.Gtk.Objects.Widget#g:method:setHalign"), [setHasTooltip]("GI.Gtk.Objects.Widget#g:method:setHasTooltip"), [setHexpand]("GI.Gtk.Objects.Widget#g:method:setHexpand"), [setHexpandSet]("GI.Gtk.Objects.Widget#g:method:setHexpandSet"), [setLayoutManager]("GI.Gtk.Objects.Widget#g:method:setLayoutManager"), [setLimitEvents]("GI.Gtk.Objects.Widget#g:method:setLimitEvents"), [setMarginBottom]("GI.Gtk.Objects.Widget#g:method:setMarginBottom"), [setMarginEnd]("GI.Gtk.Objects.Widget#g:method:setMarginEnd"), [setMarginStart]("GI.Gtk.Objects.Widget#g:method:setMarginStart"), [setMarginTop]("GI.Gtk.Objects.Widget#g:method:setMarginTop"), [setName]("GI.Gtk.Objects.Widget#g:method:setName"), [setOpacity]("GI.Gtk.Objects.Widget#g:method:setOpacity"), [setOverflow]("GI.Gtk.Objects.Widget#g:method:setOverflow"), [setParent]("GI.Gtk.Objects.Widget#g:method:setParent"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setReceivesDefault]("GI.Gtk.Objects.Widget#g:method:setReceivesDefault"), [setSensitive]("GI.Gtk.Objects.Widget#g:method:setSensitive"), [setShowTitleButtons]("GI.Gtk.Objects.HeaderBar#g:method:setShowTitleButtons"), [setSizeRequest]("GI.Gtk.Objects.Widget#g:method:setSizeRequest"), [setStateFlags]("GI.Gtk.Objects.Widget#g:method:setStateFlags"), [setTitleWidget]("GI.Gtk.Objects.HeaderBar#g:method:setTitleWidget"), [setTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:setTooltipMarkup"), [setTooltipText]("GI.Gtk.Objects.Widget#g:method:setTooltipText"), [setUseNativeControls]("GI.Gtk.Objects.HeaderBar#g:method:setUseNativeControls"), [setValign]("GI.Gtk.Objects.Widget#g:method:setValign"), [setVexpand]("GI.Gtk.Objects.Widget#g:method:setVexpand"), [setVexpandSet]("GI.Gtk.Objects.Widget#g:method:setVexpandSet"), [setVisible]("GI.Gtk.Objects.Widget#g:method:setVisible").

#if defined(ENABLE_OVERLOADING)
    ResolveHeaderBarMethod                  ,
#endif

-- ** getDecorationLayout #method:getDecorationLayout#

#if defined(ENABLE_OVERLOADING)
    HeaderBarGetDecorationLayoutMethodInfo  ,
#endif
    headerBarGetDecorationLayout            ,


-- ** getShowTitleButtons #method:getShowTitleButtons#

#if defined(ENABLE_OVERLOADING)
    HeaderBarGetShowTitleButtonsMethodInfo  ,
#endif
    headerBarGetShowTitleButtons            ,


-- ** getTitleWidget #method:getTitleWidget#

#if defined(ENABLE_OVERLOADING)
    HeaderBarGetTitleWidgetMethodInfo       ,
#endif
    headerBarGetTitleWidget                 ,


-- ** getUseNativeControls #method:getUseNativeControls#

#if defined(ENABLE_OVERLOADING)
    HeaderBarGetUseNativeControlsMethodInfo ,
#endif
    headerBarGetUseNativeControls           ,


-- ** new #method:new#

    headerBarNew                            ,


-- ** packEnd #method:packEnd#

#if defined(ENABLE_OVERLOADING)
    HeaderBarPackEndMethodInfo              ,
#endif
    headerBarPackEnd                        ,


-- ** packStart #method:packStart#

#if defined(ENABLE_OVERLOADING)
    HeaderBarPackStartMethodInfo            ,
#endif
    headerBarPackStart                      ,


-- ** remove #method:remove#

#if defined(ENABLE_OVERLOADING)
    HeaderBarRemoveMethodInfo               ,
#endif
    headerBarRemove                         ,


-- ** setDecorationLayout #method:setDecorationLayout#

#if defined(ENABLE_OVERLOADING)
    HeaderBarSetDecorationLayoutMethodInfo  ,
#endif
    headerBarSetDecorationLayout            ,


-- ** setShowTitleButtons #method:setShowTitleButtons#

#if defined(ENABLE_OVERLOADING)
    HeaderBarSetShowTitleButtonsMethodInfo  ,
#endif
    headerBarSetShowTitleButtons            ,


-- ** setTitleWidget #method:setTitleWidget#

#if defined(ENABLE_OVERLOADING)
    HeaderBarSetTitleWidgetMethodInfo       ,
#endif
    headerBarSetTitleWidget                 ,


-- ** setUseNativeControls #method:setUseNativeControls#

#if defined(ENABLE_OVERLOADING)
    HeaderBarSetUseNativeControlsMethodInfo ,
#endif
    headerBarSetUseNativeControls           ,




 -- * Properties


-- ** decorationLayout #attr:decorationLayout#
-- | The decoration layout for buttons.
-- 
-- If this property is not set, the
-- [Settings:gtkDecorationLayout]("GI.Gtk.Objects.Settings#g:attr:gtkDecorationLayout") setting is used.

#if defined(ENABLE_OVERLOADING)
    HeaderBarDecorationLayoutPropertyInfo   ,
#endif
    clearHeaderBarDecorationLayout          ,
    constructHeaderBarDecorationLayout      ,
    getHeaderBarDecorationLayout            ,
#if defined(ENABLE_OVERLOADING)
    headerBarDecorationLayout               ,
#endif
    setHeaderBarDecorationLayout            ,


-- ** showTitleButtons #attr:showTitleButtons#
-- | Whether to show title buttons like close, minimize, maximize.
-- 
-- Which buttons are actually shown and where is determined
-- by the [HeaderBar:decorationLayout]("GI.Gtk.Objects.HeaderBar#g:attr:decorationLayout") property,
-- and by the state of the window (e.g. a close button will not
-- be shown if the window can\'t be closed).

#if defined(ENABLE_OVERLOADING)
    HeaderBarShowTitleButtonsPropertyInfo   ,
#endif
    constructHeaderBarShowTitleButtons      ,
    getHeaderBarShowTitleButtons            ,
#if defined(ENABLE_OVERLOADING)
    headerBarShowTitleButtons               ,
#endif
    setHeaderBarShowTitleButtons            ,


-- ** titleWidget #attr:titleWidget#
-- | The title widget to display.

#if defined(ENABLE_OVERLOADING)
    HeaderBarTitleWidgetPropertyInfo        ,
#endif
    clearHeaderBarTitleWidget               ,
    constructHeaderBarTitleWidget           ,
    getHeaderBarTitleWidget                 ,
#if defined(ENABLE_OVERLOADING)
    headerBarTitleWidget                    ,
#endif
    setHeaderBarTitleWidget                 ,


-- ** useNativeControls #attr:useNativeControls#
-- | Whether to show platform native close\/minimize\/maximize buttons.
-- 
-- For macOS, the [HeaderBar:decorationLayout]("GI.Gtk.Objects.HeaderBar#g:attr:decorationLayout") property
-- can be used to enable\/disable controls.
-- 
-- On Linux, this option has no effect.
-- 
-- See also <https://docs.gtk.org/gtk4/osx.html?native-window-controls Using GTK on Apple macOS>.
-- 
-- /Since: 4.18/

#if defined(ENABLE_OVERLOADING)
    HeaderBarUseNativeControlsPropertyInfo  ,
#endif
    constructHeaderBarUseNativeControls     ,
    getHeaderBarUseNativeControls           ,
#if defined(ENABLE_OVERLOADING)
    headerBarUseNativeControls              ,
#endif
    setHeaderBarUseNativeControls           ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.ComponentTransfer as Gsk.ComponentTransfer
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget

#endif

-- | Memory-managed wrapper type.
newtype HeaderBar = HeaderBar (SP.ManagedPtr HeaderBar)
    deriving (Eq)

instance SP.ManagedPtrNewtype HeaderBar where
    toManagedPtr (HeaderBar p) = p

foreign import ccall "gtk_header_bar_get_type"
    c_gtk_header_bar_get_type :: IO B.Types.GType

instance B.Types.TypedObject HeaderBar where
    glibType = c_gtk_header_bar_get_type

instance B.Types.GObject HeaderBar

-- | Type class for types which can be safely cast to t'HeaderBar', for instance with `toHeaderBar`.
class (SP.GObject o, O.IsDescendantOf HeaderBar o) => IsHeaderBar o
instance (SP.GObject o, O.IsDescendantOf HeaderBar o) => IsHeaderBar o

instance O.HasParentTypes HeaderBar
type instance O.ParentTypes HeaderBar = '[Gtk.Widget.Widget, GObject.Object.Object, Gtk.Accessible.Accessible, Gtk.Buildable.Buildable, Gtk.ConstraintTarget.ConstraintTarget]

-- | Cast to t'HeaderBar', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toHeaderBar :: (MIO.MonadIO m, IsHeaderBar o) => o -> m HeaderBar
toHeaderBar = MIO.liftIO . B.ManagedPtr.unsafeCastTo HeaderBar

-- | Convert t'HeaderBar' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe HeaderBar) where
    gvalueGType_ = c_gtk_header_bar_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr HeaderBar)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr HeaderBar)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject HeaderBar ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveHeaderBarMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveHeaderBarMethod "actionSetEnabled" o = Gtk.Widget.WidgetActionSetEnabledMethodInfo
    ResolveHeaderBarMethod "activate" o = Gtk.Widget.WidgetActivateMethodInfo
    ResolveHeaderBarMethod "activateAction" o = Gtk.Widget.WidgetActivateActionMethodInfo
    ResolveHeaderBarMethod "activateDefault" o = Gtk.Widget.WidgetActivateDefaultMethodInfo
    ResolveHeaderBarMethod "addController" o = Gtk.Widget.WidgetAddControllerMethodInfo
    ResolveHeaderBarMethod "addCssClass" o = Gtk.Widget.WidgetAddCssClassMethodInfo
    ResolveHeaderBarMethod "addMnemonicLabel" o = Gtk.Widget.WidgetAddMnemonicLabelMethodInfo
    ResolveHeaderBarMethod "addTickCallback" o = Gtk.Widget.WidgetAddTickCallbackMethodInfo
    ResolveHeaderBarMethod "allocate" o = Gtk.Widget.WidgetAllocateMethodInfo
    ResolveHeaderBarMethod "announce" o = Gtk.Accessible.AccessibleAnnounceMethodInfo
    ResolveHeaderBarMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveHeaderBarMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveHeaderBarMethod "childFocus" o = Gtk.Widget.WidgetChildFocusMethodInfo
    ResolveHeaderBarMethod "computeBounds" o = Gtk.Widget.WidgetComputeBoundsMethodInfo
    ResolveHeaderBarMethod "computeExpand" o = Gtk.Widget.WidgetComputeExpandMethodInfo
    ResolveHeaderBarMethod "computePoint" o = Gtk.Widget.WidgetComputePointMethodInfo
    ResolveHeaderBarMethod "computeTransform" o = Gtk.Widget.WidgetComputeTransformMethodInfo
    ResolveHeaderBarMethod "contains" o = Gtk.Widget.WidgetContainsMethodInfo
    ResolveHeaderBarMethod "createPangoContext" o = Gtk.Widget.WidgetCreatePangoContextMethodInfo
    ResolveHeaderBarMethod "createPangoLayout" o = Gtk.Widget.WidgetCreatePangoLayoutMethodInfo
    ResolveHeaderBarMethod "disposeTemplate" o = Gtk.Widget.WidgetDisposeTemplateMethodInfo
    ResolveHeaderBarMethod "dragCheckThreshold" o = Gtk.Widget.WidgetDragCheckThresholdMethodInfo
    ResolveHeaderBarMethod "errorBell" o = Gtk.Widget.WidgetErrorBellMethodInfo
    ResolveHeaderBarMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveHeaderBarMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveHeaderBarMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveHeaderBarMethod "grabFocus" o = Gtk.Widget.WidgetGrabFocusMethodInfo
    ResolveHeaderBarMethod "hasCssClass" o = Gtk.Widget.WidgetHasCssClassMethodInfo
    ResolveHeaderBarMethod "hasDefault" o = Gtk.Widget.WidgetHasDefaultMethodInfo
    ResolveHeaderBarMethod "hasFocus" o = Gtk.Widget.WidgetHasFocusMethodInfo
    ResolveHeaderBarMethod "hasVisibleFocus" o = Gtk.Widget.WidgetHasVisibleFocusMethodInfo
    ResolveHeaderBarMethod "hide" o = Gtk.Widget.WidgetHideMethodInfo
    ResolveHeaderBarMethod "inDestruction" o = Gtk.Widget.WidgetInDestructionMethodInfo
    ResolveHeaderBarMethod "initTemplate" o = Gtk.Widget.WidgetInitTemplateMethodInfo
    ResolveHeaderBarMethod "insertActionGroup" o = Gtk.Widget.WidgetInsertActionGroupMethodInfo
    ResolveHeaderBarMethod "insertAfter" o = Gtk.Widget.WidgetInsertAfterMethodInfo
    ResolveHeaderBarMethod "insertBefore" o = Gtk.Widget.WidgetInsertBeforeMethodInfo
    ResolveHeaderBarMethod "isAncestor" o = Gtk.Widget.WidgetIsAncestorMethodInfo
    ResolveHeaderBarMethod "isDrawable" o = Gtk.Widget.WidgetIsDrawableMethodInfo
    ResolveHeaderBarMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveHeaderBarMethod "isFocus" o = Gtk.Widget.WidgetIsFocusMethodInfo
    ResolveHeaderBarMethod "isSensitive" o = Gtk.Widget.WidgetIsSensitiveMethodInfo
    ResolveHeaderBarMethod "isVisible" o = Gtk.Widget.WidgetIsVisibleMethodInfo
    ResolveHeaderBarMethod "keynavFailed" o = Gtk.Widget.WidgetKeynavFailedMethodInfo
    ResolveHeaderBarMethod "listMnemonicLabels" o = Gtk.Widget.WidgetListMnemonicLabelsMethodInfo
    ResolveHeaderBarMethod "map" o = Gtk.Widget.WidgetMapMethodInfo
    ResolveHeaderBarMethod "measure" o = Gtk.Widget.WidgetMeasureMethodInfo
    ResolveHeaderBarMethod "mnemonicActivate" o = Gtk.Widget.WidgetMnemonicActivateMethodInfo
    ResolveHeaderBarMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveHeaderBarMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveHeaderBarMethod "observeChildren" o = Gtk.Widget.WidgetObserveChildrenMethodInfo
    ResolveHeaderBarMethod "observeControllers" o = Gtk.Widget.WidgetObserveControllersMethodInfo
    ResolveHeaderBarMethod "packEnd" o = HeaderBarPackEndMethodInfo
    ResolveHeaderBarMethod "packStart" o = HeaderBarPackStartMethodInfo
    ResolveHeaderBarMethod "pick" o = Gtk.Widget.WidgetPickMethodInfo
    ResolveHeaderBarMethod "queueAllocate" o = Gtk.Widget.WidgetQueueAllocateMethodInfo
    ResolveHeaderBarMethod "queueDraw" o = Gtk.Widget.WidgetQueueDrawMethodInfo
    ResolveHeaderBarMethod "queueResize" o = Gtk.Widget.WidgetQueueResizeMethodInfo
    ResolveHeaderBarMethod "realize" o = Gtk.Widget.WidgetRealizeMethodInfo
    ResolveHeaderBarMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveHeaderBarMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveHeaderBarMethod "remove" o = HeaderBarRemoveMethodInfo
    ResolveHeaderBarMethod "removeController" o = Gtk.Widget.WidgetRemoveControllerMethodInfo
    ResolveHeaderBarMethod "removeCssClass" o = Gtk.Widget.WidgetRemoveCssClassMethodInfo
    ResolveHeaderBarMethod "removeMnemonicLabel" o = Gtk.Widget.WidgetRemoveMnemonicLabelMethodInfo
    ResolveHeaderBarMethod "removeTickCallback" o = Gtk.Widget.WidgetRemoveTickCallbackMethodInfo
    ResolveHeaderBarMethod "resetProperty" o = Gtk.Accessible.AccessibleResetPropertyMethodInfo
    ResolveHeaderBarMethod "resetRelation" o = Gtk.Accessible.AccessibleResetRelationMethodInfo
    ResolveHeaderBarMethod "resetState" o = Gtk.Accessible.AccessibleResetStateMethodInfo
    ResolveHeaderBarMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveHeaderBarMethod "shouldLayout" o = Gtk.Widget.WidgetShouldLayoutMethodInfo
    ResolveHeaderBarMethod "show" o = Gtk.Widget.WidgetShowMethodInfo
    ResolveHeaderBarMethod "sizeAllocate" o = Gtk.Widget.WidgetSizeAllocateMethodInfo
    ResolveHeaderBarMethod "snapshotChild" o = Gtk.Widget.WidgetSnapshotChildMethodInfo
    ResolveHeaderBarMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveHeaderBarMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveHeaderBarMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveHeaderBarMethod "translateCoordinates" o = Gtk.Widget.WidgetTranslateCoordinatesMethodInfo
    ResolveHeaderBarMethod "triggerTooltipQuery" o = Gtk.Widget.WidgetTriggerTooltipQueryMethodInfo
    ResolveHeaderBarMethod "unmap" o = Gtk.Widget.WidgetUnmapMethodInfo
    ResolveHeaderBarMethod "unparent" o = Gtk.Widget.WidgetUnparentMethodInfo
    ResolveHeaderBarMethod "unrealize" o = Gtk.Widget.WidgetUnrealizeMethodInfo
    ResolveHeaderBarMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveHeaderBarMethod "unsetStateFlags" o = Gtk.Widget.WidgetUnsetStateFlagsMethodInfo
    ResolveHeaderBarMethod "updateNextAccessibleSibling" o = Gtk.Accessible.AccessibleUpdateNextAccessibleSiblingMethodInfo
    ResolveHeaderBarMethod "updatePlatformState" o = Gtk.Accessible.AccessibleUpdatePlatformStateMethodInfo
    ResolveHeaderBarMethod "updateProperty" o = Gtk.Accessible.AccessibleUpdatePropertyMethodInfo
    ResolveHeaderBarMethod "updateRelation" o = Gtk.Accessible.AccessibleUpdateRelationMethodInfo
    ResolveHeaderBarMethod "updateState" o = Gtk.Accessible.AccessibleUpdateStateMethodInfo
    ResolveHeaderBarMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveHeaderBarMethod "getAccessibleParent" o = Gtk.Accessible.AccessibleGetAccessibleParentMethodInfo
    ResolveHeaderBarMethod "getAccessibleRole" o = Gtk.Accessible.AccessibleGetAccessibleRoleMethodInfo
    ResolveHeaderBarMethod "getAllocatedBaseline" o = Gtk.Widget.WidgetGetAllocatedBaselineMethodInfo
    ResolveHeaderBarMethod "getAllocatedHeight" o = Gtk.Widget.WidgetGetAllocatedHeightMethodInfo
    ResolveHeaderBarMethod "getAllocatedWidth" o = Gtk.Widget.WidgetGetAllocatedWidthMethodInfo
    ResolveHeaderBarMethod "getAllocation" o = Gtk.Widget.WidgetGetAllocationMethodInfo
    ResolveHeaderBarMethod "getAncestor" o = Gtk.Widget.WidgetGetAncestorMethodInfo
    ResolveHeaderBarMethod "getAtContext" o = Gtk.Accessible.AccessibleGetAtContextMethodInfo
    ResolveHeaderBarMethod "getBaseline" o = Gtk.Widget.WidgetGetBaselineMethodInfo
    ResolveHeaderBarMethod "getBounds" o = Gtk.Accessible.AccessibleGetBoundsMethodInfo
    ResolveHeaderBarMethod "getBuildableId" o = Gtk.Buildable.BuildableGetBuildableIdMethodInfo
    ResolveHeaderBarMethod "getCanFocus" o = Gtk.Widget.WidgetGetCanFocusMethodInfo
    ResolveHeaderBarMethod "getCanTarget" o = Gtk.Widget.WidgetGetCanTargetMethodInfo
    ResolveHeaderBarMethod "getChildVisible" o = Gtk.Widget.WidgetGetChildVisibleMethodInfo
    ResolveHeaderBarMethod "getClipboard" o = Gtk.Widget.WidgetGetClipboardMethodInfo
    ResolveHeaderBarMethod "getColor" o = Gtk.Widget.WidgetGetColorMethodInfo
    ResolveHeaderBarMethod "getCssClasses" o = Gtk.Widget.WidgetGetCssClassesMethodInfo
    ResolveHeaderBarMethod "getCssName" o = Gtk.Widget.WidgetGetCssNameMethodInfo
    ResolveHeaderBarMethod "getCursor" o = Gtk.Widget.WidgetGetCursorMethodInfo
    ResolveHeaderBarMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveHeaderBarMethod "getDecorationLayout" o = HeaderBarGetDecorationLayoutMethodInfo
    ResolveHeaderBarMethod "getDirection" o = Gtk.Widget.WidgetGetDirectionMethodInfo
    ResolveHeaderBarMethod "getDisplay" o = Gtk.Widget.WidgetGetDisplayMethodInfo
    ResolveHeaderBarMethod "getFirstAccessibleChild" o = Gtk.Accessible.AccessibleGetFirstAccessibleChildMethodInfo
    ResolveHeaderBarMethod "getFirstChild" o = Gtk.Widget.WidgetGetFirstChildMethodInfo
    ResolveHeaderBarMethod "getFocusChild" o = Gtk.Widget.WidgetGetFocusChildMethodInfo
    ResolveHeaderBarMethod "getFocusOnClick" o = Gtk.Widget.WidgetGetFocusOnClickMethodInfo
    ResolveHeaderBarMethod "getFocusable" o = Gtk.Widget.WidgetGetFocusableMethodInfo
    ResolveHeaderBarMethod "getFontMap" o = Gtk.Widget.WidgetGetFontMapMethodInfo
    ResolveHeaderBarMethod "getFontOptions" o = Gtk.Widget.WidgetGetFontOptionsMethodInfo
    ResolveHeaderBarMethod "getFrameClock" o = Gtk.Widget.WidgetGetFrameClockMethodInfo
    ResolveHeaderBarMethod "getHalign" o = Gtk.Widget.WidgetGetHalignMethodInfo
    ResolveHeaderBarMethod "getHasTooltip" o = Gtk.Widget.WidgetGetHasTooltipMethodInfo
    ResolveHeaderBarMethod "getHeight" o = Gtk.Widget.WidgetGetHeightMethodInfo
    ResolveHeaderBarMethod "getHexpand" o = Gtk.Widget.WidgetGetHexpandMethodInfo
    ResolveHeaderBarMethod "getHexpandSet" o = Gtk.Widget.WidgetGetHexpandSetMethodInfo
    ResolveHeaderBarMethod "getLastChild" o = Gtk.Widget.WidgetGetLastChildMethodInfo
    ResolveHeaderBarMethod "getLayoutManager" o = Gtk.Widget.WidgetGetLayoutManagerMethodInfo
    ResolveHeaderBarMethod "getLimitEvents" o = Gtk.Widget.WidgetGetLimitEventsMethodInfo
    ResolveHeaderBarMethod "getMapped" o = Gtk.Widget.WidgetGetMappedMethodInfo
    ResolveHeaderBarMethod "getMarginBottom" o = Gtk.Widget.WidgetGetMarginBottomMethodInfo
    ResolveHeaderBarMethod "getMarginEnd" o = Gtk.Widget.WidgetGetMarginEndMethodInfo
    ResolveHeaderBarMethod "getMarginStart" o = Gtk.Widget.WidgetGetMarginStartMethodInfo
    ResolveHeaderBarMethod "getMarginTop" o = Gtk.Widget.WidgetGetMarginTopMethodInfo
    ResolveHeaderBarMethod "getName" o = Gtk.Widget.WidgetGetNameMethodInfo
    ResolveHeaderBarMethod "getNative" o = Gtk.Widget.WidgetGetNativeMethodInfo
    ResolveHeaderBarMethod "getNextAccessibleSibling" o = Gtk.Accessible.AccessibleGetNextAccessibleSiblingMethodInfo
    ResolveHeaderBarMethod "getNextSibling" o = Gtk.Widget.WidgetGetNextSiblingMethodInfo
    ResolveHeaderBarMethod "getOpacity" o = Gtk.Widget.WidgetGetOpacityMethodInfo
    ResolveHeaderBarMethod "getOverflow" o = Gtk.Widget.WidgetGetOverflowMethodInfo
    ResolveHeaderBarMethod "getPangoContext" o = Gtk.Widget.WidgetGetPangoContextMethodInfo
    ResolveHeaderBarMethod "getParent" o = Gtk.Widget.WidgetGetParentMethodInfo
    ResolveHeaderBarMethod "getPlatformState" o = Gtk.Accessible.AccessibleGetPlatformStateMethodInfo
    ResolveHeaderBarMethod "getPreferredSize" o = Gtk.Widget.WidgetGetPreferredSizeMethodInfo
    ResolveHeaderBarMethod "getPrevSibling" o = Gtk.Widget.WidgetGetPrevSiblingMethodInfo
    ResolveHeaderBarMethod "getPrimaryClipboard" o = Gtk.Widget.WidgetGetPrimaryClipboardMethodInfo
    ResolveHeaderBarMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveHeaderBarMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveHeaderBarMethod "getRealized" o = Gtk.Widget.WidgetGetRealizedMethodInfo
    ResolveHeaderBarMethod "getReceivesDefault" o = Gtk.Widget.WidgetGetReceivesDefaultMethodInfo
    ResolveHeaderBarMethod "getRequestMode" o = Gtk.Widget.WidgetGetRequestModeMethodInfo
    ResolveHeaderBarMethod "getRoot" o = Gtk.Widget.WidgetGetRootMethodInfo
    ResolveHeaderBarMethod "getScaleFactor" o = Gtk.Widget.WidgetGetScaleFactorMethodInfo
    ResolveHeaderBarMethod "getSensitive" o = Gtk.Widget.WidgetGetSensitiveMethodInfo
    ResolveHeaderBarMethod "getSettings" o = Gtk.Widget.WidgetGetSettingsMethodInfo
    ResolveHeaderBarMethod "getShowTitleButtons" o = HeaderBarGetShowTitleButtonsMethodInfo
    ResolveHeaderBarMethod "getSize" o = Gtk.Widget.WidgetGetSizeMethodInfo
    ResolveHeaderBarMethod "getSizeRequest" o = Gtk.Widget.WidgetGetSizeRequestMethodInfo
    ResolveHeaderBarMethod "getStateFlags" o = Gtk.Widget.WidgetGetStateFlagsMethodInfo
    ResolveHeaderBarMethod "getStyleContext" o = Gtk.Widget.WidgetGetStyleContextMethodInfo
    ResolveHeaderBarMethod "getTemplateChild" o = Gtk.Widget.WidgetGetTemplateChildMethodInfo
    ResolveHeaderBarMethod "getTitleWidget" o = HeaderBarGetTitleWidgetMethodInfo
    ResolveHeaderBarMethod "getTooltipMarkup" o = Gtk.Widget.WidgetGetTooltipMarkupMethodInfo
    ResolveHeaderBarMethod "getTooltipText" o = Gtk.Widget.WidgetGetTooltipTextMethodInfo
    ResolveHeaderBarMethod "getUseNativeControls" o = HeaderBarGetUseNativeControlsMethodInfo
    ResolveHeaderBarMethod "getValign" o = Gtk.Widget.WidgetGetValignMethodInfo
    ResolveHeaderBarMethod "getVexpand" o = Gtk.Widget.WidgetGetVexpandMethodInfo
    ResolveHeaderBarMethod "getVexpandSet" o = Gtk.Widget.WidgetGetVexpandSetMethodInfo
    ResolveHeaderBarMethod "getVisible" o = Gtk.Widget.WidgetGetVisibleMethodInfo
    ResolveHeaderBarMethod "getWidth" o = Gtk.Widget.WidgetGetWidthMethodInfo
    ResolveHeaderBarMethod "setAccessibleParent" o = Gtk.Accessible.AccessibleSetAccessibleParentMethodInfo
    ResolveHeaderBarMethod "setCanFocus" o = Gtk.Widget.WidgetSetCanFocusMethodInfo
    ResolveHeaderBarMethod "setCanTarget" o = Gtk.Widget.WidgetSetCanTargetMethodInfo
    ResolveHeaderBarMethod "setChildVisible" o = Gtk.Widget.WidgetSetChildVisibleMethodInfo
    ResolveHeaderBarMethod "setCssClasses" o = Gtk.Widget.WidgetSetCssClassesMethodInfo
    ResolveHeaderBarMethod "setCursor" o = Gtk.Widget.WidgetSetCursorMethodInfo
    ResolveHeaderBarMethod "setCursorFromName" o = Gtk.Widget.WidgetSetCursorFromNameMethodInfo
    ResolveHeaderBarMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveHeaderBarMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveHeaderBarMethod "setDecorationLayout" o = HeaderBarSetDecorationLayoutMethodInfo
    ResolveHeaderBarMethod "setDirection" o = Gtk.Widget.WidgetSetDirectionMethodInfo
    ResolveHeaderBarMethod "setFocusChild" o = Gtk.Widget.WidgetSetFocusChildMethodInfo
    ResolveHeaderBarMethod "setFocusOnClick" o = Gtk.Widget.WidgetSetFocusOnClickMethodInfo
    ResolveHeaderBarMethod "setFocusable" o = Gtk.Widget.WidgetSetFocusableMethodInfo
    ResolveHeaderBarMethod "setFontMap" o = Gtk.Widget.WidgetSetFontMapMethodInfo
    ResolveHeaderBarMethod "setFontOptions" o = Gtk.Widget.WidgetSetFontOptionsMethodInfo
    ResolveHeaderBarMethod "setHalign" o = Gtk.Widget.WidgetSetHalignMethodInfo
    ResolveHeaderBarMethod "setHasTooltip" o = Gtk.Widget.WidgetSetHasTooltipMethodInfo
    ResolveHeaderBarMethod "setHexpand" o = Gtk.Widget.WidgetSetHexpandMethodInfo
    ResolveHeaderBarMethod "setHexpandSet" o = Gtk.Widget.WidgetSetHexpandSetMethodInfo
    ResolveHeaderBarMethod "setLayoutManager" o = Gtk.Widget.WidgetSetLayoutManagerMethodInfo
    ResolveHeaderBarMethod "setLimitEvents" o = Gtk.Widget.WidgetSetLimitEventsMethodInfo
    ResolveHeaderBarMethod "setMarginBottom" o = Gtk.Widget.WidgetSetMarginBottomMethodInfo
    ResolveHeaderBarMethod "setMarginEnd" o = Gtk.Widget.WidgetSetMarginEndMethodInfo
    ResolveHeaderBarMethod "setMarginStart" o = Gtk.Widget.WidgetSetMarginStartMethodInfo
    ResolveHeaderBarMethod "setMarginTop" o = Gtk.Widget.WidgetSetMarginTopMethodInfo
    ResolveHeaderBarMethod "setName" o = Gtk.Widget.WidgetSetNameMethodInfo
    ResolveHeaderBarMethod "setOpacity" o = Gtk.Widget.WidgetSetOpacityMethodInfo
    ResolveHeaderBarMethod "setOverflow" o = Gtk.Widget.WidgetSetOverflowMethodInfo
    ResolveHeaderBarMethod "setParent" o = Gtk.Widget.WidgetSetParentMethodInfo
    ResolveHeaderBarMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveHeaderBarMethod "setReceivesDefault" o = Gtk.Widget.WidgetSetReceivesDefaultMethodInfo
    ResolveHeaderBarMethod "setSensitive" o = Gtk.Widget.WidgetSetSensitiveMethodInfo
    ResolveHeaderBarMethod "setShowTitleButtons" o = HeaderBarSetShowTitleButtonsMethodInfo
    ResolveHeaderBarMethod "setSizeRequest" o = Gtk.Widget.WidgetSetSizeRequestMethodInfo
    ResolveHeaderBarMethod "setStateFlags" o = Gtk.Widget.WidgetSetStateFlagsMethodInfo
    ResolveHeaderBarMethod "setTitleWidget" o = HeaderBarSetTitleWidgetMethodInfo
    ResolveHeaderBarMethod "setTooltipMarkup" o = Gtk.Widget.WidgetSetTooltipMarkupMethodInfo
    ResolveHeaderBarMethod "setTooltipText" o = Gtk.Widget.WidgetSetTooltipTextMethodInfo
    ResolveHeaderBarMethod "setUseNativeControls" o = HeaderBarSetUseNativeControlsMethodInfo
    ResolveHeaderBarMethod "setValign" o = Gtk.Widget.WidgetSetValignMethodInfo
    ResolveHeaderBarMethod "setVexpand" o = Gtk.Widget.WidgetSetVexpandMethodInfo
    ResolveHeaderBarMethod "setVexpandSet" o = Gtk.Widget.WidgetSetVexpandSetMethodInfo
    ResolveHeaderBarMethod "setVisible" o = Gtk.Widget.WidgetSetVisibleMethodInfo
    ResolveHeaderBarMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveHeaderBarMethod t HeaderBar, O.OverloadedMethod info HeaderBar p) => OL.IsLabel t (HeaderBar -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveHeaderBarMethod t HeaderBar, O.OverloadedMethod info HeaderBar p, R.HasField t HeaderBar p) => R.HasField t HeaderBar p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveHeaderBarMethod t HeaderBar, O.OverloadedMethodInfo info HeaderBar) => OL.IsLabel t (O.MethodProxy info HeaderBar) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "decoration-layout"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@decoration-layout@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' headerBar #decorationLayout
-- @
getHeaderBarDecorationLayout :: (MonadIO m, IsHeaderBar o) => o -> m (Maybe T.Text)
getHeaderBarDecorationLayout obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "decoration-layout"

-- | Set the value of the “@decoration-layout@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' headerBar [ #decorationLayout 'Data.GI.Base.Attributes.:=' value ]
-- @
setHeaderBarDecorationLayout :: (MonadIO m, IsHeaderBar o) => o -> T.Text -> m ()
setHeaderBarDecorationLayout obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyString obj "decoration-layout" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@decoration-layout@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructHeaderBarDecorationLayout :: (IsHeaderBar o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructHeaderBarDecorationLayout val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "decoration-layout" (P.Just val)

-- | Set the value of the “@decoration-layout@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #decorationLayout
-- @
clearHeaderBarDecorationLayout :: (MonadIO m, IsHeaderBar o) => o -> m ()
clearHeaderBarDecorationLayout obj = liftIO $ B.Properties.setObjectPropertyString obj "decoration-layout" (Nothing :: Maybe T.Text)

#if defined(ENABLE_OVERLOADING)
data HeaderBarDecorationLayoutPropertyInfo
instance AttrInfo HeaderBarDecorationLayoutPropertyInfo where
    type AttrAllowedOps HeaderBarDecorationLayoutPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint HeaderBarDecorationLayoutPropertyInfo = IsHeaderBar
    type AttrSetTypeConstraint HeaderBarDecorationLayoutPropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint HeaderBarDecorationLayoutPropertyInfo = (~) T.Text
    type AttrTransferType HeaderBarDecorationLayoutPropertyInfo = T.Text
    type AttrGetType HeaderBarDecorationLayoutPropertyInfo = (Maybe T.Text)
    type AttrLabel HeaderBarDecorationLayoutPropertyInfo = "decoration-layout"
    type AttrOrigin HeaderBarDecorationLayoutPropertyInfo = HeaderBar
    attrGet = getHeaderBarDecorationLayout
    attrSet = setHeaderBarDecorationLayout
    attrPut = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructHeaderBarDecorationLayout
    attrClear = clearHeaderBarDecorationLayout
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.HeaderBar.decorationLayout"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-HeaderBar.html#g:attr:decorationLayout"
        })
#endif

-- VVV Prop "show-title-buttons"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@show-title-buttons@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' headerBar #showTitleButtons
-- @
getHeaderBarShowTitleButtons :: (MonadIO m, IsHeaderBar o) => o -> m Bool
getHeaderBarShowTitleButtons obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "show-title-buttons"

-- | Set the value of the “@show-title-buttons@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' headerBar [ #showTitleButtons 'Data.GI.Base.Attributes.:=' value ]
-- @
setHeaderBarShowTitleButtons :: (MonadIO m, IsHeaderBar o) => o -> Bool -> m ()
setHeaderBarShowTitleButtons obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "show-title-buttons" val

-- | Construct a t'GValueConstruct' with valid value for the “@show-title-buttons@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructHeaderBarShowTitleButtons :: (IsHeaderBar o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructHeaderBarShowTitleButtons val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "show-title-buttons" val

#if defined(ENABLE_OVERLOADING)
data HeaderBarShowTitleButtonsPropertyInfo
instance AttrInfo HeaderBarShowTitleButtonsPropertyInfo where
    type AttrAllowedOps HeaderBarShowTitleButtonsPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint HeaderBarShowTitleButtonsPropertyInfo = IsHeaderBar
    type AttrSetTypeConstraint HeaderBarShowTitleButtonsPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint HeaderBarShowTitleButtonsPropertyInfo = (~) Bool
    type AttrTransferType HeaderBarShowTitleButtonsPropertyInfo = Bool
    type AttrGetType HeaderBarShowTitleButtonsPropertyInfo = Bool
    type AttrLabel HeaderBarShowTitleButtonsPropertyInfo = "show-title-buttons"
    type AttrOrigin HeaderBarShowTitleButtonsPropertyInfo = HeaderBar
    attrGet = getHeaderBarShowTitleButtons
    attrSet = setHeaderBarShowTitleButtons
    attrPut = setHeaderBarShowTitleButtons
    attrTransfer _ v = do
        return v
    attrConstruct = constructHeaderBarShowTitleButtons
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.HeaderBar.showTitleButtons"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-HeaderBar.html#g:attr:showTitleButtons"
        })
#endif

-- VVV Prop "title-widget"
   -- Type: TInterface (Name {namespace = "Gtk", name = "Widget"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@title-widget@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' headerBar #titleWidget
-- @
getHeaderBarTitleWidget :: (MonadIO m, IsHeaderBar o) => o -> m (Maybe Gtk.Widget.Widget)
getHeaderBarTitleWidget obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "title-widget" Gtk.Widget.Widget

-- | Set the value of the “@title-widget@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' headerBar [ #titleWidget 'Data.GI.Base.Attributes.:=' value ]
-- @
setHeaderBarTitleWidget :: (MonadIO m, IsHeaderBar o, Gtk.Widget.IsWidget a) => o -> a -> m ()
setHeaderBarTitleWidget obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "title-widget" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@title-widget@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructHeaderBarTitleWidget :: (IsHeaderBar o, MIO.MonadIO m, Gtk.Widget.IsWidget a) => a -> m (GValueConstruct o)
constructHeaderBarTitleWidget val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "title-widget" (P.Just val)

-- | Set the value of the “@title-widget@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #titleWidget
-- @
clearHeaderBarTitleWidget :: (MonadIO m, IsHeaderBar o) => o -> m ()
clearHeaderBarTitleWidget obj = liftIO $ B.Properties.setObjectPropertyObject obj "title-widget" (Nothing :: Maybe Gtk.Widget.Widget)

#if defined(ENABLE_OVERLOADING)
data HeaderBarTitleWidgetPropertyInfo
instance AttrInfo HeaderBarTitleWidgetPropertyInfo where
    type AttrAllowedOps HeaderBarTitleWidgetPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint HeaderBarTitleWidgetPropertyInfo = IsHeaderBar
    type AttrSetTypeConstraint HeaderBarTitleWidgetPropertyInfo = Gtk.Widget.IsWidget
    type AttrTransferTypeConstraint HeaderBarTitleWidgetPropertyInfo = Gtk.Widget.IsWidget
    type AttrTransferType HeaderBarTitleWidgetPropertyInfo = Gtk.Widget.Widget
    type AttrGetType HeaderBarTitleWidgetPropertyInfo = (Maybe Gtk.Widget.Widget)
    type AttrLabel HeaderBarTitleWidgetPropertyInfo = "title-widget"
    type AttrOrigin HeaderBarTitleWidgetPropertyInfo = HeaderBar
    attrGet = getHeaderBarTitleWidget
    attrSet = setHeaderBarTitleWidget
    attrPut = undefined
    attrTransfer _ v = do
        unsafeCastTo Gtk.Widget.Widget v
    attrConstruct = constructHeaderBarTitleWidget
    attrClear = clearHeaderBarTitleWidget
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.HeaderBar.titleWidget"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-HeaderBar.html#g:attr:titleWidget"
        })
#endif

-- VVV Prop "use-native-controls"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@use-native-controls@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' headerBar #useNativeControls
-- @
getHeaderBarUseNativeControls :: (MonadIO m, IsHeaderBar o) => o -> m Bool
getHeaderBarUseNativeControls obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "use-native-controls"

-- | Set the value of the “@use-native-controls@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' headerBar [ #useNativeControls 'Data.GI.Base.Attributes.:=' value ]
-- @
setHeaderBarUseNativeControls :: (MonadIO m, IsHeaderBar o) => o -> Bool -> m ()
setHeaderBarUseNativeControls obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "use-native-controls" val

-- | Construct a t'GValueConstruct' with valid value for the “@use-native-controls@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructHeaderBarUseNativeControls :: (IsHeaderBar o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructHeaderBarUseNativeControls val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "use-native-controls" val

#if defined(ENABLE_OVERLOADING)
data HeaderBarUseNativeControlsPropertyInfo
instance AttrInfo HeaderBarUseNativeControlsPropertyInfo where
    type AttrAllowedOps HeaderBarUseNativeControlsPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint HeaderBarUseNativeControlsPropertyInfo = IsHeaderBar
    type AttrSetTypeConstraint HeaderBarUseNativeControlsPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint HeaderBarUseNativeControlsPropertyInfo = (~) Bool
    type AttrTransferType HeaderBarUseNativeControlsPropertyInfo = Bool
    type AttrGetType HeaderBarUseNativeControlsPropertyInfo = Bool
    type AttrLabel HeaderBarUseNativeControlsPropertyInfo = "use-native-controls"
    type AttrOrigin HeaderBarUseNativeControlsPropertyInfo = HeaderBar
    attrGet = getHeaderBarUseNativeControls
    attrSet = setHeaderBarUseNativeControls
    attrPut = setHeaderBarUseNativeControls
    attrTransfer _ v = do
        return v
    attrConstruct = constructHeaderBarUseNativeControls
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.HeaderBar.useNativeControls"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-HeaderBar.html#g:attr:useNativeControls"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList HeaderBar
type instance O.AttributeList HeaderBar = HeaderBarAttributeList
type HeaderBarAttributeList = ('[ '("accessibleRole", Gtk.Accessible.AccessibleAccessibleRolePropertyInfo), '("canFocus", Gtk.Widget.WidgetCanFocusPropertyInfo), '("canTarget", Gtk.Widget.WidgetCanTargetPropertyInfo), '("cssClasses", Gtk.Widget.WidgetCssClassesPropertyInfo), '("cssName", Gtk.Widget.WidgetCssNamePropertyInfo), '("cursor", Gtk.Widget.WidgetCursorPropertyInfo), '("decorationLayout", HeaderBarDecorationLayoutPropertyInfo), '("focusOnClick", Gtk.Widget.WidgetFocusOnClickPropertyInfo), '("focusable", Gtk.Widget.WidgetFocusablePropertyInfo), '("halign", Gtk.Widget.WidgetHalignPropertyInfo), '("hasDefault", Gtk.Widget.WidgetHasDefaultPropertyInfo), '("hasFocus", Gtk.Widget.WidgetHasFocusPropertyInfo), '("hasTooltip", Gtk.Widget.WidgetHasTooltipPropertyInfo), '("heightRequest", Gtk.Widget.WidgetHeightRequestPropertyInfo), '("hexpand", Gtk.Widget.WidgetHexpandPropertyInfo), '("hexpandSet", Gtk.Widget.WidgetHexpandSetPropertyInfo), '("layoutManager", Gtk.Widget.WidgetLayoutManagerPropertyInfo), '("limitEvents", Gtk.Widget.WidgetLimitEventsPropertyInfo), '("marginBottom", Gtk.Widget.WidgetMarginBottomPropertyInfo), '("marginEnd", Gtk.Widget.WidgetMarginEndPropertyInfo), '("marginStart", Gtk.Widget.WidgetMarginStartPropertyInfo), '("marginTop", Gtk.Widget.WidgetMarginTopPropertyInfo), '("name", Gtk.Widget.WidgetNamePropertyInfo), '("opacity", Gtk.Widget.WidgetOpacityPropertyInfo), '("overflow", Gtk.Widget.WidgetOverflowPropertyInfo), '("parent", Gtk.Widget.WidgetParentPropertyInfo), '("receivesDefault", Gtk.Widget.WidgetReceivesDefaultPropertyInfo), '("root", Gtk.Widget.WidgetRootPropertyInfo), '("scaleFactor", Gtk.Widget.WidgetScaleFactorPropertyInfo), '("sensitive", Gtk.Widget.WidgetSensitivePropertyInfo), '("showTitleButtons", HeaderBarShowTitleButtonsPropertyInfo), '("titleWidget", HeaderBarTitleWidgetPropertyInfo), '("tooltipMarkup", Gtk.Widget.WidgetTooltipMarkupPropertyInfo), '("tooltipText", Gtk.Widget.WidgetTooltipTextPropertyInfo), '("useNativeControls", HeaderBarUseNativeControlsPropertyInfo), '("valign", Gtk.Widget.WidgetValignPropertyInfo), '("vexpand", Gtk.Widget.WidgetVexpandPropertyInfo), '("vexpandSet", Gtk.Widget.WidgetVexpandSetPropertyInfo), '("visible", Gtk.Widget.WidgetVisiblePropertyInfo), '("widthRequest", Gtk.Widget.WidgetWidthRequestPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
headerBarDecorationLayout :: AttrLabelProxy "decorationLayout"
headerBarDecorationLayout = AttrLabelProxy

headerBarShowTitleButtons :: AttrLabelProxy "showTitleButtons"
headerBarShowTitleButtons = AttrLabelProxy

headerBarTitleWidget :: AttrLabelProxy "titleWidget"
headerBarTitleWidget = AttrLabelProxy

headerBarUseNativeControls :: AttrLabelProxy "useNativeControls"
headerBarUseNativeControls = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList HeaderBar = HeaderBarSignalList
type HeaderBarSignalList = ('[ '("destroy", Gtk.Widget.WidgetDestroySignalInfo), '("directionChanged", Gtk.Widget.WidgetDirectionChangedSignalInfo), '("hide", Gtk.Widget.WidgetHideSignalInfo), '("keynavFailed", Gtk.Widget.WidgetKeynavFailedSignalInfo), '("map", Gtk.Widget.WidgetMapSignalInfo), '("mnemonicActivate", Gtk.Widget.WidgetMnemonicActivateSignalInfo), '("moveFocus", Gtk.Widget.WidgetMoveFocusSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("queryTooltip", Gtk.Widget.WidgetQueryTooltipSignalInfo), '("realize", Gtk.Widget.WidgetRealizeSignalInfo), '("show", Gtk.Widget.WidgetShowSignalInfo), '("stateFlagsChanged", Gtk.Widget.WidgetStateFlagsChangedSignalInfo), '("unmap", Gtk.Widget.WidgetUnmapSignalInfo), '("unrealize", Gtk.Widget.WidgetUnrealizeSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method HeaderBar::new
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "HeaderBar" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_header_bar_new" gtk_header_bar_new :: 
    IO (Ptr HeaderBar)

-- | Creates a new @GtkHeaderBar@ widget.
headerBarNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m HeaderBar
    -- ^ __Returns:__ a new @GtkHeaderBar@
headerBarNew  = liftIO $ do
    result <- gtk_header_bar_new
    checkUnexpectedReturnNULL "headerBarNew" result
    result' <- (newObject HeaderBar) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method HeaderBar::get_decoration_layout
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "bar"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "HeaderBar" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a header bar" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_header_bar_get_decoration_layout" gtk_header_bar_get_decoration_layout :: 
    Ptr HeaderBar ->                        -- bar : TInterface (Name {namespace = "Gtk", name = "HeaderBar"})
    IO CString

-- | Gets the decoration layout of the header bar.
headerBarGetDecorationLayout ::
    (B.CallStack.HasCallStack, MonadIO m, IsHeaderBar a) =>
    a
    -- ^ /@bar@/: a header bar
    -> m (Maybe T.Text)
    -- ^ __Returns:__ the decoration layout
headerBarGetDecorationLayout bar = liftIO $ do
    bar' <- unsafeManagedPtrCastPtr bar
    result <- gtk_header_bar_get_decoration_layout bar'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    touchManagedPtr bar
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data HeaderBarGetDecorationLayoutMethodInfo
instance (signature ~ (m (Maybe T.Text)), MonadIO m, IsHeaderBar a) => O.OverloadedMethod HeaderBarGetDecorationLayoutMethodInfo a signature where
    overloadedMethod = headerBarGetDecorationLayout

instance O.OverloadedMethodInfo HeaderBarGetDecorationLayoutMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.HeaderBar.headerBarGetDecorationLayout",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-HeaderBar.html#v:headerBarGetDecorationLayout"
        })


#endif

-- method HeaderBar::get_show_title_buttons
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "bar"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "HeaderBar" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a header bar" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_header_bar_get_show_title_buttons" gtk_header_bar_get_show_title_buttons :: 
    Ptr HeaderBar ->                        -- bar : TInterface (Name {namespace = "Gtk", name = "HeaderBar"})
    IO CInt

-- | Returns whether this header bar shows the standard window
-- title buttons.
headerBarGetShowTitleButtons ::
    (B.CallStack.HasCallStack, MonadIO m, IsHeaderBar a) =>
    a
    -- ^ /@bar@/: a header bar
    -> m Bool
    -- ^ __Returns:__ true if title buttons are shown
headerBarGetShowTitleButtons bar = liftIO $ do
    bar' <- unsafeManagedPtrCastPtr bar
    result <- gtk_header_bar_get_show_title_buttons bar'
    let result' = (/= 0) result
    touchManagedPtr bar
    return result'

#if defined(ENABLE_OVERLOADING)
data HeaderBarGetShowTitleButtonsMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsHeaderBar a) => O.OverloadedMethod HeaderBarGetShowTitleButtonsMethodInfo a signature where
    overloadedMethod = headerBarGetShowTitleButtons

instance O.OverloadedMethodInfo HeaderBarGetShowTitleButtonsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.HeaderBar.headerBarGetShowTitleButtons",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-HeaderBar.html#v:headerBarGetShowTitleButtons"
        })


#endif

-- method HeaderBar::get_title_widget
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "bar"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "HeaderBar" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a header bar" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Widget" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_header_bar_get_title_widget" gtk_header_bar_get_title_widget :: 
    Ptr HeaderBar ->                        -- bar : TInterface (Name {namespace = "Gtk", name = "HeaderBar"})
    IO (Ptr Gtk.Widget.Widget)

-- | Retrieves the title widget of the header bar.
-- 
-- See 'GI.Gtk.Objects.HeaderBar.headerBarSetTitleWidget'.
headerBarGetTitleWidget ::
    (B.CallStack.HasCallStack, MonadIO m, IsHeaderBar a) =>
    a
    -- ^ /@bar@/: a header bar
    -> m (Maybe Gtk.Widget.Widget)
    -- ^ __Returns:__ the title widget
headerBarGetTitleWidget bar = liftIO $ do
    bar' <- unsafeManagedPtrCastPtr bar
    result <- gtk_header_bar_get_title_widget bar'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gtk.Widget.Widget) result'
        return result''
    touchManagedPtr bar
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data HeaderBarGetTitleWidgetMethodInfo
instance (signature ~ (m (Maybe Gtk.Widget.Widget)), MonadIO m, IsHeaderBar a) => O.OverloadedMethod HeaderBarGetTitleWidgetMethodInfo a signature where
    overloadedMethod = headerBarGetTitleWidget

instance O.OverloadedMethodInfo HeaderBarGetTitleWidgetMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.HeaderBar.headerBarGetTitleWidget",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-HeaderBar.html#v:headerBarGetTitleWidget"
        })


#endif

-- method HeaderBar::get_use_native_controls
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "bar"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "HeaderBar" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a header bar" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_header_bar_get_use_native_controls" gtk_header_bar_get_use_native_controls :: 
    Ptr HeaderBar ->                        -- bar : TInterface (Name {namespace = "Gtk", name = "HeaderBar"})
    IO CInt

-- | Returns whether this header bar shows platform
-- native window controls.
-- 
-- /Since: 4.18/
headerBarGetUseNativeControls ::
    (B.CallStack.HasCallStack, MonadIO m, IsHeaderBar a) =>
    a
    -- ^ /@bar@/: a header bar
    -> m Bool
    -- ^ __Returns:__ true if native window controls are shown
headerBarGetUseNativeControls bar = liftIO $ do
    bar' <- unsafeManagedPtrCastPtr bar
    result <- gtk_header_bar_get_use_native_controls bar'
    let result' = (/= 0) result
    touchManagedPtr bar
    return result'

#if defined(ENABLE_OVERLOADING)
data HeaderBarGetUseNativeControlsMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsHeaderBar a) => O.OverloadedMethod HeaderBarGetUseNativeControlsMethodInfo a signature where
    overloadedMethod = headerBarGetUseNativeControls

instance O.OverloadedMethodInfo HeaderBarGetUseNativeControlsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.HeaderBar.headerBarGetUseNativeControls",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-HeaderBar.html#v:headerBarGetUseNativeControls"
        })


#endif

-- method HeaderBar::pack_end
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "bar"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "HeaderBar" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A header bar" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the widget to be added to @bar"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_header_bar_pack_end" gtk_header_bar_pack_end :: 
    Ptr HeaderBar ->                        -- bar : TInterface (Name {namespace = "Gtk", name = "HeaderBar"})
    Ptr Gtk.Widget.Widget ->                -- child : TInterface (Name {namespace = "Gtk", name = "Widget"})
    IO ()

-- | Adds a child to the header bar, packed with reference to the end.
headerBarPackEnd ::
    (B.CallStack.HasCallStack, MonadIO m, IsHeaderBar a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@bar@/: A header bar
    -> b
    -- ^ /@child@/: the widget to be added to /@bar@/
    -> m ()
headerBarPackEnd bar child = liftIO $ do
    bar' <- unsafeManagedPtrCastPtr bar
    child' <- unsafeManagedPtrCastPtr child
    gtk_header_bar_pack_end bar' child'
    touchManagedPtr bar
    touchManagedPtr child
    return ()

#if defined(ENABLE_OVERLOADING)
data HeaderBarPackEndMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, IsHeaderBar a, Gtk.Widget.IsWidget b) => O.OverloadedMethod HeaderBarPackEndMethodInfo a signature where
    overloadedMethod = headerBarPackEnd

instance O.OverloadedMethodInfo HeaderBarPackEndMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.HeaderBar.headerBarPackEnd",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-HeaderBar.html#v:headerBarPackEnd"
        })


#endif

-- method HeaderBar::pack_start
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "bar"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "HeaderBar" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A header bar" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the widget to be added to @bar"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_header_bar_pack_start" gtk_header_bar_pack_start :: 
    Ptr HeaderBar ->                        -- bar : TInterface (Name {namespace = "Gtk", name = "HeaderBar"})
    Ptr Gtk.Widget.Widget ->                -- child : TInterface (Name {namespace = "Gtk", name = "Widget"})
    IO ()

-- | Adds a child to the header bar, packed with reference to the start.
headerBarPackStart ::
    (B.CallStack.HasCallStack, MonadIO m, IsHeaderBar a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@bar@/: A header bar
    -> b
    -- ^ /@child@/: the widget to be added to /@bar@/
    -> m ()
headerBarPackStart bar child = liftIO $ do
    bar' <- unsafeManagedPtrCastPtr bar
    child' <- unsafeManagedPtrCastPtr child
    gtk_header_bar_pack_start bar' child'
    touchManagedPtr bar
    touchManagedPtr child
    return ()

#if defined(ENABLE_OVERLOADING)
data HeaderBarPackStartMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, IsHeaderBar a, Gtk.Widget.IsWidget b) => O.OverloadedMethod HeaderBarPackStartMethodInfo a signature where
    overloadedMethod = headerBarPackStart

instance O.OverloadedMethodInfo HeaderBarPackStartMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.HeaderBar.headerBarPackStart",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-HeaderBar.html#v:headerBarPackStart"
        })


#endif

-- method HeaderBar::remove
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "bar"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "HeaderBar" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a header bar" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the child to remove"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_header_bar_remove" gtk_header_bar_remove :: 
    Ptr HeaderBar ->                        -- bar : TInterface (Name {namespace = "Gtk", name = "HeaderBar"})
    Ptr Gtk.Widget.Widget ->                -- child : TInterface (Name {namespace = "Gtk", name = "Widget"})
    IO ()

-- | Removes a child from the header bar.
-- 
-- The child must have been added with
-- 'GI.Gtk.Objects.HeaderBar.headerBarPackStart',
-- 'GI.Gtk.Objects.HeaderBar.headerBarPackEnd' or
-- 'GI.Gtk.Objects.HeaderBar.headerBarSetTitleWidget'.
headerBarRemove ::
    (B.CallStack.HasCallStack, MonadIO m, IsHeaderBar a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@bar@/: a header bar
    -> b
    -- ^ /@child@/: the child to remove
    -> m ()
headerBarRemove bar child = liftIO $ do
    bar' <- unsafeManagedPtrCastPtr bar
    child' <- unsafeManagedPtrCastPtr child
    gtk_header_bar_remove bar' child'
    touchManagedPtr bar
    touchManagedPtr child
    return ()

#if defined(ENABLE_OVERLOADING)
data HeaderBarRemoveMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, IsHeaderBar a, Gtk.Widget.IsWidget b) => O.OverloadedMethod HeaderBarRemoveMethodInfo a signature where
    overloadedMethod = headerBarRemove

instance O.OverloadedMethodInfo HeaderBarRemoveMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.HeaderBar.headerBarRemove",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-HeaderBar.html#v:headerBarRemove"
        })


#endif

-- method HeaderBar::set_decoration_layout
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "bar"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "HeaderBar" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a header bar" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "layout"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a decoration layout"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_header_bar_set_decoration_layout" gtk_header_bar_set_decoration_layout :: 
    Ptr HeaderBar ->                        -- bar : TInterface (Name {namespace = "Gtk", name = "HeaderBar"})
    CString ->                              -- layout : TBasicType TUTF8
    IO ()

-- | Sets the decoration layout for this header bar.
-- 
-- This property overrides the
-- [Settings:gtkDecorationLayout]("GI.Gtk.Objects.Settings#g:attr:gtkDecorationLayout") setting.
-- 
-- There can be valid reasons for overriding the setting, such
-- as a header bar design that does not allow for buttons to take
-- room on the right, or only offers room for a single close button.
-- Split header bars are another example for overriding the setting.
-- 
-- The format of the string is button names, separated by commas.
-- A colon separates the buttons that should appear on the left
-- from those on the right. Recognized button names are minimize,
-- maximize, close and icon (the window icon).
-- 
-- For example, “icon:minimize,maximize,close” specifies an icon
-- on the left, and minimize, maximize and close buttons on the right.
headerBarSetDecorationLayout ::
    (B.CallStack.HasCallStack, MonadIO m, IsHeaderBar a) =>
    a
    -- ^ /@bar@/: a header bar
    -> Maybe (T.Text)
    -- ^ /@layout@/: a decoration layout
    -> m ()
headerBarSetDecorationLayout bar layout = liftIO $ do
    bar' <- unsafeManagedPtrCastPtr bar
    maybeLayout <- case layout of
        Nothing -> return FP.nullPtr
        Just jLayout -> do
            jLayout' <- textToCString jLayout
            return jLayout'
    gtk_header_bar_set_decoration_layout bar' maybeLayout
    touchManagedPtr bar
    freeMem maybeLayout
    return ()

#if defined(ENABLE_OVERLOADING)
data HeaderBarSetDecorationLayoutMethodInfo
instance (signature ~ (Maybe (T.Text) -> m ()), MonadIO m, IsHeaderBar a) => O.OverloadedMethod HeaderBarSetDecorationLayoutMethodInfo a signature where
    overloadedMethod = headerBarSetDecorationLayout

instance O.OverloadedMethodInfo HeaderBarSetDecorationLayoutMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.HeaderBar.headerBarSetDecorationLayout",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-HeaderBar.html#v:headerBarSetDecorationLayout"
        })


#endif

-- method HeaderBar::set_show_title_buttons
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "bar"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "HeaderBar" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a header bar" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "setting"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "true to show standard title buttons"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_header_bar_set_show_title_buttons" gtk_header_bar_set_show_title_buttons :: 
    Ptr HeaderBar ->                        -- bar : TInterface (Name {namespace = "Gtk", name = "HeaderBar"})
    CInt ->                                 -- setting : TBasicType TBoolean
    IO ()

-- | Sets whether this header bar shows the standard window
-- title buttons.
headerBarSetShowTitleButtons ::
    (B.CallStack.HasCallStack, MonadIO m, IsHeaderBar a) =>
    a
    -- ^ /@bar@/: a header bar
    -> Bool
    -- ^ /@setting@/: true to show standard title buttons
    -> m ()
headerBarSetShowTitleButtons bar setting = liftIO $ do
    bar' <- unsafeManagedPtrCastPtr bar
    let setting' = (P.fromIntegral . P.fromEnum) setting
    gtk_header_bar_set_show_title_buttons bar' setting'
    touchManagedPtr bar
    return ()

#if defined(ENABLE_OVERLOADING)
data HeaderBarSetShowTitleButtonsMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsHeaderBar a) => O.OverloadedMethod HeaderBarSetShowTitleButtonsMethodInfo a signature where
    overloadedMethod = headerBarSetShowTitleButtons

instance O.OverloadedMethodInfo HeaderBarSetShowTitleButtonsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.HeaderBar.headerBarSetShowTitleButtons",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-HeaderBar.html#v:headerBarSetShowTitleButtons"
        })


#endif

-- method HeaderBar::set_title_widget
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "bar"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "HeaderBar" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a header bar" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "title_widget"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a widget to use for a title"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_header_bar_set_title_widget" gtk_header_bar_set_title_widget :: 
    Ptr HeaderBar ->                        -- bar : TInterface (Name {namespace = "Gtk", name = "HeaderBar"})
    Ptr Gtk.Widget.Widget ->                -- title_widget : TInterface (Name {namespace = "Gtk", name = "Widget"})
    IO ()

-- | Sets the title for the header bar.
-- 
-- When set to @NULL@, the headerbar will display the title of
-- the window it is contained in.
-- 
-- The title should help a user identify the current view.
-- To achieve the same style as the builtin title, use the
-- “title” style class.
-- 
-- You should set the title widget to @NULL@, for the window
-- title label to be visible again.
headerBarSetTitleWidget ::
    (B.CallStack.HasCallStack, MonadIO m, IsHeaderBar a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@bar@/: a header bar
    -> Maybe (b)
    -- ^ /@titleWidget@/: a widget to use for a title
    -> m ()
headerBarSetTitleWidget bar titleWidget = liftIO $ do
    bar' <- unsafeManagedPtrCastPtr bar
    maybeTitleWidget <- case titleWidget of
        Nothing -> return FP.nullPtr
        Just jTitleWidget -> do
            jTitleWidget' <- unsafeManagedPtrCastPtr jTitleWidget
            return jTitleWidget'
    gtk_header_bar_set_title_widget bar' maybeTitleWidget
    touchManagedPtr bar
    whenJust titleWidget touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data HeaderBarSetTitleWidgetMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsHeaderBar a, Gtk.Widget.IsWidget b) => O.OverloadedMethod HeaderBarSetTitleWidgetMethodInfo a signature where
    overloadedMethod = headerBarSetTitleWidget

instance O.OverloadedMethodInfo HeaderBarSetTitleWidgetMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.HeaderBar.headerBarSetTitleWidget",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-HeaderBar.html#v:headerBarSetTitleWidget"
        })


#endif

-- method HeaderBar::set_use_native_controls
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "bar"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "HeaderBar" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a header bar" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "setting"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "true to show native window controls"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_header_bar_set_use_native_controls" gtk_header_bar_set_use_native_controls :: 
    Ptr HeaderBar ->                        -- bar : TInterface (Name {namespace = "Gtk", name = "HeaderBar"})
    CInt ->                                 -- setting : TBasicType TBoolean
    IO ()

-- | Sets whether this header bar shows native window controls.
-- 
-- This option shows the \"stoplight\" buttons on macOS.
-- For Linux, this option has no effect.
-- 
-- See also <https://docs.gtk.org/gtk4/osx.html?native-window-controls Using GTK on Apple macOS>.
-- 
-- /Since: 4.18/
headerBarSetUseNativeControls ::
    (B.CallStack.HasCallStack, MonadIO m, IsHeaderBar a) =>
    a
    -- ^ /@bar@/: a header bar
    -> Bool
    -- ^ /@setting@/: true to show native window controls
    -> m ()
headerBarSetUseNativeControls bar setting = liftIO $ do
    bar' <- unsafeManagedPtrCastPtr bar
    let setting' = (P.fromIntegral . P.fromEnum) setting
    gtk_header_bar_set_use_native_controls bar' setting'
    touchManagedPtr bar
    return ()

#if defined(ENABLE_OVERLOADING)
data HeaderBarSetUseNativeControlsMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsHeaderBar a) => O.OverloadedMethod HeaderBarSetUseNativeControlsMethodInfo a signature where
    overloadedMethod = headerBarSetUseNativeControls

instance O.OverloadedMethodInfo HeaderBarSetUseNativeControlsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.HeaderBar.headerBarSetUseNativeControls",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-HeaderBar.html#v:headerBarSetUseNativeControls"
        })


#endif


