// Copyright 2021, OpenTelemetry Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// OpAMP: Open Agent Management Protocol (https://github.com/open-telemetry/opamp-spec)

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.17.3
// source: opamp.proto

package protobufs

import (
	reflect "reflect"
	sync "sync"

	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type AgentToServerFlags int32

const (
	AgentToServerFlags_AgentToServerFlags_Unspecified AgentToServerFlags = 0
	// The Agent requests Server go generate a new instance_uid, which will
	// be sent back in ServerToAgent message
	AgentToServerFlags_AgentToServerFlags_RequestInstanceUid AgentToServerFlags = 1
)

// Enum value maps for AgentToServerFlags.
var (
	AgentToServerFlags_name = map[int32]string{
		0: "AgentToServerFlags_Unspecified",
		1: "AgentToServerFlags_RequestInstanceUid",
	}
	AgentToServerFlags_value = map[string]int32{
		"AgentToServerFlags_Unspecified":        0,
		"AgentToServerFlags_RequestInstanceUid": 1,
	}
)

func (x AgentToServerFlags) Enum() *AgentToServerFlags {
	p := new(AgentToServerFlags)
	*p = x
	return p
}

func (x AgentToServerFlags) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AgentToServerFlags) Descriptor() protoreflect.EnumDescriptor {
	return file_opamp_proto_enumTypes[0].Descriptor()
}

func (AgentToServerFlags) Type() protoreflect.EnumType {
	return &file_opamp_proto_enumTypes[0]
}

func (x AgentToServerFlags) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AgentToServerFlags.Descriptor instead.
func (AgentToServerFlags) EnumDescriptor() ([]byte, []int) {
	return file_opamp_proto_rawDescGZIP(), []int{0}
}

type ServerToAgentFlags int32

const (
	ServerToAgentFlags_ServerToAgentFlags_Unspecified ServerToAgentFlags = 0
	// ReportFullState flag can be used by the Server if the Agent did not include the
	// particular bit of information in the last status report (which is an allowed
	// optimization) but the Server detects that it does not have it (e.g. was
	// restarted and lost state). The detection happens using
	// AgentToServer.sequence_num values.
	// The Server asks the Agent to report full status.
	ServerToAgentFlags_ServerToAgentFlags_ReportFullState ServerToAgentFlags = 1
	// ReportAvailableComponents flag can be used by the server if the Agent did
	// not include the full AvailableComponents message, but only the hash.
	// If this flag is specified, the agent will populate available_components.components
	// with a full description of the agent's components.
	// Status: [Development]
	ServerToAgentFlags_ServerToAgentFlags_ReportAvailableComponents ServerToAgentFlags = 2
)

// Enum value maps for ServerToAgentFlags.
var (
	ServerToAgentFlags_name = map[int32]string{
		0: "ServerToAgentFlags_Unspecified",
		1: "ServerToAgentFlags_ReportFullState",
		2: "ServerToAgentFlags_ReportAvailableComponents",
	}
	ServerToAgentFlags_value = map[string]int32{
		"ServerToAgentFlags_Unspecified":               0,
		"ServerToAgentFlags_ReportFullState":           1,
		"ServerToAgentFlags_ReportAvailableComponents": 2,
	}
)

func (x ServerToAgentFlags) Enum() *ServerToAgentFlags {
	p := new(ServerToAgentFlags)
	*p = x
	return p
}

func (x ServerToAgentFlags) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ServerToAgentFlags) Descriptor() protoreflect.EnumDescriptor {
	return file_opamp_proto_enumTypes[1].Descriptor()
}

func (ServerToAgentFlags) Type() protoreflect.EnumType {
	return &file_opamp_proto_enumTypes[1]
}

func (x ServerToAgentFlags) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ServerToAgentFlags.Descriptor instead.
func (ServerToAgentFlags) EnumDescriptor() ([]byte, []int) {
	return file_opamp_proto_rawDescGZIP(), []int{1}
}

type ServerCapabilities int32

const (
	// The capabilities field is unspecified.
	ServerCapabilities_ServerCapabilities_Unspecified ServerCapabilities = 0
	// The Server can accept status reports. This bit MUST be set, since all Server
	// MUST be able to accept status reports.
	ServerCapabilities_ServerCapabilities_AcceptsStatus ServerCapabilities = 1
	// The Server can offer remote configuration to the Agent.
	ServerCapabilities_ServerCapabilities_OffersRemoteConfig ServerCapabilities = 2
	// The Server can accept EffectiveConfig in AgentToServer.
	ServerCapabilities_ServerCapabilities_AcceptsEffectiveConfig ServerCapabilities = 4
	// The Server can offer Packages.
	// Status: [Beta]
	ServerCapabilities_ServerCapabilities_OffersPackages ServerCapabilities = 8
	// The Server can accept Packages status.
	// Status: [Beta]
	ServerCapabilities_ServerCapabilities_AcceptsPackagesStatus ServerCapabilities = 16
	// The Server can offer connection settings.
	// Status: [Beta]
	ServerCapabilities_ServerCapabilities_OffersConnectionSettings ServerCapabilities = 32
	// The Server can accept ConnectionSettingsRequest and respond with an offer.
	// Status: [Development]
	ServerCapabilities_ServerCapabilities_AcceptsConnectionSettingsRequest ServerCapabilities = 64
)

// Enum value maps for ServerCapabilities.
var (
	ServerCapabilities_name = map[int32]string{
		0:  "ServerCapabilities_Unspecified",
		1:  "ServerCapabilities_AcceptsStatus",
		2:  "ServerCapabilities_OffersRemoteConfig",
		4:  "ServerCapabilities_AcceptsEffectiveConfig",
		8:  "ServerCapabilities_OffersPackages",
		16: "ServerCapabilities_AcceptsPackagesStatus",
		32: "ServerCapabilities_OffersConnectionSettings",
		64: "ServerCapabilities_AcceptsConnectionSettingsRequest",
	}
	ServerCapabilities_value = map[string]int32{
		"ServerCapabilities_Unspecified":                      0,
		"ServerCapabilities_AcceptsStatus":                    1,
		"ServerCapabilities_OffersRemoteConfig":               2,
		"ServerCapabilities_AcceptsEffectiveConfig":           4,
		"ServerCapabilities_OffersPackages":                   8,
		"ServerCapabilities_AcceptsPackagesStatus":            16,
		"ServerCapabilities_OffersConnectionSettings":         32,
		"ServerCapabilities_AcceptsConnectionSettingsRequest": 64,
	}
)

func (x ServerCapabilities) Enum() *ServerCapabilities {
	p := new(ServerCapabilities)
	*p = x
	return p
}

func (x ServerCapabilities) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ServerCapabilities) Descriptor() protoreflect.EnumDescriptor {
	return file_opamp_proto_enumTypes[2].Descriptor()
}

func (ServerCapabilities) Type() protoreflect.EnumType {
	return &file_opamp_proto_enumTypes[2]
}

func (x ServerCapabilities) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ServerCapabilities.Descriptor instead.
func (ServerCapabilities) EnumDescriptor() ([]byte, []int) {
	return file_opamp_proto_rawDescGZIP(), []int{2}
}

// The type of the package, either an addon or a top-level package.
// Status: [Beta]
type PackageType int32

const (
	PackageType_PackageType_TopLevel PackageType = 0
	PackageType_PackageType_Addon    PackageType = 1
)

// Enum value maps for PackageType.
var (
	PackageType_name = map[int32]string{
		0: "PackageType_TopLevel",
		1: "PackageType_Addon",
	}
	PackageType_value = map[string]int32{
		"PackageType_TopLevel": 0,
		"PackageType_Addon":    1,
	}
)

func (x PackageType) Enum() *PackageType {
	p := new(PackageType)
	*p = x
	return p
}

func (x PackageType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PackageType) Descriptor() protoreflect.EnumDescriptor {
	return file_opamp_proto_enumTypes[3].Descriptor()
}

func (PackageType) Type() protoreflect.EnumType {
	return &file_opamp_proto_enumTypes[3]
}

func (x PackageType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PackageType.Descriptor instead.
func (PackageType) EnumDescriptor() ([]byte, []int) {
	return file_opamp_proto_rawDescGZIP(), []int{3}
}

type ServerErrorResponseType int32

const (
	// Unknown error. Something went wrong, but it is not known what exactly.
	// The Agent SHOULD NOT retry the message.
	// The error_message field may contain a description of the problem.
	ServerErrorResponseType_ServerErrorResponseType_Unknown ServerErrorResponseType = 0
	// The AgentToServer message was malformed. The Agent SHOULD NOT retry
	// the message.
	ServerErrorResponseType_ServerErrorResponseType_BadRequest ServerErrorResponseType = 1
	// The Server is overloaded and unable to process the request. The Agent
	// should retry the message later. retry_info field may be optionally
	// set with additional information about retrying.
	ServerErrorResponseType_ServerErrorResponseType_Unavailable ServerErrorResponseType = 2
)

// Enum value maps for ServerErrorResponseType.
var (
	ServerErrorResponseType_name = map[int32]string{
		0: "ServerErrorResponseType_Unknown",
		1: "ServerErrorResponseType_BadRequest",
		2: "ServerErrorResponseType_Unavailable",
	}
	ServerErrorResponseType_value = map[string]int32{
		"ServerErrorResponseType_Unknown":     0,
		"ServerErrorResponseType_BadRequest":  1,
		"ServerErrorResponseType_Unavailable": 2,
	}
)

func (x ServerErrorResponseType) Enum() *ServerErrorResponseType {
	p := new(ServerErrorResponseType)
	*p = x
	return p
}

func (x ServerErrorResponseType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ServerErrorResponseType) Descriptor() protoreflect.EnumDescriptor {
	return file_opamp_proto_enumTypes[4].Descriptor()
}

func (ServerErrorResponseType) Type() protoreflect.EnumType {
	return &file_opamp_proto_enumTypes[4]
}

func (x ServerErrorResponseType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ServerErrorResponseType.Descriptor instead.
func (ServerErrorResponseType) EnumDescriptor() ([]byte, []int) {
	return file_opamp_proto_rawDescGZIP(), []int{4}
}

// Status: [Beta]
type CommandType int32

const (
	// The Agent should restart. This request will be ignored if the Agent does not
	// support restart.
	CommandType_CommandType_Restart CommandType = 0
)

// Enum value maps for CommandType.
var (
	CommandType_name = map[int32]string{
		0: "CommandType_Restart",
	}
	CommandType_value = map[string]int32{
		"CommandType_Restart": 0,
	}
)

func (x CommandType) Enum() *CommandType {
	p := new(CommandType)
	*p = x
	return p
}

func (x CommandType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CommandType) Descriptor() protoreflect.EnumDescriptor {
	return file_opamp_proto_enumTypes[5].Descriptor()
}

func (CommandType) Type() protoreflect.EnumType {
	return &file_opamp_proto_enumTypes[5]
}

func (x CommandType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CommandType.Descriptor instead.
func (CommandType) EnumDescriptor() ([]byte, []int) {
	return file_opamp_proto_rawDescGZIP(), []int{5}
}

type AgentCapabilities int32

const (
	// The capabilities field is unspecified.
	AgentCapabilities_AgentCapabilities_Unspecified AgentCapabilities = 0
	// The Agent can report status. This bit MUST be set, since all Agents MUST
	// report status.
	AgentCapabilities_AgentCapabilities_ReportsStatus AgentCapabilities = 1
	// The Agent can accept remote configuration from the Server.
	AgentCapabilities_AgentCapabilities_AcceptsRemoteConfig AgentCapabilities = 2
	// The Agent will report EffectiveConfig in AgentToServer.
	AgentCapabilities_AgentCapabilities_ReportsEffectiveConfig AgentCapabilities = 4
	// The Agent can accept package offers.
	// Status: [Beta]
	AgentCapabilities_AgentCapabilities_AcceptsPackages AgentCapabilities = 8
	// The Agent can report package status.
	// Status: [Beta]
	AgentCapabilities_AgentCapabilities_ReportsPackageStatuses AgentCapabilities = 16
	// The Agent can report own trace to the destination specified by
	// the Server via ConnectionSettingsOffers.own_traces field.
	// Status: [Beta]
	AgentCapabilities_AgentCapabilities_ReportsOwnTraces AgentCapabilities = 32
	// The Agent can report own metrics to the destination specified by
	// the Server via ConnectionSettingsOffers.own_metrics field.
	// Status: [Beta]
	AgentCapabilities_AgentCapabilities_ReportsOwnMetrics AgentCapabilities = 64
	// The Agent can report own logs to the destination specified by
	// the Server via ConnectionSettingsOffers.own_logs field.
	// Status: [Beta]
	AgentCapabilities_AgentCapabilities_ReportsOwnLogs AgentCapabilities = 128
	// The can accept connections settings for OpAMP via
	// ConnectionSettingsOffers.opamp field.
	// Status: [Beta]
	AgentCapabilities_AgentCapabilities_AcceptsOpAMPConnectionSettings AgentCapabilities = 256
	// The can accept connections settings for other destinations via
	// ConnectionSettingsOffers.other_connections field.
	// Status: [Beta]
	AgentCapabilities_AgentCapabilities_AcceptsOtherConnectionSettings AgentCapabilities = 512
	// The Agent can accept restart requests.
	// Status: [Beta]
	AgentCapabilities_AgentCapabilities_AcceptsRestartCommand AgentCapabilities = 1024
	// The Agent will report Health via AgentToServer.health field.
	AgentCapabilities_AgentCapabilities_ReportsHealth AgentCapabilities = 2048
	// The Agent will report RemoteConfig status via AgentToServer.remote_config_status field.
	AgentCapabilities_AgentCapabilities_ReportsRemoteConfig AgentCapabilities = 4096
	// The Agent can report heartbeats.
	// This is specified by the ServerToAgent.OpAMPConnectionSettings.heartbeat_interval_seconds field.
	// If this capability is true, but the Server does not set a heartbeat_interval_seconds field, the
	// Agent should use its own configured interval, which by default will be 30s. The Server may not
	// know the configured interval and should not make assumptions about it.
	// Status: [Development]
	AgentCapabilities_AgentCapabilities_ReportsHeartbeat AgentCapabilities = 8192
	// The agent will report AvailableComponents via the AgentToServer.available_components field.
	// Status: [Development]
	AgentCapabilities_AgentCapabilities_ReportsAvailableComponents AgentCapabilities = 16384
	// The agent will report ConnectionSettingsOffers status via AgentToServer.connection_settings_status field.
	// Status: [Development]
	AgentCapabilities_AgentCapabilities_ReportsConnectionSettingsStatus AgentCapabilities = 32768 // Add new capabilities here, continuing with the least significant unused bit.
)

// Enum value maps for AgentCapabilities.
var (
	AgentCapabilities_name = map[int32]string{
		0:     "AgentCapabilities_Unspecified",
		1:     "AgentCapabilities_ReportsStatus",
		2:     "AgentCapabilities_AcceptsRemoteConfig",
		4:     "AgentCapabilities_ReportsEffectiveConfig",
		8:     "AgentCapabilities_AcceptsPackages",
		16:    "AgentCapabilities_ReportsPackageStatuses",
		32:    "AgentCapabilities_ReportsOwnTraces",
		64:    "AgentCapabilities_ReportsOwnMetrics",
		128:   "AgentCapabilities_ReportsOwnLogs",
		256:   "AgentCapabilities_AcceptsOpAMPConnectionSettings",
		512:   "AgentCapabilities_AcceptsOtherConnectionSettings",
		1024:  "AgentCapabilities_AcceptsRestartCommand",
		2048:  "AgentCapabilities_ReportsHealth",
		4096:  "AgentCapabilities_ReportsRemoteConfig",
		8192:  "AgentCapabilities_ReportsHeartbeat",
		16384: "AgentCapabilities_ReportsAvailableComponents",
		32768: "AgentCapabilities_ReportsConnectionSettingsStatus",
	}
	AgentCapabilities_value = map[string]int32{
		"AgentCapabilities_Unspecified":                     0,
		"AgentCapabilities_ReportsStatus":                   1,
		"AgentCapabilities_AcceptsRemoteConfig":             2,
		"AgentCapabilities_ReportsEffectiveConfig":          4,
		"AgentCapabilities_AcceptsPackages":                 8,
		"AgentCapabilities_ReportsPackageStatuses":          16,
		"AgentCapabilities_ReportsOwnTraces":                32,
		"AgentCapabilities_ReportsOwnMetrics":               64,
		"AgentCapabilities_ReportsOwnLogs":                  128,
		"AgentCapabilities_AcceptsOpAMPConnectionSettings":  256,
		"AgentCapabilities_AcceptsOtherConnectionSettings":  512,
		"AgentCapabilities_AcceptsRestartCommand":           1024,
		"AgentCapabilities_ReportsHealth":                   2048,
		"AgentCapabilities_ReportsRemoteConfig":             4096,
		"AgentCapabilities_ReportsHeartbeat":                8192,
		"AgentCapabilities_ReportsAvailableComponents":      16384,
		"AgentCapabilities_ReportsConnectionSettingsStatus": 32768,
	}
)

func (x AgentCapabilities) Enum() *AgentCapabilities {
	p := new(AgentCapabilities)
	*p = x
	return p
}

func (x AgentCapabilities) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AgentCapabilities) Descriptor() protoreflect.EnumDescriptor {
	return file_opamp_proto_enumTypes[6].Descriptor()
}

func (AgentCapabilities) Type() protoreflect.EnumType {
	return &file_opamp_proto_enumTypes[6]
}

func (x AgentCapabilities) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AgentCapabilities.Descriptor instead.
func (AgentCapabilities) EnumDescriptor() ([]byte, []int) {
	return file_opamp_proto_rawDescGZIP(), []int{6}
}

// Status: [Development]
type ConnectionSettingsStatuses int32

const (
	// The value of status field is not set.
	ConnectionSettingsStatuses_ConnectionSettingsStatuses_UNSET ConnectionSettingsStatuses = 0
	// ConnectionSettings were successfully applied by the Agent.
	ConnectionSettingsStatuses_ConnectionSettingsStatuses_APPLIED ConnectionSettingsStatuses = 1
	// Agent is currently applying the ConnectionSettings that it received.
	ConnectionSettingsStatuses_ConnectionSettingsStatuses_APPLYING ConnectionSettingsStatuses = 2
	// Agent tried to apply the ConnectionSettings it received earlier, but failed.
	// See error_message for more details.
	ConnectionSettingsStatuses_ConnectionSettingsStatuses_FAILED ConnectionSettingsStatuses = 3
)

// Enum value maps for ConnectionSettingsStatuses.
var (
	ConnectionSettingsStatuses_name = map[int32]string{
		0: "ConnectionSettingsStatuses_UNSET",
		1: "ConnectionSettingsStatuses_APPLIED",
		2: "ConnectionSettingsStatuses_APPLYING",
		3: "ConnectionSettingsStatuses_FAILED",
	}
	ConnectionSettingsStatuses_value = map[string]int32{
		"ConnectionSettingsStatuses_UNSET":    0,
		"ConnectionSettingsStatuses_APPLIED":  1,
		"ConnectionSettingsStatuses_APPLYING": 2,
		"ConnectionSettingsStatuses_FAILED":   3,
	}
)

func (x ConnectionSettingsStatuses) Enum() *ConnectionSettingsStatuses {
	p := new(ConnectionSettingsStatuses)
	*p = x
	return p
}

func (x ConnectionSettingsStatuses) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ConnectionSettingsStatuses) Descriptor() protoreflect.EnumDescriptor {
	return file_opamp_proto_enumTypes[7].Descriptor()
}

func (ConnectionSettingsStatuses) Type() protoreflect.EnumType {
	return &file_opamp_proto_enumTypes[7]
}

func (x ConnectionSettingsStatuses) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ConnectionSettingsStatuses.Descriptor instead.
func (ConnectionSettingsStatuses) EnumDescriptor() ([]byte, []int) {
	return file_opamp_proto_rawDescGZIP(), []int{7}
}

type RemoteConfigStatuses int32

const (
	// The value of status field is not set.
	RemoteConfigStatuses_RemoteConfigStatuses_UNSET RemoteConfigStatuses = 0
	// Remote config was successfully applied by the Agent.
	RemoteConfigStatuses_RemoteConfigStatuses_APPLIED RemoteConfigStatuses = 1
	// Agent is currently applying the remote config that it received earlier.
	RemoteConfigStatuses_RemoteConfigStatuses_APPLYING RemoteConfigStatuses = 2
	// Agent tried to apply the config received earlier, but it failed.
	// See error_message for more details.
	RemoteConfigStatuses_RemoteConfigStatuses_FAILED RemoteConfigStatuses = 3
)

// Enum value maps for RemoteConfigStatuses.
var (
	RemoteConfigStatuses_name = map[int32]string{
		0: "RemoteConfigStatuses_UNSET",
		1: "RemoteConfigStatuses_APPLIED",
		2: "RemoteConfigStatuses_APPLYING",
		3: "RemoteConfigStatuses_FAILED",
	}
	RemoteConfigStatuses_value = map[string]int32{
		"RemoteConfigStatuses_UNSET":    0,
		"RemoteConfigStatuses_APPLIED":  1,
		"RemoteConfigStatuses_APPLYING": 2,
		"RemoteConfigStatuses_FAILED":   3,
	}
)

func (x RemoteConfigStatuses) Enum() *RemoteConfigStatuses {
	p := new(RemoteConfigStatuses)
	*p = x
	return p
}

func (x RemoteConfigStatuses) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RemoteConfigStatuses) Descriptor() protoreflect.EnumDescriptor {
	return file_opamp_proto_enumTypes[8].Descriptor()
}

func (RemoteConfigStatuses) Type() protoreflect.EnumType {
	return &file_opamp_proto_enumTypes[8]
}

func (x RemoteConfigStatuses) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RemoteConfigStatuses.Descriptor instead.
func (RemoteConfigStatuses) EnumDescriptor() ([]byte, []int) {
	return file_opamp_proto_rawDescGZIP(), []int{8}
}

// The status of this package.
// Status: [Beta]
type PackageStatusEnum int32

const (
	// Package is successfully installed by the Agent.
	// The error_message field MUST NOT be set.
	PackageStatusEnum_PackageStatusEnum_Installed PackageStatusEnum = 0
	// Installation of this package has not yet started.
	PackageStatusEnum_PackageStatusEnum_InstallPending PackageStatusEnum = 1
	// Agent is currently installing the package.
	// server_offered_hash field MUST be set to indicate the version that the
	// Agent is installing. The error_message field MUST NOT be set.
	PackageStatusEnum_PackageStatusEnum_Installing PackageStatusEnum = 2
	// Agent tried to install the package but installation failed.
	// server_offered_hash field MUST be set to indicate the version that the Agent
	// tried to install. The error_message may also contain more details about
	// the failure.
	PackageStatusEnum_PackageStatusEnum_InstallFailed PackageStatusEnum = 3
	// Agent is currently downloading the package.
	// server_offered_hash field MUST be set to indicate the version that the
	// Agent is installing. The error_message field MUST NOT be set.
	// Status: [Development]
	PackageStatusEnum_PackageStatusEnum_Downloading PackageStatusEnum = 4
)

// Enum value maps for PackageStatusEnum.
var (
	PackageStatusEnum_name = map[int32]string{
		0: "PackageStatusEnum_Installed",
		1: "PackageStatusEnum_InstallPending",
		2: "PackageStatusEnum_Installing",
		3: "PackageStatusEnum_InstallFailed",
		4: "PackageStatusEnum_Downloading",
	}
	PackageStatusEnum_value = map[string]int32{
		"PackageStatusEnum_Installed":      0,
		"PackageStatusEnum_InstallPending": 1,
		"PackageStatusEnum_Installing":     2,
		"PackageStatusEnum_InstallFailed":  3,
		"PackageStatusEnum_Downloading":    4,
	}
)

func (x PackageStatusEnum) Enum() *PackageStatusEnum {
	p := new(PackageStatusEnum)
	*p = x
	return p
}

func (x PackageStatusEnum) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PackageStatusEnum) Descriptor() protoreflect.EnumDescriptor {
	return file_opamp_proto_enumTypes[9].Descriptor()
}

func (PackageStatusEnum) Type() protoreflect.EnumType {
	return &file_opamp_proto_enumTypes[9]
}

func (x PackageStatusEnum) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PackageStatusEnum.Descriptor instead.
func (PackageStatusEnum) EnumDescriptor() ([]byte, []int) {
	return file_opamp_proto_rawDescGZIP(), []int{9}
}

type AgentToServer struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Globally unique identifier of the running instance of the Agent. SHOULD remain
	// unchanged for the lifetime of the Agent process.
	// MUST be 16 bytes long and SHOULD be generated using the UUID v7 spec.
	InstanceUid []byte `protobuf:"bytes,1,opt,name=instance_uid,json=instanceUid,proto3" json:"instance_uid,omitempty"`
	// The sequence number is incremented by 1 for every AgentToServer sent
	// by the Agent. This allows the Server to detect that it missed a message when
	// it notices that the sequence_num is not exactly by 1 greater than the previously
	// received one.
	SequenceNum uint64 `protobuf:"varint,2,opt,name=sequence_num,json=sequenceNum,proto3" json:"sequence_num,omitempty"`
	// Data that describes the Agent, its type, where it runs, etc.
	// May be omitted if nothing changed since last AgentToServer message.
	AgentDescription *AgentDescription `protobuf:"bytes,3,opt,name=agent_description,json=agentDescription,proto3" json:"agent_description,omitempty"`
	// Bitmask of flags defined by AgentCapabilities enum.
	// All bits that are not defined in AgentCapabilities enum MUST be set to 0 by
	// the Agent. This allows extending the protocol and the AgentCapabilities enum
	// in the future such that old Agents automatically report that they don't
	// support the new capability.
	// This field MUST be always set.
	Capabilities uint64 `protobuf:"varint,4,opt,name=capabilities,proto3" json:"capabilities,omitempty"`
	// The current health of the Agent and sub-components. The top-level ComponentHealth represents
	// the health of the Agent overall. May be omitted if nothing changed since last AgentToServer
	// message.
	// Status: [Beta]
	Health *ComponentHealth `protobuf:"bytes,5,opt,name=health,proto3" json:"health,omitempty"`
	// The current effective configuration of the Agent. The effective configuration is
	// the one that is currently used by the Agent. The effective configuration may be
	// different from the remote configuration received from the Server earlier, e.g.
	// because the Agent uses a local configuration instead (or in addition).
	//
	// This field SHOULD be unset if the effective config is unchanged since the last
	// AgentToServer message.
	EffectiveConfig *EffectiveConfig `protobuf:"bytes,6,opt,name=effective_config,json=effectiveConfig,proto3" json:"effective_config,omitempty"`
	// The status of the remote config that was previously received from the Server.
	// This field SHOULD be unset if the remote config status is unchanged since the
	// last AgentToServer message.
	RemoteConfigStatus *RemoteConfigStatus `protobuf:"bytes,7,opt,name=remote_config_status,json=remoteConfigStatus,proto3" json:"remote_config_status,omitempty"`
	// The list of the Agent packages, including package statuses. This field SHOULD be
	// unset if this information is unchanged since the last AgentToServer message for
	// this Agent was sent in the stream.
	// Status: [Beta]
	PackageStatuses *PackageStatuses `protobuf:"bytes,8,opt,name=package_statuses,json=packageStatuses,proto3" json:"package_statuses,omitempty"`
	// AgentDisconnect MUST be set in the last AgentToServer message sent from the
	// Agent to the Server.
	AgentDisconnect *AgentDisconnect `protobuf:"bytes,9,opt,name=agent_disconnect,json=agentDisconnect,proto3" json:"agent_disconnect,omitempty"`
	// Bit flags as defined by AgentToServerFlags bit masks.
	Flags uint64 `protobuf:"varint,10,opt,name=flags,proto3" json:"flags,omitempty"`
	// A request to create connection settings. This field is set for flows where
	// the Agent initiates the creation of connection settings.
	// Status: [Development]
	ConnectionSettingsRequest *ConnectionSettingsRequest `protobuf:"bytes,11,opt,name=connection_settings_request,json=connectionSettingsRequest,proto3" json:"connection_settings_request,omitempty"`
	// A message indicating custom capabilities supported by the Agent.
	// Status: [Development]
	CustomCapabilities *CustomCapabilities `protobuf:"bytes,12,opt,name=custom_capabilities,json=customCapabilities,proto3" json:"custom_capabilities,omitempty"`
	// A custom message sent from an Agent to the Server.
	// Status: [Development]
	CustomMessage *CustomMessage `protobuf:"bytes,13,opt,name=custom_message,json=customMessage,proto3" json:"custom_message,omitempty"`
	// A message indicating the components that are available for configuration on the agent.
	// Status: [Development]
	AvailableComponents *AvailableComponents `protobuf:"bytes,14,opt,name=available_components,json=availableComponents,proto3" json:"available_components,omitempty"`
	// The status of the OfferedConnectionSettings that was previously received
	// from the Server. This field SHOULD be unset if the offered connection
	// settings status is unchanged since the last AgentToServer message.
	// Status: [Development]
	ConnectionSettingsStatus *ConnectionSettingsStatus `protobuf:"bytes,15,opt,name=connection_settings_status,json=connectionSettingsStatus,proto3" json:"connection_settings_status,omitempty"`
}

func (x *AgentToServer) Reset() {
	*x = AgentToServer{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opamp_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AgentToServer) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AgentToServer) ProtoMessage() {}

func (x *AgentToServer) ProtoReflect() protoreflect.Message {
	mi := &file_opamp_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AgentToServer.ProtoReflect.Descriptor instead.
func (*AgentToServer) Descriptor() ([]byte, []int) {
	return file_opamp_proto_rawDescGZIP(), []int{0}
}

func (x *AgentToServer) GetInstanceUid() []byte {
	if x != nil {
		return x.InstanceUid
	}
	return nil
}

func (x *AgentToServer) GetSequenceNum() uint64 {
	if x != nil {
		return x.SequenceNum
	}
	return 0
}

func (x *AgentToServer) GetAgentDescription() *AgentDescription {
	if x != nil {
		return x.AgentDescription
	}
	return nil
}

func (x *AgentToServer) GetCapabilities() uint64 {
	if x != nil {
		return x.Capabilities
	}
	return 0
}

func (x *AgentToServer) GetHealth() *ComponentHealth {
	if x != nil {
		return x.Health
	}
	return nil
}

func (x *AgentToServer) GetEffectiveConfig() *EffectiveConfig {
	if x != nil {
		return x.EffectiveConfig
	}
	return nil
}

func (x *AgentToServer) GetRemoteConfigStatus() *RemoteConfigStatus {
	if x != nil {
		return x.RemoteConfigStatus
	}
	return nil
}

func (x *AgentToServer) GetPackageStatuses() *PackageStatuses {
	if x != nil {
		return x.PackageStatuses
	}
	return nil
}

func (x *AgentToServer) GetAgentDisconnect() *AgentDisconnect {
	if x != nil {
		return x.AgentDisconnect
	}
	return nil
}

func (x *AgentToServer) GetFlags() uint64 {
	if x != nil {
		return x.Flags
	}
	return 0
}

func (x *AgentToServer) GetConnectionSettingsRequest() *ConnectionSettingsRequest {
	if x != nil {
		return x.ConnectionSettingsRequest
	}
	return nil
}

func (x *AgentToServer) GetCustomCapabilities() *CustomCapabilities {
	if x != nil {
		return x.CustomCapabilities
	}
	return nil
}

func (x *AgentToServer) GetCustomMessage() *CustomMessage {
	if x != nil {
		return x.CustomMessage
	}
	return nil
}

func (x *AgentToServer) GetAvailableComponents() *AvailableComponents {
	if x != nil {
		return x.AvailableComponents
	}
	return nil
}

func (x *AgentToServer) GetConnectionSettingsStatus() *ConnectionSettingsStatus {
	if x != nil {
		return x.ConnectionSettingsStatus
	}
	return nil
}

// AgentDisconnect is the last message sent from the Agent to the Server. The Server
// SHOULD forget the association of the Agent instance with the message stream.
//
// If the message stream is closed in the transport layer then the Server SHOULD
// forget association of all Agent instances that were previously established for
// this message stream using AgentConnect message, even if the corresponding
// AgentDisconnect message were not explicitly received from the Agent.
type AgentDisconnect struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *AgentDisconnect) Reset() {
	*x = AgentDisconnect{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opamp_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AgentDisconnect) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AgentDisconnect) ProtoMessage() {}

func (x *AgentDisconnect) ProtoReflect() protoreflect.Message {
	mi := &file_opamp_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AgentDisconnect.ProtoReflect.Descriptor instead.
func (*AgentDisconnect) Descriptor() ([]byte, []int) {
	return file_opamp_proto_rawDescGZIP(), []int{1}
}

// ConnectionSettingsRequest is a request from the Agent to the Server to create
// and respond with an offer of connection settings for the Agent.
// Status: [Development]
type ConnectionSettingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Request for OpAMP connection settings. If this field is unset
	// then the ConnectionSettingsRequest message is empty and is not actionable
	// for the Server.
	Opamp *OpAMPConnectionSettingsRequest `protobuf:"bytes,1,opt,name=opamp,proto3" json:"opamp,omitempty"`
}

func (x *ConnectionSettingsRequest) Reset() {
	*x = ConnectionSettingsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opamp_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConnectionSettingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConnectionSettingsRequest) ProtoMessage() {}

func (x *ConnectionSettingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_opamp_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConnectionSettingsRequest.ProtoReflect.Descriptor instead.
func (*ConnectionSettingsRequest) Descriptor() ([]byte, []int) {
	return file_opamp_proto_rawDescGZIP(), []int{2}
}

func (x *ConnectionSettingsRequest) GetOpamp() *OpAMPConnectionSettingsRequest {
	if x != nil {
		return x.Opamp
	}
	return nil
}

// OpAMPConnectionSettingsRequest is a request for the Server to produce
// a OpAMPConnectionSettings in its response.
// Status: [Development]
type OpAMPConnectionSettingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A request to create a client certificate. This is used to initiate a
	// Client Signing Request (CSR) flow.
	// Required.
	CertificateRequest *CertificateRequest `protobuf:"bytes,1,opt,name=certificate_request,json=certificateRequest,proto3" json:"certificate_request,omitempty"`
}

func (x *OpAMPConnectionSettingsRequest) Reset() {
	*x = OpAMPConnectionSettingsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opamp_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OpAMPConnectionSettingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OpAMPConnectionSettingsRequest) ProtoMessage() {}

func (x *OpAMPConnectionSettingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_opamp_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OpAMPConnectionSettingsRequest.ProtoReflect.Descriptor instead.
func (*OpAMPConnectionSettingsRequest) Descriptor() ([]byte, []int) {
	return file_opamp_proto_rawDescGZIP(), []int{3}
}

func (x *OpAMPConnectionSettingsRequest) GetCertificateRequest() *CertificateRequest {
	if x != nil {
		return x.CertificateRequest
	}
	return nil
}

// Status: [Development]
type CertificateRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// PEM-encoded Client Certificate Signing Request (CSR), signed by client's private key.
	// The Server SHOULD validate the request and SHOULD respond with a
	// OpAMPConnectionSettings where the certificate.cert contains the issued
	// certificate.
	Csr []byte `protobuf:"bytes,1,opt,name=csr,proto3" json:"csr,omitempty"`
}

func (x *CertificateRequest) Reset() {
	*x = CertificateRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opamp_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CertificateRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CertificateRequest) ProtoMessage() {}

func (x *CertificateRequest) ProtoReflect() protoreflect.Message {
	mi := &file_opamp_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CertificateRequest.ProtoReflect.Descriptor instead.
func (*CertificateRequest) Descriptor() ([]byte, []int) {
	return file_opamp_proto_rawDescGZIP(), []int{4}
}

func (x *CertificateRequest) GetCsr() []byte {
	if x != nil {
		return x.Csr
	}
	return nil
}

// AvailableComponents contains metadata relating to the components included
// within the agent.
// status: [Development]
type AvailableComponents struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A map of a unique component ID to details about the component.
	// This may be omitted from the message if the server has not
	// explicitly requested it be sent by setting the ReportAvailableComponents
	// flag in the previous ServerToAgent message.
	Components map[string]*ComponentDetails `protobuf:"bytes,1,rep,name=components,proto3" json:"components,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Agent-calculated hash of the components.
	// This hash should be included in every AvailableComponents message.
	Hash []byte `protobuf:"bytes,2,opt,name=hash,proto3" json:"hash,omitempty"`
}

func (x *AvailableComponents) Reset() {
	*x = AvailableComponents{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opamp_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AvailableComponents) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AvailableComponents) ProtoMessage() {}

func (x *AvailableComponents) ProtoReflect() protoreflect.Message {
	mi := &file_opamp_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AvailableComponents.ProtoReflect.Descriptor instead.
func (*AvailableComponents) Descriptor() ([]byte, []int) {
	return file_opamp_proto_rawDescGZIP(), []int{5}
}

func (x *AvailableComponents) GetComponents() map[string]*ComponentDetails {
	if x != nil {
		return x.Components
	}
	return nil
}

func (x *AvailableComponents) GetHash() []byte {
	if x != nil {
		return x.Hash
	}
	return nil
}

type ComponentDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Extra key/value pairs that may be used to describe the component.
	// The key/value pairs are according to semantic conventions, see:
	// https://opentelemetry.io/docs/specs/semconv/
	//
	// For example, you may use the "code" semantic conventions to
	// report the location of the code for a specific component:
	// https://opentelemetry.io/docs/specs/semconv/attributes-registry/code/
	//
	// Or you may use the "vcs" semantic conventions to report the
	// repository the component may be a part of:
	// https://opentelemetry.io/docs/specs/semconv/attributes-registry/vcs/
	Metadata []*KeyValue `protobuf:"bytes,1,rep,name=metadata,proto3" json:"metadata,omitempty"`
	// A map of component ID to sub components details. It can nest as deeply as needed to
	// describe the underlying system.
	SubComponentMap map[string]*ComponentDetails `protobuf:"bytes,2,rep,name=sub_component_map,json=subComponentMap,proto3" json:"sub_component_map,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *ComponentDetails) Reset() {
	*x = ComponentDetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opamp_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ComponentDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ComponentDetails) ProtoMessage() {}

func (x *ComponentDetails) ProtoReflect() protoreflect.Message {
	mi := &file_opamp_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ComponentDetails.ProtoReflect.Descriptor instead.
func (*ComponentDetails) Descriptor() ([]byte, []int) {
	return file_opamp_proto_rawDescGZIP(), []int{6}
}

func (x *ComponentDetails) GetMetadata() []*KeyValue {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *ComponentDetails) GetSubComponentMap() map[string]*ComponentDetails {
	if x != nil {
		return x.SubComponentMap
	}
	return nil
}

type ServerToAgent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Agent instance uid. MUST match the instance_uid field in AgentToServer message.
	// Used for multiplexing messages from/to multiple agents using one message stream.
	InstanceUid []byte `protobuf:"bytes,1,opt,name=instance_uid,json=instanceUid,proto3" json:"instance_uid,omitempty"`
	// error_response is set if the Server wants to indicate that something went wrong
	// during processing of an AgentToServer message. If error_response is set then
	// all other fields below must be unset and vice versa, if any of the fields below is
	// set then error_response must be unset.
	ErrorResponse *ServerErrorResponse `protobuf:"bytes,2,opt,name=error_response,json=errorResponse,proto3" json:"error_response,omitempty"`
	// remote_config field is set when the Server has a remote config offer for the Agent.
	RemoteConfig *AgentRemoteConfig `protobuf:"bytes,3,opt,name=remote_config,json=remoteConfig,proto3" json:"remote_config,omitempty"`
	// This field is set when the Server wants the Agent to change one or more
	// of its client connection settings (destination, headers, certificate, etc).
	// Status: [Beta]
	ConnectionSettings *ConnectionSettingsOffers `protobuf:"bytes,4,opt,name=connection_settings,json=connectionSettings,proto3" json:"connection_settings,omitempty"`
	// This field is set when the Server has packages to offer to the Agent.
	// Status: [Beta]
	PackagesAvailable *PackagesAvailable `protobuf:"bytes,5,opt,name=packages_available,json=packagesAvailable,proto3" json:"packages_available,omitempty"`
	// Bit flags as defined by ServerToAgentFlags bit masks.
	Flags uint64 `protobuf:"varint,6,opt,name=flags,proto3" json:"flags,omitempty"`
	// Bitmask of flags defined by ServerCapabilities enum.
	// All bits that are not defined in ServerCapabilities enum MUST be set to 0
	// by the Server. This allows extending the protocol and the ServerCapabilities
	// enum in the future such that old Servers automatically report that they
	// don't support the new capability.
	// This field MUST be set in the first ServerToAgent sent by the Server and MAY
	// be omitted in subsequent ServerToAgent messages by setting it to
	// UnspecifiedServerCapability value.
	Capabilities uint64 `protobuf:"varint,7,opt,name=capabilities,proto3" json:"capabilities,omitempty"`
	// Properties related to identification of the Agent, which can be overridden
	// by the Server if needed.
	AgentIdentification *AgentIdentification `protobuf:"bytes,8,opt,name=agent_identification,json=agentIdentification,proto3" json:"agent_identification,omitempty"`
	// Allows the Server to instruct the Agent to perform a command, e.g. RESTART. This field should not be specified
	// with fields other than instance_uid and capabilities. If specified, other fields will be ignored and the command
	// will be performed.
	// Status: [Beta]
	Command *ServerToAgentCommand `protobuf:"bytes,9,opt,name=command,proto3" json:"command,omitempty"`
	// A message indicating custom capabilities supported by the Server.
	// Status: [Development]
	CustomCapabilities *CustomCapabilities `protobuf:"bytes,10,opt,name=custom_capabilities,json=customCapabilities,proto3" json:"custom_capabilities,omitempty"`
	// A custom message sent from the Server to an Agent.
	// Status: [Development]
	CustomMessage *CustomMessage `protobuf:"bytes,11,opt,name=custom_message,json=customMessage,proto3" json:"custom_message,omitempty"`
}

func (x *ServerToAgent) Reset() {
	*x = ServerToAgent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opamp_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ServerToAgent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServerToAgent) ProtoMessage() {}

func (x *ServerToAgent) ProtoReflect() protoreflect.Message {
	mi := &file_opamp_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServerToAgent.ProtoReflect.Descriptor instead.
func (*ServerToAgent) Descriptor() ([]byte, []int) {
	return file_opamp_proto_rawDescGZIP(), []int{7}
}

func (x *ServerToAgent) GetInstanceUid() []byte {
	if x != nil {
		return x.InstanceUid
	}
	return nil
}

func (x *ServerToAgent) GetErrorResponse() *ServerErrorResponse {
	if x != nil {
		return x.ErrorResponse
	}
	return nil
}

func (x *ServerToAgent) GetRemoteConfig() *AgentRemoteConfig {
	if x != nil {
		return x.RemoteConfig
	}
	return nil
}

func (x *ServerToAgent) GetConnectionSettings() *ConnectionSettingsOffers {
	if x != nil {
		return x.ConnectionSettings
	}
	return nil
}

func (x *ServerToAgent) GetPackagesAvailable() *PackagesAvailable {
	if x != nil {
		return x.PackagesAvailable
	}
	return nil
}

func (x *ServerToAgent) GetFlags() uint64 {
	if x != nil {
		return x.Flags
	}
	return 0
}

func (x *ServerToAgent) GetCapabilities() uint64 {
	if x != nil {
		return x.Capabilities
	}
	return 0
}

func (x *ServerToAgent) GetAgentIdentification() *AgentIdentification {
	if x != nil {
		return x.AgentIdentification
	}
	return nil
}

func (x *ServerToAgent) GetCommand() *ServerToAgentCommand {
	if x != nil {
		return x.Command
	}
	return nil
}

func (x *ServerToAgent) GetCustomCapabilities() *CustomCapabilities {
	if x != nil {
		return x.CustomCapabilities
	}
	return nil
}

func (x *ServerToAgent) GetCustomMessage() *CustomMessage {
	if x != nil {
		return x.CustomMessage
	}
	return nil
}

// The OpAMPConnectionSettings message is a collection of fields which comprise an
// offer from the Server to the Agent to use the specified settings for OpAMP
// connection.
// Status: [Beta]
type OpAMPConnectionSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// OpAMP Server URL This MUST be a WebSocket or HTTP URL and MUST be non-empty, for
	// example: "wss://example.com:4318/v1/opamp"
	DestinationEndpoint string `protobuf:"bytes,1,opt,name=destination_endpoint,json=destinationEndpoint,proto3" json:"destination_endpoint,omitempty"`
	// Optional headers to use when connecting. Typically used to set access tokens or
	// other authorization headers. For HTTP-based protocols the Agent should
	// set these in the request headers.
	// For example:
	// key="Authorization", Value="Basic YWxhZGRpbjpvcGVuc2VzYW1l".
	Headers *Headers `protobuf:"bytes,2,opt,name=headers,proto3" json:"headers,omitempty"`
	// The Agent should use the offered certificate to connect to the destination
	// from now on. If the Agent is able to validate and connect using the offered
	// certificate the Agent SHOULD forget any previous client certificates
	// for this connection.
	// This field is optional: if omitted the client SHOULD NOT use a client-side certificate.
	// This field can be used to perform a client certificate revocation/rotation.
	Certificate *TLSCertificate `protobuf:"bytes,3,opt,name=certificate,proto3" json:"certificate,omitempty"`
	// The Agent MUST periodically send an AgentToServer message if the
	// AgentCapabilities_ReportsHeartbeat capability is true. At a minimum the instance_uid
	// field MUST be set.
	//
	// An HTTP Client MUST use the value as polling interval, if heartbeat_interval_seconds is non-zero.
	//
	// A heartbeat is used to keep the connection active and inform the server that the Agent
	// is still alive and active.
	//
	// If this field has no value or is set to 0, the Agent should not send any heartbeats.
	// Status: [Development]
	HeartbeatIntervalSeconds uint64 `protobuf:"varint,4,opt,name=heartbeat_interval_seconds,json=heartbeatIntervalSeconds,proto3" json:"heartbeat_interval_seconds,omitempty"`
	// Optional connection specific TLS settings.
	// Status: [Development]
	Tls *TLSConnectionSettings `protobuf:"bytes,5,opt,name=tls,proto3" json:"tls,omitempty"`
	// Optional connection specific proxy settings.
	// Status: [Development]
	Proxy *ProxyConnectionSettings `protobuf:"bytes,6,opt,name=proxy,proto3" json:"proxy,omitempty"`
}

func (x *OpAMPConnectionSettings) Reset() {
	*x = OpAMPConnectionSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opamp_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OpAMPConnectionSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OpAMPConnectionSettings) ProtoMessage() {}

func (x *OpAMPConnectionSettings) ProtoReflect() protoreflect.Message {
	mi := &file_opamp_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OpAMPConnectionSettings.ProtoReflect.Descriptor instead.
func (*OpAMPConnectionSettings) Descriptor() ([]byte, []int) {
	return file_opamp_proto_rawDescGZIP(), []int{8}
}

func (x *OpAMPConnectionSettings) GetDestinationEndpoint() string {
	if x != nil {
		return x.DestinationEndpoint
	}
	return ""
}

func (x *OpAMPConnectionSettings) GetHeaders() *Headers {
	if x != nil {
		return x.Headers
	}
	return nil
}

func (x *OpAMPConnectionSettings) GetCertificate() *TLSCertificate {
	if x != nil {
		return x.Certificate
	}
	return nil
}

func (x *OpAMPConnectionSettings) GetHeartbeatIntervalSeconds() uint64 {
	if x != nil {
		return x.HeartbeatIntervalSeconds
	}
	return 0
}

func (x *OpAMPConnectionSettings) GetTls() *TLSConnectionSettings {
	if x != nil {
		return x.Tls
	}
	return nil
}

func (x *OpAMPConnectionSettings) GetProxy() *ProxyConnectionSettings {
	if x != nil {
		return x.Proxy
	}
	return nil
}

// The TelemetryConnectionSettings message is a collection of fields which comprise an
// offer from the Server to the Agent to use the specified settings for a network
// connection to report own telemetry.
// Status: [Beta]
type TelemetryConnectionSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The value MUST be a full URL an OTLP/HTTP/Protobuf receiver with path. Schema
	// SHOULD begin with "https://", for example "https://example.com:4318/v1/metrics"
	// The Agent MAY refuse to send the telemetry if the URL begins with "http://".
	DestinationEndpoint string `protobuf:"bytes,1,opt,name=destination_endpoint,json=destinationEndpoint,proto3" json:"destination_endpoint,omitempty"`
	// Optional headers to use when connecting. Typically used to set access tokens or
	// other authorization headers. For HTTP-based protocols the Agent should
	// set these in the request headers.
	// For example:
	// key="Authorization", Value="Basic YWxhZGRpbjpvcGVuc2VzYW1l".
	Headers *Headers `protobuf:"bytes,2,opt,name=headers,proto3" json:"headers,omitempty"`
	// The Agent should use the offered certificate to connect to the destination
	// from now on. If the Agent is able to validate and connect using the offered
	// certificate the Agent SHOULD forget any previous client certificates
	// for this connection.
	// This field is optional: if omitted the client SHOULD NOT use a client-side certificate.
	// This field can be used to perform a client certificate revocation/rotation.
	Certificate *TLSCertificate `protobuf:"bytes,3,opt,name=certificate,proto3" json:"certificate,omitempty"`
	// Optional connection specific TLS settings.
	// Status: [Development]
	Tls *TLSConnectionSettings `protobuf:"bytes,4,opt,name=tls,proto3" json:"tls,omitempty"`
	// Optional connection specific proxy settings.
	// Status: [Development]
	Proxy *ProxyConnectionSettings `protobuf:"bytes,5,opt,name=proxy,proto3" json:"proxy,omitempty"`
}

func (x *TelemetryConnectionSettings) Reset() {
	*x = TelemetryConnectionSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opamp_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TelemetryConnectionSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TelemetryConnectionSettings) ProtoMessage() {}

func (x *TelemetryConnectionSettings) ProtoReflect() protoreflect.Message {
	mi := &file_opamp_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TelemetryConnectionSettings.ProtoReflect.Descriptor instead.
func (*TelemetryConnectionSettings) Descriptor() ([]byte, []int) {
	return file_opamp_proto_rawDescGZIP(), []int{9}
}

func (x *TelemetryConnectionSettings) GetDestinationEndpoint() string {
	if x != nil {
		return x.DestinationEndpoint
	}
	return ""
}

func (x *TelemetryConnectionSettings) GetHeaders() *Headers {
	if x != nil {
		return x.Headers
	}
	return nil
}

func (x *TelemetryConnectionSettings) GetCertificate() *TLSCertificate {
	if x != nil {
		return x.Certificate
	}
	return nil
}

func (x *TelemetryConnectionSettings) GetTls() *TLSConnectionSettings {
	if x != nil {
		return x.Tls
	}
	return nil
}

func (x *TelemetryConnectionSettings) GetProxy() *ProxyConnectionSettings {
	if x != nil {
		return x.Proxy
	}
	return nil
}

// The OtherConnectionSettings message is a collection of fields which comprise an
// offer from the Server to the Agent to use the specified settings for a network
// connection. It is not required that all fields in this message are specified.
// The Server may specify only some of the fields, in which case it means that
// the Server offers the Agent to change only those fields, while keeping the
// rest of the fields unchanged.
//
// For example the Server may send a ConnectionSettings message with only the
// certificate field set, while all other fields are unset. This means that
// the Server wants the Agent to use a new certificate and continue sending to
// the destination it is currently sending using the current header and other
// settings.
//
// For fields which reference other messages the field is considered unset
// when the reference is unset.
//
// For primitive field (string) we rely on the "flags" to describe that the
// field is not set (this is done to overcome the limitation of old protoc
// compilers don't generate methods that allow to check for the presence of
// the field.
// Status: [Beta]
type OtherConnectionSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A URL, host:port or some other destination specifier.
	DestinationEndpoint string `protobuf:"bytes,1,opt,name=destination_endpoint,json=destinationEndpoint,proto3" json:"destination_endpoint,omitempty"`
	// Optional headers to use when connecting. Typically used to set access tokens or
	// other authorization headers. For HTTP-based protocols the Agent should
	// set these in the request headers.
	// For example:
	// key="Authorization", Value="Basic YWxhZGRpbjpvcGVuc2VzYW1l".
	Headers *Headers `protobuf:"bytes,2,opt,name=headers,proto3" json:"headers,omitempty"`
	// The Agent should use the offered certificate to connect to the destination
	// from now on. If the Agent is able to validate and connect using the offered
	// certificate the Agent SHOULD forget any previous client certificates
	// for this connection.
	// This field is optional: if omitted the client SHOULD NOT use a client-side certificate.
	// This field can be used to perform a client certificate revocation/rotation.
	Certificate *TLSCertificate `protobuf:"bytes,3,opt,name=certificate,proto3" json:"certificate,omitempty"`
	// Other connection settings. These are Agent-specific and are up to the Agent
	// interpret.
	OtherSettings map[string]string `protobuf:"bytes,4,rep,name=other_settings,json=otherSettings,proto3" json:"other_settings,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional connection specific TLS settings.
	// Status: [Development]
	Tls *TLSConnectionSettings `protobuf:"bytes,5,opt,name=tls,proto3" json:"tls,omitempty"`
	// Optional connection specific proxy settings.
	// Status: [Development]
	Proxy *ProxyConnectionSettings `protobuf:"bytes,6,opt,name=proxy,proto3" json:"proxy,omitempty"`
}

func (x *OtherConnectionSettings) Reset() {
	*x = OtherConnectionSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opamp_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OtherConnectionSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OtherConnectionSettings) ProtoMessage() {}

func (x *OtherConnectionSettings) ProtoReflect() protoreflect.Message {
	mi := &file_opamp_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OtherConnectionSettings.ProtoReflect.Descriptor instead.
func (*OtherConnectionSettings) Descriptor() ([]byte, []int) {
	return file_opamp_proto_rawDescGZIP(), []int{10}
}

func (x *OtherConnectionSettings) GetDestinationEndpoint() string {
	if x != nil {
		return x.DestinationEndpoint
	}
	return ""
}

func (x *OtherConnectionSettings) GetHeaders() *Headers {
	if x != nil {
		return x.Headers
	}
	return nil
}

func (x *OtherConnectionSettings) GetCertificate() *TLSCertificate {
	if x != nil {
		return x.Certificate
	}
	return nil
}

func (x *OtherConnectionSettings) GetOtherSettings() map[string]string {
	if x != nil {
		return x.OtherSettings
	}
	return nil
}

func (x *OtherConnectionSettings) GetTls() *TLSConnectionSettings {
	if x != nil {
		return x.Tls
	}
	return nil
}

func (x *OtherConnectionSettings) GetProxy() *ProxyConnectionSettings {
	if x != nil {
		return x.Proxy
	}
	return nil
}

// TLSConnectionSettings are optional connection settings that can be passed to
// the client in order to specify TLS configuration.
// Status: [Development]
type TLSConnectionSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Provides CA cert contents as a string.
	CaPemContents string `protobuf:"bytes,1,opt,name=ca_pem_contents,json=caPemContents,proto3" json:"ca_pem_contents,omitempty"`
	// Load system CA pool alongside any passed CAs.
	IncludeSystemCaCertsPool bool `protobuf:"varint,2,opt,name=include_system_ca_certs_pool,json=includeSystemCaCertsPool,proto3" json:"include_system_ca_certs_pool,omitempty"`
	// skip certificate verification.
	InsecureSkipVerify bool `protobuf:"varint,3,opt,name=insecure_skip_verify,json=insecureSkipVerify,proto3" json:"insecure_skip_verify,omitempty"`
	// Miniumum accepted TLS version; default "1.2".
	MinVersion string `protobuf:"bytes,4,opt,name=min_version,json=minVersion,proto3" json:"min_version,omitempty"`
	// Maxiumum accepted TLS version; default "".
	MaxVersion string `protobuf:"bytes,5,opt,name=max_version,json=maxVersion,proto3" json:"max_version,omitempty"`
	// Explicit list of cipher suites.
	CipherSuites []string `protobuf:"bytes,6,rep,name=cipher_suites,json=cipherSuites,proto3" json:"cipher_suites,omitempty"`
}

func (x *TLSConnectionSettings) Reset() {
	*x = TLSConnectionSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opamp_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TLSConnectionSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TLSConnectionSettings) ProtoMessage() {}

func (x *TLSConnectionSettings) ProtoReflect() protoreflect.Message {
	mi := &file_opamp_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TLSConnectionSettings.ProtoReflect.Descriptor instead.
func (*TLSConnectionSettings) Descriptor() ([]byte, []int) {
	return file_opamp_proto_rawDescGZIP(), []int{11}
}

func (x *TLSConnectionSettings) GetCaPemContents() string {
	if x != nil {
		return x.CaPemContents
	}
	return ""
}

func (x *TLSConnectionSettings) GetIncludeSystemCaCertsPool() bool {
	if x != nil {
		return x.IncludeSystemCaCertsPool
	}
	return false
}

func (x *TLSConnectionSettings) GetInsecureSkipVerify() bool {
	if x != nil {
		return x.InsecureSkipVerify
	}
	return false
}

func (x *TLSConnectionSettings) GetMinVersion() string {
	if x != nil {
		return x.MinVersion
	}
	return ""
}

func (x *TLSConnectionSettings) GetMaxVersion() string {
	if x != nil {
		return x.MaxVersion
	}
	return ""
}

func (x *TLSConnectionSettings) GetCipherSuites() []string {
	if x != nil {
		return x.CipherSuites
	}
	return nil
}

// Status: [Development]
type ProxyConnectionSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A URL, host:port or some other destination specifier.
	Url string `protobuf:"bytes,1,opt,name=url,proto3" json:"url,omitempty"`
	// Optional headers to send to proxies during CONNECT requests.
	// These headers can be ignored for non-HTTP based proxies.
	// For example:
	// key="Authorization", Value="Basic YWxhZGRpbjpvcGVuc2VzYW1l".
	ConnectHeaders *Headers `protobuf:"bytes,2,opt,name=connect_headers,json=connectHeaders,proto3" json:"connect_headers,omitempty"`
}

func (x *ProxyConnectionSettings) Reset() {
	*x = ProxyConnectionSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opamp_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProxyConnectionSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProxyConnectionSettings) ProtoMessage() {}

func (x *ProxyConnectionSettings) ProtoReflect() protoreflect.Message {
	mi := &file_opamp_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProxyConnectionSettings.ProtoReflect.Descriptor instead.
func (*ProxyConnectionSettings) Descriptor() ([]byte, []int) {
	return file_opamp_proto_rawDescGZIP(), []int{12}
}

func (x *ProxyConnectionSettings) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

func (x *ProxyConnectionSettings) GetConnectHeaders() *Headers {
	if x != nil {
		return x.ConnectHeaders
	}
	return nil
}

// Status: [Beta]
type Headers struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Headers []*Header `protobuf:"bytes,1,rep,name=headers,proto3" json:"headers,omitempty"`
}

func (x *Headers) Reset() {
	*x = Headers{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opamp_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Headers) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Headers) ProtoMessage() {}

func (x *Headers) ProtoReflect() protoreflect.Message {
	mi := &file_opamp_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Headers.ProtoReflect.Descriptor instead.
func (*Headers) Descriptor() ([]byte, []int) {
	return file_opamp_proto_rawDescGZIP(), []int{13}
}

func (x *Headers) GetHeaders() []*Header {
	if x != nil {
		return x.Headers
	}
	return nil
}

// Status: [Beta]
type Header struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Key   string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	Value string `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *Header) Reset() {
	*x = Header{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opamp_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Header) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Header) ProtoMessage() {}

func (x *Header) ProtoReflect() protoreflect.Message {
	mi := &file_opamp_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Header.ProtoReflect.Descriptor instead.
func (*Header) Descriptor() ([]byte, []int) {
	return file_opamp_proto_rawDescGZIP(), []int{14}
}

func (x *Header) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *Header) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

// Status: [Beta]
type TLSCertificate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// PEM-encoded certificate. Required.
	Cert []byte `protobuf:"bytes,1,opt,name=cert,proto3" json:"cert,omitempty"`
	// PEM-encoded private key of the certificate. Required.
	PrivateKey []byte `protobuf:"bytes,2,opt,name=private_key,json=privateKey,proto3" json:"private_key,omitempty"`
	// PEM-encoded certificate of the signing CA.
	// Optional. MUST be specified if the certificate is CA-signed.
	// Can be stored by TLS-terminating intermediary proxies in order to verify
	// the connecting client's certificate in the future.
	// It is not recommended that the Agent accepts this CA as an authority for
	// any purposes.
	CaCert []byte `protobuf:"bytes,3,opt,name=ca_cert,json=caCert,proto3" json:"ca_cert,omitempty"`
}

func (x *TLSCertificate) Reset() {
	*x = TLSCertificate{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opamp_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TLSCertificate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TLSCertificate) ProtoMessage() {}

func (x *TLSCertificate) ProtoReflect() protoreflect.Message {
	mi := &file_opamp_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TLSCertificate.ProtoReflect.Descriptor instead.
func (*TLSCertificate) Descriptor() ([]byte, []int) {
	return file_opamp_proto_rawDescGZIP(), []int{15}
}

func (x *TLSCertificate) GetCert() []byte {
	if x != nil {
		return x.Cert
	}
	return nil
}

func (x *TLSCertificate) GetPrivateKey() []byte {
	if x != nil {
		return x.PrivateKey
	}
	return nil
}

func (x *TLSCertificate) GetCaCert() []byte {
	if x != nil {
		return x.CaCert
	}
	return nil
}

// Status: [Beta]
type ConnectionSettingsOffers struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Hash of all settings, including settings that may be omitted from this message
	// because they are unchanged.
	Hash []byte `protobuf:"bytes,1,opt,name=hash,proto3" json:"hash,omitempty"`
	// Settings to connect to the OpAMP Server.
	// If this field is not set then the Agent should assume that the settings are
	// unchanged and should continue using existing settings.
	// The Agent MUST verify the offered connection settings by actually connecting
	// before accepting the setting to ensure it does not loose access to the OpAMP
	// Server due to invalid settings.
	Opamp *OpAMPConnectionSettings `protobuf:"bytes,2,opt,name=opamp,proto3" json:"opamp,omitempty"`
	// Settings to connect to an OTLP metrics backend to send Agent's own metrics to.
	// If this field is not set then the Agent should assume that the settings
	// are unchanged.
	//
	// Once accepted the Agent should periodically send to the specified destination
	// its own metrics, i.e. metrics of the Agent process and any custom metrics that
	// describe the Agent state.
	//
	// All attributes specified in the identifying_attributes field in AgentDescription
	// message SHOULD be also specified in the Resource of the reported OTLP metrics.
	//
	// Attributes specified in the non_identifying_attributes field in
	// AgentDescription message may be also specified in the Resource of the reported
	// OTLP metrics, in which case they SHOULD have exactly the same values.
	//
	// Process metrics MUST follow the conventions for processes:
	// https://github.com/open-telemetry/opentelemetry-specification/blob/main/specification/metrics/semantic_conventions/process-metrics.md
	OwnMetrics *TelemetryConnectionSettings `protobuf:"bytes,3,opt,name=own_metrics,json=ownMetrics,proto3" json:"own_metrics,omitempty"`
	// Similar to own_metrics, but for traces.
	OwnTraces *TelemetryConnectionSettings `protobuf:"bytes,4,opt,name=own_traces,json=ownTraces,proto3" json:"own_traces,omitempty"`
	// Similar to own_metrics, but for logs.
	OwnLogs *TelemetryConnectionSettings `protobuf:"bytes,5,opt,name=own_logs,json=ownLogs,proto3" json:"own_logs,omitempty"`
	// Another set of connection settings, with a string name associated with each.
	// How the Agent uses these is Agent-specific. Typically the name represents
	// the name of the destination to connect to (as it is known to the Agent).
	// If this field is not set then the Agent should assume that the other_connections
	// settings are unchanged.
	OtherConnections map[string]*OtherConnectionSettings `protobuf:"bytes,6,rep,name=other_connections,json=otherConnections,proto3" json:"other_connections,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *ConnectionSettingsOffers) Reset() {
	*x = ConnectionSettingsOffers{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opamp_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConnectionSettingsOffers) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConnectionSettingsOffers) ProtoMessage() {}

func (x *ConnectionSettingsOffers) ProtoReflect() protoreflect.Message {
	mi := &file_opamp_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConnectionSettingsOffers.ProtoReflect.Descriptor instead.
func (*ConnectionSettingsOffers) Descriptor() ([]byte, []int) {
	return file_opamp_proto_rawDescGZIP(), []int{16}
}

func (x *ConnectionSettingsOffers) GetHash() []byte {
	if x != nil {
		return x.Hash
	}
	return nil
}

func (x *ConnectionSettingsOffers) GetOpamp() *OpAMPConnectionSettings {
	if x != nil {
		return x.Opamp
	}
	return nil
}

func (x *ConnectionSettingsOffers) GetOwnMetrics() *TelemetryConnectionSettings {
	if x != nil {
		return x.OwnMetrics
	}
	return nil
}

func (x *ConnectionSettingsOffers) GetOwnTraces() *TelemetryConnectionSettings {
	if x != nil {
		return x.OwnTraces
	}
	return nil
}

func (x *ConnectionSettingsOffers) GetOwnLogs() *TelemetryConnectionSettings {
	if x != nil {
		return x.OwnLogs
	}
	return nil
}

func (x *ConnectionSettingsOffers) GetOtherConnections() map[string]*OtherConnectionSettings {
	if x != nil {
		return x.OtherConnections
	}
	return nil
}

// List of packages that the Server offers to the Agent.
// Status: [Beta]
type PackagesAvailable struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Map of packages. Keys are package names, values are the packages available for download.
	Packages map[string]*PackageAvailable `protobuf:"bytes,1,rep,name=packages,proto3" json:"packages,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Aggregate hash of all remotely installed packages. The Agent SHOULD include this
	// value in subsequent PackageStatuses messages. This in turn allows the management
	// Server to identify that a different set of packages is available for the Agent
	// and specify the available packages in the next ServerToAgent message.
	//
	// This field MUST be always set if the management Server supports packages
	// of agents.
	//
	// The hash is calculated as an aggregate of all packages names and content.
	AllPackagesHash []byte `protobuf:"bytes,2,opt,name=all_packages_hash,json=allPackagesHash,proto3" json:"all_packages_hash,omitempty"`
}

func (x *PackagesAvailable) Reset() {
	*x = PackagesAvailable{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opamp_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PackagesAvailable) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PackagesAvailable) ProtoMessage() {}

func (x *PackagesAvailable) ProtoReflect() protoreflect.Message {
	mi := &file_opamp_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PackagesAvailable.ProtoReflect.Descriptor instead.
func (*PackagesAvailable) Descriptor() ([]byte, []int) {
	return file_opamp_proto_rawDescGZIP(), []int{17}
}

func (x *PackagesAvailable) GetPackages() map[string]*PackageAvailable {
	if x != nil {
		return x.Packages
	}
	return nil
}

func (x *PackagesAvailable) GetAllPackagesHash() []byte {
	if x != nil {
		return x.AllPackagesHash
	}
	return nil
}

// Each Agent is composed of one or more packages. A package has a name and
// content stored in a file. The content of the files, functionality
// provided by the packages, how they are stored and used by the Agent side is Agent
// type-specific and is outside the concerns of the OpAMP protocol.
//
// If the Agent does not have an installed package with the specified name then
// it SHOULD download it from the specified URL and install it.
//
// If the Agent already has an installed package with the specified name
// but with a different hash then the Agent SHOULD download and
// install the package again, since it is a different version of the same package.
//
// If the Agent has an installed package with the specified name and the same
// hash then the Agent does not need to do anything, it already
// has the right version of the package.
// Status: [Beta]
type PackageAvailable struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Type PackageType `protobuf:"varint,1,opt,name=type,proto3,enum=opamp.proto.PackageType" json:"type,omitempty"`
	// The package version that is available on the Server side. The Agent may for
	// example use this information to avoid downloading a package that was previously
	// already downloaded and failed to install.
	Version string `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty"`
	// The downloadable file of the package.
	File *DownloadableFile `protobuf:"bytes,3,opt,name=file,proto3" json:"file,omitempty"`
	// The hash of the package. SHOULD be calculated based on all other fields of the
	// PackageAvailable message and content of the file of the package. The hash is
	// used by the Agent to determine if the package it has is different from the
	// package the Server is offering.
	Hash []byte `protobuf:"bytes,4,opt,name=hash,proto3" json:"hash,omitempty"`
}

func (x *PackageAvailable) Reset() {
	*x = PackageAvailable{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opamp_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PackageAvailable) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PackageAvailable) ProtoMessage() {}

func (x *PackageAvailable) ProtoReflect() protoreflect.Message {
	mi := &file_opamp_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PackageAvailable.ProtoReflect.Descriptor instead.
func (*PackageAvailable) Descriptor() ([]byte, []int) {
	return file_opamp_proto_rawDescGZIP(), []int{18}
}

func (x *PackageAvailable) GetType() PackageType {
	if x != nil {
		return x.Type
	}
	return PackageType_PackageType_TopLevel
}

func (x *PackageAvailable) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *PackageAvailable) GetFile() *DownloadableFile {
	if x != nil {
		return x.File
	}
	return nil
}

func (x *PackageAvailable) GetHash() []byte {
	if x != nil {
		return x.Hash
	}
	return nil
}

// Status: [Beta]
type DownloadableFile struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The URL from which the file can be downloaded using HTTP GET request.
	// The Server at the specified URL SHOULD support range requests
	// to allow for resuming downloads.
	DownloadUrl string `protobuf:"bytes,1,opt,name=download_url,json=downloadUrl,proto3" json:"download_url,omitempty"`
	// The hash of the file content. Can be used by the Agent to verify that the file
	// was downloaded correctly.
	ContentHash []byte `protobuf:"bytes,2,opt,name=content_hash,json=contentHash,proto3" json:"content_hash,omitempty"`
	// Optional signature of the file content. Can be used by the Agent to verify the
	// authenticity of the downloaded file, for example can be the
	// [detached GPG signature](https://www.gnupg.org/gph/en/manual/x135.html#AEN160).
	// The exact signing and verification method is Agent specific. See
	// https://github.com/open-telemetry/opamp-spec/blob/main/specification.md#code-signing
	// for recommendations.
	Signature []byte `protobuf:"bytes,3,opt,name=signature,proto3" json:"signature,omitempty"`
	// Optional headers to use when downloading a file. Typically used to set
	// access tokens or other authorization headers. For HTTP-based protocols
	// the Agent should set these in the request headers.
	// For example:
	// key="Authorization", Value="Basic YWxhZGRpbjpvcGVuc2VzYW1l".
	// Status: [Development]
	Headers *Headers `protobuf:"bytes,4,opt,name=headers,proto3" json:"headers,omitempty"`
}

func (x *DownloadableFile) Reset() {
	*x = DownloadableFile{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opamp_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DownloadableFile) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DownloadableFile) ProtoMessage() {}

func (x *DownloadableFile) ProtoReflect() protoreflect.Message {
	mi := &file_opamp_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DownloadableFile.ProtoReflect.Descriptor instead.
func (*DownloadableFile) Descriptor() ([]byte, []int) {
	return file_opamp_proto_rawDescGZIP(), []int{19}
}

func (x *DownloadableFile) GetDownloadUrl() string {
	if x != nil {
		return x.DownloadUrl
	}
	return ""
}

func (x *DownloadableFile) GetContentHash() []byte {
	if x != nil {
		return x.ContentHash
	}
	return nil
}

func (x *DownloadableFile) GetSignature() []byte {
	if x != nil {
		return x.Signature
	}
	return nil
}

func (x *DownloadableFile) GetHeaders() *Headers {
	if x != nil {
		return x.Headers
	}
	return nil
}

type ServerErrorResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Type ServerErrorResponseType `protobuf:"varint,1,opt,name=type,proto3,enum=opamp.proto.ServerErrorResponseType" json:"type,omitempty"`
	// Error message in the string form, typically human readable.
	ErrorMessage string `protobuf:"bytes,2,opt,name=error_message,json=errorMessage,proto3" json:"error_message,omitempty"`
	// Types that are assignable to Details:
	//	*ServerErrorResponse_RetryInfo
	Details isServerErrorResponse_Details `protobuf_oneof:"Details"`
}

func (x *ServerErrorResponse) Reset() {
	*x = ServerErrorResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opamp_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ServerErrorResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServerErrorResponse) ProtoMessage() {}

func (x *ServerErrorResponse) ProtoReflect() protoreflect.Message {
	mi := &file_opamp_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServerErrorResponse.ProtoReflect.Descriptor instead.
func (*ServerErrorResponse) Descriptor() ([]byte, []int) {
	return file_opamp_proto_rawDescGZIP(), []int{20}
}

func (x *ServerErrorResponse) GetType() ServerErrorResponseType {
	if x != nil {
		return x.Type
	}
	return ServerErrorResponseType_ServerErrorResponseType_Unknown
}

func (x *ServerErrorResponse) GetErrorMessage() string {
	if x != nil {
		return x.ErrorMessage
	}
	return ""
}

func (m *ServerErrorResponse) GetDetails() isServerErrorResponse_Details {
	if m != nil {
		return m.Details
	}
	return nil
}

func (x *ServerErrorResponse) GetRetryInfo() *RetryInfo {
	if x, ok := x.GetDetails().(*ServerErrorResponse_RetryInfo); ok {
		return x.RetryInfo
	}
	return nil
}

type isServerErrorResponse_Details interface {
	isServerErrorResponse_Details()
}

type ServerErrorResponse_RetryInfo struct {
	// Additional information about retrying if type==UNAVAILABLE.
	RetryInfo *RetryInfo `protobuf:"bytes,3,opt,name=retry_info,json=retryInfo,proto3,oneof"`
}

func (*ServerErrorResponse_RetryInfo) isServerErrorResponse_Details() {}

type RetryInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	RetryAfterNanoseconds uint64 `protobuf:"varint,1,opt,name=retry_after_nanoseconds,json=retryAfterNanoseconds,proto3" json:"retry_after_nanoseconds,omitempty"`
}

func (x *RetryInfo) Reset() {
	*x = RetryInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opamp_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RetryInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RetryInfo) ProtoMessage() {}

func (x *RetryInfo) ProtoReflect() protoreflect.Message {
	mi := &file_opamp_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RetryInfo.ProtoReflect.Descriptor instead.
func (*RetryInfo) Descriptor() ([]byte, []int) {
	return file_opamp_proto_rawDescGZIP(), []int{21}
}

func (x *RetryInfo) GetRetryAfterNanoseconds() uint64 {
	if x != nil {
		return x.RetryAfterNanoseconds
	}
	return 0
}

// ServerToAgentCommand is sent from the Server to the Agent to request that the Agent
// perform a command.
// Status: [Beta]
type ServerToAgentCommand struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Type CommandType `protobuf:"varint,1,opt,name=type,proto3,enum=opamp.proto.CommandType" json:"type,omitempty"`
}

func (x *ServerToAgentCommand) Reset() {
	*x = ServerToAgentCommand{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opamp_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ServerToAgentCommand) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServerToAgentCommand) ProtoMessage() {}

func (x *ServerToAgentCommand) ProtoReflect() protoreflect.Message {
	mi := &file_opamp_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServerToAgentCommand.ProtoReflect.Descriptor instead.
func (*ServerToAgentCommand) Descriptor() ([]byte, []int) {
	return file_opamp_proto_rawDescGZIP(), []int{22}
}

func (x *ServerToAgentCommand) GetType() CommandType {
	if x != nil {
		return x.Type
	}
	return CommandType_CommandType_Restart
}

type AgentDescription struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Attributes that identify the Agent.
	// Keys/values are according to OpenTelemetry semantic conventions, see:
	// https://github.com/open-telemetry/opentelemetry-specification/tree/main/specification/resource/semantic_conventions
	//
	// For standalone running Agents (such as OpenTelemetry Collector) the following
	// attributes SHOULD be specified:
	// - service.name should be set to a reverse FQDN that uniquely identifies the
	//   Agent type, e.g. "io.opentelemetry.collector"
	// - service.namespace if it is used in the environment where the Agent runs.
	// - service.version should be set to version number of the Agent build.
	// - service.instance.id should be set. It may be set equal to the Agent's
	//   instance uid (equal to ServerToAgent.instance_uid field) or any other value
	//   that uniquely identifies the Agent in combination with other attributes.
	// - any other attributes that are necessary for uniquely identifying the Agent's
	//   own telemetry.
	//
	// The Agent SHOULD also include these attributes in the Resource of its own
	// telemetry. The combination of identifying attributes SHOULD be sufficient to
	// uniquely identify the Agent's own telemetry in the destination system to which
	// the Agent sends its own telemetry.
	IdentifyingAttributes []*KeyValue `protobuf:"bytes,1,rep,name=identifying_attributes,json=identifyingAttributes,proto3" json:"identifying_attributes,omitempty"`
	// Attributes that do not necessarily identify the Agent but help describe
	// where it runs.
	// The following attributes SHOULD be included:
	// - os.type, os.version - to describe where the Agent runs.
	// - host.* to describe the host the Agent runs on.
	// - cloud.* to describe the cloud where the host is located.
	// - any other relevant Resource attributes that describe this Agent and the
	//   environment it runs in.
	// - any user-defined attributes that the end user would like to associate
	//   with this Agent.
	NonIdentifyingAttributes []*KeyValue `protobuf:"bytes,2,rep,name=non_identifying_attributes,json=nonIdentifyingAttributes,proto3" json:"non_identifying_attributes,omitempty"`
}

func (x *AgentDescription) Reset() {
	*x = AgentDescription{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opamp_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AgentDescription) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AgentDescription) ProtoMessage() {}

func (x *AgentDescription) ProtoReflect() protoreflect.Message {
	mi := &file_opamp_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AgentDescription.ProtoReflect.Descriptor instead.
func (*AgentDescription) Descriptor() ([]byte, []int) {
	return file_opamp_proto_rawDescGZIP(), []int{23}
}

func (x *AgentDescription) GetIdentifyingAttributes() []*KeyValue {
	if x != nil {
		return x.IdentifyingAttributes
	}
	return nil
}

func (x *AgentDescription) GetNonIdentifyingAttributes() []*KeyValue {
	if x != nil {
		return x.NonIdentifyingAttributes
	}
	return nil
}

// The health of the Agent and sub-components
// Status: [Beta]
type ComponentHealth struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Set to true if the component is up and healthy.
	Healthy bool `protobuf:"varint,1,opt,name=healthy,proto3" json:"healthy,omitempty"`
	// Timestamp since the component is up, i.e. when the component was started.
	// Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January 1970.
	// If the component is not running MUST be set to 0.
	StartTimeUnixNano uint64 `protobuf:"fixed64,2,opt,name=start_time_unix_nano,json=startTimeUnixNano,proto3" json:"start_time_unix_nano,omitempty"`
	// Human-readable error message if the component is in erroneous state. SHOULD be set
	// when healthy==false.
	LastError string `protobuf:"bytes,3,opt,name=last_error,json=lastError,proto3" json:"last_error,omitempty"`
	// Component status represented as a string. The status values are defined by agent-specific
	// semantics and not at the protocol level.
	Status string `protobuf:"bytes,4,opt,name=status,proto3" json:"status,omitempty"`
	// The time when the component status was observed. Value is UNIX Epoch time in
	// nanoseconds since 00:00:00 UTC on 1 January 1970.
	StatusTimeUnixNano uint64 `protobuf:"fixed64,5,opt,name=status_time_unix_nano,json=statusTimeUnixNano,proto3" json:"status_time_unix_nano,omitempty"`
	// A map to store more granular, sub-component health. It can nest as deeply as needed to
	// describe the underlying system.
	ComponentHealthMap map[string]*ComponentHealth `protobuf:"bytes,6,rep,name=component_health_map,json=componentHealthMap,proto3" json:"component_health_map,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *ComponentHealth) Reset() {
	*x = ComponentHealth{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opamp_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ComponentHealth) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ComponentHealth) ProtoMessage() {}

func (x *ComponentHealth) ProtoReflect() protoreflect.Message {
	mi := &file_opamp_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ComponentHealth.ProtoReflect.Descriptor instead.
func (*ComponentHealth) Descriptor() ([]byte, []int) {
	return file_opamp_proto_rawDescGZIP(), []int{24}
}

func (x *ComponentHealth) GetHealthy() bool {
	if x != nil {
		return x.Healthy
	}
	return false
}

func (x *ComponentHealth) GetStartTimeUnixNano() uint64 {
	if x != nil {
		return x.StartTimeUnixNano
	}
	return 0
}

func (x *ComponentHealth) GetLastError() string {
	if x != nil {
		return x.LastError
	}
	return ""
}

func (x *ComponentHealth) GetStatus() string {
	if x != nil {
		return x.Status
	}
	return ""
}

func (x *ComponentHealth) GetStatusTimeUnixNano() uint64 {
	if x != nil {
		return x.StatusTimeUnixNano
	}
	return 0
}

func (x *ComponentHealth) GetComponentHealthMap() map[string]*ComponentHealth {
	if x != nil {
		return x.ComponentHealthMap
	}
	return nil
}

type EffectiveConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The effective config of the Agent.
	ConfigMap *AgentConfigMap `protobuf:"bytes,1,opt,name=config_map,json=configMap,proto3" json:"config_map,omitempty"`
}

func (x *EffectiveConfig) Reset() {
	*x = EffectiveConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opamp_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EffectiveConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EffectiveConfig) ProtoMessage() {}

func (x *EffectiveConfig) ProtoReflect() protoreflect.Message {
	mi := &file_opamp_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EffectiveConfig.ProtoReflect.Descriptor instead.
func (*EffectiveConfig) Descriptor() ([]byte, []int) {
	return file_opamp_proto_rawDescGZIP(), []int{25}
}

func (x *EffectiveConfig) GetConfigMap() *AgentConfigMap {
	if x != nil {
		return x.ConfigMap
	}
	return nil
}

type RemoteConfigStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The hash of the remote config that was last received by this Agent in the
	// AgentRemoteConfig.config_hash field.
	// The Server SHOULD compare this hash with the config hash
	// it has for the Agent and if the hashes are different the Server MUST include
	// the remote_config field in the response in the ServerToAgent message.
	LastRemoteConfigHash []byte               `protobuf:"bytes,1,opt,name=last_remote_config_hash,json=lastRemoteConfigHash,proto3" json:"last_remote_config_hash,omitempty"`
	Status               RemoteConfigStatuses `protobuf:"varint,2,opt,name=status,proto3,enum=opamp.proto.RemoteConfigStatuses" json:"status,omitempty"`
	// Optional error message if status==FAILED.
	ErrorMessage string `protobuf:"bytes,3,opt,name=error_message,json=errorMessage,proto3" json:"error_message,omitempty"`
}

func (x *RemoteConfigStatus) Reset() {
	*x = RemoteConfigStatus{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opamp_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RemoteConfigStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RemoteConfigStatus) ProtoMessage() {}

func (x *RemoteConfigStatus) ProtoReflect() protoreflect.Message {
	mi := &file_opamp_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RemoteConfigStatus.ProtoReflect.Descriptor instead.
func (*RemoteConfigStatus) Descriptor() ([]byte, []int) {
	return file_opamp_proto_rawDescGZIP(), []int{26}
}

func (x *RemoteConfigStatus) GetLastRemoteConfigHash() []byte {
	if x != nil {
		return x.LastRemoteConfigHash
	}
	return nil
}

func (x *RemoteConfigStatus) GetStatus() RemoteConfigStatuses {
	if x != nil {
		return x.Status
	}
	return RemoteConfigStatuses_RemoteConfigStatuses_UNSET
}

func (x *RemoteConfigStatus) GetErrorMessage() string {
	if x != nil {
		return x.ErrorMessage
	}
	return ""
}

// Status: [Development]
type ConnectionSettingsStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The hash of the connection settings that was last recieved by this Agent
	// in the connection_settings.hash field. The Server SHOULD compare this
	// hash with the OfferedConnectionSettings hash it has for the Agent and if
	// the hashes are different the Server MUST include the connection_settings
	// field in the response in the ServerToAgent message.
	LastConnectionSettingsHash []byte                     `protobuf:"bytes,1,opt,name=last_connection_settings_hash,json=lastConnectionSettingsHash,proto3" json:"last_connection_settings_hash,omitempty"`
	Status                     ConnectionSettingsStatuses `protobuf:"varint,2,opt,name=status,proto3,enum=opamp.proto.ConnectionSettingsStatuses" json:"status,omitempty"`
	// Optional error message if status==FAILED.
	ErrorMessage string `protobuf:"bytes,3,opt,name=error_message,json=errorMessage,proto3" json:"error_message,omitempty"`
}

func (x *ConnectionSettingsStatus) Reset() {
	*x = ConnectionSettingsStatus{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opamp_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConnectionSettingsStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConnectionSettingsStatus) ProtoMessage() {}

func (x *ConnectionSettingsStatus) ProtoReflect() protoreflect.Message {
	mi := &file_opamp_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConnectionSettingsStatus.ProtoReflect.Descriptor instead.
func (*ConnectionSettingsStatus) Descriptor() ([]byte, []int) {
	return file_opamp_proto_rawDescGZIP(), []int{27}
}

func (x *ConnectionSettingsStatus) GetLastConnectionSettingsHash() []byte {
	if x != nil {
		return x.LastConnectionSettingsHash
	}
	return nil
}

func (x *ConnectionSettingsStatus) GetStatus() ConnectionSettingsStatuses {
	if x != nil {
		return x.Status
	}
	return ConnectionSettingsStatuses_ConnectionSettingsStatuses_UNSET
}

func (x *ConnectionSettingsStatus) GetErrorMessage() string {
	if x != nil {
		return x.ErrorMessage
	}
	return ""
}

// The PackageStatuses message describes the status of all packages that the Agent
// has or was offered.
// Status: [Beta]
type PackageStatuses struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A map of PackageStatus messages, where the keys are package names.
	// The key MUST match the name field of PackageStatus message.
	Packages map[string]*PackageStatus `protobuf:"bytes,1,rep,name=packages,proto3" json:"packages,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The aggregate hash of all packages that this Agent previously received from the
	// Server via PackagesAvailable message.
	//
	// The Server SHOULD compare this hash to the aggregate hash of all packages that
	// it has for this Agent and if the hashes are different the Server SHOULD send
	// an PackagesAvailable message to the Agent.
	ServerProvidedAllPackagesHash []byte `protobuf:"bytes,2,opt,name=server_provided_all_packages_hash,json=serverProvidedAllPackagesHash,proto3" json:"server_provided_all_packages_hash,omitempty"`
	// This field is set if the Agent encountered an error when processing the
	// PackagesAvailable message and that error is not related to any particular single
	// package.
	// The field must be unset is there were no processing errors.
	ErrorMessage string `protobuf:"bytes,3,opt,name=error_message,json=errorMessage,proto3" json:"error_message,omitempty"`
}

func (x *PackageStatuses) Reset() {
	*x = PackageStatuses{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opamp_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PackageStatuses) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PackageStatuses) ProtoMessage() {}

func (x *PackageStatuses) ProtoReflect() protoreflect.Message {
	mi := &file_opamp_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PackageStatuses.ProtoReflect.Descriptor instead.
func (*PackageStatuses) Descriptor() ([]byte, []int) {
	return file_opamp_proto_rawDescGZIP(), []int{28}
}

func (x *PackageStatuses) GetPackages() map[string]*PackageStatus {
	if x != nil {
		return x.Packages
	}
	return nil
}

func (x *PackageStatuses) GetServerProvidedAllPackagesHash() []byte {
	if x != nil {
		return x.ServerProvidedAllPackagesHash
	}
	return nil
}

func (x *PackageStatuses) GetErrorMessage() string {
	if x != nil {
		return x.ErrorMessage
	}
	return ""
}

// The status of a single package.
// Status: [Beta]
type PackageStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Package name. MUST be always set and MUST match the key in the packages field
	// of PackageStatuses message.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The version of the package that the Agent has.
	// MUST be set if the Agent has this package.
	// MUST be empty if the Agent does not have this package. This may be the case
	// for example if the package was offered by the Server but failed to install
	// and the Agent did not have this package previously.
	AgentHasVersion string `protobuf:"bytes,2,opt,name=agent_has_version,json=agentHasVersion,proto3" json:"agent_has_version,omitempty"`
	// The hash of the package that the Agent has.
	// MUST be set if the Agent has this package.
	// MUST be empty if the Agent does not have this package. This may be the case for
	// example if the package was offered by the Server but failed to install and the
	// Agent did not have this package previously.
	AgentHasHash []byte `protobuf:"bytes,3,opt,name=agent_has_hash,json=agentHasHash,proto3" json:"agent_has_hash,omitempty"`
	// The version of the package that the Server offered to the Agent.
	// MUST be set if the installation of the package is initiated by an earlier offer
	// from the Server to install this package.
	//
	// MUST be empty if the Agent has this package but it was installed locally and
	// was not offered by the Server.
	//
	// Note that it is possible for both agent_has_version and server_offered_version
	// fields to be set and to have different values. This is for example possible if
	// the Agent already has a version of the package successfully installed, the Server
	// offers a different version, but the Agent fails to install that version.
	ServerOfferedVersion string `protobuf:"bytes,4,opt,name=server_offered_version,json=serverOfferedVersion,proto3" json:"server_offered_version,omitempty"`
	// The hash of the package that the Server offered to the Agent.
	// MUST be set if the installation of the package is initiated by an earlier
	// offer from the Server to install this package.
	//
	// MUST be empty if the Agent has this package but it was installed locally and
	// was not offered by the Server.
	//
	// Note that it is possible for both agent_has_hash and server_offered_hash
	// fields to be set and to have different values. This is for example possible if
	// the Agent already has a version of the package successfully installed, the
	// Server offers a different version, but the Agent fails to install that version.
	ServerOfferedHash []byte            `protobuf:"bytes,5,opt,name=server_offered_hash,json=serverOfferedHash,proto3" json:"server_offered_hash,omitempty"`
	Status            PackageStatusEnum `protobuf:"varint,6,opt,name=status,proto3,enum=opamp.proto.PackageStatusEnum" json:"status,omitempty"`
	// Error message if the status is erroneous.
	ErrorMessage string `protobuf:"bytes,7,opt,name=error_message,json=errorMessage,proto3" json:"error_message,omitempty"`
	// Optional details that may be of interest to a user.
	// Should only be set if status is Downloading.
	// Status: [Development]
	DownloadDetails *PackageDownloadDetails `protobuf:"bytes,8,opt,name=download_details,json=downloadDetails,proto3" json:"download_details,omitempty"`
}

func (x *PackageStatus) Reset() {
	*x = PackageStatus{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opamp_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PackageStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PackageStatus) ProtoMessage() {}

func (x *PackageStatus) ProtoReflect() protoreflect.Message {
	mi := &file_opamp_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PackageStatus.ProtoReflect.Descriptor instead.
func (*PackageStatus) Descriptor() ([]byte, []int) {
	return file_opamp_proto_rawDescGZIP(), []int{29}
}

func (x *PackageStatus) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *PackageStatus) GetAgentHasVersion() string {
	if x != nil {
		return x.AgentHasVersion
	}
	return ""
}

func (x *PackageStatus) GetAgentHasHash() []byte {
	if x != nil {
		return x.AgentHasHash
	}
	return nil
}

func (x *PackageStatus) GetServerOfferedVersion() string {
	if x != nil {
		return x.ServerOfferedVersion
	}
	return ""
}

func (x *PackageStatus) GetServerOfferedHash() []byte {
	if x != nil {
		return x.ServerOfferedHash
	}
	return nil
}

func (x *PackageStatus) GetStatus() PackageStatusEnum {
	if x != nil {
		return x.Status
	}
	return PackageStatusEnum_PackageStatusEnum_Installed
}

func (x *PackageStatus) GetErrorMessage() string {
	if x != nil {
		return x.ErrorMessage
	}
	return ""
}

func (x *PackageStatus) GetDownloadDetails() *PackageDownloadDetails {
	if x != nil {
		return x.DownloadDetails
	}
	return nil
}

// Additional details that an agent can use to describe an in-progress package download.
// Status: [Development]
type PackageDownloadDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The package download progress as a percentage.
	DownloadPercent float64 `protobuf:"fixed64,1,opt,name=download_percent,json=downloadPercent,proto3" json:"download_percent,omitempty"`
	// The current package download rate in bytes per second.
	DownloadBytesPerSecond float64 `protobuf:"fixed64,2,opt,name=download_bytes_per_second,json=downloadBytesPerSecond,proto3" json:"download_bytes_per_second,omitempty"`
}

func (x *PackageDownloadDetails) Reset() {
	*x = PackageDownloadDetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opamp_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PackageDownloadDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PackageDownloadDetails) ProtoMessage() {}

func (x *PackageDownloadDetails) ProtoReflect() protoreflect.Message {
	mi := &file_opamp_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PackageDownloadDetails.ProtoReflect.Descriptor instead.
func (*PackageDownloadDetails) Descriptor() ([]byte, []int) {
	return file_opamp_proto_rawDescGZIP(), []int{30}
}

func (x *PackageDownloadDetails) GetDownloadPercent() float64 {
	if x != nil {
		return x.DownloadPercent
	}
	return 0
}

func (x *PackageDownloadDetails) GetDownloadBytesPerSecond() float64 {
	if x != nil {
		return x.DownloadBytesPerSecond
	}
	return 0
}

// Properties related to identification of the Agent, which can be overridden
// by the Server if needed
type AgentIdentification struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// When new_instance_uid is set, Agent MUST update instance_uid
	// to the value provided and use it for all further communication.
	// MUST be 16 bytes long and SHOULD be generated using the UUID v7 spec.
	NewInstanceUid []byte `protobuf:"bytes,1,opt,name=new_instance_uid,json=newInstanceUid,proto3" json:"new_instance_uid,omitempty"`
}

func (x *AgentIdentification) Reset() {
	*x = AgentIdentification{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opamp_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AgentIdentification) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AgentIdentification) ProtoMessage() {}

func (x *AgentIdentification) ProtoReflect() protoreflect.Message {
	mi := &file_opamp_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AgentIdentification.ProtoReflect.Descriptor instead.
func (*AgentIdentification) Descriptor() ([]byte, []int) {
	return file_opamp_proto_rawDescGZIP(), []int{31}
}

func (x *AgentIdentification) GetNewInstanceUid() []byte {
	if x != nil {
		return x.NewInstanceUid
	}
	return nil
}

type AgentRemoteConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Agent config offered by the management Server to the Agent instance. SHOULD NOT be
	// set if the config for this Agent has not changed since it was last requested (i.e.
	// AgentConfigRequest.last_remote_config_hash field is equal to
	// AgentConfigResponse.config_hash field).
	Config *AgentConfigMap `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Hash of "config". The Agent SHOULD include this value in subsequent
	// RemoteConfigStatus messages in the last_remote_config_hash field. This in turn
	// allows the management Server to identify that a new config is available for the Agent.
	//
	// This field MUST be always set if the management Server supports remote configuration
	// of agents.
	//
	// Management Server must choose a hashing function that guarantees lack of hash
	// collisions in practice.
	ConfigHash []byte `protobuf:"bytes,2,opt,name=config_hash,json=configHash,proto3" json:"config_hash,omitempty"`
}

func (x *AgentRemoteConfig) Reset() {
	*x = AgentRemoteConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opamp_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AgentRemoteConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AgentRemoteConfig) ProtoMessage() {}

func (x *AgentRemoteConfig) ProtoReflect() protoreflect.Message {
	mi := &file_opamp_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AgentRemoteConfig.ProtoReflect.Descriptor instead.
func (*AgentRemoteConfig) Descriptor() ([]byte, []int) {
	return file_opamp_proto_rawDescGZIP(), []int{32}
}

func (x *AgentRemoteConfig) GetConfig() *AgentConfigMap {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *AgentRemoteConfig) GetConfigHash() []byte {
	if x != nil {
		return x.ConfigHash
	}
	return nil
}

type AgentConfigMap struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Map of configs. Keys are config file names or config section names.
	// The configuration is assumed to be a collection of one or more named config files
	// or sections.
	// For agents that use a single config file or section the map SHOULD contain a single
	// entry and the key may be an empty string.
	ConfigMap map[string]*AgentConfigFile `protobuf:"bytes,1,rep,name=config_map,json=configMap,proto3" json:"config_map,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *AgentConfigMap) Reset() {
	*x = AgentConfigMap{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opamp_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AgentConfigMap) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AgentConfigMap) ProtoMessage() {}

func (x *AgentConfigMap) ProtoReflect() protoreflect.Message {
	mi := &file_opamp_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AgentConfigMap.ProtoReflect.Descriptor instead.
func (*AgentConfigMap) Descriptor() ([]byte, []int) {
	return file_opamp_proto_rawDescGZIP(), []int{33}
}

func (x *AgentConfigMap) GetConfigMap() map[string]*AgentConfigFile {
	if x != nil {
		return x.ConfigMap
	}
	return nil
}

type AgentConfigFile struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Config file or section body. The content, format and encoding depends on the Agent
	// type. The content_type field may optionally describe the MIME type of the body.
	Body []byte `protobuf:"bytes,1,opt,name=body,proto3" json:"body,omitempty"`
	// Optional MIME Content-Type that describes what's in the body field, for
	// example "text/yaml".
	ContentType string `protobuf:"bytes,2,opt,name=content_type,json=contentType,proto3" json:"content_type,omitempty"`
}

func (x *AgentConfigFile) Reset() {
	*x = AgentConfigFile{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opamp_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AgentConfigFile) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AgentConfigFile) ProtoMessage() {}

func (x *AgentConfigFile) ProtoReflect() protoreflect.Message {
	mi := &file_opamp_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AgentConfigFile.ProtoReflect.Descriptor instead.
func (*AgentConfigFile) Descriptor() ([]byte, []int) {
	return file_opamp_proto_rawDescGZIP(), []int{34}
}

func (x *AgentConfigFile) GetBody() []byte {
	if x != nil {
		return x.Body
	}
	return nil
}

func (x *AgentConfigFile) GetContentType() string {
	if x != nil {
		return x.ContentType
	}
	return ""
}

type CustomCapabilities struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of custom capabilities that are supported. Each capability is a reverse FQDN
	// with optional version information that uniquely identifies the custom capability
	// and should match a capability specified in a supported CustomMessage.
	// Status: [Development]
	Capabilities []string `protobuf:"bytes,1,rep,name=capabilities,proto3" json:"capabilities,omitempty"`
}

func (x *CustomCapabilities) Reset() {
	*x = CustomCapabilities{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opamp_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CustomCapabilities) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CustomCapabilities) ProtoMessage() {}

func (x *CustomCapabilities) ProtoReflect() protoreflect.Message {
	mi := &file_opamp_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CustomCapabilities.ProtoReflect.Descriptor instead.
func (*CustomCapabilities) Descriptor() ([]byte, []int) {
	return file_opamp_proto_rawDescGZIP(), []int{35}
}

func (x *CustomCapabilities) GetCapabilities() []string {
	if x != nil {
		return x.Capabilities
	}
	return nil
}

type CustomMessage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A reverse FQDN that uniquely identifies the capability and matches one of the
	// capabilities in the CustomCapabilities message.
	// Status: [Development]
	Capability string `protobuf:"bytes,1,opt,name=capability,proto3" json:"capability,omitempty"`
	// Type of message within the capability. The capability defines the types of custom
	// messages that are used to implement the capability. The type must only be unique
	// within the capability.
	// Status: [Development]
	Type string `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`
	// Binary data of the message. The capability must specify the format of the contents
	// of the data for each custom message type it defines.
	// Status: [Development]
	Data []byte `protobuf:"bytes,3,opt,name=data,proto3" json:"data,omitempty"`
}

func (x *CustomMessage) Reset() {
	*x = CustomMessage{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opamp_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CustomMessage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CustomMessage) ProtoMessage() {}

func (x *CustomMessage) ProtoReflect() protoreflect.Message {
	mi := &file_opamp_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CustomMessage.ProtoReflect.Descriptor instead.
func (*CustomMessage) Descriptor() ([]byte, []int) {
	return file_opamp_proto_rawDescGZIP(), []int{36}
}

func (x *CustomMessage) GetCapability() string {
	if x != nil {
		return x.Capability
	}
	return ""
}

func (x *CustomMessage) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *CustomMessage) GetData() []byte {
	if x != nil {
		return x.Data
	}
	return nil
}

var File_opamp_proto protoreflect.FileDescriptor

var file_opamp_proto_rawDesc = []byte{
	0x0a, 0x0b, 0x6f, 0x70, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x0b, 0x6f,
	0x70, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x0e, 0x61, 0x6e, 0x79, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xf6, 0x07, 0x0a, 0x0d, 0x41,
	0x67, 0x65, 0x6e, 0x74, 0x54, 0x6f, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x12, 0x21, 0x0a, 0x0c,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x75, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0c, 0x52, 0x0b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x55, 0x69, 0x64, 0x12,
	0x21, 0x0a, 0x0c, 0x73, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x6e, 0x75, 0x6d, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0b, 0x73, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x4e,
	0x75, 0x6d, 0x12, 0x4a, 0x0a, 0x11, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x64, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e,
	0x6f, 0x70, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x41, 0x67, 0x65, 0x6e,
	0x74, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x10, 0x61, 0x67,
	0x65, 0x6e, 0x74, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x22,
	0x0a, 0x0c, 0x63, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x04, 0x52, 0x0c, 0x63, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69,
	0x65, 0x73, 0x12, 0x34, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x6f, 0x70, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68,
	0x52, 0x06, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x12, 0x47, 0x0a, 0x10, 0x65, 0x66, 0x66, 0x65,
	0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x6f, 0x70, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x2e, 0x45, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x52, 0x0f, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x51, 0x0a, 0x14, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1f, 0x2e, 0x6f, 0x70, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x52, 0x65,
	0x6d, 0x6f, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x52, 0x12, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x12, 0x47, 0x0a, 0x10, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x5f,
	0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x65, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c,
	0x2e, 0x6f, 0x70, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x50, 0x61, 0x63,
	0x6b, 0x61, 0x67, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x65, 0x73, 0x52, 0x0f, 0x70, 0x61,
	0x63, 0x6b, 0x61, 0x67, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x65, 0x73, 0x12, 0x47, 0x0a,
	0x10, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x6f, 0x70, 0x61, 0x6d, 0x70, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x44, 0x69, 0x73, 0x63, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x52, 0x0f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x44, 0x69, 0x73, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x18,
	0x0a, 0x20, 0x01, 0x28, 0x04, 0x52, 0x05, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x12, 0x66, 0x0a, 0x1b,
	0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x18, 0x0b, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x26, 0x2e, 0x6f, 0x70, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e,
	0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x52, 0x19, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x50, 0x0a, 0x13, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x63,
	0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x18, 0x0c, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1f, 0x2e, 0x6f, 0x70, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e,
	0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69,
	0x65, 0x73, 0x52, 0x12, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69,
	0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x12, 0x41, 0x0a, 0x0e, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x6f, 0x70, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x43, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x0d, 0x63, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x53, 0x0a, 0x14, 0x61, 0x76, 0x61,
	0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74,
	0x73, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x6f, 0x70, 0x61, 0x6d, 0x70, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x41, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x43,
	0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x13, 0x61, 0x76, 0x61, 0x69, 0x6c,
	0x61, 0x62, 0x6c, 0x65, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x63,
	0x0a, 0x1a, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x0f, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x25, 0x2e, 0x6f, 0x70, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x2e, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x18, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x53, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x22, 0x11, 0x0a, 0x0f, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x44, 0x69, 0x73, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x22, 0x5e, 0x0a, 0x19, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x05, 0x6f, 0x70, 0x61, 0x6d, 0x70, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x6f, 0x70, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x2e, 0x4f, 0x70, 0x41, 0x4d, 0x50, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x52,
	0x05, 0x6f, 0x70, 0x61, 0x6d, 0x70, 0x22, 0x72, 0x0a, 0x1e, 0x4f, 0x70, 0x41, 0x4d, 0x50, 0x43,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x50, 0x0a, 0x13, 0x63, 0x65, 0x72, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x6f, 0x70, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x2e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x52, 0x12, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x22, 0x26, 0x0a, 0x12, 0x43, 0x65,
	0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x10, 0x0a, 0x03, 0x63, 0x73, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x03, 0x63,
	0x73, 0x72, 0x22, 0xd9, 0x01, 0x0a, 0x13, 0x41, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65,
	0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x50, 0x0a, 0x0a, 0x63, 0x6f,
	0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x30,
	0x2e, 0x6f, 0x70, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x41, 0x76, 0x61,
	0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x73,
	0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x52, 0x0a, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x12, 0x0a, 0x04,
	0x68, 0x61, 0x73, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x04, 0x68, 0x61, 0x73, 0x68,
	0x1a, 0x5c, 0x0a, 0x0f, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x33, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x6f, 0x70, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x44, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x73, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x88,
	0x02, 0x0a, 0x10, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x44, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x73, 0x12, 0x31, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x6f, 0x70, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x2e, 0x4b, 0x65, 0x79, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x08, 0x6d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x5e, 0x0a, 0x11, 0x73, 0x75, 0x62, 0x5f, 0x63, 0x6f,
	0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x5f, 0x6d, 0x61, 0x70, 0x18, 0x02, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x32, 0x2e, 0x6f, 0x70, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e,
	0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73,
	0x2e, 0x53, 0x75, 0x62, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x4d, 0x61, 0x70,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0f, 0x73, 0x75, 0x62, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e,
	0x65, 0x6e, 0x74, 0x4d, 0x61, 0x70, 0x1a, 0x61, 0x0a, 0x14, 0x53, 0x75, 0x62, 0x43, 0x6f, 0x6d,
	0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x4d, 0x61, 0x70, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10,
	0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79,
	0x12, 0x33, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1d, 0x2e, 0x6f, 0x70, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x43, 0x6f,
	0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x52, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xc8, 0x05, 0x0a, 0x0d, 0x53, 0x65,
	0x72, 0x76, 0x65, 0x72, 0x54, 0x6f, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x12, 0x21, 0x0a, 0x0c, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x75, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0c, 0x52, 0x0b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x55, 0x69, 0x64, 0x12, 0x47,
	0x0a, 0x0e, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x6f, 0x70, 0x61, 0x6d, 0x70, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x45, 0x72, 0x72, 0x6f, 0x72,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x52, 0x0d, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x43, 0x0a, 0x0d, 0x72, 0x65, 0x6d, 0x6f, 0x74,
	0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e,
	0x2e, 0x6f, 0x70, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x41, 0x67, 0x65,
	0x6e, 0x74, 0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0c,
	0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x56, 0x0a, 0x13,
	0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x6f, 0x70, 0x61, 0x6d,
	0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x4f, 0x66, 0x66, 0x65, 0x72, 0x73,
	0x52, 0x12, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x12, 0x4d, 0x0a, 0x12, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x73,
	0x5f, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1e, 0x2e, 0x6f, 0x70, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x50,
	0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x73, 0x41, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65,
	0x52, 0x11, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x73, 0x41, 0x76, 0x61, 0x69, 0x6c, 0x61,
	0x62, 0x6c, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x04, 0x52, 0x05, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x12, 0x22, 0x0a, 0x0c, 0x63, 0x61, 0x70,
	0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x04, 0x52,
	0x0c, 0x63, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x12, 0x53, 0x0a,
	0x14, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x6f, 0x70,
	0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x49,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x13, 0x61,
	0x67, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x3b, 0x0a, 0x07, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x18, 0x09, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x6f, 0x70, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x54, 0x6f, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x43,
	0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x52, 0x07, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x12,
	0x50, 0x0a, 0x13, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x63, 0x61, 0x70, 0x61, 0x62, 0x69,
	0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x6f,
	0x70, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x52, 0x12, 0x63,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65,
	0x73, 0x12, 0x41, 0x0a, 0x0e, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x6f, 0x70, 0x61, 0x6d,
	0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x0d, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x22, 0xeb, 0x02, 0x0a, 0x17, 0x4f, 0x70, 0x41, 0x4d, 0x50, 0x43, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x12, 0x31, 0x0a, 0x14, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x13,
	0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x6e, 0x64, 0x70, 0x6f,
	0x69, 0x6e, 0x74, 0x12, 0x2e, 0x0a, 0x07, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x6f, 0x70, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x2e, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x52, 0x07, 0x68, 0x65, 0x61, 0x64,
	0x65, 0x72, 0x73, 0x12, 0x3d, 0x0a, 0x0b, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x6f, 0x70, 0x61, 0x6d, 0x70,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x54, 0x4c, 0x53, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x65, 0x52, 0x0b, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x65, 0x12, 0x3c, 0x0a, 0x1a, 0x68, 0x65, 0x61, 0x72, 0x74, 0x62, 0x65, 0x61, 0x74, 0x5f,
	0x69, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x5f, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x04, 0x52, 0x18, 0x68, 0x65, 0x61, 0x72, 0x74, 0x62, 0x65, 0x61,
	0x74, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x53, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73,
	0x12, 0x34, 0x0a, 0x03, 0x74, 0x6c, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e,
	0x6f, 0x70, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x54, 0x4c, 0x53, 0x43,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x52, 0x03, 0x74, 0x6c, 0x73, 0x12, 0x3a, 0x0a, 0x05, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x6f, 0x70, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x2e, 0x50, 0x72, 0x6f, 0x78, 0x79, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x05, 0x70, 0x72, 0x6f,
	0x78, 0x79, 0x22, 0xb1, 0x02, 0x0a, 0x1b, 0x54, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x79,
	0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x12, 0x31, 0x0a, 0x14, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x13, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x6e, 0x64,
	0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x2e, 0x0a, 0x07, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x6f, 0x70, 0x61, 0x6d, 0x70, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x52, 0x07, 0x68, 0x65,
	0x61, 0x64, 0x65, 0x72, 0x73, 0x12, 0x3d, 0x0a, 0x0b, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x6f, 0x70, 0x61,
	0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x54, 0x4c, 0x53, 0x43, 0x65, 0x72, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x52, 0x0b, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x65, 0x12, 0x34, 0x0a, 0x03, 0x74, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x22, 0x2e, 0x6f, 0x70, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e,
	0x54, 0x4c, 0x53, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x03, 0x74, 0x6c, 0x73, 0x12, 0x3a, 0x0a, 0x05, 0x70, 0x72,
	0x6f, 0x78, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x6f, 0x70, 0x61, 0x6d,
	0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x50, 0x72, 0x6f, 0x78, 0x79, 0x43, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52,
	0x05, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x22, 0xcf, 0x03, 0x0a, 0x17, 0x4f, 0x74, 0x68, 0x65, 0x72,
	0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x12, 0x31, 0x0a, 0x14, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x13, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x6e, 0x64,
	0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x2e, 0x0a, 0x07, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x6f, 0x70, 0x61, 0x6d, 0x70, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x52, 0x07, 0x68, 0x65,
	0x61, 0x64, 0x65, 0x72, 0x73, 0x12, 0x3d, 0x0a, 0x0b, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x6f, 0x70, 0x61,
	0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x54, 0x4c, 0x53, 0x43, 0x65, 0x72, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x52, 0x0b, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x65, 0x12, 0x5e, 0x0a, 0x0e, 0x6f, 0x74, 0x68, 0x65, 0x72, 0x5f, 0x73, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x6f,
	0x70, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x4f, 0x74, 0x68, 0x65, 0x72,
	0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x2e, 0x4f, 0x74, 0x68, 0x65, 0x72, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0d, 0x6f, 0x74, 0x68, 0x65, 0x72, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x12, 0x34, 0x0a, 0x03, 0x74, 0x6c, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x22, 0x2e, 0x6f, 0x70, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e,
	0x54, 0x4c, 0x53, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x03, 0x74, 0x6c, 0x73, 0x12, 0x3a, 0x0a, 0x05, 0x70, 0x72,
	0x6f, 0x78, 0x79, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x6f, 0x70, 0x61, 0x6d,
	0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x50, 0x72, 0x6f, 0x78, 0x79, 0x43, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52,
	0x05, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x1a, 0x40, 0x0a, 0x12, 0x4f, 0x74, 0x68, 0x65, 0x72, 0x53,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03,
	0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x98, 0x02, 0x0a, 0x15, 0x54, 0x4c, 0x53,
	0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x63, 0x61, 0x5f, 0x70, 0x65, 0x6d, 0x5f, 0x63, 0x6f, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x63, 0x61, 0x50,
	0x65, 0x6d, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x3e, 0x0a, 0x1c, 0x69, 0x6e,
	0x63, 0x6c, 0x75, 0x64, 0x65, 0x5f, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x5f, 0x63, 0x61, 0x5f,
	0x63, 0x65, 0x72, 0x74, 0x73, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x18, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x43,
	0x61, 0x43, 0x65, 0x72, 0x74, 0x73, 0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x30, 0x0a, 0x14, 0x69, 0x6e,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x65, 0x5f, 0x73, 0x6b, 0x69, 0x70, 0x5f, 0x76, 0x65, 0x72, 0x69,
	0x66, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x12, 0x69, 0x6e, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x65, 0x53, 0x6b, 0x69, 0x70, 0x56, 0x65, 0x72, 0x69, 0x66, 0x79, 0x12, 0x1f, 0x0a, 0x0b,
	0x6d, 0x69, 0x6e, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0a, 0x6d, 0x69, 0x6e, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x1f, 0x0a,
	0x0b, 0x6d, 0x61, 0x78, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0a, 0x6d, 0x61, 0x78, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x23,
	0x0a, 0x0d, 0x63, 0x69, 0x70, 0x68, 0x65, 0x72, 0x5f, 0x73, 0x75, 0x69, 0x74, 0x65, 0x73, 0x18,
	0x06, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0c, 0x63, 0x69, 0x70, 0x68, 0x65, 0x72, 0x53, 0x75, 0x69,
	0x74, 0x65, 0x73, 0x22, 0x6a, 0x0a, 0x17, 0x50, 0x72, 0x6f, 0x78, 0x79, 0x43, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x10,
	0x0a, 0x03, 0x75, 0x72, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x6c,
	0x12, 0x3d, 0x0a, 0x0f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x5f, 0x68, 0x65, 0x61, 0x64,
	0x65, 0x72, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x6f, 0x70, 0x61, 0x6d,
	0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x52,
	0x0e, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x22,
	0x38, 0x0a, 0x07, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x12, 0x2d, 0x0a, 0x07, 0x68, 0x65,
	0x61, 0x64, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x6f, 0x70,
	0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72,
	0x52, 0x07, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x22, 0x30, 0x0a, 0x06, 0x48, 0x65, 0x61,
	0x64, 0x65, 0x72, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x5e, 0x0a, 0x0e, 0x54,
	0x4c, 0x53, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x12, 0x12, 0x0a,
	0x04, 0x63, 0x65, 0x72, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x04, 0x63, 0x65, 0x72,
	0x74, 0x12, 0x1f, 0x0a, 0x0b, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x6b, 0x65, 0x79,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0a, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x4b,
	0x65, 0x79, 0x12, 0x17, 0x0a, 0x07, 0x63, 0x61, 0x5f, 0x63, 0x65, 0x72, 0x74, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0c, 0x52, 0x06, 0x63, 0x61, 0x43, 0x65, 0x72, 0x74, 0x22, 0x98, 0x04, 0x0a, 0x18,
	0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x4f, 0x66, 0x66, 0x65, 0x72, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x68, 0x61, 0x73, 0x68,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x04, 0x68, 0x61, 0x73, 0x68, 0x12, 0x3a, 0x0a, 0x05,
	0x6f, 0x70, 0x61, 0x6d, 0x70, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x6f, 0x70,
	0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x4f, 0x70, 0x41, 0x4d, 0x50, 0x43,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x52, 0x05, 0x6f, 0x70, 0x61, 0x6d, 0x70, 0x12, 0x49, 0x0a, 0x0b, 0x6f, 0x77, 0x6e, 0x5f,
	0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e,
	0x6f, 0x70, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x54, 0x65, 0x6c, 0x65,
	0x6d, 0x65, 0x74, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x0a, 0x6f, 0x77, 0x6e, 0x4d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x73, 0x12, 0x47, 0x0a, 0x0a, 0x6f, 0x77, 0x6e, 0x5f, 0x74, 0x72, 0x61, 0x63, 0x65,
	0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x6f, 0x70, 0x61, 0x6d, 0x70, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x54, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x79, 0x43,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x52, 0x09, 0x6f, 0x77, 0x6e, 0x54, 0x72, 0x61, 0x63, 0x65, 0x73, 0x12, 0x43, 0x0a, 0x08,
	0x6f, 0x77, 0x6e, 0x5f, 0x6c, 0x6f, 0x67, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28,
	0x2e, 0x6f, 0x70, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x54, 0x65, 0x6c,
	0x65, 0x6d, 0x65, 0x74, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x07, 0x6f, 0x77, 0x6e, 0x4c, 0x6f, 0x67,
	0x73, 0x12, 0x68, 0x0a, 0x11, 0x6f, 0x74, 0x68, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x6f,
	0x70, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x43, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x4f, 0x66, 0x66,
	0x65, 0x72, 0x73, 0x2e, 0x4f, 0x74, 0x68, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x10, 0x6f, 0x74, 0x68, 0x65, 0x72,
	0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x69, 0x0a, 0x15, 0x4f,
	0x74, 0x68, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x3a, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x6f, 0x70, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x2e, 0x4f, 0x74, 0x68, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xe5, 0x01, 0x0a, 0x11, 0x50, 0x61, 0x63, 0x6b, 0x61,
	0x67, 0x65, 0x73, 0x41, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x48, 0x0a, 0x08,
	0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c,
	0x2e, 0x6f, 0x70, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x50, 0x61, 0x63,
	0x6b, 0x61, 0x67, 0x65, 0x73, 0x41, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x50,
	0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x08, 0x70, 0x61,
	0x63, 0x6b, 0x61, 0x67, 0x65, 0x73, 0x12, 0x2a, 0x0a, 0x11, 0x61, 0x6c, 0x6c, 0x5f, 0x70, 0x61,
	0x63, 0x6b, 0x61, 0x67, 0x65, 0x73, 0x5f, 0x68, 0x61, 0x73, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0c, 0x52, 0x0f, 0x61, 0x6c, 0x6c, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x73, 0x48, 0x61,
	0x73, 0x68, 0x1a, 0x5a, 0x0a, 0x0d, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x33, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x6f, 0x70, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x2e, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x41, 0x76, 0x61, 0x69, 0x6c, 0x61,
	0x62, 0x6c, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xa1,
	0x01, 0x0a, 0x10, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x41, 0x76, 0x61, 0x69, 0x6c, 0x61,
	0x62, 0x6c, 0x65, 0x12, 0x2c, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x18, 0x2e, 0x6f, 0x70, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e,
	0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70,
	0x65, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x31, 0x0a, 0x04, 0x66,
	0x69, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x6f, 0x70, 0x61, 0x6d,
	0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64,
	0x61, 0x62, 0x6c, 0x65, 0x46, 0x69, 0x6c, 0x65, 0x52, 0x04, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x12,
	0x0a, 0x04, 0x68, 0x61, 0x73, 0x68, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x04, 0x68, 0x61,
	0x73, 0x68, 0x22, 0xa6, 0x01, 0x0a, 0x10, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x61,
	0x62, 0x6c, 0x65, 0x46, 0x69, 0x6c, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x6f, 0x77, 0x6e, 0x6c,
	0x6f, 0x61, 0x64, 0x5f, 0x75, 0x72, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64,
	0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x55, 0x72, 0x6c, 0x12, 0x21, 0x0a, 0x0c, 0x63, 0x6f,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x68, 0x61, 0x73, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c,
	0x52, 0x0b, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x48, 0x61, 0x73, 0x68, 0x12, 0x1c, 0x0a,
	0x09, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0c,
	0x52, 0x09, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x12, 0x2e, 0x0a, 0x07, 0x68,
	0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x6f,
	0x70, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x48, 0x65, 0x61, 0x64, 0x65,
	0x72, 0x73, 0x52, 0x07, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x22, 0xb8, 0x01, 0x0a, 0x13,
	0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x38, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x24, 0x2e, 0x6f, 0x70, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e,
	0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x23, 0x0a,
	0x0d, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x4d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x12, 0x37, 0x0a, 0x0a, 0x72, 0x65, 0x74, 0x72, 0x79, 0x5f, 0x69, 0x6e, 0x66, 0x6f,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x6f, 0x70, 0x61, 0x6d, 0x70, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x52, 0x65, 0x74, 0x72, 0x79, 0x49, 0x6e, 0x66, 0x6f, 0x48, 0x00,
	0x52, 0x09, 0x72, 0x65, 0x74, 0x72, 0x79, 0x49, 0x6e, 0x66, 0x6f, 0x42, 0x09, 0x0a, 0x07, 0x44,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x22, 0x43, 0x0a, 0x09, 0x52, 0x65, 0x74, 0x72, 0x79, 0x49,
	0x6e, 0x66, 0x6f, 0x12, 0x36, 0x0a, 0x17, 0x72, 0x65, 0x74, 0x72, 0x79, 0x5f, 0x61, 0x66, 0x74,
	0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6e, 0x6f, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x04, 0x52, 0x15, 0x72, 0x65, 0x74, 0x72, 0x79, 0x41, 0x66, 0x74, 0x65, 0x72,
	0x4e, 0x61, 0x6e, 0x6f, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x22, 0x44, 0x0a, 0x14, 0x53,
	0x65, 0x72, 0x76, 0x65, 0x72, 0x54, 0x6f, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6d, 0x6d,
	0x61, 0x6e, 0x64, 0x12, 0x2c, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x18, 0x2e, 0x6f, 0x70, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e,
	0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70,
	0x65, 0x22, 0xb5, 0x01, 0x0a, 0x10, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x44, 0x65, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4c, 0x0a, 0x16, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x66, 0x79, 0x69, 0x6e, 0x67, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x6f, 0x70, 0x61, 0x6d, 0x70, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x4b, 0x65, 0x79, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x15, 0x69,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x69, 0x6e, 0x67, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62,
	0x75, 0x74, 0x65, 0x73, 0x12, 0x53, 0x0a, 0x1a, 0x6e, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x66, 0x79, 0x69, 0x6e, 0x67, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
	0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x6f, 0x70, 0x61, 0x6d, 0x70,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x4b, 0x65, 0x79, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52,
	0x18, 0x6e, 0x6f, 0x6e, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x69, 0x6e, 0x67, 0x41,
	0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x22, 0x93, 0x03, 0x0a, 0x0f, 0x43, 0x6f,
	0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x12, 0x18, 0x0a,
	0x07, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07,
	0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x79, 0x12, 0x2f, 0x0a, 0x14, 0x73, 0x74, 0x61, 0x72, 0x74,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x75, 0x6e, 0x69, 0x78, 0x5f, 0x6e, 0x61, 0x6e, 0x6f, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x06, 0x52, 0x11, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65,
	0x55, 0x6e, 0x69, 0x78, 0x4e, 0x61, 0x6e, 0x6f, 0x12, 0x1d, 0x0a, 0x0a, 0x6c, 0x61, 0x73, 0x74,
	0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6c, 0x61,
	0x73, 0x74, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12,
	0x31, 0x0a, 0x15, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x75,
	0x6e, 0x69, 0x78, 0x5f, 0x6e, 0x61, 0x6e, 0x6f, 0x18, 0x05, 0x20, 0x01, 0x28, 0x06, 0x52, 0x12,
	0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x54, 0x69, 0x6d, 0x65, 0x55, 0x6e, 0x69, 0x78, 0x4e, 0x61,
	0x6e, 0x6f, 0x12, 0x66, 0x0a, 0x14, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x5f,
	0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x5f, 0x6d, 0x61, 0x70, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x34, 0x2e, 0x6f, 0x70, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x43,
	0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x2e, 0x43,
	0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x4d, 0x61,
	0x70, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x12, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e,
	0x74, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x4d, 0x61, 0x70, 0x1a, 0x63, 0x0a, 0x17, 0x43, 0x6f,
	0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x4d, 0x61, 0x70,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x32, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x6f, 0x70, 0x61, 0x6d, 0x70, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x48, 0x65,
	0x61, 0x6c, 0x74, 0x68, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22,
	0x4d, 0x0a, 0x0f, 0x45, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x3a, 0x0a, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x6d, 0x61, 0x70,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x6f, 0x70, 0x61, 0x6d, 0x70, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x4d, 0x61, 0x70, 0x52, 0x09, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4d, 0x61, 0x70, 0x22, 0xab,
	0x01, 0x0a, 0x12, 0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x35, 0x0a, 0x17, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x72, 0x65,
	0x6d, 0x6f, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x68, 0x61, 0x73, 0x68,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x14, 0x6c, 0x61, 0x73, 0x74, 0x52, 0x65, 0x6d, 0x6f,
	0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x61, 0x73, 0x68, 0x12, 0x39, 0x0a, 0x06,
	0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x21, 0x2e, 0x6f,
	0x70, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x52, 0x65, 0x6d, 0x6f, 0x74,
	0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x65, 0x73, 0x52,
	0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x65, 0x72, 0x72, 0x6f, 0x72,
	0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c,
	0x65, 0x72, 0x72, 0x6f, 0x72, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x22, 0xc3, 0x01, 0x0a,
	0x18, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x41, 0x0a, 0x1d, 0x6c, 0x61, 0x73,
	0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x5f, 0x68, 0x61, 0x73, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c,
	0x52, 0x1a, 0x6c, 0x61, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x48, 0x61, 0x73, 0x68, 0x12, 0x3f, 0x0a, 0x06,
	0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x27, 0x2e, 0x6f,
	0x70, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x43, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x53, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x65, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x23, 0x0a,
	0x0d, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x4d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x22, 0xa1, 0x02, 0x0a, 0x0f, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x65, 0x73, 0x12, 0x46, 0x0a, 0x08, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67,
	0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x6f, 0x70, 0x61, 0x6d, 0x70,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x65, 0x73, 0x2e, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x52, 0x08, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x73, 0x12, 0x48,
	0x0a, 0x21, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65,
	0x64, 0x5f, 0x61, 0x6c, 0x6c, 0x5f, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x73, 0x5f, 0x68,
	0x61, 0x73, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x1d, 0x73, 0x65, 0x72, 0x76, 0x65,
	0x72, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x64, 0x41, 0x6c, 0x6c, 0x50, 0x61, 0x63, 0x6b,
	0x61, 0x67, 0x65, 0x73, 0x48, 0x61, 0x73, 0x68, 0x12, 0x23, 0x0a, 0x0d, 0x65, 0x72, 0x72, 0x6f,
	0x72, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0c, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x1a, 0x57, 0x0a,
	0x0d, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10,
	0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79,
	0x12, 0x30, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x6f, 0x70, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x50, 0x61,
	0x63, 0x6b, 0x61, 0x67, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x88, 0x03, 0x0a, 0x0d, 0x50, 0x61, 0x63, 0x6b, 0x61,
	0x67, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2a, 0x0a, 0x11,
	0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x68, 0x61, 0x73, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x48, 0x61,
	0x73, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x24, 0x0a, 0x0e, 0x61, 0x67, 0x65, 0x6e,
	0x74, 0x5f, 0x68, 0x61, 0x73, 0x5f, 0x68, 0x61, 0x73, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0c,
	0x52, 0x0c, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x48, 0x61, 0x73, 0x48, 0x61, 0x73, 0x68, 0x12, 0x34,
	0x0a, 0x16, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x6f, 0x66, 0x66, 0x65, 0x72, 0x65, 0x64,
	0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x14,
	0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x4f, 0x66, 0x66, 0x65, 0x72, 0x65, 0x64, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x12, 0x2e, 0x0a, 0x13, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x6f,
	0x66, 0x66, 0x65, 0x72, 0x65, 0x64, 0x5f, 0x68, 0x61, 0x73, 0x68, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0c, 0x52, 0x11, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x4f, 0x66, 0x66, 0x65, 0x72, 0x65, 0x64,
	0x48, 0x61, 0x73, 0x68, 0x12, 0x36, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x1e, 0x2e, 0x6f, 0x70, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x2e, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x45, 0x6e, 0x75, 0x6d, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x23, 0x0a, 0x0d,
	0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0c, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x12, 0x4e, 0x0a, 0x10, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x64, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x6f, 0x70,
	0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67,
	0x65, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73,
	0x52, 0x0f, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c,
	0x73, 0x22, 0x7e, 0x0a, 0x16, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x44, 0x6f, 0x77, 0x6e,
	0x6c, 0x6f, 0x61, 0x64, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x29, 0x0a, 0x10, 0x64,
	0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x01, 0x52, 0x0f, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x50,
	0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x12, 0x39, 0x0a, 0x19, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x6f,
	0x61, 0x64, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x73, 0x65, 0x63,
	0x6f, 0x6e, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x01, 0x52, 0x16, 0x64, 0x6f, 0x77, 0x6e, 0x6c,
	0x6f, 0x61, 0x64, 0x42, 0x79, 0x74, 0x65, 0x73, 0x50, 0x65, 0x72, 0x53, 0x65, 0x63, 0x6f, 0x6e,
	0x64, 0x22, 0x3f, 0x0a, 0x13, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x28, 0x0a, 0x10, 0x6e, 0x65, 0x77, 0x5f,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x75, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0c, 0x52, 0x0e, 0x6e, 0x65, 0x77, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x55,
	0x69, 0x64, 0x22, 0x69, 0x0a, 0x11, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x6d, 0x6f, 0x74,
	0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x33, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x6f, 0x70, 0x61, 0x6d, 0x70, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x4d, 0x61, 0x70, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x1f, 0x0a, 0x0b,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x68, 0x61, 0x73, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0c, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x61, 0x73, 0x68, 0x22, 0xb7, 0x01,
	0x0a, 0x0e, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4d, 0x61, 0x70,
	0x12, 0x49, 0x0a, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x6d, 0x61, 0x70, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x6f, 0x70, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x2e, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4d, 0x61,
	0x70, 0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4d, 0x61, 0x70, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x52, 0x09, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4d, 0x61, 0x70, 0x1a, 0x5a, 0x0a, 0x0e, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4d, 0x61, 0x70, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a,
	0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12,
	0x32, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c,
	0x2e, 0x6f, 0x70, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x41, 0x67, 0x65,
	0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x46, 0x69, 0x6c, 0x65, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x48, 0x0a, 0x0f, 0x41, 0x67, 0x65, 0x6e, 0x74,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x46, 0x69, 0x6c, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x62, 0x6f,
	0x64, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x04, 0x62, 0x6f, 0x64, 0x79, 0x12, 0x21,
	0x0a, 0x0c, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70,
	0x65, 0x22, 0x38, 0x0a, 0x12, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x61, 0x70, 0x61, 0x62,
	0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x12, 0x22, 0x0a, 0x0c, 0x63, 0x61, 0x70, 0x61, 0x62,
	0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0c, 0x63,
	0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x22, 0x57, 0x0a, 0x0d, 0x43,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x1e, 0x0a, 0x0a,
	0x63, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0a, 0x63, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x12, 0x12, 0x0a, 0x04,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65,
	0x12, 0x12, 0x0a, 0x04, 0x64, 0x61, 0x74, 0x61, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x04,
	0x64, 0x61, 0x74, 0x61, 0x2a, 0x63, 0x0a, 0x12, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x54, 0x6f, 0x53,
	0x65, 0x72, 0x76, 0x65, 0x72, 0x46, 0x6c, 0x61, 0x67, 0x73, 0x12, 0x22, 0x0a, 0x1e, 0x41, 0x67,
	0x65, 0x6e, 0x74, 0x54, 0x6f, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x46, 0x6c, 0x61, 0x67, 0x73,
	0x5f, 0x55, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x69, 0x66, 0x69, 0x65, 0x64, 0x10, 0x00, 0x12, 0x29,
	0x0a, 0x25, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x54, 0x6f, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x46,
	0x6c, 0x61, 0x67, 0x73, 0x5f, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x55, 0x69, 0x64, 0x10, 0x01, 0x2a, 0x92, 0x01, 0x0a, 0x12, 0x53, 0x65,
	0x72, 0x76, 0x65, 0x72, 0x54, 0x6f, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x46, 0x6c, 0x61, 0x67, 0x73,
	0x12, 0x22, 0x0a, 0x1e, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x54, 0x6f, 0x41, 0x67, 0x65, 0x6e,
	0x74, 0x46, 0x6c, 0x61, 0x67, 0x73, 0x5f, 0x55, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x69, 0x66, 0x69,
	0x65, 0x64, 0x10, 0x00, 0x12, 0x26, 0x0a, 0x22, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x54, 0x6f,
	0x41, 0x67, 0x65, 0x6e, 0x74, 0x46, 0x6c, 0x61, 0x67, 0x73, 0x5f, 0x52, 0x65, 0x70, 0x6f, 0x72,
	0x74, 0x46, 0x75, 0x6c, 0x6c, 0x53, 0x74, 0x61, 0x74, 0x65, 0x10, 0x01, 0x12, 0x30, 0x0a, 0x2c,
	0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x54, 0x6f, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x46, 0x6c, 0x61,
	0x67, 0x73, 0x5f, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x41, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62,
	0x6c, 0x65, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x73, 0x10, 0x02, 0x2a, 0xf7,
	0x02, 0x0a, 0x12, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c,
	0x69, 0x74, 0x69, 0x65, 0x73, 0x12, 0x22, 0x0a, 0x1e, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43,
	0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x5f, 0x55, 0x6e, 0x73, 0x70,
	0x65, 0x63, 0x69, 0x66, 0x69, 0x65, 0x64, 0x10, 0x00, 0x12, 0x24, 0x0a, 0x20, 0x53, 0x65, 0x72,
	0x76, 0x65, 0x72, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x5f,
	0x41, 0x63, 0x63, 0x65, 0x70, 0x74, 0x73, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x10, 0x01, 0x12,
	0x29, 0x0a, 0x25, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c,
	0x69, 0x74, 0x69, 0x65, 0x73, 0x5f, 0x4f, 0x66, 0x66, 0x65, 0x72, 0x73, 0x52, 0x65, 0x6d, 0x6f,
	0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x10, 0x02, 0x12, 0x2d, 0x0a, 0x29, 0x53, 0x65,
	0x72, 0x76, 0x65, 0x72, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73,
	0x5f, 0x41, 0x63, 0x63, 0x65, 0x70, 0x74, 0x73, 0x45, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76,
	0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x10, 0x04, 0x12, 0x25, 0x0a, 0x21, 0x53, 0x65, 0x72,
	0x76, 0x65, 0x72, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x5f,
	0x4f, 0x66, 0x66, 0x65, 0x72, 0x73, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x73, 0x10, 0x08,
	0x12, 0x2c, 0x0a, 0x28, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69,
	0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x5f, 0x41, 0x63, 0x63, 0x65, 0x70, 0x74, 0x73, 0x50, 0x61,
	0x63, 0x6b, 0x61, 0x67, 0x65, 0x73, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x10, 0x10, 0x12, 0x2f,
	0x0a, 0x2b, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69,
	0x74, 0x69, 0x65, 0x73, 0x5f, 0x4f, 0x66, 0x66, 0x65, 0x72, 0x73, 0x43, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x10, 0x20, 0x12,
	0x37, 0x0a, 0x33, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c,
	0x69, 0x74, 0x69, 0x65, 0x73, 0x5f, 0x41, 0x63, 0x63, 0x65, 0x70, 0x74, 0x73, 0x43, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x10, 0x40, 0x2a, 0x3e, 0x0a, 0x0b, 0x50, 0x61, 0x63, 0x6b,
	0x61, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x18, 0x0a, 0x14, 0x50, 0x61, 0x63, 0x6b, 0x61,
	0x67, 0x65, 0x54, 0x79, 0x70, 0x65, 0x5f, 0x54, 0x6f, 0x70, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x10,
	0x00, 0x12, 0x15, 0x0a, 0x11, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65,
	0x5f, 0x41, 0x64, 0x64, 0x6f, 0x6e, 0x10, 0x01, 0x2a, 0x8f, 0x01, 0x0a, 0x17, 0x53, 0x65, 0x72,
	0x76, 0x65, 0x72, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x23, 0x0a, 0x1f, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x45, 0x72,
	0x72, 0x6f, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x54, 0x79, 0x70, 0x65, 0x5f,
	0x55, 0x6e, 0x6b, 0x6e, 0x6f, 0x77, 0x6e, 0x10, 0x00, 0x12, 0x26, 0x0a, 0x22, 0x53, 0x65, 0x72,
	0x76, 0x65, 0x72, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x54, 0x79, 0x70, 0x65, 0x5f, 0x42, 0x61, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x10,
	0x01, 0x12, 0x27, 0x0a, 0x23, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x45, 0x72, 0x72, 0x6f, 0x72,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x54, 0x79, 0x70, 0x65, 0x5f, 0x55, 0x6e, 0x61,
	0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x10, 0x02, 0x2a, 0x26, 0x0a, 0x0b, 0x43, 0x6f,
	0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x54, 0x79, 0x70, 0x65, 0x12, 0x17, 0x0a, 0x13, 0x43, 0x6f, 0x6d,
	0x6d, 0x61, 0x6e, 0x64, 0x54, 0x79, 0x70, 0x65, 0x5f, 0x52, 0x65, 0x73, 0x74, 0x61, 0x72, 0x74,
	0x10, 0x00, 0x2a, 0x85, 0x06, 0x0a, 0x11, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x43, 0x61, 0x70, 0x61,
	0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x12, 0x21, 0x0a, 0x1d, 0x41, 0x67, 0x65, 0x6e,
	0x74, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x5f, 0x55, 0x6e,
	0x73, 0x70, 0x65, 0x63, 0x69, 0x66, 0x69, 0x65, 0x64, 0x10, 0x00, 0x12, 0x23, 0x0a, 0x1f, 0x41,
	0x67, 0x65, 0x6e, 0x74, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73,
	0x5f, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x10, 0x01,
	0x12, 0x29, 0x0a, 0x25, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c,
	0x69, 0x74, 0x69, 0x65, 0x73, 0x5f, 0x41, 0x63, 0x63, 0x65, 0x70, 0x74, 0x73, 0x52, 0x65, 0x6d,
	0x6f, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x10, 0x02, 0x12, 0x2c, 0x0a, 0x28, 0x41,
	0x67, 0x65, 0x6e, 0x74, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73,
	0x5f, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x45, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76,
	0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x10, 0x04, 0x12, 0x25, 0x0a, 0x21, 0x41, 0x67, 0x65,
	0x6e, 0x74, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x5f, 0x41,
	0x63, 0x63, 0x65, 0x70, 0x74, 0x73, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x73, 0x10, 0x08,
	0x12, 0x2c, 0x0a, 0x28, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c,
	0x69, 0x74, 0x69, 0x65, 0x73, 0x5f, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x50, 0x61, 0x63,
	0x6b, 0x61, 0x67, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x65, 0x73, 0x10, 0x10, 0x12, 0x26,
	0x0a, 0x22, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74,
	0x69, 0x65, 0x73, 0x5f, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x4f, 0x77, 0x6e, 0x54, 0x72,
	0x61, 0x63, 0x65, 0x73, 0x10, 0x20, 0x12, 0x27, 0x0a, 0x23, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x43,
	0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x5f, 0x52, 0x65, 0x70, 0x6f,
	0x72, 0x74, 0x73, 0x4f, 0x77, 0x6e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x10, 0x40, 0x12,
	0x25, 0x0a, 0x20, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69,
	0x74, 0x69, 0x65, 0x73, 0x5f, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x4f, 0x77, 0x6e, 0x4c,
	0x6f, 0x67, 0x73, 0x10, 0x80, 0x01, 0x12, 0x35, 0x0a, 0x30, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x43,
	0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x5f, 0x41, 0x63, 0x63, 0x65,
	0x70, 0x74, 0x73, 0x4f, 0x70, 0x41, 0x4d, 0x50, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x10, 0x80, 0x02, 0x12, 0x35, 0x0a,
	0x30, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69,
	0x65, 0x73, 0x5f, 0x41, 0x63, 0x63, 0x65, 0x70, 0x74, 0x73, 0x4f, 0x74, 0x68, 0x65, 0x72, 0x43,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x10, 0x80, 0x04, 0x12, 0x2c, 0x0a, 0x27, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x43, 0x61, 0x70,
	0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x5f, 0x41, 0x63, 0x63, 0x65, 0x70, 0x74,
	0x73, 0x52, 0x65, 0x73, 0x74, 0x61, 0x72, 0x74, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x10,
	0x80, 0x08, 0x12, 0x24, 0x0a, 0x1f, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x43, 0x61, 0x70, 0x61, 0x62,
	0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x5f, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x48,
	0x65, 0x61, 0x6c, 0x74, 0x68, 0x10, 0x80, 0x10, 0x12, 0x2a, 0x0a, 0x25, 0x41, 0x67, 0x65, 0x6e,
	0x74, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x5f, 0x52, 0x65,
	0x70, 0x6f, 0x72, 0x74, 0x73, 0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x10, 0x80, 0x20, 0x12, 0x27, 0x0a, 0x22, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x43, 0x61, 0x70,
	0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x5f, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74,
	0x73, 0x48, 0x65, 0x61, 0x72, 0x74, 0x62, 0x65, 0x61, 0x74, 0x10, 0x80, 0x40, 0x12, 0x32, 0x0a,
	0x2c, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69,
	0x65, 0x73, 0x5f, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x41, 0x76, 0x61, 0x69, 0x6c, 0x61,
	0x62, 0x6c, 0x65, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x73, 0x10, 0x80, 0x80,
	0x01, 0x12, 0x37, 0x0a, 0x31, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69,
	0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x5f, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x43, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x10, 0x80, 0x80, 0x02, 0x2a, 0xba, 0x01, 0x0a, 0x1a, 0x43,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x65, 0x73, 0x12, 0x24, 0x0a, 0x20, 0x43, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x53,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x65, 0x73, 0x5f, 0x55, 0x4e, 0x53, 0x45, 0x54, 0x10, 0x00, 0x12,
	0x26, 0x0a, 0x22, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x65, 0x73, 0x5f, 0x41, 0x50,
	0x50, 0x4c, 0x49, 0x45, 0x44, 0x10, 0x01, 0x12, 0x27, 0x0a, 0x23, 0x43, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x53, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x65, 0x73, 0x5f, 0x41, 0x50, 0x50, 0x4c, 0x59, 0x49, 0x4e, 0x47, 0x10, 0x02,
	0x12, 0x25, 0x0a, 0x21, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x65, 0x73, 0x5f, 0x46,
	0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x03, 0x2a, 0x9c, 0x01, 0x0a, 0x14, 0x52, 0x65, 0x6d, 0x6f,
	0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x65, 0x73,
	0x12, 0x1e, 0x0a, 0x1a, 0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x65, 0x73, 0x5f, 0x55, 0x4e, 0x53, 0x45, 0x54, 0x10, 0x00,
	0x12, 0x20, 0x0a, 0x1c, 0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x65, 0x73, 0x5f, 0x41, 0x50, 0x50, 0x4c, 0x49, 0x45, 0x44,
	0x10, 0x01, 0x12, 0x21, 0x0a, 0x1d, 0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x65, 0x73, 0x5f, 0x41, 0x50, 0x50, 0x4c, 0x59,
	0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x1f, 0x0a, 0x1b, 0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x65, 0x73, 0x5f, 0x46, 0x41,
	0x49, 0x4c, 0x45, 0x44, 0x10, 0x03, 0x2a, 0xc4, 0x01, 0x0a, 0x11, 0x50, 0x61, 0x63, 0x6b, 0x61,
	0x67, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x45, 0x6e, 0x75, 0x6d, 0x12, 0x1f, 0x0a, 0x1b,
	0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x45, 0x6e, 0x75,
	0x6d, 0x5f, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x65, 0x64, 0x10, 0x00, 0x12, 0x24, 0x0a,
	0x20, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x45, 0x6e,
	0x75, 0x6d, 0x5f, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x50, 0x65, 0x6e, 0x64, 0x69, 0x6e,
	0x67, 0x10, 0x01, 0x12, 0x20, 0x0a, 0x1c, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x45, 0x6e, 0x75, 0x6d, 0x5f, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c,
	0x69, 0x6e, 0x67, 0x10, 0x02, 0x12, 0x23, 0x0a, 0x1f, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65,
	0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x45, 0x6e, 0x75, 0x6d, 0x5f, 0x49, 0x6e, 0x73, 0x74, 0x61,
	0x6c, 0x6c, 0x46, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x10, 0x03, 0x12, 0x21, 0x0a, 0x1d, 0x50, 0x61,
	0x63, 0x6b, 0x61, 0x67, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x45, 0x6e, 0x75, 0x6d, 0x5f,
	0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x69, 0x6e, 0x67, 0x10, 0x04, 0x42, 0x2e, 0x5a,
	0x2c, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x6f, 0x70, 0x65, 0x6e,
	0x2d, 0x74, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x79, 0x2f, 0x6f, 0x70, 0x61, 0x6d, 0x70,
	0x2d, 0x67, 0x6f, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x73, 0x62, 0x06, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_opamp_proto_rawDescOnce sync.Once
	file_opamp_proto_rawDescData = file_opamp_proto_rawDesc
)

func file_opamp_proto_rawDescGZIP() []byte {
	file_opamp_proto_rawDescOnce.Do(func() {
		file_opamp_proto_rawDescData = protoimpl.X.CompressGZIP(file_opamp_proto_rawDescData)
	})
	return file_opamp_proto_rawDescData
}

var file_opamp_proto_enumTypes = make([]protoimpl.EnumInfo, 10)
var file_opamp_proto_msgTypes = make([]protoimpl.MessageInfo, 45)
var file_opamp_proto_goTypes = []interface{}{
	(AgentToServerFlags)(0),                // 0: opamp.proto.AgentToServerFlags
	(ServerToAgentFlags)(0),                // 1: opamp.proto.ServerToAgentFlags
	(ServerCapabilities)(0),                // 2: opamp.proto.ServerCapabilities
	(PackageType)(0),                       // 3: opamp.proto.PackageType
	(ServerErrorResponseType)(0),           // 4: opamp.proto.ServerErrorResponseType
	(CommandType)(0),                       // 5: opamp.proto.CommandType
	(AgentCapabilities)(0),                 // 6: opamp.proto.AgentCapabilities
	(ConnectionSettingsStatuses)(0),        // 7: opamp.proto.ConnectionSettingsStatuses
	(RemoteConfigStatuses)(0),              // 8: opamp.proto.RemoteConfigStatuses
	(PackageStatusEnum)(0),                 // 9: opamp.proto.PackageStatusEnum
	(*AgentToServer)(nil),                  // 10: opamp.proto.AgentToServer
	(*AgentDisconnect)(nil),                // 11: opamp.proto.AgentDisconnect
	(*ConnectionSettingsRequest)(nil),      // 12: opamp.proto.ConnectionSettingsRequest
	(*OpAMPConnectionSettingsRequest)(nil), // 13: opamp.proto.OpAMPConnectionSettingsRequest
	(*CertificateRequest)(nil),             // 14: opamp.proto.CertificateRequest
	(*AvailableComponents)(nil),            // 15: opamp.proto.AvailableComponents
	(*ComponentDetails)(nil),               // 16: opamp.proto.ComponentDetails
	(*ServerToAgent)(nil),                  // 17: opamp.proto.ServerToAgent
	(*OpAMPConnectionSettings)(nil),        // 18: opamp.proto.OpAMPConnectionSettings
	(*TelemetryConnectionSettings)(nil),    // 19: opamp.proto.TelemetryConnectionSettings
	(*OtherConnectionSettings)(nil),        // 20: opamp.proto.OtherConnectionSettings
	(*TLSConnectionSettings)(nil),          // 21: opamp.proto.TLSConnectionSettings
	(*ProxyConnectionSettings)(nil),        // 22: opamp.proto.ProxyConnectionSettings
	(*Headers)(nil),                        // 23: opamp.proto.Headers
	(*Header)(nil),                         // 24: opamp.proto.Header
	(*TLSCertificate)(nil),                 // 25: opamp.proto.TLSCertificate
	(*ConnectionSettingsOffers)(nil),       // 26: opamp.proto.ConnectionSettingsOffers
	(*PackagesAvailable)(nil),              // 27: opamp.proto.PackagesAvailable
	(*PackageAvailable)(nil),               // 28: opamp.proto.PackageAvailable
	(*DownloadableFile)(nil),               // 29: opamp.proto.DownloadableFile
	(*ServerErrorResponse)(nil),            // 30: opamp.proto.ServerErrorResponse
	(*RetryInfo)(nil),                      // 31: opamp.proto.RetryInfo
	(*ServerToAgentCommand)(nil),           // 32: opamp.proto.ServerToAgentCommand
	(*AgentDescription)(nil),               // 33: opamp.proto.AgentDescription
	(*ComponentHealth)(nil),                // 34: opamp.proto.ComponentHealth
	(*EffectiveConfig)(nil),                // 35: opamp.proto.EffectiveConfig
	(*RemoteConfigStatus)(nil),             // 36: opamp.proto.RemoteConfigStatus
	(*ConnectionSettingsStatus)(nil),       // 37: opamp.proto.ConnectionSettingsStatus
	(*PackageStatuses)(nil),                // 38: opamp.proto.PackageStatuses
	(*PackageStatus)(nil),                  // 39: opamp.proto.PackageStatus
	(*PackageDownloadDetails)(nil),         // 40: opamp.proto.PackageDownloadDetails
	(*AgentIdentification)(nil),            // 41: opamp.proto.AgentIdentification
	(*AgentRemoteConfig)(nil),              // 42: opamp.proto.AgentRemoteConfig
	(*AgentConfigMap)(nil),                 // 43: opamp.proto.AgentConfigMap
	(*AgentConfigFile)(nil),                // 44: opamp.proto.AgentConfigFile
	(*CustomCapabilities)(nil),             // 45: opamp.proto.CustomCapabilities
	(*CustomMessage)(nil),                  // 46: opamp.proto.CustomMessage
	nil,                                    // 47: opamp.proto.AvailableComponents.ComponentsEntry
	nil,                                    // 48: opamp.proto.ComponentDetails.SubComponentMapEntry
	nil,                                    // 49: opamp.proto.OtherConnectionSettings.OtherSettingsEntry
	nil,                                    // 50: opamp.proto.ConnectionSettingsOffers.OtherConnectionsEntry
	nil,                                    // 51: opamp.proto.PackagesAvailable.PackagesEntry
	nil,                                    // 52: opamp.proto.ComponentHealth.ComponentHealthMapEntry
	nil,                                    // 53: opamp.proto.PackageStatuses.PackagesEntry
	nil,                                    // 54: opamp.proto.AgentConfigMap.ConfigMapEntry
	(*KeyValue)(nil),                       // 55: opamp.proto.KeyValue
}
var file_opamp_proto_depIdxs = []int32{
	33, // 0: opamp.proto.AgentToServer.agent_description:type_name -> opamp.proto.AgentDescription
	34, // 1: opamp.proto.AgentToServer.health:type_name -> opamp.proto.ComponentHealth
	35, // 2: opamp.proto.AgentToServer.effective_config:type_name -> opamp.proto.EffectiveConfig
	36, // 3: opamp.proto.AgentToServer.remote_config_status:type_name -> opamp.proto.RemoteConfigStatus
	38, // 4: opamp.proto.AgentToServer.package_statuses:type_name -> opamp.proto.PackageStatuses
	11, // 5: opamp.proto.AgentToServer.agent_disconnect:type_name -> opamp.proto.AgentDisconnect
	12, // 6: opamp.proto.AgentToServer.connection_settings_request:type_name -> opamp.proto.ConnectionSettingsRequest
	45, // 7: opamp.proto.AgentToServer.custom_capabilities:type_name -> opamp.proto.CustomCapabilities
	46, // 8: opamp.proto.AgentToServer.custom_message:type_name -> opamp.proto.CustomMessage
	15, // 9: opamp.proto.AgentToServer.available_components:type_name -> opamp.proto.AvailableComponents
	37, // 10: opamp.proto.AgentToServer.connection_settings_status:type_name -> opamp.proto.ConnectionSettingsStatus
	13, // 11: opamp.proto.ConnectionSettingsRequest.opamp:type_name -> opamp.proto.OpAMPConnectionSettingsRequest
	14, // 12: opamp.proto.OpAMPConnectionSettingsRequest.certificate_request:type_name -> opamp.proto.CertificateRequest
	47, // 13: opamp.proto.AvailableComponents.components:type_name -> opamp.proto.AvailableComponents.ComponentsEntry
	55, // 14: opamp.proto.ComponentDetails.metadata:type_name -> opamp.proto.KeyValue
	48, // 15: opamp.proto.ComponentDetails.sub_component_map:type_name -> opamp.proto.ComponentDetails.SubComponentMapEntry
	30, // 16: opamp.proto.ServerToAgent.error_response:type_name -> opamp.proto.ServerErrorResponse
	42, // 17: opamp.proto.ServerToAgent.remote_config:type_name -> opamp.proto.AgentRemoteConfig
	26, // 18: opamp.proto.ServerToAgent.connection_settings:type_name -> opamp.proto.ConnectionSettingsOffers
	27, // 19: opamp.proto.ServerToAgent.packages_available:type_name -> opamp.proto.PackagesAvailable
	41, // 20: opamp.proto.ServerToAgent.agent_identification:type_name -> opamp.proto.AgentIdentification
	32, // 21: opamp.proto.ServerToAgent.command:type_name -> opamp.proto.ServerToAgentCommand
	45, // 22: opamp.proto.ServerToAgent.custom_capabilities:type_name -> opamp.proto.CustomCapabilities
	46, // 23: opamp.proto.ServerToAgent.custom_message:type_name -> opamp.proto.CustomMessage
	23, // 24: opamp.proto.OpAMPConnectionSettings.headers:type_name -> opamp.proto.Headers
	25, // 25: opamp.proto.OpAMPConnectionSettings.certificate:type_name -> opamp.proto.TLSCertificate
	21, // 26: opamp.proto.OpAMPConnectionSettings.tls:type_name -> opamp.proto.TLSConnectionSettings
	22, // 27: opamp.proto.OpAMPConnectionSettings.proxy:type_name -> opamp.proto.ProxyConnectionSettings
	23, // 28: opamp.proto.TelemetryConnectionSettings.headers:type_name -> opamp.proto.Headers
	25, // 29: opamp.proto.TelemetryConnectionSettings.certificate:type_name -> opamp.proto.TLSCertificate
	21, // 30: opamp.proto.TelemetryConnectionSettings.tls:type_name -> opamp.proto.TLSConnectionSettings
	22, // 31: opamp.proto.TelemetryConnectionSettings.proxy:type_name -> opamp.proto.ProxyConnectionSettings
	23, // 32: opamp.proto.OtherConnectionSettings.headers:type_name -> opamp.proto.Headers
	25, // 33: opamp.proto.OtherConnectionSettings.certificate:type_name -> opamp.proto.TLSCertificate
	49, // 34: opamp.proto.OtherConnectionSettings.other_settings:type_name -> opamp.proto.OtherConnectionSettings.OtherSettingsEntry
	21, // 35: opamp.proto.OtherConnectionSettings.tls:type_name -> opamp.proto.TLSConnectionSettings
	22, // 36: opamp.proto.OtherConnectionSettings.proxy:type_name -> opamp.proto.ProxyConnectionSettings
	23, // 37: opamp.proto.ProxyConnectionSettings.connect_headers:type_name -> opamp.proto.Headers
	24, // 38: opamp.proto.Headers.headers:type_name -> opamp.proto.Header
	18, // 39: opamp.proto.ConnectionSettingsOffers.opamp:type_name -> opamp.proto.OpAMPConnectionSettings
	19, // 40: opamp.proto.ConnectionSettingsOffers.own_metrics:type_name -> opamp.proto.TelemetryConnectionSettings
	19, // 41: opamp.proto.ConnectionSettingsOffers.own_traces:type_name -> opamp.proto.TelemetryConnectionSettings
	19, // 42: opamp.proto.ConnectionSettingsOffers.own_logs:type_name -> opamp.proto.TelemetryConnectionSettings
	50, // 43: opamp.proto.ConnectionSettingsOffers.other_connections:type_name -> opamp.proto.ConnectionSettingsOffers.OtherConnectionsEntry
	51, // 44: opamp.proto.PackagesAvailable.packages:type_name -> opamp.proto.PackagesAvailable.PackagesEntry
	3,  // 45: opamp.proto.PackageAvailable.type:type_name -> opamp.proto.PackageType
	29, // 46: opamp.proto.PackageAvailable.file:type_name -> opamp.proto.DownloadableFile
	23, // 47: opamp.proto.DownloadableFile.headers:type_name -> opamp.proto.Headers
	4,  // 48: opamp.proto.ServerErrorResponse.type:type_name -> opamp.proto.ServerErrorResponseType
	31, // 49: opamp.proto.ServerErrorResponse.retry_info:type_name -> opamp.proto.RetryInfo
	5,  // 50: opamp.proto.ServerToAgentCommand.type:type_name -> opamp.proto.CommandType
	55, // 51: opamp.proto.AgentDescription.identifying_attributes:type_name -> opamp.proto.KeyValue
	55, // 52: opamp.proto.AgentDescription.non_identifying_attributes:type_name -> opamp.proto.KeyValue
	52, // 53: opamp.proto.ComponentHealth.component_health_map:type_name -> opamp.proto.ComponentHealth.ComponentHealthMapEntry
	43, // 54: opamp.proto.EffectiveConfig.config_map:type_name -> opamp.proto.AgentConfigMap
	8,  // 55: opamp.proto.RemoteConfigStatus.status:type_name -> opamp.proto.RemoteConfigStatuses
	7,  // 56: opamp.proto.ConnectionSettingsStatus.status:type_name -> opamp.proto.ConnectionSettingsStatuses
	53, // 57: opamp.proto.PackageStatuses.packages:type_name -> opamp.proto.PackageStatuses.PackagesEntry
	9,  // 58: opamp.proto.PackageStatus.status:type_name -> opamp.proto.PackageStatusEnum
	40, // 59: opamp.proto.PackageStatus.download_details:type_name -> opamp.proto.PackageDownloadDetails
	43, // 60: opamp.proto.AgentRemoteConfig.config:type_name -> opamp.proto.AgentConfigMap
	54, // 61: opamp.proto.AgentConfigMap.config_map:type_name -> opamp.proto.AgentConfigMap.ConfigMapEntry
	16, // 62: opamp.proto.AvailableComponents.ComponentsEntry.value:type_name -> opamp.proto.ComponentDetails
	16, // 63: opamp.proto.ComponentDetails.SubComponentMapEntry.value:type_name -> opamp.proto.ComponentDetails
	20, // 64: opamp.proto.ConnectionSettingsOffers.OtherConnectionsEntry.value:type_name -> opamp.proto.OtherConnectionSettings
	28, // 65: opamp.proto.PackagesAvailable.PackagesEntry.value:type_name -> opamp.proto.PackageAvailable
	34, // 66: opamp.proto.ComponentHealth.ComponentHealthMapEntry.value:type_name -> opamp.proto.ComponentHealth
	39, // 67: opamp.proto.PackageStatuses.PackagesEntry.value:type_name -> opamp.proto.PackageStatus
	44, // 68: opamp.proto.AgentConfigMap.ConfigMapEntry.value:type_name -> opamp.proto.AgentConfigFile
	69, // [69:69] is the sub-list for method output_type
	69, // [69:69] is the sub-list for method input_type
	69, // [69:69] is the sub-list for extension type_name
	69, // [69:69] is the sub-list for extension extendee
	0,  // [0:69] is the sub-list for field type_name
}

func init() { file_opamp_proto_init() }
func file_opamp_proto_init() {
	if File_opamp_proto != nil {
		return
	}
	file_anyvalue_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_opamp_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AgentToServer); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_opamp_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AgentDisconnect); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_opamp_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ConnectionSettingsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_opamp_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OpAMPConnectionSettingsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_opamp_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CertificateRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_opamp_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AvailableComponents); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_opamp_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ComponentDetails); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_opamp_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ServerToAgent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_opamp_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OpAMPConnectionSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_opamp_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TelemetryConnectionSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_opamp_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OtherConnectionSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_opamp_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TLSConnectionSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_opamp_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ProxyConnectionSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_opamp_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Headers); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_opamp_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Header); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_opamp_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TLSCertificate); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_opamp_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ConnectionSettingsOffers); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_opamp_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PackagesAvailable); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_opamp_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PackageAvailable); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_opamp_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DownloadableFile); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_opamp_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ServerErrorResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_opamp_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RetryInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_opamp_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ServerToAgentCommand); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_opamp_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AgentDescription); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_opamp_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ComponentHealth); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_opamp_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EffectiveConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_opamp_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RemoteConfigStatus); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_opamp_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ConnectionSettingsStatus); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_opamp_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PackageStatuses); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_opamp_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PackageStatus); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_opamp_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PackageDownloadDetails); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_opamp_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AgentIdentification); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_opamp_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AgentRemoteConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_opamp_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AgentConfigMap); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_opamp_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AgentConfigFile); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_opamp_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CustomCapabilities); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_opamp_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CustomMessage); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_opamp_proto_msgTypes[20].OneofWrappers = []interface{}{
		(*ServerErrorResponse_RetryInfo)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_opamp_proto_rawDesc,
			NumEnums:      10,
			NumMessages:   45,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_opamp_proto_goTypes,
		DependencyIndexes: file_opamp_proto_depIdxs,
		EnumInfos:         file_opamp_proto_enumTypes,
		MessageInfos:      file_opamp_proto_msgTypes,
	}.Build()
	File_opamp_proto = out.File
	file_opamp_proto_rawDesc = nil
	file_opamp_proto_goTypes = nil
	file_opamp_proto_depIdxs = nil
}
