/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, vocoder, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_vocoder_cvsd_encode_sb = R"doc(This block performs CVSD audio encoding. Its design and implementation is modeled after the CVSD encoder/decoder specifications defined in the Bluetooth standard.

CVSD is a method for encoding speech that seeks to reduce the bandwidth required for digital voice transmission. CVSD takes advantage of strong correlation between samples, quantizing the difference in amplitude between two consecutive samples. This difference requires fewer quantization levels as compared to other methods that quantize the actual amplitude level, reducing the bandwidth. CVSD employs a two level quantizer (one bit) and an adaptive algorithm that allows for continuous step size adjustment.


The coder can represent low amplitude signals with accuracy without sacrificing performance on large amplitude signals, a trade off that occurs in some non-adaptive modulations.


The CVSD encoder effectively provides 8-to-1 compression. More specifically, each incoming audio sample is compared to an internal reference value. If the input is greater or equal to the reference, the encoder outputs a \"1\" bit. If the input is less than the reference, the encoder outputs a \"0\" bit. The reference value is then updated accordingly based on the frequency of outputted \"1\" or \"0\" bits. By grouping 8 outputs bits together, the encoder essentially produce one output byte for every 8 input audio samples.


This encoder requires that input audio samples are 2-byte short signed integers. The result bandwidth conversion, therefore, is 16 input bytes of raw audio data to 1 output byte of encoded audio data.


The CVSD encoder module must be prefixed by an up-converter to over-sample the audio data prior to encoding. The Bluetooth standard specifically calls for a 1-to-8 interpolating up-converter. While this reduces the overall compression of the codec, this is required so that the encoder can accurately compute the slope between adjacent audio samples and correctly update its internal reference value.


References:

Constructor Specific Documentation:

Constructor parameters to initialize the CVSD encoder. The default values are modeled after the Bluetooth standard and should not be changed except by an advanced user.

Args:
    min_step : Minimum step size used to update the internal reference. Default: \"10\"
    max_step : Maximum step size used to update the internal reference. Default: \"1280\"
    step_decay : Decay factor applied to step size when there is not a run of J output 1s or 0s. Default: \"0.9990234375\" (i.e. 1-1/1024)
    accum_decay : Decay factor applied to the internal reference during every iteration of the codec. Default: \"0.96875\" (i.e. 1-1/32)
    K : Size of shift register; the number of output bits remembered by codec (must be <= to 32). Default: \"32\"
    J : Number of bits in the shift register that are equal; i.e. the size of a run of 1s, 0s. Default: \"4\"
    pos_accum_max : Maximum integer value allowed for the internal reference. Default: \"32767\" (2^15 - 1 or MAXSHORT)
    neg_accum_max : Minimum integer value allowed for the internal reference. Default: \"-32767\" (-2^15 + 1 or MINSHORT+1))doc";


static const char* __doc_gr_vocoder_cvsd_encode_sb_cvsd_encode_sb_0 = R"doc()doc";


static const char* __doc_gr_vocoder_cvsd_encode_sb_cvsd_encode_sb_1 = R"doc()doc";


static const char* __doc_gr_vocoder_cvsd_encode_sb_make = R"doc(This block performs CVSD audio encoding. Its design and implementation is modeled after the CVSD encoder/decoder specifications defined in the Bluetooth standard.

CVSD is a method for encoding speech that seeks to reduce the bandwidth required for digital voice transmission. CVSD takes advantage of strong correlation between samples, quantizing the difference in amplitude between two consecutive samples. This difference requires fewer quantization levels as compared to other methods that quantize the actual amplitude level, reducing the bandwidth. CVSD employs a two level quantizer (one bit) and an adaptive algorithm that allows for continuous step size adjustment.


The coder can represent low amplitude signals with accuracy without sacrificing performance on large amplitude signals, a trade off that occurs in some non-adaptive modulations.


The CVSD encoder effectively provides 8-to-1 compression. More specifically, each incoming audio sample is compared to an internal reference value. If the input is greater or equal to the reference, the encoder outputs a \"1\" bit. If the input is less than the reference, the encoder outputs a \"0\" bit. The reference value is then updated accordingly based on the frequency of outputted \"1\" or \"0\" bits. By grouping 8 outputs bits together, the encoder essentially produce one output byte for every 8 input audio samples.


This encoder requires that input audio samples are 2-byte short signed integers. The result bandwidth conversion, therefore, is 16 input bytes of raw audio data to 1 output byte of encoded audio data.


The CVSD encoder module must be prefixed by an up-converter to over-sample the audio data prior to encoding. The Bluetooth standard specifically calls for a 1-to-8 interpolating up-converter. While this reduces the overall compression of the codec, this is required so that the encoder can accurately compute the slope between adjacent audio samples and correctly update its internal reference value.


References:

Constructor Specific Documentation:

Constructor parameters to initialize the CVSD encoder. The default values are modeled after the Bluetooth standard and should not be changed except by an advanced user.

Args:
    min_step : Minimum step size used to update the internal reference. Default: \"10\"
    max_step : Maximum step size used to update the internal reference. Default: \"1280\"
    step_decay : Decay factor applied to step size when there is not a run of J output 1s or 0s. Default: \"0.9990234375\" (i.e. 1-1/1024)
    accum_decay : Decay factor applied to the internal reference during every iteration of the codec. Default: \"0.96875\" (i.e. 1-1/32)
    K : Size of shift register; the number of output bits remembered by codec (must be <= to 32). Default: \"32\"
    J : Number of bits in the shift register that are equal; i.e. the size of a run of 1s, 0s. Default: \"4\"
    pos_accum_max : Maximum integer value allowed for the internal reference. Default: \"32767\" (2^15 - 1 or MAXSHORT)
    neg_accum_max : Minimum integer value allowed for the internal reference. Default: \"-32767\" (-2^15 + 1 or MINSHORT+1))doc";


static const char* __doc_gr_vocoder_cvsd_encode_sb_min_step = R"doc()doc";


static const char* __doc_gr_vocoder_cvsd_encode_sb_max_step = R"doc()doc";


static const char* __doc_gr_vocoder_cvsd_encode_sb_step_decay = R"doc()doc";


static const char* __doc_gr_vocoder_cvsd_encode_sb_accum_decay = R"doc()doc";


static const char* __doc_gr_vocoder_cvsd_encode_sb_K = R"doc()doc";


static const char* __doc_gr_vocoder_cvsd_encode_sb_J = R"doc()doc";


static const char* __doc_gr_vocoder_cvsd_encode_sb_pos_accum_max = R"doc()doc";


static const char* __doc_gr_vocoder_cvsd_encode_sb_neg_accum_max = R"doc()doc";
