/* storage-row.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from storage-row.vala, do not modify */

/* This file is part of GNOME Boxes. License: LGPLv2+*/

#include <handy.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <libvirt-gobject/libvirt-gobject.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>
#include <libvirt-gconfig/libvirt-gconfig.h>
#include <osinfo/osinfo.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define BOXES_TYPE_MEMORY_ROW (boxes_memory_row_get_type ())
#define BOXES_MEMORY_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_MEMORY_ROW, BoxesMemoryRow))
#define BOXES_MEMORY_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_MEMORY_ROW, BoxesMemoryRowClass))
#define BOXES_IS_MEMORY_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_MEMORY_ROW))
#define BOXES_IS_MEMORY_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_MEMORY_ROW))
#define BOXES_MEMORY_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_MEMORY_ROW, BoxesMemoryRowClass))

typedef struct _BoxesMemoryRow BoxesMemoryRow;
typedef struct _BoxesMemoryRowClass BoxesMemoryRowClass;
typedef struct _BoxesMemoryRowPrivate BoxesMemoryRowPrivate;

#define BOXES_TYPE_STORAGE_ROW (boxes_storage_row_get_type ())
#define BOXES_STORAGE_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_STORAGE_ROW, BoxesStorageRow))
#define BOXES_STORAGE_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_STORAGE_ROW, BoxesStorageRowClass))
#define BOXES_IS_STORAGE_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_STORAGE_ROW))
#define BOXES_IS_STORAGE_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_STORAGE_ROW))
#define BOXES_STORAGE_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_STORAGE_ROW, BoxesStorageRowClass))

typedef struct _BoxesStorageRow BoxesStorageRow;
typedef struct _BoxesStorageRowClass BoxesStorageRowClass;
typedef struct _BoxesStorageRowPrivate BoxesStorageRowPrivate;

#define BOXES_TYPE_COLLECTION_ITEM (boxes_collection_item_get_type ())
#define BOXES_COLLECTION_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_COLLECTION_ITEM, BoxesCollectionItem))
#define BOXES_COLLECTION_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_COLLECTION_ITEM, BoxesCollectionItemClass))
#define BOXES_IS_COLLECTION_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_COLLECTION_ITEM))
#define BOXES_IS_COLLECTION_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_COLLECTION_ITEM))
#define BOXES_COLLECTION_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_COLLECTION_ITEM, BoxesCollectionItemClass))

typedef struct _BoxesCollectionItem BoxesCollectionItem;
typedef struct _BoxesCollectionItemClass BoxesCollectionItemClass;

#define BOXES_TYPE_MACHINE (boxes_machine_get_type ())
#define BOXES_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_MACHINE, BoxesMachine))
#define BOXES_MACHINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_MACHINE, BoxesMachineClass))
#define BOXES_IS_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_MACHINE))
#define BOXES_IS_MACHINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_MACHINE))
#define BOXES_MACHINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_MACHINE, BoxesMachineClass))

typedef struct _BoxesMachine BoxesMachine;
typedef struct _BoxesMachineClass BoxesMachineClass;

#define BOXES_TYPE_LIBVIRT_MACHINE (boxes_libvirt_machine_get_type ())
#define BOXES_LIBVIRT_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_LIBVIRT_MACHINE, BoxesLibvirtMachine))
#define BOXES_LIBVIRT_MACHINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_LIBVIRT_MACHINE, BoxesLibvirtMachineClass))
#define BOXES_IS_LIBVIRT_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_LIBVIRT_MACHINE))
#define BOXES_IS_LIBVIRT_MACHINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_LIBVIRT_MACHINE))
#define BOXES_LIBVIRT_MACHINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_LIBVIRT_MACHINE, BoxesLibvirtMachineClass))

typedef struct _BoxesLibvirtMachine BoxesLibvirtMachine;
typedef struct _BoxesLibvirtMachineClass BoxesLibvirtMachineClass;
enum  {
	BOXES_STORAGE_ROW_0_PROPERTY,
	BOXES_STORAGE_ROW_NUM_PROPERTIES
};
static GParamSpec* boxes_storage_row_properties[BOXES_STORAGE_ROW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define __vala_GVirStorageVolInfo_free0(var) ((var == NULL) ? NULL : (var = (_vala_GVirStorageVolInfo_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __vala_GVirStoragePoolInfo_free0(var) ((var == NULL) ? NULL : (var = (_vala_GVirStoragePoolInfo_free (var), NULL)))
typedef struct _Block63Data Block63Data;
typedef struct _BoxesStorageRowOnSpinButtonChangedData BoxesStorageRowOnSpinButtonChangedData;

#define BOXES_TYPE_VM_CREATOR (boxes_vm_creator_get_type ())
#define BOXES_VM_CREATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_VM_CREATOR, BoxesVMCreator))
#define BOXES_VM_CREATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_VM_CREATOR, BoxesVMCreatorClass))
#define BOXES_IS_VM_CREATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_VM_CREATOR))
#define BOXES_IS_VM_CREATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_VM_CREATOR))
#define BOXES_VM_CREATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_VM_CREATOR, BoxesVMCreatorClass))

typedef struct _BoxesVMCreator BoxesVMCreator;
typedef struct _BoxesVMCreatorClass BoxesVMCreatorClass;

struct _BoxesMemoryRow {
	HdyActionRow parent_instance;
	BoxesMemoryRowPrivate * priv;
	GtkStack* stack;
	GtkLabel* used_label;
	GtkSpinButton* spin_button;
};

struct _BoxesMemoryRowClass {
	HdyActionRowClass parent_class;
};

struct _BoxesStorageRow {
	BoxesMemoryRow parent_instance;
	BoxesStorageRowPrivate * priv;
};

struct _BoxesStorageRowClass {
	BoxesMemoryRowClass parent_class;
};

struct _BoxesStorageRowPrivate {
	BoxesLibvirtMachine* machine;
	GVirDomainDisk* external_disk;
};

struct _Block63Data {
	int _ref_count_;
	BoxesStorageRow* self;
	GFile* disk;
};

struct _BoxesStorageRowOnSpinButtonChangedData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	BoxesStorageRow* self;
	guint64 storage;
	GtkSpinButton* _tmp0_;
	BoxesLibvirtMachine* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GVirDomainDisk* disk;
	BoxesLibvirtMachine* _tmp4_;
	GVirDomainDisk* _tmp5_;
	GVirDomainDisk* _tmp6_;
	guint64 size;
	GVirDomainDisk* _tmp7_;
	GVirStoragePool* pool;
	BoxesLibvirtMachine* _tmp8_;
	GVirConnection* _tmp9_;
	GVirConnection* _tmp10_;
	GVirStoragePool* _tmp11_;
	GVirStoragePool* _tmp12_;
	BoxesLibvirtMachine* _tmp13_;
	GError* _error_;
	BoxesLibvirtMachine* _tmp14_;
	GVirStorageVol* _tmp15_;
	GVirStorageVol* _tmp16_;
	const gchar* _tmp17_;
	GError* _tmp18_;
	const gchar* _tmp19_;
	GError* _inner_error0_;
};

static gint BoxesStorageRow_private_offset;
static gpointer boxes_storage_row_parent_class = NULL;

VALA_EXTERN GType boxes_memory_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesMemoryRow, g_object_unref)
VALA_EXTERN GType boxes_storage_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesStorageRow, g_object_unref)
VALA_EXTERN GType boxes_collection_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesCollectionItem, g_object_unref)
VALA_EXTERN GType boxes_machine_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesMachine, g_object_unref)
VALA_EXTERN GType boxes_libvirt_machine_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesLibvirtMachine, g_object_unref)
VALA_EXTERN void boxes_storage_row_setup (BoxesStorageRow* self,
                              BoxesLibvirtMachine* machine);
VALA_EXTERN GVirStorageVol* boxes_libvirt_machine_get_storage_volume (BoxesLibvirtMachine* self);
VALA_EXTERN GVirDomainDisk* boxes_libvirt_machine_get_domain_disk (BoxesLibvirtMachine* self,
                                                       GError** error);
VALA_EXTERN gboolean boxes_libvirt_machine_get_importing (BoxesLibvirtMachine* self);
static void boxes_storage_row_setup_internal_storage (BoxesStorageRow* self);
static void boxes_storage_row_setup_external_storage (BoxesStorageRow* self);
VALA_EXTERN GVirStoragePool* boxes_get_storage_pool (GVirConnection* connection);
VALA_EXTERN GVirConnection* boxes_libvirt_machine_get_connection (BoxesLibvirtMachine* self);
static void _vala_GVirStorageVolInfo_free (GVirStorageVolInfo* self);
static void _vala_GVirStoragePoolInfo_free (GVirStoragePoolInfo* self);
VALA_EXTERN const gchar* boxes_collection_item_get_name (BoxesCollectionItem* self);
static void boxes_storage_row_on_spin_button_changed (BoxesStorageRow* self,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_);
static void boxes_storage_row_on_spin_button_changed_finish (BoxesStorageRow* self,
                                                      GAsyncResult* _res_);
static void _boxes_storage_row_on_spin_button_changed_gtk_spin_button_value_changed (GtkSpinButton* _sender,
                                                                              gpointer self);
static Block63Data* block63_data_ref (Block63Data* _data63_);
static void block63_data_unref (void * _userdata_);
static void __lambda69_ (Block63Data* _data63_,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda69__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void boxes_storage_row_on_spin_button_changed_data_free (gpointer _data);
static gboolean boxes_storage_row_on_spin_button_changed_co (BoxesStorageRowOnSpinButtonChangedData* _data_);
VALA_EXTERN gboolean boxes_machine_get_is_running (BoxesMachine* self);
static void boxes_storage_row_resize_storage_volume (BoxesStorageRow* self,
                                              guint64 size,
                                              GError** error);
static void boxes_storage_row_on_spin_button_changed_ready (GObject* source_object,
                                                     GAsyncResult* _res_,
                                                     gpointer _user_data_);
VALA_EXTERN void boxes_libvirt_machine_update_domain_config (BoxesLibvirtMachine* self);
VALA_EXTERN GType boxes_vm_creator_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesVMCreator, g_object_unref)
VALA_EXTERN BoxesVMCreator* boxes_libvirt_machine_get_vm_creator (BoxesLibvirtMachine* self);
VALA_EXTERN void boxes_libvirt_machine_set_storage_volume (BoxesLibvirtMachine* self,
                                               GVirStorageVol* value);
VALA_EXTERN BoxesStorageRow* boxes_storage_row_new (void);
VALA_EXTERN BoxesStorageRow* boxes_storage_row_construct (GType object_type);
VALA_EXTERN BoxesMemoryRow* boxes_memory_row_new (void);
VALA_EXTERN BoxesMemoryRow* boxes_memory_row_construct (GType object_type);
static void boxes_storage_row_finalize (GObject * obj);
static GType boxes_storage_row_get_type_once (void);

static inline gpointer
boxes_storage_row_get_instance_private (BoxesStorageRow* self)
{
	return G_STRUCT_MEMBER_P (self, BoxesStorageRow_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
boxes_storage_row_setup (BoxesStorageRow* self,
                         BoxesLibvirtMachine* machine)
{
	BoxesLibvirtMachine* _tmp0_;
	gboolean storage_is_internal = FALSE;
	GVirStorageVol* _tmp1_;
	GVirStorageVol* _tmp2_;
	gboolean _tmp8_ = FALSE;
	gboolean has_disk = FALSE;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_;
	gboolean _tmp12_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (machine != NULL);
	_tmp0_ = _g_object_ref0 (machine);
	_g_object_unref0 (self->priv->machine);
	self->priv->machine = _tmp0_;
	_tmp1_ = boxes_libvirt_machine_get_storage_volume (machine);
	_tmp2_ = _tmp1_;
	storage_is_internal = _tmp2_ != NULL;
	if (!storage_is_internal) {
		{
			GVirDomainDisk* _tmp3_ = NULL;
			GVirDomainDisk* _tmp4_;
			GVirDomainDisk* _tmp5_;
			_tmp4_ = boxes_libvirt_machine_get_domain_disk (machine, &_inner_error0_);
			_tmp3_ = _tmp4_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp5_ = _tmp3_;
			_tmp3_ = NULL;
			_g_object_unref0 (self->priv->external_disk);
			self->priv->external_disk = _tmp5_;
			_g_object_unref0 (_tmp3_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* _error_ = NULL;
			GError* _tmp6_;
			const gchar* _tmp7_;
			_error_ = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp6_ = _error_;
			_tmp7_ = _tmp6_->message;
			g_warning ("storage-row.vala:16: Failed to obtain domain disk: %s", _tmp7_);
			gtk_widget_set_visible ((GtkWidget*) self, FALSE);
			_g_error_free0 (_error_);
			return;
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	if (storage_is_internal) {
		_tmp8_ = TRUE;
	} else {
		GVirDomainDisk* _tmp9_;
		_tmp9_ = self->priv->external_disk;
		_tmp8_ = _tmp9_ != NULL;
	}
	has_disk = _tmp8_;
	_tmp11_ = boxes_libvirt_machine_get_importing (machine);
	_tmp12_ = _tmp11_;
	if (_tmp12_) {
		_tmp10_ = TRUE;
	} else {
		_tmp10_ = !has_disk;
	}
	if (_tmp10_) {
		gtk_widget_set_visible ((GtkWidget*) self, FALSE);
		return;
	}
	if (storage_is_internal) {
		boxes_storage_row_setup_internal_storage (self);
	} else {
		boxes_storage_row_setup_external_storage (self);
	}
}

static void
_vala_GVirStorageVolInfo_free (GVirStorageVolInfo* self)
{
	g_boxed_free (gvir_storage_vol_info_get_type (), self);
}

static void
_vala_GVirStoragePoolInfo_free (GVirStoragePoolInfo* self)
{
	g_boxed_free (gvir_storage_pool_info_get_type (), self);
}

static void
_boxes_storage_row_on_spin_button_changed_gtk_spin_button_value_changed (GtkSpinButton* _sender,
                                                                         gpointer self)
{
	boxes_storage_row_on_spin_button_changed ((BoxesStorageRow*) self, NULL, NULL);
}

static void
boxes_storage_row_setup_internal_storage (BoxesStorageRow* self)
{
	GtkSpinButton* _tmp27_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GVirStorageVolInfo* volume_info = NULL;
		BoxesLibvirtMachine* _tmp0_;
		GVirStorageVol* _tmp1_;
		GVirStorageVol* _tmp2_;
		GVirStorageVolInfo* _tmp3_;
		GVirStoragePool* pool = NULL;
		BoxesLibvirtMachine* _tmp4_;
		GVirConnection* _tmp5_;
		GVirConnection* _tmp6_;
		GVirStoragePool* _tmp7_;
		GVirStoragePoolInfo* pool_info = NULL;
		GVirStoragePool* _tmp8_;
		GVirStoragePoolInfo* _tmp9_;
		guint64 min_storage = 0ULL;
		GVirStorageVolInfo* _tmp10_;
		guint64 max_storage = 0ULL;
		GVirStoragePoolInfo* _tmp11_;
		GVirStorageVolInfo* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		GtkSpinButton* _tmp17_;
		GtkSpinButton* _tmp18_;
		GVirStorageVolInfo* _tmp19_;
		GtkSpinButton* _tmp20_;
		GVirStorageVolInfo* _tmp21_;
		_tmp0_ = self->priv->machine;
		_tmp1_ = boxes_libvirt_machine_get_storage_volume (_tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = gvir_storage_vol_get_info (_tmp2_, &_inner_error0_);
		volume_info = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp4_ = self->priv->machine;
		_tmp5_ = boxes_libvirt_machine_get_connection (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = boxes_get_storage_pool (_tmp6_);
		pool = _tmp7_;
		_tmp8_ = pool;
		_tmp9_ = gvir_storage_pool_get_info (_tmp8_, &_inner_error0_);
		pool_info = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (pool);
			__vala_GVirStorageVolInfo_free0 (volume_info);
			goto __catch0_g_error;
		}
		_tmp10_ = volume_info;
		min_storage = _tmp10_->allocation;
		_tmp11_ = pool_info;
		max_storage = min_storage + _tmp11_->available;
		_tmp12_ = volume_info;
		_tmp13_ = g_format_size_full (_tmp12_->allocation, G_FORMAT_SIZE_DEFAULT);
		_tmp14_ = _tmp13_;
		_tmp15_ = g_strdup_printf (_ ("Used %s."), _tmp14_);
		_tmp16_ = _tmp15_;
		hdy_action_row_set_subtitle ((HdyActionRow*) self, _tmp16_);
		_g_free0 (_tmp16_);
		_g_free0 (_tmp14_);
		if (min_storage >= max_storage) {
			hdy_action_row_set_subtitle ((HdyActionRow*) self, _ ("There is not enough space on your machine to increase the maximum disk" \
" size."));
		}
		_tmp17_ = ((BoxesMemoryRow*) self)->spin_button;
		gtk_spin_button_set_range (_tmp17_, (gdouble) min_storage, (gdouble) max_storage);
		_tmp18_ = ((BoxesMemoryRow*) self)->spin_button;
		_tmp19_ = volume_info;
		gtk_spin_button_set_increments (_tmp18_, (gdouble) ((256 * 1000) * 1000), (gdouble) _tmp19_->allocation);
		_tmp20_ = ((BoxesMemoryRow*) self)->spin_button;
		_tmp21_ = volume_info;
		gtk_spin_button_set_value (_tmp20_, (gdouble) _tmp21_->capacity);
		__vala_GVirStoragePoolInfo_free0 (pool_info);
		_g_object_unref0 (pool);
		__vala_GVirStorageVolInfo_free0 (volume_info);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		BoxesLibvirtMachine* _tmp22_;
		const gchar* _tmp23_;
		const gchar* _tmp24_;
		GError* _tmp25_;
		const gchar* _tmp26_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp22_ = self->priv->machine;
		_tmp23_ = boxes_collection_item_get_name ((BoxesCollectionItem*) _tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = _error_;
		_tmp26_ = _tmp25_->message;
		g_warning ("storage-row.vala:56: Failed to obtain virtual resources for '%s', %s", _tmp24_, _tmp26_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp27_ = ((BoxesMemoryRow*) self)->spin_button;
	g_signal_connect_object (_tmp27_, "value-changed", (GCallback) _boxes_storage_row_on_spin_button_changed_gtk_spin_button_value_changed, self, 0);
}

static Block63Data*
block63_data_ref (Block63Data* _data63_)
{
	g_atomic_int_inc (&_data63_->_ref_count_);
	return _data63_;
}

static void
block63_data_unref (void * _userdata_)
{
	Block63Data* _data63_;
	_data63_ = (Block63Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data63_->_ref_count_)) {
		BoxesStorageRow* self;
		self = _data63_->self;
		_g_object_unref0 (_data63_->disk);
		_g_object_unref0 (self);
		g_slice_free (Block63Data, _data63_);
	}
}

static void
__lambda69_ (Block63Data* _data63_,
             GObject* obj,
             GAsyncResult* res)
{
	BoxesStorageRow* self;
	GError* _inner_error0_ = NULL;
	self = _data63_->self;
	g_return_if_fail (res != NULL);
	{
		GFileInfo* info = NULL;
		GFileInfo* _tmp0_;
		GtkLabel* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp0_ = g_file_query_info_finish (_data63_->disk, res, &_inner_error0_);
		info = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp1_ = ((BoxesMemoryRow*) self)->used_label;
		_tmp2_ = g_format_size_full ((guint64) g_file_info_get_size (info), G_FORMAT_SIZE_IEC_UNITS);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_strdup_printf (_ ("Used %s"), _tmp3_);
		_tmp5_ = _tmp4_;
		gtk_label_set_label (_tmp1_, _tmp5_);
		_g_free0 (_tmp5_);
		_g_free0 (_tmp3_);
		_g_object_unref0 (info);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		gchar* _tmp6_;
		gchar* _tmp7_;
		GError* _tmp8_;
		const gchar* _tmp9_;
		GError* _tmp10_;
		const gchar* _tmp11_;
		GtkLabel* _tmp12_;
		GtkSpinButton* _tmp13_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = g_file_get_path (_data63_->disk);
		_tmp7_ = _tmp6_;
		_tmp8_ = _error_;
		_tmp9_ = _tmp8_->message;
		g_message ("storage-row.vala:79: Failed to calculate disk size for '%s': %s", _tmp7_, _tmp9_);
		_g_free0 (_tmp7_);
		_tmp10_ = _error_;
		_tmp11_ = _tmp10_->message;
		hdy_action_row_set_subtitle ((HdyActionRow*) self, _tmp11_);
		_tmp12_ = ((BoxesMemoryRow*) self)->used_label;
		_tmp13_ = ((BoxesMemoryRow*) self)->spin_button;
		gtk_widget_set_visible ((GtkWidget*) _tmp13_, FALSE);
		gtk_widget_set_visible ((GtkWidget*) _tmp12_, FALSE);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda69__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda69_ (self, source_object, res);
	block63_data_unref (self);
}

static void
boxes_storage_row_setup_external_storage (BoxesStorageRow* self)
{
	Block63Data* _data63_;
	GVirConfigDomainDisk* disk_config = NULL;
	GVirDomainDisk* _tmp0_;
	GVirConfigDomainDevice* _tmp1_;
	GVirConfigDomainDevice* _tmp2_;
	GVirConfigDomainDisk* _tmp3_;
	const gchar* _tmp4_;
	GFile* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GtkStack* _tmp8_;
	GtkLabel* _tmp9_;
	g_return_if_fail (self != NULL);
	_data63_ = g_slice_new0 (Block63Data);
	_data63_->_ref_count_ = 1;
	_data63_->self = g_object_ref (self);
	_tmp0_ = self->priv->external_disk;
	_tmp1_ = gvir_domain_device_get_config ((GVirDomainDevice*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gvir_config_domain_disk_get_type ()) ? ((GVirConfigDomainDisk*) _tmp2_) : NULL;
	if (_tmp3_ == NULL) {
		_g_object_unref0 (_tmp2_);
	}
	disk_config = _tmp3_;
	_tmp4_ = gvir_config_domain_disk_get_source (disk_config);
	_tmp5_ = g_file_new_for_path (_tmp4_);
	_data63_->disk = _tmp5_;
	hdy_preferences_row_set_title ((HdyPreferencesRow*) self, _ ("Storage disk"));
	_tmp6_ = g_file_get_path (_data63_->disk);
	_tmp7_ = _tmp6_;
	hdy_action_row_set_subtitle ((HdyActionRow*) self, _tmp7_);
	_g_free0 (_tmp7_);
	g_file_query_info_async (_data63_->disk, G_FILE_ATTRIBUTE_STANDARD_SIZE, G_FILE_QUERY_INFO_NONE, G_PRIORITY_LOW, NULL, ___lambda69__gasync_ready_callback, block63_data_ref (_data63_));
	_tmp8_ = ((BoxesMemoryRow*) self)->stack;
	_tmp9_ = ((BoxesMemoryRow*) self)->used_label;
	gtk_stack_set_visible_child (_tmp8_, (GtkWidget*) _tmp9_);
	_g_object_unref0 (disk_config);
	block63_data_unref (_data63_);
	_data63_ = NULL;
}

static void
boxes_storage_row_on_spin_button_changed_data_free (gpointer _data)
{
	BoxesStorageRowOnSpinButtonChangedData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (BoxesStorageRowOnSpinButtonChangedData, _data_);
}

static void
boxes_storage_row_on_spin_button_changed (BoxesStorageRow* self,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_)
{
	BoxesStorageRowOnSpinButtonChangedData* _data_;
	BoxesStorageRow* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (BoxesStorageRowOnSpinButtonChangedData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, boxes_storage_row_on_spin_button_changed_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	boxes_storage_row_on_spin_button_changed_co (_data_);
}

static void
boxes_storage_row_on_spin_button_changed_finish (BoxesStorageRow* self,
                                                 GAsyncResult* _res_)
{
	BoxesStorageRowOnSpinButtonChangedData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
boxes_storage_row_on_spin_button_changed_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_)
{
	BoxesStorageRowOnSpinButtonChangedData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	boxes_storage_row_on_spin_button_changed_co (_data_);
}

static gboolean
boxes_storage_row_on_spin_button_changed_co (BoxesStorageRowOnSpinButtonChangedData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = ((BoxesMemoryRow*) _data_->self)->spin_button;
	_data_->storage = (guint64) gtk_spin_button_get_value (_data_->_tmp0_);
	{
		_data_->_tmp1_ = _data_->self->priv->machine;
		_data_->_tmp2_ = boxes_machine_get_is_running ((BoxesMachine*) _data_->_tmp1_);
		_data_->_tmp3_ = _data_->_tmp2_;
		if (!_data_->_tmp3_) {
			boxes_storage_row_resize_storage_volume (_data_->self, _data_->storage, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!g_task_get_completed (_data_->_async_result)) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp4_ = _data_->self->priv->machine;
		_data_->_tmp5_ = boxes_libvirt_machine_get_domain_disk (_data_->_tmp4_, &_data_->_inner_error0_);
		_data_->disk = _data_->_tmp5_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp6_ = _data_->disk;
		if (_data_->_tmp6_ == NULL) {
			_g_object_unref0 (_data_->disk);
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!g_task_get_completed (_data_->_async_result)) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->size = ((_data_->storage + OSINFO_KIBIBYTES) - 1) / OSINFO_KIBIBYTES;
		_data_->_tmp7_ = _data_->disk;
		gvir_domain_disk_resize (_data_->_tmp7_, _data_->size, (guint) GVIR_STORAGE_VOL_RESIZE_SHRINK, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->disk);
			goto __catch0_g_error;
		}
		_data_->_tmp8_ = _data_->self->priv->machine;
		_data_->_tmp9_ = boxes_libvirt_machine_get_connection (_data_->_tmp8_);
		_data_->_tmp10_ = _data_->_tmp9_;
		_data_->_tmp11_ = boxes_get_storage_pool (_data_->_tmp10_);
		_data_->pool = _data_->_tmp11_;
		_data_->_tmp12_ = _data_->pool;
		_data_->_state_ = 1;
		gvir_storage_pool_refresh_async (_data_->_tmp12_, NULL, boxes_storage_row_on_spin_button_changed_ready, _data_);
		return FALSE;
		_state_1:
		gvir_storage_pool_refresh_finish (_data_->_tmp12_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->pool);
			_g_object_unref0 (_data_->disk);
			goto __catch0_g_error;
		}
		_data_->_tmp13_ = _data_->self->priv->machine;
		boxes_libvirt_machine_update_domain_config (_data_->_tmp13_);
		_g_object_unref0 (_data_->pool);
		_g_object_unref0 (_data_->disk);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->_error_ = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp14_ = _data_->self->priv->machine;
		_data_->_tmp15_ = boxes_libvirt_machine_get_storage_volume (_data_->_tmp14_);
		_data_->_tmp16_ = _data_->_tmp15_;
		_data_->_tmp17_ = gvir_storage_vol_get_name (_data_->_tmp16_);
		_data_->_tmp18_ = _data_->_error_;
		_data_->_tmp19_ = _data_->_tmp18_->message;
		g_warning ("Failed to change storage capacity of volume '%s' to %" G_GUINT64_FORMAT " KiB: %s", _data_->_tmp17_, _data_->storage, _data_->_tmp19_);
		_g_error_free0 (_data_->_error_);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
boxes_storage_row_resize_storage_volume (BoxesStorageRow* self,
                                         guint64 size,
                                         GError** error)
{
	GVirStorageVolInfo* volume_info = NULL;
	BoxesLibvirtMachine* _tmp0_;
	GVirStorageVol* _tmp1_;
	GVirStorageVol* _tmp2_;
	GVirStorageVolInfo* _tmp3_;
	gboolean _tmp4_ = FALSE;
	BoxesLibvirtMachine* _tmp5_;
	BoxesVMCreator* _tmp6_;
	BoxesVMCreator* _tmp7_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->machine;
	_tmp1_ = boxes_libvirt_machine_get_storage_volume (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = gvir_storage_vol_get_info (_tmp2_, &_inner_error0_);
	volume_info = _tmp3_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp5_ = self->priv->machine;
	_tmp6_ = boxes_libvirt_machine_get_vm_creator (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp7_ != NULL) {
		GVirStorageVolInfo* _tmp8_;
		_tmp8_ = volume_info;
		_tmp4_ = size < _tmp8_->capacity;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		GVirConfigStorageVol* config = NULL;
		BoxesLibvirtMachine* _tmp9_;
		GVirStorageVol* _tmp10_;
		GVirStorageVol* _tmp11_;
		GVirConfigStorageVol* _tmp12_;
		GVirConfigStorageVol* _tmp13_;
		BoxesLibvirtMachine* _tmp14_;
		GVirStorageVol* _tmp15_;
		GVirStorageVol* _tmp16_;
		GVirStoragePool* pool = NULL;
		BoxesLibvirtMachine* _tmp17_;
		GVirConnection* _tmp18_;
		GVirConnection* _tmp19_;
		GVirStoragePool* _tmp20_;
		GVirStorageVol* _tmp21_ = NULL;
		GVirStoragePool* _tmp22_;
		GVirConfigStorageVol* _tmp23_;
		GVirStorageVol* _tmp24_;
		BoxesLibvirtMachine* _tmp25_;
		_tmp9_ = self->priv->machine;
		_tmp10_ = boxes_libvirt_machine_get_storage_volume (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = gvir_storage_vol_get_config (_tmp11_, (guint) GVIR_DOMAIN_XML_NONE, &_inner_error0_);
		config = _tmp12_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			__vala_GVirStorageVolInfo_free0 (volume_info);
			return;
		}
		_tmp13_ = config;
		gvir_config_storage_vol_set_capacity (_tmp13_, size);
		_tmp14_ = self->priv->machine;
		_tmp15_ = boxes_libvirt_machine_get_storage_volume (_tmp14_);
		_tmp16_ = _tmp15_;
		gvir_storage_vol_delete (_tmp16_, (guint) 0, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (config);
			__vala_GVirStorageVolInfo_free0 (volume_info);
			return;
		}
		_tmp17_ = self->priv->machine;
		_tmp18_ = boxes_libvirt_machine_get_connection (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = boxes_get_storage_pool (_tmp19_);
		pool = _tmp20_;
		_tmp22_ = pool;
		_tmp23_ = config;
		_tmp24_ = gvir_storage_pool_create_volume (_tmp22_, _tmp23_, &_inner_error0_);
		_tmp21_ = _tmp24_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (pool);
			_g_object_unref0 (config);
			__vala_GVirStorageVolInfo_free0 (volume_info);
			return;
		}
		_tmp25_ = self->priv->machine;
		boxes_libvirt_machine_set_storage_volume (_tmp25_, _tmp21_);
		_g_object_unref0 (_tmp21_);
		_g_object_unref0 (pool);
		_g_object_unref0 (config);
	} else {
		BoxesLibvirtMachine* _tmp26_;
		GVirStorageVol* _tmp27_;
		GVirStorageVol* _tmp28_;
		_tmp26_ = self->priv->machine;
		_tmp27_ = boxes_libvirt_machine_get_storage_volume (_tmp26_);
		_tmp28_ = _tmp27_;
		gvir_storage_vol_resize (_tmp28_, size, GVIR_STORAGE_VOL_RESIZE_SHRINK, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			__vala_GVirStorageVolInfo_free0 (volume_info);
			return;
		}
	}
	g_debug ("Storage changed to %" G_GUINT64_FORMAT, size);
	__vala_GVirStorageVolInfo_free0 (volume_info);
}

BoxesStorageRow*
boxes_storage_row_construct (GType object_type)
{
	BoxesStorageRow * self = NULL;
	self = (BoxesStorageRow*) boxes_memory_row_construct (object_type);
	return self;
}

BoxesStorageRow*
boxes_storage_row_new (void)
{
	return boxes_storage_row_construct (BOXES_TYPE_STORAGE_ROW);
}

static void
boxes_storage_row_class_init (BoxesStorageRowClass * klass,
                              gpointer klass_data)
{
	boxes_storage_row_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BoxesStorageRow_private_offset);
	G_OBJECT_CLASS (klass)->finalize = boxes_storage_row_finalize;
}

static void
boxes_storage_row_instance_init (BoxesStorageRow * self,
                                 gpointer klass)
{
	self->priv = boxes_storage_row_get_instance_private (self);
}

static void
boxes_storage_row_finalize (GObject * obj)
{
	BoxesStorageRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BOXES_TYPE_STORAGE_ROW, BoxesStorageRow);
	_g_object_unref0 (self->priv->machine);
	_g_object_unref0 (self->priv->external_disk);
	G_OBJECT_CLASS (boxes_storage_row_parent_class)->finalize (obj);
}

static GType
boxes_storage_row_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BoxesStorageRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) boxes_storage_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BoxesStorageRow), 0, (GInstanceInitFunc) boxes_storage_row_instance_init, NULL };
	GType boxes_storage_row_type_id;
	boxes_storage_row_type_id = g_type_register_static (BOXES_TYPE_MEMORY_ROW, "BoxesStorageRow", &g_define_type_info, 0);
	BoxesStorageRow_private_offset = g_type_add_instance_private (boxes_storage_row_type_id, sizeof (BoxesStorageRowPrivate));
	return boxes_storage_row_type_id;
}

GType
boxes_storage_row_get_type (void)
{
	static volatile gsize boxes_storage_row_type_id__once = 0;
	if (g_once_init_enter (&boxes_storage_row_type_id__once)) {
		GType boxes_storage_row_type_id;
		boxes_storage_row_type_id = boxes_storage_row_get_type_once ();
		g_once_init_leave (&boxes_storage_row_type_id__once, boxes_storage_row_type_id);
	}
	return boxes_storage_row_type_id__once;
}

