/*
  Copyright (c) 2018 Red Hat, Inc. <http://www.redhat.com>
  This file is part of GlusterFS.

  This file is licensed to you under your choice of the GNU Lesser
  General Public License, version 3 or any later version (LGPLv3 or
  later), or the GNU General Public License, version 2 (GPLv2), in all
  cases as published by the Free Software Foundation.
*/

/* File: utime-autogen-fops-tmpl.h
 * This file contains the utime autogenerated FOPs declarations.
 */

#ifndef _UTIME_AUTOGEN_FOPS_H
#define _UTIME_AUTOGEN_FOPS_H

#include <glusterfs/xlator.h>

/* BEGIN GENERATED CODE - DO NOT MODIFY */

int32_t
gf_utime_opendir (call_frame_t *frame, xlator_t *this,
                loc_t * loc,
	fd_t * fd,
	dict_t * xdata);


int32_t
gf_utime_writev (call_frame_t *frame, xlator_t *this,
                fd_t * fd,
	struct iovec * vector,
	int32_t count,
	off_t off,
	uint32_t flags,
	struct iobref * iobref,
	dict_t * xdata);


int32_t
gf_utime_readv (call_frame_t *frame, xlator_t *this,
                fd_t * fd,
	size_t size,
	off_t offset,
	uint32_t flags,
	dict_t * xdata);


int32_t
gf_utime_open (call_frame_t *frame, xlator_t *this,
                loc_t * loc,
	int32_t flags,
	fd_t * fd,
	dict_t * xdata);


int32_t
gf_utime_create (call_frame_t *frame, xlator_t *this,
                loc_t * loc,
	int32_t flags,
	mode_t mode,
	mode_t umask,
	fd_t * fd,
	dict_t * xdata);


int32_t
gf_utime_link (call_frame_t *frame, xlator_t *this,
                loc_t * oldloc,
	loc_t * newloc,
	dict_t * xdata);


int32_t
gf_utime_rename (call_frame_t *frame, xlator_t *this,
                loc_t * oldloc,
	loc_t * newloc,
	dict_t * xdata);


int32_t
gf_utime_symlink (call_frame_t *frame, xlator_t *this,
                const char * linkpath,
	loc_t * loc,
	mode_t umask,
	dict_t * xdata);


int32_t
gf_utime_rmdir (call_frame_t *frame, xlator_t *this,
                loc_t * loc,
	int32_t flags,
	dict_t * xdata);


int32_t
gf_utime_unlink (call_frame_t *frame, xlator_t *this,
                loc_t * loc,
	int32_t flags,
	dict_t * xdata);


int32_t
gf_utime_mkdir (call_frame_t *frame, xlator_t *this,
                loc_t * loc,
	mode_t mode,
	mode_t umask,
	dict_t * xdata);


int32_t
gf_utime_mknod (call_frame_t *frame, xlator_t *this,
                loc_t * loc,
	mode_t mode,
	dev_t rdev,
	mode_t umask,
	dict_t * xdata);


int32_t
gf_utime_ftruncate (call_frame_t *frame, xlator_t *this,
                fd_t * fd,
	off_t offset,
	dict_t * xdata);


int32_t
gf_utime_removexattr (call_frame_t *frame, xlator_t *this,
                loc_t * loc,
	const char * name,
	dict_t * xdata);


int32_t
gf_utime_fremovexattr (call_frame_t *frame, xlator_t *this,
                fd_t * fd,
	const char * name,
	dict_t * xdata);


int32_t
gf_utime_setattr (call_frame_t *frame, xlator_t *this,
                loc_t * loc,
	struct iatt * stbuf,
	int32_t valid,
	dict_t * xdata);


int32_t
gf_utime_truncate (call_frame_t *frame, xlator_t *this,
                loc_t * loc,
	off_t offset,
	dict_t * xdata);


int32_t
gf_utime_fsetattr (call_frame_t *frame, xlator_t *this,
                fd_t * fd,
	struct iatt * stbuf,
	int32_t valid,
	dict_t * xdata);


int32_t
gf_utime_fallocate (call_frame_t *frame, xlator_t *this,
                fd_t * fd,
	int32_t keep_size,
	off_t offset,
	size_t len,
	dict_t * xdata);


int32_t
gf_utime_zerofill (call_frame_t *frame, xlator_t *this,
                fd_t * fd,
	off_t offset,
	off_t len,
	dict_t * xdata);


int32_t
gf_utime_copy_file_range (call_frame_t *frame, xlator_t *this,
                fd_t * fd_in,
	off64_t  off_in,
	fd_t * fd_out,
	off64_t  off_out,
	size_t len,
	uint32_t flags,
	dict_t * xdata);

/* END GENERATED CODE */

#endif /* _UTIME_AUTOGEN_FOPS_H */
