/* gitg-ext-message-bus.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from gitg-ext-message-bus.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2012 - Jesse van den Kieboom
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include "libgitg-ext.h"
#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define GITG_EXT_MESSAGE_BUS_TYPE_MESSAGE (gitg_ext_message_bus_message_get_type ())
#define GITG_EXT_MESSAGE_BUS_MESSAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_EXT_MESSAGE_BUS_TYPE_MESSAGE, GitgExtMessageBusMessage))
#define GITG_EXT_MESSAGE_BUS_MESSAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_EXT_MESSAGE_BUS_TYPE_MESSAGE, GitgExtMessageBusMessageClass))
#define GITG_EXT_MESSAGE_BUS_IS_MESSAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_EXT_MESSAGE_BUS_TYPE_MESSAGE))
#define GITG_EXT_MESSAGE_BUS_IS_MESSAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_EXT_MESSAGE_BUS_TYPE_MESSAGE))
#define GITG_EXT_MESSAGE_BUS_MESSAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_EXT_MESSAGE_BUS_TYPE_MESSAGE, GitgExtMessageBusMessageClass))

typedef struct _GitgExtMessageBusMessage GitgExtMessageBusMessage;
typedef struct _GitgExtMessageBusMessageClass GitgExtMessageBusMessageClass;

#define GITG_EXT_MESSAGE_BUS_TYPE_ID_MAP (gitg_ext_message_bus_id_map_get_type ())
#define GITG_EXT_MESSAGE_BUS_ID_MAP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_EXT_MESSAGE_BUS_TYPE_ID_MAP, GitgExtMessageBusIdMap))
#define GITG_EXT_MESSAGE_BUS_ID_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_EXT_MESSAGE_BUS_TYPE_ID_MAP, GitgExtMessageBusIdMapClass))
#define GITG_EXT_MESSAGE_BUS_IS_ID_MAP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_EXT_MESSAGE_BUS_TYPE_ID_MAP))
#define GITG_EXT_MESSAGE_BUS_IS_ID_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_EXT_MESSAGE_BUS_TYPE_ID_MAP))
#define GITG_EXT_MESSAGE_BUS_ID_MAP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_EXT_MESSAGE_BUS_TYPE_ID_MAP, GitgExtMessageBusIdMapClass))

typedef struct _GitgExtMessageBusIdMap GitgExtMessageBusIdMap;
typedef struct _GitgExtMessageBusIdMapClass GitgExtMessageBusIdMapClass;
enum  {
	GITG_EXT_MESSAGE_BUS_0_PROPERTY,
	GITG_EXT_MESSAGE_BUS_NUM_PROPERTIES
};
static GParamSpec* gitg_ext_message_bus_properties[GITG_EXT_MESSAGE_BUS_NUM_PROPERTIES];
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _GitgExtMessageBusMessagePrivate GitgExtMessageBusMessagePrivate;

#define GITG_EXT_MESSAGE_BUS_TYPE_LISTENER (gitg_ext_message_bus_listener_get_type ())
#define GITG_EXT_MESSAGE_BUS_LISTENER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_EXT_MESSAGE_BUS_TYPE_LISTENER, GitgExtMessageBusListener))
#define GITG_EXT_MESSAGE_BUS_LISTENER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_EXT_MESSAGE_BUS_TYPE_LISTENER, GitgExtMessageBusListenerClass))
#define GITG_EXT_MESSAGE_BUS_IS_LISTENER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_EXT_MESSAGE_BUS_TYPE_LISTENER))
#define GITG_EXT_MESSAGE_BUS_IS_LISTENER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_EXT_MESSAGE_BUS_TYPE_LISTENER))
#define GITG_EXT_MESSAGE_BUS_LISTENER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_EXT_MESSAGE_BUS_TYPE_LISTENER, GitgExtMessageBusListenerClass))

typedef struct _GitgExtMessageBusListener GitgExtMessageBusListener;
typedef struct _GitgExtMessageBusListenerClass GitgExtMessageBusListenerClass;
typedef struct _GitgExtMessageBusListenerPrivate GitgExtMessageBusListenerPrivate;
#define _gitg_ext_message_bus_listener_unref0(var) ((var == NULL) ? NULL : (var = (gitg_ext_message_bus_listener_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block1Data Block1Data;
#define _gitg_ext_message_bus_message_unref0(var) ((var == NULL) ? NULL : (var = (gitg_ext_message_bus_message_unref (var), NULL)))
typedef struct _GitgExtMessageBusIdMapPrivate GitgExtMessageBusIdMapPrivate;
#define _gitg_ext_message_bus_id_map_unref0(var) ((var == NULL) ? NULL : (var = (gitg_ext_message_bus_id_map_unref (var), NULL)))
typedef void (*GitgExtMessageBusMatchCallback) (GitgExtMessageBusMessage* message, GList* listeners, gpointer user_data);
typedef struct _GitgExtMessageBusParamSpecListener GitgExtMessageBusParamSpecListener;
typedef struct _GitgExtMessageBusParamSpecMessage GitgExtMessageBusParamSpecMessage;
typedef struct _GitgExtMessageBusParamSpecIdMap GitgExtMessageBusParamSpecIdMap;
enum  {
	GITG_EXT_MESSAGE_BUS_REGISTERED_SIGNAL,
	GITG_EXT_MESSAGE_BUS_UNREGISTERED_SIGNAL,
	GITG_EXT_MESSAGE_BUS_DISPATCH_SIGNAL,
	GITG_EXT_MESSAGE_BUS_NUM_SIGNALS
};
static guint gitg_ext_message_bus_signals[GITG_EXT_MESSAGE_BUS_NUM_SIGNALS] = {0};

struct _GitgExtMessageBusPrivate {
	GHashTable* d_messages;
	GHashTable* d_idmap;
	GHashTable* d_types;
};

struct _GitgExtMessageBusMessage {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GitgExtMessageBusMessagePrivate * priv;
	GitgExtMessageId* id;
	GList* listeners;
};

struct _GitgExtMessageBusMessageClass {
	GTypeClass parent_class;
	void (*finalize) (GitgExtMessageBusMessage *self);
};

struct _GitgExtMessageBusListener {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GitgExtMessageBusListenerPrivate * priv;
	guint id;
	gboolean blocked;
	GitgExtMessageCallback callback;
	gpointer callback_target;
	GDestroyNotify callback_target_destroy_notify;
};

struct _GitgExtMessageBusListenerClass {
	GTypeClass parent_class;
	void (*finalize) (GitgExtMessageBusListener *self);
};

struct _Block1Data {
	int _ref_count_;
	GitgExtMessageBus* self;
	gchar* object_path;
};

struct _GitgExtMessageBusIdMap {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GitgExtMessageBusIdMapPrivate * priv;
	GitgExtMessageBusMessage* message;
	GList* listener;
};

struct _GitgExtMessageBusIdMapClass {
	GTypeClass parent_class;
	void (*finalize) (GitgExtMessageBusIdMap *self);
};

struct _GitgExtMessageBusParamSpecListener {
	GParamSpec parent_instance;
};

struct _GitgExtMessageBusParamSpecMessage {
	GParamSpec parent_instance;
};

struct _GitgExtMessageBusParamSpecIdMap {
	GParamSpec parent_instance;
};

static gint GitgExtMessageBus_private_offset;
static gpointer gitg_ext_message_bus_parent_class = NULL;
static GitgExtMessageBus* gitg_ext_message_bus_s_instance;
static GitgExtMessageBus* gitg_ext_message_bus_s_instance = NULL;
static guint gitg_ext_message_bus_s_next_id;
static guint gitg_ext_message_bus_s_next_id = 0U;
static gpointer gitg_ext_message_bus_listener_parent_class = NULL;
static gpointer gitg_ext_message_bus_message_parent_class = NULL;
static gpointer gitg_ext_message_bus_id_map_parent_class = NULL;

static gpointer gitg_ext_message_bus_message_ref (gpointer instance);
static void gitg_ext_message_bus_message_unref (gpointer instance);
static GParamSpec* gitg_ext_message_bus_param_spec_message (const gchar* name,
                                                     const gchar* nick,
                                                     const gchar* blurb,
                                                     GType object_type,
                                                     GParamFlags flags) G_GNUC_UNUSED ;
static void gitg_ext_message_bus_value_set_message (GValue* value,
                                             gpointer v_object) G_GNUC_UNUSED ;
static void gitg_ext_message_bus_value_take_message (GValue* value,
                                              gpointer v_object) G_GNUC_UNUSED ;
static gpointer gitg_ext_message_bus_value_get_message (const GValue* value) G_GNUC_UNUSED ;
static GType gitg_ext_message_bus_message_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static gpointer gitg_ext_message_bus_id_map_ref (gpointer instance);
static void gitg_ext_message_bus_id_map_unref (gpointer instance);
static GParamSpec* gitg_ext_message_bus_param_spec_id_map (const gchar* name,
                                                    const gchar* nick,
                                                    const gchar* blurb,
                                                    GType object_type,
                                                    GParamFlags flags) G_GNUC_UNUSED ;
static void gitg_ext_message_bus_value_set_id_map (GValue* value,
                                            gpointer v_object) G_GNUC_UNUSED ;
static void gitg_ext_message_bus_value_take_id_map (GValue* value,
                                             gpointer v_object) G_GNUC_UNUSED ;
static gpointer gitg_ext_message_bus_value_get_id_map (const GValue* value) G_GNUC_UNUSED ;
static GType gitg_ext_message_bus_id_map_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static guint _gitg_ext_message_id_hash_ghash_func (gconstpointer key);
static gboolean _gitg_ext_message_id_equal_gequal_func (gconstpointer a,
                                                 gconstpointer b);
static void _g_object_unref0_ (gpointer var);
static void _gitg_ext_message_bus_message_unref0_ (gpointer var);
static void _gitg_ext_message_bus_id_map_unref0_ (gpointer var);
static void gitg_ext_message_bus_dispatch_message_real (GitgExtMessageBus* self,
                                                 GitgExtMessageBusMessage* msg,
                                                 GitgExtMessage* message);
static gpointer gitg_ext_message_bus_listener_ref (gpointer instance);
static void gitg_ext_message_bus_listener_unref (gpointer instance);
static GParamSpec* gitg_ext_message_bus_param_spec_listener (const gchar* name,
                                                      const gchar* nick,
                                                      const gchar* blurb,
                                                      GType object_type,
                                                      GParamFlags flags) G_GNUC_UNUSED ;
static void gitg_ext_message_bus_value_set_listener (GValue* value,
                                              gpointer v_object) G_GNUC_UNUSED ;
static void gitg_ext_message_bus_value_take_listener (GValue* value,
                                               gpointer v_object) G_GNUC_UNUSED ;
static gpointer gitg_ext_message_bus_value_get_listener (const GValue* value) G_GNUC_UNUSED ;
static GType gitg_ext_message_bus_listener_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static void gitg_ext_message_bus_unregister_real (GitgExtMessageBus* self,
                                           GitgExtMessageId* id,
                                           gboolean remove_from_store);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static gboolean __lambda4_ (Block1Data* _data1_,
                     GitgExtMessageId* key,
                     GType val);
static gboolean ___lambda4__ghr_func (gconstpointer key,
                               gconstpointer value,
                               gpointer self);
static GitgExtMessageBusMessage* gitg_ext_message_bus_new_message (GitgExtMessageBus* self,
                                                            GitgExtMessageId* id);
static GitgExtMessageBusMessage* gitg_ext_message_bus_message_new (GitgExtMessageId* id);
static GitgExtMessageBusMessage* gitg_ext_message_bus_message_construct (GType object_type,
                                                                  GitgExtMessageId* id);
static GitgExtMessageBusMessage* gitg_ext_message_bus_lookup_message (GitgExtMessageBus* self,
                                                               GitgExtMessageId* id,
                                                               gboolean create);
static guint gitg_ext_message_bus_add_listener (GitgExtMessageBus* self,
                                         GitgExtMessageBusMessage* message,
                                         GitgExtMessageCallback callback,
                                         gpointer callback_target,
                                         GDestroyNotify callback_target_destroy_notify);
static GitgExtMessageBusListener* gitg_ext_message_bus_listener_new (guint id,
                                                              GitgExtMessageCallback callback,
                                                              gpointer callback_target,
                                                              GDestroyNotify callback_target_destroy_notify);
static GitgExtMessageBusListener* gitg_ext_message_bus_listener_construct (GType object_type,
                                                                    guint id,
                                                                    GitgExtMessageCallback callback,
                                                                    gpointer callback_target,
                                                                    GDestroyNotify callback_target_destroy_notify);
static GitgExtMessageBusIdMap* gitg_ext_message_bus_id_map_new (GitgExtMessageBusMessage* message);
static GitgExtMessageBusIdMap* gitg_ext_message_bus_id_map_construct (GType object_type,
                                                               GitgExtMessageBusMessage* message);
static void gitg_ext_message_bus_remove_listener (GitgExtMessageBus* self,
                                           GitgExtMessageBusMessage* message,
                                           GList* listener);
static void gitg_ext_message_bus_block_listener (GitgExtMessageBus* self,
                                          GitgExtMessageBusMessage* message,
                                          GList* listener);
static void gitg_ext_message_bus_unblock_listener (GitgExtMessageBus* self,
                                            GitgExtMessageBusMessage* message,
                                            GList* listener);
static void gitg_ext_message_bus_process_by_id (GitgExtMessageBus* self,
                                         guint id,
                                         GitgExtMessageBusMatchCallback processor,
                                         gpointer processor_target);
static void _gitg_ext_message_bus_remove_listener_gitg_ext_message_bus_match_callback (GitgExtMessageBusMessage* message,
                                                                                GList* listeners,
                                                                                gpointer self);
static void _gitg_ext_message_bus_block_listener_gitg_ext_message_bus_match_callback (GitgExtMessageBusMessage* message,
                                                                               GList* listeners,
                                                                               gpointer self);
static void _gitg_ext_message_bus_unblock_listener_gitg_ext_message_bus_match_callback (GitgExtMessageBusMessage* message,
                                                                                 GList* listeners,
                                                                                 gpointer self);
static void gitg_ext_message_bus_dispatch_message (GitgExtMessageBus* self,
                                            GitgExtMessage* message);
static void gitg_ext_message_bus_real_dispatch (GitgExtMessageBus* self,
                                         GitgExtMessage* message);
static void gitg_ext_message_bus_listener_finalize (GitgExtMessageBusListener * obj);
static GType gitg_ext_message_bus_listener_get_type_once (void);
static void _gitg_ext_message_bus_listener_unref0_ (gpointer var);
static inline void _g_list_free__gitg_ext_message_bus_listener_unref0_ (GList* self);
static void gitg_ext_message_bus_message_finalize (GitgExtMessageBusMessage * obj);
static GType gitg_ext_message_bus_message_get_type_once (void);
static void gitg_ext_message_bus_id_map_finalize (GitgExtMessageBusIdMap * obj);
static GType gitg_ext_message_bus_id_map_get_type_once (void);
static void gitg_ext_message_bus_finalize (GObject * obj);
static GType gitg_ext_message_bus_get_type_once (void);

static inline gpointer
gitg_ext_message_bus_get_instance_private (GitgExtMessageBus* self)
{
	return G_STRUCT_MEMBER_P (self, GitgExtMessageBus_private_offset);
}

static guint
_gitg_ext_message_id_hash_ghash_func (gconstpointer key)
{
	guint result;
	result = gitg_ext_message_id_hash (key);
	return result;
}

static gboolean
_gitg_ext_message_id_equal_gequal_func (gconstpointer a,
                                        gconstpointer b)
{
	gboolean result;
	result = gitg_ext_message_id_equal (a, (GitgExtMessageId*) b);
	return result;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static void
_gitg_ext_message_bus_message_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (gitg_ext_message_bus_message_unref (var), NULL));
}

static void
_gitg_ext_message_bus_id_map_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (gitg_ext_message_bus_id_map_unref (var), NULL));
}

GitgExtMessageBus*
gitg_ext_message_bus_construct (GType object_type)
{
	GitgExtMessageBus * self = NULL;
	GHashTable* _tmp0_;
	GHashFunc _tmp1_;
	GEqualFunc _tmp2_;
	GHashTable* _tmp3_;
	GHashTable* _tmp4_;
	self = (GitgExtMessageBus*) g_object_new (object_type, NULL);
	_tmp0_ = g_hash_table_new_full (_gitg_ext_message_id_hash_ghash_func, _gitg_ext_message_id_equal_gequal_func, _g_object_unref0_, _gitg_ext_message_bus_message_unref0_);
	_g_hash_table_unref0 (self->priv->d_messages);
	self->priv->d_messages = _tmp0_;
	_tmp1_ = g_direct_hash;
	_tmp2_ = g_direct_equal;
	_tmp3_ = g_hash_table_new_full (_tmp1_, _tmp2_, NULL, _gitg_ext_message_bus_id_map_unref0_);
	_g_hash_table_unref0 (self->priv->d_idmap);
	self->priv->d_idmap = _tmp3_;
	_tmp4_ = g_hash_table_new_full (_gitg_ext_message_id_hash_ghash_func, _gitg_ext_message_id_equal_gequal_func, _g_object_unref0_, NULL);
	_g_hash_table_unref0 (self->priv->d_types);
	self->priv->d_types = _tmp4_;
	return self;
}

GitgExtMessageBus*
gitg_ext_message_bus_new (void)
{
	return gitg_ext_message_bus_construct (GITG_EXT_TYPE_MESSAGE_BUS);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GitgExtMessageBus*
gitg_ext_message_bus_get_default (void)
{
	GitgExtMessageBus* _tmp0_;
	GitgExtMessageBus* _tmp3_;
	GitgExtMessageBus* _tmp4_;
	GitgExtMessageBus* result;
	_tmp0_ = gitg_ext_message_bus_s_instance;
	if (_tmp0_ == NULL) {
		GitgExtMessageBus* _tmp1_;
		GitgExtMessageBus* _tmp2_;
		_tmp1_ = gitg_ext_message_bus_new ();
		_g_object_unref0 (gitg_ext_message_bus_s_instance);
		gitg_ext_message_bus_s_instance = _tmp1_;
		_tmp2_ = gitg_ext_message_bus_s_instance;
		g_object_add_weak_pointer ((GObject*) _tmp2_, &gitg_ext_message_bus_s_instance);
	}
	_tmp3_ = gitg_ext_message_bus_s_instance;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	result = _tmp4_;
	return result;
}

static gpointer
_gitg_ext_message_bus_listener_ref0 (gpointer self)
{
	return self ? gitg_ext_message_bus_listener_ref (self) : NULL;
}

static void
gitg_ext_message_bus_dispatch_message_real (GitgExtMessageBus* self,
                                            GitgExtMessageBusMessage* msg,
                                            GitgExtMessage* message)
{
	GList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (msg != NULL);
	g_return_if_fail (message != NULL);
	_tmp0_ = msg->listeners;
	{
		GList* l_collection = NULL;
		GList* l_it = NULL;
		l_collection = _tmp0_;
		for (l_it = l_collection; l_it != NULL; l_it = l_it->next) {
			GitgExtMessageBusListener* _tmp1_;
			GitgExtMessageBusListener* l = NULL;
			_tmp1_ = _gitg_ext_message_bus_listener_ref0 ((GitgExtMessageBusListener*) l_it->data);
			l = _tmp1_;
			{
				GitgExtMessageBusListener* _tmp2_;
				_tmp2_ = l;
				if (!_tmp2_->blocked) {
					GitgExtMessageBusListener* _tmp3_;
					GitgExtMessageCallback _tmp4_;
					gpointer _tmp4__target;
					_tmp3_ = l;
					_tmp4_ = _tmp3_->callback;
					_tmp4__target = _tmp3_->callback_target;
					_tmp4_ (message, _tmp4__target);
				}
				_gitg_ext_message_bus_listener_unref0 (l);
			}
		}
	}
}

GType
gitg_ext_message_bus_lookup (GitgExtMessageBus* self,
                             GitgExtMessageId* id)
{
	GType ret = 0UL;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_ = NULL;
	gboolean _tmp2_;
	GType result;
	g_return_val_if_fail (self != NULL, 0UL);
	g_return_val_if_fail (id != NULL, 0UL);
	_tmp0_ = self->priv->d_types;
	_tmp2_ = g_hash_table_lookup_extended (_tmp0_, id, NULL, &_tmp1_);
	ret = (GType) ((gintptr) _tmp1_);
	if (!_tmp2_) {
		result = G_TYPE_INVALID;
		return result;
	} else {
		result = ret;
		return result;
	}
}

void
gitg_ext_message_bus_register (GitgExtMessageBus* self,
                               GType message_type,
                               GitgExtMessageId* id)
{
	GitgExtMessageId* cp = NULL;
	GitgExtMessageId* _tmp3_;
	GHashTable* _tmp4_;
	GitgExtMessageId* _tmp5_;
	GitgExtMessageId* _tmp6_;
	GitgExtMessageId* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (id != NULL);
	if (gitg_ext_message_bus_is_registered (self, id)) {
		gchar* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp0_ = gitg_ext_message_id_get_id (id);
		_tmp1_ = _tmp0_;
		_tmp2_ = _tmp1_;
		g_warning ("gitg-ext-message-bus.vala:133: Message type for `%s' is already regist" \
"ered", _tmp2_);
		_g_free0 (_tmp2_);
		return;
	}
	_tmp3_ = gitg_ext_message_id_copy (id);
	cp = _tmp3_;
	_tmp4_ = self->priv->d_types;
	_tmp5_ = cp;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	g_hash_table_insert (_tmp4_, _tmp6_, (gpointer) ((gintptr) message_type));
	_tmp7_ = cp;
	g_signal_emit (self, gitg_ext_message_bus_signals[GITG_EXT_MESSAGE_BUS_REGISTERED_SIGNAL], 0, _tmp7_);
	_g_object_unref0 (cp);
}

static void
gitg_ext_message_bus_unregister_real (GitgExtMessageBus* self,
                                      GitgExtMessageId* id,
                                      gboolean remove_from_store)
{
	GitgExtMessageId* cp = NULL;
	GitgExtMessageId* _tmp0_;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (id != NULL);
	_tmp0_ = _g_object_ref0 (id);
	cp = _tmp0_;
	if (!remove_from_store) {
		_tmp1_ = TRUE;
	} else {
		GHashTable* _tmp2_;
		GitgExtMessageId* _tmp3_;
		_tmp2_ = self->priv->d_types;
		_tmp3_ = cp;
		_tmp1_ = g_hash_table_remove (_tmp2_, _tmp3_);
	}
	if (_tmp1_) {
		GitgExtMessageId* _tmp4_;
		_tmp4_ = cp;
		g_signal_emit (self, gitg_ext_message_bus_signals[GITG_EXT_MESSAGE_BUS_UNREGISTERED_SIGNAL], 0, _tmp4_);
	}
	_g_object_unref0 (cp);
}

void
gitg_ext_message_bus_unregister (GitgExtMessageBus* self,
                                 GitgExtMessageId* id)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (id != NULL);
	gitg_ext_message_bus_unregister_real (self, id, TRUE);
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		GitgExtMessageBus* self;
		self = _data1_->self;
		_g_free0 (_data1_->object_path);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static gboolean
__lambda4_ (Block1Data* _data1_,
            GitgExtMessageId* key,
            GType val)
{
	GitgExtMessageBus* self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gboolean result;
	self = _data1_->self;
	g_return_val_if_fail (key != NULL, FALSE);
	_tmp0_ = gitg_ext_message_id_get_object_path (key);
	_tmp1_ = _tmp0_;
	if (g_strcmp0 (_tmp1_, _data1_->object_path) == 0) {
		gitg_ext_message_bus_unregister_real (self, key, TRUE);
		result = TRUE;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}

static gboolean
___lambda4__ghr_func (gconstpointer key,
                      gconstpointer value,
                      gpointer self)
{
	gboolean result;
	result = __lambda4_ (self, (GitgExtMessageId*) key, (GType) ((gintptr) value));
	return result;
}

void
gitg_ext_message_bus_unregister_all (GitgExtMessageBus* self,
                                     const gchar* object_path)
{
	Block1Data* _data1_;
	gchar* _tmp0_;
	GHashTable* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object_path != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = g_strdup (object_path);
	_g_free0 (_data1_->object_path);
	_data1_->object_path = _tmp0_;
	_tmp1_ = self->priv->d_types;
	g_hash_table_foreach_remove (_tmp1_, ___lambda4__ghr_func, _data1_);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}

gboolean
gitg_ext_message_bus_is_registered (GitgExtMessageBus* self,
                                    GitgExtMessageId* id)
{
	GHashTable* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (id != NULL, FALSE);
	_tmp0_ = self->priv->d_types;
	result = g_hash_table_lookup_extended (_tmp0_, id, NULL, (gpointer) ((gintptr) NULL));
	return result;
}

static gpointer
_gitg_ext_message_bus_message_ref0 (gpointer self)
{
	return self ? gitg_ext_message_bus_message_ref (self) : NULL;
}

static GitgExtMessageBusMessage*
gitg_ext_message_bus_new_message (GitgExtMessageBus* self,
                                  GitgExtMessageId* id)
{
	GitgExtMessageBusMessage* ret = NULL;
	GitgExtMessageBusMessage* _tmp0_;
	GHashTable* _tmp1_;
	GitgExtMessageId* _tmp2_;
	GitgExtMessageBusMessage* _tmp3_;
	GitgExtMessageBusMessage* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	_tmp0_ = gitg_ext_message_bus_message_new (id);
	ret = _tmp0_;
	_tmp1_ = self->priv->d_messages;
	_tmp2_ = _g_object_ref0 (id);
	_tmp3_ = _gitg_ext_message_bus_message_ref0 (ret);
	g_hash_table_insert (_tmp1_, _tmp2_, _tmp3_);
	result = ret;
	return result;
}

static GitgExtMessageBusMessage*
gitg_ext_message_bus_lookup_message (GitgExtMessageBus* self,
                                     GitgExtMessageId* id,
                                     gboolean create)
{
	GitgExtMessageBusMessage* message = NULL;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	GitgExtMessageBusMessage* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GitgExtMessageBusMessage* _tmp4_;
	GitgExtMessageBusMessage* _tmp5_;
	GitgExtMessageBusMessage* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	_tmp0_ = self->priv->d_messages;
	_tmp1_ = g_hash_table_lookup (_tmp0_, id);
	_tmp2_ = _gitg_ext_message_bus_message_ref0 ((GitgExtMessageBusMessage*) _tmp1_);
	message = _tmp2_;
	_tmp4_ = message;
	if (_tmp4_ == NULL) {
		_tmp3_ = !create;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		result = NULL;
		_gitg_ext_message_bus_message_unref0 (message);
		return result;
	}
	_tmp5_ = message;
	if (_tmp5_ == NULL) {
		GitgExtMessageBusMessage* _tmp6_;
		_tmp6_ = gitg_ext_message_bus_new_message (self, id);
		_gitg_ext_message_bus_message_unref0 (message);
		message = _tmp6_;
	}
	result = message;
	return result;
}

static gpointer
_gitg_ext_message_bus_id_map_ref0 (gpointer self)
{
	return self ? gitg_ext_message_bus_id_map_ref (self) : NULL;
}

static guint
gitg_ext_message_bus_add_listener (GitgExtMessageBus* self,
                                   GitgExtMessageBusMessage* message,
                                   GitgExtMessageCallback callback,
                                   gpointer callback_target,
                                   GDestroyNotify callback_target_destroy_notify)
{
	GitgExtMessageBusListener* listener = NULL;
	guint _tmp0_;
	GitgExtMessageCallback _tmp1_;
	gpointer _tmp1__target;
	GDestroyNotify _tmp1__target_destroy_notify;
	GitgExtMessageBusListener* _tmp2_;
	GitgExtMessageBusListener* _tmp3_;
	GitgExtMessageBusIdMap* idmap = NULL;
	GitgExtMessageBusIdMap* _tmp4_;
	GList* _tmp5_;
	GList* _tmp6_;
	GHashTable* _tmp7_;
	GitgExtMessageBusIdMap* _tmp8_;
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	g_return_val_if_fail (message != NULL, 0U);
	gitg_ext_message_bus_s_next_id = gitg_ext_message_bus_s_next_id + 1;
	_tmp0_ = gitg_ext_message_bus_s_next_id;
	_tmp1_ = callback;
	_tmp1__target = callback_target;
	_tmp1__target_destroy_notify = callback_target_destroy_notify;
	callback = NULL;
	callback_target = NULL;
	callback_target_destroy_notify = NULL;
	_tmp2_ = gitg_ext_message_bus_listener_new (_tmp0_, _tmp1_, _tmp1__target, _tmp1__target_destroy_notify);
	listener = _tmp2_;
	_tmp3_ = _gitg_ext_message_bus_listener_ref0 (listener);
	message->listeners = g_list_append (message->listeners, _tmp3_);
	_tmp4_ = gitg_ext_message_bus_id_map_new (message);
	idmap = _tmp4_;
	_tmp5_ = message->listeners;
	_tmp6_ = g_list_last (_tmp5_);
	idmap->listener = _tmp6_;
	_tmp7_ = self->priv->d_idmap;
	_tmp8_ = _gitg_ext_message_bus_id_map_ref0 (idmap);
	g_hash_table_insert (_tmp7_, (gpointer) ((guintptr) listener->id), _tmp8_);
	result = listener->id;
	_gitg_ext_message_bus_id_map_unref0 (idmap);
	_gitg_ext_message_bus_listener_unref0 (listener);
	(callback_target_destroy_notify == NULL) ? NULL : (callback_target_destroy_notify (callback_target), NULL);
	callback = NULL;
	callback_target = NULL;
	callback_target_destroy_notify = NULL;
	return result;
}

static void
gitg_ext_message_bus_remove_listener (GitgExtMessageBus* self,
                                      GitgExtMessageBusMessage* message,
                                      GList* listener)
{
	GitgExtMessageBusListener* lst = NULL;
	gconstpointer _tmp0_;
	GHashTable* _tmp1_;
	GitgExtMessageBusListener* _tmp2_;
	GList* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	_tmp0_ = listener->data;
	lst = (GitgExtMessageBusListener*) _tmp0_;
	_tmp1_ = self->priv->d_idmap;
	_tmp2_ = lst;
	g_hash_table_remove (_tmp1_, (gpointer) ((guintptr) _tmp2_->id));
	message->listeners = g_list_delete_link (message->listeners, listener);
	_tmp3_ = message->listeners;
	if (_tmp3_ == NULL) {
		GHashTable* _tmp4_;
		GitgExtMessageId* _tmp5_;
		_tmp4_ = self->priv->d_messages;
		_tmp5_ = message->id;
		g_hash_table_remove (_tmp4_, _tmp5_);
	}
}

static void
gitg_ext_message_bus_block_listener (GitgExtMessageBus* self,
                                     GitgExtMessageBusMessage* message,
                                     GList* listener)
{
	gconstpointer _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	_tmp0_ = listener->data;
	((GitgExtMessageBusListener*) _tmp0_)->blocked = TRUE;
}

static void
gitg_ext_message_bus_unblock_listener (GitgExtMessageBus* self,
                                       GitgExtMessageBusMessage* message,
                                       GList* listener)
{
	gconstpointer _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	_tmp0_ = listener->data;
	((GitgExtMessageBusListener*) _tmp0_)->blocked = FALSE;
}

guint
gitg_ext_message_bus_connect (GitgExtMessageBus* self,
                              GitgExtMessageId* id,
                              GitgExtMessageCallback callback,
                              gpointer callback_target,
                              GDestroyNotify callback_target_destroy_notify)
{
	GitgExtMessageBusMessage* message = NULL;
	GitgExtMessageBusMessage* _tmp0_;
	GitgExtMessageCallback _tmp1_;
	gpointer _tmp1__target;
	GDestroyNotify _tmp1__target_destroy_notify;
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	g_return_val_if_fail (id != NULL, 0U);
	_tmp0_ = gitg_ext_message_bus_lookup_message (self, id, TRUE);
	message = _tmp0_;
	_tmp1_ = callback;
	_tmp1__target = callback_target;
	_tmp1__target_destroy_notify = callback_target_destroy_notify;
	callback = NULL;
	callback_target = NULL;
	callback_target_destroy_notify = NULL;
	result = gitg_ext_message_bus_add_listener (self, message, _tmp1_, _tmp1__target, _tmp1__target_destroy_notify);
	_gitg_ext_message_bus_message_unref0 (message);
	(callback_target_destroy_notify == NULL) ? NULL : (callback_target_destroy_notify (callback_target), NULL);
	callback = NULL;
	callback_target = NULL;
	callback_target_destroy_notify = NULL;
	return result;
}

static void
gitg_ext_message_bus_process_by_id (GitgExtMessageBus* self,
                                    guint id,
                                    GitgExtMessageBusMatchCallback processor,
                                    gpointer processor_target)
{
	GitgExtMessageBusIdMap* idmap = NULL;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	GitgExtMessageBusIdMap* _tmp2_;
	GitgExtMessageBusIdMap* _tmp3_;
	GitgExtMessageBusIdMap* _tmp4_;
	GitgExtMessageBusMessage* _tmp5_;
	GitgExtMessageBusIdMap* _tmp6_;
	GList* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->d_idmap;
	_tmp1_ = g_hash_table_lookup (_tmp0_, (gpointer) ((guintptr) id));
	_tmp2_ = _gitg_ext_message_bus_id_map_ref0 ((GitgExtMessageBusIdMap*) _tmp1_);
	idmap = _tmp2_;
	_tmp3_ = idmap;
	if (_tmp3_ == NULL) {
		_gitg_ext_message_bus_id_map_unref0 (idmap);
		return;
	}
	_tmp4_ = idmap;
	_tmp5_ = _tmp4_->message;
	_tmp6_ = idmap;
	_tmp7_ = _tmp6_->listener;
	processor (_tmp5_, _tmp7_, processor_target);
	_gitg_ext_message_bus_id_map_unref0 (idmap);
}

static void
_gitg_ext_message_bus_remove_listener_gitg_ext_message_bus_match_callback (GitgExtMessageBusMessage* message,
                                                                           GList* listeners,
                                                                           gpointer self)
{
	gitg_ext_message_bus_remove_listener ((GitgExtMessageBus*) self, message, listeners);
}

void
gitg_ext_message_bus_disconnect (GitgExtMessageBus* self,
                                 guint id)
{
	g_return_if_fail (self != NULL);
	gitg_ext_message_bus_process_by_id (self, id, _gitg_ext_message_bus_remove_listener_gitg_ext_message_bus_match_callback, self);
}

static void
_gitg_ext_message_bus_block_listener_gitg_ext_message_bus_match_callback (GitgExtMessageBusMessage* message,
                                                                          GList* listeners,
                                                                          gpointer self)
{
	gitg_ext_message_bus_block_listener ((GitgExtMessageBus*) self, message, listeners);
}

void
gitg_ext_message_bus_block (GitgExtMessageBus* self,
                            guint id)
{
	g_return_if_fail (self != NULL);
	gitg_ext_message_bus_process_by_id (self, id, _gitg_ext_message_bus_block_listener_gitg_ext_message_bus_match_callback, self);
}

static void
_gitg_ext_message_bus_unblock_listener_gitg_ext_message_bus_match_callback (GitgExtMessageBusMessage* message,
                                                                            GList* listeners,
                                                                            gpointer self)
{
	gitg_ext_message_bus_unblock_listener ((GitgExtMessageBus*) self, message, listeners);
}

void
gitg_ext_message_bus_unblock (GitgExtMessageBus* self,
                              guint id)
{
	g_return_if_fail (self != NULL);
	gitg_ext_message_bus_process_by_id (self, id, _gitg_ext_message_bus_unblock_listener_gitg_ext_message_bus_match_callback, self);
}

static void
gitg_ext_message_bus_dispatch_message (GitgExtMessageBus* self,
                                       GitgExtMessage* message)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	g_signal_emit (self, gitg_ext_message_bus_signals[GITG_EXT_MESSAGE_BUS_DISPATCH_SIGNAL], 0, message);
}

GitgExtMessage*
gitg_ext_message_bus_send_message (GitgExtMessageBus* self,
                                   GitgExtMessage* message)
{
	GitgExtMessage* _tmp0_;
	GitgExtMessage* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (message != NULL, NULL);
	gitg_ext_message_bus_dispatch_message (self, message);
	_tmp0_ = _g_object_ref0 (message);
	result = _tmp0_;
	return result;
}

GitgExtMessage*
gitg_ext_message_bus_send (GitgExtMessageBus* self,
                           GitgExtMessageId* id,
                           const gchar* firstprop,
                           ...)
{
	GType type = 0UL;
	GitgExtMessage* msg = NULL;
	va_list _tmp3_ = {0};
	GObject* _tmp4_;
	GObject* _tmp5_;
	GitgExtMessage* _tmp6_;
	GitgExtMessage* _tmp7_;
	GitgExtMessage* _tmp9_;
	GitgExtMessage* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	type = gitg_ext_message_bus_lookup (self, id);
	if (type == G_TYPE_INVALID) {
		gchar* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp0_ = gitg_ext_message_id_get_id (id);
		_tmp1_ = _tmp0_;
		_tmp2_ = _tmp1_;
		g_warning ("gitg-ext-message-bus.vala:294: Could not find message type for `%s'", _tmp2_);
		_g_free0 (_tmp2_);
		result = NULL;
		return result;
	}
	va_start (_tmp3_, firstprop);
	_tmp4_ = g_object_new_valist (type, firstprop, _tmp3_);
	_tmp5_ = G_IS_INITIALLY_UNOWNED (_tmp4_) ? g_object_ref_sink (_tmp4_) : _tmp4_;
	_tmp6_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GITG_EXT_TYPE_MESSAGE, GitgExtMessage);
	va_end (_tmp3_);
	msg = _tmp6_;
	_tmp7_ = msg;
	if (_tmp7_ != NULL) {
		GitgExtMessage* _tmp8_;
		_tmp8_ = msg;
		gitg_ext_message_set_id (_tmp8_, id);
	}
	_tmp9_ = msg;
	gitg_ext_message_bus_dispatch_message (self, _tmp9_);
	result = msg;
	return result;
}

static void
gitg_ext_message_bus_real_dispatch (GitgExtMessageBus* self,
                                    GitgExtMessage* message)
{
	GitgExtMessageBusMessage* msg = NULL;
	GitgExtMessageId* _tmp0_;
	GitgExtMessageId* _tmp1_;
	GitgExtMessageBusMessage* _tmp2_;
	GitgExtMessageBusMessage* _tmp3_;
	g_return_if_fail (message != NULL);
	_tmp0_ = gitg_ext_message_get_id (message);
	_tmp1_ = _tmp0_;
	_tmp2_ = gitg_ext_message_bus_lookup_message (self, _tmp1_, FALSE);
	msg = _tmp2_;
	_tmp3_ = msg;
	if (_tmp3_ != NULL) {
		GitgExtMessageBusMessage* _tmp4_;
		_tmp4_ = msg;
		gitg_ext_message_bus_dispatch_message_real (self, _tmp4_, message);
	}
	_gitg_ext_message_bus_message_unref0 (msg);
}

static GitgExtMessageBusListener*
gitg_ext_message_bus_listener_construct (GType object_type,
                                         guint id,
                                         GitgExtMessageCallback callback,
                                         gpointer callback_target,
                                         GDestroyNotify callback_target_destroy_notify)
{
	GitgExtMessageBusListener* self = NULL;
	GitgExtMessageCallback _tmp0_;
	gpointer _tmp0__target;
	GDestroyNotify _tmp0__target_destroy_notify;
	self = (GitgExtMessageBusListener*) g_type_create_instance (object_type);
	self->id = id;
	_tmp0_ = callback;
	_tmp0__target = callback_target;
	_tmp0__target_destroy_notify = callback_target_destroy_notify;
	callback = NULL;
	callback_target = NULL;
	callback_target_destroy_notify = NULL;
	(self->callback_target_destroy_notify == NULL) ? NULL : (self->callback_target_destroy_notify (self->callback_target), NULL);
	self->callback = NULL;
	self->callback_target = NULL;
	self->callback_target_destroy_notify = NULL;
	self->callback = _tmp0_;
	self->callback_target = _tmp0__target;
	self->callback_target_destroy_notify = _tmp0__target_destroy_notify;
	self->blocked = FALSE;
	(callback_target_destroy_notify == NULL) ? NULL : (callback_target_destroy_notify (callback_target), NULL);
	callback = NULL;
	callback_target = NULL;
	callback_target_destroy_notify = NULL;
	return self;
}

static GitgExtMessageBusListener*
gitg_ext_message_bus_listener_new (guint id,
                                   GitgExtMessageCallback callback,
                                   gpointer callback_target,
                                   GDestroyNotify callback_target_destroy_notify)
{
	return gitg_ext_message_bus_listener_construct (GITG_EXT_MESSAGE_BUS_TYPE_LISTENER, id, callback, callback_target, callback_target_destroy_notify);
}

static void
gitg_ext_message_bus_value_listener_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
gitg_ext_message_bus_value_listener_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		gitg_ext_message_bus_listener_unref (value->data[0].v_pointer);
	}
}

static void
gitg_ext_message_bus_value_listener_copy_value (const GValue* src_value,
                                                GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = gitg_ext_message_bus_listener_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
gitg_ext_message_bus_value_listener_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
gitg_ext_message_bus_value_listener_collect_value (GValue* value,
                                                   guint n_collect_values,
                                                   GTypeCValue* collect_values,
                                                   guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		GitgExtMessageBusListener * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = gitg_ext_message_bus_listener_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
gitg_ext_message_bus_value_listener_lcopy_value (const GValue* value,
                                                 guint n_collect_values,
                                                 GTypeCValue* collect_values,
                                                 guint collect_flags)
{
	GitgExtMessageBusListener ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = gitg_ext_message_bus_listener_ref (value->data[0].v_pointer);
	}
	return NULL;
}

static GParamSpec*
gitg_ext_message_bus_param_spec_listener (const gchar* name,
                                          const gchar* nick,
                                          const gchar* blurb,
                                          GType object_type,
                                          GParamFlags flags)
{
	GitgExtMessageBusParamSpecListener* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GITG_EXT_MESSAGE_BUS_TYPE_LISTENER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

static gpointer
gitg_ext_message_bus_value_get_listener (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GITG_EXT_MESSAGE_BUS_TYPE_LISTENER), NULL);
	return value->data[0].v_pointer;
}

static void
gitg_ext_message_bus_value_set_listener (GValue* value,
                                         gpointer v_object)
{
	GitgExtMessageBusListener * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GITG_EXT_MESSAGE_BUS_TYPE_LISTENER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GITG_EXT_MESSAGE_BUS_TYPE_LISTENER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		gitg_ext_message_bus_listener_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gitg_ext_message_bus_listener_unref (old);
	}
}

static void
gitg_ext_message_bus_value_take_listener (GValue* value,
                                          gpointer v_object)
{
	GitgExtMessageBusListener * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GITG_EXT_MESSAGE_BUS_TYPE_LISTENER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GITG_EXT_MESSAGE_BUS_TYPE_LISTENER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gitg_ext_message_bus_listener_unref (old);
	}
}

static void
gitg_ext_message_bus_listener_class_init (GitgExtMessageBusListenerClass * klass,
                                          gpointer klass_data)
{
	gitg_ext_message_bus_listener_parent_class = g_type_class_peek_parent (klass);
	((GitgExtMessageBusListenerClass *) klass)->finalize = gitg_ext_message_bus_listener_finalize;
}

static void
gitg_ext_message_bus_listener_instance_init (GitgExtMessageBusListener * self,
                                             gpointer klass)
{
	self->ref_count = 1;
}

static void
gitg_ext_message_bus_listener_finalize (GitgExtMessageBusListener * obj)
{
	GitgExtMessageBusListener * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_EXT_MESSAGE_BUS_TYPE_LISTENER, GitgExtMessageBusListener);
	g_signal_handlers_destroy (self);
	(self->callback_target_destroy_notify == NULL) ? NULL : (self->callback_target_destroy_notify (self->callback_target), NULL);
	self->callback = NULL;
	self->callback_target = NULL;
	self->callback_target_destroy_notify = NULL;
}

 G_GNUC_NO_INLINE static GType
gitg_ext_message_bus_listener_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { gitg_ext_message_bus_value_listener_init, gitg_ext_message_bus_value_listener_free_value, gitg_ext_message_bus_value_listener_copy_value, gitg_ext_message_bus_value_listener_peek_pointer, "p", gitg_ext_message_bus_value_listener_collect_value, "p", gitg_ext_message_bus_value_listener_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (GitgExtMessageBusListenerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_ext_message_bus_listener_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgExtMessageBusListener), 0, (GInstanceInitFunc) gitg_ext_message_bus_listener_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType gitg_ext_message_bus_listener_type_id;
	gitg_ext_message_bus_listener_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GitgExtMessageBusListener", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return gitg_ext_message_bus_listener_type_id;
}

static GType
gitg_ext_message_bus_listener_get_type (void)
{
	static gsize gitg_ext_message_bus_listener_type_id__once = 0;
	if (g_once_init_enter (&gitg_ext_message_bus_listener_type_id__once)) {
		GType gitg_ext_message_bus_listener_type_id;
		gitg_ext_message_bus_listener_type_id = gitg_ext_message_bus_listener_get_type_once ();
		g_once_init_leave (&gitg_ext_message_bus_listener_type_id__once, gitg_ext_message_bus_listener_type_id);
	}
	return gitg_ext_message_bus_listener_type_id__once;
}

static gpointer
gitg_ext_message_bus_listener_ref (gpointer instance)
{
	GitgExtMessageBusListener * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

static void
gitg_ext_message_bus_listener_unref (gpointer instance)
{
	GitgExtMessageBusListener * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GITG_EXT_MESSAGE_BUS_LISTENER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_gitg_ext_message_bus_listener_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (gitg_ext_message_bus_listener_unref (var), NULL));
}

static inline void
_g_list_free__gitg_ext_message_bus_listener_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _gitg_ext_message_bus_listener_unref0_);
}

static GitgExtMessageBusMessage*
gitg_ext_message_bus_message_construct (GType object_type,
                                        GitgExtMessageId* id)
{
	GitgExtMessageBusMessage* self = NULL;
	GitgExtMessageId* _tmp0_;
	g_return_val_if_fail (id != NULL, NULL);
	self = (GitgExtMessageBusMessage*) g_type_create_instance (object_type);
	_tmp0_ = gitg_ext_message_id_copy (id);
	_g_object_unref0 (self->id);
	self->id = _tmp0_;
	(self->listeners == NULL) ? NULL : (self->listeners = (_g_list_free__gitg_ext_message_bus_listener_unref0_ (self->listeners), NULL));
	self->listeners = NULL;
	return self;
}

static GitgExtMessageBusMessage*
gitg_ext_message_bus_message_new (GitgExtMessageId* id)
{
	return gitg_ext_message_bus_message_construct (GITG_EXT_MESSAGE_BUS_TYPE_MESSAGE, id);
}

static void
gitg_ext_message_bus_value_message_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
gitg_ext_message_bus_value_message_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		gitg_ext_message_bus_message_unref (value->data[0].v_pointer);
	}
}

static void
gitg_ext_message_bus_value_message_copy_value (const GValue* src_value,
                                               GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = gitg_ext_message_bus_message_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
gitg_ext_message_bus_value_message_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
gitg_ext_message_bus_value_message_collect_value (GValue* value,
                                                  guint n_collect_values,
                                                  GTypeCValue* collect_values,
                                                  guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		GitgExtMessageBusMessage * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = gitg_ext_message_bus_message_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
gitg_ext_message_bus_value_message_lcopy_value (const GValue* value,
                                                guint n_collect_values,
                                                GTypeCValue* collect_values,
                                                guint collect_flags)
{
	GitgExtMessageBusMessage ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = gitg_ext_message_bus_message_ref (value->data[0].v_pointer);
	}
	return NULL;
}

static GParamSpec*
gitg_ext_message_bus_param_spec_message (const gchar* name,
                                         const gchar* nick,
                                         const gchar* blurb,
                                         GType object_type,
                                         GParamFlags flags)
{
	GitgExtMessageBusParamSpecMessage* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GITG_EXT_MESSAGE_BUS_TYPE_MESSAGE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

static gpointer
gitg_ext_message_bus_value_get_message (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GITG_EXT_MESSAGE_BUS_TYPE_MESSAGE), NULL);
	return value->data[0].v_pointer;
}

static void
gitg_ext_message_bus_value_set_message (GValue* value,
                                        gpointer v_object)
{
	GitgExtMessageBusMessage * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GITG_EXT_MESSAGE_BUS_TYPE_MESSAGE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GITG_EXT_MESSAGE_BUS_TYPE_MESSAGE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		gitg_ext_message_bus_message_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gitg_ext_message_bus_message_unref (old);
	}
}

static void
gitg_ext_message_bus_value_take_message (GValue* value,
                                         gpointer v_object)
{
	GitgExtMessageBusMessage * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GITG_EXT_MESSAGE_BUS_TYPE_MESSAGE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GITG_EXT_MESSAGE_BUS_TYPE_MESSAGE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gitg_ext_message_bus_message_unref (old);
	}
}

static void
gitg_ext_message_bus_message_class_init (GitgExtMessageBusMessageClass * klass,
                                         gpointer klass_data)
{
	gitg_ext_message_bus_message_parent_class = g_type_class_peek_parent (klass);
	((GitgExtMessageBusMessageClass *) klass)->finalize = gitg_ext_message_bus_message_finalize;
}

static void
gitg_ext_message_bus_message_instance_init (GitgExtMessageBusMessage * self,
                                            gpointer klass)
{
	self->ref_count = 1;
}

static void
gitg_ext_message_bus_message_finalize (GitgExtMessageBusMessage * obj)
{
	GitgExtMessageBusMessage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_EXT_MESSAGE_BUS_TYPE_MESSAGE, GitgExtMessageBusMessage);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->id);
	(self->listeners == NULL) ? NULL : (self->listeners = (_g_list_free__gitg_ext_message_bus_listener_unref0_ (self->listeners), NULL));
}

 G_GNUC_NO_INLINE static GType
gitg_ext_message_bus_message_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { gitg_ext_message_bus_value_message_init, gitg_ext_message_bus_value_message_free_value, gitg_ext_message_bus_value_message_copy_value, gitg_ext_message_bus_value_message_peek_pointer, "p", gitg_ext_message_bus_value_message_collect_value, "p", gitg_ext_message_bus_value_message_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (GitgExtMessageBusMessageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_ext_message_bus_message_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgExtMessageBusMessage), 0, (GInstanceInitFunc) gitg_ext_message_bus_message_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType gitg_ext_message_bus_message_type_id;
	gitg_ext_message_bus_message_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GitgExtMessageBusMessage", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return gitg_ext_message_bus_message_type_id;
}

static GType
gitg_ext_message_bus_message_get_type (void)
{
	static gsize gitg_ext_message_bus_message_type_id__once = 0;
	if (g_once_init_enter (&gitg_ext_message_bus_message_type_id__once)) {
		GType gitg_ext_message_bus_message_type_id;
		gitg_ext_message_bus_message_type_id = gitg_ext_message_bus_message_get_type_once ();
		g_once_init_leave (&gitg_ext_message_bus_message_type_id__once, gitg_ext_message_bus_message_type_id);
	}
	return gitg_ext_message_bus_message_type_id__once;
}

static gpointer
gitg_ext_message_bus_message_ref (gpointer instance)
{
	GitgExtMessageBusMessage * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

static void
gitg_ext_message_bus_message_unref (gpointer instance)
{
	GitgExtMessageBusMessage * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GITG_EXT_MESSAGE_BUS_MESSAGE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static GitgExtMessageBusIdMap*
gitg_ext_message_bus_id_map_construct (GType object_type,
                                       GitgExtMessageBusMessage* message)
{
	GitgExtMessageBusIdMap* self = NULL;
	GitgExtMessageBusMessage* _tmp0_;
	g_return_val_if_fail (message != NULL, NULL);
	self = (GitgExtMessageBusIdMap*) g_type_create_instance (object_type);
	_tmp0_ = _gitg_ext_message_bus_message_ref0 (message);
	_gitg_ext_message_bus_message_unref0 (self->message);
	self->message = _tmp0_;
	return self;
}

static GitgExtMessageBusIdMap*
gitg_ext_message_bus_id_map_new (GitgExtMessageBusMessage* message)
{
	return gitg_ext_message_bus_id_map_construct (GITG_EXT_MESSAGE_BUS_TYPE_ID_MAP, message);
}

static void
gitg_ext_message_bus_value_id_map_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
gitg_ext_message_bus_value_id_map_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		gitg_ext_message_bus_id_map_unref (value->data[0].v_pointer);
	}
}

static void
gitg_ext_message_bus_value_id_map_copy_value (const GValue* src_value,
                                              GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = gitg_ext_message_bus_id_map_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
gitg_ext_message_bus_value_id_map_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
gitg_ext_message_bus_value_id_map_collect_value (GValue* value,
                                                 guint n_collect_values,
                                                 GTypeCValue* collect_values,
                                                 guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		GitgExtMessageBusIdMap * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = gitg_ext_message_bus_id_map_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
gitg_ext_message_bus_value_id_map_lcopy_value (const GValue* value,
                                               guint n_collect_values,
                                               GTypeCValue* collect_values,
                                               guint collect_flags)
{
	GitgExtMessageBusIdMap ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = gitg_ext_message_bus_id_map_ref (value->data[0].v_pointer);
	}
	return NULL;
}

static GParamSpec*
gitg_ext_message_bus_param_spec_id_map (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags)
{
	GitgExtMessageBusParamSpecIdMap* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GITG_EXT_MESSAGE_BUS_TYPE_ID_MAP), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

static gpointer
gitg_ext_message_bus_value_get_id_map (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GITG_EXT_MESSAGE_BUS_TYPE_ID_MAP), NULL);
	return value->data[0].v_pointer;
}

static void
gitg_ext_message_bus_value_set_id_map (GValue* value,
                                       gpointer v_object)
{
	GitgExtMessageBusIdMap * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GITG_EXT_MESSAGE_BUS_TYPE_ID_MAP));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GITG_EXT_MESSAGE_BUS_TYPE_ID_MAP));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		gitg_ext_message_bus_id_map_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gitg_ext_message_bus_id_map_unref (old);
	}
}

static void
gitg_ext_message_bus_value_take_id_map (GValue* value,
                                        gpointer v_object)
{
	GitgExtMessageBusIdMap * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GITG_EXT_MESSAGE_BUS_TYPE_ID_MAP));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GITG_EXT_MESSAGE_BUS_TYPE_ID_MAP));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gitg_ext_message_bus_id_map_unref (old);
	}
}

static void
gitg_ext_message_bus_id_map_class_init (GitgExtMessageBusIdMapClass * klass,
                                        gpointer klass_data)
{
	gitg_ext_message_bus_id_map_parent_class = g_type_class_peek_parent (klass);
	((GitgExtMessageBusIdMapClass *) klass)->finalize = gitg_ext_message_bus_id_map_finalize;
}

static void
gitg_ext_message_bus_id_map_instance_init (GitgExtMessageBusIdMap * self,
                                           gpointer klass)
{
	self->ref_count = 1;
}

static void
gitg_ext_message_bus_id_map_finalize (GitgExtMessageBusIdMap * obj)
{
	GitgExtMessageBusIdMap * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_EXT_MESSAGE_BUS_TYPE_ID_MAP, GitgExtMessageBusIdMap);
	g_signal_handlers_destroy (self);
	_gitg_ext_message_bus_message_unref0 (self->message);
}

 G_GNUC_NO_INLINE static GType
gitg_ext_message_bus_id_map_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { gitg_ext_message_bus_value_id_map_init, gitg_ext_message_bus_value_id_map_free_value, gitg_ext_message_bus_value_id_map_copy_value, gitg_ext_message_bus_value_id_map_peek_pointer, "p", gitg_ext_message_bus_value_id_map_collect_value, "p", gitg_ext_message_bus_value_id_map_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (GitgExtMessageBusIdMapClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_ext_message_bus_id_map_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgExtMessageBusIdMap), 0, (GInstanceInitFunc) gitg_ext_message_bus_id_map_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType gitg_ext_message_bus_id_map_type_id;
	gitg_ext_message_bus_id_map_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GitgExtMessageBusIdMap", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return gitg_ext_message_bus_id_map_type_id;
}

static GType
gitg_ext_message_bus_id_map_get_type (void)
{
	static gsize gitg_ext_message_bus_id_map_type_id__once = 0;
	if (g_once_init_enter (&gitg_ext_message_bus_id_map_type_id__once)) {
		GType gitg_ext_message_bus_id_map_type_id;
		gitg_ext_message_bus_id_map_type_id = gitg_ext_message_bus_id_map_get_type_once ();
		g_once_init_leave (&gitg_ext_message_bus_id_map_type_id__once, gitg_ext_message_bus_id_map_type_id);
	}
	return gitg_ext_message_bus_id_map_type_id__once;
}

static gpointer
gitg_ext_message_bus_id_map_ref (gpointer instance)
{
	GitgExtMessageBusIdMap * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

static void
gitg_ext_message_bus_id_map_unref (gpointer instance)
{
	GitgExtMessageBusIdMap * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GITG_EXT_MESSAGE_BUS_ID_MAP_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
gitg_ext_message_bus_class_init (GitgExtMessageBusClass * klass,
                                 gpointer klass_data)
{
	gitg_ext_message_bus_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GitgExtMessageBus_private_offset);
	((GitgExtMessageBusClass *) klass)->dispatch = gitg_ext_message_bus_real_dispatch;
	G_OBJECT_CLASS (klass)->finalize = gitg_ext_message_bus_finalize;
	gitg_ext_message_bus_signals[GITG_EXT_MESSAGE_BUS_REGISTERED_SIGNAL] = g_signal_new ("registered", GITG_EXT_TYPE_MESSAGE_BUS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GITG_EXT_TYPE_MESSAGE_ID);
	gitg_ext_message_bus_signals[GITG_EXT_MESSAGE_BUS_UNREGISTERED_SIGNAL] = g_signal_new ("unregistered", GITG_EXT_TYPE_MESSAGE_BUS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GITG_EXT_TYPE_MESSAGE_ID);
	gitg_ext_message_bus_signals[GITG_EXT_MESSAGE_BUS_DISPATCH_SIGNAL] = g_signal_new ("dispatch", GITG_EXT_TYPE_MESSAGE_BUS, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (GitgExtMessageBusClass, dispatch), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GITG_EXT_TYPE_MESSAGE);
}

static void
gitg_ext_message_bus_instance_init (GitgExtMessageBus * self,
                                    gpointer klass)
{
	self->priv = gitg_ext_message_bus_get_instance_private (self);
}

static void
gitg_ext_message_bus_finalize (GObject * obj)
{
	GitgExtMessageBus * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_EXT_TYPE_MESSAGE_BUS, GitgExtMessageBus);
	_g_hash_table_unref0 (self->priv->d_messages);
	_g_hash_table_unref0 (self->priv->d_idmap);
	_g_hash_table_unref0 (self->priv->d_types);
	G_OBJECT_CLASS (gitg_ext_message_bus_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
gitg_ext_message_bus_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GitgExtMessageBusClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_ext_message_bus_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgExtMessageBus), 0, (GInstanceInitFunc) gitg_ext_message_bus_instance_init, NULL };
	GType gitg_ext_message_bus_type_id;
	gitg_ext_message_bus_type_id = g_type_register_static (G_TYPE_OBJECT, "GitgExtMessageBus", &g_define_type_info, 0);
	GitgExtMessageBus_private_offset = g_type_add_instance_private (gitg_ext_message_bus_type_id, sizeof (GitgExtMessageBusPrivate));
	return gitg_ext_message_bus_type_id;
}

GType
gitg_ext_message_bus_get_type (void)
{
	static gsize gitg_ext_message_bus_type_id__once = 0;
	if (g_once_init_enter (&gitg_ext_message_bus_type_id__once)) {
		GType gitg_ext_message_bus_type_id;
		gitg_ext_message_bus_type_id = gitg_ext_message_bus_get_type_once ();
		g_once_init_leave (&gitg_ext_message_bus_type_id__once, gitg_ext_message_bus_type_id);
	}
	return gitg_ext_message_bus_type_id__once;
}

