/* graph-view.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from graph-view.vala, do not modify */

/* This file is part of Elastic. License: GPL-3.0+.*/

#include <adwaita.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <graphene-gobject.h>
#include <gsk/gsk.h>

#define ELASTIC_GRAPH_VIEW_TOP_PADDING 24
#define ELASTIC_GRAPH_VIEW_START_VALUE ((gdouble) 0)
#define ELASTIC_GRAPH_VIEW_END_VALUE ((gdouble) 1)
#define ELASTIC_GRAPH_VIEW_N_POINTS 1000
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define ELASTIC_TYPE_GRAPH_VIEW (elastic_graph_view_get_type ())
#define ELASTIC_GRAPH_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ELASTIC_TYPE_GRAPH_VIEW, ElasticGraphView))
#define ELASTIC_GRAPH_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ELASTIC_TYPE_GRAPH_VIEW, ElasticGraphViewClass))
#define ELASTIC_IS_GRAPH_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ELASTIC_TYPE_GRAPH_VIEW))
#define ELASTIC_IS_GRAPH_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ELASTIC_TYPE_GRAPH_VIEW))
#define ELASTIC_GRAPH_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ELASTIC_TYPE_GRAPH_VIEW, ElasticGraphViewClass))

typedef struct _ElasticGraphView ElasticGraphView;
typedef struct _ElasticGraphViewClass ElasticGraphViewClass;
typedef struct _ElasticGraphViewPrivate ElasticGraphViewPrivate;

#define ELASTIC_TYPE_SPRING_PARAMS (elastic_spring_params_get_type ())
#define ELASTIC_SPRING_PARAMS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ELASTIC_TYPE_SPRING_PARAMS, ElasticSpringParams))
#define ELASTIC_SPRING_PARAMS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ELASTIC_TYPE_SPRING_PARAMS, ElasticSpringParamsClass))
#define ELASTIC_IS_SPRING_PARAMS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ELASTIC_TYPE_SPRING_PARAMS))
#define ELASTIC_IS_SPRING_PARAMS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ELASTIC_TYPE_SPRING_PARAMS))
#define ELASTIC_SPRING_PARAMS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ELASTIC_TYPE_SPRING_PARAMS, ElasticSpringParamsClass))

typedef struct _ElasticSpringParams ElasticSpringParams;
typedef struct _ElasticSpringParamsClass ElasticSpringParamsClass;

#define ELASTIC_GRAPH_VIEW_TYPE_GRAPH_POINT (elastic_graph_view_graph_point_get_type ())
typedef struct _ElasticGraphViewGraphPoint ElasticGraphViewGraphPoint;
enum  {
	ELASTIC_GRAPH_VIEW_0_PROPERTY,
	ELASTIC_GRAPH_VIEW_SPRING_PROPERTY,
	ELASTIC_GRAPH_VIEW_NUM_PROPERTIES
};
static GParamSpec* elastic_graph_view_properties[ELASTIC_GRAPH_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _gsk_path_builder_unref0(var) ((var == NULL) ? NULL : (var = (gsk_path_builder_unref (var), NULL)))
#define _gsk_path_unref0(var) ((var == NULL) ? NULL : (var = (gsk_path_unref (var), NULL)))
#define __vala_GskStroke_free0(var) ((var == NULL) ? NULL : (var = (_vala_GskStroke_free (var), NULL)))
typedef enum  {
	ELASTIC_SEASON_INTERSEX,
	ELASTIC_SEASON_LESBIAN,
	ELASTIC_SEASON_AIDS,
	ELASTIC_SEASON_AUTISM,
	ELASTIC_SEASON_PAN,
	ELASTIC_SEASON_TRANS,
	ELASTIC_SEASON_ARO,
	ELASTIC_SEASON_ACE,
	ELASTIC_SEASON_BI,
	ELASTIC_SEASON_NON_BINARY,
	ELASTIC_SEASON_PRIDE,
	ELASTIC_SEASON_DISABILITY,
	ELASTIC_SEASON_BLACK_HISTORY
} ElasticSeason;

#define ELASTIC_TYPE_SEASON (elastic_season_get_type ())
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ElasticGraphView {
	AdwBin parent_instance;
	ElasticGraphViewPrivate * priv;
};

struct _ElasticGraphViewClass {
	AdwBinClass parent_class;
};

struct _ElasticGraphViewGraphPoint {
	gint64 time;
	gdouble value;
};

struct _ElasticGraphViewPrivate {
	ElasticSpringParams* _spring;
	GtkWidget* label_box;
	GtkLabel* duration_label;
	GtkLabel* min_label;
	GtkLabel* max_label;
	AdwSpringAnimation* animation;
	ElasticGraphViewGraphPoint* points;
	gint points_length1;
	gint _points_size_;
	gint64 start_time;
	gint64 current_time;
	gint64 duration;
	gdouble min;
	gdouble max;
	gint last_index;
};

static gint ElasticGraphView_private_offset;
static gpointer elastic_graph_view_parent_class = NULL;

VALA_EXTERN GType elastic_graph_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ElasticGraphView, g_object_unref)
VALA_EXTERN GType elastic_spring_params_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ElasticSpringParams, g_object_unref)
static GType elastic_graph_view_graph_point_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static ElasticGraphViewGraphPoint* elastic_graph_view_graph_point_dup (const ElasticGraphViewGraphPoint* self);
static void elastic_graph_view_graph_point_free (ElasticGraphViewGraphPoint* self);
VALA_EXTERN void elastic_graph_view_run_animation (ElasticGraphView* self);
static void elastic_graph_view_set_min (ElasticGraphView* self,
                                 gdouble min);
static void elastic_graph_view_set_max (ElasticGraphView* self,
                                 gdouble max);
VALA_EXTERN void elastic_graph_view_reset (ElasticGraphView* self);
VALA_EXTERN ElasticSpringParams* elastic_graph_view_get_spring (ElasticGraphView* self);
VALA_EXTERN void elastic_spring_params_apply (ElasticSpringParams* self,
                                  AdwSpringAnimation* animation);
static void _vala_array_add1 (ElasticGraphViewGraphPoint* * array,
                       gint* length,
                       gint* size,
                       const ElasticGraphViewGraphPoint* value);
static void _vala_array_add2 (ElasticGraphViewGraphPoint* * array,
                       gint* length,
                       gint* size,
                       const ElasticGraphViewGraphPoint* value);
static void _vala_array_add3 (ElasticGraphViewGraphPoint* * array,
                       gint* length,
                       gint* size,
                       const ElasticGraphViewGraphPoint* value);
static inline gdouble elastic_graph_view_inverse_lerp (ElasticGraphView* self,
                                         gdouble a,
                                         gdouble b,
                                         gdouble t);
static inline gfloat elastic_graph_view_transform_y (ElasticGraphView* self,
                                       gfloat height,
                                       gdouble y);
static inline gfloat elastic_graph_view_transform_x (ElasticGraphView* self,
                                       gfloat width,
                                       gdouble x);
static void elastic_graph_view_real_snapshot (GtkWidget* base,
                                       GtkSnapshot* snapshot);
static void _vala_GskStroke_free (GskStroke* self);
static void elastic_graph_view_append_background (ElasticGraphView* self,
                                           GtkSnapshot* snapshot,
                                           gboolean standalone,
                                           gfloat alpha);
static inline void elastic_graph_view_adjust_color (ElasticGraphView* self,
                                      GdkRGBA* rgba,
                                      gboolean standalone,
                                      gboolean dark,
                                      gfloat alpha,
                                      GdkRGBA* result);
VALA_EXTERN GType elastic_season_get_type (void) G_GNUC_CONST ;
VALA_EXTERN ElasticSeason* elastic_season_get_current (void);
VALA_EXTERN gchar** elastic_season_get_colors (ElasticSeason self,
                                   gint* result_length1);
static void _vala_array_add4 (GskColorStop* * array,
                       gint* length,
                       gint* size,
                       const GskColorStop* value);
static void elastic_graph_view_real_realize (GtkWidget* base);
static void _gtk_widget_queue_draw_g_object_notify (GObject* _sender,
                                             GParamSpec* pspec,
                                             gpointer self);
static void elastic_graph_view_real_unrealize (GtkWidget* base);
VALA_EXTERN ElasticGraphView* elastic_graph_view_new (void);
VALA_EXTERN ElasticGraphView* elastic_graph_view_construct (GType object_type);
VALA_EXTERN void elastic_graph_view_set_spring (ElasticGraphView* self,
                                    ElasticSpringParams* value);
static void _elastic_graph_view_reset_elastic_spring_params_changed (ElasticSpringParams* _sender,
                                                              gpointer self);
static GObject * elastic_graph_view_constructor (GType type,
                                          guint n_construct_properties,
                                          GObjectConstructParam * construct_properties);
static void _elastic_graph_view___lambda4_ (ElasticGraphView* self,
                                     gdouble value);
static void __elastic_graph_view___lambda4__adw_animation_target_func (gdouble value,
                                                                gpointer self);
static void _elastic_graph_view___lambda5_ (ElasticGraphView* self);
static void __elastic_graph_view___lambda5__adw_animation_done (AdwAnimation* _sender,
                                                         gpointer self);
static void elastic_graph_view_finalize (GObject * obj);
static GType elastic_graph_view_get_type_once (void);
static void _vala_elastic_graph_view_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec);
static void _vala_elastic_graph_view_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
elastic_graph_view_get_instance_private (ElasticGraphView* self)
{
	return G_STRUCT_MEMBER_P (self, ElasticGraphView_private_offset);
}

void
elastic_graph_view_run_animation (ElasticGraphView* self)
{
	GdkFrameClock* _tmp0_;
	AdwSpringAnimation* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_widget_get_frame_clock ((GtkWidget*) self);
	self->priv->start_time = gdk_frame_clock_get_frame_time (_tmp0_);
	_tmp1_ = self->priv->animation;
	adw_animation_play ((AdwAnimation*) _tmp1_);
}

static void
elastic_graph_view_set_min (ElasticGraphView* self,
                            gdouble min)
{
	GtkLabel* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	self->priv->min = min;
	_tmp0_ = self->priv->min_label;
	_tmp1_ = g_strdup_printf (_ ("Min: %.2lf"), min);
	_tmp2_ = _tmp1_;
	gtk_label_set_label (_tmp0_, _tmp2_);
	_g_free0 (_tmp2_);
}

static void
elastic_graph_view_set_max (ElasticGraphView* self,
                            gdouble max)
{
	GtkLabel* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	self->priv->max = max;
	_tmp0_ = self->priv->max_label;
	_tmp1_ = g_strdup_printf (_ ("Max: %.2lf"), max);
	_tmp2_ = _tmp1_;
	gtk_label_set_label (_tmp0_, _tmp2_);
	_g_free0 (_tmp2_);
}

static void
_vala_array_add1 (ElasticGraphViewGraphPoint* * array,
                  gint* length,
                  gint* size,
                  const ElasticGraphViewGraphPoint* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ElasticGraphViewGraphPoint, *array, *size);
	}
	(*array)[(*length)++] = *value;
}

static void
_vala_array_add2 (ElasticGraphViewGraphPoint* * array,
                  gint* length,
                  gint* size,
                  const ElasticGraphViewGraphPoint* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ElasticGraphViewGraphPoint, *array, *size);
	}
	(*array)[(*length)++] = *value;
}

static void
_vala_array_add3 (ElasticGraphViewGraphPoint* * array,
                  gint* length,
                  gint* size,
                  const ElasticGraphViewGraphPoint* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ElasticGraphViewGraphPoint, *array, *size);
	}
	(*array)[(*length)++] = *value;
}

void
elastic_graph_view_reset (ElasticGraphView* self)
{
	AdwSpringAnimation* _tmp0_;
	ElasticGraphViewGraphPoint* _tmp1_;
	ElasticSpringParams* _tmp2_;
	ElasticSpringParams* _tmp3_;
	AdwSpringAnimation* _tmp4_;
	guint estimated = 0U;
	AdwSpringAnimation* _tmp5_;
	guint _tmp6_;
	guint _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->animation;
	adw_animation_reset ((AdwAnimation*) _tmp0_);
	_tmp1_ = g_new0 (ElasticGraphViewGraphPoint, 0);
	self->priv->points = (g_free (self->priv->points), NULL);
	self->priv->points = _tmp1_;
	self->priv->points_length1 = 0;
	self->priv->_points_size_ = self->priv->points_length1;
	self->priv->min = MIN (ELASTIC_GRAPH_VIEW_START_VALUE, ELASTIC_GRAPH_VIEW_END_VALUE);
	self->priv->max = MAX (ELASTIC_GRAPH_VIEW_START_VALUE, ELASTIC_GRAPH_VIEW_END_VALUE);
	self->priv->current_time = (gint64) 0;
	self->priv->start_time = self->priv->current_time;
	self->priv->last_index = 0;
	_tmp2_ = elastic_graph_view_get_spring (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->animation;
	elastic_spring_params_apply (_tmp3_, _tmp4_);
	_tmp5_ = self->priv->animation;
	_tmp6_ = adw_spring_animation_get_estimated_duration (_tmp5_);
	_tmp7_ = _tmp6_;
	estimated = _tmp7_;
	if (estimated == G_MAXUINT) {
		GtkWidget* _tmp8_;
		self->priv->duration = (gint64) -1;
		_tmp8_ = self->priv->label_box;
		gtk_widget_set_opacity (_tmp8_, (gdouble) 0);
	} else {
		GtkLabel* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gdouble initial_velocity = 0.0;
		AdwSpringAnimation* _tmp12_;
		gdouble final_velocity = 0.0;
		AdwSpringAnimation* _tmp13_;
		ElasticGraphViewGraphPoint initial_point = {0};
		ElasticGraphViewGraphPoint _tmp14_ = {0};
		ElasticGraphViewGraphPoint _tmp15_;
		ElasticGraphViewGraphPoint final_point = {0};
		ElasticGraphViewGraphPoint _tmp21_ = {0};
		ElasticGraphViewGraphPoint _tmp22_;
		GtkWidget* _tmp23_;
		self->priv->duration = (gint64) (estimated * 1000);
		_tmp9_ = self->priv->duration_label;
		_tmp10_ = g_strdup_printf (_ ("Duration: %.0lf ms"), self->priv->duration / 1000.0);
		_tmp11_ = _tmp10_;
		gtk_label_set_label (_tmp9_, _tmp11_);
		_g_free0 (_tmp11_);
		_tmp12_ = self->priv->animation;
		initial_velocity = adw_spring_animation_calculate_velocity (_tmp12_, (guint) 0);
		_tmp13_ = self->priv->animation;
		final_velocity = adw_spring_animation_calculate_velocity (_tmp13_, estimated);
		_tmp14_.time = (gint64) -1000000;
		_tmp14_.value = ELASTIC_GRAPH_VIEW_START_VALUE - initial_velocity;
		initial_point = _tmp14_;
		_tmp15_ = initial_point;
		_vala_array_add1 (&self->priv->points, &self->priv->points_length1, &self->priv->_points_size_, &_tmp15_);
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp16_ = FALSE;
				_tmp16_ = TRUE;
				while (TRUE) {
					guint t = 0U;
					gdouble value = 0.0;
					AdwSpringAnimation* _tmp18_;
					gint64 time = 0LL;
					ElasticGraphViewGraphPoint point = {0};
					ElasticGraphViewGraphPoint _tmp19_ = {0};
					ElasticGraphViewGraphPoint _tmp20_;
					if (!_tmp16_) {
						gint _tmp17_;
						_tmp17_ = i;
						i = _tmp17_ + 1;
					}
					_tmp16_ = FALSE;
					if (!(i <= ELASTIC_GRAPH_VIEW_N_POINTS)) {
						break;
					}
					t = (guint) round ((((gdouble) i) * estimated) / ELASTIC_GRAPH_VIEW_N_POINTS);
					_tmp18_ = self->priv->animation;
					value = adw_spring_animation_calculate_value (_tmp18_, t);
					time = ((gint64) t) * 1000;
					_tmp19_.time = time;
					_tmp19_.value = value;
					point = _tmp19_;
					_tmp20_ = point;
					_vala_array_add2 (&self->priv->points, &self->priv->points_length1, &self->priv->_points_size_, &_tmp20_);
					if (value < self->priv->min) {
						self->priv->min = value;
					}
					if (value > self->priv->max) {
						self->priv->max = value;
					}
				}
			}
		}
		_tmp21_.time = (gint64) ((estimated + 1000) * 1000);
		_tmp21_.value = ELASTIC_GRAPH_VIEW_END_VALUE + final_velocity;
		final_point = _tmp21_;
		_tmp22_ = final_point;
		_vala_array_add3 (&self->priv->points, &self->priv->points_length1, &self->priv->_points_size_, &_tmp22_);
		_tmp23_ = self->priv->label_box;
		gtk_widget_set_opacity (_tmp23_, (gdouble) 1);
	}
	elastic_graph_view_set_min (self, self->priv->min);
	elastic_graph_view_set_max (self, self->priv->max);
	gtk_widget_queue_draw ((GtkWidget*) self);
}

static inline gdouble
elastic_graph_view_inverse_lerp (ElasticGraphView* self,
                                 gdouble a,
                                 gdouble b,
                                 gdouble t)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = (t - a) / (b - a);
	return result;
}

static inline gfloat
elastic_graph_view_transform_y (ElasticGraphView* self,
                                gfloat height,
                                gdouble y)
{
	gfloat bottom_padding = 0.0F;
	GtkWidget* _tmp0_;
	gdouble start = 0.0;
	gdouble end = 0.0;
	gdouble scale = 0.0;
	GtkNative* _tmp1_;
	GdkSurface* _tmp2_;
	gdouble _tmp3_;
	gdouble _tmp4_;
	gfloat result;
	g_return_val_if_fail (self != NULL, 0.0F);
	_tmp0_ = self->priv->label_box;
	bottom_padding = (gfloat) gtk_widget_get_height (_tmp0_);
	height = height - bottom_padding;
	if (self->priv->min == self->priv->max) {
		result = height / 2;
		return result;
	}
	start = height - ((height - ELASTIC_GRAPH_VIEW_TOP_PADDING) * elastic_graph_view_inverse_lerp (self, self->priv->min, self->priv->max, ELASTIC_GRAPH_VIEW_START_VALUE));
	end = height - ((height - ELASTIC_GRAPH_VIEW_TOP_PADDING) * elastic_graph_view_inverse_lerp (self, self->priv->min, self->priv->max, ELASTIC_GRAPH_VIEW_END_VALUE));
	_tmp1_ = gtk_widget_get_native ((GtkWidget*) self);
	_tmp2_ = gtk_native_get_surface (_tmp1_);
	_tmp3_ = gdk_surface_get_scale (_tmp2_);
	_tmp4_ = _tmp3_;
	scale = _tmp4_;
	start = round (start * scale) / scale;
	end = round (end * scale) / scale;
	result = (gfloat) adw_lerp (start, end, y);
	return result;
}

static inline gfloat
elastic_graph_view_transform_x (ElasticGraphView* self,
                                gfloat width,
                                gdouble x)
{
	gfloat result;
	g_return_val_if_fail (self != NULL, 0.0F);
	result = (((gfloat) x) * width) / self->priv->duration;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_vala_GskStroke_free (GskStroke* self)
{
	g_boxed_free (gsk_stroke_get_type (), self);
}

static void
elastic_graph_view_real_snapshot (GtkWidget* base,
                                  GtkSnapshot* snapshot)
{
	ElasticGraphView * self;
	AdwStyleManager* style_manager = NULL;
	AdwStyleManager* _tmp0_;
	AdwStyleManager* _tmp1_;
	gboolean dark = FALSE;
	AdwStyleManager* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean hc = FALSE;
	AdwStyleManager* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	gint width = 0;
	gint height = 0;
	gfloat y1 = 0.0F;
	gfloat y2 = 0.0F;
	ElasticGraphViewGraphPoint* _tmp8_;
	gint _tmp8__length1;
	ElasticGraphViewGraphPoint* _tmp9_;
	gint _tmp9__length1;
	graphene_point_t _tmp10_ = {0};
	GdkRGBA color = {0};
	GdkRGBA _tmp11_ = {0};
	GskPathBuilder* builder = NULL;
	GskPathBuilder* _tmp12_;
	GskPathBuilder* _tmp13_;
	GskPathBuilder* _tmp14_;
	GskPathBuilder* _tmp15_;
	GskPathBuilder* _tmp16_;
	GskPath* path = NULL;
	GskPathBuilder* _tmp17_;
	GskPath* _tmp18_;
	GskStroke* stroke = NULL;
	GskStroke* _tmp19_;
	GskStroke* _tmp20_;
	gfloat* _tmp21_;
	gfloat* _tmp22_;
	gint _tmp22__length1;
	gfloat _tmp23_ = 0.0F;
	gfloat dashed_alpha = 0.0F;
	GskPath* _tmp24_;
	GskStroke* _tmp25_;
	GdkRGBA _tmp26_;
	GdkRGBA _tmp27_;
	GdkRGBA _tmp28_;
	GdkRGBA _tmp29_;
	GdkRGBA _tmp30_ = {0};
	GskPathBuilder* _tmp31_;
	GskPathBuilder* _tmp41_;
	GskPath* _tmp42_;
	gfloat _tmp43_ = 0.0F;
	gfloat path_alpha = 0.0F;
	GskPath* _tmp44_;
	GskStroke* _tmp45_;
	GskStroke* _tmp46_;
	GdkRGBA _tmp47_;
	GdkRGBA _tmp48_;
	GdkRGBA _tmp49_;
	GdkRGBA _tmp50_;
	GdkRGBA _tmp51_ = {0};
	gfloat last_x = 0.0F;
	gfloat last_y = 0.0F;
	GskPathBuilder* _tmp52_;
	GskPath* filled_path = NULL;
	GskPathBuilder* _tmp64_;
	GskPath* _tmp65_;
	gfloat _tmp66_ = 0.0F;
	gfloat bottom_offset = 0.0F;
	GskPathBuilder* _tmp67_;
	GskPathBuilder* _tmp68_;
	GskPath* _tmp69_;
	GskPathBuilder* _tmp70_;
	GskPathBuilder* _tmp71_;
	GskPathBuilder* _tmp72_;
	ElasticGraphViewGraphPoint* _tmp73_;
	gint _tmp73__length1;
	ElasticGraphViewGraphPoint _tmp74_;
	GskPathBuilder* _tmp75_;
	ElasticGraphViewGraphPoint* _tmp76_;
	gint _tmp76__length1;
	ElasticGraphViewGraphPoint _tmp77_;
	ElasticGraphViewGraphPoint* _tmp78_;
	gint _tmp78__length1;
	ElasticGraphViewGraphPoint _tmp79_;
	GskPathBuilder* _tmp80_;
	GskPath* _tmp81_;
	GskPath* _tmp82_;
	GskStroke* _tmp83_;
	GskPath* _tmp84_;
	GskStroke* _tmp85_;
	self = (ElasticGraphView*) base;
	g_return_if_fail (snapshot != NULL);
	_tmp0_ = adw_style_manager_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	style_manager = _tmp1_;
	_tmp2_ = style_manager;
	_tmp3_ = adw_style_manager_get_dark (_tmp2_);
	_tmp4_ = _tmp3_;
	dark = _tmp4_;
	_tmp5_ = style_manager;
	_tmp6_ = adw_style_manager_get_high_contrast (_tmp5_);
	_tmp7_ = _tmp6_;
	hc = _tmp7_;
	width = gtk_widget_get_width ((GtkWidget*) self);
	height = gtk_widget_get_height ((GtkWidget*) self);
	y1 = elastic_graph_view_transform_y (self, (gfloat) height, ELASTIC_GRAPH_VIEW_START_VALUE);
	y2 = elastic_graph_view_transform_y (self, (gfloat) height, ELASTIC_GRAPH_VIEW_END_VALUE);
	_tmp8_ = self->priv->points;
	_tmp8__length1 = self->priv->points_length1;
	_vala_assert (_tmp8_ != NULL, "points != null");
	_tmp9_ = self->priv->points;
	_tmp9__length1 = self->priv->points_length1;
	if (_tmp9__length1 == 0) {
		GTK_WIDGET_CLASS (elastic_graph_view_parent_class)->snapshot ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, adw_bin_get_type (), AdwBin), snapshot);
		_g_object_unref0 (style_manager);
		return;
	}
	_tmp10_.x = (gfloat) 0;
	_tmp10_.y = 0.5f;
	gtk_snapshot_translate (snapshot, &_tmp10_);
	gtk_widget_get_color ((GtkWidget*) self, &_tmp11_);
	color = _tmp11_;
	_tmp12_ = gsk_path_builder_new ();
	builder = _tmp12_;
	_tmp13_ = builder;
	gsk_path_builder_move_to (_tmp13_, (gfloat) 0, y1);
	_tmp14_ = builder;
	gsk_path_builder_rel_line_to (_tmp14_, (gfloat) width, (gfloat) 0);
	_tmp15_ = builder;
	gsk_path_builder_move_to (_tmp15_, (gfloat) 0, y2);
	_tmp16_ = builder;
	gsk_path_builder_rel_line_to (_tmp16_, (gfloat) width, (gfloat) 0);
	_tmp17_ = builder;
	_tmp18_ = gsk_path_builder_to_path (_tmp17_);
	path = _tmp18_;
	_tmp19_ = gsk_stroke_new ((gfloat) 1);
	stroke = _tmp19_;
	_tmp20_ = stroke;
	_tmp21_ = g_new0 (gfloat, 2);
	_tmp21_[0] = (gfloat) 4;
	_tmp21_[1] = (gfloat) 2;
	_tmp22_ = _tmp21_;
	_tmp22__length1 = 2;
	gsk_stroke_set_dash (_tmp20_, _tmp22_, (gsize) 2);
	_tmp22_ = (g_free (_tmp22_), NULL);
	if (hc) {
		_tmp23_ = 0.5f;
	} else {
		_tmp23_ = 0.15f;
	}
	dashed_alpha = _tmp23_;
	_tmp24_ = path;
	_tmp25_ = stroke;
	_tmp26_ = color;
	_tmp27_ = color;
	_tmp28_ = color;
	_tmp29_ = color;
	_tmp30_.red = _tmp26_.red;
	_tmp30_.green = _tmp27_.green;
	_tmp30_.blue = _tmp28_.blue;
	_tmp30_.alpha = _tmp29_.alpha * dashed_alpha;
	gtk_snapshot_append_stroke (snapshot, _tmp24_, _tmp25_, &_tmp30_);
	_tmp31_ = gsk_path_builder_new ();
	_gsk_path_builder_unref0 (builder);
	builder = _tmp31_;
	{
		gint i = 0;
		i = self->priv->last_index;
		{
			gboolean _tmp32_ = FALSE;
			_tmp32_ = TRUE;
			while (TRUE) {
				ElasticGraphViewGraphPoint* _tmp34_;
				gint _tmp34__length1;
				gfloat x = 0.0F;
				ElasticGraphViewGraphPoint* _tmp35_;
				gint _tmp35__length1;
				ElasticGraphViewGraphPoint _tmp36_;
				gfloat y = 0.0F;
				ElasticGraphViewGraphPoint* _tmp37_;
				gint _tmp37__length1;
				ElasticGraphViewGraphPoint _tmp38_;
				GskPathBuilder* _tmp40_;
				if (!_tmp32_) {
					gint _tmp33_;
					_tmp33_ = i;
					i = _tmp33_ + 1;
				}
				_tmp32_ = FALSE;
				_tmp34_ = self->priv->points;
				_tmp34__length1 = self->priv->points_length1;
				if (!(i < _tmp34__length1)) {
					break;
				}
				_tmp35_ = self->priv->points;
				_tmp35__length1 = self->priv->points_length1;
				_tmp36_ = _tmp35_[i];
				x = elastic_graph_view_transform_x (self, (gfloat) width, (gdouble) _tmp36_.time);
				_tmp37_ = self->priv->points;
				_tmp37__length1 = self->priv->points_length1;
				_tmp38_ = _tmp37_[i];
				y = elastic_graph_view_transform_y (self, (gfloat) height, _tmp38_.value);
				if (i == self->priv->last_index) {
					GskPathBuilder* _tmp39_;
					_tmp39_ = builder;
					gsk_path_builder_move_to (_tmp39_, x, y);
				}
				_tmp40_ = builder;
				gsk_path_builder_line_to (_tmp40_, x, y);
			}
		}
	}
	_tmp41_ = builder;
	_tmp42_ = gsk_path_builder_to_path (_tmp41_);
	_gsk_path_unref0 (path);
	path = _tmp42_;
	if (hc) {
		_tmp43_ = 0.65f;
	} else {
		_tmp43_ = 0.25f;
	}
	path_alpha = _tmp43_;
	_tmp44_ = path;
	_tmp45_ = gsk_stroke_new ((gfloat) 1);
	_tmp46_ = _tmp45_;
	_tmp47_ = color;
	_tmp48_ = color;
	_tmp49_ = color;
	_tmp50_ = color;
	_tmp51_.red = _tmp47_.red;
	_tmp51_.green = _tmp48_.green;
	_tmp51_.blue = _tmp49_.blue;
	_tmp51_.alpha = _tmp50_.alpha * path_alpha;
	gtk_snapshot_append_stroke (snapshot, _tmp44_, _tmp46_, &_tmp51_);
	__vala_GskStroke_free0 (_tmp46_);
	if (self->priv->current_time == ((gint64) 0)) {
		GTK_WIDGET_CLASS (elastic_graph_view_parent_class)->snapshot ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, adw_bin_get_type (), AdwBin), snapshot);
		__vala_GskStroke_free0 (stroke);
		_gsk_path_unref0 (path);
		_gsk_path_builder_unref0 (builder);
		_g_object_unref0 (style_manager);
		return;
	}
	last_x = (gfloat) 0;
	last_y = (gfloat) 0;
	_tmp52_ = gsk_path_builder_new ();
	_gsk_path_builder_unref0 (builder);
	builder = _tmp52_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp53_ = FALSE;
			_tmp53_ = TRUE;
			while (TRUE) {
				ElasticGraphViewGraphPoint* _tmp55_;
				gint _tmp55__length1;
				ElasticGraphViewGraphPoint* _tmp56_;
				gint _tmp56__length1;
				ElasticGraphViewGraphPoint _tmp57_;
				gfloat x = 0.0F;
				ElasticGraphViewGraphPoint* _tmp58_;
				gint _tmp58__length1;
				ElasticGraphViewGraphPoint _tmp59_;
				gfloat y = 0.0F;
				ElasticGraphViewGraphPoint* _tmp60_;
				gint _tmp60__length1;
				ElasticGraphViewGraphPoint _tmp61_;
				GskPathBuilder* _tmp63_;
				if (!_tmp53_) {
					gint _tmp54_;
					_tmp54_ = i;
					i = _tmp54_ + 1;
				}
				_tmp53_ = FALSE;
				_tmp55_ = self->priv->points;
				_tmp55__length1 = self->priv->points_length1;
				if (!(i < _tmp55__length1)) {
					break;
				}
				_tmp56_ = self->priv->points;
				_tmp56__length1 = self->priv->points_length1;
				_tmp57_ = _tmp56_[i];
				if (_tmp57_.time > self->priv->current_time) {
					self->priv->last_index = i - 1;
					break;
				}
				_tmp58_ = self->priv->points;
				_tmp58__length1 = self->priv->points_length1;
				_tmp59_ = _tmp58_[i];
				x = elastic_graph_view_transform_x (self, (gfloat) width, (gdouble) _tmp59_.time);
				_tmp60_ = self->priv->points;
				_tmp60__length1 = self->priv->points_length1;
				_tmp61_ = _tmp60_[i];
				y = elastic_graph_view_transform_y (self, (gfloat) height, _tmp61_.value);
				last_x = x;
				last_y = y;
				if (i == 0) {
					GskPathBuilder* _tmp62_;
					_tmp62_ = builder;
					gsk_path_builder_move_to (_tmp62_, x, y);
				}
				_tmp63_ = builder;
				gsk_path_builder_line_to (_tmp63_, x, y);
			}
		}
	}
	_tmp64_ = builder;
	_tmp65_ = gsk_path_builder_to_path (_tmp64_);
	filled_path = _tmp65_;
	if (dark) {
		_tmp66_ = -0.5f;
	} else {
		_tmp66_ = 0.5f;
	}
	bottom_offset = _tmp66_;
	_tmp67_ = gsk_path_builder_new ();
	_gsk_path_builder_unref0 (builder);
	builder = _tmp67_;
	_tmp68_ = builder;
	_tmp69_ = filled_path;
	gsk_path_builder_add_path (_tmp68_, _tmp69_);
	_tmp70_ = builder;
	gsk_path_builder_move_to (_tmp70_, last_x, last_y);
	_tmp71_ = builder;
	gsk_path_builder_line_to (_tmp71_, last_x, height + bottom_offset);
	_tmp72_ = builder;
	_tmp73_ = self->priv->points;
	_tmp73__length1 = self->priv->points_length1;
	_tmp74_ = _tmp73_[0];
	gsk_path_builder_line_to (_tmp72_, elastic_graph_view_transform_x (self, (gfloat) width, (gdouble) _tmp74_.time), height + bottom_offset);
	_tmp75_ = builder;
	_tmp76_ = self->priv->points;
	_tmp76__length1 = self->priv->points_length1;
	_tmp77_ = _tmp76_[0];
	_tmp78_ = self->priv->points;
	_tmp78__length1 = self->priv->points_length1;
	_tmp79_ = _tmp78_[0];
	gsk_path_builder_line_to (_tmp75_, elastic_graph_view_transform_x (self, (gfloat) width, (gdouble) _tmp77_.time), elastic_graph_view_transform_y (self, (gfloat) height, _tmp79_.value));
	_tmp80_ = builder;
	_tmp81_ = gsk_path_builder_to_path (_tmp80_);
	_gsk_path_unref0 (path);
	path = _tmp81_;
	_tmp82_ = path;
	gtk_snapshot_push_fill (snapshot, _tmp82_, GSK_FILL_RULE_EVEN_ODD);
	elastic_graph_view_append_background (self, snapshot, FALSE, 0.2f);
	gtk_snapshot_pop (snapshot);
	_tmp83_ = gsk_stroke_new ((gfloat) 2);
	__vala_GskStroke_free0 (stroke);
	stroke = _tmp83_;
	_tmp84_ = filled_path;
	_tmp85_ = stroke;
	gtk_snapshot_push_stroke (snapshot, _tmp84_, _tmp85_);
	elastic_graph_view_append_background (self, snapshot, TRUE, 1.0f);
	gtk_snapshot_pop (snapshot);
	GTK_WIDGET_CLASS (elastic_graph_view_parent_class)->snapshot ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, adw_bin_get_type (), AdwBin), snapshot);
	_gsk_path_unref0 (filled_path);
	__vala_GskStroke_free0 (stroke);
	_gsk_path_unref0 (path);
	_gsk_path_builder_unref0 (builder);
	_g_object_unref0 (style_manager);
}

static inline void
elastic_graph_view_adjust_color (ElasticGraphView* self,
                                 GdkRGBA* rgba,
                                 gboolean standalone,
                                 gboolean dark,
                                 gfloat alpha,
                                 GdkRGBA* result)
{
	GdkRGBA _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (rgba != NULL);
	if (standalone) {
		GdkRGBA _tmp0_;
		GdkRGBA _tmp1_ = {0};
		_tmp0_ = *rgba;
		adw_rgba_to_standalone (&_tmp0_, dark, &_tmp1_);
		*rgba = _tmp1_;
	}
	(*rgba).alpha = (*rgba).alpha * alpha;
	_tmp2_ = *rgba;
	*result = _tmp2_;
	return;
}

static void
_vala_array_add4 (GskColorStop* * array,
                  gint* length,
                  gint* size,
                  const GskColorStop* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GskColorStop, *array, *size);
	}
	(*array)[(*length)++] = *value;
}

static void
elastic_graph_view_append_background (ElasticGraphView* self,
                                      GtkSnapshot* snapshot,
                                      gboolean standalone,
                                      gfloat alpha)
{
	AdwStyleManager* style_manager = NULL;
	AdwStyleManager* _tmp0_;
	AdwStyleManager* _tmp1_;
	AdwAccentColor accent = 0;
	AdwStyleManager* _tmp2_;
	AdwAccentColor _tmp3_;
	AdwAccentColor _tmp4_;
	gboolean dark = FALSE;
	AdwStyleManager* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	gint width = 0;
	gint height = 0;
	graphene_rect_t rect = {0};
	graphene_rect_t _tmp8_ = {0};
	ElasticSeason* _tmp9_ = NULL;
	ElasticSeason* _tmp10_;
	gchar** _tmp11_ = NULL;
	gint _tmp11__length1;
	gint __tmp11__size_;
	gchar** colors = NULL;
	gchar** _tmp14_;
	gint _tmp14__length1;
	gint colors_length1;
	gint _colors_size_;
	gchar** _tmp15_;
	gint _tmp15__length1;
	GskColorStop* stops = NULL;
	GskColorStop* _tmp21_;
	gint stops_length1;
	gint _stops_size_;
	graphene_rect_t _tmp34_;
	graphene_point_t _tmp35_ = {0};
	graphene_point_t _tmp36_ = {0};
	GskColorStop* _tmp37_;
	gint _tmp37__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (snapshot != NULL);
	_tmp0_ = adw_style_manager_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	style_manager = _tmp1_;
	_tmp2_ = style_manager;
	_tmp3_ = adw_style_manager_get_accent_color (_tmp2_);
	_tmp4_ = _tmp3_;
	accent = _tmp4_;
	_tmp5_ = style_manager;
	_tmp6_ = adw_style_manager_get_dark (_tmp5_);
	_tmp7_ = _tmp6_;
	dark = _tmp7_;
	width = gtk_widget_get_width ((GtkWidget*) self);
	height = gtk_widget_get_height ((GtkWidget*) self);
	_tmp8_.origin = (graphene_point_t) {(gfloat) 0, (gfloat) 0};
	_tmp8_.size = (graphene_size_t) {(gfloat) width, (gfloat) height};
	rect = _tmp8_;
	_tmp10_ = elastic_season_get_current ();
	_tmp9_ = _tmp10_;
	_tmp11_ = NULL;
	_tmp11__length1 = 0;
	__tmp11__size_ = _tmp11__length1;
	if (_tmp9_ != NULL) {
		gint _tmp12_ = 0;
		gchar** _tmp13_;
		_tmp13_ = elastic_season_get_colors (*_tmp9_, &_tmp12_);
		_tmp11_ = (_vala_array_free (_tmp11_, _tmp11__length1, (GDestroyNotify) g_free), NULL);
		_tmp11_ = _tmp13_;
		_tmp11__length1 = _tmp12_;
		__tmp11__size_ = _tmp11__length1;
	}
	_tmp14_ = _tmp11_;
	_tmp14__length1 = _tmp11__length1;
	_tmp11_ = NULL;
	_tmp11__length1 = 0;
	colors = _tmp14_;
	colors_length1 = _tmp14__length1;
	_colors_size_ = colors_length1;
	_tmp15_ = colors;
	_tmp15__length1 = colors_length1;
	if (_tmp15_ == NULL) {
		GdkRGBA color = {0};
		GdkRGBA _tmp16_ = {0};
		GdkRGBA _tmp17_;
		GdkRGBA _tmp18_ = {0};
		GdkRGBA _tmp19_;
		graphene_rect_t _tmp20_;
		adw_accent_color_to_rgba (accent, &_tmp16_);
		color = _tmp16_;
		_tmp17_ = color;
		elastic_graph_view_adjust_color (self, &_tmp17_, standalone, dark, alpha, &_tmp18_);
		color = _tmp18_;
		_tmp19_ = color;
		_tmp20_ = rect;
		gtk_snapshot_append_color (snapshot, &_tmp19_, &_tmp20_);
		colors = (_vala_array_free (colors, colors_length1, (GDestroyNotify) g_free), NULL);
		_tmp11_ = (_vala_array_free (_tmp11_, _tmp11__length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (_tmp9_);
		_g_object_unref0 (style_manager);
		return;
	}
	_tmp21_ = g_new0 (GskColorStop, 0);
	stops = _tmp21_;
	stops_length1 = 0;
	_stops_size_ = stops_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp22_ = FALSE;
			_tmp22_ = TRUE;
			while (TRUE) {
				gchar** _tmp24_;
				gint _tmp24__length1;
				GdkRGBA color = {0};
				GdkRGBA _tmp25_ = {0};
				gchar** _tmp26_;
				gint _tmp26__length1;
				const gchar* _tmp27_;
				GdkRGBA _tmp28_;
				GdkRGBA _tmp29_ = {0};
				gfloat offset = 0.0F;
				gchar** _tmp30_;
				gint _tmp30__length1;
				GskColorStop stop = {0};
				GdkRGBA _tmp31_;
				GskColorStop _tmp32_ = {0};
				GskColorStop _tmp33_;
				if (!_tmp22_) {
					gint _tmp23_;
					_tmp23_ = i;
					i = _tmp23_ + 1;
				}
				_tmp22_ = FALSE;
				_tmp24_ = colors;
				_tmp24__length1 = colors_length1;
				if (!(i < _tmp24__length1)) {
					break;
				}
				color = _tmp25_;
				_tmp26_ = colors;
				_tmp26__length1 = colors_length1;
				_tmp27_ = _tmp26_[i];
				_vala_assert (gdk_rgba_parse (&color, _tmp27_), "color.parse (colors[i])");
				_tmp28_ = color;
				elastic_graph_view_adjust_color (self, &_tmp28_, standalone, dark, alpha, &_tmp29_);
				color = _tmp29_;
				_tmp30_ = colors;
				_tmp30__length1 = colors_length1;
				offset = ((gfloat) i) / ((gfloat) (_tmp30__length1 - 1));
				_tmp31_ = color;
				_tmp32_.offset = offset;
				_tmp32_.color = _tmp31_;
				stop = _tmp32_;
				_tmp33_ = stop;
				_vala_array_add4 (&stops, &stops_length1, &_stops_size_, &_tmp33_);
			}
		}
	}
	_tmp34_ = rect;
	_tmp35_.x = (gfloat) 0;
	_tmp35_.y = (gfloat) 0;
	_tmp36_.x = (gfloat) width;
	_tmp36_.y = (gfloat) 0;
	_tmp37_ = stops;
	_tmp37__length1 = stops_length1;
	gtk_snapshot_append_linear_gradient (snapshot, &_tmp34_, &_tmp35_, &_tmp36_, _tmp37_, (gsize) _tmp37__length1);
	stops = (g_free (stops), NULL);
	colors = (_vala_array_free (colors, colors_length1, (GDestroyNotify) g_free), NULL);
	_tmp11_ = (_vala_array_free (_tmp11_, _tmp11__length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (_tmp9_);
	_g_object_unref0 (style_manager);
}

static void
_gtk_widget_queue_draw_g_object_notify (GObject* _sender,
                                        GParamSpec* pspec,
                                        gpointer self)
{
	gtk_widget_queue_draw ((GtkWidget*) self);
}

static void
elastic_graph_view_real_realize (GtkWidget* base)
{
	ElasticGraphView * self;
	GtkNative* _tmp0_;
	GdkSurface* _tmp1_;
	self = (ElasticGraphView*) base;
	GTK_WIDGET_CLASS (elastic_graph_view_parent_class)->realize ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, adw_bin_get_type (), AdwBin));
	_tmp0_ = gtk_widget_get_native ((GtkWidget*) self);
	_tmp1_ = gtk_native_get_surface (_tmp0_);
	g_signal_connect_object ((GObject*) _tmp1_, "notify::scale", (GCallback) _gtk_widget_queue_draw_g_object_notify, (GtkWidget*) self, 0);
}

static void
elastic_graph_view_real_unrealize (GtkWidget* base)
{
	ElasticGraphView * self;
	GtkNative* _tmp0_;
	GdkSurface* _tmp1_;
	guint _tmp2_;
	GQuark _tmp3_;
	self = (ElasticGraphView*) base;
	_tmp0_ = gtk_widget_get_native ((GtkWidget*) self);
	_tmp1_ = gtk_native_get_surface (_tmp0_);
	g_signal_parse_name ("notify::scale", G_TYPE_OBJECT, &_tmp2_, &_tmp3_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) _tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, _tmp3_, NULL, (GCallback) _gtk_widget_queue_draw_g_object_notify, (GtkWidget*) self);
	GTK_WIDGET_CLASS (elastic_graph_view_parent_class)->unrealize ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, adw_bin_get_type (), AdwBin));
}

ElasticGraphView*
elastic_graph_view_construct (GType object_type)
{
	ElasticGraphView * self = NULL;
	self = (ElasticGraphView*) g_object_new (object_type, NULL);
	return self;
}

ElasticGraphView*
elastic_graph_view_new (void)
{
	return elastic_graph_view_construct (ELASTIC_TYPE_GRAPH_VIEW);
}

ElasticSpringParams*
elastic_graph_view_get_spring (ElasticGraphView* self)
{
	ElasticSpringParams* result;
	ElasticSpringParams* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_spring;
	result = _tmp0_;
	return result;
}

static void
_elastic_graph_view_reset_elastic_spring_params_changed (ElasticSpringParams* _sender,
                                                         gpointer self)
{
	elastic_graph_view_reset ((ElasticGraphView*) self);
}

void
elastic_graph_view_set_spring (ElasticGraphView* self,
                               ElasticSpringParams* value)
{
	ElasticSpringParams* _tmp0_;
	ElasticSpringParams* _tmp1_;
	ElasticSpringParams* _tmp2_;
	ElasticSpringParams* _tmp3_;
	ElasticSpringParams* _tmp7_;
	ElasticSpringParams* _tmp8_;
	ElasticSpringParams* _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = elastic_graph_view_get_spring (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == value) {
		return;
	}
	_tmp2_ = elastic_graph_view_get_spring (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != NULL) {
		ElasticSpringParams* _tmp4_;
		ElasticSpringParams* _tmp5_;
		guint _tmp6_;
		_tmp4_ = elastic_graph_view_get_spring (self);
		_tmp5_ = _tmp4_;
		g_signal_parse_name ("changed", ELASTIC_TYPE_SPRING_PARAMS, &_tmp6_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp5_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp6_, 0, NULL, (GCallback) _elastic_graph_view_reset_elastic_spring_params_changed, self);
	}
	_tmp7_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_spring);
	self->priv->_spring = _tmp7_;
	_tmp8_ = elastic_graph_view_get_spring (self);
	_tmp9_ = _tmp8_;
	if (_tmp9_ != NULL) {
		ElasticSpringParams* _tmp10_;
		ElasticSpringParams* _tmp11_;
		_tmp10_ = elastic_graph_view_get_spring (self);
		_tmp11_ = _tmp10_;
		g_signal_connect_object (_tmp11_, "changed", (GCallback) _elastic_graph_view_reset_elastic_spring_params_changed, self, 0);
	}
	elastic_graph_view_reset (self);
	g_object_notify_by_pspec ((GObject *) self, elastic_graph_view_properties[ELASTIC_GRAPH_VIEW_SPRING_PROPERTY]);
}

static ElasticGraphViewGraphPoint*
elastic_graph_view_graph_point_dup (const ElasticGraphViewGraphPoint* self)
{
	ElasticGraphViewGraphPoint* dup;
	dup = g_new0 (ElasticGraphViewGraphPoint, 1);
	memcpy (dup, self, sizeof (ElasticGraphViewGraphPoint));
	return dup;
}

static void
elastic_graph_view_graph_point_free (ElasticGraphViewGraphPoint* self)
{
	g_free (self);
}

static GType
elastic_graph_view_graph_point_get_type_once (void)
{
	GType elastic_graph_view_graph_point_type_id;
	elastic_graph_view_graph_point_type_id = g_boxed_type_register_static ("ElasticGraphViewGraphPoint", (GBoxedCopyFunc) elastic_graph_view_graph_point_dup, (GBoxedFreeFunc) elastic_graph_view_graph_point_free);
	return elastic_graph_view_graph_point_type_id;
}

static GType
elastic_graph_view_graph_point_get_type (void)
{
	static volatile gsize elastic_graph_view_graph_point_type_id__once = 0;
	if (g_once_init_enter (&elastic_graph_view_graph_point_type_id__once)) {
		GType elastic_graph_view_graph_point_type_id;
		elastic_graph_view_graph_point_type_id = elastic_graph_view_graph_point_get_type_once ();
		g_once_init_leave (&elastic_graph_view_graph_point_type_id__once, elastic_graph_view_graph_point_type_id);
	}
	return elastic_graph_view_graph_point_type_id__once;
}

static void
_elastic_graph_view___lambda4_ (ElasticGraphView* self,
                                gdouble value)
{
	GdkFrameClock* _tmp0_;
	_tmp0_ = gtk_widget_get_frame_clock ((GtkWidget*) self);
	self->priv->current_time = gdk_frame_clock_get_frame_time (_tmp0_) - self->priv->start_time;
	gtk_widget_queue_draw ((GtkWidget*) self);
}

static void
__elastic_graph_view___lambda4__adw_animation_target_func (gdouble value,
                                                           gpointer self)
{
	_elastic_graph_view___lambda4_ ((ElasticGraphView*) self, value);
}

static void
_elastic_graph_view___lambda5_ (ElasticGraphView* self)
{
	self->priv->current_time = G_MAXINT64;
	gtk_widget_queue_draw ((GtkWidget*) self);
}

static void
__elastic_graph_view___lambda5__adw_animation_done (AdwAnimation* _sender,
                                                    gpointer self)
{
	_elastic_graph_view___lambda5_ ((ElasticGraphView*) self);
}

static GObject *
elastic_graph_view_constructor (GType type,
                                guint n_construct_properties,
                                GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ElasticGraphView * self;
	AdwSpringParams* _tmp0_;
	AdwCallbackAnimationTarget* _tmp1_;
	AdwSpringAnimation* _tmp2_;
	AdwSpringAnimation* _tmp3_;
	AdwSpringAnimation* _tmp4_;
	AdwStyleManager* style_manager = NULL;
	AdwStyleManager* _tmp5_;
	AdwStyleManager* _tmp6_;
	AdwStyleManager* _tmp7_;
	AdwStyleManager* _tmp8_;
	AdwStyleManager* _tmp9_;
	parent_class = G_OBJECT_CLASS (elastic_graph_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ELASTIC_TYPE_GRAPH_VIEW, ElasticGraphView);
	_tmp0_ = adw_spring_params_new_full ((gdouble) 1, (gdouble) 1, (gdouble) 1);
	_tmp1_ = (AdwCallbackAnimationTarget*) adw_callback_animation_target_new (__elastic_graph_view___lambda4__adw_animation_target_func, g_object_ref (self), g_object_unref);
	_tmp2_ = (AdwSpringAnimation*) adw_spring_animation_new ((GtkWidget*) self, ELASTIC_GRAPH_VIEW_START_VALUE, ELASTIC_GRAPH_VIEW_END_VALUE, _tmp0_, (AdwAnimationTarget*) _tmp1_);
	_g_object_unref0 (self->priv->animation);
	self->priv->animation = _tmp2_;
	_tmp3_ = self->priv->animation;
	g_signal_connect_object ((AdwAnimation*) _tmp3_, "done", (GCallback) __elastic_graph_view___lambda5__adw_animation_done, self, 0);
	_tmp4_ = self->priv->animation;
	adw_animation_set_follow_enable_animations_setting ((AdwAnimation*) _tmp4_, FALSE);
	_tmp5_ = adw_style_manager_get_default ();
	_tmp6_ = _g_object_ref0 (_tmp5_);
	style_manager = _tmp6_;
	_tmp7_ = style_manager;
	g_signal_connect_object ((GObject*) _tmp7_, "notify::dark", (GCallback) _gtk_widget_queue_draw_g_object_notify, (GtkWidget*) self, 0);
	_tmp8_ = style_manager;
	g_signal_connect_object ((GObject*) _tmp8_, "notify::high-contrast", (GCallback) _gtk_widget_queue_draw_g_object_notify, (GtkWidget*) self, 0);
	_tmp9_ = style_manager;
	g_signal_connect_object ((GObject*) _tmp9_, "notify::accent-color", (GCallback) _gtk_widget_queue_draw_g_object_notify, (GtkWidget*) self, 0);
	_g_object_unref0 (style_manager);
	return obj;
}

static void
elastic_graph_view_class_init (ElasticGraphViewClass * klass,
                               gpointer klass_data)
{
	elastic_graph_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ElasticGraphView_private_offset);
	((GtkWidgetClass *) klass)->snapshot = (void (*) (GtkWidget*, GtkSnapshot*)) elastic_graph_view_real_snapshot;
	((GtkWidgetClass *) klass)->realize = (void (*) (GtkWidget*)) elastic_graph_view_real_realize;
	((GtkWidgetClass *) klass)->unrealize = (void (*) (GtkWidget*)) elastic_graph_view_real_unrealize;
	G_OBJECT_CLASS (klass)->get_property = _vala_elastic_graph_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_elastic_graph_view_set_property;
	G_OBJECT_CLASS (klass)->constructor = elastic_graph_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = elastic_graph_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ELASTIC_GRAPH_VIEW_SPRING_PROPERTY, elastic_graph_view_properties[ELASTIC_GRAPH_VIEW_SPRING_PROPERTY] = g_param_spec_object ("spring", "spring", "spring", ELASTIC_TYPE_SPRING_PARAMS, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/app/drey/Elastic/graph-view.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "label_box", FALSE, ElasticGraphView_private_offset + G_STRUCT_OFFSET (ElasticGraphViewPrivate, label_box));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "duration_label", FALSE, ElasticGraphView_private_offset + G_STRUCT_OFFSET (ElasticGraphViewPrivate, duration_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "min_label", FALSE, ElasticGraphView_private_offset + G_STRUCT_OFFSET (ElasticGraphViewPrivate, min_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "max_label", FALSE, ElasticGraphView_private_offset + G_STRUCT_OFFSET (ElasticGraphViewPrivate, max_label));
	gtk_widget_class_set_css_name (GTK_WIDGET_CLASS (klass), "graph-view");
}

static void
elastic_graph_view_instance_init (ElasticGraphView * self,
                                  gpointer klass)
{
	self->priv = elastic_graph_view_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
elastic_graph_view_finalize (GObject * obj)
{
	ElasticGraphView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ELASTIC_TYPE_GRAPH_VIEW, ElasticGraphView);
	_g_object_unref0 (self->priv->_spring);
	_g_object_unref0 (self->priv->animation);
	self->priv->points = (g_free (self->priv->points), NULL);
	G_OBJECT_CLASS (elastic_graph_view_parent_class)->finalize (obj);
}

static GType
elastic_graph_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ElasticGraphViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) elastic_graph_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ElasticGraphView), 0, (GInstanceInitFunc) elastic_graph_view_instance_init, NULL };
	GType elastic_graph_view_type_id;
	elastic_graph_view_type_id = g_type_register_static (adw_bin_get_type (), "ElasticGraphView", &g_define_type_info, 0);
	ElasticGraphView_private_offset = g_type_add_instance_private (elastic_graph_view_type_id, sizeof (ElasticGraphViewPrivate));
	return elastic_graph_view_type_id;
}

GType
elastic_graph_view_get_type (void)
{
	static volatile gsize elastic_graph_view_type_id__once = 0;
	if (g_once_init_enter (&elastic_graph_view_type_id__once)) {
		GType elastic_graph_view_type_id;
		elastic_graph_view_type_id = elastic_graph_view_get_type_once ();
		g_once_init_leave (&elastic_graph_view_type_id__once, elastic_graph_view_type_id);
	}
	return elastic_graph_view_type_id__once;
}

static void
_vala_elastic_graph_view_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec)
{
	ElasticGraphView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ELASTIC_TYPE_GRAPH_VIEW, ElasticGraphView);
	switch (property_id) {
		case ELASTIC_GRAPH_VIEW_SPRING_PROPERTY:
		g_value_set_object (value, elastic_graph_view_get_spring (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_elastic_graph_view_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec)
{
	ElasticGraphView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ELASTIC_TYPE_GRAPH_VIEW, ElasticGraphView);
	switch (property_id) {
		case ELASTIC_GRAPH_VIEW_SPRING_PROPERTY:
		elastic_graph_view_set_spring (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

