/* DuplicityLogger.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from DuplicityLogger.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*-
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: Michael Terry
 */

#include "deja.h"
#include <gio/gio.h>
#include <glib.h>
#include <glib-object.h>
#include <gio/gunixinputstream.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gstdio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define TYPE_STANZA (stanza_get_type ())
#define STANZA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STANZA, Stanza))
#define STANZA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STANZA, StanzaClass))
#define IS_STANZA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STANZA))
#define IS_STANZA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STANZA))
#define STANZA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STANZA, StanzaClass))

typedef struct _Stanza Stanza;
typedef struct _StanzaClass StanzaClass;
enum  {
	DEJA_DUP_DUPLICITY_LOGGER_0_PROPERTY,
	DEJA_DUP_DUPLICITY_LOGGER_READER_PROPERTY,
	DEJA_DUP_DUPLICITY_LOGGER_PRINT_TO_CONSOLE_PROPERTY,
	DEJA_DUP_DUPLICITY_LOGGER_NUM_PROPERTIES
};
static GParamSpec* deja_dup_duplicity_logger_properties[DEJA_DUP_DUPLICITY_LOGGER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _DejaDupDuplicityLoggerReadData DejaDupDuplicityLoggerReadData;
typedef struct _StanzaPrivate StanzaPrivate;
enum  {
	DEJA_DUP_DUPLICITY_LOGGER_MESSAGE_SIGNAL,
	DEJA_DUP_DUPLICITY_LOGGER_NUM_SIGNALS
};
static guint deja_dup_duplicity_logger_signals[DEJA_DUP_DUPLICITY_LOGGER_NUM_SIGNALS] = {0};
enum  {
	STANZA_0_PROPERTY,
	STANZA_NUM_PROPERTIES
};
static GParamSpec* stanza_properties[STANZA_NUM_PROPERTIES];
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _DejaDupDuplicityLoggerPrivate {
	GDataInputStream* _reader;
	gboolean _print_to_console;
	GQueue* tail;
};

struct _DejaDupDuplicityLoggerReadData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	DejaDupDuplicityLogger* self;
	GCancellable* cancellable;
	GList* stanza_lines;
	gchar* line;
	GDataInputStream* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GError* err;
	GError* _tmp4_;
	const gchar* _tmp5_;
	GError* _inner_error0_;
};

struct _Stanza {
	GObject parent_instance;
	StanzaPrivate * priv;
	gchar* original_text;
	gboolean* control_is_path;
	gint control_is_path_length1;
	gint _control_is_path_size_;
	gchar** control_line;
	gint control_line_length1;
	gint _control_line_size_;
	GList* data;
	gchar* text;
};

struct _StanzaClass {
	GObjectClass parent_class;
};

static gint DejaDupDuplicityLogger_private_offset;
static gpointer deja_dup_duplicity_logger_parent_class = NULL;
static gpointer stanza_parent_class = NULL;

VALA_EXTERN GType stanza_get_type (void) G_GNUC_CONST ;
static void _g_object_unref0_ (gpointer var);
static inline void _g_queue_free__g_object_unref0_ (GQueue* self);
static void deja_dup_duplicity_logger_read_data_free (gpointer _data);
static gboolean deja_dup_duplicity_logger_read_co (DejaDupDuplicityLoggerReadData* _data_);
static void deja_dup_duplicity_logger_read_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_);
static void deja_dup_duplicity_logger_process_stanza_line (DejaDupDuplicityLogger* self,
                                                    const gchar* line,
                                                    GList** stanza_lines);
static void _g_free0_ (gpointer var);
static inline void _g_list_free__g_free0_ (GList* self);
VALA_EXTERN Stanza* stanza_parse_stanza (GList* stanza_lines);
static void deja_dup_duplicity_logger_add_to_tail (DejaDupDuplicityLogger* self,
                                            Stanza* stanza);
VALA_EXTERN gchar* stanza_obscured (Stanza* self,
                        DejaDupLogObscurer* obscurer);
static void g_cclosure_user_marshal_VOID__BOXED_INT_POINTER_STRING (GClosure * closure,
                                                             GValue * return_value,
                                                             guint n_param_values,
                                                             const GValue * param_values,
                                                             gpointer invocation_hint,
                                                             gpointer marshal_data);
static GObject * deja_dup_duplicity_logger_constructor (GType type,
                                                 guint n_construct_properties,
                                                 GObjectConstructParam * construct_properties);
static void deja_dup_duplicity_logger_finalize (GObject * obj);
static GType deja_dup_duplicity_logger_get_type_once (void);
static void _vala_deja_dup_duplicity_logger_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec);
static void _vala_deja_dup_duplicity_logger_set_property (GObject * object,
                                                   guint property_id,
                                                   const GValue * value,
                                                   GParamSpec * pspec);
VALA_EXTERN Stanza* stanza_new (void);
VALA_EXTERN Stanza* stanza_construct (GType object_type);
static void stanza_split_line (const gchar* line,
                        gboolean** is_path,
                        gint* is_path_length1,
                        gchar*** split,
                        gint* split_length1);
static GList* stanza_grab_stanza_data (GList* stanza);
static gchar* stanza_grab_stanza_text (GList* stanza);
static gint stanza_num_suffix (const gchar* word,
                        gchar ch,
                        glong start);
static gchar* stanza_validated_string (const gchar* s);
static gchar* stanza_compress_string (const gchar* s_in);
static void _vala_array_add15 (gboolean* * array,
                        gint* length,
                        gint* size,
                        gboolean value);
static void _vala_array_add16 (gboolean* * array,
                        gint* length,
                        gint* size,
                        gboolean value);
static gboolean* _vala_array_dup3 (gboolean* self,
                            gssize length);
static void stanza_finalize (GObject * obj);
static GType stanza_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
deja_dup_duplicity_logger_get_instance_private (DejaDupDuplicityLogger* self)
{
	return G_STRUCT_MEMBER_P (self, DejaDupDuplicityLogger_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_queue_free__g_object_unref0_ (GQueue* self)
{
	g_queue_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

DejaDupDuplicityLogger*
deja_dup_duplicity_logger_construct_for_fd (GType object_type,
                                            gint fd)
{
	DejaDupDuplicityLogger * self = NULL;
	GInputStream* stream = NULL;
	GUnixInputStream* _tmp0_;
	GDataInputStream* _tmp1_;
	GDataInputStream* _tmp2_;
	_tmp0_ = (GUnixInputStream*) g_unix_input_stream_new (fd, TRUE);
	stream = (GInputStream*) _tmp0_;
	_tmp1_ = g_data_input_stream_new (stream);
	_tmp2_ = _tmp1_;
	self = (DejaDupDuplicityLogger*) g_object_new (object_type, "reader", _tmp2_, NULL);
	_g_object_unref0 (_tmp2_);
	_g_object_unref0 (stream);
	return self;
}

DejaDupDuplicityLogger*
deja_dup_duplicity_logger_new_for_fd (gint fd)
{
	return deja_dup_duplicity_logger_construct_for_fd (DEJA_DUP_TYPE_DUPLICITY_LOGGER, fd);
}

DejaDupDuplicityLogger*
deja_dup_duplicity_logger_construct_for_stream (GType object_type,
                                                GInputStream* stream)
{
	DejaDupDuplicityLogger * self = NULL;
	GDataInputStream* _tmp0_;
	GDataInputStream* _tmp1_;
	g_return_val_if_fail (stream != NULL, NULL);
	_tmp0_ = g_data_input_stream_new (stream);
	_tmp1_ = _tmp0_;
	self = (DejaDupDuplicityLogger*) g_object_new (object_type, "reader", _tmp1_, NULL);
	_g_object_unref0 (_tmp1_);
	return self;
}

DejaDupDuplicityLogger*
deja_dup_duplicity_logger_new_for_stream (GInputStream* stream)
{
	return deja_dup_duplicity_logger_construct_for_stream (DEJA_DUP_TYPE_DUPLICITY_LOGGER, stream);
}

DejaDupDuplicityLogger*
deja_dup_duplicity_logger_from_cache_log (void)
{
	gchar* cachefile = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	GError* _inner_error0_ = NULL;
	DejaDupDuplicityLogger* result;
	_tmp0_ = deja_dup_duplicity_logger_get_cachefile ();
	cachefile = _tmp0_;
	_tmp1_ = cachefile;
	if (_tmp1_ == NULL) {
		result = NULL;
		_g_free0 (cachefile);
		return result;
	}
	{
		GFileInputStream* stream = NULL;
		const gchar* _tmp2_;
		GFile* _tmp3_;
		GFile* _tmp4_;
		GFileInputStream* _tmp5_;
		GFileInputStream* _tmp6_;
		GFileInputStream* _tmp7_;
		DejaDupDuplicityLogger* _tmp8_;
		_tmp2_ = cachefile;
		_tmp3_ = g_file_new_for_path (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_file_read (_tmp4_, NULL, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_object_unref0 (_tmp4_);
		stream = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp7_ = stream;
		_tmp8_ = deja_dup_duplicity_logger_new_for_stream ((GInputStream*) _tmp7_);
		result = _tmp8_;
		_g_object_unref0 (stream);
		_g_free0 (cachefile);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		result = NULL;
		_g_free0 (cachefile);
		return result;
	}
	__finally0:
	_g_free0 (cachefile);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
deja_dup_duplicity_logger_read_data_free (gpointer _data)
{
	DejaDupDuplicityLoggerReadData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (DejaDupDuplicityLoggerReadData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
deja_dup_duplicity_logger_read (DejaDupDuplicityLogger* self,
                                GCancellable* cancellable,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_)
{
	DejaDupDuplicityLoggerReadData* _data_;
	DejaDupDuplicityLogger* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (DejaDupDuplicityLoggerReadData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, deja_dup_duplicity_logger_read_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	deja_dup_duplicity_logger_read_co (_data_);
}

void
deja_dup_duplicity_logger_read_finish (DejaDupDuplicityLogger* self,
                                       GAsyncResult* _res_)
{
	DejaDupDuplicityLoggerReadData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	if (NULL == _data_) {
		return;
	}
}

static void
deja_dup_duplicity_logger_read_ready (GObject* source_object,
                                      GAsyncResult* _res_,
                                      gpointer _user_data_)
{
	DejaDupDuplicityLoggerReadData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	deja_dup_duplicity_logger_read_co (_data_);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static inline void
_g_list_free__g_free0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_free0_);
}

static gboolean
deja_dup_duplicity_logger_read_co (DejaDupDuplicityLoggerReadData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->stanza_lines = NULL;
	while (TRUE) {
		{
			_data_->_tmp0_ = _data_->self->priv->_reader;
			_data_->_state_ = 1;
			g_data_input_stream_read_line_async (_data_->_tmp0_, G_PRIORITY_LOW, _data_->cancellable, deja_dup_duplicity_logger_read_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp1_ = g_data_input_stream_read_line_finish (_data_->_tmp0_, _data_->_res_, NULL, &_data_->_inner_error0_);
			_data_->line = _data_->_tmp1_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_data_->_tmp2_ = _data_->line;
			if (_data_->_tmp2_ == NULL) {
				_g_free0 (_data_->line);
				break;
			}
			_data_->_tmp3_ = _data_->line;
			deja_dup_duplicity_logger_process_stanza_line (_data_->self, _data_->_tmp3_, &_data_->stanza_lines);
			_g_free0 (_data_->line);
		}
		goto __finally0;
		__catch0_g_error:
		{
			_data_->err = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp4_ = _data_->err;
			_data_->_tmp5_ = _data_->_tmp4_->message;
			g_warning ("DuplicityLogger.vala:58: %s\n", _data_->_tmp5_);
			_g_error_free0 (_data_->err);
			break;
		}
		__finally0:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			(_data_->stanza_lines == NULL) ? NULL : (_data_->stanza_lines = (_g_list_free__g_free0_ (_data_->stanza_lines), NULL));
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	(_data_->stanza_lines == NULL) ? NULL : (_data_->stanza_lines = (_g_list_free__g_free0_ (_data_->stanza_lines), NULL));
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
deja_dup_duplicity_logger_read_sync (DejaDupDuplicityLogger* self)
{
	GList* stanza_lines = NULL;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	stanza_lines = NULL;
	while (TRUE) {
		{
			gchar* line = NULL;
			GDataInputStream* _tmp0_;
			gchar* _tmp1_;
			const gchar* _tmp2_;
			const gchar* _tmp3_;
			_tmp0_ = self->priv->_reader;
			_tmp1_ = g_data_input_stream_read_line (_tmp0_, NULL, NULL, &_inner_error0_);
			line = _tmp1_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp2_ = line;
			if (_tmp2_ == NULL) {
				_g_free0 (line);
				break;
			}
			_tmp3_ = line;
			deja_dup_duplicity_logger_process_stanza_line (self, _tmp3_, &stanza_lines);
			_g_free0 (line);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* err = NULL;
			GError* _tmp4_;
			const gchar* _tmp5_;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp4_ = err;
			_tmp5_ = _tmp4_->message;
			g_warning ("DuplicityLogger.vala:76: %s\n", _tmp5_);
			_g_error_free0 (err);
			break;
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			(stanza_lines == NULL) ? NULL : (stanza_lines = (_g_list_free__g_free0_ (stanza_lines), NULL));
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	(stanza_lines == NULL) ? NULL : (stanza_lines = (_g_list_free__g_free0_ (stanza_lines), NULL));
}

static void
deja_dup_duplicity_logger_process_stanza_line (DejaDupDuplicityLogger* self,
                                               const gchar* line,
                                               GList** stanza_lines)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (line != NULL);
	if (g_strcmp0 (line, "") != 0) {
		gboolean _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = self->priv->_print_to_console;
		if (_tmp0_) {
			g_print ("DUPLICITY: %s\n", line);
		}
		_tmp1_ = g_strdup (line);
		*stanza_lines = g_list_append (*stanza_lines, _tmp1_);
	} else {
		if ((*stanza_lines) != NULL) {
			gboolean _tmp2_;
			Stanza* stanza = NULL;
			Stanza* _tmp3_;
			Stanza* _tmp4_;
			Stanza* _tmp5_;
			gchar** _tmp6_;
			gint _tmp6__length1;
			Stanza* _tmp7_;
			GList* _tmp8_;
			Stanza* _tmp9_;
			const gchar* _tmp10_;
			_tmp2_ = self->priv->_print_to_console;
			if (_tmp2_) {
				g_print ("\n");
			}
			_tmp3_ = stanza_parse_stanza (*stanza_lines);
			stanza = _tmp3_;
			_tmp4_ = stanza;
			deja_dup_duplicity_logger_add_to_tail (self, _tmp4_);
			_tmp5_ = stanza;
			_tmp6_ = _tmp5_->control_line;
			_tmp6__length1 = _tmp5_->control_line_length1;
			_tmp7_ = stanza;
			_tmp8_ = _tmp7_->data;
			_tmp9_ = stanza;
			_tmp10_ = _tmp9_->text;
			g_signal_emit (self, deja_dup_duplicity_logger_signals[DEJA_DUP_DUPLICITY_LOGGER_MESSAGE_SIGNAL], 0, _tmp6_, (gint) _tmp6__length1, _tmp8_, _tmp10_);
			((*stanza_lines) == NULL) ? NULL : (*stanza_lines = (_g_list_free__g_free0_ (*stanza_lines), NULL));
			*stanza_lines = NULL;
			_g_object_unref0 (stanza);
		}
	}
}

void
deja_dup_duplicity_logger_write_tail_to_cache (DejaDupDuplicityLogger* self)
{
	gchar* cachefile = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* contents = NULL;
	gchar* _tmp2_;
	GQueue* _tmp3_;
	GList* _tmp4_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = deja_dup_duplicity_logger_get_cachefile ();
	cachefile = _tmp0_;
	_tmp1_ = cachefile;
	if (_tmp1_ == NULL) {
		_g_free0 (cachefile);
		return;
	}
	_tmp2_ = g_strdup ("");
	contents = _tmp2_;
	_tmp3_ = self->priv->tail;
	_tmp4_ = _tmp3_->head;
	{
		GList* stanza_collection = NULL;
		GList* stanza_it = NULL;
		stanza_collection = _tmp4_;
		for (stanza_it = stanza_collection; stanza_it != NULL; stanza_it = stanza_it->next) {
			Stanza* _tmp5_;
			Stanza* stanza = NULL;
			_tmp5_ = _g_object_ref0 ((Stanza*) stanza_it->data);
			stanza = _tmp5_;
			{
				const gchar* _tmp6_;
				Stanza* _tmp7_;
				const gchar* _tmp8_;
				gchar* _tmp9_;
				gchar* _tmp10_;
				gchar* _tmp11_;
				_tmp6_ = contents;
				_tmp7_ = stanza;
				_tmp8_ = _tmp7_->original_text;
				_tmp9_ = g_strconcat (_tmp8_, "\n", NULL);
				_tmp10_ = _tmp9_;
				_tmp11_ = g_strconcat (_tmp6_, _tmp10_, NULL);
				_g_free0 (contents);
				contents = _tmp11_;
				_g_free0 (_tmp10_);
				_g_object_unref0 (stanza);
			}
		}
	}
	{
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		_tmp12_ = cachefile;
		_tmp13_ = contents;
		g_file_set_contents (_tmp12_, _tmp13_, (gssize) -1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp14_;
		const gchar* _tmp15_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp14_ = e;
		_tmp15_ = _tmp14_->message;
		g_info ("DuplicityLogger.vala:116: %s\n", _tmp15_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (contents);
		_g_free0 (cachefile);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (contents);
	_g_free0 (cachefile);
}

gchar*
deja_dup_duplicity_logger_get_obscured_tail (DejaDupDuplicityLogger* self,
                                             DejaDupLogObscurer* obscurer)
{
	gchar* contents = NULL;
	gchar* _tmp0_;
	GQueue* _tmp1_;
	GList* _tmp2_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (obscurer != NULL, NULL);
	_tmp0_ = g_strdup ("");
	contents = _tmp0_;
	_tmp1_ = self->priv->tail;
	_tmp2_ = _tmp1_->head;
	{
		GList* stanza_collection = NULL;
		GList* stanza_it = NULL;
		stanza_collection = _tmp2_;
		for (stanza_it = stanza_collection; stanza_it != NULL; stanza_it = stanza_it->next) {
			Stanza* _tmp3_;
			Stanza* stanza = NULL;
			_tmp3_ = _g_object_ref0 ((Stanza*) stanza_it->data);
			stanza = _tmp3_;
			{
				const gchar* _tmp4_;
				Stanza* _tmp5_;
				gchar* _tmp6_;
				gchar* _tmp7_;
				gchar* _tmp8_;
				gchar* _tmp9_;
				gchar* _tmp10_;
				_tmp4_ = contents;
				_tmp5_ = stanza;
				_tmp6_ = stanza_obscured (_tmp5_, obscurer);
				_tmp7_ = _tmp6_;
				_tmp8_ = g_strconcat (_tmp7_, "\n\n", NULL);
				_tmp9_ = _tmp8_;
				_tmp10_ = g_strconcat (_tmp4_, _tmp9_, NULL);
				_g_free0 (contents);
				contents = _tmp10_;
				_g_free0 (_tmp9_);
				_g_free0 (_tmp7_);
				_g_object_unref0 (stanza);
			}
		}
	}
	result = contents;
	return result;
}

gchar*
deja_dup_duplicity_logger_get_cachefile (void)
{
	gchar* cachedir = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	_tmp0_ = g_get_user_cache_dir ();
	_tmp1_ = g_strdup (_tmp0_);
	cachedir = _tmp1_;
	_tmp2_ = cachedir;
	if (_tmp2_ == NULL) {
		result = NULL;
		_g_free0 (cachedir);
		return result;
	}
	_tmp3_ = cachedir;
	_tmp4_ = g_build_filename (_tmp3_, PACKAGE, "duplicity.log", NULL);
	result = _tmp4_;
	_g_free0 (cachedir);
	return result;
}

static void
deja_dup_duplicity_logger_add_to_tail (DejaDupDuplicityLogger* self,
                                       Stanza* stanza)
{
	GQueue* _tmp0_;
	Stanza* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (stanza != NULL);
	_tmp0_ = self->priv->tail;
	_tmp1_ = _g_object_ref0 (stanza);
	g_queue_push_tail (_tmp0_, _tmp1_);
	while (TRUE) {
		GQueue* _tmp2_;
		GQueue* _tmp3_;
		gpointer _tmp4_;
		Stanza* _tmp5_;
		_tmp2_ = self->priv->tail;
		if (!(g_queue_get_length (_tmp2_) > ((guint) 50))) {
			break;
		}
		_tmp3_ = self->priv->tail;
		_tmp4_ = g_queue_pop_head (_tmp3_);
		_tmp5_ = (Stanza*) _tmp4_;
		_g_object_unref0 (_tmp5_);
	}
}

DejaDupDuplicityLogger*
deja_dup_duplicity_logger_construct (GType object_type)
{
	DejaDupDuplicityLogger * self = NULL;
	self = (DejaDupDuplicityLogger*) g_object_new (object_type, NULL);
	return self;
}

DejaDupDuplicityLogger*
deja_dup_duplicity_logger_new (void)
{
	return deja_dup_duplicity_logger_construct (DEJA_DUP_TYPE_DUPLICITY_LOGGER);
}

GDataInputStream*
deja_dup_duplicity_logger_get_reader (DejaDupDuplicityLogger* self)
{
	GDataInputStream* result;
	GDataInputStream* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_reader;
	result = _tmp0_;
	return result;
}

static void
deja_dup_duplicity_logger_set_reader (DejaDupDuplicityLogger* self,
                                      GDataInputStream* value)
{
	GDataInputStream* old_value;
	g_return_if_fail (self != NULL);
	old_value = deja_dup_duplicity_logger_get_reader (self);
	if (old_value != value) {
		GDataInputStream* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_reader);
		self->priv->_reader = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, deja_dup_duplicity_logger_properties[DEJA_DUP_DUPLICITY_LOGGER_READER_PROPERTY]);
	}
}

gboolean
deja_dup_duplicity_logger_get_print_to_console (DejaDupDuplicityLogger* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_print_to_console;
	return result;
}

void
deja_dup_duplicity_logger_set_print_to_console (DejaDupDuplicityLogger* self,
                                                gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = deja_dup_duplicity_logger_get_print_to_console (self);
	if (old_value != value) {
		self->priv->_print_to_console = value;
		g_object_notify_by_pspec ((GObject *) self, deja_dup_duplicity_logger_properties[DEJA_DUP_DUPLICITY_LOGGER_PRINT_TO_CONSOLE_PROPERTY]);
	}
}

static void
g_cclosure_user_marshal_VOID__BOXED_INT_POINTER_STRING (GClosure * closure,
                                                        GValue * return_value,
                                                        guint n_param_values,
                                                        const GValue * param_values,
                                                        gpointer invocation_hint,
                                                        gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__BOXED_INT_POINTER_STRING) (gpointer data1, gpointer arg_1, gint arg_2, gpointer arg_3, const char* arg_4, gpointer data2);
	register GMarshalFunc_VOID__BOXED_INT_POINTER_STRING callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 5);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__BOXED_INT_POINTER_STRING) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_boxed (param_values + 1), g_value_get_int (param_values + 2), g_value_get_pointer (param_values + 3), g_value_get_string (param_values + 4), data2);
}

static GObject *
deja_dup_duplicity_logger_constructor (GType type,
                                       guint n_construct_properties,
                                       GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	DejaDupDuplicityLogger * self;
	GQueue* _tmp0_;
	parent_class = G_OBJECT_CLASS (deja_dup_duplicity_logger_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DEJA_DUP_TYPE_DUPLICITY_LOGGER, DejaDupDuplicityLogger);
	_tmp0_ = g_queue_new ();
	(self->priv->tail == NULL) ? NULL : (self->priv->tail = (_g_queue_free__g_object_unref0_ (self->priv->tail), NULL));
	self->priv->tail = _tmp0_;
	return obj;
}

static void
deja_dup_duplicity_logger_class_init (DejaDupDuplicityLoggerClass * klass,
                                      gpointer klass_data)
{
	deja_dup_duplicity_logger_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &DejaDupDuplicityLogger_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_deja_dup_duplicity_logger_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_deja_dup_duplicity_logger_set_property;
	G_OBJECT_CLASS (klass)->constructor = deja_dup_duplicity_logger_constructor;
	G_OBJECT_CLASS (klass)->finalize = deja_dup_duplicity_logger_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEJA_DUP_DUPLICITY_LOGGER_READER_PROPERTY, deja_dup_duplicity_logger_properties[DEJA_DUP_DUPLICITY_LOGGER_READER_PROPERTY] = g_param_spec_object ("reader", "reader", "reader", g_data_input_stream_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEJA_DUP_DUPLICITY_LOGGER_PRINT_TO_CONSOLE_PROPERTY, deja_dup_duplicity_logger_properties[DEJA_DUP_DUPLICITY_LOGGER_PRINT_TO_CONSOLE_PROPERTY] = g_param_spec_boolean ("print-to-console", "print-to-console", "print-to-console", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	deja_dup_duplicity_logger_signals[DEJA_DUP_DUPLICITY_LOGGER_MESSAGE_SIGNAL] = g_signal_new ("message", DEJA_DUP_TYPE_DUPLICITY_LOGGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__BOXED_INT_POINTER_STRING, G_TYPE_NONE, 4, G_TYPE_STRV, G_TYPE_INT, G_TYPE_POINTER, G_TYPE_STRING);
}

static void
deja_dup_duplicity_logger_instance_init (DejaDupDuplicityLogger * self,
                                         gpointer klass)
{
	self->priv = deja_dup_duplicity_logger_get_instance_private (self);
}

static void
deja_dup_duplicity_logger_finalize (GObject * obj)
{
	DejaDupDuplicityLogger * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DEJA_DUP_TYPE_DUPLICITY_LOGGER, DejaDupDuplicityLogger);
	_g_object_unref0 (self->priv->_reader);
	(self->priv->tail == NULL) ? NULL : (self->priv->tail = (_g_queue_free__g_object_unref0_ (self->priv->tail), NULL));
	G_OBJECT_CLASS (deja_dup_duplicity_logger_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
deja_dup_duplicity_logger_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DejaDupDuplicityLoggerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) deja_dup_duplicity_logger_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DejaDupDuplicityLogger), 0, (GInstanceInitFunc) deja_dup_duplicity_logger_instance_init, NULL };
	GType deja_dup_duplicity_logger_type_id;
	deja_dup_duplicity_logger_type_id = g_type_register_static (G_TYPE_OBJECT, "DejaDupDuplicityLogger", &g_define_type_info, 0);
	DejaDupDuplicityLogger_private_offset = g_type_add_instance_private (deja_dup_duplicity_logger_type_id, sizeof (DejaDupDuplicityLoggerPrivate));
	return deja_dup_duplicity_logger_type_id;
}

GType
deja_dup_duplicity_logger_get_type (void)
{
	static gsize deja_dup_duplicity_logger_type_id__once = 0;
	if (g_once_init_enter (&deja_dup_duplicity_logger_type_id__once)) {
		GType deja_dup_duplicity_logger_type_id;
		deja_dup_duplicity_logger_type_id = deja_dup_duplicity_logger_get_type_once ();
		g_once_init_leave (&deja_dup_duplicity_logger_type_id__once, deja_dup_duplicity_logger_type_id);
	}
	return deja_dup_duplicity_logger_type_id__once;
}

static void
_vala_deja_dup_duplicity_logger_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec)
{
	DejaDupDuplicityLogger * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, DEJA_DUP_TYPE_DUPLICITY_LOGGER, DejaDupDuplicityLogger);
	switch (property_id) {
		case DEJA_DUP_DUPLICITY_LOGGER_READER_PROPERTY:
		g_value_set_object (value, deja_dup_duplicity_logger_get_reader (self));
		break;
		case DEJA_DUP_DUPLICITY_LOGGER_PRINT_TO_CONSOLE_PROPERTY:
		g_value_set_boolean (value, deja_dup_duplicity_logger_get_print_to_console (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_deja_dup_duplicity_logger_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec)
{
	DejaDupDuplicityLogger * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, DEJA_DUP_TYPE_DUPLICITY_LOGGER, DejaDupDuplicityLogger);
	switch (property_id) {
		case DEJA_DUP_DUPLICITY_LOGGER_READER_PROPERTY:
		deja_dup_duplicity_logger_set_reader (self, g_value_get_object (value));
		break;
		case DEJA_DUP_DUPLICITY_LOGGER_PRINT_TO_CONSOLE_PROPERTY:
		deja_dup_duplicity_logger_set_print_to_console (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

Stanza*
stanza_parse_stanza (GList* stanza_lines)
{
	Stanza* stanza = NULL;
	Stanza* _tmp0_;
	Stanza* _tmp1_;
	gchar* _tmp2_;
	gconstpointer _tmp11_;
	Stanza* _tmp12_;
	Stanza* _tmp13_;
	gboolean* _tmp14_ = NULL;
	gint _tmp15_ = 0;
	gchar** _tmp16_ = NULL;
	gint _tmp17_ = 0;
	Stanza* _tmp18_;
	GList* _tmp19_;
	Stanza* _tmp20_;
	gchar* _tmp21_;
	Stanza* result;
	_tmp0_ = stanza_new ();
	stanza = _tmp0_;
	_tmp1_ = stanza;
	_tmp2_ = g_strdup ("");
	_g_free0 (_tmp1_->original_text);
	_tmp1_->original_text = _tmp2_;
	{
		GList* line_collection = NULL;
		GList* line_it = NULL;
		line_collection = stanza_lines;
		for (line_it = line_collection; line_it != NULL; line_it = line_it->next) {
			gchar* _tmp3_;
			gchar* line = NULL;
			_tmp3_ = g_strdup ((const gchar*) line_it->data);
			line = _tmp3_;
			{
				Stanza* _tmp4_;
				Stanza* _tmp5_;
				const gchar* _tmp6_;
				const gchar* _tmp7_;
				gchar* _tmp8_;
				gchar* _tmp9_;
				gchar* _tmp10_;
				_tmp4_ = stanza;
				_tmp5_ = stanza;
				_tmp6_ = _tmp5_->original_text;
				_tmp7_ = line;
				_tmp8_ = g_strconcat (_tmp7_, "\n", NULL);
				_tmp9_ = _tmp8_;
				_tmp10_ = g_strconcat (_tmp6_, _tmp9_, NULL);
				_g_free0 (_tmp5_->original_text);
				_tmp5_->original_text = _tmp10_;
				_g_free0 (_tmp9_);
				_g_free0 (line);
			}
		}
	}
	_tmp11_ = stanza_lines->data;
	_tmp12_ = stanza;
	_tmp13_ = stanza;
	stanza_split_line ((const gchar*) _tmp11_, &_tmp14_, &_tmp15_, &_tmp16_, &_tmp17_);
	_tmp12_->control_is_path = (g_free (_tmp12_->control_is_path), NULL);
	_tmp12_->control_is_path = _tmp14_;
	_tmp12_->control_is_path_length1 = _tmp15_;
	_tmp12_->_control_is_path_size_ = _tmp12_->control_is_path_length1;
	_tmp13_->control_line = (_vala_array_free (_tmp13_->control_line, _tmp13_->control_line_length1, (GDestroyNotify) g_free), NULL);
	_tmp13_->control_line = _tmp16_;
	_tmp13_->control_line_length1 = _tmp17_;
	_tmp13_->_control_line_size_ = _tmp13_->control_line_length1;
	_tmp18_ = stanza;
	_tmp19_ = stanza_grab_stanza_data (stanza_lines);
	(_tmp18_->data == NULL) ? NULL : (_tmp18_->data = (_g_list_free__g_free0_ (_tmp18_->data), NULL));
	_tmp18_->data = _tmp19_;
	_tmp20_ = stanza;
	_tmp21_ = stanza_grab_stanza_text (stanza_lines);
	_g_free0 (_tmp20_->text);
	_tmp20_->text = _tmp21_;
	result = stanza;
	return result;
}

gchar*
stanza_obscured (Stanza* self,
                 DejaDupLogObscurer* obscurer)
{
	gchar* val = NULL;
	gchar* _tmp0_;
	GList* _tmp20_;
	const gchar* _tmp30_;
	gchar** _tmp31_;
	gchar** _tmp32_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (obscurer != NULL, NULL);
	_tmp0_ = g_strdup ("");
	val = _tmp0_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gchar** _tmp3_;
				gint _tmp3__length1;
				gboolean* _tmp4_;
				gint _tmp4__length1;
				gboolean _tmp5_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = self->control_line;
				_tmp3__length1 = self->control_line_length1;
				if (!(i < _tmp3__length1)) {
					break;
				}
				_tmp4_ = self->control_is_path;
				_tmp4__length1 = self->control_is_path_length1;
				_tmp5_ = _tmp4_[i];
				if (_tmp5_) {
					const gchar* _tmp6_;
					gchar** _tmp7_;
					gint _tmp7__length1;
					const gchar* _tmp8_;
					gchar* _tmp9_;
					gchar* _tmp10_;
					gchar* _tmp11_;
					gchar* _tmp12_;
					gchar* _tmp13_;
					_tmp6_ = val;
					_tmp7_ = self->control_line;
					_tmp7__length1 = self->control_line_length1;
					_tmp8_ = _tmp7_[i];
					_tmp9_ = deja_dup_log_obscurer_replace_path (obscurer, _tmp8_);
					_tmp10_ = _tmp9_;
					_tmp11_ = g_strconcat (_tmp10_, " ", NULL);
					_tmp12_ = _tmp11_;
					_tmp13_ = g_strconcat (_tmp6_, _tmp12_, NULL);
					_g_free0 (val);
					val = _tmp13_;
					_g_free0 (_tmp12_);
					_g_free0 (_tmp10_);
				} else {
					const gchar* _tmp14_;
					gchar** _tmp15_;
					gint _tmp15__length1;
					const gchar* _tmp16_;
					gchar* _tmp17_;
					gchar* _tmp18_;
					gchar* _tmp19_;
					_tmp14_ = val;
					_tmp15_ = self->control_line;
					_tmp15__length1 = self->control_line_length1;
					_tmp16_ = _tmp15_[i];
					_tmp17_ = g_strconcat (_tmp16_, " ", NULL);
					_tmp18_ = _tmp17_;
					_tmp19_ = g_strconcat (_tmp14_, _tmp18_, NULL);
					_g_free0 (val);
					val = _tmp19_;
					_g_free0 (_tmp18_);
				}
			}
		}
	}
	_tmp20_ = self->data;
	if (_tmp20_ != NULL) {
		GList* _tmp21_;
		_tmp21_ = self->data;
		{
			GList* line_collection = NULL;
			GList* line_it = NULL;
			line_collection = _tmp21_;
			for (line_it = line_collection; line_it != NULL; line_it = line_it->next) {
				gchar* _tmp22_;
				gchar* line = NULL;
				_tmp22_ = g_strdup ((const gchar*) line_it->data);
				line = _tmp22_;
				{
					const gchar* _tmp23_;
					const gchar* _tmp24_;
					gchar* _tmp25_;
					gchar* _tmp26_;
					gchar* _tmp27_;
					gchar* _tmp28_;
					gchar* _tmp29_;
					_tmp23_ = val;
					_tmp24_ = line;
					_tmp25_ = deja_dup_log_obscurer_replace_freeform_text (obscurer, _tmp24_);
					_tmp26_ = _tmp25_;
					_tmp27_ = g_strconcat ("\n", _tmp26_, NULL);
					_tmp28_ = _tmp27_;
					_tmp29_ = g_strconcat (_tmp23_, _tmp28_, NULL);
					_g_free0 (val);
					val = _tmp29_;
					_g_free0 (_tmp28_);
					_g_free0 (_tmp26_);
					_g_free0 (line);
				}
			}
		}
	}
	_tmp30_ = self->text;
	_tmp32_ = _tmp31_ = g_strsplit (_tmp30_, "\n", 0);
	{
		gchar** line_collection = NULL;
		gint line_collection_length1 = 0;
		gint _line_collection_size_ = 0;
		gint line_it = 0;
		line_collection = _tmp32_;
		line_collection_length1 = _vala_array_length (_tmp31_);
		for (line_it = 0; line_it < line_collection_length1; line_it = line_it + 1) {
			gchar* _tmp33_;
			gchar* line = NULL;
			_tmp33_ = g_strdup (line_collection[line_it]);
			line = _tmp33_;
			{
				const gchar* _tmp34_;
				const gchar* _tmp35_;
				gchar* _tmp36_;
				gchar* _tmp37_;
				gchar* _tmp38_;
				gchar* _tmp39_;
				gchar* _tmp40_;
				_tmp34_ = val;
				_tmp35_ = line;
				_tmp36_ = deja_dup_log_obscurer_replace_freeform_text (obscurer, _tmp35_);
				_tmp37_ = _tmp36_;
				_tmp38_ = g_strconcat ("\n. ", _tmp37_, NULL);
				_tmp39_ = _tmp38_;
				_tmp40_ = g_strconcat (_tmp34_, _tmp39_, NULL);
				_g_free0 (val);
				val = _tmp40_;
				_g_free0 (_tmp39_);
				_g_free0 (_tmp37_);
				_g_free0 (line);
			}
		}
		line_collection = (_vala_array_free (line_collection, line_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	result = val;
	return result;
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static gint
stanza_num_suffix (const gchar* word,
                   gchar ch,
                   glong start)
{
	gint rv = 0;
	gint result;
	g_return_val_if_fail (word != NULL, 0);
	rv = 0;
	if (start < ((glong) 0)) {
		gint _tmp0_;
		gint _tmp1_;
		_tmp0_ = strlen (word);
		_tmp1_ = _tmp0_;
		start = ((glong) _tmp1_) - 1;
	}
	{
		glong i = 0L;
		i = start;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				if (!_tmp2_) {
					glong _tmp3_;
					gint _tmp4_;
					i = i - 1;
					_tmp3_ = i;
					rv = rv + 1;
					_tmp4_ = rv;
				}
				_tmp2_ = FALSE;
				if (!(i >= ((glong) 0))) {
					break;
				}
				if (string_get (word, i) != ch) {
					break;
				}
			}
		}
	}
	result = rv;
	return result;
}

static gchar*
stanza_validated_string (const gchar* s)
{
	GString* rv = NULL;
	GString* _tmp0_;
	const gchar* p = NULL;
	GString* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* result;
	g_return_val_if_fail (s != NULL, NULL);
	_tmp0_ = g_string_new ("");
	rv = _tmp0_;
	p = s;
	while (TRUE) {
		const gchar* _tmp1_;
		gunichar ch = 0U;
		const gchar* _tmp2_;
		gboolean _tmp3_ = FALSE;
		_tmp1_ = p;
		if (!(((gint) string_get (_tmp1_, (glong) 0)) != 0)) {
			break;
		}
		_tmp2_ = p;
		ch = g_utf8_get_char_validated (_tmp2_, (gssize) -1);
		if (ch == ((gunichar) -1)) {
			_tmp3_ = TRUE;
		} else {
			_tmp3_ = ch == ((gunichar) -2);
		}
		if (_tmp3_) {
			GString* _tmp4_;
			const gchar* _tmp5_;
			_tmp4_ = rv;
			g_string_append (_tmp4_, "�");
			_tmp5_ = p;
			p = (const gchar*) (((gchar*) _tmp5_) + 1);
		} else {
			GString* _tmp6_;
			const gchar* _tmp7_;
			const gchar* _tmp8_;
			_tmp6_ = rv;
			g_string_append_unichar (_tmp6_, ch);
			_tmp7_ = p;
			_tmp8_ = g_utf8_next_char (_tmp7_);
			p = _tmp8_;
		}
	}
	_tmp9_ = rv;
	_tmp10_ = _tmp9_->str;
	_tmp11_ = g_strdup (_tmp10_);
	result = _tmp11_;
	_g_string_free0 (rv);
	return result;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gchar*
stanza_compress_string (const gchar* s_in)
{
	GString* rv = NULL;
	gint _tmp0_;
	gint _tmp1_;
	GString* _tmp2_;
	gchar* s = NULL;
	gint s_length1;
	gint _s_size_;
	gint i = 0;
	GString* _tmp61_;
	const gchar* _tmp62_;
	gchar* _tmp63_;
	gchar* result;
	g_return_val_if_fail (s_in != NULL, NULL);
	_tmp0_ = strlen (s_in);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_string_sized_new ((gsize) _tmp1_);
	rv = _tmp2_;
	s = (gchar*) s_in;
	s_length1 = -1;
	_s_size_ = s_length1;
	i = 0;
	while (TRUE) {
		gchar* _tmp3_;
		gint _tmp3__length1;
		gchar _tmp4_;
		gboolean _tmp5_ = FALSE;
		gchar* _tmp6_;
		gint _tmp6__length1;
		gchar _tmp7_;
		_tmp3_ = s;
		_tmp3__length1 = s_length1;
		_tmp4_ = _tmp3_[i];
		if (!(((gint) _tmp4_) != 0)) {
			break;
		}
		_tmp6_ = s;
		_tmp6__length1 = s_length1;
		_tmp7_ = _tmp6_[i];
		if (_tmp7_ == '\\') {
			gchar* _tmp8_;
			gint _tmp8__length1;
			gchar _tmp9_;
			_tmp8_ = s;
			_tmp8__length1 = s_length1;
			_tmp9_ = _tmp8_[i + 1];
			_tmp5_ = ((gint) _tmp9_) != 0;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			gboolean bare_escape = FALSE;
			gchar* _tmp10_;
			gint _tmp10__length1;
			gchar _tmp11_;
			bare_escape = FALSE;
			_tmp10_ = s;
			_tmp10__length1 = s_length1;
			_tmp11_ = _tmp10_[i + 1];
			switch (_tmp11_) {
				case 'b':
				{
					GString* _tmp12_;
					_tmp12_ = rv;
					g_string_append_c (_tmp12_, '\b');
					i += 2;
					break;
				}
				case 'f':
				{
					GString* _tmp13_;
					_tmp13_ = rv;
					g_string_append_c (_tmp13_, '\f');
					i += 2;
					break;
				}
				case 't':
				{
					GString* _tmp14_;
					_tmp14_ = rv;
					g_string_append_c (_tmp14_, '\t');
					i += 2;
					break;
				}
				case 'n':
				{
					GString* _tmp15_;
					_tmp15_ = rv;
					g_string_append_c (_tmp15_, '\n');
					i += 2;
					break;
				}
				case 'r':
				{
					GString* _tmp16_;
					_tmp16_ = rv;
					g_string_append_c (_tmp16_, '\r');
					i += 2;
					break;
				}
				case 'v':
				{
					GString* _tmp17_;
					_tmp17_ = rv;
					g_string_append_c (_tmp17_, '\xb');
					i += 2;
					break;
				}
				case 'a':
				{
					GString* _tmp18_;
					_tmp18_ = rv;
					g_string_append_c (_tmp18_, '\x7');
					i += 2;
					break;
				}
				case 'U':
				{
					guint64 val = 0ULL;
					gchar* _tmp19_;
					gint _tmp19__length1;
					gchar* _tmp20_;
					gchar* _tmp21_;
					guint64 _tmp22_;
					GString* _tmp23_;
					_tmp19_ = s;
					_tmp19__length1 = s_length1;
					_tmp20_ = string_substring ((const gchar*) _tmp19_, (glong) (i + 2), (glong) 8);
					_tmp21_ = _tmp20_;
					_tmp22_ = g_ascii_strtoull (_tmp21_, NULL, (guint) 16);
					_g_free0 (_tmp21_);
					val = _tmp22_;
					_tmp23_ = rv;
					g_string_append_unichar (_tmp23_, (gunichar) val);
					i += 10;
					break;
				}
				case 'u':
				{
					guint64 val = 0ULL;
					gchar* _tmp24_;
					gint _tmp24__length1;
					gchar* _tmp25_;
					gchar* _tmp26_;
					guint64 _tmp27_;
					GString* _tmp28_;
					_tmp24_ = s;
					_tmp24__length1 = s_length1;
					_tmp25_ = string_substring ((const gchar*) _tmp24_, (glong) (i + 2), (glong) 4);
					_tmp26_ = _tmp25_;
					_tmp27_ = g_ascii_strtoull (_tmp26_, NULL, (guint) 16);
					_g_free0 (_tmp26_);
					val = _tmp27_;
					_tmp28_ = rv;
					g_string_append_unichar (_tmp28_, (gunichar) val);
					i += 6;
					break;
				}
				case 'x':
				{
					guint64 val = 0ULL;
					gchar* _tmp29_;
					gint _tmp29__length1;
					gchar* _tmp30_;
					gchar* _tmp31_;
					guint64 _tmp32_;
					GString* _tmp33_;
					_tmp29_ = s;
					_tmp29__length1 = s_length1;
					_tmp30_ = string_substring ((const gchar*) _tmp29_, (glong) (i + 2), (glong) 2);
					_tmp31_ = _tmp30_;
					_tmp32_ = g_ascii_strtoull (_tmp31_, NULL, (guint) 16);
					_g_free0 (_tmp31_);
					val = _tmp32_;
					_tmp33_ = rv;
					g_string_append_unichar (_tmp33_, (gunichar) val);
					i += 4;
					break;
				}
				case '0':
				case '1':
				case '2':
				case '3':
				case '4':
				case '5':
				case '6':
				case '7':
				{
					gboolean _tmp34_ = FALSE;
					gboolean _tmp35_ = FALSE;
					gchar* _tmp36_;
					gint _tmp36__length1;
					gchar _tmp37_;
					_tmp36_ = s;
					_tmp36__length1 = s_length1;
					_tmp37_ = _tmp36_[i + 2];
					if (((gint) _tmp37_) != 0) {
						gchar* _tmp38_;
						gint _tmp38__length1;
						gchar _tmp39_;
						_tmp38_ = s;
						_tmp38__length1 = s_length1;
						_tmp39_ = _tmp38_[i + 3];
						_tmp35_ = ((gint) _tmp39_) != 0;
					} else {
						_tmp35_ = FALSE;
					}
					if (_tmp35_) {
						gchar* _tmp40_;
						gint _tmp40__length1;
						gchar _tmp41_;
						_tmp40_ = s;
						_tmp40__length1 = s_length1;
						_tmp41_ = _tmp40_[i + 4];
						_tmp34_ = ((gint) _tmp41_) != 0;
					} else {
						_tmp34_ = FALSE;
					}
					if (_tmp34_) {
						gchar* tmpstr = NULL;
						gchar* _tmp42_;
						gint tmpstr_length1;
						gint _tmpstr_size_;
						gchar* _tmp43_;
						gint _tmp43__length1;
						gchar* _tmp44_;
						gint _tmp44__length1;
						gchar _tmp45_;
						gchar* _tmp46_;
						gint _tmp46__length1;
						gchar* _tmp47_;
						gint _tmp47__length1;
						gchar _tmp48_;
						gchar* _tmp49_;
						gint _tmp49__length1;
						gchar* _tmp50_;
						gint _tmp50__length1;
						gchar _tmp51_;
						guint64 val = 0ULL;
						gchar* _tmp52_;
						gint _tmp52__length1;
						GString* _tmp53_;
						_tmp42_ = g_new0 (gchar, 4);
						tmpstr = _tmp42_;
						tmpstr_length1 = 4;
						_tmpstr_size_ = tmpstr_length1;
						_tmp43_ = tmpstr;
						_tmp43__length1 = tmpstr_length1;
						_tmp44_ = s;
						_tmp44__length1 = s_length1;
						_tmp45_ = _tmp44_[i + 2];
						_tmp43_[0] = _tmp45_;
						_tmp46_ = tmpstr;
						_tmp46__length1 = tmpstr_length1;
						_tmp47_ = s;
						_tmp47__length1 = s_length1;
						_tmp48_ = _tmp47_[i + 3];
						_tmp46_[1] = _tmp48_;
						_tmp49_ = tmpstr;
						_tmp49__length1 = tmpstr_length1;
						_tmp50_ = s;
						_tmp50__length1 = s_length1;
						_tmp51_ = _tmp50_[i + 4];
						_tmp49_[2] = _tmp51_;
						_tmp52_ = tmpstr;
						_tmp52__length1 = tmpstr_length1;
						val = g_ascii_strtoull ((const gchar*) _tmp52_, NULL, (guint) 8);
						_tmp53_ = rv;
						g_string_append_unichar (_tmp53_, (gunichar) val);
						i += 5;
						tmpstr = (g_free (tmpstr), NULL);
					} else {
						bare_escape = TRUE;
					}
					break;
				}
				default:
				{
					bare_escape = TRUE;
					break;
				}
			}
			if (bare_escape) {
				GString* _tmp54_;
				gchar* _tmp55_;
				gint _tmp55__length1;
				gchar _tmp56_;
				_tmp54_ = rv;
				_tmp55_ = s;
				_tmp55__length1 = s_length1;
				_tmp56_ = _tmp55_[i + 1];
				g_string_append_c (_tmp54_, _tmp56_);
				i += 2;
			}
		} else {
			GString* _tmp57_;
			gchar* _tmp58_;
			gint _tmp58__length1;
			gint _tmp59_;
			gchar _tmp60_;
			_tmp57_ = rv;
			_tmp58_ = s;
			_tmp58__length1 = s_length1;
			_tmp59_ = i;
			i = _tmp59_ + 1;
			_tmp60_ = _tmp58_[_tmp59_];
			g_string_append_c (_tmp57_, _tmp60_);
		}
	}
	_tmp61_ = rv;
	_tmp62_ = _tmp61_->str;
	_tmp63_ = g_strdup (_tmp62_);
	result = _tmp63_;
	_g_string_free0 (rv);
	return result;
}

static gchar*
string_chomp (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strchomp (_result_);
	result = _result_;
	return result;
}

static void
_vala_array_add15 (gboolean* * array,
                   gint* length,
                   gint* size,
                   gboolean value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gboolean, *array, *size);
	}
	(*array)[(*length)++] = value;
}

static void
_vala_array_add16 (gboolean* * array,
                   gint* length,
                   gint* size,
                   gboolean value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gboolean, *array, *size);
	}
	(*array)[(*length)++] = value;
}

static gboolean*
_vala_array_dup3 (gboolean* self,
                  gssize length)
{
	if (length > 0) {
		return g_memdup2 (self, length * sizeof (gboolean));
	}
	return NULL;
}

static void
stanza_split_line (const gchar* line,
                   gboolean** is_path,
                   gint* is_path_length1,
                   gchar*** split,
                   gint* split_length1)
{
	gboolean* _vala_is_path = NULL;
	gint _vala_is_path_length1 = 0;
	gchar** _vala_split = NULL;
	gint _vala_split_length1 = 0;
	gchar** firstsplit = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gint firstsplit_length1;
	gint _firstsplit_size_;
	GList* splitlist = NULL;
	gboolean* splitlist_is_path = NULL;
	gboolean* _tmp5_;
	gint splitlist_is_path_length1;
	gint _splitlist_is_path_size_;
	gint group_ends_on = 0;
	gint i = 0;
	gboolean in_group = FALSE;
	gchar* group_word = NULL;
	gchar* _tmp7_;
	GList* _tmp49_;
	gchar** _tmp50_;
	GList* _tmp51_;
	gboolean* _tmp57_;
	gint _tmp57__length1;
	gboolean* _tmp58_;
	gint _tmp58__length1;
	g_return_if_fail (line != NULL);
	_tmp0_ = string_chomp (line);
	_tmp1_ = _tmp0_;
	_tmp3_ = _tmp2_ = g_strsplit (_tmp1_, " ", 0);
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _vala_array_length (_tmp2_);
	_g_free0 (_tmp1_);
	firstsplit = _tmp4_;
	firstsplit_length1 = _tmp4__length1;
	_firstsplit_size_ = firstsplit_length1;
	splitlist = NULL;
	_tmp5_ = g_new0 (gboolean, 0);
	splitlist_is_path = _tmp5_;
	splitlist_is_path_length1 = 0;
	_splitlist_is_path_size_ = splitlist_is_path_length1;
	group_ends_on = -1;
	if (g_str_has_prefix (line, "INFO 10 ")) {
		gchar** _tmp6_;
		gint _tmp6__length1;
		_tmp6_ = firstsplit;
		_tmp6__length1 = firstsplit_length1;
		group_ends_on = _tmp6__length1 - 2;
	}
	in_group = FALSE;
	_tmp7_ = g_strdup ("");
	group_word = _tmp7_;
	{
		gboolean _tmp8_ = FALSE;
		i = 0;
		_tmp8_ = TRUE;
		while (TRUE) {
			gchar** _tmp10_;
			gint _tmp10__length1;
			const gchar* _tmp11_;
			gchar* word = NULL;
			gchar** _tmp12_;
			gint _tmp12__length1;
			const gchar* _tmp13_;
			gchar* _tmp14_;
			gboolean _tmp15_ = FALSE;
			if (!_tmp8_) {
				gint _tmp9_;
				i = i + 1;
				_tmp9_ = i;
			}
			_tmp8_ = FALSE;
			_tmp10_ = firstsplit;
			_tmp10__length1 = firstsplit_length1;
			_tmp11_ = _tmp10_[i];
			if (!(_tmp11_ != NULL)) {
				break;
			}
			_tmp12_ = firstsplit;
			_tmp12__length1 = firstsplit_length1;
			_tmp13_ = _tmp12_[i];
			_tmp14_ = g_strdup (_tmp13_);
			word = _tmp14_;
			if (!in_group) {
				const gchar* _tmp16_;
				_tmp16_ = word;
				_tmp15_ = g_str_has_prefix (_tmp16_, "\'");
			} else {
				_tmp15_ = FALSE;
			}
			if (_tmp15_) {
				in_group = TRUE;
			}
			if (in_group) {
				gboolean _tmp17_ = FALSE;
				const gchar* _tmp31_;
				gchar* _tmp32_;
				const gchar* _tmp33_;
				if (group_ends_on >= 0) {
					_tmp17_ = group_ends_on == i;
				} else {
					_tmp17_ = FALSE;
				}
				if (_tmp17_) {
					in_group = FALSE;
				} else {
					gboolean _tmp18_ = FALSE;
					gboolean _tmp19_ = FALSE;
					if (group_ends_on < 0) {
						const gchar* _tmp20_;
						_tmp20_ = word;
						_tmp19_ = g_str_has_suffix (_tmp20_, "\'");
					} else {
						_tmp19_ = FALSE;
					}
					if (_tmp19_) {
						const gchar* _tmp21_;
						const gchar* _tmp22_;
						gint _tmp23_;
						gint _tmp24_;
						_tmp21_ = word;
						_tmp22_ = word;
						_tmp23_ = strlen (_tmp22_);
						_tmp24_ = _tmp23_;
						_tmp18_ = (stanza_num_suffix (_tmp21_, '\\', ((glong) _tmp24_) - 2) % 2) == 0;
					} else {
						_tmp18_ = FALSE;
					}
					if (_tmp18_) {
						in_group = FALSE;
					} else {
						const gchar* _tmp25_;
						_tmp25_ = word;
						if ((stanza_num_suffix (_tmp25_, '\\', (glong) -1) % 2) == 1) {
							const gchar* _tmp26_;
							const gchar* _tmp27_;
							gint _tmp28_;
							gint _tmp29_;
							gchar* _tmp30_;
							_tmp26_ = word;
							_tmp27_ = word;
							_tmp28_ = strlen (_tmp27_);
							_tmp29_ = _tmp28_;
							_tmp30_ = string_substring (_tmp26_, (glong) 0, (glong) (_tmp29_ - 2));
							_g_free0 (word);
							word = _tmp30_;
						}
					}
				}
				_tmp31_ = word;
				_tmp32_ = stanza_compress_string (_tmp31_);
				_g_free0 (word);
				word = _tmp32_;
				_tmp33_ = group_word;
				if (g_strcmp0 (_tmp33_, "") == 0) {
					const gchar* _tmp34_;
					gchar* _tmp35_;
					_tmp34_ = word;
					_tmp35_ = g_strdup (_tmp34_);
					_g_free0 (group_word);
					group_word = _tmp35_;
				} else {
					const gchar* _tmp36_;
					const gchar* _tmp37_;
					gchar* _tmp38_;
					gchar* _tmp39_;
					gchar* _tmp40_;
					_tmp36_ = group_word;
					_tmp37_ = word;
					_tmp38_ = g_strconcat (" ", _tmp37_, NULL);
					_tmp39_ = _tmp38_;
					_tmp40_ = g_strconcat (_tmp36_, _tmp39_, NULL);
					_g_free0 (group_word);
					group_word = _tmp40_;
					_g_free0 (_tmp39_);
				}
				if (!in_group) {
					const gchar* _tmp41_;
					const gchar* _tmp42_;
					gint _tmp43_;
					gint _tmp44_;
					gchar* _tmp45_;
					gchar* _tmp46_;
					_tmp41_ = group_word;
					_tmp42_ = group_word;
					_tmp43_ = strlen (_tmp42_);
					_tmp44_ = _tmp43_;
					_tmp45_ = string_substring (_tmp41_, (glong) 1, (glong) (_tmp44_ - 2));
					splitlist = g_list_append (splitlist, _tmp45_);
					_vala_array_add15 (&splitlist_is_path, &splitlist_is_path_length1, &_splitlist_is_path_size_, TRUE);
					_tmp46_ = g_strdup ("");
					_g_free0 (group_word);
					group_word = _tmp46_;
				}
			} else {
				const gchar* _tmp47_;
				gchar* _tmp48_;
				_tmp47_ = word;
				_tmp48_ = g_strdup (_tmp47_);
				splitlist = g_list_append (splitlist, _tmp48_);
				_vala_array_add16 (&splitlist_is_path, &splitlist_is_path_length1, &_splitlist_is_path_size_, FALSE);
			}
			_g_free0 (word);
		}
	}
	_tmp49_ = splitlist;
	_tmp50_ = g_new0 (gchar*, g_list_length (_tmp49_) + 1);
	_vala_split = (_vala_array_free (_vala_split, _vala_split_length1, (GDestroyNotify) g_free), NULL);
	_vala_split = _tmp50_;
	_vala_split_length1 = g_list_length (_tmp49_);
	i = 0;
	_tmp51_ = splitlist;
	{
		GList* s_collection = NULL;
		GList* s_it = NULL;
		s_collection = _tmp51_;
		for (s_it = s_collection; s_it != NULL; s_it = s_it->next) {
			gchar* _tmp52_;
			gchar* s = NULL;
			_tmp52_ = g_strdup ((const gchar*) s_it->data);
			s = _tmp52_;
			{
				gchar** _tmp53_;
				gint _tmp53__length1;
				gint _tmp54_;
				const gchar* _tmp55_;
				gchar* _tmp56_;
				_tmp53_ = _vala_split;
				_tmp53__length1 = _vala_split_length1;
				_tmp54_ = i;
				i = _tmp54_ + 1;
				_tmp55_ = s;
				_tmp56_ = g_strdup (_tmp55_);
				_g_free0 (_tmp53_[_tmp54_]);
				_tmp53_[_tmp54_] = _tmp56_;
				_g_free0 (s);
			}
		}
	}
	_tmp57_ = splitlist_is_path;
	_tmp57__length1 = splitlist_is_path_length1;
	_tmp58_ = (_tmp57_ != NULL) ? _vala_array_dup3 (_tmp57_, _tmp57__length1) : _tmp57_;
	_tmp58__length1 = _tmp57__length1;
	_vala_is_path = (g_free (_vala_is_path), NULL);
	_vala_is_path = _tmp58_;
	_vala_is_path_length1 = _tmp58__length1;
	_g_free0 (group_word);
	splitlist_is_path = (g_free (splitlist_is_path), NULL);
	(splitlist == NULL) ? NULL : (splitlist = (_g_list_free__g_free0_ (splitlist), NULL));
	firstsplit = (_vala_array_free (firstsplit, firstsplit_length1, (GDestroyNotify) g_free), NULL);
	if (is_path) {
		*is_path = _vala_is_path;
	} else {
		_vala_is_path = (g_free (_vala_is_path), NULL);
	}
	if (is_path_length1) {
		*is_path_length1 = _vala_is_path_length1;
	}
	if (split) {
		*split = _vala_split;
	} else {
		_vala_split = (_vala_array_free (_vala_split, _vala_split_length1, (GDestroyNotify) g_free), NULL);
	}
	if (split_length1) {
		*split_length1 = _vala_split_length1;
	}
}

static GList*
stanza_grab_stanza_data (GList* stanza)
{
	GList* list = NULL;
	GList* _tmp0_;
	GList* result;
	list = NULL;
	_tmp0_ = stanza->next;
	stanza = _tmp0_;
	{
		GList* line_collection = NULL;
		GList* line_it = NULL;
		line_collection = stanza;
		for (line_it = line_collection; line_it != NULL; line_it = line_it->next) {
			gchar* _tmp1_;
			gchar* line = NULL;
			_tmp1_ = g_strdup ((const gchar*) line_it->data);
			line = _tmp1_;
			{
				const gchar* _tmp2_;
				_tmp2_ = line;
				if (!g_str_has_prefix (_tmp2_, ". ")) {
					const gchar* _tmp3_;
					gchar* _tmp4_;
					gchar* _tmp5_;
					gchar* _tmp6_;
					_tmp3_ = line;
					_tmp4_ = string_chomp (_tmp3_);
					_tmp5_ = _tmp4_;
					_tmp6_ = stanza_validated_string (_tmp5_);
					list = g_list_append (list, _tmp6_);
					_g_free0 (_tmp5_);
				}
				_g_free0 (line);
			}
		}
	}
	result = list;
	return result;
}

static gchar*
stanza_grab_stanza_text (GList* stanza)
{
	gchar* text = NULL;
	gchar* _tmp0_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* result;
	_tmp0_ = g_strdup ("");
	text = _tmp0_;
	{
		GList* line_collection = NULL;
		GList* line_it = NULL;
		line_collection = stanza;
		for (line_it = line_collection; line_it != NULL; line_it = line_it->next) {
			gchar* _tmp1_;
			gchar* line = NULL;
			_tmp1_ = g_strdup ((const gchar*) line_it->data);
			line = _tmp1_;
			{
				const gchar* _tmp2_;
				_tmp2_ = line;
				if (g_str_has_prefix (_tmp2_, ". ")) {
					gchar** split = NULL;
					const gchar* _tmp3_;
					gchar** _tmp4_;
					gchar** _tmp5_;
					gint split_length1;
					gint _split_size_;
					const gchar* _tmp6_;
					gchar** _tmp7_;
					gint _tmp7__length1;
					const gchar* _tmp8_;
					gchar* _tmp9_;
					gchar* _tmp10_;
					gchar* _tmp11_;
					_tmp3_ = line;
					_tmp5_ = _tmp4_ = g_strsplit (_tmp3_, ". ", 2);
					split = _tmp5_;
					split_length1 = _vala_array_length (_tmp4_);
					_split_size_ = split_length1;
					_tmp6_ = text;
					_tmp7_ = split;
					_tmp7__length1 = split_length1;
					_tmp8_ = _tmp7_[1];
					_tmp9_ = stanza_validated_string (_tmp8_);
					_tmp10_ = _tmp9_;
					_tmp11_ = g_strdup_printf ("%s%s\n", _tmp6_, _tmp10_);
					_g_free0 (text);
					text = _tmp11_;
					_g_free0 (_tmp10_);
					split = (_vala_array_free (split, split_length1, (GDestroyNotify) g_free), NULL);
				}
				_g_free0 (line);
			}
		}
	}
	_tmp12_ = text;
	_tmp13_ = string_chomp (_tmp12_);
	result = _tmp13_;
	_g_free0 (text);
	return result;
}

Stanza*
stanza_construct (GType object_type)
{
	Stanza * self = NULL;
	self = (Stanza*) g_object_new (object_type, NULL);
	return self;
}

Stanza*
stanza_new (void)
{
	return stanza_construct (TYPE_STANZA);
}

static void
stanza_class_init (StanzaClass * klass,
                   gpointer klass_data)
{
	stanza_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = stanza_finalize;
}

static void
stanza_instance_init (Stanza * self,
                      gpointer klass)
{
}

static void
stanza_finalize (GObject * obj)
{
	Stanza * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_STANZA, Stanza);
	_g_free0 (self->original_text);
	self->control_is_path = (g_free (self->control_is_path), NULL);
	self->control_line = (_vala_array_free (self->control_line, self->control_line_length1, (GDestroyNotify) g_free), NULL);
	(self->data == NULL) ? NULL : (self->data = (_g_list_free__g_free0_ (self->data), NULL));
	_g_free0 (self->text);
	G_OBJECT_CLASS (stanza_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
stanza_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (StanzaClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) stanza_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Stanza), 0, (GInstanceInitFunc) stanza_instance_init, NULL };
	GType stanza_type_id;
	stanza_type_id = g_type_register_static (G_TYPE_OBJECT, "Stanza", &g_define_type_info, 0);
	return stanza_type_id;
}

GType
stanza_get_type (void)
{
	static gsize stanza_type_id__once = 0;
	if (g_once_init_enter (&stanza_type_id__once)) {
		GType stanza_type_id;
		stanza_type_id = stanza_get_type_once ();
		g_once_init_leave (&stanza_type_id__once, stanza_type_id);
	}
	return stanza_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

