/* OperationWrapper.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from OperationWrapper.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*-
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: Michael Terry
 */
/* This holds an abstraction of an Operation, exposing just a few dynamic*/
/* properties that UIs can bind to (summary & button).*/
/* It also handles some of the GTK-side business logic (like dialogs).*/
/* This is meant to be cheap and created per-widget.*/
/* All global GTK-business logic is in OperationLauncher.*/

#include <glib-object.h>
#include "deja.h"
#include <gtk/gtk.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>
#include <adwaita.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_OPERATION_WRAPPER (operation_wrapper_get_type ())
#define OPERATION_WRAPPER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_OPERATION_WRAPPER, OperationWrapper))
#define OPERATION_WRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_OPERATION_WRAPPER, OperationWrapperClass))
#define IS_OPERATION_WRAPPER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_OPERATION_WRAPPER))
#define IS_OPERATION_WRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_OPERATION_WRAPPER))
#define OPERATION_WRAPPER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_OPERATION_WRAPPER, OperationWrapperClass))

typedef struct _OperationWrapper OperationWrapper;
typedef struct _OperationWrapperClass OperationWrapperClass;
typedef struct _OperationWrapperPrivate OperationWrapperPrivate;
typedef enum  {
	OPERATION_WRAPPER_MODE_PROGRESS,
	OPERATION_WRAPPER_MODE_ERROR_PERSISTENT,
	OPERATION_WRAPPER_MODE_ERROR_TEMPORARY
} OperationWrapperMode;

#define OPERATION_WRAPPER_TYPE_MODE (operation_wrapper_mode_get_type ())
typedef void (*OperationWrapperButtonAction) (gpointer user_data);
enum  {
	OPERATION_WRAPPER_0_PROPERTY,
	OPERATION_WRAPPER_OPERATION_PROPERTY,
	OPERATION_WRAPPER_PARENT_PROPERTY,
	OPERATION_WRAPPER_CANCEL_STOPS_PROPERTY,
	OPERATION_WRAPPER_ACTIVE_PROPERTY,
	OPERATION_WRAPPER_SUMMARY_PROPERTY,
	OPERATION_WRAPPER_BUTTON_LABEL_PROPERTY,
	OPERATION_WRAPPER_BUTTON_SUGGESTED_PROPERTY,
	OPERATION_WRAPPER_ERROR_MODE_PROPERTY,
	OPERATION_WRAPPER_FRACTION_PROPERTY,
	OPERATION_WRAPPER_PULSING_PROPERTY,
	OPERATION_WRAPPER_NUM_PROPERTIES
};
static GParamSpec* operation_wrapper_properties[OPERATION_WRAPPER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block6Data Block6Data;
typedef struct _Block7Data Block7Data;

#define TYPE_PASSPHRASE_DIALOG (passphrase_dialog_get_type ())
#define PASSPHRASE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PASSPHRASE_DIALOG, PassphraseDialog))
#define PASSPHRASE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PASSPHRASE_DIALOG, PassphraseDialogClass))
#define IS_PASSPHRASE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PASSPHRASE_DIALOG))
#define IS_PASSPHRASE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PASSPHRASE_DIALOG))
#define PASSPHRASE_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PASSPHRASE_DIALOG, PassphraseDialogClass))

typedef struct _PassphraseDialog PassphraseDialog;
typedef struct _PassphraseDialogClass PassphraseDialogClass;
typedef struct _OperationWrapperAskPassphraseData OperationWrapperAskPassphraseData;
typedef struct _Block8Data Block8Data;
typedef struct _OperationWrapperAskBackendPasswordData OperationWrapperAskBackendPasswordData;
typedef struct _Block9Data Block9Data;
typedef struct _Block10Data Block10Data;
enum  {
	OPERATION_WRAPPER_PULSE_SIGNAL,
	OPERATION_WRAPPER_ATTENTION_NEEDED_SIGNAL,
	OPERATION_WRAPPER_PAUSE_CHANGED_SIGNAL,
	OPERATION_WRAPPER_SUCCEEDED_SIGNAL,
	OPERATION_WRAPPER_DONE_SIGNAL,
	OPERATION_WRAPPER_NUM_SIGNALS
};
static guint operation_wrapper_signals[OPERATION_WRAPPER_NUM_SIGNALS] = {0};

struct _OperationWrapper {
	GObject parent_instance;
	OperationWrapperPrivate * priv;
};

struct _OperationWrapperClass {
	GObjectClass parent_class;
};

struct _OperationWrapperPrivate {
	DejaDupOperation* _operation;
	GtkWidget* _parent;
	gboolean _cancel_stops;
	gboolean _active;
	gchar* _summary;
	gchar* _button_label;
	gboolean _button_suggested;
	gboolean _error_mode;
	gdouble _fraction;
	OperationWrapperMode mode;
	gboolean progress_enabled;
	guint pulse_id;
	OperationWrapperButtonAction button_action;
	gpointer button_action_target;
	GDestroyNotify button_action_target_destroy_notify;
	gboolean button_is_dialog;
};

struct _Block6Data {
	int _ref_count_;
	OperationWrapper* self;
	gchar* detail;
};

struct _Block7Data {
	int _ref_count_;
	OperationWrapper* self;
	gchar* errstr;
	gchar* detail;
};

struct _OperationWrapperAskPassphraseData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	OperationWrapper* self;
	gchar* heading;
	gchar* body;
	gboolean first;
	gboolean nag;
	PassphraseDialog* dialog;
	PassphraseDialog* _tmp0_;
	PassphraseDialog* _tmp1_;
	PassphraseDialog* _tmp2_;
	PassphraseDialog* _tmp3_;
	PassphraseDialog* _tmp4_;
	PassphraseDialog* _tmp5_;
	gchar* response;
	PassphraseDialog* _tmp6_;
	GtkWidget* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	DejaDupOperation* _tmp11_;
	PassphraseDialog* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	PassphraseDialog* _tmp15_;
	gboolean _tmp16_;
	gboolean _tmp17_;
};

struct _Block8Data {
	int _ref_count_;
	OperationWrapper* self;
	gchar* header;
	gchar* body;
	gboolean nag;
	gboolean first;
};

struct _OperationWrapperAskBackendPasswordData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	OperationWrapper* self;
	gchar* body;
	gchar* label;
	PassphraseDialog* dialog;
	PassphraseDialog* _tmp0_;
	PassphraseDialog* _tmp1_;
	PassphraseDialog* _tmp2_;
	PassphraseDialog* _tmp3_;
	gchar* response;
	PassphraseDialog* _tmp4_;
	GtkWidget* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gboolean _tmp8_;
	const gchar* _tmp9_;
	PassphraseDialog* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	DejaDupOperation* _tmp13_;
	PassphraseDialog* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	PassphraseDialog* _tmp17_;
	gboolean _tmp18_;
	gboolean _tmp19_;
};

struct _Block9Data {
	int _ref_count_;
	OperationWrapper* self;
	gchar* label;
};

struct _Block10Data {
	int _ref_count_;
	OperationWrapper* self;
	gchar* header;
	gchar* description;
	gchar* action;
	gboolean safe;
};

static gint OperationWrapper_private_offset;
static gpointer operation_wrapper_parent_class = NULL;

VALA_EXTERN GType operation_wrapper_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (OperationWrapper, g_object_unref)
static GType operation_wrapper_mode_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
VALA_EXTERN OperationWrapper* operation_wrapper_new (DejaDupOperation* operation,
                                         GtkWidget* parent);
VALA_EXTERN OperationWrapper* operation_wrapper_construct (GType object_type,
                                               DejaDupOperation* operation,
                                               GtkWidget* parent);
static void operation_wrapper_connect_operation (OperationWrapper* self);
VALA_EXTERN void operation_wrapper_click (OperationWrapper* self);
VALA_EXTERN void operation_wrapper_auto_click (OperationWrapper* self);
VALA_EXTERN void operation_wrapper_clear (OperationWrapper* self);
VALA_EXTERN void operation_wrapper_set_operation (OperationWrapper* self,
                                      DejaDupOperation* value);
VALA_EXTERN DejaDupOperation* operation_wrapper_get_operation (OperationWrapper* self);
static void operation_wrapper_handle_started (OperationWrapper* self);
static void _operation_wrapper_handle_started_deja_dup_operation_started (DejaDupOperation* _sender,
                                                                   gpointer self);
static void operation_wrapper_handle_done (OperationWrapper* self,
                                    gboolean success,
                                    gboolean cancelled,
                                    const gchar* detail);
static void _operation_wrapper_handle_done_deja_dup_operation_done (DejaDupOperation* _sender,
                                                             gboolean success,
                                                             gboolean cancelled,
                                                             const gchar* detail,
                                                             gpointer self);
static void operation_wrapper_handle_error (OperationWrapper* self,
                                     const gchar* errstr,
                                     const gchar* detail);
static void _operation_wrapper_handle_error_deja_dup_operation_raise_error (DejaDupOperation* _sender,
                                                                     const gchar* errstr,
                                                                     const gchar* detail,
                                                                     gpointer self);
static void operation_wrapper_handle_action_desc (OperationWrapper* self,
                                           const gchar* action);
static void _operation_wrapper_handle_action_desc_deja_dup_operation_action_desc_changed (DejaDupOperation* _sender,
                                                                                   const gchar* action,
                                                                                   gpointer self);
static void operation_wrapper_handle_progress (OperationWrapper* self,
                                        gdouble percent);
static void _operation_wrapper_handle_progress_deja_dup_operation_progress (DejaDupOperation* _sender,
                                                                     gdouble percent,
                                                                     gpointer self);
static void operation_wrapper_handle_passphrase_required (OperationWrapper* self,
                                                   gboolean repeat,
                                                   gboolean first);
static void _operation_wrapper_handle_passphrase_required_deja_dup_operation_passphrase_required (DejaDupOperation* _sender,
                                                                                           gboolean repeat,
                                                                                           gboolean first,
                                                                                           gpointer self);
static void operation_wrapper_handle_backend_password_required (OperationWrapper* self,
                                                         const gchar* desc,
                                                         const gchar* label,
                                                         const gchar* _error_);
static void _operation_wrapper_handle_backend_password_required_deja_dup_operation_backend_password_required (DejaDupOperation* _sender,
                                                                                                       const gchar* desc,
                                                                                                       const gchar* label,
                                                                                                       const gchar* _error_,
                                                                                                       gpointer self);
static void operation_wrapper_handle_question (OperationWrapper* self,
                                        const gchar* summary,
                                        const gchar* header,
                                        const gchar* description,
                                        const gchar* action,
                                        gboolean safe);
static void _operation_wrapper_handle_question_deja_dup_operation_question (DejaDupOperation* _sender,
                                                                     const gchar* summary,
                                                                     const gchar* header,
                                                                     const gchar* description,
                                                                     const gchar* action,
                                                                     gboolean safe,
                                                                     gpointer self);
static void operation_wrapper_handle_mount_op_required (OperationWrapper* self);
static void _operation_wrapper_handle_mount_op_required_deja_dup_operation_mount_op_required (DejaDupOperation* _sender,
                                                                                       gpointer self);
static void operation_wrapper_handle_pause_changed (OperationWrapper* self,
                                             gboolean paused);
static void _operation_wrapper_handle_pause_changed_deja_dup_operation_pause_changed (DejaDupOperation* _sender,
                                                                               gboolean paused,
                                                                               gpointer self);
static void operation_wrapper_reset (OperationWrapper* self);
static void operation_wrapper_set_summary (OperationWrapper* self,
                                    const gchar* value);
static void operation_wrapper_set_button_label (OperationWrapper* self,
                                         const gchar* value);
static void operation_wrapper_set_button_suggested (OperationWrapper* self,
                                             gboolean value);
static void operation_wrapper_set_error_mode (OperationWrapper* self,
                                       gboolean value);
static void operation_wrapper_set_progress_enabled (OperationWrapper* self,
                                             gboolean enabled);
VALA_EXTERN gdouble operation_wrapper_get_fraction (OperationWrapper* self);
static gboolean operation_wrapper_send_pulse (OperationWrapper* self);
static gboolean _operation_wrapper_send_pulse_gsource_func (gpointer self);
static void operation_wrapper_set_fraction (OperationWrapper* self,
                                     gdouble value);
static void operation_wrapper_activate_error_mode (OperationWrapper* self,
                                            OperationWrapperMode m);
static void operation_wrapper_dialog_closed (OperationWrapper* self);
VALA_EXTERN gboolean operation_wrapper_get_cancel_stops (OperationWrapper* self);
static void operation_wrapper_set_active (OperationWrapper* self,
                                   gboolean value);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static void ____lambda8_ (Block6Data* _data6_);
VALA_EXTERN GtkWidget* operation_wrapper_get_parent (OperationWrapper* self);
static void _____lambda8__operation_wrapper_button_action (gpointer self);
static void _deja_dup_operation_stop_operation_wrapper_button_action (gpointer self);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static void __lambda9_ (Block7Data* _data7_);
static void ___lambda9__operation_wrapper_button_action (gpointer self);
static void _operation_wrapper_ask_passphrase_data_free (gpointer _data);
static void _operation_wrapper_ask_passphrase (OperationWrapper* self,
                                        const gchar* heading,
                                        const gchar* body,
                                        gboolean first,
                                        gboolean nag,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_);
static void _operation_wrapper_ask_passphrase_finish (OperationWrapper* self,
                                               GAsyncResult* _res_);
static gboolean _operation_wrapper_ask_passphrase_co (OperationWrapperAskPassphraseData* _data_);
VALA_EXTERN GType passphrase_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PassphraseDialog, g_object_unref)
VALA_EXTERN PassphraseDialog* passphrase_dialog_new (void);
VALA_EXTERN PassphraseDialog* passphrase_dialog_construct (GType object_type);
VALA_EXTERN void passphrase_dialog_set_label (PassphraseDialog* self,
                                  const gchar* value);
VALA_EXTERN void passphrase_dialog_set_first_time (PassphraseDialog* self,
                                       gboolean value);
VALA_EXTERN void passphrase_dialog_set_nag_mode (PassphraseDialog* self,
                                     gboolean value);
static void _operation_wrapper_ask_passphrase_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_);
VALA_EXTERN const gchar* passphrase_dialog_get_passphrase (PassphraseDialog* self);
VALA_EXTERN gboolean passphrase_dialog_get_remember (PassphraseDialog* self);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
static void __lambda10_ (Block8Data* _data8_);
static void ___lambda10__operation_wrapper_button_action (gpointer self);
static void _operation_wrapper_ask_backend_password_data_free (gpointer _data);
static void _operation_wrapper_ask_backend_password (OperationWrapper* self,
                                              const gchar* body,
                                              const gchar* label,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_);
static void _operation_wrapper_ask_backend_password_finish (OperationWrapper* self,
                                                     GAsyncResult* _res_);
static gboolean _operation_wrapper_ask_backend_password_co (OperationWrapperAskBackendPasswordData* _data_);
static void _operation_wrapper_ask_backend_password_ready (GObject* source_object,
                                                    GAsyncResult* _res_,
                                                    gpointer _user_data_);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (void * _userdata_);
static void __lambda11_ (Block9Data* _data9_);
VALA_EXTERN const gchar* operation_wrapper_get_summary (OperationWrapper* self);
static void ___lambda11__operation_wrapper_button_action (gpointer self);
static void __lambda15_ (OperationWrapper* self);
static void ___lambda15__operation_wrapper_button_action (gpointer self);
static Block10Data* block10_data_ref (Block10Data* _data10_);
static void block10_data_unref (void * _userdata_);
static void __lambda12_ (Block10Data* _data10_);
static void __lambda13_ (OperationWrapper* self);
static void ___lambda13__adw_alert_dialog_response (AdwAlertDialog* _sender,
                                             const gchar* response,
                                             gpointer self);
static void __lambda14_ (OperationWrapper* self);
static void ___lambda14__adw_alert_dialog_response (AdwAlertDialog* _sender,
                                             const gchar* response,
                                             gpointer self);
static void ___lambda12__operation_wrapper_button_action (gpointer self);
static void operation_wrapper_set_parent (OperationWrapper* self,
                                   GtkWidget* value);
VALA_EXTERN void operation_wrapper_set_cancel_stops (OperationWrapper* self,
                                         gboolean value);
VALA_EXTERN gboolean operation_wrapper_get_active (OperationWrapper* self);
VALA_EXTERN const gchar* operation_wrapper_get_button_label (OperationWrapper* self);
VALA_EXTERN gboolean operation_wrapper_get_button_suggested (OperationWrapper* self);
VALA_EXTERN gboolean operation_wrapper_get_error_mode (OperationWrapper* self);
VALA_EXTERN gboolean operation_wrapper_get_pulsing (OperationWrapper* self);
static void operation_wrapper_finalize (GObject * obj);
static GType operation_wrapper_get_type_once (void);
static void _vala_operation_wrapper_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec);
static void _vala_operation_wrapper_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec);

static inline gpointer
operation_wrapper_get_instance_private (OperationWrapper* self)
{
	return G_STRUCT_MEMBER_P (self, OperationWrapper_private_offset);
}

 G_GNUC_NO_INLINE static GType
operation_wrapper_mode_get_type_once (void)
{
	static const GEnumValue values[] = {{OPERATION_WRAPPER_MODE_PROGRESS, "OPERATION_WRAPPER_MODE_PROGRESS", "progress"}, {OPERATION_WRAPPER_MODE_ERROR_PERSISTENT, "OPERATION_WRAPPER_MODE_ERROR_PERSISTENT", "error-persistent"}, {OPERATION_WRAPPER_MODE_ERROR_TEMPORARY, "OPERATION_WRAPPER_MODE_ERROR_TEMPORARY", "error-temporary"}, {0, NULL, NULL}};
	GType operation_wrapper_mode_type_id;
	operation_wrapper_mode_type_id = g_enum_register_static ("OperationWrapperMode", values);
	return operation_wrapper_mode_type_id;
}

static GType
operation_wrapper_mode_get_type (void)
{
	static gsize operation_wrapper_mode_type_id__once = 0;
	if (g_once_init_enter (&operation_wrapper_mode_type_id__once)) {
		GType operation_wrapper_mode_type_id;
		operation_wrapper_mode_type_id = operation_wrapper_mode_get_type_once ();
		g_once_init_leave (&operation_wrapper_mode_type_id__once, operation_wrapper_mode_type_id);
	}
	return operation_wrapper_mode_type_id__once;
}

OperationWrapper*
operation_wrapper_construct (GType object_type,
                             DejaDupOperation* operation,
                             GtkWidget* parent)
{
	OperationWrapper * self = NULL;
	g_return_val_if_fail (operation != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	self = (OperationWrapper*) g_object_new (object_type, "operation", operation, "parent", parent, NULL);
	operation_wrapper_connect_operation (self);
	return self;
}

OperationWrapper*
operation_wrapper_new (DejaDupOperation* operation,
                       GtkWidget* parent)
{
	return operation_wrapper_construct (TYPE_OPERATION_WRAPPER, operation, parent);
}

void
operation_wrapper_click (OperationWrapper* self)
{
	OperationWrapperButtonAction _tmp0_;
	gpointer _tmp0__target;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->button_action;
	_tmp0__target = self->priv->button_action_target;
	if (_tmp0_ != NULL) {
		OperationWrapperButtonAction _tmp1_;
		gpointer _tmp1__target;
		_tmp1_ = self->priv->button_action;
		_tmp1__target = self->priv->button_action_target;
		_tmp1_ (_tmp1__target);
	}
}

void
operation_wrapper_auto_click (OperationWrapper* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->button_is_dialog) {
		operation_wrapper_click (self);
	}
}

void
operation_wrapper_clear (OperationWrapper* self)
{
	g_return_if_fail (self != NULL);
	operation_wrapper_set_operation (self, NULL);
}

static void
_operation_wrapper_handle_started_deja_dup_operation_started (DejaDupOperation* _sender,
                                                              gpointer self)
{
	operation_wrapper_handle_started ((OperationWrapper*) self);
}

static void
_operation_wrapper_handle_done_deja_dup_operation_done (DejaDupOperation* _sender,
                                                        gboolean success,
                                                        gboolean cancelled,
                                                        const gchar* detail,
                                                        gpointer self)
{
	operation_wrapper_handle_done ((OperationWrapper*) self, success, cancelled, detail);
}

static void
_operation_wrapper_handle_error_deja_dup_operation_raise_error (DejaDupOperation* _sender,
                                                                const gchar* errstr,
                                                                const gchar* detail,
                                                                gpointer self)
{
	operation_wrapper_handle_error ((OperationWrapper*) self, errstr, detail);
}

static void
_operation_wrapper_handle_action_desc_deja_dup_operation_action_desc_changed (DejaDupOperation* _sender,
                                                                              const gchar* action,
                                                                              gpointer self)
{
	operation_wrapper_handle_action_desc ((OperationWrapper*) self, action);
}

static void
_operation_wrapper_handle_progress_deja_dup_operation_progress (DejaDupOperation* _sender,
                                                                gdouble percent,
                                                                gpointer self)
{
	operation_wrapper_handle_progress ((OperationWrapper*) self, percent);
}

static void
_operation_wrapper_handle_passphrase_required_deja_dup_operation_passphrase_required (DejaDupOperation* _sender,
                                                                                      gboolean repeat,
                                                                                      gboolean first,
                                                                                      gpointer self)
{
	operation_wrapper_handle_passphrase_required ((OperationWrapper*) self, repeat, first);
}

static void
_operation_wrapper_handle_backend_password_required_deja_dup_operation_backend_password_required (DejaDupOperation* _sender,
                                                                                                  const gchar* desc,
                                                                                                  const gchar* label,
                                                                                                  const gchar* _error_,
                                                                                                  gpointer self)
{
	operation_wrapper_handle_backend_password_required ((OperationWrapper*) self, desc, label, _error_);
}

static void
_operation_wrapper_handle_question_deja_dup_operation_question (DejaDupOperation* _sender,
                                                                const gchar* summary,
                                                                const gchar* header,
                                                                const gchar* description,
                                                                const gchar* action,
                                                                gboolean safe,
                                                                gpointer self)
{
	operation_wrapper_handle_question ((OperationWrapper*) self, summary, header, description, action, safe);
}

static void
_operation_wrapper_handle_mount_op_required_deja_dup_operation_mount_op_required (DejaDupOperation* _sender,
                                                                                  gpointer self)
{
	operation_wrapper_handle_mount_op_required ((OperationWrapper*) self);
}

static void
_operation_wrapper_handle_pause_changed_deja_dup_operation_pause_changed (DejaDupOperation* _sender,
                                                                          gboolean paused,
                                                                          gpointer self)
{
	operation_wrapper_handle_pause_changed ((OperationWrapper*) self, paused);
}

static void
operation_wrapper_connect_operation (OperationWrapper* self)
{
	DejaDupOperation* _tmp0_;
	DejaDupOperation* _tmp1_;
	DejaDupOperation* _tmp2_;
	DejaDupOperation* _tmp3_;
	DejaDupOperation* _tmp4_;
	DejaDupOperation* _tmp5_;
	DejaDupOperation* _tmp6_;
	DejaDupOperation* _tmp7_;
	DejaDupOperation* _tmp8_;
	DejaDupOperation* _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_operation;
	g_signal_connect_object (_tmp0_, "started", (GCallback) _operation_wrapper_handle_started_deja_dup_operation_started, self, 0);
	_tmp1_ = self->priv->_operation;
	g_signal_connect_object (_tmp1_, "done", (GCallback) _operation_wrapper_handle_done_deja_dup_operation_done, self, 0);
	_tmp2_ = self->priv->_operation;
	g_signal_connect_object (_tmp2_, "raise-error", (GCallback) _operation_wrapper_handle_error_deja_dup_operation_raise_error, self, 0);
	_tmp3_ = self->priv->_operation;
	g_signal_connect_object (_tmp3_, "action-desc-changed", (GCallback) _operation_wrapper_handle_action_desc_deja_dup_operation_action_desc_changed, self, 0);
	_tmp4_ = self->priv->_operation;
	g_signal_connect_object (_tmp4_, "progress", (GCallback) _operation_wrapper_handle_progress_deja_dup_operation_progress, self, 0);
	_tmp5_ = self->priv->_operation;
	g_signal_connect_object (_tmp5_, "passphrase-required", (GCallback) _operation_wrapper_handle_passphrase_required_deja_dup_operation_passphrase_required, self, 0);
	_tmp6_ = self->priv->_operation;
	g_signal_connect_object (_tmp6_, "backend-password-required", (GCallback) _operation_wrapper_handle_backend_password_required_deja_dup_operation_backend_password_required, self, 0);
	_tmp7_ = self->priv->_operation;
	g_signal_connect_object (_tmp7_, "question", (GCallback) _operation_wrapper_handle_question_deja_dup_operation_question, self, 0);
	_tmp8_ = self->priv->_operation;
	g_signal_connect_object (_tmp8_, "mount-op-required", (GCallback) _operation_wrapper_handle_mount_op_required_deja_dup_operation_mount_op_required, self, 0);
	_tmp9_ = self->priv->_operation;
	g_signal_connect_object (_tmp9_, "pause-changed", (GCallback) _operation_wrapper_handle_pause_changed_deja_dup_operation_pause_changed, self, 0);
}

static void
operation_wrapper_reset (OperationWrapper* self)
{
	g_return_if_fail (self != NULL);
	operation_wrapper_set_summary (self, "");
	operation_wrapper_set_button_label (self, "");
	operation_wrapper_set_button_suggested (self, FALSE);
	operation_wrapper_set_error_mode (self, FALSE);
	self->priv->mode = OPERATION_WRAPPER_MODE_PROGRESS;
	(self->priv->button_action_target_destroy_notify == NULL) ? NULL : (self->priv->button_action_target_destroy_notify (self->priv->button_action_target), NULL);
	self->priv->button_action = NULL;
	self->priv->button_action_target = NULL;
	self->priv->button_action_target_destroy_notify = NULL;
	self->priv->button_action = NULL;
	self->priv->button_action_target = NULL;
	self->priv->button_action_target_destroy_notify = NULL;
	self->priv->button_is_dialog = FALSE;
}

static gboolean
_operation_wrapper_send_pulse_gsource_func (gpointer self)
{
	gboolean result;
	result = operation_wrapper_send_pulse ((OperationWrapper*) self);
	return result;
}

static void
operation_wrapper_set_progress_enabled (OperationWrapper* self,
                                        gboolean enabled)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	self->priv->progress_enabled = enabled;
	if (enabled) {
		gdouble _tmp2_;
		_tmp2_ = self->priv->_fraction;
		_tmp1_ = _tmp2_ == ((gdouble) 0);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = self->priv->pulse_id == ((guint) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		self->priv->pulse_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 250, _operation_wrapper_send_pulse_gsource_func, g_object_ref (self), g_object_unref);
	} else {
		if (!enabled) {
			if (self->priv->pulse_id > ((guint) 0)) {
				g_source_remove (self->priv->pulse_id);
			}
			self->priv->pulse_id = (guint) 0;
			operation_wrapper_set_fraction (self, (gdouble) 1);
			operation_wrapper_set_fraction (self, (gdouble) 0);
		}
	}
	g_object_notify ((GObject*) self, "pulsing");
}

static gboolean
operation_wrapper_send_pulse (OperationWrapper* self)
{
	gboolean _tmp0_ = FALSE;
	gdouble _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->_fraction;
	if (_tmp1_ == ((gdouble) 0)) {
		_tmp0_ = self->priv->progress_enabled;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		g_signal_emit (self, operation_wrapper_signals[OPERATION_WRAPPER_PULSE_SIGNAL], 0);
		result = G_SOURCE_CONTINUE;
		return result;
	} else {
		self->priv->pulse_id = (guint) 0;
		g_object_notify ((GObject*) self, "pulsing");
		result = G_SOURCE_REMOVE;
		return result;
	}
}

static void
operation_wrapper_activate_error_mode (OperationWrapper* self,
                                       OperationWrapperMode m)
{
	g_return_if_fail (self != NULL);
	self->priv->mode = m;
	operation_wrapper_set_error_mode (self, m == OPERATION_WRAPPER_MODE_ERROR_PERSISTENT);
}

static void
operation_wrapper_dialog_closed (OperationWrapper* self)
{
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_cancel_stops;
	if (_tmp0_) {
		DejaDupOperation* _tmp1_;
		_tmp1_ = self->priv->_operation;
		deja_dup_operation_stop (_tmp1_);
	}
}

static void
operation_wrapper_handle_started (OperationWrapper* self)
{
	g_return_if_fail (self != NULL);
	operation_wrapper_set_fraction (self, (gdouble) 0);
	operation_wrapper_set_progress_enabled (self, TRUE);
	operation_wrapper_reset (self);
	operation_wrapper_set_active (self, TRUE);
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		OperationWrapper* self;
		self = _data6_->self;
		_g_free0 (_data6_->detail);
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}

static void
____lambda8_ (Block6Data* _data6_)
{
	OperationWrapper* self;
	AdwAlertDialog* dlg = NULL;
	AdwAlertDialog* _tmp0_;
	GtkWidget* _tmp1_;
	self = _data6_->self;
	_tmp0_ = (AdwAlertDialog*) adw_alert_dialog_new (NULL, _data6_->detail);
	g_object_ref_sink (_tmp0_);
	dlg = _tmp0_;
	adw_alert_dialog_add_response (dlg, "close", _ ("_Close"));
	_tmp1_ = self->priv->_parent;
	adw_alert_dialog_choose (dlg, _tmp1_, NULL, NULL, NULL);
	_g_object_unref0 (dlg);
}

static void
_____lambda8__operation_wrapper_button_action (gpointer self)
{
	____lambda8_ (self);
}

static void
operation_wrapper_handle_done (OperationWrapper* self,
                               gboolean success,
                               gboolean cancelled,
                               const gchar* detail)
{
	Block6Data* _data6_;
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_data6_->self = g_object_ref (self);
	_tmp0_ = g_strdup (detail);
	_g_free0 (_data6_->detail);
	_data6_->detail = _tmp0_;
	if (cancelled) {
		operation_wrapper_reset (self);
		operation_wrapper_set_active (self, FALSE);
	} else {
		gboolean _tmp1_ = FALSE;
		if (success) {
			_tmp1_ = _data6_->detail != NULL;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			DejaDupOperation* _tmp2_;
			DejaDupToolJobMode _tmp3_;
			DejaDupToolJobMode _tmp4_;
			operation_wrapper_reset (self);
			_tmp2_ = self->priv->_operation;
			_tmp3_ = deja_dup_operation_get_mode (_tmp2_);
			_tmp4_ = _tmp3_;
			if (_tmp4_ == DEJA_DUP_TOOL_JOB_MODE_BACKUP) {
				operation_wrapper_set_summary (self, _ ("Backup completed, but not all files were successfully backed up"));
			} else {
				DejaDupOperation* _tmp5_;
				DejaDupToolJobMode _tmp6_;
				DejaDupToolJobMode _tmp7_;
				_tmp5_ = self->priv->_operation;
				_tmp6_ = deja_dup_operation_get_mode (_tmp5_);
				_tmp7_ = _tmp6_;
				if (_tmp7_ == DEJA_DUP_TOOL_JOB_MODE_RESTORE) {
					operation_wrapper_set_summary (self, _ ("Restore completed, but not all files were successfully restored"));
				}
			}
			operation_wrapper_set_button_label (self, _ ("_Details"));
			(self->priv->button_action_target_destroy_notify == NULL) ? NULL : (self->priv->button_action_target_destroy_notify (self->priv->button_action_target), NULL);
			self->priv->button_action = NULL;
			self->priv->button_action_target = NULL;
			self->priv->button_action_target_destroy_notify = NULL;
			self->priv->button_action = _____lambda8__operation_wrapper_button_action;
			self->priv->button_action_target = block6_data_ref (_data6_);
			self->priv->button_action_target_destroy_notify = block6_data_unref;
			self->priv->button_is_dialog = TRUE;
			g_signal_emit (self, operation_wrapper_signals[OPERATION_WRAPPER_SUCCEEDED_SIGNAL], 0, TRUE);
		} else {
			if (success) {
				DejaDupOperation* _tmp8_;
				DejaDupToolJobMode _tmp9_;
				DejaDupToolJobMode _tmp10_;
				operation_wrapper_reset (self);
				_tmp8_ = self->priv->_operation;
				_tmp9_ = deja_dup_operation_get_mode (_tmp8_);
				_tmp10_ = _tmp9_;
				if (_tmp10_ == DEJA_DUP_TOOL_JOB_MODE_BACKUP) {
					operation_wrapper_set_summary (self, _ ("Backup completed"));
				} else {
					DejaDupOperation* _tmp11_;
					DejaDupToolJobMode _tmp12_;
					DejaDupToolJobMode _tmp13_;
					_tmp11_ = self->priv->_operation;
					_tmp12_ = deja_dup_operation_get_mode (_tmp11_);
					_tmp13_ = _tmp12_;
					if (_tmp13_ == DEJA_DUP_TOOL_JOB_MODE_RESTORE) {
						operation_wrapper_set_summary (self, _ ("Restore completed"));
					}
				}
				operation_wrapper_set_active (self, FALSE);
				g_signal_emit (self, operation_wrapper_signals[OPERATION_WRAPPER_SUCCEEDED_SIGNAL], 0, FALSE);
			}
		}
	}
	operation_wrapper_set_progress_enabled (self, FALSE);
	g_signal_emit (self, operation_wrapper_signals[OPERATION_WRAPPER_DONE_SIGNAL], 0, cancelled);
	block6_data_unref (_data6_);
	_data6_ = NULL;
}

static void
operation_wrapper_handle_pause_changed (OperationWrapper* self,
                                        gboolean paused)
{
	g_return_if_fail (self != NULL);
	g_signal_emit (self, operation_wrapper_signals[OPERATION_WRAPPER_PAUSE_CHANGED_SIGNAL], 0, paused);
}

static void
_deja_dup_operation_stop_operation_wrapper_button_action (gpointer self)
{
	deja_dup_operation_stop ((DejaDupOperation*) self);
}

static void
operation_wrapper_handle_action_desc (OperationWrapper* self,
                                      const gchar* action)
{
	DejaDupOperation* _tmp0_;
	DejaDupOperation* _tmp1_;
	DejaDupToolJobMode _tmp2_;
	DejaDupToolJobMode _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	operation_wrapper_set_progress_enabled (self, TRUE);
	operation_wrapper_reset (self);
	operation_wrapper_set_summary (self, action);
	_tmp0_ = self->priv->_operation;
	(self->priv->button_action_target_destroy_notify == NULL) ? NULL : (self->priv->button_action_target_destroy_notify (self->priv->button_action_target), NULL);
	self->priv->button_action = NULL;
	self->priv->button_action_target = NULL;
	self->priv->button_action_target_destroy_notify = NULL;
	self->priv->button_action = _deja_dup_operation_stop_operation_wrapper_button_action;
	self->priv->button_action_target = g_object_ref (_tmp0_);
	self->priv->button_action_target_destroy_notify = g_object_unref;
	_tmp1_ = self->priv->_operation;
	_tmp2_ = deja_dup_operation_get_mode (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == DEJA_DUP_TOOL_JOB_MODE_BACKUP) {
		operation_wrapper_set_button_label (self, _ ("_Pause"));
	} else {
		operation_wrapper_set_button_label (self, _ ("_Stop"));
	}
}

static void
operation_wrapper_handle_progress (OperationWrapper* self,
                                   gdouble percent)
{
	g_return_if_fail (self != NULL);
	operation_wrapper_set_fraction (self, percent);
	operation_wrapper_set_progress_enabled (self, TRUE);
}

static Block7Data*
block7_data_ref (Block7Data* _data7_)
{
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}

static void
block7_data_unref (void * _userdata_)
{
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		OperationWrapper* self;
		self = _data7_->self;
		_g_free0 (_data7_->errstr);
		_g_free0 (_data7_->detail);
		_g_object_unref0 (self);
		g_slice_free (Block7Data, _data7_);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda9_ (Block7Data* _data7_)
{
	OperationWrapper* self;
	AdwAlertDialog* _tmp0_ = NULL;
	AdwAlertDialog* dlg = NULL;
	AdwAlertDialog* _tmp3_;
	GtkWidget* _tmp4_;
	self = _data7_->self;
	if (_data7_->detail == NULL) {
		AdwAlertDialog* _tmp1_;
		_tmp1_ = (AdwAlertDialog*) adw_alert_dialog_new (NULL, _data7_->errstr);
		g_object_ref_sink (_tmp1_);
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp1_;
	} else {
		AdwAlertDialog* _tmp2_;
		_tmp2_ = (AdwAlertDialog*) adw_alert_dialog_new (_data7_->errstr, _data7_->detail);
		g_object_ref_sink (_tmp2_);
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp2_;
	}
	_tmp3_ = _g_object_ref0 (_tmp0_);
	dlg = _tmp3_;
	adw_alert_dialog_add_response (dlg, "close", _ ("_Close"));
	_tmp4_ = self->priv->_parent;
	adw_alert_dialog_choose (dlg, _tmp4_, NULL, NULL, NULL);
	_g_object_unref0 (dlg);
	_g_object_unref0 (_tmp0_);
}

static void
___lambda9__operation_wrapper_button_action (gpointer self)
{
	__lambda9_ (self);
}

static void
operation_wrapper_handle_error (OperationWrapper* self,
                                const gchar* errstr,
                                const gchar* detail)
{
	Block7Data* _data7_;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	DejaDupOperation* _tmp4_;
	DejaDupToolJobMode _tmp5_;
	DejaDupToolJobMode _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (errstr != NULL);
	_data7_ = g_slice_new0 (Block7Data);
	_data7_->_ref_count_ = 1;
	_data7_->self = g_object_ref (self);
	_tmp0_ = g_strdup (errstr);
	_g_free0 (_data7_->errstr);
	_data7_->errstr = _tmp0_;
	_tmp1_ = g_strdup (detail);
	_g_free0 (_data7_->detail);
	_data7_->detail = _tmp1_;
	operation_wrapper_reset (self);
	operation_wrapper_set_progress_enabled (self, FALSE);
	operation_wrapper_activate_error_mode (self, OPERATION_WRAPPER_MODE_ERROR_PERSISTENT);
	_tmp4_ = self->priv->_operation;
	_tmp5_ = deja_dup_operation_get_mode (_tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp6_ == DEJA_DUP_TOOL_JOB_MODE_BACKUP) {
		_tmp3_ = TRUE;
	} else {
		DejaDupOperation* _tmp7_;
		DejaDupToolJobMode _tmp8_;
		DejaDupToolJobMode _tmp9_;
		_tmp7_ = self->priv->_operation;
		_tmp8_ = deja_dup_operation_get_mode (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp3_ = _tmp9_ == DEJA_DUP_TOOL_JOB_MODE_VERIFY_BASIC;
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		DejaDupOperation* _tmp10_;
		DejaDupToolJobMode _tmp11_;
		DejaDupToolJobMode _tmp12_;
		_tmp10_ = self->priv->_operation;
		_tmp11_ = deja_dup_operation_get_mode (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp2_ = _tmp12_ == DEJA_DUP_TOOL_JOB_MODE_VERIFY_CLEAN;
	}
	if (_tmp2_) {
		operation_wrapper_set_summary (self, _ ("Failed to back up"));
	} else {
		gboolean _tmp13_ = FALSE;
		DejaDupOperation* _tmp14_;
		DejaDupToolJobMode _tmp15_;
		DejaDupToolJobMode _tmp16_;
		_tmp14_ = self->priv->_operation;
		_tmp15_ = deja_dup_operation_get_mode (_tmp14_);
		_tmp16_ = _tmp15_;
		if (_tmp16_ == DEJA_DUP_TOOL_JOB_MODE_LIST_SNAPSHOTS) {
			_tmp13_ = TRUE;
		} else {
			DejaDupOperation* _tmp17_;
			DejaDupToolJobMode _tmp18_;
			DejaDupToolJobMode _tmp19_;
			_tmp17_ = self->priv->_operation;
			_tmp18_ = deja_dup_operation_get_mode (_tmp17_);
			_tmp19_ = _tmp18_;
			_tmp13_ = _tmp19_ == DEJA_DUP_TOOL_JOB_MODE_LIST_FILES;
		}
		if (_tmp13_) {
			operation_wrapper_set_summary (self, _ ("Failed to list files"));
		} else {
			operation_wrapper_set_summary (self, _ ("Failed to restore"));
		}
	}
	operation_wrapper_set_button_label (self, _ ("_Details"));
	(self->priv->button_action_target_destroy_notify == NULL) ? NULL : (self->priv->button_action_target_destroy_notify (self->priv->button_action_target), NULL);
	self->priv->button_action = NULL;
	self->priv->button_action_target = NULL;
	self->priv->button_action_target_destroy_notify = NULL;
	self->priv->button_action = ___lambda9__operation_wrapper_button_action;
	self->priv->button_action_target = block7_data_ref (_data7_);
	self->priv->button_action_target_destroy_notify = block7_data_unref;
	self->priv->button_is_dialog = TRUE;
	g_signal_emit (self, operation_wrapper_signals[OPERATION_WRAPPER_ATTENTION_NEEDED_SIGNAL], 0, FALSE);
	block7_data_unref (_data7_);
	_data7_ = NULL;
}

static void
_operation_wrapper_ask_passphrase_data_free (gpointer _data)
{
	OperationWrapperAskPassphraseData* _data_;
	_data_ = _data;
	_g_free0 (_data_->heading);
	_g_free0 (_data_->body);
	_g_object_unref0 (_data_->self);
	g_slice_free (OperationWrapperAskPassphraseData, _data_);
}

static void
_operation_wrapper_ask_passphrase (OperationWrapper* self,
                                   const gchar* heading,
                                   const gchar* body,
                                   gboolean first,
                                   gboolean nag,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_)
{
	OperationWrapperAskPassphraseData* _data_;
	OperationWrapper* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (heading != NULL);
	g_return_if_fail (body != NULL);
	_data_ = g_slice_new0 (OperationWrapperAskPassphraseData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, _operation_wrapper_ask_passphrase_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (heading);
	_g_free0 (_data_->heading);
	_data_->heading = _tmp1_;
	_tmp2_ = g_strdup (body);
	_g_free0 (_data_->body);
	_data_->body = _tmp2_;
	_data_->first = first;
	_data_->nag = nag;
	_operation_wrapper_ask_passphrase_co (_data_);
}

static void
_operation_wrapper_ask_passphrase_finish (OperationWrapper* self,
                                          GAsyncResult* _res_)
{
	OperationWrapperAskPassphraseData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
_operation_wrapper_ask_passphrase_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_)
{
	OperationWrapperAskPassphraseData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_operation_wrapper_ask_passphrase_co (_data_);
}

static gboolean
_operation_wrapper_ask_passphrase_co (OperationWrapperAskPassphraseData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = passphrase_dialog_new ();
	g_object_ref_sink (_data_->_tmp0_);
	_data_->dialog = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->dialog;
	adw_alert_dialog_set_heading ((AdwAlertDialog*) _data_->_tmp1_, _data_->heading);
	_data_->_tmp2_ = _data_->dialog;
	adw_alert_dialog_set_body ((AdwAlertDialog*) _data_->_tmp2_, _data_->body);
	_data_->_tmp3_ = _data_->dialog;
	passphrase_dialog_set_label (_data_->_tmp3_, _ ("E_ncryption password"));
	_data_->_tmp4_ = _data_->dialog;
	passphrase_dialog_set_first_time (_data_->_tmp4_, _data_->first);
	_data_->_tmp5_ = _data_->dialog;
	passphrase_dialog_set_nag_mode (_data_->_tmp5_, _data_->nag);
	_data_->_tmp6_ = _data_->dialog;
	_data_->_tmp7_ = _data_->self->priv->_parent;
	_data_->_state_ = 1;
	adw_alert_dialog_choose ((AdwAlertDialog*) _data_->_tmp6_, _data_->_tmp7_, NULL, _operation_wrapper_ask_passphrase_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp8_ = adw_alert_dialog_choose_finish ((AdwAlertDialog*) _data_->_tmp6_, _data_->_res_);
	_data_->_tmp9_ = g_strdup (_data_->_tmp8_);
	_data_->response = _data_->_tmp9_;
	_data_->_tmp10_ = _data_->response;
	if (g_strcmp0 (_data_->_tmp10_, "continue") != 0) {
		operation_wrapper_dialog_closed (_data_->self);
		_g_free0 (_data_->response);
		_g_object_unref0 (_data_->dialog);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp11_ = _data_->self->priv->_operation;
	_data_->_tmp12_ = _data_->dialog;
	_data_->_tmp13_ = passphrase_dialog_get_passphrase (_data_->_tmp12_);
	_data_->_tmp14_ = _data_->_tmp13_;
	_data_->_tmp15_ = _data_->dialog;
	_data_->_tmp16_ = passphrase_dialog_get_remember (_data_->_tmp15_);
	_data_->_tmp17_ = _data_->_tmp16_;
	_data_->_state_ = 2;
	deja_dup_operation_set_passphrase (_data_->_tmp11_, _data_->_tmp14_, _data_->_tmp17_, _operation_wrapper_ask_passphrase_ready, _data_);
	return FALSE;
	_state_2:
	deja_dup_operation_set_passphrase_finish (_data_->_tmp11_, _data_->_res_);
	_g_free0 (_data_->response);
	_g_object_unref0 (_data_->dialog);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static Block8Data*
block8_data_ref (Block8Data* _data8_)
{
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}

static void
block8_data_unref (void * _userdata_)
{
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		OperationWrapper* self;
		self = _data8_->self;
		_g_free0 (_data8_->body);
		_g_free0 (_data8_->header);
		_g_object_unref0 (self);
		g_slice_free (Block8Data, _data8_);
	}
}

static void
__lambda10_ (Block8Data* _data8_)
{
	OperationWrapper* self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	self = _data8_->self;
	_tmp0_ = _data8_->header;
	_tmp1_ = _data8_->body;
	_operation_wrapper_ask_passphrase (self, _tmp0_, _tmp1_, _data8_->first, _data8_->nag, NULL, NULL);
}

static void
___lambda10__operation_wrapper_button_action (gpointer self)
{
	__lambda10_ (self);
}

static void
operation_wrapper_handle_passphrase_required (OperationWrapper* self,
                                              gboolean repeat,
                                              gboolean first)
{
	Block8Data* _data8_;
	gchar* _tmp0_;
	gchar* _tmp1_;
	DejaDupOperation* _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	g_return_if_fail (self != NULL);
	_data8_ = g_slice_new0 (Block8Data);
	_data8_->_ref_count_ = 1;
	_data8_->self = g_object_ref (self);
	_data8_->first = first;
	operation_wrapper_reset (self);
	operation_wrapper_set_progress_enabled (self, FALSE);
	operation_wrapper_activate_error_mode (self, OPERATION_WRAPPER_MODE_ERROR_TEMPORARY);
	operation_wrapper_set_button_label (self, _ ("_Enter Password…"));
	_tmp0_ = g_strdup ("");
	_data8_->header = _tmp0_;
	_tmp1_ = g_strdup ("");
	_data8_->body = _tmp1_;
	if (repeat) {
		gchar* _tmp2_;
		gchar* _tmp3_;
		operation_wrapper_set_summary (self, _ ("Wrong encryption password, try again"));
		_tmp2_ = g_strdup (_ ("Wrong Encryption Password"));
		_g_free0 (_data8_->header);
		_data8_->header = _tmp2_;
		_tmp3_ = g_strdup (_ ("Try again."));
		_g_free0 (_data8_->body);
		_data8_->body = _tmp3_;
	} else {
		if (_data8_->first) {
			gchar* _tmp4_;
			gchar* _tmp5_;
			operation_wrapper_set_summary (self, _ ("Encryption setup needed"));
			operation_wrapper_set_button_label (self, _ ("_Details"));
			_tmp4_ = g_strdup (_ ("Require Password?"));
			_g_free0 (_data8_->header);
			_data8_->header = _tmp4_;
			_tmp5_ = g_strdup (_ ("You will need your password to restore your files. You might want to w" \
"rite it down."));
			_g_free0 (_data8_->body);
			_data8_->body = _tmp5_;
		} else {
			gchar* _tmp6_;
			operation_wrapper_set_summary (self, _ ("Encryption password needed"));
			_tmp6_ = g_strdup (_ ("Encryption Password Needed"));
			_g_free0 (_data8_->header);
			_data8_->header = _tmp6_;
		}
	}
	_tmp7_ = self->priv->_operation;
	_tmp8_ = deja_dup_operation_get_use_cached_password (_tmp7_);
	_tmp9_ = _tmp8_;
	_data8_->nag = !_tmp9_;
	if (_data8_->nag) {
		gchar* _tmp10_;
		_tmp10_ = g_strdup (_ ("In order to check that you will be able to retrieve your files in the " \
"case " "of an emergency, please enter your encryption password again to perfor" \
"m a " "brief restore test."));
		_g_free0 (_data8_->body);
		_data8_->body = _tmp10_;
	}
	(self->priv->button_action_target_destroy_notify == NULL) ? NULL : (self->priv->button_action_target_destroy_notify (self->priv->button_action_target), NULL);
	self->priv->button_action = NULL;
	self->priv->button_action_target = NULL;
	self->priv->button_action_target_destroy_notify = NULL;
	self->priv->button_action = ___lambda10__operation_wrapper_button_action;
	self->priv->button_action_target = block8_data_ref (_data8_);
	self->priv->button_action_target_destroy_notify = block8_data_unref;
	self->priv->button_is_dialog = TRUE;
	g_signal_emit (self, operation_wrapper_signals[OPERATION_WRAPPER_ATTENTION_NEEDED_SIGNAL], 0, TRUE);
	block8_data_unref (_data8_);
	_data8_ = NULL;
}

static void
_operation_wrapper_ask_backend_password_data_free (gpointer _data)
{
	OperationWrapperAskBackendPasswordData* _data_;
	_data_ = _data;
	_g_free0 (_data_->body);
	_g_free0 (_data_->label);
	_g_object_unref0 (_data_->self);
	g_slice_free (OperationWrapperAskBackendPasswordData, _data_);
}

static void
_operation_wrapper_ask_backend_password (OperationWrapper* self,
                                         const gchar* body,
                                         const gchar* label,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_)
{
	OperationWrapperAskBackendPasswordData* _data_;
	OperationWrapper* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (body != NULL);
	g_return_if_fail (label != NULL);
	_data_ = g_slice_new0 (OperationWrapperAskBackendPasswordData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, _operation_wrapper_ask_backend_password_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (body);
	_g_free0 (_data_->body);
	_data_->body = _tmp1_;
	_tmp2_ = g_strdup (label);
	_g_free0 (_data_->label);
	_data_->label = _tmp2_;
	_operation_wrapper_ask_backend_password_co (_data_);
}

static void
_operation_wrapper_ask_backend_password_finish (OperationWrapper* self,
                                                GAsyncResult* _res_)
{
	OperationWrapperAskBackendPasswordData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
_operation_wrapper_ask_backend_password_ready (GObject* source_object,
                                               GAsyncResult* _res_,
                                               gpointer _user_data_)
{
	OperationWrapperAskBackendPasswordData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_operation_wrapper_ask_backend_password_co (_data_);
}

static gboolean
_operation_wrapper_ask_backend_password_co (OperationWrapperAskBackendPasswordData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = passphrase_dialog_new ();
	g_object_ref_sink (_data_->_tmp0_);
	_data_->dialog = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->dialog;
	adw_alert_dialog_set_heading ((AdwAlertDialog*) _data_->_tmp1_, _ ("Enter Password"));
	_data_->_tmp2_ = _data_->dialog;
	adw_alert_dialog_set_body ((AdwAlertDialog*) _data_->_tmp2_, _data_->body);
	_data_->_tmp3_ = _data_->dialog;
	passphrase_dialog_set_label (_data_->_tmp3_, _data_->label);
	_data_->_tmp4_ = _data_->dialog;
	_data_->_tmp5_ = _data_->self->priv->_parent;
	_data_->_state_ = 1;
	adw_alert_dialog_choose ((AdwAlertDialog*) _data_->_tmp4_, _data_->_tmp5_, NULL, _operation_wrapper_ask_backend_password_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp6_ = adw_alert_dialog_choose_finish ((AdwAlertDialog*) _data_->_tmp4_, _data_->_res_);
	_data_->_tmp7_ = g_strdup (_data_->_tmp6_);
	_data_->response = _data_->_tmp7_;
	_data_->_tmp9_ = _data_->response;
	if (g_strcmp0 (_data_->_tmp9_, "continue") != 0) {
		_data_->_tmp8_ = TRUE;
	} else {
		_data_->_tmp10_ = _data_->dialog;
		_data_->_tmp11_ = passphrase_dialog_get_passphrase (_data_->_tmp10_);
		_data_->_tmp12_ = _data_->_tmp11_;
		_data_->_tmp8_ = g_strcmp0 (_data_->_tmp12_, "") == 0;
	}
	if (_data_->_tmp8_) {
		operation_wrapper_dialog_closed (_data_->self);
		_g_free0 (_data_->response);
		_g_object_unref0 (_data_->dialog);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp13_ = _data_->self->priv->_operation;
	_data_->_tmp14_ = _data_->dialog;
	_data_->_tmp15_ = passphrase_dialog_get_passphrase (_data_->_tmp14_);
	_data_->_tmp16_ = _data_->_tmp15_;
	_data_->_tmp17_ = _data_->dialog;
	_data_->_tmp18_ = passphrase_dialog_get_remember (_data_->_tmp17_);
	_data_->_tmp19_ = _data_->_tmp18_;
	_data_->_state_ = 2;
	deja_dup_operation_set_backend_password (_data_->_tmp13_, _data_->_tmp16_, _data_->_tmp19_, _operation_wrapper_ask_backend_password_ready, _data_);
	return FALSE;
	_state_2:
	deja_dup_operation_set_backend_password_finish (_data_->_tmp13_, _data_->_res_);
	_g_free0 (_data_->response);
	_g_object_unref0 (_data_->dialog);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static Block9Data*
block9_data_ref (Block9Data* _data9_)
{
	g_atomic_int_inc (&_data9_->_ref_count_);
	return _data9_;
}

static void
block9_data_unref (void * _userdata_)
{
	Block9Data* _data9_;
	_data9_ = (Block9Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
		OperationWrapper* self;
		self = _data9_->self;
		_g_free0 (_data9_->label);
		_g_object_unref0 (self);
		g_slice_free (Block9Data, _data9_);
	}
}

static void
__lambda11_ (Block9Data* _data9_)
{
	OperationWrapper* self;
	const gchar* _tmp0_;
	self = _data9_->self;
	_tmp0_ = self->priv->_summary;
	_operation_wrapper_ask_backend_password (self, _tmp0_, _data9_->label, NULL, NULL);
}

static void
___lambda11__operation_wrapper_button_action (gpointer self)
{
	__lambda11_ (self);
}

static void
operation_wrapper_handle_backend_password_required (OperationWrapper* self,
                                                    const gchar* desc,
                                                    const gchar* label,
                                                    const gchar* _error_)
{
	Block9Data* _data9_;
	gchar* _tmp0_;
	const gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (desc != NULL);
	g_return_if_fail (label != NULL);
	_data9_ = g_slice_new0 (Block9Data);
	_data9_->_ref_count_ = 1;
	_data9_->self = g_object_ref (self);
	_tmp0_ = g_strdup (label);
	_g_free0 (_data9_->label);
	_data9_->label = _tmp0_;
	operation_wrapper_reset (self);
	operation_wrapper_set_progress_enabled (self, FALSE);
	operation_wrapper_activate_error_mode (self, OPERATION_WRAPPER_MODE_ERROR_TEMPORARY);
	if (_error_ == NULL) {
		_tmp1_ = desc;
	} else {
		_tmp1_ = _error_;
	}
	operation_wrapper_set_summary (self, _tmp1_);
	operation_wrapper_set_button_label (self, _ ("_Enter Password…"));
	operation_wrapper_set_button_suggested (self, TRUE);
	(self->priv->button_action_target_destroy_notify == NULL) ? NULL : (self->priv->button_action_target_destroy_notify (self->priv->button_action_target), NULL);
	self->priv->button_action = NULL;
	self->priv->button_action_target = NULL;
	self->priv->button_action_target_destroy_notify = NULL;
	self->priv->button_action = ___lambda11__operation_wrapper_button_action;
	self->priv->button_action_target = block9_data_ref (_data9_);
	self->priv->button_action_target_destroy_notify = block9_data_unref;
	self->priv->button_is_dialog = TRUE;
	g_signal_emit (self, operation_wrapper_signals[OPERATION_WRAPPER_ATTENTION_NEEDED_SIGNAL], 0, TRUE);
	block9_data_unref (_data9_);
	_data9_ = NULL;
}

static void
__lambda15_ (OperationWrapper* self)
{
	GtkMountOperation* mount_op = NULL;
	GtkWidget* _tmp0_;
	GtkRoot* _tmp1_;
	GtkRoot* _tmp2_;
	GtkMountOperation* _tmp3_;
	DejaDupOperation* _tmp4_;
	_tmp0_ = self->priv->_parent;
	_tmp1_ = gtk_widget_get_root (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = (GtkMountOperation*) gtk_mount_operation_new (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gtk_window_get_type ()) ? ((GtkWindow*) _tmp2_) : NULL);
	mount_op = _tmp3_;
	_tmp4_ = self->priv->_operation;
	deja_dup_operation_set_mount_op (_tmp4_, (GMountOperation*) mount_op);
	_g_object_unref0 (mount_op);
}

static void
___lambda15__operation_wrapper_button_action (gpointer self)
{
	__lambda15_ ((OperationWrapper*) self);
}

static void
operation_wrapper_handle_mount_op_required (OperationWrapper* self)
{
	g_return_if_fail (self != NULL);
	operation_wrapper_reset (self);
	operation_wrapper_set_progress_enabled (self, FALSE);
	operation_wrapper_activate_error_mode (self, OPERATION_WRAPPER_MODE_ERROR_TEMPORARY);
	operation_wrapper_set_summary (self, _ ("Authentication needed"));
	operation_wrapper_set_button_label (self, _ ("_Connect…"));
	operation_wrapper_set_button_suggested (self, TRUE);
	(self->priv->button_action_target_destroy_notify == NULL) ? NULL : (self->priv->button_action_target_destroy_notify (self->priv->button_action_target), NULL);
	self->priv->button_action = NULL;
	self->priv->button_action_target = NULL;
	self->priv->button_action_target_destroy_notify = NULL;
	self->priv->button_action = ___lambda15__operation_wrapper_button_action;
	self->priv->button_action_target = g_object_ref (self);
	self->priv->button_action_target_destroy_notify = g_object_unref;
	g_signal_emit (self, operation_wrapper_signals[OPERATION_WRAPPER_ATTENTION_NEEDED_SIGNAL], 0, FALSE);
}

static Block10Data*
block10_data_ref (Block10Data* _data10_)
{
	g_atomic_int_inc (&_data10_->_ref_count_);
	return _data10_;
}

static void
block10_data_unref (void * _userdata_)
{
	Block10Data* _data10_;
	_data10_ = (Block10Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data10_->_ref_count_)) {
		OperationWrapper* self;
		self = _data10_->self;
		_g_free0 (_data10_->header);
		_g_free0 (_data10_->description);
		_g_free0 (_data10_->action);
		_g_object_unref0 (self);
		g_slice_free (Block10Data, _data10_);
	}
}

static void
__lambda13_ (OperationWrapper* self)
{
	operation_wrapper_dialog_closed (self);
}

static void
___lambda13__adw_alert_dialog_response (AdwAlertDialog* _sender,
                                        const gchar* response,
                                        gpointer self)
{
	__lambda13_ ((OperationWrapper*) self);
}

static void
__lambda14_ (OperationWrapper* self)
{
	DejaDupOperation* _tmp0_;
	_tmp0_ = self->priv->_operation;
	deja_dup_operation_resume (_tmp0_);
}

static void
___lambda14__adw_alert_dialog_response (AdwAlertDialog* _sender,
                                        const gchar* response,
                                        gpointer self)
{
	__lambda14_ ((OperationWrapper*) self);
}

static void
__lambda12_ (Block10Data* _data10_)
{
	OperationWrapper* self;
	AdwAlertDialog* dlg = NULL;
	AdwAlertDialog* _tmp0_;
	AdwAlertDialog* _tmp1_;
	AdwAlertDialog* _tmp2_;
	const gchar* _tmp3_ = NULL;
	AdwAlertDialog* _tmp4_;
	AdwAlertDialog* _tmp7_;
	AdwAlertDialog* _tmp8_;
	AdwAlertDialog* _tmp9_;
	GtkWidget* _tmp10_;
	self = _data10_->self;
	_tmp0_ = (AdwAlertDialog*) adw_alert_dialog_new (_data10_->header, _data10_->description);
	g_object_ref_sink (_tmp0_);
	dlg = _tmp0_;
	_tmp1_ = dlg;
	adw_alert_dialog_set_body_use_markup (_tmp1_, TRUE);
	_tmp2_ = dlg;
	adw_alert_dialog_add_response (_tmp2_, "close", _ ("_Cancel"));
	if (_data10_->action == NULL) {
		_tmp3_ = _ ("Co_ntinue");
	} else {
		_tmp3_ = _data10_->action;
	}
	_tmp4_ = dlg;
	adw_alert_dialog_add_response (_tmp4_, "continue", _tmp3_);
	if (_data10_->safe) {
		AdwAlertDialog* _tmp5_;
		AdwAlertDialog* _tmp6_;
		_tmp5_ = dlg;
		adw_alert_dialog_set_default_response (_tmp5_, "continue");
		_tmp6_ = dlg;
		adw_alert_dialog_set_response_appearance (_tmp6_, "continue", ADW_RESPONSE_SUGGESTED);
	}
	_tmp7_ = dlg;
	g_signal_connect_object (_tmp7_, "response::close", (GCallback) ___lambda13__adw_alert_dialog_response, self, 0);
	_tmp8_ = dlg;
	g_signal_connect_object (_tmp8_, "response::continue", (GCallback) ___lambda14__adw_alert_dialog_response, self, 0);
	_tmp9_ = dlg;
	_tmp10_ = self->priv->_parent;
	adw_alert_dialog_choose (_tmp9_, _tmp10_, NULL, NULL, NULL);
	_g_object_unref0 (dlg);
}

static void
___lambda12__operation_wrapper_button_action (gpointer self)
{
	__lambda12_ (self);
}

static void
operation_wrapper_handle_question (OperationWrapper* self,
                                   const gchar* summary,
                                   const gchar* header,
                                   const gchar* description,
                                   const gchar* action,
                                   gboolean safe)
{
	Block10Data* _data10_;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (summary != NULL);
	_data10_ = g_slice_new0 (Block10Data);
	_data10_->_ref_count_ = 1;
	_data10_->self = g_object_ref (self);
	_tmp0_ = g_strdup (header);
	_g_free0 (_data10_->header);
	_data10_->header = _tmp0_;
	_tmp1_ = g_strdup (description);
	_g_free0 (_data10_->description);
	_data10_->description = _tmp1_;
	_tmp2_ = g_strdup (action);
	_g_free0 (_data10_->action);
	_data10_->action = _tmp2_;
	_data10_->safe = safe;
	operation_wrapper_reset (self);
	operation_wrapper_set_progress_enabled (self, FALSE);
	operation_wrapper_activate_error_mode (self, OPERATION_WRAPPER_MODE_ERROR_TEMPORARY);
	operation_wrapper_set_summary (self, summary);
	operation_wrapper_set_button_label (self, _ ("_Details"));
	(self->priv->button_action_target_destroy_notify == NULL) ? NULL : (self->priv->button_action_target_destroy_notify (self->priv->button_action_target), NULL);
	self->priv->button_action = NULL;
	self->priv->button_action_target = NULL;
	self->priv->button_action_target_destroy_notify = NULL;
	self->priv->button_action = ___lambda12__operation_wrapper_button_action;
	self->priv->button_action_target = block10_data_ref (_data10_);
	self->priv->button_action_target_destroy_notify = block10_data_unref;
	self->priv->button_is_dialog = TRUE;
	g_signal_emit (self, operation_wrapper_signals[OPERATION_WRAPPER_ATTENTION_NEEDED_SIGNAL], 0, TRUE);
	block10_data_unref (_data10_);
	_data10_ = NULL;
}

DejaDupOperation*
operation_wrapper_get_operation (OperationWrapper* self)
{
	DejaDupOperation* result;
	DejaDupOperation* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_operation;
	result = _tmp0_;
	return result;
}

void
operation_wrapper_set_operation (OperationWrapper* self,
                                 DejaDupOperation* value)
{
	DejaDupOperation* old_value;
	g_return_if_fail (self != NULL);
	old_value = operation_wrapper_get_operation (self);
	if (old_value != value) {
		DejaDupOperation* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_operation);
		self->priv->_operation = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, operation_wrapper_properties[OPERATION_WRAPPER_OPERATION_PROPERTY]);
	}
}

GtkWidget*
operation_wrapper_get_parent (OperationWrapper* self)
{
	GtkWidget* result;
	GtkWidget* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_parent;
	result = _tmp0_;
	return result;
}

static void
operation_wrapper_set_parent (OperationWrapper* self,
                              GtkWidget* value)
{
	GtkWidget* old_value;
	g_return_if_fail (self != NULL);
	old_value = operation_wrapper_get_parent (self);
	if (old_value != value) {
		GtkWidget* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_parent);
		self->priv->_parent = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, operation_wrapper_properties[OPERATION_WRAPPER_PARENT_PROPERTY]);
	}
}

gboolean
operation_wrapper_get_cancel_stops (OperationWrapper* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_cancel_stops;
	return result;
}

void
operation_wrapper_set_cancel_stops (OperationWrapper* self,
                                    gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = operation_wrapper_get_cancel_stops (self);
	if (old_value != value) {
		self->priv->_cancel_stops = value;
		g_object_notify_by_pspec ((GObject *) self, operation_wrapper_properties[OPERATION_WRAPPER_CANCEL_STOPS_PROPERTY]);
	}
}

gboolean
operation_wrapper_get_active (OperationWrapper* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_active;
	return result;
}

static void
operation_wrapper_set_active (OperationWrapper* self,
                              gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = operation_wrapper_get_active (self);
	if (old_value != value) {
		self->priv->_active = value;
		g_object_notify_by_pspec ((GObject *) self, operation_wrapper_properties[OPERATION_WRAPPER_ACTIVE_PROPERTY]);
	}
}

const gchar*
operation_wrapper_get_summary (OperationWrapper* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_summary;
	result = _tmp0_;
	return result;
}

static void
operation_wrapper_set_summary (OperationWrapper* self,
                               const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = operation_wrapper_get_summary (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_summary);
		self->priv->_summary = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, operation_wrapper_properties[OPERATION_WRAPPER_SUMMARY_PROPERTY]);
	}
}

const gchar*
operation_wrapper_get_button_label (OperationWrapper* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_button_label;
	result = _tmp0_;
	return result;
}

static void
operation_wrapper_set_button_label (OperationWrapper* self,
                                    const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = operation_wrapper_get_button_label (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_button_label);
		self->priv->_button_label = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, operation_wrapper_properties[OPERATION_WRAPPER_BUTTON_LABEL_PROPERTY]);
	}
}

gboolean
operation_wrapper_get_button_suggested (OperationWrapper* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_button_suggested;
	return result;
}

static void
operation_wrapper_set_button_suggested (OperationWrapper* self,
                                        gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = operation_wrapper_get_button_suggested (self);
	if (old_value != value) {
		self->priv->_button_suggested = value;
		g_object_notify_by_pspec ((GObject *) self, operation_wrapper_properties[OPERATION_WRAPPER_BUTTON_SUGGESTED_PROPERTY]);
	}
}

gboolean
operation_wrapper_get_error_mode (OperationWrapper* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_error_mode;
	return result;
}

static void
operation_wrapper_set_error_mode (OperationWrapper* self,
                                  gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = operation_wrapper_get_error_mode (self);
	if (old_value != value) {
		self->priv->_error_mode = value;
		g_object_notify_by_pspec ((GObject *) self, operation_wrapper_properties[OPERATION_WRAPPER_ERROR_MODE_PROPERTY]);
	}
}

gdouble
operation_wrapper_get_fraction (OperationWrapper* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_fraction;
	return result;
}

static void
operation_wrapper_set_fraction (OperationWrapper* self,
                                gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = operation_wrapper_get_fraction (self);
	if (old_value != value) {
		self->priv->_fraction = value;
		g_object_notify_by_pspec ((GObject *) self, operation_wrapper_properties[OPERATION_WRAPPER_FRACTION_PROPERTY]);
	}
}

gboolean
operation_wrapper_get_pulsing (OperationWrapper* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->pulse_id != ((guint) 0);
	return result;
}

static void
operation_wrapper_class_init (OperationWrapperClass * klass,
                              gpointer klass_data)
{
	operation_wrapper_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &OperationWrapper_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_operation_wrapper_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_operation_wrapper_set_property;
	G_OBJECT_CLASS (klass)->finalize = operation_wrapper_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), OPERATION_WRAPPER_OPERATION_PROPERTY, operation_wrapper_properties[OPERATION_WRAPPER_OPERATION_PROPERTY] = g_param_spec_object ("operation", "operation", "operation", DEJA_DUP_TYPE_OPERATION, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), OPERATION_WRAPPER_PARENT_PROPERTY, operation_wrapper_properties[OPERATION_WRAPPER_PARENT_PROPERTY] = g_param_spec_object ("parent", "parent", "parent", gtk_widget_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), OPERATION_WRAPPER_CANCEL_STOPS_PROPERTY, operation_wrapper_properties[OPERATION_WRAPPER_CANCEL_STOPS_PROPERTY] = g_param_spec_boolean ("cancel-stops", "cancel-stops", "cancel-stops", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), OPERATION_WRAPPER_ACTIVE_PROPERTY, operation_wrapper_properties[OPERATION_WRAPPER_ACTIVE_PROPERTY] = g_param_spec_boolean ("active", "active", "active", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), OPERATION_WRAPPER_SUMMARY_PROPERTY, operation_wrapper_properties[OPERATION_WRAPPER_SUMMARY_PROPERTY] = g_param_spec_string ("summary", "summary", "summary", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), OPERATION_WRAPPER_BUTTON_LABEL_PROPERTY, operation_wrapper_properties[OPERATION_WRAPPER_BUTTON_LABEL_PROPERTY] = g_param_spec_string ("button-label", "button-label", "button-label", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), OPERATION_WRAPPER_BUTTON_SUGGESTED_PROPERTY, operation_wrapper_properties[OPERATION_WRAPPER_BUTTON_SUGGESTED_PROPERTY] = g_param_spec_boolean ("button-suggested", "button-suggested", "button-suggested", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), OPERATION_WRAPPER_ERROR_MODE_PROPERTY, operation_wrapper_properties[OPERATION_WRAPPER_ERROR_MODE_PROPERTY] = g_param_spec_boolean ("error-mode", "error-mode", "error-mode", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), OPERATION_WRAPPER_FRACTION_PROPERTY, operation_wrapper_properties[OPERATION_WRAPPER_FRACTION_PROPERTY] = g_param_spec_double ("fraction", "fraction", "fraction", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), OPERATION_WRAPPER_PULSING_PROPERTY, operation_wrapper_properties[OPERATION_WRAPPER_PULSING_PROPERTY] = g_param_spec_boolean ("pulsing", "pulsing", "pulsing", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	operation_wrapper_signals[OPERATION_WRAPPER_PULSE_SIGNAL] = g_signal_new ("pulse", TYPE_OPERATION_WRAPPER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	operation_wrapper_signals[OPERATION_WRAPPER_ATTENTION_NEEDED_SIGNAL] = g_signal_new ("attention-needed", TYPE_OPERATION_WRAPPER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
	operation_wrapper_signals[OPERATION_WRAPPER_PAUSE_CHANGED_SIGNAL] = g_signal_new ("pause-changed", TYPE_OPERATION_WRAPPER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
	operation_wrapper_signals[OPERATION_WRAPPER_SUCCEEDED_SIGNAL] = g_signal_new ("succeeded", TYPE_OPERATION_WRAPPER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
	operation_wrapper_signals[OPERATION_WRAPPER_DONE_SIGNAL] = g_signal_new ("done", TYPE_OPERATION_WRAPPER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
}

static void
operation_wrapper_instance_init (OperationWrapper * self,
                                 gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	self->priv = operation_wrapper_get_instance_private (self);
	_tmp0_ = g_strdup ("");
	self->priv->_summary = _tmp0_;
	_tmp1_ = g_strdup ("");
	self->priv->_button_label = _tmp1_;
	self->priv->mode = OPERATION_WRAPPER_MODE_PROGRESS;
	self->priv->progress_enabled = FALSE;
}

static void
operation_wrapper_finalize (GObject * obj)
{
	OperationWrapper * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_OPERATION_WRAPPER, OperationWrapper);
	_g_object_unref0 (self->priv->_operation);
	_g_object_unref0 (self->priv->_parent);
	_g_free0 (self->priv->_summary);
	_g_free0 (self->priv->_button_label);
	(self->priv->button_action_target_destroy_notify == NULL) ? NULL : (self->priv->button_action_target_destroy_notify (self->priv->button_action_target), NULL);
	self->priv->button_action = NULL;
	self->priv->button_action_target = NULL;
	self->priv->button_action_target_destroy_notify = NULL;
	G_OBJECT_CLASS (operation_wrapper_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
operation_wrapper_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (OperationWrapperClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) operation_wrapper_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (OperationWrapper), 0, (GInstanceInitFunc) operation_wrapper_instance_init, NULL };
	GType operation_wrapper_type_id;
	operation_wrapper_type_id = g_type_register_static (G_TYPE_OBJECT, "OperationWrapper", &g_define_type_info, 0);
	OperationWrapper_private_offset = g_type_add_instance_private (operation_wrapper_type_id, sizeof (OperationWrapperPrivate));
	return operation_wrapper_type_id;
}

GType
operation_wrapper_get_type (void)
{
	static gsize operation_wrapper_type_id__once = 0;
	if (g_once_init_enter (&operation_wrapper_type_id__once)) {
		GType operation_wrapper_type_id;
		operation_wrapper_type_id = operation_wrapper_get_type_once ();
		g_once_init_leave (&operation_wrapper_type_id__once, operation_wrapper_type_id);
	}
	return operation_wrapper_type_id__once;
}

static void
_vala_operation_wrapper_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec)
{
	OperationWrapper * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_OPERATION_WRAPPER, OperationWrapper);
	switch (property_id) {
		case OPERATION_WRAPPER_OPERATION_PROPERTY:
		g_value_set_object (value, operation_wrapper_get_operation (self));
		break;
		case OPERATION_WRAPPER_PARENT_PROPERTY:
		g_value_set_object (value, operation_wrapper_get_parent (self));
		break;
		case OPERATION_WRAPPER_CANCEL_STOPS_PROPERTY:
		g_value_set_boolean (value, operation_wrapper_get_cancel_stops (self));
		break;
		case OPERATION_WRAPPER_ACTIVE_PROPERTY:
		g_value_set_boolean (value, operation_wrapper_get_active (self));
		break;
		case OPERATION_WRAPPER_SUMMARY_PROPERTY:
		g_value_set_string (value, operation_wrapper_get_summary (self));
		break;
		case OPERATION_WRAPPER_BUTTON_LABEL_PROPERTY:
		g_value_set_string (value, operation_wrapper_get_button_label (self));
		break;
		case OPERATION_WRAPPER_BUTTON_SUGGESTED_PROPERTY:
		g_value_set_boolean (value, operation_wrapper_get_button_suggested (self));
		break;
		case OPERATION_WRAPPER_ERROR_MODE_PROPERTY:
		g_value_set_boolean (value, operation_wrapper_get_error_mode (self));
		break;
		case OPERATION_WRAPPER_FRACTION_PROPERTY:
		g_value_set_double (value, operation_wrapper_get_fraction (self));
		break;
		case OPERATION_WRAPPER_PULSING_PROPERTY:
		g_value_set_boolean (value, operation_wrapper_get_pulsing (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_operation_wrapper_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec)
{
	OperationWrapper * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_OPERATION_WRAPPER, OperationWrapper);
	switch (property_id) {
		case OPERATION_WRAPPER_OPERATION_PROPERTY:
		operation_wrapper_set_operation (self, g_value_get_object (value));
		break;
		case OPERATION_WRAPPER_PARENT_PROPERTY:
		operation_wrapper_set_parent (self, g_value_get_object (value));
		break;
		case OPERATION_WRAPPER_CANCEL_STOPS_PROPERTY:
		operation_wrapper_set_cancel_stops (self, g_value_get_boolean (value));
		break;
		case OPERATION_WRAPPER_ACTIVE_PROPERTY:
		operation_wrapper_set_active (self, g_value_get_boolean (value));
		break;
		case OPERATION_WRAPPER_SUMMARY_PROPERTY:
		operation_wrapper_set_summary (self, g_value_get_string (value));
		break;
		case OPERATION_WRAPPER_BUTTON_LABEL_PROPERTY:
		operation_wrapper_set_button_label (self, g_value_get_string (value));
		break;
		case OPERATION_WRAPPER_BUTTON_SUGGESTED_PROPERTY:
		operation_wrapper_set_button_suggested (self, g_value_get_boolean (value));
		break;
		case OPERATION_WRAPPER_ERROR_MODE_PROPERTY:
		operation_wrapper_set_error_mode (self, g_value_get_boolean (value));
		break;
		case OPERATION_WRAPPER_FRACTION_PROPERTY:
		operation_wrapper_set_fraction (self, g_value_get_double (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

