/*
 * This file was generated by qdbusxml2cpp-fix version 0.8
 * Command line was: qdbusxml2cpp-fix -c Launcherd -p generated/com_deepin_dde_daemon_launcherd ../xml/com.deepin.dde.daemon.Launcherd.xml
 *
 * qdbusxml2cpp-fix is Copyright (C) 2016 Deepin Technology Co., Ltd.
 *
 * This is an auto-generated file.
 * This file may have been hand-edited. Look for HAND-EDIT comments
 * before re-generating it.
 */

#include "generated/com_deepin_dde_daemon_launcherd.h"

/*
 * Implementation of interface class __Launcherd
 */

class __LauncherdPrivate
{
public:
   __LauncherdPrivate() = default;

    // begin member variables
    int DisplayMode;
    bool Fullscreen;

public:
    QMap<QString, QDBusPendingCallWatcher *> m_processingCalls;
    QMap<QString, QList<QVariant>> m_waittingCalls;
};

__Launcherd::__Launcherd(const QString &service, const QString &path, const QDBusConnection &connection, QObject *parent)
    : DBusExtendedAbstractInterface(service, path, staticInterfaceName(), connection, parent)
    , d_ptr(new __LauncherdPrivate)
{
    connect(this, &__Launcherd::propertyChanged, this, &__Launcherd::onPropertyChanged);

    if (QMetaType::type("LauncherItemInfo") == QMetaType::UnknownType)
        registerLauncherItemInfoMetaType();
    if (QMetaType::type("LauncherItemInfoList") == QMetaType::UnknownType)
        registerLauncherItemInfoListMetaType();
}

__Launcherd::~__Launcherd()
{
    qDeleteAll(d_ptr->m_processingCalls.values());
    delete d_ptr;
}

void __Launcherd::onPropertyChanged(const QString &propName, const QVariant &value)
{
    if (propName == QStringLiteral("DisplayMode"))
    {
        const int &DisplayMode = qvariant_cast<int>(value);
        if (d_ptr->DisplayMode != DisplayMode)
        {
            d_ptr->DisplayMode = DisplayMode;
            Q_EMIT DisplayModeChanged(d_ptr->DisplayMode);
        }
        return;
    }

    if (propName == QStringLiteral("Fullscreen"))
    {
        const bool &Fullscreen = qvariant_cast<bool>(value);
        if (d_ptr->Fullscreen != Fullscreen)
        {
            d_ptr->Fullscreen = Fullscreen;
            Q_EMIT FullscreenChanged(d_ptr->Fullscreen);
        }
        return;
    }

    qWarning() << "property not handle: " << propName;
    return;
}

int __Launcherd::displayMode()
{
    return qvariant_cast<int>(internalPropGet("DisplayMode", &d_ptr->DisplayMode));
}

void __Launcherd::setDisplayMode(int value)
{

   internalPropSet("DisplayMode", QVariant::fromValue(value), &d_ptr->DisplayMode);
}

bool __Launcherd::fullscreen()
{
    return qvariant_cast<bool>(internalPropGet("Fullscreen", &d_ptr->Fullscreen));
}

void __Launcherd::setFullscreen(bool value)
{

   internalPropSet("Fullscreen", QVariant::fromValue(value), &d_ptr->Fullscreen);
}

void __Launcherd::CallQueued(const QString &callName, const QList<QVariant> &args)
{
    if (d_ptr->m_waittingCalls.contains(callName))
    {
        d_ptr->m_waittingCalls[callName] = args;
        return;
    }
    if (d_ptr->m_processingCalls.contains(callName))
    {
        d_ptr->m_waittingCalls.insert(callName, args);
    } else {
        QDBusPendingCallWatcher *watcher = new QDBusPendingCallWatcher(asyncCallWithArgumentList(callName, args));
        connect(watcher, &QDBusPendingCallWatcher::finished, this, &__Launcherd::onPendingCallFinished);
        d_ptr->m_processingCalls.insert(callName, watcher);
    }
}

void __Launcherd::onPendingCallFinished(QDBusPendingCallWatcher *w)
{
    w->deleteLater();
    const auto callName = d_ptr->m_processingCalls.key(w);
    Q_ASSERT(!callName.isEmpty());
    if (callName.isEmpty())
        return;
    d_ptr->m_processingCalls.remove(callName);
    if (!d_ptr->m_waittingCalls.contains(callName))
        return;
    const auto args = d_ptr->m_waittingCalls.take(callName);
    CallQueued(callName, args);
}
