/*
Copyright The cert-manager Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

import (
	certmanagerv1 "github.com/cert-manager/cert-manager/pkg/apis/certmanager/v1"
	applyconfigurationsmetav1 "github.com/cert-manager/cert-manager/pkg/client/applyconfigurations/meta/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
)

// CertificateRequestSpecApplyConfiguration represents a declarative configuration of the CertificateRequestSpec type for use
// with apply.
type CertificateRequestSpecApplyConfiguration struct {
	Duration  *metav1.Duration                                             `json:"duration,omitempty"`
	IssuerRef *applyconfigurationsmetav1.IssuerReferenceApplyConfiguration `json:"issuerRef,omitempty"`
	Request   []byte                                                       `json:"request,omitempty"`
	IsCA      *bool                                                        `json:"isCA,omitempty"`
	Usages    []certmanagerv1.KeyUsage                                     `json:"usages,omitempty"`
	Username  *string                                                      `json:"username,omitempty"`
	UID       *string                                                      `json:"uid,omitempty"`
	Groups    []string                                                     `json:"groups,omitempty"`
	Extra     map[string][]string                                          `json:"extra,omitempty"`
}

// CertificateRequestSpecApplyConfiguration constructs a declarative configuration of the CertificateRequestSpec type for use with
// apply.
func CertificateRequestSpec() *CertificateRequestSpecApplyConfiguration {
	return &CertificateRequestSpecApplyConfiguration{}
}

// WithDuration sets the Duration field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Duration field is set to the value of the last call.
func (b *CertificateRequestSpecApplyConfiguration) WithDuration(value metav1.Duration) *CertificateRequestSpecApplyConfiguration {
	b.Duration = &value
	return b
}

// WithIssuerRef sets the IssuerRef field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the IssuerRef field is set to the value of the last call.
func (b *CertificateRequestSpecApplyConfiguration) WithIssuerRef(value *applyconfigurationsmetav1.IssuerReferenceApplyConfiguration) *CertificateRequestSpecApplyConfiguration {
	b.IssuerRef = value
	return b
}

// WithRequest adds the given value to the Request field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Request field.
func (b *CertificateRequestSpecApplyConfiguration) WithRequest(values ...byte) *CertificateRequestSpecApplyConfiguration {
	for i := range values {
		b.Request = append(b.Request, values[i])
	}
	return b
}

// WithIsCA sets the IsCA field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the IsCA field is set to the value of the last call.
func (b *CertificateRequestSpecApplyConfiguration) WithIsCA(value bool) *CertificateRequestSpecApplyConfiguration {
	b.IsCA = &value
	return b
}

// WithUsages adds the given value to the Usages field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Usages field.
func (b *CertificateRequestSpecApplyConfiguration) WithUsages(values ...certmanagerv1.KeyUsage) *CertificateRequestSpecApplyConfiguration {
	for i := range values {
		b.Usages = append(b.Usages, values[i])
	}
	return b
}

// WithUsername sets the Username field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Username field is set to the value of the last call.
func (b *CertificateRequestSpecApplyConfiguration) WithUsername(value string) *CertificateRequestSpecApplyConfiguration {
	b.Username = &value
	return b
}

// WithUID sets the UID field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the UID field is set to the value of the last call.
func (b *CertificateRequestSpecApplyConfiguration) WithUID(value string) *CertificateRequestSpecApplyConfiguration {
	b.UID = &value
	return b
}

// WithGroups adds the given value to the Groups field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Groups field.
func (b *CertificateRequestSpecApplyConfiguration) WithGroups(values ...string) *CertificateRequestSpecApplyConfiguration {
	for i := range values {
		b.Groups = append(b.Groups, values[i])
	}
	return b
}

// WithExtra puts the entries into the Extra field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, the entries provided by each call will be put on the Extra field,
// overwriting an existing map entries in Extra field with the same key.
func (b *CertificateRequestSpecApplyConfiguration) WithExtra(entries map[string][]string) *CertificateRequestSpecApplyConfiguration {
	if b.Extra == nil && len(entries) > 0 {
		b.Extra = make(map[string][]string, len(entries))
	}
	for k, v := range entries {
		b.Extra[k] = v
	}
	return b
}
