#line 1 "/build/clisp/src/clisp/modules/syscalls/calls.c"
/*
 * system calls
 * Copyright (C) 2003-2012,2016-2017 Sam Steingold
 * Copyright (C) 2005,2008,2017-2024 Bruno Haible
 * Copyright (C) 2005,2010 Arseny Slobodyuk
 * This is Free Software, distributed under the GNU GPL v2+
 */

#if defined(_WIN32)
/* need this for CreateHardLink to work */
# define WINVER 0x0500
#endif
#if defined(__CYGWIN__)
# define UNIX_CYGWIN
#endif

/* clisp.h includes system headers among other stuff
   (windows.h on windows) */

#include "clisp.h"
#include "config.h"

# include <sys/time.h>
# include <time.h>
# include <unistd.h>
#if defined(HAVE_SYS_UNISTD_H)
# include <sys/unistd.h>
#endif
#include <errno.h>              /* from gnulib */
#include <sys/types.h>
#if defined(HAVE_SYS_STAT_H)
# include <sys/stat.h>
#endif
#if defined(HAVE_SYS_RESOURCE_H)
# include <sys/resource.h>
#endif
#include <sys/wait.h>    /* always present on unix, imported from gnulib elsewhere */
#if defined(HAVE_SYS_STATVFS_H)
# include <sys/statvfs.h>
#endif
#if defined(HAVE_UTIME_H)
# include <utime.h>
#endif
#include <wchar.h>
#include <limits.h>
#if !defined(NZERO)             /* should be defined in <limits.h> */
# define NZERO 20
#endif
#if defined(HAVE_SYSLOG_H)
# include <syslog.h>
#endif
#if defined(HAVE_UTMPX_H)
# include <utmpx.h>
#endif
#if defined(HAVE_SIGNAL_H)
# include <signal.h>
#endif
#if defined(HAVE_FCNTL_H)
# include <fcntl.h>
#endif
#if defined(HAVE_SYS_PARAM_H)   /* might not be present on woe32 */
# include <sys/param.h>
#endif
#if defined(HAVE_FTW_H)
# include <ftw.h>
#endif
#include <fnmatch.h>

#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
#include <initguid.h>
DEFINE_GUID(FMTID_SummaryInformation, 0xF29F85E0, 0x4FF9, 0x1068,
            0xAB, 0x91, 0x08, 0x00, 0x2B, 0x27, 0xB3, 0xD9);
DEFINE_GUID(FMTID_UserDefinedProperties, 0xD5CDD505, 0x2E9C, 0x101B,
            0x93, 0x97, 0x08, 0x00, 0x2B, 0x2C, 0xF9, 0xAE);
#endif

#include <stdio.h>              /* for BUFSIZ */
#include <stdlib.h>
#include <string.h>             /* for strcpy(), strcat() */

/* #define DEBUG */
#if defined(DEBUG)
extern object nobject_out (FILE* stream, object obj);
#line 86
# define XOUT(obj,label)                                                   (printf("[%s:%d] %s: %s:\n",__FILE__,__LINE__,STRING(obj),label),         obj=nobject_out(stdout,obj), printf("\n"))
#else
# undef OBJECT_OUT
# define OBJECT_OUT(o,l)
# define XOUT(o,l)
#endif

/* http://opengroup.org/onlinepubs/9699919799/basedefs/sys/types.h.html
   specifies tha pid_t is signed, assume that uid_t & gid_t are signed too */
#if SIZEOF_PID_T == 8
# define pid_to_I(g)  sint64_to_I(g)
# define I_to_pid(g)  I_to_sint64(g=check_sint64(g))
#else
# define pid_to_I(g)  sint32_to_I(g)
# define I_to_pid(g)  I_to_sint32(g=check_sint32(g))
#endif
#if SIZEOF_UID_T == 8
# define uid_to_I(g)  sint64_to_I(g)
# define I_to_uid(g)  I_to_sint64(g=check_sint64(g))
#else
# define uid_to_I(g)  sint32_to_I(g)
# define I_to_uid(g)  I_to_sint32(g=check_sint32(g))
#endif
#if SIZEOF_GID_T == 8
# define gid_to_I(g)  sint64_to_I(g)
# define I_to_gid(g)  I_to_sint64(g=check_sint64(g))
#else
# define gid_to_I(g)  sint32_to_I(g)
# define I_to_gid(g)  I_to_sint32(g=check_sint32(g))
#endif

/* general convenience macros */
/* when the portability is ensured by gnulib, use ANSIC_error;
   when we use WIN32_NATIVE functions, use OS_error */
#line 123
#define GETTER(type,conv,call)                                     type id;                                                         begin_system_call(); id = call(); end_system_call();             VALUES1(conv##_to_I(id))
#define GETTER0(type,call)  GETTER(type##_t,type,call)
#line 130
#define GETTER1(type,call)                                 type##_t id = I_to_##type(STACK_0);                      type##_t ret;                                            begin_system_call(); ret=call(id); end_system_call();    if (ret==(type##_t)-1) ANSIC_error();                    VALUES1(type##_to_I(ret)); skipSTACK(1)
#line 136
#define SETTER(type,conv,call)                                     type val = conv(STACK_0);                                        int status;                                                      begin_system_call(); status = call(val); end_system_call();      if (status) ANSIC_error();                                       VALUES1(popSTACK())
#define SETTER1(type,call)  SETTER(type##_t,I_to_##type,call)
#line 144
#define SETTER2(type,call)                                                 type##_t eid = I_to_##type(STACK_0);                                     type##_t rid = I_to_##type(STACK_1);                                     int status;                                                              begin_system_call(); status = call(rid,eid); end_system_call();          if (status) ANSIC_error();                                               VALUES0; skipSTACK(2)

/* for COPY-FILE, must come before DEFMODULE for DEFCHECKER to work */
typedef enum {
  COPY_METHOD_COPY,
  COPY_METHOD_SYMLINK,
  COPY_METHOD_HARDLINK,
  COPY_METHOD_HARDLINK_OR_COPY, /* EXDEV=>COPY */
  COPY_METHOD_RENAME
} copy_method_t;

DEFMODULE(syscalls,"POSIX")

void module__syscalls__init_function_1 (module_t* module);
void module__syscalls__init_function_2__modprep (module_t* module);

#define O(varname) module__syscalls__object_tab._##varname
#define F(varname) subr_tab_ptr_as_object(&this_module_stab->_##varname)

struct module__syscalls__object_tab_t {
  gcv_object_t _object_cl_decode_universal_time;
#if (defined(HAVE_SYSCONF)) && (defined(_SC_2_CHAR_TERM))
  gcv_object_t _object_K2_char_term;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_2_C_BIND))
  gcv_object_t _object_K2_c_bind;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_2_C_DEV))
  gcv_object_t _object_K2_c_dev;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_2_FORT_DEV))
  gcv_object_t _object_K2_fort_dev;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_2_FORT_RUN))
  gcv_object_t _object_K2_fort_run;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_2_LOCALEDEF))
  gcv_object_t _object_K2_localedef;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_2_PBS))
  gcv_object_t _object_K2_pbs;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_2_PBS_ACCOUNTING))
  gcv_object_t _object_K2_pbs_accounting;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_2_PBS_CHECKPOINT))
  gcv_object_t _object_K2_pbs_checkpoint;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_2_PBS_LOCATE))
  gcv_object_t _object_K2_pbs_locate;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_2_PBS_MESSAGE))
  gcv_object_t _object_K2_pbs_message;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_2_PBS_TRACK))
  gcv_object_t _object_K2_pbs_track;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_2_SW_DEV))
  gcv_object_t _object_K2_sw_dev;
#endif
#if (defined(HAVE_PATHCONF) && defined(HAVE_FPATHCONF)) && (defined(_PC_2_SYMLINKS))
  gcv_object_t _object_K2_symlinks;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_2_UPE))
  gcv_object_t _object_K2_upe;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_2_VERSION))
  gcv_object_t _object_K2_version;
#endif
#if ((defined(WIN32_NATIVE)) && (defined(ABOVE_NORMAL_PRIORITY_CLASS))) || (!(defined(WIN32_NATIVE)))
  gcv_object_t _object_Kabove_normal;
#endif
#if (defined(HAVE_UTMPX_H)) && (defined(ACCOUNTING))
  gcv_object_t _object_Kaccounting;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_ADVISORY_INFO))
  gcv_object_t _object_Kadvisory_info;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_AIO_LISTIO_MAX))
  gcv_object_t _object_Kaio_listio_max;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_AIO_MAX))
  gcv_object_t _object_Kaio_max;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_AIO_PRIO_DELTA_MAX))
  gcv_object_t _object_Kaio_prio_delta_max;
#endif
#if (defined(HAVE_SYSLOG)) && (defined(LOG_ALERT))
  gcv_object_t _object_Kalert;
#endif
#if (defined(HAVE_PATHCONF) && defined(HAVE_FPATHCONF)) && (defined(_PC_ALLOC_SIZE_MIN))
  gcv_object_t _object_Kalloc_size_min;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(PROCESSOR_ARCHITECTURE_ALPHA))
  gcv_object_t _object_Kalpha;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(PROCESSOR_ARCHITECTURE_ALPHA64))
  gcv_object_t _object_Kalpha64;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  gcv_object_t _object_Kalt;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(PROCESSOR_ARCHITECTURE_AMD64))
  gcv_object_t _object_Kamd64;
#endif
#if (defined(HAVE_FCNTL)) && (defined(O_APPEND))
  gcv_object_t _object_Kappend;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  gcv_object_t _object_Kappname;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(FILE_ATTRIBUTE_ARCHIVE))
  gcv_object_t _object_Karchive;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  gcv_object_t _object_Karguments;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_ARG_MAX))
  gcv_object_t _object_Karg_max;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(PROCESSOR_ARCHITECTURE_ARM))
  gcv_object_t _object_Karm;
#endif
#if (defined(HAVE_GETRLIMIT) || defined(HAVE_SETRLIMIT)) && (defined(RLIMIT_AS))
  gcv_object_t _object_Kas;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_ASYNCHRONOUS_IO))
  gcv_object_t _object_Kasynchronous_io;
#endif
#if (defined(HAVE_PATHCONF) && defined(HAVE_FPATHCONF)) && (defined(_PC_ASYNC_IO))
  gcv_object_t _object_Kasync_io;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_ATEXIT_MAX))
  gcv_object_t _object_Katexit_max;
#endif
#if defined(HAVE_STAT) && (defined(HAVE_CHMOD) || defined(HAVE_CHOWN) || defined(HAVE_UTIME))
  gcv_object_t _object_Katime;
#endif
#if (defined(HAVE_SYSLOG)) && (defined(LOG_AUTH))
  gcv_object_t _object_Kauth;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  gcv_object_t _object_Kauthor;
#endif
#if (defined(HAVE_SYSLOG)) && (defined(LOG_AUTHPRIV))
  gcv_object_t _object_Kauthpriv;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_AVPHYS_PAGES))
  gcv_object_t _object_Kavphys_pages;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  gcv_object_t _object_Kbackoffice;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_BARRIERS))
  gcv_object_t _object_Kbarriers;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_BC_BASE_MAX))
  gcv_object_t _object_Kbc_base_max;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_BC_DIM_MAX))
  gcv_object_t _object_Kbc_dim_max;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_BC_SCALE_MAX))
  gcv_object_t _object_Kbc_scale_max;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_BC_STRING_MAX))
  gcv_object_t _object_Kbc_string_max;
#endif
#if ((defined(WIN32_NATIVE)) && (defined(BELOW_NORMAL_PRIORITY_CLASS))) || (!(defined(WIN32_NATIVE)))
  gcv_object_t _object_Kbelow_normal;
#endif
#if (defined(HAVE_FCNTL)) && (defined(O_BINARY))
  gcv_object_t _object_Kbinary;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  gcv_object_t _object_Kblob;
#endif
#if defined(HAVE_FCNTL) || defined(WIN32_NATIVE)
  gcv_object_t _object_Kblock;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  gcv_object_t _object_Kbool;
#endif
#if (defined(HAVE_UTMPX_H)) && (defined(BOOT_TIME))
  gcv_object_t _object_Kboot_time;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  gcv_object_t _object_Kbstr;
#endif
  gcv_object_t _object_Kbuffered;
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  gcv_object_t _object_Kbuilt_in;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  gcv_object_t _object_Kbyref;
#endif
  gcv_object_t _object_Kcase_sensitive;
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  gcv_object_t _object_Kcharcount;
#endif
#if defined(HAVE_NFTW)
  gcv_object_t _object_Kchdir;
#endif
#if (defined(HAVE_SYS_RESOURCE_H)) && (defined(HAVE_GETRUSAGE)) && (defined(RUSAGE_CHILDREN))
  gcv_object_t _object_Kchildren;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_CHILD_MAX))
  gcv_object_t _object_Kchild_max;
#endif
#if (defined(HAVE_PATHCONF) && defined(HAVE_FPATHCONF)) && (defined(_PC_CHOWN_RESTRICTED))
  gcv_object_t _object_Kchown_restricted;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  gcv_object_t _object_Kclipboard_format;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_CLK_TCK))
  gcv_object_t _object_Kclk_tck;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_CLOCK_SELECTION))
  gcv_object_t _object_Kclock_selection;
#endif
#if (defined(HAVE_FCNTL)) && (defined(FD_CLOEXEC))
  gcv_object_t _object_Kcloexec;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  gcv_object_t _object_Kcodepage;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_COLL_WEIGHTS_MAX))
  gcv_object_t _object_Kcoll_weights_max;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  gcv_object_t _object_Kcomments;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(FILE_ATTRIBUTE_COMPRESSED))
  gcv_object_t _object_Kcompressed;
#endif
#if (defined(HAVE_SYSLOG)) && (defined(HAVE_OPENLOG))
  gcv_object_t _object_Kcons;
#endif
#if defined(HAVE_SYS_RESOURCE_H)
  gcv_object_t _object_Kcontinued;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  gcv_object_t _object_Kcontrol;
#endif
  gcv_object_t _object_Kcopy;
#if (defined(HAVE_GETRLIMIT) || defined(HAVE_SETRLIMIT)) && (defined(RLIMIT_CORE))
  gcv_object_t _object_Kcore;
#endif
#if (defined(HAVE_GETRLIMIT) || defined(HAVE_SETRLIMIT)) && (defined(RLIMIT_CPU))
  gcv_object_t _object_Kcpu;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_CPUTIME))
  gcv_object_t _object_Kcputime;
#endif
#if (defined(HAVE_FCNTL)) && (defined(O_CREAT))
  gcv_object_t _object_Kcreat;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  gcv_object_t _object_Kcreate_dtm;
#endif
#if (defined(HAVE_SYSLOG)) && (defined(LOG_CRIT))
  gcv_object_t _object_Kcrit;
#endif
#if (defined(HAVE_SYSLOG)) && (defined(LOG_CRON))
  gcv_object_t _object_Kcron;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  gcv_object_t _object_Kcy;
#endif
#if (defined(HAVE_NFTW)) && (defined(FTW_D))
  gcv_object_t _object_Kd;
#endif
#if (defined(HAVE_SYSLOG)) && (defined(LOG_DAEMON))
  gcv_object_t _object_Kdaemon;
#endif
#if (defined(HAVE_GETRLIMIT) || defined(HAVE_SETRLIMIT)) && (defined(RLIMIT_DATA))
  gcv_object_t _object_Kdata;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  gcv_object_t _object_Kdatacenter;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  gcv_object_t _object_Kdate;
#endif
#if (defined(HAVE_UTMPX_H)) && (defined(DEAD_PROCESS))
  gcv_object_t _object_Kdead_process;
#endif
#if (defined(HAVE_SYSLOG)) && (defined(LOG_DEBUG))
  gcv_object_t _object_Kdebug;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_DELAYTIMER_MAX))
  gcv_object_t _object_Kdelaytimer_max;
#endif
#if defined(HAVE_NFTW)
  gcv_object_t _object_Kdepth;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  gcv_object_t _object_Kdescription;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(FILE_ATTRIBUTE_DEVICE))
  gcv_object_t _object_Kdevice;
#endif
#if (defined(HAVE_FCNTL)) && (defined(O_DIRECT))
  gcv_object_t _object_Kdirect;
#endif
  gcv_object_t _object_Kdirection;
#if ((defined(HAVE_FCNTL)) && (defined(O_DIRECTORY))) || ((defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(FILE_ATTRIBUTE_DIRECTORY)))
  gcv_object_t _object_Kdirectory;
#endif
#if (defined(HAVE_NFTW)) && (defined(FTW_DNR))
  gcv_object_t _object_Kdnr;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_AUTOZONE_ALREADY_EXISTS))
  gcv_object_t _object_Kdns_error_autozone_already_exists;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_AXFR))
  gcv_object_t _object_Kdns_error_axfr;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_BAD_PACKET))
  gcv_object_t _object_Kdns_error_bad_packet;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_CANNOT_FIND_ROOT_HINTS))
  gcv_object_t _object_Kdns_error_cannot_find_root_hints;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_CNAME_COLLISION))
  gcv_object_t _object_Kdns_error_cname_collision;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_CNAME_LOOP))
  gcv_object_t _object_Kdns_error_cname_loop;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_DATAFILE_OPEN_FAILURE))
  gcv_object_t _object_Kdns_error_datafile_open_failure;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_DATAFILE_PARSING))
  gcv_object_t _object_Kdns_error_datafile_parsing;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_DP_ALREADY_ENLISTED))
  gcv_object_t _object_Kdns_error_dp_already_enlisted;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_DP_ALREADY_EXISTS))
  gcv_object_t _object_Kdns_error_dp_already_exists;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_DP_DOES_NOT_EXIST))
  gcv_object_t _object_Kdns_error_dp_does_not_exist;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_DP_NOT_AVAILABLE))
  gcv_object_t _object_Kdns_error_dp_not_available;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_DP_NOT_ENLISTED))
  gcv_object_t _object_Kdns_error_dp_not_enlisted;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_DS_UNAVAILABLE))
  gcv_object_t _object_Kdns_error_ds_unavailable;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_DS_ZONE_ALREADY_EXISTS))
  gcv_object_t _object_Kdns_error_ds_zone_already_exists;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_FILE_WRITEBACK_FAILED))
  gcv_object_t _object_Kdns_error_file_writeback_failed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_FORWARDER_ALREADY_EXISTS))
  gcv_object_t _object_Kdns_error_forwarder_already_exists;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_INCONSISTENT_ROOT_HINTS))
  gcv_object_t _object_Kdns_error_inconsistent_root_hints;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_INVALID_DATAFILE_NAME))
  gcv_object_t _object_Kdns_error_invalid_datafile_name;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_INVALID_IP_ADDRESS))
  gcv_object_t _object_Kdns_error_invalid_ip_address;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_INVALID_NAME_CHAR))
  gcv_object_t _object_Kdns_error_invalid_name_char;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_INVALID_PROPERTY))
  gcv_object_t _object_Kdns_error_invalid_property;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_INVALID_TYPE))
  gcv_object_t _object_Kdns_error_invalid_type;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_INVALID_ZONE_OPERATION))
  gcv_object_t _object_Kdns_error_invalid_zone_operation;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_INVALID_ZONE_TYPE))
  gcv_object_t _object_Kdns_error_invalid_zone_type;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_NAME_DOES_NOT_EXIST))
  gcv_object_t _object_Kdns_error_name_does_not_exist;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_NAME_NOT_IN_ZONE))
  gcv_object_t _object_Kdns_error_name_not_in_zone;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_NBSTAT_INIT_FAILED))
  gcv_object_t _object_Kdns_error_nbstat_init_failed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_NEED_SECONDARY_ADDRESSES))
  gcv_object_t _object_Kdns_error_need_secondary_addresses;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_NEED_WINS_SERVERS))
  gcv_object_t _object_Kdns_error_need_wins_servers;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_NODE_CREATION_FAILED))
  gcv_object_t _object_Kdns_error_node_creation_failed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_NODE_IS_CNAME))
  gcv_object_t _object_Kdns_error_node_is_cname;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_NON_RFC_NAME))
  gcv_object_t _object_Kdns_error_non_rfc_name;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_NOT_ALLOWED_ON_ROOT_SERVER))
  gcv_object_t _object_Kdns_error_not_allowed_on_root_server;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_NOT_ALLOWED_UNDER_DELEGATION))
  gcv_object_t _object_Kdns_error_not_allowed_under_delegation;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_NOT_UNIQUE))
  gcv_object_t _object_Kdns_error_not_unique;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_NO_BOOTFILE_IF_DS_ZONE))
  gcv_object_t _object_Kdns_error_no_bootfile_if_ds_zone;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_NO_CREATE_CACHE_DATA))
  gcv_object_t _object_Kdns_error_no_create_cache_data;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_NO_DNS_SERVERS))
  gcv_object_t _object_Kdns_error_no_dns_servers;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_NO_PACKET))
  gcv_object_t _object_Kdns_error_no_packet;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_NO_TCPIP))
  gcv_object_t _object_Kdns_error_no_tcpip;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_NO_ZONE_INFO))
  gcv_object_t _object_Kdns_error_no_zone_info;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_NUMERIC_NAME))
  gcv_object_t _object_Kdns_error_numeric_name;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_PRIMARY_REQUIRES_DATAFILE))
  gcv_object_t _object_Kdns_error_primary_requires_datafile;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_RCODE))
  gcv_object_t _object_Kdns_error_rcode;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_RCODE_BADKEY))
  gcv_object_t _object_Kdns_error_rcode_badkey;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_RCODE_BADSIG))
  gcv_object_t _object_Kdns_error_rcode_badsig;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_RCODE_BADTIME))
  gcv_object_t _object_Kdns_error_rcode_badtime;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_RCODE_FORMAT_ERROR))
  gcv_object_t _object_Kdns_error_rcode_format_error;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_RCODE_NAME_ERROR))
  gcv_object_t _object_Kdns_error_rcode_name_error;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_RCODE_NOTAUTH))
  gcv_object_t _object_Kdns_error_rcode_notauth;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_RCODE_NOTZONE))
  gcv_object_t _object_Kdns_error_rcode_notzone;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_RCODE_NOT_IMPLEMENTED))
  gcv_object_t _object_Kdns_error_rcode_not_implemented;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_RCODE_NXRRSET))
  gcv_object_t _object_Kdns_error_rcode_nxrrset;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_RCODE_REFUSED))
  gcv_object_t _object_Kdns_error_rcode_refused;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_RCODE_SERVER_FAILURE))
  gcv_object_t _object_Kdns_error_rcode_server_failure;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_RCODE_YXDOMAIN))
  gcv_object_t _object_Kdns_error_rcode_yxdomain;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_RCODE_YXRRSET))
  gcv_object_t _object_Kdns_error_rcode_yxrrset;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_RECORD_ALREADY_EXISTS))
  gcv_object_t _object_Kdns_error_record_already_exists;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_RECORD_DOES_NOT_EXIST))
  gcv_object_t _object_Kdns_error_record_does_not_exist;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_RECORD_FORMAT))
  gcv_object_t _object_Kdns_error_record_format;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_RECORD_ONLY_AT_ZONE_ROOT))
  gcv_object_t _object_Kdns_error_record_only_at_zone_root;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_RECORD_TIMED_OUT))
  gcv_object_t _object_Kdns_error_record_timed_out;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_SECONDARY_DATA))
  gcv_object_t _object_Kdns_error_secondary_data;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_SECONDARY_REQUIRES_MASTER_IP))
  gcv_object_t _object_Kdns_error_secondary_requires_master_ip;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_SOA_DELETE_INVALID))
  gcv_object_t _object_Kdns_error_soa_delete_invalid;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_TRY_AGAIN_LATER))
  gcv_object_t _object_Kdns_error_try_again_later;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_UNKNOWN_RECORD_TYPE))
  gcv_object_t _object_Kdns_error_unknown_record_type;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_UNSECURE_PACKET))
  gcv_object_t _object_Kdns_error_unsecure_packet;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_WINS_INIT_FAILED))
  gcv_object_t _object_Kdns_error_wins_init_failed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_ZONE_ALREADY_EXISTS))
  gcv_object_t _object_Kdns_error_zone_already_exists;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_ZONE_CONFIGURATION_ERROR))
  gcv_object_t _object_Kdns_error_zone_configuration_error;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_ZONE_CREATION_FAILED))
  gcv_object_t _object_Kdns_error_zone_creation_failed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_ZONE_DOES_NOT_EXIST))
  gcv_object_t _object_Kdns_error_zone_does_not_exist;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_ZONE_HAS_NO_NS_RECORDS))
  gcv_object_t _object_Kdns_error_zone_has_no_ns_records;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_ZONE_HAS_NO_SOA_RECORD))
  gcv_object_t _object_Kdns_error_zone_has_no_soa_record;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_ZONE_IS_SHUTDOWN))
  gcv_object_t _object_Kdns_error_zone_is_shutdown;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_ZONE_LOCKED))
  gcv_object_t _object_Kdns_error_zone_locked;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_ZONE_NOT_SECONDARY))
  gcv_object_t _object_Kdns_error_zone_not_secondary;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_ZONE_REQUIRES_MASTER_IP))
  gcv_object_t _object_Kdns_error_zone_requires_master_ip;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_INFO_ADDED_LOCAL_WINS))
  gcv_object_t _object_Kdns_info_added_local_wins;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_INFO_AXFR_COMPLETE))
  gcv_object_t _object_Kdns_info_axfr_complete;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_INFO_NO_RECORDS))
  gcv_object_t _object_Kdns_info_no_records;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_STATUS_CONTINUE_NEEDED))
  gcv_object_t _object_Kdns_status_continue_needed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_STATUS_DOTTED_NAME))
  gcv_object_t _object_Kdns_status_dotted_name;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_STATUS_FQDN))
  gcv_object_t _object_Kdns_status_fqdn;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_STATUS_SINGLE_PART_NAME))
  gcv_object_t _object_Kdns_status_single_part_name;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_WARNING_DOMAIN_UNDELETED))
  gcv_object_t _object_Kdns_warning_domain_undeleted;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_WARNING_PTR_CREATE_FAILED))
  gcv_object_t _object_Kdns_warning_ptr_create_failed;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  gcv_object_t _object_Kdoc_security;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  gcv_object_t _object_Kdomain_controller;
#endif
#if (defined(HAVE_NFTW)) && (defined(FTW_DP))
  gcv_object_t _object_Kdp;
#endif
#if defined(E2BIG)
  gcv_object_t _object_Ke2big;
#endif
#if defined(EACCES)
  gcv_object_t _object_Keacces;
#endif
#if defined(EADDRINUSE)
  gcv_object_t _object_Keaddrinuse;
#endif
#if defined(EADDRNOTAVAIL)
  gcv_object_t _object_Keaddrnotavail;
#endif
#if defined(EADV)
  gcv_object_t _object_Keadv;
#endif
#if defined(EAFNOSUPPORT)
  gcv_object_t _object_Keafnosupport;
#endif
#if defined(EAGAIN)
  gcv_object_t _object_Keagain;
#endif
#if defined(EAIO)
  gcv_object_t _object_Keaio;
#endif
#if defined(EALIGN)
  gcv_object_t _object_Kealign;
#endif
#if defined(EALREADY)
  gcv_object_t _object_Kealready;
#endif
#if defined(EAUTH)
  gcv_object_t _object_Keauth;
#endif
#if defined(EBADE)
  gcv_object_t _object_Kebade;
#endif
#if defined(EBADF)
  gcv_object_t _object_Kebadf;
#endif
#if defined(EBADFD)
  gcv_object_t _object_Kebadfd;
#endif
#if defined(EBADMSG)
  gcv_object_t _object_Kebadmsg;
#endif
#if defined(EBADR)
  gcv_object_t _object_Kebadr;
#endif
#if defined(EBADRPC)
  gcv_object_t _object_Kebadrpc;
#endif
#if defined(EBADRQC)
  gcv_object_t _object_Kebadrqc;
#endif
#if defined(EBADSLT)
  gcv_object_t _object_Kebadslt;
#endif
#if defined(EBFONT)
  gcv_object_t _object_Kebfont;
#endif
#if defined(EBUSY)
  gcv_object_t _object_Kebusy;
#endif
#if defined(ECANCELED)
  gcv_object_t _object_Kecanceled;
#endif
#if defined(ECASECLASH)
  gcv_object_t _object_Kecaseclash;
#endif
#if defined(ECHILD)
  gcv_object_t _object_Kechild;
#endif
#if defined(ECHRNG)
  gcv_object_t _object_Kechrng;
#endif
#if defined(ECLONEME)
  gcv_object_t _object_Kecloneme;
#endif
#if defined(ECOMM)
  gcv_object_t _object_Kecomm;
#endif
#if defined(ECONNABORTED)
  gcv_object_t _object_Keconnaborted;
#endif
#if defined(ECONNREFUSED)
  gcv_object_t _object_Keconnrefused;
#endif
#if defined(ECONNRESET)
  gcv_object_t _object_Keconnreset;
#endif
#if defined(EDEADLK)
  gcv_object_t _object_Kedeadlk;
#endif
#if defined(EDEADLOCK)
  gcv_object_t _object_Kedeadlock;
#endif
#if defined(EDESTADDRREQ)
  gcv_object_t _object_Kedestaddrreq;
#endif
#if defined(EDIRIOCTL)
  gcv_object_t _object_Kedirioctl;
#endif
#if defined(EDIRTY)
  gcv_object_t _object_Kedirty;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  gcv_object_t _object_Kedittime;
#endif
#if defined(EDOM)
  gcv_object_t _object_Kedom;
#endif
#if defined(EDOOFUS)
  gcv_object_t _object_Kedoofus;
#endif
#if defined(EDOTDOT)
  gcv_object_t _object_Kedotdot;
#endif
#if defined(EDQUOT)
  gcv_object_t _object_Kedquot;
#endif
#if defined(EDUPPKG)
  gcv_object_t _object_Keduppkg;
#endif
#if defined(EEXIST)
  gcv_object_t _object_Keexist;
#endif
#if defined(EFAIL)
  gcv_object_t _object_Kefail;
#endif
#if defined(EFAULT)
  gcv_object_t _object_Kefault;
#endif
#if defined(EFBIG)
  gcv_object_t _object_Kefbig;
#endif
#if defined(EFTYPE)
  gcv_object_t _object_Keftype;
#endif
#if defined(EHOSTDOWN)
  gcv_object_t _object_Kehostdown;
#endif
#if defined(EHOSTUNREACH)
  gcv_object_t _object_Kehostunreach;
#endif
#if defined(EHWPOISON)
  gcv_object_t _object_Kehwpoison;
#endif
#if defined(EIDRM)
  gcv_object_t _object_Keidrm;
#endif
#if defined(EILSEQ)
  gcv_object_t _object_Keilseq;
#endif
#if defined(EINIT)
  gcv_object_t _object_Keinit;
#endif
#if defined(EINPROG)
  gcv_object_t _object_Keinprog;
#endif
#if defined(EINPROGRESS)
  gcv_object_t _object_Keinprogress;
#endif
#if defined(EINTR)
  gcv_object_t _object_Keintr;
#endif
#if defined(EINVAL)
  gcv_object_t _object_Keinval;
#endif
#if defined(EIO)
  gcv_object_t _object_Keio;
#endif
#if defined(EISCONN)
  gcv_object_t _object_Keisconn;
#endif
#if defined(EISDIR)
  gcv_object_t _object_Keisdir;
#endif
#if defined(EISNAM)
  gcv_object_t _object_Keisnam;
#endif
#if defined(EISNAME)
  gcv_object_t _object_Keisname;
#endif
#if defined(EJUSTRETURN)
  gcv_object_t _object_Kejustreturn;
#endif
#if defined(EKEYEXPIRED)
  gcv_object_t _object_Kekeyexpired;
#endif
#if defined(EKEYREJECTED)
  gcv_object_t _object_Kekeyrejected;
#endif
#if defined(EKEYREVOKED)
  gcv_object_t _object_Kekeyrevoked;
#endif
#if defined(EL2HLT)
  gcv_object_t _object_Kel2hlt;
#endif
#if defined(EL2NSYNC)
  gcv_object_t _object_Kel2nsync;
#endif
#if defined(EL3HLT)
  gcv_object_t _object_Kel3hlt;
#endif
#if defined(EL3RST)
  gcv_object_t _object_Kel3rst;
#endif
#if defined(ELAST)
  gcv_object_t _object_Kelast;
#endif
#if defined(ELBIN)
  gcv_object_t _object_Kelbin;
#endif
  gcv_object_t _object_Kelement_type;
#if defined(ELIBACC)
  gcv_object_t _object_Kelibacc;
#endif
#if defined(ELIBBAD)
  gcv_object_t _object_Kelibbad;
#endif
#if defined(ELIBEXEC)
  gcv_object_t _object_Kelibexec;
#endif
#if defined(ELIBMAX)
  gcv_object_t _object_Kelibmax;
#endif
#if defined(ELIBSCN)
  gcv_object_t _object_Kelibscn;
#endif
#if defined(ELNRNG)
  gcv_object_t _object_Kelnrng;
#endif
#if defined(ELOCKUNMAPPED)
  gcv_object_t _object_Kelockunmapped;
#endif
#if defined(ELOOP)
  gcv_object_t _object_Keloop;
#endif
#if defined(EMEDIUMTYPE)
  gcv_object_t _object_Kemediumtype;
#endif
#if (defined(HAVE_SYSLOG)) && (defined(LOG_EMERG))
  gcv_object_t _object_Kemerg;
#endif
#if defined(EMFILE)
  gcv_object_t _object_Kemfile;
#endif
#if defined(EMLINK)
  gcv_object_t _object_Kemlink;
#endif
#if ((defined(HAVE_UTMPX_H)) && (defined(EMPTY))) || (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN))
  gcv_object_t _object_Kempty;
#endif
#if defined(EMSGSIZE)
  gcv_object_t _object_Kemsgsize;
#endif
#if defined(EMTIMERS)
  gcv_object_t _object_Kemtimers;
#endif
#if defined(EMULTIHOP)
  gcv_object_t _object_Kemultihop;
#endif
#if defined(ENAMETOOLONG)
  gcv_object_t _object_Kenametoolong;
#endif
#if defined(ENAVAIL)
  gcv_object_t _object_Kenavail;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(FILE_ATTRIBUTE_ENCRYPTED))
  gcv_object_t _object_Kencrypted;
#endif
#if defined(ENEEDAUTH)
  gcv_object_t _object_Keneedauth;
#endif
#if defined(ENET)
  gcv_object_t _object_Kenet;
#endif
#if defined(ENETDOWN)
  gcv_object_t _object_Kenetdown;
#endif
#if defined(ENETRESET)
  gcv_object_t _object_Kenetreset;
#endif
#if defined(ENETUNREACH)
  gcv_object_t _object_Kenetunreach;
#endif
#if defined(ENFILE)
  gcv_object_t _object_Kenfile;
#endif
#if defined(ENMFILE)
  gcv_object_t _object_Kenmfile;
#endif
#if defined(ENOANO)
  gcv_object_t _object_Kenoano;
#endif
#if defined(ENOATTR)
  gcv_object_t _object_Kenoattr;
#endif
#if defined(ENOBUFS)
  gcv_object_t _object_Kenobufs;
#endif
#if defined(ENOCSI)
  gcv_object_t _object_Kenocsi;
#endif
#if defined(ENODATA)
  gcv_object_t _object_Kenodata;
#endif
#if defined(ENODEV)
  gcv_object_t _object_Kenodev;
#endif
#if defined(ENOENT)
  gcv_object_t _object_Kenoent;
#endif
#if defined(ENOEXEC)
  gcv_object_t _object_Kenoexec;
#endif
#if defined(ENOFILE)
  gcv_object_t _object_Kenofile;
#endif
#if defined(ENOIOCTL)
  gcv_object_t _object_Kenoioctl;
#endif
#if defined(ENOKEY)
  gcv_object_t _object_Kenokey;
#endif
#if defined(ENOLCK)
  gcv_object_t _object_Kenolck;
#endif
#if defined(ENOLINK)
  gcv_object_t _object_Kenolink;
#endif
#if defined(ENOMEDIUM)
  gcv_object_t _object_Kenomedium;
#endif
#if defined(ENOMEM)
  gcv_object_t _object_Kenomem;
#endif
#if defined(ENOMSG)
  gcv_object_t _object_Kenomsg;
#endif
#if defined(ENONET)
  gcv_object_t _object_Kenonet;
#endif
#if defined(ENOPKG)
  gcv_object_t _object_Kenopkg;
#endif
#if defined(ENOPROTOOPT)
  gcv_object_t _object_Kenoprotoopt;
#endif
#if defined(ENOSHARE)
  gcv_object_t _object_Kenoshare;
#endif
#if defined(ENOSPC)
  gcv_object_t _object_Kenospc;
#endif
#if defined(ENOSR)
  gcv_object_t _object_Kenosr;
#endif
#if defined(ENOSTR)
  gcv_object_t _object_Kenostr;
#endif
#if defined(ENOSYM)
  gcv_object_t _object_Kenosym;
#endif
#if defined(ENOSYS)
  gcv_object_t _object_Kenosys;
#endif
#if defined(ENOTACTIVE)
  gcv_object_t _object_Kenotactive;
#endif
#if defined(ENOTBLK)
  gcv_object_t _object_Kenotblk;
#endif
#if defined(ENOTCONN)
  gcv_object_t _object_Kenotconn;
#endif
#if defined(ENOTDIR)
  gcv_object_t _object_Kenotdir;
#endif
#if defined(ENOTEMPTY)
  gcv_object_t _object_Kenotempty;
#endif
#if defined(ENOTNAM)
  gcv_object_t _object_Kenotnam;
#endif
#if defined(ENOTRECOVERABLE)
  gcv_object_t _object_Kenotrecoverable;
#endif
#if defined(ENOTSOCK)
  gcv_object_t _object_Kenotsock;
#endif
#if defined(ENOTSUP)
  gcv_object_t _object_Kenotsup;
#endif
#if defined(ENOTTY)
  gcv_object_t _object_Kenotty;
#endif
#if defined(ENOTUNIQ)
  gcv_object_t _object_Kenotuniq;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  gcv_object_t _object_Kenterprise;
#endif
#if defined(ENXIO)
  gcv_object_t _object_Kenxio;
#endif
#if defined(EOPNOTSUPP)
  gcv_object_t _object_Keopnotsupp;
#endif
#if defined(EOVERFLOW)
  gcv_object_t _object_Keoverflow;
#endif
#if defined(EOWNERDEAD)
  gcv_object_t _object_Keownerdead;
#endif
#if defined(EPERM)
  gcv_object_t _object_Keperm;
#endif
#if defined(EPFNOSUPPORT)
  gcv_object_t _object_Kepfnosupport;
#endif
#if defined(EPIPE)
  gcv_object_t _object_Kepipe;
#endif
#if defined(EPROCLIM)
  gcv_object_t _object_Keproclim;
#endif
#if defined(EPROCUNAVAIL)
  gcv_object_t _object_Keprocunavail;
#endif
#if defined(EPROGMISMATCH)
  gcv_object_t _object_Keprogmismatch;
#endif
#if defined(EPROGUNAVAIL)
  gcv_object_t _object_Keprogunavail;
#endif
#if defined(EPROTO)
  gcv_object_t _object_Keproto;
#endif
#if defined(EPROTONOSUPPORT)
  gcv_object_t _object_Keprotonosupport;
#endif
#if defined(EPROTOTYPE)
  gcv_object_t _object_Keprototype;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(EPT_S_CANT_CREATE))
  gcv_object_t _object_Kept_s_cant_create;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(EPT_S_CANT_PERFORM_OP))
  gcv_object_t _object_Kept_s_cant_perform_op;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(EPT_S_INVALID_ENTRY))
  gcv_object_t _object_Kept_s_invalid_entry;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(EPT_S_NOT_REGISTERED))
  gcv_object_t _object_Kept_s_not_registered;
#endif
#if defined(ERANGE)
  gcv_object_t _object_Kerange;
#endif
#if defined(EREMCHG)
  gcv_object_t _object_Keremchg;
#endif
#if defined(EREMDEV)
  gcv_object_t _object_Keremdev;
#endif
#if defined(EREMOTE)
  gcv_object_t _object_Keremote;
#endif
#if defined(EREMOTEIO)
  gcv_object_t _object_Keremoteio;
#endif
#if defined(EREMOTERELEASE)
  gcv_object_t _object_Keremoterelease;
#endif
#if defined(ERESTART)
  gcv_object_t _object_Kerestart;
#endif
#if defined(ERESTARTNOHAND)
  gcv_object_t _object_Kerestartnohand;
#endif
#if defined(ERESTARTNOINTR)
  gcv_object_t _object_Kerestartnointr;
#endif
#if defined(ERESTARTSYS)
  gcv_object_t _object_Kerestartsys;
#endif
#if defined(ERFKILL)
  gcv_object_t _object_Kerfkill;
#endif
#if defined(EROFS)
  gcv_object_t _object_Kerofs;
#endif
#if defined(ERPCMISMATCH)
  gcv_object_t _object_Kerpcmismatch;
#endif
#if (defined(HAVE_SYSLOG)) && (defined(LOG_ERR))
  gcv_object_t _object_Kerr;
#endif
#if defined(ERREMOTE)
  gcv_object_t _object_Kerremote;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  gcv_object_t _object_Kerror;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ACCESS_DENIED))
  gcv_object_t _object_Kerror_access_denied;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ACCESS_DISABLED_BY_POLICY))
  gcv_object_t _object_Kerror_access_disabled_by_policy;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ACCESS_DISABLED_WEBBLADE))
  gcv_object_t _object_Kerror_access_disabled_webblade;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ACCESS_DISABLED_WEBBLADE_TAMPER))
  gcv_object_t _object_Kerror_access_disabled_webblade_tamper;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ACCOUNT_DISABLED))
  gcv_object_t _object_Kerror_account_disabled;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ACCOUNT_EXPIRED))
  gcv_object_t _object_Kerror_account_expired;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ACCOUNT_LOCKED_OUT))
  gcv_object_t _object_Kerror_account_locked_out;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ACCOUNT_RESTRICTION))
  gcv_object_t _object_Kerror_account_restriction;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ACTIVATION_COUNT_EXCEEDED))
  gcv_object_t _object_Kerror_activation_count_exceeded;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ACTIVE_CONNECTIONS))
  gcv_object_t _object_Kerror_active_connections;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ADAP_HDW_ERR))
  gcv_object_t _object_Kerror_adap_hdw_err;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ADDRESS_ALREADY_ASSOCIATED))
  gcv_object_t _object_Kerror_address_already_associated;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ADDRESS_NOT_ASSOCIATED))
  gcv_object_t _object_Kerror_address_not_associated;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ALIAS_EXISTS))
  gcv_object_t _object_Kerror_alias_exists;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ALLOTTED_SPACE_EXCEEDED))
  gcv_object_t _object_Kerror_allotted_space_exceeded;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ALL_NODES_NOT_AVAILABLE))
  gcv_object_t _object_Kerror_all_nodes_not_available;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ALL_USER_TRUST_QUOTA_EXCEEDED))
  gcv_object_t _object_Kerror_all_user_trust_quota_exceeded;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ALREADY_ASSIGNED))
  gcv_object_t _object_Kerror_already_assigned;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ALREADY_EXISTS))
  gcv_object_t _object_Kerror_already_exists;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ALREADY_FIBER))
  gcv_object_t _object_Kerror_already_fiber;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ALREADY_INITIALIZED))
  gcv_object_t _object_Kerror_already_initialized;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ALREADY_REGISTERED))
  gcv_object_t _object_Kerror_already_registered;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ALREADY_RUNNING_LKG))
  gcv_object_t _object_Kerror_already_running_lkg;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ALREADY_THREAD))
  gcv_object_t _object_Kerror_already_thread;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ALREADY_WAITING))
  gcv_object_t _object_Kerror_already_waiting;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_APPHELP_BLOCK))
  gcv_object_t _object_Kerror_apphelp_block;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_APP_WRONG_OS))
  gcv_object_t _object_Kerror_app_wrong_os;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ARENA_TRASHED))
  gcv_object_t _object_Kerror_arena_trashed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ARITHMETIC_OVERFLOW))
  gcv_object_t _object_Kerror_arithmetic_overflow;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ATOMIC_LOCKS_NOT_SUPPORTED))
  gcv_object_t _object_Kerror_atomic_locks_not_supported;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_AUTODATASEG_EXCEEDS_64k))
  gcv_object_t _object_Kerror_autodataseg_exceeds_64k;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BADDB))
  gcv_object_t _object_Kerror_baddb;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BADKEY))
  gcv_object_t _object_Kerror_badkey;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BAD_ARGUMENTS))
  gcv_object_t _object_Kerror_bad_arguments;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BAD_COMMAND))
  gcv_object_t _object_Kerror_bad_command;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BAD_CONFIGURATION))
  gcv_object_t _object_Kerror_bad_configuration;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BAD_DESCRIPTOR_FORMAT))
  gcv_object_t _object_Kerror_bad_descriptor_format;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BAD_DEVICE))
  gcv_object_t _object_Kerror_bad_device;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BAD_DEV_TYPE))
  gcv_object_t _object_Kerror_bad_dev_type;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BAD_DRIVER))
  gcv_object_t _object_Kerror_bad_driver;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BAD_DRIVER_LEVEL))
  gcv_object_t _object_Kerror_bad_driver_level;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BAD_ENVIRONMENT))
  gcv_object_t _object_Kerror_bad_environment;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BAD_EXE_FORMAT))
  gcv_object_t _object_Kerror_bad_exe_format;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BAD_FORMAT))
  gcv_object_t _object_Kerror_bad_format;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BAD_IMPERSONATION_LEVEL))
  gcv_object_t _object_Kerror_bad_impersonation_level;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BAD_INHERITANCE_ACL))
  gcv_object_t _object_Kerror_bad_inheritance_acl;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BAD_LENGTH))
  gcv_object_t _object_Kerror_bad_length;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BAD_LOGON_SESSION_STATE))
  gcv_object_t _object_Kerror_bad_logon_session_state;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BAD_NETPATH))
  gcv_object_t _object_Kerror_bad_netpath;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BAD_NET_NAME))
  gcv_object_t _object_Kerror_bad_net_name;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BAD_NET_RESP))
  gcv_object_t _object_Kerror_bad_net_resp;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BAD_PATHNAME))
  gcv_object_t _object_Kerror_bad_pathname;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BAD_PIPE))
  gcv_object_t _object_Kerror_bad_pipe;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BAD_PROFILE))
  gcv_object_t _object_Kerror_bad_profile;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BAD_PROVIDER))
  gcv_object_t _object_Kerror_bad_provider;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BAD_QUERY_SYNTAX))
  gcv_object_t _object_Kerror_bad_query_syntax;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BAD_RECOVERY_POLICY))
  gcv_object_t _object_Kerror_bad_recovery_policy;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BAD_REM_ADAP))
  gcv_object_t _object_Kerror_bad_rem_adap;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BAD_THREADID_ADDR))
  gcv_object_t _object_Kerror_bad_threadid_addr;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BAD_TOKEN_TYPE))
  gcv_object_t _object_Kerror_bad_token_type;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BAD_UNIT))
  gcv_object_t _object_Kerror_bad_unit;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BAD_USERNAME))
  gcv_object_t _object_Kerror_bad_username;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BAD_USER_PROFILE))
  gcv_object_t _object_Kerror_bad_user_profile;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BAD_VALIDATION_CLASS))
  gcv_object_t _object_Kerror_bad_validation_class;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BEGINNING_OF_MEDIA))
  gcv_object_t _object_Kerror_beginning_of_media;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BOOT_ALREADY_ACCEPTED))
  gcv_object_t _object_Kerror_boot_already_accepted;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BROKEN_PIPE))
  gcv_object_t _object_Kerror_broken_pipe;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BUFFER_OVERFLOW))
  gcv_object_t _object_Kerror_buffer_overflow;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BUSY))
  gcv_object_t _object_Kerror_busy;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BUSY_DRIVE))
  gcv_object_t _object_Kerror_busy_drive;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BUS_RESET))
  gcv_object_t _object_Kerror_bus_reset;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CALLBACK_SUPPLIED_INVALID_DATA))
  gcv_object_t _object_Kerror_callback_supplied_invalid_data;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CALL_NOT_IMPLEMENTED))
  gcv_object_t _object_Kerror_call_not_implemented;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CANCELLED))
  gcv_object_t _object_Kerror_cancelled;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CANCEL_VIOLATION))
  gcv_object_t _object_Kerror_cancel_violation;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CANNOT_COPY))
  gcv_object_t _object_Kerror_cannot_copy;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CANNOT_DETECT_DRIVER_FAILURE))
  gcv_object_t _object_Kerror_cannot_detect_driver_failure;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CANNOT_DETECT_PROCESS_ABORT))
  gcv_object_t _object_Kerror_cannot_detect_process_abort;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CANNOT_FIND_WND_CLASS))
  gcv_object_t _object_Kerror_cannot_find_wnd_class;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CANNOT_IMPERSONATE))
  gcv_object_t _object_Kerror_cannot_impersonate;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CANNOT_MAKE))
  gcv_object_t _object_Kerror_cannot_make;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CANNOT_OPEN_PROFILE))
  gcv_object_t _object_Kerror_cannot_open_profile;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CANTOPEN))
  gcv_object_t _object_Kerror_cantopen;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CANTREAD))
  gcv_object_t _object_Kerror_cantread;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CANTWRITE))
  gcv_object_t _object_Kerror_cantwrite;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CANT_ACCESS_DOMAIN_INFO))
  gcv_object_t _object_Kerror_cant_access_domain_info;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CANT_ACCESS_FILE))
  gcv_object_t _object_Kerror_cant_access_file;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CANT_DELETE_LAST_ITEM))
  gcv_object_t _object_Kerror_cant_delete_last_item;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CANT_DISABLE_MANDATORY))
  gcv_object_t _object_Kerror_cant_disable_mandatory;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CANT_EVICT_ACTIVE_NODE))
  gcv_object_t _object_Kerror_cant_evict_active_node;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CANT_OPEN_ANONYMOUS))
  gcv_object_t _object_Kerror_cant_open_anonymous;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CANT_RESOLVE_FILENAME))
  gcv_object_t _object_Kerror_cant_resolve_filename;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CAN_NOT_COMPLETE))
  gcv_object_t _object_Kerror_can_not_complete;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CAN_NOT_DEL_LOCAL_WINS))
  gcv_object_t _object_Kerror_can_not_del_local_wins;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CHILD_MUST_BE_VOLATILE))
  gcv_object_t _object_Kerror_child_must_be_volatile;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CHILD_NOT_COMPLETE))
  gcv_object_t _object_Kerror_child_not_complete;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CHILD_WINDOW_MENU))
  gcv_object_t _object_Kerror_child_window_menu;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CIRCULAR_DEPENDENCY))
  gcv_object_t _object_Kerror_circular_dependency;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLASS_ALREADY_EXISTS))
  gcv_object_t _object_Kerror_class_already_exists;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLASS_DOES_NOT_EXIST))
  gcv_object_t _object_Kerror_class_does_not_exist;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLASS_HAS_WINDOWS))
  gcv_object_t _object_Kerror_class_has_windows;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLEANER_CARTRIDGE_INSTALLED))
  gcv_object_t _object_Kerror_cleaner_cartridge_installed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLEANER_CARTRIDGE_SPENT))
  gcv_object_t _object_Kerror_cleaner_cartridge_spent;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLEANER_SLOT_NOT_SET))
  gcv_object_t _object_Kerror_cleaner_slot_not_set;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLEANER_SLOT_SET))
  gcv_object_t _object_Kerror_cleaner_slot_set;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLIPBOARD_NOT_OPEN))
  gcv_object_t _object_Kerror_clipboard_not_open;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLIPPING_NOT_SUPPORTED))
  gcv_object_t _object_Kerror_clipping_not_supported;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSCFG_ALREADY_COMMITTED))
  gcv_object_t _object_Kerror_cluscfg_already_committed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSCFG_ROLLBACK_FAILED))
  gcv_object_t _object_Kerror_cluscfg_rollback_failed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSCFG_SYSTEM_DISK_DRIVE_LETTER_CONFLICT))
  gcv_object_t _object_Kerror_cluscfg_system_disk_drive_letter_conflict;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTERLOG_CHKPOINT_NOT_FOUND))
  gcv_object_t _object_Kerror_clusterlog_chkpoint_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTERLOG_CORRUPT))
  gcv_object_t _object_Kerror_clusterlog_corrupt;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTERLOG_EXCEEDS_MAXSIZE))
  gcv_object_t _object_Kerror_clusterlog_exceeds_maxsize;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTERLOG_NOT_ENOUGH_SPACE))
  gcv_object_t _object_Kerror_clusterlog_not_enough_space;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTERLOG_RECORD_EXCEEDS_MAXSIZE))
  gcv_object_t _object_Kerror_clusterlog_record_exceeds_maxsize;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_CANT_CREATE_DUP_CLUSTER_NAME))
  gcv_object_t _object_Kerror_cluster_cant_create_dup_cluster_name;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_DATABASE_SEQMISMATCH))
  gcv_object_t _object_Kerror_cluster_database_seqmismatch;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_EVICT_WITHOUT_CLEANUP))
  gcv_object_t _object_Kerror_cluster_evict_without_cleanup;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_GUM_NOT_LOCKER))
  gcv_object_t _object_Kerror_cluster_gum_not_locker;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_INCOMPATIBLE_VERSIONS))
  gcv_object_t _object_Kerror_cluster_incompatible_versions;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_INSTANCE_ID_MISMATCH))
  gcv_object_t _object_Kerror_cluster_instance_id_mismatch;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_INVALID_NETWORK))
  gcv_object_t _object_Kerror_cluster_invalid_network;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_INVALID_NETWORK_PROVIDER))
  gcv_object_t _object_Kerror_cluster_invalid_network_provider;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_INVALID_NODE))
  gcv_object_t _object_Kerror_cluster_invalid_node;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_INVALID_REQUEST))
  gcv_object_t _object_Kerror_cluster_invalid_request;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_IPADDR_IN_USE))
  gcv_object_t _object_Kerror_cluster_ipaddr_in_use;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_JOIN_ABORTED))
  gcv_object_t _object_Kerror_cluster_join_aborted;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_JOIN_IN_PROGRESS))
  gcv_object_t _object_Kerror_cluster_join_in_progress;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_JOIN_NOT_IN_PROGRESS))
  gcv_object_t _object_Kerror_cluster_join_not_in_progress;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_LAST_INTERNAL_NETWORK))
  gcv_object_t _object_Kerror_cluster_last_internal_network;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_LOCAL_NODE_NOT_FOUND))
  gcv_object_t _object_Kerror_cluster_local_node_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_MAXNUM_OF_RESOURCES_EXCEEDED))
  gcv_object_t _object_Kerror_cluster_maxnum_of_resources_exceeded;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_MEMBERSHIP_HALT))
  gcv_object_t _object_Kerror_cluster_membership_halt;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_MEMBERSHIP_INVALID_STATE))
  gcv_object_t _object_Kerror_cluster_membership_invalid_state;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_MISMATCHED_COMPUTER_ACCT_NAME))
  gcv_object_t _object_Kerror_cluster_mismatched_computer_acct_name;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_NETINTERFACE_EXISTS))
  gcv_object_t _object_Kerror_cluster_netinterface_exists;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_NETINTERFACE_NOT_FOUND))
  gcv_object_t _object_Kerror_cluster_netinterface_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_NETWORK_ALREADY_OFFLINE))
  gcv_object_t _object_Kerror_cluster_network_already_offline;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_NETWORK_ALREADY_ONLINE))
  gcv_object_t _object_Kerror_cluster_network_already_online;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_NETWORK_EXISTS))
  gcv_object_t _object_Kerror_cluster_network_exists;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_NETWORK_HAS_DEPENDENTS))
  gcv_object_t _object_Kerror_cluster_network_has_dependents;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_NETWORK_NOT_FOUND))
  gcv_object_t _object_Kerror_cluster_network_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_NETWORK_NOT_FOUND_FOR_IP))
  gcv_object_t _object_Kerror_cluster_network_not_found_for_ip;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_NETWORK_NOT_INTERNAL))
  gcv_object_t _object_Kerror_cluster_network_not_internal;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_NODE_ALREADY_DOWN))
  gcv_object_t _object_Kerror_cluster_node_already_down;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_NODE_ALREADY_HAS_DFS_ROOT))
  gcv_object_t _object_Kerror_cluster_node_already_has_dfs_root;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_NODE_ALREADY_MEMBER))
  gcv_object_t _object_Kerror_cluster_node_already_member;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_NODE_ALREADY_UP))
  gcv_object_t _object_Kerror_cluster_node_already_up;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_NODE_DOWN))
  gcv_object_t _object_Kerror_cluster_node_down;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_NODE_EXISTS))
  gcv_object_t _object_Kerror_cluster_node_exists;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_NODE_NOT_FOUND))
  gcv_object_t _object_Kerror_cluster_node_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_NODE_NOT_MEMBER))
  gcv_object_t _object_Kerror_cluster_node_not_member;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_NODE_NOT_PAUSED))
  gcv_object_t _object_Kerror_cluster_node_not_paused;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_NODE_NOT_READY))
  gcv_object_t _object_Kerror_cluster_node_not_ready;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_NODE_PAUSED))
  gcv_object_t _object_Kerror_cluster_node_paused;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_NODE_SHUTTING_DOWN))
  gcv_object_t _object_Kerror_cluster_node_shutting_down;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_NODE_UNREACHABLE))
  gcv_object_t _object_Kerror_cluster_node_unreachable;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_NODE_UP))
  gcv_object_t _object_Kerror_cluster_node_up;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_NO_RPC_PACKAGES_REGISTERED))
  gcv_object_t _object_Kerror_cluster_no_rpc_packages_registered;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_NO_SECURITY_CONTEXT))
  gcv_object_t _object_Kerror_cluster_no_security_context;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_OLD_VERSION))
  gcv_object_t _object_Kerror_cluster_old_version;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_OWNER_NOT_IN_PREFLIST))
  gcv_object_t _object_Kerror_cluster_owner_not_in_preflist;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_PARAMETER_MISMATCH))
  gcv_object_t _object_Kerror_cluster_parameter_mismatch;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_PROPERTY_DATA_TYPE_MISMATCH))
  gcv_object_t _object_Kerror_cluster_property_data_type_mismatch;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_QUORUMLOG_NOT_FOUND))
  gcv_object_t _object_Kerror_cluster_quorumlog_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_RESNAME_NOT_FOUND))
  gcv_object_t _object_Kerror_cluster_resname_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_RESOURCE_TYPE_NOT_FOUND))
  gcv_object_t _object_Kerror_cluster_resource_type_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_RESTYPE_NOT_SUPPORTED))
  gcv_object_t _object_Kerror_cluster_restype_not_supported;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_SHUTTING_DOWN))
  gcv_object_t _object_Kerror_cluster_shutting_down;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_SYSTEM_CONFIG_CHANGED))
  gcv_object_t _object_Kerror_cluster_system_config_changed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_WRONG_OS_VERSION))
  gcv_object_t _object_Kerror_cluster_wrong_os_version;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_COLORSPACE_MISMATCH))
  gcv_object_t _object_Kerror_colorspace_mismatch;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_COMMITMENT_LIMIT))
  gcv_object_t _object_Kerror_commitment_limit;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CONNECTED_OTHER_PASSWORD))
  gcv_object_t _object_Kerror_connected_other_password;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CONNECTED_OTHER_PASSWORD_DEFAULT))
  gcv_object_t _object_Kerror_connected_other_password_default;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CONNECTION_ABORTED))
  gcv_object_t _object_Kerror_connection_aborted;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CONNECTION_ACTIVE))
  gcv_object_t _object_Kerror_connection_active;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CONNECTION_COUNT_LIMIT))
  gcv_object_t _object_Kerror_connection_count_limit;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CONNECTION_INVALID))
  gcv_object_t _object_Kerror_connection_invalid;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CONNECTION_REFUSED))
  gcv_object_t _object_Kerror_connection_refused;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CONNECTION_UNAVAIL))
  gcv_object_t _object_Kerror_connection_unavail;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CONTEXT_EXPIRED))
  gcv_object_t _object_Kerror_context_expired;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CONTINUE))
  gcv_object_t _object_Kerror_continue;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CONTROLLING_IEPORT))
  gcv_object_t _object_Kerror_controlling_ieport;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CONTROL_ID_NOT_FOUND))
  gcv_object_t _object_Kerror_control_id_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CORE_RESOURCE))
  gcv_object_t _object_Kerror_core_resource;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_COUNTER_TIMEOUT))
  gcv_object_t _object_Kerror_counter_timeout;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CRC))
  gcv_object_t _object_Kerror_crc;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CREATE_FAILED))
  gcv_object_t _object_Kerror_create_failed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CSCSHARE_OFFLINE))
  gcv_object_t _object_Kerror_cscshare_offline;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_BAD_VIDEO_MODE))
  gcv_object_t _object_Kerror_ctx_bad_video_mode;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_CANNOT_MAKE_EVENTLOG_ENTRY))
  gcv_object_t _object_Kerror_ctx_cannot_make_eventlog_entry;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_CLIENT_LICENSE_IN_USE))
  gcv_object_t _object_Kerror_ctx_client_license_in_use;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_CLIENT_LICENSE_NOT_SET))
  gcv_object_t _object_Kerror_ctx_client_license_not_set;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_CLIENT_QUERY_TIMEOUT))
  gcv_object_t _object_Kerror_ctx_client_query_timeout;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_CLOSE_PENDING))
  gcv_object_t _object_Kerror_ctx_close_pending;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_CONSOLE_CONNECT))
  gcv_object_t _object_Kerror_ctx_console_connect;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_CONSOLE_DISCONNECT))
  gcv_object_t _object_Kerror_ctx_console_disconnect;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_GRAPHICS_INVALID))
  gcv_object_t _object_Kerror_ctx_graphics_invalid;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_INVALID_MODEMNAME))
  gcv_object_t _object_Kerror_ctx_invalid_modemname;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_INVALID_PD))
  gcv_object_t _object_Kerror_ctx_invalid_pd;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_INVALID_WD))
  gcv_object_t _object_Kerror_ctx_invalid_wd;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_LICENSE_CLIENT_INVALID))
  gcv_object_t _object_Kerror_ctx_license_client_invalid;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_LICENSE_EXPIRED))
  gcv_object_t _object_Kerror_ctx_license_expired;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_LICENSE_NOT_AVAILABLE))
  gcv_object_t _object_Kerror_ctx_license_not_available;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_LOGON_DISABLED))
  gcv_object_t _object_Kerror_ctx_logon_disabled;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_MODEM_INF_NOT_FOUND))
  gcv_object_t _object_Kerror_ctx_modem_inf_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_MODEM_RESPONSE_BUSY))
  gcv_object_t _object_Kerror_ctx_modem_response_busy;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_MODEM_RESPONSE_ERROR))
  gcv_object_t _object_Kerror_ctx_modem_response_error;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_MODEM_RESPONSE_NO_CARRIER))
  gcv_object_t _object_Kerror_ctx_modem_response_no_carrier;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_MODEM_RESPONSE_NO_DIALTONE))
  gcv_object_t _object_Kerror_ctx_modem_response_no_dialtone;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_MODEM_RESPONSE_TIMEOUT))
  gcv_object_t _object_Kerror_ctx_modem_response_timeout;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_MODEM_RESPONSE_VOICE))
  gcv_object_t _object_Kerror_ctx_modem_response_voice;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_NOT_CONSOLE))
  gcv_object_t _object_Kerror_ctx_not_console;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_NO_OUTBUF))
  gcv_object_t _object_Kerror_ctx_no_outbuf;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_PD_NOT_FOUND))
  gcv_object_t _object_Kerror_ctx_pd_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_SERVICE_NAME_COLLISION))
  gcv_object_t _object_Kerror_ctx_service_name_collision;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_SHADOW_DENIED))
  gcv_object_t _object_Kerror_ctx_shadow_denied;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_SHADOW_DISABLED))
  gcv_object_t _object_Kerror_ctx_shadow_disabled;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_SHADOW_ENDED_BY_MODE_CHANGE))
  gcv_object_t _object_Kerror_ctx_shadow_ended_by_mode_change;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_SHADOW_INVALID))
  gcv_object_t _object_Kerror_ctx_shadow_invalid;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_SHADOW_NOT_RUNNING))
  gcv_object_t _object_Kerror_ctx_shadow_not_running;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_TD_ERROR))
  gcv_object_t _object_Kerror_ctx_td_error;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_WD_NOT_FOUND))
  gcv_object_t _object_Kerror_ctx_wd_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_WINSTATION_ACCESS_DENIED))
  gcv_object_t _object_Kerror_ctx_winstation_access_denied;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_WINSTATION_ALREADY_EXISTS))
  gcv_object_t _object_Kerror_ctx_winstation_already_exists;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_WINSTATION_BUSY))
  gcv_object_t _object_Kerror_ctx_winstation_busy;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_WINSTATION_NAME_INVALID))
  gcv_object_t _object_Kerror_ctx_winstation_name_invalid;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_WINSTATION_NOT_FOUND))
  gcv_object_t _object_Kerror_ctx_winstation_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CURRENT_DIRECTORY))
  gcv_object_t _object_Kerror_current_directory;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CURRENT_DOMAIN_NOT_ALLOWED))
  gcv_object_t _object_Kerror_current_domain_not_allowed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DATABASE_BACKUP_CORRUPT))
  gcv_object_t _object_Kerror_database_backup_corrupt;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DATABASE_DOES_NOT_EXIST))
  gcv_object_t _object_Kerror_database_does_not_exist;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DATABASE_FAILURE))
  gcv_object_t _object_Kerror_database_failure;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DATABASE_FULL))
  gcv_object_t _object_Kerror_database_full;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DATATYPE_MISMATCH))
  gcv_object_t _object_Kerror_datatype_mismatch;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DC_NOT_FOUND))
  gcv_object_t _object_Kerror_dc_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DDE_FAIL))
  gcv_object_t _object_Kerror_dde_fail;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DEBUGGER_INACTIVE))
  gcv_object_t _object_Kerror_debugger_inactive;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DECRYPTION_FAILED))
  gcv_object_t _object_Kerror_decryption_failed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DELETE_PENDING))
  gcv_object_t _object_Kerror_delete_pending;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DELETING_ICM_XFORM))
  gcv_object_t _object_Kerror_deleting_icm_xform;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DEPENDENCY_ALREADY_EXISTS))
  gcv_object_t _object_Kerror_dependency_already_exists;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DEPENDENCY_NOT_ALLOWED))
  gcv_object_t _object_Kerror_dependency_not_allowed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DEPENDENCY_NOT_FOUND))
  gcv_object_t _object_Kerror_dependency_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DEPENDENT_RESOURCE_EXISTS))
  gcv_object_t _object_Kerror_dependent_resource_exists;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DEPENDENT_SERVICES_RUNNING))
  gcv_object_t _object_Kerror_dependent_services_running;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DESTINATION_ELEMENT_FULL))
  gcv_object_t _object_Kerror_destination_element_full;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DESTROY_OBJECT_OF_OTHER_THREAD))
  gcv_object_t _object_Kerror_destroy_object_of_other_thread;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DEVICE_ALREADY_REMEMBERED))
  gcv_object_t _object_Kerror_device_already_remembered;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DEVICE_DOOR_OPEN))
  gcv_object_t _object_Kerror_device_door_open;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DEVICE_IN_USE))
  gcv_object_t _object_Kerror_device_in_use;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DEVICE_NOT_AVAILABLE))
  gcv_object_t _object_Kerror_device_not_available;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DEVICE_NOT_CONNECTED))
  gcv_object_t _object_Kerror_device_not_connected;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DEVICE_NOT_PARTITIONED))
  gcv_object_t _object_Kerror_device_not_partitioned;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DEVICE_REINITIALIZATION_NEEDED))
  gcv_object_t _object_Kerror_device_reinitialization_needed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DEVICE_REMOVED))
  gcv_object_t _object_Kerror_device_removed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DEVICE_REQUIRES_CLEANING))
  gcv_object_t _object_Kerror_device_requires_cleaning;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DEV_NOT_EXIST))
  gcv_object_t _object_Kerror_dev_not_exist;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DHCP_ADDRESS_CONFLICT))
  gcv_object_t _object_Kerror_dhcp_address_conflict;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DIFFERENT_SERVICE_ACCOUNT))
  gcv_object_t _object_Kerror_different_service_account;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DIRECTORY))
  gcv_object_t _object_Kerror_directory;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DIRECT_ACCESS_HANDLE))
  gcv_object_t _object_Kerror_direct_access_handle;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DIR_EFS_DISALLOWED))
  gcv_object_t _object_Kerror_dir_efs_disallowed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DIR_NOT_EMPTY))
  gcv_object_t _object_Kerror_dir_not_empty;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DIR_NOT_ROOT))
  gcv_object_t _object_Kerror_dir_not_root;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DISCARDED))
  gcv_object_t _object_Kerror_discarded;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DISK_CHANGE))
  gcv_object_t _object_Kerror_disk_change;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DISK_CORRUPT))
  gcv_object_t _object_Kerror_disk_corrupt;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DISK_FULL))
  gcv_object_t _object_Kerror_disk_full;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DISK_OPERATION_FAILED))
  gcv_object_t _object_Kerror_disk_operation_failed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DISK_RECALIBRATE_FAILED))
  gcv_object_t _object_Kerror_disk_recalibrate_failed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DISK_RESET_FAILED))
  gcv_object_t _object_Kerror_disk_reset_failed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DISK_TOO_FRAGMENTED))
  gcv_object_t _object_Kerror_disk_too_fragmented;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DLL_INIT_FAILED))
  gcv_object_t _object_Kerror_dll_init_failed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DLL_NOT_FOUND))
  gcv_object_t _object_Kerror_dll_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DOMAIN_CONTROLLER_EXISTS))
  gcv_object_t _object_Kerror_domain_controller_exists;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DOMAIN_CONTROLLER_NOT_FOUND))
  gcv_object_t _object_Kerror_domain_controller_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DOMAIN_EXISTS))
  gcv_object_t _object_Kerror_domain_exists;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DOMAIN_LIMIT_EXCEEDED))
  gcv_object_t _object_Kerror_domain_limit_exceeded;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DOMAIN_TRUST_INCONSISTENT))
  gcv_object_t _object_Kerror_domain_trust_inconsistent;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DOWNGRADE_DETECTED))
  gcv_object_t _object_Kerror_downgrade_detected;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DRIVER_BLOCKED))
  gcv_object_t _object_Kerror_driver_blocked;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DRIVE_LOCKED))
  gcv_object_t _object_Kerror_drive_locked;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DRIVE_MEDIA_MISMATCH))
  gcv_object_t _object_Kerror_drive_media_mismatch;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_ADD_REPLICA_INHIBITED))
  gcv_object_t _object_Kerror_ds_add_replica_inhibited;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_ADMIN_LIMIT_EXCEEDED))
  gcv_object_t _object_Kerror_ds_admin_limit_exceeded;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_AFFECTS_MULTIPLE_DSAS))
  gcv_object_t _object_Kerror_ds_affects_multiple_dsas;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_AG_CANT_HAVE_UNIVERSAL_MEMBER))
  gcv_object_t _object_Kerror_ds_ag_cant_have_universal_member;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_ALIASED_OBJ_MISSING))
  gcv_object_t _object_Kerror_ds_aliased_obj_missing;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_ALIAS_DEREF_PROBLEM))
  gcv_object_t _object_Kerror_ds_alias_deref_problem;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_ALIAS_POINTS_TO_ALIAS))
  gcv_object_t _object_Kerror_ds_alias_points_to_alias;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_ALIAS_PROBLEM))
  gcv_object_t _object_Kerror_ds_alias_problem;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_ATTRIBUTE_OR_VALUE_EXISTS))
  gcv_object_t _object_Kerror_ds_attribute_or_value_exists;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_ATTRIBUTE_OWNED_BY_SAM))
  gcv_object_t _object_Kerror_ds_attribute_owned_by_sam;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_ATTRIBUTE_TYPE_UNDEFINED))
  gcv_object_t _object_Kerror_ds_attribute_type_undefined;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_ATT_ALREADY_EXISTS))
  gcv_object_t _object_Kerror_ds_att_already_exists;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_ATT_IS_NOT_ON_OBJ))
  gcv_object_t _object_Kerror_ds_att_is_not_on_obj;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_ATT_NOT_DEF_FOR_CLASS))
  gcv_object_t _object_Kerror_ds_att_not_def_for_class;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_ATT_NOT_DEF_IN_SCHEMA))
  gcv_object_t _object_Kerror_ds_att_not_def_in_schema;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_ATT_SCHEMA_REQ_ID))
  gcv_object_t _object_Kerror_ds_att_schema_req_id;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_ATT_SCHEMA_REQ_SYNTAX))
  gcv_object_t _object_Kerror_ds_att_schema_req_syntax;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_ATT_VAL_ALREADY_EXISTS))
  gcv_object_t _object_Kerror_ds_att_val_already_exists;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_AUTHORIZATION_FAILED))
  gcv_object_t _object_Kerror_ds_authorization_failed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_AUTH_METHOD_NOT_SUPPORTED))
  gcv_object_t _object_Kerror_ds_auth_method_not_supported;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_AUTH_UNKNOWN))
  gcv_object_t _object_Kerror_ds_auth_unknown;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_AUX_CLS_TEST_FAIL))
  gcv_object_t _object_Kerror_ds_aux_cls_test_fail;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_BACKLINK_WITHOUT_LINK))
  gcv_object_t _object_Kerror_ds_backlink_without_link;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_BAD_ATT_SCHEMA_SYNTAX))
  gcv_object_t _object_Kerror_ds_bad_att_schema_syntax;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_BAD_HIERARCHY_FILE))
  gcv_object_t _object_Kerror_ds_bad_hierarchy_file;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_BAD_INSTANCE_TYPE))
  gcv_object_t _object_Kerror_ds_bad_instance_type;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_BAD_NAME_SYNTAX))
  gcv_object_t _object_Kerror_ds_bad_name_syntax;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_BAD_RDN_ATT_ID_SYNTAX))
  gcv_object_t _object_Kerror_ds_bad_rdn_att_id_syntax;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_BUILD_HIERARCHY_TABLE_FAILED))
  gcv_object_t _object_Kerror_ds_build_hierarchy_table_failed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_BUSY))
  gcv_object_t _object_Kerror_ds_busy;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_ACCESS_REMOTE_PART_OF_AD))
  gcv_object_t _object_Kerror_ds_cant_access_remote_part_of_ad;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_ADD_ATT_VALUES))
  gcv_object_t _object_Kerror_ds_cant_add_att_values;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_ADD_SYSTEM_ONLY))
  gcv_object_t _object_Kerror_ds_cant_add_system_only;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_ADD_TO_GC))
  gcv_object_t _object_Kerror_ds_cant_add_to_gc;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_CACHE_ATT))
  gcv_object_t _object_Kerror_ds_cant_cache_att;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_CACHE_CLASS))
  gcv_object_t _object_Kerror_ds_cant_cache_class;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_CREATE_IN_NONDOMAIN_NC))
  gcv_object_t _object_Kerror_ds_cant_create_in_nondomain_nc;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_CREATE_UNDER_SCHEMA))
  gcv_object_t _object_Kerror_ds_cant_create_under_schema;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_DELETE))
  gcv_object_t _object_Kerror_ds_cant_delete;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_DELETE_DSA_OBJ))
  gcv_object_t _object_Kerror_ds_cant_delete_dsa_obj;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_DEL_MASTER_CROSSREF))
  gcv_object_t _object_Kerror_ds_cant_del_master_crossref;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_DEMOTE_WITH_WRITEABLE_NC))
  gcv_object_t _object_Kerror_ds_cant_demote_with_writeable_nc;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_DEREF_ALIAS))
  gcv_object_t _object_Kerror_ds_cant_deref_alias;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_DERIVE_SPN_FOR_DELETED_DOMAIN))
  gcv_object_t _object_Kerror_ds_cant_derive_spn_for_deleted_domain;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_DERIVE_SPN_WITHOUT_SERVER_REF))
  gcv_object_t _object_Kerror_ds_cant_derive_spn_without_server_ref;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_FIND_DC_FOR_SRC_DOMAIN))
  gcv_object_t _object_Kerror_ds_cant_find_dc_for_src_domain;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_FIND_DSA_OBJ))
  gcv_object_t _object_Kerror_ds_cant_find_dsa_obj;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_FIND_EXPECTED_NC))
  gcv_object_t _object_Kerror_ds_cant_find_expected_nc;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_FIND_NC_IN_CACHE))
  gcv_object_t _object_Kerror_ds_cant_find_nc_in_cache;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_MIX_MASTER_AND_REPS))
  gcv_object_t _object_Kerror_ds_cant_mix_master_and_reps;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_MOD_OBJ_CLASS))
  gcv_object_t _object_Kerror_ds_cant_mod_obj_class;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_MOD_PRIMARYGROUPID))
  gcv_object_t _object_Kerror_ds_cant_mod_primarygroupid;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_MOD_SYSTEM_ONLY))
  gcv_object_t _object_Kerror_ds_cant_mod_system_only;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_MOVE_ACCOUNT_GROUP))
  gcv_object_t _object_Kerror_ds_cant_move_account_group;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_MOVE_APP_BASIC_GROUP))
  gcv_object_t _object_Kerror_ds_cant_move_app_basic_group;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_MOVE_APP_QUERY_GROUP))
  gcv_object_t _object_Kerror_ds_cant_move_app_query_group;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_MOVE_DELETED_OBJECT))
  gcv_object_t _object_Kerror_ds_cant_move_deleted_object;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_MOVE_RESOURCE_GROUP))
  gcv_object_t _object_Kerror_ds_cant_move_resource_group;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_ON_NON_LEAF))
  gcv_object_t _object_Kerror_ds_cant_on_non_leaf;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_ON_RDN))
  gcv_object_t _object_Kerror_ds_cant_on_rdn;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_REMOVE_ATT_CACHE))
  gcv_object_t _object_Kerror_ds_cant_remove_att_cache;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_REMOVE_CLASS_CACHE))
  gcv_object_t _object_Kerror_ds_cant_remove_class_cache;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_REM_MISSING_ATT))
  gcv_object_t _object_Kerror_ds_cant_rem_missing_att;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_REM_MISSING_ATT_VAL))
  gcv_object_t _object_Kerror_ds_cant_rem_missing_att_val;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_REPLACE_HIDDEN_REC))
  gcv_object_t _object_Kerror_ds_cant_replace_hidden_rec;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_RETRIEVE_ATTS))
  gcv_object_t _object_Kerror_ds_cant_retrieve_atts;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_RETRIEVE_CHILD))
  gcv_object_t _object_Kerror_ds_cant_retrieve_child;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_RETRIEVE_DN))
  gcv_object_t _object_Kerror_ds_cant_retrieve_dn;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_RETRIEVE_INSTANCE))
  gcv_object_t _object_Kerror_ds_cant_retrieve_instance;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_RETRIEVE_SD))
  gcv_object_t _object_Kerror_ds_cant_retrieve_sd;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_START))
  gcv_object_t _object_Kerror_ds_cant_start;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_TREE_DELETE_CRITICAL_OBJ))
  gcv_object_t _object_Kerror_ds_cant_tree_delete_critical_obj;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_WITH_ACCT_GROUP_MEMBERSHPS))
  gcv_object_t _object_Kerror_ds_cant_with_acct_group_membershps;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CHILDREN_EXIST))
  gcv_object_t _object_Kerror_ds_children_exist;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CLASS_MUST_BE_CONCRETE))
  gcv_object_t _object_Kerror_ds_class_must_be_concrete;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CLASS_NOT_DSA))
  gcv_object_t _object_Kerror_ds_class_not_dsa;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CLIENT_LOOP))
  gcv_object_t _object_Kerror_ds_client_loop;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CODE_INCONSISTENCY))
  gcv_object_t _object_Kerror_ds_code_inconsistency;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_COMPARE_FALSE))
  gcv_object_t _object_Kerror_ds_compare_false;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_COMPARE_TRUE))
  gcv_object_t _object_Kerror_ds_compare_true;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CONFIDENTIALITY_REQUIRED))
  gcv_object_t _object_Kerror_ds_confidentiality_required;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CONFIG_PARAM_MISSING))
  gcv_object_t _object_Kerror_ds_config_param_missing;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CONSTRAINT_VIOLATION))
  gcv_object_t _object_Kerror_ds_constraint_violation;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CONSTRUCTED_ATT_MOD))
  gcv_object_t _object_Kerror_ds_constructed_att_mod;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CONTROL_NOT_FOUND))
  gcv_object_t _object_Kerror_ds_control_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_COULDNT_CONTACT_FSMO))
  gcv_object_t _object_Kerror_ds_couldnt_contact_fsmo;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_COULDNT_IDENTIFY_OBJECTS_FOR_TREE_DELETE))
  gcv_object_t _object_Kerror_ds_couldnt_identify_objects_for_tree_delete;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_COULDNT_LOCK_TREE_FOR_DELETE))
  gcv_object_t _object_Kerror_ds_couldnt_lock_tree_for_delete;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_COULDNT_UPDATE_SPNS))
  gcv_object_t _object_Kerror_ds_couldnt_update_spns;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_COUNTING_AB_INDICES_FAILED))
  gcv_object_t _object_Kerror_ds_counting_ab_indices_failed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CROSS_DOMAIN_CLEANUP_REQD))
  gcv_object_t _object_Kerror_ds_cross_domain_cleanup_reqd;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CROSS_DOM_MOVE_ERROR))
  gcv_object_t _object_Kerror_ds_cross_dom_move_error;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CROSS_NC_DN_RENAME))
  gcv_object_t _object_Kerror_ds_cross_nc_dn_rename;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CROSS_REF_BUSY))
  gcv_object_t _object_Kerror_ds_cross_ref_busy;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CROSS_REF_EXISTS))
  gcv_object_t _object_Kerror_ds_cross_ref_exists;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CR_IMPOSSIBLE_TO_VALIDATE))
  gcv_object_t _object_Kerror_ds_cr_impossible_to_validate;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CR_IMPOSSIBLE_TO_VALIDATE_V2))
  gcv_object_t _object_Kerror_ds_cr_impossible_to_validate_v2;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DATABASE_ERROR))
  gcv_object_t _object_Kerror_ds_database_error;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DECODING_ERROR))
  gcv_object_t _object_Kerror_ds_decoding_error;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DESTINATION_AUDITING_NOT_ENABLED))
  gcv_object_t _object_Kerror_ds_destination_auditing_not_enabled;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DESTINATION_DOMAIN_NOT_IN_FOREST))
  gcv_object_t _object_Kerror_ds_destination_domain_not_in_forest;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DIFFERENT_REPL_EPOCHS))
  gcv_object_t _object_Kerror_ds_different_repl_epochs;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DOMAIN_RENAME_IN_PROGRESS))
  gcv_object_t _object_Kerror_ds_domain_rename_in_progress;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DOMAIN_VERSION_TOO_HIGH))
  gcv_object_t _object_Kerror_ds_domain_version_too_high;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DOMAIN_VERSION_TOO_LOW))
  gcv_object_t _object_Kerror_ds_domain_version_too_low;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_ABANDON_SYNC))
  gcv_object_t _object_Kerror_ds_dra_abandon_sync;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_ACCESS_DENIED))
  gcv_object_t _object_Kerror_ds_dra_access_denied;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_BAD_DN))
  gcv_object_t _object_Kerror_ds_dra_bad_dn;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_BAD_INSTANCE_TYPE))
  gcv_object_t _object_Kerror_ds_dra_bad_instance_type;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_BAD_NC))
  gcv_object_t _object_Kerror_ds_dra_bad_nc;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_BUSY))
  gcv_object_t _object_Kerror_ds_dra_busy;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_CONNECTION_FAILED))
  gcv_object_t _object_Kerror_ds_dra_connection_failed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_DB_ERROR))
  gcv_object_t _object_Kerror_ds_dra_db_error;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_DN_EXISTS))
  gcv_object_t _object_Kerror_ds_dra_dn_exists;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_EARLIER_SCHEMA_CONLICT))
  gcv_object_t _object_Kerror_ds_dra_earlier_schema_conlict;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_EXTN_CONNECTION_FAILED))
  gcv_object_t _object_Kerror_ds_dra_extn_connection_failed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_GENERIC))
  gcv_object_t _object_Kerror_ds_dra_generic;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_INCOMPATIBLE_PARTIAL_SET))
  gcv_object_t _object_Kerror_ds_dra_incompatible_partial_set;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_INCONSISTENT_DIT))
  gcv_object_t _object_Kerror_ds_dra_inconsistent_dit;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_INTERNAL_ERROR))
  gcv_object_t _object_Kerror_ds_dra_internal_error;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_INVALID_PARAMETER))
  gcv_object_t _object_Kerror_ds_dra_invalid_parameter;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_MAIL_PROBLEM))
  gcv_object_t _object_Kerror_ds_dra_mail_problem;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_MISSING_PARENT))
  gcv_object_t _object_Kerror_ds_dra_missing_parent;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_NAME_COLLISION))
  gcv_object_t _object_Kerror_ds_dra_name_collision;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_NOT_SUPPORTED))
  gcv_object_t _object_Kerror_ds_dra_not_supported;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_NO_REPLICA))
  gcv_object_t _object_Kerror_ds_dra_no_replica;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_OBJ_IS_REP_SOURCE))
  gcv_object_t _object_Kerror_ds_dra_obj_is_rep_source;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_OBJ_NC_MISMATCH))
  gcv_object_t _object_Kerror_ds_dra_obj_nc_mismatch;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_OUT_OF_MEM))
  gcv_object_t _object_Kerror_ds_dra_out_of_mem;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_PREEMPTED))
  gcv_object_t _object_Kerror_ds_dra_preempted;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_REF_ALREADY_EXISTS))
  gcv_object_t _object_Kerror_ds_dra_ref_already_exists;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_REF_NOT_FOUND))
  gcv_object_t _object_Kerror_ds_dra_ref_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_REPL_PENDING))
  gcv_object_t _object_Kerror_ds_dra_repl_pending;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_RPC_CANCELLED))
  gcv_object_t _object_Kerror_ds_dra_rpc_cancelled;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_SCHEMA_CONFLICT))
  gcv_object_t _object_Kerror_ds_dra_schema_conflict;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_SCHEMA_INFO_SHIP))
  gcv_object_t _object_Kerror_ds_dra_schema_info_ship;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_SCHEMA_MISMATCH))
  gcv_object_t _object_Kerror_ds_dra_schema_mismatch;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_SHUTDOWN))
  gcv_object_t _object_Kerror_ds_dra_shutdown;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_SINK_DISABLED))
  gcv_object_t _object_Kerror_ds_dra_sink_disabled;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_SOURCE_DISABLED))
  gcv_object_t _object_Kerror_ds_dra_source_disabled;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_SOURCE_IS_PARTIAL_REPLICA))
  gcv_object_t _object_Kerror_ds_dra_source_is_partial_replica;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_SOURCE_REINSTALLED))
  gcv_object_t _object_Kerror_ds_dra_source_reinstalled;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRS_EXTENSIONS_CHANGED))
  gcv_object_t _object_Kerror_ds_drs_extensions_changed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DSA_MUST_BE_INT_MASTER))
  gcv_object_t _object_Kerror_ds_dsa_must_be_int_master;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DST_DOMAIN_NOT_NATIVE))
  gcv_object_t _object_Kerror_ds_dst_domain_not_native;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DST_NC_MISMATCH))
  gcv_object_t _object_Kerror_ds_dst_nc_mismatch;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DS_REQUIRED))
  gcv_object_t _object_Kerror_ds_ds_required;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DUPLICATE_ID_FOUND))
  gcv_object_t _object_Kerror_ds_duplicate_id_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DUP_LDAP_DISPLAY_NAME))
  gcv_object_t _object_Kerror_ds_dup_ldap_display_name;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DUP_LINK_ID))
  gcv_object_t _object_Kerror_ds_dup_link_id;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DUP_MAPI_ID))
  gcv_object_t _object_Kerror_ds_dup_mapi_id;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DUP_MSDS_INTID))
  gcv_object_t _object_Kerror_ds_dup_msds_intid;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DUP_OID))
  gcv_object_t _object_Kerror_ds_dup_oid;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DUP_RDN))
  gcv_object_t _object_Kerror_ds_dup_rdn;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DUP_SCHEMA_ID_GUID))
  gcv_object_t _object_Kerror_ds_dup_schema_id_guid;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_ENCODING_ERROR))
  gcv_object_t _object_Kerror_ds_encoding_error;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_EPOCH_MISMATCH))
  gcv_object_t _object_Kerror_ds_epoch_mismatch;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_EXISTING_AD_CHILD_NC))
  gcv_object_t _object_Kerror_ds_existing_ad_child_nc;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_EXISTS_IN_AUX_CLS))
  gcv_object_t _object_Kerror_ds_exists_in_aux_cls;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_EXISTS_IN_MAY_HAVE))
  gcv_object_t _object_Kerror_ds_exists_in_may_have;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_EXISTS_IN_MUST_HAVE))
  gcv_object_t _object_Kerror_ds_exists_in_must_have;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_EXISTS_IN_POSS_SUP))
  gcv_object_t _object_Kerror_ds_exists_in_poss_sup;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_EXISTS_IN_RDNATTID))
  gcv_object_t _object_Kerror_ds_exists_in_rdnattid;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_EXISTS_IN_SUB_CLS))
  gcv_object_t _object_Kerror_ds_exists_in_sub_cls;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_FILTER_UNKNOWN))
  gcv_object_t _object_Kerror_ds_filter_unknown;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_FILTER_USES_CONTRUCTED_ATTRS))
  gcv_object_t _object_Kerror_ds_filter_uses_contructed_attrs;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_FOREST_VERSION_TOO_HIGH))
  gcv_object_t _object_Kerror_ds_forest_version_too_high;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_FOREST_VERSION_TOO_LOW))
  gcv_object_t _object_Kerror_ds_forest_version_too_low;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_GCVERIFY_ERROR))
  gcv_object_t _object_Kerror_ds_gcverify_error;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_GC_NOT_AVAILABLE))
  gcv_object_t _object_Kerror_ds_gc_not_available;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_GC_REQUIRED))
  gcv_object_t _object_Kerror_ds_gc_required;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_GENERIC_ERROR))
  gcv_object_t _object_Kerror_ds_generic_error;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_GLOBAL_CANT_HAVE_CROSSDOMAIN_MEMBER))
  gcv_object_t _object_Kerror_ds_global_cant_have_crossdomain_member;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_GLOBAL_CANT_HAVE_LOCAL_MEMBER))
  gcv_object_t _object_Kerror_ds_global_cant_have_local_member;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_GLOBAL_CANT_HAVE_UNIVERSAL_MEMBER))
  gcv_object_t _object_Kerror_ds_global_cant_have_universal_member;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_GOVERNSID_MISSING))
  gcv_object_t _object_Kerror_ds_governsid_missing;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_GROUP_CONVERSION_ERROR))
  gcv_object_t _object_Kerror_ds_group_conversion_error;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_HAVE_PRIMARY_MEMBERS))
  gcv_object_t _object_Kerror_ds_have_primary_members;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_HIERARCHY_TABLE_MALLOC_FAILED))
  gcv_object_t _object_Kerror_ds_hierarchy_table_malloc_failed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_ILLEGAL_BASE_SCHEMA_MOD))
  gcv_object_t _object_Kerror_ds_illegal_base_schema_mod;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_ILLEGAL_MOD_OPERATION))
  gcv_object_t _object_Kerror_ds_illegal_mod_operation;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_ILLEGAL_SUPERIOR))
  gcv_object_t _object_Kerror_ds_illegal_superior;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_ILLEGAL_XDOM_MOVE_OPERATION))
  gcv_object_t _object_Kerror_ds_illegal_xdom_move_operation;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_INAPPROPRIATE_AUTH))
  gcv_object_t _object_Kerror_ds_inappropriate_auth;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_INAPPROPRIATE_MATCHING))
  gcv_object_t _object_Kerror_ds_inappropriate_matching;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_INCOMPATIBLE_CONTROLS_USED))
  gcv_object_t _object_Kerror_ds_incompatible_controls_used;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_INCOMPATIBLE_VERSION))
  gcv_object_t _object_Kerror_ds_incompatible_version;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_INCORRECT_ROLE_OWNER))
  gcv_object_t _object_Kerror_ds_incorrect_role_owner;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_INIT_FAILURE))
  gcv_object_t _object_Kerror_ds_init_failure;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_INIT_FAILURE_CONSOLE))
  gcv_object_t _object_Kerror_ds_init_failure_console;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_INSTALL_NO_SCH_VERSION_IN_INIFILE))
  gcv_object_t _object_Kerror_ds_install_no_sch_version_in_inifile;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_INSTALL_NO_SRC_SCH_VERSION))
  gcv_object_t _object_Kerror_ds_install_no_src_sch_version;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_INSTALL_SCHEMA_MISMATCH))
  gcv_object_t _object_Kerror_ds_install_schema_mismatch;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_INSUFFICIENT_ATTR_TO_CREATE_OBJECT))
  gcv_object_t _object_Kerror_ds_insufficient_attr_to_create_object;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_INSUFF_ACCESS_RIGHTS))
  gcv_object_t _object_Kerror_ds_insuff_access_rights;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_INTERNAL_FAILURE))
  gcv_object_t _object_Kerror_ds_internal_failure;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_INVALID_ATTRIBUTE_SYNTAX))
  gcv_object_t _object_Kerror_ds_invalid_attribute_syntax;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_INVALID_DMD))
  gcv_object_t _object_Kerror_ds_invalid_dmd;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_INVALID_DN_SYNTAX))
  gcv_object_t _object_Kerror_ds_invalid_dn_syntax;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_INVALID_GROUP_TYPE))
  gcv_object_t _object_Kerror_ds_invalid_group_type;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_INVALID_LDAP_DISPLAY_NAME))
  gcv_object_t _object_Kerror_ds_invalid_ldap_display_name;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_INVALID_NAME_FOR_SPN))
  gcv_object_t _object_Kerror_ds_invalid_name_for_spn;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_INVALID_ROLE_OWNER))
  gcv_object_t _object_Kerror_ds_invalid_role_owner;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_INVALID_SCRIPT))
  gcv_object_t _object_Kerror_ds_invalid_script;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_INVALID_SEARCH_FLAG))
  gcv_object_t _object_Kerror_ds_invalid_search_flag;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_IS_LEAF))
  gcv_object_t _object_Kerror_ds_is_leaf;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_KEY_NOT_UNIQUE))
  gcv_object_t _object_Kerror_ds_key_not_unique;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_LINK_ID_NOT_AVAILABLE))
  gcv_object_t _object_Kerror_ds_link_id_not_available;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_LOCAL_CANT_HAVE_CROSSDOMAIN_LOCAL_MEMBER))
  gcv_object_t _object_Kerror_ds_local_cant_have_crossdomain_local_member;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_LOCAL_ERROR))
  gcv_object_t _object_Kerror_ds_local_error;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_LOCAL_MEMBER_OF_LOCAL_ONLY))
  gcv_object_t _object_Kerror_ds_local_member_of_local_only;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_LOOKUP_FAILURE))
  gcv_object_t _object_Kerror_ds_lookup_failure;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_LOOP_DETECT))
  gcv_object_t _object_Kerror_ds_loop_detect;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_LOW_DSA_VERSION))
  gcv_object_t _object_Kerror_ds_low_dsa_version;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_MACHINE_ACCOUNT_CREATED_PRENT4))
  gcv_object_t _object_Kerror_ds_machine_account_created_prent4;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_MACHINE_ACCOUNT_QUOTA_EXCEEDED))
  gcv_object_t _object_Kerror_ds_machine_account_quota_exceeded;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_MASTERDSA_REQUIRED))
  gcv_object_t _object_Kerror_ds_masterdsa_required;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_MAX_OBJ_SIZE_EXCEEDED))
  gcv_object_t _object_Kerror_ds_max_obj_size_exceeded;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_MEMBERSHIP_EVALUATED_LOCALLY))
  gcv_object_t _object_Kerror_ds_membership_evaluated_locally;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_MISSING_EXPECTED_ATT))
  gcv_object_t _object_Kerror_ds_missing_expected_att;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_MISSING_FSMO_SETTINGS))
  gcv_object_t _object_Kerror_ds_missing_fsmo_settings;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_MISSING_INFRASTRUCTURE_CONTAINER))
  gcv_object_t _object_Kerror_ds_missing_infrastructure_container;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_MISSING_REQUIRED_ATT))
  gcv_object_t _object_Kerror_ds_missing_required_att;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_MISSING_SUPREF))
  gcv_object_t _object_Kerror_ds_missing_supref;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_MODIFYDN_DISALLOWED_BY_FLAG))
  gcv_object_t _object_Kerror_ds_modifydn_disallowed_by_flag;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_MODIFYDN_DISALLOWED_BY_INSTANCE_TYPE))
  gcv_object_t _object_Kerror_ds_modifydn_disallowed_by_instance_type;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_MODIFYDN_WRONG_GRANDPARENT))
  gcv_object_t _object_Kerror_ds_modifydn_wrong_grandparent;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_MUST_BE_RUN_ON_DST_DC))
  gcv_object_t _object_Kerror_ds_must_be_run_on_dst_dc;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NAME_ERROR_DOMAIN_ONLY))
  gcv_object_t _object_Kerror_ds_name_error_domain_only;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NAME_ERROR_NOT_FOUND))
  gcv_object_t _object_Kerror_ds_name_error_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NAME_ERROR_NOT_UNIQUE))
  gcv_object_t _object_Kerror_ds_name_error_not_unique;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NAME_ERROR_NO_MAPPING))
  gcv_object_t _object_Kerror_ds_name_error_no_mapping;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NAME_ERROR_NO_SYNTACTICAL_MAPPING))
  gcv_object_t _object_Kerror_ds_name_error_no_syntactical_mapping;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NAME_ERROR_RESOLVING))
  gcv_object_t _object_Kerror_ds_name_error_resolving;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NAME_ERROR_TRUST_REFERRAL))
  gcv_object_t _object_Kerror_ds_name_error_trust_referral;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NAME_NOT_UNIQUE))
  gcv_object_t _object_Kerror_ds_name_not_unique;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NAME_REFERENCE_INVALID))
  gcv_object_t _object_Kerror_ds_name_reference_invalid;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NAME_TOO_LONG))
  gcv_object_t _object_Kerror_ds_name_too_long;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NAME_TOO_MANY_PARTS))
  gcv_object_t _object_Kerror_ds_name_too_many_parts;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NAME_TYPE_UNKNOWN))
  gcv_object_t _object_Kerror_ds_name_type_unknown;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NAME_UNPARSEABLE))
  gcv_object_t _object_Kerror_ds_name_unparseable;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NAME_VALUE_TOO_LONG))
  gcv_object_t _object_Kerror_ds_name_value_too_long;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NAMING_MASTER_GC))
  gcv_object_t _object_Kerror_ds_naming_master_gc;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NAMING_VIOLATION))
  gcv_object_t _object_Kerror_ds_naming_violation;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NCNAME_MISSING_CR_REF))
  gcv_object_t _object_Kerror_ds_ncname_missing_cr_ref;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NCNAME_MUST_BE_NC))
  gcv_object_t _object_Kerror_ds_ncname_must_be_nc;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NC_MUST_HAVE_NC_PARENT))
  gcv_object_t _object_Kerror_ds_nc_must_have_nc_parent;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NC_STILL_HAS_DSAS))
  gcv_object_t _object_Kerror_ds_nc_still_has_dsas;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NONEXISTENT_MAY_HAVE))
  gcv_object_t _object_Kerror_ds_nonexistent_may_have;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NONEXISTENT_MUST_HAVE))
  gcv_object_t _object_Kerror_ds_nonexistent_must_have;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NONEXISTENT_POSS_SUP))
  gcv_object_t _object_Kerror_ds_nonexistent_poss_sup;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NONSAFE_SCHEMA_CHANGE))
  gcv_object_t _object_Kerror_ds_nonsafe_schema_change;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NON_BASE_SEARCH))
  gcv_object_t _object_Kerror_ds_non_base_search;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NOTIFY_FILTER_TOO_COMPLEX))
  gcv_object_t _object_Kerror_ds_notify_filter_too_complex;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NOT_AN_OBJECT))
  gcv_object_t _object_Kerror_ds_not_an_object;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NOT_AUTHORITIVE_FOR_DST_NC))
  gcv_object_t _object_Kerror_ds_not_authoritive_for_dst_nc;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NOT_CLOSEST))
  gcv_object_t _object_Kerror_ds_not_closest;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NOT_INSTALLED))
  gcv_object_t _object_Kerror_ds_not_installed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NOT_ON_BACKLINK))
  gcv_object_t _object_Kerror_ds_not_on_backlink;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NOT_SUPPORTED))
  gcv_object_t _object_Kerror_ds_not_supported;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NOT_SUPPORTED_SORT_ORDER))
  gcv_object_t _object_Kerror_ds_not_supported_sort_order;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NO_ATTRIBUTE_OR_VALUE))
  gcv_object_t _object_Kerror_ds_no_attribute_or_value;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NO_BEHAVIOR_VERSION_IN_MIXEDDOMAIN))
  gcv_object_t _object_Kerror_ds_no_behavior_version_in_mixeddomain;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NO_CHAINED_EVAL))
  gcv_object_t _object_Kerror_ds_no_chained_eval;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NO_CHAINING))
  gcv_object_t _object_Kerror_ds_no_chaining;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NO_CHECKPOINT_WITH_PDC))
  gcv_object_t _object_Kerror_ds_no_checkpoint_with_pdc;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NO_CROSSREF_FOR_NC))
  gcv_object_t _object_Kerror_ds_no_crossref_for_nc;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NO_DELETED_NAME))
  gcv_object_t _object_Kerror_ds_no_deleted_name;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NO_FPO_IN_UNIVERSAL_GROUPS))
  gcv_object_t _object_Kerror_ds_no_fpo_in_universal_groups;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NO_MORE_RIDS))
  gcv_object_t _object_Kerror_ds_no_more_rids;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NO_MSDS_INTID))
  gcv_object_t _object_Kerror_ds_no_msds_intid;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NO_NEST_GLOBALGROUP_IN_MIXEDDOMAIN))
  gcv_object_t _object_Kerror_ds_no_nest_globalgroup_in_mixeddomain;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NO_NEST_LOCALGROUP_IN_MIXEDDOMAIN))
  gcv_object_t _object_Kerror_ds_no_nest_localgroup_in_mixeddomain;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NO_OBJECT_MOVE_IN_SCHEMA_NC))
  gcv_object_t _object_Kerror_ds_no_object_move_in_schema_nc;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NO_PARENT_OBJECT))
  gcv_object_t _object_Kerror_ds_no_parent_object;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NO_PKT_PRIVACY_ON_CONNECTION))
  gcv_object_t _object_Kerror_ds_no_pkt_privacy_on_connection;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NO_RDN_DEFINED_IN_SCHEMA))
  gcv_object_t _object_Kerror_ds_no_rdn_defined_in_schema;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NO_REF_DOMAIN))
  gcv_object_t _object_Kerror_ds_no_ref_domain;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NO_REQUESTED_ATTS_FOUND))
  gcv_object_t _object_Kerror_ds_no_requested_atts_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NO_RESULTS_RETURNED))
  gcv_object_t _object_Kerror_ds_no_results_returned;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NO_RIDS_ALLOCATED))
  gcv_object_t _object_Kerror_ds_no_rids_allocated;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NO_SUCH_OBJECT))
  gcv_object_t _object_Kerror_ds_no_such_object;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NO_TREE_DELETE_ABOVE_NC))
  gcv_object_t _object_Kerror_ds_no_tree_delete_above_nc;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NTDSCRIPT_PROCESS_ERROR))
  gcv_object_t _object_Kerror_ds_ntdscript_process_error;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NTDSCRIPT_SYNTAX_ERROR))
  gcv_object_t _object_Kerror_ds_ntdscript_syntax_error;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_OBJECT_BEING_REMOVED))
  gcv_object_t _object_Kerror_ds_object_being_removed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_OBJECT_CLASS_REQUIRED))
  gcv_object_t _object_Kerror_ds_object_class_required;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_OBJECT_RESULTS_TOO_LARGE))
  gcv_object_t _object_Kerror_ds_object_results_too_large;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_OBJ_CLASS_NOT_DEFINED))
  gcv_object_t _object_Kerror_ds_obj_class_not_defined;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_OBJ_CLASS_NOT_SUBCLASS))
  gcv_object_t _object_Kerror_ds_obj_class_not_subclass;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_OBJ_CLASS_VIOLATION))
  gcv_object_t _object_Kerror_ds_obj_class_violation;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_OBJ_GUID_EXISTS))
  gcv_object_t _object_Kerror_ds_obj_guid_exists;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_OBJ_NOT_FOUND))
  gcv_object_t _object_Kerror_ds_obj_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_OBJ_STRING_NAME_EXISTS))
  gcv_object_t _object_Kerror_ds_obj_string_name_exists;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_OBJ_TOO_LARGE))
  gcv_object_t _object_Kerror_ds_obj_too_large;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_OFFSET_RANGE_ERROR))
  gcv_object_t _object_Kerror_ds_offset_range_error;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_OPERATIONS_ERROR))
  gcv_object_t _object_Kerror_ds_operations_error;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_OUT_OF_SCOPE))
  gcv_object_t _object_Kerror_ds_out_of_scope;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_OUT_OF_VERSION_STORE))
  gcv_object_t _object_Kerror_ds_out_of_version_store;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_PARAM_ERROR))
  gcv_object_t _object_Kerror_ds_param_error;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_PARENT_IS_AN_ALIAS))
  gcv_object_t _object_Kerror_ds_parent_is_an_alias;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_PDC_OPERATION_IN_PROGRESS))
  gcv_object_t _object_Kerror_ds_pdc_operation_in_progress;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_PROTOCOL_ERROR))
  gcv_object_t _object_Kerror_ds_protocol_error;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_RANGE_CONSTRAINT))
  gcv_object_t _object_Kerror_ds_range_constraint;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_RDN_DOESNT_MATCH_SCHEMA))
  gcv_object_t _object_Kerror_ds_rdn_doesnt_match_schema;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_RECALCSCHEMA_FAILED))
  gcv_object_t _object_Kerror_ds_recalcschema_failed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_REFERRAL))
  gcv_object_t _object_Kerror_ds_referral;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_REFERRAL_LIMIT_EXCEEDED))
  gcv_object_t _object_Kerror_ds_referral_limit_exceeded;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_REFUSING_FSMO_ROLES))
  gcv_object_t _object_Kerror_ds_refusing_fsmo_roles;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_REMOTE_CROSSREF_OP_FAILED))
  gcv_object_t _object_Kerror_ds_remote_crossref_op_failed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_REPLICATOR_ONLY))
  gcv_object_t _object_Kerror_ds_replicator_only;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_REPLICA_SET_CHANGE_NOT_ALLOWED_ON_DISABLED_CR))
  gcv_object_t _object_Kerror_ds_replica_set_change_not_allowed_on_disabled_cr;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_RESERVED_LINK_ID))
  gcv_object_t _object_Kerror_ds_reserved_link_id;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_RIDMGR_INIT_ERROR))
  gcv_object_t _object_Kerror_ds_ridmgr_init_error;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_ROLE_NOT_VERIFIED))
  gcv_object_t _object_Kerror_ds_role_not_verified;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_ROOT_CANT_BE_SUBREF))
  gcv_object_t _object_Kerror_ds_root_cant_be_subref;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_ROOT_MUST_BE_NC))
  gcv_object_t _object_Kerror_ds_root_must_be_nc;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_ROOT_REQUIRES_CLASS_TOP))
  gcv_object_t _object_Kerror_ds_root_requires_class_top;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_SAM_INIT_FAILURE))
  gcv_object_t _object_Kerror_ds_sam_init_failure;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_SAM_INIT_FAILURE_CONSOLE))
  gcv_object_t _object_Kerror_ds_sam_init_failure_console;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_SAM_NEED_BOOTKEY_FLOPPY))
  gcv_object_t _object_Kerror_ds_sam_need_bootkey_floppy;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_SAM_NEED_BOOTKEY_PASSWORD))
  gcv_object_t _object_Kerror_ds_sam_need_bootkey_password;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_SCHEMA_ALLOC_FAILED))
  gcv_object_t _object_Kerror_ds_schema_alloc_failed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_SCHEMA_NOT_LOADED))
  gcv_object_t _object_Kerror_ds_schema_not_loaded;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_SCHEMA_UPDATE_DISALLOWED))
  gcv_object_t _object_Kerror_ds_schema_update_disallowed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_SECURITY_CHECKING_ERROR))
  gcv_object_t _object_Kerror_ds_security_checking_error;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_SECURITY_ILLEGAL_MODIFY))
  gcv_object_t _object_Kerror_ds_security_illegal_modify;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_SEC_DESC_INVALID))
  gcv_object_t _object_Kerror_ds_sec_desc_invalid;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_SEC_DESC_TOO_SHORT))
  gcv_object_t _object_Kerror_ds_sec_desc_too_short;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_SEMANTIC_ATT_TEST))
  gcv_object_t _object_Kerror_ds_semantic_att_test;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_SENSITIVE_GROUP_VIOLATION))
  gcv_object_t _object_Kerror_ds_sensitive_group_violation;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_SERVER_DOWN))
  gcv_object_t _object_Kerror_ds_server_down;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_SHUTTING_DOWN))
  gcv_object_t _object_Kerror_ds_shutting_down;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_SINGLE_USER_MODE_FAILED))
  gcv_object_t _object_Kerror_ds_single_user_mode_failed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_SINGLE_VALUE_CONSTRAINT))
  gcv_object_t _object_Kerror_ds_single_value_constraint;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_SIZELIMIT_EXCEEDED))
  gcv_object_t _object_Kerror_ds_sizelimit_exceeded;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_SORT_CONTROL_MISSING))
  gcv_object_t _object_Kerror_ds_sort_control_missing;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_SOURCE_AUDITING_NOT_ENABLED))
  gcv_object_t _object_Kerror_ds_source_auditing_not_enabled;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_SOURCE_DOMAIN_IN_FOREST))
  gcv_object_t _object_Kerror_ds_source_domain_in_forest;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_SRC_AND_DST_NC_IDENTICAL))
  gcv_object_t _object_Kerror_ds_src_and_dst_nc_identical;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_SRC_AND_DST_OBJECT_CLASS_MISMATCH))
  gcv_object_t _object_Kerror_ds_src_and_dst_object_class_mismatch;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_SRC_DC_MUST_BE_SP4_OR_GREATER))
  gcv_object_t _object_Kerror_ds_src_dc_must_be_sp4_or_greater;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_SRC_GUID_MISMATCH))
  gcv_object_t _object_Kerror_ds_src_guid_mismatch;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_SRC_NAME_MISMATCH))
  gcv_object_t _object_Kerror_ds_src_name_mismatch;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_SRC_OBJ_NOT_GROUP_OR_USER))
  gcv_object_t _object_Kerror_ds_src_obj_not_group_or_user;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_SRC_SID_EXISTS_IN_FOREST))
  gcv_object_t _object_Kerror_ds_src_sid_exists_in_forest;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_STRING_SD_CONVERSION_FAILED))
  gcv_object_t _object_Kerror_ds_string_sd_conversion_failed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_STRONG_AUTH_REQUIRED))
  gcv_object_t _object_Kerror_ds_strong_auth_required;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_SUBREF_MUST_HAVE_PARENT))
  gcv_object_t _object_Kerror_ds_subref_must_have_parent;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_SUBTREE_NOTIFY_NOT_NC_HEAD))
  gcv_object_t _object_Kerror_ds_subtree_notify_not_nc_head;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_SUB_CLS_TEST_FAIL))
  gcv_object_t _object_Kerror_ds_sub_cls_test_fail;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_SYNTAX_MISMATCH))
  gcv_object_t _object_Kerror_ds_syntax_mismatch;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_THREAD_LIMIT_EXCEEDED))
  gcv_object_t _object_Kerror_ds_thread_limit_exceeded;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_TIMELIMIT_EXCEEDED))
  gcv_object_t _object_Kerror_ds_timelimit_exceeded;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_TREE_DELETE_NOT_FINISHED))
  gcv_object_t _object_Kerror_ds_tree_delete_not_finished;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_UNABLE_TO_SURRENDER_ROLES))
  gcv_object_t _object_Kerror_ds_unable_to_surrender_roles;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_UNAVAILABLE))
  gcv_object_t _object_Kerror_ds_unavailable;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_UNAVAILABLE_CRIT_EXTENSION))
  gcv_object_t _object_Kerror_ds_unavailable_crit_extension;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_UNICODEPWD_NOT_IN_QUOTES))
  gcv_object_t _object_Kerror_ds_unicodepwd_not_in_quotes;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_UNIVERSAL_CANT_HAVE_LOCAL_MEMBER))
  gcv_object_t _object_Kerror_ds_universal_cant_have_local_member;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_UNKNOWN_ERROR))
  gcv_object_t _object_Kerror_ds_unknown_error;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_UNKNOWN_OPERATION))
  gcv_object_t _object_Kerror_ds_unknown_operation;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_UNWILLING_TO_PERFORM))
  gcv_object_t _object_Kerror_ds_unwilling_to_perform;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_USER_BUFFER_TO_SMALL))
  gcv_object_t _object_Kerror_ds_user_buffer_to_small;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_WKO_CONTAINER_CANNOT_BE_SPECIAL))
  gcv_object_t _object_Kerror_ds_wko_container_cannot_be_special;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_WRONG_LINKED_ATT_SYNTAX))
  gcv_object_t _object_Kerror_ds_wrong_linked_att_syntax;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_WRONG_OM_OBJ_CLASS))
  gcv_object_t _object_Kerror_ds_wrong_om_obj_class;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DUPLICATE_SERVICE_NAME))
  gcv_object_t _object_Kerror_duplicate_service_name;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DUPLICATE_TAG))
  gcv_object_t _object_Kerror_duplicate_tag;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DUP_DOMAINNAME))
  gcv_object_t _object_Kerror_dup_domainname;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DUP_NAME))
  gcv_object_t _object_Kerror_dup_name;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DYNLINK_FROM_INVALID_RING))
  gcv_object_t _object_Kerror_dynlink_from_invalid_ring;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_EAS_DIDNT_FIT))
  gcv_object_t _object_Kerror_eas_didnt_fit;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_EAS_NOT_SUPPORTED))
  gcv_object_t _object_Kerror_eas_not_supported;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_EA_ACCESS_DENIED))
  gcv_object_t _object_Kerror_ea_access_denied;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_EA_FILE_CORRUPT))
  gcv_object_t _object_Kerror_ea_file_corrupt;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_EA_LIST_INCONSISTENT))
  gcv_object_t _object_Kerror_ea_list_inconsistent;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_EA_TABLE_FULL))
  gcv_object_t _object_Kerror_ea_table_full;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_EFS_ALG_BLOB_TOO_BIG))
  gcv_object_t _object_Kerror_efs_alg_blob_too_big;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_EFS_DISABLED))
  gcv_object_t _object_Kerror_efs_disabled;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_EFS_SERVER_NOT_TRUSTED))
  gcv_object_t _object_Kerror_efs_server_not_trusted;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_EFS_VERSION_NOT_SUPPORT))
  gcv_object_t _object_Kerror_efs_version_not_support;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_EMPTY))
  gcv_object_t _object_Kerror_empty;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ENCRYPTION_FAILED))
  gcv_object_t _object_Kerror_encryption_failed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_END_OF_MEDIA))
  gcv_object_t _object_Kerror_end_of_media;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ENVVAR_NOT_FOUND))
  gcv_object_t _object_Kerror_envvar_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_EOM_OVERFLOW))
  gcv_object_t _object_Kerror_eom_overflow;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_EVENTLOG_CANT_START))
  gcv_object_t _object_Kerror_eventlog_cant_start;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_EVENTLOG_FILE_CHANGED))
  gcv_object_t _object_Kerror_eventlog_file_changed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_EVENTLOG_FILE_CORRUPT))
  gcv_object_t _object_Kerror_eventlog_file_corrupt;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_EXCEPTION_IN_SERVICE))
  gcv_object_t _object_Kerror_exception_in_service;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_EXCL_SEM_ALREADY_OWNED))
  gcv_object_t _object_Kerror_excl_sem_already_owned;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_EXE_CANNOT_MODIFY_SIGNED_BINARY))
  gcv_object_t _object_Kerror_exe_cannot_modify_signed_binary;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_EXE_CANNOT_MODIFY_STRONG_SIGNED_BINARY))
  gcv_object_t _object_Kerror_exe_cannot_modify_strong_signed_binary;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_EXE_MACHINE_TYPE_MISMATCH))
  gcv_object_t _object_Kerror_exe_machine_type_mismatch;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_EXE_MARKED_INVALID))
  gcv_object_t _object_Kerror_exe_marked_invalid;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_EXTENDED_ERROR))
  gcv_object_t _object_Kerror_extended_error;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_FAILED_SERVICE_CONTROLLER_CONNECT))
  gcv_object_t _object_Kerror_failed_service_controller_connect;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_FAIL_I24))
  gcv_object_t _object_Kerror_fail_i24;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_FILEMARK_DETECTED))
  gcv_object_t _object_Kerror_filemark_detected;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_FILENAME_EXCED_RANGE))
  gcv_object_t _object_Kerror_filename_exced_range;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_FILE_CORRUPT))
  gcv_object_t _object_Kerror_file_corrupt;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_FILE_ENCRYPTED))
  gcv_object_t _object_Kerror_file_encrypted;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_FILE_EXISTS))
  gcv_object_t _object_Kerror_file_exists;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_FILE_INVALID))
  gcv_object_t _object_Kerror_file_invalid;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_FILE_NOT_ENCRYPTED))
  gcv_object_t _object_Kerror_file_not_encrypted;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_FILE_NOT_FOUND))
  gcv_object_t _object_Kerror_file_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_FILE_OFFLINE))
  gcv_object_t _object_Kerror_file_offline;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_FILE_READ_ONLY))
  gcv_object_t _object_Kerror_file_read_only;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_FLOPPY_BAD_REGISTERS))
  gcv_object_t _object_Kerror_floppy_bad_registers;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_FLOPPY_ID_MARK_NOT_FOUND))
  gcv_object_t _object_Kerror_floppy_id_mark_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_FLOPPY_UNKNOWN_ERROR))
  gcv_object_t _object_Kerror_floppy_unknown_error;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_FLOPPY_WRONG_CYLINDER))
  gcv_object_t _object_Kerror_floppy_wrong_cylinder;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_FULLSCREEN_MODE))
  gcv_object_t _object_Kerror_fullscreen_mode;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_FULL_BACKUP))
  gcv_object_t _object_Kerror_full_backup;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_FUNCTION_FAILED))
  gcv_object_t _object_Kerror_function_failed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_FUNCTION_NOT_CALLED))
  gcv_object_t _object_Kerror_function_not_called;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_GENERIC_NOT_MAPPED))
  gcv_object_t _object_Kerror_generic_not_mapped;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_GEN_FAILURE))
  gcv_object_t _object_Kerror_gen_failure;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_GLOBAL_ONLY_HOOK))
  gcv_object_t _object_Kerror_global_only_hook;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_GRACEFUL_DISCONNECT))
  gcv_object_t _object_Kerror_graceful_disconnect;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_GROUP_EXISTS))
  gcv_object_t _object_Kerror_group_exists;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_GROUP_NOT_AVAILABLE))
  gcv_object_t _object_Kerror_group_not_available;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_GROUP_NOT_FOUND))
  gcv_object_t _object_Kerror_group_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_GROUP_NOT_ONLINE))
  gcv_object_t _object_Kerror_group_not_online;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_HANDLE_DISK_FULL))
  gcv_object_t _object_Kerror_handle_disk_full;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_HANDLE_EOF))
  gcv_object_t _object_Kerror_handle_eof;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_HOOK_NEEDS_HMOD))
  gcv_object_t _object_Kerror_hook_needs_hmod;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_HOOK_NOT_INSTALLED))
  gcv_object_t _object_Kerror_hook_not_installed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_HOOK_TYPE_NOT_ALLOWED))
  gcv_object_t _object_Kerror_hook_type_not_allowed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_HOST_DOWN))
  gcv_object_t _object_Kerror_host_down;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_HOST_NODE_NOT_AVAILABLE))
  gcv_object_t _object_Kerror_host_node_not_available;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_HOST_NODE_NOT_GROUP_OWNER))
  gcv_object_t _object_Kerror_host_node_not_group_owner;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_HOST_NODE_NOT_RESOURCE_OWNER))
  gcv_object_t _object_Kerror_host_node_not_resource_owner;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_HOST_UNREACHABLE))
  gcv_object_t _object_Kerror_host_unreachable;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_HOTKEY_ALREADY_REGISTERED))
  gcv_object_t _object_Kerror_hotkey_already_registered;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_HOTKEY_NOT_REGISTERED))
  gcv_object_t _object_Kerror_hotkey_not_registered;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_HWNDS_HAVE_DIFF_PARENT))
  gcv_object_t _object_Kerror_hwnds_have_diff_parent;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ICM_NOT_ENABLED))
  gcv_object_t _object_Kerror_icm_not_enabled;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ILLEGAL_ELEMENT_ADDRESS))
  gcv_object_t _object_Kerror_illegal_element_address;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ILL_FORMED_PASSWORD))
  gcv_object_t _object_Kerror_ill_formed_password;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INCORRECT_ADDRESS))
  gcv_object_t _object_Kerror_incorrect_address;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INC_BACKUP))
  gcv_object_t _object_Kerror_inc_backup;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INDEX_ABSENT))
  gcv_object_t _object_Kerror_index_absent;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INDIGENOUS_TYPE))
  gcv_object_t _object_Kerror_indigenous_type;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INFLOOP_IN_RELOC_CHAIN))
  gcv_object_t _object_Kerror_infloop_in_reloc_chain;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INSTALL_ALREADY_RUNNING))
  gcv_object_t _object_Kerror_install_already_running;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INSTALL_FAILURE))
  gcv_object_t _object_Kerror_install_failure;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INSTALL_LANGUAGE_UNSUPPORTED))
  gcv_object_t _object_Kerror_install_language_unsupported;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INSTALL_LOG_FAILURE))
  gcv_object_t _object_Kerror_install_log_failure;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INSTALL_NOTUSED))
  gcv_object_t _object_Kerror_install_notused;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INSTALL_PACKAGE_INVALID))
  gcv_object_t _object_Kerror_install_package_invalid;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INSTALL_PACKAGE_OPEN_FAILED))
  gcv_object_t _object_Kerror_install_package_open_failed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INSTALL_PACKAGE_REJECTED))
  gcv_object_t _object_Kerror_install_package_rejected;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INSTALL_PACKAGE_VERSION))
  gcv_object_t _object_Kerror_install_package_version;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INSTALL_PLATFORM_UNSUPPORTED))
  gcv_object_t _object_Kerror_install_platform_unsupported;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INSTALL_REMOTE_DISALLOWED))
  gcv_object_t _object_Kerror_install_remote_disallowed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INSTALL_REMOTE_PROHIBITED))
  gcv_object_t _object_Kerror_install_remote_prohibited;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INSTALL_SERVICE_FAILURE))
  gcv_object_t _object_Kerror_install_service_failure;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INSTALL_SOURCE_ABSENT))
  gcv_object_t _object_Kerror_install_source_absent;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INSTALL_SUSPEND))
  gcv_object_t _object_Kerror_install_suspend;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INSTALL_TEMP_UNWRITABLE))
  gcv_object_t _object_Kerror_install_temp_unwritable;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INSTALL_TRANSFORM_FAILURE))
  gcv_object_t _object_Kerror_install_transform_failure;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INSTALL_TRANSFORM_REJECTED))
  gcv_object_t _object_Kerror_install_transform_rejected;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INSTALL_UI_FAILURE))
  gcv_object_t _object_Kerror_install_ui_failure;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INSTALL_USEREXIT))
  gcv_object_t _object_Kerror_install_userexit;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INSUFFICIENT_BUFFER))
  gcv_object_t _object_Kerror_insufficient_buffer;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INTERNAL_DB_CORRUPTION))
  gcv_object_t _object_Kerror_internal_db_corruption;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INTERNAL_DB_ERROR))
  gcv_object_t _object_Kerror_internal_db_error;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INTERNAL_ERROR))
  gcv_object_t _object_Kerror_internal_error;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_ACCEL_HANDLE))
  gcv_object_t _object_Kerror_invalid_accel_handle;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_ACCESS))
  gcv_object_t _object_Kerror_invalid_access;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_ACCOUNT_NAME))
  gcv_object_t _object_Kerror_invalid_account_name;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_ACL))
  gcv_object_t _object_Kerror_invalid_acl;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_ADDRESS))
  gcv_object_t _object_Kerror_invalid_address;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_AT_INTERRUPT_TIME))
  gcv_object_t _object_Kerror_invalid_at_interrupt_time;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_BLOCK))
  gcv_object_t _object_Kerror_invalid_block;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_BLOCK_LENGTH))
  gcv_object_t _object_Kerror_invalid_block_length;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_CATEGORY))
  gcv_object_t _object_Kerror_invalid_category;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_CLEANER))
  gcv_object_t _object_Kerror_invalid_cleaner;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_CMM))
  gcv_object_t _object_Kerror_invalid_cmm;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_COLORINDEX))
  gcv_object_t _object_Kerror_invalid_colorindex;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_COLORSPACE))
  gcv_object_t _object_Kerror_invalid_colorspace;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_COMBOBOX_MESSAGE))
  gcv_object_t _object_Kerror_invalid_combobox_message;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_COMMAND_LINE))
  gcv_object_t _object_Kerror_invalid_command_line;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_COMPUTERNAME))
  gcv_object_t _object_Kerror_invalid_computername;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_CURSOR_HANDLE))
  gcv_object_t _object_Kerror_invalid_cursor_handle;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_DATA))
  gcv_object_t _object_Kerror_invalid_data;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_DATATYPE))
  gcv_object_t _object_Kerror_invalid_datatype;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_DLL))
  gcv_object_t _object_Kerror_invalid_dll;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_DOMAINNAME))
  gcv_object_t _object_Kerror_invalid_domainname;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_DOMAIN_ROLE))
  gcv_object_t _object_Kerror_invalid_domain_role;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_DOMAIN_STATE))
  gcv_object_t _object_Kerror_invalid_domain_state;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_DRIVE))
  gcv_object_t _object_Kerror_invalid_drive;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_DRIVE_OBJECT))
  gcv_object_t _object_Kerror_invalid_drive_object;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_DWP_HANDLE))
  gcv_object_t _object_Kerror_invalid_dwp_handle;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_EA_HANDLE))
  gcv_object_t _object_Kerror_invalid_ea_handle;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_EA_NAME))
  gcv_object_t _object_Kerror_invalid_ea_name;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_EDIT_HEIGHT))
  gcv_object_t _object_Kerror_invalid_edit_height;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_ENVIRONMENT))
  gcv_object_t _object_Kerror_invalid_environment;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_EVENTNAME))
  gcv_object_t _object_Kerror_invalid_eventname;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_EVENT_COUNT))
  gcv_object_t _object_Kerror_invalid_event_count;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_EXE_SIGNATURE))
  gcv_object_t _object_Kerror_invalid_exe_signature;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_FIELD))
  gcv_object_t _object_Kerror_invalid_field;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_FILTER_PROC))
  gcv_object_t _object_Kerror_invalid_filter_proc;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_FLAGS))
  gcv_object_t _object_Kerror_invalid_flags;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_FLAG_NUMBER))
  gcv_object_t _object_Kerror_invalid_flag_number;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_FORM_NAME))
  gcv_object_t _object_Kerror_invalid_form_name;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_FORM_SIZE))
  gcv_object_t _object_Kerror_invalid_form_size;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_FUNCTION))
  gcv_object_t _object_Kerror_invalid_function;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_GROUPNAME))
  gcv_object_t _object_Kerror_invalid_groupname;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_GROUP_ATTRIBUTES))
  gcv_object_t _object_Kerror_invalid_group_attributes;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_GW_COMMAND))
  gcv_object_t _object_Kerror_invalid_gw_command;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_HANDLE))
  gcv_object_t _object_Kerror_invalid_handle;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_HANDLE_STATE))
  gcv_object_t _object_Kerror_invalid_handle_state;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_HOOK_FILTER))
  gcv_object_t _object_Kerror_invalid_hook_filter;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_HOOK_HANDLE))
  gcv_object_t _object_Kerror_invalid_hook_handle;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_ICON_HANDLE))
  gcv_object_t _object_Kerror_invalid_icon_handle;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_ID_AUTHORITY))
  gcv_object_t _object_Kerror_invalid_id_authority;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_IMPORT_OF_NON_DLL))
  gcv_object_t _object_Kerror_invalid_import_of_non_dll;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_INDEX))
  gcv_object_t _object_Kerror_invalid_index;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_KEYBOARD_HANDLE))
  gcv_object_t _object_Kerror_invalid_keyboard_handle;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_LB_MESSAGE))
  gcv_object_t _object_Kerror_invalid_lb_message;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_LEVEL))
  gcv_object_t _object_Kerror_invalid_level;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_LIBRARY))
  gcv_object_t _object_Kerror_invalid_library;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_LIST_FORMAT))
  gcv_object_t _object_Kerror_invalid_list_format;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_LOGON_HOURS))
  gcv_object_t _object_Kerror_invalid_logon_hours;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_LOGON_TYPE))
  gcv_object_t _object_Kerror_invalid_logon_type;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_MEDIA))
  gcv_object_t _object_Kerror_invalid_media;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_MEDIA_POOL))
  gcv_object_t _object_Kerror_invalid_media_pool;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_MEMBER))
  gcv_object_t _object_Kerror_invalid_member;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_MENU_HANDLE))
  gcv_object_t _object_Kerror_invalid_menu_handle;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_MESSAGE))
  gcv_object_t _object_Kerror_invalid_message;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_MESSAGEDEST))
  gcv_object_t _object_Kerror_invalid_messagedest;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_MESSAGENAME))
  gcv_object_t _object_Kerror_invalid_messagename;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_MINALLOCSIZE))
  gcv_object_t _object_Kerror_invalid_minallocsize;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_MODULETYPE))
  gcv_object_t _object_Kerror_invalid_moduletype;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_MONITOR_HANDLE))
  gcv_object_t _object_Kerror_invalid_monitor_handle;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_MSGBOX_STYLE))
  gcv_object_t _object_Kerror_invalid_msgbox_style;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_NAME))
  gcv_object_t _object_Kerror_invalid_name;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_NETNAME))
  gcv_object_t _object_Kerror_invalid_netname;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_OPERATION))
  gcv_object_t _object_Kerror_invalid_operation;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_OPERATION_ON_QUORUM))
  gcv_object_t _object_Kerror_invalid_operation_on_quorum;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_OPLOCK_PROTOCOL))
  gcv_object_t _object_Kerror_invalid_oplock_protocol;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_ORDINAL))
  gcv_object_t _object_Kerror_invalid_ordinal;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_OWNER))
  gcv_object_t _object_Kerror_invalid_owner;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_PARAMETER))
  gcv_object_t _object_Kerror_invalid_parameter;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_PASSWORD))
  gcv_object_t _object_Kerror_invalid_password;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_PASSWORDNAME))
  gcv_object_t _object_Kerror_invalid_passwordname;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_PIXEL_FORMAT))
  gcv_object_t _object_Kerror_invalid_pixel_format;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_PRIMARY_GROUP))
  gcv_object_t _object_Kerror_invalid_primary_group;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_PRINTER_COMMAND))
  gcv_object_t _object_Kerror_invalid_printer_command;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_PRINTER_NAME))
  gcv_object_t _object_Kerror_invalid_printer_name;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_PRINTER_STATE))
  gcv_object_t _object_Kerror_invalid_printer_state;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_PRINT_MONITOR))
  gcv_object_t _object_Kerror_invalid_print_monitor;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_PRIORITY))
  gcv_object_t _object_Kerror_invalid_priority;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_PROFILE))
  gcv_object_t _object_Kerror_invalid_profile;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_REPARSE_DATA))
  gcv_object_t _object_Kerror_invalid_reparse_data;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_SCROLLBAR_RANGE))
  gcv_object_t _object_Kerror_invalid_scrollbar_range;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_SECURITY_DESCR))
  gcv_object_t _object_Kerror_invalid_security_descr;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_SEGDPL))
  gcv_object_t _object_Kerror_invalid_segdpl;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_SEGMENT_NUMBER))
  gcv_object_t _object_Kerror_invalid_segment_number;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_SEPARATOR_FILE))
  gcv_object_t _object_Kerror_invalid_separator_file;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_SERVER_STATE))
  gcv_object_t _object_Kerror_invalid_server_state;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_SERVICENAME))
  gcv_object_t _object_Kerror_invalid_servicename;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_SERVICE_ACCOUNT))
  gcv_object_t _object_Kerror_invalid_service_account;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_SERVICE_CONTROL))
  gcv_object_t _object_Kerror_invalid_service_control;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_SERVICE_LOCK))
  gcv_object_t _object_Kerror_invalid_service_lock;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_SHARENAME))
  gcv_object_t _object_Kerror_invalid_sharename;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_SHOWWIN_COMMAND))
  gcv_object_t _object_Kerror_invalid_showwin_command;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_SID))
  gcv_object_t _object_Kerror_invalid_sid;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_SIGNAL_NUMBER))
  gcv_object_t _object_Kerror_invalid_signal_number;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_SPI_VALUE))
  gcv_object_t _object_Kerror_invalid_spi_value;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_STACKSEG))
  gcv_object_t _object_Kerror_invalid_stackseg;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_STARTING_CODESEG))
  gcv_object_t _object_Kerror_invalid_starting_codeseg;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_STATE))
  gcv_object_t _object_Kerror_invalid_state;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_SUB_AUTHORITY))
  gcv_object_t _object_Kerror_invalid_sub_authority;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_TABLE))
  gcv_object_t _object_Kerror_invalid_table;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_TARGET_HANDLE))
  gcv_object_t _object_Kerror_invalid_target_handle;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_THREAD_ID))
  gcv_object_t _object_Kerror_invalid_thread_id;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_TIME))
  gcv_object_t _object_Kerror_invalid_time;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_TRANSFORM))
  gcv_object_t _object_Kerror_invalid_transform;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_USER_BUFFER))
  gcv_object_t _object_Kerror_invalid_user_buffer;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_VERIFY_SWITCH))
  gcv_object_t _object_Kerror_invalid_verify_switch;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_WINDOW_HANDLE))
  gcv_object_t _object_Kerror_invalid_window_handle;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_WINDOW_STYLE))
  gcv_object_t _object_Kerror_invalid_window_style;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_WORKSTATION))
  gcv_object_t _object_Kerror_invalid_workstation;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IOPL_NOT_ENABLED))
  gcv_object_t _object_Kerror_iopl_not_enabled;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IO_DEVICE))
  gcv_object_t _object_Kerror_io_device;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IO_INCOMPLETE))
  gcv_object_t _object_Kerror_io_incomplete;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IO_PENDING))
  gcv_object_t _object_Kerror_io_pending;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_DEFAULT_MM_AUTH_NOT_FOUND))
  gcv_object_t _object_Kerror_ipsec_default_mm_auth_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_DEFAULT_MM_POLICY_NOT_FOUND))
  gcv_object_t _object_Kerror_ipsec_default_mm_policy_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_DEFAULT_QM_POLICY_NOT_FOUND))
  gcv_object_t _object_Kerror_ipsec_default_qm_policy_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_ADD_UPDATE_KEY_FAILED))
  gcv_object_t _object_Kerror_ipsec_ike_add_update_key_failed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_ATTRIB_FAIL))
  gcv_object_t _object_Kerror_ipsec_ike_attrib_fail;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_AUTH_FAIL))
  gcv_object_t _object_Kerror_ipsec_ike_auth_fail;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_BENIGN_REINIT))
  gcv_object_t _object_Kerror_ipsec_ike_benign_reinit;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_CRL_FAILED))
  gcv_object_t _object_Kerror_ipsec_ike_crl_failed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_DECRYPT))
  gcv_object_t _object_Kerror_ipsec_ike_decrypt;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_DH_FAIL))
  gcv_object_t _object_Kerror_ipsec_ike_dh_fail;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_DH_FAILURE))
  gcv_object_t _object_Kerror_ipsec_ike_dh_failure;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_DROP_NO_RESPONSE))
  gcv_object_t _object_Kerror_ipsec_ike_drop_no_response;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_ENCRYPT))
  gcv_object_t _object_Kerror_ipsec_ike_encrypt;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_ERROR))
  gcv_object_t _object_Kerror_ipsec_ike_error;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_FAILQUERYSSP))
  gcv_object_t _object_Kerror_ipsec_ike_failqueryssp;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_FAILSSPINIT))
  gcv_object_t _object_Kerror_ipsec_ike_failsspinit;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_GENERAL_PROCESSING_ERROR))
  gcv_object_t _object_Kerror_ipsec_ike_general_processing_error;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_GETSPIFAIL))
  gcv_object_t _object_Kerror_ipsec_ike_getspifail;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_INVALID_AUTH_ALG))
  gcv_object_t _object_Kerror_ipsec_ike_invalid_auth_alg;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_INVALID_CERT_KEYLEN))
  gcv_object_t _object_Kerror_ipsec_ike_invalid_cert_keylen;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_INVALID_CERT_TYPE))
  gcv_object_t _object_Kerror_ipsec_ike_invalid_cert_type;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_INVALID_COOKIE))
  gcv_object_t _object_Kerror_ipsec_ike_invalid_cookie;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_INVALID_ENCRYPT_ALG))
  gcv_object_t _object_Kerror_ipsec_ike_invalid_encrypt_alg;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_INVALID_FILTER))
  gcv_object_t _object_Kerror_ipsec_ike_invalid_filter;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_INVALID_GROUP))
  gcv_object_t _object_Kerror_ipsec_ike_invalid_group;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_INVALID_HASH))
  gcv_object_t _object_Kerror_ipsec_ike_invalid_hash;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_INVALID_HASH_ALG))
  gcv_object_t _object_Kerror_ipsec_ike_invalid_hash_alg;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_INVALID_HASH_SIZE))
  gcv_object_t _object_Kerror_ipsec_ike_invalid_hash_size;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_INVALID_HEADER))
  gcv_object_t _object_Kerror_ipsec_ike_invalid_header;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_INVALID_KEY_USAGE))
  gcv_object_t _object_Kerror_ipsec_ike_invalid_key_usage;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_INVALID_PAYLOAD))
  gcv_object_t _object_Kerror_ipsec_ike_invalid_payload;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_INVALID_POLICY))
  gcv_object_t _object_Kerror_ipsec_ike_invalid_policy;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_INVALID_RESPONDER_LIFETIME_NOTIFY))
  gcv_object_t _object_Kerror_ipsec_ike_invalid_responder_lifetime_notify;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_INVALID_SIG))
  gcv_object_t _object_Kerror_ipsec_ike_invalid_sig;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_INVALID_SIGNATURE))
  gcv_object_t _object_Kerror_ipsec_ike_invalid_signature;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_INVALID_SITUATION))
  gcv_object_t _object_Kerror_ipsec_ike_invalid_situation;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_KERBEROS_ERROR))
  gcv_object_t _object_Kerror_ipsec_ike_kerberos_error;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_LOAD_FAILED))
  gcv_object_t _object_Kerror_ipsec_ike_load_failed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_LOAD_SOFT_SA))
  gcv_object_t _object_Kerror_ipsec_ike_load_soft_sa;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_MM_ACQUIRE_DROP))
  gcv_object_t _object_Kerror_ipsec_ike_mm_acquire_drop;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_MM_DELAY_DROP))
  gcv_object_t _object_Kerror_ipsec_ike_mm_delay_drop;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_MM_LIMIT))
  gcv_object_t _object_Kerror_ipsec_ike_mm_limit;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_NEGOTIATION_DISABLED))
  gcv_object_t _object_Kerror_ipsec_ike_negotiation_disabled;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_NEGOTIATION_PENDING))
  gcv_object_t _object_Kerror_ipsec_ike_negotiation_pending;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_NEG_STATUS_END))
  gcv_object_t _object_Kerror_ipsec_ike_neg_status_end;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_NOTCBPRIV))
  gcv_object_t _object_Kerror_ipsec_ike_notcbpriv;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_NO_CERT))
  gcv_object_t _object_Kerror_ipsec_ike_no_cert;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_NO_MM_POLICY))
  gcv_object_t _object_Kerror_ipsec_ike_no_mm_policy;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_NO_PEER_CERT))
  gcv_object_t _object_Kerror_ipsec_ike_no_peer_cert;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_NO_POLICY))
  gcv_object_t _object_Kerror_ipsec_ike_no_policy;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_NO_PRIVATE_KEY))
  gcv_object_t _object_Kerror_ipsec_ike_no_private_key;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_NO_PUBLIC_KEY))
  gcv_object_t _object_Kerror_ipsec_ike_no_public_key;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_OUT_OF_MEMORY))
  gcv_object_t _object_Kerror_ipsec_ike_out_of_memory;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_PEER_CRL_FAILED))
  gcv_object_t _object_Kerror_ipsec_ike_peer_crl_failed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_POLICY_CHANGE))
  gcv_object_t _object_Kerror_ipsec_ike_policy_change;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_POLICY_MATCH))
  gcv_object_t _object_Kerror_ipsec_ike_policy_match;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_PROCESS_ERR))
  gcv_object_t _object_Kerror_ipsec_ike_process_err;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_PROCESS_ERR_CERT))
  gcv_object_t _object_Kerror_ipsec_ike_process_err_cert;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_PROCESS_ERR_CERT_REQ))
  gcv_object_t _object_Kerror_ipsec_ike_process_err_cert_req;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_PROCESS_ERR_DELETE))
  gcv_object_t _object_Kerror_ipsec_ike_process_err_delete;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_PROCESS_ERR_HASH))
  gcv_object_t _object_Kerror_ipsec_ike_process_err_hash;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_PROCESS_ERR_ID))
  gcv_object_t _object_Kerror_ipsec_ike_process_err_id;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_PROCESS_ERR_KE))
  gcv_object_t _object_Kerror_ipsec_ike_process_err_ke;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_PROCESS_ERR_NONCE))
  gcv_object_t _object_Kerror_ipsec_ike_process_err_nonce;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_PROCESS_ERR_NOTIFY))
  gcv_object_t _object_Kerror_ipsec_ike_process_err_notify;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_PROCESS_ERR_PROP))
  gcv_object_t _object_Kerror_ipsec_ike_process_err_prop;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_PROCESS_ERR_SA))
  gcv_object_t _object_Kerror_ipsec_ike_process_err_sa;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_PROCESS_ERR_SIG))
  gcv_object_t _object_Kerror_ipsec_ike_process_err_sig;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_PROCESS_ERR_TRANS))
  gcv_object_t _object_Kerror_ipsec_ike_process_err_trans;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_PROCESS_ERR_VENDOR))
  gcv_object_t _object_Kerror_ipsec_ike_process_err_vendor;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_QM_ACQUIRE_DROP))
  gcv_object_t _object_Kerror_ipsec_ike_qm_acquire_drop;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_QM_DELAY_DROP))
  gcv_object_t _object_Kerror_ipsec_ike_qm_delay_drop;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_QUEUE_DROP_MM))
  gcv_object_t _object_Kerror_ipsec_ike_queue_drop_mm;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_QUEUE_DROP_NO_MM))
  gcv_object_t _object_Kerror_ipsec_ike_queue_drop_no_mm;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_RPC_DELETE))
  gcv_object_t _object_Kerror_ipsec_ike_rpc_delete;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_SA_DELETED))
  gcv_object_t _object_Kerror_ipsec_ike_sa_deleted;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_SA_REAPED))
  gcv_object_t _object_Kerror_ipsec_ike_sa_reaped;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_SECLOADFAIL))
  gcv_object_t _object_Kerror_ipsec_ike_secloadfail;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_SOFT_SA_TORN_DOWN))
  gcv_object_t _object_Kerror_ipsec_ike_soft_sa_torn_down;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_SRVACQFAIL))
  gcv_object_t _object_Kerror_ipsec_ike_srvacqfail;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_SRVQUERYCRED))
  gcv_object_t _object_Kerror_ipsec_ike_srvquerycred;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_TIMED_OUT))
  gcv_object_t _object_Kerror_ipsec_ike_timed_out;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_UNKNOWN_DOI))
  gcv_object_t _object_Kerror_ipsec_ike_unknown_doi;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_UNSUPPORTED_ID))
  gcv_object_t _object_Kerror_ipsec_ike_unsupported_id;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_MM_AUTH_EXISTS))
  gcv_object_t _object_Kerror_ipsec_mm_auth_exists;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_MM_AUTH_IN_USE))
  gcv_object_t _object_Kerror_ipsec_mm_auth_in_use;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_MM_AUTH_NOT_FOUND))
  gcv_object_t _object_Kerror_ipsec_mm_auth_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_MM_AUTH_PENDING_DELETION))
  gcv_object_t _object_Kerror_ipsec_mm_auth_pending_deletion;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_MM_FILTER_EXISTS))
  gcv_object_t _object_Kerror_ipsec_mm_filter_exists;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_MM_FILTER_NOT_FOUND))
  gcv_object_t _object_Kerror_ipsec_mm_filter_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_MM_FILTER_PENDING_DELETION))
  gcv_object_t _object_Kerror_ipsec_mm_filter_pending_deletion;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_MM_POLICY_EXISTS))
  gcv_object_t _object_Kerror_ipsec_mm_policy_exists;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_MM_POLICY_IN_USE))
  gcv_object_t _object_Kerror_ipsec_mm_policy_in_use;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_MM_POLICY_NOT_FOUND))
  gcv_object_t _object_Kerror_ipsec_mm_policy_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_MM_POLICY_PENDING_DELETION))
  gcv_object_t _object_Kerror_ipsec_mm_policy_pending_deletion;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_QM_POLICY_EXISTS))
  gcv_object_t _object_Kerror_ipsec_qm_policy_exists;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_QM_POLICY_IN_USE))
  gcv_object_t _object_Kerror_ipsec_qm_policy_in_use;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_QM_POLICY_NOT_FOUND))
  gcv_object_t _object_Kerror_ipsec_qm_policy_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_QM_POLICY_PENDING_DELETION))
  gcv_object_t _object_Kerror_ipsec_qm_policy_pending_deletion;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_TRANSPORT_FILTER_EXISTS))
  gcv_object_t _object_Kerror_ipsec_transport_filter_exists;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_TRANSPORT_FILTER_NOT_FOUND))
  gcv_object_t _object_Kerror_ipsec_transport_filter_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_TRANSPORT_FILTER_PENDING_DELETION))
  gcv_object_t _object_Kerror_ipsec_transport_filter_pending_deletion;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_TUNNEL_FILTER_EXISTS))
  gcv_object_t _object_Kerror_ipsec_tunnel_filter_exists;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_TUNNEL_FILTER_NOT_FOUND))
  gcv_object_t _object_Kerror_ipsec_tunnel_filter_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_TUNNEL_FILTER_PENDING_DELETION))
  gcv_object_t _object_Kerror_ipsec_tunnel_filter_pending_deletion;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IRQ_BUSY))
  gcv_object_t _object_Kerror_irq_busy;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IS_JOINED))
  gcv_object_t _object_Kerror_is_joined;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IS_JOIN_PATH))
  gcv_object_t _object_Kerror_is_join_path;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IS_JOIN_TARGET))
  gcv_object_t _object_Kerror_is_join_target;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IS_SUBSTED))
  gcv_object_t _object_Kerror_is_substed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IS_SUBST_PATH))
  gcv_object_t _object_Kerror_is_subst_path;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IS_SUBST_TARGET))
  gcv_object_t _object_Kerror_is_subst_target;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ITERATED_DATA_EXCEEDS_64k))
  gcv_object_t _object_Kerror_iterated_data_exceeds_64k;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_JOIN_TO_JOIN))
  gcv_object_t _object_Kerror_join_to_join;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_JOIN_TO_SUBST))
  gcv_object_t _object_Kerror_join_to_subst;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_JOURNAL_DELETE_IN_PROGRESS))
  gcv_object_t _object_Kerror_journal_delete_in_progress;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_JOURNAL_ENTRY_DELETED))
  gcv_object_t _object_Kerror_journal_entry_deleted;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_JOURNAL_HOOK_SET))
  gcv_object_t _object_Kerror_journal_hook_set;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_JOURNAL_NOT_ACTIVE))
  gcv_object_t _object_Kerror_journal_not_active;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_KEY_DELETED))
  gcv_object_t _object_Kerror_key_deleted;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_KEY_HAS_CHILDREN))
  gcv_object_t _object_Kerror_key_has_children;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_KM_DRIVER_BLOCKED))
  gcv_object_t _object_Kerror_km_driver_blocked;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_LABEL_TOO_LONG))
  gcv_object_t _object_Kerror_label_too_long;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_LAST_ADMIN))
  gcv_object_t _object_Kerror_last_admin;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_LB_WITHOUT_TABSTOPS))
  gcv_object_t _object_Kerror_lb_without_tabstops;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_LIBRARY_FULL))
  gcv_object_t _object_Kerror_library_full;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_LIBRARY_OFFLINE))
  gcv_object_t _object_Kerror_library_offline;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_LICENSE_QUOTA_EXCEEDED))
  gcv_object_t _object_Kerror_license_quota_exceeded;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_LISTBOX_ID_NOT_FOUND))
  gcv_object_t _object_Kerror_listbox_id_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_LM_CROSS_ENCRYPTION_REQUIRED))
  gcv_object_t _object_Kerror_lm_cross_encryption_required;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_LOCAL_USER_SESSION_KEY))
  gcv_object_t _object_Kerror_local_user_session_key;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_LOCKED))
  gcv_object_t _object_Kerror_locked;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_LOCK_FAILED))
  gcv_object_t _object_Kerror_lock_failed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_LOCK_VIOLATION))
  gcv_object_t _object_Kerror_lock_violation;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_LOGIN_TIME_RESTRICTION))
  gcv_object_t _object_Kerror_login_time_restriction;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_LOGIN_WKSTA_RESTRICTION))
  gcv_object_t _object_Kerror_login_wksta_restriction;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_LOGON_FAILURE))
  gcv_object_t _object_Kerror_logon_failure;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_LOGON_NOT_GRANTED))
  gcv_object_t _object_Kerror_logon_not_granted;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_LOGON_SESSION_COLLISION))
  gcv_object_t _object_Kerror_logon_session_collision;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_LOGON_SESSION_EXISTS))
  gcv_object_t _object_Kerror_logon_session_exists;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_LOGON_TYPE_NOT_GRANTED))
  gcv_object_t _object_Kerror_logon_type_not_granted;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_LOG_FILE_FULL))
  gcv_object_t _object_Kerror_log_file_full;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_LUIDS_EXHAUSTED))
  gcv_object_t _object_Kerror_luids_exhausted;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_MACHINE_LOCKED))
  gcv_object_t _object_Kerror_machine_locked;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_MAGAZINE_NOT_PRESENT))
  gcv_object_t _object_Kerror_magazine_not_present;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_MAPPED_ALIGNMENT))
  gcv_object_t _object_Kerror_mapped_alignment;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_MAX_THRDS_REACHED))
  gcv_object_t _object_Kerror_max_thrds_reached;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_MEDIA_CHANGED))
  gcv_object_t _object_Kerror_media_changed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_MEDIA_INCOMPATIBLE))
  gcv_object_t _object_Kerror_media_incompatible;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_MEDIA_NOT_AVAILABLE))
  gcv_object_t _object_Kerror_media_not_available;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_MEDIA_OFFLINE))
  gcv_object_t _object_Kerror_media_offline;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_MEDIA_UNAVAILABLE))
  gcv_object_t _object_Kerror_media_unavailable;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_MEDIUM_NOT_ACCESSIBLE))
  gcv_object_t _object_Kerror_medium_not_accessible;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_MEMBERS_PRIMARY_GROUP))
  gcv_object_t _object_Kerror_members_primary_group;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_MEMBER_IN_ALIAS))
  gcv_object_t _object_Kerror_member_in_alias;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_MEMBER_IN_GROUP))
  gcv_object_t _object_Kerror_member_in_group;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_MEMBER_NOT_IN_ALIAS))
  gcv_object_t _object_Kerror_member_not_in_alias;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_MEMBER_NOT_IN_GROUP))
  gcv_object_t _object_Kerror_member_not_in_group;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_MENU_ITEM_NOT_FOUND))
  gcv_object_t _object_Kerror_menu_item_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_MESSAGE_EXCEEDS_MAX_SIZE))
  gcv_object_t _object_Kerror_message_exceeds_max_size;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_MESSAGE_SYNC_ONLY))
  gcv_object_t _object_Kerror_message_sync_only;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_METAFILE_NOT_SUPPORTED))
  gcv_object_t _object_Kerror_metafile_not_supported;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_META_EXPANSION_TOO_LONG))
  gcv_object_t _object_Kerror_meta_expansion_too_long;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_MOD_NOT_FOUND))
  gcv_object_t _object_Kerror_mod_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_MORE_DATA))
  gcv_object_t _object_Kerror_more_data;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_MORE_WRITES))
  gcv_object_t _object_Kerror_more_writes;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_MR_MID_NOT_FOUND))
  gcv_object_t _object_Kerror_mr_mid_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_MUTUAL_AUTH_FAILED))
  gcv_object_t _object_Kerror_mutual_auth_failed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NEGATIVE_SEEK))
  gcv_object_t _object_Kerror_negative_seek;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NESTING_NOT_ALLOWED))
  gcv_object_t _object_Kerror_nesting_not_allowed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NETLOGON_NOT_STARTED))
  gcv_object_t _object_Kerror_netlogon_not_started;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NETNAME_DELETED))
  gcv_object_t _object_Kerror_netname_deleted;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NETWORK_ACCESS_DENIED))
  gcv_object_t _object_Kerror_network_access_denied;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NETWORK_BUSY))
  gcv_object_t _object_Kerror_network_busy;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NETWORK_NOT_AVAILABLE))
  gcv_object_t _object_Kerror_network_not_available;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NETWORK_UNREACHABLE))
  gcv_object_t _object_Kerror_network_unreachable;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NET_WRITE_FAULT))
  gcv_object_t _object_Kerror_net_write_fault;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOACCESS))
  gcv_object_t _object_Kerror_noaccess;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NODE_CANNOT_BE_CLUSTERED))
  gcv_object_t _object_Kerror_node_cannot_be_clustered;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NODE_CANT_HOST_RESOURCE))
  gcv_object_t _object_Kerror_node_cant_host_resource;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NODE_NOT_AVAILABLE))
  gcv_object_t _object_Kerror_node_not_available;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT))
  gcv_object_t _object_Kerror_nologon_interdomain_trust_account;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOLOGON_SERVER_TRUST_ACCOUNT))
  gcv_object_t _object_Kerror_nologon_server_trust_account;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOLOGON_WORKSTATION_TRUST_ACCOUNT))
  gcv_object_t _object_Kerror_nologon_workstation_trust_account;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NONE_MAPPED))
  gcv_object_t _object_Kerror_none_mapped;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NONPAGED_SYSTEM_RESOURCES))
  gcv_object_t _object_Kerror_nonpaged_system_resources;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NON_ACCOUNT_SID))
  gcv_object_t _object_Kerror_non_account_sid;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NON_DOMAIN_SID))
  gcv_object_t _object_Kerror_non_domain_sid;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NON_MDICHILD_WINDOW))
  gcv_object_t _object_Kerror_non_mdichild_window;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOTIFY_ENUM_DIR))
  gcv_object_t _object_Kerror_notify_enum_dir;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOT_ALL_ASSIGNED))
  gcv_object_t _object_Kerror_not_all_assigned;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOT_AUTHENTICATED))
  gcv_object_t _object_Kerror_not_authenticated;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOT_A_REPARSE_POINT))
  gcv_object_t _object_Kerror_not_a_reparse_point;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOT_CHILD_WINDOW))
  gcv_object_t _object_Kerror_not_child_window;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOT_CONNECTED))
  gcv_object_t _object_Kerror_not_connected;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOT_CONTAINER))
  gcv_object_t _object_Kerror_not_container;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOT_DOS_DISK))
  gcv_object_t _object_Kerror_not_dos_disk;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOT_EMPTY))
  gcv_object_t _object_Kerror_not_empty;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOT_ENOUGH_MEMORY))
  gcv_object_t _object_Kerror_not_enough_memory;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOT_ENOUGH_QUOTA))
  gcv_object_t _object_Kerror_not_enough_quota;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOT_ENOUGH_SERVER_MEMORY))
  gcv_object_t _object_Kerror_not_enough_server_memory;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOT_EXPORT_FORMAT))
  gcv_object_t _object_Kerror_not_export_format;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOT_FOUND))
  gcv_object_t _object_Kerror_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOT_JOINED))
  gcv_object_t _object_Kerror_not_joined;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOT_LOCKED))
  gcv_object_t _object_Kerror_not_locked;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOT_LOGGED_ON))
  gcv_object_t _object_Kerror_not_logged_on;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOT_LOGON_PROCESS))
  gcv_object_t _object_Kerror_not_logon_process;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOT_OWNER))
  gcv_object_t _object_Kerror_not_owner;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOT_QUORUM_CAPABLE))
  gcv_object_t _object_Kerror_not_quorum_capable;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOT_QUORUM_CLASS))
  gcv_object_t _object_Kerror_not_quorum_class;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOT_READY))
  gcv_object_t _object_Kerror_not_ready;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOT_REGISTRY_FILE))
  gcv_object_t _object_Kerror_not_registry_file;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOT_SAFEBOOT_SERVICE))
  gcv_object_t _object_Kerror_not_safeboot_service;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOT_SAME_DEVICE))
  gcv_object_t _object_Kerror_not_same_device;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOT_SUBSTED))
  gcv_object_t _object_Kerror_not_substed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOT_SUPPORTED))
  gcv_object_t _object_Kerror_not_supported;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOT_SUPPORTED_ON_SBS))
  gcv_object_t _object_Kerror_not_supported_on_sbs;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOT_SUPPORTED_ON_STANDARD_SERVER))
  gcv_object_t _object_Kerror_not_supported_on_standard_server;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_ASSOCIATION))
  gcv_object_t _object_Kerror_no_association;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_BROWSER_SERVERS_FOUND))
  gcv_object_t _object_Kerror_no_browser_servers_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_DATA))
  gcv_object_t _object_Kerror_no_data;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_DATA_DETECTED))
  gcv_object_t _object_Kerror_no_data_detected;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_EFS))
  gcv_object_t _object_Kerror_no_efs;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_IMPERSONATION_TOKEN))
  gcv_object_t _object_Kerror_no_impersonation_token;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_INHERITANCE))
  gcv_object_t _object_Kerror_no_inheritance;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_LOGON_SERVERS))
  gcv_object_t _object_Kerror_no_logon_servers;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_LOG_SPACE))
  gcv_object_t _object_Kerror_no_log_space;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_MATCH))
  gcv_object_t _object_Kerror_no_match;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_MEDIA_IN_DRIVE))
  gcv_object_t _object_Kerror_no_media_in_drive;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_MORE_DEVICES))
  gcv_object_t _object_Kerror_no_more_devices;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_MORE_FILES))
  gcv_object_t _object_Kerror_no_more_files;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_MORE_ITEMS))
  gcv_object_t _object_Kerror_no_more_items;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_MORE_SEARCH_HANDLES))
  gcv_object_t _object_Kerror_no_more_search_handles;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_MORE_USER_HANDLES))
  gcv_object_t _object_Kerror_no_more_user_handles;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_NETWORK))
  gcv_object_t _object_Kerror_no_network;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_NET_OR_BAD_PATH))
  gcv_object_t _object_Kerror_no_net_or_bad_path;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_PROC_SLOTS))
  gcv_object_t _object_Kerror_no_proc_slots;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_PROMOTION_ACTIVE))
  gcv_object_t _object_Kerror_no_promotion_active;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_QUOTAS_FOR_ACCOUNT))
  gcv_object_t _object_Kerror_no_quotas_for_account;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_RECOVERY_POLICY))
  gcv_object_t _object_Kerror_no_recovery_policy;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_RECOVERY_PROGRAM))
  gcv_object_t _object_Kerror_no_recovery_program;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_SCROLLBARS))
  gcv_object_t _object_Kerror_no_scrollbars;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_SECURITY_ON_OBJECT))
  gcv_object_t _object_Kerror_no_security_on_object;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_SHUTDOWN_IN_PROGRESS))
  gcv_object_t _object_Kerror_no_shutdown_in_progress;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_SIGNAL_SENT))
  gcv_object_t _object_Kerror_no_signal_sent;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_SITENAME))
  gcv_object_t _object_Kerror_no_sitename;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_SPOOL_SPACE))
  gcv_object_t _object_Kerror_no_spool_space;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_SUCH_ALIAS))
  gcv_object_t _object_Kerror_no_such_alias;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_SUCH_DOMAIN))
  gcv_object_t _object_Kerror_no_such_domain;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_SUCH_GROUP))
  gcv_object_t _object_Kerror_no_such_group;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_SUCH_LOGON_SESSION))
  gcv_object_t _object_Kerror_no_such_logon_session;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_SUCH_MEMBER))
  gcv_object_t _object_Kerror_no_such_member;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_SUCH_PACKAGE))
  gcv_object_t _object_Kerror_no_such_package;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_SUCH_PRIVILEGE))
  gcv_object_t _object_Kerror_no_such_privilege;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_SUCH_SITE))
  gcv_object_t _object_Kerror_no_such_site;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_SUCH_USER))
  gcv_object_t _object_Kerror_no_such_user;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_SUPPORTING_DRIVES))
  gcv_object_t _object_Kerror_no_supporting_drives;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_SYSTEM_MENU))
  gcv_object_t _object_Kerror_no_system_menu;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_SYSTEM_RESOURCES))
  gcv_object_t _object_Kerror_no_system_resources;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_TOKEN))
  gcv_object_t _object_Kerror_no_token;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_TRACKING_SERVICE))
  gcv_object_t _object_Kerror_no_tracking_service;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_TRUST_LSA_SECRET))
  gcv_object_t _object_Kerror_no_trust_lsa_secret;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_TRUST_SAM_ACCOUNT))
  gcv_object_t _object_Kerror_no_trust_sam_account;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_UNICODE_TRANSLATION))
  gcv_object_t _object_Kerror_no_unicode_translation;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_USER_KEYS))
  gcv_object_t _object_Kerror_no_user_keys;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_USER_SESSION_KEY))
  gcv_object_t _object_Kerror_no_user_session_key;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_VOLUME_ID))
  gcv_object_t _object_Kerror_no_volume_id;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_VOLUME_LABEL))
  gcv_object_t _object_Kerror_no_volume_label;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_WILDCARD_CHARACTERS))
  gcv_object_t _object_Kerror_no_wildcard_characters;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NT_CROSS_ENCRYPTION_REQUIRED))
  gcv_object_t _object_Kerror_nt_cross_encryption_required;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NULL_LM_PASSWORD))
  gcv_object_t _object_Kerror_null_lm_password;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_OBJECT_ALREADY_EXISTS))
  gcv_object_t _object_Kerror_object_already_exists;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_OBJECT_IN_LIST))
  gcv_object_t _object_Kerror_object_in_list;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_OBJECT_NOT_FOUND))
  gcv_object_t _object_Kerror_object_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_OLD_WIN_VERSION))
  gcv_object_t _object_Kerror_old_win_version;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ONLY_IF_CONNECTED))
  gcv_object_t _object_Kerror_only_if_connected;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_OPEN_FAILED))
  gcv_object_t _object_Kerror_open_failed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_OPEN_FILES))
  gcv_object_t _object_Kerror_open_files;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_OPERATION_ABORTED))
  gcv_object_t _object_Kerror_operation_aborted;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_OPLOCK_NOT_GRANTED))
  gcv_object_t _object_Kerror_oplock_not_granted;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_OUTOFMEMORY))
  gcv_object_t _object_Kerror_outofmemory;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_OUT_OF_PAPER))
  gcv_object_t _object_Kerror_out_of_paper;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_OUT_OF_STRUCTURES))
  gcv_object_t _object_Kerror_out_of_structures;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_OVERRIDE_NOCHANGES))
  gcv_object_t _object_Kerror_override_nochanges;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PAGED_SYSTEM_RESOURCES))
  gcv_object_t _object_Kerror_paged_system_resources;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PAGEFILE_QUOTA))
  gcv_object_t _object_Kerror_pagefile_quota;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PARAMETER_QUOTA_EXCEEDED))
  gcv_object_t _object_Kerror_parameter_quota_exceeded;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PARTIAL_COPY))
  gcv_object_t _object_Kerror_partial_copy;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PARTITION_FAILURE))
  gcv_object_t _object_Kerror_partition_failure;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PASSWORD_EXPIRED))
  gcv_object_t _object_Kerror_password_expired;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PASSWORD_MUST_CHANGE))
  gcv_object_t _object_Kerror_password_must_change;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PASSWORD_RESTRICTION))
  gcv_object_t _object_Kerror_password_restriction;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PATCH_PACKAGE_INVALID))
  gcv_object_t _object_Kerror_patch_package_invalid;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PATCH_PACKAGE_OPEN_FAILED))
  gcv_object_t _object_Kerror_patch_package_open_failed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PATCH_PACKAGE_REJECTED))
  gcv_object_t _object_Kerror_patch_package_rejected;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PATCH_PACKAGE_UNSUPPORTED))
  gcv_object_t _object_Kerror_patch_package_unsupported;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PATCH_TARGET_NOT_FOUND))
  gcv_object_t _object_Kerror_patch_target_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PATH_BUSY))
  gcv_object_t _object_Kerror_path_busy;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PATH_NOT_FOUND))
  gcv_object_t _object_Kerror_path_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PER_USER_TRUST_QUOTA_EXCEEDED))
  gcv_object_t _object_Kerror_per_user_trust_quota_exceeded;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PIPE_BUSY))
  gcv_object_t _object_Kerror_pipe_busy;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PIPE_CONNECTED))
  gcv_object_t _object_Kerror_pipe_connected;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PIPE_LISTENING))
  gcv_object_t _object_Kerror_pipe_listening;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PIPE_NOT_CONNECTED))
  gcv_object_t _object_Kerror_pipe_not_connected;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PKINIT_FAILURE))
  gcv_object_t _object_Kerror_pkinit_failure;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_POINT_NOT_FOUND))
  gcv_object_t _object_Kerror_point_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_POLICY_OBJECT_NOT_FOUND))
  gcv_object_t _object_Kerror_policy_object_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_POLICY_ONLY_IN_DS))
  gcv_object_t _object_Kerror_policy_only_in_ds;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_POPUP_ALREADY_ACTIVE))
  gcv_object_t _object_Kerror_popup_already_active;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PORT_UNREACHABLE))
  gcv_object_t _object_Kerror_port_unreachable;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_POSSIBLE_DEADLOCK))
  gcv_object_t _object_Kerror_possible_deadlock;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_POTENTIAL_FILE_FOUND))
  gcv_object_t _object_Kerror_potential_file_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PRINTER_ALREADY_EXISTS))
  gcv_object_t _object_Kerror_printer_already_exists;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PRINTER_DELETED))
  gcv_object_t _object_Kerror_printer_deleted;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PRINTER_DRIVER_ALREADY_INSTALLED))
  gcv_object_t _object_Kerror_printer_driver_already_installed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PRINTER_DRIVER_BLOCKED))
  gcv_object_t _object_Kerror_printer_driver_blocked;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PRINTER_DRIVER_IN_USE))
  gcv_object_t _object_Kerror_printer_driver_in_use;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PRINTER_DRIVER_WARNED))
  gcv_object_t _object_Kerror_printer_driver_warned;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PRINTER_HAS_JOBS_QUEUED))
  gcv_object_t _object_Kerror_printer_has_jobs_queued;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PRINTER_NOT_FOUND))
  gcv_object_t _object_Kerror_printer_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PRINTQ_FULL))
  gcv_object_t _object_Kerror_printq_full;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PRINT_CANCELLED))
  gcv_object_t _object_Kerror_print_cancelled;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PRINT_MONITOR_ALREADY_INSTALLED))
  gcv_object_t _object_Kerror_print_monitor_already_installed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PRINT_MONITOR_IN_USE))
  gcv_object_t _object_Kerror_print_monitor_in_use;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PRINT_PROCESSOR_ALREADY_INSTALLED))
  gcv_object_t _object_Kerror_print_processor_already_installed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PRIVATE_DIALOG_INDEX))
  gcv_object_t _object_Kerror_private_dialog_index;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PRIVILEGE_NOT_HELD))
  gcv_object_t _object_Kerror_privilege_not_held;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PROCESS_ABORTED))
  gcv_object_t _object_Kerror_process_aborted;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PROC_NOT_FOUND))
  gcv_object_t _object_Kerror_proc_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PRODUCT_UNINSTALLED))
  gcv_object_t _object_Kerror_product_uninstalled;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PRODUCT_VERSION))
  gcv_object_t _object_Kerror_product_version;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PROFILE_NOT_ASSOCIATED_WITH_DEVICE))
  gcv_object_t _object_Kerror_profile_not_associated_with_device;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PROFILE_NOT_FOUND))
  gcv_object_t _object_Kerror_profile_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PROMOTION_ACTIVE))
  gcv_object_t _object_Kerror_promotion_active;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PROTOCOL_UNREACHABLE))
  gcv_object_t _object_Kerror_protocol_unreachable;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_QUORUMLOG_OPEN_FAILED))
  gcv_object_t _object_Kerror_quorumlog_open_failed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_QUORUM_DISK_NOT_FOUND))
  gcv_object_t _object_Kerror_quorum_disk_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_QUORUM_OWNER_ALIVE))
  gcv_object_t _object_Kerror_quorum_owner_alive;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_QUORUM_RESOURCE))
  gcv_object_t _object_Kerror_quorum_resource;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_QUORUM_RESOURCE_ONLINE_FAILED))
  gcv_object_t _object_Kerror_quorum_resource_online_failed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_READ_FAULT))
  gcv_object_t _object_Kerror_read_fault;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_RECOVERY_FAILURE))
  gcv_object_t _object_Kerror_recovery_failure;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_REC_NON_EXISTENT))
  gcv_object_t _object_Kerror_rec_non_existent;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_REDIRECTOR_HAS_OPEN_HANDLES))
  gcv_object_t _object_Kerror_redirector_has_open_handles;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_REDIR_PAUSED))
  gcv_object_t _object_Kerror_redir_paused;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_REGISTRY_CORRUPT))
  gcv_object_t _object_Kerror_registry_corrupt;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_REGISTRY_IO_FAILED))
  gcv_object_t _object_Kerror_registry_io_failed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_REGISTRY_RECOVERED))
  gcv_object_t _object_Kerror_registry_recovered;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_REG_NAT_CONSUMPTION))
  gcv_object_t _object_Kerror_reg_nat_consumption;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_RELOC_CHAIN_XEEDS_SEGLIM))
  gcv_object_t _object_Kerror_reloc_chain_xeeds_seglim;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_REMOTE_SESSION_LIMIT_EXCEEDED))
  gcv_object_t _object_Kerror_remote_session_limit_exceeded;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_REMOTE_STORAGE_MEDIA_ERROR))
  gcv_object_t _object_Kerror_remote_storage_media_error;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_REMOTE_STORAGE_NOT_ACTIVE))
  gcv_object_t _object_Kerror_remote_storage_not_active;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_REM_NOT_LIST))
  gcv_object_t _object_Kerror_rem_not_list;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_REPARSE_ATTRIBUTE_CONFLICT))
  gcv_object_t _object_Kerror_reparse_attribute_conflict;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_REPARSE_TAG_INVALID))
  gcv_object_t _object_Kerror_reparse_tag_invalid;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_REPARSE_TAG_MISMATCH))
  gcv_object_t _object_Kerror_reparse_tag_mismatch;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_REQUEST_ABORTED))
  gcv_object_t _object_Kerror_request_aborted;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_REQUEST_REFUSED))
  gcv_object_t _object_Kerror_request_refused;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_REQUIRES_INTERACTIVE_WINDOWSTATION))
  gcv_object_t _object_Kerror_requires_interactive_windowstation;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_REQ_NOT_ACCEP))
  gcv_object_t _object_Kerror_req_not_accep;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_RESMON_CREATE_FAILED))
  gcv_object_t _object_Kerror_resmon_create_failed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_RESMON_INVALID_STATE))
  gcv_object_t _object_Kerror_resmon_invalid_state;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_RESMON_ONLINE_FAILED))
  gcv_object_t _object_Kerror_resmon_online_failed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_RESOURCE_DATA_NOT_FOUND))
  gcv_object_t _object_Kerror_resource_data_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_RESOURCE_DISABLED))
  gcv_object_t _object_Kerror_resource_disabled;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_RESOURCE_FAILED))
  gcv_object_t _object_Kerror_resource_failed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_RESOURCE_LANG_NOT_FOUND))
  gcv_object_t _object_Kerror_resource_lang_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_RESOURCE_NAME_NOT_FOUND))
  gcv_object_t _object_Kerror_resource_name_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_RESOURCE_NOT_AVAILABLE))
  gcv_object_t _object_Kerror_resource_not_available;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_RESOURCE_NOT_FOUND))
  gcv_object_t _object_Kerror_resource_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_RESOURCE_NOT_ONLINE))
  gcv_object_t _object_Kerror_resource_not_online;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_RESOURCE_NOT_PRESENT))
  gcv_object_t _object_Kerror_resource_not_present;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_RESOURCE_ONLINE))
  gcv_object_t _object_Kerror_resource_online;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_RESOURCE_PROPERTIES_STORED))
  gcv_object_t _object_Kerror_resource_properties_stored;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_RESOURCE_PROPERTY_UNCHANGEABLE))
  gcv_object_t _object_Kerror_resource_property_unchangeable;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_RESOURCE_TYPE_NOT_FOUND))
  gcv_object_t _object_Kerror_resource_type_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_RETRY))
  gcv_object_t _object_Kerror_retry;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_REVISION_MISMATCH))
  gcv_object_t _object_Kerror_revision_mismatch;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_RING2SEG_MUST_BE_MOVABLE))
  gcv_object_t _object_Kerror_ring2seg_must_be_movable;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_RING2_STACK_IN_USE))
  gcv_object_t _object_Kerror_ring2_stack_in_use;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_RMODE_APP))
  gcv_object_t _object_Kerror_rmode_app;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_RPL_NOT_ALLOWED))
  gcv_object_t _object_Kerror_rpl_not_allowed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_RXACT_COMMIT_FAILURE))
  gcv_object_t _object_Kerror_rxact_commit_failure;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_RXACT_INVALID_STATE))
  gcv_object_t _object_Kerror_rxact_invalid_state;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SAME_DRIVE))
  gcv_object_t _object_Kerror_same_drive;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SAM_INIT_FAILURE))
  gcv_object_t _object_Kerror_sam_init_failure;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SCOPE_NOT_FOUND))
  gcv_object_t _object_Kerror_scope_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SCREEN_ALREADY_LOCKED))
  gcv_object_t _object_Kerror_screen_already_locked;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SECRET_TOO_LONG))
  gcv_object_t _object_Kerror_secret_too_long;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SECTOR_NOT_FOUND))
  gcv_object_t _object_Kerror_sector_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SEEK))
  gcv_object_t _object_Kerror_seek;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SEEK_ON_DEVICE))
  gcv_object_t _object_Kerror_seek_on_device;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SEM_IS_SET))
  gcv_object_t _object_Kerror_sem_is_set;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SEM_NOT_FOUND))
  gcv_object_t _object_Kerror_sem_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SEM_OWNER_DIED))
  gcv_object_t _object_Kerror_sem_owner_died;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SEM_TIMEOUT))
  gcv_object_t _object_Kerror_sem_timeout;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SEM_USER_LIMIT))
  gcv_object_t _object_Kerror_sem_user_limit;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SERIAL_NO_DEVICE))
  gcv_object_t _object_Kerror_serial_no_device;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SERVER_DISABLED))
  gcv_object_t _object_Kerror_server_disabled;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SERVER_HAS_OPEN_HANDLES))
  gcv_object_t _object_Kerror_server_has_open_handles;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SERVER_NOT_DISABLED))
  gcv_object_t _object_Kerror_server_not_disabled;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SERVER_SHUTDOWN_IN_PROGRESS))
  gcv_object_t _object_Kerror_server_shutdown_in_progress;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SERVICE_ALREADY_RUNNING))
  gcv_object_t _object_Kerror_service_already_running;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SERVICE_CANNOT_ACCEPT_CTRL))
  gcv_object_t _object_Kerror_service_cannot_accept_ctrl;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SERVICE_DATABASE_LOCKED))
  gcv_object_t _object_Kerror_service_database_locked;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SERVICE_DEPENDENCY_DELETED))
  gcv_object_t _object_Kerror_service_dependency_deleted;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SERVICE_DEPENDENCY_FAIL))
  gcv_object_t _object_Kerror_service_dependency_fail;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SERVICE_DISABLED))
  gcv_object_t _object_Kerror_service_disabled;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SERVICE_DOES_NOT_EXIST))
  gcv_object_t _object_Kerror_service_does_not_exist;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SERVICE_EXISTS))
  gcv_object_t _object_Kerror_service_exists;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SERVICE_LOGON_FAILED))
  gcv_object_t _object_Kerror_service_logon_failed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SERVICE_MARKED_FOR_DELETE))
  gcv_object_t _object_Kerror_service_marked_for_delete;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SERVICE_NEVER_STARTED))
  gcv_object_t _object_Kerror_service_never_started;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SERVICE_NOT_ACTIVE))
  gcv_object_t _object_Kerror_service_not_active;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SERVICE_NOT_FOUND))
  gcv_object_t _object_Kerror_service_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SERVICE_NOT_IN_EXE))
  gcv_object_t _object_Kerror_service_not_in_exe;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SERVICE_NO_THREAD))
  gcv_object_t _object_Kerror_service_no_thread;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SERVICE_REQUEST_TIMEOUT))
  gcv_object_t _object_Kerror_service_request_timeout;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SERVICE_SPECIFIC_ERROR))
  gcv_object_t _object_Kerror_service_specific_error;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SERVICE_START_HANG))
  gcv_object_t _object_Kerror_service_start_hang;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SESSION_CREDENTIAL_CONFLICT))
  gcv_object_t _object_Kerror_session_credential_conflict;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SETCOUNT_ON_BAD_LB))
  gcv_object_t _object_Kerror_setcount_on_bad_lb;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SETMARK_DETECTED))
  gcv_object_t _object_Kerror_setmark_detected;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SET_NOT_FOUND))
  gcv_object_t _object_Kerror_set_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SET_POWER_STATE_FAILED))
  gcv_object_t _object_Kerror_set_power_state_failed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SET_POWER_STATE_VETOED))
  gcv_object_t _object_Kerror_set_power_state_vetoed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SHARED_POLICY))
  gcv_object_t _object_Kerror_shared_policy;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SHARING_BUFFER_EXCEEDED))
  gcv_object_t _object_Kerror_sharing_buffer_exceeded;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SHARING_PAUSED))
  gcv_object_t _object_Kerror_sharing_paused;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SHARING_VIOLATION))
  gcv_object_t _object_Kerror_sharing_violation;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SHUTDOWN_CLUSTER))
  gcv_object_t _object_Kerror_shutdown_cluster;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SHUTDOWN_IN_PROGRESS))
  gcv_object_t _object_Kerror_shutdown_in_progress;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SIGNAL_PENDING))
  gcv_object_t _object_Kerror_signal_pending;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SIGNAL_REFUSED))
  gcv_object_t _object_Kerror_signal_refused;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SINGLE_INSTANCE_APP))
  gcv_object_t _object_Kerror_single_instance_app;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SMARTCARD_SUBSYSTEM_FAILURE))
  gcv_object_t _object_Kerror_smartcard_subsystem_failure;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SOME_NOT_MAPPED))
  gcv_object_t _object_Kerror_some_not_mapped;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SOURCE_ELEMENT_EMPTY))
  gcv_object_t _object_Kerror_source_element_empty;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SPECIAL_ACCOUNT))
  gcv_object_t _object_Kerror_special_account;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SPECIAL_GROUP))
  gcv_object_t _object_Kerror_special_group;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SPECIAL_USER))
  gcv_object_t _object_Kerror_special_user;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SPL_NO_ADDJOB))
  gcv_object_t _object_Kerror_spl_no_addjob;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SPL_NO_STARTDOC))
  gcv_object_t _object_Kerror_spl_no_startdoc;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SPOOL_FILE_NOT_FOUND))
  gcv_object_t _object_Kerror_spool_file_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_STACK_BUFFER_OVERRUN))
  gcv_object_t _object_Kerror_stack_buffer_overrun;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_STACK_OVERFLOW))
  gcv_object_t _object_Kerror_stack_overflow;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_STATIC_INIT))
  gcv_object_t _object_Kerror_static_init;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SUBST_TO_JOIN))
  gcv_object_t _object_Kerror_subst_to_join;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SUBST_TO_SUBST))
  gcv_object_t _object_Kerror_subst_to_subst;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SUCCESS_REBOOT_INITIATED))
  gcv_object_t _object_Kerror_success_reboot_initiated;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SUCCESS_REBOOT_REQUIRED))
  gcv_object_t _object_Kerror_success_reboot_required;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SUCCESS_RESTART_REQUIRED))
  gcv_object_t _object_Kerror_success_restart_required;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SWAPERROR))
  gcv_object_t _object_Kerror_swaperror;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_ACTIVATION_CONTEXT_DISABLED))
  gcv_object_t _object_Kerror_sxs_activation_context_disabled;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_ASSEMBLY_NOT_FOUND))
  gcv_object_t _object_Kerror_sxs_assembly_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_CANT_GEN_ACTCTX))
  gcv_object_t _object_Kerror_sxs_cant_gen_actctx;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_DUPLICATE_ASSEMBLY_NAME))
  gcv_object_t _object_Kerror_sxs_duplicate_assembly_name;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_DUPLICATE_CLSID))
  gcv_object_t _object_Kerror_sxs_duplicate_clsid;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_DUPLICATE_DLL_NAME))
  gcv_object_t _object_Kerror_sxs_duplicate_dll_name;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_DUPLICATE_IID))
  gcv_object_t _object_Kerror_sxs_duplicate_iid;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_DUPLICATE_PROGID))
  gcv_object_t _object_Kerror_sxs_duplicate_progid;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_DUPLICATE_TLBID))
  gcv_object_t _object_Kerror_sxs_duplicate_tlbid;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_DUPLICATE_WINDOWCLASS_NAME))
  gcv_object_t _object_Kerror_sxs_duplicate_windowclass_name;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_FILE_HASH_MISMATCH))
  gcv_object_t _object_Kerror_sxs_file_hash_mismatch;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_INVALID_ACTCTXDATA_FORMAT))
  gcv_object_t _object_Kerror_sxs_invalid_actctxdata_format;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_INVALID_ASSEMBLY_IDENTITY_ATTRIBUTE))
  gcv_object_t _object_Kerror_sxs_invalid_assembly_identity_attribute;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_INVALID_ASSEMBLY_IDENTITY_ATTRIBUTE_NAME))
  gcv_object_t _object_Kerror_sxs_invalid_assembly_identity_attribute_name;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_INVALID_XML_NAMESPACE_URI))
  gcv_object_t _object_Kerror_sxs_invalid_xml_namespace_uri;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_KEY_NOT_FOUND))
  gcv_object_t _object_Kerror_sxs_key_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_LEAF_MANIFEST_DEPENDENCY_NOT_INSTALLED))
  gcv_object_t _object_Kerror_sxs_leaf_manifest_dependency_not_installed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_MANIFEST_FORMAT_ERROR))
  gcv_object_t _object_Kerror_sxs_manifest_format_error;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_MANIFEST_INVALID_REQUIRED_DEFAULT_NAMESPACE))
  gcv_object_t _object_Kerror_sxs_manifest_invalid_required_default_namespace;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_MANIFEST_MISSING_REQUIRED_DEFAULT_NAMESPACE))
  gcv_object_t _object_Kerror_sxs_manifest_missing_required_default_namespace;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_MANIFEST_PARSE_ERROR))
  gcv_object_t _object_Kerror_sxs_manifest_parse_error;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_MISSING_ASSEMBLY_IDENTITY_ATTRIBUTE))
  gcv_object_t _object_Kerror_sxs_missing_assembly_identity_attribute;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_POLICY_PARSE_ERROR))
  gcv_object_t _object_Kerror_sxs_policy_parse_error;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_PRIVATE_MANIFEST_CROSS_PATH_WITH_REPARSE_POINT))
  gcv_object_t _object_Kerror_sxs_private_manifest_cross_path_with_reparse_point;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_PROCESS_DEFAULT_ALREADY_SET))
  gcv_object_t _object_Kerror_sxs_process_default_already_set;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_PROTECTION_CATALOG_FILE_MISSING))
  gcv_object_t _object_Kerror_sxs_protection_catalog_file_missing;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_PROTECTION_CATALOG_NOT_VALID))
  gcv_object_t _object_Kerror_sxs_protection_catalog_not_valid;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_PROTECTION_PUBLIC_KEY_TOO_SHORT))
  gcv_object_t _object_Kerror_sxs_protection_public_key_too_short;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_PROTECTION_RECOVERY_FAILED))
  gcv_object_t _object_Kerror_sxs_protection_recovery_failed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_ROOT_MANIFEST_DEPENDENCY_NOT_INSTALLED))
  gcv_object_t _object_Kerror_sxs_root_manifest_dependency_not_installed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_SECTION_NOT_FOUND))
  gcv_object_t _object_Kerror_sxs_section_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_THREAD_QUERIES_DISABLED))
  gcv_object_t _object_Kerror_sxs_thread_queries_disabled;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_UNKNOWN_ENCODING))
  gcv_object_t _object_Kerror_sxs_unknown_encoding;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_UNKNOWN_ENCODING_GROUP))
  gcv_object_t _object_Kerror_sxs_unknown_encoding_group;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_UNTRANSLATABLE_HRESULT))
  gcv_object_t _object_Kerror_sxs_untranslatable_hresult;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_VERSION_CONFLICT))
  gcv_object_t _object_Kerror_sxs_version_conflict;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_WRONG_SECTION_TYPE))
  gcv_object_t _object_Kerror_sxs_wrong_section_type;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_BADCHARDATA))
  gcv_object_t _object_Kerror_sxs_xml_e_badchardata;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_BADCHARINSTRING))
  gcv_object_t _object_Kerror_sxs_xml_e_badcharinstring;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_BADNAMECHAR))
  gcv_object_t _object_Kerror_sxs_xml_e_badnamechar;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_BADPEREFINSUBSET))
  gcv_object_t _object_Kerror_sxs_xml_e_badperefinsubset;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_BADSTARTNAMECHAR))
  gcv_object_t _object_Kerror_sxs_xml_e_badstartnamechar;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_BADXMLCASE))
  gcv_object_t _object_Kerror_sxs_xml_e_badxmlcase;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_BADXMLDECL))
  gcv_object_t _object_Kerror_sxs_xml_e_badxmldecl;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_COMMENTSYNTAX))
  gcv_object_t _object_Kerror_sxs_xml_e_commentsyntax;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_DUPLICATEATTRIBUTE))
  gcv_object_t _object_Kerror_sxs_xml_e_duplicateattribute;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_EXPECTINGCLOSEQUOTE))
  gcv_object_t _object_Kerror_sxs_xml_e_expectingclosequote;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_EXPECTINGTAGEND))
  gcv_object_t _object_Kerror_sxs_xml_e_expectingtagend;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_INCOMPLETE_ENCODING))
  gcv_object_t _object_Kerror_sxs_xml_e_incomplete_encoding;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_INTERNALERROR))
  gcv_object_t _object_Kerror_sxs_xml_e_internalerror;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_INVALIDATROOTLEVEL))
  gcv_object_t _object_Kerror_sxs_xml_e_invalidatrootlevel;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_INVALIDENCODING))
  gcv_object_t _object_Kerror_sxs_xml_e_invalidencoding;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_INVALIDSWITCH))
  gcv_object_t _object_Kerror_sxs_xml_e_invalidswitch;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_INVALID_DECIMAL))
  gcv_object_t _object_Kerror_sxs_xml_e_invalid_decimal;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_INVALID_HEXIDECIMAL))
  gcv_object_t _object_Kerror_sxs_xml_e_invalid_hexidecimal;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_INVALID_STANDALONE))
  gcv_object_t _object_Kerror_sxs_xml_e_invalid_standalone;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_INVALID_UNICODE))
  gcv_object_t _object_Kerror_sxs_xml_e_invalid_unicode;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_INVALID_VERSION))
  gcv_object_t _object_Kerror_sxs_xml_e_invalid_version;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_MISSINGEQUALS))
  gcv_object_t _object_Kerror_sxs_xml_e_missingequals;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_MISSINGQUOTE))
  gcv_object_t _object_Kerror_sxs_xml_e_missingquote;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_MISSINGROOT))
  gcv_object_t _object_Kerror_sxs_xml_e_missingroot;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_MISSINGSEMICOLON))
  gcv_object_t _object_Kerror_sxs_xml_e_missingsemicolon;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_MISSINGWHITESPACE))
  gcv_object_t _object_Kerror_sxs_xml_e_missingwhitespace;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_MISSING_PAREN))
  gcv_object_t _object_Kerror_sxs_xml_e_missing_paren;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_MULTIPLEROOTS))
  gcv_object_t _object_Kerror_sxs_xml_e_multipleroots;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_MULTIPLE_COLONS))
  gcv_object_t _object_Kerror_sxs_xml_e_multiple_colons;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_RESERVEDNAMESPACE))
  gcv_object_t _object_Kerror_sxs_xml_e_reservednamespace;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_UNBALANCEDPAREN))
  gcv_object_t _object_Kerror_sxs_xml_e_unbalancedparen;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_UNCLOSEDCDATA))
  gcv_object_t _object_Kerror_sxs_xml_e_unclosedcdata;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_UNCLOSEDCOMMENT))
  gcv_object_t _object_Kerror_sxs_xml_e_unclosedcomment;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_UNCLOSEDDECL))
  gcv_object_t _object_Kerror_sxs_xml_e_uncloseddecl;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_UNCLOSEDENDTAG))
  gcv_object_t _object_Kerror_sxs_xml_e_unclosedendtag;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_UNCLOSEDSTARTTAG))
  gcv_object_t _object_Kerror_sxs_xml_e_unclosedstarttag;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_UNCLOSEDSTRING))
  gcv_object_t _object_Kerror_sxs_xml_e_unclosedstring;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_UNCLOSEDTAG))
  gcv_object_t _object_Kerror_sxs_xml_e_unclosedtag;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_UNEXPECTEDENDTAG))
  gcv_object_t _object_Kerror_sxs_xml_e_unexpectedendtag;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_UNEXPECTEDEOF))
  gcv_object_t _object_Kerror_sxs_xml_e_unexpectedeof;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_UNEXPECTED_STANDALONE))
  gcv_object_t _object_Kerror_sxs_xml_e_unexpected_standalone;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_UNEXPECTED_WHITESPACE))
  gcv_object_t _object_Kerror_sxs_xml_e_unexpected_whitespace;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_WHITESPACEORQUESTIONMARK))
  gcv_object_t _object_Kerror_sxs_xml_e_whitespaceorquestionmark;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_XMLDECLSYNTAX))
  gcv_object_t _object_Kerror_sxs_xml_e_xmldeclsyntax;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SYNC_FOREGROUND_REFRESH_REQUIRED))
  gcv_object_t _object_Kerror_sync_foreground_refresh_required;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SYSTEM_TRACE))
  gcv_object_t _object_Kerror_system_trace;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_TAG_NOT_FOUND))
  gcv_object_t _object_Kerror_tag_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_TAG_NOT_PRESENT))
  gcv_object_t _object_Kerror_tag_not_present;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_THREAD_1_INACTIVE))
  gcv_object_t _object_Kerror_thread_1_inactive;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_TIMEOUT))
  gcv_object_t _object_Kerror_timeout;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_TIME_SKEW))
  gcv_object_t _object_Kerror_time_skew;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_TLW_WITH_WSCHILD))
  gcv_object_t _object_Kerror_tlw_with_wschild;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_TOKEN_ALREADY_IN_USE))
  gcv_object_t _object_Kerror_token_already_in_use;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_TOO_MANY_CMDS))
  gcv_object_t _object_Kerror_too_many_cmds;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_TOO_MANY_CONTEXT_IDS))
  gcv_object_t _object_Kerror_too_many_context_ids;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_TOO_MANY_LINKS))
  gcv_object_t _object_Kerror_too_many_links;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_TOO_MANY_LUIDS_REQUESTED))
  gcv_object_t _object_Kerror_too_many_luids_requested;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_TOO_MANY_MODULES))
  gcv_object_t _object_Kerror_too_many_modules;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_TOO_MANY_MUXWAITERS))
  gcv_object_t _object_Kerror_too_many_muxwaiters;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_TOO_MANY_NAMES))
  gcv_object_t _object_Kerror_too_many_names;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_TOO_MANY_OPEN_FILES))
  gcv_object_t _object_Kerror_too_many_open_files;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_TOO_MANY_POSTS))
  gcv_object_t _object_Kerror_too_many_posts;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_TOO_MANY_SECRETS))
  gcv_object_t _object_Kerror_too_many_secrets;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_TOO_MANY_SEMAPHORES))
  gcv_object_t _object_Kerror_too_many_semaphores;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_TOO_MANY_SEM_REQUESTS))
  gcv_object_t _object_Kerror_too_many_sem_requests;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_TOO_MANY_SESS))
  gcv_object_t _object_Kerror_too_many_sess;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_TOO_MANY_SIDS))
  gcv_object_t _object_Kerror_too_many_sids;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_TOO_MANY_TCBS))
  gcv_object_t _object_Kerror_too_many_tcbs;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_TRANSFORM_NOT_SUPPORTED))
  gcv_object_t _object_Kerror_transform_not_supported;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_TRANSPORT_FULL))
  gcv_object_t _object_Kerror_transport_full;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_TRUSTED_DOMAIN_FAILURE))
  gcv_object_t _object_Kerror_trusted_domain_failure;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_TRUSTED_RELATIONSHIP_FAILURE))
  gcv_object_t _object_Kerror_trusted_relationship_failure;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_TRUST_FAILURE))
  gcv_object_t _object_Kerror_trust_failure;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_UNABLE_TO_CLEAN))
  gcv_object_t _object_Kerror_unable_to_clean;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_UNABLE_TO_EJECT_MOUNTED_MEDIA))
  gcv_object_t _object_Kerror_unable_to_eject_mounted_media;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_UNABLE_TO_INVENTORY_DRIVE))
  gcv_object_t _object_Kerror_unable_to_inventory_drive;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_UNABLE_TO_INVENTORY_SLOT))
  gcv_object_t _object_Kerror_unable_to_inventory_slot;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_UNABLE_TO_INVENTORY_TRANSPORT))
  gcv_object_t _object_Kerror_unable_to_inventory_transport;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_UNABLE_TO_LOAD_MEDIUM))
  gcv_object_t _object_Kerror_unable_to_load_medium;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_UNABLE_TO_LOCK_MEDIA))
  gcv_object_t _object_Kerror_unable_to_lock_media;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_UNABLE_TO_MOVE_REPLACEMENT))
  gcv_object_t _object_Kerror_unable_to_move_replacement;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_UNABLE_TO_MOVE_REPLACEMENT_2))
  gcv_object_t _object_Kerror_unable_to_move_replacement_2;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_UNABLE_TO_REMOVE_REPLACED))
  gcv_object_t _object_Kerror_unable_to_remove_replaced;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_UNABLE_TO_UNLOAD_MEDIA))
  gcv_object_t _object_Kerror_unable_to_unload_media;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_UNEXPECTED_OMID))
  gcv_object_t _object_Kerror_unexpected_omid;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_UNEXP_NET_ERR))
  gcv_object_t _object_Kerror_unexp_net_err;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_UNKNOWN_COMPONENT))
  gcv_object_t _object_Kerror_unknown_component;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_UNKNOWN_FEATURE))
  gcv_object_t _object_Kerror_unknown_feature;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_UNKNOWN_PORT))
  gcv_object_t _object_Kerror_unknown_port;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_UNKNOWN_PRINTER_DRIVER))
  gcv_object_t _object_Kerror_unknown_printer_driver;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_UNKNOWN_PRINTPROCESSOR))
  gcv_object_t _object_Kerror_unknown_printprocessor;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_UNKNOWN_PRINT_MONITOR))
  gcv_object_t _object_Kerror_unknown_print_monitor;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_UNKNOWN_PRODUCT))
  gcv_object_t _object_Kerror_unknown_product;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_UNKNOWN_PROPERTY))
  gcv_object_t _object_Kerror_unknown_property;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_UNKNOWN_REVISION))
  gcv_object_t _object_Kerror_unknown_revision;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_UNRECOGNIZED_MEDIA))
  gcv_object_t _object_Kerror_unrecognized_media;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_UNRECOGNIZED_VOLUME))
  gcv_object_t _object_Kerror_unrecognized_volume;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_UNSUPPORTED_TYPE))
  gcv_object_t _object_Kerror_unsupported_type;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_USER_DELETE_TRUST_QUOTA_EXCEEDED))
  gcv_object_t _object_Kerror_user_delete_trust_quota_exceeded;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_USER_EXISTS))
  gcv_object_t _object_Kerror_user_exists;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_USER_MAPPED_FILE))
  gcv_object_t _object_Kerror_user_mapped_file;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_VC_DISCONNECTED))
  gcv_object_t _object_Kerror_vc_disconnected;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_VOLUME_CONTAINS_SYS_FILES))
  gcv_object_t _object_Kerror_volume_contains_sys_files;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_VOLUME_NOT_SIS_ENABLED))
  gcv_object_t _object_Kerror_volume_not_sis_enabled;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_VOLUME_NOT_SUPPORT_EFS))
  gcv_object_t _object_Kerror_volume_not_support_efs;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_WAIT_NO_CHILDREN))
  gcv_object_t _object_Kerror_wait_no_children;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_WINDOW_NOT_COMBOBOX))
  gcv_object_t _object_Kerror_window_not_combobox;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_WINDOW_NOT_DIALOG))
  gcv_object_t _object_Kerror_window_not_dialog;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_WINDOW_OF_OTHER_THREAD))
  gcv_object_t _object_Kerror_window_of_other_thread;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_WINS_INTERNAL))
  gcv_object_t _object_Kerror_wins_internal;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_WMI_ALREADY_DISABLED))
  gcv_object_t _object_Kerror_wmi_already_disabled;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_WMI_ALREADY_ENABLED))
  gcv_object_t _object_Kerror_wmi_already_enabled;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_WMI_DP_FAILED))
  gcv_object_t _object_Kerror_wmi_dp_failed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_WMI_DP_NOT_FOUND))
  gcv_object_t _object_Kerror_wmi_dp_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_WMI_GUID_DISCONNECTED))
  gcv_object_t _object_Kerror_wmi_guid_disconnected;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_WMI_GUID_NOT_FOUND))
  gcv_object_t _object_Kerror_wmi_guid_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_WMI_INSTANCE_NOT_FOUND))
  gcv_object_t _object_Kerror_wmi_instance_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_WMI_INVALID_MOF))
  gcv_object_t _object_Kerror_wmi_invalid_mof;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_WMI_INVALID_REGINFO))
  gcv_object_t _object_Kerror_wmi_invalid_reginfo;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_WMI_ITEMID_NOT_FOUND))
  gcv_object_t _object_Kerror_wmi_itemid_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_WMI_READ_ONLY))
  gcv_object_t _object_Kerror_wmi_read_only;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_WMI_SERVER_UNAVAILABLE))
  gcv_object_t _object_Kerror_wmi_server_unavailable;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_WMI_SET_FAILURE))
  gcv_object_t _object_Kerror_wmi_set_failure;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_WMI_TRY_AGAIN))
  gcv_object_t _object_Kerror_wmi_try_again;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_WMI_UNRESOLVED_INSTANCE_REF))
  gcv_object_t _object_Kerror_wmi_unresolved_instance_ref;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_WORKING_SET_QUOTA))
  gcv_object_t _object_Kerror_working_set_quota;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_WRITE_FAULT))
  gcv_object_t _object_Kerror_write_fault;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_WRITE_PROTECT))
  gcv_object_t _object_Kerror_write_protect;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_WRONG_DISK))
  gcv_object_t _object_Kerror_wrong_disk;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_WRONG_EFS))
  gcv_object_t _object_Kerror_wrong_efs;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_WRONG_PASSWORD))
  gcv_object_t _object_Kerror_wrong_password;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_WRONG_TARGET_NAME))
  gcv_object_t _object_Kerror_wrong_target_name;
#endif
#if defined(ESHUTDOWN)
  gcv_object_t _object_Keshutdown;
#endif
#if defined(ESOCKTNOSUPPORT)
  gcv_object_t _object_Kesocktnosupport;
#endif
#if defined(ESPIPE)
  gcv_object_t _object_Kespipe;
#endif
#if defined(ESRCH)
  gcv_object_t _object_Kesrch;
#endif
#if defined(ESRMNT)
  gcv_object_t _object_Kesrmnt;
#endif
#if defined(ESTALE)
  gcv_object_t _object_Kestale;
#endif
#if defined(ESTRPIPE)
  gcv_object_t _object_Kestrpipe;
#endif
#if defined(ETIME)
  gcv_object_t _object_Ketime;
#endif
#if defined(ETIMEDOUT)
  gcv_object_t _object_Ketimedout;
#endif
#if defined(ETOOMANYREFS)
  gcv_object_t _object_Ketoomanyrefs;
#endif
#if defined(ETXTBSY)
  gcv_object_t _object_Ketxtbsy;
#endif
#if defined(EUCLEAN)
  gcv_object_t _object_Keuclean;
#endif
#if defined(EUNATCH)
  gcv_object_t _object_Keunatch;
#endif
#if defined(EUSERS)
  gcv_object_t _object_Keusers;
#endif
#if defined(EVERSION)
  gcv_object_t _object_Keversion;
#endif
#if defined(EWOULDBLOCK)
  gcv_object_t _object_Kewouldblock;
#endif
#if (defined(HAVE_FCNTL)) && (defined(O_EXCL))
  gcv_object_t _object_Kexcl;
#endif
#if defined(EXDEV)
  gcv_object_t _object_Kexdev;
#endif
#if defined(EXFULL)
  gcv_object_t _object_Kexfull;
#endif
#if defined(HAVE_SYS_RESOURCE_H)
  gcv_object_t _object_Kexited;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_EXPR_NEST_MAX))
  gcv_object_t _object_Kexpr_nest_max;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  gcv_object_t _object_Kext;
#endif
  gcv_object_t _object_Kexternal_format;
#if (defined(HAVE_NFTW)) && (defined(FTW_F))
  gcv_object_t _object_Kf;
#endif
#if (defined(HAVE_SYSLOG)) && (defined(HAVE_OPENLOG))
  gcv_object_t _object_Kfacility;
#endif
#if defined(S_IFBLK)
  gcv_object_t _object_Kfblk;
#endif
#if defined(S_IFCHR)
  gcv_object_t _object_Kfchr;
#endif
#if (defined(HAVE_FCNTL)) && (defined(F_GETFD))
  gcv_object_t _object_Kfd;
#endif
#if defined(S_IFDIR)
  gcv_object_t _object_Kfdir;
#endif
#if defined(HAVE_NFTW)
  gcv_object_t _object_Kfd_limit;
#endif
#if defined(S_IFIFO)
  gcv_object_t _object_Kfifo;
#endif
#if (defined(HAVE_PATHCONF) && defined(HAVE_FPATHCONF)) && (defined(_PC_FILESIZEBITS))
  gcv_object_t _object_Kfilesizebits;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  gcv_object_t _object_Kfiletime;
#endif
#if (defined(WIN32_NATIVE) || (defined(HAVE_STATVFS) && defined(HAVE_SYS_STATVFS_H))) && (defined(FILE_NAMED_STREAMS))
  gcv_object_t _object_Kfile_named_streams;
#endif
#if (defined(WIN32_NATIVE) || (defined(HAVE_STATVFS) && defined(HAVE_SYS_STATVFS_H))) && (defined(FILE_READ_ONLY_VOLUME))
  gcv_object_t _object_Kfile_read_only_volume;
#endif
#if (defined(WIN32_NATIVE) || (defined(HAVE_STATVFS) && defined(HAVE_SYS_STATVFS_H))) && (defined(FILE_SUPPORTS_ENCRYPTION))
  gcv_object_t _object_Kfile_supports_encryption;
#endif
#if (defined(WIN32_NATIVE) || (defined(HAVE_STATVFS) && defined(HAVE_SYS_STATVFS_H))) && (defined(FILE_SUPPORTS_OBJECT_IDS))
  gcv_object_t _object_Kfile_supports_object_ids;
#endif
#if (defined(WIN32_NATIVE) || (defined(HAVE_STATVFS) && defined(HAVE_SYS_STATVFS_H))) && (defined(FILE_SUPPORTS_REPARSE_POINTS))
  gcv_object_t _object_Kfile_supports_reparse_points;
#endif
#if (defined(WIN32_NATIVE) || (defined(HAVE_STATVFS) && defined(HAVE_SYS_STATVFS_H))) && (defined(FILE_SUPPORTS_SPARSE_FILES))
  gcv_object_t _object_Kfile_supports_sparse_files;
#endif
#if (defined(WIN32_NATIVE) || (defined(HAVE_STATVFS) && defined(HAVE_SYS_STATVFS_H))) && (defined(FILE_VOLUME_QUOTAS))
  gcv_object_t _object_Kfile_volume_quotas;
#endif
#if (defined(HAVE_FCNTL)) && (defined(F_GETFL))
  gcv_object_t _object_Kfl;
#endif
#if defined(S_IFREG)
  gcv_object_t _object_Kfreg;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(FRS_ERR_AUTHENTICATION))
  gcv_object_t _object_Kfrs_err_authentication;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(FRS_ERR_CHILD_TO_PARENT_COMM))
  gcv_object_t _object_Kfrs_err_child_to_parent_comm;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(FRS_ERR_INSUFFICIENT_PRIV))
  gcv_object_t _object_Kfrs_err_insufficient_priv;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(FRS_ERR_INTERNAL))
  gcv_object_t _object_Kfrs_err_internal;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(FRS_ERR_INTERNAL_API))
  gcv_object_t _object_Kfrs_err_internal_api;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(FRS_ERR_INVALID_API_SEQUENCE))
  gcv_object_t _object_Kfrs_err_invalid_api_sequence;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(FRS_ERR_INVALID_SERVICE_PARAMETER))
  gcv_object_t _object_Kfrs_err_invalid_service_parameter;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(FRS_ERR_PARENT_AUTHENTICATION))
  gcv_object_t _object_Kfrs_err_parent_authentication;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(FRS_ERR_PARENT_INSUFFICIENT_PRIV))
  gcv_object_t _object_Kfrs_err_parent_insufficient_priv;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(FRS_ERR_PARENT_TO_CHILD_COMM))
  gcv_object_t _object_Kfrs_err_parent_to_child_comm;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(FRS_ERR_SERVICE_COMM))
  gcv_object_t _object_Kfrs_err_service_comm;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(FRS_ERR_STARTING_SERVICE))
  gcv_object_t _object_Kfrs_err_starting_service;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(FRS_ERR_STOPPING_SERVICE))
  gcv_object_t _object_Kfrs_err_stopping_service;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(FRS_ERR_SYSVOL_DEMOTE))
  gcv_object_t _object_Kfrs_err_sysvol_demote;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(FRS_ERR_SYSVOL_IS_BUSY))
  gcv_object_t _object_Kfrs_err_sysvol_is_busy;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(FRS_ERR_SYSVOL_POPULATE))
  gcv_object_t _object_Kfrs_err_sysvol_populate;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(FRS_ERR_SYSVOL_POPULATE_TIMEOUT))
  gcv_object_t _object_Kfrs_err_sysvol_populate_timeout;
#endif
#if (defined(HAVE_GETRLIMIT) || defined(HAVE_SETRLIMIT)) && (defined(RLIMIT_FSIZE))
  gcv_object_t _object_Kfsize;
#endif
#if defined(S_IFSOCK)
  gcv_object_t _object_Kfsock;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_FSYNC))
  gcv_object_t _object_Kfsync;
#endif
#if (defined(WIN32_NATIVE) || (defined(HAVE_STATVFS) && defined(HAVE_SYS_STATVFS_H))) && (defined(FS_CASE_IS_PRESERVED))
  gcv_object_t _object_Kfs_case_is_preserved;
#endif
#if (defined(WIN32_NATIVE) || (defined(HAVE_STATVFS) && defined(HAVE_SYS_STATVFS_H))) && (defined(FS_CASE_SENSITIVE))
  gcv_object_t _object_Kfs_case_sensitive;
#endif
#if (defined(WIN32_NATIVE) || (defined(HAVE_STATVFS) && defined(HAVE_SYS_STATVFS_H))) && (defined(FS_FILE_COMPRESSION))
  gcv_object_t _object_Kfs_file_compression;
#endif
#if (defined(WIN32_NATIVE) || (defined(HAVE_STATVFS) && defined(HAVE_SYS_STATVFS_H))) && (defined(FS_FILE_ENCRYPTION))
  gcv_object_t _object_Kfs_file_encryption;
#endif
#if (defined(WIN32_NATIVE) || (defined(HAVE_STATVFS) && defined(HAVE_SYS_STATVFS_H))) && (defined(FS_PERSISTENT_ACLS))
  gcv_object_t _object_Kfs_persistent_acls;
#endif
#if (defined(WIN32_NATIVE) || (defined(HAVE_STATVFS) && defined(HAVE_SYS_STATVFS_H))) && (defined(FS_UNICODE_STORED_ON_DISK))
  gcv_object_t _object_Kfs_unicode_stored_on_disk;
#endif
#if (defined(WIN32_NATIVE) || (defined(HAVE_STATVFS) && defined(HAVE_SYS_STATVFS_H))) && (defined(FS_VOL_IS_COMPRESSED))
  gcv_object_t _object_Kfs_vol_is_compressed;
#endif
#if (defined(HAVE_SYSLOG)) && (defined(LOG_FTP))
  gcv_object_t _object_Kftp;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_GETGR_R_SIZE_MAX))
  gcv_object_t _object_Kgetgr_r_size_max;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_GETPW_R_SIZE_MAX))
  gcv_object_t _object_Kgetpw_r_size_max;
#endif
#if defined(HAVE_STAT) && (defined(HAVE_CHMOD) || defined(HAVE_CHOWN) || defined(HAVE_UTIME))
  gcv_object_t _object_Kgid;
#endif
  gcv_object_t _object_Khardlink;
  gcv_object_t _object_Khardlink_or_copy;
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(FILE_ATTRIBUTE_HIDDEN))
  gcv_object_t _object_Khidden;
#endif
#if ((defined(WIN32_NATIVE)) && (defined(HIGH_PRIORITY_CLASS))) || (!(defined(WIN32_NATIVE)))
  gcv_object_t _object_Khigh;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_HOST_NAME_MAX))
  gcv_object_t _object_Khost_name_max;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  gcv_object_t _object_Khot_key;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  gcv_object_t _object_Ki1;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  gcv_object_t _object_Ki2;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  gcv_object_t _object_Ki4;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  gcv_object_t _object_Ki8;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(PROCESSOR_ARCHITECTURE_IA32_ON_WIN64))
  gcv_object_t _object_Kia32_on_win64;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(PROCESSOR_ARCHITECTURE_IA64))
  gcv_object_t _object_Kia64;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  gcv_object_t _object_Kicon;
#endif
#if ((defined(WIN32_NATIVE)) && (defined(IDLE_PRIORITY_CLASS))) || (!(defined(WIN32_NATIVE)))
  gcv_object_t _object_Kidle;
#endif
  gcv_object_t _object_Kif_does_not_exist;
  gcv_object_t _object_Kif_exists;
#if (defined(HAVE_SYSLOG)) && (defined(LOG_INFO))
  gcv_object_t _object_Kinfo;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  gcv_object_t _object_Kinitid;
#endif
#if (defined(HAVE_UTMPX_H)) && (defined(INIT_PROCESS))
  gcv_object_t _object_Kinit_process;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  gcv_object_t _object_Kint;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(PROCESSOR_ARCHITECTURE_INTEL))
  gcv_object_t _object_Kintel;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_IOV_MAX))
  gcv_object_t _object_Kiov_max;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_IPV6))
  gcv_object_t _object_Kipv6;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_JOB_CONTROL))
  gcv_object_t _object_Kjob_control;
#endif
#if (defined(HAVE_SYSLOG)) && (defined(LOG_KERN))
  gcv_object_t _object_Kkern;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  gcv_object_t _object_Kkeywords;
#endif
#if (defined(HAVE_FCNTL)) && (defined(O_LARGEFILE))
  gcv_object_t _object_Klargefile;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  gcv_object_t _object_Klastauthor;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  gcv_object_t _object_Klastprinted;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  gcv_object_t _object_Klastsave_dtm;
#endif
#if defined(HAVE_FCNTL) || defined(WIN32_NATIVE)
  gcv_object_t _object_Klength;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_LINE_MAX))
  gcv_object_t _object_Kline_max;
#endif
#if (defined(HAVE_PATHCONF) && defined(HAVE_FPATHCONF)) && (defined(_PC_LINK_MAX))
  gcv_object_t _object_Klink_max;
#endif
#if (defined(HAVE_SYSLOG)) && (defined(LOG_LOCAL0))
  gcv_object_t _object_Klocal0;
#endif
#if (defined(HAVE_SYSLOG)) && (defined(LOG_LOCAL1))
  gcv_object_t _object_Klocal1;
#endif
#if (defined(HAVE_SYSLOG)) && (defined(LOG_LOCAL2))
  gcv_object_t _object_Klocal2;
#endif
#if (defined(HAVE_SYSLOG)) && (defined(LOG_LOCAL3))
  gcv_object_t _object_Klocal3;
#endif
#if (defined(HAVE_SYSLOG)) && (defined(LOG_LOCAL4))
  gcv_object_t _object_Klocal4;
#endif
#if (defined(HAVE_SYSLOG)) && (defined(LOG_LOCAL5))
  gcv_object_t _object_Klocal5;
#endif
#if (defined(HAVE_SYSLOG)) && (defined(LOG_LOCAL6))
  gcv_object_t _object_Klocal6;
#endif
#if (defined(HAVE_SYSLOG)) && (defined(LOG_LOCAL7))
  gcv_object_t _object_Klocal7;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  gcv_object_t _object_Klocale;
#endif
#if (defined(HAVE_GETRLIMIT) || defined(HAVE_SETRLIMIT)) && (defined(RLIMIT_LOCKS))
  gcv_object_t _object_Klocks;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_LOGIN_NAME_MAX))
  gcv_object_t _object_Klogin_name_max;
#endif
#if (defined(HAVE_UTMPX_H)) && (defined(LOGIN_PROCESS))
  gcv_object_t _object_Klogin_process;
#endif
#if ((defined(WIN32_NATIVE)) && (defined(LOW_PRIORITY_CLASS))) || (!(defined(WIN32_NATIVE)))
  gcv_object_t _object_Klow;
#endif
#if (defined(HAVE_SYSLOG)) && (defined(LOG_LPR))
  gcv_object_t _object_Klpr;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  gcv_object_t _object_Klpstr;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  gcv_object_t _object_Klpwstr;
#endif
#if (defined(HAVE_SYS_RESOURCE_H)) && (defined(HAVE_GETRUSAGE)) && (defined(RUSAGE_LWP))
  gcv_object_t _object_Klwp;
#endif
#if (defined(HAVE_SYSLOG)) && (defined(LOG_MAIL))
  gcv_object_t _object_Kmail;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_MAPPED_FILES))
  gcv_object_t _object_Kmapped_files;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  gcv_object_t _object_Kmax;
#endif
#if (defined(HAVE_PATHCONF) && defined(HAVE_FPATHCONF)) && (defined(_PC_MAX_CANON))
  gcv_object_t _object_Kmax_canon;
#endif
#if (defined(HAVE_PATHCONF) && defined(HAVE_FPATHCONF)) && (defined(_PC_MAX_INPUT))
  gcv_object_t _object_Kmax_input;
#endif
#if ((defined(HAVE_SYSCONF)) && (defined(_SC_MEMLOCK))) || ((defined(HAVE_GETRLIMIT) || defined(HAVE_SETRLIMIT)) && (defined(RLIMIT_MEMLOCK)))
  gcv_object_t _object_Kmemlock;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_MEMLOCK_RANGE))
  gcv_object_t _object_Kmemlock_range;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_MEMORY_PROTECTION))
  gcv_object_t _object_Kmemory_protection;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_MESSAGE_PASSING))
  gcv_object_t _object_Kmessage_passing;
#endif
  gcv_object_t _object_Kmethod;
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  gcv_object_t _object_Kmin;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(PROCESSOR_ARCHITECTURE_MIPS))
  gcv_object_t _object_Kmips;
#endif
#if defined(HAVE_STAT) && (defined(HAVE_CHMOD) || defined(HAVE_CHOWN) || defined(HAVE_UTIME))
  gcv_object_t _object_Kmode;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_MONOTONIC_CLOCK))
  gcv_object_t _object_Kmonotonic_clock;
#endif
#if defined(HAVE_NFTW)
  gcv_object_t _object_Kmount;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_MQ_OPEN_MAX))
  gcv_object_t _object_Kmq_open_max;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_MQ_PRIO_MAX))
  gcv_object_t _object_Kmq_prio_max;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(PROCESSOR_ARCHITECTURE_MSIL))
  gcv_object_t _object_Kmsil;
#endif
#if defined(HAVE_STAT) && (defined(HAVE_CHMOD) || defined(HAVE_CHOWN) || defined(HAVE_UTIME))
  gcv_object_t _object_Kmtime;
#endif
#if (defined(HAVE_PATHCONF) && defined(HAVE_FPATHCONF)) && (defined(_PC_NAME_MAX))
  gcv_object_t _object_Kname_max;
#endif
#if (defined(HAVE_SYSLOG)) && (defined(HAVE_OPENLOG))
  gcv_object_t _object_Kndelay;
#endif
#if (defined(HAVE_SYSLOG)) && (defined(LOG_NEWS))
  gcv_object_t _object_Knews;
#endif
#if (defined(HAVE_UTMPX_H)) && (defined(NEW_TIME))
  gcv_object_t _object_Knew_time;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_NGROUPS_MAX))
  gcv_object_t _object_Kngroups_max;
#endif
#if (defined(HAVE_FCNTL)) && (defined(O_NOCTTY))
  gcv_object_t _object_Knoctty;
#endif
  gcv_object_t _object_Knoescape;
#if (defined(HAVE_GETRLIMIT) || defined(HAVE_SETRLIMIT)) && (defined(RLIMIT_NOFILE))
  gcv_object_t _object_Knofile;
#endif
#if (defined(HAVE_FCNTL)) && (defined(O_NOFOLLOW))
  gcv_object_t _object_Knofollow;
#endif
#if defined(HAVE_SYS_RESOURCE_H)
  gcv_object_t _object_Knohang;
#endif
#if (defined(HAVE_FCNTL)) && (defined(O_NOINHERIT))
  gcv_object_t _object_Knoinherit;
#endif
#if (defined(HAVE_FCNTL)) && (defined(O_NONBLOCK))
  gcv_object_t _object_Knonblock;
#endif
#if ((defined(WIN32_NATIVE)) && (defined(NORMAL_PRIORITY_CLASS))) || (!(defined(WIN32_NATIVE))) || ((defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(FILE_ATTRIBUTE_NORMAL)))
  gcv_object_t _object_Knormal;
#endif
#if (defined(HAVE_SYSLOG)) && (defined(LOG_NOTICE))
  gcv_object_t _object_Knotice;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  gcv_object_t _object_Knotimplemented;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(FILE_ATTRIBUTE_NOT_CONTENT_INDEXED))
  gcv_object_t _object_Knot_content_indexed;
#endif
#if ((defined(HAVE_SYSLOG)) && (defined(HAVE_OPENLOG))) || (defined(HAVE_SYS_RESOURCE_H))
  gcv_object_t _object_Knowait;
#endif
#if (defined(HAVE_PATHCONF) && defined(HAVE_FPATHCONF)) && (defined(_PC_NO_TRUNC))
  gcv_object_t _object_Kno_trunc;
#endif
#if (defined(HAVE_GETRLIMIT) || defined(HAVE_SETRLIMIT)) && (defined(RLIMIT_NPROC))
  gcv_object_t _object_Knproc;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_NPROCESSORS_CONF))
  gcv_object_t _object_Knprocessors_conf;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_NPROCESSORS_ONLN))
  gcv_object_t _object_Knprocessors_onln;
#endif
#if (defined(HAVE_NFTW)) && (defined(FTW_NS))
  gcv_object_t _object_Kns;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  gcv_object_t _object_Knt;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  gcv_object_t _object_Knull;
#endif
#if (defined(HAVE_SYSLOG)) && (defined(HAVE_OPENLOG))
  gcv_object_t _object_Kodelay;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(FILE_ATTRIBUTE_OFFLINE))
  gcv_object_t _object_Koffline;
#endif
#if (defined(HAVE_UTMPX_H)) && (defined(OLD_TIME))
  gcv_object_t _object_Kold_time;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_OPEN_MAX))
  gcv_object_t _object_Kopen_max;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(OR_INVALID_OID))
  gcv_object_t _object_Kor_invalid_oid;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(OR_INVALID_OXID))
  gcv_object_t _object_Kor_invalid_oxid;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(OR_INVALID_SET))
  gcv_object_t _object_Kor_invalid_set;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  gcv_object_t _object_Kpagecount;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_PAGESIZE))
  gcv_object_t _object_Kpagesize;
#endif
#if ((defined(HAVE_CONFSTR)) && (defined(_CS_PATH))) || (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN))
  gcv_object_t _object_Kpath;
#endif
  gcv_object_t _object_Kpathname;
#if (defined(HAVE_PATHCONF) && defined(HAVE_FPATHCONF)) && (defined(_PC_PATH_MAX))
  gcv_object_t _object_Kpath_max;
#endif
  gcv_object_t _object_Kperiod;
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  gcv_object_t _object_Kpersonal;
#endif
#if defined(PRIO_PGRP)
  gcv_object_t _object_Kpgrp;
#endif
#if defined(HAVE_NFTW)
  gcv_object_t _object_Kphys;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_PHYS_PAGES))
  gcv_object_t _object_Kphys_pages;
#endif
#if ((defined(HAVE_SYSLOG)) && (defined(HAVE_OPENLOG))) || (defined(HAVE_SYS_RESOURCE_H))
  gcv_object_t _object_Kpid;
#endif
#if (defined(HAVE_PATHCONF) && defined(HAVE_FPATHCONF)) && (defined(_PC_PIPE_BUF))
  gcv_object_t _object_Kpipe_buf;
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_POSIX_V6_ILP32_OFF32_CFLAGS))
  gcv_object_t _object_Kposix_v6_ilp32_off32_cflags;
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_POSIX_V6_ILP32_OFF32_LDFLAGS))
  gcv_object_t _object_Kposix_v6_ilp32_off32_ldflags;
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_POSIX_V6_ILP32_OFF32_LIBS))
  gcv_object_t _object_Kposix_v6_ilp32_off32_libs;
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_POSIX_V6_ILP32_OFFBIG_CFLAGS))
  gcv_object_t _object_Kposix_v6_ilp32_offbig_cflags;
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_POSIX_V6_ILP32_OFFBIG_LDFLAGS))
  gcv_object_t _object_Kposix_v6_ilp32_offbig_ldflags;
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_POSIX_V6_ILP32_OFFBIG_LIBS))
  gcv_object_t _object_Kposix_v6_ilp32_offbig_libs;
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_POSIX_V6_LP64_OFF64_CFLAGS))
  gcv_object_t _object_Kposix_v6_lp64_off64_cflags;
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_POSIX_V6_LP64_OFF64_LDFLAGS))
  gcv_object_t _object_Kposix_v6_lp64_off64_ldflags;
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_POSIX_V6_LP64_OFF64_LIBS))
  gcv_object_t _object_Kposix_v6_lp64_off64_libs;
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_POSIX_V6_LPBIG_OFFBIG_CFLAGS))
  gcv_object_t _object_Kposix_v6_lpbig_offbig_cflags;
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_POSIX_V6_LPBIG_OFFBIG_LDFLAGS))
  gcv_object_t _object_Kposix_v6_lpbig_offbig_ldflags;
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_POSIX_V6_LPBIG_OFFBIG_LIBS))
  gcv_object_t _object_Kposix_v6_lpbig_offbig_libs;
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_POSIX_V6_WIDTH_RESTRICTED_ENVS))
  gcv_object_t _object_Kposix_v6_width_restricted_envs;
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_POSIX_V7_ILP32_OFF32_CFLAGS))
  gcv_object_t _object_Kposix_v7_ilp32_off32_cflags;
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_POSIX_V7_ILP32_OFF32_LDFLAGS))
  gcv_object_t _object_Kposix_v7_ilp32_off32_ldflags;
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_POSIX_V7_ILP32_OFF32_LIBS))
  gcv_object_t _object_Kposix_v7_ilp32_off32_libs;
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_POSIX_V7_ILP32_OFFBIG_CFLAGS))
  gcv_object_t _object_Kposix_v7_ilp32_offbig_cflags;
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_POSIX_V7_ILP32_OFFBIG_LDFLAGS))
  gcv_object_t _object_Kposix_v7_ilp32_offbig_ldflags;
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_POSIX_V7_ILP32_OFFBIG_LIBS))
  gcv_object_t _object_Kposix_v7_ilp32_offbig_libs;
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_POSIX_V7_LP64_OFF64_CFLAGS))
  gcv_object_t _object_Kposix_v7_lp64_off64_cflags;
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_POSIX_V7_LP64_OFF64_LDFLAGS))
  gcv_object_t _object_Kposix_v7_lp64_off64_ldflags;
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_POSIX_V7_LP64_OFF64_LIBS))
  gcv_object_t _object_Kposix_v7_lp64_off64_libs;
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_POSIX_V7_LPBIG_OFFBIG_CFLAGS))
  gcv_object_t _object_Kposix_v7_lpbig_offbig_cflags;
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_POSIX_V7_LPBIG_OFFBIG_LDFLAGS))
  gcv_object_t _object_Kposix_v7_lpbig_offbig_ldflags;
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_POSIX_V7_LPBIG_OFFBIG_LIBS))
  gcv_object_t _object_Kposix_v7_lpbig_offbig_libs;
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_POSIX_V7_THREADS_CFLAGS))
  gcv_object_t _object_Kposix_v7_threads_cflags;
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_POSIX_V7_THREADS_LDFLAGS))
  gcv_object_t _object_Kposix_v7_threads_ldflags;
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_POSIX_V7_WIDTH_RESTRICTED_ENVS))
  gcv_object_t _object_Kposix_v7_width_restricted_envs;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(PROCESSOR_ARCHITECTURE_PPC))
  gcv_object_t _object_Kppc;
#endif
  gcv_object_t _object_Kpreserve;
#if (defined(HAVE_SYSCONF)) && (defined(_SC_PRIORITIZED_IO))
  gcv_object_t _object_Kprioritized_io;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_PRIORITY_SCHEDULING))
  gcv_object_t _object_Kpriority_scheduling;
#endif
#if (defined(HAVE_PATHCONF) && defined(HAVE_FPATHCONF)) && (defined(_PC_PRIO_IO))
  gcv_object_t _object_Kprio_io;
#endif
#if defined(PRIO_PROCESS)
  gcv_object_t _object_Kprocess;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  gcv_object_t _object_Kr4;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  gcv_object_t _object_Kr8;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_RAW_SOCKETS))
  gcv_object_t _object_Kraw_sockets;
#endif
#if defined(HAVE_FCNTL)
  gcv_object_t _object_Krdonly;
#endif
#if defined(HAVE_FCNTL)
  gcv_object_t _object_Krdwr;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_READER_WRITER_LOCKS))
  gcv_object_t _object_Kreader_writer_locks;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(FILE_ATTRIBUTE_READONLY))
  gcv_object_t _object_Kreadonly;
#endif
#if ((defined(WIN32_NATIVE)) && (defined(REALTIME_PRIORITY_CLASS))) || (!(defined(WIN32_NATIVE)))
  gcv_object_t _object_Krealtime;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_REALTIME_SIGNALS))
  gcv_object_t _object_Krealtime_signals;
#endif
#if (defined(HAVE_PATHCONF) && defined(HAVE_FPATHCONF)) && (defined(_PC_REC_INCR_XFER_SIZE))
  gcv_object_t _object_Krec_incr_xfer_size;
#endif
#if (defined(HAVE_PATHCONF) && defined(HAVE_FPATHCONF)) && (defined(_PC_REC_MAX_XFER_SIZE))
  gcv_object_t _object_Krec_max_xfer_size;
#endif
#if (defined(HAVE_PATHCONF) && defined(HAVE_FPATHCONF)) && (defined(_PC_REC_MIN_XFER_SIZE))
  gcv_object_t _object_Krec_min_xfer_size;
#endif
#if (defined(HAVE_PATHCONF) && defined(HAVE_FPATHCONF)) && (defined(_PC_REC_XFER_ALIGN))
  gcv_object_t _object_Krec_xfer_align;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_REGEXP))
  gcv_object_t _object_Kregexp;
#endif
  gcv_object_t _object_Krename;
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(FILE_ATTRIBUTE_REPARSE_POINT))
  gcv_object_t _object_Kreparse_point;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  gcv_object_t _object_Krevnumber;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_RE_DUP_MAX))
  gcv_object_t _object_Kre_dup_max;
#endif
#if defined(S_IRGRP)
  gcv_object_t _object_Krgrp;
#endif
#if defined(S_IROTH)
  gcv_object_t _object_Kroth;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_ADDRESS_ERROR))
  gcv_object_t _object_Krpc_s_address_error;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_ALREADY_LISTENING))
  gcv_object_t _object_Krpc_s_already_listening;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_ALREADY_REGISTERED))
  gcv_object_t _object_Krpc_s_already_registered;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_BINDING_HAS_NO_AUTH))
  gcv_object_t _object_Krpc_s_binding_has_no_auth;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_BINDING_INCOMPLETE))
  gcv_object_t _object_Krpc_s_binding_incomplete;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_CALL_CANCELLED))
  gcv_object_t _object_Krpc_s_call_cancelled;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_CALL_FAILED))
  gcv_object_t _object_Krpc_s_call_failed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_CALL_FAILED_DNE))
  gcv_object_t _object_Krpc_s_call_failed_dne;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_CALL_IN_PROGRESS))
  gcv_object_t _object_Krpc_s_call_in_progress;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_CANNOT_SUPPORT))
  gcv_object_t _object_Krpc_s_cannot_support;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_CANT_CREATE_ENDPOINT))
  gcv_object_t _object_Krpc_s_cant_create_endpoint;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_COMM_FAILURE))
  gcv_object_t _object_Krpc_s_comm_failure;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_DUPLICATE_ENDPOINT))
  gcv_object_t _object_Krpc_s_duplicate_endpoint;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_ENTRY_ALREADY_EXISTS))
  gcv_object_t _object_Krpc_s_entry_already_exists;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_ENTRY_NOT_FOUND))
  gcv_object_t _object_Krpc_s_entry_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_ENTRY_TYPE_MISMATCH))
  gcv_object_t _object_Krpc_s_entry_type_mismatch;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_FP_DIV_ZERO))
  gcv_object_t _object_Krpc_s_fp_div_zero;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_FP_OVERFLOW))
  gcv_object_t _object_Krpc_s_fp_overflow;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_FP_UNDERFLOW))
  gcv_object_t _object_Krpc_s_fp_underflow;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_GROUP_MEMBER_NOT_FOUND))
  gcv_object_t _object_Krpc_s_group_member_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_GRP_ELT_NOT_ADDED))
  gcv_object_t _object_Krpc_s_grp_elt_not_added;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_GRP_ELT_NOT_REMOVED))
  gcv_object_t _object_Krpc_s_grp_elt_not_removed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_INCOMPLETE_NAME))
  gcv_object_t _object_Krpc_s_incomplete_name;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_INTERFACE_NOT_EXPORTED))
  gcv_object_t _object_Krpc_s_interface_not_exported;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_INTERFACE_NOT_FOUND))
  gcv_object_t _object_Krpc_s_interface_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_INTERNAL_ERROR))
  gcv_object_t _object_Krpc_s_internal_error;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_INVALID_ASYNC_CALL))
  gcv_object_t _object_Krpc_s_invalid_async_call;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_INVALID_ASYNC_HANDLE))
  gcv_object_t _object_Krpc_s_invalid_async_handle;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_INVALID_AUTH_IDENTITY))
  gcv_object_t _object_Krpc_s_invalid_auth_identity;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_INVALID_BINDING))
  gcv_object_t _object_Krpc_s_invalid_binding;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_INVALID_BOUND))
  gcv_object_t _object_Krpc_s_invalid_bound;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_INVALID_ENDPOINT_FORMAT))
  gcv_object_t _object_Krpc_s_invalid_endpoint_format;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_INVALID_NAF_ID))
  gcv_object_t _object_Krpc_s_invalid_naf_id;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_INVALID_NAME_SYNTAX))
  gcv_object_t _object_Krpc_s_invalid_name_syntax;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_INVALID_NETWORK_OPTIONS))
  gcv_object_t _object_Krpc_s_invalid_network_options;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_INVALID_NET_ADDR))
  gcv_object_t _object_Krpc_s_invalid_net_addr;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_INVALID_OBJECT))
  gcv_object_t _object_Krpc_s_invalid_object;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_INVALID_RPC_PROTSEQ))
  gcv_object_t _object_Krpc_s_invalid_rpc_protseq;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_INVALID_STRING_BINDING))
  gcv_object_t _object_Krpc_s_invalid_string_binding;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_INVALID_STRING_UUID))
  gcv_object_t _object_Krpc_s_invalid_string_uuid;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_INVALID_TAG))
  gcv_object_t _object_Krpc_s_invalid_tag;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_INVALID_TIMEOUT))
  gcv_object_t _object_Krpc_s_invalid_timeout;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_INVALID_VERS_OPTION))
  gcv_object_t _object_Krpc_s_invalid_vers_option;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_MAX_CALLS_TOO_SMALL))
  gcv_object_t _object_Krpc_s_max_calls_too_small;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_NAME_SERVICE_UNAVAILABLE))
  gcv_object_t _object_Krpc_s_name_service_unavailable;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_NOTHING_TO_EXPORT))
  gcv_object_t _object_Krpc_s_nothing_to_export;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_NOT_ALL_OBJS_EXPORTED))
  gcv_object_t _object_Krpc_s_not_all_objs_exported;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_NOT_ALL_OBJS_UNEXPORTED))
  gcv_object_t _object_Krpc_s_not_all_objs_unexported;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_NOT_CANCELLED))
  gcv_object_t _object_Krpc_s_not_cancelled;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_NOT_LISTENING))
  gcv_object_t _object_Krpc_s_not_listening;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_NOT_RPC_ERROR))
  gcv_object_t _object_Krpc_s_not_rpc_error;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_NO_BINDINGS))
  gcv_object_t _object_Krpc_s_no_bindings;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_NO_CALL_ACTIVE))
  gcv_object_t _object_Krpc_s_no_call_active;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_NO_CONTEXT_AVAILABLE))
  gcv_object_t _object_Krpc_s_no_context_available;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_NO_ENDPOINT_FOUND))
  gcv_object_t _object_Krpc_s_no_endpoint_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_NO_ENTRY_NAME))
  gcv_object_t _object_Krpc_s_no_entry_name;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_NO_INTERFACES))
  gcv_object_t _object_Krpc_s_no_interfaces;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_NO_MORE_BINDINGS))
  gcv_object_t _object_Krpc_s_no_more_bindings;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_NO_MORE_MEMBERS))
  gcv_object_t _object_Krpc_s_no_more_members;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_NO_PRINC_NAME))
  gcv_object_t _object_Krpc_s_no_princ_name;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_NO_PROTSEQS))
  gcv_object_t _object_Krpc_s_no_protseqs;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_NO_PROTSEQS_REGISTERED))
  gcv_object_t _object_Krpc_s_no_protseqs_registered;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_OBJECT_NOT_FOUND))
  gcv_object_t _object_Krpc_s_object_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_OUT_OF_RESOURCES))
  gcv_object_t _object_Krpc_s_out_of_resources;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_PRF_ELT_NOT_ADDED))
  gcv_object_t _object_Krpc_s_prf_elt_not_added;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_PRF_ELT_NOT_REMOVED))
  gcv_object_t _object_Krpc_s_prf_elt_not_removed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_PROCNUM_OUT_OF_RANGE))
  gcv_object_t _object_Krpc_s_procnum_out_of_range;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_PROFILE_NOT_ADDED))
  gcv_object_t _object_Krpc_s_profile_not_added;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_PROTOCOL_ERROR))
  gcv_object_t _object_Krpc_s_protocol_error;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_PROTSEQ_NOT_FOUND))
  gcv_object_t _object_Krpc_s_protseq_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_PROTSEQ_NOT_SUPPORTED))
  gcv_object_t _object_Krpc_s_protseq_not_supported;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_SEC_PKG_ERROR))
  gcv_object_t _object_Krpc_s_sec_pkg_error;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_SEND_INCOMPLETE))
  gcv_object_t _object_Krpc_s_send_incomplete;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_SERVER_TOO_BUSY))
  gcv_object_t _object_Krpc_s_server_too_busy;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_SERVER_UNAVAILABLE))
  gcv_object_t _object_Krpc_s_server_unavailable;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_STRING_TOO_LONG))
  gcv_object_t _object_Krpc_s_string_too_long;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_TYPE_ALREADY_REGISTERED))
  gcv_object_t _object_Krpc_s_type_already_registered;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_UNKNOWN_AUTHN_LEVEL))
  gcv_object_t _object_Krpc_s_unknown_authn_level;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_UNKNOWN_AUTHN_SERVICE))
  gcv_object_t _object_Krpc_s_unknown_authn_service;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_UNKNOWN_AUTHN_TYPE))
  gcv_object_t _object_Krpc_s_unknown_authn_type;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_UNKNOWN_AUTHZ_SERVICE))
  gcv_object_t _object_Krpc_s_unknown_authz_service;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_UNKNOWN_IF))
  gcv_object_t _object_Krpc_s_unknown_if;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_UNKNOWN_MGR_TYPE))
  gcv_object_t _object_Krpc_s_unknown_mgr_type;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_UNSUPPORTED_AUTHN_LEVEL))
  gcv_object_t _object_Krpc_s_unsupported_authn_level;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_UNSUPPORTED_NAME_SYNTAX))
  gcv_object_t _object_Krpc_s_unsupported_name_syntax;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_UNSUPPORTED_TRANS_SYN))
  gcv_object_t _object_Krpc_s_unsupported_trans_syn;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_UNSUPPORTED_TYPE))
  gcv_object_t _object_Krpc_s_unsupported_type;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_UUID_LOCAL_ONLY))
  gcv_object_t _object_Krpc_s_uuid_local_only;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_UUID_NO_ADDRESS))
  gcv_object_t _object_Krpc_s_uuid_no_address;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_WRONG_KIND_OF_BINDING))
  gcv_object_t _object_Krpc_s_wrong_kind_of_binding;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_ZERO_DIVIDE))
  gcv_object_t _object_Krpc_s_zero_divide;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_X_BAD_STUB_DATA))
  gcv_object_t _object_Krpc_x_bad_stub_data;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_X_BYTE_COUNT_TOO_SMALL))
  gcv_object_t _object_Krpc_x_byte_count_too_small;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_X_ENUM_VALUE_OUT_OF_RANGE))
  gcv_object_t _object_Krpc_x_enum_value_out_of_range;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_X_INVALID_ES_ACTION))
  gcv_object_t _object_Krpc_x_invalid_es_action;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_X_INVALID_PIPE_OBJECT))
  gcv_object_t _object_Krpc_x_invalid_pipe_object;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_X_NO_MORE_ENTRIES))
  gcv_object_t _object_Krpc_x_no_more_entries;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_X_NULL_REF_POINTER))
  gcv_object_t _object_Krpc_x_null_ref_pointer;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_X_PIPE_CLOSED))
  gcv_object_t _object_Krpc_x_pipe_closed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_X_PIPE_DISCIPLINE_ERROR))
  gcv_object_t _object_Krpc_x_pipe_discipline_error;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_X_PIPE_EMPTY))
  gcv_object_t _object_Krpc_x_pipe_empty;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_X_SS_CANNOT_GET_CALL_HANDLE))
  gcv_object_t _object_Krpc_x_ss_cannot_get_call_handle;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_X_SS_CHAR_TRANS_OPEN_FAIL))
  gcv_object_t _object_Krpc_x_ss_char_trans_open_fail;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_X_SS_CHAR_TRANS_SHORT_FILE))
  gcv_object_t _object_Krpc_x_ss_char_trans_short_file;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_X_SS_CONTEXT_DAMAGED))
  gcv_object_t _object_Krpc_x_ss_context_damaged;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_X_SS_HANDLES_MISMATCH))
  gcv_object_t _object_Krpc_x_ss_handles_mismatch;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_X_SS_IN_NULL_CONTEXT))
  gcv_object_t _object_Krpc_x_ss_in_null_context;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_X_WRONG_ES_VERSION))
  gcv_object_t _object_Krpc_x_wrong_es_version;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_X_WRONG_PIPE_ORDER))
  gcv_object_t _object_Krpc_x_wrong_pipe_order;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_X_WRONG_PIPE_VERSION))
  gcv_object_t _object_Krpc_x_wrong_pipe_version;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_X_WRONG_STUB_VERSION))
  gcv_object_t _object_Krpc_x_wrong_stub_version;
#endif
#if (defined(HAVE_GETRLIMIT) || defined(HAVE_SETRLIMIT)) && (defined(RLIMIT_RSS))
  gcv_object_t _object_Krss;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_RTSIG_MAX))
  gcv_object_t _object_Krtsig_max;
#endif
#if (defined(HAVE_UTMPX_H)) && (defined(RUN_LVL))
  gcv_object_t _object_Krun_lvl;
#endif
#if defined(S_IRUSR)
  gcv_object_t _object_Krusr;
#endif
#if defined(S_IRWXG)
  gcv_object_t _object_Krwxg;
#endif
#if defined(S_IRWXO)
  gcv_object_t _object_Krwxo;
#endif
#if defined(S_IRWXU)
  gcv_object_t _object_Krwxu;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  gcv_object_t _object_Ks;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_SAVED_IDS))
  gcv_object_t _object_Ksaved_ids;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(SCHED_E_SERVICE_NOT_LOCALSYSTEM))
  gcv_object_t _object_Ksched_e_service_not_localsystem;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(SEC_E_ISSUING_CA_UNTRUSTED))
  gcv_object_t _object_Ksec_e_issuing_ca_untrusted;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(SEC_E_PKINIT_CLIENT_FAILUR))
  gcv_object_t _object_Ksec_e_pkinit_client_failur;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(SEC_E_REVOCATION_OFFLINE_C))
  gcv_object_t _object_Ksec_e_revocation_offline_c;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(SEC_E_SMARTCARD_CERT_EXPIRED))
  gcv_object_t _object_Ksec_e_smartcard_cert_expired;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(SEC_E_SMARTCARD_CERT_REVOKED))
  gcv_object_t _object_Ksec_e_smartcard_cert_revoked;
#endif
#if (defined(HAVE_SYS_RESOURCE_H)) && (defined(HAVE_GETRUSAGE)) && (defined(RUSAGE_SELF))
  gcv_object_t _object_Kself;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_SEMAPHORES))
  gcv_object_t _object_Ksemaphores;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_SEM_NSEMS_MAX))
  gcv_object_t _object_Ksem_nsems_max;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_SEM_VALUE_MAX))
  gcv_object_t _object_Ksem_value_max;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  gcv_object_t _object_Kserver;
#endif
#if defined(S_ISGID)
  gcv_object_t _object_Ksgid;
#endif
#if defined(HAVE_FCNTL) || defined(WIN32_NATIVE)
  gcv_object_t _object_Kshared;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_SHARED_MEMORY_OBJECTS))
  gcv_object_t _object_Kshared_memory_objects;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_SHELL))
  gcv_object_t _object_Kshell;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  gcv_object_t _object_Kshift;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  gcv_object_t _object_Kshow_command;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(PROCESSOR_ARCHITECTURE_SHX))
  gcv_object_t _object_Kshx;
#endif
#if defined(SIGABRT)
  gcv_object_t _object_Ksigabrt;
#endif
#if defined(SIGALRM)
  gcv_object_t _object_Ksigalrm;
#endif
#if defined(SIGBUS)
  gcv_object_t _object_Ksigbus;
#endif
#if defined(SIGCHLD)
  gcv_object_t _object_Ksigchld;
#endif
#if defined(SIGCONT)
  gcv_object_t _object_Ksigcont;
#endif
#if defined(SIGFPE)
  gcv_object_t _object_Ksigfpe;
#endif
#if defined(SIGHUP)
  gcv_object_t _object_Ksighup;
#endif
#if defined(SIGILL)
  gcv_object_t _object_Ksigill;
#endif
#if defined(SIGINT)
  gcv_object_t _object_Ksigint;
#endif
#if defined(SIGKILL)
  gcv_object_t _object_Ksigkill;
#endif
#if defined(HAVE_SYS_RESOURCE_H)
  gcv_object_t _object_Ksignaled;
#endif
#if defined(SIGPIPE)
  gcv_object_t _object_Ksigpipe;
#endif
#if defined(SIGPOLL)
  gcv_object_t _object_Ksigpoll;
#endif
#if defined(SIGPROF)
  gcv_object_t _object_Ksigprof;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_SIGQUEUE_MAX))
  gcv_object_t _object_Ksigqueue_max;
#endif
#if defined(SIGQUIT)
  gcv_object_t _object_Ksigquit;
#endif
#if defined(SIGSEGV)
  gcv_object_t _object_Ksigsegv;
#endif
#if defined(SIGSTOP)
  gcv_object_t _object_Ksigstop;
#endif
#if defined(SIGSYS)
  gcv_object_t _object_Ksigsys;
#endif
#if defined(SIGTERM)
  gcv_object_t _object_Ksigterm;
#endif
#if defined(SIGTRAP)
  gcv_object_t _object_Ksigtrap;
#endif
#if defined(SIGTSTP)
  gcv_object_t _object_Ksigtstp;
#endif
#if defined(SIGTTIN)
  gcv_object_t _object_Ksigttin;
#endif
#if defined(SIGTTOU)
  gcv_object_t _object_Ksigttou;
#endif
#if defined(SIGURG)
  gcv_object_t _object_Ksigurg;
#endif
#if defined(SIGUSR1)
  gcv_object_t _object_Ksigusr1;
#endif
#if defined(SIGUSR2)
  gcv_object_t _object_Ksigusr2;
#endif
#if defined(SIGVTALRM)
  gcv_object_t _object_Ksigvtalrm;
#endif
#if defined(SIGXCPU)
  gcv_object_t _object_Ksigxcpu;
#endif
#if defined(SIGXFSZ)
  gcv_object_t _object_Ksigxfsz;
#endif
#if (defined(HAVE_NFTW)) && (defined(FTW_SL))
  gcv_object_t _object_Ksl;
#endif
#if (defined(HAVE_NFTW)) && (defined(FTW_SLN))
  gcv_object_t _object_Ksln;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  gcv_object_t _object_Ksmallbusiness;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  gcv_object_t _object_Ksmallbusiness_restricted;
#endif
#if (defined(HAVE_PATHCONF) && defined(HAVE_FPATHCONF)) && (defined(_PC_SOCK_MAXBUF))
  gcv_object_t _object_Ksock_maxbuf;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(FILE_ATTRIBUTE_SPARSE_FILE))
  gcv_object_t _object_Ksparse_file;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_SPAWN))
  gcv_object_t _object_Kspawn;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_SPIN_LOCKS))
  gcv_object_t _object_Kspin_locks;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_SPORADIC_SERVER))
  gcv_object_t _object_Ksporadic_server;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_SS_REPL_MAX))
  gcv_object_t _object_Kss_repl_max;
#endif
#if (defined(HAVE_GETRLIMIT) || defined(HAVE_SETRLIMIT)) && (defined(RLIMIT_STACK))
  gcv_object_t _object_Kstack;
#endif
#if defined(HAVE_FCNTL) || defined(WIN32_NATIVE)
  gcv_object_t _object_Kstart;
#endif
#if defined(HAVE_SYS_RESOURCE_H)
  gcv_object_t _object_Kstopped;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_STREAM_MAX))
  gcv_object_t _object_Kstream_max;
#endif
#if defined(STRUNCATE)
  gcv_object_t _object_Kstruncate;
#endif
#if (defined(WIN32_NATIVE) || (defined(HAVE_STATVFS) && defined(HAVE_SYS_STATVFS_H))) && (defined(ST_APPEND))
  gcv_object_t _object_Kst_append;
#endif
#if (defined(WIN32_NATIVE) || (defined(HAVE_STATVFS) && defined(HAVE_SYS_STATVFS_H))) && (defined(ST_IMMUTABLE))
  gcv_object_t _object_Kst_immutable;
#endif
#if (defined(WIN32_NATIVE) || (defined(HAVE_STATVFS) && defined(HAVE_SYS_STATVFS_H))) && (defined(ST_MANDLOCK))
  gcv_object_t _object_Kst_mandlock;
#endif
#if (defined(WIN32_NATIVE) || (defined(HAVE_STATVFS) && defined(HAVE_SYS_STATVFS_H))) && (defined(ST_NOATIME))
  gcv_object_t _object_Kst_noatime;
#endif
#if (defined(WIN32_NATIVE) || (defined(HAVE_STATVFS) && defined(HAVE_SYS_STATVFS_H))) && (defined(ST_NODEV))
  gcv_object_t _object_Kst_nodev;
#endif
#if (defined(WIN32_NATIVE) || (defined(HAVE_STATVFS) && defined(HAVE_SYS_STATVFS_H))) && (defined(ST_NODIRATIME))
  gcv_object_t _object_Kst_nodiratime;
#endif
#if (defined(WIN32_NATIVE) || (defined(HAVE_STATVFS) && defined(HAVE_SYS_STATVFS_H))) && (defined(ST_NOEXEC))
  gcv_object_t _object_Kst_noexec;
#endif
#if (defined(WIN32_NATIVE) || (defined(HAVE_STATVFS) && defined(HAVE_SYS_STATVFS_H))) && (defined(ST_NOSUID))
  gcv_object_t _object_Kst_nosuid;
#endif
#if (defined(WIN32_NATIVE) || (defined(HAVE_STATVFS) && defined(HAVE_SYS_STATVFS_H))) && (defined(ST_NOTRUNC))
  gcv_object_t _object_Kst_notrunc;
#endif
#if (defined(WIN32_NATIVE) || (defined(HAVE_STATVFS) && defined(HAVE_SYS_STATVFS_H))) && (defined(ST_RDONLY))
  gcv_object_t _object_Kst_rdonly;
#endif
#if (defined(WIN32_NATIVE) || (defined(HAVE_STATVFS) && defined(HAVE_SYS_STATVFS_H))) && (defined(ST_SYNCHRONOUS))
  gcv_object_t _object_Kst_synchronous;
#endif
#if (defined(WIN32_NATIVE) || (defined(HAVE_STATVFS) && defined(HAVE_SYS_STATVFS_H))) && (defined(ST_WRITE))
  gcv_object_t _object_Kst_write;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  gcv_object_t _object_Ksubject;
#endif
#if defined(S_ISUID)
  gcv_object_t _object_Ksuid;
#endif
#if defined(S_ISVTX)
  gcv_object_t _object_Ksvtx;
#endif
  gcv_object_t _object_Ksymlink;
#if (defined(HAVE_PATHCONF) && defined(HAVE_FPATHCONF)) && (defined(_PC_SYMLINK_MAX))
  gcv_object_t _object_Ksymlink_max;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_SYMLOOP_MAX))
  gcv_object_t _object_Ksymloop_max;
#endif
#if (defined(HAVE_FCNTL)) && (defined(O_SYNC))
  gcv_object_t _object_Ksync;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_SYNCHRONIZED_IO))
  gcv_object_t _object_Ksynchronized_io;
#endif
#if (defined(HAVE_PATHCONF) && defined(HAVE_FPATHCONF)) && (defined(_PC_SYNC_IO))
  gcv_object_t _object_Ksync_io;
#endif
#if (defined(HAVE_SYSLOG)) && (defined(LOG_SYSLOG))
  gcv_object_t _object_Ksyslog;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(FILE_ATTRIBUTE_SYSTEM))
  gcv_object_t _object_Ksystem;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  gcv_object_t _object_Ktemplate;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(FILE_ATTRIBUTE_TEMPORARY))
  gcv_object_t _object_Ktemporary;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  gcv_object_t _object_Kterminal;
#endif
#if (defined(HAVE_FCNTL)) && (defined(O_TEXT))
  gcv_object_t _object_Ktext;
#endif
#if (defined(HAVE_SYS_RESOURCE_H)) && (defined(HAVE_GETRUSAGE)) && (defined(RUSAGE_THREAD))
  gcv_object_t _object_Kthread;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_THREADS))
  gcv_object_t _object_Kthreads;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_THREAD_ATTR_STACKADDR))
  gcv_object_t _object_Kthread_attr_stackaddr;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_THREAD_ATTR_STACKSIZE))
  gcv_object_t _object_Kthread_attr_stacksize;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_THREAD_CPUTIME))
  gcv_object_t _object_Kthread_cputime;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_THREAD_DESTRUCTOR_ITERATIONS))
  gcv_object_t _object_Kthread_destructor_iterations;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_THREAD_KEYS_MAX))
  gcv_object_t _object_Kthread_keys_max;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_THREAD_PRIORITY_SCHEDULING))
  gcv_object_t _object_Kthread_priority_scheduling;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_THREAD_PRIO_INHERIT))
  gcv_object_t _object_Kthread_prio_inherit;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_THREAD_PRIO_PROTECT))
  gcv_object_t _object_Kthread_prio_protect;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_THREAD_PROCESS_SHARED))
  gcv_object_t _object_Kthread_process_shared;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_THREAD_ROBUST_PRIO_INHERIT))
  gcv_object_t _object_Kthread_robust_prio_inherit;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_THREAD_ROBUST_PRIO_PROTECT))
  gcv_object_t _object_Kthread_robust_prio_protect;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_THREAD_SAFE_FUNCTIONS))
  gcv_object_t _object_Kthread_safe_functions;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_THREAD_SPORADIC_SERVER))
  gcv_object_t _object_Kthread_sporadic_server;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_THREAD_STACK_MIN))
  gcv_object_t _object_Kthread_stack_min;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_THREAD_THREADS_MAX))
  gcv_object_t _object_Kthread_threads_max;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  gcv_object_t _object_Kthumbnail;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_TIMEOUTS))
  gcv_object_t _object_Ktimeouts;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_TIMERS))
  gcv_object_t _object_Ktimers;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_TIMER_MAX))
  gcv_object_t _object_Ktimer_max;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  gcv_object_t _object_Ktitle;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_TRACE))
  gcv_object_t _object_Ktrace;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_TRACE_EVENT_FILTER))
  gcv_object_t _object_Ktrace_event_filter;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_TRACE_EVENT_NAME_MAX))
  gcv_object_t _object_Ktrace_event_name_max;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_TRACE_INHERIT))
  gcv_object_t _object_Ktrace_inherit;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_TRACE_LOG))
  gcv_object_t _object_Ktrace_log;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_TRACE_NAME_MAX))
  gcv_object_t _object_Ktrace_name_max;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_TRACE_SYS_MAX))
  gcv_object_t _object_Ktrace_sys_max;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_TRACE_USER_EVENT_MAX))
  gcv_object_t _object_Ktrace_user_event_max;
#endif
#if (defined(HAVE_FCNTL)) && (defined(O_TRUNC))
  gcv_object_t _object_Ktrunc;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_TTY_NAME_MAX))
  gcv_object_t _object_Ktty_name_max;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_TYPED_MEMORY_OBJECTS))
  gcv_object_t _object_Ktyped_memory_objects;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_TZNAME_MAX))
  gcv_object_t _object_Ktzname_max;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  gcv_object_t _object_Kui1;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  gcv_object_t _object_Kui2;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  gcv_object_t _object_Kui4;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  gcv_object_t _object_Kui8;
#endif
#if defined(HAVE_STAT) && (defined(HAVE_CHMOD) || defined(HAVE_CHOWN) || defined(HAVE_UTIME))
  gcv_object_t _object_Kuid;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  gcv_object_t _object_Kuint;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(PROCESSOR_ARCHITECTURE_UNKNOWN))
  gcv_object_t _object_Kunknown;
#endif
#if defined(HAVE_SYS_RESOURCE_H)
  gcv_object_t _object_Kuntraced;
#endif
#if defined(HAVE_SYS_RESOURCE_H)
  gcv_object_t _object_Kusage;
#endif
#if ((defined(HAVE_SYSLOG)) && (defined(LOG_USER))) || (defined(PRIO_USER))
  gcv_object_t _object_Kuser;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  gcv_object_t _object_Kuser_defined;
#endif
#if (defined(HAVE_UTMPX_H)) && (defined(USER_PROCESS))
  gcv_object_t _object_Kuser_process;
#endif
#if (defined(HAVE_SYSLOG)) && (defined(LOG_UUCP))
  gcv_object_t _object_Kuucp;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_V6_ILP32_OFF32))
  gcv_object_t _object_Kv6_ilp32_off32;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_V6_ILP32_OFFBIG))
  gcv_object_t _object_Kv6_ilp32_offbig;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_V6_LP64_OFF64))
  gcv_object_t _object_Kv6_lp64_off64;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_V6_LPBIG_OFFBIG))
  gcv_object_t _object_Kv6_lpbig_offbig;
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_V7_ENV))
  gcv_object_t _object_Kv7_env;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_V7_ILP32_OFF32))
  gcv_object_t _object_Kv7_ilp32_off32;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_V7_ILP32_OFFBIG))
  gcv_object_t _object_Kv7_ilp32_offbig;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_V7_LP64_OFF64))
  gcv_object_t _object_Kv7_lp64_off64;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_V7_LPBIG_OFFBIG))
  gcv_object_t _object_Kv7_lpbig_offbig;
#endif
#if (defined(HAVE_PATHCONF) && defined(HAVE_FPATHCONF)) && (defined(_PC_VDISABLE))
  gcv_object_t _object_Kvdisable;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_VERSION))
  gcv_object_t _object_Kversion;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WAIT_TIMEOUT))
  gcv_object_t _object_Kwait_timeout;
#endif
#if (defined(HAVE_SYSLOG)) && (defined(LOG_WARNING))
  gcv_object_t _object_Kwarning;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WARNING_IPSEC_MM_POLICY_PRUNED))
  gcv_object_t _object_Kwarning_ipsec_mm_policy_pruned;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WARNING_IPSEC_QM_POLICY_PRUNED))
  gcv_object_t _object_Kwarning_ipsec_qm_policy_pruned;
#endif
#if defined(S_IWGRP)
  gcv_object_t _object_Kwgrp;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  gcv_object_t _object_Kwindows;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  gcv_object_t _object_Kwordcount;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  gcv_object_t _object_Kworking_directory;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  gcv_object_t _object_Kworkstation;
#endif
#if defined(S_IWOTH)
  gcv_object_t _object_Kwoth;
#endif
#if defined(HAVE_FCNTL)
  gcv_object_t _object_Kwronly;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSABASEERR))
  gcv_object_t _object_Kwsabaseerr;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAEACCES))
  gcv_object_t _object_Kwsaeacces;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAEADDRINUSE))
  gcv_object_t _object_Kwsaeaddrinuse;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAEADDRNOTAVAIL))
  gcv_object_t _object_Kwsaeaddrnotavail;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAEAFNOSUPPORT))
  gcv_object_t _object_Kwsaeafnosupport;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAEALREADY))
  gcv_object_t _object_Kwsaealready;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAEBADF))
  gcv_object_t _object_Kwsaebadf;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAECANCELLED))
  gcv_object_t _object_Kwsaecancelled;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAECONNABORTED))
  gcv_object_t _object_Kwsaeconnaborted;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAECONNREFUSED))
  gcv_object_t _object_Kwsaeconnrefused;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAECONNRESET))
  gcv_object_t _object_Kwsaeconnreset;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAEDESTADDRREQ))
  gcv_object_t _object_Kwsaedestaddrreq;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAEDISCON))
  gcv_object_t _object_Kwsaediscon;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAEDQUOT))
  gcv_object_t _object_Kwsaedquot;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAEFAULT))
  gcv_object_t _object_Kwsaefault;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAEHOSTDOWN))
  gcv_object_t _object_Kwsaehostdown;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAEHOSTUNREACH))
  gcv_object_t _object_Kwsaehostunreach;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAEINPROGRESS))
  gcv_object_t _object_Kwsaeinprogress;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAEINTR))
  gcv_object_t _object_Kwsaeintr;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAEINVAL))
  gcv_object_t _object_Kwsaeinval;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAEINVALIDPROCTABLE))
  gcv_object_t _object_Kwsaeinvalidproctable;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAEINVALIDPROVIDER))
  gcv_object_t _object_Kwsaeinvalidprovider;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAEISCONN))
  gcv_object_t _object_Kwsaeisconn;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAELOOP))
  gcv_object_t _object_Kwsaeloop;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAEMFILE))
  gcv_object_t _object_Kwsaemfile;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAEMSGSIZE))
  gcv_object_t _object_Kwsaemsgsize;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAENAMETOOLONG))
  gcv_object_t _object_Kwsaenametoolong;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAENETDOWN))
  gcv_object_t _object_Kwsaenetdown;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAENETRESET))
  gcv_object_t _object_Kwsaenetreset;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAENETUNREACH))
  gcv_object_t _object_Kwsaenetunreach;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAENOBUFS))
  gcv_object_t _object_Kwsaenobufs;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAENOMORE))
  gcv_object_t _object_Kwsaenomore;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAENOPROTOOPT))
  gcv_object_t _object_Kwsaenoprotoopt;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAENOTCONN))
  gcv_object_t _object_Kwsaenotconn;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAENOTEMPTY))
  gcv_object_t _object_Kwsaenotempty;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAENOTSOCK))
  gcv_object_t _object_Kwsaenotsock;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAEOPNOTSUPP))
  gcv_object_t _object_Kwsaeopnotsupp;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAEPFNOSUPPORT))
  gcv_object_t _object_Kwsaepfnosupport;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAEPROCLIM))
  gcv_object_t _object_Kwsaeproclim;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAEPROTONOSUPPORT))
  gcv_object_t _object_Kwsaeprotonosupport;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAEPROTOTYPE))
  gcv_object_t _object_Kwsaeprototype;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAEPROVIDERFAILEDINIT))
  gcv_object_t _object_Kwsaeproviderfailedinit;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAEREFUSED))
  gcv_object_t _object_Kwsaerefused;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAEREMOTE))
  gcv_object_t _object_Kwsaeremote;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAESHUTDOWN))
  gcv_object_t _object_Kwsaeshutdown;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAESOCKTNOSUPPORT))
  gcv_object_t _object_Kwsaesocktnosupport;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAESTALE))
  gcv_object_t _object_Kwsaestale;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAETIMEDOUT))
  gcv_object_t _object_Kwsaetimedout;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAETOOMANYREFS))
  gcv_object_t _object_Kwsaetoomanyrefs;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAEUSERS))
  gcv_object_t _object_Kwsaeusers;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAEWOULDBLOCK))
  gcv_object_t _object_Kwsaewouldblock;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAHOST_NOT_FOUND))
  gcv_object_t _object_Kwsahost_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSANOTINITIALISED))
  gcv_object_t _object_Kwsanotinitialised;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSANO_DATA))
  gcv_object_t _object_Kwsano_data;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSANO_RECOVERY))
  gcv_object_t _object_Kwsano_recovery;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSASERVICE_NOT_FOUND))
  gcv_object_t _object_Kwsaservice_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSASYSCALLFAILURE))
  gcv_object_t _object_Kwsasyscallfailure;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSASYSNOTREADY))
  gcv_object_t _object_Kwsasysnotready;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSATRY_AGAIN))
  gcv_object_t _object_Kwsatry_again;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSATYPE_NOT_FOUND))
  gcv_object_t _object_Kwsatype_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAVERNOTSUPPORTED))
  gcv_object_t _object_Kwsavernotsupported;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSA_E_CANCELLED))
  gcv_object_t _object_Kwsa_e_cancelled;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSA_E_NO_MORE))
  gcv_object_t _object_Kwsa_e_no_more;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSA_QOS_ADMISSION_FAILURE))
  gcv_object_t _object_Kwsa_qos_admission_failure;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSA_QOS_BAD_OBJECT))
  gcv_object_t _object_Kwsa_qos_bad_object;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSA_QOS_BAD_STYLE))
  gcv_object_t _object_Kwsa_qos_bad_style;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSA_QOS_EFILTERCOUNT))
  gcv_object_t _object_Kwsa_qos_efiltercount;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSA_QOS_EFILTERSTYLE))
  gcv_object_t _object_Kwsa_qos_efilterstyle;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSA_QOS_EFILTERTYPE))
  gcv_object_t _object_Kwsa_qos_efiltertype;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSA_QOS_EFLOWCOUNT))
  gcv_object_t _object_Kwsa_qos_eflowcount;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSA_QOS_EFLOWDESC))
  gcv_object_t _object_Kwsa_qos_eflowdesc;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSA_QOS_EFLOWSPEC))
  gcv_object_t _object_Kwsa_qos_eflowspec;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSA_QOS_EOBJLENGTH))
  gcv_object_t _object_Kwsa_qos_eobjlength;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSA_QOS_EPOLICYOBJ))
  gcv_object_t _object_Kwsa_qos_epolicyobj;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSA_QOS_EPROVSPECBUF))
  gcv_object_t _object_Kwsa_qos_eprovspecbuf;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSA_QOS_EPSFILTERSPEC))
  gcv_object_t _object_Kwsa_qos_epsfilterspec;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSA_QOS_EPSFLOWSPEC))
  gcv_object_t _object_Kwsa_qos_epsflowspec;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSA_QOS_ESDMODEOBJ))
  gcv_object_t _object_Kwsa_qos_esdmodeobj;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSA_QOS_ESERVICETYPE))
  gcv_object_t _object_Kwsa_qos_eservicetype;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSA_QOS_ESHAPERATEOBJ))
  gcv_object_t _object_Kwsa_qos_eshaperateobj;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSA_QOS_EUNKNOWNPSOBJ))
  gcv_object_t _object_Kwsa_qos_eunknownpsobj;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSA_QOS_GENERIC_ERROR))
  gcv_object_t _object_Kwsa_qos_generic_error;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSA_QOS_NO_RECEIVERS))
  gcv_object_t _object_Kwsa_qos_no_receivers;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSA_QOS_NO_SENDERS))
  gcv_object_t _object_Kwsa_qos_no_senders;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSA_QOS_POLICY_FAILURE))
  gcv_object_t _object_Kwsa_qos_policy_failure;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSA_QOS_RECEIVERS))
  gcv_object_t _object_Kwsa_qos_receivers;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSA_QOS_REQUEST_CONFIRMED))
  gcv_object_t _object_Kwsa_qos_request_confirmed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSA_QOS_RESERVED_PETYPE))
  gcv_object_t _object_Kwsa_qos_reserved_petype;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSA_QOS_SENDERS))
  gcv_object_t _object_Kwsa_qos_senders;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSA_QOS_TRAFFIC_CTRL_ERROR))
  gcv_object_t _object_Kwsa_qos_traffic_ctrl_error;
#endif
#if defined(S_IWUSR)
  gcv_object_t _object_Kwusr;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_XBS5_ILP32_OFF32))
  gcv_object_t _object_Kxbs5_ilp32_off32;
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_XBS5_ILP32_OFF32_CFLAGS))
  gcv_object_t _object_Kxbs5_ilp32_off32_cflags;
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_XBS5_ILP32_OFF32_LDFLAGS))
  gcv_object_t _object_Kxbs5_ilp32_off32_ldflags;
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_XBS5_ILP32_OFF32_LIBS))
  gcv_object_t _object_Kxbs5_ilp32_off32_libs;
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_XBS5_ILP32_OFF32_LINTFLAGS))
  gcv_object_t _object_Kxbs5_ilp32_off32_lintflags;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_XBS5_ILP32_OFFBIG))
  gcv_object_t _object_Kxbs5_ilp32_offbig;
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_XBS5_ILP32_OFFBIG_CFLAGS))
  gcv_object_t _object_Kxbs5_ilp32_offbig_cflags;
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_XBS5_ILP32_OFFBIG_LDFLAGS))
  gcv_object_t _object_Kxbs5_ilp32_offbig_ldflags;
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_XBS5_ILP32_OFFBIG_LIBS))
  gcv_object_t _object_Kxbs5_ilp32_offbig_libs;
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_XBS5_ILP32_OFFBIG_LINTFLAGS))
  gcv_object_t _object_Kxbs5_ilp32_offbig_lintflags;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_XBS5_LP64_OFF64))
  gcv_object_t _object_Kxbs5_lp64_off64;
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_XBS5_LP64_OFF64_CFLAGS))
  gcv_object_t _object_Kxbs5_lp64_off64_cflags;
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_XBS5_LP64_OFF64_LDFLAGS))
  gcv_object_t _object_Kxbs5_lp64_off64_ldflags;
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_XBS5_LP64_OFF64_LIBS))
  gcv_object_t _object_Kxbs5_lp64_off64_libs;
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_XBS5_LP64_OFF64_LINTFLAGS))
  gcv_object_t _object_Kxbs5_lp64_off64_lintflags;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_XBS5_LPBIG_OFFBIG))
  gcv_object_t _object_Kxbs5_lpbig_offbig;
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_XBS5_LPBIG_OFFBIG_CFLAGS))
  gcv_object_t _object_Kxbs5_lpbig_offbig_cflags;
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_XBS5_LPBIG_OFFBIG_LDFLAGS))
  gcv_object_t _object_Kxbs5_lpbig_offbig_ldflags;
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_XBS5_LPBIG_OFFBIG_LIBS))
  gcv_object_t _object_Kxbs5_lpbig_offbig_libs;
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_XBS5_LPBIG_OFFBIG_LINTFLAGS))
  gcv_object_t _object_Kxbs5_lpbig_offbig_lintflags;
#endif
#if defined(S_IXGRP)
  gcv_object_t _object_Kxgrp;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_XOPEN_CRYPT))
  gcv_object_t _object_Kxopen_crypt;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_XOPEN_ENH_I18N))
  gcv_object_t _object_Kxopen_enh_i18n;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_XOPEN_LEGACY))
  gcv_object_t _object_Kxopen_legacy;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_XOPEN_REALTIME))
  gcv_object_t _object_Kxopen_realtime;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_XOPEN_REALTIME_THREADS))
  gcv_object_t _object_Kxopen_realtime_threads;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_XOPEN_SHM))
  gcv_object_t _object_Kxopen_shm;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_XOPEN_STREAMS))
  gcv_object_t _object_Kxopen_streams;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_XOPEN_UNIX))
  gcv_object_t _object_Kxopen_unix;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_XOPEN_UUCP))
  gcv_object_t _object_Kxopen_uucp;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_XOPEN_VERSION))
  gcv_object_t _object_Kxopen_version;
#endif
#if defined(S_IXOTH)
  gcv_object_t _object_Kxoth;
#endif
#if defined(S_IXUSR)
  gcv_object_t _object_Kxusr;
#endif
  gcv_object_t _object_posix__copy_file;
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  gcv_object_t _object_posix__make_file_info;
#endif
#if (defined(HAVE_FSTAT) && defined(HAVE_STAT)) || (defined(HAVE_NFTW))
  gcv_object_t _object_posix__make_file_stat;
#endif
#if defined(HAVE_GETGRGID) && defined(HAVE_GETGRNAM)
  gcv_object_t _object_posix__make_group_info;
#endif
  gcv_object_t _object_posix__make_hostent;
#if defined(HAVE_GETRLIMIT)
  gcv_object_t _object_posix__make_rlimit;
#endif
#if (defined(HAVE_GETSERVBYPORT) && defined(HAVE_GETSERVBYNAME)) || defined(WIN32_NATIVE)
  gcv_object_t _object_posix__make_service;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  gcv_object_t _object_posix__make_shortcut_info;
#endif
#if defined(WIN32_NATIVE) || (defined(HAVE_STATVFS) && defined(HAVE_SYS_STATVFS_H))
  gcv_object_t _object_posix__make_stat_vfs;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  gcv_object_t _object_posix__make_system_info;
#endif
  gcv_object_t _object_posix__make_uname;
#if defined(HAVE_SYS_RESOURCE_H)
  gcv_object_t _object_posix__make_usage;
#endif
#if defined(HAVE_GETLOGIN) && defined(HAVE_GETPWNAM) && defined(HAVE_GETPWUID) && defined(HAVE_GETUID)
  gcv_object_t _object_posix__make_user_info;
#endif
#if defined(HAVE_UTMPX_H)
  gcv_object_t _object_posix__make_utmpx;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  gcv_object_t _object_posix__make_version;
#endif
#if defined(WIN32_NATIVE)
  gcv_object_t _object_posix__mkfilever;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  gcv_object_t _object_posix__mkmemstat;
#endif
  gcv_object_t _object_posix__resolve_host_ipaddr;
#if defined(HAVE_SETRLIMIT)
  gcv_object_t _object_posix__rlimit;
#endif
#if defined(HAVE_UTMPX_H)
  gcv_object_t _object_posix__utmpx;
#endif
#if (defined(HAVE_STAT) && (defined(HAVE_CHMOD) || defined(HAVE_CHOWN) || defined(HAVE_UTIME))) && (!(defined(WIN32_NATIVE))) && (!(defined(HAVE_CHMOD)))
  gcv_object_t _object__22chmod_28_29_22;
#endif
#if (defined(HAVE_STAT) && (defined(HAVE_CHMOD) || defined(HAVE_CHOWN) || defined(HAVE_UTIME))) && (!(defined(HAVE_CHOWN)))
  gcv_object_t _object__22chown_28_29_22;
#endif
#if (defined(HAVE_STAT) && (defined(HAVE_CHMOD) || defined(HAVE_CHOWN) || defined(HAVE_UTIME))) && (!defined(WIN32_NATIVE)) && (!(defined(HAVE_UTIME)))
  gcv_object_t _object__22utime_28_29_22;
#endif
  gcv_object_t _object__28member_200_201_202_29;
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  gcv_object_t _object__28member_20_alt_20_control_20_ext_20_shift_29;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  gcv_object_t _object__28member_20_normal_20_max_20_min_29;
#endif
  gcv_object_t _object__28or_20null_20integer_20_28member_20_copy_20_symlink_20_hardlink_20_hardlink_or_copy_20_rename_29_29;
  gcv_object_t _object___28or_20integer_20_28member_defined_28e2big_29_Ke2big_defined_28eacces_29_Keacces_defined_28eaddrinuse_29_Keaddrinuse_defined_28eaddrnotavail_29_Keaddrnotavail_defined_28eafnosupport_29_Keafnosupport_defined_28eagain_29_Keagain_defined_28ealready_29_Kealready_defined_28ebadf_29_Kebadf_defined_28ebadmsg_29_Kebadmsg_defined_28ebusy_29_Kebusy_defined_28ecanceled_29_Kecanceled_defined_28echild_29_Kechild_defined_28econnaborted_29_Keconnaborted_defined_28econnrefused_29_Keconnrefused_defined_28econnreset_29_Keconnreset_defined_28edeadlk_29_Kedeadlk_defined_28edestaddrreq_29_Kedestaddrreq_defined_28edom_29_Kedom_defined_28edquot_29_Kedquot_defined_28eexist_29_Keexist_defined_28efault_29_Kefault_defined_28efbig_29_Kefbig_defined_28ehostunreach_29_Kehostunreach_defined_28eidrm_29_Keidrm_defined_28eilseq_29_Keilseq_defined_28einprogress_29_Keinprogress_defined_28eintr_29_Keintr_defined_28einval_29_Keinval_defined_28eio_29_Keio_defined_28eisconn_29_Keisconn_defined_28eisdir_29_Keisdir_defined_28eloop_29_Keloop_defined_28emfile_29_Kemfile_defined_28emlink_29_Kemlink_defined_28emsgsize_29_Kemsgsize_defined_28emultihop_29_Kemultihop_defined_28enametoolong_29_Kenametoolong_defined_28enetdown_29_Kenetdown_defined_28enetreset_29_Kenetreset_defined_28enetunreach_29_Kenetunreach_defined_28enfile_29_Kenfile_defined_28enobufs_29_Kenobufs_defined_28enodata_29_Kenodata_defined_28enodev_29_Kenodev_defined_28enoent_29_Kenoent_defined_28enoexec_29_Kenoexec_defined_28enolck_29_Kenolck_defined_28enolink_29_Kenolink_defined_28enomem_29_Kenomem_defined_28enomsg_29_Kenomsg_defined_28enoprotoopt_29_Kenoprotoopt_defined_28enospc_29_Kenospc_defined_28enosr_29_Kenosr_defined_28enostr_29_Kenostr_defined_28enosys_29_Kenosys_defined_28enotconn_29_Kenotconn_defined_28enotdir_29_Kenotdir_defined_28enotempty_29_Kenotempty_defined_28enotsock_29_Kenotsock_defined_28enotsup_29_Kenotsup_defined_28enotty_29_Kenotty_defined_28enxio_29_Kenxio_defined_28eopnotsupp_29_Keopnotsupp_defined_28eoverflow_29_Keo;
#if defined(HAVE_UTMPX_H)
  gcv_object_t _object___28or_20integer_20_28member_defined_28empty_29_Kempty_defined_28run_lvl_29_Krun_lvl_defined_28boot_time_29_Kboot_time_defined_28old_time_29_Kold_time_defined_28new_time_29_Knew_time_defined_28user_process_29_Kuser_process_defined_28init_process_29_Kinit_process_defined_28login_process_29_Klogin_process_defined_28dead_process_29_Kdead_process_defined_28accounting_29_Kaccounting__29_29;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  gcv_object_t _object___28or_20integer_20_28member_defined_28error_invalid_function_29_Kerror_invalid_function_defined_28error_file_not_found_29_Kerror_file_not_found_defined_28error_path_not_found_29_Kerror_path_not_found_defined_28error_too_many_open_files_29_Kerror_too_many_open_files_defined_28error_access_denied_29_Kerror_access_denied_defined_28error_invalid_handle_29_Kerror_invalid_handle_defined_28error_arena_trashed_29_Kerror_arena_trashed_defined_28error_not_enough_memory_29_Kerror_not_enough_memory_defined_28error_invalid_block_29_Kerror_invalid_block_defined_28error_bad_environment_29_Kerror_bad_environment_defined_28error_bad_format_29_Kerror_bad_format_defined_28error_invalid_access_29_Kerror_invalid_access_defined_28error_invalid_data_29_Kerror_invalid_data_defined_28error_outofmemory_29_Kerror_outofmemory_defined_28error_invalid_drive_29_Kerror_invalid_drive_defined_28error_current_directory_29_Kerror_current_directory_defined_28error_not_same_device_29_Kerror_not_same_device_defined_28error_no_more_files_29_Kerror_no_more_files_defined_28error_write_protect_29_Kerror_write_protect_defined_28error_bad_unit_29_Kerror_bad_unit_defined_28error_not_ready_29_Kerror_not_ready_defined_28error_bad_command_29_Kerror_bad_command_defined_28error_crc_29_Kerror_crc_defined_28error_bad_length_29_Kerror_bad_length_defined_28error_seek_29_Kerror_seek_defined_28error_not_dos_disk_29_Kerror_not_dos_disk_defined_28error_sector_not_found_29_Kerror_sector_not_found_defined_28error_out_of_paper_29_Kerror_out_of_paper_defined_28error_write_fault_29_Kerror_write_fault_defined_28error_read_fault_29_Kerror_read_fault_defined_28error_gen_failure_29_Kerror_gen_failure_defined_28error_sharing_violation_29_Kerror_sharing_violation_defined_28error_lock_violation_29_Kerror_lock_violation_defined_28error_wrong_disk_29_Kerror_wrong_disk_defined_28error_sharing_buffer_exceeded_29_Kerror_sharing_buffer_exceeded_defined_28error_handle_eof_29_Kerror_handle_eof_defined_28error_handle_disk_full_29_Kerror;
#endif
#if defined(HAVE_FCNTL)
  gcv_object_t _object___28or_20integer_20_28member_defined_28fd_cloexec_29_Kcloexec__29_29;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  gcv_object_t _object___28or_20integer_20_28member_defined_28file_attribute_archive_29_Karchive_defined_28file_attribute_compressed_29_Kcompressed_defined_28file_attribute_device_29_Kdevice_defined_28file_attribute_directory_29_Kdirectory_defined_28file_attribute_encrypted_29_Kencrypted_defined_28file_attribute_hidden_29_Khidden_defined_28file_attribute_normal_29_Knormal_defined_28file_attribute_not_content_indexed_29_Knot_content_indexed_defined_28file_attribute_offline_29_Koffline_defined_28file_attribute_readonly_29_Kreadonly_defined_28file_attribute_reparse_point_29_Kreparse_point_defined_28file_attribute_sparse_file_29_Ksparse_file_defined_28file_attribute_system_29_Ksystem_defined_28file_attribute_temporary_29_Ktemporary__29_29;
#endif
#if defined(HAVE_NFTW)
  gcv_object_t _object___28or_20integer_20_28member_defined_28ftw_f_29_Kf_defined_28ftw_d_29_Kd_defined_28ftw_dp_29_Kdp_defined_28ftw_sl_29_Ksl_defined_28ftw_sln_29_Ksln_defined_28ftw_dnr_29_Kdnr_defined_28ftw_ns_29_Kns__29_29;
#endif
#if defined(HAVE_FCNTL)
  gcv_object_t _object___28or_20integer_20_28member_defined_28f_getfd_29_Kfd_defined_28f_getfl_29_Kfl__29_29;
#endif
#if defined(HAVE_SYSLOG)
  gcv_object_t _object___28or_20integer_20_28member_defined_28log_emerg_29_Kemerg_defined_28log_alert_29_Kalert_defined_28log_crit_29_Kcrit_defined_28log_err_29_Kerr_defined_28log_warning_29_Kwarning_defined_28log_notice_29_Knotice_defined_28log_info_29_Kinfo_defined_28log_debug_29_Kdebug__29_29;
#endif
#if defined(HAVE_FCNTL)
  gcv_object_t _object___28or_20integer_20_28member_defined_28o_rdonly_29_Krdonly_defined_28o_wronly_29_Kwronly_defined_28o_rdwr_29_Krdwr_defined_28o_append_29_Kappend_defined_28o_creat_29_Kcreat_defined_28o_trunc_29_Ktrunc_defined_28o_excl_29_Kexcl_defined_28o_noctty_29_Knoctty_defined_28o_sync_29_Ksync_defined_28o_nonblock_29_Knonblock_defined_28o_binary_29_Kbinary_defined_28o_text_29_Ktext_defined_28o_noinherit_29_Knoinherit_defined_28o_direct_29_Kdirect_defined_28o_largefile_29_Klargefile_defined_28o_directory_29_Kdirectory_defined_28o_nofollow_29_Knofollow__29_29;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  gcv_object_t _object___28or_20integer_20_28member_defined_28processor_architecture_intel_29_Kintel_defined_28processor_architecture_mips_29_Kmips_defined_28processor_architecture_alpha_29_Kalpha_defined_28processor_architecture_ppc_29_Kppc_defined_28processor_architecture_shx_29_Kshx_defined_28processor_architecture_arm_29_Karm_defined_28processor_architecture_ia64_29_Kia64_defined_28processor_architecture_alpha64_29_Kalpha64_defined_28processor_architecture_msil_29_Kmsil_defined_28processor_architecture_amd64_29_Kamd64_defined_28processor_architecture_ia32_on_win64_29_Kia32_on_win64_defined_28processor_architecture_unknown_29_Kunknown__29_29;
#endif
#if defined(HAVE_GETRLIMIT) || defined(HAVE_SETRLIMIT)
  gcv_object_t _object___28or_20integer_20_28member_defined_28rlimit_cpu_29_Kcpu_defined_28rlimit_fsize_29_Kfsize_defined_28rlimit_data_29_Kdata_defined_28rlimit_stack_29_Kstack_defined_28rlimit_core_29_Kcore_defined_28rlimit_rss_29_Krss_defined_28rlimit_nofile_29_Knofile_defined_28rlimit_as_29_Kas_defined_28rlimit_nproc_29_Knproc_defined_28rlimit_memlock_29_Kmemlock_defined_28rlimit_locks_29_Klocks__29_29;
#endif
#if (defined(HAVE_SYS_RESOURCE_H)) && (defined(HAVE_GETRUSAGE))
  gcv_object_t _object___28or_20integer_20_28member_defined_28rusage_self_29_Kself_defined_28rusage_children_29_Kchildren_defined_28rusage_thread_29_Kthread_defined_28rusage_lwp_29_Klwp__29_29;
#endif
  gcv_object_t _object___28or_20integer_20_28member_defined_28sigabrt_29_Ksigabrt_defined_28sigalrm_29_Ksigalrm_defined_28sigbus_29_Ksigbus_defined_28sigchld_29_Ksigchld_defined_28sigcont_29_Ksigcont_defined_28sigfpe_29_Ksigfpe_defined_28sighup_29_Ksighup_defined_28sigill_29_Ksigill_defined_28sigint_29_Ksigint_defined_28sigkill_29_Ksigkill_defined_28sigpipe_29_Ksigpipe_defined_28sigquit_29_Ksigquit_defined_28sigsegv_29_Ksigsegv_defined_28sigstop_29_Ksigstop_defined_28sigterm_29_Ksigterm_defined_28sigtstp_29_Ksigtstp_defined_28sigttin_29_Ksigttin_defined_28sigttou_29_Ksigttou_defined_28sigusr1_29_Ksigusr1_defined_28sigusr2_29_Ksigusr2_defined_28sigpoll_29_Ksigpoll_defined_28sigprof_29_Ksigprof_defined_28sigsys_29_Ksigsys_defined_28sigtrap_29_Ksigtrap_defined_28sigurg_29_Ksigurg_defined_28sigvtalrm_29_Ksigvtalrm_defined_28sigxcpu_29_Ksigxcpu_defined_28sigxfsz_29_Ksigxfsz__29_29;
#if defined(WIN32_NATIVE) || (defined(HAVE_STATVFS) && defined(HAVE_SYS_STATVFS_H))
  gcv_object_t _object___28or_20integer_20_28member_defined_28st_rdonly_29_Kst_rdonly_defined_28st_nosuid_29_Kst_nosuid_defined_28st_notrunc_29_Kst_notrunc_defined_28st_nodev_29_Kst_nodev_defined_28st_noexec_29_Kst_noexec_defined_28st_synchronous_29_Kst_synchronous_defined_28st_mandlock_29_Kst_mandlock_defined_28st_write_29_Kst_write_defined_28st_append_29_Kst_append_defined_28st_immutable_29_Kst_immutable_defined_28st_noatime_29_Kst_noatime_defined_28st_nodiratime_29_Kst_nodiratime_defined_28file_named_streams_29_Kfile_named_streams_defined_28file_read_only_volume_29_Kfile_read_only_volume_defined_28file_supports_object_ids_29_Kfile_supports_object_ids_defined_28file_supports_reparse_points_29_Kfile_supports_reparse_points_defined_28file_supports_sparse_files_29_Kfile_supports_sparse_files_defined_28file_volume_quotas_29_Kfile_volume_quotas_defined_28file_supports_encryption_29_Kfile_supports_encryption_defined_28fs_case_is_preserved_29_Kfs_case_is_preserved_defined_28fs_case_sensitive_29_Kfs_case_sensitive_defined_28fs_file_compression_29_Kfs_file_compression_defined_28fs_file_encryption_29_Kfs_file_encryption_defined_28fs_persistent_acls_29_Kfs_persistent_acls_defined_28fs_unicode_stored_on_disk_29_Kfs_unicode_stored_on_disk_defined_28fs_vol_is_compressed_29_Kfs_vol_is_compressed__29_29;
#endif
  gcv_object_t _object___28or_20integer_20_28member_defined_28s_ififo_29_Kfifo_defined_28s_ifsock_29_Kfsock_defined_28s_ifchr_29_Kfchr_defined_28s_ifdir_29_Kfdir_defined_28s_ifblk_29_Kfblk_defined_28s_ifreg_29_Kfreg__29_29;
  gcv_object_t _object___28or_20integer_20_28member_defined_28s_isuid_29_Ksuid_defined_28s_isgid_29_Ksgid_defined_28s_isvtx_29_Ksvtx_defined_28s_irwxu_29_Krwxu_defined_28s_irusr_29_Krusr_defined_28s_iwusr_29_Kwusr_defined_28s_ixusr_29_Kxusr_defined_28s_irwxg_29_Krwxg_defined_28s_irgrp_29_Krgrp_defined_28s_iwgrp_29_Kwgrp_defined_28s_ixgrp_29_Kxgrp_defined_28s_irwxo_29_Krwxo_defined_28s_iroth_29_Kroth_defined_28s_iwoth_29_Kwoth_defined_28s_ixoth_29_Kxoth__29_29;
#if defined(HAVE_CONFSTR)
  gcv_object_t _object___28or_20integer_20_28member_defined_28_cs_path_29_Kpath_defined_28_cs_posix_v6_ilp32_off32_cflags_29_Kposix_v6_ilp32_off32_cflags_defined_28_cs_posix_v6_ilp32_off32_ldflags_29_Kposix_v6_ilp32_off32_ldflags_defined_28_cs_posix_v6_ilp32_off32_libs_29_Kposix_v6_ilp32_off32_libs_defined_28_cs_posix_v6_ilp32_offbig_cflags_29_Kposix_v6_ilp32_offbig_cflags_defined_28_cs_posix_v6_ilp32_offbig_ldflags_29_Kposix_v6_ilp32_offbig_ldflags_defined_28_cs_posix_v6_ilp32_offbig_libs_29_Kposix_v6_ilp32_offbig_libs_defined_28_cs_posix_v6_lp64_off64_cflags_29_Kposix_v6_lp64_off64_cflags_defined_28_cs_posix_v6_lp64_off64_ldflags_29_Kposix_v6_lp64_off64_ldflags_defined_28_cs_posix_v6_lp64_off64_libs_29_Kposix_v6_lp64_off64_libs_defined_28_cs_posix_v6_lpbig_offbig_cflags_29_Kposix_v6_lpbig_offbig_cflags_defined_28_cs_posix_v6_lpbig_offbig_ldflags_29_Kposix_v6_lpbig_offbig_ldflags_defined_28_cs_posix_v6_lpbig_offbig_libs_29_Kposix_v6_lpbig_offbig_libs_defined_28_cs_posix_v6_width_restricted_envs_29_Kposix_v6_width_restricted_envs_defined_28_cs_v7_env_29_Kv7_env_defined_28_cs_posix_v7_ilp32_off32_cflags_29_Kposix_v7_ilp32_off32_cflags_defined_28_cs_posix_v7_ilp32_off32_ldflags_29_Kposix_v7_ilp32_off32_ldflags_defined_28_cs_posix_v7_ilp32_off32_libs_29_Kposix_v7_ilp32_off32_libs_defined_28_cs_posix_v7_ilp32_offbig_cflags_29_Kposix_v7_ilp32_offbig_cflags_defined_28_cs_posix_v7_ilp32_offbig_ldflags_29_Kposix_v7_ilp32_offbig_ldflags_defined_28_cs_posix_v7_ilp32_offbig_libs_29_Kposix_v7_ilp32_offbig_libs_defined_28_cs_posix_v7_lp64_off64_cflags_29_Kposix_v7_lp64_off64_cflags_defined_28_cs_posix_v7_lp64_off64_ldflags_29_Kposix_v7_lp64_off64_ldflags_defined_28_cs_posix_v7_lp64_off64_libs_29_Kposix_v7_lp64_off64_libs_defined_28_cs_posix_v7_lpbig_offbig_cflags_29_Kposix_v7_lpbig_offbig_cflags_defined_28_cs_posix_v7_lpbig_offbig_ldflags_29_Kposix_v7_lpbig_offbig_ldflags_defined_28_cs_posix_v7_lpbig_offbig_libs_29_Kposix_v7_lpbig_offbig_libs_defined_28_cs_posix_v7_threads_cflags_29_Kposix_v7_t;
#endif
#if defined(HAVE_PATHCONF) && defined(HAVE_FPATHCONF)
  gcv_object_t _object___28or_20integer_20_28member_defined_28_pc_filesizebits_29_Kfilesizebits_defined_28_pc_link_max_29_Klink_max_defined_28_pc_max_canon_29_Kmax_canon_defined_28_pc_max_input_29_Kmax_input_defined_28_pc_name_max_29_Kname_max_defined_28_pc_path_max_29_Kpath_max_defined_28_pc_pipe_buf_29_Kpipe_buf_defined_28_pc_2_symlinks_29_K2_symlinks_defined_28_pc_alloc_size_min_29_Kalloc_size_min_defined_28_pc_rec_incr_xfer_size_29_Krec_incr_xfer_size_defined_28_pc_rec_max_xfer_size_29_Krec_max_xfer_size_defined_28_pc_rec_min_xfer_size_29_Krec_min_xfer_size_defined_28_pc_rec_xfer_align_29_Krec_xfer_align_defined_28_pc_symlink_max_29_Ksymlink_max_defined_28_pc_chown_restricted_29_Kchown_restricted_defined_28_pc_no_trunc_29_Kno_trunc_defined_28_pc_vdisable_29_Kvdisable_defined_28_pc_async_io_29_Kasync_io_defined_28_pc_prio_io_29_Kprio_io_defined_28_pc_sync_io_29_Ksync_io_defined_28_pc_sock_maxbuf_29_Ksock_maxbuf__29_29;
#endif
#if defined(HAVE_SYSCONF)
  gcv_object_t _object___28or_20integer_20_28member_defined_28_sc_aio_listio_max_29_Kaio_listio_max_defined_28_sc_aio_max_29_Kaio_max_defined_28_sc_aio_prio_delta_max_29_Kaio_prio_delta_max_defined_28_sc_arg_max_29_Karg_max_defined_28_sc_atexit_max_29_Katexit_max_defined_28_sc_bc_base_max_29_Kbc_base_max_defined_28_sc_bc_dim_max_29_Kbc_dim_max_defined_28_sc_bc_scale_max_29_Kbc_scale_max_defined_28_sc_bc_string_max_29_Kbc_string_max_defined_28_sc_child_max_29_Kchild_max_defined_28_sc_clk_tck_29_Kclk_tck_defined_28_sc_coll_weights_max_29_Kcoll_weights_max_defined_28_sc_delaytimer_max_29_Kdelaytimer_max_defined_28_sc_expr_nest_max_29_Kexpr_nest_max_defined_28_sc_host_name_max_29_Khost_name_max_defined_28_sc_iov_max_29_Kiov_max_defined_28_sc_line_max_29_Kline_max_defined_28_sc_login_name_max_29_Klogin_name_max_defined_28_sc_ngroups_max_29_Kngroups_max_defined_28_sc_getgr_r_size_max_29_Kgetgr_r_size_max_defined_28_sc_getpw_r_size_max_29_Kgetpw_r_size_max_defined_28_sc_mq_open_max_29_Kmq_open_max_defined_28_sc_mq_prio_max_29_Kmq_prio_max_defined_28_sc_open_max_29_Kopen_max_defined_28_sc_advisory_info_29_Kadvisory_info_defined_28_sc_barriers_29_Kbarriers_defined_28_sc_asynchronous_io_29_Kasynchronous_io_defined_28_sc_clock_selection_29_Kclock_selection_defined_28_sc_cputime_29_Kcputime_defined_28_sc_fsync_29_Kfsync_defined_28_sc_ipv6_29_Kipv6_defined_28_sc_job_control_29_Kjob_control_defined_28_sc_mapped_files_29_Kmapped_files_defined_28_sc_memlock_29_Kmemlock_defined_28_sc_memlock_range_29_Kmemlock_range_defined_28_sc_memory_protection_29_Kmemory_protection_defined_28_sc_message_passing_29_Kmessage_passing_defined_28_sc_monotonic_clock_29_Kmonotonic_clock_defined_28_sc_prioritized_io_29_Kprioritized_io_defined_28_sc_priority_scheduling_29_Kpriority_scheduling_defined_28_sc_raw_sockets_29_Kraw_sockets_defined_28_sc_reader_writer_locks_29_Kreader_writer_locks_defined_28_sc_realtime_signals_29_Krealtime_signals_defined_28_sc_regexp_29_Kregexp_defined_28_sc_saved_ids_29_Ksaved_ids_defined_28;
#endif
#if defined(HAVE_SYSLOG)
  gcv_object_t _object___28or_20null_20integer_20_28member_defined_28log_kern_29_Kkern_defined_28log_user_29_Kuser_defined_28log_mail_29_Kmail_defined_28log_news_29_Knews_defined_28log_uucp_29_Kuucp_defined_28log_daemon_29_Kdaemon_defined_28log_auth_29_Kauth_defined_28log_cron_29_Kcron_defined_28log_lpr_29_Klpr_defined_28log_syslog_29_Ksyslog_defined_28log_authpriv_29_Kauthpriv_defined_28log_ftp_29_Kftp_defined_28log_local0_29_Klocal0_defined_28log_local1_29_Klocal1_defined_28log_local2_29_Klocal2_defined_28log_local3_29_Klocal3_defined_28log_local4_29_Klocal4_defined_28log_local5_29_Klocal5_defined_28log_local6_29_Klocal6_defined_28log_local7_29_Klocal7__29_29;
#endif
  gcv_object_t _object___28or_20null_20integer_20_28member_defined_28prio_process_29_Kprocess_defined_28prio_pgrp_29_Kpgrp_defined_28prio_user_29_Kuser__29_29;
#if defined(WIN32_NATIVE)
  gcv_object_t _object___28or_20null_20integer_20_28member_defined_28realtime_priority_class_29_Krealtime_defined_28high_priority_class_29_Khigh_defined_28above_normal_priority_class_29_Kabove_normal_defined_28normal_priority_class_29_Knormal_defined_28below_normal_priority_class_29_Kbelow_normal_defined_28low_priority_class_29_Klow_defined_28idle_priority_class_29_Kidle__29_29;
#endif
#if !(defined(WIN32_NATIVE))
  gcv_object_t _object___28or_20null_20integer_20_28member_Krealtime_Khigh_Kabove_normal_Knormal_Kbelow_normal_Klow_Kidle__29_29;
#endif
  gcv_object_t _my_stdin;
  gcv_object_t _my_stdout;
  gcv_object_t _my_stderr;
} module__syscalls__object_tab;
uintC module__syscalls__object_tab_size = sizeof(module__syscalls__object_tab)/sizeof(gcv_object_t);

struct module__syscalls__object_tab_initdata_t {
  object_initdata_t _object_cl_decode_universal_time;
#if (defined(HAVE_SYSCONF)) && (defined(_SC_2_CHAR_TERM))
  object_initdata_t _object_K2_char_term;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_2_C_BIND))
  object_initdata_t _object_K2_c_bind;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_2_C_DEV))
  object_initdata_t _object_K2_c_dev;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_2_FORT_DEV))
  object_initdata_t _object_K2_fort_dev;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_2_FORT_RUN))
  object_initdata_t _object_K2_fort_run;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_2_LOCALEDEF))
  object_initdata_t _object_K2_localedef;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_2_PBS))
  object_initdata_t _object_K2_pbs;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_2_PBS_ACCOUNTING))
  object_initdata_t _object_K2_pbs_accounting;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_2_PBS_CHECKPOINT))
  object_initdata_t _object_K2_pbs_checkpoint;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_2_PBS_LOCATE))
  object_initdata_t _object_K2_pbs_locate;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_2_PBS_MESSAGE))
  object_initdata_t _object_K2_pbs_message;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_2_PBS_TRACK))
  object_initdata_t _object_K2_pbs_track;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_2_SW_DEV))
  object_initdata_t _object_K2_sw_dev;
#endif
#if (defined(HAVE_PATHCONF) && defined(HAVE_FPATHCONF)) && (defined(_PC_2_SYMLINKS))
  object_initdata_t _object_K2_symlinks;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_2_UPE))
  object_initdata_t _object_K2_upe;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_2_VERSION))
  object_initdata_t _object_K2_version;
#endif
#if ((defined(WIN32_NATIVE)) && (defined(ABOVE_NORMAL_PRIORITY_CLASS))) || (!(defined(WIN32_NATIVE)))
  object_initdata_t _object_Kabove_normal;
#endif
#if (defined(HAVE_UTMPX_H)) && (defined(ACCOUNTING))
  object_initdata_t _object_Kaccounting;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_ADVISORY_INFO))
  object_initdata_t _object_Kadvisory_info;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_AIO_LISTIO_MAX))
  object_initdata_t _object_Kaio_listio_max;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_AIO_MAX))
  object_initdata_t _object_Kaio_max;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_AIO_PRIO_DELTA_MAX))
  object_initdata_t _object_Kaio_prio_delta_max;
#endif
#if (defined(HAVE_SYSLOG)) && (defined(LOG_ALERT))
  object_initdata_t _object_Kalert;
#endif
#if (defined(HAVE_PATHCONF) && defined(HAVE_FPATHCONF)) && (defined(_PC_ALLOC_SIZE_MIN))
  object_initdata_t _object_Kalloc_size_min;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(PROCESSOR_ARCHITECTURE_ALPHA))
  object_initdata_t _object_Kalpha;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(PROCESSOR_ARCHITECTURE_ALPHA64))
  object_initdata_t _object_Kalpha64;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  object_initdata_t _object_Kalt;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(PROCESSOR_ARCHITECTURE_AMD64))
  object_initdata_t _object_Kamd64;
#endif
#if (defined(HAVE_FCNTL)) && (defined(O_APPEND))
  object_initdata_t _object_Kappend;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  object_initdata_t _object_Kappname;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(FILE_ATTRIBUTE_ARCHIVE))
  object_initdata_t _object_Karchive;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  object_initdata_t _object_Karguments;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_ARG_MAX))
  object_initdata_t _object_Karg_max;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(PROCESSOR_ARCHITECTURE_ARM))
  object_initdata_t _object_Karm;
#endif
#if (defined(HAVE_GETRLIMIT) || defined(HAVE_SETRLIMIT)) && (defined(RLIMIT_AS))
  object_initdata_t _object_Kas;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_ASYNCHRONOUS_IO))
  object_initdata_t _object_Kasynchronous_io;
#endif
#if (defined(HAVE_PATHCONF) && defined(HAVE_FPATHCONF)) && (defined(_PC_ASYNC_IO))
  object_initdata_t _object_Kasync_io;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_ATEXIT_MAX))
  object_initdata_t _object_Katexit_max;
#endif
#if defined(HAVE_STAT) && (defined(HAVE_CHMOD) || defined(HAVE_CHOWN) || defined(HAVE_UTIME))
  object_initdata_t _object_Katime;
#endif
#if (defined(HAVE_SYSLOG)) && (defined(LOG_AUTH))
  object_initdata_t _object_Kauth;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  object_initdata_t _object_Kauthor;
#endif
#if (defined(HAVE_SYSLOG)) && (defined(LOG_AUTHPRIV))
  object_initdata_t _object_Kauthpriv;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_AVPHYS_PAGES))
  object_initdata_t _object_Kavphys_pages;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  object_initdata_t _object_Kbackoffice;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_BARRIERS))
  object_initdata_t _object_Kbarriers;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_BC_BASE_MAX))
  object_initdata_t _object_Kbc_base_max;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_BC_DIM_MAX))
  object_initdata_t _object_Kbc_dim_max;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_BC_SCALE_MAX))
  object_initdata_t _object_Kbc_scale_max;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_BC_STRING_MAX))
  object_initdata_t _object_Kbc_string_max;
#endif
#if ((defined(WIN32_NATIVE)) && (defined(BELOW_NORMAL_PRIORITY_CLASS))) || (!(defined(WIN32_NATIVE)))
  object_initdata_t _object_Kbelow_normal;
#endif
#if (defined(HAVE_FCNTL)) && (defined(O_BINARY))
  object_initdata_t _object_Kbinary;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  object_initdata_t _object_Kblob;
#endif
#if defined(HAVE_FCNTL) || defined(WIN32_NATIVE)
  object_initdata_t _object_Kblock;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  object_initdata_t _object_Kbool;
#endif
#if (defined(HAVE_UTMPX_H)) && (defined(BOOT_TIME))
  object_initdata_t _object_Kboot_time;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  object_initdata_t _object_Kbstr;
#endif
  object_initdata_t _object_Kbuffered;
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  object_initdata_t _object_Kbuilt_in;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  object_initdata_t _object_Kbyref;
#endif
  object_initdata_t _object_Kcase_sensitive;
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  object_initdata_t _object_Kcharcount;
#endif
#if defined(HAVE_NFTW)
  object_initdata_t _object_Kchdir;
#endif
#if (defined(HAVE_SYS_RESOURCE_H)) && (defined(HAVE_GETRUSAGE)) && (defined(RUSAGE_CHILDREN))
  object_initdata_t _object_Kchildren;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_CHILD_MAX))
  object_initdata_t _object_Kchild_max;
#endif
#if (defined(HAVE_PATHCONF) && defined(HAVE_FPATHCONF)) && (defined(_PC_CHOWN_RESTRICTED))
  object_initdata_t _object_Kchown_restricted;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  object_initdata_t _object_Kclipboard_format;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_CLK_TCK))
  object_initdata_t _object_Kclk_tck;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_CLOCK_SELECTION))
  object_initdata_t _object_Kclock_selection;
#endif
#if (defined(HAVE_FCNTL)) && (defined(FD_CLOEXEC))
  object_initdata_t _object_Kcloexec;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  object_initdata_t _object_Kcodepage;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_COLL_WEIGHTS_MAX))
  object_initdata_t _object_Kcoll_weights_max;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  object_initdata_t _object_Kcomments;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(FILE_ATTRIBUTE_COMPRESSED))
  object_initdata_t _object_Kcompressed;
#endif
#if (defined(HAVE_SYSLOG)) && (defined(HAVE_OPENLOG))
  object_initdata_t _object_Kcons;
#endif
#if defined(HAVE_SYS_RESOURCE_H)
  object_initdata_t _object_Kcontinued;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  object_initdata_t _object_Kcontrol;
#endif
  object_initdata_t _object_Kcopy;
#if (defined(HAVE_GETRLIMIT) || defined(HAVE_SETRLIMIT)) && (defined(RLIMIT_CORE))
  object_initdata_t _object_Kcore;
#endif
#if (defined(HAVE_GETRLIMIT) || defined(HAVE_SETRLIMIT)) && (defined(RLIMIT_CPU))
  object_initdata_t _object_Kcpu;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_CPUTIME))
  object_initdata_t _object_Kcputime;
#endif
#if (defined(HAVE_FCNTL)) && (defined(O_CREAT))
  object_initdata_t _object_Kcreat;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  object_initdata_t _object_Kcreate_dtm;
#endif
#if (defined(HAVE_SYSLOG)) && (defined(LOG_CRIT))
  object_initdata_t _object_Kcrit;
#endif
#if (defined(HAVE_SYSLOG)) && (defined(LOG_CRON))
  object_initdata_t _object_Kcron;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  object_initdata_t _object_Kcy;
#endif
#if (defined(HAVE_NFTW)) && (defined(FTW_D))
  object_initdata_t _object_Kd;
#endif
#if (defined(HAVE_SYSLOG)) && (defined(LOG_DAEMON))
  object_initdata_t _object_Kdaemon;
#endif
#if (defined(HAVE_GETRLIMIT) || defined(HAVE_SETRLIMIT)) && (defined(RLIMIT_DATA))
  object_initdata_t _object_Kdata;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  object_initdata_t _object_Kdatacenter;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  object_initdata_t _object_Kdate;
#endif
#if (defined(HAVE_UTMPX_H)) && (defined(DEAD_PROCESS))
  object_initdata_t _object_Kdead_process;
#endif
#if (defined(HAVE_SYSLOG)) && (defined(LOG_DEBUG))
  object_initdata_t _object_Kdebug;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_DELAYTIMER_MAX))
  object_initdata_t _object_Kdelaytimer_max;
#endif
#if defined(HAVE_NFTW)
  object_initdata_t _object_Kdepth;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  object_initdata_t _object_Kdescription;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(FILE_ATTRIBUTE_DEVICE))
  object_initdata_t _object_Kdevice;
#endif
#if (defined(HAVE_FCNTL)) && (defined(O_DIRECT))
  object_initdata_t _object_Kdirect;
#endif
  object_initdata_t _object_Kdirection;
#if ((defined(HAVE_FCNTL)) && (defined(O_DIRECTORY))) || ((defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(FILE_ATTRIBUTE_DIRECTORY)))
  object_initdata_t _object_Kdirectory;
#endif
#if (defined(HAVE_NFTW)) && (defined(FTW_DNR))
  object_initdata_t _object_Kdnr;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_AUTOZONE_ALREADY_EXISTS))
  object_initdata_t _object_Kdns_error_autozone_already_exists;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_AXFR))
  object_initdata_t _object_Kdns_error_axfr;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_BAD_PACKET))
  object_initdata_t _object_Kdns_error_bad_packet;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_CANNOT_FIND_ROOT_HINTS))
  object_initdata_t _object_Kdns_error_cannot_find_root_hints;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_CNAME_COLLISION))
  object_initdata_t _object_Kdns_error_cname_collision;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_CNAME_LOOP))
  object_initdata_t _object_Kdns_error_cname_loop;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_DATAFILE_OPEN_FAILURE))
  object_initdata_t _object_Kdns_error_datafile_open_failure;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_DATAFILE_PARSING))
  object_initdata_t _object_Kdns_error_datafile_parsing;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_DP_ALREADY_ENLISTED))
  object_initdata_t _object_Kdns_error_dp_already_enlisted;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_DP_ALREADY_EXISTS))
  object_initdata_t _object_Kdns_error_dp_already_exists;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_DP_DOES_NOT_EXIST))
  object_initdata_t _object_Kdns_error_dp_does_not_exist;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_DP_NOT_AVAILABLE))
  object_initdata_t _object_Kdns_error_dp_not_available;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_DP_NOT_ENLISTED))
  object_initdata_t _object_Kdns_error_dp_not_enlisted;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_DS_UNAVAILABLE))
  object_initdata_t _object_Kdns_error_ds_unavailable;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_DS_ZONE_ALREADY_EXISTS))
  object_initdata_t _object_Kdns_error_ds_zone_already_exists;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_FILE_WRITEBACK_FAILED))
  object_initdata_t _object_Kdns_error_file_writeback_failed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_FORWARDER_ALREADY_EXISTS))
  object_initdata_t _object_Kdns_error_forwarder_already_exists;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_INCONSISTENT_ROOT_HINTS))
  object_initdata_t _object_Kdns_error_inconsistent_root_hints;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_INVALID_DATAFILE_NAME))
  object_initdata_t _object_Kdns_error_invalid_datafile_name;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_INVALID_IP_ADDRESS))
  object_initdata_t _object_Kdns_error_invalid_ip_address;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_INVALID_NAME_CHAR))
  object_initdata_t _object_Kdns_error_invalid_name_char;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_INVALID_PROPERTY))
  object_initdata_t _object_Kdns_error_invalid_property;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_INVALID_TYPE))
  object_initdata_t _object_Kdns_error_invalid_type;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_INVALID_ZONE_OPERATION))
  object_initdata_t _object_Kdns_error_invalid_zone_operation;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_INVALID_ZONE_TYPE))
  object_initdata_t _object_Kdns_error_invalid_zone_type;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_NAME_DOES_NOT_EXIST))
  object_initdata_t _object_Kdns_error_name_does_not_exist;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_NAME_NOT_IN_ZONE))
  object_initdata_t _object_Kdns_error_name_not_in_zone;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_NBSTAT_INIT_FAILED))
  object_initdata_t _object_Kdns_error_nbstat_init_failed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_NEED_SECONDARY_ADDRESSES))
  object_initdata_t _object_Kdns_error_need_secondary_addresses;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_NEED_WINS_SERVERS))
  object_initdata_t _object_Kdns_error_need_wins_servers;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_NODE_CREATION_FAILED))
  object_initdata_t _object_Kdns_error_node_creation_failed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_NODE_IS_CNAME))
  object_initdata_t _object_Kdns_error_node_is_cname;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_NON_RFC_NAME))
  object_initdata_t _object_Kdns_error_non_rfc_name;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_NOT_ALLOWED_ON_ROOT_SERVER))
  object_initdata_t _object_Kdns_error_not_allowed_on_root_server;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_NOT_ALLOWED_UNDER_DELEGATION))
  object_initdata_t _object_Kdns_error_not_allowed_under_delegation;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_NOT_UNIQUE))
  object_initdata_t _object_Kdns_error_not_unique;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_NO_BOOTFILE_IF_DS_ZONE))
  object_initdata_t _object_Kdns_error_no_bootfile_if_ds_zone;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_NO_CREATE_CACHE_DATA))
  object_initdata_t _object_Kdns_error_no_create_cache_data;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_NO_DNS_SERVERS))
  object_initdata_t _object_Kdns_error_no_dns_servers;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_NO_PACKET))
  object_initdata_t _object_Kdns_error_no_packet;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_NO_TCPIP))
  object_initdata_t _object_Kdns_error_no_tcpip;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_NO_ZONE_INFO))
  object_initdata_t _object_Kdns_error_no_zone_info;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_NUMERIC_NAME))
  object_initdata_t _object_Kdns_error_numeric_name;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_PRIMARY_REQUIRES_DATAFILE))
  object_initdata_t _object_Kdns_error_primary_requires_datafile;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_RCODE))
  object_initdata_t _object_Kdns_error_rcode;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_RCODE_BADKEY))
  object_initdata_t _object_Kdns_error_rcode_badkey;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_RCODE_BADSIG))
  object_initdata_t _object_Kdns_error_rcode_badsig;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_RCODE_BADTIME))
  object_initdata_t _object_Kdns_error_rcode_badtime;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_RCODE_FORMAT_ERROR))
  object_initdata_t _object_Kdns_error_rcode_format_error;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_RCODE_NAME_ERROR))
  object_initdata_t _object_Kdns_error_rcode_name_error;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_RCODE_NOTAUTH))
  object_initdata_t _object_Kdns_error_rcode_notauth;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_RCODE_NOTZONE))
  object_initdata_t _object_Kdns_error_rcode_notzone;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_RCODE_NOT_IMPLEMENTED))
  object_initdata_t _object_Kdns_error_rcode_not_implemented;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_RCODE_NXRRSET))
  object_initdata_t _object_Kdns_error_rcode_nxrrset;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_RCODE_REFUSED))
  object_initdata_t _object_Kdns_error_rcode_refused;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_RCODE_SERVER_FAILURE))
  object_initdata_t _object_Kdns_error_rcode_server_failure;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_RCODE_YXDOMAIN))
  object_initdata_t _object_Kdns_error_rcode_yxdomain;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_RCODE_YXRRSET))
  object_initdata_t _object_Kdns_error_rcode_yxrrset;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_RECORD_ALREADY_EXISTS))
  object_initdata_t _object_Kdns_error_record_already_exists;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_RECORD_DOES_NOT_EXIST))
  object_initdata_t _object_Kdns_error_record_does_not_exist;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_RECORD_FORMAT))
  object_initdata_t _object_Kdns_error_record_format;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_RECORD_ONLY_AT_ZONE_ROOT))
  object_initdata_t _object_Kdns_error_record_only_at_zone_root;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_RECORD_TIMED_OUT))
  object_initdata_t _object_Kdns_error_record_timed_out;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_SECONDARY_DATA))
  object_initdata_t _object_Kdns_error_secondary_data;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_SECONDARY_REQUIRES_MASTER_IP))
  object_initdata_t _object_Kdns_error_secondary_requires_master_ip;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_SOA_DELETE_INVALID))
  object_initdata_t _object_Kdns_error_soa_delete_invalid;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_TRY_AGAIN_LATER))
  object_initdata_t _object_Kdns_error_try_again_later;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_UNKNOWN_RECORD_TYPE))
  object_initdata_t _object_Kdns_error_unknown_record_type;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_UNSECURE_PACKET))
  object_initdata_t _object_Kdns_error_unsecure_packet;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_WINS_INIT_FAILED))
  object_initdata_t _object_Kdns_error_wins_init_failed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_ZONE_ALREADY_EXISTS))
  object_initdata_t _object_Kdns_error_zone_already_exists;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_ZONE_CONFIGURATION_ERROR))
  object_initdata_t _object_Kdns_error_zone_configuration_error;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_ZONE_CREATION_FAILED))
  object_initdata_t _object_Kdns_error_zone_creation_failed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_ZONE_DOES_NOT_EXIST))
  object_initdata_t _object_Kdns_error_zone_does_not_exist;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_ZONE_HAS_NO_NS_RECORDS))
  object_initdata_t _object_Kdns_error_zone_has_no_ns_records;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_ZONE_HAS_NO_SOA_RECORD))
  object_initdata_t _object_Kdns_error_zone_has_no_soa_record;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_ZONE_IS_SHUTDOWN))
  object_initdata_t _object_Kdns_error_zone_is_shutdown;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_ZONE_LOCKED))
  object_initdata_t _object_Kdns_error_zone_locked;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_ZONE_NOT_SECONDARY))
  object_initdata_t _object_Kdns_error_zone_not_secondary;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_ZONE_REQUIRES_MASTER_IP))
  object_initdata_t _object_Kdns_error_zone_requires_master_ip;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_INFO_ADDED_LOCAL_WINS))
  object_initdata_t _object_Kdns_info_added_local_wins;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_INFO_AXFR_COMPLETE))
  object_initdata_t _object_Kdns_info_axfr_complete;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_INFO_NO_RECORDS))
  object_initdata_t _object_Kdns_info_no_records;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_STATUS_CONTINUE_NEEDED))
  object_initdata_t _object_Kdns_status_continue_needed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_STATUS_DOTTED_NAME))
  object_initdata_t _object_Kdns_status_dotted_name;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_STATUS_FQDN))
  object_initdata_t _object_Kdns_status_fqdn;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_STATUS_SINGLE_PART_NAME))
  object_initdata_t _object_Kdns_status_single_part_name;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_WARNING_DOMAIN_UNDELETED))
  object_initdata_t _object_Kdns_warning_domain_undeleted;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_WARNING_PTR_CREATE_FAILED))
  object_initdata_t _object_Kdns_warning_ptr_create_failed;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  object_initdata_t _object_Kdoc_security;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  object_initdata_t _object_Kdomain_controller;
#endif
#if (defined(HAVE_NFTW)) && (defined(FTW_DP))
  object_initdata_t _object_Kdp;
#endif
#if defined(E2BIG)
  object_initdata_t _object_Ke2big;
#endif
#if defined(EACCES)
  object_initdata_t _object_Keacces;
#endif
#if defined(EADDRINUSE)
  object_initdata_t _object_Keaddrinuse;
#endif
#if defined(EADDRNOTAVAIL)
  object_initdata_t _object_Keaddrnotavail;
#endif
#if defined(EADV)
  object_initdata_t _object_Keadv;
#endif
#if defined(EAFNOSUPPORT)
  object_initdata_t _object_Keafnosupport;
#endif
#if defined(EAGAIN)
  object_initdata_t _object_Keagain;
#endif
#if defined(EAIO)
  object_initdata_t _object_Keaio;
#endif
#if defined(EALIGN)
  object_initdata_t _object_Kealign;
#endif
#if defined(EALREADY)
  object_initdata_t _object_Kealready;
#endif
#if defined(EAUTH)
  object_initdata_t _object_Keauth;
#endif
#if defined(EBADE)
  object_initdata_t _object_Kebade;
#endif
#if defined(EBADF)
  object_initdata_t _object_Kebadf;
#endif
#if defined(EBADFD)
  object_initdata_t _object_Kebadfd;
#endif
#if defined(EBADMSG)
  object_initdata_t _object_Kebadmsg;
#endif
#if defined(EBADR)
  object_initdata_t _object_Kebadr;
#endif
#if defined(EBADRPC)
  object_initdata_t _object_Kebadrpc;
#endif
#if defined(EBADRQC)
  object_initdata_t _object_Kebadrqc;
#endif
#if defined(EBADSLT)
  object_initdata_t _object_Kebadslt;
#endif
#if defined(EBFONT)
  object_initdata_t _object_Kebfont;
#endif
#if defined(EBUSY)
  object_initdata_t _object_Kebusy;
#endif
#if defined(ECANCELED)
  object_initdata_t _object_Kecanceled;
#endif
#if defined(ECASECLASH)
  object_initdata_t _object_Kecaseclash;
#endif
#if defined(ECHILD)
  object_initdata_t _object_Kechild;
#endif
#if defined(ECHRNG)
  object_initdata_t _object_Kechrng;
#endif
#if defined(ECLONEME)
  object_initdata_t _object_Kecloneme;
#endif
#if defined(ECOMM)
  object_initdata_t _object_Kecomm;
#endif
#if defined(ECONNABORTED)
  object_initdata_t _object_Keconnaborted;
#endif
#if defined(ECONNREFUSED)
  object_initdata_t _object_Keconnrefused;
#endif
#if defined(ECONNRESET)
  object_initdata_t _object_Keconnreset;
#endif
#if defined(EDEADLK)
  object_initdata_t _object_Kedeadlk;
#endif
#if defined(EDEADLOCK)
  object_initdata_t _object_Kedeadlock;
#endif
#if defined(EDESTADDRREQ)
  object_initdata_t _object_Kedestaddrreq;
#endif
#if defined(EDIRIOCTL)
  object_initdata_t _object_Kedirioctl;
#endif
#if defined(EDIRTY)
  object_initdata_t _object_Kedirty;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  object_initdata_t _object_Kedittime;
#endif
#if defined(EDOM)
  object_initdata_t _object_Kedom;
#endif
#if defined(EDOOFUS)
  object_initdata_t _object_Kedoofus;
#endif
#if defined(EDOTDOT)
  object_initdata_t _object_Kedotdot;
#endif
#if defined(EDQUOT)
  object_initdata_t _object_Kedquot;
#endif
#if defined(EDUPPKG)
  object_initdata_t _object_Keduppkg;
#endif
#if defined(EEXIST)
  object_initdata_t _object_Keexist;
#endif
#if defined(EFAIL)
  object_initdata_t _object_Kefail;
#endif
#if defined(EFAULT)
  object_initdata_t _object_Kefault;
#endif
#if defined(EFBIG)
  object_initdata_t _object_Kefbig;
#endif
#if defined(EFTYPE)
  object_initdata_t _object_Keftype;
#endif
#if defined(EHOSTDOWN)
  object_initdata_t _object_Kehostdown;
#endif
#if defined(EHOSTUNREACH)
  object_initdata_t _object_Kehostunreach;
#endif
#if defined(EHWPOISON)
  object_initdata_t _object_Kehwpoison;
#endif
#if defined(EIDRM)
  object_initdata_t _object_Keidrm;
#endif
#if defined(EILSEQ)
  object_initdata_t _object_Keilseq;
#endif
#if defined(EINIT)
  object_initdata_t _object_Keinit;
#endif
#if defined(EINPROG)
  object_initdata_t _object_Keinprog;
#endif
#if defined(EINPROGRESS)
  object_initdata_t _object_Keinprogress;
#endif
#if defined(EINTR)
  object_initdata_t _object_Keintr;
#endif
#if defined(EINVAL)
  object_initdata_t _object_Keinval;
#endif
#if defined(EIO)
  object_initdata_t _object_Keio;
#endif
#if defined(EISCONN)
  object_initdata_t _object_Keisconn;
#endif
#if defined(EISDIR)
  object_initdata_t _object_Keisdir;
#endif
#if defined(EISNAM)
  object_initdata_t _object_Keisnam;
#endif
#if defined(EISNAME)
  object_initdata_t _object_Keisname;
#endif
#if defined(EJUSTRETURN)
  object_initdata_t _object_Kejustreturn;
#endif
#if defined(EKEYEXPIRED)
  object_initdata_t _object_Kekeyexpired;
#endif
#if defined(EKEYREJECTED)
  object_initdata_t _object_Kekeyrejected;
#endif
#if defined(EKEYREVOKED)
  object_initdata_t _object_Kekeyrevoked;
#endif
#if defined(EL2HLT)
  object_initdata_t _object_Kel2hlt;
#endif
#if defined(EL2NSYNC)
  object_initdata_t _object_Kel2nsync;
#endif
#if defined(EL3HLT)
  object_initdata_t _object_Kel3hlt;
#endif
#if defined(EL3RST)
  object_initdata_t _object_Kel3rst;
#endif
#if defined(ELAST)
  object_initdata_t _object_Kelast;
#endif
#if defined(ELBIN)
  object_initdata_t _object_Kelbin;
#endif
  object_initdata_t _object_Kelement_type;
#if defined(ELIBACC)
  object_initdata_t _object_Kelibacc;
#endif
#if defined(ELIBBAD)
  object_initdata_t _object_Kelibbad;
#endif
#if defined(ELIBEXEC)
  object_initdata_t _object_Kelibexec;
#endif
#if defined(ELIBMAX)
  object_initdata_t _object_Kelibmax;
#endif
#if defined(ELIBSCN)
  object_initdata_t _object_Kelibscn;
#endif
#if defined(ELNRNG)
  object_initdata_t _object_Kelnrng;
#endif
#if defined(ELOCKUNMAPPED)
  object_initdata_t _object_Kelockunmapped;
#endif
#if defined(ELOOP)
  object_initdata_t _object_Keloop;
#endif
#if defined(EMEDIUMTYPE)
  object_initdata_t _object_Kemediumtype;
#endif
#if (defined(HAVE_SYSLOG)) && (defined(LOG_EMERG))
  object_initdata_t _object_Kemerg;
#endif
#if defined(EMFILE)
  object_initdata_t _object_Kemfile;
#endif
#if defined(EMLINK)
  object_initdata_t _object_Kemlink;
#endif
#if ((defined(HAVE_UTMPX_H)) && (defined(EMPTY))) || (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN))
  object_initdata_t _object_Kempty;
#endif
#if defined(EMSGSIZE)
  object_initdata_t _object_Kemsgsize;
#endif
#if defined(EMTIMERS)
  object_initdata_t _object_Kemtimers;
#endif
#if defined(EMULTIHOP)
  object_initdata_t _object_Kemultihop;
#endif
#if defined(ENAMETOOLONG)
  object_initdata_t _object_Kenametoolong;
#endif
#if defined(ENAVAIL)
  object_initdata_t _object_Kenavail;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(FILE_ATTRIBUTE_ENCRYPTED))
  object_initdata_t _object_Kencrypted;
#endif
#if defined(ENEEDAUTH)
  object_initdata_t _object_Keneedauth;
#endif
#if defined(ENET)
  object_initdata_t _object_Kenet;
#endif
#if defined(ENETDOWN)
  object_initdata_t _object_Kenetdown;
#endif
#if defined(ENETRESET)
  object_initdata_t _object_Kenetreset;
#endif
#if defined(ENETUNREACH)
  object_initdata_t _object_Kenetunreach;
#endif
#if defined(ENFILE)
  object_initdata_t _object_Kenfile;
#endif
#if defined(ENMFILE)
  object_initdata_t _object_Kenmfile;
#endif
#if defined(ENOANO)
  object_initdata_t _object_Kenoano;
#endif
#if defined(ENOATTR)
  object_initdata_t _object_Kenoattr;
#endif
#if defined(ENOBUFS)
  object_initdata_t _object_Kenobufs;
#endif
#if defined(ENOCSI)
  object_initdata_t _object_Kenocsi;
#endif
#if defined(ENODATA)
  object_initdata_t _object_Kenodata;
#endif
#if defined(ENODEV)
  object_initdata_t _object_Kenodev;
#endif
#if defined(ENOENT)
  object_initdata_t _object_Kenoent;
#endif
#if defined(ENOEXEC)
  object_initdata_t _object_Kenoexec;
#endif
#if defined(ENOFILE)
  object_initdata_t _object_Kenofile;
#endif
#if defined(ENOIOCTL)
  object_initdata_t _object_Kenoioctl;
#endif
#if defined(ENOKEY)
  object_initdata_t _object_Kenokey;
#endif
#if defined(ENOLCK)
  object_initdata_t _object_Kenolck;
#endif
#if defined(ENOLINK)
  object_initdata_t _object_Kenolink;
#endif
#if defined(ENOMEDIUM)
  object_initdata_t _object_Kenomedium;
#endif
#if defined(ENOMEM)
  object_initdata_t _object_Kenomem;
#endif
#if defined(ENOMSG)
  object_initdata_t _object_Kenomsg;
#endif
#if defined(ENONET)
  object_initdata_t _object_Kenonet;
#endif
#if defined(ENOPKG)
  object_initdata_t _object_Kenopkg;
#endif
#if defined(ENOPROTOOPT)
  object_initdata_t _object_Kenoprotoopt;
#endif
#if defined(ENOSHARE)
  object_initdata_t _object_Kenoshare;
#endif
#if defined(ENOSPC)
  object_initdata_t _object_Kenospc;
#endif
#if defined(ENOSR)
  object_initdata_t _object_Kenosr;
#endif
#if defined(ENOSTR)
  object_initdata_t _object_Kenostr;
#endif
#if defined(ENOSYM)
  object_initdata_t _object_Kenosym;
#endif
#if defined(ENOSYS)
  object_initdata_t _object_Kenosys;
#endif
#if defined(ENOTACTIVE)
  object_initdata_t _object_Kenotactive;
#endif
#if defined(ENOTBLK)
  object_initdata_t _object_Kenotblk;
#endif
#if defined(ENOTCONN)
  object_initdata_t _object_Kenotconn;
#endif
#if defined(ENOTDIR)
  object_initdata_t _object_Kenotdir;
#endif
#if defined(ENOTEMPTY)
  object_initdata_t _object_Kenotempty;
#endif
#if defined(ENOTNAM)
  object_initdata_t _object_Kenotnam;
#endif
#if defined(ENOTRECOVERABLE)
  object_initdata_t _object_Kenotrecoverable;
#endif
#if defined(ENOTSOCK)
  object_initdata_t _object_Kenotsock;
#endif
#if defined(ENOTSUP)
  object_initdata_t _object_Kenotsup;
#endif
#if defined(ENOTTY)
  object_initdata_t _object_Kenotty;
#endif
#if defined(ENOTUNIQ)
  object_initdata_t _object_Kenotuniq;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  object_initdata_t _object_Kenterprise;
#endif
#if defined(ENXIO)
  object_initdata_t _object_Kenxio;
#endif
#if defined(EOPNOTSUPP)
  object_initdata_t _object_Keopnotsupp;
#endif
#if defined(EOVERFLOW)
  object_initdata_t _object_Keoverflow;
#endif
#if defined(EOWNERDEAD)
  object_initdata_t _object_Keownerdead;
#endif
#if defined(EPERM)
  object_initdata_t _object_Keperm;
#endif
#if defined(EPFNOSUPPORT)
  object_initdata_t _object_Kepfnosupport;
#endif
#if defined(EPIPE)
  object_initdata_t _object_Kepipe;
#endif
#if defined(EPROCLIM)
  object_initdata_t _object_Keproclim;
#endif
#if defined(EPROCUNAVAIL)
  object_initdata_t _object_Keprocunavail;
#endif
#if defined(EPROGMISMATCH)
  object_initdata_t _object_Keprogmismatch;
#endif
#if defined(EPROGUNAVAIL)
  object_initdata_t _object_Keprogunavail;
#endif
#if defined(EPROTO)
  object_initdata_t _object_Keproto;
#endif
#if defined(EPROTONOSUPPORT)
  object_initdata_t _object_Keprotonosupport;
#endif
#if defined(EPROTOTYPE)
  object_initdata_t _object_Keprototype;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(EPT_S_CANT_CREATE))
  object_initdata_t _object_Kept_s_cant_create;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(EPT_S_CANT_PERFORM_OP))
  object_initdata_t _object_Kept_s_cant_perform_op;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(EPT_S_INVALID_ENTRY))
  object_initdata_t _object_Kept_s_invalid_entry;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(EPT_S_NOT_REGISTERED))
  object_initdata_t _object_Kept_s_not_registered;
#endif
#if defined(ERANGE)
  object_initdata_t _object_Kerange;
#endif
#if defined(EREMCHG)
  object_initdata_t _object_Keremchg;
#endif
#if defined(EREMDEV)
  object_initdata_t _object_Keremdev;
#endif
#if defined(EREMOTE)
  object_initdata_t _object_Keremote;
#endif
#if defined(EREMOTEIO)
  object_initdata_t _object_Keremoteio;
#endif
#if defined(EREMOTERELEASE)
  object_initdata_t _object_Keremoterelease;
#endif
#if defined(ERESTART)
  object_initdata_t _object_Kerestart;
#endif
#if defined(ERESTARTNOHAND)
  object_initdata_t _object_Kerestartnohand;
#endif
#if defined(ERESTARTNOINTR)
  object_initdata_t _object_Kerestartnointr;
#endif
#if defined(ERESTARTSYS)
  object_initdata_t _object_Kerestartsys;
#endif
#if defined(ERFKILL)
  object_initdata_t _object_Kerfkill;
#endif
#if defined(EROFS)
  object_initdata_t _object_Kerofs;
#endif
#if defined(ERPCMISMATCH)
  object_initdata_t _object_Kerpcmismatch;
#endif
#if (defined(HAVE_SYSLOG)) && (defined(LOG_ERR))
  object_initdata_t _object_Kerr;
#endif
#if defined(ERREMOTE)
  object_initdata_t _object_Kerremote;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  object_initdata_t _object_Kerror;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ACCESS_DENIED))
  object_initdata_t _object_Kerror_access_denied;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ACCESS_DISABLED_BY_POLICY))
  object_initdata_t _object_Kerror_access_disabled_by_policy;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ACCESS_DISABLED_WEBBLADE))
  object_initdata_t _object_Kerror_access_disabled_webblade;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ACCESS_DISABLED_WEBBLADE_TAMPER))
  object_initdata_t _object_Kerror_access_disabled_webblade_tamper;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ACCOUNT_DISABLED))
  object_initdata_t _object_Kerror_account_disabled;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ACCOUNT_EXPIRED))
  object_initdata_t _object_Kerror_account_expired;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ACCOUNT_LOCKED_OUT))
  object_initdata_t _object_Kerror_account_locked_out;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ACCOUNT_RESTRICTION))
  object_initdata_t _object_Kerror_account_restriction;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ACTIVATION_COUNT_EXCEEDED))
  object_initdata_t _object_Kerror_activation_count_exceeded;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ACTIVE_CONNECTIONS))
  object_initdata_t _object_Kerror_active_connections;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ADAP_HDW_ERR))
  object_initdata_t _object_Kerror_adap_hdw_err;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ADDRESS_ALREADY_ASSOCIATED))
  object_initdata_t _object_Kerror_address_already_associated;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ADDRESS_NOT_ASSOCIATED))
  object_initdata_t _object_Kerror_address_not_associated;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ALIAS_EXISTS))
  object_initdata_t _object_Kerror_alias_exists;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ALLOTTED_SPACE_EXCEEDED))
  object_initdata_t _object_Kerror_allotted_space_exceeded;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ALL_NODES_NOT_AVAILABLE))
  object_initdata_t _object_Kerror_all_nodes_not_available;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ALL_USER_TRUST_QUOTA_EXCEEDED))
  object_initdata_t _object_Kerror_all_user_trust_quota_exceeded;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ALREADY_ASSIGNED))
  object_initdata_t _object_Kerror_already_assigned;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ALREADY_EXISTS))
  object_initdata_t _object_Kerror_already_exists;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ALREADY_FIBER))
  object_initdata_t _object_Kerror_already_fiber;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ALREADY_INITIALIZED))
  object_initdata_t _object_Kerror_already_initialized;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ALREADY_REGISTERED))
  object_initdata_t _object_Kerror_already_registered;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ALREADY_RUNNING_LKG))
  object_initdata_t _object_Kerror_already_running_lkg;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ALREADY_THREAD))
  object_initdata_t _object_Kerror_already_thread;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ALREADY_WAITING))
  object_initdata_t _object_Kerror_already_waiting;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_APPHELP_BLOCK))
  object_initdata_t _object_Kerror_apphelp_block;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_APP_WRONG_OS))
  object_initdata_t _object_Kerror_app_wrong_os;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ARENA_TRASHED))
  object_initdata_t _object_Kerror_arena_trashed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ARITHMETIC_OVERFLOW))
  object_initdata_t _object_Kerror_arithmetic_overflow;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ATOMIC_LOCKS_NOT_SUPPORTED))
  object_initdata_t _object_Kerror_atomic_locks_not_supported;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_AUTODATASEG_EXCEEDS_64k))
  object_initdata_t _object_Kerror_autodataseg_exceeds_64k;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BADDB))
  object_initdata_t _object_Kerror_baddb;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BADKEY))
  object_initdata_t _object_Kerror_badkey;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BAD_ARGUMENTS))
  object_initdata_t _object_Kerror_bad_arguments;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BAD_COMMAND))
  object_initdata_t _object_Kerror_bad_command;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BAD_CONFIGURATION))
  object_initdata_t _object_Kerror_bad_configuration;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BAD_DESCRIPTOR_FORMAT))
  object_initdata_t _object_Kerror_bad_descriptor_format;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BAD_DEVICE))
  object_initdata_t _object_Kerror_bad_device;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BAD_DEV_TYPE))
  object_initdata_t _object_Kerror_bad_dev_type;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BAD_DRIVER))
  object_initdata_t _object_Kerror_bad_driver;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BAD_DRIVER_LEVEL))
  object_initdata_t _object_Kerror_bad_driver_level;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BAD_ENVIRONMENT))
  object_initdata_t _object_Kerror_bad_environment;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BAD_EXE_FORMAT))
  object_initdata_t _object_Kerror_bad_exe_format;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BAD_FORMAT))
  object_initdata_t _object_Kerror_bad_format;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BAD_IMPERSONATION_LEVEL))
  object_initdata_t _object_Kerror_bad_impersonation_level;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BAD_INHERITANCE_ACL))
  object_initdata_t _object_Kerror_bad_inheritance_acl;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BAD_LENGTH))
  object_initdata_t _object_Kerror_bad_length;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BAD_LOGON_SESSION_STATE))
  object_initdata_t _object_Kerror_bad_logon_session_state;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BAD_NETPATH))
  object_initdata_t _object_Kerror_bad_netpath;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BAD_NET_NAME))
  object_initdata_t _object_Kerror_bad_net_name;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BAD_NET_RESP))
  object_initdata_t _object_Kerror_bad_net_resp;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BAD_PATHNAME))
  object_initdata_t _object_Kerror_bad_pathname;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BAD_PIPE))
  object_initdata_t _object_Kerror_bad_pipe;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BAD_PROFILE))
  object_initdata_t _object_Kerror_bad_profile;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BAD_PROVIDER))
  object_initdata_t _object_Kerror_bad_provider;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BAD_QUERY_SYNTAX))
  object_initdata_t _object_Kerror_bad_query_syntax;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BAD_RECOVERY_POLICY))
  object_initdata_t _object_Kerror_bad_recovery_policy;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BAD_REM_ADAP))
  object_initdata_t _object_Kerror_bad_rem_adap;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BAD_THREADID_ADDR))
  object_initdata_t _object_Kerror_bad_threadid_addr;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BAD_TOKEN_TYPE))
  object_initdata_t _object_Kerror_bad_token_type;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BAD_UNIT))
  object_initdata_t _object_Kerror_bad_unit;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BAD_USERNAME))
  object_initdata_t _object_Kerror_bad_username;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BAD_USER_PROFILE))
  object_initdata_t _object_Kerror_bad_user_profile;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BAD_VALIDATION_CLASS))
  object_initdata_t _object_Kerror_bad_validation_class;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BEGINNING_OF_MEDIA))
  object_initdata_t _object_Kerror_beginning_of_media;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BOOT_ALREADY_ACCEPTED))
  object_initdata_t _object_Kerror_boot_already_accepted;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BROKEN_PIPE))
  object_initdata_t _object_Kerror_broken_pipe;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BUFFER_OVERFLOW))
  object_initdata_t _object_Kerror_buffer_overflow;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BUSY))
  object_initdata_t _object_Kerror_busy;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BUSY_DRIVE))
  object_initdata_t _object_Kerror_busy_drive;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BUS_RESET))
  object_initdata_t _object_Kerror_bus_reset;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CALLBACK_SUPPLIED_INVALID_DATA))
  object_initdata_t _object_Kerror_callback_supplied_invalid_data;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CALL_NOT_IMPLEMENTED))
  object_initdata_t _object_Kerror_call_not_implemented;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CANCELLED))
  object_initdata_t _object_Kerror_cancelled;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CANCEL_VIOLATION))
  object_initdata_t _object_Kerror_cancel_violation;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CANNOT_COPY))
  object_initdata_t _object_Kerror_cannot_copy;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CANNOT_DETECT_DRIVER_FAILURE))
  object_initdata_t _object_Kerror_cannot_detect_driver_failure;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CANNOT_DETECT_PROCESS_ABORT))
  object_initdata_t _object_Kerror_cannot_detect_process_abort;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CANNOT_FIND_WND_CLASS))
  object_initdata_t _object_Kerror_cannot_find_wnd_class;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CANNOT_IMPERSONATE))
  object_initdata_t _object_Kerror_cannot_impersonate;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CANNOT_MAKE))
  object_initdata_t _object_Kerror_cannot_make;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CANNOT_OPEN_PROFILE))
  object_initdata_t _object_Kerror_cannot_open_profile;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CANTOPEN))
  object_initdata_t _object_Kerror_cantopen;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CANTREAD))
  object_initdata_t _object_Kerror_cantread;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CANTWRITE))
  object_initdata_t _object_Kerror_cantwrite;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CANT_ACCESS_DOMAIN_INFO))
  object_initdata_t _object_Kerror_cant_access_domain_info;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CANT_ACCESS_FILE))
  object_initdata_t _object_Kerror_cant_access_file;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CANT_DELETE_LAST_ITEM))
  object_initdata_t _object_Kerror_cant_delete_last_item;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CANT_DISABLE_MANDATORY))
  object_initdata_t _object_Kerror_cant_disable_mandatory;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CANT_EVICT_ACTIVE_NODE))
  object_initdata_t _object_Kerror_cant_evict_active_node;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CANT_OPEN_ANONYMOUS))
  object_initdata_t _object_Kerror_cant_open_anonymous;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CANT_RESOLVE_FILENAME))
  object_initdata_t _object_Kerror_cant_resolve_filename;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CAN_NOT_COMPLETE))
  object_initdata_t _object_Kerror_can_not_complete;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CAN_NOT_DEL_LOCAL_WINS))
  object_initdata_t _object_Kerror_can_not_del_local_wins;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CHILD_MUST_BE_VOLATILE))
  object_initdata_t _object_Kerror_child_must_be_volatile;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CHILD_NOT_COMPLETE))
  object_initdata_t _object_Kerror_child_not_complete;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CHILD_WINDOW_MENU))
  object_initdata_t _object_Kerror_child_window_menu;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CIRCULAR_DEPENDENCY))
  object_initdata_t _object_Kerror_circular_dependency;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLASS_ALREADY_EXISTS))
  object_initdata_t _object_Kerror_class_already_exists;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLASS_DOES_NOT_EXIST))
  object_initdata_t _object_Kerror_class_does_not_exist;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLASS_HAS_WINDOWS))
  object_initdata_t _object_Kerror_class_has_windows;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLEANER_CARTRIDGE_INSTALLED))
  object_initdata_t _object_Kerror_cleaner_cartridge_installed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLEANER_CARTRIDGE_SPENT))
  object_initdata_t _object_Kerror_cleaner_cartridge_spent;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLEANER_SLOT_NOT_SET))
  object_initdata_t _object_Kerror_cleaner_slot_not_set;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLEANER_SLOT_SET))
  object_initdata_t _object_Kerror_cleaner_slot_set;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLIPBOARD_NOT_OPEN))
  object_initdata_t _object_Kerror_clipboard_not_open;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLIPPING_NOT_SUPPORTED))
  object_initdata_t _object_Kerror_clipping_not_supported;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSCFG_ALREADY_COMMITTED))
  object_initdata_t _object_Kerror_cluscfg_already_committed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSCFG_ROLLBACK_FAILED))
  object_initdata_t _object_Kerror_cluscfg_rollback_failed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSCFG_SYSTEM_DISK_DRIVE_LETTER_CONFLICT))
  object_initdata_t _object_Kerror_cluscfg_system_disk_drive_letter_conflict;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTERLOG_CHKPOINT_NOT_FOUND))
  object_initdata_t _object_Kerror_clusterlog_chkpoint_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTERLOG_CORRUPT))
  object_initdata_t _object_Kerror_clusterlog_corrupt;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTERLOG_EXCEEDS_MAXSIZE))
  object_initdata_t _object_Kerror_clusterlog_exceeds_maxsize;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTERLOG_NOT_ENOUGH_SPACE))
  object_initdata_t _object_Kerror_clusterlog_not_enough_space;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTERLOG_RECORD_EXCEEDS_MAXSIZE))
  object_initdata_t _object_Kerror_clusterlog_record_exceeds_maxsize;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_CANT_CREATE_DUP_CLUSTER_NAME))
  object_initdata_t _object_Kerror_cluster_cant_create_dup_cluster_name;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_DATABASE_SEQMISMATCH))
  object_initdata_t _object_Kerror_cluster_database_seqmismatch;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_EVICT_WITHOUT_CLEANUP))
  object_initdata_t _object_Kerror_cluster_evict_without_cleanup;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_GUM_NOT_LOCKER))
  object_initdata_t _object_Kerror_cluster_gum_not_locker;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_INCOMPATIBLE_VERSIONS))
  object_initdata_t _object_Kerror_cluster_incompatible_versions;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_INSTANCE_ID_MISMATCH))
  object_initdata_t _object_Kerror_cluster_instance_id_mismatch;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_INVALID_NETWORK))
  object_initdata_t _object_Kerror_cluster_invalid_network;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_INVALID_NETWORK_PROVIDER))
  object_initdata_t _object_Kerror_cluster_invalid_network_provider;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_INVALID_NODE))
  object_initdata_t _object_Kerror_cluster_invalid_node;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_INVALID_REQUEST))
  object_initdata_t _object_Kerror_cluster_invalid_request;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_IPADDR_IN_USE))
  object_initdata_t _object_Kerror_cluster_ipaddr_in_use;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_JOIN_ABORTED))
  object_initdata_t _object_Kerror_cluster_join_aborted;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_JOIN_IN_PROGRESS))
  object_initdata_t _object_Kerror_cluster_join_in_progress;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_JOIN_NOT_IN_PROGRESS))
  object_initdata_t _object_Kerror_cluster_join_not_in_progress;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_LAST_INTERNAL_NETWORK))
  object_initdata_t _object_Kerror_cluster_last_internal_network;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_LOCAL_NODE_NOT_FOUND))
  object_initdata_t _object_Kerror_cluster_local_node_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_MAXNUM_OF_RESOURCES_EXCEEDED))
  object_initdata_t _object_Kerror_cluster_maxnum_of_resources_exceeded;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_MEMBERSHIP_HALT))
  object_initdata_t _object_Kerror_cluster_membership_halt;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_MEMBERSHIP_INVALID_STATE))
  object_initdata_t _object_Kerror_cluster_membership_invalid_state;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_MISMATCHED_COMPUTER_ACCT_NAME))
  object_initdata_t _object_Kerror_cluster_mismatched_computer_acct_name;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_NETINTERFACE_EXISTS))
  object_initdata_t _object_Kerror_cluster_netinterface_exists;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_NETINTERFACE_NOT_FOUND))
  object_initdata_t _object_Kerror_cluster_netinterface_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_NETWORK_ALREADY_OFFLINE))
  object_initdata_t _object_Kerror_cluster_network_already_offline;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_NETWORK_ALREADY_ONLINE))
  object_initdata_t _object_Kerror_cluster_network_already_online;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_NETWORK_EXISTS))
  object_initdata_t _object_Kerror_cluster_network_exists;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_NETWORK_HAS_DEPENDENTS))
  object_initdata_t _object_Kerror_cluster_network_has_dependents;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_NETWORK_NOT_FOUND))
  object_initdata_t _object_Kerror_cluster_network_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_NETWORK_NOT_FOUND_FOR_IP))
  object_initdata_t _object_Kerror_cluster_network_not_found_for_ip;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_NETWORK_NOT_INTERNAL))
  object_initdata_t _object_Kerror_cluster_network_not_internal;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_NODE_ALREADY_DOWN))
  object_initdata_t _object_Kerror_cluster_node_already_down;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_NODE_ALREADY_HAS_DFS_ROOT))
  object_initdata_t _object_Kerror_cluster_node_already_has_dfs_root;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_NODE_ALREADY_MEMBER))
  object_initdata_t _object_Kerror_cluster_node_already_member;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_NODE_ALREADY_UP))
  object_initdata_t _object_Kerror_cluster_node_already_up;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_NODE_DOWN))
  object_initdata_t _object_Kerror_cluster_node_down;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_NODE_EXISTS))
  object_initdata_t _object_Kerror_cluster_node_exists;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_NODE_NOT_FOUND))
  object_initdata_t _object_Kerror_cluster_node_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_NODE_NOT_MEMBER))
  object_initdata_t _object_Kerror_cluster_node_not_member;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_NODE_NOT_PAUSED))
  object_initdata_t _object_Kerror_cluster_node_not_paused;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_NODE_NOT_READY))
  object_initdata_t _object_Kerror_cluster_node_not_ready;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_NODE_PAUSED))
  object_initdata_t _object_Kerror_cluster_node_paused;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_NODE_SHUTTING_DOWN))
  object_initdata_t _object_Kerror_cluster_node_shutting_down;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_NODE_UNREACHABLE))
  object_initdata_t _object_Kerror_cluster_node_unreachable;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_NODE_UP))
  object_initdata_t _object_Kerror_cluster_node_up;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_NO_RPC_PACKAGES_REGISTERED))
  object_initdata_t _object_Kerror_cluster_no_rpc_packages_registered;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_NO_SECURITY_CONTEXT))
  object_initdata_t _object_Kerror_cluster_no_security_context;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_OLD_VERSION))
  object_initdata_t _object_Kerror_cluster_old_version;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_OWNER_NOT_IN_PREFLIST))
  object_initdata_t _object_Kerror_cluster_owner_not_in_preflist;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_PARAMETER_MISMATCH))
  object_initdata_t _object_Kerror_cluster_parameter_mismatch;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_PROPERTY_DATA_TYPE_MISMATCH))
  object_initdata_t _object_Kerror_cluster_property_data_type_mismatch;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_QUORUMLOG_NOT_FOUND))
  object_initdata_t _object_Kerror_cluster_quorumlog_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_RESNAME_NOT_FOUND))
  object_initdata_t _object_Kerror_cluster_resname_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_RESOURCE_TYPE_NOT_FOUND))
  object_initdata_t _object_Kerror_cluster_resource_type_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_RESTYPE_NOT_SUPPORTED))
  object_initdata_t _object_Kerror_cluster_restype_not_supported;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_SHUTTING_DOWN))
  object_initdata_t _object_Kerror_cluster_shutting_down;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_SYSTEM_CONFIG_CHANGED))
  object_initdata_t _object_Kerror_cluster_system_config_changed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_WRONG_OS_VERSION))
  object_initdata_t _object_Kerror_cluster_wrong_os_version;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_COLORSPACE_MISMATCH))
  object_initdata_t _object_Kerror_colorspace_mismatch;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_COMMITMENT_LIMIT))
  object_initdata_t _object_Kerror_commitment_limit;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CONNECTED_OTHER_PASSWORD))
  object_initdata_t _object_Kerror_connected_other_password;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CONNECTED_OTHER_PASSWORD_DEFAULT))
  object_initdata_t _object_Kerror_connected_other_password_default;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CONNECTION_ABORTED))
  object_initdata_t _object_Kerror_connection_aborted;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CONNECTION_ACTIVE))
  object_initdata_t _object_Kerror_connection_active;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CONNECTION_COUNT_LIMIT))
  object_initdata_t _object_Kerror_connection_count_limit;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CONNECTION_INVALID))
  object_initdata_t _object_Kerror_connection_invalid;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CONNECTION_REFUSED))
  object_initdata_t _object_Kerror_connection_refused;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CONNECTION_UNAVAIL))
  object_initdata_t _object_Kerror_connection_unavail;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CONTEXT_EXPIRED))
  object_initdata_t _object_Kerror_context_expired;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CONTINUE))
  object_initdata_t _object_Kerror_continue;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CONTROLLING_IEPORT))
  object_initdata_t _object_Kerror_controlling_ieport;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CONTROL_ID_NOT_FOUND))
  object_initdata_t _object_Kerror_control_id_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CORE_RESOURCE))
  object_initdata_t _object_Kerror_core_resource;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_COUNTER_TIMEOUT))
  object_initdata_t _object_Kerror_counter_timeout;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CRC))
  object_initdata_t _object_Kerror_crc;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CREATE_FAILED))
  object_initdata_t _object_Kerror_create_failed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CSCSHARE_OFFLINE))
  object_initdata_t _object_Kerror_cscshare_offline;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_BAD_VIDEO_MODE))
  object_initdata_t _object_Kerror_ctx_bad_video_mode;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_CANNOT_MAKE_EVENTLOG_ENTRY))
  object_initdata_t _object_Kerror_ctx_cannot_make_eventlog_entry;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_CLIENT_LICENSE_IN_USE))
  object_initdata_t _object_Kerror_ctx_client_license_in_use;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_CLIENT_LICENSE_NOT_SET))
  object_initdata_t _object_Kerror_ctx_client_license_not_set;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_CLIENT_QUERY_TIMEOUT))
  object_initdata_t _object_Kerror_ctx_client_query_timeout;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_CLOSE_PENDING))
  object_initdata_t _object_Kerror_ctx_close_pending;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_CONSOLE_CONNECT))
  object_initdata_t _object_Kerror_ctx_console_connect;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_CONSOLE_DISCONNECT))
  object_initdata_t _object_Kerror_ctx_console_disconnect;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_GRAPHICS_INVALID))
  object_initdata_t _object_Kerror_ctx_graphics_invalid;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_INVALID_MODEMNAME))
  object_initdata_t _object_Kerror_ctx_invalid_modemname;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_INVALID_PD))
  object_initdata_t _object_Kerror_ctx_invalid_pd;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_INVALID_WD))
  object_initdata_t _object_Kerror_ctx_invalid_wd;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_LICENSE_CLIENT_INVALID))
  object_initdata_t _object_Kerror_ctx_license_client_invalid;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_LICENSE_EXPIRED))
  object_initdata_t _object_Kerror_ctx_license_expired;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_LICENSE_NOT_AVAILABLE))
  object_initdata_t _object_Kerror_ctx_license_not_available;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_LOGON_DISABLED))
  object_initdata_t _object_Kerror_ctx_logon_disabled;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_MODEM_INF_NOT_FOUND))
  object_initdata_t _object_Kerror_ctx_modem_inf_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_MODEM_RESPONSE_BUSY))
  object_initdata_t _object_Kerror_ctx_modem_response_busy;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_MODEM_RESPONSE_ERROR))
  object_initdata_t _object_Kerror_ctx_modem_response_error;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_MODEM_RESPONSE_NO_CARRIER))
  object_initdata_t _object_Kerror_ctx_modem_response_no_carrier;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_MODEM_RESPONSE_NO_DIALTONE))
  object_initdata_t _object_Kerror_ctx_modem_response_no_dialtone;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_MODEM_RESPONSE_TIMEOUT))
  object_initdata_t _object_Kerror_ctx_modem_response_timeout;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_MODEM_RESPONSE_VOICE))
  object_initdata_t _object_Kerror_ctx_modem_response_voice;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_NOT_CONSOLE))
  object_initdata_t _object_Kerror_ctx_not_console;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_NO_OUTBUF))
  object_initdata_t _object_Kerror_ctx_no_outbuf;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_PD_NOT_FOUND))
  object_initdata_t _object_Kerror_ctx_pd_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_SERVICE_NAME_COLLISION))
  object_initdata_t _object_Kerror_ctx_service_name_collision;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_SHADOW_DENIED))
  object_initdata_t _object_Kerror_ctx_shadow_denied;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_SHADOW_DISABLED))
  object_initdata_t _object_Kerror_ctx_shadow_disabled;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_SHADOW_ENDED_BY_MODE_CHANGE))
  object_initdata_t _object_Kerror_ctx_shadow_ended_by_mode_change;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_SHADOW_INVALID))
  object_initdata_t _object_Kerror_ctx_shadow_invalid;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_SHADOW_NOT_RUNNING))
  object_initdata_t _object_Kerror_ctx_shadow_not_running;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_TD_ERROR))
  object_initdata_t _object_Kerror_ctx_td_error;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_WD_NOT_FOUND))
  object_initdata_t _object_Kerror_ctx_wd_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_WINSTATION_ACCESS_DENIED))
  object_initdata_t _object_Kerror_ctx_winstation_access_denied;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_WINSTATION_ALREADY_EXISTS))
  object_initdata_t _object_Kerror_ctx_winstation_already_exists;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_WINSTATION_BUSY))
  object_initdata_t _object_Kerror_ctx_winstation_busy;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_WINSTATION_NAME_INVALID))
  object_initdata_t _object_Kerror_ctx_winstation_name_invalid;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_WINSTATION_NOT_FOUND))
  object_initdata_t _object_Kerror_ctx_winstation_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CURRENT_DIRECTORY))
  object_initdata_t _object_Kerror_current_directory;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CURRENT_DOMAIN_NOT_ALLOWED))
  object_initdata_t _object_Kerror_current_domain_not_allowed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DATABASE_BACKUP_CORRUPT))
  object_initdata_t _object_Kerror_database_backup_corrupt;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DATABASE_DOES_NOT_EXIST))
  object_initdata_t _object_Kerror_database_does_not_exist;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DATABASE_FAILURE))
  object_initdata_t _object_Kerror_database_failure;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DATABASE_FULL))
  object_initdata_t _object_Kerror_database_full;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DATATYPE_MISMATCH))
  object_initdata_t _object_Kerror_datatype_mismatch;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DC_NOT_FOUND))
  object_initdata_t _object_Kerror_dc_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DDE_FAIL))
  object_initdata_t _object_Kerror_dde_fail;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DEBUGGER_INACTIVE))
  object_initdata_t _object_Kerror_debugger_inactive;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DECRYPTION_FAILED))
  object_initdata_t _object_Kerror_decryption_failed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DELETE_PENDING))
  object_initdata_t _object_Kerror_delete_pending;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DELETING_ICM_XFORM))
  object_initdata_t _object_Kerror_deleting_icm_xform;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DEPENDENCY_ALREADY_EXISTS))
  object_initdata_t _object_Kerror_dependency_already_exists;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DEPENDENCY_NOT_ALLOWED))
  object_initdata_t _object_Kerror_dependency_not_allowed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DEPENDENCY_NOT_FOUND))
  object_initdata_t _object_Kerror_dependency_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DEPENDENT_RESOURCE_EXISTS))
  object_initdata_t _object_Kerror_dependent_resource_exists;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DEPENDENT_SERVICES_RUNNING))
  object_initdata_t _object_Kerror_dependent_services_running;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DESTINATION_ELEMENT_FULL))
  object_initdata_t _object_Kerror_destination_element_full;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DESTROY_OBJECT_OF_OTHER_THREAD))
  object_initdata_t _object_Kerror_destroy_object_of_other_thread;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DEVICE_ALREADY_REMEMBERED))
  object_initdata_t _object_Kerror_device_already_remembered;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DEVICE_DOOR_OPEN))
  object_initdata_t _object_Kerror_device_door_open;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DEVICE_IN_USE))
  object_initdata_t _object_Kerror_device_in_use;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DEVICE_NOT_AVAILABLE))
  object_initdata_t _object_Kerror_device_not_available;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DEVICE_NOT_CONNECTED))
  object_initdata_t _object_Kerror_device_not_connected;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DEVICE_NOT_PARTITIONED))
  object_initdata_t _object_Kerror_device_not_partitioned;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DEVICE_REINITIALIZATION_NEEDED))
  object_initdata_t _object_Kerror_device_reinitialization_needed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DEVICE_REMOVED))
  object_initdata_t _object_Kerror_device_removed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DEVICE_REQUIRES_CLEANING))
  object_initdata_t _object_Kerror_device_requires_cleaning;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DEV_NOT_EXIST))
  object_initdata_t _object_Kerror_dev_not_exist;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DHCP_ADDRESS_CONFLICT))
  object_initdata_t _object_Kerror_dhcp_address_conflict;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DIFFERENT_SERVICE_ACCOUNT))
  object_initdata_t _object_Kerror_different_service_account;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DIRECTORY))
  object_initdata_t _object_Kerror_directory;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DIRECT_ACCESS_HANDLE))
  object_initdata_t _object_Kerror_direct_access_handle;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DIR_EFS_DISALLOWED))
  object_initdata_t _object_Kerror_dir_efs_disallowed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DIR_NOT_EMPTY))
  object_initdata_t _object_Kerror_dir_not_empty;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DIR_NOT_ROOT))
  object_initdata_t _object_Kerror_dir_not_root;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DISCARDED))
  object_initdata_t _object_Kerror_discarded;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DISK_CHANGE))
  object_initdata_t _object_Kerror_disk_change;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DISK_CORRUPT))
  object_initdata_t _object_Kerror_disk_corrupt;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DISK_FULL))
  object_initdata_t _object_Kerror_disk_full;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DISK_OPERATION_FAILED))
  object_initdata_t _object_Kerror_disk_operation_failed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DISK_RECALIBRATE_FAILED))
  object_initdata_t _object_Kerror_disk_recalibrate_failed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DISK_RESET_FAILED))
  object_initdata_t _object_Kerror_disk_reset_failed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DISK_TOO_FRAGMENTED))
  object_initdata_t _object_Kerror_disk_too_fragmented;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DLL_INIT_FAILED))
  object_initdata_t _object_Kerror_dll_init_failed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DLL_NOT_FOUND))
  object_initdata_t _object_Kerror_dll_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DOMAIN_CONTROLLER_EXISTS))
  object_initdata_t _object_Kerror_domain_controller_exists;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DOMAIN_CONTROLLER_NOT_FOUND))
  object_initdata_t _object_Kerror_domain_controller_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DOMAIN_EXISTS))
  object_initdata_t _object_Kerror_domain_exists;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DOMAIN_LIMIT_EXCEEDED))
  object_initdata_t _object_Kerror_domain_limit_exceeded;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DOMAIN_TRUST_INCONSISTENT))
  object_initdata_t _object_Kerror_domain_trust_inconsistent;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DOWNGRADE_DETECTED))
  object_initdata_t _object_Kerror_downgrade_detected;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DRIVER_BLOCKED))
  object_initdata_t _object_Kerror_driver_blocked;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DRIVE_LOCKED))
  object_initdata_t _object_Kerror_drive_locked;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DRIVE_MEDIA_MISMATCH))
  object_initdata_t _object_Kerror_drive_media_mismatch;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_ADD_REPLICA_INHIBITED))
  object_initdata_t _object_Kerror_ds_add_replica_inhibited;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_ADMIN_LIMIT_EXCEEDED))
  object_initdata_t _object_Kerror_ds_admin_limit_exceeded;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_AFFECTS_MULTIPLE_DSAS))
  object_initdata_t _object_Kerror_ds_affects_multiple_dsas;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_AG_CANT_HAVE_UNIVERSAL_MEMBER))
  object_initdata_t _object_Kerror_ds_ag_cant_have_universal_member;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_ALIASED_OBJ_MISSING))
  object_initdata_t _object_Kerror_ds_aliased_obj_missing;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_ALIAS_DEREF_PROBLEM))
  object_initdata_t _object_Kerror_ds_alias_deref_problem;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_ALIAS_POINTS_TO_ALIAS))
  object_initdata_t _object_Kerror_ds_alias_points_to_alias;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_ALIAS_PROBLEM))
  object_initdata_t _object_Kerror_ds_alias_problem;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_ATTRIBUTE_OR_VALUE_EXISTS))
  object_initdata_t _object_Kerror_ds_attribute_or_value_exists;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_ATTRIBUTE_OWNED_BY_SAM))
  object_initdata_t _object_Kerror_ds_attribute_owned_by_sam;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_ATTRIBUTE_TYPE_UNDEFINED))
  object_initdata_t _object_Kerror_ds_attribute_type_undefined;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_ATT_ALREADY_EXISTS))
  object_initdata_t _object_Kerror_ds_att_already_exists;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_ATT_IS_NOT_ON_OBJ))
  object_initdata_t _object_Kerror_ds_att_is_not_on_obj;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_ATT_NOT_DEF_FOR_CLASS))
  object_initdata_t _object_Kerror_ds_att_not_def_for_class;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_ATT_NOT_DEF_IN_SCHEMA))
  object_initdata_t _object_Kerror_ds_att_not_def_in_schema;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_ATT_SCHEMA_REQ_ID))
  object_initdata_t _object_Kerror_ds_att_schema_req_id;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_ATT_SCHEMA_REQ_SYNTAX))
  object_initdata_t _object_Kerror_ds_att_schema_req_syntax;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_ATT_VAL_ALREADY_EXISTS))
  object_initdata_t _object_Kerror_ds_att_val_already_exists;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_AUTHORIZATION_FAILED))
  object_initdata_t _object_Kerror_ds_authorization_failed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_AUTH_METHOD_NOT_SUPPORTED))
  object_initdata_t _object_Kerror_ds_auth_method_not_supported;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_AUTH_UNKNOWN))
  object_initdata_t _object_Kerror_ds_auth_unknown;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_AUX_CLS_TEST_FAIL))
  object_initdata_t _object_Kerror_ds_aux_cls_test_fail;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_BACKLINK_WITHOUT_LINK))
  object_initdata_t _object_Kerror_ds_backlink_without_link;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_BAD_ATT_SCHEMA_SYNTAX))
  object_initdata_t _object_Kerror_ds_bad_att_schema_syntax;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_BAD_HIERARCHY_FILE))
  object_initdata_t _object_Kerror_ds_bad_hierarchy_file;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_BAD_INSTANCE_TYPE))
  object_initdata_t _object_Kerror_ds_bad_instance_type;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_BAD_NAME_SYNTAX))
  object_initdata_t _object_Kerror_ds_bad_name_syntax;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_BAD_RDN_ATT_ID_SYNTAX))
  object_initdata_t _object_Kerror_ds_bad_rdn_att_id_syntax;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_BUILD_HIERARCHY_TABLE_FAILED))
  object_initdata_t _object_Kerror_ds_build_hierarchy_table_failed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_BUSY))
  object_initdata_t _object_Kerror_ds_busy;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_ACCESS_REMOTE_PART_OF_AD))
  object_initdata_t _object_Kerror_ds_cant_access_remote_part_of_ad;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_ADD_ATT_VALUES))
  object_initdata_t _object_Kerror_ds_cant_add_att_values;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_ADD_SYSTEM_ONLY))
  object_initdata_t _object_Kerror_ds_cant_add_system_only;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_ADD_TO_GC))
  object_initdata_t _object_Kerror_ds_cant_add_to_gc;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_CACHE_ATT))
  object_initdata_t _object_Kerror_ds_cant_cache_att;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_CACHE_CLASS))
  object_initdata_t _object_Kerror_ds_cant_cache_class;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_CREATE_IN_NONDOMAIN_NC))
  object_initdata_t _object_Kerror_ds_cant_create_in_nondomain_nc;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_CREATE_UNDER_SCHEMA))
  object_initdata_t _object_Kerror_ds_cant_create_under_schema;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_DELETE))
  object_initdata_t _object_Kerror_ds_cant_delete;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_DELETE_DSA_OBJ))
  object_initdata_t _object_Kerror_ds_cant_delete_dsa_obj;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_DEL_MASTER_CROSSREF))
  object_initdata_t _object_Kerror_ds_cant_del_master_crossref;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_DEMOTE_WITH_WRITEABLE_NC))
  object_initdata_t _object_Kerror_ds_cant_demote_with_writeable_nc;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_DEREF_ALIAS))
  object_initdata_t _object_Kerror_ds_cant_deref_alias;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_DERIVE_SPN_FOR_DELETED_DOMAIN))
  object_initdata_t _object_Kerror_ds_cant_derive_spn_for_deleted_domain;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_DERIVE_SPN_WITHOUT_SERVER_REF))
  object_initdata_t _object_Kerror_ds_cant_derive_spn_without_server_ref;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_FIND_DC_FOR_SRC_DOMAIN))
  object_initdata_t _object_Kerror_ds_cant_find_dc_for_src_domain;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_FIND_DSA_OBJ))
  object_initdata_t _object_Kerror_ds_cant_find_dsa_obj;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_FIND_EXPECTED_NC))
  object_initdata_t _object_Kerror_ds_cant_find_expected_nc;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_FIND_NC_IN_CACHE))
  object_initdata_t _object_Kerror_ds_cant_find_nc_in_cache;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_MIX_MASTER_AND_REPS))
  object_initdata_t _object_Kerror_ds_cant_mix_master_and_reps;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_MOD_OBJ_CLASS))
  object_initdata_t _object_Kerror_ds_cant_mod_obj_class;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_MOD_PRIMARYGROUPID))
  object_initdata_t _object_Kerror_ds_cant_mod_primarygroupid;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_MOD_SYSTEM_ONLY))
  object_initdata_t _object_Kerror_ds_cant_mod_system_only;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_MOVE_ACCOUNT_GROUP))
  object_initdata_t _object_Kerror_ds_cant_move_account_group;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_MOVE_APP_BASIC_GROUP))
  object_initdata_t _object_Kerror_ds_cant_move_app_basic_group;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_MOVE_APP_QUERY_GROUP))
  object_initdata_t _object_Kerror_ds_cant_move_app_query_group;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_MOVE_DELETED_OBJECT))
  object_initdata_t _object_Kerror_ds_cant_move_deleted_object;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_MOVE_RESOURCE_GROUP))
  object_initdata_t _object_Kerror_ds_cant_move_resource_group;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_ON_NON_LEAF))
  object_initdata_t _object_Kerror_ds_cant_on_non_leaf;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_ON_RDN))
  object_initdata_t _object_Kerror_ds_cant_on_rdn;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_REMOVE_ATT_CACHE))
  object_initdata_t _object_Kerror_ds_cant_remove_att_cache;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_REMOVE_CLASS_CACHE))
  object_initdata_t _object_Kerror_ds_cant_remove_class_cache;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_REM_MISSING_ATT))
  object_initdata_t _object_Kerror_ds_cant_rem_missing_att;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_REM_MISSING_ATT_VAL))
  object_initdata_t _object_Kerror_ds_cant_rem_missing_att_val;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_REPLACE_HIDDEN_REC))
  object_initdata_t _object_Kerror_ds_cant_replace_hidden_rec;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_RETRIEVE_ATTS))
  object_initdata_t _object_Kerror_ds_cant_retrieve_atts;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_RETRIEVE_CHILD))
  object_initdata_t _object_Kerror_ds_cant_retrieve_child;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_RETRIEVE_DN))
  object_initdata_t _object_Kerror_ds_cant_retrieve_dn;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_RETRIEVE_INSTANCE))
  object_initdata_t _object_Kerror_ds_cant_retrieve_instance;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_RETRIEVE_SD))
  object_initdata_t _object_Kerror_ds_cant_retrieve_sd;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_START))
  object_initdata_t _object_Kerror_ds_cant_start;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_TREE_DELETE_CRITICAL_OBJ))
  object_initdata_t _object_Kerror_ds_cant_tree_delete_critical_obj;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_WITH_ACCT_GROUP_MEMBERSHPS))
  object_initdata_t _object_Kerror_ds_cant_with_acct_group_membershps;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CHILDREN_EXIST))
  object_initdata_t _object_Kerror_ds_children_exist;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CLASS_MUST_BE_CONCRETE))
  object_initdata_t _object_Kerror_ds_class_must_be_concrete;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CLASS_NOT_DSA))
  object_initdata_t _object_Kerror_ds_class_not_dsa;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CLIENT_LOOP))
  object_initdata_t _object_Kerror_ds_client_loop;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CODE_INCONSISTENCY))
  object_initdata_t _object_Kerror_ds_code_inconsistency;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_COMPARE_FALSE))
  object_initdata_t _object_Kerror_ds_compare_false;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_COMPARE_TRUE))
  object_initdata_t _object_Kerror_ds_compare_true;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CONFIDENTIALITY_REQUIRED))
  object_initdata_t _object_Kerror_ds_confidentiality_required;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CONFIG_PARAM_MISSING))
  object_initdata_t _object_Kerror_ds_config_param_missing;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CONSTRAINT_VIOLATION))
  object_initdata_t _object_Kerror_ds_constraint_violation;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CONSTRUCTED_ATT_MOD))
  object_initdata_t _object_Kerror_ds_constructed_att_mod;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CONTROL_NOT_FOUND))
  object_initdata_t _object_Kerror_ds_control_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_COULDNT_CONTACT_FSMO))
  object_initdata_t _object_Kerror_ds_couldnt_contact_fsmo;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_COULDNT_IDENTIFY_OBJECTS_FOR_TREE_DELETE))
  object_initdata_t _object_Kerror_ds_couldnt_identify_objects_for_tree_delete;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_COULDNT_LOCK_TREE_FOR_DELETE))
  object_initdata_t _object_Kerror_ds_couldnt_lock_tree_for_delete;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_COULDNT_UPDATE_SPNS))
  object_initdata_t _object_Kerror_ds_couldnt_update_spns;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_COUNTING_AB_INDICES_FAILED))
  object_initdata_t _object_Kerror_ds_counting_ab_indices_failed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CROSS_DOMAIN_CLEANUP_REQD))
  object_initdata_t _object_Kerror_ds_cross_domain_cleanup_reqd;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CROSS_DOM_MOVE_ERROR))
  object_initdata_t _object_Kerror_ds_cross_dom_move_error;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CROSS_NC_DN_RENAME))
  object_initdata_t _object_Kerror_ds_cross_nc_dn_rename;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CROSS_REF_BUSY))
  object_initdata_t _object_Kerror_ds_cross_ref_busy;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CROSS_REF_EXISTS))
  object_initdata_t _object_Kerror_ds_cross_ref_exists;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CR_IMPOSSIBLE_TO_VALIDATE))
  object_initdata_t _object_Kerror_ds_cr_impossible_to_validate;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CR_IMPOSSIBLE_TO_VALIDATE_V2))
  object_initdata_t _object_Kerror_ds_cr_impossible_to_validate_v2;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DATABASE_ERROR))
  object_initdata_t _object_Kerror_ds_database_error;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DECODING_ERROR))
  object_initdata_t _object_Kerror_ds_decoding_error;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DESTINATION_AUDITING_NOT_ENABLED))
  object_initdata_t _object_Kerror_ds_destination_auditing_not_enabled;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DESTINATION_DOMAIN_NOT_IN_FOREST))
  object_initdata_t _object_Kerror_ds_destination_domain_not_in_forest;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DIFFERENT_REPL_EPOCHS))
  object_initdata_t _object_Kerror_ds_different_repl_epochs;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DOMAIN_RENAME_IN_PROGRESS))
  object_initdata_t _object_Kerror_ds_domain_rename_in_progress;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DOMAIN_VERSION_TOO_HIGH))
  object_initdata_t _object_Kerror_ds_domain_version_too_high;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DOMAIN_VERSION_TOO_LOW))
  object_initdata_t _object_Kerror_ds_domain_version_too_low;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_ABANDON_SYNC))
  object_initdata_t _object_Kerror_ds_dra_abandon_sync;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_ACCESS_DENIED))
  object_initdata_t _object_Kerror_ds_dra_access_denied;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_BAD_DN))
  object_initdata_t _object_Kerror_ds_dra_bad_dn;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_BAD_INSTANCE_TYPE))
  object_initdata_t _object_Kerror_ds_dra_bad_instance_type;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_BAD_NC))
  object_initdata_t _object_Kerror_ds_dra_bad_nc;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_BUSY))
  object_initdata_t _object_Kerror_ds_dra_busy;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_CONNECTION_FAILED))
  object_initdata_t _object_Kerror_ds_dra_connection_failed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_DB_ERROR))
  object_initdata_t _object_Kerror_ds_dra_db_error;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_DN_EXISTS))
  object_initdata_t _object_Kerror_ds_dra_dn_exists;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_EARLIER_SCHEMA_CONLICT))
  object_initdata_t _object_Kerror_ds_dra_earlier_schema_conlict;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_EXTN_CONNECTION_FAILED))
  object_initdata_t _object_Kerror_ds_dra_extn_connection_failed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_GENERIC))
  object_initdata_t _object_Kerror_ds_dra_generic;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_INCOMPATIBLE_PARTIAL_SET))
  object_initdata_t _object_Kerror_ds_dra_incompatible_partial_set;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_INCONSISTENT_DIT))
  object_initdata_t _object_Kerror_ds_dra_inconsistent_dit;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_INTERNAL_ERROR))
  object_initdata_t _object_Kerror_ds_dra_internal_error;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_INVALID_PARAMETER))
  object_initdata_t _object_Kerror_ds_dra_invalid_parameter;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_MAIL_PROBLEM))
  object_initdata_t _object_Kerror_ds_dra_mail_problem;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_MISSING_PARENT))
  object_initdata_t _object_Kerror_ds_dra_missing_parent;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_NAME_COLLISION))
  object_initdata_t _object_Kerror_ds_dra_name_collision;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_NOT_SUPPORTED))
  object_initdata_t _object_Kerror_ds_dra_not_supported;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_NO_REPLICA))
  object_initdata_t _object_Kerror_ds_dra_no_replica;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_OBJ_IS_REP_SOURCE))
  object_initdata_t _object_Kerror_ds_dra_obj_is_rep_source;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_OBJ_NC_MISMATCH))
  object_initdata_t _object_Kerror_ds_dra_obj_nc_mismatch;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_OUT_OF_MEM))
  object_initdata_t _object_Kerror_ds_dra_out_of_mem;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_PREEMPTED))
  object_initdata_t _object_Kerror_ds_dra_preempted;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_REF_ALREADY_EXISTS))
  object_initdata_t _object_Kerror_ds_dra_ref_already_exists;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_REF_NOT_FOUND))
  object_initdata_t _object_Kerror_ds_dra_ref_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_REPL_PENDING))
  object_initdata_t _object_Kerror_ds_dra_repl_pending;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_RPC_CANCELLED))
  object_initdata_t _object_Kerror_ds_dra_rpc_cancelled;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_SCHEMA_CONFLICT))
  object_initdata_t _object_Kerror_ds_dra_schema_conflict;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_SCHEMA_INFO_SHIP))
  object_initdata_t _object_Kerror_ds_dra_schema_info_ship;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_SCHEMA_MISMATCH))
  object_initdata_t _object_Kerror_ds_dra_schema_mismatch;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_SHUTDOWN))
  object_initdata_t _object_Kerror_ds_dra_shutdown;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_SINK_DISABLED))
  object_initdata_t _object_Kerror_ds_dra_sink_disabled;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_SOURCE_DISABLED))
  object_initdata_t _object_Kerror_ds_dra_source_disabled;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_SOURCE_IS_PARTIAL_REPLICA))
  object_initdata_t _object_Kerror_ds_dra_source_is_partial_replica;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_SOURCE_REINSTALLED))
  object_initdata_t _object_Kerror_ds_dra_source_reinstalled;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRS_EXTENSIONS_CHANGED))
  object_initdata_t _object_Kerror_ds_drs_extensions_changed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DSA_MUST_BE_INT_MASTER))
  object_initdata_t _object_Kerror_ds_dsa_must_be_int_master;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DST_DOMAIN_NOT_NATIVE))
  object_initdata_t _object_Kerror_ds_dst_domain_not_native;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DST_NC_MISMATCH))
  object_initdata_t _object_Kerror_ds_dst_nc_mismatch;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DS_REQUIRED))
  object_initdata_t _object_Kerror_ds_ds_required;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DUPLICATE_ID_FOUND))
  object_initdata_t _object_Kerror_ds_duplicate_id_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DUP_LDAP_DISPLAY_NAME))
  object_initdata_t _object_Kerror_ds_dup_ldap_display_name;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DUP_LINK_ID))
  object_initdata_t _object_Kerror_ds_dup_link_id;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DUP_MAPI_ID))
  object_initdata_t _object_Kerror_ds_dup_mapi_id;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DUP_MSDS_INTID))
  object_initdata_t _object_Kerror_ds_dup_msds_intid;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DUP_OID))
  object_initdata_t _object_Kerror_ds_dup_oid;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DUP_RDN))
  object_initdata_t _object_Kerror_ds_dup_rdn;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DUP_SCHEMA_ID_GUID))
  object_initdata_t _object_Kerror_ds_dup_schema_id_guid;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_ENCODING_ERROR))
  object_initdata_t _object_Kerror_ds_encoding_error;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_EPOCH_MISMATCH))
  object_initdata_t _object_Kerror_ds_epoch_mismatch;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_EXISTING_AD_CHILD_NC))
  object_initdata_t _object_Kerror_ds_existing_ad_child_nc;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_EXISTS_IN_AUX_CLS))
  object_initdata_t _object_Kerror_ds_exists_in_aux_cls;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_EXISTS_IN_MAY_HAVE))
  object_initdata_t _object_Kerror_ds_exists_in_may_have;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_EXISTS_IN_MUST_HAVE))
  object_initdata_t _object_Kerror_ds_exists_in_must_have;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_EXISTS_IN_POSS_SUP))
  object_initdata_t _object_Kerror_ds_exists_in_poss_sup;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_EXISTS_IN_RDNATTID))
  object_initdata_t _object_Kerror_ds_exists_in_rdnattid;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_EXISTS_IN_SUB_CLS))
  object_initdata_t _object_Kerror_ds_exists_in_sub_cls;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_FILTER_UNKNOWN))
  object_initdata_t _object_Kerror_ds_filter_unknown;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_FILTER_USES_CONTRUCTED_ATTRS))
  object_initdata_t _object_Kerror_ds_filter_uses_contructed_attrs;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_FOREST_VERSION_TOO_HIGH))
  object_initdata_t _object_Kerror_ds_forest_version_too_high;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_FOREST_VERSION_TOO_LOW))
  object_initdata_t _object_Kerror_ds_forest_version_too_low;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_GCVERIFY_ERROR))
  object_initdata_t _object_Kerror_ds_gcverify_error;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_GC_NOT_AVAILABLE))
  object_initdata_t _object_Kerror_ds_gc_not_available;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_GC_REQUIRED))
  object_initdata_t _object_Kerror_ds_gc_required;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_GENERIC_ERROR))
  object_initdata_t _object_Kerror_ds_generic_error;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_GLOBAL_CANT_HAVE_CROSSDOMAIN_MEMBER))
  object_initdata_t _object_Kerror_ds_global_cant_have_crossdomain_member;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_GLOBAL_CANT_HAVE_LOCAL_MEMBER))
  object_initdata_t _object_Kerror_ds_global_cant_have_local_member;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_GLOBAL_CANT_HAVE_UNIVERSAL_MEMBER))
  object_initdata_t _object_Kerror_ds_global_cant_have_universal_member;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_GOVERNSID_MISSING))
  object_initdata_t _object_Kerror_ds_governsid_missing;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_GROUP_CONVERSION_ERROR))
  object_initdata_t _object_Kerror_ds_group_conversion_error;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_HAVE_PRIMARY_MEMBERS))
  object_initdata_t _object_Kerror_ds_have_primary_members;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_HIERARCHY_TABLE_MALLOC_FAILED))
  object_initdata_t _object_Kerror_ds_hierarchy_table_malloc_failed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_ILLEGAL_BASE_SCHEMA_MOD))
  object_initdata_t _object_Kerror_ds_illegal_base_schema_mod;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_ILLEGAL_MOD_OPERATION))
  object_initdata_t _object_Kerror_ds_illegal_mod_operation;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_ILLEGAL_SUPERIOR))
  object_initdata_t _object_Kerror_ds_illegal_superior;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_ILLEGAL_XDOM_MOVE_OPERATION))
  object_initdata_t _object_Kerror_ds_illegal_xdom_move_operation;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_INAPPROPRIATE_AUTH))
  object_initdata_t _object_Kerror_ds_inappropriate_auth;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_INAPPROPRIATE_MATCHING))
  object_initdata_t _object_Kerror_ds_inappropriate_matching;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_INCOMPATIBLE_CONTROLS_USED))
  object_initdata_t _object_Kerror_ds_incompatible_controls_used;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_INCOMPATIBLE_VERSION))
  object_initdata_t _object_Kerror_ds_incompatible_version;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_INCORRECT_ROLE_OWNER))
  object_initdata_t _object_Kerror_ds_incorrect_role_owner;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_INIT_FAILURE))
  object_initdata_t _object_Kerror_ds_init_failure;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_INIT_FAILURE_CONSOLE))
  object_initdata_t _object_Kerror_ds_init_failure_console;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_INSTALL_NO_SCH_VERSION_IN_INIFILE))
  object_initdata_t _object_Kerror_ds_install_no_sch_version_in_inifile;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_INSTALL_NO_SRC_SCH_VERSION))
  object_initdata_t _object_Kerror_ds_install_no_src_sch_version;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_INSTALL_SCHEMA_MISMATCH))
  object_initdata_t _object_Kerror_ds_install_schema_mismatch;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_INSUFFICIENT_ATTR_TO_CREATE_OBJECT))
  object_initdata_t _object_Kerror_ds_insufficient_attr_to_create_object;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_INSUFF_ACCESS_RIGHTS))
  object_initdata_t _object_Kerror_ds_insuff_access_rights;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_INTERNAL_FAILURE))
  object_initdata_t _object_Kerror_ds_internal_failure;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_INVALID_ATTRIBUTE_SYNTAX))
  object_initdata_t _object_Kerror_ds_invalid_attribute_syntax;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_INVALID_DMD))
  object_initdata_t _object_Kerror_ds_invalid_dmd;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_INVALID_DN_SYNTAX))
  object_initdata_t _object_Kerror_ds_invalid_dn_syntax;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_INVALID_GROUP_TYPE))
  object_initdata_t _object_Kerror_ds_invalid_group_type;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_INVALID_LDAP_DISPLAY_NAME))
  object_initdata_t _object_Kerror_ds_invalid_ldap_display_name;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_INVALID_NAME_FOR_SPN))
  object_initdata_t _object_Kerror_ds_invalid_name_for_spn;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_INVALID_ROLE_OWNER))
  object_initdata_t _object_Kerror_ds_invalid_role_owner;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_INVALID_SCRIPT))
  object_initdata_t _object_Kerror_ds_invalid_script;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_INVALID_SEARCH_FLAG))
  object_initdata_t _object_Kerror_ds_invalid_search_flag;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_IS_LEAF))
  object_initdata_t _object_Kerror_ds_is_leaf;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_KEY_NOT_UNIQUE))
  object_initdata_t _object_Kerror_ds_key_not_unique;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_LINK_ID_NOT_AVAILABLE))
  object_initdata_t _object_Kerror_ds_link_id_not_available;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_LOCAL_CANT_HAVE_CROSSDOMAIN_LOCAL_MEMBER))
  object_initdata_t _object_Kerror_ds_local_cant_have_crossdomain_local_member;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_LOCAL_ERROR))
  object_initdata_t _object_Kerror_ds_local_error;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_LOCAL_MEMBER_OF_LOCAL_ONLY))
  object_initdata_t _object_Kerror_ds_local_member_of_local_only;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_LOOKUP_FAILURE))
  object_initdata_t _object_Kerror_ds_lookup_failure;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_LOOP_DETECT))
  object_initdata_t _object_Kerror_ds_loop_detect;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_LOW_DSA_VERSION))
  object_initdata_t _object_Kerror_ds_low_dsa_version;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_MACHINE_ACCOUNT_CREATED_PRENT4))
  object_initdata_t _object_Kerror_ds_machine_account_created_prent4;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_MACHINE_ACCOUNT_QUOTA_EXCEEDED))
  object_initdata_t _object_Kerror_ds_machine_account_quota_exceeded;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_MASTERDSA_REQUIRED))
  object_initdata_t _object_Kerror_ds_masterdsa_required;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_MAX_OBJ_SIZE_EXCEEDED))
  object_initdata_t _object_Kerror_ds_max_obj_size_exceeded;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_MEMBERSHIP_EVALUATED_LOCALLY))
  object_initdata_t _object_Kerror_ds_membership_evaluated_locally;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_MISSING_EXPECTED_ATT))
  object_initdata_t _object_Kerror_ds_missing_expected_att;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_MISSING_FSMO_SETTINGS))
  object_initdata_t _object_Kerror_ds_missing_fsmo_settings;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_MISSING_INFRASTRUCTURE_CONTAINER))
  object_initdata_t _object_Kerror_ds_missing_infrastructure_container;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_MISSING_REQUIRED_ATT))
  object_initdata_t _object_Kerror_ds_missing_required_att;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_MISSING_SUPREF))
  object_initdata_t _object_Kerror_ds_missing_supref;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_MODIFYDN_DISALLOWED_BY_FLAG))
  object_initdata_t _object_Kerror_ds_modifydn_disallowed_by_flag;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_MODIFYDN_DISALLOWED_BY_INSTANCE_TYPE))
  object_initdata_t _object_Kerror_ds_modifydn_disallowed_by_instance_type;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_MODIFYDN_WRONG_GRANDPARENT))
  object_initdata_t _object_Kerror_ds_modifydn_wrong_grandparent;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_MUST_BE_RUN_ON_DST_DC))
  object_initdata_t _object_Kerror_ds_must_be_run_on_dst_dc;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NAME_ERROR_DOMAIN_ONLY))
  object_initdata_t _object_Kerror_ds_name_error_domain_only;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NAME_ERROR_NOT_FOUND))
  object_initdata_t _object_Kerror_ds_name_error_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NAME_ERROR_NOT_UNIQUE))
  object_initdata_t _object_Kerror_ds_name_error_not_unique;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NAME_ERROR_NO_MAPPING))
  object_initdata_t _object_Kerror_ds_name_error_no_mapping;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NAME_ERROR_NO_SYNTACTICAL_MAPPING))
  object_initdata_t _object_Kerror_ds_name_error_no_syntactical_mapping;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NAME_ERROR_RESOLVING))
  object_initdata_t _object_Kerror_ds_name_error_resolving;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NAME_ERROR_TRUST_REFERRAL))
  object_initdata_t _object_Kerror_ds_name_error_trust_referral;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NAME_NOT_UNIQUE))
  object_initdata_t _object_Kerror_ds_name_not_unique;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NAME_REFERENCE_INVALID))
  object_initdata_t _object_Kerror_ds_name_reference_invalid;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NAME_TOO_LONG))
  object_initdata_t _object_Kerror_ds_name_too_long;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NAME_TOO_MANY_PARTS))
  object_initdata_t _object_Kerror_ds_name_too_many_parts;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NAME_TYPE_UNKNOWN))
  object_initdata_t _object_Kerror_ds_name_type_unknown;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NAME_UNPARSEABLE))
  object_initdata_t _object_Kerror_ds_name_unparseable;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NAME_VALUE_TOO_LONG))
  object_initdata_t _object_Kerror_ds_name_value_too_long;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NAMING_MASTER_GC))
  object_initdata_t _object_Kerror_ds_naming_master_gc;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NAMING_VIOLATION))
  object_initdata_t _object_Kerror_ds_naming_violation;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NCNAME_MISSING_CR_REF))
  object_initdata_t _object_Kerror_ds_ncname_missing_cr_ref;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NCNAME_MUST_BE_NC))
  object_initdata_t _object_Kerror_ds_ncname_must_be_nc;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NC_MUST_HAVE_NC_PARENT))
  object_initdata_t _object_Kerror_ds_nc_must_have_nc_parent;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NC_STILL_HAS_DSAS))
  object_initdata_t _object_Kerror_ds_nc_still_has_dsas;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NONEXISTENT_MAY_HAVE))
  object_initdata_t _object_Kerror_ds_nonexistent_may_have;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NONEXISTENT_MUST_HAVE))
  object_initdata_t _object_Kerror_ds_nonexistent_must_have;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NONEXISTENT_POSS_SUP))
  object_initdata_t _object_Kerror_ds_nonexistent_poss_sup;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NONSAFE_SCHEMA_CHANGE))
  object_initdata_t _object_Kerror_ds_nonsafe_schema_change;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NON_BASE_SEARCH))
  object_initdata_t _object_Kerror_ds_non_base_search;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NOTIFY_FILTER_TOO_COMPLEX))
  object_initdata_t _object_Kerror_ds_notify_filter_too_complex;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NOT_AN_OBJECT))
  object_initdata_t _object_Kerror_ds_not_an_object;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NOT_AUTHORITIVE_FOR_DST_NC))
  object_initdata_t _object_Kerror_ds_not_authoritive_for_dst_nc;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NOT_CLOSEST))
  object_initdata_t _object_Kerror_ds_not_closest;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NOT_INSTALLED))
  object_initdata_t _object_Kerror_ds_not_installed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NOT_ON_BACKLINK))
  object_initdata_t _object_Kerror_ds_not_on_backlink;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NOT_SUPPORTED))
  object_initdata_t _object_Kerror_ds_not_supported;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NOT_SUPPORTED_SORT_ORDER))
  object_initdata_t _object_Kerror_ds_not_supported_sort_order;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NO_ATTRIBUTE_OR_VALUE))
  object_initdata_t _object_Kerror_ds_no_attribute_or_value;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NO_BEHAVIOR_VERSION_IN_MIXEDDOMAIN))
  object_initdata_t _object_Kerror_ds_no_behavior_version_in_mixeddomain;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NO_CHAINED_EVAL))
  object_initdata_t _object_Kerror_ds_no_chained_eval;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NO_CHAINING))
  object_initdata_t _object_Kerror_ds_no_chaining;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NO_CHECKPOINT_WITH_PDC))
  object_initdata_t _object_Kerror_ds_no_checkpoint_with_pdc;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NO_CROSSREF_FOR_NC))
  object_initdata_t _object_Kerror_ds_no_crossref_for_nc;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NO_DELETED_NAME))
  object_initdata_t _object_Kerror_ds_no_deleted_name;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NO_FPO_IN_UNIVERSAL_GROUPS))
  object_initdata_t _object_Kerror_ds_no_fpo_in_universal_groups;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NO_MORE_RIDS))
  object_initdata_t _object_Kerror_ds_no_more_rids;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NO_MSDS_INTID))
  object_initdata_t _object_Kerror_ds_no_msds_intid;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NO_NEST_GLOBALGROUP_IN_MIXEDDOMAIN))
  object_initdata_t _object_Kerror_ds_no_nest_globalgroup_in_mixeddomain;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NO_NEST_LOCALGROUP_IN_MIXEDDOMAIN))
  object_initdata_t _object_Kerror_ds_no_nest_localgroup_in_mixeddomain;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NO_OBJECT_MOVE_IN_SCHEMA_NC))
  object_initdata_t _object_Kerror_ds_no_object_move_in_schema_nc;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NO_PARENT_OBJECT))
  object_initdata_t _object_Kerror_ds_no_parent_object;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NO_PKT_PRIVACY_ON_CONNECTION))
  object_initdata_t _object_Kerror_ds_no_pkt_privacy_on_connection;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NO_RDN_DEFINED_IN_SCHEMA))
  object_initdata_t _object_Kerror_ds_no_rdn_defined_in_schema;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NO_REF_DOMAIN))
  object_initdata_t _object_Kerror_ds_no_ref_domain;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NO_REQUESTED_ATTS_FOUND))
  object_initdata_t _object_Kerror_ds_no_requested_atts_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NO_RESULTS_RETURNED))
  object_initdata_t _object_Kerror_ds_no_results_returned;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NO_RIDS_ALLOCATED))
  object_initdata_t _object_Kerror_ds_no_rids_allocated;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NO_SUCH_OBJECT))
  object_initdata_t _object_Kerror_ds_no_such_object;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NO_TREE_DELETE_ABOVE_NC))
  object_initdata_t _object_Kerror_ds_no_tree_delete_above_nc;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NTDSCRIPT_PROCESS_ERROR))
  object_initdata_t _object_Kerror_ds_ntdscript_process_error;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NTDSCRIPT_SYNTAX_ERROR))
  object_initdata_t _object_Kerror_ds_ntdscript_syntax_error;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_OBJECT_BEING_REMOVED))
  object_initdata_t _object_Kerror_ds_object_being_removed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_OBJECT_CLASS_REQUIRED))
  object_initdata_t _object_Kerror_ds_object_class_required;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_OBJECT_RESULTS_TOO_LARGE))
  object_initdata_t _object_Kerror_ds_object_results_too_large;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_OBJ_CLASS_NOT_DEFINED))
  object_initdata_t _object_Kerror_ds_obj_class_not_defined;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_OBJ_CLASS_NOT_SUBCLASS))
  object_initdata_t _object_Kerror_ds_obj_class_not_subclass;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_OBJ_CLASS_VIOLATION))
  object_initdata_t _object_Kerror_ds_obj_class_violation;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_OBJ_GUID_EXISTS))
  object_initdata_t _object_Kerror_ds_obj_guid_exists;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_OBJ_NOT_FOUND))
  object_initdata_t _object_Kerror_ds_obj_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_OBJ_STRING_NAME_EXISTS))
  object_initdata_t _object_Kerror_ds_obj_string_name_exists;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_OBJ_TOO_LARGE))
  object_initdata_t _object_Kerror_ds_obj_too_large;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_OFFSET_RANGE_ERROR))
  object_initdata_t _object_Kerror_ds_offset_range_error;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_OPERATIONS_ERROR))
  object_initdata_t _object_Kerror_ds_operations_error;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_OUT_OF_SCOPE))
  object_initdata_t _object_Kerror_ds_out_of_scope;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_OUT_OF_VERSION_STORE))
  object_initdata_t _object_Kerror_ds_out_of_version_store;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_PARAM_ERROR))
  object_initdata_t _object_Kerror_ds_param_error;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_PARENT_IS_AN_ALIAS))
  object_initdata_t _object_Kerror_ds_parent_is_an_alias;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_PDC_OPERATION_IN_PROGRESS))
  object_initdata_t _object_Kerror_ds_pdc_operation_in_progress;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_PROTOCOL_ERROR))
  object_initdata_t _object_Kerror_ds_protocol_error;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_RANGE_CONSTRAINT))
  object_initdata_t _object_Kerror_ds_range_constraint;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_RDN_DOESNT_MATCH_SCHEMA))
  object_initdata_t _object_Kerror_ds_rdn_doesnt_match_schema;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_RECALCSCHEMA_FAILED))
  object_initdata_t _object_Kerror_ds_recalcschema_failed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_REFERRAL))
  object_initdata_t _object_Kerror_ds_referral;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_REFERRAL_LIMIT_EXCEEDED))
  object_initdata_t _object_Kerror_ds_referral_limit_exceeded;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_REFUSING_FSMO_ROLES))
  object_initdata_t _object_Kerror_ds_refusing_fsmo_roles;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_REMOTE_CROSSREF_OP_FAILED))
  object_initdata_t _object_Kerror_ds_remote_crossref_op_failed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_REPLICATOR_ONLY))
  object_initdata_t _object_Kerror_ds_replicator_only;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_REPLICA_SET_CHANGE_NOT_ALLOWED_ON_DISABLED_CR))
  object_initdata_t _object_Kerror_ds_replica_set_change_not_allowed_on_disabled_cr;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_RESERVED_LINK_ID))
  object_initdata_t _object_Kerror_ds_reserved_link_id;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_RIDMGR_INIT_ERROR))
  object_initdata_t _object_Kerror_ds_ridmgr_init_error;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_ROLE_NOT_VERIFIED))
  object_initdata_t _object_Kerror_ds_role_not_verified;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_ROOT_CANT_BE_SUBREF))
  object_initdata_t _object_Kerror_ds_root_cant_be_subref;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_ROOT_MUST_BE_NC))
  object_initdata_t _object_Kerror_ds_root_must_be_nc;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_ROOT_REQUIRES_CLASS_TOP))
  object_initdata_t _object_Kerror_ds_root_requires_class_top;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_SAM_INIT_FAILURE))
  object_initdata_t _object_Kerror_ds_sam_init_failure;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_SAM_INIT_FAILURE_CONSOLE))
  object_initdata_t _object_Kerror_ds_sam_init_failure_console;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_SAM_NEED_BOOTKEY_FLOPPY))
  object_initdata_t _object_Kerror_ds_sam_need_bootkey_floppy;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_SAM_NEED_BOOTKEY_PASSWORD))
  object_initdata_t _object_Kerror_ds_sam_need_bootkey_password;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_SCHEMA_ALLOC_FAILED))
  object_initdata_t _object_Kerror_ds_schema_alloc_failed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_SCHEMA_NOT_LOADED))
  object_initdata_t _object_Kerror_ds_schema_not_loaded;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_SCHEMA_UPDATE_DISALLOWED))
  object_initdata_t _object_Kerror_ds_schema_update_disallowed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_SECURITY_CHECKING_ERROR))
  object_initdata_t _object_Kerror_ds_security_checking_error;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_SECURITY_ILLEGAL_MODIFY))
  object_initdata_t _object_Kerror_ds_security_illegal_modify;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_SEC_DESC_INVALID))
  object_initdata_t _object_Kerror_ds_sec_desc_invalid;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_SEC_DESC_TOO_SHORT))
  object_initdata_t _object_Kerror_ds_sec_desc_too_short;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_SEMANTIC_ATT_TEST))
  object_initdata_t _object_Kerror_ds_semantic_att_test;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_SENSITIVE_GROUP_VIOLATION))
  object_initdata_t _object_Kerror_ds_sensitive_group_violation;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_SERVER_DOWN))
  object_initdata_t _object_Kerror_ds_server_down;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_SHUTTING_DOWN))
  object_initdata_t _object_Kerror_ds_shutting_down;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_SINGLE_USER_MODE_FAILED))
  object_initdata_t _object_Kerror_ds_single_user_mode_failed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_SINGLE_VALUE_CONSTRAINT))
  object_initdata_t _object_Kerror_ds_single_value_constraint;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_SIZELIMIT_EXCEEDED))
  object_initdata_t _object_Kerror_ds_sizelimit_exceeded;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_SORT_CONTROL_MISSING))
  object_initdata_t _object_Kerror_ds_sort_control_missing;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_SOURCE_AUDITING_NOT_ENABLED))
  object_initdata_t _object_Kerror_ds_source_auditing_not_enabled;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_SOURCE_DOMAIN_IN_FOREST))
  object_initdata_t _object_Kerror_ds_source_domain_in_forest;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_SRC_AND_DST_NC_IDENTICAL))
  object_initdata_t _object_Kerror_ds_src_and_dst_nc_identical;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_SRC_AND_DST_OBJECT_CLASS_MISMATCH))
  object_initdata_t _object_Kerror_ds_src_and_dst_object_class_mismatch;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_SRC_DC_MUST_BE_SP4_OR_GREATER))
  object_initdata_t _object_Kerror_ds_src_dc_must_be_sp4_or_greater;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_SRC_GUID_MISMATCH))
  object_initdata_t _object_Kerror_ds_src_guid_mismatch;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_SRC_NAME_MISMATCH))
  object_initdata_t _object_Kerror_ds_src_name_mismatch;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_SRC_OBJ_NOT_GROUP_OR_USER))
  object_initdata_t _object_Kerror_ds_src_obj_not_group_or_user;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_SRC_SID_EXISTS_IN_FOREST))
  object_initdata_t _object_Kerror_ds_src_sid_exists_in_forest;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_STRING_SD_CONVERSION_FAILED))
  object_initdata_t _object_Kerror_ds_string_sd_conversion_failed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_STRONG_AUTH_REQUIRED))
  object_initdata_t _object_Kerror_ds_strong_auth_required;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_SUBREF_MUST_HAVE_PARENT))
  object_initdata_t _object_Kerror_ds_subref_must_have_parent;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_SUBTREE_NOTIFY_NOT_NC_HEAD))
  object_initdata_t _object_Kerror_ds_subtree_notify_not_nc_head;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_SUB_CLS_TEST_FAIL))
  object_initdata_t _object_Kerror_ds_sub_cls_test_fail;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_SYNTAX_MISMATCH))
  object_initdata_t _object_Kerror_ds_syntax_mismatch;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_THREAD_LIMIT_EXCEEDED))
  object_initdata_t _object_Kerror_ds_thread_limit_exceeded;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_TIMELIMIT_EXCEEDED))
  object_initdata_t _object_Kerror_ds_timelimit_exceeded;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_TREE_DELETE_NOT_FINISHED))
  object_initdata_t _object_Kerror_ds_tree_delete_not_finished;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_UNABLE_TO_SURRENDER_ROLES))
  object_initdata_t _object_Kerror_ds_unable_to_surrender_roles;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_UNAVAILABLE))
  object_initdata_t _object_Kerror_ds_unavailable;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_UNAVAILABLE_CRIT_EXTENSION))
  object_initdata_t _object_Kerror_ds_unavailable_crit_extension;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_UNICODEPWD_NOT_IN_QUOTES))
  object_initdata_t _object_Kerror_ds_unicodepwd_not_in_quotes;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_UNIVERSAL_CANT_HAVE_LOCAL_MEMBER))
  object_initdata_t _object_Kerror_ds_universal_cant_have_local_member;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_UNKNOWN_ERROR))
  object_initdata_t _object_Kerror_ds_unknown_error;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_UNKNOWN_OPERATION))
  object_initdata_t _object_Kerror_ds_unknown_operation;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_UNWILLING_TO_PERFORM))
  object_initdata_t _object_Kerror_ds_unwilling_to_perform;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_USER_BUFFER_TO_SMALL))
  object_initdata_t _object_Kerror_ds_user_buffer_to_small;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_WKO_CONTAINER_CANNOT_BE_SPECIAL))
  object_initdata_t _object_Kerror_ds_wko_container_cannot_be_special;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_WRONG_LINKED_ATT_SYNTAX))
  object_initdata_t _object_Kerror_ds_wrong_linked_att_syntax;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_WRONG_OM_OBJ_CLASS))
  object_initdata_t _object_Kerror_ds_wrong_om_obj_class;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DUPLICATE_SERVICE_NAME))
  object_initdata_t _object_Kerror_duplicate_service_name;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DUPLICATE_TAG))
  object_initdata_t _object_Kerror_duplicate_tag;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DUP_DOMAINNAME))
  object_initdata_t _object_Kerror_dup_domainname;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DUP_NAME))
  object_initdata_t _object_Kerror_dup_name;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DYNLINK_FROM_INVALID_RING))
  object_initdata_t _object_Kerror_dynlink_from_invalid_ring;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_EAS_DIDNT_FIT))
  object_initdata_t _object_Kerror_eas_didnt_fit;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_EAS_NOT_SUPPORTED))
  object_initdata_t _object_Kerror_eas_not_supported;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_EA_ACCESS_DENIED))
  object_initdata_t _object_Kerror_ea_access_denied;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_EA_FILE_CORRUPT))
  object_initdata_t _object_Kerror_ea_file_corrupt;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_EA_LIST_INCONSISTENT))
  object_initdata_t _object_Kerror_ea_list_inconsistent;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_EA_TABLE_FULL))
  object_initdata_t _object_Kerror_ea_table_full;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_EFS_ALG_BLOB_TOO_BIG))
  object_initdata_t _object_Kerror_efs_alg_blob_too_big;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_EFS_DISABLED))
  object_initdata_t _object_Kerror_efs_disabled;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_EFS_SERVER_NOT_TRUSTED))
  object_initdata_t _object_Kerror_efs_server_not_trusted;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_EFS_VERSION_NOT_SUPPORT))
  object_initdata_t _object_Kerror_efs_version_not_support;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_EMPTY))
  object_initdata_t _object_Kerror_empty;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ENCRYPTION_FAILED))
  object_initdata_t _object_Kerror_encryption_failed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_END_OF_MEDIA))
  object_initdata_t _object_Kerror_end_of_media;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ENVVAR_NOT_FOUND))
  object_initdata_t _object_Kerror_envvar_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_EOM_OVERFLOW))
  object_initdata_t _object_Kerror_eom_overflow;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_EVENTLOG_CANT_START))
  object_initdata_t _object_Kerror_eventlog_cant_start;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_EVENTLOG_FILE_CHANGED))
  object_initdata_t _object_Kerror_eventlog_file_changed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_EVENTLOG_FILE_CORRUPT))
  object_initdata_t _object_Kerror_eventlog_file_corrupt;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_EXCEPTION_IN_SERVICE))
  object_initdata_t _object_Kerror_exception_in_service;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_EXCL_SEM_ALREADY_OWNED))
  object_initdata_t _object_Kerror_excl_sem_already_owned;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_EXE_CANNOT_MODIFY_SIGNED_BINARY))
  object_initdata_t _object_Kerror_exe_cannot_modify_signed_binary;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_EXE_CANNOT_MODIFY_STRONG_SIGNED_BINARY))
  object_initdata_t _object_Kerror_exe_cannot_modify_strong_signed_binary;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_EXE_MACHINE_TYPE_MISMATCH))
  object_initdata_t _object_Kerror_exe_machine_type_mismatch;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_EXE_MARKED_INVALID))
  object_initdata_t _object_Kerror_exe_marked_invalid;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_EXTENDED_ERROR))
  object_initdata_t _object_Kerror_extended_error;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_FAILED_SERVICE_CONTROLLER_CONNECT))
  object_initdata_t _object_Kerror_failed_service_controller_connect;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_FAIL_I24))
  object_initdata_t _object_Kerror_fail_i24;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_FILEMARK_DETECTED))
  object_initdata_t _object_Kerror_filemark_detected;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_FILENAME_EXCED_RANGE))
  object_initdata_t _object_Kerror_filename_exced_range;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_FILE_CORRUPT))
  object_initdata_t _object_Kerror_file_corrupt;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_FILE_ENCRYPTED))
  object_initdata_t _object_Kerror_file_encrypted;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_FILE_EXISTS))
  object_initdata_t _object_Kerror_file_exists;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_FILE_INVALID))
  object_initdata_t _object_Kerror_file_invalid;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_FILE_NOT_ENCRYPTED))
  object_initdata_t _object_Kerror_file_not_encrypted;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_FILE_NOT_FOUND))
  object_initdata_t _object_Kerror_file_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_FILE_OFFLINE))
  object_initdata_t _object_Kerror_file_offline;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_FILE_READ_ONLY))
  object_initdata_t _object_Kerror_file_read_only;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_FLOPPY_BAD_REGISTERS))
  object_initdata_t _object_Kerror_floppy_bad_registers;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_FLOPPY_ID_MARK_NOT_FOUND))
  object_initdata_t _object_Kerror_floppy_id_mark_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_FLOPPY_UNKNOWN_ERROR))
  object_initdata_t _object_Kerror_floppy_unknown_error;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_FLOPPY_WRONG_CYLINDER))
  object_initdata_t _object_Kerror_floppy_wrong_cylinder;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_FULLSCREEN_MODE))
  object_initdata_t _object_Kerror_fullscreen_mode;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_FULL_BACKUP))
  object_initdata_t _object_Kerror_full_backup;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_FUNCTION_FAILED))
  object_initdata_t _object_Kerror_function_failed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_FUNCTION_NOT_CALLED))
  object_initdata_t _object_Kerror_function_not_called;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_GENERIC_NOT_MAPPED))
  object_initdata_t _object_Kerror_generic_not_mapped;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_GEN_FAILURE))
  object_initdata_t _object_Kerror_gen_failure;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_GLOBAL_ONLY_HOOK))
  object_initdata_t _object_Kerror_global_only_hook;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_GRACEFUL_DISCONNECT))
  object_initdata_t _object_Kerror_graceful_disconnect;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_GROUP_EXISTS))
  object_initdata_t _object_Kerror_group_exists;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_GROUP_NOT_AVAILABLE))
  object_initdata_t _object_Kerror_group_not_available;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_GROUP_NOT_FOUND))
  object_initdata_t _object_Kerror_group_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_GROUP_NOT_ONLINE))
  object_initdata_t _object_Kerror_group_not_online;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_HANDLE_DISK_FULL))
  object_initdata_t _object_Kerror_handle_disk_full;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_HANDLE_EOF))
  object_initdata_t _object_Kerror_handle_eof;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_HOOK_NEEDS_HMOD))
  object_initdata_t _object_Kerror_hook_needs_hmod;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_HOOK_NOT_INSTALLED))
  object_initdata_t _object_Kerror_hook_not_installed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_HOOK_TYPE_NOT_ALLOWED))
  object_initdata_t _object_Kerror_hook_type_not_allowed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_HOST_DOWN))
  object_initdata_t _object_Kerror_host_down;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_HOST_NODE_NOT_AVAILABLE))
  object_initdata_t _object_Kerror_host_node_not_available;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_HOST_NODE_NOT_GROUP_OWNER))
  object_initdata_t _object_Kerror_host_node_not_group_owner;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_HOST_NODE_NOT_RESOURCE_OWNER))
  object_initdata_t _object_Kerror_host_node_not_resource_owner;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_HOST_UNREACHABLE))
  object_initdata_t _object_Kerror_host_unreachable;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_HOTKEY_ALREADY_REGISTERED))
  object_initdata_t _object_Kerror_hotkey_already_registered;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_HOTKEY_NOT_REGISTERED))
  object_initdata_t _object_Kerror_hotkey_not_registered;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_HWNDS_HAVE_DIFF_PARENT))
  object_initdata_t _object_Kerror_hwnds_have_diff_parent;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ICM_NOT_ENABLED))
  object_initdata_t _object_Kerror_icm_not_enabled;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ILLEGAL_ELEMENT_ADDRESS))
  object_initdata_t _object_Kerror_illegal_element_address;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ILL_FORMED_PASSWORD))
  object_initdata_t _object_Kerror_ill_formed_password;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INCORRECT_ADDRESS))
  object_initdata_t _object_Kerror_incorrect_address;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INC_BACKUP))
  object_initdata_t _object_Kerror_inc_backup;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INDEX_ABSENT))
  object_initdata_t _object_Kerror_index_absent;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INDIGENOUS_TYPE))
  object_initdata_t _object_Kerror_indigenous_type;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INFLOOP_IN_RELOC_CHAIN))
  object_initdata_t _object_Kerror_infloop_in_reloc_chain;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INSTALL_ALREADY_RUNNING))
  object_initdata_t _object_Kerror_install_already_running;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INSTALL_FAILURE))
  object_initdata_t _object_Kerror_install_failure;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INSTALL_LANGUAGE_UNSUPPORTED))
  object_initdata_t _object_Kerror_install_language_unsupported;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INSTALL_LOG_FAILURE))
  object_initdata_t _object_Kerror_install_log_failure;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INSTALL_NOTUSED))
  object_initdata_t _object_Kerror_install_notused;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INSTALL_PACKAGE_INVALID))
  object_initdata_t _object_Kerror_install_package_invalid;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INSTALL_PACKAGE_OPEN_FAILED))
  object_initdata_t _object_Kerror_install_package_open_failed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INSTALL_PACKAGE_REJECTED))
  object_initdata_t _object_Kerror_install_package_rejected;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INSTALL_PACKAGE_VERSION))
  object_initdata_t _object_Kerror_install_package_version;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INSTALL_PLATFORM_UNSUPPORTED))
  object_initdata_t _object_Kerror_install_platform_unsupported;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INSTALL_REMOTE_DISALLOWED))
  object_initdata_t _object_Kerror_install_remote_disallowed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INSTALL_REMOTE_PROHIBITED))
  object_initdata_t _object_Kerror_install_remote_prohibited;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INSTALL_SERVICE_FAILURE))
  object_initdata_t _object_Kerror_install_service_failure;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INSTALL_SOURCE_ABSENT))
  object_initdata_t _object_Kerror_install_source_absent;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INSTALL_SUSPEND))
  object_initdata_t _object_Kerror_install_suspend;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INSTALL_TEMP_UNWRITABLE))
  object_initdata_t _object_Kerror_install_temp_unwritable;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INSTALL_TRANSFORM_FAILURE))
  object_initdata_t _object_Kerror_install_transform_failure;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INSTALL_TRANSFORM_REJECTED))
  object_initdata_t _object_Kerror_install_transform_rejected;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INSTALL_UI_FAILURE))
  object_initdata_t _object_Kerror_install_ui_failure;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INSTALL_USEREXIT))
  object_initdata_t _object_Kerror_install_userexit;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INSUFFICIENT_BUFFER))
  object_initdata_t _object_Kerror_insufficient_buffer;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INTERNAL_DB_CORRUPTION))
  object_initdata_t _object_Kerror_internal_db_corruption;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INTERNAL_DB_ERROR))
  object_initdata_t _object_Kerror_internal_db_error;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INTERNAL_ERROR))
  object_initdata_t _object_Kerror_internal_error;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_ACCEL_HANDLE))
  object_initdata_t _object_Kerror_invalid_accel_handle;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_ACCESS))
  object_initdata_t _object_Kerror_invalid_access;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_ACCOUNT_NAME))
  object_initdata_t _object_Kerror_invalid_account_name;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_ACL))
  object_initdata_t _object_Kerror_invalid_acl;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_ADDRESS))
  object_initdata_t _object_Kerror_invalid_address;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_AT_INTERRUPT_TIME))
  object_initdata_t _object_Kerror_invalid_at_interrupt_time;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_BLOCK))
  object_initdata_t _object_Kerror_invalid_block;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_BLOCK_LENGTH))
  object_initdata_t _object_Kerror_invalid_block_length;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_CATEGORY))
  object_initdata_t _object_Kerror_invalid_category;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_CLEANER))
  object_initdata_t _object_Kerror_invalid_cleaner;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_CMM))
  object_initdata_t _object_Kerror_invalid_cmm;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_COLORINDEX))
  object_initdata_t _object_Kerror_invalid_colorindex;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_COLORSPACE))
  object_initdata_t _object_Kerror_invalid_colorspace;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_COMBOBOX_MESSAGE))
  object_initdata_t _object_Kerror_invalid_combobox_message;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_COMMAND_LINE))
  object_initdata_t _object_Kerror_invalid_command_line;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_COMPUTERNAME))
  object_initdata_t _object_Kerror_invalid_computername;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_CURSOR_HANDLE))
  object_initdata_t _object_Kerror_invalid_cursor_handle;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_DATA))
  object_initdata_t _object_Kerror_invalid_data;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_DATATYPE))
  object_initdata_t _object_Kerror_invalid_datatype;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_DLL))
  object_initdata_t _object_Kerror_invalid_dll;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_DOMAINNAME))
  object_initdata_t _object_Kerror_invalid_domainname;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_DOMAIN_ROLE))
  object_initdata_t _object_Kerror_invalid_domain_role;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_DOMAIN_STATE))
  object_initdata_t _object_Kerror_invalid_domain_state;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_DRIVE))
  object_initdata_t _object_Kerror_invalid_drive;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_DRIVE_OBJECT))
  object_initdata_t _object_Kerror_invalid_drive_object;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_DWP_HANDLE))
  object_initdata_t _object_Kerror_invalid_dwp_handle;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_EA_HANDLE))
  object_initdata_t _object_Kerror_invalid_ea_handle;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_EA_NAME))
  object_initdata_t _object_Kerror_invalid_ea_name;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_EDIT_HEIGHT))
  object_initdata_t _object_Kerror_invalid_edit_height;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_ENVIRONMENT))
  object_initdata_t _object_Kerror_invalid_environment;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_EVENTNAME))
  object_initdata_t _object_Kerror_invalid_eventname;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_EVENT_COUNT))
  object_initdata_t _object_Kerror_invalid_event_count;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_EXE_SIGNATURE))
  object_initdata_t _object_Kerror_invalid_exe_signature;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_FIELD))
  object_initdata_t _object_Kerror_invalid_field;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_FILTER_PROC))
  object_initdata_t _object_Kerror_invalid_filter_proc;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_FLAGS))
  object_initdata_t _object_Kerror_invalid_flags;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_FLAG_NUMBER))
  object_initdata_t _object_Kerror_invalid_flag_number;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_FORM_NAME))
  object_initdata_t _object_Kerror_invalid_form_name;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_FORM_SIZE))
  object_initdata_t _object_Kerror_invalid_form_size;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_FUNCTION))
  object_initdata_t _object_Kerror_invalid_function;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_GROUPNAME))
  object_initdata_t _object_Kerror_invalid_groupname;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_GROUP_ATTRIBUTES))
  object_initdata_t _object_Kerror_invalid_group_attributes;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_GW_COMMAND))
  object_initdata_t _object_Kerror_invalid_gw_command;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_HANDLE))
  object_initdata_t _object_Kerror_invalid_handle;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_HANDLE_STATE))
  object_initdata_t _object_Kerror_invalid_handle_state;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_HOOK_FILTER))
  object_initdata_t _object_Kerror_invalid_hook_filter;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_HOOK_HANDLE))
  object_initdata_t _object_Kerror_invalid_hook_handle;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_ICON_HANDLE))
  object_initdata_t _object_Kerror_invalid_icon_handle;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_ID_AUTHORITY))
  object_initdata_t _object_Kerror_invalid_id_authority;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_IMPORT_OF_NON_DLL))
  object_initdata_t _object_Kerror_invalid_import_of_non_dll;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_INDEX))
  object_initdata_t _object_Kerror_invalid_index;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_KEYBOARD_HANDLE))
  object_initdata_t _object_Kerror_invalid_keyboard_handle;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_LB_MESSAGE))
  object_initdata_t _object_Kerror_invalid_lb_message;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_LEVEL))
  object_initdata_t _object_Kerror_invalid_level;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_LIBRARY))
  object_initdata_t _object_Kerror_invalid_library;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_LIST_FORMAT))
  object_initdata_t _object_Kerror_invalid_list_format;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_LOGON_HOURS))
  object_initdata_t _object_Kerror_invalid_logon_hours;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_LOGON_TYPE))
  object_initdata_t _object_Kerror_invalid_logon_type;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_MEDIA))
  object_initdata_t _object_Kerror_invalid_media;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_MEDIA_POOL))
  object_initdata_t _object_Kerror_invalid_media_pool;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_MEMBER))
  object_initdata_t _object_Kerror_invalid_member;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_MENU_HANDLE))
  object_initdata_t _object_Kerror_invalid_menu_handle;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_MESSAGE))
  object_initdata_t _object_Kerror_invalid_message;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_MESSAGEDEST))
  object_initdata_t _object_Kerror_invalid_messagedest;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_MESSAGENAME))
  object_initdata_t _object_Kerror_invalid_messagename;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_MINALLOCSIZE))
  object_initdata_t _object_Kerror_invalid_minallocsize;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_MODULETYPE))
  object_initdata_t _object_Kerror_invalid_moduletype;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_MONITOR_HANDLE))
  object_initdata_t _object_Kerror_invalid_monitor_handle;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_MSGBOX_STYLE))
  object_initdata_t _object_Kerror_invalid_msgbox_style;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_NAME))
  object_initdata_t _object_Kerror_invalid_name;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_NETNAME))
  object_initdata_t _object_Kerror_invalid_netname;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_OPERATION))
  object_initdata_t _object_Kerror_invalid_operation;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_OPERATION_ON_QUORUM))
  object_initdata_t _object_Kerror_invalid_operation_on_quorum;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_OPLOCK_PROTOCOL))
  object_initdata_t _object_Kerror_invalid_oplock_protocol;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_ORDINAL))
  object_initdata_t _object_Kerror_invalid_ordinal;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_OWNER))
  object_initdata_t _object_Kerror_invalid_owner;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_PARAMETER))
  object_initdata_t _object_Kerror_invalid_parameter;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_PASSWORD))
  object_initdata_t _object_Kerror_invalid_password;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_PASSWORDNAME))
  object_initdata_t _object_Kerror_invalid_passwordname;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_PIXEL_FORMAT))
  object_initdata_t _object_Kerror_invalid_pixel_format;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_PRIMARY_GROUP))
  object_initdata_t _object_Kerror_invalid_primary_group;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_PRINTER_COMMAND))
  object_initdata_t _object_Kerror_invalid_printer_command;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_PRINTER_NAME))
  object_initdata_t _object_Kerror_invalid_printer_name;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_PRINTER_STATE))
  object_initdata_t _object_Kerror_invalid_printer_state;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_PRINT_MONITOR))
  object_initdata_t _object_Kerror_invalid_print_monitor;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_PRIORITY))
  object_initdata_t _object_Kerror_invalid_priority;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_PROFILE))
  object_initdata_t _object_Kerror_invalid_profile;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_REPARSE_DATA))
  object_initdata_t _object_Kerror_invalid_reparse_data;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_SCROLLBAR_RANGE))
  object_initdata_t _object_Kerror_invalid_scrollbar_range;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_SECURITY_DESCR))
  object_initdata_t _object_Kerror_invalid_security_descr;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_SEGDPL))
  object_initdata_t _object_Kerror_invalid_segdpl;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_SEGMENT_NUMBER))
  object_initdata_t _object_Kerror_invalid_segment_number;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_SEPARATOR_FILE))
  object_initdata_t _object_Kerror_invalid_separator_file;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_SERVER_STATE))
  object_initdata_t _object_Kerror_invalid_server_state;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_SERVICENAME))
  object_initdata_t _object_Kerror_invalid_servicename;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_SERVICE_ACCOUNT))
  object_initdata_t _object_Kerror_invalid_service_account;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_SERVICE_CONTROL))
  object_initdata_t _object_Kerror_invalid_service_control;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_SERVICE_LOCK))
  object_initdata_t _object_Kerror_invalid_service_lock;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_SHARENAME))
  object_initdata_t _object_Kerror_invalid_sharename;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_SHOWWIN_COMMAND))
  object_initdata_t _object_Kerror_invalid_showwin_command;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_SID))
  object_initdata_t _object_Kerror_invalid_sid;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_SIGNAL_NUMBER))
  object_initdata_t _object_Kerror_invalid_signal_number;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_SPI_VALUE))
  object_initdata_t _object_Kerror_invalid_spi_value;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_STACKSEG))
  object_initdata_t _object_Kerror_invalid_stackseg;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_STARTING_CODESEG))
  object_initdata_t _object_Kerror_invalid_starting_codeseg;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_STATE))
  object_initdata_t _object_Kerror_invalid_state;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_SUB_AUTHORITY))
  object_initdata_t _object_Kerror_invalid_sub_authority;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_TABLE))
  object_initdata_t _object_Kerror_invalid_table;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_TARGET_HANDLE))
  object_initdata_t _object_Kerror_invalid_target_handle;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_THREAD_ID))
  object_initdata_t _object_Kerror_invalid_thread_id;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_TIME))
  object_initdata_t _object_Kerror_invalid_time;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_TRANSFORM))
  object_initdata_t _object_Kerror_invalid_transform;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_USER_BUFFER))
  object_initdata_t _object_Kerror_invalid_user_buffer;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_VERIFY_SWITCH))
  object_initdata_t _object_Kerror_invalid_verify_switch;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_WINDOW_HANDLE))
  object_initdata_t _object_Kerror_invalid_window_handle;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_WINDOW_STYLE))
  object_initdata_t _object_Kerror_invalid_window_style;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_WORKSTATION))
  object_initdata_t _object_Kerror_invalid_workstation;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IOPL_NOT_ENABLED))
  object_initdata_t _object_Kerror_iopl_not_enabled;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IO_DEVICE))
  object_initdata_t _object_Kerror_io_device;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IO_INCOMPLETE))
  object_initdata_t _object_Kerror_io_incomplete;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IO_PENDING))
  object_initdata_t _object_Kerror_io_pending;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_DEFAULT_MM_AUTH_NOT_FOUND))
  object_initdata_t _object_Kerror_ipsec_default_mm_auth_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_DEFAULT_MM_POLICY_NOT_FOUND))
  object_initdata_t _object_Kerror_ipsec_default_mm_policy_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_DEFAULT_QM_POLICY_NOT_FOUND))
  object_initdata_t _object_Kerror_ipsec_default_qm_policy_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_ADD_UPDATE_KEY_FAILED))
  object_initdata_t _object_Kerror_ipsec_ike_add_update_key_failed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_ATTRIB_FAIL))
  object_initdata_t _object_Kerror_ipsec_ike_attrib_fail;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_AUTH_FAIL))
  object_initdata_t _object_Kerror_ipsec_ike_auth_fail;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_BENIGN_REINIT))
  object_initdata_t _object_Kerror_ipsec_ike_benign_reinit;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_CRL_FAILED))
  object_initdata_t _object_Kerror_ipsec_ike_crl_failed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_DECRYPT))
  object_initdata_t _object_Kerror_ipsec_ike_decrypt;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_DH_FAIL))
  object_initdata_t _object_Kerror_ipsec_ike_dh_fail;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_DH_FAILURE))
  object_initdata_t _object_Kerror_ipsec_ike_dh_failure;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_DROP_NO_RESPONSE))
  object_initdata_t _object_Kerror_ipsec_ike_drop_no_response;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_ENCRYPT))
  object_initdata_t _object_Kerror_ipsec_ike_encrypt;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_ERROR))
  object_initdata_t _object_Kerror_ipsec_ike_error;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_FAILQUERYSSP))
  object_initdata_t _object_Kerror_ipsec_ike_failqueryssp;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_FAILSSPINIT))
  object_initdata_t _object_Kerror_ipsec_ike_failsspinit;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_GENERAL_PROCESSING_ERROR))
  object_initdata_t _object_Kerror_ipsec_ike_general_processing_error;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_GETSPIFAIL))
  object_initdata_t _object_Kerror_ipsec_ike_getspifail;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_INVALID_AUTH_ALG))
  object_initdata_t _object_Kerror_ipsec_ike_invalid_auth_alg;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_INVALID_CERT_KEYLEN))
  object_initdata_t _object_Kerror_ipsec_ike_invalid_cert_keylen;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_INVALID_CERT_TYPE))
  object_initdata_t _object_Kerror_ipsec_ike_invalid_cert_type;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_INVALID_COOKIE))
  object_initdata_t _object_Kerror_ipsec_ike_invalid_cookie;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_INVALID_ENCRYPT_ALG))
  object_initdata_t _object_Kerror_ipsec_ike_invalid_encrypt_alg;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_INVALID_FILTER))
  object_initdata_t _object_Kerror_ipsec_ike_invalid_filter;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_INVALID_GROUP))
  object_initdata_t _object_Kerror_ipsec_ike_invalid_group;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_INVALID_HASH))
  object_initdata_t _object_Kerror_ipsec_ike_invalid_hash;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_INVALID_HASH_ALG))
  object_initdata_t _object_Kerror_ipsec_ike_invalid_hash_alg;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_INVALID_HASH_SIZE))
  object_initdata_t _object_Kerror_ipsec_ike_invalid_hash_size;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_INVALID_HEADER))
  object_initdata_t _object_Kerror_ipsec_ike_invalid_header;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_INVALID_KEY_USAGE))
  object_initdata_t _object_Kerror_ipsec_ike_invalid_key_usage;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_INVALID_PAYLOAD))
  object_initdata_t _object_Kerror_ipsec_ike_invalid_payload;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_INVALID_POLICY))
  object_initdata_t _object_Kerror_ipsec_ike_invalid_policy;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_INVALID_RESPONDER_LIFETIME_NOTIFY))
  object_initdata_t _object_Kerror_ipsec_ike_invalid_responder_lifetime_notify;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_INVALID_SIG))
  object_initdata_t _object_Kerror_ipsec_ike_invalid_sig;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_INVALID_SIGNATURE))
  object_initdata_t _object_Kerror_ipsec_ike_invalid_signature;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_INVALID_SITUATION))
  object_initdata_t _object_Kerror_ipsec_ike_invalid_situation;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_KERBEROS_ERROR))
  object_initdata_t _object_Kerror_ipsec_ike_kerberos_error;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_LOAD_FAILED))
  object_initdata_t _object_Kerror_ipsec_ike_load_failed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_LOAD_SOFT_SA))
  object_initdata_t _object_Kerror_ipsec_ike_load_soft_sa;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_MM_ACQUIRE_DROP))
  object_initdata_t _object_Kerror_ipsec_ike_mm_acquire_drop;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_MM_DELAY_DROP))
  object_initdata_t _object_Kerror_ipsec_ike_mm_delay_drop;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_MM_LIMIT))
  object_initdata_t _object_Kerror_ipsec_ike_mm_limit;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_NEGOTIATION_DISABLED))
  object_initdata_t _object_Kerror_ipsec_ike_negotiation_disabled;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_NEGOTIATION_PENDING))
  object_initdata_t _object_Kerror_ipsec_ike_negotiation_pending;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_NEG_STATUS_END))
  object_initdata_t _object_Kerror_ipsec_ike_neg_status_end;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_NOTCBPRIV))
  object_initdata_t _object_Kerror_ipsec_ike_notcbpriv;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_NO_CERT))
  object_initdata_t _object_Kerror_ipsec_ike_no_cert;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_NO_MM_POLICY))
  object_initdata_t _object_Kerror_ipsec_ike_no_mm_policy;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_NO_PEER_CERT))
  object_initdata_t _object_Kerror_ipsec_ike_no_peer_cert;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_NO_POLICY))
  object_initdata_t _object_Kerror_ipsec_ike_no_policy;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_NO_PRIVATE_KEY))
  object_initdata_t _object_Kerror_ipsec_ike_no_private_key;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_NO_PUBLIC_KEY))
  object_initdata_t _object_Kerror_ipsec_ike_no_public_key;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_OUT_OF_MEMORY))
  object_initdata_t _object_Kerror_ipsec_ike_out_of_memory;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_PEER_CRL_FAILED))
  object_initdata_t _object_Kerror_ipsec_ike_peer_crl_failed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_POLICY_CHANGE))
  object_initdata_t _object_Kerror_ipsec_ike_policy_change;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_POLICY_MATCH))
  object_initdata_t _object_Kerror_ipsec_ike_policy_match;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_PROCESS_ERR))
  object_initdata_t _object_Kerror_ipsec_ike_process_err;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_PROCESS_ERR_CERT))
  object_initdata_t _object_Kerror_ipsec_ike_process_err_cert;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_PROCESS_ERR_CERT_REQ))
  object_initdata_t _object_Kerror_ipsec_ike_process_err_cert_req;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_PROCESS_ERR_DELETE))
  object_initdata_t _object_Kerror_ipsec_ike_process_err_delete;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_PROCESS_ERR_HASH))
  object_initdata_t _object_Kerror_ipsec_ike_process_err_hash;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_PROCESS_ERR_ID))
  object_initdata_t _object_Kerror_ipsec_ike_process_err_id;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_PROCESS_ERR_KE))
  object_initdata_t _object_Kerror_ipsec_ike_process_err_ke;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_PROCESS_ERR_NONCE))
  object_initdata_t _object_Kerror_ipsec_ike_process_err_nonce;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_PROCESS_ERR_NOTIFY))
  object_initdata_t _object_Kerror_ipsec_ike_process_err_notify;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_PROCESS_ERR_PROP))
  object_initdata_t _object_Kerror_ipsec_ike_process_err_prop;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_PROCESS_ERR_SA))
  object_initdata_t _object_Kerror_ipsec_ike_process_err_sa;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_PROCESS_ERR_SIG))
  object_initdata_t _object_Kerror_ipsec_ike_process_err_sig;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_PROCESS_ERR_TRANS))
  object_initdata_t _object_Kerror_ipsec_ike_process_err_trans;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_PROCESS_ERR_VENDOR))
  object_initdata_t _object_Kerror_ipsec_ike_process_err_vendor;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_QM_ACQUIRE_DROP))
  object_initdata_t _object_Kerror_ipsec_ike_qm_acquire_drop;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_QM_DELAY_DROP))
  object_initdata_t _object_Kerror_ipsec_ike_qm_delay_drop;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_QUEUE_DROP_MM))
  object_initdata_t _object_Kerror_ipsec_ike_queue_drop_mm;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_QUEUE_DROP_NO_MM))
  object_initdata_t _object_Kerror_ipsec_ike_queue_drop_no_mm;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_RPC_DELETE))
  object_initdata_t _object_Kerror_ipsec_ike_rpc_delete;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_SA_DELETED))
  object_initdata_t _object_Kerror_ipsec_ike_sa_deleted;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_SA_REAPED))
  object_initdata_t _object_Kerror_ipsec_ike_sa_reaped;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_SECLOADFAIL))
  object_initdata_t _object_Kerror_ipsec_ike_secloadfail;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_SOFT_SA_TORN_DOWN))
  object_initdata_t _object_Kerror_ipsec_ike_soft_sa_torn_down;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_SRVACQFAIL))
  object_initdata_t _object_Kerror_ipsec_ike_srvacqfail;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_SRVQUERYCRED))
  object_initdata_t _object_Kerror_ipsec_ike_srvquerycred;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_TIMED_OUT))
  object_initdata_t _object_Kerror_ipsec_ike_timed_out;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_UNKNOWN_DOI))
  object_initdata_t _object_Kerror_ipsec_ike_unknown_doi;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_UNSUPPORTED_ID))
  object_initdata_t _object_Kerror_ipsec_ike_unsupported_id;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_MM_AUTH_EXISTS))
  object_initdata_t _object_Kerror_ipsec_mm_auth_exists;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_MM_AUTH_IN_USE))
  object_initdata_t _object_Kerror_ipsec_mm_auth_in_use;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_MM_AUTH_NOT_FOUND))
  object_initdata_t _object_Kerror_ipsec_mm_auth_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_MM_AUTH_PENDING_DELETION))
  object_initdata_t _object_Kerror_ipsec_mm_auth_pending_deletion;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_MM_FILTER_EXISTS))
  object_initdata_t _object_Kerror_ipsec_mm_filter_exists;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_MM_FILTER_NOT_FOUND))
  object_initdata_t _object_Kerror_ipsec_mm_filter_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_MM_FILTER_PENDING_DELETION))
  object_initdata_t _object_Kerror_ipsec_mm_filter_pending_deletion;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_MM_POLICY_EXISTS))
  object_initdata_t _object_Kerror_ipsec_mm_policy_exists;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_MM_POLICY_IN_USE))
  object_initdata_t _object_Kerror_ipsec_mm_policy_in_use;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_MM_POLICY_NOT_FOUND))
  object_initdata_t _object_Kerror_ipsec_mm_policy_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_MM_POLICY_PENDING_DELETION))
  object_initdata_t _object_Kerror_ipsec_mm_policy_pending_deletion;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_QM_POLICY_EXISTS))
  object_initdata_t _object_Kerror_ipsec_qm_policy_exists;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_QM_POLICY_IN_USE))
  object_initdata_t _object_Kerror_ipsec_qm_policy_in_use;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_QM_POLICY_NOT_FOUND))
  object_initdata_t _object_Kerror_ipsec_qm_policy_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_QM_POLICY_PENDING_DELETION))
  object_initdata_t _object_Kerror_ipsec_qm_policy_pending_deletion;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_TRANSPORT_FILTER_EXISTS))
  object_initdata_t _object_Kerror_ipsec_transport_filter_exists;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_TRANSPORT_FILTER_NOT_FOUND))
  object_initdata_t _object_Kerror_ipsec_transport_filter_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_TRANSPORT_FILTER_PENDING_DELETION))
  object_initdata_t _object_Kerror_ipsec_transport_filter_pending_deletion;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_TUNNEL_FILTER_EXISTS))
  object_initdata_t _object_Kerror_ipsec_tunnel_filter_exists;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_TUNNEL_FILTER_NOT_FOUND))
  object_initdata_t _object_Kerror_ipsec_tunnel_filter_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_TUNNEL_FILTER_PENDING_DELETION))
  object_initdata_t _object_Kerror_ipsec_tunnel_filter_pending_deletion;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IRQ_BUSY))
  object_initdata_t _object_Kerror_irq_busy;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IS_JOINED))
  object_initdata_t _object_Kerror_is_joined;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IS_JOIN_PATH))
  object_initdata_t _object_Kerror_is_join_path;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IS_JOIN_TARGET))
  object_initdata_t _object_Kerror_is_join_target;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IS_SUBSTED))
  object_initdata_t _object_Kerror_is_substed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IS_SUBST_PATH))
  object_initdata_t _object_Kerror_is_subst_path;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IS_SUBST_TARGET))
  object_initdata_t _object_Kerror_is_subst_target;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ITERATED_DATA_EXCEEDS_64k))
  object_initdata_t _object_Kerror_iterated_data_exceeds_64k;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_JOIN_TO_JOIN))
  object_initdata_t _object_Kerror_join_to_join;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_JOIN_TO_SUBST))
  object_initdata_t _object_Kerror_join_to_subst;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_JOURNAL_DELETE_IN_PROGRESS))
  object_initdata_t _object_Kerror_journal_delete_in_progress;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_JOURNAL_ENTRY_DELETED))
  object_initdata_t _object_Kerror_journal_entry_deleted;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_JOURNAL_HOOK_SET))
  object_initdata_t _object_Kerror_journal_hook_set;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_JOURNAL_NOT_ACTIVE))
  object_initdata_t _object_Kerror_journal_not_active;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_KEY_DELETED))
  object_initdata_t _object_Kerror_key_deleted;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_KEY_HAS_CHILDREN))
  object_initdata_t _object_Kerror_key_has_children;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_KM_DRIVER_BLOCKED))
  object_initdata_t _object_Kerror_km_driver_blocked;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_LABEL_TOO_LONG))
  object_initdata_t _object_Kerror_label_too_long;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_LAST_ADMIN))
  object_initdata_t _object_Kerror_last_admin;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_LB_WITHOUT_TABSTOPS))
  object_initdata_t _object_Kerror_lb_without_tabstops;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_LIBRARY_FULL))
  object_initdata_t _object_Kerror_library_full;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_LIBRARY_OFFLINE))
  object_initdata_t _object_Kerror_library_offline;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_LICENSE_QUOTA_EXCEEDED))
  object_initdata_t _object_Kerror_license_quota_exceeded;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_LISTBOX_ID_NOT_FOUND))
  object_initdata_t _object_Kerror_listbox_id_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_LM_CROSS_ENCRYPTION_REQUIRED))
  object_initdata_t _object_Kerror_lm_cross_encryption_required;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_LOCAL_USER_SESSION_KEY))
  object_initdata_t _object_Kerror_local_user_session_key;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_LOCKED))
  object_initdata_t _object_Kerror_locked;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_LOCK_FAILED))
  object_initdata_t _object_Kerror_lock_failed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_LOCK_VIOLATION))
  object_initdata_t _object_Kerror_lock_violation;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_LOGIN_TIME_RESTRICTION))
  object_initdata_t _object_Kerror_login_time_restriction;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_LOGIN_WKSTA_RESTRICTION))
  object_initdata_t _object_Kerror_login_wksta_restriction;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_LOGON_FAILURE))
  object_initdata_t _object_Kerror_logon_failure;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_LOGON_NOT_GRANTED))
  object_initdata_t _object_Kerror_logon_not_granted;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_LOGON_SESSION_COLLISION))
  object_initdata_t _object_Kerror_logon_session_collision;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_LOGON_SESSION_EXISTS))
  object_initdata_t _object_Kerror_logon_session_exists;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_LOGON_TYPE_NOT_GRANTED))
  object_initdata_t _object_Kerror_logon_type_not_granted;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_LOG_FILE_FULL))
  object_initdata_t _object_Kerror_log_file_full;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_LUIDS_EXHAUSTED))
  object_initdata_t _object_Kerror_luids_exhausted;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_MACHINE_LOCKED))
  object_initdata_t _object_Kerror_machine_locked;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_MAGAZINE_NOT_PRESENT))
  object_initdata_t _object_Kerror_magazine_not_present;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_MAPPED_ALIGNMENT))
  object_initdata_t _object_Kerror_mapped_alignment;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_MAX_THRDS_REACHED))
  object_initdata_t _object_Kerror_max_thrds_reached;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_MEDIA_CHANGED))
  object_initdata_t _object_Kerror_media_changed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_MEDIA_INCOMPATIBLE))
  object_initdata_t _object_Kerror_media_incompatible;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_MEDIA_NOT_AVAILABLE))
  object_initdata_t _object_Kerror_media_not_available;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_MEDIA_OFFLINE))
  object_initdata_t _object_Kerror_media_offline;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_MEDIA_UNAVAILABLE))
  object_initdata_t _object_Kerror_media_unavailable;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_MEDIUM_NOT_ACCESSIBLE))
  object_initdata_t _object_Kerror_medium_not_accessible;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_MEMBERS_PRIMARY_GROUP))
  object_initdata_t _object_Kerror_members_primary_group;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_MEMBER_IN_ALIAS))
  object_initdata_t _object_Kerror_member_in_alias;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_MEMBER_IN_GROUP))
  object_initdata_t _object_Kerror_member_in_group;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_MEMBER_NOT_IN_ALIAS))
  object_initdata_t _object_Kerror_member_not_in_alias;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_MEMBER_NOT_IN_GROUP))
  object_initdata_t _object_Kerror_member_not_in_group;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_MENU_ITEM_NOT_FOUND))
  object_initdata_t _object_Kerror_menu_item_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_MESSAGE_EXCEEDS_MAX_SIZE))
  object_initdata_t _object_Kerror_message_exceeds_max_size;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_MESSAGE_SYNC_ONLY))
  object_initdata_t _object_Kerror_message_sync_only;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_METAFILE_NOT_SUPPORTED))
  object_initdata_t _object_Kerror_metafile_not_supported;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_META_EXPANSION_TOO_LONG))
  object_initdata_t _object_Kerror_meta_expansion_too_long;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_MOD_NOT_FOUND))
  object_initdata_t _object_Kerror_mod_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_MORE_DATA))
  object_initdata_t _object_Kerror_more_data;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_MORE_WRITES))
  object_initdata_t _object_Kerror_more_writes;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_MR_MID_NOT_FOUND))
  object_initdata_t _object_Kerror_mr_mid_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_MUTUAL_AUTH_FAILED))
  object_initdata_t _object_Kerror_mutual_auth_failed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NEGATIVE_SEEK))
  object_initdata_t _object_Kerror_negative_seek;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NESTING_NOT_ALLOWED))
  object_initdata_t _object_Kerror_nesting_not_allowed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NETLOGON_NOT_STARTED))
  object_initdata_t _object_Kerror_netlogon_not_started;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NETNAME_DELETED))
  object_initdata_t _object_Kerror_netname_deleted;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NETWORK_ACCESS_DENIED))
  object_initdata_t _object_Kerror_network_access_denied;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NETWORK_BUSY))
  object_initdata_t _object_Kerror_network_busy;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NETWORK_NOT_AVAILABLE))
  object_initdata_t _object_Kerror_network_not_available;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NETWORK_UNREACHABLE))
  object_initdata_t _object_Kerror_network_unreachable;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NET_WRITE_FAULT))
  object_initdata_t _object_Kerror_net_write_fault;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOACCESS))
  object_initdata_t _object_Kerror_noaccess;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NODE_CANNOT_BE_CLUSTERED))
  object_initdata_t _object_Kerror_node_cannot_be_clustered;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NODE_CANT_HOST_RESOURCE))
  object_initdata_t _object_Kerror_node_cant_host_resource;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NODE_NOT_AVAILABLE))
  object_initdata_t _object_Kerror_node_not_available;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT))
  object_initdata_t _object_Kerror_nologon_interdomain_trust_account;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOLOGON_SERVER_TRUST_ACCOUNT))
  object_initdata_t _object_Kerror_nologon_server_trust_account;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOLOGON_WORKSTATION_TRUST_ACCOUNT))
  object_initdata_t _object_Kerror_nologon_workstation_trust_account;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NONE_MAPPED))
  object_initdata_t _object_Kerror_none_mapped;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NONPAGED_SYSTEM_RESOURCES))
  object_initdata_t _object_Kerror_nonpaged_system_resources;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NON_ACCOUNT_SID))
  object_initdata_t _object_Kerror_non_account_sid;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NON_DOMAIN_SID))
  object_initdata_t _object_Kerror_non_domain_sid;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NON_MDICHILD_WINDOW))
  object_initdata_t _object_Kerror_non_mdichild_window;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOTIFY_ENUM_DIR))
  object_initdata_t _object_Kerror_notify_enum_dir;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOT_ALL_ASSIGNED))
  object_initdata_t _object_Kerror_not_all_assigned;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOT_AUTHENTICATED))
  object_initdata_t _object_Kerror_not_authenticated;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOT_A_REPARSE_POINT))
  object_initdata_t _object_Kerror_not_a_reparse_point;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOT_CHILD_WINDOW))
  object_initdata_t _object_Kerror_not_child_window;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOT_CONNECTED))
  object_initdata_t _object_Kerror_not_connected;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOT_CONTAINER))
  object_initdata_t _object_Kerror_not_container;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOT_DOS_DISK))
  object_initdata_t _object_Kerror_not_dos_disk;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOT_EMPTY))
  object_initdata_t _object_Kerror_not_empty;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOT_ENOUGH_MEMORY))
  object_initdata_t _object_Kerror_not_enough_memory;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOT_ENOUGH_QUOTA))
  object_initdata_t _object_Kerror_not_enough_quota;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOT_ENOUGH_SERVER_MEMORY))
  object_initdata_t _object_Kerror_not_enough_server_memory;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOT_EXPORT_FORMAT))
  object_initdata_t _object_Kerror_not_export_format;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOT_FOUND))
  object_initdata_t _object_Kerror_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOT_JOINED))
  object_initdata_t _object_Kerror_not_joined;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOT_LOCKED))
  object_initdata_t _object_Kerror_not_locked;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOT_LOGGED_ON))
  object_initdata_t _object_Kerror_not_logged_on;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOT_LOGON_PROCESS))
  object_initdata_t _object_Kerror_not_logon_process;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOT_OWNER))
  object_initdata_t _object_Kerror_not_owner;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOT_QUORUM_CAPABLE))
  object_initdata_t _object_Kerror_not_quorum_capable;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOT_QUORUM_CLASS))
  object_initdata_t _object_Kerror_not_quorum_class;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOT_READY))
  object_initdata_t _object_Kerror_not_ready;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOT_REGISTRY_FILE))
  object_initdata_t _object_Kerror_not_registry_file;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOT_SAFEBOOT_SERVICE))
  object_initdata_t _object_Kerror_not_safeboot_service;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOT_SAME_DEVICE))
  object_initdata_t _object_Kerror_not_same_device;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOT_SUBSTED))
  object_initdata_t _object_Kerror_not_substed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOT_SUPPORTED))
  object_initdata_t _object_Kerror_not_supported;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOT_SUPPORTED_ON_SBS))
  object_initdata_t _object_Kerror_not_supported_on_sbs;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOT_SUPPORTED_ON_STANDARD_SERVER))
  object_initdata_t _object_Kerror_not_supported_on_standard_server;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_ASSOCIATION))
  object_initdata_t _object_Kerror_no_association;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_BROWSER_SERVERS_FOUND))
  object_initdata_t _object_Kerror_no_browser_servers_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_DATA))
  object_initdata_t _object_Kerror_no_data;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_DATA_DETECTED))
  object_initdata_t _object_Kerror_no_data_detected;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_EFS))
  object_initdata_t _object_Kerror_no_efs;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_IMPERSONATION_TOKEN))
  object_initdata_t _object_Kerror_no_impersonation_token;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_INHERITANCE))
  object_initdata_t _object_Kerror_no_inheritance;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_LOGON_SERVERS))
  object_initdata_t _object_Kerror_no_logon_servers;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_LOG_SPACE))
  object_initdata_t _object_Kerror_no_log_space;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_MATCH))
  object_initdata_t _object_Kerror_no_match;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_MEDIA_IN_DRIVE))
  object_initdata_t _object_Kerror_no_media_in_drive;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_MORE_DEVICES))
  object_initdata_t _object_Kerror_no_more_devices;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_MORE_FILES))
  object_initdata_t _object_Kerror_no_more_files;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_MORE_ITEMS))
  object_initdata_t _object_Kerror_no_more_items;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_MORE_SEARCH_HANDLES))
  object_initdata_t _object_Kerror_no_more_search_handles;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_MORE_USER_HANDLES))
  object_initdata_t _object_Kerror_no_more_user_handles;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_NETWORK))
  object_initdata_t _object_Kerror_no_network;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_NET_OR_BAD_PATH))
  object_initdata_t _object_Kerror_no_net_or_bad_path;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_PROC_SLOTS))
  object_initdata_t _object_Kerror_no_proc_slots;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_PROMOTION_ACTIVE))
  object_initdata_t _object_Kerror_no_promotion_active;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_QUOTAS_FOR_ACCOUNT))
  object_initdata_t _object_Kerror_no_quotas_for_account;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_RECOVERY_POLICY))
  object_initdata_t _object_Kerror_no_recovery_policy;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_RECOVERY_PROGRAM))
  object_initdata_t _object_Kerror_no_recovery_program;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_SCROLLBARS))
  object_initdata_t _object_Kerror_no_scrollbars;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_SECURITY_ON_OBJECT))
  object_initdata_t _object_Kerror_no_security_on_object;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_SHUTDOWN_IN_PROGRESS))
  object_initdata_t _object_Kerror_no_shutdown_in_progress;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_SIGNAL_SENT))
  object_initdata_t _object_Kerror_no_signal_sent;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_SITENAME))
  object_initdata_t _object_Kerror_no_sitename;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_SPOOL_SPACE))
  object_initdata_t _object_Kerror_no_spool_space;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_SUCH_ALIAS))
  object_initdata_t _object_Kerror_no_such_alias;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_SUCH_DOMAIN))
  object_initdata_t _object_Kerror_no_such_domain;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_SUCH_GROUP))
  object_initdata_t _object_Kerror_no_such_group;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_SUCH_LOGON_SESSION))
  object_initdata_t _object_Kerror_no_such_logon_session;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_SUCH_MEMBER))
  object_initdata_t _object_Kerror_no_such_member;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_SUCH_PACKAGE))
  object_initdata_t _object_Kerror_no_such_package;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_SUCH_PRIVILEGE))
  object_initdata_t _object_Kerror_no_such_privilege;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_SUCH_SITE))
  object_initdata_t _object_Kerror_no_such_site;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_SUCH_USER))
  object_initdata_t _object_Kerror_no_such_user;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_SUPPORTING_DRIVES))
  object_initdata_t _object_Kerror_no_supporting_drives;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_SYSTEM_MENU))
  object_initdata_t _object_Kerror_no_system_menu;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_SYSTEM_RESOURCES))
  object_initdata_t _object_Kerror_no_system_resources;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_TOKEN))
  object_initdata_t _object_Kerror_no_token;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_TRACKING_SERVICE))
  object_initdata_t _object_Kerror_no_tracking_service;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_TRUST_LSA_SECRET))
  object_initdata_t _object_Kerror_no_trust_lsa_secret;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_TRUST_SAM_ACCOUNT))
  object_initdata_t _object_Kerror_no_trust_sam_account;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_UNICODE_TRANSLATION))
  object_initdata_t _object_Kerror_no_unicode_translation;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_USER_KEYS))
  object_initdata_t _object_Kerror_no_user_keys;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_USER_SESSION_KEY))
  object_initdata_t _object_Kerror_no_user_session_key;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_VOLUME_ID))
  object_initdata_t _object_Kerror_no_volume_id;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_VOLUME_LABEL))
  object_initdata_t _object_Kerror_no_volume_label;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_WILDCARD_CHARACTERS))
  object_initdata_t _object_Kerror_no_wildcard_characters;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NT_CROSS_ENCRYPTION_REQUIRED))
  object_initdata_t _object_Kerror_nt_cross_encryption_required;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NULL_LM_PASSWORD))
  object_initdata_t _object_Kerror_null_lm_password;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_OBJECT_ALREADY_EXISTS))
  object_initdata_t _object_Kerror_object_already_exists;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_OBJECT_IN_LIST))
  object_initdata_t _object_Kerror_object_in_list;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_OBJECT_NOT_FOUND))
  object_initdata_t _object_Kerror_object_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_OLD_WIN_VERSION))
  object_initdata_t _object_Kerror_old_win_version;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ONLY_IF_CONNECTED))
  object_initdata_t _object_Kerror_only_if_connected;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_OPEN_FAILED))
  object_initdata_t _object_Kerror_open_failed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_OPEN_FILES))
  object_initdata_t _object_Kerror_open_files;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_OPERATION_ABORTED))
  object_initdata_t _object_Kerror_operation_aborted;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_OPLOCK_NOT_GRANTED))
  object_initdata_t _object_Kerror_oplock_not_granted;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_OUTOFMEMORY))
  object_initdata_t _object_Kerror_outofmemory;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_OUT_OF_PAPER))
  object_initdata_t _object_Kerror_out_of_paper;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_OUT_OF_STRUCTURES))
  object_initdata_t _object_Kerror_out_of_structures;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_OVERRIDE_NOCHANGES))
  object_initdata_t _object_Kerror_override_nochanges;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PAGED_SYSTEM_RESOURCES))
  object_initdata_t _object_Kerror_paged_system_resources;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PAGEFILE_QUOTA))
  object_initdata_t _object_Kerror_pagefile_quota;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PARAMETER_QUOTA_EXCEEDED))
  object_initdata_t _object_Kerror_parameter_quota_exceeded;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PARTIAL_COPY))
  object_initdata_t _object_Kerror_partial_copy;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PARTITION_FAILURE))
  object_initdata_t _object_Kerror_partition_failure;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PASSWORD_EXPIRED))
  object_initdata_t _object_Kerror_password_expired;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PASSWORD_MUST_CHANGE))
  object_initdata_t _object_Kerror_password_must_change;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PASSWORD_RESTRICTION))
  object_initdata_t _object_Kerror_password_restriction;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PATCH_PACKAGE_INVALID))
  object_initdata_t _object_Kerror_patch_package_invalid;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PATCH_PACKAGE_OPEN_FAILED))
  object_initdata_t _object_Kerror_patch_package_open_failed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PATCH_PACKAGE_REJECTED))
  object_initdata_t _object_Kerror_patch_package_rejected;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PATCH_PACKAGE_UNSUPPORTED))
  object_initdata_t _object_Kerror_patch_package_unsupported;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PATCH_TARGET_NOT_FOUND))
  object_initdata_t _object_Kerror_patch_target_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PATH_BUSY))
  object_initdata_t _object_Kerror_path_busy;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PATH_NOT_FOUND))
  object_initdata_t _object_Kerror_path_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PER_USER_TRUST_QUOTA_EXCEEDED))
  object_initdata_t _object_Kerror_per_user_trust_quota_exceeded;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PIPE_BUSY))
  object_initdata_t _object_Kerror_pipe_busy;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PIPE_CONNECTED))
  object_initdata_t _object_Kerror_pipe_connected;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PIPE_LISTENING))
  object_initdata_t _object_Kerror_pipe_listening;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PIPE_NOT_CONNECTED))
  object_initdata_t _object_Kerror_pipe_not_connected;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PKINIT_FAILURE))
  object_initdata_t _object_Kerror_pkinit_failure;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_POINT_NOT_FOUND))
  object_initdata_t _object_Kerror_point_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_POLICY_OBJECT_NOT_FOUND))
  object_initdata_t _object_Kerror_policy_object_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_POLICY_ONLY_IN_DS))
  object_initdata_t _object_Kerror_policy_only_in_ds;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_POPUP_ALREADY_ACTIVE))
  object_initdata_t _object_Kerror_popup_already_active;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PORT_UNREACHABLE))
  object_initdata_t _object_Kerror_port_unreachable;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_POSSIBLE_DEADLOCK))
  object_initdata_t _object_Kerror_possible_deadlock;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_POTENTIAL_FILE_FOUND))
  object_initdata_t _object_Kerror_potential_file_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PRINTER_ALREADY_EXISTS))
  object_initdata_t _object_Kerror_printer_already_exists;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PRINTER_DELETED))
  object_initdata_t _object_Kerror_printer_deleted;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PRINTER_DRIVER_ALREADY_INSTALLED))
  object_initdata_t _object_Kerror_printer_driver_already_installed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PRINTER_DRIVER_BLOCKED))
  object_initdata_t _object_Kerror_printer_driver_blocked;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PRINTER_DRIVER_IN_USE))
  object_initdata_t _object_Kerror_printer_driver_in_use;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PRINTER_DRIVER_WARNED))
  object_initdata_t _object_Kerror_printer_driver_warned;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PRINTER_HAS_JOBS_QUEUED))
  object_initdata_t _object_Kerror_printer_has_jobs_queued;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PRINTER_NOT_FOUND))
  object_initdata_t _object_Kerror_printer_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PRINTQ_FULL))
  object_initdata_t _object_Kerror_printq_full;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PRINT_CANCELLED))
  object_initdata_t _object_Kerror_print_cancelled;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PRINT_MONITOR_ALREADY_INSTALLED))
  object_initdata_t _object_Kerror_print_monitor_already_installed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PRINT_MONITOR_IN_USE))
  object_initdata_t _object_Kerror_print_monitor_in_use;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PRINT_PROCESSOR_ALREADY_INSTALLED))
  object_initdata_t _object_Kerror_print_processor_already_installed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PRIVATE_DIALOG_INDEX))
  object_initdata_t _object_Kerror_private_dialog_index;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PRIVILEGE_NOT_HELD))
  object_initdata_t _object_Kerror_privilege_not_held;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PROCESS_ABORTED))
  object_initdata_t _object_Kerror_process_aborted;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PROC_NOT_FOUND))
  object_initdata_t _object_Kerror_proc_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PRODUCT_UNINSTALLED))
  object_initdata_t _object_Kerror_product_uninstalled;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PRODUCT_VERSION))
  object_initdata_t _object_Kerror_product_version;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PROFILE_NOT_ASSOCIATED_WITH_DEVICE))
  object_initdata_t _object_Kerror_profile_not_associated_with_device;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PROFILE_NOT_FOUND))
  object_initdata_t _object_Kerror_profile_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PROMOTION_ACTIVE))
  object_initdata_t _object_Kerror_promotion_active;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PROTOCOL_UNREACHABLE))
  object_initdata_t _object_Kerror_protocol_unreachable;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_QUORUMLOG_OPEN_FAILED))
  object_initdata_t _object_Kerror_quorumlog_open_failed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_QUORUM_DISK_NOT_FOUND))
  object_initdata_t _object_Kerror_quorum_disk_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_QUORUM_OWNER_ALIVE))
  object_initdata_t _object_Kerror_quorum_owner_alive;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_QUORUM_RESOURCE))
  object_initdata_t _object_Kerror_quorum_resource;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_QUORUM_RESOURCE_ONLINE_FAILED))
  object_initdata_t _object_Kerror_quorum_resource_online_failed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_READ_FAULT))
  object_initdata_t _object_Kerror_read_fault;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_RECOVERY_FAILURE))
  object_initdata_t _object_Kerror_recovery_failure;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_REC_NON_EXISTENT))
  object_initdata_t _object_Kerror_rec_non_existent;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_REDIRECTOR_HAS_OPEN_HANDLES))
  object_initdata_t _object_Kerror_redirector_has_open_handles;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_REDIR_PAUSED))
  object_initdata_t _object_Kerror_redir_paused;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_REGISTRY_CORRUPT))
  object_initdata_t _object_Kerror_registry_corrupt;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_REGISTRY_IO_FAILED))
  object_initdata_t _object_Kerror_registry_io_failed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_REGISTRY_RECOVERED))
  object_initdata_t _object_Kerror_registry_recovered;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_REG_NAT_CONSUMPTION))
  object_initdata_t _object_Kerror_reg_nat_consumption;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_RELOC_CHAIN_XEEDS_SEGLIM))
  object_initdata_t _object_Kerror_reloc_chain_xeeds_seglim;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_REMOTE_SESSION_LIMIT_EXCEEDED))
  object_initdata_t _object_Kerror_remote_session_limit_exceeded;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_REMOTE_STORAGE_MEDIA_ERROR))
  object_initdata_t _object_Kerror_remote_storage_media_error;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_REMOTE_STORAGE_NOT_ACTIVE))
  object_initdata_t _object_Kerror_remote_storage_not_active;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_REM_NOT_LIST))
  object_initdata_t _object_Kerror_rem_not_list;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_REPARSE_ATTRIBUTE_CONFLICT))
  object_initdata_t _object_Kerror_reparse_attribute_conflict;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_REPARSE_TAG_INVALID))
  object_initdata_t _object_Kerror_reparse_tag_invalid;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_REPARSE_TAG_MISMATCH))
  object_initdata_t _object_Kerror_reparse_tag_mismatch;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_REQUEST_ABORTED))
  object_initdata_t _object_Kerror_request_aborted;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_REQUEST_REFUSED))
  object_initdata_t _object_Kerror_request_refused;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_REQUIRES_INTERACTIVE_WINDOWSTATION))
  object_initdata_t _object_Kerror_requires_interactive_windowstation;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_REQ_NOT_ACCEP))
  object_initdata_t _object_Kerror_req_not_accep;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_RESMON_CREATE_FAILED))
  object_initdata_t _object_Kerror_resmon_create_failed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_RESMON_INVALID_STATE))
  object_initdata_t _object_Kerror_resmon_invalid_state;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_RESMON_ONLINE_FAILED))
  object_initdata_t _object_Kerror_resmon_online_failed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_RESOURCE_DATA_NOT_FOUND))
  object_initdata_t _object_Kerror_resource_data_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_RESOURCE_DISABLED))
  object_initdata_t _object_Kerror_resource_disabled;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_RESOURCE_FAILED))
  object_initdata_t _object_Kerror_resource_failed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_RESOURCE_LANG_NOT_FOUND))
  object_initdata_t _object_Kerror_resource_lang_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_RESOURCE_NAME_NOT_FOUND))
  object_initdata_t _object_Kerror_resource_name_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_RESOURCE_NOT_AVAILABLE))
  object_initdata_t _object_Kerror_resource_not_available;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_RESOURCE_NOT_FOUND))
  object_initdata_t _object_Kerror_resource_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_RESOURCE_NOT_ONLINE))
  object_initdata_t _object_Kerror_resource_not_online;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_RESOURCE_NOT_PRESENT))
  object_initdata_t _object_Kerror_resource_not_present;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_RESOURCE_ONLINE))
  object_initdata_t _object_Kerror_resource_online;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_RESOURCE_PROPERTIES_STORED))
  object_initdata_t _object_Kerror_resource_properties_stored;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_RESOURCE_PROPERTY_UNCHANGEABLE))
  object_initdata_t _object_Kerror_resource_property_unchangeable;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_RESOURCE_TYPE_NOT_FOUND))
  object_initdata_t _object_Kerror_resource_type_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_RETRY))
  object_initdata_t _object_Kerror_retry;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_REVISION_MISMATCH))
  object_initdata_t _object_Kerror_revision_mismatch;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_RING2SEG_MUST_BE_MOVABLE))
  object_initdata_t _object_Kerror_ring2seg_must_be_movable;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_RING2_STACK_IN_USE))
  object_initdata_t _object_Kerror_ring2_stack_in_use;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_RMODE_APP))
  object_initdata_t _object_Kerror_rmode_app;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_RPL_NOT_ALLOWED))
  object_initdata_t _object_Kerror_rpl_not_allowed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_RXACT_COMMIT_FAILURE))
  object_initdata_t _object_Kerror_rxact_commit_failure;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_RXACT_INVALID_STATE))
  object_initdata_t _object_Kerror_rxact_invalid_state;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SAME_DRIVE))
  object_initdata_t _object_Kerror_same_drive;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SAM_INIT_FAILURE))
  object_initdata_t _object_Kerror_sam_init_failure;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SCOPE_NOT_FOUND))
  object_initdata_t _object_Kerror_scope_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SCREEN_ALREADY_LOCKED))
  object_initdata_t _object_Kerror_screen_already_locked;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SECRET_TOO_LONG))
  object_initdata_t _object_Kerror_secret_too_long;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SECTOR_NOT_FOUND))
  object_initdata_t _object_Kerror_sector_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SEEK))
  object_initdata_t _object_Kerror_seek;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SEEK_ON_DEVICE))
  object_initdata_t _object_Kerror_seek_on_device;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SEM_IS_SET))
  object_initdata_t _object_Kerror_sem_is_set;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SEM_NOT_FOUND))
  object_initdata_t _object_Kerror_sem_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SEM_OWNER_DIED))
  object_initdata_t _object_Kerror_sem_owner_died;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SEM_TIMEOUT))
  object_initdata_t _object_Kerror_sem_timeout;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SEM_USER_LIMIT))
  object_initdata_t _object_Kerror_sem_user_limit;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SERIAL_NO_DEVICE))
  object_initdata_t _object_Kerror_serial_no_device;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SERVER_DISABLED))
  object_initdata_t _object_Kerror_server_disabled;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SERVER_HAS_OPEN_HANDLES))
  object_initdata_t _object_Kerror_server_has_open_handles;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SERVER_NOT_DISABLED))
  object_initdata_t _object_Kerror_server_not_disabled;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SERVER_SHUTDOWN_IN_PROGRESS))
  object_initdata_t _object_Kerror_server_shutdown_in_progress;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SERVICE_ALREADY_RUNNING))
  object_initdata_t _object_Kerror_service_already_running;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SERVICE_CANNOT_ACCEPT_CTRL))
  object_initdata_t _object_Kerror_service_cannot_accept_ctrl;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SERVICE_DATABASE_LOCKED))
  object_initdata_t _object_Kerror_service_database_locked;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SERVICE_DEPENDENCY_DELETED))
  object_initdata_t _object_Kerror_service_dependency_deleted;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SERVICE_DEPENDENCY_FAIL))
  object_initdata_t _object_Kerror_service_dependency_fail;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SERVICE_DISABLED))
  object_initdata_t _object_Kerror_service_disabled;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SERVICE_DOES_NOT_EXIST))
  object_initdata_t _object_Kerror_service_does_not_exist;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SERVICE_EXISTS))
  object_initdata_t _object_Kerror_service_exists;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SERVICE_LOGON_FAILED))
  object_initdata_t _object_Kerror_service_logon_failed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SERVICE_MARKED_FOR_DELETE))
  object_initdata_t _object_Kerror_service_marked_for_delete;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SERVICE_NEVER_STARTED))
  object_initdata_t _object_Kerror_service_never_started;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SERVICE_NOT_ACTIVE))
  object_initdata_t _object_Kerror_service_not_active;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SERVICE_NOT_FOUND))
  object_initdata_t _object_Kerror_service_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SERVICE_NOT_IN_EXE))
  object_initdata_t _object_Kerror_service_not_in_exe;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SERVICE_NO_THREAD))
  object_initdata_t _object_Kerror_service_no_thread;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SERVICE_REQUEST_TIMEOUT))
  object_initdata_t _object_Kerror_service_request_timeout;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SERVICE_SPECIFIC_ERROR))
  object_initdata_t _object_Kerror_service_specific_error;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SERVICE_START_HANG))
  object_initdata_t _object_Kerror_service_start_hang;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SESSION_CREDENTIAL_CONFLICT))
  object_initdata_t _object_Kerror_session_credential_conflict;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SETCOUNT_ON_BAD_LB))
  object_initdata_t _object_Kerror_setcount_on_bad_lb;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SETMARK_DETECTED))
  object_initdata_t _object_Kerror_setmark_detected;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SET_NOT_FOUND))
  object_initdata_t _object_Kerror_set_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SET_POWER_STATE_FAILED))
  object_initdata_t _object_Kerror_set_power_state_failed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SET_POWER_STATE_VETOED))
  object_initdata_t _object_Kerror_set_power_state_vetoed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SHARED_POLICY))
  object_initdata_t _object_Kerror_shared_policy;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SHARING_BUFFER_EXCEEDED))
  object_initdata_t _object_Kerror_sharing_buffer_exceeded;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SHARING_PAUSED))
  object_initdata_t _object_Kerror_sharing_paused;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SHARING_VIOLATION))
  object_initdata_t _object_Kerror_sharing_violation;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SHUTDOWN_CLUSTER))
  object_initdata_t _object_Kerror_shutdown_cluster;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SHUTDOWN_IN_PROGRESS))
  object_initdata_t _object_Kerror_shutdown_in_progress;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SIGNAL_PENDING))
  object_initdata_t _object_Kerror_signal_pending;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SIGNAL_REFUSED))
  object_initdata_t _object_Kerror_signal_refused;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SINGLE_INSTANCE_APP))
  object_initdata_t _object_Kerror_single_instance_app;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SMARTCARD_SUBSYSTEM_FAILURE))
  object_initdata_t _object_Kerror_smartcard_subsystem_failure;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SOME_NOT_MAPPED))
  object_initdata_t _object_Kerror_some_not_mapped;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SOURCE_ELEMENT_EMPTY))
  object_initdata_t _object_Kerror_source_element_empty;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SPECIAL_ACCOUNT))
  object_initdata_t _object_Kerror_special_account;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SPECIAL_GROUP))
  object_initdata_t _object_Kerror_special_group;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SPECIAL_USER))
  object_initdata_t _object_Kerror_special_user;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SPL_NO_ADDJOB))
  object_initdata_t _object_Kerror_spl_no_addjob;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SPL_NO_STARTDOC))
  object_initdata_t _object_Kerror_spl_no_startdoc;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SPOOL_FILE_NOT_FOUND))
  object_initdata_t _object_Kerror_spool_file_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_STACK_BUFFER_OVERRUN))
  object_initdata_t _object_Kerror_stack_buffer_overrun;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_STACK_OVERFLOW))
  object_initdata_t _object_Kerror_stack_overflow;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_STATIC_INIT))
  object_initdata_t _object_Kerror_static_init;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SUBST_TO_JOIN))
  object_initdata_t _object_Kerror_subst_to_join;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SUBST_TO_SUBST))
  object_initdata_t _object_Kerror_subst_to_subst;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SUCCESS_REBOOT_INITIATED))
  object_initdata_t _object_Kerror_success_reboot_initiated;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SUCCESS_REBOOT_REQUIRED))
  object_initdata_t _object_Kerror_success_reboot_required;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SUCCESS_RESTART_REQUIRED))
  object_initdata_t _object_Kerror_success_restart_required;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SWAPERROR))
  object_initdata_t _object_Kerror_swaperror;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_ACTIVATION_CONTEXT_DISABLED))
  object_initdata_t _object_Kerror_sxs_activation_context_disabled;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_ASSEMBLY_NOT_FOUND))
  object_initdata_t _object_Kerror_sxs_assembly_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_CANT_GEN_ACTCTX))
  object_initdata_t _object_Kerror_sxs_cant_gen_actctx;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_DUPLICATE_ASSEMBLY_NAME))
  object_initdata_t _object_Kerror_sxs_duplicate_assembly_name;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_DUPLICATE_CLSID))
  object_initdata_t _object_Kerror_sxs_duplicate_clsid;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_DUPLICATE_DLL_NAME))
  object_initdata_t _object_Kerror_sxs_duplicate_dll_name;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_DUPLICATE_IID))
  object_initdata_t _object_Kerror_sxs_duplicate_iid;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_DUPLICATE_PROGID))
  object_initdata_t _object_Kerror_sxs_duplicate_progid;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_DUPLICATE_TLBID))
  object_initdata_t _object_Kerror_sxs_duplicate_tlbid;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_DUPLICATE_WINDOWCLASS_NAME))
  object_initdata_t _object_Kerror_sxs_duplicate_windowclass_name;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_FILE_HASH_MISMATCH))
  object_initdata_t _object_Kerror_sxs_file_hash_mismatch;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_INVALID_ACTCTXDATA_FORMAT))
  object_initdata_t _object_Kerror_sxs_invalid_actctxdata_format;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_INVALID_ASSEMBLY_IDENTITY_ATTRIBUTE))
  object_initdata_t _object_Kerror_sxs_invalid_assembly_identity_attribute;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_INVALID_ASSEMBLY_IDENTITY_ATTRIBUTE_NAME))
  object_initdata_t _object_Kerror_sxs_invalid_assembly_identity_attribute_name;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_INVALID_XML_NAMESPACE_URI))
  object_initdata_t _object_Kerror_sxs_invalid_xml_namespace_uri;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_KEY_NOT_FOUND))
  object_initdata_t _object_Kerror_sxs_key_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_LEAF_MANIFEST_DEPENDENCY_NOT_INSTALLED))
  object_initdata_t _object_Kerror_sxs_leaf_manifest_dependency_not_installed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_MANIFEST_FORMAT_ERROR))
  object_initdata_t _object_Kerror_sxs_manifest_format_error;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_MANIFEST_INVALID_REQUIRED_DEFAULT_NAMESPACE))
  object_initdata_t _object_Kerror_sxs_manifest_invalid_required_default_namespace;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_MANIFEST_MISSING_REQUIRED_DEFAULT_NAMESPACE))
  object_initdata_t _object_Kerror_sxs_manifest_missing_required_default_namespace;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_MANIFEST_PARSE_ERROR))
  object_initdata_t _object_Kerror_sxs_manifest_parse_error;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_MISSING_ASSEMBLY_IDENTITY_ATTRIBUTE))
  object_initdata_t _object_Kerror_sxs_missing_assembly_identity_attribute;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_POLICY_PARSE_ERROR))
  object_initdata_t _object_Kerror_sxs_policy_parse_error;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_PRIVATE_MANIFEST_CROSS_PATH_WITH_REPARSE_POINT))
  object_initdata_t _object_Kerror_sxs_private_manifest_cross_path_with_reparse_point;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_PROCESS_DEFAULT_ALREADY_SET))
  object_initdata_t _object_Kerror_sxs_process_default_already_set;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_PROTECTION_CATALOG_FILE_MISSING))
  object_initdata_t _object_Kerror_sxs_protection_catalog_file_missing;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_PROTECTION_CATALOG_NOT_VALID))
  object_initdata_t _object_Kerror_sxs_protection_catalog_not_valid;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_PROTECTION_PUBLIC_KEY_TOO_SHORT))
  object_initdata_t _object_Kerror_sxs_protection_public_key_too_short;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_PROTECTION_RECOVERY_FAILED))
  object_initdata_t _object_Kerror_sxs_protection_recovery_failed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_ROOT_MANIFEST_DEPENDENCY_NOT_INSTALLED))
  object_initdata_t _object_Kerror_sxs_root_manifest_dependency_not_installed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_SECTION_NOT_FOUND))
  object_initdata_t _object_Kerror_sxs_section_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_THREAD_QUERIES_DISABLED))
  object_initdata_t _object_Kerror_sxs_thread_queries_disabled;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_UNKNOWN_ENCODING))
  object_initdata_t _object_Kerror_sxs_unknown_encoding;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_UNKNOWN_ENCODING_GROUP))
  object_initdata_t _object_Kerror_sxs_unknown_encoding_group;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_UNTRANSLATABLE_HRESULT))
  object_initdata_t _object_Kerror_sxs_untranslatable_hresult;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_VERSION_CONFLICT))
  object_initdata_t _object_Kerror_sxs_version_conflict;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_WRONG_SECTION_TYPE))
  object_initdata_t _object_Kerror_sxs_wrong_section_type;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_BADCHARDATA))
  object_initdata_t _object_Kerror_sxs_xml_e_badchardata;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_BADCHARINSTRING))
  object_initdata_t _object_Kerror_sxs_xml_e_badcharinstring;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_BADNAMECHAR))
  object_initdata_t _object_Kerror_sxs_xml_e_badnamechar;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_BADPEREFINSUBSET))
  object_initdata_t _object_Kerror_sxs_xml_e_badperefinsubset;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_BADSTARTNAMECHAR))
  object_initdata_t _object_Kerror_sxs_xml_e_badstartnamechar;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_BADXMLCASE))
  object_initdata_t _object_Kerror_sxs_xml_e_badxmlcase;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_BADXMLDECL))
  object_initdata_t _object_Kerror_sxs_xml_e_badxmldecl;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_COMMENTSYNTAX))
  object_initdata_t _object_Kerror_sxs_xml_e_commentsyntax;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_DUPLICATEATTRIBUTE))
  object_initdata_t _object_Kerror_sxs_xml_e_duplicateattribute;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_EXPECTINGCLOSEQUOTE))
  object_initdata_t _object_Kerror_sxs_xml_e_expectingclosequote;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_EXPECTINGTAGEND))
  object_initdata_t _object_Kerror_sxs_xml_e_expectingtagend;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_INCOMPLETE_ENCODING))
  object_initdata_t _object_Kerror_sxs_xml_e_incomplete_encoding;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_INTERNALERROR))
  object_initdata_t _object_Kerror_sxs_xml_e_internalerror;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_INVALIDATROOTLEVEL))
  object_initdata_t _object_Kerror_sxs_xml_e_invalidatrootlevel;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_INVALIDENCODING))
  object_initdata_t _object_Kerror_sxs_xml_e_invalidencoding;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_INVALIDSWITCH))
  object_initdata_t _object_Kerror_sxs_xml_e_invalidswitch;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_INVALID_DECIMAL))
  object_initdata_t _object_Kerror_sxs_xml_e_invalid_decimal;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_INVALID_HEXIDECIMAL))
  object_initdata_t _object_Kerror_sxs_xml_e_invalid_hexidecimal;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_INVALID_STANDALONE))
  object_initdata_t _object_Kerror_sxs_xml_e_invalid_standalone;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_INVALID_UNICODE))
  object_initdata_t _object_Kerror_sxs_xml_e_invalid_unicode;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_INVALID_VERSION))
  object_initdata_t _object_Kerror_sxs_xml_e_invalid_version;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_MISSINGEQUALS))
  object_initdata_t _object_Kerror_sxs_xml_e_missingequals;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_MISSINGQUOTE))
  object_initdata_t _object_Kerror_sxs_xml_e_missingquote;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_MISSINGROOT))
  object_initdata_t _object_Kerror_sxs_xml_e_missingroot;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_MISSINGSEMICOLON))
  object_initdata_t _object_Kerror_sxs_xml_e_missingsemicolon;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_MISSINGWHITESPACE))
  object_initdata_t _object_Kerror_sxs_xml_e_missingwhitespace;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_MISSING_PAREN))
  object_initdata_t _object_Kerror_sxs_xml_e_missing_paren;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_MULTIPLEROOTS))
  object_initdata_t _object_Kerror_sxs_xml_e_multipleroots;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_MULTIPLE_COLONS))
  object_initdata_t _object_Kerror_sxs_xml_e_multiple_colons;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_RESERVEDNAMESPACE))
  object_initdata_t _object_Kerror_sxs_xml_e_reservednamespace;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_UNBALANCEDPAREN))
  object_initdata_t _object_Kerror_sxs_xml_e_unbalancedparen;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_UNCLOSEDCDATA))
  object_initdata_t _object_Kerror_sxs_xml_e_unclosedcdata;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_UNCLOSEDCOMMENT))
  object_initdata_t _object_Kerror_sxs_xml_e_unclosedcomment;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_UNCLOSEDDECL))
  object_initdata_t _object_Kerror_sxs_xml_e_uncloseddecl;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_UNCLOSEDENDTAG))
  object_initdata_t _object_Kerror_sxs_xml_e_unclosedendtag;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_UNCLOSEDSTARTTAG))
  object_initdata_t _object_Kerror_sxs_xml_e_unclosedstarttag;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_UNCLOSEDSTRING))
  object_initdata_t _object_Kerror_sxs_xml_e_unclosedstring;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_UNCLOSEDTAG))
  object_initdata_t _object_Kerror_sxs_xml_e_unclosedtag;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_UNEXPECTEDENDTAG))
  object_initdata_t _object_Kerror_sxs_xml_e_unexpectedendtag;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_UNEXPECTEDEOF))
  object_initdata_t _object_Kerror_sxs_xml_e_unexpectedeof;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_UNEXPECTED_STANDALONE))
  object_initdata_t _object_Kerror_sxs_xml_e_unexpected_standalone;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_UNEXPECTED_WHITESPACE))
  object_initdata_t _object_Kerror_sxs_xml_e_unexpected_whitespace;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_WHITESPACEORQUESTIONMARK))
  object_initdata_t _object_Kerror_sxs_xml_e_whitespaceorquestionmark;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_XMLDECLSYNTAX))
  object_initdata_t _object_Kerror_sxs_xml_e_xmldeclsyntax;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SYNC_FOREGROUND_REFRESH_REQUIRED))
  object_initdata_t _object_Kerror_sync_foreground_refresh_required;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SYSTEM_TRACE))
  object_initdata_t _object_Kerror_system_trace;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_TAG_NOT_FOUND))
  object_initdata_t _object_Kerror_tag_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_TAG_NOT_PRESENT))
  object_initdata_t _object_Kerror_tag_not_present;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_THREAD_1_INACTIVE))
  object_initdata_t _object_Kerror_thread_1_inactive;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_TIMEOUT))
  object_initdata_t _object_Kerror_timeout;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_TIME_SKEW))
  object_initdata_t _object_Kerror_time_skew;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_TLW_WITH_WSCHILD))
  object_initdata_t _object_Kerror_tlw_with_wschild;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_TOKEN_ALREADY_IN_USE))
  object_initdata_t _object_Kerror_token_already_in_use;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_TOO_MANY_CMDS))
  object_initdata_t _object_Kerror_too_many_cmds;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_TOO_MANY_CONTEXT_IDS))
  object_initdata_t _object_Kerror_too_many_context_ids;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_TOO_MANY_LINKS))
  object_initdata_t _object_Kerror_too_many_links;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_TOO_MANY_LUIDS_REQUESTED))
  object_initdata_t _object_Kerror_too_many_luids_requested;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_TOO_MANY_MODULES))
  object_initdata_t _object_Kerror_too_many_modules;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_TOO_MANY_MUXWAITERS))
  object_initdata_t _object_Kerror_too_many_muxwaiters;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_TOO_MANY_NAMES))
  object_initdata_t _object_Kerror_too_many_names;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_TOO_MANY_OPEN_FILES))
  object_initdata_t _object_Kerror_too_many_open_files;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_TOO_MANY_POSTS))
  object_initdata_t _object_Kerror_too_many_posts;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_TOO_MANY_SECRETS))
  object_initdata_t _object_Kerror_too_many_secrets;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_TOO_MANY_SEMAPHORES))
  object_initdata_t _object_Kerror_too_many_semaphores;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_TOO_MANY_SEM_REQUESTS))
  object_initdata_t _object_Kerror_too_many_sem_requests;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_TOO_MANY_SESS))
  object_initdata_t _object_Kerror_too_many_sess;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_TOO_MANY_SIDS))
  object_initdata_t _object_Kerror_too_many_sids;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_TOO_MANY_TCBS))
  object_initdata_t _object_Kerror_too_many_tcbs;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_TRANSFORM_NOT_SUPPORTED))
  object_initdata_t _object_Kerror_transform_not_supported;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_TRANSPORT_FULL))
  object_initdata_t _object_Kerror_transport_full;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_TRUSTED_DOMAIN_FAILURE))
  object_initdata_t _object_Kerror_trusted_domain_failure;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_TRUSTED_RELATIONSHIP_FAILURE))
  object_initdata_t _object_Kerror_trusted_relationship_failure;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_TRUST_FAILURE))
  object_initdata_t _object_Kerror_trust_failure;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_UNABLE_TO_CLEAN))
  object_initdata_t _object_Kerror_unable_to_clean;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_UNABLE_TO_EJECT_MOUNTED_MEDIA))
  object_initdata_t _object_Kerror_unable_to_eject_mounted_media;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_UNABLE_TO_INVENTORY_DRIVE))
  object_initdata_t _object_Kerror_unable_to_inventory_drive;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_UNABLE_TO_INVENTORY_SLOT))
  object_initdata_t _object_Kerror_unable_to_inventory_slot;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_UNABLE_TO_INVENTORY_TRANSPORT))
  object_initdata_t _object_Kerror_unable_to_inventory_transport;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_UNABLE_TO_LOAD_MEDIUM))
  object_initdata_t _object_Kerror_unable_to_load_medium;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_UNABLE_TO_LOCK_MEDIA))
  object_initdata_t _object_Kerror_unable_to_lock_media;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_UNABLE_TO_MOVE_REPLACEMENT))
  object_initdata_t _object_Kerror_unable_to_move_replacement;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_UNABLE_TO_MOVE_REPLACEMENT_2))
  object_initdata_t _object_Kerror_unable_to_move_replacement_2;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_UNABLE_TO_REMOVE_REPLACED))
  object_initdata_t _object_Kerror_unable_to_remove_replaced;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_UNABLE_TO_UNLOAD_MEDIA))
  object_initdata_t _object_Kerror_unable_to_unload_media;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_UNEXPECTED_OMID))
  object_initdata_t _object_Kerror_unexpected_omid;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_UNEXP_NET_ERR))
  object_initdata_t _object_Kerror_unexp_net_err;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_UNKNOWN_COMPONENT))
  object_initdata_t _object_Kerror_unknown_component;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_UNKNOWN_FEATURE))
  object_initdata_t _object_Kerror_unknown_feature;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_UNKNOWN_PORT))
  object_initdata_t _object_Kerror_unknown_port;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_UNKNOWN_PRINTER_DRIVER))
  object_initdata_t _object_Kerror_unknown_printer_driver;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_UNKNOWN_PRINTPROCESSOR))
  object_initdata_t _object_Kerror_unknown_printprocessor;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_UNKNOWN_PRINT_MONITOR))
  object_initdata_t _object_Kerror_unknown_print_monitor;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_UNKNOWN_PRODUCT))
  object_initdata_t _object_Kerror_unknown_product;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_UNKNOWN_PROPERTY))
  object_initdata_t _object_Kerror_unknown_property;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_UNKNOWN_REVISION))
  object_initdata_t _object_Kerror_unknown_revision;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_UNRECOGNIZED_MEDIA))
  object_initdata_t _object_Kerror_unrecognized_media;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_UNRECOGNIZED_VOLUME))
  object_initdata_t _object_Kerror_unrecognized_volume;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_UNSUPPORTED_TYPE))
  object_initdata_t _object_Kerror_unsupported_type;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_USER_DELETE_TRUST_QUOTA_EXCEEDED))
  object_initdata_t _object_Kerror_user_delete_trust_quota_exceeded;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_USER_EXISTS))
  object_initdata_t _object_Kerror_user_exists;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_USER_MAPPED_FILE))
  object_initdata_t _object_Kerror_user_mapped_file;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_VC_DISCONNECTED))
  object_initdata_t _object_Kerror_vc_disconnected;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_VOLUME_CONTAINS_SYS_FILES))
  object_initdata_t _object_Kerror_volume_contains_sys_files;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_VOLUME_NOT_SIS_ENABLED))
  object_initdata_t _object_Kerror_volume_not_sis_enabled;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_VOLUME_NOT_SUPPORT_EFS))
  object_initdata_t _object_Kerror_volume_not_support_efs;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_WAIT_NO_CHILDREN))
  object_initdata_t _object_Kerror_wait_no_children;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_WINDOW_NOT_COMBOBOX))
  object_initdata_t _object_Kerror_window_not_combobox;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_WINDOW_NOT_DIALOG))
  object_initdata_t _object_Kerror_window_not_dialog;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_WINDOW_OF_OTHER_THREAD))
  object_initdata_t _object_Kerror_window_of_other_thread;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_WINS_INTERNAL))
  object_initdata_t _object_Kerror_wins_internal;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_WMI_ALREADY_DISABLED))
  object_initdata_t _object_Kerror_wmi_already_disabled;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_WMI_ALREADY_ENABLED))
  object_initdata_t _object_Kerror_wmi_already_enabled;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_WMI_DP_FAILED))
  object_initdata_t _object_Kerror_wmi_dp_failed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_WMI_DP_NOT_FOUND))
  object_initdata_t _object_Kerror_wmi_dp_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_WMI_GUID_DISCONNECTED))
  object_initdata_t _object_Kerror_wmi_guid_disconnected;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_WMI_GUID_NOT_FOUND))
  object_initdata_t _object_Kerror_wmi_guid_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_WMI_INSTANCE_NOT_FOUND))
  object_initdata_t _object_Kerror_wmi_instance_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_WMI_INVALID_MOF))
  object_initdata_t _object_Kerror_wmi_invalid_mof;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_WMI_INVALID_REGINFO))
  object_initdata_t _object_Kerror_wmi_invalid_reginfo;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_WMI_ITEMID_NOT_FOUND))
  object_initdata_t _object_Kerror_wmi_itemid_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_WMI_READ_ONLY))
  object_initdata_t _object_Kerror_wmi_read_only;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_WMI_SERVER_UNAVAILABLE))
  object_initdata_t _object_Kerror_wmi_server_unavailable;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_WMI_SET_FAILURE))
  object_initdata_t _object_Kerror_wmi_set_failure;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_WMI_TRY_AGAIN))
  object_initdata_t _object_Kerror_wmi_try_again;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_WMI_UNRESOLVED_INSTANCE_REF))
  object_initdata_t _object_Kerror_wmi_unresolved_instance_ref;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_WORKING_SET_QUOTA))
  object_initdata_t _object_Kerror_working_set_quota;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_WRITE_FAULT))
  object_initdata_t _object_Kerror_write_fault;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_WRITE_PROTECT))
  object_initdata_t _object_Kerror_write_protect;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_WRONG_DISK))
  object_initdata_t _object_Kerror_wrong_disk;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_WRONG_EFS))
  object_initdata_t _object_Kerror_wrong_efs;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_WRONG_PASSWORD))
  object_initdata_t _object_Kerror_wrong_password;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_WRONG_TARGET_NAME))
  object_initdata_t _object_Kerror_wrong_target_name;
#endif
#if defined(ESHUTDOWN)
  object_initdata_t _object_Keshutdown;
#endif
#if defined(ESOCKTNOSUPPORT)
  object_initdata_t _object_Kesocktnosupport;
#endif
#if defined(ESPIPE)
  object_initdata_t _object_Kespipe;
#endif
#if defined(ESRCH)
  object_initdata_t _object_Kesrch;
#endif
#if defined(ESRMNT)
  object_initdata_t _object_Kesrmnt;
#endif
#if defined(ESTALE)
  object_initdata_t _object_Kestale;
#endif
#if defined(ESTRPIPE)
  object_initdata_t _object_Kestrpipe;
#endif
#if defined(ETIME)
  object_initdata_t _object_Ketime;
#endif
#if defined(ETIMEDOUT)
  object_initdata_t _object_Ketimedout;
#endif
#if defined(ETOOMANYREFS)
  object_initdata_t _object_Ketoomanyrefs;
#endif
#if defined(ETXTBSY)
  object_initdata_t _object_Ketxtbsy;
#endif
#if defined(EUCLEAN)
  object_initdata_t _object_Keuclean;
#endif
#if defined(EUNATCH)
  object_initdata_t _object_Keunatch;
#endif
#if defined(EUSERS)
  object_initdata_t _object_Keusers;
#endif
#if defined(EVERSION)
  object_initdata_t _object_Keversion;
#endif
#if defined(EWOULDBLOCK)
  object_initdata_t _object_Kewouldblock;
#endif
#if (defined(HAVE_FCNTL)) && (defined(O_EXCL))
  object_initdata_t _object_Kexcl;
#endif
#if defined(EXDEV)
  object_initdata_t _object_Kexdev;
#endif
#if defined(EXFULL)
  object_initdata_t _object_Kexfull;
#endif
#if defined(HAVE_SYS_RESOURCE_H)
  object_initdata_t _object_Kexited;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_EXPR_NEST_MAX))
  object_initdata_t _object_Kexpr_nest_max;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  object_initdata_t _object_Kext;
#endif
  object_initdata_t _object_Kexternal_format;
#if (defined(HAVE_NFTW)) && (defined(FTW_F))
  object_initdata_t _object_Kf;
#endif
#if (defined(HAVE_SYSLOG)) && (defined(HAVE_OPENLOG))
  object_initdata_t _object_Kfacility;
#endif
#if defined(S_IFBLK)
  object_initdata_t _object_Kfblk;
#endif
#if defined(S_IFCHR)
  object_initdata_t _object_Kfchr;
#endif
#if (defined(HAVE_FCNTL)) && (defined(F_GETFD))
  object_initdata_t _object_Kfd;
#endif
#if defined(S_IFDIR)
  object_initdata_t _object_Kfdir;
#endif
#if defined(HAVE_NFTW)
  object_initdata_t _object_Kfd_limit;
#endif
#if defined(S_IFIFO)
  object_initdata_t _object_Kfifo;
#endif
#if (defined(HAVE_PATHCONF) && defined(HAVE_FPATHCONF)) && (defined(_PC_FILESIZEBITS))
  object_initdata_t _object_Kfilesizebits;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  object_initdata_t _object_Kfiletime;
#endif
#if (defined(WIN32_NATIVE) || (defined(HAVE_STATVFS) && defined(HAVE_SYS_STATVFS_H))) && (defined(FILE_NAMED_STREAMS))
  object_initdata_t _object_Kfile_named_streams;
#endif
#if (defined(WIN32_NATIVE) || (defined(HAVE_STATVFS) && defined(HAVE_SYS_STATVFS_H))) && (defined(FILE_READ_ONLY_VOLUME))
  object_initdata_t _object_Kfile_read_only_volume;
#endif
#if (defined(WIN32_NATIVE) || (defined(HAVE_STATVFS) && defined(HAVE_SYS_STATVFS_H))) && (defined(FILE_SUPPORTS_ENCRYPTION))
  object_initdata_t _object_Kfile_supports_encryption;
#endif
#if (defined(WIN32_NATIVE) || (defined(HAVE_STATVFS) && defined(HAVE_SYS_STATVFS_H))) && (defined(FILE_SUPPORTS_OBJECT_IDS))
  object_initdata_t _object_Kfile_supports_object_ids;
#endif
#if (defined(WIN32_NATIVE) || (defined(HAVE_STATVFS) && defined(HAVE_SYS_STATVFS_H))) && (defined(FILE_SUPPORTS_REPARSE_POINTS))
  object_initdata_t _object_Kfile_supports_reparse_points;
#endif
#if (defined(WIN32_NATIVE) || (defined(HAVE_STATVFS) && defined(HAVE_SYS_STATVFS_H))) && (defined(FILE_SUPPORTS_SPARSE_FILES))
  object_initdata_t _object_Kfile_supports_sparse_files;
#endif
#if (defined(WIN32_NATIVE) || (defined(HAVE_STATVFS) && defined(HAVE_SYS_STATVFS_H))) && (defined(FILE_VOLUME_QUOTAS))
  object_initdata_t _object_Kfile_volume_quotas;
#endif
#if (defined(HAVE_FCNTL)) && (defined(F_GETFL))
  object_initdata_t _object_Kfl;
#endif
#if defined(S_IFREG)
  object_initdata_t _object_Kfreg;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(FRS_ERR_AUTHENTICATION))
  object_initdata_t _object_Kfrs_err_authentication;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(FRS_ERR_CHILD_TO_PARENT_COMM))
  object_initdata_t _object_Kfrs_err_child_to_parent_comm;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(FRS_ERR_INSUFFICIENT_PRIV))
  object_initdata_t _object_Kfrs_err_insufficient_priv;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(FRS_ERR_INTERNAL))
  object_initdata_t _object_Kfrs_err_internal;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(FRS_ERR_INTERNAL_API))
  object_initdata_t _object_Kfrs_err_internal_api;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(FRS_ERR_INVALID_API_SEQUENCE))
  object_initdata_t _object_Kfrs_err_invalid_api_sequence;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(FRS_ERR_INVALID_SERVICE_PARAMETER))
  object_initdata_t _object_Kfrs_err_invalid_service_parameter;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(FRS_ERR_PARENT_AUTHENTICATION))
  object_initdata_t _object_Kfrs_err_parent_authentication;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(FRS_ERR_PARENT_INSUFFICIENT_PRIV))
  object_initdata_t _object_Kfrs_err_parent_insufficient_priv;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(FRS_ERR_PARENT_TO_CHILD_COMM))
  object_initdata_t _object_Kfrs_err_parent_to_child_comm;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(FRS_ERR_SERVICE_COMM))
  object_initdata_t _object_Kfrs_err_service_comm;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(FRS_ERR_STARTING_SERVICE))
  object_initdata_t _object_Kfrs_err_starting_service;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(FRS_ERR_STOPPING_SERVICE))
  object_initdata_t _object_Kfrs_err_stopping_service;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(FRS_ERR_SYSVOL_DEMOTE))
  object_initdata_t _object_Kfrs_err_sysvol_demote;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(FRS_ERR_SYSVOL_IS_BUSY))
  object_initdata_t _object_Kfrs_err_sysvol_is_busy;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(FRS_ERR_SYSVOL_POPULATE))
  object_initdata_t _object_Kfrs_err_sysvol_populate;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(FRS_ERR_SYSVOL_POPULATE_TIMEOUT))
  object_initdata_t _object_Kfrs_err_sysvol_populate_timeout;
#endif
#if (defined(HAVE_GETRLIMIT) || defined(HAVE_SETRLIMIT)) && (defined(RLIMIT_FSIZE))
  object_initdata_t _object_Kfsize;
#endif
#if defined(S_IFSOCK)
  object_initdata_t _object_Kfsock;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_FSYNC))
  object_initdata_t _object_Kfsync;
#endif
#if (defined(WIN32_NATIVE) || (defined(HAVE_STATVFS) && defined(HAVE_SYS_STATVFS_H))) && (defined(FS_CASE_IS_PRESERVED))
  object_initdata_t _object_Kfs_case_is_preserved;
#endif
#if (defined(WIN32_NATIVE) || (defined(HAVE_STATVFS) && defined(HAVE_SYS_STATVFS_H))) && (defined(FS_CASE_SENSITIVE))
  object_initdata_t _object_Kfs_case_sensitive;
#endif
#if (defined(WIN32_NATIVE) || (defined(HAVE_STATVFS) && defined(HAVE_SYS_STATVFS_H))) && (defined(FS_FILE_COMPRESSION))
  object_initdata_t _object_Kfs_file_compression;
#endif
#if (defined(WIN32_NATIVE) || (defined(HAVE_STATVFS) && defined(HAVE_SYS_STATVFS_H))) && (defined(FS_FILE_ENCRYPTION))
  object_initdata_t _object_Kfs_file_encryption;
#endif
#if (defined(WIN32_NATIVE) || (defined(HAVE_STATVFS) && defined(HAVE_SYS_STATVFS_H))) && (defined(FS_PERSISTENT_ACLS))
  object_initdata_t _object_Kfs_persistent_acls;
#endif
#if (defined(WIN32_NATIVE) || (defined(HAVE_STATVFS) && defined(HAVE_SYS_STATVFS_H))) && (defined(FS_UNICODE_STORED_ON_DISK))
  object_initdata_t _object_Kfs_unicode_stored_on_disk;
#endif
#if (defined(WIN32_NATIVE) || (defined(HAVE_STATVFS) && defined(HAVE_SYS_STATVFS_H))) && (defined(FS_VOL_IS_COMPRESSED))
  object_initdata_t _object_Kfs_vol_is_compressed;
#endif
#if (defined(HAVE_SYSLOG)) && (defined(LOG_FTP))
  object_initdata_t _object_Kftp;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_GETGR_R_SIZE_MAX))
  object_initdata_t _object_Kgetgr_r_size_max;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_GETPW_R_SIZE_MAX))
  object_initdata_t _object_Kgetpw_r_size_max;
#endif
#if defined(HAVE_STAT) && (defined(HAVE_CHMOD) || defined(HAVE_CHOWN) || defined(HAVE_UTIME))
  object_initdata_t _object_Kgid;
#endif
  object_initdata_t _object_Khardlink;
  object_initdata_t _object_Khardlink_or_copy;
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(FILE_ATTRIBUTE_HIDDEN))
  object_initdata_t _object_Khidden;
#endif
#if ((defined(WIN32_NATIVE)) && (defined(HIGH_PRIORITY_CLASS))) || (!(defined(WIN32_NATIVE)))
  object_initdata_t _object_Khigh;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_HOST_NAME_MAX))
  object_initdata_t _object_Khost_name_max;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  object_initdata_t _object_Khot_key;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  object_initdata_t _object_Ki1;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  object_initdata_t _object_Ki2;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  object_initdata_t _object_Ki4;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  object_initdata_t _object_Ki8;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(PROCESSOR_ARCHITECTURE_IA32_ON_WIN64))
  object_initdata_t _object_Kia32_on_win64;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(PROCESSOR_ARCHITECTURE_IA64))
  object_initdata_t _object_Kia64;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  object_initdata_t _object_Kicon;
#endif
#if ((defined(WIN32_NATIVE)) && (defined(IDLE_PRIORITY_CLASS))) || (!(defined(WIN32_NATIVE)))
  object_initdata_t _object_Kidle;
#endif
  object_initdata_t _object_Kif_does_not_exist;
  object_initdata_t _object_Kif_exists;
#if (defined(HAVE_SYSLOG)) && (defined(LOG_INFO))
  object_initdata_t _object_Kinfo;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  object_initdata_t _object_Kinitid;
#endif
#if (defined(HAVE_UTMPX_H)) && (defined(INIT_PROCESS))
  object_initdata_t _object_Kinit_process;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  object_initdata_t _object_Kint;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(PROCESSOR_ARCHITECTURE_INTEL))
  object_initdata_t _object_Kintel;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_IOV_MAX))
  object_initdata_t _object_Kiov_max;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_IPV6))
  object_initdata_t _object_Kipv6;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_JOB_CONTROL))
  object_initdata_t _object_Kjob_control;
#endif
#if (defined(HAVE_SYSLOG)) && (defined(LOG_KERN))
  object_initdata_t _object_Kkern;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  object_initdata_t _object_Kkeywords;
#endif
#if (defined(HAVE_FCNTL)) && (defined(O_LARGEFILE))
  object_initdata_t _object_Klargefile;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  object_initdata_t _object_Klastauthor;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  object_initdata_t _object_Klastprinted;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  object_initdata_t _object_Klastsave_dtm;
#endif
#if defined(HAVE_FCNTL) || defined(WIN32_NATIVE)
  object_initdata_t _object_Klength;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_LINE_MAX))
  object_initdata_t _object_Kline_max;
#endif
#if (defined(HAVE_PATHCONF) && defined(HAVE_FPATHCONF)) && (defined(_PC_LINK_MAX))
  object_initdata_t _object_Klink_max;
#endif
#if (defined(HAVE_SYSLOG)) && (defined(LOG_LOCAL0))
  object_initdata_t _object_Klocal0;
#endif
#if (defined(HAVE_SYSLOG)) && (defined(LOG_LOCAL1))
  object_initdata_t _object_Klocal1;
#endif
#if (defined(HAVE_SYSLOG)) && (defined(LOG_LOCAL2))
  object_initdata_t _object_Klocal2;
#endif
#if (defined(HAVE_SYSLOG)) && (defined(LOG_LOCAL3))
  object_initdata_t _object_Klocal3;
#endif
#if (defined(HAVE_SYSLOG)) && (defined(LOG_LOCAL4))
  object_initdata_t _object_Klocal4;
#endif
#if (defined(HAVE_SYSLOG)) && (defined(LOG_LOCAL5))
  object_initdata_t _object_Klocal5;
#endif
#if (defined(HAVE_SYSLOG)) && (defined(LOG_LOCAL6))
  object_initdata_t _object_Klocal6;
#endif
#if (defined(HAVE_SYSLOG)) && (defined(LOG_LOCAL7))
  object_initdata_t _object_Klocal7;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  object_initdata_t _object_Klocale;
#endif
#if (defined(HAVE_GETRLIMIT) || defined(HAVE_SETRLIMIT)) && (defined(RLIMIT_LOCKS))
  object_initdata_t _object_Klocks;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_LOGIN_NAME_MAX))
  object_initdata_t _object_Klogin_name_max;
#endif
#if (defined(HAVE_UTMPX_H)) && (defined(LOGIN_PROCESS))
  object_initdata_t _object_Klogin_process;
#endif
#if ((defined(WIN32_NATIVE)) && (defined(LOW_PRIORITY_CLASS))) || (!(defined(WIN32_NATIVE)))
  object_initdata_t _object_Klow;
#endif
#if (defined(HAVE_SYSLOG)) && (defined(LOG_LPR))
  object_initdata_t _object_Klpr;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  object_initdata_t _object_Klpstr;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  object_initdata_t _object_Klpwstr;
#endif
#if (defined(HAVE_SYS_RESOURCE_H)) && (defined(HAVE_GETRUSAGE)) && (defined(RUSAGE_LWP))
  object_initdata_t _object_Klwp;
#endif
#if (defined(HAVE_SYSLOG)) && (defined(LOG_MAIL))
  object_initdata_t _object_Kmail;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_MAPPED_FILES))
  object_initdata_t _object_Kmapped_files;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  object_initdata_t _object_Kmax;
#endif
#if (defined(HAVE_PATHCONF) && defined(HAVE_FPATHCONF)) && (defined(_PC_MAX_CANON))
  object_initdata_t _object_Kmax_canon;
#endif
#if (defined(HAVE_PATHCONF) && defined(HAVE_FPATHCONF)) && (defined(_PC_MAX_INPUT))
  object_initdata_t _object_Kmax_input;
#endif
#if ((defined(HAVE_SYSCONF)) && (defined(_SC_MEMLOCK))) || ((defined(HAVE_GETRLIMIT) || defined(HAVE_SETRLIMIT)) && (defined(RLIMIT_MEMLOCK)))
  object_initdata_t _object_Kmemlock;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_MEMLOCK_RANGE))
  object_initdata_t _object_Kmemlock_range;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_MEMORY_PROTECTION))
  object_initdata_t _object_Kmemory_protection;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_MESSAGE_PASSING))
  object_initdata_t _object_Kmessage_passing;
#endif
  object_initdata_t _object_Kmethod;
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  object_initdata_t _object_Kmin;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(PROCESSOR_ARCHITECTURE_MIPS))
  object_initdata_t _object_Kmips;
#endif
#if defined(HAVE_STAT) && (defined(HAVE_CHMOD) || defined(HAVE_CHOWN) || defined(HAVE_UTIME))
  object_initdata_t _object_Kmode;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_MONOTONIC_CLOCK))
  object_initdata_t _object_Kmonotonic_clock;
#endif
#if defined(HAVE_NFTW)
  object_initdata_t _object_Kmount;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_MQ_OPEN_MAX))
  object_initdata_t _object_Kmq_open_max;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_MQ_PRIO_MAX))
  object_initdata_t _object_Kmq_prio_max;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(PROCESSOR_ARCHITECTURE_MSIL))
  object_initdata_t _object_Kmsil;
#endif
#if defined(HAVE_STAT) && (defined(HAVE_CHMOD) || defined(HAVE_CHOWN) || defined(HAVE_UTIME))
  object_initdata_t _object_Kmtime;
#endif
#if (defined(HAVE_PATHCONF) && defined(HAVE_FPATHCONF)) && (defined(_PC_NAME_MAX))
  object_initdata_t _object_Kname_max;
#endif
#if (defined(HAVE_SYSLOG)) && (defined(HAVE_OPENLOG))
  object_initdata_t _object_Kndelay;
#endif
#if (defined(HAVE_SYSLOG)) && (defined(LOG_NEWS))
  object_initdata_t _object_Knews;
#endif
#if (defined(HAVE_UTMPX_H)) && (defined(NEW_TIME))
  object_initdata_t _object_Knew_time;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_NGROUPS_MAX))
  object_initdata_t _object_Kngroups_max;
#endif
#if (defined(HAVE_FCNTL)) && (defined(O_NOCTTY))
  object_initdata_t _object_Knoctty;
#endif
  object_initdata_t _object_Knoescape;
#if (defined(HAVE_GETRLIMIT) || defined(HAVE_SETRLIMIT)) && (defined(RLIMIT_NOFILE))
  object_initdata_t _object_Knofile;
#endif
#if (defined(HAVE_FCNTL)) && (defined(O_NOFOLLOW))
  object_initdata_t _object_Knofollow;
#endif
#if defined(HAVE_SYS_RESOURCE_H)
  object_initdata_t _object_Knohang;
#endif
#if (defined(HAVE_FCNTL)) && (defined(O_NOINHERIT))
  object_initdata_t _object_Knoinherit;
#endif
#if (defined(HAVE_FCNTL)) && (defined(O_NONBLOCK))
  object_initdata_t _object_Knonblock;
#endif
#if ((defined(WIN32_NATIVE)) && (defined(NORMAL_PRIORITY_CLASS))) || (!(defined(WIN32_NATIVE))) || ((defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(FILE_ATTRIBUTE_NORMAL)))
  object_initdata_t _object_Knormal;
#endif
#if (defined(HAVE_SYSLOG)) && (defined(LOG_NOTICE))
  object_initdata_t _object_Knotice;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  object_initdata_t _object_Knotimplemented;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(FILE_ATTRIBUTE_NOT_CONTENT_INDEXED))
  object_initdata_t _object_Knot_content_indexed;
#endif
#if ((defined(HAVE_SYSLOG)) && (defined(HAVE_OPENLOG))) || (defined(HAVE_SYS_RESOURCE_H))
  object_initdata_t _object_Knowait;
#endif
#if (defined(HAVE_PATHCONF) && defined(HAVE_FPATHCONF)) && (defined(_PC_NO_TRUNC))
  object_initdata_t _object_Kno_trunc;
#endif
#if (defined(HAVE_GETRLIMIT) || defined(HAVE_SETRLIMIT)) && (defined(RLIMIT_NPROC))
  object_initdata_t _object_Knproc;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_NPROCESSORS_CONF))
  object_initdata_t _object_Knprocessors_conf;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_NPROCESSORS_ONLN))
  object_initdata_t _object_Knprocessors_onln;
#endif
#if (defined(HAVE_NFTW)) && (defined(FTW_NS))
  object_initdata_t _object_Kns;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  object_initdata_t _object_Knt;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  object_initdata_t _object_Knull;
#endif
#if (defined(HAVE_SYSLOG)) && (defined(HAVE_OPENLOG))
  object_initdata_t _object_Kodelay;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(FILE_ATTRIBUTE_OFFLINE))
  object_initdata_t _object_Koffline;
#endif
#if (defined(HAVE_UTMPX_H)) && (defined(OLD_TIME))
  object_initdata_t _object_Kold_time;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_OPEN_MAX))
  object_initdata_t _object_Kopen_max;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(OR_INVALID_OID))
  object_initdata_t _object_Kor_invalid_oid;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(OR_INVALID_OXID))
  object_initdata_t _object_Kor_invalid_oxid;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(OR_INVALID_SET))
  object_initdata_t _object_Kor_invalid_set;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  object_initdata_t _object_Kpagecount;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_PAGESIZE))
  object_initdata_t _object_Kpagesize;
#endif
#if ((defined(HAVE_CONFSTR)) && (defined(_CS_PATH))) || (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN))
  object_initdata_t _object_Kpath;
#endif
  object_initdata_t _object_Kpathname;
#if (defined(HAVE_PATHCONF) && defined(HAVE_FPATHCONF)) && (defined(_PC_PATH_MAX))
  object_initdata_t _object_Kpath_max;
#endif
  object_initdata_t _object_Kperiod;
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  object_initdata_t _object_Kpersonal;
#endif
#if defined(PRIO_PGRP)
  object_initdata_t _object_Kpgrp;
#endif
#if defined(HAVE_NFTW)
  object_initdata_t _object_Kphys;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_PHYS_PAGES))
  object_initdata_t _object_Kphys_pages;
#endif
#if ((defined(HAVE_SYSLOG)) && (defined(HAVE_OPENLOG))) || (defined(HAVE_SYS_RESOURCE_H))
  object_initdata_t _object_Kpid;
#endif
#if (defined(HAVE_PATHCONF) && defined(HAVE_FPATHCONF)) && (defined(_PC_PIPE_BUF))
  object_initdata_t _object_Kpipe_buf;
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_POSIX_V6_ILP32_OFF32_CFLAGS))
  object_initdata_t _object_Kposix_v6_ilp32_off32_cflags;
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_POSIX_V6_ILP32_OFF32_LDFLAGS))
  object_initdata_t _object_Kposix_v6_ilp32_off32_ldflags;
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_POSIX_V6_ILP32_OFF32_LIBS))
  object_initdata_t _object_Kposix_v6_ilp32_off32_libs;
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_POSIX_V6_ILP32_OFFBIG_CFLAGS))
  object_initdata_t _object_Kposix_v6_ilp32_offbig_cflags;
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_POSIX_V6_ILP32_OFFBIG_LDFLAGS))
  object_initdata_t _object_Kposix_v6_ilp32_offbig_ldflags;
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_POSIX_V6_ILP32_OFFBIG_LIBS))
  object_initdata_t _object_Kposix_v6_ilp32_offbig_libs;
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_POSIX_V6_LP64_OFF64_CFLAGS))
  object_initdata_t _object_Kposix_v6_lp64_off64_cflags;
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_POSIX_V6_LP64_OFF64_LDFLAGS))
  object_initdata_t _object_Kposix_v6_lp64_off64_ldflags;
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_POSIX_V6_LP64_OFF64_LIBS))
  object_initdata_t _object_Kposix_v6_lp64_off64_libs;
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_POSIX_V6_LPBIG_OFFBIG_CFLAGS))
  object_initdata_t _object_Kposix_v6_lpbig_offbig_cflags;
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_POSIX_V6_LPBIG_OFFBIG_LDFLAGS))
  object_initdata_t _object_Kposix_v6_lpbig_offbig_ldflags;
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_POSIX_V6_LPBIG_OFFBIG_LIBS))
  object_initdata_t _object_Kposix_v6_lpbig_offbig_libs;
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_POSIX_V6_WIDTH_RESTRICTED_ENVS))
  object_initdata_t _object_Kposix_v6_width_restricted_envs;
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_POSIX_V7_ILP32_OFF32_CFLAGS))
  object_initdata_t _object_Kposix_v7_ilp32_off32_cflags;
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_POSIX_V7_ILP32_OFF32_LDFLAGS))
  object_initdata_t _object_Kposix_v7_ilp32_off32_ldflags;
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_POSIX_V7_ILP32_OFF32_LIBS))
  object_initdata_t _object_Kposix_v7_ilp32_off32_libs;
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_POSIX_V7_ILP32_OFFBIG_CFLAGS))
  object_initdata_t _object_Kposix_v7_ilp32_offbig_cflags;
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_POSIX_V7_ILP32_OFFBIG_LDFLAGS))
  object_initdata_t _object_Kposix_v7_ilp32_offbig_ldflags;
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_POSIX_V7_ILP32_OFFBIG_LIBS))
  object_initdata_t _object_Kposix_v7_ilp32_offbig_libs;
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_POSIX_V7_LP64_OFF64_CFLAGS))
  object_initdata_t _object_Kposix_v7_lp64_off64_cflags;
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_POSIX_V7_LP64_OFF64_LDFLAGS))
  object_initdata_t _object_Kposix_v7_lp64_off64_ldflags;
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_POSIX_V7_LP64_OFF64_LIBS))
  object_initdata_t _object_Kposix_v7_lp64_off64_libs;
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_POSIX_V7_LPBIG_OFFBIG_CFLAGS))
  object_initdata_t _object_Kposix_v7_lpbig_offbig_cflags;
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_POSIX_V7_LPBIG_OFFBIG_LDFLAGS))
  object_initdata_t _object_Kposix_v7_lpbig_offbig_ldflags;
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_POSIX_V7_LPBIG_OFFBIG_LIBS))
  object_initdata_t _object_Kposix_v7_lpbig_offbig_libs;
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_POSIX_V7_THREADS_CFLAGS))
  object_initdata_t _object_Kposix_v7_threads_cflags;
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_POSIX_V7_THREADS_LDFLAGS))
  object_initdata_t _object_Kposix_v7_threads_ldflags;
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_POSIX_V7_WIDTH_RESTRICTED_ENVS))
  object_initdata_t _object_Kposix_v7_width_restricted_envs;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(PROCESSOR_ARCHITECTURE_PPC))
  object_initdata_t _object_Kppc;
#endif
  object_initdata_t _object_Kpreserve;
#if (defined(HAVE_SYSCONF)) && (defined(_SC_PRIORITIZED_IO))
  object_initdata_t _object_Kprioritized_io;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_PRIORITY_SCHEDULING))
  object_initdata_t _object_Kpriority_scheduling;
#endif
#if (defined(HAVE_PATHCONF) && defined(HAVE_FPATHCONF)) && (defined(_PC_PRIO_IO))
  object_initdata_t _object_Kprio_io;
#endif
#if defined(PRIO_PROCESS)
  object_initdata_t _object_Kprocess;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  object_initdata_t _object_Kr4;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  object_initdata_t _object_Kr8;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_RAW_SOCKETS))
  object_initdata_t _object_Kraw_sockets;
#endif
#if defined(HAVE_FCNTL)
  object_initdata_t _object_Krdonly;
#endif
#if defined(HAVE_FCNTL)
  object_initdata_t _object_Krdwr;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_READER_WRITER_LOCKS))
  object_initdata_t _object_Kreader_writer_locks;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(FILE_ATTRIBUTE_READONLY))
  object_initdata_t _object_Kreadonly;
#endif
#if ((defined(WIN32_NATIVE)) && (defined(REALTIME_PRIORITY_CLASS))) || (!(defined(WIN32_NATIVE)))
  object_initdata_t _object_Krealtime;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_REALTIME_SIGNALS))
  object_initdata_t _object_Krealtime_signals;
#endif
#if (defined(HAVE_PATHCONF) && defined(HAVE_FPATHCONF)) && (defined(_PC_REC_INCR_XFER_SIZE))
  object_initdata_t _object_Krec_incr_xfer_size;
#endif
#if (defined(HAVE_PATHCONF) && defined(HAVE_FPATHCONF)) && (defined(_PC_REC_MAX_XFER_SIZE))
  object_initdata_t _object_Krec_max_xfer_size;
#endif
#if (defined(HAVE_PATHCONF) && defined(HAVE_FPATHCONF)) && (defined(_PC_REC_MIN_XFER_SIZE))
  object_initdata_t _object_Krec_min_xfer_size;
#endif
#if (defined(HAVE_PATHCONF) && defined(HAVE_FPATHCONF)) && (defined(_PC_REC_XFER_ALIGN))
  object_initdata_t _object_Krec_xfer_align;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_REGEXP))
  object_initdata_t _object_Kregexp;
#endif
  object_initdata_t _object_Krename;
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(FILE_ATTRIBUTE_REPARSE_POINT))
  object_initdata_t _object_Kreparse_point;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  object_initdata_t _object_Krevnumber;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_RE_DUP_MAX))
  object_initdata_t _object_Kre_dup_max;
#endif
#if defined(S_IRGRP)
  object_initdata_t _object_Krgrp;
#endif
#if defined(S_IROTH)
  object_initdata_t _object_Kroth;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_ADDRESS_ERROR))
  object_initdata_t _object_Krpc_s_address_error;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_ALREADY_LISTENING))
  object_initdata_t _object_Krpc_s_already_listening;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_ALREADY_REGISTERED))
  object_initdata_t _object_Krpc_s_already_registered;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_BINDING_HAS_NO_AUTH))
  object_initdata_t _object_Krpc_s_binding_has_no_auth;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_BINDING_INCOMPLETE))
  object_initdata_t _object_Krpc_s_binding_incomplete;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_CALL_CANCELLED))
  object_initdata_t _object_Krpc_s_call_cancelled;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_CALL_FAILED))
  object_initdata_t _object_Krpc_s_call_failed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_CALL_FAILED_DNE))
  object_initdata_t _object_Krpc_s_call_failed_dne;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_CALL_IN_PROGRESS))
  object_initdata_t _object_Krpc_s_call_in_progress;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_CANNOT_SUPPORT))
  object_initdata_t _object_Krpc_s_cannot_support;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_CANT_CREATE_ENDPOINT))
  object_initdata_t _object_Krpc_s_cant_create_endpoint;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_COMM_FAILURE))
  object_initdata_t _object_Krpc_s_comm_failure;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_DUPLICATE_ENDPOINT))
  object_initdata_t _object_Krpc_s_duplicate_endpoint;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_ENTRY_ALREADY_EXISTS))
  object_initdata_t _object_Krpc_s_entry_already_exists;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_ENTRY_NOT_FOUND))
  object_initdata_t _object_Krpc_s_entry_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_ENTRY_TYPE_MISMATCH))
  object_initdata_t _object_Krpc_s_entry_type_mismatch;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_FP_DIV_ZERO))
  object_initdata_t _object_Krpc_s_fp_div_zero;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_FP_OVERFLOW))
  object_initdata_t _object_Krpc_s_fp_overflow;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_FP_UNDERFLOW))
  object_initdata_t _object_Krpc_s_fp_underflow;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_GROUP_MEMBER_NOT_FOUND))
  object_initdata_t _object_Krpc_s_group_member_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_GRP_ELT_NOT_ADDED))
  object_initdata_t _object_Krpc_s_grp_elt_not_added;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_GRP_ELT_NOT_REMOVED))
  object_initdata_t _object_Krpc_s_grp_elt_not_removed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_INCOMPLETE_NAME))
  object_initdata_t _object_Krpc_s_incomplete_name;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_INTERFACE_NOT_EXPORTED))
  object_initdata_t _object_Krpc_s_interface_not_exported;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_INTERFACE_NOT_FOUND))
  object_initdata_t _object_Krpc_s_interface_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_INTERNAL_ERROR))
  object_initdata_t _object_Krpc_s_internal_error;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_INVALID_ASYNC_CALL))
  object_initdata_t _object_Krpc_s_invalid_async_call;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_INVALID_ASYNC_HANDLE))
  object_initdata_t _object_Krpc_s_invalid_async_handle;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_INVALID_AUTH_IDENTITY))
  object_initdata_t _object_Krpc_s_invalid_auth_identity;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_INVALID_BINDING))
  object_initdata_t _object_Krpc_s_invalid_binding;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_INVALID_BOUND))
  object_initdata_t _object_Krpc_s_invalid_bound;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_INVALID_ENDPOINT_FORMAT))
  object_initdata_t _object_Krpc_s_invalid_endpoint_format;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_INVALID_NAF_ID))
  object_initdata_t _object_Krpc_s_invalid_naf_id;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_INVALID_NAME_SYNTAX))
  object_initdata_t _object_Krpc_s_invalid_name_syntax;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_INVALID_NETWORK_OPTIONS))
  object_initdata_t _object_Krpc_s_invalid_network_options;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_INVALID_NET_ADDR))
  object_initdata_t _object_Krpc_s_invalid_net_addr;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_INVALID_OBJECT))
  object_initdata_t _object_Krpc_s_invalid_object;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_INVALID_RPC_PROTSEQ))
  object_initdata_t _object_Krpc_s_invalid_rpc_protseq;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_INVALID_STRING_BINDING))
  object_initdata_t _object_Krpc_s_invalid_string_binding;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_INVALID_STRING_UUID))
  object_initdata_t _object_Krpc_s_invalid_string_uuid;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_INVALID_TAG))
  object_initdata_t _object_Krpc_s_invalid_tag;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_INVALID_TIMEOUT))
  object_initdata_t _object_Krpc_s_invalid_timeout;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_INVALID_VERS_OPTION))
  object_initdata_t _object_Krpc_s_invalid_vers_option;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_MAX_CALLS_TOO_SMALL))
  object_initdata_t _object_Krpc_s_max_calls_too_small;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_NAME_SERVICE_UNAVAILABLE))
  object_initdata_t _object_Krpc_s_name_service_unavailable;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_NOTHING_TO_EXPORT))
  object_initdata_t _object_Krpc_s_nothing_to_export;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_NOT_ALL_OBJS_EXPORTED))
  object_initdata_t _object_Krpc_s_not_all_objs_exported;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_NOT_ALL_OBJS_UNEXPORTED))
  object_initdata_t _object_Krpc_s_not_all_objs_unexported;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_NOT_CANCELLED))
  object_initdata_t _object_Krpc_s_not_cancelled;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_NOT_LISTENING))
  object_initdata_t _object_Krpc_s_not_listening;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_NOT_RPC_ERROR))
  object_initdata_t _object_Krpc_s_not_rpc_error;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_NO_BINDINGS))
  object_initdata_t _object_Krpc_s_no_bindings;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_NO_CALL_ACTIVE))
  object_initdata_t _object_Krpc_s_no_call_active;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_NO_CONTEXT_AVAILABLE))
  object_initdata_t _object_Krpc_s_no_context_available;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_NO_ENDPOINT_FOUND))
  object_initdata_t _object_Krpc_s_no_endpoint_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_NO_ENTRY_NAME))
  object_initdata_t _object_Krpc_s_no_entry_name;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_NO_INTERFACES))
  object_initdata_t _object_Krpc_s_no_interfaces;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_NO_MORE_BINDINGS))
  object_initdata_t _object_Krpc_s_no_more_bindings;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_NO_MORE_MEMBERS))
  object_initdata_t _object_Krpc_s_no_more_members;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_NO_PRINC_NAME))
  object_initdata_t _object_Krpc_s_no_princ_name;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_NO_PROTSEQS))
  object_initdata_t _object_Krpc_s_no_protseqs;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_NO_PROTSEQS_REGISTERED))
  object_initdata_t _object_Krpc_s_no_protseqs_registered;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_OBJECT_NOT_FOUND))
  object_initdata_t _object_Krpc_s_object_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_OUT_OF_RESOURCES))
  object_initdata_t _object_Krpc_s_out_of_resources;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_PRF_ELT_NOT_ADDED))
  object_initdata_t _object_Krpc_s_prf_elt_not_added;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_PRF_ELT_NOT_REMOVED))
  object_initdata_t _object_Krpc_s_prf_elt_not_removed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_PROCNUM_OUT_OF_RANGE))
  object_initdata_t _object_Krpc_s_procnum_out_of_range;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_PROFILE_NOT_ADDED))
  object_initdata_t _object_Krpc_s_profile_not_added;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_PROTOCOL_ERROR))
  object_initdata_t _object_Krpc_s_protocol_error;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_PROTSEQ_NOT_FOUND))
  object_initdata_t _object_Krpc_s_protseq_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_PROTSEQ_NOT_SUPPORTED))
  object_initdata_t _object_Krpc_s_protseq_not_supported;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_SEC_PKG_ERROR))
  object_initdata_t _object_Krpc_s_sec_pkg_error;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_SEND_INCOMPLETE))
  object_initdata_t _object_Krpc_s_send_incomplete;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_SERVER_TOO_BUSY))
  object_initdata_t _object_Krpc_s_server_too_busy;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_SERVER_UNAVAILABLE))
  object_initdata_t _object_Krpc_s_server_unavailable;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_STRING_TOO_LONG))
  object_initdata_t _object_Krpc_s_string_too_long;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_TYPE_ALREADY_REGISTERED))
  object_initdata_t _object_Krpc_s_type_already_registered;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_UNKNOWN_AUTHN_LEVEL))
  object_initdata_t _object_Krpc_s_unknown_authn_level;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_UNKNOWN_AUTHN_SERVICE))
  object_initdata_t _object_Krpc_s_unknown_authn_service;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_UNKNOWN_AUTHN_TYPE))
  object_initdata_t _object_Krpc_s_unknown_authn_type;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_UNKNOWN_AUTHZ_SERVICE))
  object_initdata_t _object_Krpc_s_unknown_authz_service;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_UNKNOWN_IF))
  object_initdata_t _object_Krpc_s_unknown_if;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_UNKNOWN_MGR_TYPE))
  object_initdata_t _object_Krpc_s_unknown_mgr_type;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_UNSUPPORTED_AUTHN_LEVEL))
  object_initdata_t _object_Krpc_s_unsupported_authn_level;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_UNSUPPORTED_NAME_SYNTAX))
  object_initdata_t _object_Krpc_s_unsupported_name_syntax;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_UNSUPPORTED_TRANS_SYN))
  object_initdata_t _object_Krpc_s_unsupported_trans_syn;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_UNSUPPORTED_TYPE))
  object_initdata_t _object_Krpc_s_unsupported_type;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_UUID_LOCAL_ONLY))
  object_initdata_t _object_Krpc_s_uuid_local_only;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_UUID_NO_ADDRESS))
  object_initdata_t _object_Krpc_s_uuid_no_address;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_WRONG_KIND_OF_BINDING))
  object_initdata_t _object_Krpc_s_wrong_kind_of_binding;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_ZERO_DIVIDE))
  object_initdata_t _object_Krpc_s_zero_divide;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_X_BAD_STUB_DATA))
  object_initdata_t _object_Krpc_x_bad_stub_data;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_X_BYTE_COUNT_TOO_SMALL))
  object_initdata_t _object_Krpc_x_byte_count_too_small;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_X_ENUM_VALUE_OUT_OF_RANGE))
  object_initdata_t _object_Krpc_x_enum_value_out_of_range;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_X_INVALID_ES_ACTION))
  object_initdata_t _object_Krpc_x_invalid_es_action;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_X_INVALID_PIPE_OBJECT))
  object_initdata_t _object_Krpc_x_invalid_pipe_object;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_X_NO_MORE_ENTRIES))
  object_initdata_t _object_Krpc_x_no_more_entries;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_X_NULL_REF_POINTER))
  object_initdata_t _object_Krpc_x_null_ref_pointer;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_X_PIPE_CLOSED))
  object_initdata_t _object_Krpc_x_pipe_closed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_X_PIPE_DISCIPLINE_ERROR))
  object_initdata_t _object_Krpc_x_pipe_discipline_error;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_X_PIPE_EMPTY))
  object_initdata_t _object_Krpc_x_pipe_empty;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_X_SS_CANNOT_GET_CALL_HANDLE))
  object_initdata_t _object_Krpc_x_ss_cannot_get_call_handle;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_X_SS_CHAR_TRANS_OPEN_FAIL))
  object_initdata_t _object_Krpc_x_ss_char_trans_open_fail;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_X_SS_CHAR_TRANS_SHORT_FILE))
  object_initdata_t _object_Krpc_x_ss_char_trans_short_file;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_X_SS_CONTEXT_DAMAGED))
  object_initdata_t _object_Krpc_x_ss_context_damaged;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_X_SS_HANDLES_MISMATCH))
  object_initdata_t _object_Krpc_x_ss_handles_mismatch;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_X_SS_IN_NULL_CONTEXT))
  object_initdata_t _object_Krpc_x_ss_in_null_context;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_X_WRONG_ES_VERSION))
  object_initdata_t _object_Krpc_x_wrong_es_version;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_X_WRONG_PIPE_ORDER))
  object_initdata_t _object_Krpc_x_wrong_pipe_order;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_X_WRONG_PIPE_VERSION))
  object_initdata_t _object_Krpc_x_wrong_pipe_version;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_X_WRONG_STUB_VERSION))
  object_initdata_t _object_Krpc_x_wrong_stub_version;
#endif
#if (defined(HAVE_GETRLIMIT) || defined(HAVE_SETRLIMIT)) && (defined(RLIMIT_RSS))
  object_initdata_t _object_Krss;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_RTSIG_MAX))
  object_initdata_t _object_Krtsig_max;
#endif
#if (defined(HAVE_UTMPX_H)) && (defined(RUN_LVL))
  object_initdata_t _object_Krun_lvl;
#endif
#if defined(S_IRUSR)
  object_initdata_t _object_Krusr;
#endif
#if defined(S_IRWXG)
  object_initdata_t _object_Krwxg;
#endif
#if defined(S_IRWXO)
  object_initdata_t _object_Krwxo;
#endif
#if defined(S_IRWXU)
  object_initdata_t _object_Krwxu;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  object_initdata_t _object_Ks;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_SAVED_IDS))
  object_initdata_t _object_Ksaved_ids;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(SCHED_E_SERVICE_NOT_LOCALSYSTEM))
  object_initdata_t _object_Ksched_e_service_not_localsystem;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(SEC_E_ISSUING_CA_UNTRUSTED))
  object_initdata_t _object_Ksec_e_issuing_ca_untrusted;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(SEC_E_PKINIT_CLIENT_FAILUR))
  object_initdata_t _object_Ksec_e_pkinit_client_failur;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(SEC_E_REVOCATION_OFFLINE_C))
  object_initdata_t _object_Ksec_e_revocation_offline_c;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(SEC_E_SMARTCARD_CERT_EXPIRED))
  object_initdata_t _object_Ksec_e_smartcard_cert_expired;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(SEC_E_SMARTCARD_CERT_REVOKED))
  object_initdata_t _object_Ksec_e_smartcard_cert_revoked;
#endif
#if (defined(HAVE_SYS_RESOURCE_H)) && (defined(HAVE_GETRUSAGE)) && (defined(RUSAGE_SELF))
  object_initdata_t _object_Kself;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_SEMAPHORES))
  object_initdata_t _object_Ksemaphores;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_SEM_NSEMS_MAX))
  object_initdata_t _object_Ksem_nsems_max;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_SEM_VALUE_MAX))
  object_initdata_t _object_Ksem_value_max;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  object_initdata_t _object_Kserver;
#endif
#if defined(S_ISGID)
  object_initdata_t _object_Ksgid;
#endif
#if defined(HAVE_FCNTL) || defined(WIN32_NATIVE)
  object_initdata_t _object_Kshared;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_SHARED_MEMORY_OBJECTS))
  object_initdata_t _object_Kshared_memory_objects;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_SHELL))
  object_initdata_t _object_Kshell;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  object_initdata_t _object_Kshift;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  object_initdata_t _object_Kshow_command;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(PROCESSOR_ARCHITECTURE_SHX))
  object_initdata_t _object_Kshx;
#endif
#if defined(SIGABRT)
  object_initdata_t _object_Ksigabrt;
#endif
#if defined(SIGALRM)
  object_initdata_t _object_Ksigalrm;
#endif
#if defined(SIGBUS)
  object_initdata_t _object_Ksigbus;
#endif
#if defined(SIGCHLD)
  object_initdata_t _object_Ksigchld;
#endif
#if defined(SIGCONT)
  object_initdata_t _object_Ksigcont;
#endif
#if defined(SIGFPE)
  object_initdata_t _object_Ksigfpe;
#endif
#if defined(SIGHUP)
  object_initdata_t _object_Ksighup;
#endif
#if defined(SIGILL)
  object_initdata_t _object_Ksigill;
#endif
#if defined(SIGINT)
  object_initdata_t _object_Ksigint;
#endif
#if defined(SIGKILL)
  object_initdata_t _object_Ksigkill;
#endif
#if defined(HAVE_SYS_RESOURCE_H)
  object_initdata_t _object_Ksignaled;
#endif
#if defined(SIGPIPE)
  object_initdata_t _object_Ksigpipe;
#endif
#if defined(SIGPOLL)
  object_initdata_t _object_Ksigpoll;
#endif
#if defined(SIGPROF)
  object_initdata_t _object_Ksigprof;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_SIGQUEUE_MAX))
  object_initdata_t _object_Ksigqueue_max;
#endif
#if defined(SIGQUIT)
  object_initdata_t _object_Ksigquit;
#endif
#if defined(SIGSEGV)
  object_initdata_t _object_Ksigsegv;
#endif
#if defined(SIGSTOP)
  object_initdata_t _object_Ksigstop;
#endif
#if defined(SIGSYS)
  object_initdata_t _object_Ksigsys;
#endif
#if defined(SIGTERM)
  object_initdata_t _object_Ksigterm;
#endif
#if defined(SIGTRAP)
  object_initdata_t _object_Ksigtrap;
#endif
#if defined(SIGTSTP)
  object_initdata_t _object_Ksigtstp;
#endif
#if defined(SIGTTIN)
  object_initdata_t _object_Ksigttin;
#endif
#if defined(SIGTTOU)
  object_initdata_t _object_Ksigttou;
#endif
#if defined(SIGURG)
  object_initdata_t _object_Ksigurg;
#endif
#if defined(SIGUSR1)
  object_initdata_t _object_Ksigusr1;
#endif
#if defined(SIGUSR2)
  object_initdata_t _object_Ksigusr2;
#endif
#if defined(SIGVTALRM)
  object_initdata_t _object_Ksigvtalrm;
#endif
#if defined(SIGXCPU)
  object_initdata_t _object_Ksigxcpu;
#endif
#if defined(SIGXFSZ)
  object_initdata_t _object_Ksigxfsz;
#endif
#if (defined(HAVE_NFTW)) && (defined(FTW_SL))
  object_initdata_t _object_Ksl;
#endif
#if (defined(HAVE_NFTW)) && (defined(FTW_SLN))
  object_initdata_t _object_Ksln;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  object_initdata_t _object_Ksmallbusiness;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  object_initdata_t _object_Ksmallbusiness_restricted;
#endif
#if (defined(HAVE_PATHCONF) && defined(HAVE_FPATHCONF)) && (defined(_PC_SOCK_MAXBUF))
  object_initdata_t _object_Ksock_maxbuf;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(FILE_ATTRIBUTE_SPARSE_FILE))
  object_initdata_t _object_Ksparse_file;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_SPAWN))
  object_initdata_t _object_Kspawn;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_SPIN_LOCKS))
  object_initdata_t _object_Kspin_locks;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_SPORADIC_SERVER))
  object_initdata_t _object_Ksporadic_server;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_SS_REPL_MAX))
  object_initdata_t _object_Kss_repl_max;
#endif
#if (defined(HAVE_GETRLIMIT) || defined(HAVE_SETRLIMIT)) && (defined(RLIMIT_STACK))
  object_initdata_t _object_Kstack;
#endif
#if defined(HAVE_FCNTL) || defined(WIN32_NATIVE)
  object_initdata_t _object_Kstart;
#endif
#if defined(HAVE_SYS_RESOURCE_H)
  object_initdata_t _object_Kstopped;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_STREAM_MAX))
  object_initdata_t _object_Kstream_max;
#endif
#if defined(STRUNCATE)
  object_initdata_t _object_Kstruncate;
#endif
#if (defined(WIN32_NATIVE) || (defined(HAVE_STATVFS) && defined(HAVE_SYS_STATVFS_H))) && (defined(ST_APPEND))
  object_initdata_t _object_Kst_append;
#endif
#if (defined(WIN32_NATIVE) || (defined(HAVE_STATVFS) && defined(HAVE_SYS_STATVFS_H))) && (defined(ST_IMMUTABLE))
  object_initdata_t _object_Kst_immutable;
#endif
#if (defined(WIN32_NATIVE) || (defined(HAVE_STATVFS) && defined(HAVE_SYS_STATVFS_H))) && (defined(ST_MANDLOCK))
  object_initdata_t _object_Kst_mandlock;
#endif
#if (defined(WIN32_NATIVE) || (defined(HAVE_STATVFS) && defined(HAVE_SYS_STATVFS_H))) && (defined(ST_NOATIME))
  object_initdata_t _object_Kst_noatime;
#endif
#if (defined(WIN32_NATIVE) || (defined(HAVE_STATVFS) && defined(HAVE_SYS_STATVFS_H))) && (defined(ST_NODEV))
  object_initdata_t _object_Kst_nodev;
#endif
#if (defined(WIN32_NATIVE) || (defined(HAVE_STATVFS) && defined(HAVE_SYS_STATVFS_H))) && (defined(ST_NODIRATIME))
  object_initdata_t _object_Kst_nodiratime;
#endif
#if (defined(WIN32_NATIVE) || (defined(HAVE_STATVFS) && defined(HAVE_SYS_STATVFS_H))) && (defined(ST_NOEXEC))
  object_initdata_t _object_Kst_noexec;
#endif
#if (defined(WIN32_NATIVE) || (defined(HAVE_STATVFS) && defined(HAVE_SYS_STATVFS_H))) && (defined(ST_NOSUID))
  object_initdata_t _object_Kst_nosuid;
#endif
#if (defined(WIN32_NATIVE) || (defined(HAVE_STATVFS) && defined(HAVE_SYS_STATVFS_H))) && (defined(ST_NOTRUNC))
  object_initdata_t _object_Kst_notrunc;
#endif
#if (defined(WIN32_NATIVE) || (defined(HAVE_STATVFS) && defined(HAVE_SYS_STATVFS_H))) && (defined(ST_RDONLY))
  object_initdata_t _object_Kst_rdonly;
#endif
#if (defined(WIN32_NATIVE) || (defined(HAVE_STATVFS) && defined(HAVE_SYS_STATVFS_H))) && (defined(ST_SYNCHRONOUS))
  object_initdata_t _object_Kst_synchronous;
#endif
#if (defined(WIN32_NATIVE) || (defined(HAVE_STATVFS) && defined(HAVE_SYS_STATVFS_H))) && (defined(ST_WRITE))
  object_initdata_t _object_Kst_write;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  object_initdata_t _object_Ksubject;
#endif
#if defined(S_ISUID)
  object_initdata_t _object_Ksuid;
#endif
#if defined(S_ISVTX)
  object_initdata_t _object_Ksvtx;
#endif
  object_initdata_t _object_Ksymlink;
#if (defined(HAVE_PATHCONF) && defined(HAVE_FPATHCONF)) && (defined(_PC_SYMLINK_MAX))
  object_initdata_t _object_Ksymlink_max;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_SYMLOOP_MAX))
  object_initdata_t _object_Ksymloop_max;
#endif
#if (defined(HAVE_FCNTL)) && (defined(O_SYNC))
  object_initdata_t _object_Ksync;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_SYNCHRONIZED_IO))
  object_initdata_t _object_Ksynchronized_io;
#endif
#if (defined(HAVE_PATHCONF) && defined(HAVE_FPATHCONF)) && (defined(_PC_SYNC_IO))
  object_initdata_t _object_Ksync_io;
#endif
#if (defined(HAVE_SYSLOG)) && (defined(LOG_SYSLOG))
  object_initdata_t _object_Ksyslog;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(FILE_ATTRIBUTE_SYSTEM))
  object_initdata_t _object_Ksystem;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  object_initdata_t _object_Ktemplate;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(FILE_ATTRIBUTE_TEMPORARY))
  object_initdata_t _object_Ktemporary;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  object_initdata_t _object_Kterminal;
#endif
#if (defined(HAVE_FCNTL)) && (defined(O_TEXT))
  object_initdata_t _object_Ktext;
#endif
#if (defined(HAVE_SYS_RESOURCE_H)) && (defined(HAVE_GETRUSAGE)) && (defined(RUSAGE_THREAD))
  object_initdata_t _object_Kthread;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_THREADS))
  object_initdata_t _object_Kthreads;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_THREAD_ATTR_STACKADDR))
  object_initdata_t _object_Kthread_attr_stackaddr;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_THREAD_ATTR_STACKSIZE))
  object_initdata_t _object_Kthread_attr_stacksize;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_THREAD_CPUTIME))
  object_initdata_t _object_Kthread_cputime;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_THREAD_DESTRUCTOR_ITERATIONS))
  object_initdata_t _object_Kthread_destructor_iterations;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_THREAD_KEYS_MAX))
  object_initdata_t _object_Kthread_keys_max;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_THREAD_PRIORITY_SCHEDULING))
  object_initdata_t _object_Kthread_priority_scheduling;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_THREAD_PRIO_INHERIT))
  object_initdata_t _object_Kthread_prio_inherit;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_THREAD_PRIO_PROTECT))
  object_initdata_t _object_Kthread_prio_protect;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_THREAD_PROCESS_SHARED))
  object_initdata_t _object_Kthread_process_shared;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_THREAD_ROBUST_PRIO_INHERIT))
  object_initdata_t _object_Kthread_robust_prio_inherit;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_THREAD_ROBUST_PRIO_PROTECT))
  object_initdata_t _object_Kthread_robust_prio_protect;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_THREAD_SAFE_FUNCTIONS))
  object_initdata_t _object_Kthread_safe_functions;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_THREAD_SPORADIC_SERVER))
  object_initdata_t _object_Kthread_sporadic_server;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_THREAD_STACK_MIN))
  object_initdata_t _object_Kthread_stack_min;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_THREAD_THREADS_MAX))
  object_initdata_t _object_Kthread_threads_max;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  object_initdata_t _object_Kthumbnail;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_TIMEOUTS))
  object_initdata_t _object_Ktimeouts;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_TIMERS))
  object_initdata_t _object_Ktimers;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_TIMER_MAX))
  object_initdata_t _object_Ktimer_max;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  object_initdata_t _object_Ktitle;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_TRACE))
  object_initdata_t _object_Ktrace;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_TRACE_EVENT_FILTER))
  object_initdata_t _object_Ktrace_event_filter;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_TRACE_EVENT_NAME_MAX))
  object_initdata_t _object_Ktrace_event_name_max;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_TRACE_INHERIT))
  object_initdata_t _object_Ktrace_inherit;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_TRACE_LOG))
  object_initdata_t _object_Ktrace_log;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_TRACE_NAME_MAX))
  object_initdata_t _object_Ktrace_name_max;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_TRACE_SYS_MAX))
  object_initdata_t _object_Ktrace_sys_max;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_TRACE_USER_EVENT_MAX))
  object_initdata_t _object_Ktrace_user_event_max;
#endif
#if (defined(HAVE_FCNTL)) && (defined(O_TRUNC))
  object_initdata_t _object_Ktrunc;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_TTY_NAME_MAX))
  object_initdata_t _object_Ktty_name_max;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_TYPED_MEMORY_OBJECTS))
  object_initdata_t _object_Ktyped_memory_objects;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_TZNAME_MAX))
  object_initdata_t _object_Ktzname_max;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  object_initdata_t _object_Kui1;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  object_initdata_t _object_Kui2;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  object_initdata_t _object_Kui4;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  object_initdata_t _object_Kui8;
#endif
#if defined(HAVE_STAT) && (defined(HAVE_CHMOD) || defined(HAVE_CHOWN) || defined(HAVE_UTIME))
  object_initdata_t _object_Kuid;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  object_initdata_t _object_Kuint;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(PROCESSOR_ARCHITECTURE_UNKNOWN))
  object_initdata_t _object_Kunknown;
#endif
#if defined(HAVE_SYS_RESOURCE_H)
  object_initdata_t _object_Kuntraced;
#endif
#if defined(HAVE_SYS_RESOURCE_H)
  object_initdata_t _object_Kusage;
#endif
#if ((defined(HAVE_SYSLOG)) && (defined(LOG_USER))) || (defined(PRIO_USER))
  object_initdata_t _object_Kuser;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  object_initdata_t _object_Kuser_defined;
#endif
#if (defined(HAVE_UTMPX_H)) && (defined(USER_PROCESS))
  object_initdata_t _object_Kuser_process;
#endif
#if (defined(HAVE_SYSLOG)) && (defined(LOG_UUCP))
  object_initdata_t _object_Kuucp;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_V6_ILP32_OFF32))
  object_initdata_t _object_Kv6_ilp32_off32;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_V6_ILP32_OFFBIG))
  object_initdata_t _object_Kv6_ilp32_offbig;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_V6_LP64_OFF64))
  object_initdata_t _object_Kv6_lp64_off64;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_V6_LPBIG_OFFBIG))
  object_initdata_t _object_Kv6_lpbig_offbig;
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_V7_ENV))
  object_initdata_t _object_Kv7_env;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_V7_ILP32_OFF32))
  object_initdata_t _object_Kv7_ilp32_off32;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_V7_ILP32_OFFBIG))
  object_initdata_t _object_Kv7_ilp32_offbig;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_V7_LP64_OFF64))
  object_initdata_t _object_Kv7_lp64_off64;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_V7_LPBIG_OFFBIG))
  object_initdata_t _object_Kv7_lpbig_offbig;
#endif
#if (defined(HAVE_PATHCONF) && defined(HAVE_FPATHCONF)) && (defined(_PC_VDISABLE))
  object_initdata_t _object_Kvdisable;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_VERSION))
  object_initdata_t _object_Kversion;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WAIT_TIMEOUT))
  object_initdata_t _object_Kwait_timeout;
#endif
#if (defined(HAVE_SYSLOG)) && (defined(LOG_WARNING))
  object_initdata_t _object_Kwarning;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WARNING_IPSEC_MM_POLICY_PRUNED))
  object_initdata_t _object_Kwarning_ipsec_mm_policy_pruned;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WARNING_IPSEC_QM_POLICY_PRUNED))
  object_initdata_t _object_Kwarning_ipsec_qm_policy_pruned;
#endif
#if defined(S_IWGRP)
  object_initdata_t _object_Kwgrp;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  object_initdata_t _object_Kwindows;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  object_initdata_t _object_Kwordcount;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  object_initdata_t _object_Kworking_directory;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  object_initdata_t _object_Kworkstation;
#endif
#if defined(S_IWOTH)
  object_initdata_t _object_Kwoth;
#endif
#if defined(HAVE_FCNTL)
  object_initdata_t _object_Kwronly;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSABASEERR))
  object_initdata_t _object_Kwsabaseerr;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAEACCES))
  object_initdata_t _object_Kwsaeacces;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAEADDRINUSE))
  object_initdata_t _object_Kwsaeaddrinuse;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAEADDRNOTAVAIL))
  object_initdata_t _object_Kwsaeaddrnotavail;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAEAFNOSUPPORT))
  object_initdata_t _object_Kwsaeafnosupport;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAEALREADY))
  object_initdata_t _object_Kwsaealready;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAEBADF))
  object_initdata_t _object_Kwsaebadf;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAECANCELLED))
  object_initdata_t _object_Kwsaecancelled;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAECONNABORTED))
  object_initdata_t _object_Kwsaeconnaborted;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAECONNREFUSED))
  object_initdata_t _object_Kwsaeconnrefused;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAECONNRESET))
  object_initdata_t _object_Kwsaeconnreset;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAEDESTADDRREQ))
  object_initdata_t _object_Kwsaedestaddrreq;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAEDISCON))
  object_initdata_t _object_Kwsaediscon;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAEDQUOT))
  object_initdata_t _object_Kwsaedquot;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAEFAULT))
  object_initdata_t _object_Kwsaefault;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAEHOSTDOWN))
  object_initdata_t _object_Kwsaehostdown;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAEHOSTUNREACH))
  object_initdata_t _object_Kwsaehostunreach;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAEINPROGRESS))
  object_initdata_t _object_Kwsaeinprogress;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAEINTR))
  object_initdata_t _object_Kwsaeintr;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAEINVAL))
  object_initdata_t _object_Kwsaeinval;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAEINVALIDPROCTABLE))
  object_initdata_t _object_Kwsaeinvalidproctable;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAEINVALIDPROVIDER))
  object_initdata_t _object_Kwsaeinvalidprovider;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAEISCONN))
  object_initdata_t _object_Kwsaeisconn;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAELOOP))
  object_initdata_t _object_Kwsaeloop;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAEMFILE))
  object_initdata_t _object_Kwsaemfile;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAEMSGSIZE))
  object_initdata_t _object_Kwsaemsgsize;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAENAMETOOLONG))
  object_initdata_t _object_Kwsaenametoolong;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAENETDOWN))
  object_initdata_t _object_Kwsaenetdown;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAENETRESET))
  object_initdata_t _object_Kwsaenetreset;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAENETUNREACH))
  object_initdata_t _object_Kwsaenetunreach;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAENOBUFS))
  object_initdata_t _object_Kwsaenobufs;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAENOMORE))
  object_initdata_t _object_Kwsaenomore;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAENOPROTOOPT))
  object_initdata_t _object_Kwsaenoprotoopt;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAENOTCONN))
  object_initdata_t _object_Kwsaenotconn;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAENOTEMPTY))
  object_initdata_t _object_Kwsaenotempty;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAENOTSOCK))
  object_initdata_t _object_Kwsaenotsock;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAEOPNOTSUPP))
  object_initdata_t _object_Kwsaeopnotsupp;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAEPFNOSUPPORT))
  object_initdata_t _object_Kwsaepfnosupport;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAEPROCLIM))
  object_initdata_t _object_Kwsaeproclim;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAEPROTONOSUPPORT))
  object_initdata_t _object_Kwsaeprotonosupport;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAEPROTOTYPE))
  object_initdata_t _object_Kwsaeprototype;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAEPROVIDERFAILEDINIT))
  object_initdata_t _object_Kwsaeproviderfailedinit;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAEREFUSED))
  object_initdata_t _object_Kwsaerefused;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAEREMOTE))
  object_initdata_t _object_Kwsaeremote;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAESHUTDOWN))
  object_initdata_t _object_Kwsaeshutdown;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAESOCKTNOSUPPORT))
  object_initdata_t _object_Kwsaesocktnosupport;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAESTALE))
  object_initdata_t _object_Kwsaestale;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAETIMEDOUT))
  object_initdata_t _object_Kwsaetimedout;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAETOOMANYREFS))
  object_initdata_t _object_Kwsaetoomanyrefs;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAEUSERS))
  object_initdata_t _object_Kwsaeusers;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAEWOULDBLOCK))
  object_initdata_t _object_Kwsaewouldblock;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAHOST_NOT_FOUND))
  object_initdata_t _object_Kwsahost_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSANOTINITIALISED))
  object_initdata_t _object_Kwsanotinitialised;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSANO_DATA))
  object_initdata_t _object_Kwsano_data;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSANO_RECOVERY))
  object_initdata_t _object_Kwsano_recovery;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSASERVICE_NOT_FOUND))
  object_initdata_t _object_Kwsaservice_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSASYSCALLFAILURE))
  object_initdata_t _object_Kwsasyscallfailure;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSASYSNOTREADY))
  object_initdata_t _object_Kwsasysnotready;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSATRY_AGAIN))
  object_initdata_t _object_Kwsatry_again;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSATYPE_NOT_FOUND))
  object_initdata_t _object_Kwsatype_not_found;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSAVERNOTSUPPORTED))
  object_initdata_t _object_Kwsavernotsupported;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSA_E_CANCELLED))
  object_initdata_t _object_Kwsa_e_cancelled;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSA_E_NO_MORE))
  object_initdata_t _object_Kwsa_e_no_more;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSA_QOS_ADMISSION_FAILURE))
  object_initdata_t _object_Kwsa_qos_admission_failure;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSA_QOS_BAD_OBJECT))
  object_initdata_t _object_Kwsa_qos_bad_object;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSA_QOS_BAD_STYLE))
  object_initdata_t _object_Kwsa_qos_bad_style;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSA_QOS_EFILTERCOUNT))
  object_initdata_t _object_Kwsa_qos_efiltercount;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSA_QOS_EFILTERSTYLE))
  object_initdata_t _object_Kwsa_qos_efilterstyle;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSA_QOS_EFILTERTYPE))
  object_initdata_t _object_Kwsa_qos_efiltertype;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSA_QOS_EFLOWCOUNT))
  object_initdata_t _object_Kwsa_qos_eflowcount;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSA_QOS_EFLOWDESC))
  object_initdata_t _object_Kwsa_qos_eflowdesc;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSA_QOS_EFLOWSPEC))
  object_initdata_t _object_Kwsa_qos_eflowspec;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSA_QOS_EOBJLENGTH))
  object_initdata_t _object_Kwsa_qos_eobjlength;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSA_QOS_EPOLICYOBJ))
  object_initdata_t _object_Kwsa_qos_epolicyobj;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSA_QOS_EPROVSPECBUF))
  object_initdata_t _object_Kwsa_qos_eprovspecbuf;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSA_QOS_EPSFILTERSPEC))
  object_initdata_t _object_Kwsa_qos_epsfilterspec;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSA_QOS_EPSFLOWSPEC))
  object_initdata_t _object_Kwsa_qos_epsflowspec;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSA_QOS_ESDMODEOBJ))
  object_initdata_t _object_Kwsa_qos_esdmodeobj;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSA_QOS_ESERVICETYPE))
  object_initdata_t _object_Kwsa_qos_eservicetype;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSA_QOS_ESHAPERATEOBJ))
  object_initdata_t _object_Kwsa_qos_eshaperateobj;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSA_QOS_EUNKNOWNPSOBJ))
  object_initdata_t _object_Kwsa_qos_eunknownpsobj;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSA_QOS_GENERIC_ERROR))
  object_initdata_t _object_Kwsa_qos_generic_error;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSA_QOS_NO_RECEIVERS))
  object_initdata_t _object_Kwsa_qos_no_receivers;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSA_QOS_NO_SENDERS))
  object_initdata_t _object_Kwsa_qos_no_senders;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSA_QOS_POLICY_FAILURE))
  object_initdata_t _object_Kwsa_qos_policy_failure;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSA_QOS_RECEIVERS))
  object_initdata_t _object_Kwsa_qos_receivers;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSA_QOS_REQUEST_CONFIRMED))
  object_initdata_t _object_Kwsa_qos_request_confirmed;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSA_QOS_RESERVED_PETYPE))
  object_initdata_t _object_Kwsa_qos_reserved_petype;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSA_QOS_SENDERS))
  object_initdata_t _object_Kwsa_qos_senders;
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(WSA_QOS_TRAFFIC_CTRL_ERROR))
  object_initdata_t _object_Kwsa_qos_traffic_ctrl_error;
#endif
#if defined(S_IWUSR)
  object_initdata_t _object_Kwusr;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_XBS5_ILP32_OFF32))
  object_initdata_t _object_Kxbs5_ilp32_off32;
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_XBS5_ILP32_OFF32_CFLAGS))
  object_initdata_t _object_Kxbs5_ilp32_off32_cflags;
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_XBS5_ILP32_OFF32_LDFLAGS))
  object_initdata_t _object_Kxbs5_ilp32_off32_ldflags;
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_XBS5_ILP32_OFF32_LIBS))
  object_initdata_t _object_Kxbs5_ilp32_off32_libs;
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_XBS5_ILP32_OFF32_LINTFLAGS))
  object_initdata_t _object_Kxbs5_ilp32_off32_lintflags;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_XBS5_ILP32_OFFBIG))
  object_initdata_t _object_Kxbs5_ilp32_offbig;
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_XBS5_ILP32_OFFBIG_CFLAGS))
  object_initdata_t _object_Kxbs5_ilp32_offbig_cflags;
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_XBS5_ILP32_OFFBIG_LDFLAGS))
  object_initdata_t _object_Kxbs5_ilp32_offbig_ldflags;
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_XBS5_ILP32_OFFBIG_LIBS))
  object_initdata_t _object_Kxbs5_ilp32_offbig_libs;
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_XBS5_ILP32_OFFBIG_LINTFLAGS))
  object_initdata_t _object_Kxbs5_ilp32_offbig_lintflags;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_XBS5_LP64_OFF64))
  object_initdata_t _object_Kxbs5_lp64_off64;
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_XBS5_LP64_OFF64_CFLAGS))
  object_initdata_t _object_Kxbs5_lp64_off64_cflags;
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_XBS5_LP64_OFF64_LDFLAGS))
  object_initdata_t _object_Kxbs5_lp64_off64_ldflags;
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_XBS5_LP64_OFF64_LIBS))
  object_initdata_t _object_Kxbs5_lp64_off64_libs;
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_XBS5_LP64_OFF64_LINTFLAGS))
  object_initdata_t _object_Kxbs5_lp64_off64_lintflags;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_XBS5_LPBIG_OFFBIG))
  object_initdata_t _object_Kxbs5_lpbig_offbig;
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_XBS5_LPBIG_OFFBIG_CFLAGS))
  object_initdata_t _object_Kxbs5_lpbig_offbig_cflags;
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_XBS5_LPBIG_OFFBIG_LDFLAGS))
  object_initdata_t _object_Kxbs5_lpbig_offbig_ldflags;
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_XBS5_LPBIG_OFFBIG_LIBS))
  object_initdata_t _object_Kxbs5_lpbig_offbig_libs;
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_XBS5_LPBIG_OFFBIG_LINTFLAGS))
  object_initdata_t _object_Kxbs5_lpbig_offbig_lintflags;
#endif
#if defined(S_IXGRP)
  object_initdata_t _object_Kxgrp;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_XOPEN_CRYPT))
  object_initdata_t _object_Kxopen_crypt;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_XOPEN_ENH_I18N))
  object_initdata_t _object_Kxopen_enh_i18n;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_XOPEN_LEGACY))
  object_initdata_t _object_Kxopen_legacy;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_XOPEN_REALTIME))
  object_initdata_t _object_Kxopen_realtime;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_XOPEN_REALTIME_THREADS))
  object_initdata_t _object_Kxopen_realtime_threads;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_XOPEN_SHM))
  object_initdata_t _object_Kxopen_shm;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_XOPEN_STREAMS))
  object_initdata_t _object_Kxopen_streams;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_XOPEN_UNIX))
  object_initdata_t _object_Kxopen_unix;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_XOPEN_UUCP))
  object_initdata_t _object_Kxopen_uucp;
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_XOPEN_VERSION))
  object_initdata_t _object_Kxopen_version;
#endif
#if defined(S_IXOTH)
  object_initdata_t _object_Kxoth;
#endif
#if defined(S_IXUSR)
  object_initdata_t _object_Kxusr;
#endif
  object_initdata_t _object_posix__copy_file;
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  object_initdata_t _object_posix__make_file_info;
#endif
#if (defined(HAVE_FSTAT) && defined(HAVE_STAT)) || (defined(HAVE_NFTW))
  object_initdata_t _object_posix__make_file_stat;
#endif
#if defined(HAVE_GETGRGID) && defined(HAVE_GETGRNAM)
  object_initdata_t _object_posix__make_group_info;
#endif
  object_initdata_t _object_posix__make_hostent;
#if defined(HAVE_GETRLIMIT)
  object_initdata_t _object_posix__make_rlimit;
#endif
#if (defined(HAVE_GETSERVBYPORT) && defined(HAVE_GETSERVBYNAME)) || defined(WIN32_NATIVE)
  object_initdata_t _object_posix__make_service;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  object_initdata_t _object_posix__make_shortcut_info;
#endif
#if defined(WIN32_NATIVE) || (defined(HAVE_STATVFS) && defined(HAVE_SYS_STATVFS_H))
  object_initdata_t _object_posix__make_stat_vfs;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  object_initdata_t _object_posix__make_system_info;
#endif
  object_initdata_t _object_posix__make_uname;
#if defined(HAVE_SYS_RESOURCE_H)
  object_initdata_t _object_posix__make_usage;
#endif
#if defined(HAVE_GETLOGIN) && defined(HAVE_GETPWNAM) && defined(HAVE_GETPWUID) && defined(HAVE_GETUID)
  object_initdata_t _object_posix__make_user_info;
#endif
#if defined(HAVE_UTMPX_H)
  object_initdata_t _object_posix__make_utmpx;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  object_initdata_t _object_posix__make_version;
#endif
#if defined(WIN32_NATIVE)
  object_initdata_t _object_posix__mkfilever;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  object_initdata_t _object_posix__mkmemstat;
#endif
  object_initdata_t _object_posix__resolve_host_ipaddr;
#if defined(HAVE_SETRLIMIT)
  object_initdata_t _object_posix__rlimit;
#endif
#if defined(HAVE_UTMPX_H)
  object_initdata_t _object_posix__utmpx;
#endif
#if (defined(HAVE_STAT) && (defined(HAVE_CHMOD) || defined(HAVE_CHOWN) || defined(HAVE_UTIME))) && (!(defined(WIN32_NATIVE))) && (!(defined(HAVE_CHMOD)))
  object_initdata_t _object__22chmod_28_29_22;
#endif
#if (defined(HAVE_STAT) && (defined(HAVE_CHMOD) || defined(HAVE_CHOWN) || defined(HAVE_UTIME))) && (!(defined(HAVE_CHOWN)))
  object_initdata_t _object__22chown_28_29_22;
#endif
#if (defined(HAVE_STAT) && (defined(HAVE_CHMOD) || defined(HAVE_CHOWN) || defined(HAVE_UTIME))) && (!defined(WIN32_NATIVE)) && (!(defined(HAVE_UTIME)))
  object_initdata_t _object__22utime_28_29_22;
#endif
  object_initdata_t _object__28member_200_201_202_29;
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  object_initdata_t _object__28member_20_alt_20_control_20_ext_20_shift_29;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  object_initdata_t _object__28member_20_normal_20_max_20_min_29;
#endif
  object_initdata_t _object__28or_20null_20integer_20_28member_20_copy_20_symlink_20_hardlink_20_hardlink_or_copy_20_rename_29_29;
  object_initdata_t _object___28or_20integer_20_28member_defined_28e2big_29_Ke2big_defined_28eacces_29_Keacces_defined_28eaddrinuse_29_Keaddrinuse_defined_28eaddrnotavail_29_Keaddrnotavail_defined_28eafnosupport_29_Keafnosupport_defined_28eagain_29_Keagain_defined_28ealready_29_Kealready_defined_28ebadf_29_Kebadf_defined_28ebadmsg_29_Kebadmsg_defined_28ebusy_29_Kebusy_defined_28ecanceled_29_Kecanceled_defined_28echild_29_Kechild_defined_28econnaborted_29_Keconnaborted_defined_28econnrefused_29_Keconnrefused_defined_28econnreset_29_Keconnreset_defined_28edeadlk_29_Kedeadlk_defined_28edestaddrreq_29_Kedestaddrreq_defined_28edom_29_Kedom_defined_28edquot_29_Kedquot_defined_28eexist_29_Keexist_defined_28efault_29_Kefault_defined_28efbig_29_Kefbig_defined_28ehostunreach_29_Kehostunreach_defined_28eidrm_29_Keidrm_defined_28eilseq_29_Keilseq_defined_28einprogress_29_Keinprogress_defined_28eintr_29_Keintr_defined_28einval_29_Keinval_defined_28eio_29_Keio_defined_28eisconn_29_Keisconn_defined_28eisdir_29_Keisdir_defined_28eloop_29_Keloop_defined_28emfile_29_Kemfile_defined_28emlink_29_Kemlink_defined_28emsgsize_29_Kemsgsize_defined_28emultihop_29_Kemultihop_defined_28enametoolong_29_Kenametoolong_defined_28enetdown_29_Kenetdown_defined_28enetreset_29_Kenetreset_defined_28enetunreach_29_Kenetunreach_defined_28enfile_29_Kenfile_defined_28enobufs_29_Kenobufs_defined_28enodata_29_Kenodata_defined_28enodev_29_Kenodev_defined_28enoent_29_Kenoent_defined_28enoexec_29_Kenoexec_defined_28enolck_29_Kenolck_defined_28enolink_29_Kenolink_defined_28enomem_29_Kenomem_defined_28enomsg_29_Kenomsg_defined_28enoprotoopt_29_Kenoprotoopt_defined_28enospc_29_Kenospc_defined_28enosr_29_Kenosr_defined_28enostr_29_Kenostr_defined_28enosys_29_Kenosys_defined_28enotconn_29_Kenotconn_defined_28enotdir_29_Kenotdir_defined_28enotempty_29_Kenotempty_defined_28enotsock_29_Kenotsock_defined_28enotsup_29_Kenotsup_defined_28enotty_29_Kenotty_defined_28enxio_29_Kenxio_defined_28eopnotsupp_29_Keopnotsupp_defined_28eoverflow_29_Keo;
#if defined(HAVE_UTMPX_H)
  object_initdata_t _object___28or_20integer_20_28member_defined_28empty_29_Kempty_defined_28run_lvl_29_Krun_lvl_defined_28boot_time_29_Kboot_time_defined_28old_time_29_Kold_time_defined_28new_time_29_Knew_time_defined_28user_process_29_Kuser_process_defined_28init_process_29_Kinit_process_defined_28login_process_29_Klogin_process_defined_28dead_process_29_Kdead_process_defined_28accounting_29_Kaccounting__29_29;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  object_initdata_t _object___28or_20integer_20_28member_defined_28error_invalid_function_29_Kerror_invalid_function_defined_28error_file_not_found_29_Kerror_file_not_found_defined_28error_path_not_found_29_Kerror_path_not_found_defined_28error_too_many_open_files_29_Kerror_too_many_open_files_defined_28error_access_denied_29_Kerror_access_denied_defined_28error_invalid_handle_29_Kerror_invalid_handle_defined_28error_arena_trashed_29_Kerror_arena_trashed_defined_28error_not_enough_memory_29_Kerror_not_enough_memory_defined_28error_invalid_block_29_Kerror_invalid_block_defined_28error_bad_environment_29_Kerror_bad_environment_defined_28error_bad_format_29_Kerror_bad_format_defined_28error_invalid_access_29_Kerror_invalid_access_defined_28error_invalid_data_29_Kerror_invalid_data_defined_28error_outofmemory_29_Kerror_outofmemory_defined_28error_invalid_drive_29_Kerror_invalid_drive_defined_28error_current_directory_29_Kerror_current_directory_defined_28error_not_same_device_29_Kerror_not_same_device_defined_28error_no_more_files_29_Kerror_no_more_files_defined_28error_write_protect_29_Kerror_write_protect_defined_28error_bad_unit_29_Kerror_bad_unit_defined_28error_not_ready_29_Kerror_not_ready_defined_28error_bad_command_29_Kerror_bad_command_defined_28error_crc_29_Kerror_crc_defined_28error_bad_length_29_Kerror_bad_length_defined_28error_seek_29_Kerror_seek_defined_28error_not_dos_disk_29_Kerror_not_dos_disk_defined_28error_sector_not_found_29_Kerror_sector_not_found_defined_28error_out_of_paper_29_Kerror_out_of_paper_defined_28error_write_fault_29_Kerror_write_fault_defined_28error_read_fault_29_Kerror_read_fault_defined_28error_gen_failure_29_Kerror_gen_failure_defined_28error_sharing_violation_29_Kerror_sharing_violation_defined_28error_lock_violation_29_Kerror_lock_violation_defined_28error_wrong_disk_29_Kerror_wrong_disk_defined_28error_sharing_buffer_exceeded_29_Kerror_sharing_buffer_exceeded_defined_28error_handle_eof_29_Kerror_handle_eof_defined_28error_handle_disk_full_29_Kerror;
#endif
#if defined(HAVE_FCNTL)
  object_initdata_t _object___28or_20integer_20_28member_defined_28fd_cloexec_29_Kcloexec__29_29;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  object_initdata_t _object___28or_20integer_20_28member_defined_28file_attribute_archive_29_Karchive_defined_28file_attribute_compressed_29_Kcompressed_defined_28file_attribute_device_29_Kdevice_defined_28file_attribute_directory_29_Kdirectory_defined_28file_attribute_encrypted_29_Kencrypted_defined_28file_attribute_hidden_29_Khidden_defined_28file_attribute_normal_29_Knormal_defined_28file_attribute_not_content_indexed_29_Knot_content_indexed_defined_28file_attribute_offline_29_Koffline_defined_28file_attribute_readonly_29_Kreadonly_defined_28file_attribute_reparse_point_29_Kreparse_point_defined_28file_attribute_sparse_file_29_Ksparse_file_defined_28file_attribute_system_29_Ksystem_defined_28file_attribute_temporary_29_Ktemporary__29_29;
#endif
#if defined(HAVE_NFTW)
  object_initdata_t _object___28or_20integer_20_28member_defined_28ftw_f_29_Kf_defined_28ftw_d_29_Kd_defined_28ftw_dp_29_Kdp_defined_28ftw_sl_29_Ksl_defined_28ftw_sln_29_Ksln_defined_28ftw_dnr_29_Kdnr_defined_28ftw_ns_29_Kns__29_29;
#endif
#if defined(HAVE_FCNTL)
  object_initdata_t _object___28or_20integer_20_28member_defined_28f_getfd_29_Kfd_defined_28f_getfl_29_Kfl__29_29;
#endif
#if defined(HAVE_SYSLOG)
  object_initdata_t _object___28or_20integer_20_28member_defined_28log_emerg_29_Kemerg_defined_28log_alert_29_Kalert_defined_28log_crit_29_Kcrit_defined_28log_err_29_Kerr_defined_28log_warning_29_Kwarning_defined_28log_notice_29_Knotice_defined_28log_info_29_Kinfo_defined_28log_debug_29_Kdebug__29_29;
#endif
#if defined(HAVE_FCNTL)
  object_initdata_t _object___28or_20integer_20_28member_defined_28o_rdonly_29_Krdonly_defined_28o_wronly_29_Kwronly_defined_28o_rdwr_29_Krdwr_defined_28o_append_29_Kappend_defined_28o_creat_29_Kcreat_defined_28o_trunc_29_Ktrunc_defined_28o_excl_29_Kexcl_defined_28o_noctty_29_Knoctty_defined_28o_sync_29_Ksync_defined_28o_nonblock_29_Knonblock_defined_28o_binary_29_Kbinary_defined_28o_text_29_Ktext_defined_28o_noinherit_29_Knoinherit_defined_28o_direct_29_Kdirect_defined_28o_largefile_29_Klargefile_defined_28o_directory_29_Kdirectory_defined_28o_nofollow_29_Knofollow__29_29;
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  object_initdata_t _object___28or_20integer_20_28member_defined_28processor_architecture_intel_29_Kintel_defined_28processor_architecture_mips_29_Kmips_defined_28processor_architecture_alpha_29_Kalpha_defined_28processor_architecture_ppc_29_Kppc_defined_28processor_architecture_shx_29_Kshx_defined_28processor_architecture_arm_29_Karm_defined_28processor_architecture_ia64_29_Kia64_defined_28processor_architecture_alpha64_29_Kalpha64_defined_28processor_architecture_msil_29_Kmsil_defined_28processor_architecture_amd64_29_Kamd64_defined_28processor_architecture_ia32_on_win64_29_Kia32_on_win64_defined_28processor_architecture_unknown_29_Kunknown__29_29;
#endif
#if defined(HAVE_GETRLIMIT) || defined(HAVE_SETRLIMIT)
  object_initdata_t _object___28or_20integer_20_28member_defined_28rlimit_cpu_29_Kcpu_defined_28rlimit_fsize_29_Kfsize_defined_28rlimit_data_29_Kdata_defined_28rlimit_stack_29_Kstack_defined_28rlimit_core_29_Kcore_defined_28rlimit_rss_29_Krss_defined_28rlimit_nofile_29_Knofile_defined_28rlimit_as_29_Kas_defined_28rlimit_nproc_29_Knproc_defined_28rlimit_memlock_29_Kmemlock_defined_28rlimit_locks_29_Klocks__29_29;
#endif
#if (defined(HAVE_SYS_RESOURCE_H)) && (defined(HAVE_GETRUSAGE))
  object_initdata_t _object___28or_20integer_20_28member_defined_28rusage_self_29_Kself_defined_28rusage_children_29_Kchildren_defined_28rusage_thread_29_Kthread_defined_28rusage_lwp_29_Klwp__29_29;
#endif
  object_initdata_t _object___28or_20integer_20_28member_defined_28sigabrt_29_Ksigabrt_defined_28sigalrm_29_Ksigalrm_defined_28sigbus_29_Ksigbus_defined_28sigchld_29_Ksigchld_defined_28sigcont_29_Ksigcont_defined_28sigfpe_29_Ksigfpe_defined_28sighup_29_Ksighup_defined_28sigill_29_Ksigill_defined_28sigint_29_Ksigint_defined_28sigkill_29_Ksigkill_defined_28sigpipe_29_Ksigpipe_defined_28sigquit_29_Ksigquit_defined_28sigsegv_29_Ksigsegv_defined_28sigstop_29_Ksigstop_defined_28sigterm_29_Ksigterm_defined_28sigtstp_29_Ksigtstp_defined_28sigttin_29_Ksigttin_defined_28sigttou_29_Ksigttou_defined_28sigusr1_29_Ksigusr1_defined_28sigusr2_29_Ksigusr2_defined_28sigpoll_29_Ksigpoll_defined_28sigprof_29_Ksigprof_defined_28sigsys_29_Ksigsys_defined_28sigtrap_29_Ksigtrap_defined_28sigurg_29_Ksigurg_defined_28sigvtalrm_29_Ksigvtalrm_defined_28sigxcpu_29_Ksigxcpu_defined_28sigxfsz_29_Ksigxfsz__29_29;
#if defined(WIN32_NATIVE) || (defined(HAVE_STATVFS) && defined(HAVE_SYS_STATVFS_H))
  object_initdata_t _object___28or_20integer_20_28member_defined_28st_rdonly_29_Kst_rdonly_defined_28st_nosuid_29_Kst_nosuid_defined_28st_notrunc_29_Kst_notrunc_defined_28st_nodev_29_Kst_nodev_defined_28st_noexec_29_Kst_noexec_defined_28st_synchronous_29_Kst_synchronous_defined_28st_mandlock_29_Kst_mandlock_defined_28st_write_29_Kst_write_defined_28st_append_29_Kst_append_defined_28st_immutable_29_Kst_immutable_defined_28st_noatime_29_Kst_noatime_defined_28st_nodiratime_29_Kst_nodiratime_defined_28file_named_streams_29_Kfile_named_streams_defined_28file_read_only_volume_29_Kfile_read_only_volume_defined_28file_supports_object_ids_29_Kfile_supports_object_ids_defined_28file_supports_reparse_points_29_Kfile_supports_reparse_points_defined_28file_supports_sparse_files_29_Kfile_supports_sparse_files_defined_28file_volume_quotas_29_Kfile_volume_quotas_defined_28file_supports_encryption_29_Kfile_supports_encryption_defined_28fs_case_is_preserved_29_Kfs_case_is_preserved_defined_28fs_case_sensitive_29_Kfs_case_sensitive_defined_28fs_file_compression_29_Kfs_file_compression_defined_28fs_file_encryption_29_Kfs_file_encryption_defined_28fs_persistent_acls_29_Kfs_persistent_acls_defined_28fs_unicode_stored_on_disk_29_Kfs_unicode_stored_on_disk_defined_28fs_vol_is_compressed_29_Kfs_vol_is_compressed__29_29;
#endif
  object_initdata_t _object___28or_20integer_20_28member_defined_28s_ififo_29_Kfifo_defined_28s_ifsock_29_Kfsock_defined_28s_ifchr_29_Kfchr_defined_28s_ifdir_29_Kfdir_defined_28s_ifblk_29_Kfblk_defined_28s_ifreg_29_Kfreg__29_29;
  object_initdata_t _object___28or_20integer_20_28member_defined_28s_isuid_29_Ksuid_defined_28s_isgid_29_Ksgid_defined_28s_isvtx_29_Ksvtx_defined_28s_irwxu_29_Krwxu_defined_28s_irusr_29_Krusr_defined_28s_iwusr_29_Kwusr_defined_28s_ixusr_29_Kxusr_defined_28s_irwxg_29_Krwxg_defined_28s_irgrp_29_Krgrp_defined_28s_iwgrp_29_Kwgrp_defined_28s_ixgrp_29_Kxgrp_defined_28s_irwxo_29_Krwxo_defined_28s_iroth_29_Kroth_defined_28s_iwoth_29_Kwoth_defined_28s_ixoth_29_Kxoth__29_29;
#if defined(HAVE_CONFSTR)
  object_initdata_t _object___28or_20integer_20_28member_defined_28_cs_path_29_Kpath_defined_28_cs_posix_v6_ilp32_off32_cflags_29_Kposix_v6_ilp32_off32_cflags_defined_28_cs_posix_v6_ilp32_off32_ldflags_29_Kposix_v6_ilp32_off32_ldflags_defined_28_cs_posix_v6_ilp32_off32_libs_29_Kposix_v6_ilp32_off32_libs_defined_28_cs_posix_v6_ilp32_offbig_cflags_29_Kposix_v6_ilp32_offbig_cflags_defined_28_cs_posix_v6_ilp32_offbig_ldflags_29_Kposix_v6_ilp32_offbig_ldflags_defined_28_cs_posix_v6_ilp32_offbig_libs_29_Kposix_v6_ilp32_offbig_libs_defined_28_cs_posix_v6_lp64_off64_cflags_29_Kposix_v6_lp64_off64_cflags_defined_28_cs_posix_v6_lp64_off64_ldflags_29_Kposix_v6_lp64_off64_ldflags_defined_28_cs_posix_v6_lp64_off64_libs_29_Kposix_v6_lp64_off64_libs_defined_28_cs_posix_v6_lpbig_offbig_cflags_29_Kposix_v6_lpbig_offbig_cflags_defined_28_cs_posix_v6_lpbig_offbig_ldflags_29_Kposix_v6_lpbig_offbig_ldflags_defined_28_cs_posix_v6_lpbig_offbig_libs_29_Kposix_v6_lpbig_offbig_libs_defined_28_cs_posix_v6_width_restricted_envs_29_Kposix_v6_width_restricted_envs_defined_28_cs_v7_env_29_Kv7_env_defined_28_cs_posix_v7_ilp32_off32_cflags_29_Kposix_v7_ilp32_off32_cflags_defined_28_cs_posix_v7_ilp32_off32_ldflags_29_Kposix_v7_ilp32_off32_ldflags_defined_28_cs_posix_v7_ilp32_off32_libs_29_Kposix_v7_ilp32_off32_libs_defined_28_cs_posix_v7_ilp32_offbig_cflags_29_Kposix_v7_ilp32_offbig_cflags_defined_28_cs_posix_v7_ilp32_offbig_ldflags_29_Kposix_v7_ilp32_offbig_ldflags_defined_28_cs_posix_v7_ilp32_offbig_libs_29_Kposix_v7_ilp32_offbig_libs_defined_28_cs_posix_v7_lp64_off64_cflags_29_Kposix_v7_lp64_off64_cflags_defined_28_cs_posix_v7_lp64_off64_ldflags_29_Kposix_v7_lp64_off64_ldflags_defined_28_cs_posix_v7_lp64_off64_libs_29_Kposix_v7_lp64_off64_libs_defined_28_cs_posix_v7_lpbig_offbig_cflags_29_Kposix_v7_lpbig_offbig_cflags_defined_28_cs_posix_v7_lpbig_offbig_ldflags_29_Kposix_v7_lpbig_offbig_ldflags_defined_28_cs_posix_v7_lpbig_offbig_libs_29_Kposix_v7_lpbig_offbig_libs_defined_28_cs_posix_v7_threads_cflags_29_Kposix_v7_t;
#endif
#if defined(HAVE_PATHCONF) && defined(HAVE_FPATHCONF)
  object_initdata_t _object___28or_20integer_20_28member_defined_28_pc_filesizebits_29_Kfilesizebits_defined_28_pc_link_max_29_Klink_max_defined_28_pc_max_canon_29_Kmax_canon_defined_28_pc_max_input_29_Kmax_input_defined_28_pc_name_max_29_Kname_max_defined_28_pc_path_max_29_Kpath_max_defined_28_pc_pipe_buf_29_Kpipe_buf_defined_28_pc_2_symlinks_29_K2_symlinks_defined_28_pc_alloc_size_min_29_Kalloc_size_min_defined_28_pc_rec_incr_xfer_size_29_Krec_incr_xfer_size_defined_28_pc_rec_max_xfer_size_29_Krec_max_xfer_size_defined_28_pc_rec_min_xfer_size_29_Krec_min_xfer_size_defined_28_pc_rec_xfer_align_29_Krec_xfer_align_defined_28_pc_symlink_max_29_Ksymlink_max_defined_28_pc_chown_restricted_29_Kchown_restricted_defined_28_pc_no_trunc_29_Kno_trunc_defined_28_pc_vdisable_29_Kvdisable_defined_28_pc_async_io_29_Kasync_io_defined_28_pc_prio_io_29_Kprio_io_defined_28_pc_sync_io_29_Ksync_io_defined_28_pc_sock_maxbuf_29_Ksock_maxbuf__29_29;
#endif
#if defined(HAVE_SYSCONF)
  object_initdata_t _object___28or_20integer_20_28member_defined_28_sc_aio_listio_max_29_Kaio_listio_max_defined_28_sc_aio_max_29_Kaio_max_defined_28_sc_aio_prio_delta_max_29_Kaio_prio_delta_max_defined_28_sc_arg_max_29_Karg_max_defined_28_sc_atexit_max_29_Katexit_max_defined_28_sc_bc_base_max_29_Kbc_base_max_defined_28_sc_bc_dim_max_29_Kbc_dim_max_defined_28_sc_bc_scale_max_29_Kbc_scale_max_defined_28_sc_bc_string_max_29_Kbc_string_max_defined_28_sc_child_max_29_Kchild_max_defined_28_sc_clk_tck_29_Kclk_tck_defined_28_sc_coll_weights_max_29_Kcoll_weights_max_defined_28_sc_delaytimer_max_29_Kdelaytimer_max_defined_28_sc_expr_nest_max_29_Kexpr_nest_max_defined_28_sc_host_name_max_29_Khost_name_max_defined_28_sc_iov_max_29_Kiov_max_defined_28_sc_line_max_29_Kline_max_defined_28_sc_login_name_max_29_Klogin_name_max_defined_28_sc_ngroups_max_29_Kngroups_max_defined_28_sc_getgr_r_size_max_29_Kgetgr_r_size_max_defined_28_sc_getpw_r_size_max_29_Kgetpw_r_size_max_defined_28_sc_mq_open_max_29_Kmq_open_max_defined_28_sc_mq_prio_max_29_Kmq_prio_max_defined_28_sc_open_max_29_Kopen_max_defined_28_sc_advisory_info_29_Kadvisory_info_defined_28_sc_barriers_29_Kbarriers_defined_28_sc_asynchronous_io_29_Kasynchronous_io_defined_28_sc_clock_selection_29_Kclock_selection_defined_28_sc_cputime_29_Kcputime_defined_28_sc_fsync_29_Kfsync_defined_28_sc_ipv6_29_Kipv6_defined_28_sc_job_control_29_Kjob_control_defined_28_sc_mapped_files_29_Kmapped_files_defined_28_sc_memlock_29_Kmemlock_defined_28_sc_memlock_range_29_Kmemlock_range_defined_28_sc_memory_protection_29_Kmemory_protection_defined_28_sc_message_passing_29_Kmessage_passing_defined_28_sc_monotonic_clock_29_Kmonotonic_clock_defined_28_sc_prioritized_io_29_Kprioritized_io_defined_28_sc_priority_scheduling_29_Kpriority_scheduling_defined_28_sc_raw_sockets_29_Kraw_sockets_defined_28_sc_reader_writer_locks_29_Kreader_writer_locks_defined_28_sc_realtime_signals_29_Krealtime_signals_defined_28_sc_regexp_29_Kregexp_defined_28_sc_saved_ids_29_Ksaved_ids_defined_28;
#endif
#if defined(HAVE_SYSLOG)
  object_initdata_t _object___28or_20null_20integer_20_28member_defined_28log_kern_29_Kkern_defined_28log_user_29_Kuser_defined_28log_mail_29_Kmail_defined_28log_news_29_Knews_defined_28log_uucp_29_Kuucp_defined_28log_daemon_29_Kdaemon_defined_28log_auth_29_Kauth_defined_28log_cron_29_Kcron_defined_28log_lpr_29_Klpr_defined_28log_syslog_29_Ksyslog_defined_28log_authpriv_29_Kauthpriv_defined_28log_ftp_29_Kftp_defined_28log_local0_29_Klocal0_defined_28log_local1_29_Klocal1_defined_28log_local2_29_Klocal2_defined_28log_local3_29_Klocal3_defined_28log_local4_29_Klocal4_defined_28log_local5_29_Klocal5_defined_28log_local6_29_Klocal6_defined_28log_local7_29_Klocal7__29_29;
#endif
  object_initdata_t _object___28or_20null_20integer_20_28member_defined_28prio_process_29_Kprocess_defined_28prio_pgrp_29_Kpgrp_defined_28prio_user_29_Kuser__29_29;
#if defined(WIN32_NATIVE)
  object_initdata_t _object___28or_20null_20integer_20_28member_defined_28realtime_priority_class_29_Krealtime_defined_28high_priority_class_29_Khigh_defined_28above_normal_priority_class_29_Kabove_normal_defined_28normal_priority_class_29_Knormal_defined_28below_normal_priority_class_29_Kbelow_normal_defined_28low_priority_class_29_Klow_defined_28idle_priority_class_29_Kidle__29_29;
#endif
#if !(defined(WIN32_NATIVE))
  object_initdata_t _object___28or_20null_20integer_20_28member_Krealtime_Khigh_Kabove_normal_Knormal_Kbelow_normal_Klow_Kidle__29_29;
#endif
  object_initdata_t _my_stdin;
  object_initdata_t _my_stdout;
  object_initdata_t _my_stderr;
  int _dummy_to_avoid_trailing_comma_in_initializer;
} module__syscalls__object_tab_initdata = {
  { "CL:DECODE-UNIVERSAL-TIME" },
#if (defined(HAVE_SYSCONF)) && (defined(_SC_2_CHAR_TERM))
  { ":2-CHAR-TERM" },
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_2_C_BIND))
  { ":2-C-BIND" },
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_2_C_DEV))
  { ":2-C-DEV" },
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_2_FORT_DEV))
  { ":2-FORT-DEV" },
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_2_FORT_RUN))
  { ":2-FORT-RUN" },
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_2_LOCALEDEF))
  { ":2-LOCALEDEF" },
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_2_PBS))
  { ":2-PBS" },
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_2_PBS_ACCOUNTING))
  { ":2-PBS-ACCOUNTING" },
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_2_PBS_CHECKPOINT))
  { ":2-PBS-CHECKPOINT" },
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_2_PBS_LOCATE))
  { ":2-PBS-LOCATE" },
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_2_PBS_MESSAGE))
  { ":2-PBS-MESSAGE" },
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_2_PBS_TRACK))
  { ":2-PBS-TRACK" },
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_2_SW_DEV))
  { ":2-SW-DEV" },
#endif
#if (defined(HAVE_PATHCONF) && defined(HAVE_FPATHCONF)) && (defined(_PC_2_SYMLINKS))
  { ":2-SYMLINKS" },
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_2_UPE))
  { ":2-UPE" },
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_2_VERSION))
  { ":2-VERSION" },
#endif
#if ((defined(WIN32_NATIVE)) && (defined(ABOVE_NORMAL_PRIORITY_CLASS))) || (!(defined(WIN32_NATIVE)))
  { ":ABOVE-NORMAL" },
#endif
#if (defined(HAVE_UTMPX_H)) && (defined(ACCOUNTING))
  { ":ACCOUNTING" },
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_ADVISORY_INFO))
  { ":ADVISORY-INFO" },
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_AIO_LISTIO_MAX))
  { ":AIO-LISTIO-MAX" },
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_AIO_MAX))
  { ":AIO-MAX" },
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_AIO_PRIO_DELTA_MAX))
  { ":AIO-PRIO-DELTA-MAX" },
#endif
#if (defined(HAVE_SYSLOG)) && (defined(LOG_ALERT))
  { ":ALERT" },
#endif
#if (defined(HAVE_PATHCONF) && defined(HAVE_FPATHCONF)) && (defined(_PC_ALLOC_SIZE_MIN))
  { ":ALLOC-SIZE-MIN" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(PROCESSOR_ARCHITECTURE_ALPHA))
  { ":ALPHA" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(PROCESSOR_ARCHITECTURE_ALPHA64))
  { ":ALPHA64" },
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  { ":ALT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(PROCESSOR_ARCHITECTURE_AMD64))
  { ":AMD64" },
#endif
#if (defined(HAVE_FCNTL)) && (defined(O_APPEND))
  { ":APPEND" },
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  { ":APPNAME" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(FILE_ATTRIBUTE_ARCHIVE))
  { ":ARCHIVE" },
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  { ":ARGUMENTS" },
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_ARG_MAX))
  { ":ARG-MAX" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(PROCESSOR_ARCHITECTURE_ARM))
  { ":ARM" },
#endif
#if (defined(HAVE_GETRLIMIT) || defined(HAVE_SETRLIMIT)) && (defined(RLIMIT_AS))
  { ":AS" },
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_ASYNCHRONOUS_IO))
  { ":ASYNCHRONOUS-IO" },
#endif
#if (defined(HAVE_PATHCONF) && defined(HAVE_FPATHCONF)) && (defined(_PC_ASYNC_IO))
  { ":ASYNC-IO" },
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_ATEXIT_MAX))
  { ":ATEXIT-MAX" },
#endif
#if defined(HAVE_STAT) && (defined(HAVE_CHMOD) || defined(HAVE_CHOWN) || defined(HAVE_UTIME))
  { ":ATIME" },
#endif
#if (defined(HAVE_SYSLOG)) && (defined(LOG_AUTH))
  { ":AUTH" },
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  { ":AUTHOR" },
#endif
#if (defined(HAVE_SYSLOG)) && (defined(LOG_AUTHPRIV))
  { ":AUTHPRIV" },
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_AVPHYS_PAGES))
  { ":AVPHYS-PAGES" },
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  { ":BACKOFFICE" },
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_BARRIERS))
  { ":BARRIERS" },
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_BC_BASE_MAX))
  { ":BC-BASE-MAX" },
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_BC_DIM_MAX))
  { ":BC-DIM-MAX" },
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_BC_SCALE_MAX))
  { ":BC-SCALE-MAX" },
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_BC_STRING_MAX))
  { ":BC-STRING-MAX" },
#endif
#if ((defined(WIN32_NATIVE)) && (defined(BELOW_NORMAL_PRIORITY_CLASS))) || (!(defined(WIN32_NATIVE)))
  { ":BELOW-NORMAL" },
#endif
#if (defined(HAVE_FCNTL)) && (defined(O_BINARY))
  { ":BINARY" },
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  { ":BLOB" },
#endif
#if defined(HAVE_FCNTL) || defined(WIN32_NATIVE)
  { ":BLOCK" },
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  { ":BOOL" },
#endif
#if (defined(HAVE_UTMPX_H)) && (defined(BOOT_TIME))
  { ":BOOT-TIME" },
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  { ":BSTR" },
#endif
  { ":BUFFERED" },
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  { ":BUILT-IN" },
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  { ":BYREF" },
#endif
  { ":CASE-SENSITIVE" },
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  { ":CHARCOUNT" },
#endif
#if defined(HAVE_NFTW)
  { ":CHDIR" },
#endif
#if (defined(HAVE_SYS_RESOURCE_H)) && (defined(HAVE_GETRUSAGE)) && (defined(RUSAGE_CHILDREN))
  { ":CHILDREN" },
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_CHILD_MAX))
  { ":CHILD-MAX" },
#endif
#if (defined(HAVE_PATHCONF) && defined(HAVE_FPATHCONF)) && (defined(_PC_CHOWN_RESTRICTED))
  { ":CHOWN-RESTRICTED" },
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  { ":CLIPBOARD-FORMAT" },
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_CLK_TCK))
  { ":CLK-TCK" },
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_CLOCK_SELECTION))
  { ":CLOCK-SELECTION" },
#endif
#if (defined(HAVE_FCNTL)) && (defined(FD_CLOEXEC))
  { ":CLOEXEC" },
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  { ":CODEPAGE" },
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_COLL_WEIGHTS_MAX))
  { ":COLL-WEIGHTS-MAX" },
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  { ":COMMENTS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(FILE_ATTRIBUTE_COMPRESSED))
  { ":COMPRESSED" },
#endif
#if (defined(HAVE_SYSLOG)) && (defined(HAVE_OPENLOG))
  { ":CONS" },
#endif
#if defined(HAVE_SYS_RESOURCE_H)
  { ":CONTINUED" },
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  { ":CONTROL" },
#endif
  { ":COPY" },
#if (defined(HAVE_GETRLIMIT) || defined(HAVE_SETRLIMIT)) && (defined(RLIMIT_CORE))
  { ":CORE" },
#endif
#if (defined(HAVE_GETRLIMIT) || defined(HAVE_SETRLIMIT)) && (defined(RLIMIT_CPU))
  { ":CPU" },
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_CPUTIME))
  { ":CPUTIME" },
#endif
#if (defined(HAVE_FCNTL)) && (defined(O_CREAT))
  { ":CREAT" },
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  { ":CREATE-DTM" },
#endif
#if (defined(HAVE_SYSLOG)) && (defined(LOG_CRIT))
  { ":CRIT" },
#endif
#if (defined(HAVE_SYSLOG)) && (defined(LOG_CRON))
  { ":CRON" },
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  { ":CY" },
#endif
#if (defined(HAVE_NFTW)) && (defined(FTW_D))
  { ":D" },
#endif
#if (defined(HAVE_SYSLOG)) && (defined(LOG_DAEMON))
  { ":DAEMON" },
#endif
#if (defined(HAVE_GETRLIMIT) || defined(HAVE_SETRLIMIT)) && (defined(RLIMIT_DATA))
  { ":DATA" },
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  { ":DATACENTER" },
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  { ":DATE" },
#endif
#if (defined(HAVE_UTMPX_H)) && (defined(DEAD_PROCESS))
  { ":DEAD-PROCESS" },
#endif
#if (defined(HAVE_SYSLOG)) && (defined(LOG_DEBUG))
  { ":DEBUG" },
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_DELAYTIMER_MAX))
  { ":DELAYTIMER-MAX" },
#endif
#if defined(HAVE_NFTW)
  { ":DEPTH" },
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  { ":DESCRIPTION" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(FILE_ATTRIBUTE_DEVICE))
  { ":DEVICE" },
#endif
#if (defined(HAVE_FCNTL)) && (defined(O_DIRECT))
  { ":DIRECT" },
#endif
  { ":DIRECTION" },
#if ((defined(HAVE_FCNTL)) && (defined(O_DIRECTORY))) || ((defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(FILE_ATTRIBUTE_DIRECTORY)))
  { ":DIRECTORY" },
#endif
#if (defined(HAVE_NFTW)) && (defined(FTW_DNR))
  { ":DNR" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_AUTOZONE_ALREADY_EXISTS))
  { ":DNS_ERROR_AUTOZONE_ALREADY_EXISTS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_AXFR))
  { ":DNS_ERROR_AXFR" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_BAD_PACKET))
  { ":DNS_ERROR_BAD_PACKET" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_CANNOT_FIND_ROOT_HINTS))
  { ":DNS_ERROR_CANNOT_FIND_ROOT_HINTS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_CNAME_COLLISION))
  { ":DNS_ERROR_CNAME_COLLISION" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_CNAME_LOOP))
  { ":DNS_ERROR_CNAME_LOOP" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_DATAFILE_OPEN_FAILURE))
  { ":DNS_ERROR_DATAFILE_OPEN_FAILURE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_DATAFILE_PARSING))
  { ":DNS_ERROR_DATAFILE_PARSING" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_DP_ALREADY_ENLISTED))
  { ":DNS_ERROR_DP_ALREADY_ENLISTED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_DP_ALREADY_EXISTS))
  { ":DNS_ERROR_DP_ALREADY_EXISTS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_DP_DOES_NOT_EXIST))
  { ":DNS_ERROR_DP_DOES_NOT_EXIST" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_DP_NOT_AVAILABLE))
  { ":DNS_ERROR_DP_NOT_AVAILABLE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_DP_NOT_ENLISTED))
  { ":DNS_ERROR_DP_NOT_ENLISTED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_DS_UNAVAILABLE))
  { ":DNS_ERROR_DS_UNAVAILABLE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_DS_ZONE_ALREADY_EXISTS))
  { ":DNS_ERROR_DS_ZONE_ALREADY_EXISTS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_FILE_WRITEBACK_FAILED))
  { ":DNS_ERROR_FILE_WRITEBACK_FAILED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_FORWARDER_ALREADY_EXISTS))
  { ":DNS_ERROR_FORWARDER_ALREADY_EXISTS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_INCONSISTENT_ROOT_HINTS))
  { ":DNS_ERROR_INCONSISTENT_ROOT_HINTS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_INVALID_DATAFILE_NAME))
  { ":DNS_ERROR_INVALID_DATAFILE_NAME" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_INVALID_IP_ADDRESS))
  { ":DNS_ERROR_INVALID_IP_ADDRESS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_INVALID_NAME_CHAR))
  { ":DNS_ERROR_INVALID_NAME_CHAR" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_INVALID_PROPERTY))
  { ":DNS_ERROR_INVALID_PROPERTY" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_INVALID_TYPE))
  { ":DNS_ERROR_INVALID_TYPE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_INVALID_ZONE_OPERATION))
  { ":DNS_ERROR_INVALID_ZONE_OPERATION" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_INVALID_ZONE_TYPE))
  { ":DNS_ERROR_INVALID_ZONE_TYPE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_NAME_DOES_NOT_EXIST))
  { ":DNS_ERROR_NAME_DOES_NOT_EXIST" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_NAME_NOT_IN_ZONE))
  { ":DNS_ERROR_NAME_NOT_IN_ZONE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_NBSTAT_INIT_FAILED))
  { ":DNS_ERROR_NBSTAT_INIT_FAILED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_NEED_SECONDARY_ADDRESSES))
  { ":DNS_ERROR_NEED_SECONDARY_ADDRESSES" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_NEED_WINS_SERVERS))
  { ":DNS_ERROR_NEED_WINS_SERVERS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_NODE_CREATION_FAILED))
  { ":DNS_ERROR_NODE_CREATION_FAILED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_NODE_IS_CNAME))
  { ":DNS_ERROR_NODE_IS_CNAME" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_NON_RFC_NAME))
  { ":DNS_ERROR_NON_RFC_NAME" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_NOT_ALLOWED_ON_ROOT_SERVER))
  { ":DNS_ERROR_NOT_ALLOWED_ON_ROOT_SERVER" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_NOT_ALLOWED_UNDER_DELEGATION))
  { ":DNS_ERROR_NOT_ALLOWED_UNDER_DELEGATION" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_NOT_UNIQUE))
  { ":DNS_ERROR_NOT_UNIQUE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_NO_BOOTFILE_IF_DS_ZONE))
  { ":DNS_ERROR_NO_BOOTFILE_IF_DS_ZONE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_NO_CREATE_CACHE_DATA))
  { ":DNS_ERROR_NO_CREATE_CACHE_DATA" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_NO_DNS_SERVERS))
  { ":DNS_ERROR_NO_DNS_SERVERS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_NO_PACKET))
  { ":DNS_ERROR_NO_PACKET" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_NO_TCPIP))
  { ":DNS_ERROR_NO_TCPIP" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_NO_ZONE_INFO))
  { ":DNS_ERROR_NO_ZONE_INFO" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_NUMERIC_NAME))
  { ":DNS_ERROR_NUMERIC_NAME" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_PRIMARY_REQUIRES_DATAFILE))
  { ":DNS_ERROR_PRIMARY_REQUIRES_DATAFILE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_RCODE))
  { ":DNS_ERROR_RCODE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_RCODE_BADKEY))
  { ":DNS_ERROR_RCODE_BADKEY" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_RCODE_BADSIG))
  { ":DNS_ERROR_RCODE_BADSIG" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_RCODE_BADTIME))
  { ":DNS_ERROR_RCODE_BADTIME" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_RCODE_FORMAT_ERROR))
  { ":DNS_ERROR_RCODE_FORMAT_ERROR" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_RCODE_NAME_ERROR))
  { ":DNS_ERROR_RCODE_NAME_ERROR" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_RCODE_NOTAUTH))
  { ":DNS_ERROR_RCODE_NOTAUTH" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_RCODE_NOTZONE))
  { ":DNS_ERROR_RCODE_NOTZONE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_RCODE_NOT_IMPLEMENTED))
  { ":DNS_ERROR_RCODE_NOT_IMPLEMENTED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_RCODE_NXRRSET))
  { ":DNS_ERROR_RCODE_NXRRSET" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_RCODE_REFUSED))
  { ":DNS_ERROR_RCODE_REFUSED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_RCODE_SERVER_FAILURE))
  { ":DNS_ERROR_RCODE_SERVER_FAILURE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_RCODE_YXDOMAIN))
  { ":DNS_ERROR_RCODE_YXDOMAIN" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_RCODE_YXRRSET))
  { ":DNS_ERROR_RCODE_YXRRSET" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_RECORD_ALREADY_EXISTS))
  { ":DNS_ERROR_RECORD_ALREADY_EXISTS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_RECORD_DOES_NOT_EXIST))
  { ":DNS_ERROR_RECORD_DOES_NOT_EXIST" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_RECORD_FORMAT))
  { ":DNS_ERROR_RECORD_FORMAT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_RECORD_ONLY_AT_ZONE_ROOT))
  { ":DNS_ERROR_RECORD_ONLY_AT_ZONE_ROOT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_RECORD_TIMED_OUT))
  { ":DNS_ERROR_RECORD_TIMED_OUT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_SECONDARY_DATA))
  { ":DNS_ERROR_SECONDARY_DATA" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_SECONDARY_REQUIRES_MASTER_IP))
  { ":DNS_ERROR_SECONDARY_REQUIRES_MASTER_IP" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_SOA_DELETE_INVALID))
  { ":DNS_ERROR_SOA_DELETE_INVALID" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_TRY_AGAIN_LATER))
  { ":DNS_ERROR_TRY_AGAIN_LATER" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_UNKNOWN_RECORD_TYPE))
  { ":DNS_ERROR_UNKNOWN_RECORD_TYPE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_UNSECURE_PACKET))
  { ":DNS_ERROR_UNSECURE_PACKET" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_WINS_INIT_FAILED))
  { ":DNS_ERROR_WINS_INIT_FAILED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_ZONE_ALREADY_EXISTS))
  { ":DNS_ERROR_ZONE_ALREADY_EXISTS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_ZONE_CONFIGURATION_ERROR))
  { ":DNS_ERROR_ZONE_CONFIGURATION_ERROR" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_ZONE_CREATION_FAILED))
  { ":DNS_ERROR_ZONE_CREATION_FAILED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_ZONE_DOES_NOT_EXIST))
  { ":DNS_ERROR_ZONE_DOES_NOT_EXIST" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_ZONE_HAS_NO_NS_RECORDS))
  { ":DNS_ERROR_ZONE_HAS_NO_NS_RECORDS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_ZONE_HAS_NO_SOA_RECORD))
  { ":DNS_ERROR_ZONE_HAS_NO_SOA_RECORD" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_ZONE_IS_SHUTDOWN))
  { ":DNS_ERROR_ZONE_IS_SHUTDOWN" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_ZONE_LOCKED))
  { ":DNS_ERROR_ZONE_LOCKED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_ZONE_NOT_SECONDARY))
  { ":DNS_ERROR_ZONE_NOT_SECONDARY" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_ERROR_ZONE_REQUIRES_MASTER_IP))
  { ":DNS_ERROR_ZONE_REQUIRES_MASTER_IP" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_INFO_ADDED_LOCAL_WINS))
  { ":DNS_INFO_ADDED_LOCAL_WINS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_INFO_AXFR_COMPLETE))
  { ":DNS_INFO_AXFR_COMPLETE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_INFO_NO_RECORDS))
  { ":DNS_INFO_NO_RECORDS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_STATUS_CONTINUE_NEEDED))
  { ":DNS_STATUS_CONTINUE_NEEDED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_STATUS_DOTTED_NAME))
  { ":DNS_STATUS_DOTTED_NAME" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_STATUS_FQDN))
  { ":DNS_STATUS_FQDN" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_STATUS_SINGLE_PART_NAME))
  { ":DNS_STATUS_SINGLE_PART_NAME" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_WARNING_DOMAIN_UNDELETED))
  { ":DNS_WARNING_DOMAIN_UNDELETED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(DNS_WARNING_PTR_CREATE_FAILED))
  { ":DNS_WARNING_PTR_CREATE_FAILED" },
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  { ":DOC-SECURITY" },
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  { ":DOMAIN-CONTROLLER" },
#endif
#if (defined(HAVE_NFTW)) && (defined(FTW_DP))
  { ":DP" },
#endif
#if defined(E2BIG)
  { ":E2BIG" },
#endif
#if defined(EACCES)
  { ":EACCES" },
#endif
#if defined(EADDRINUSE)
  { ":EADDRINUSE" },
#endif
#if defined(EADDRNOTAVAIL)
  { ":EADDRNOTAVAIL" },
#endif
#if defined(EADV)
  { ":EADV" },
#endif
#if defined(EAFNOSUPPORT)
  { ":EAFNOSUPPORT" },
#endif
#if defined(EAGAIN)
  { ":EAGAIN" },
#endif
#if defined(EAIO)
  { ":EAIO" },
#endif
#if defined(EALIGN)
  { ":EALIGN" },
#endif
#if defined(EALREADY)
  { ":EALREADY" },
#endif
#if defined(EAUTH)
  { ":EAUTH" },
#endif
#if defined(EBADE)
  { ":EBADE" },
#endif
#if defined(EBADF)
  { ":EBADF" },
#endif
#if defined(EBADFD)
  { ":EBADFD" },
#endif
#if defined(EBADMSG)
  { ":EBADMSG" },
#endif
#if defined(EBADR)
  { ":EBADR" },
#endif
#if defined(EBADRPC)
  { ":EBADRPC" },
#endif
#if defined(EBADRQC)
  { ":EBADRQC" },
#endif
#if defined(EBADSLT)
  { ":EBADSLT" },
#endif
#if defined(EBFONT)
  { ":EBFONT" },
#endif
#if defined(EBUSY)
  { ":EBUSY" },
#endif
#if defined(ECANCELED)
  { ":ECANCELED" },
#endif
#if defined(ECASECLASH)
  { ":ECASECLASH" },
#endif
#if defined(ECHILD)
  { ":ECHILD" },
#endif
#if defined(ECHRNG)
  { ":ECHRNG" },
#endif
#if defined(ECLONEME)
  { ":ECLONEME" },
#endif
#if defined(ECOMM)
  { ":ECOMM" },
#endif
#if defined(ECONNABORTED)
  { ":ECONNABORTED" },
#endif
#if defined(ECONNREFUSED)
  { ":ECONNREFUSED" },
#endif
#if defined(ECONNRESET)
  { ":ECONNRESET" },
#endif
#if defined(EDEADLK)
  { ":EDEADLK" },
#endif
#if defined(EDEADLOCK)
  { ":EDEADLOCK" },
#endif
#if defined(EDESTADDRREQ)
  { ":EDESTADDRREQ" },
#endif
#if defined(EDIRIOCTL)
  { ":EDIRIOCTL" },
#endif
#if defined(EDIRTY)
  { ":EDIRTY" },
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  { ":EDITTIME" },
#endif
#if defined(EDOM)
  { ":EDOM" },
#endif
#if defined(EDOOFUS)
  { ":EDOOFUS" },
#endif
#if defined(EDOTDOT)
  { ":EDOTDOT" },
#endif
#if defined(EDQUOT)
  { ":EDQUOT" },
#endif
#if defined(EDUPPKG)
  { ":EDUPPKG" },
#endif
#if defined(EEXIST)
  { ":EEXIST" },
#endif
#if defined(EFAIL)
  { ":EFAIL" },
#endif
#if defined(EFAULT)
  { ":EFAULT" },
#endif
#if defined(EFBIG)
  { ":EFBIG" },
#endif
#if defined(EFTYPE)
  { ":EFTYPE" },
#endif
#if defined(EHOSTDOWN)
  { ":EHOSTDOWN" },
#endif
#if defined(EHOSTUNREACH)
  { ":EHOSTUNREACH" },
#endif
#if defined(EHWPOISON)
  { ":EHWPOISON" },
#endif
#if defined(EIDRM)
  { ":EIDRM" },
#endif
#if defined(EILSEQ)
  { ":EILSEQ" },
#endif
#if defined(EINIT)
  { ":EINIT" },
#endif
#if defined(EINPROG)
  { ":EINPROG" },
#endif
#if defined(EINPROGRESS)
  { ":EINPROGRESS" },
#endif
#if defined(EINTR)
  { ":EINTR" },
#endif
#if defined(EINVAL)
  { ":EINVAL" },
#endif
#if defined(EIO)
  { ":EIO" },
#endif
#if defined(EISCONN)
  { ":EISCONN" },
#endif
#if defined(EISDIR)
  { ":EISDIR" },
#endif
#if defined(EISNAM)
  { ":EISNAM" },
#endif
#if defined(EISNAME)
  { ":EISNAME" },
#endif
#if defined(EJUSTRETURN)
  { ":EJUSTRETURN" },
#endif
#if defined(EKEYEXPIRED)
  { ":EKEYEXPIRED" },
#endif
#if defined(EKEYREJECTED)
  { ":EKEYREJECTED" },
#endif
#if defined(EKEYREVOKED)
  { ":EKEYREVOKED" },
#endif
#if defined(EL2HLT)
  { ":EL2HLT" },
#endif
#if defined(EL2NSYNC)
  { ":EL2NSYNC" },
#endif
#if defined(EL3HLT)
  { ":EL3HLT" },
#endif
#if defined(EL3RST)
  { ":EL3RST" },
#endif
#if defined(ELAST)
  { ":ELAST" },
#endif
#if defined(ELBIN)
  { ":ELBIN" },
#endif
  { ":ELEMENT-TYPE" },
#if defined(ELIBACC)
  { ":ELIBACC" },
#endif
#if defined(ELIBBAD)
  { ":ELIBBAD" },
#endif
#if defined(ELIBEXEC)
  { ":ELIBEXEC" },
#endif
#if defined(ELIBMAX)
  { ":ELIBMAX" },
#endif
#if defined(ELIBSCN)
  { ":ELIBSCN" },
#endif
#if defined(ELNRNG)
  { ":ELNRNG" },
#endif
#if defined(ELOCKUNMAPPED)
  { ":ELOCKUNMAPPED" },
#endif
#if defined(ELOOP)
  { ":ELOOP" },
#endif
#if defined(EMEDIUMTYPE)
  { ":EMEDIUMTYPE" },
#endif
#if (defined(HAVE_SYSLOG)) && (defined(LOG_EMERG))
  { ":EMERG" },
#endif
#if defined(EMFILE)
  { ":EMFILE" },
#endif
#if defined(EMLINK)
  { ":EMLINK" },
#endif
#if ((defined(HAVE_UTMPX_H)) && (defined(EMPTY))) || (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN))
  { ":EMPTY" },
#endif
#if defined(EMSGSIZE)
  { ":EMSGSIZE" },
#endif
#if defined(EMTIMERS)
  { ":EMTIMERS" },
#endif
#if defined(EMULTIHOP)
  { ":EMULTIHOP" },
#endif
#if defined(ENAMETOOLONG)
  { ":ENAMETOOLONG" },
#endif
#if defined(ENAVAIL)
  { ":ENAVAIL" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(FILE_ATTRIBUTE_ENCRYPTED))
  { ":ENCRYPTED" },
#endif
#if defined(ENEEDAUTH)
  { ":ENEEDAUTH" },
#endif
#if defined(ENET)
  { ":ENET" },
#endif
#if defined(ENETDOWN)
  { ":ENETDOWN" },
#endif
#if defined(ENETRESET)
  { ":ENETRESET" },
#endif
#if defined(ENETUNREACH)
  { ":ENETUNREACH" },
#endif
#if defined(ENFILE)
  { ":ENFILE" },
#endif
#if defined(ENMFILE)
  { ":ENMFILE" },
#endif
#if defined(ENOANO)
  { ":ENOANO" },
#endif
#if defined(ENOATTR)
  { ":ENOATTR" },
#endif
#if defined(ENOBUFS)
  { ":ENOBUFS" },
#endif
#if defined(ENOCSI)
  { ":ENOCSI" },
#endif
#if defined(ENODATA)
  { ":ENODATA" },
#endif
#if defined(ENODEV)
  { ":ENODEV" },
#endif
#if defined(ENOENT)
  { ":ENOENT" },
#endif
#if defined(ENOEXEC)
  { ":ENOEXEC" },
#endif
#if defined(ENOFILE)
  { ":ENOFILE" },
#endif
#if defined(ENOIOCTL)
  { ":ENOIOCTL" },
#endif
#if defined(ENOKEY)
  { ":ENOKEY" },
#endif
#if defined(ENOLCK)
  { ":ENOLCK" },
#endif
#if defined(ENOLINK)
  { ":ENOLINK" },
#endif
#if defined(ENOMEDIUM)
  { ":ENOMEDIUM" },
#endif
#if defined(ENOMEM)
  { ":ENOMEM" },
#endif
#if defined(ENOMSG)
  { ":ENOMSG" },
#endif
#if defined(ENONET)
  { ":ENONET" },
#endif
#if defined(ENOPKG)
  { ":ENOPKG" },
#endif
#if defined(ENOPROTOOPT)
  { ":ENOPROTOOPT" },
#endif
#if defined(ENOSHARE)
  { ":ENOSHARE" },
#endif
#if defined(ENOSPC)
  { ":ENOSPC" },
#endif
#if defined(ENOSR)
  { ":ENOSR" },
#endif
#if defined(ENOSTR)
  { ":ENOSTR" },
#endif
#if defined(ENOSYM)
  { ":ENOSYM" },
#endif
#if defined(ENOSYS)
  { ":ENOSYS" },
#endif
#if defined(ENOTACTIVE)
  { ":ENOTACTIVE" },
#endif
#if defined(ENOTBLK)
  { ":ENOTBLK" },
#endif
#if defined(ENOTCONN)
  { ":ENOTCONN" },
#endif
#if defined(ENOTDIR)
  { ":ENOTDIR" },
#endif
#if defined(ENOTEMPTY)
  { ":ENOTEMPTY" },
#endif
#if defined(ENOTNAM)
  { ":ENOTNAM" },
#endif
#if defined(ENOTRECOVERABLE)
  { ":ENOTRECOVERABLE" },
#endif
#if defined(ENOTSOCK)
  { ":ENOTSOCK" },
#endif
#if defined(ENOTSUP)
  { ":ENOTSUP" },
#endif
#if defined(ENOTTY)
  { ":ENOTTY" },
#endif
#if defined(ENOTUNIQ)
  { ":ENOTUNIQ" },
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  { ":ENTERPRISE" },
#endif
#if defined(ENXIO)
  { ":ENXIO" },
#endif
#if defined(EOPNOTSUPP)
  { ":EOPNOTSUPP" },
#endif
#if defined(EOVERFLOW)
  { ":EOVERFLOW" },
#endif
#if defined(EOWNERDEAD)
  { ":EOWNERDEAD" },
#endif
#if defined(EPERM)
  { ":EPERM" },
#endif
#if defined(EPFNOSUPPORT)
  { ":EPFNOSUPPORT" },
#endif
#if defined(EPIPE)
  { ":EPIPE" },
#endif
#if defined(EPROCLIM)
  { ":EPROCLIM" },
#endif
#if defined(EPROCUNAVAIL)
  { ":EPROCUNAVAIL" },
#endif
#if defined(EPROGMISMATCH)
  { ":EPROGMISMATCH" },
#endif
#if defined(EPROGUNAVAIL)
  { ":EPROGUNAVAIL" },
#endif
#if defined(EPROTO)
  { ":EPROTO" },
#endif
#if defined(EPROTONOSUPPORT)
  { ":EPROTONOSUPPORT" },
#endif
#if defined(EPROTOTYPE)
  { ":EPROTOTYPE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(EPT_S_CANT_CREATE))
  { ":EPT_S_CANT_CREATE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(EPT_S_CANT_PERFORM_OP))
  { ":EPT_S_CANT_PERFORM_OP" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(EPT_S_INVALID_ENTRY))
  { ":EPT_S_INVALID_ENTRY" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(EPT_S_NOT_REGISTERED))
  { ":EPT_S_NOT_REGISTERED" },
#endif
#if defined(ERANGE)
  { ":ERANGE" },
#endif
#if defined(EREMCHG)
  { ":EREMCHG" },
#endif
#if defined(EREMDEV)
  { ":EREMDEV" },
#endif
#if defined(EREMOTE)
  { ":EREMOTE" },
#endif
#if defined(EREMOTEIO)
  { ":EREMOTEIO" },
#endif
#if defined(EREMOTERELEASE)
  { ":EREMOTERELEASE" },
#endif
#if defined(ERESTART)
  { ":ERESTART" },
#endif
#if defined(ERESTARTNOHAND)
  { ":ERESTARTNOHAND" },
#endif
#if defined(ERESTARTNOINTR)
  { ":ERESTARTNOINTR" },
#endif
#if defined(ERESTARTSYS)
  { ":ERESTARTSYS" },
#endif
#if defined(ERFKILL)
  { ":ERFKILL" },
#endif
#if defined(EROFS)
  { ":EROFS" },
#endif
#if defined(ERPCMISMATCH)
  { ":ERPCMISMATCH" },
#endif
#if (defined(HAVE_SYSLOG)) && (defined(LOG_ERR))
  { ":ERR" },
#endif
#if defined(ERREMOTE)
  { ":ERREMOTE" },
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  { ":ERROR" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ACCESS_DENIED))
  { ":ERROR_ACCESS_DENIED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ACCESS_DISABLED_BY_POLICY))
  { ":ERROR_ACCESS_DISABLED_BY_POLICY" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ACCESS_DISABLED_WEBBLADE))
  { ":ERROR_ACCESS_DISABLED_WEBBLADE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ACCESS_DISABLED_WEBBLADE_TAMPER))
  { ":ERROR_ACCESS_DISABLED_WEBBLADE_TAMPER" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ACCOUNT_DISABLED))
  { ":ERROR_ACCOUNT_DISABLED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ACCOUNT_EXPIRED))
  { ":ERROR_ACCOUNT_EXPIRED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ACCOUNT_LOCKED_OUT))
  { ":ERROR_ACCOUNT_LOCKED_OUT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ACCOUNT_RESTRICTION))
  { ":ERROR_ACCOUNT_RESTRICTION" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ACTIVATION_COUNT_EXCEEDED))
  { ":ERROR_ACTIVATION_COUNT_EXCEEDED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ACTIVE_CONNECTIONS))
  { ":ERROR_ACTIVE_CONNECTIONS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ADAP_HDW_ERR))
  { ":ERROR_ADAP_HDW_ERR" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ADDRESS_ALREADY_ASSOCIATED))
  { ":ERROR_ADDRESS_ALREADY_ASSOCIATED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ADDRESS_NOT_ASSOCIATED))
  { ":ERROR_ADDRESS_NOT_ASSOCIATED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ALIAS_EXISTS))
  { ":ERROR_ALIAS_EXISTS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ALLOTTED_SPACE_EXCEEDED))
  { ":ERROR_ALLOTTED_SPACE_EXCEEDED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ALL_NODES_NOT_AVAILABLE))
  { ":ERROR_ALL_NODES_NOT_AVAILABLE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ALL_USER_TRUST_QUOTA_EXCEEDED))
  { ":ERROR_ALL_USER_TRUST_QUOTA_EXCEEDED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ALREADY_ASSIGNED))
  { ":ERROR_ALREADY_ASSIGNED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ALREADY_EXISTS))
  { ":ERROR_ALREADY_EXISTS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ALREADY_FIBER))
  { ":ERROR_ALREADY_FIBER" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ALREADY_INITIALIZED))
  { ":ERROR_ALREADY_INITIALIZED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ALREADY_REGISTERED))
  { ":ERROR_ALREADY_REGISTERED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ALREADY_RUNNING_LKG))
  { ":ERROR_ALREADY_RUNNING_LKG" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ALREADY_THREAD))
  { ":ERROR_ALREADY_THREAD" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ALREADY_WAITING))
  { ":ERROR_ALREADY_WAITING" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_APPHELP_BLOCK))
  { ":ERROR_APPHELP_BLOCK" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_APP_WRONG_OS))
  { ":ERROR_APP_WRONG_OS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ARENA_TRASHED))
  { ":ERROR_ARENA_TRASHED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ARITHMETIC_OVERFLOW))
  { ":ERROR_ARITHMETIC_OVERFLOW" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ATOMIC_LOCKS_NOT_SUPPORTED))
  { ":ERROR_ATOMIC_LOCKS_NOT_SUPPORTED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_AUTODATASEG_EXCEEDS_64k))
  { ":ERROR_AUTODATASEG_EXCEEDS_64K" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BADDB))
  { ":ERROR_BADDB" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BADKEY))
  { ":ERROR_BADKEY" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BAD_ARGUMENTS))
  { ":ERROR_BAD_ARGUMENTS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BAD_COMMAND))
  { ":ERROR_BAD_COMMAND" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BAD_CONFIGURATION))
  { ":ERROR_BAD_CONFIGURATION" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BAD_DESCRIPTOR_FORMAT))
  { ":ERROR_BAD_DESCRIPTOR_FORMAT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BAD_DEVICE))
  { ":ERROR_BAD_DEVICE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BAD_DEV_TYPE))
  { ":ERROR_BAD_DEV_TYPE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BAD_DRIVER))
  { ":ERROR_BAD_DRIVER" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BAD_DRIVER_LEVEL))
  { ":ERROR_BAD_DRIVER_LEVEL" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BAD_ENVIRONMENT))
  { ":ERROR_BAD_ENVIRONMENT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BAD_EXE_FORMAT))
  { ":ERROR_BAD_EXE_FORMAT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BAD_FORMAT))
  { ":ERROR_BAD_FORMAT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BAD_IMPERSONATION_LEVEL))
  { ":ERROR_BAD_IMPERSONATION_LEVEL" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BAD_INHERITANCE_ACL))
  { ":ERROR_BAD_INHERITANCE_ACL" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BAD_LENGTH))
  { ":ERROR_BAD_LENGTH" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BAD_LOGON_SESSION_STATE))
  { ":ERROR_BAD_LOGON_SESSION_STATE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BAD_NETPATH))
  { ":ERROR_BAD_NETPATH" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BAD_NET_NAME))
  { ":ERROR_BAD_NET_NAME" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BAD_NET_RESP))
  { ":ERROR_BAD_NET_RESP" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BAD_PATHNAME))
  { ":ERROR_BAD_PATHNAME" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BAD_PIPE))
  { ":ERROR_BAD_PIPE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BAD_PROFILE))
  { ":ERROR_BAD_PROFILE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BAD_PROVIDER))
  { ":ERROR_BAD_PROVIDER" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BAD_QUERY_SYNTAX))
  { ":ERROR_BAD_QUERY_SYNTAX" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BAD_RECOVERY_POLICY))
  { ":ERROR_BAD_RECOVERY_POLICY" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BAD_REM_ADAP))
  { ":ERROR_BAD_REM_ADAP" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BAD_THREADID_ADDR))
  { ":ERROR_BAD_THREADID_ADDR" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BAD_TOKEN_TYPE))
  { ":ERROR_BAD_TOKEN_TYPE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BAD_UNIT))
  { ":ERROR_BAD_UNIT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BAD_USERNAME))
  { ":ERROR_BAD_USERNAME" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BAD_USER_PROFILE))
  { ":ERROR_BAD_USER_PROFILE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BAD_VALIDATION_CLASS))
  { ":ERROR_BAD_VALIDATION_CLASS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BEGINNING_OF_MEDIA))
  { ":ERROR_BEGINNING_OF_MEDIA" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BOOT_ALREADY_ACCEPTED))
  { ":ERROR_BOOT_ALREADY_ACCEPTED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BROKEN_PIPE))
  { ":ERROR_BROKEN_PIPE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BUFFER_OVERFLOW))
  { ":ERROR_BUFFER_OVERFLOW" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BUSY))
  { ":ERROR_BUSY" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BUSY_DRIVE))
  { ":ERROR_BUSY_DRIVE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_BUS_RESET))
  { ":ERROR_BUS_RESET" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CALLBACK_SUPPLIED_INVALID_DATA))
  { ":ERROR_CALLBACK_SUPPLIED_INVALID_DATA" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CALL_NOT_IMPLEMENTED))
  { ":ERROR_CALL_NOT_IMPLEMENTED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CANCELLED))
  { ":ERROR_CANCELLED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CANCEL_VIOLATION))
  { ":ERROR_CANCEL_VIOLATION" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CANNOT_COPY))
  { ":ERROR_CANNOT_COPY" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CANNOT_DETECT_DRIVER_FAILURE))
  { ":ERROR_CANNOT_DETECT_DRIVER_FAILURE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CANNOT_DETECT_PROCESS_ABORT))
  { ":ERROR_CANNOT_DETECT_PROCESS_ABORT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CANNOT_FIND_WND_CLASS))
  { ":ERROR_CANNOT_FIND_WND_CLASS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CANNOT_IMPERSONATE))
  { ":ERROR_CANNOT_IMPERSONATE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CANNOT_MAKE))
  { ":ERROR_CANNOT_MAKE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CANNOT_OPEN_PROFILE))
  { ":ERROR_CANNOT_OPEN_PROFILE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CANTOPEN))
  { ":ERROR_CANTOPEN" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CANTREAD))
  { ":ERROR_CANTREAD" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CANTWRITE))
  { ":ERROR_CANTWRITE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CANT_ACCESS_DOMAIN_INFO))
  { ":ERROR_CANT_ACCESS_DOMAIN_INFO" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CANT_ACCESS_FILE))
  { ":ERROR_CANT_ACCESS_FILE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CANT_DELETE_LAST_ITEM))
  { ":ERROR_CANT_DELETE_LAST_ITEM" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CANT_DISABLE_MANDATORY))
  { ":ERROR_CANT_DISABLE_MANDATORY" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CANT_EVICT_ACTIVE_NODE))
  { ":ERROR_CANT_EVICT_ACTIVE_NODE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CANT_OPEN_ANONYMOUS))
  { ":ERROR_CANT_OPEN_ANONYMOUS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CANT_RESOLVE_FILENAME))
  { ":ERROR_CANT_RESOLVE_FILENAME" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CAN_NOT_COMPLETE))
  { ":ERROR_CAN_NOT_COMPLETE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CAN_NOT_DEL_LOCAL_WINS))
  { ":ERROR_CAN_NOT_DEL_LOCAL_WINS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CHILD_MUST_BE_VOLATILE))
  { ":ERROR_CHILD_MUST_BE_VOLATILE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CHILD_NOT_COMPLETE))
  { ":ERROR_CHILD_NOT_COMPLETE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CHILD_WINDOW_MENU))
  { ":ERROR_CHILD_WINDOW_MENU" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CIRCULAR_DEPENDENCY))
  { ":ERROR_CIRCULAR_DEPENDENCY" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLASS_ALREADY_EXISTS))
  { ":ERROR_CLASS_ALREADY_EXISTS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLASS_DOES_NOT_EXIST))
  { ":ERROR_CLASS_DOES_NOT_EXIST" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLASS_HAS_WINDOWS))
  { ":ERROR_CLASS_HAS_WINDOWS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLEANER_CARTRIDGE_INSTALLED))
  { ":ERROR_CLEANER_CARTRIDGE_INSTALLED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLEANER_CARTRIDGE_SPENT))
  { ":ERROR_CLEANER_CARTRIDGE_SPENT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLEANER_SLOT_NOT_SET))
  { ":ERROR_CLEANER_SLOT_NOT_SET" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLEANER_SLOT_SET))
  { ":ERROR_CLEANER_SLOT_SET" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLIPBOARD_NOT_OPEN))
  { ":ERROR_CLIPBOARD_NOT_OPEN" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLIPPING_NOT_SUPPORTED))
  { ":ERROR_CLIPPING_NOT_SUPPORTED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSCFG_ALREADY_COMMITTED))
  { ":ERROR_CLUSCFG_ALREADY_COMMITTED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSCFG_ROLLBACK_FAILED))
  { ":ERROR_CLUSCFG_ROLLBACK_FAILED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSCFG_SYSTEM_DISK_DRIVE_LETTER_CONFLICT))
  { ":ERROR_CLUSCFG_SYSTEM_DISK_DRIVE_LETTER_CONFLICT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTERLOG_CHKPOINT_NOT_FOUND))
  { ":ERROR_CLUSTERLOG_CHKPOINT_NOT_FOUND" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTERLOG_CORRUPT))
  { ":ERROR_CLUSTERLOG_CORRUPT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTERLOG_EXCEEDS_MAXSIZE))
  { ":ERROR_CLUSTERLOG_EXCEEDS_MAXSIZE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTERLOG_NOT_ENOUGH_SPACE))
  { ":ERROR_CLUSTERLOG_NOT_ENOUGH_SPACE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTERLOG_RECORD_EXCEEDS_MAXSIZE))
  { ":ERROR_CLUSTERLOG_RECORD_EXCEEDS_MAXSIZE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_CANT_CREATE_DUP_CLUSTER_NAME))
  { ":ERROR_CLUSTER_CANT_CREATE_DUP_CLUSTER_NAME" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_DATABASE_SEQMISMATCH))
  { ":ERROR_CLUSTER_DATABASE_SEQMISMATCH" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_EVICT_WITHOUT_CLEANUP))
  { ":ERROR_CLUSTER_EVICT_WITHOUT_CLEANUP" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_GUM_NOT_LOCKER))
  { ":ERROR_CLUSTER_GUM_NOT_LOCKER" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_INCOMPATIBLE_VERSIONS))
  { ":ERROR_CLUSTER_INCOMPATIBLE_VERSIONS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_INSTANCE_ID_MISMATCH))
  { ":ERROR_CLUSTER_INSTANCE_ID_MISMATCH" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_INVALID_NETWORK))
  { ":ERROR_CLUSTER_INVALID_NETWORK" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_INVALID_NETWORK_PROVIDER))
  { ":ERROR_CLUSTER_INVALID_NETWORK_PROVIDER" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_INVALID_NODE))
  { ":ERROR_CLUSTER_INVALID_NODE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_INVALID_REQUEST))
  { ":ERROR_CLUSTER_INVALID_REQUEST" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_IPADDR_IN_USE))
  { ":ERROR_CLUSTER_IPADDR_IN_USE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_JOIN_ABORTED))
  { ":ERROR_CLUSTER_JOIN_ABORTED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_JOIN_IN_PROGRESS))
  { ":ERROR_CLUSTER_JOIN_IN_PROGRESS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_JOIN_NOT_IN_PROGRESS))
  { ":ERROR_CLUSTER_JOIN_NOT_IN_PROGRESS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_LAST_INTERNAL_NETWORK))
  { ":ERROR_CLUSTER_LAST_INTERNAL_NETWORK" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_LOCAL_NODE_NOT_FOUND))
  { ":ERROR_CLUSTER_LOCAL_NODE_NOT_FOUND" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_MAXNUM_OF_RESOURCES_EXCEEDED))
  { ":ERROR_CLUSTER_MAXNUM_OF_RESOURCES_EXCEEDED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_MEMBERSHIP_HALT))
  { ":ERROR_CLUSTER_MEMBERSHIP_HALT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_MEMBERSHIP_INVALID_STATE))
  { ":ERROR_CLUSTER_MEMBERSHIP_INVALID_STATE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_MISMATCHED_COMPUTER_ACCT_NAME))
  { ":ERROR_CLUSTER_MISMATCHED_COMPUTER_ACCT_NAME" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_NETINTERFACE_EXISTS))
  { ":ERROR_CLUSTER_NETINTERFACE_EXISTS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_NETINTERFACE_NOT_FOUND))
  { ":ERROR_CLUSTER_NETINTERFACE_NOT_FOUND" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_NETWORK_ALREADY_OFFLINE))
  { ":ERROR_CLUSTER_NETWORK_ALREADY_OFFLINE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_NETWORK_ALREADY_ONLINE))
  { ":ERROR_CLUSTER_NETWORK_ALREADY_ONLINE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_NETWORK_EXISTS))
  { ":ERROR_CLUSTER_NETWORK_EXISTS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_NETWORK_HAS_DEPENDENTS))
  { ":ERROR_CLUSTER_NETWORK_HAS_DEPENDENTS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_NETWORK_NOT_FOUND))
  { ":ERROR_CLUSTER_NETWORK_NOT_FOUND" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_NETWORK_NOT_FOUND_FOR_IP))
  { ":ERROR_CLUSTER_NETWORK_NOT_FOUND_FOR_IP" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_NETWORK_NOT_INTERNAL))
  { ":ERROR_CLUSTER_NETWORK_NOT_INTERNAL" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_NODE_ALREADY_DOWN))
  { ":ERROR_CLUSTER_NODE_ALREADY_DOWN" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_NODE_ALREADY_HAS_DFS_ROOT))
  { ":ERROR_CLUSTER_NODE_ALREADY_HAS_DFS_ROOT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_NODE_ALREADY_MEMBER))
  { ":ERROR_CLUSTER_NODE_ALREADY_MEMBER" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_NODE_ALREADY_UP))
  { ":ERROR_CLUSTER_NODE_ALREADY_UP" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_NODE_DOWN))
  { ":ERROR_CLUSTER_NODE_DOWN" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_NODE_EXISTS))
  { ":ERROR_CLUSTER_NODE_EXISTS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_NODE_NOT_FOUND))
  { ":ERROR_CLUSTER_NODE_NOT_FOUND" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_NODE_NOT_MEMBER))
  { ":ERROR_CLUSTER_NODE_NOT_MEMBER" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_NODE_NOT_PAUSED))
  { ":ERROR_CLUSTER_NODE_NOT_PAUSED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_NODE_NOT_READY))
  { ":ERROR_CLUSTER_NODE_NOT_READY" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_NODE_PAUSED))
  { ":ERROR_CLUSTER_NODE_PAUSED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_NODE_SHUTTING_DOWN))
  { ":ERROR_CLUSTER_NODE_SHUTTING_DOWN" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_NODE_UNREACHABLE))
  { ":ERROR_CLUSTER_NODE_UNREACHABLE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_NODE_UP))
  { ":ERROR_CLUSTER_NODE_UP" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_NO_RPC_PACKAGES_REGISTERED))
  { ":ERROR_CLUSTER_NO_RPC_PACKAGES_REGISTERED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_NO_SECURITY_CONTEXT))
  { ":ERROR_CLUSTER_NO_SECURITY_CONTEXT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_OLD_VERSION))
  { ":ERROR_CLUSTER_OLD_VERSION" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_OWNER_NOT_IN_PREFLIST))
  { ":ERROR_CLUSTER_OWNER_NOT_IN_PREFLIST" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_PARAMETER_MISMATCH))
  { ":ERROR_CLUSTER_PARAMETER_MISMATCH" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_PROPERTY_DATA_TYPE_MISMATCH))
  { ":ERROR_CLUSTER_PROPERTY_DATA_TYPE_MISMATCH" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_QUORUMLOG_NOT_FOUND))
  { ":ERROR_CLUSTER_QUORUMLOG_NOT_FOUND" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_RESNAME_NOT_FOUND))
  { ":ERROR_CLUSTER_RESNAME_NOT_FOUND" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_RESOURCE_TYPE_NOT_FOUND))
  { ":ERROR_CLUSTER_RESOURCE_TYPE_NOT_FOUND" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_RESTYPE_NOT_SUPPORTED))
  { ":ERROR_CLUSTER_RESTYPE_NOT_SUPPORTED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_SHUTTING_DOWN))
  { ":ERROR_CLUSTER_SHUTTING_DOWN" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_SYSTEM_CONFIG_CHANGED))
  { ":ERROR_CLUSTER_SYSTEM_CONFIG_CHANGED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CLUSTER_WRONG_OS_VERSION))
  { ":ERROR_CLUSTER_WRONG_OS_VERSION" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_COLORSPACE_MISMATCH))
  { ":ERROR_COLORSPACE_MISMATCH" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_COMMITMENT_LIMIT))
  { ":ERROR_COMMITMENT_LIMIT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CONNECTED_OTHER_PASSWORD))
  { ":ERROR_CONNECTED_OTHER_PASSWORD" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CONNECTED_OTHER_PASSWORD_DEFAULT))
  { ":ERROR_CONNECTED_OTHER_PASSWORD_DEFAULT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CONNECTION_ABORTED))
  { ":ERROR_CONNECTION_ABORTED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CONNECTION_ACTIVE))
  { ":ERROR_CONNECTION_ACTIVE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CONNECTION_COUNT_LIMIT))
  { ":ERROR_CONNECTION_COUNT_LIMIT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CONNECTION_INVALID))
  { ":ERROR_CONNECTION_INVALID" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CONNECTION_REFUSED))
  { ":ERROR_CONNECTION_REFUSED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CONNECTION_UNAVAIL))
  { ":ERROR_CONNECTION_UNAVAIL" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CONTEXT_EXPIRED))
  { ":ERROR_CONTEXT_EXPIRED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CONTINUE))
  { ":ERROR_CONTINUE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CONTROLLING_IEPORT))
  { ":ERROR_CONTROLLING_IEPORT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CONTROL_ID_NOT_FOUND))
  { ":ERROR_CONTROL_ID_NOT_FOUND" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CORE_RESOURCE))
  { ":ERROR_CORE_RESOURCE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_COUNTER_TIMEOUT))
  { ":ERROR_COUNTER_TIMEOUT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CRC))
  { ":ERROR_CRC" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CREATE_FAILED))
  { ":ERROR_CREATE_FAILED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CSCSHARE_OFFLINE))
  { ":ERROR_CSCSHARE_OFFLINE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_BAD_VIDEO_MODE))
  { ":ERROR_CTX_BAD_VIDEO_MODE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_CANNOT_MAKE_EVENTLOG_ENTRY))
  { ":ERROR_CTX_CANNOT_MAKE_EVENTLOG_ENTRY" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_CLIENT_LICENSE_IN_USE))
  { ":ERROR_CTX_CLIENT_LICENSE_IN_USE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_CLIENT_LICENSE_NOT_SET))
  { ":ERROR_CTX_CLIENT_LICENSE_NOT_SET" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_CLIENT_QUERY_TIMEOUT))
  { ":ERROR_CTX_CLIENT_QUERY_TIMEOUT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_CLOSE_PENDING))
  { ":ERROR_CTX_CLOSE_PENDING" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_CONSOLE_CONNECT))
  { ":ERROR_CTX_CONSOLE_CONNECT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_CONSOLE_DISCONNECT))
  { ":ERROR_CTX_CONSOLE_DISCONNECT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_GRAPHICS_INVALID))
  { ":ERROR_CTX_GRAPHICS_INVALID" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_INVALID_MODEMNAME))
  { ":ERROR_CTX_INVALID_MODEMNAME" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_INVALID_PD))
  { ":ERROR_CTX_INVALID_PD" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_INVALID_WD))
  { ":ERROR_CTX_INVALID_WD" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_LICENSE_CLIENT_INVALID))
  { ":ERROR_CTX_LICENSE_CLIENT_INVALID" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_LICENSE_EXPIRED))
  { ":ERROR_CTX_LICENSE_EXPIRED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_LICENSE_NOT_AVAILABLE))
  { ":ERROR_CTX_LICENSE_NOT_AVAILABLE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_LOGON_DISABLED))
  { ":ERROR_CTX_LOGON_DISABLED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_MODEM_INF_NOT_FOUND))
  { ":ERROR_CTX_MODEM_INF_NOT_FOUND" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_MODEM_RESPONSE_BUSY))
  { ":ERROR_CTX_MODEM_RESPONSE_BUSY" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_MODEM_RESPONSE_ERROR))
  { ":ERROR_CTX_MODEM_RESPONSE_ERROR" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_MODEM_RESPONSE_NO_CARRIER))
  { ":ERROR_CTX_MODEM_RESPONSE_NO_CARRIER" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_MODEM_RESPONSE_NO_DIALTONE))
  { ":ERROR_CTX_MODEM_RESPONSE_NO_DIALTONE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_MODEM_RESPONSE_TIMEOUT))
  { ":ERROR_CTX_MODEM_RESPONSE_TIMEOUT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_MODEM_RESPONSE_VOICE))
  { ":ERROR_CTX_MODEM_RESPONSE_VOICE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_NOT_CONSOLE))
  { ":ERROR_CTX_NOT_CONSOLE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_NO_OUTBUF))
  { ":ERROR_CTX_NO_OUTBUF" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_PD_NOT_FOUND))
  { ":ERROR_CTX_PD_NOT_FOUND" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_SERVICE_NAME_COLLISION))
  { ":ERROR_CTX_SERVICE_NAME_COLLISION" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_SHADOW_DENIED))
  { ":ERROR_CTX_SHADOW_DENIED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_SHADOW_DISABLED))
  { ":ERROR_CTX_SHADOW_DISABLED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_SHADOW_ENDED_BY_MODE_CHANGE))
  { ":ERROR_CTX_SHADOW_ENDED_BY_MODE_CHANGE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_SHADOW_INVALID))
  { ":ERROR_CTX_SHADOW_INVALID" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_SHADOW_NOT_RUNNING))
  { ":ERROR_CTX_SHADOW_NOT_RUNNING" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_TD_ERROR))
  { ":ERROR_CTX_TD_ERROR" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_WD_NOT_FOUND))
  { ":ERROR_CTX_WD_NOT_FOUND" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_WINSTATION_ACCESS_DENIED))
  { ":ERROR_CTX_WINSTATION_ACCESS_DENIED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_WINSTATION_ALREADY_EXISTS))
  { ":ERROR_CTX_WINSTATION_ALREADY_EXISTS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_WINSTATION_BUSY))
  { ":ERROR_CTX_WINSTATION_BUSY" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_WINSTATION_NAME_INVALID))
  { ":ERROR_CTX_WINSTATION_NAME_INVALID" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CTX_WINSTATION_NOT_FOUND))
  { ":ERROR_CTX_WINSTATION_NOT_FOUND" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CURRENT_DIRECTORY))
  { ":ERROR_CURRENT_DIRECTORY" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_CURRENT_DOMAIN_NOT_ALLOWED))
  { ":ERROR_CURRENT_DOMAIN_NOT_ALLOWED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DATABASE_BACKUP_CORRUPT))
  { ":ERROR_DATABASE_BACKUP_CORRUPT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DATABASE_DOES_NOT_EXIST))
  { ":ERROR_DATABASE_DOES_NOT_EXIST" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DATABASE_FAILURE))
  { ":ERROR_DATABASE_FAILURE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DATABASE_FULL))
  { ":ERROR_DATABASE_FULL" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DATATYPE_MISMATCH))
  { ":ERROR_DATATYPE_MISMATCH" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DC_NOT_FOUND))
  { ":ERROR_DC_NOT_FOUND" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DDE_FAIL))
  { ":ERROR_DDE_FAIL" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DEBUGGER_INACTIVE))
  { ":ERROR_DEBUGGER_INACTIVE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DECRYPTION_FAILED))
  { ":ERROR_DECRYPTION_FAILED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DELETE_PENDING))
  { ":ERROR_DELETE_PENDING" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DELETING_ICM_XFORM))
  { ":ERROR_DELETING_ICM_XFORM" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DEPENDENCY_ALREADY_EXISTS))
  { ":ERROR_DEPENDENCY_ALREADY_EXISTS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DEPENDENCY_NOT_ALLOWED))
  { ":ERROR_DEPENDENCY_NOT_ALLOWED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DEPENDENCY_NOT_FOUND))
  { ":ERROR_DEPENDENCY_NOT_FOUND" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DEPENDENT_RESOURCE_EXISTS))
  { ":ERROR_DEPENDENT_RESOURCE_EXISTS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DEPENDENT_SERVICES_RUNNING))
  { ":ERROR_DEPENDENT_SERVICES_RUNNING" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DESTINATION_ELEMENT_FULL))
  { ":ERROR_DESTINATION_ELEMENT_FULL" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DESTROY_OBJECT_OF_OTHER_THREAD))
  { ":ERROR_DESTROY_OBJECT_OF_OTHER_THREAD" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DEVICE_ALREADY_REMEMBERED))
  { ":ERROR_DEVICE_ALREADY_REMEMBERED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DEVICE_DOOR_OPEN))
  { ":ERROR_DEVICE_DOOR_OPEN" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DEVICE_IN_USE))
  { ":ERROR_DEVICE_IN_USE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DEVICE_NOT_AVAILABLE))
  { ":ERROR_DEVICE_NOT_AVAILABLE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DEVICE_NOT_CONNECTED))
  { ":ERROR_DEVICE_NOT_CONNECTED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DEVICE_NOT_PARTITIONED))
  { ":ERROR_DEVICE_NOT_PARTITIONED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DEVICE_REINITIALIZATION_NEEDED))
  { ":ERROR_DEVICE_REINITIALIZATION_NEEDED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DEVICE_REMOVED))
  { ":ERROR_DEVICE_REMOVED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DEVICE_REQUIRES_CLEANING))
  { ":ERROR_DEVICE_REQUIRES_CLEANING" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DEV_NOT_EXIST))
  { ":ERROR_DEV_NOT_EXIST" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DHCP_ADDRESS_CONFLICT))
  { ":ERROR_DHCP_ADDRESS_CONFLICT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DIFFERENT_SERVICE_ACCOUNT))
  { ":ERROR_DIFFERENT_SERVICE_ACCOUNT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DIRECTORY))
  { ":ERROR_DIRECTORY" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DIRECT_ACCESS_HANDLE))
  { ":ERROR_DIRECT_ACCESS_HANDLE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DIR_EFS_DISALLOWED))
  { ":ERROR_DIR_EFS_DISALLOWED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DIR_NOT_EMPTY))
  { ":ERROR_DIR_NOT_EMPTY" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DIR_NOT_ROOT))
  { ":ERROR_DIR_NOT_ROOT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DISCARDED))
  { ":ERROR_DISCARDED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DISK_CHANGE))
  { ":ERROR_DISK_CHANGE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DISK_CORRUPT))
  { ":ERROR_DISK_CORRUPT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DISK_FULL))
  { ":ERROR_DISK_FULL" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DISK_OPERATION_FAILED))
  { ":ERROR_DISK_OPERATION_FAILED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DISK_RECALIBRATE_FAILED))
  { ":ERROR_DISK_RECALIBRATE_FAILED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DISK_RESET_FAILED))
  { ":ERROR_DISK_RESET_FAILED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DISK_TOO_FRAGMENTED))
  { ":ERROR_DISK_TOO_FRAGMENTED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DLL_INIT_FAILED))
  { ":ERROR_DLL_INIT_FAILED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DLL_NOT_FOUND))
  { ":ERROR_DLL_NOT_FOUND" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DOMAIN_CONTROLLER_EXISTS))
  { ":ERROR_DOMAIN_CONTROLLER_EXISTS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DOMAIN_CONTROLLER_NOT_FOUND))
  { ":ERROR_DOMAIN_CONTROLLER_NOT_FOUND" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DOMAIN_EXISTS))
  { ":ERROR_DOMAIN_EXISTS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DOMAIN_LIMIT_EXCEEDED))
  { ":ERROR_DOMAIN_LIMIT_EXCEEDED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DOMAIN_TRUST_INCONSISTENT))
  { ":ERROR_DOMAIN_TRUST_INCONSISTENT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DOWNGRADE_DETECTED))
  { ":ERROR_DOWNGRADE_DETECTED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DRIVER_BLOCKED))
  { ":ERROR_DRIVER_BLOCKED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DRIVE_LOCKED))
  { ":ERROR_DRIVE_LOCKED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DRIVE_MEDIA_MISMATCH))
  { ":ERROR_DRIVE_MEDIA_MISMATCH" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_ADD_REPLICA_INHIBITED))
  { ":ERROR_DS_ADD_REPLICA_INHIBITED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_ADMIN_LIMIT_EXCEEDED))
  { ":ERROR_DS_ADMIN_LIMIT_EXCEEDED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_AFFECTS_MULTIPLE_DSAS))
  { ":ERROR_DS_AFFECTS_MULTIPLE_DSAS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_AG_CANT_HAVE_UNIVERSAL_MEMBER))
  { ":ERROR_DS_AG_CANT_HAVE_UNIVERSAL_MEMBER" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_ALIASED_OBJ_MISSING))
  { ":ERROR_DS_ALIASED_OBJ_MISSING" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_ALIAS_DEREF_PROBLEM))
  { ":ERROR_DS_ALIAS_DEREF_PROBLEM" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_ALIAS_POINTS_TO_ALIAS))
  { ":ERROR_DS_ALIAS_POINTS_TO_ALIAS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_ALIAS_PROBLEM))
  { ":ERROR_DS_ALIAS_PROBLEM" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_ATTRIBUTE_OR_VALUE_EXISTS))
  { ":ERROR_DS_ATTRIBUTE_OR_VALUE_EXISTS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_ATTRIBUTE_OWNED_BY_SAM))
  { ":ERROR_DS_ATTRIBUTE_OWNED_BY_SAM" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_ATTRIBUTE_TYPE_UNDEFINED))
  { ":ERROR_DS_ATTRIBUTE_TYPE_UNDEFINED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_ATT_ALREADY_EXISTS))
  { ":ERROR_DS_ATT_ALREADY_EXISTS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_ATT_IS_NOT_ON_OBJ))
  { ":ERROR_DS_ATT_IS_NOT_ON_OBJ" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_ATT_NOT_DEF_FOR_CLASS))
  { ":ERROR_DS_ATT_NOT_DEF_FOR_CLASS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_ATT_NOT_DEF_IN_SCHEMA))
  { ":ERROR_DS_ATT_NOT_DEF_IN_SCHEMA" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_ATT_SCHEMA_REQ_ID))
  { ":ERROR_DS_ATT_SCHEMA_REQ_ID" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_ATT_SCHEMA_REQ_SYNTAX))
  { ":ERROR_DS_ATT_SCHEMA_REQ_SYNTAX" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_ATT_VAL_ALREADY_EXISTS))
  { ":ERROR_DS_ATT_VAL_ALREADY_EXISTS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_AUTHORIZATION_FAILED))
  { ":ERROR_DS_AUTHORIZATION_FAILED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_AUTH_METHOD_NOT_SUPPORTED))
  { ":ERROR_DS_AUTH_METHOD_NOT_SUPPORTED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_AUTH_UNKNOWN))
  { ":ERROR_DS_AUTH_UNKNOWN" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_AUX_CLS_TEST_FAIL))
  { ":ERROR_DS_AUX_CLS_TEST_FAIL" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_BACKLINK_WITHOUT_LINK))
  { ":ERROR_DS_BACKLINK_WITHOUT_LINK" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_BAD_ATT_SCHEMA_SYNTAX))
  { ":ERROR_DS_BAD_ATT_SCHEMA_SYNTAX" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_BAD_HIERARCHY_FILE))
  { ":ERROR_DS_BAD_HIERARCHY_FILE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_BAD_INSTANCE_TYPE))
  { ":ERROR_DS_BAD_INSTANCE_TYPE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_BAD_NAME_SYNTAX))
  { ":ERROR_DS_BAD_NAME_SYNTAX" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_BAD_RDN_ATT_ID_SYNTAX))
  { ":ERROR_DS_BAD_RDN_ATT_ID_SYNTAX" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_BUILD_HIERARCHY_TABLE_FAILED))
  { ":ERROR_DS_BUILD_HIERARCHY_TABLE_FAILED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_BUSY))
  { ":ERROR_DS_BUSY" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_ACCESS_REMOTE_PART_OF_AD))
  { ":ERROR_DS_CANT_ACCESS_REMOTE_PART_OF_AD" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_ADD_ATT_VALUES))
  { ":ERROR_DS_CANT_ADD_ATT_VALUES" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_ADD_SYSTEM_ONLY))
  { ":ERROR_DS_CANT_ADD_SYSTEM_ONLY" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_ADD_TO_GC))
  { ":ERROR_DS_CANT_ADD_TO_GC" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_CACHE_ATT))
  { ":ERROR_DS_CANT_CACHE_ATT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_CACHE_CLASS))
  { ":ERROR_DS_CANT_CACHE_CLASS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_CREATE_IN_NONDOMAIN_NC))
  { ":ERROR_DS_CANT_CREATE_IN_NONDOMAIN_NC" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_CREATE_UNDER_SCHEMA))
  { ":ERROR_DS_CANT_CREATE_UNDER_SCHEMA" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_DELETE))
  { ":ERROR_DS_CANT_DELETE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_DELETE_DSA_OBJ))
  { ":ERROR_DS_CANT_DELETE_DSA_OBJ" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_DEL_MASTER_CROSSREF))
  { ":ERROR_DS_CANT_DEL_MASTER_CROSSREF" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_DEMOTE_WITH_WRITEABLE_NC))
  { ":ERROR_DS_CANT_DEMOTE_WITH_WRITEABLE_NC" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_DEREF_ALIAS))
  { ":ERROR_DS_CANT_DEREF_ALIAS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_DERIVE_SPN_FOR_DELETED_DOMAIN))
  { ":ERROR_DS_CANT_DERIVE_SPN_FOR_DELETED_DOMAIN" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_DERIVE_SPN_WITHOUT_SERVER_REF))
  { ":ERROR_DS_CANT_DERIVE_SPN_WITHOUT_SERVER_REF" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_FIND_DC_FOR_SRC_DOMAIN))
  { ":ERROR_DS_CANT_FIND_DC_FOR_SRC_DOMAIN" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_FIND_DSA_OBJ))
  { ":ERROR_DS_CANT_FIND_DSA_OBJ" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_FIND_EXPECTED_NC))
  { ":ERROR_DS_CANT_FIND_EXPECTED_NC" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_FIND_NC_IN_CACHE))
  { ":ERROR_DS_CANT_FIND_NC_IN_CACHE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_MIX_MASTER_AND_REPS))
  { ":ERROR_DS_CANT_MIX_MASTER_AND_REPS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_MOD_OBJ_CLASS))
  { ":ERROR_DS_CANT_MOD_OBJ_CLASS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_MOD_PRIMARYGROUPID))
  { ":ERROR_DS_CANT_MOD_PRIMARYGROUPID" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_MOD_SYSTEM_ONLY))
  { ":ERROR_DS_CANT_MOD_SYSTEM_ONLY" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_MOVE_ACCOUNT_GROUP))
  { ":ERROR_DS_CANT_MOVE_ACCOUNT_GROUP" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_MOVE_APP_BASIC_GROUP))
  { ":ERROR_DS_CANT_MOVE_APP_BASIC_GROUP" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_MOVE_APP_QUERY_GROUP))
  { ":ERROR_DS_CANT_MOVE_APP_QUERY_GROUP" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_MOVE_DELETED_OBJECT))
  { ":ERROR_DS_CANT_MOVE_DELETED_OBJECT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_MOVE_RESOURCE_GROUP))
  { ":ERROR_DS_CANT_MOVE_RESOURCE_GROUP" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_ON_NON_LEAF))
  { ":ERROR_DS_CANT_ON_NON_LEAF" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_ON_RDN))
  { ":ERROR_DS_CANT_ON_RDN" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_REMOVE_ATT_CACHE))
  { ":ERROR_DS_CANT_REMOVE_ATT_CACHE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_REMOVE_CLASS_CACHE))
  { ":ERROR_DS_CANT_REMOVE_CLASS_CACHE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_REM_MISSING_ATT))
  { ":ERROR_DS_CANT_REM_MISSING_ATT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_REM_MISSING_ATT_VAL))
  { ":ERROR_DS_CANT_REM_MISSING_ATT_VAL" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_REPLACE_HIDDEN_REC))
  { ":ERROR_DS_CANT_REPLACE_HIDDEN_REC" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_RETRIEVE_ATTS))
  { ":ERROR_DS_CANT_RETRIEVE_ATTS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_RETRIEVE_CHILD))
  { ":ERROR_DS_CANT_RETRIEVE_CHILD" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_RETRIEVE_DN))
  { ":ERROR_DS_CANT_RETRIEVE_DN" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_RETRIEVE_INSTANCE))
  { ":ERROR_DS_CANT_RETRIEVE_INSTANCE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_RETRIEVE_SD))
  { ":ERROR_DS_CANT_RETRIEVE_SD" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_START))
  { ":ERROR_DS_CANT_START" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_TREE_DELETE_CRITICAL_OBJ))
  { ":ERROR_DS_CANT_TREE_DELETE_CRITICAL_OBJ" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CANT_WITH_ACCT_GROUP_MEMBERSHPS))
  { ":ERROR_DS_CANT_WITH_ACCT_GROUP_MEMBERSHPS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CHILDREN_EXIST))
  { ":ERROR_DS_CHILDREN_EXIST" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CLASS_MUST_BE_CONCRETE))
  { ":ERROR_DS_CLASS_MUST_BE_CONCRETE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CLASS_NOT_DSA))
  { ":ERROR_DS_CLASS_NOT_DSA" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CLIENT_LOOP))
  { ":ERROR_DS_CLIENT_LOOP" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CODE_INCONSISTENCY))
  { ":ERROR_DS_CODE_INCONSISTENCY" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_COMPARE_FALSE))
  { ":ERROR_DS_COMPARE_FALSE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_COMPARE_TRUE))
  { ":ERROR_DS_COMPARE_TRUE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CONFIDENTIALITY_REQUIRED))
  { ":ERROR_DS_CONFIDENTIALITY_REQUIRED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CONFIG_PARAM_MISSING))
  { ":ERROR_DS_CONFIG_PARAM_MISSING" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CONSTRAINT_VIOLATION))
  { ":ERROR_DS_CONSTRAINT_VIOLATION" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CONSTRUCTED_ATT_MOD))
  { ":ERROR_DS_CONSTRUCTED_ATT_MOD" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CONTROL_NOT_FOUND))
  { ":ERROR_DS_CONTROL_NOT_FOUND" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_COULDNT_CONTACT_FSMO))
  { ":ERROR_DS_COULDNT_CONTACT_FSMO" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_COULDNT_IDENTIFY_OBJECTS_FOR_TREE_DELETE))
  { ":ERROR_DS_COULDNT_IDENTIFY_OBJECTS_FOR_TREE_DELETE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_COULDNT_LOCK_TREE_FOR_DELETE))
  { ":ERROR_DS_COULDNT_LOCK_TREE_FOR_DELETE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_COULDNT_UPDATE_SPNS))
  { ":ERROR_DS_COULDNT_UPDATE_SPNS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_COUNTING_AB_INDICES_FAILED))
  { ":ERROR_DS_COUNTING_AB_INDICES_FAILED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CROSS_DOMAIN_CLEANUP_REQD))
  { ":ERROR_DS_CROSS_DOMAIN_CLEANUP_REQD" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CROSS_DOM_MOVE_ERROR))
  { ":ERROR_DS_CROSS_DOM_MOVE_ERROR" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CROSS_NC_DN_RENAME))
  { ":ERROR_DS_CROSS_NC_DN_RENAME" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CROSS_REF_BUSY))
  { ":ERROR_DS_CROSS_REF_BUSY" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CROSS_REF_EXISTS))
  { ":ERROR_DS_CROSS_REF_EXISTS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CR_IMPOSSIBLE_TO_VALIDATE))
  { ":ERROR_DS_CR_IMPOSSIBLE_TO_VALIDATE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_CR_IMPOSSIBLE_TO_VALIDATE_V2))
  { ":ERROR_DS_CR_IMPOSSIBLE_TO_VALIDATE_V2" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DATABASE_ERROR))
  { ":ERROR_DS_DATABASE_ERROR" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DECODING_ERROR))
  { ":ERROR_DS_DECODING_ERROR" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DESTINATION_AUDITING_NOT_ENABLED))
  { ":ERROR_DS_DESTINATION_AUDITING_NOT_ENABLED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DESTINATION_DOMAIN_NOT_IN_FOREST))
  { ":ERROR_DS_DESTINATION_DOMAIN_NOT_IN_FOREST" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DIFFERENT_REPL_EPOCHS))
  { ":ERROR_DS_DIFFERENT_REPL_EPOCHS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DOMAIN_RENAME_IN_PROGRESS))
  { ":ERROR_DS_DOMAIN_RENAME_IN_PROGRESS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DOMAIN_VERSION_TOO_HIGH))
  { ":ERROR_DS_DOMAIN_VERSION_TOO_HIGH" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DOMAIN_VERSION_TOO_LOW))
  { ":ERROR_DS_DOMAIN_VERSION_TOO_LOW" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_ABANDON_SYNC))
  { ":ERROR_DS_DRA_ABANDON_SYNC" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_ACCESS_DENIED))
  { ":ERROR_DS_DRA_ACCESS_DENIED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_BAD_DN))
  { ":ERROR_DS_DRA_BAD_DN" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_BAD_INSTANCE_TYPE))
  { ":ERROR_DS_DRA_BAD_INSTANCE_TYPE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_BAD_NC))
  { ":ERROR_DS_DRA_BAD_NC" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_BUSY))
  { ":ERROR_DS_DRA_BUSY" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_CONNECTION_FAILED))
  { ":ERROR_DS_DRA_CONNECTION_FAILED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_DB_ERROR))
  { ":ERROR_DS_DRA_DB_ERROR" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_DN_EXISTS))
  { ":ERROR_DS_DRA_DN_EXISTS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_EARLIER_SCHEMA_CONLICT))
  { ":ERROR_DS_DRA_EARLIER_SCHEMA_CONLICT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_EXTN_CONNECTION_FAILED))
  { ":ERROR_DS_DRA_EXTN_CONNECTION_FAILED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_GENERIC))
  { ":ERROR_DS_DRA_GENERIC" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_INCOMPATIBLE_PARTIAL_SET))
  { ":ERROR_DS_DRA_INCOMPATIBLE_PARTIAL_SET" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_INCONSISTENT_DIT))
  { ":ERROR_DS_DRA_INCONSISTENT_DIT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_INTERNAL_ERROR))
  { ":ERROR_DS_DRA_INTERNAL_ERROR" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_INVALID_PARAMETER))
  { ":ERROR_DS_DRA_INVALID_PARAMETER" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_MAIL_PROBLEM))
  { ":ERROR_DS_DRA_MAIL_PROBLEM" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_MISSING_PARENT))
  { ":ERROR_DS_DRA_MISSING_PARENT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_NAME_COLLISION))
  { ":ERROR_DS_DRA_NAME_COLLISION" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_NOT_SUPPORTED))
  { ":ERROR_DS_DRA_NOT_SUPPORTED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_NO_REPLICA))
  { ":ERROR_DS_DRA_NO_REPLICA" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_OBJ_IS_REP_SOURCE))
  { ":ERROR_DS_DRA_OBJ_IS_REP_SOURCE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_OBJ_NC_MISMATCH))
  { ":ERROR_DS_DRA_OBJ_NC_MISMATCH" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_OUT_OF_MEM))
  { ":ERROR_DS_DRA_OUT_OF_MEM" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_PREEMPTED))
  { ":ERROR_DS_DRA_PREEMPTED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_REF_ALREADY_EXISTS))
  { ":ERROR_DS_DRA_REF_ALREADY_EXISTS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_REF_NOT_FOUND))
  { ":ERROR_DS_DRA_REF_NOT_FOUND" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_REPL_PENDING))
  { ":ERROR_DS_DRA_REPL_PENDING" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_RPC_CANCELLED))
  { ":ERROR_DS_DRA_RPC_CANCELLED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_SCHEMA_CONFLICT))
  { ":ERROR_DS_DRA_SCHEMA_CONFLICT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_SCHEMA_INFO_SHIP))
  { ":ERROR_DS_DRA_SCHEMA_INFO_SHIP" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_SCHEMA_MISMATCH))
  { ":ERROR_DS_DRA_SCHEMA_MISMATCH" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_SHUTDOWN))
  { ":ERROR_DS_DRA_SHUTDOWN" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_SINK_DISABLED))
  { ":ERROR_DS_DRA_SINK_DISABLED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_SOURCE_DISABLED))
  { ":ERROR_DS_DRA_SOURCE_DISABLED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_SOURCE_IS_PARTIAL_REPLICA))
  { ":ERROR_DS_DRA_SOURCE_IS_PARTIAL_REPLICA" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRA_SOURCE_REINSTALLED))
  { ":ERROR_DS_DRA_SOURCE_REINSTALLED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DRS_EXTENSIONS_CHANGED))
  { ":ERROR_DS_DRS_EXTENSIONS_CHANGED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DSA_MUST_BE_INT_MASTER))
  { ":ERROR_DS_DSA_MUST_BE_INT_MASTER" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DST_DOMAIN_NOT_NATIVE))
  { ":ERROR_DS_DST_DOMAIN_NOT_NATIVE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DST_NC_MISMATCH))
  { ":ERROR_DS_DST_NC_MISMATCH" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DS_REQUIRED))
  { ":ERROR_DS_DS_REQUIRED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DUPLICATE_ID_FOUND))
  { ":ERROR_DS_DUPLICATE_ID_FOUND" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DUP_LDAP_DISPLAY_NAME))
  { ":ERROR_DS_DUP_LDAP_DISPLAY_NAME" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DUP_LINK_ID))
  { ":ERROR_DS_DUP_LINK_ID" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DUP_MAPI_ID))
  { ":ERROR_DS_DUP_MAPI_ID" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DUP_MSDS_INTID))
  { ":ERROR_DS_DUP_MSDS_INTID" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DUP_OID))
  { ":ERROR_DS_DUP_OID" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DUP_RDN))
  { ":ERROR_DS_DUP_RDN" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_DUP_SCHEMA_ID_GUID))
  { ":ERROR_DS_DUP_SCHEMA_ID_GUID" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_ENCODING_ERROR))
  { ":ERROR_DS_ENCODING_ERROR" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_EPOCH_MISMATCH))
  { ":ERROR_DS_EPOCH_MISMATCH" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_EXISTING_AD_CHILD_NC))
  { ":ERROR_DS_EXISTING_AD_CHILD_NC" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_EXISTS_IN_AUX_CLS))
  { ":ERROR_DS_EXISTS_IN_AUX_CLS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_EXISTS_IN_MAY_HAVE))
  { ":ERROR_DS_EXISTS_IN_MAY_HAVE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_EXISTS_IN_MUST_HAVE))
  { ":ERROR_DS_EXISTS_IN_MUST_HAVE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_EXISTS_IN_POSS_SUP))
  { ":ERROR_DS_EXISTS_IN_POSS_SUP" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_EXISTS_IN_RDNATTID))
  { ":ERROR_DS_EXISTS_IN_RDNATTID" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_EXISTS_IN_SUB_CLS))
  { ":ERROR_DS_EXISTS_IN_SUB_CLS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_FILTER_UNKNOWN))
  { ":ERROR_DS_FILTER_UNKNOWN" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_FILTER_USES_CONTRUCTED_ATTRS))
  { ":ERROR_DS_FILTER_USES_CONTRUCTED_ATTRS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_FOREST_VERSION_TOO_HIGH))
  { ":ERROR_DS_FOREST_VERSION_TOO_HIGH" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_FOREST_VERSION_TOO_LOW))
  { ":ERROR_DS_FOREST_VERSION_TOO_LOW" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_GCVERIFY_ERROR))
  { ":ERROR_DS_GCVERIFY_ERROR" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_GC_NOT_AVAILABLE))
  { ":ERROR_DS_GC_NOT_AVAILABLE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_GC_REQUIRED))
  { ":ERROR_DS_GC_REQUIRED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_GENERIC_ERROR))
  { ":ERROR_DS_GENERIC_ERROR" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_GLOBAL_CANT_HAVE_CROSSDOMAIN_MEMBER))
  { ":ERROR_DS_GLOBAL_CANT_HAVE_CROSSDOMAIN_MEMBER" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_GLOBAL_CANT_HAVE_LOCAL_MEMBER))
  { ":ERROR_DS_GLOBAL_CANT_HAVE_LOCAL_MEMBER" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_GLOBAL_CANT_HAVE_UNIVERSAL_MEMBER))
  { ":ERROR_DS_GLOBAL_CANT_HAVE_UNIVERSAL_MEMBER" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_GOVERNSID_MISSING))
  { ":ERROR_DS_GOVERNSID_MISSING" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_GROUP_CONVERSION_ERROR))
  { ":ERROR_DS_GROUP_CONVERSION_ERROR" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_HAVE_PRIMARY_MEMBERS))
  { ":ERROR_DS_HAVE_PRIMARY_MEMBERS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_HIERARCHY_TABLE_MALLOC_FAILED))
  { ":ERROR_DS_HIERARCHY_TABLE_MALLOC_FAILED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_ILLEGAL_BASE_SCHEMA_MOD))
  { ":ERROR_DS_ILLEGAL_BASE_SCHEMA_MOD" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_ILLEGAL_MOD_OPERATION))
  { ":ERROR_DS_ILLEGAL_MOD_OPERATION" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_ILLEGAL_SUPERIOR))
  { ":ERROR_DS_ILLEGAL_SUPERIOR" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_ILLEGAL_XDOM_MOVE_OPERATION))
  { ":ERROR_DS_ILLEGAL_XDOM_MOVE_OPERATION" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_INAPPROPRIATE_AUTH))
  { ":ERROR_DS_INAPPROPRIATE_AUTH" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_INAPPROPRIATE_MATCHING))
  { ":ERROR_DS_INAPPROPRIATE_MATCHING" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_INCOMPATIBLE_CONTROLS_USED))
  { ":ERROR_DS_INCOMPATIBLE_CONTROLS_USED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_INCOMPATIBLE_VERSION))
  { ":ERROR_DS_INCOMPATIBLE_VERSION" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_INCORRECT_ROLE_OWNER))
  { ":ERROR_DS_INCORRECT_ROLE_OWNER" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_INIT_FAILURE))
  { ":ERROR_DS_INIT_FAILURE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_INIT_FAILURE_CONSOLE))
  { ":ERROR_DS_INIT_FAILURE_CONSOLE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_INSTALL_NO_SCH_VERSION_IN_INIFILE))
  { ":ERROR_DS_INSTALL_NO_SCH_VERSION_IN_INIFILE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_INSTALL_NO_SRC_SCH_VERSION))
  { ":ERROR_DS_INSTALL_NO_SRC_SCH_VERSION" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_INSTALL_SCHEMA_MISMATCH))
  { ":ERROR_DS_INSTALL_SCHEMA_MISMATCH" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_INSUFFICIENT_ATTR_TO_CREATE_OBJECT))
  { ":ERROR_DS_INSUFFICIENT_ATTR_TO_CREATE_OBJECT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_INSUFF_ACCESS_RIGHTS))
  { ":ERROR_DS_INSUFF_ACCESS_RIGHTS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_INTERNAL_FAILURE))
  { ":ERROR_DS_INTERNAL_FAILURE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_INVALID_ATTRIBUTE_SYNTAX))
  { ":ERROR_DS_INVALID_ATTRIBUTE_SYNTAX" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_INVALID_DMD))
  { ":ERROR_DS_INVALID_DMD" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_INVALID_DN_SYNTAX))
  { ":ERROR_DS_INVALID_DN_SYNTAX" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_INVALID_GROUP_TYPE))
  { ":ERROR_DS_INVALID_GROUP_TYPE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_INVALID_LDAP_DISPLAY_NAME))
  { ":ERROR_DS_INVALID_LDAP_DISPLAY_NAME" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_INVALID_NAME_FOR_SPN))
  { ":ERROR_DS_INVALID_NAME_FOR_SPN" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_INVALID_ROLE_OWNER))
  { ":ERROR_DS_INVALID_ROLE_OWNER" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_INVALID_SCRIPT))
  { ":ERROR_DS_INVALID_SCRIPT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_INVALID_SEARCH_FLAG))
  { ":ERROR_DS_INVALID_SEARCH_FLAG" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_IS_LEAF))
  { ":ERROR_DS_IS_LEAF" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_KEY_NOT_UNIQUE))
  { ":ERROR_DS_KEY_NOT_UNIQUE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_LINK_ID_NOT_AVAILABLE))
  { ":ERROR_DS_LINK_ID_NOT_AVAILABLE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_LOCAL_CANT_HAVE_CROSSDOMAIN_LOCAL_MEMBER))
  { ":ERROR_DS_LOCAL_CANT_HAVE_CROSSDOMAIN_LOCAL_MEMBER" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_LOCAL_ERROR))
  { ":ERROR_DS_LOCAL_ERROR" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_LOCAL_MEMBER_OF_LOCAL_ONLY))
  { ":ERROR_DS_LOCAL_MEMBER_OF_LOCAL_ONLY" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_LOOKUP_FAILURE))
  { ":ERROR_DS_LOOKUP_FAILURE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_LOOP_DETECT))
  { ":ERROR_DS_LOOP_DETECT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_LOW_DSA_VERSION))
  { ":ERROR_DS_LOW_DSA_VERSION" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_MACHINE_ACCOUNT_CREATED_PRENT4))
  { ":ERROR_DS_MACHINE_ACCOUNT_CREATED_PRENT4" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_MACHINE_ACCOUNT_QUOTA_EXCEEDED))
  { ":ERROR_DS_MACHINE_ACCOUNT_QUOTA_EXCEEDED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_MASTERDSA_REQUIRED))
  { ":ERROR_DS_MASTERDSA_REQUIRED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_MAX_OBJ_SIZE_EXCEEDED))
  { ":ERROR_DS_MAX_OBJ_SIZE_EXCEEDED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_MEMBERSHIP_EVALUATED_LOCALLY))
  { ":ERROR_DS_MEMBERSHIP_EVALUATED_LOCALLY" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_MISSING_EXPECTED_ATT))
  { ":ERROR_DS_MISSING_EXPECTED_ATT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_MISSING_FSMO_SETTINGS))
  { ":ERROR_DS_MISSING_FSMO_SETTINGS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_MISSING_INFRASTRUCTURE_CONTAINER))
  { ":ERROR_DS_MISSING_INFRASTRUCTURE_CONTAINER" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_MISSING_REQUIRED_ATT))
  { ":ERROR_DS_MISSING_REQUIRED_ATT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_MISSING_SUPREF))
  { ":ERROR_DS_MISSING_SUPREF" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_MODIFYDN_DISALLOWED_BY_FLAG))
  { ":ERROR_DS_MODIFYDN_DISALLOWED_BY_FLAG" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_MODIFYDN_DISALLOWED_BY_INSTANCE_TYPE))
  { ":ERROR_DS_MODIFYDN_DISALLOWED_BY_INSTANCE_TYPE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_MODIFYDN_WRONG_GRANDPARENT))
  { ":ERROR_DS_MODIFYDN_WRONG_GRANDPARENT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_MUST_BE_RUN_ON_DST_DC))
  { ":ERROR_DS_MUST_BE_RUN_ON_DST_DC" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NAME_ERROR_DOMAIN_ONLY))
  { ":ERROR_DS_NAME_ERROR_DOMAIN_ONLY" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NAME_ERROR_NOT_FOUND))
  { ":ERROR_DS_NAME_ERROR_NOT_FOUND" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NAME_ERROR_NOT_UNIQUE))
  { ":ERROR_DS_NAME_ERROR_NOT_UNIQUE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NAME_ERROR_NO_MAPPING))
  { ":ERROR_DS_NAME_ERROR_NO_MAPPING" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NAME_ERROR_NO_SYNTACTICAL_MAPPING))
  { ":ERROR_DS_NAME_ERROR_NO_SYNTACTICAL_MAPPING" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NAME_ERROR_RESOLVING))
  { ":ERROR_DS_NAME_ERROR_RESOLVING" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NAME_ERROR_TRUST_REFERRAL))
  { ":ERROR_DS_NAME_ERROR_TRUST_REFERRAL" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NAME_NOT_UNIQUE))
  { ":ERROR_DS_NAME_NOT_UNIQUE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NAME_REFERENCE_INVALID))
  { ":ERROR_DS_NAME_REFERENCE_INVALID" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NAME_TOO_LONG))
  { ":ERROR_DS_NAME_TOO_LONG" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NAME_TOO_MANY_PARTS))
  { ":ERROR_DS_NAME_TOO_MANY_PARTS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NAME_TYPE_UNKNOWN))
  { ":ERROR_DS_NAME_TYPE_UNKNOWN" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NAME_UNPARSEABLE))
  { ":ERROR_DS_NAME_UNPARSEABLE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NAME_VALUE_TOO_LONG))
  { ":ERROR_DS_NAME_VALUE_TOO_LONG" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NAMING_MASTER_GC))
  { ":ERROR_DS_NAMING_MASTER_GC" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NAMING_VIOLATION))
  { ":ERROR_DS_NAMING_VIOLATION" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NCNAME_MISSING_CR_REF))
  { ":ERROR_DS_NCNAME_MISSING_CR_REF" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NCNAME_MUST_BE_NC))
  { ":ERROR_DS_NCNAME_MUST_BE_NC" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NC_MUST_HAVE_NC_PARENT))
  { ":ERROR_DS_NC_MUST_HAVE_NC_PARENT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NC_STILL_HAS_DSAS))
  { ":ERROR_DS_NC_STILL_HAS_DSAS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NONEXISTENT_MAY_HAVE))
  { ":ERROR_DS_NONEXISTENT_MAY_HAVE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NONEXISTENT_MUST_HAVE))
  { ":ERROR_DS_NONEXISTENT_MUST_HAVE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NONEXISTENT_POSS_SUP))
  { ":ERROR_DS_NONEXISTENT_POSS_SUP" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NONSAFE_SCHEMA_CHANGE))
  { ":ERROR_DS_NONSAFE_SCHEMA_CHANGE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NON_BASE_SEARCH))
  { ":ERROR_DS_NON_BASE_SEARCH" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NOTIFY_FILTER_TOO_COMPLEX))
  { ":ERROR_DS_NOTIFY_FILTER_TOO_COMPLEX" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NOT_AN_OBJECT))
  { ":ERROR_DS_NOT_AN_OBJECT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NOT_AUTHORITIVE_FOR_DST_NC))
  { ":ERROR_DS_NOT_AUTHORITIVE_FOR_DST_NC" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NOT_CLOSEST))
  { ":ERROR_DS_NOT_CLOSEST" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NOT_INSTALLED))
  { ":ERROR_DS_NOT_INSTALLED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NOT_ON_BACKLINK))
  { ":ERROR_DS_NOT_ON_BACKLINK" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NOT_SUPPORTED))
  { ":ERROR_DS_NOT_SUPPORTED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NOT_SUPPORTED_SORT_ORDER))
  { ":ERROR_DS_NOT_SUPPORTED_SORT_ORDER" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NO_ATTRIBUTE_OR_VALUE))
  { ":ERROR_DS_NO_ATTRIBUTE_OR_VALUE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NO_BEHAVIOR_VERSION_IN_MIXEDDOMAIN))
  { ":ERROR_DS_NO_BEHAVIOR_VERSION_IN_MIXEDDOMAIN" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NO_CHAINED_EVAL))
  { ":ERROR_DS_NO_CHAINED_EVAL" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NO_CHAINING))
  { ":ERROR_DS_NO_CHAINING" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NO_CHECKPOINT_WITH_PDC))
  { ":ERROR_DS_NO_CHECKPOINT_WITH_PDC" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NO_CROSSREF_FOR_NC))
  { ":ERROR_DS_NO_CROSSREF_FOR_NC" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NO_DELETED_NAME))
  { ":ERROR_DS_NO_DELETED_NAME" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NO_FPO_IN_UNIVERSAL_GROUPS))
  { ":ERROR_DS_NO_FPO_IN_UNIVERSAL_GROUPS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NO_MORE_RIDS))
  { ":ERROR_DS_NO_MORE_RIDS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NO_MSDS_INTID))
  { ":ERROR_DS_NO_MSDS_INTID" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NO_NEST_GLOBALGROUP_IN_MIXEDDOMAIN))
  { ":ERROR_DS_NO_NEST_GLOBALGROUP_IN_MIXEDDOMAIN" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NO_NEST_LOCALGROUP_IN_MIXEDDOMAIN))
  { ":ERROR_DS_NO_NEST_LOCALGROUP_IN_MIXEDDOMAIN" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NO_OBJECT_MOVE_IN_SCHEMA_NC))
  { ":ERROR_DS_NO_OBJECT_MOVE_IN_SCHEMA_NC" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NO_PARENT_OBJECT))
  { ":ERROR_DS_NO_PARENT_OBJECT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NO_PKT_PRIVACY_ON_CONNECTION))
  { ":ERROR_DS_NO_PKT_PRIVACY_ON_CONNECTION" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NO_RDN_DEFINED_IN_SCHEMA))
  { ":ERROR_DS_NO_RDN_DEFINED_IN_SCHEMA" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NO_REF_DOMAIN))
  { ":ERROR_DS_NO_REF_DOMAIN" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NO_REQUESTED_ATTS_FOUND))
  { ":ERROR_DS_NO_REQUESTED_ATTS_FOUND" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NO_RESULTS_RETURNED))
  { ":ERROR_DS_NO_RESULTS_RETURNED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NO_RIDS_ALLOCATED))
  { ":ERROR_DS_NO_RIDS_ALLOCATED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NO_SUCH_OBJECT))
  { ":ERROR_DS_NO_SUCH_OBJECT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NO_TREE_DELETE_ABOVE_NC))
  { ":ERROR_DS_NO_TREE_DELETE_ABOVE_NC" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NTDSCRIPT_PROCESS_ERROR))
  { ":ERROR_DS_NTDSCRIPT_PROCESS_ERROR" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_NTDSCRIPT_SYNTAX_ERROR))
  { ":ERROR_DS_NTDSCRIPT_SYNTAX_ERROR" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_OBJECT_BEING_REMOVED))
  { ":ERROR_DS_OBJECT_BEING_REMOVED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_OBJECT_CLASS_REQUIRED))
  { ":ERROR_DS_OBJECT_CLASS_REQUIRED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_OBJECT_RESULTS_TOO_LARGE))
  { ":ERROR_DS_OBJECT_RESULTS_TOO_LARGE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_OBJ_CLASS_NOT_DEFINED))
  { ":ERROR_DS_OBJ_CLASS_NOT_DEFINED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_OBJ_CLASS_NOT_SUBCLASS))
  { ":ERROR_DS_OBJ_CLASS_NOT_SUBCLASS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_OBJ_CLASS_VIOLATION))
  { ":ERROR_DS_OBJ_CLASS_VIOLATION" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_OBJ_GUID_EXISTS))
  { ":ERROR_DS_OBJ_GUID_EXISTS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_OBJ_NOT_FOUND))
  { ":ERROR_DS_OBJ_NOT_FOUND" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_OBJ_STRING_NAME_EXISTS))
  { ":ERROR_DS_OBJ_STRING_NAME_EXISTS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_OBJ_TOO_LARGE))
  { ":ERROR_DS_OBJ_TOO_LARGE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_OFFSET_RANGE_ERROR))
  { ":ERROR_DS_OFFSET_RANGE_ERROR" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_OPERATIONS_ERROR))
  { ":ERROR_DS_OPERATIONS_ERROR" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_OUT_OF_SCOPE))
  { ":ERROR_DS_OUT_OF_SCOPE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_OUT_OF_VERSION_STORE))
  { ":ERROR_DS_OUT_OF_VERSION_STORE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_PARAM_ERROR))
  { ":ERROR_DS_PARAM_ERROR" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_PARENT_IS_AN_ALIAS))
  { ":ERROR_DS_PARENT_IS_AN_ALIAS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_PDC_OPERATION_IN_PROGRESS))
  { ":ERROR_DS_PDC_OPERATION_IN_PROGRESS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_PROTOCOL_ERROR))
  { ":ERROR_DS_PROTOCOL_ERROR" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_RANGE_CONSTRAINT))
  { ":ERROR_DS_RANGE_CONSTRAINT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_RDN_DOESNT_MATCH_SCHEMA))
  { ":ERROR_DS_RDN_DOESNT_MATCH_SCHEMA" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_RECALCSCHEMA_FAILED))
  { ":ERROR_DS_RECALCSCHEMA_FAILED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_REFERRAL))
  { ":ERROR_DS_REFERRAL" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_REFERRAL_LIMIT_EXCEEDED))
  { ":ERROR_DS_REFERRAL_LIMIT_EXCEEDED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_REFUSING_FSMO_ROLES))
  { ":ERROR_DS_REFUSING_FSMO_ROLES" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_REMOTE_CROSSREF_OP_FAILED))
  { ":ERROR_DS_REMOTE_CROSSREF_OP_FAILED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_REPLICATOR_ONLY))
  { ":ERROR_DS_REPLICATOR_ONLY" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_REPLICA_SET_CHANGE_NOT_ALLOWED_ON_DISABLED_CR))
  { ":ERROR_DS_REPLICA_SET_CHANGE_NOT_ALLOWED_ON_DISABLED_CR" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_RESERVED_LINK_ID))
  { ":ERROR_DS_RESERVED_LINK_ID" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_RIDMGR_INIT_ERROR))
  { ":ERROR_DS_RIDMGR_INIT_ERROR" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_ROLE_NOT_VERIFIED))
  { ":ERROR_DS_ROLE_NOT_VERIFIED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_ROOT_CANT_BE_SUBREF))
  { ":ERROR_DS_ROOT_CANT_BE_SUBREF" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_ROOT_MUST_BE_NC))
  { ":ERROR_DS_ROOT_MUST_BE_NC" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_ROOT_REQUIRES_CLASS_TOP))
  { ":ERROR_DS_ROOT_REQUIRES_CLASS_TOP" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_SAM_INIT_FAILURE))
  { ":ERROR_DS_SAM_INIT_FAILURE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_SAM_INIT_FAILURE_CONSOLE))
  { ":ERROR_DS_SAM_INIT_FAILURE_CONSOLE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_SAM_NEED_BOOTKEY_FLOPPY))
  { ":ERROR_DS_SAM_NEED_BOOTKEY_FLOPPY" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_SAM_NEED_BOOTKEY_PASSWORD))
  { ":ERROR_DS_SAM_NEED_BOOTKEY_PASSWORD" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_SCHEMA_ALLOC_FAILED))
  { ":ERROR_DS_SCHEMA_ALLOC_FAILED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_SCHEMA_NOT_LOADED))
  { ":ERROR_DS_SCHEMA_NOT_LOADED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_SCHEMA_UPDATE_DISALLOWED))
  { ":ERROR_DS_SCHEMA_UPDATE_DISALLOWED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_SECURITY_CHECKING_ERROR))
  { ":ERROR_DS_SECURITY_CHECKING_ERROR" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_SECURITY_ILLEGAL_MODIFY))
  { ":ERROR_DS_SECURITY_ILLEGAL_MODIFY" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_SEC_DESC_INVALID))
  { ":ERROR_DS_SEC_DESC_INVALID" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_SEC_DESC_TOO_SHORT))
  { ":ERROR_DS_SEC_DESC_TOO_SHORT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_SEMANTIC_ATT_TEST))
  { ":ERROR_DS_SEMANTIC_ATT_TEST" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_SENSITIVE_GROUP_VIOLATION))
  { ":ERROR_DS_SENSITIVE_GROUP_VIOLATION" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_SERVER_DOWN))
  { ":ERROR_DS_SERVER_DOWN" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_SHUTTING_DOWN))
  { ":ERROR_DS_SHUTTING_DOWN" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_SINGLE_USER_MODE_FAILED))
  { ":ERROR_DS_SINGLE_USER_MODE_FAILED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_SINGLE_VALUE_CONSTRAINT))
  { ":ERROR_DS_SINGLE_VALUE_CONSTRAINT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_SIZELIMIT_EXCEEDED))
  { ":ERROR_DS_SIZELIMIT_EXCEEDED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_SORT_CONTROL_MISSING))
  { ":ERROR_DS_SORT_CONTROL_MISSING" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_SOURCE_AUDITING_NOT_ENABLED))
  { ":ERROR_DS_SOURCE_AUDITING_NOT_ENABLED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_SOURCE_DOMAIN_IN_FOREST))
  { ":ERROR_DS_SOURCE_DOMAIN_IN_FOREST" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_SRC_AND_DST_NC_IDENTICAL))
  { ":ERROR_DS_SRC_AND_DST_NC_IDENTICAL" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_SRC_AND_DST_OBJECT_CLASS_MISMATCH))
  { ":ERROR_DS_SRC_AND_DST_OBJECT_CLASS_MISMATCH" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_SRC_DC_MUST_BE_SP4_OR_GREATER))
  { ":ERROR_DS_SRC_DC_MUST_BE_SP4_OR_GREATER" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_SRC_GUID_MISMATCH))
  { ":ERROR_DS_SRC_GUID_MISMATCH" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_SRC_NAME_MISMATCH))
  { ":ERROR_DS_SRC_NAME_MISMATCH" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_SRC_OBJ_NOT_GROUP_OR_USER))
  { ":ERROR_DS_SRC_OBJ_NOT_GROUP_OR_USER" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_SRC_SID_EXISTS_IN_FOREST))
  { ":ERROR_DS_SRC_SID_EXISTS_IN_FOREST" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_STRING_SD_CONVERSION_FAILED))
  { ":ERROR_DS_STRING_SD_CONVERSION_FAILED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_STRONG_AUTH_REQUIRED))
  { ":ERROR_DS_STRONG_AUTH_REQUIRED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_SUBREF_MUST_HAVE_PARENT))
  { ":ERROR_DS_SUBREF_MUST_HAVE_PARENT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_SUBTREE_NOTIFY_NOT_NC_HEAD))
  { ":ERROR_DS_SUBTREE_NOTIFY_NOT_NC_HEAD" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_SUB_CLS_TEST_FAIL))
  { ":ERROR_DS_SUB_CLS_TEST_FAIL" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_SYNTAX_MISMATCH))
  { ":ERROR_DS_SYNTAX_MISMATCH" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_THREAD_LIMIT_EXCEEDED))
  { ":ERROR_DS_THREAD_LIMIT_EXCEEDED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_TIMELIMIT_EXCEEDED))
  { ":ERROR_DS_TIMELIMIT_EXCEEDED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_TREE_DELETE_NOT_FINISHED))
  { ":ERROR_DS_TREE_DELETE_NOT_FINISHED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_UNABLE_TO_SURRENDER_ROLES))
  { ":ERROR_DS_UNABLE_TO_SURRENDER_ROLES" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_UNAVAILABLE))
  { ":ERROR_DS_UNAVAILABLE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_UNAVAILABLE_CRIT_EXTENSION))
  { ":ERROR_DS_UNAVAILABLE_CRIT_EXTENSION" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_UNICODEPWD_NOT_IN_QUOTES))
  { ":ERROR_DS_UNICODEPWD_NOT_IN_QUOTES" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_UNIVERSAL_CANT_HAVE_LOCAL_MEMBER))
  { ":ERROR_DS_UNIVERSAL_CANT_HAVE_LOCAL_MEMBER" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_UNKNOWN_ERROR))
  { ":ERROR_DS_UNKNOWN_ERROR" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_UNKNOWN_OPERATION))
  { ":ERROR_DS_UNKNOWN_OPERATION" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_UNWILLING_TO_PERFORM))
  { ":ERROR_DS_UNWILLING_TO_PERFORM" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_USER_BUFFER_TO_SMALL))
  { ":ERROR_DS_USER_BUFFER_TO_SMALL" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_WKO_CONTAINER_CANNOT_BE_SPECIAL))
  { ":ERROR_DS_WKO_CONTAINER_CANNOT_BE_SPECIAL" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_WRONG_LINKED_ATT_SYNTAX))
  { ":ERROR_DS_WRONG_LINKED_ATT_SYNTAX" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DS_WRONG_OM_OBJ_CLASS))
  { ":ERROR_DS_WRONG_OM_OBJ_CLASS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DUPLICATE_SERVICE_NAME))
  { ":ERROR_DUPLICATE_SERVICE_NAME" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DUPLICATE_TAG))
  { ":ERROR_DUPLICATE_TAG" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DUP_DOMAINNAME))
  { ":ERROR_DUP_DOMAINNAME" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DUP_NAME))
  { ":ERROR_DUP_NAME" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_DYNLINK_FROM_INVALID_RING))
  { ":ERROR_DYNLINK_FROM_INVALID_RING" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_EAS_DIDNT_FIT))
  { ":ERROR_EAS_DIDNT_FIT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_EAS_NOT_SUPPORTED))
  { ":ERROR_EAS_NOT_SUPPORTED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_EA_ACCESS_DENIED))
  { ":ERROR_EA_ACCESS_DENIED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_EA_FILE_CORRUPT))
  { ":ERROR_EA_FILE_CORRUPT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_EA_LIST_INCONSISTENT))
  { ":ERROR_EA_LIST_INCONSISTENT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_EA_TABLE_FULL))
  { ":ERROR_EA_TABLE_FULL" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_EFS_ALG_BLOB_TOO_BIG))
  { ":ERROR_EFS_ALG_BLOB_TOO_BIG" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_EFS_DISABLED))
  { ":ERROR_EFS_DISABLED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_EFS_SERVER_NOT_TRUSTED))
  { ":ERROR_EFS_SERVER_NOT_TRUSTED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_EFS_VERSION_NOT_SUPPORT))
  { ":ERROR_EFS_VERSION_NOT_SUPPORT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_EMPTY))
  { ":ERROR_EMPTY" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ENCRYPTION_FAILED))
  { ":ERROR_ENCRYPTION_FAILED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_END_OF_MEDIA))
  { ":ERROR_END_OF_MEDIA" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ENVVAR_NOT_FOUND))
  { ":ERROR_ENVVAR_NOT_FOUND" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_EOM_OVERFLOW))
  { ":ERROR_EOM_OVERFLOW" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_EVENTLOG_CANT_START))
  { ":ERROR_EVENTLOG_CANT_START" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_EVENTLOG_FILE_CHANGED))
  { ":ERROR_EVENTLOG_FILE_CHANGED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_EVENTLOG_FILE_CORRUPT))
  { ":ERROR_EVENTLOG_FILE_CORRUPT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_EXCEPTION_IN_SERVICE))
  { ":ERROR_EXCEPTION_IN_SERVICE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_EXCL_SEM_ALREADY_OWNED))
  { ":ERROR_EXCL_SEM_ALREADY_OWNED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_EXE_CANNOT_MODIFY_SIGNED_BINARY))
  { ":ERROR_EXE_CANNOT_MODIFY_SIGNED_BINARY" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_EXE_CANNOT_MODIFY_STRONG_SIGNED_BINARY))
  { ":ERROR_EXE_CANNOT_MODIFY_STRONG_SIGNED_BINARY" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_EXE_MACHINE_TYPE_MISMATCH))
  { ":ERROR_EXE_MACHINE_TYPE_MISMATCH" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_EXE_MARKED_INVALID))
  { ":ERROR_EXE_MARKED_INVALID" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_EXTENDED_ERROR))
  { ":ERROR_EXTENDED_ERROR" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_FAILED_SERVICE_CONTROLLER_CONNECT))
  { ":ERROR_FAILED_SERVICE_CONTROLLER_CONNECT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_FAIL_I24))
  { ":ERROR_FAIL_I24" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_FILEMARK_DETECTED))
  { ":ERROR_FILEMARK_DETECTED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_FILENAME_EXCED_RANGE))
  { ":ERROR_FILENAME_EXCED_RANGE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_FILE_CORRUPT))
  { ":ERROR_FILE_CORRUPT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_FILE_ENCRYPTED))
  { ":ERROR_FILE_ENCRYPTED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_FILE_EXISTS))
  { ":ERROR_FILE_EXISTS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_FILE_INVALID))
  { ":ERROR_FILE_INVALID" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_FILE_NOT_ENCRYPTED))
  { ":ERROR_FILE_NOT_ENCRYPTED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_FILE_NOT_FOUND))
  { ":ERROR_FILE_NOT_FOUND" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_FILE_OFFLINE))
  { ":ERROR_FILE_OFFLINE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_FILE_READ_ONLY))
  { ":ERROR_FILE_READ_ONLY" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_FLOPPY_BAD_REGISTERS))
  { ":ERROR_FLOPPY_BAD_REGISTERS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_FLOPPY_ID_MARK_NOT_FOUND))
  { ":ERROR_FLOPPY_ID_MARK_NOT_FOUND" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_FLOPPY_UNKNOWN_ERROR))
  { ":ERROR_FLOPPY_UNKNOWN_ERROR" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_FLOPPY_WRONG_CYLINDER))
  { ":ERROR_FLOPPY_WRONG_CYLINDER" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_FULLSCREEN_MODE))
  { ":ERROR_FULLSCREEN_MODE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_FULL_BACKUP))
  { ":ERROR_FULL_BACKUP" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_FUNCTION_FAILED))
  { ":ERROR_FUNCTION_FAILED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_FUNCTION_NOT_CALLED))
  { ":ERROR_FUNCTION_NOT_CALLED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_GENERIC_NOT_MAPPED))
  { ":ERROR_GENERIC_NOT_MAPPED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_GEN_FAILURE))
  { ":ERROR_GEN_FAILURE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_GLOBAL_ONLY_HOOK))
  { ":ERROR_GLOBAL_ONLY_HOOK" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_GRACEFUL_DISCONNECT))
  { ":ERROR_GRACEFUL_DISCONNECT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_GROUP_EXISTS))
  { ":ERROR_GROUP_EXISTS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_GROUP_NOT_AVAILABLE))
  { ":ERROR_GROUP_NOT_AVAILABLE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_GROUP_NOT_FOUND))
  { ":ERROR_GROUP_NOT_FOUND" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_GROUP_NOT_ONLINE))
  { ":ERROR_GROUP_NOT_ONLINE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_HANDLE_DISK_FULL))
  { ":ERROR_HANDLE_DISK_FULL" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_HANDLE_EOF))
  { ":ERROR_HANDLE_EOF" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_HOOK_NEEDS_HMOD))
  { ":ERROR_HOOK_NEEDS_HMOD" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_HOOK_NOT_INSTALLED))
  { ":ERROR_HOOK_NOT_INSTALLED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_HOOK_TYPE_NOT_ALLOWED))
  { ":ERROR_HOOK_TYPE_NOT_ALLOWED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_HOST_DOWN))
  { ":ERROR_HOST_DOWN" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_HOST_NODE_NOT_AVAILABLE))
  { ":ERROR_HOST_NODE_NOT_AVAILABLE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_HOST_NODE_NOT_GROUP_OWNER))
  { ":ERROR_HOST_NODE_NOT_GROUP_OWNER" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_HOST_NODE_NOT_RESOURCE_OWNER))
  { ":ERROR_HOST_NODE_NOT_RESOURCE_OWNER" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_HOST_UNREACHABLE))
  { ":ERROR_HOST_UNREACHABLE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_HOTKEY_ALREADY_REGISTERED))
  { ":ERROR_HOTKEY_ALREADY_REGISTERED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_HOTKEY_NOT_REGISTERED))
  { ":ERROR_HOTKEY_NOT_REGISTERED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_HWNDS_HAVE_DIFF_PARENT))
  { ":ERROR_HWNDS_HAVE_DIFF_PARENT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ICM_NOT_ENABLED))
  { ":ERROR_ICM_NOT_ENABLED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ILLEGAL_ELEMENT_ADDRESS))
  { ":ERROR_ILLEGAL_ELEMENT_ADDRESS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ILL_FORMED_PASSWORD))
  { ":ERROR_ILL_FORMED_PASSWORD" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INCORRECT_ADDRESS))
  { ":ERROR_INCORRECT_ADDRESS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INC_BACKUP))
  { ":ERROR_INC_BACKUP" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INDEX_ABSENT))
  { ":ERROR_INDEX_ABSENT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INDIGENOUS_TYPE))
  { ":ERROR_INDIGENOUS_TYPE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INFLOOP_IN_RELOC_CHAIN))
  { ":ERROR_INFLOOP_IN_RELOC_CHAIN" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INSTALL_ALREADY_RUNNING))
  { ":ERROR_INSTALL_ALREADY_RUNNING" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INSTALL_FAILURE))
  { ":ERROR_INSTALL_FAILURE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INSTALL_LANGUAGE_UNSUPPORTED))
  { ":ERROR_INSTALL_LANGUAGE_UNSUPPORTED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INSTALL_LOG_FAILURE))
  { ":ERROR_INSTALL_LOG_FAILURE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INSTALL_NOTUSED))
  { ":ERROR_INSTALL_NOTUSED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INSTALL_PACKAGE_INVALID))
  { ":ERROR_INSTALL_PACKAGE_INVALID" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INSTALL_PACKAGE_OPEN_FAILED))
  { ":ERROR_INSTALL_PACKAGE_OPEN_FAILED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INSTALL_PACKAGE_REJECTED))
  { ":ERROR_INSTALL_PACKAGE_REJECTED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INSTALL_PACKAGE_VERSION))
  { ":ERROR_INSTALL_PACKAGE_VERSION" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INSTALL_PLATFORM_UNSUPPORTED))
  { ":ERROR_INSTALL_PLATFORM_UNSUPPORTED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INSTALL_REMOTE_DISALLOWED))
  { ":ERROR_INSTALL_REMOTE_DISALLOWED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INSTALL_REMOTE_PROHIBITED))
  { ":ERROR_INSTALL_REMOTE_PROHIBITED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INSTALL_SERVICE_FAILURE))
  { ":ERROR_INSTALL_SERVICE_FAILURE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INSTALL_SOURCE_ABSENT))
  { ":ERROR_INSTALL_SOURCE_ABSENT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INSTALL_SUSPEND))
  { ":ERROR_INSTALL_SUSPEND" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INSTALL_TEMP_UNWRITABLE))
  { ":ERROR_INSTALL_TEMP_UNWRITABLE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INSTALL_TRANSFORM_FAILURE))
  { ":ERROR_INSTALL_TRANSFORM_FAILURE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INSTALL_TRANSFORM_REJECTED))
  { ":ERROR_INSTALL_TRANSFORM_REJECTED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INSTALL_UI_FAILURE))
  { ":ERROR_INSTALL_UI_FAILURE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INSTALL_USEREXIT))
  { ":ERROR_INSTALL_USEREXIT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INSUFFICIENT_BUFFER))
  { ":ERROR_INSUFFICIENT_BUFFER" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INTERNAL_DB_CORRUPTION))
  { ":ERROR_INTERNAL_DB_CORRUPTION" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INTERNAL_DB_ERROR))
  { ":ERROR_INTERNAL_DB_ERROR" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INTERNAL_ERROR))
  { ":ERROR_INTERNAL_ERROR" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_ACCEL_HANDLE))
  { ":ERROR_INVALID_ACCEL_HANDLE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_ACCESS))
  { ":ERROR_INVALID_ACCESS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_ACCOUNT_NAME))
  { ":ERROR_INVALID_ACCOUNT_NAME" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_ACL))
  { ":ERROR_INVALID_ACL" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_ADDRESS))
  { ":ERROR_INVALID_ADDRESS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_AT_INTERRUPT_TIME))
  { ":ERROR_INVALID_AT_INTERRUPT_TIME" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_BLOCK))
  { ":ERROR_INVALID_BLOCK" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_BLOCK_LENGTH))
  { ":ERROR_INVALID_BLOCK_LENGTH" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_CATEGORY))
  { ":ERROR_INVALID_CATEGORY" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_CLEANER))
  { ":ERROR_INVALID_CLEANER" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_CMM))
  { ":ERROR_INVALID_CMM" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_COLORINDEX))
  { ":ERROR_INVALID_COLORINDEX" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_COLORSPACE))
  { ":ERROR_INVALID_COLORSPACE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_COMBOBOX_MESSAGE))
  { ":ERROR_INVALID_COMBOBOX_MESSAGE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_COMMAND_LINE))
  { ":ERROR_INVALID_COMMAND_LINE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_COMPUTERNAME))
  { ":ERROR_INVALID_COMPUTERNAME" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_CURSOR_HANDLE))
  { ":ERROR_INVALID_CURSOR_HANDLE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_DATA))
  { ":ERROR_INVALID_DATA" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_DATATYPE))
  { ":ERROR_INVALID_DATATYPE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_DLL))
  { ":ERROR_INVALID_DLL" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_DOMAINNAME))
  { ":ERROR_INVALID_DOMAINNAME" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_DOMAIN_ROLE))
  { ":ERROR_INVALID_DOMAIN_ROLE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_DOMAIN_STATE))
  { ":ERROR_INVALID_DOMAIN_STATE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_DRIVE))
  { ":ERROR_INVALID_DRIVE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_DRIVE_OBJECT))
  { ":ERROR_INVALID_DRIVE_OBJECT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_DWP_HANDLE))
  { ":ERROR_INVALID_DWP_HANDLE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_EA_HANDLE))
  { ":ERROR_INVALID_EA_HANDLE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_EA_NAME))
  { ":ERROR_INVALID_EA_NAME" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_EDIT_HEIGHT))
  { ":ERROR_INVALID_EDIT_HEIGHT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_ENVIRONMENT))
  { ":ERROR_INVALID_ENVIRONMENT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_EVENTNAME))
  { ":ERROR_INVALID_EVENTNAME" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_EVENT_COUNT))
  { ":ERROR_INVALID_EVENT_COUNT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_EXE_SIGNATURE))
  { ":ERROR_INVALID_EXE_SIGNATURE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_FIELD))
  { ":ERROR_INVALID_FIELD" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_FILTER_PROC))
  { ":ERROR_INVALID_FILTER_PROC" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_FLAGS))
  { ":ERROR_INVALID_FLAGS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_FLAG_NUMBER))
  { ":ERROR_INVALID_FLAG_NUMBER" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_FORM_NAME))
  { ":ERROR_INVALID_FORM_NAME" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_FORM_SIZE))
  { ":ERROR_INVALID_FORM_SIZE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_FUNCTION))
  { ":ERROR_INVALID_FUNCTION" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_GROUPNAME))
  { ":ERROR_INVALID_GROUPNAME" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_GROUP_ATTRIBUTES))
  { ":ERROR_INVALID_GROUP_ATTRIBUTES" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_GW_COMMAND))
  { ":ERROR_INVALID_GW_COMMAND" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_HANDLE))
  { ":ERROR_INVALID_HANDLE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_HANDLE_STATE))
  { ":ERROR_INVALID_HANDLE_STATE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_HOOK_FILTER))
  { ":ERROR_INVALID_HOOK_FILTER" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_HOOK_HANDLE))
  { ":ERROR_INVALID_HOOK_HANDLE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_ICON_HANDLE))
  { ":ERROR_INVALID_ICON_HANDLE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_ID_AUTHORITY))
  { ":ERROR_INVALID_ID_AUTHORITY" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_IMPORT_OF_NON_DLL))
  { ":ERROR_INVALID_IMPORT_OF_NON_DLL" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_INDEX))
  { ":ERROR_INVALID_INDEX" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_KEYBOARD_HANDLE))
  { ":ERROR_INVALID_KEYBOARD_HANDLE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_LB_MESSAGE))
  { ":ERROR_INVALID_LB_MESSAGE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_LEVEL))
  { ":ERROR_INVALID_LEVEL" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_LIBRARY))
  { ":ERROR_INVALID_LIBRARY" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_LIST_FORMAT))
  { ":ERROR_INVALID_LIST_FORMAT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_LOGON_HOURS))
  { ":ERROR_INVALID_LOGON_HOURS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_LOGON_TYPE))
  { ":ERROR_INVALID_LOGON_TYPE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_MEDIA))
  { ":ERROR_INVALID_MEDIA" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_MEDIA_POOL))
  { ":ERROR_INVALID_MEDIA_POOL" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_MEMBER))
  { ":ERROR_INVALID_MEMBER" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_MENU_HANDLE))
  { ":ERROR_INVALID_MENU_HANDLE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_MESSAGE))
  { ":ERROR_INVALID_MESSAGE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_MESSAGEDEST))
  { ":ERROR_INVALID_MESSAGEDEST" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_MESSAGENAME))
  { ":ERROR_INVALID_MESSAGENAME" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_MINALLOCSIZE))
  { ":ERROR_INVALID_MINALLOCSIZE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_MODULETYPE))
  { ":ERROR_INVALID_MODULETYPE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_MONITOR_HANDLE))
  { ":ERROR_INVALID_MONITOR_HANDLE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_MSGBOX_STYLE))
  { ":ERROR_INVALID_MSGBOX_STYLE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_NAME))
  { ":ERROR_INVALID_NAME" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_NETNAME))
  { ":ERROR_INVALID_NETNAME" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_OPERATION))
  { ":ERROR_INVALID_OPERATION" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_OPERATION_ON_QUORUM))
  { ":ERROR_INVALID_OPERATION_ON_QUORUM" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_OPLOCK_PROTOCOL))
  { ":ERROR_INVALID_OPLOCK_PROTOCOL" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_ORDINAL))
  { ":ERROR_INVALID_ORDINAL" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_OWNER))
  { ":ERROR_INVALID_OWNER" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_PARAMETER))
  { ":ERROR_INVALID_PARAMETER" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_PASSWORD))
  { ":ERROR_INVALID_PASSWORD" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_PASSWORDNAME))
  { ":ERROR_INVALID_PASSWORDNAME" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_PIXEL_FORMAT))
  { ":ERROR_INVALID_PIXEL_FORMAT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_PRIMARY_GROUP))
  { ":ERROR_INVALID_PRIMARY_GROUP" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_PRINTER_COMMAND))
  { ":ERROR_INVALID_PRINTER_COMMAND" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_PRINTER_NAME))
  { ":ERROR_INVALID_PRINTER_NAME" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_PRINTER_STATE))
  { ":ERROR_INVALID_PRINTER_STATE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_PRINT_MONITOR))
  { ":ERROR_INVALID_PRINT_MONITOR" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_PRIORITY))
  { ":ERROR_INVALID_PRIORITY" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_PROFILE))
  { ":ERROR_INVALID_PROFILE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_REPARSE_DATA))
  { ":ERROR_INVALID_REPARSE_DATA" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_SCROLLBAR_RANGE))
  { ":ERROR_INVALID_SCROLLBAR_RANGE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_SECURITY_DESCR))
  { ":ERROR_INVALID_SECURITY_DESCR" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_SEGDPL))
  { ":ERROR_INVALID_SEGDPL" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_SEGMENT_NUMBER))
  { ":ERROR_INVALID_SEGMENT_NUMBER" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_SEPARATOR_FILE))
  { ":ERROR_INVALID_SEPARATOR_FILE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_SERVER_STATE))
  { ":ERROR_INVALID_SERVER_STATE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_SERVICENAME))
  { ":ERROR_INVALID_SERVICENAME" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_SERVICE_ACCOUNT))
  { ":ERROR_INVALID_SERVICE_ACCOUNT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_SERVICE_CONTROL))
  { ":ERROR_INVALID_SERVICE_CONTROL" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_SERVICE_LOCK))
  { ":ERROR_INVALID_SERVICE_LOCK" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_SHARENAME))
  { ":ERROR_INVALID_SHARENAME" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_SHOWWIN_COMMAND))
  { ":ERROR_INVALID_SHOWWIN_COMMAND" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_SID))
  { ":ERROR_INVALID_SID" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_SIGNAL_NUMBER))
  { ":ERROR_INVALID_SIGNAL_NUMBER" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_SPI_VALUE))
  { ":ERROR_INVALID_SPI_VALUE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_STACKSEG))
  { ":ERROR_INVALID_STACKSEG" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_STARTING_CODESEG))
  { ":ERROR_INVALID_STARTING_CODESEG" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_STATE))
  { ":ERROR_INVALID_STATE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_SUB_AUTHORITY))
  { ":ERROR_INVALID_SUB_AUTHORITY" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_TABLE))
  { ":ERROR_INVALID_TABLE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_TARGET_HANDLE))
  { ":ERROR_INVALID_TARGET_HANDLE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_THREAD_ID))
  { ":ERROR_INVALID_THREAD_ID" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_TIME))
  { ":ERROR_INVALID_TIME" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_TRANSFORM))
  { ":ERROR_INVALID_TRANSFORM" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_USER_BUFFER))
  { ":ERROR_INVALID_USER_BUFFER" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_VERIFY_SWITCH))
  { ":ERROR_INVALID_VERIFY_SWITCH" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_WINDOW_HANDLE))
  { ":ERROR_INVALID_WINDOW_HANDLE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_WINDOW_STYLE))
  { ":ERROR_INVALID_WINDOW_STYLE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_INVALID_WORKSTATION))
  { ":ERROR_INVALID_WORKSTATION" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IOPL_NOT_ENABLED))
  { ":ERROR_IOPL_NOT_ENABLED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IO_DEVICE))
  { ":ERROR_IO_DEVICE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IO_INCOMPLETE))
  { ":ERROR_IO_INCOMPLETE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IO_PENDING))
  { ":ERROR_IO_PENDING" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_DEFAULT_MM_AUTH_NOT_FOUND))
  { ":ERROR_IPSEC_DEFAULT_MM_AUTH_NOT_FOUND" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_DEFAULT_MM_POLICY_NOT_FOUND))
  { ":ERROR_IPSEC_DEFAULT_MM_POLICY_NOT_FOUND" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_DEFAULT_QM_POLICY_NOT_FOUND))
  { ":ERROR_IPSEC_DEFAULT_QM_POLICY_NOT_FOUND" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_ADD_UPDATE_KEY_FAILED))
  { ":ERROR_IPSEC_IKE_ADD_UPDATE_KEY_FAILED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_ATTRIB_FAIL))
  { ":ERROR_IPSEC_IKE_ATTRIB_FAIL" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_AUTH_FAIL))
  { ":ERROR_IPSEC_IKE_AUTH_FAIL" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_BENIGN_REINIT))
  { ":ERROR_IPSEC_IKE_BENIGN_REINIT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_CRL_FAILED))
  { ":ERROR_IPSEC_IKE_CRL_FAILED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_DECRYPT))
  { ":ERROR_IPSEC_IKE_DECRYPT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_DH_FAIL))
  { ":ERROR_IPSEC_IKE_DH_FAIL" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_DH_FAILURE))
  { ":ERROR_IPSEC_IKE_DH_FAILURE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_DROP_NO_RESPONSE))
  { ":ERROR_IPSEC_IKE_DROP_NO_RESPONSE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_ENCRYPT))
  { ":ERROR_IPSEC_IKE_ENCRYPT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_ERROR))
  { ":ERROR_IPSEC_IKE_ERROR" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_FAILQUERYSSP))
  { ":ERROR_IPSEC_IKE_FAILQUERYSSP" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_FAILSSPINIT))
  { ":ERROR_IPSEC_IKE_FAILSSPINIT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_GENERAL_PROCESSING_ERROR))
  { ":ERROR_IPSEC_IKE_GENERAL_PROCESSING_ERROR" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_GETSPIFAIL))
  { ":ERROR_IPSEC_IKE_GETSPIFAIL" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_INVALID_AUTH_ALG))
  { ":ERROR_IPSEC_IKE_INVALID_AUTH_ALG" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_INVALID_CERT_KEYLEN))
  { ":ERROR_IPSEC_IKE_INVALID_CERT_KEYLEN" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_INVALID_CERT_TYPE))
  { ":ERROR_IPSEC_IKE_INVALID_CERT_TYPE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_INVALID_COOKIE))
  { ":ERROR_IPSEC_IKE_INVALID_COOKIE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_INVALID_ENCRYPT_ALG))
  { ":ERROR_IPSEC_IKE_INVALID_ENCRYPT_ALG" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_INVALID_FILTER))
  { ":ERROR_IPSEC_IKE_INVALID_FILTER" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_INVALID_GROUP))
  { ":ERROR_IPSEC_IKE_INVALID_GROUP" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_INVALID_HASH))
  { ":ERROR_IPSEC_IKE_INVALID_HASH" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_INVALID_HASH_ALG))
  { ":ERROR_IPSEC_IKE_INVALID_HASH_ALG" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_INVALID_HASH_SIZE))
  { ":ERROR_IPSEC_IKE_INVALID_HASH_SIZE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_INVALID_HEADER))
  { ":ERROR_IPSEC_IKE_INVALID_HEADER" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_INVALID_KEY_USAGE))
  { ":ERROR_IPSEC_IKE_INVALID_KEY_USAGE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_INVALID_PAYLOAD))
  { ":ERROR_IPSEC_IKE_INVALID_PAYLOAD" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_INVALID_POLICY))
  { ":ERROR_IPSEC_IKE_INVALID_POLICY" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_INVALID_RESPONDER_LIFETIME_NOTIFY))
  { ":ERROR_IPSEC_IKE_INVALID_RESPONDER_LIFETIME_NOTIFY" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_INVALID_SIG))
  { ":ERROR_IPSEC_IKE_INVALID_SIG" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_INVALID_SIGNATURE))
  { ":ERROR_IPSEC_IKE_INVALID_SIGNATURE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_INVALID_SITUATION))
  { ":ERROR_IPSEC_IKE_INVALID_SITUATION" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_KERBEROS_ERROR))
  { ":ERROR_IPSEC_IKE_KERBEROS_ERROR" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_LOAD_FAILED))
  { ":ERROR_IPSEC_IKE_LOAD_FAILED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_LOAD_SOFT_SA))
  { ":ERROR_IPSEC_IKE_LOAD_SOFT_SA" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_MM_ACQUIRE_DROP))
  { ":ERROR_IPSEC_IKE_MM_ACQUIRE_DROP" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_MM_DELAY_DROP))
  { ":ERROR_IPSEC_IKE_MM_DELAY_DROP" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_MM_LIMIT))
  { ":ERROR_IPSEC_IKE_MM_LIMIT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_NEGOTIATION_DISABLED))
  { ":ERROR_IPSEC_IKE_NEGOTIATION_DISABLED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_NEGOTIATION_PENDING))
  { ":ERROR_IPSEC_IKE_NEGOTIATION_PENDING" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_NEG_STATUS_END))
  { ":ERROR_IPSEC_IKE_NEG_STATUS_END" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_NOTCBPRIV))
  { ":ERROR_IPSEC_IKE_NOTCBPRIV" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_NO_CERT))
  { ":ERROR_IPSEC_IKE_NO_CERT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_NO_MM_POLICY))
  { ":ERROR_IPSEC_IKE_NO_MM_POLICY" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_NO_PEER_CERT))
  { ":ERROR_IPSEC_IKE_NO_PEER_CERT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_NO_POLICY))
  { ":ERROR_IPSEC_IKE_NO_POLICY" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_NO_PRIVATE_KEY))
  { ":ERROR_IPSEC_IKE_NO_PRIVATE_KEY" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_NO_PUBLIC_KEY))
  { ":ERROR_IPSEC_IKE_NO_PUBLIC_KEY" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_OUT_OF_MEMORY))
  { ":ERROR_IPSEC_IKE_OUT_OF_MEMORY" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_PEER_CRL_FAILED))
  { ":ERROR_IPSEC_IKE_PEER_CRL_FAILED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_POLICY_CHANGE))
  { ":ERROR_IPSEC_IKE_POLICY_CHANGE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_POLICY_MATCH))
  { ":ERROR_IPSEC_IKE_POLICY_MATCH" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_PROCESS_ERR))
  { ":ERROR_IPSEC_IKE_PROCESS_ERR" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_PROCESS_ERR_CERT))
  { ":ERROR_IPSEC_IKE_PROCESS_ERR_CERT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_PROCESS_ERR_CERT_REQ))
  { ":ERROR_IPSEC_IKE_PROCESS_ERR_CERT_REQ" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_PROCESS_ERR_DELETE))
  { ":ERROR_IPSEC_IKE_PROCESS_ERR_DELETE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_PROCESS_ERR_HASH))
  { ":ERROR_IPSEC_IKE_PROCESS_ERR_HASH" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_PROCESS_ERR_ID))
  { ":ERROR_IPSEC_IKE_PROCESS_ERR_ID" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_PROCESS_ERR_KE))
  { ":ERROR_IPSEC_IKE_PROCESS_ERR_KE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_PROCESS_ERR_NONCE))
  { ":ERROR_IPSEC_IKE_PROCESS_ERR_NONCE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_PROCESS_ERR_NOTIFY))
  { ":ERROR_IPSEC_IKE_PROCESS_ERR_NOTIFY" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_PROCESS_ERR_PROP))
  { ":ERROR_IPSEC_IKE_PROCESS_ERR_PROP" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_PROCESS_ERR_SA))
  { ":ERROR_IPSEC_IKE_PROCESS_ERR_SA" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_PROCESS_ERR_SIG))
  { ":ERROR_IPSEC_IKE_PROCESS_ERR_SIG" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_PROCESS_ERR_TRANS))
  { ":ERROR_IPSEC_IKE_PROCESS_ERR_TRANS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_PROCESS_ERR_VENDOR))
  { ":ERROR_IPSEC_IKE_PROCESS_ERR_VENDOR" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_QM_ACQUIRE_DROP))
  { ":ERROR_IPSEC_IKE_QM_ACQUIRE_DROP" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_QM_DELAY_DROP))
  { ":ERROR_IPSEC_IKE_QM_DELAY_DROP" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_QUEUE_DROP_MM))
  { ":ERROR_IPSEC_IKE_QUEUE_DROP_MM" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_QUEUE_DROP_NO_MM))
  { ":ERROR_IPSEC_IKE_QUEUE_DROP_NO_MM" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_RPC_DELETE))
  { ":ERROR_IPSEC_IKE_RPC_DELETE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_SA_DELETED))
  { ":ERROR_IPSEC_IKE_SA_DELETED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_SA_REAPED))
  { ":ERROR_IPSEC_IKE_SA_REAPED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_SECLOADFAIL))
  { ":ERROR_IPSEC_IKE_SECLOADFAIL" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_SOFT_SA_TORN_DOWN))
  { ":ERROR_IPSEC_IKE_SOFT_SA_TORN_DOWN" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_SRVACQFAIL))
  { ":ERROR_IPSEC_IKE_SRVACQFAIL" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_SRVQUERYCRED))
  { ":ERROR_IPSEC_IKE_SRVQUERYCRED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_TIMED_OUT))
  { ":ERROR_IPSEC_IKE_TIMED_OUT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_UNKNOWN_DOI))
  { ":ERROR_IPSEC_IKE_UNKNOWN_DOI" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_IKE_UNSUPPORTED_ID))
  { ":ERROR_IPSEC_IKE_UNSUPPORTED_ID" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_MM_AUTH_EXISTS))
  { ":ERROR_IPSEC_MM_AUTH_EXISTS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_MM_AUTH_IN_USE))
  { ":ERROR_IPSEC_MM_AUTH_IN_USE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_MM_AUTH_NOT_FOUND))
  { ":ERROR_IPSEC_MM_AUTH_NOT_FOUND" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_MM_AUTH_PENDING_DELETION))
  { ":ERROR_IPSEC_MM_AUTH_PENDING_DELETION" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_MM_FILTER_EXISTS))
  { ":ERROR_IPSEC_MM_FILTER_EXISTS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_MM_FILTER_NOT_FOUND))
  { ":ERROR_IPSEC_MM_FILTER_NOT_FOUND" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_MM_FILTER_PENDING_DELETION))
  { ":ERROR_IPSEC_MM_FILTER_PENDING_DELETION" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_MM_POLICY_EXISTS))
  { ":ERROR_IPSEC_MM_POLICY_EXISTS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_MM_POLICY_IN_USE))
  { ":ERROR_IPSEC_MM_POLICY_IN_USE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_MM_POLICY_NOT_FOUND))
  { ":ERROR_IPSEC_MM_POLICY_NOT_FOUND" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_MM_POLICY_PENDING_DELETION))
  { ":ERROR_IPSEC_MM_POLICY_PENDING_DELETION" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_QM_POLICY_EXISTS))
  { ":ERROR_IPSEC_QM_POLICY_EXISTS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_QM_POLICY_IN_USE))
  { ":ERROR_IPSEC_QM_POLICY_IN_USE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_QM_POLICY_NOT_FOUND))
  { ":ERROR_IPSEC_QM_POLICY_NOT_FOUND" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_QM_POLICY_PENDING_DELETION))
  { ":ERROR_IPSEC_QM_POLICY_PENDING_DELETION" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_TRANSPORT_FILTER_EXISTS))
  { ":ERROR_IPSEC_TRANSPORT_FILTER_EXISTS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_TRANSPORT_FILTER_NOT_FOUND))
  { ":ERROR_IPSEC_TRANSPORT_FILTER_NOT_FOUND" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_TRANSPORT_FILTER_PENDING_DELETION))
  { ":ERROR_IPSEC_TRANSPORT_FILTER_PENDING_DELETION" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_TUNNEL_FILTER_EXISTS))
  { ":ERROR_IPSEC_TUNNEL_FILTER_EXISTS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_TUNNEL_FILTER_NOT_FOUND))
  { ":ERROR_IPSEC_TUNNEL_FILTER_NOT_FOUND" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IPSEC_TUNNEL_FILTER_PENDING_DELETION))
  { ":ERROR_IPSEC_TUNNEL_FILTER_PENDING_DELETION" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IRQ_BUSY))
  { ":ERROR_IRQ_BUSY" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IS_JOINED))
  { ":ERROR_IS_JOINED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IS_JOIN_PATH))
  { ":ERROR_IS_JOIN_PATH" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IS_JOIN_TARGET))
  { ":ERROR_IS_JOIN_TARGET" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IS_SUBSTED))
  { ":ERROR_IS_SUBSTED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IS_SUBST_PATH))
  { ":ERROR_IS_SUBST_PATH" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_IS_SUBST_TARGET))
  { ":ERROR_IS_SUBST_TARGET" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ITERATED_DATA_EXCEEDS_64k))
  { ":ERROR_ITERATED_DATA_EXCEEDS_64K" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_JOIN_TO_JOIN))
  { ":ERROR_JOIN_TO_JOIN" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_JOIN_TO_SUBST))
  { ":ERROR_JOIN_TO_SUBST" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_JOURNAL_DELETE_IN_PROGRESS))
  { ":ERROR_JOURNAL_DELETE_IN_PROGRESS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_JOURNAL_ENTRY_DELETED))
  { ":ERROR_JOURNAL_ENTRY_DELETED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_JOURNAL_HOOK_SET))
  { ":ERROR_JOURNAL_HOOK_SET" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_JOURNAL_NOT_ACTIVE))
  { ":ERROR_JOURNAL_NOT_ACTIVE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_KEY_DELETED))
  { ":ERROR_KEY_DELETED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_KEY_HAS_CHILDREN))
  { ":ERROR_KEY_HAS_CHILDREN" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_KM_DRIVER_BLOCKED))
  { ":ERROR_KM_DRIVER_BLOCKED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_LABEL_TOO_LONG))
  { ":ERROR_LABEL_TOO_LONG" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_LAST_ADMIN))
  { ":ERROR_LAST_ADMIN" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_LB_WITHOUT_TABSTOPS))
  { ":ERROR_LB_WITHOUT_TABSTOPS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_LIBRARY_FULL))
  { ":ERROR_LIBRARY_FULL" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_LIBRARY_OFFLINE))
  { ":ERROR_LIBRARY_OFFLINE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_LICENSE_QUOTA_EXCEEDED))
  { ":ERROR_LICENSE_QUOTA_EXCEEDED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_LISTBOX_ID_NOT_FOUND))
  { ":ERROR_LISTBOX_ID_NOT_FOUND" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_LM_CROSS_ENCRYPTION_REQUIRED))
  { ":ERROR_LM_CROSS_ENCRYPTION_REQUIRED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_LOCAL_USER_SESSION_KEY))
  { ":ERROR_LOCAL_USER_SESSION_KEY" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_LOCKED))
  { ":ERROR_LOCKED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_LOCK_FAILED))
  { ":ERROR_LOCK_FAILED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_LOCK_VIOLATION))
  { ":ERROR_LOCK_VIOLATION" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_LOGIN_TIME_RESTRICTION))
  { ":ERROR_LOGIN_TIME_RESTRICTION" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_LOGIN_WKSTA_RESTRICTION))
  { ":ERROR_LOGIN_WKSTA_RESTRICTION" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_LOGON_FAILURE))
  { ":ERROR_LOGON_FAILURE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_LOGON_NOT_GRANTED))
  { ":ERROR_LOGON_NOT_GRANTED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_LOGON_SESSION_COLLISION))
  { ":ERROR_LOGON_SESSION_COLLISION" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_LOGON_SESSION_EXISTS))
  { ":ERROR_LOGON_SESSION_EXISTS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_LOGON_TYPE_NOT_GRANTED))
  { ":ERROR_LOGON_TYPE_NOT_GRANTED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_LOG_FILE_FULL))
  { ":ERROR_LOG_FILE_FULL" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_LUIDS_EXHAUSTED))
  { ":ERROR_LUIDS_EXHAUSTED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_MACHINE_LOCKED))
  { ":ERROR_MACHINE_LOCKED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_MAGAZINE_NOT_PRESENT))
  { ":ERROR_MAGAZINE_NOT_PRESENT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_MAPPED_ALIGNMENT))
  { ":ERROR_MAPPED_ALIGNMENT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_MAX_THRDS_REACHED))
  { ":ERROR_MAX_THRDS_REACHED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_MEDIA_CHANGED))
  { ":ERROR_MEDIA_CHANGED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_MEDIA_INCOMPATIBLE))
  { ":ERROR_MEDIA_INCOMPATIBLE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_MEDIA_NOT_AVAILABLE))
  { ":ERROR_MEDIA_NOT_AVAILABLE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_MEDIA_OFFLINE))
  { ":ERROR_MEDIA_OFFLINE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_MEDIA_UNAVAILABLE))
  { ":ERROR_MEDIA_UNAVAILABLE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_MEDIUM_NOT_ACCESSIBLE))
  { ":ERROR_MEDIUM_NOT_ACCESSIBLE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_MEMBERS_PRIMARY_GROUP))
  { ":ERROR_MEMBERS_PRIMARY_GROUP" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_MEMBER_IN_ALIAS))
  { ":ERROR_MEMBER_IN_ALIAS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_MEMBER_IN_GROUP))
  { ":ERROR_MEMBER_IN_GROUP" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_MEMBER_NOT_IN_ALIAS))
  { ":ERROR_MEMBER_NOT_IN_ALIAS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_MEMBER_NOT_IN_GROUP))
  { ":ERROR_MEMBER_NOT_IN_GROUP" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_MENU_ITEM_NOT_FOUND))
  { ":ERROR_MENU_ITEM_NOT_FOUND" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_MESSAGE_EXCEEDS_MAX_SIZE))
  { ":ERROR_MESSAGE_EXCEEDS_MAX_SIZE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_MESSAGE_SYNC_ONLY))
  { ":ERROR_MESSAGE_SYNC_ONLY" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_METAFILE_NOT_SUPPORTED))
  { ":ERROR_METAFILE_NOT_SUPPORTED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_META_EXPANSION_TOO_LONG))
  { ":ERROR_META_EXPANSION_TOO_LONG" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_MOD_NOT_FOUND))
  { ":ERROR_MOD_NOT_FOUND" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_MORE_DATA))
  { ":ERROR_MORE_DATA" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_MORE_WRITES))
  { ":ERROR_MORE_WRITES" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_MR_MID_NOT_FOUND))
  { ":ERROR_MR_MID_NOT_FOUND" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_MUTUAL_AUTH_FAILED))
  { ":ERROR_MUTUAL_AUTH_FAILED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NEGATIVE_SEEK))
  { ":ERROR_NEGATIVE_SEEK" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NESTING_NOT_ALLOWED))
  { ":ERROR_NESTING_NOT_ALLOWED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NETLOGON_NOT_STARTED))
  { ":ERROR_NETLOGON_NOT_STARTED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NETNAME_DELETED))
  { ":ERROR_NETNAME_DELETED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NETWORK_ACCESS_DENIED))
  { ":ERROR_NETWORK_ACCESS_DENIED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NETWORK_BUSY))
  { ":ERROR_NETWORK_BUSY" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NETWORK_NOT_AVAILABLE))
  { ":ERROR_NETWORK_NOT_AVAILABLE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NETWORK_UNREACHABLE))
  { ":ERROR_NETWORK_UNREACHABLE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NET_WRITE_FAULT))
  { ":ERROR_NET_WRITE_FAULT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOACCESS))
  { ":ERROR_NOACCESS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NODE_CANNOT_BE_CLUSTERED))
  { ":ERROR_NODE_CANNOT_BE_CLUSTERED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NODE_CANT_HOST_RESOURCE))
  { ":ERROR_NODE_CANT_HOST_RESOURCE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NODE_NOT_AVAILABLE))
  { ":ERROR_NODE_NOT_AVAILABLE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT))
  { ":ERROR_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOLOGON_SERVER_TRUST_ACCOUNT))
  { ":ERROR_NOLOGON_SERVER_TRUST_ACCOUNT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOLOGON_WORKSTATION_TRUST_ACCOUNT))
  { ":ERROR_NOLOGON_WORKSTATION_TRUST_ACCOUNT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NONE_MAPPED))
  { ":ERROR_NONE_MAPPED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NONPAGED_SYSTEM_RESOURCES))
  { ":ERROR_NONPAGED_SYSTEM_RESOURCES" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NON_ACCOUNT_SID))
  { ":ERROR_NON_ACCOUNT_SID" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NON_DOMAIN_SID))
  { ":ERROR_NON_DOMAIN_SID" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NON_MDICHILD_WINDOW))
  { ":ERROR_NON_MDICHILD_WINDOW" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOTIFY_ENUM_DIR))
  { ":ERROR_NOTIFY_ENUM_DIR" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOT_ALL_ASSIGNED))
  { ":ERROR_NOT_ALL_ASSIGNED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOT_AUTHENTICATED))
  { ":ERROR_NOT_AUTHENTICATED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOT_A_REPARSE_POINT))
  { ":ERROR_NOT_A_REPARSE_POINT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOT_CHILD_WINDOW))
  { ":ERROR_NOT_CHILD_WINDOW" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOT_CONNECTED))
  { ":ERROR_NOT_CONNECTED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOT_CONTAINER))
  { ":ERROR_NOT_CONTAINER" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOT_DOS_DISK))
  { ":ERROR_NOT_DOS_DISK" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOT_EMPTY))
  { ":ERROR_NOT_EMPTY" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOT_ENOUGH_MEMORY))
  { ":ERROR_NOT_ENOUGH_MEMORY" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOT_ENOUGH_QUOTA))
  { ":ERROR_NOT_ENOUGH_QUOTA" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOT_ENOUGH_SERVER_MEMORY))
  { ":ERROR_NOT_ENOUGH_SERVER_MEMORY" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOT_EXPORT_FORMAT))
  { ":ERROR_NOT_EXPORT_FORMAT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOT_FOUND))
  { ":ERROR_NOT_FOUND" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOT_JOINED))
  { ":ERROR_NOT_JOINED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOT_LOCKED))
  { ":ERROR_NOT_LOCKED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOT_LOGGED_ON))
  { ":ERROR_NOT_LOGGED_ON" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOT_LOGON_PROCESS))
  { ":ERROR_NOT_LOGON_PROCESS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOT_OWNER))
  { ":ERROR_NOT_OWNER" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOT_QUORUM_CAPABLE))
  { ":ERROR_NOT_QUORUM_CAPABLE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOT_QUORUM_CLASS))
  { ":ERROR_NOT_QUORUM_CLASS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOT_READY))
  { ":ERROR_NOT_READY" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOT_REGISTRY_FILE))
  { ":ERROR_NOT_REGISTRY_FILE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOT_SAFEBOOT_SERVICE))
  { ":ERROR_NOT_SAFEBOOT_SERVICE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOT_SAME_DEVICE))
  { ":ERROR_NOT_SAME_DEVICE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOT_SUBSTED))
  { ":ERROR_NOT_SUBSTED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOT_SUPPORTED))
  { ":ERROR_NOT_SUPPORTED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOT_SUPPORTED_ON_SBS))
  { ":ERROR_NOT_SUPPORTED_ON_SBS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NOT_SUPPORTED_ON_STANDARD_SERVER))
  { ":ERROR_NOT_SUPPORTED_ON_STANDARD_SERVER" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_ASSOCIATION))
  { ":ERROR_NO_ASSOCIATION" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_BROWSER_SERVERS_FOUND))
  { ":ERROR_NO_BROWSER_SERVERS_FOUND" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_DATA))
  { ":ERROR_NO_DATA" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_DATA_DETECTED))
  { ":ERROR_NO_DATA_DETECTED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_EFS))
  { ":ERROR_NO_EFS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_IMPERSONATION_TOKEN))
  { ":ERROR_NO_IMPERSONATION_TOKEN" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_INHERITANCE))
  { ":ERROR_NO_INHERITANCE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_LOGON_SERVERS))
  { ":ERROR_NO_LOGON_SERVERS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_LOG_SPACE))
  { ":ERROR_NO_LOG_SPACE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_MATCH))
  { ":ERROR_NO_MATCH" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_MEDIA_IN_DRIVE))
  { ":ERROR_NO_MEDIA_IN_DRIVE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_MORE_DEVICES))
  { ":ERROR_NO_MORE_DEVICES" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_MORE_FILES))
  { ":ERROR_NO_MORE_FILES" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_MORE_ITEMS))
  { ":ERROR_NO_MORE_ITEMS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_MORE_SEARCH_HANDLES))
  { ":ERROR_NO_MORE_SEARCH_HANDLES" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_MORE_USER_HANDLES))
  { ":ERROR_NO_MORE_USER_HANDLES" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_NETWORK))
  { ":ERROR_NO_NETWORK" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_NET_OR_BAD_PATH))
  { ":ERROR_NO_NET_OR_BAD_PATH" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_PROC_SLOTS))
  { ":ERROR_NO_PROC_SLOTS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_PROMOTION_ACTIVE))
  { ":ERROR_NO_PROMOTION_ACTIVE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_QUOTAS_FOR_ACCOUNT))
  { ":ERROR_NO_QUOTAS_FOR_ACCOUNT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_RECOVERY_POLICY))
  { ":ERROR_NO_RECOVERY_POLICY" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_RECOVERY_PROGRAM))
  { ":ERROR_NO_RECOVERY_PROGRAM" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_SCROLLBARS))
  { ":ERROR_NO_SCROLLBARS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_SECURITY_ON_OBJECT))
  { ":ERROR_NO_SECURITY_ON_OBJECT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_SHUTDOWN_IN_PROGRESS))
  { ":ERROR_NO_SHUTDOWN_IN_PROGRESS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_SIGNAL_SENT))
  { ":ERROR_NO_SIGNAL_SENT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_SITENAME))
  { ":ERROR_NO_SITENAME" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_SPOOL_SPACE))
  { ":ERROR_NO_SPOOL_SPACE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_SUCH_ALIAS))
  { ":ERROR_NO_SUCH_ALIAS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_SUCH_DOMAIN))
  { ":ERROR_NO_SUCH_DOMAIN" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_SUCH_GROUP))
  { ":ERROR_NO_SUCH_GROUP" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_SUCH_LOGON_SESSION))
  { ":ERROR_NO_SUCH_LOGON_SESSION" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_SUCH_MEMBER))
  { ":ERROR_NO_SUCH_MEMBER" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_SUCH_PACKAGE))
  { ":ERROR_NO_SUCH_PACKAGE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_SUCH_PRIVILEGE))
  { ":ERROR_NO_SUCH_PRIVILEGE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_SUCH_SITE))
  { ":ERROR_NO_SUCH_SITE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_SUCH_USER))
  { ":ERROR_NO_SUCH_USER" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_SUPPORTING_DRIVES))
  { ":ERROR_NO_SUPPORTING_DRIVES" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_SYSTEM_MENU))
  { ":ERROR_NO_SYSTEM_MENU" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_SYSTEM_RESOURCES))
  { ":ERROR_NO_SYSTEM_RESOURCES" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_TOKEN))
  { ":ERROR_NO_TOKEN" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_TRACKING_SERVICE))
  { ":ERROR_NO_TRACKING_SERVICE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_TRUST_LSA_SECRET))
  { ":ERROR_NO_TRUST_LSA_SECRET" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_TRUST_SAM_ACCOUNT))
  { ":ERROR_NO_TRUST_SAM_ACCOUNT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_UNICODE_TRANSLATION))
  { ":ERROR_NO_UNICODE_TRANSLATION" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_USER_KEYS))
  { ":ERROR_NO_USER_KEYS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_USER_SESSION_KEY))
  { ":ERROR_NO_USER_SESSION_KEY" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_VOLUME_ID))
  { ":ERROR_NO_VOLUME_ID" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_VOLUME_LABEL))
  { ":ERROR_NO_VOLUME_LABEL" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NO_WILDCARD_CHARACTERS))
  { ":ERROR_NO_WILDCARD_CHARACTERS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NT_CROSS_ENCRYPTION_REQUIRED))
  { ":ERROR_NT_CROSS_ENCRYPTION_REQUIRED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_NULL_LM_PASSWORD))
  { ":ERROR_NULL_LM_PASSWORD" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_OBJECT_ALREADY_EXISTS))
  { ":ERROR_OBJECT_ALREADY_EXISTS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_OBJECT_IN_LIST))
  { ":ERROR_OBJECT_IN_LIST" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_OBJECT_NOT_FOUND))
  { ":ERROR_OBJECT_NOT_FOUND" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_OLD_WIN_VERSION))
  { ":ERROR_OLD_WIN_VERSION" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_ONLY_IF_CONNECTED))
  { ":ERROR_ONLY_IF_CONNECTED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_OPEN_FAILED))
  { ":ERROR_OPEN_FAILED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_OPEN_FILES))
  { ":ERROR_OPEN_FILES" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_OPERATION_ABORTED))
  { ":ERROR_OPERATION_ABORTED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_OPLOCK_NOT_GRANTED))
  { ":ERROR_OPLOCK_NOT_GRANTED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_OUTOFMEMORY))
  { ":ERROR_OUTOFMEMORY" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_OUT_OF_PAPER))
  { ":ERROR_OUT_OF_PAPER" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_OUT_OF_STRUCTURES))
  { ":ERROR_OUT_OF_STRUCTURES" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_OVERRIDE_NOCHANGES))
  { ":ERROR_OVERRIDE_NOCHANGES" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PAGED_SYSTEM_RESOURCES))
  { ":ERROR_PAGED_SYSTEM_RESOURCES" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PAGEFILE_QUOTA))
  { ":ERROR_PAGEFILE_QUOTA" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PARAMETER_QUOTA_EXCEEDED))
  { ":ERROR_PARAMETER_QUOTA_EXCEEDED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PARTIAL_COPY))
  { ":ERROR_PARTIAL_COPY" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PARTITION_FAILURE))
  { ":ERROR_PARTITION_FAILURE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PASSWORD_EXPIRED))
  { ":ERROR_PASSWORD_EXPIRED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PASSWORD_MUST_CHANGE))
  { ":ERROR_PASSWORD_MUST_CHANGE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PASSWORD_RESTRICTION))
  { ":ERROR_PASSWORD_RESTRICTION" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PATCH_PACKAGE_INVALID))
  { ":ERROR_PATCH_PACKAGE_INVALID" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PATCH_PACKAGE_OPEN_FAILED))
  { ":ERROR_PATCH_PACKAGE_OPEN_FAILED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PATCH_PACKAGE_REJECTED))
  { ":ERROR_PATCH_PACKAGE_REJECTED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PATCH_PACKAGE_UNSUPPORTED))
  { ":ERROR_PATCH_PACKAGE_UNSUPPORTED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PATCH_TARGET_NOT_FOUND))
  { ":ERROR_PATCH_TARGET_NOT_FOUND" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PATH_BUSY))
  { ":ERROR_PATH_BUSY" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PATH_NOT_FOUND))
  { ":ERROR_PATH_NOT_FOUND" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PER_USER_TRUST_QUOTA_EXCEEDED))
  { ":ERROR_PER_USER_TRUST_QUOTA_EXCEEDED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PIPE_BUSY))
  { ":ERROR_PIPE_BUSY" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PIPE_CONNECTED))
  { ":ERROR_PIPE_CONNECTED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PIPE_LISTENING))
  { ":ERROR_PIPE_LISTENING" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PIPE_NOT_CONNECTED))
  { ":ERROR_PIPE_NOT_CONNECTED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PKINIT_FAILURE))
  { ":ERROR_PKINIT_FAILURE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_POINT_NOT_FOUND))
  { ":ERROR_POINT_NOT_FOUND" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_POLICY_OBJECT_NOT_FOUND))
  { ":ERROR_POLICY_OBJECT_NOT_FOUND" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_POLICY_ONLY_IN_DS))
  { ":ERROR_POLICY_ONLY_IN_DS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_POPUP_ALREADY_ACTIVE))
  { ":ERROR_POPUP_ALREADY_ACTIVE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PORT_UNREACHABLE))
  { ":ERROR_PORT_UNREACHABLE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_POSSIBLE_DEADLOCK))
  { ":ERROR_POSSIBLE_DEADLOCK" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_POTENTIAL_FILE_FOUND))
  { ":ERROR_POTENTIAL_FILE_FOUND" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PRINTER_ALREADY_EXISTS))
  { ":ERROR_PRINTER_ALREADY_EXISTS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PRINTER_DELETED))
  { ":ERROR_PRINTER_DELETED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PRINTER_DRIVER_ALREADY_INSTALLED))
  { ":ERROR_PRINTER_DRIVER_ALREADY_INSTALLED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PRINTER_DRIVER_BLOCKED))
  { ":ERROR_PRINTER_DRIVER_BLOCKED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PRINTER_DRIVER_IN_USE))
  { ":ERROR_PRINTER_DRIVER_IN_USE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PRINTER_DRIVER_WARNED))
  { ":ERROR_PRINTER_DRIVER_WARNED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PRINTER_HAS_JOBS_QUEUED))
  { ":ERROR_PRINTER_HAS_JOBS_QUEUED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PRINTER_NOT_FOUND))
  { ":ERROR_PRINTER_NOT_FOUND" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PRINTQ_FULL))
  { ":ERROR_PRINTQ_FULL" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PRINT_CANCELLED))
  { ":ERROR_PRINT_CANCELLED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PRINT_MONITOR_ALREADY_INSTALLED))
  { ":ERROR_PRINT_MONITOR_ALREADY_INSTALLED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PRINT_MONITOR_IN_USE))
  { ":ERROR_PRINT_MONITOR_IN_USE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PRINT_PROCESSOR_ALREADY_INSTALLED))
  { ":ERROR_PRINT_PROCESSOR_ALREADY_INSTALLED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PRIVATE_DIALOG_INDEX))
  { ":ERROR_PRIVATE_DIALOG_INDEX" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PRIVILEGE_NOT_HELD))
  { ":ERROR_PRIVILEGE_NOT_HELD" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PROCESS_ABORTED))
  { ":ERROR_PROCESS_ABORTED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PROC_NOT_FOUND))
  { ":ERROR_PROC_NOT_FOUND" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PRODUCT_UNINSTALLED))
  { ":ERROR_PRODUCT_UNINSTALLED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PRODUCT_VERSION))
  { ":ERROR_PRODUCT_VERSION" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PROFILE_NOT_ASSOCIATED_WITH_DEVICE))
  { ":ERROR_PROFILE_NOT_ASSOCIATED_WITH_DEVICE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PROFILE_NOT_FOUND))
  { ":ERROR_PROFILE_NOT_FOUND" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PROMOTION_ACTIVE))
  { ":ERROR_PROMOTION_ACTIVE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_PROTOCOL_UNREACHABLE))
  { ":ERROR_PROTOCOL_UNREACHABLE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_QUORUMLOG_OPEN_FAILED))
  { ":ERROR_QUORUMLOG_OPEN_FAILED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_QUORUM_DISK_NOT_FOUND))
  { ":ERROR_QUORUM_DISK_NOT_FOUND" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_QUORUM_OWNER_ALIVE))
  { ":ERROR_QUORUM_OWNER_ALIVE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_QUORUM_RESOURCE))
  { ":ERROR_QUORUM_RESOURCE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_QUORUM_RESOURCE_ONLINE_FAILED))
  { ":ERROR_QUORUM_RESOURCE_ONLINE_FAILED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_READ_FAULT))
  { ":ERROR_READ_FAULT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_RECOVERY_FAILURE))
  { ":ERROR_RECOVERY_FAILURE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_REC_NON_EXISTENT))
  { ":ERROR_REC_NON_EXISTENT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_REDIRECTOR_HAS_OPEN_HANDLES))
  { ":ERROR_REDIRECTOR_HAS_OPEN_HANDLES" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_REDIR_PAUSED))
  { ":ERROR_REDIR_PAUSED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_REGISTRY_CORRUPT))
  { ":ERROR_REGISTRY_CORRUPT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_REGISTRY_IO_FAILED))
  { ":ERROR_REGISTRY_IO_FAILED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_REGISTRY_RECOVERED))
  { ":ERROR_REGISTRY_RECOVERED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_REG_NAT_CONSUMPTION))
  { ":ERROR_REG_NAT_CONSUMPTION" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_RELOC_CHAIN_XEEDS_SEGLIM))
  { ":ERROR_RELOC_CHAIN_XEEDS_SEGLIM" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_REMOTE_SESSION_LIMIT_EXCEEDED))
  { ":ERROR_REMOTE_SESSION_LIMIT_EXCEEDED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_REMOTE_STORAGE_MEDIA_ERROR))
  { ":ERROR_REMOTE_STORAGE_MEDIA_ERROR" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_REMOTE_STORAGE_NOT_ACTIVE))
  { ":ERROR_REMOTE_STORAGE_NOT_ACTIVE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_REM_NOT_LIST))
  { ":ERROR_REM_NOT_LIST" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_REPARSE_ATTRIBUTE_CONFLICT))
  { ":ERROR_REPARSE_ATTRIBUTE_CONFLICT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_REPARSE_TAG_INVALID))
  { ":ERROR_REPARSE_TAG_INVALID" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_REPARSE_TAG_MISMATCH))
  { ":ERROR_REPARSE_TAG_MISMATCH" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_REQUEST_ABORTED))
  { ":ERROR_REQUEST_ABORTED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_REQUEST_REFUSED))
  { ":ERROR_REQUEST_REFUSED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_REQUIRES_INTERACTIVE_WINDOWSTATION))
  { ":ERROR_REQUIRES_INTERACTIVE_WINDOWSTATION" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_REQ_NOT_ACCEP))
  { ":ERROR_REQ_NOT_ACCEP" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_RESMON_CREATE_FAILED))
  { ":ERROR_RESMON_CREATE_FAILED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_RESMON_INVALID_STATE))
  { ":ERROR_RESMON_INVALID_STATE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_RESMON_ONLINE_FAILED))
  { ":ERROR_RESMON_ONLINE_FAILED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_RESOURCE_DATA_NOT_FOUND))
  { ":ERROR_RESOURCE_DATA_NOT_FOUND" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_RESOURCE_DISABLED))
  { ":ERROR_RESOURCE_DISABLED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_RESOURCE_FAILED))
  { ":ERROR_RESOURCE_FAILED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_RESOURCE_LANG_NOT_FOUND))
  { ":ERROR_RESOURCE_LANG_NOT_FOUND" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_RESOURCE_NAME_NOT_FOUND))
  { ":ERROR_RESOURCE_NAME_NOT_FOUND" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_RESOURCE_NOT_AVAILABLE))
  { ":ERROR_RESOURCE_NOT_AVAILABLE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_RESOURCE_NOT_FOUND))
  { ":ERROR_RESOURCE_NOT_FOUND" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_RESOURCE_NOT_ONLINE))
  { ":ERROR_RESOURCE_NOT_ONLINE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_RESOURCE_NOT_PRESENT))
  { ":ERROR_RESOURCE_NOT_PRESENT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_RESOURCE_ONLINE))
  { ":ERROR_RESOURCE_ONLINE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_RESOURCE_PROPERTIES_STORED))
  { ":ERROR_RESOURCE_PROPERTIES_STORED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_RESOURCE_PROPERTY_UNCHANGEABLE))
  { ":ERROR_RESOURCE_PROPERTY_UNCHANGEABLE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_RESOURCE_TYPE_NOT_FOUND))
  { ":ERROR_RESOURCE_TYPE_NOT_FOUND" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_RETRY))
  { ":ERROR_RETRY" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_REVISION_MISMATCH))
  { ":ERROR_REVISION_MISMATCH" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_RING2SEG_MUST_BE_MOVABLE))
  { ":ERROR_RING2SEG_MUST_BE_MOVABLE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_RING2_STACK_IN_USE))
  { ":ERROR_RING2_STACK_IN_USE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_RMODE_APP))
  { ":ERROR_RMODE_APP" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_RPL_NOT_ALLOWED))
  { ":ERROR_RPL_NOT_ALLOWED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_RXACT_COMMIT_FAILURE))
  { ":ERROR_RXACT_COMMIT_FAILURE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_RXACT_INVALID_STATE))
  { ":ERROR_RXACT_INVALID_STATE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SAME_DRIVE))
  { ":ERROR_SAME_DRIVE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SAM_INIT_FAILURE))
  { ":ERROR_SAM_INIT_FAILURE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SCOPE_NOT_FOUND))
  { ":ERROR_SCOPE_NOT_FOUND" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SCREEN_ALREADY_LOCKED))
  { ":ERROR_SCREEN_ALREADY_LOCKED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SECRET_TOO_LONG))
  { ":ERROR_SECRET_TOO_LONG" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SECTOR_NOT_FOUND))
  { ":ERROR_SECTOR_NOT_FOUND" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SEEK))
  { ":ERROR_SEEK" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SEEK_ON_DEVICE))
  { ":ERROR_SEEK_ON_DEVICE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SEM_IS_SET))
  { ":ERROR_SEM_IS_SET" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SEM_NOT_FOUND))
  { ":ERROR_SEM_NOT_FOUND" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SEM_OWNER_DIED))
  { ":ERROR_SEM_OWNER_DIED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SEM_TIMEOUT))
  { ":ERROR_SEM_TIMEOUT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SEM_USER_LIMIT))
  { ":ERROR_SEM_USER_LIMIT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SERIAL_NO_DEVICE))
  { ":ERROR_SERIAL_NO_DEVICE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SERVER_DISABLED))
  { ":ERROR_SERVER_DISABLED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SERVER_HAS_OPEN_HANDLES))
  { ":ERROR_SERVER_HAS_OPEN_HANDLES" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SERVER_NOT_DISABLED))
  { ":ERROR_SERVER_NOT_DISABLED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SERVER_SHUTDOWN_IN_PROGRESS))
  { ":ERROR_SERVER_SHUTDOWN_IN_PROGRESS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SERVICE_ALREADY_RUNNING))
  { ":ERROR_SERVICE_ALREADY_RUNNING" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SERVICE_CANNOT_ACCEPT_CTRL))
  { ":ERROR_SERVICE_CANNOT_ACCEPT_CTRL" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SERVICE_DATABASE_LOCKED))
  { ":ERROR_SERVICE_DATABASE_LOCKED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SERVICE_DEPENDENCY_DELETED))
  { ":ERROR_SERVICE_DEPENDENCY_DELETED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SERVICE_DEPENDENCY_FAIL))
  { ":ERROR_SERVICE_DEPENDENCY_FAIL" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SERVICE_DISABLED))
  { ":ERROR_SERVICE_DISABLED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SERVICE_DOES_NOT_EXIST))
  { ":ERROR_SERVICE_DOES_NOT_EXIST" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SERVICE_EXISTS))
  { ":ERROR_SERVICE_EXISTS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SERVICE_LOGON_FAILED))
  { ":ERROR_SERVICE_LOGON_FAILED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SERVICE_MARKED_FOR_DELETE))
  { ":ERROR_SERVICE_MARKED_FOR_DELETE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SERVICE_NEVER_STARTED))
  { ":ERROR_SERVICE_NEVER_STARTED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SERVICE_NOT_ACTIVE))
  { ":ERROR_SERVICE_NOT_ACTIVE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SERVICE_NOT_FOUND))
  { ":ERROR_SERVICE_NOT_FOUND" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SERVICE_NOT_IN_EXE))
  { ":ERROR_SERVICE_NOT_IN_EXE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SERVICE_NO_THREAD))
  { ":ERROR_SERVICE_NO_THREAD" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SERVICE_REQUEST_TIMEOUT))
  { ":ERROR_SERVICE_REQUEST_TIMEOUT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SERVICE_SPECIFIC_ERROR))
  { ":ERROR_SERVICE_SPECIFIC_ERROR" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SERVICE_START_HANG))
  { ":ERROR_SERVICE_START_HANG" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SESSION_CREDENTIAL_CONFLICT))
  { ":ERROR_SESSION_CREDENTIAL_CONFLICT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SETCOUNT_ON_BAD_LB))
  { ":ERROR_SETCOUNT_ON_BAD_LB" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SETMARK_DETECTED))
  { ":ERROR_SETMARK_DETECTED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SET_NOT_FOUND))
  { ":ERROR_SET_NOT_FOUND" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SET_POWER_STATE_FAILED))
  { ":ERROR_SET_POWER_STATE_FAILED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SET_POWER_STATE_VETOED))
  { ":ERROR_SET_POWER_STATE_VETOED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SHARED_POLICY))
  { ":ERROR_SHARED_POLICY" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SHARING_BUFFER_EXCEEDED))
  { ":ERROR_SHARING_BUFFER_EXCEEDED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SHARING_PAUSED))
  { ":ERROR_SHARING_PAUSED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SHARING_VIOLATION))
  { ":ERROR_SHARING_VIOLATION" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SHUTDOWN_CLUSTER))
  { ":ERROR_SHUTDOWN_CLUSTER" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SHUTDOWN_IN_PROGRESS))
  { ":ERROR_SHUTDOWN_IN_PROGRESS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SIGNAL_PENDING))
  { ":ERROR_SIGNAL_PENDING" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SIGNAL_REFUSED))
  { ":ERROR_SIGNAL_REFUSED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SINGLE_INSTANCE_APP))
  { ":ERROR_SINGLE_INSTANCE_APP" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SMARTCARD_SUBSYSTEM_FAILURE))
  { ":ERROR_SMARTCARD_SUBSYSTEM_FAILURE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SOME_NOT_MAPPED))
  { ":ERROR_SOME_NOT_MAPPED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SOURCE_ELEMENT_EMPTY))
  { ":ERROR_SOURCE_ELEMENT_EMPTY" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SPECIAL_ACCOUNT))
  { ":ERROR_SPECIAL_ACCOUNT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SPECIAL_GROUP))
  { ":ERROR_SPECIAL_GROUP" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SPECIAL_USER))
  { ":ERROR_SPECIAL_USER" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SPL_NO_ADDJOB))
  { ":ERROR_SPL_NO_ADDJOB" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SPL_NO_STARTDOC))
  { ":ERROR_SPL_NO_STARTDOC" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SPOOL_FILE_NOT_FOUND))
  { ":ERROR_SPOOL_FILE_NOT_FOUND" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_STACK_BUFFER_OVERRUN))
  { ":ERROR_STACK_BUFFER_OVERRUN" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_STACK_OVERFLOW))
  { ":ERROR_STACK_OVERFLOW" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_STATIC_INIT))
  { ":ERROR_STATIC_INIT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SUBST_TO_JOIN))
  { ":ERROR_SUBST_TO_JOIN" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SUBST_TO_SUBST))
  { ":ERROR_SUBST_TO_SUBST" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SUCCESS_REBOOT_INITIATED))
  { ":ERROR_SUCCESS_REBOOT_INITIATED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SUCCESS_REBOOT_REQUIRED))
  { ":ERROR_SUCCESS_REBOOT_REQUIRED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SUCCESS_RESTART_REQUIRED))
  { ":ERROR_SUCCESS_RESTART_REQUIRED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SWAPERROR))
  { ":ERROR_SWAPERROR" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_ACTIVATION_CONTEXT_DISABLED))
  { ":ERROR_SXS_ACTIVATION_CONTEXT_DISABLED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_ASSEMBLY_NOT_FOUND))
  { ":ERROR_SXS_ASSEMBLY_NOT_FOUND" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_CANT_GEN_ACTCTX))
  { ":ERROR_SXS_CANT_GEN_ACTCTX" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_DUPLICATE_ASSEMBLY_NAME))
  { ":ERROR_SXS_DUPLICATE_ASSEMBLY_NAME" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_DUPLICATE_CLSID))
  { ":ERROR_SXS_DUPLICATE_CLSID" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_DUPLICATE_DLL_NAME))
  { ":ERROR_SXS_DUPLICATE_DLL_NAME" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_DUPLICATE_IID))
  { ":ERROR_SXS_DUPLICATE_IID" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_DUPLICATE_PROGID))
  { ":ERROR_SXS_DUPLICATE_PROGID" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_DUPLICATE_TLBID))
  { ":ERROR_SXS_DUPLICATE_TLBID" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_DUPLICATE_WINDOWCLASS_NAME))
  { ":ERROR_SXS_DUPLICATE_WINDOWCLASS_NAME" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_FILE_HASH_MISMATCH))
  { ":ERROR_SXS_FILE_HASH_MISMATCH" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_INVALID_ACTCTXDATA_FORMAT))
  { ":ERROR_SXS_INVALID_ACTCTXDATA_FORMAT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_INVALID_ASSEMBLY_IDENTITY_ATTRIBUTE))
  { ":ERROR_SXS_INVALID_ASSEMBLY_IDENTITY_ATTRIBUTE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_INVALID_ASSEMBLY_IDENTITY_ATTRIBUTE_NAME))
  { ":ERROR_SXS_INVALID_ASSEMBLY_IDENTITY_ATTRIBUTE_NAME" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_INVALID_XML_NAMESPACE_URI))
  { ":ERROR_SXS_INVALID_XML_NAMESPACE_URI" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_KEY_NOT_FOUND))
  { ":ERROR_SXS_KEY_NOT_FOUND" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_LEAF_MANIFEST_DEPENDENCY_NOT_INSTALLED))
  { ":ERROR_SXS_LEAF_MANIFEST_DEPENDENCY_NOT_INSTALLED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_MANIFEST_FORMAT_ERROR))
  { ":ERROR_SXS_MANIFEST_FORMAT_ERROR" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_MANIFEST_INVALID_REQUIRED_DEFAULT_NAMESPACE))
  { ":ERROR_SXS_MANIFEST_INVALID_REQUIRED_DEFAULT_NAMESPACE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_MANIFEST_MISSING_REQUIRED_DEFAULT_NAMESPACE))
  { ":ERROR_SXS_MANIFEST_MISSING_REQUIRED_DEFAULT_NAMESPACE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_MANIFEST_PARSE_ERROR))
  { ":ERROR_SXS_MANIFEST_PARSE_ERROR" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_MISSING_ASSEMBLY_IDENTITY_ATTRIBUTE))
  { ":ERROR_SXS_MISSING_ASSEMBLY_IDENTITY_ATTRIBUTE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_POLICY_PARSE_ERROR))
  { ":ERROR_SXS_POLICY_PARSE_ERROR" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_PRIVATE_MANIFEST_CROSS_PATH_WITH_REPARSE_POINT))
  { ":ERROR_SXS_PRIVATE_MANIFEST_CROSS_PATH_WITH_REPARSE_POINT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_PROCESS_DEFAULT_ALREADY_SET))
  { ":ERROR_SXS_PROCESS_DEFAULT_ALREADY_SET" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_PROTECTION_CATALOG_FILE_MISSING))
  { ":ERROR_SXS_PROTECTION_CATALOG_FILE_MISSING" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_PROTECTION_CATALOG_NOT_VALID))
  { ":ERROR_SXS_PROTECTION_CATALOG_NOT_VALID" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_PROTECTION_PUBLIC_KEY_TOO_SHORT))
  { ":ERROR_SXS_PROTECTION_PUBLIC_KEY_TOO_SHORT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_PROTECTION_RECOVERY_FAILED))
  { ":ERROR_SXS_PROTECTION_RECOVERY_FAILED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_ROOT_MANIFEST_DEPENDENCY_NOT_INSTALLED))
  { ":ERROR_SXS_ROOT_MANIFEST_DEPENDENCY_NOT_INSTALLED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_SECTION_NOT_FOUND))
  { ":ERROR_SXS_SECTION_NOT_FOUND" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_THREAD_QUERIES_DISABLED))
  { ":ERROR_SXS_THREAD_QUERIES_DISABLED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_UNKNOWN_ENCODING))
  { ":ERROR_SXS_UNKNOWN_ENCODING" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_UNKNOWN_ENCODING_GROUP))
  { ":ERROR_SXS_UNKNOWN_ENCODING_GROUP" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_UNTRANSLATABLE_HRESULT))
  { ":ERROR_SXS_UNTRANSLATABLE_HRESULT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_VERSION_CONFLICT))
  { ":ERROR_SXS_VERSION_CONFLICT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_WRONG_SECTION_TYPE))
  { ":ERROR_SXS_WRONG_SECTION_TYPE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_BADCHARDATA))
  { ":ERROR_SXS_XML_E_BADCHARDATA" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_BADCHARINSTRING))
  { ":ERROR_SXS_XML_E_BADCHARINSTRING" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_BADNAMECHAR))
  { ":ERROR_SXS_XML_E_BADNAMECHAR" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_BADPEREFINSUBSET))
  { ":ERROR_SXS_XML_E_BADPEREFINSUBSET" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_BADSTARTNAMECHAR))
  { ":ERROR_SXS_XML_E_BADSTARTNAMECHAR" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_BADXMLCASE))
  { ":ERROR_SXS_XML_E_BADXMLCASE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_BADXMLDECL))
  { ":ERROR_SXS_XML_E_BADXMLDECL" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_COMMENTSYNTAX))
  { ":ERROR_SXS_XML_E_COMMENTSYNTAX" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_DUPLICATEATTRIBUTE))
  { ":ERROR_SXS_XML_E_DUPLICATEATTRIBUTE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_EXPECTINGCLOSEQUOTE))
  { ":ERROR_SXS_XML_E_EXPECTINGCLOSEQUOTE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_EXPECTINGTAGEND))
  { ":ERROR_SXS_XML_E_EXPECTINGTAGEND" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_INCOMPLETE_ENCODING))
  { ":ERROR_SXS_XML_E_INCOMPLETE_ENCODING" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_INTERNALERROR))
  { ":ERROR_SXS_XML_E_INTERNALERROR" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_INVALIDATROOTLEVEL))
  { ":ERROR_SXS_XML_E_INVALIDATROOTLEVEL" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_INVALIDENCODING))
  { ":ERROR_SXS_XML_E_INVALIDENCODING" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_INVALIDSWITCH))
  { ":ERROR_SXS_XML_E_INVALIDSWITCH" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_INVALID_DECIMAL))
  { ":ERROR_SXS_XML_E_INVALID_DECIMAL" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_INVALID_HEXIDECIMAL))
  { ":ERROR_SXS_XML_E_INVALID_HEXIDECIMAL" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_INVALID_STANDALONE))
  { ":ERROR_SXS_XML_E_INVALID_STANDALONE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_INVALID_UNICODE))
  { ":ERROR_SXS_XML_E_INVALID_UNICODE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_INVALID_VERSION))
  { ":ERROR_SXS_XML_E_INVALID_VERSION" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_MISSINGEQUALS))
  { ":ERROR_SXS_XML_E_MISSINGEQUALS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_MISSINGQUOTE))
  { ":ERROR_SXS_XML_E_MISSINGQUOTE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_MISSINGROOT))
  { ":ERROR_SXS_XML_E_MISSINGROOT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_MISSINGSEMICOLON))
  { ":ERROR_SXS_XML_E_MISSINGSEMICOLON" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_MISSINGWHITESPACE))
  { ":ERROR_SXS_XML_E_MISSINGWHITESPACE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_MISSING_PAREN))
  { ":ERROR_SXS_XML_E_MISSING_PAREN" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_MULTIPLEROOTS))
  { ":ERROR_SXS_XML_E_MULTIPLEROOTS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_MULTIPLE_COLONS))
  { ":ERROR_SXS_XML_E_MULTIPLE_COLONS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_RESERVEDNAMESPACE))
  { ":ERROR_SXS_XML_E_RESERVEDNAMESPACE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_UNBALANCEDPAREN))
  { ":ERROR_SXS_XML_E_UNBALANCEDPAREN" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_UNCLOSEDCDATA))
  { ":ERROR_SXS_XML_E_UNCLOSEDCDATA" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_UNCLOSEDCOMMENT))
  { ":ERROR_SXS_XML_E_UNCLOSEDCOMMENT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_UNCLOSEDDECL))
  { ":ERROR_SXS_XML_E_UNCLOSEDDECL" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_UNCLOSEDENDTAG))
  { ":ERROR_SXS_XML_E_UNCLOSEDENDTAG" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_UNCLOSEDSTARTTAG))
  { ":ERROR_SXS_XML_E_UNCLOSEDSTARTTAG" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_UNCLOSEDSTRING))
  { ":ERROR_SXS_XML_E_UNCLOSEDSTRING" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_UNCLOSEDTAG))
  { ":ERROR_SXS_XML_E_UNCLOSEDTAG" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_UNEXPECTEDENDTAG))
  { ":ERROR_SXS_XML_E_UNEXPECTEDENDTAG" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_UNEXPECTEDEOF))
  { ":ERROR_SXS_XML_E_UNEXPECTEDEOF" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_UNEXPECTED_STANDALONE))
  { ":ERROR_SXS_XML_E_UNEXPECTED_STANDALONE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_UNEXPECTED_WHITESPACE))
  { ":ERROR_SXS_XML_E_UNEXPECTED_WHITESPACE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_WHITESPACEORQUESTIONMARK))
  { ":ERROR_SXS_XML_E_WHITESPACEORQUESTIONMARK" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SXS_XML_E_XMLDECLSYNTAX))
  { ":ERROR_SXS_XML_E_XMLDECLSYNTAX" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SYNC_FOREGROUND_REFRESH_REQUIRED))
  { ":ERROR_SYNC_FOREGROUND_REFRESH_REQUIRED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_SYSTEM_TRACE))
  { ":ERROR_SYSTEM_TRACE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_TAG_NOT_FOUND))
  { ":ERROR_TAG_NOT_FOUND" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_TAG_NOT_PRESENT))
  { ":ERROR_TAG_NOT_PRESENT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_THREAD_1_INACTIVE))
  { ":ERROR_THREAD_1_INACTIVE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_TIMEOUT))
  { ":ERROR_TIMEOUT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_TIME_SKEW))
  { ":ERROR_TIME_SKEW" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_TLW_WITH_WSCHILD))
  { ":ERROR_TLW_WITH_WSCHILD" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_TOKEN_ALREADY_IN_USE))
  { ":ERROR_TOKEN_ALREADY_IN_USE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_TOO_MANY_CMDS))
  { ":ERROR_TOO_MANY_CMDS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_TOO_MANY_CONTEXT_IDS))
  { ":ERROR_TOO_MANY_CONTEXT_IDS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_TOO_MANY_LINKS))
  { ":ERROR_TOO_MANY_LINKS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_TOO_MANY_LUIDS_REQUESTED))
  { ":ERROR_TOO_MANY_LUIDS_REQUESTED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_TOO_MANY_MODULES))
  { ":ERROR_TOO_MANY_MODULES" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_TOO_MANY_MUXWAITERS))
  { ":ERROR_TOO_MANY_MUXWAITERS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_TOO_MANY_NAMES))
  { ":ERROR_TOO_MANY_NAMES" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_TOO_MANY_OPEN_FILES))
  { ":ERROR_TOO_MANY_OPEN_FILES" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_TOO_MANY_POSTS))
  { ":ERROR_TOO_MANY_POSTS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_TOO_MANY_SECRETS))
  { ":ERROR_TOO_MANY_SECRETS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_TOO_MANY_SEMAPHORES))
  { ":ERROR_TOO_MANY_SEMAPHORES" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_TOO_MANY_SEM_REQUESTS))
  { ":ERROR_TOO_MANY_SEM_REQUESTS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_TOO_MANY_SESS))
  { ":ERROR_TOO_MANY_SESS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_TOO_MANY_SIDS))
  { ":ERROR_TOO_MANY_SIDS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_TOO_MANY_TCBS))
  { ":ERROR_TOO_MANY_TCBS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_TRANSFORM_NOT_SUPPORTED))
  { ":ERROR_TRANSFORM_NOT_SUPPORTED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_TRANSPORT_FULL))
  { ":ERROR_TRANSPORT_FULL" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_TRUSTED_DOMAIN_FAILURE))
  { ":ERROR_TRUSTED_DOMAIN_FAILURE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_TRUSTED_RELATIONSHIP_FAILURE))
  { ":ERROR_TRUSTED_RELATIONSHIP_FAILURE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_TRUST_FAILURE))
  { ":ERROR_TRUST_FAILURE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_UNABLE_TO_CLEAN))
  { ":ERROR_UNABLE_TO_CLEAN" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_UNABLE_TO_EJECT_MOUNTED_MEDIA))
  { ":ERROR_UNABLE_TO_EJECT_MOUNTED_MEDIA" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_UNABLE_TO_INVENTORY_DRIVE))
  { ":ERROR_UNABLE_TO_INVENTORY_DRIVE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_UNABLE_TO_INVENTORY_SLOT))
  { ":ERROR_UNABLE_TO_INVENTORY_SLOT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_UNABLE_TO_INVENTORY_TRANSPORT))
  { ":ERROR_UNABLE_TO_INVENTORY_TRANSPORT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_UNABLE_TO_LOAD_MEDIUM))
  { ":ERROR_UNABLE_TO_LOAD_MEDIUM" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_UNABLE_TO_LOCK_MEDIA))
  { ":ERROR_UNABLE_TO_LOCK_MEDIA" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_UNABLE_TO_MOVE_REPLACEMENT))
  { ":ERROR_UNABLE_TO_MOVE_REPLACEMENT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_UNABLE_TO_MOVE_REPLACEMENT_2))
  { ":ERROR_UNABLE_TO_MOVE_REPLACEMENT_2" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_UNABLE_TO_REMOVE_REPLACED))
  { ":ERROR_UNABLE_TO_REMOVE_REPLACED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_UNABLE_TO_UNLOAD_MEDIA))
  { ":ERROR_UNABLE_TO_UNLOAD_MEDIA" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_UNEXPECTED_OMID))
  { ":ERROR_UNEXPECTED_OMID" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_UNEXP_NET_ERR))
  { ":ERROR_UNEXP_NET_ERR" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_UNKNOWN_COMPONENT))
  { ":ERROR_UNKNOWN_COMPONENT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_UNKNOWN_FEATURE))
  { ":ERROR_UNKNOWN_FEATURE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_UNKNOWN_PORT))
  { ":ERROR_UNKNOWN_PORT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_UNKNOWN_PRINTER_DRIVER))
  { ":ERROR_UNKNOWN_PRINTER_DRIVER" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_UNKNOWN_PRINTPROCESSOR))
  { ":ERROR_UNKNOWN_PRINTPROCESSOR" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_UNKNOWN_PRINT_MONITOR))
  { ":ERROR_UNKNOWN_PRINT_MONITOR" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_UNKNOWN_PRODUCT))
  { ":ERROR_UNKNOWN_PRODUCT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_UNKNOWN_PROPERTY))
  { ":ERROR_UNKNOWN_PROPERTY" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_UNKNOWN_REVISION))
  { ":ERROR_UNKNOWN_REVISION" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_UNRECOGNIZED_MEDIA))
  { ":ERROR_UNRECOGNIZED_MEDIA" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_UNRECOGNIZED_VOLUME))
  { ":ERROR_UNRECOGNIZED_VOLUME" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_UNSUPPORTED_TYPE))
  { ":ERROR_UNSUPPORTED_TYPE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_USER_DELETE_TRUST_QUOTA_EXCEEDED))
  { ":ERROR_USER_DELETE_TRUST_QUOTA_EXCEEDED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_USER_EXISTS))
  { ":ERROR_USER_EXISTS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_USER_MAPPED_FILE))
  { ":ERROR_USER_MAPPED_FILE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_VC_DISCONNECTED))
  { ":ERROR_VC_DISCONNECTED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_VOLUME_CONTAINS_SYS_FILES))
  { ":ERROR_VOLUME_CONTAINS_SYS_FILES" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_VOLUME_NOT_SIS_ENABLED))
  { ":ERROR_VOLUME_NOT_SIS_ENABLED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_VOLUME_NOT_SUPPORT_EFS))
  { ":ERROR_VOLUME_NOT_SUPPORT_EFS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_WAIT_NO_CHILDREN))
  { ":ERROR_WAIT_NO_CHILDREN" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_WINDOW_NOT_COMBOBOX))
  { ":ERROR_WINDOW_NOT_COMBOBOX" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_WINDOW_NOT_DIALOG))
  { ":ERROR_WINDOW_NOT_DIALOG" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_WINDOW_OF_OTHER_THREAD))
  { ":ERROR_WINDOW_OF_OTHER_THREAD" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_WINS_INTERNAL))
  { ":ERROR_WINS_INTERNAL" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_WMI_ALREADY_DISABLED))
  { ":ERROR_WMI_ALREADY_DISABLED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_WMI_ALREADY_ENABLED))
  { ":ERROR_WMI_ALREADY_ENABLED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_WMI_DP_FAILED))
  { ":ERROR_WMI_DP_FAILED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_WMI_DP_NOT_FOUND))
  { ":ERROR_WMI_DP_NOT_FOUND" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_WMI_GUID_DISCONNECTED))
  { ":ERROR_WMI_GUID_DISCONNECTED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_WMI_GUID_NOT_FOUND))
  { ":ERROR_WMI_GUID_NOT_FOUND" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_WMI_INSTANCE_NOT_FOUND))
  { ":ERROR_WMI_INSTANCE_NOT_FOUND" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_WMI_INVALID_MOF))
  { ":ERROR_WMI_INVALID_MOF" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_WMI_INVALID_REGINFO))
  { ":ERROR_WMI_INVALID_REGINFO" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_WMI_ITEMID_NOT_FOUND))
  { ":ERROR_WMI_ITEMID_NOT_FOUND" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_WMI_READ_ONLY))
  { ":ERROR_WMI_READ_ONLY" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_WMI_SERVER_UNAVAILABLE))
  { ":ERROR_WMI_SERVER_UNAVAILABLE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_WMI_SET_FAILURE))
  { ":ERROR_WMI_SET_FAILURE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_WMI_TRY_AGAIN))
  { ":ERROR_WMI_TRY_AGAIN" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_WMI_UNRESOLVED_INSTANCE_REF))
  { ":ERROR_WMI_UNRESOLVED_INSTANCE_REF" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_WORKING_SET_QUOTA))
  { ":ERROR_WORKING_SET_QUOTA" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_WRITE_FAULT))
  { ":ERROR_WRITE_FAULT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_WRITE_PROTECT))
  { ":ERROR_WRITE_PROTECT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_WRONG_DISK))
  { ":ERROR_WRONG_DISK" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_WRONG_EFS))
  { ":ERROR_WRONG_EFS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_WRONG_PASSWORD))
  { ":ERROR_WRONG_PASSWORD" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(ERROR_WRONG_TARGET_NAME))
  { ":ERROR_WRONG_TARGET_NAME" },
#endif
#if defined(ESHUTDOWN)
  { ":ESHUTDOWN" },
#endif
#if defined(ESOCKTNOSUPPORT)
  { ":ESOCKTNOSUPPORT" },
#endif
#if defined(ESPIPE)
  { ":ESPIPE" },
#endif
#if defined(ESRCH)
  { ":ESRCH" },
#endif
#if defined(ESRMNT)
  { ":ESRMNT" },
#endif
#if defined(ESTALE)
  { ":ESTALE" },
#endif
#if defined(ESTRPIPE)
  { ":ESTRPIPE" },
#endif
#if defined(ETIME)
  { ":ETIME" },
#endif
#if defined(ETIMEDOUT)
  { ":ETIMEDOUT" },
#endif
#if defined(ETOOMANYREFS)
  { ":ETOOMANYREFS" },
#endif
#if defined(ETXTBSY)
  { ":ETXTBSY" },
#endif
#if defined(EUCLEAN)
  { ":EUCLEAN" },
#endif
#if defined(EUNATCH)
  { ":EUNATCH" },
#endif
#if defined(EUSERS)
  { ":EUSERS" },
#endif
#if defined(EVERSION)
  { ":EVERSION" },
#endif
#if defined(EWOULDBLOCK)
  { ":EWOULDBLOCK" },
#endif
#if (defined(HAVE_FCNTL)) && (defined(O_EXCL))
  { ":EXCL" },
#endif
#if defined(EXDEV)
  { ":EXDEV" },
#endif
#if defined(EXFULL)
  { ":EXFULL" },
#endif
#if defined(HAVE_SYS_RESOURCE_H)
  { ":EXITED" },
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_EXPR_NEST_MAX))
  { ":EXPR-NEST-MAX" },
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  { ":EXT" },
#endif
  { ":EXTERNAL-FORMAT" },
#if (defined(HAVE_NFTW)) && (defined(FTW_F))
  { ":F" },
#endif
#if (defined(HAVE_SYSLOG)) && (defined(HAVE_OPENLOG))
  { ":FACILITY" },
#endif
#if defined(S_IFBLK)
  { ":FBLK" },
#endif
#if defined(S_IFCHR)
  { ":FCHR" },
#endif
#if (defined(HAVE_FCNTL)) && (defined(F_GETFD))
  { ":FD" },
#endif
#if defined(S_IFDIR)
  { ":FDIR" },
#endif
#if defined(HAVE_NFTW)
  { ":FD-LIMIT" },
#endif
#if defined(S_IFIFO)
  { ":FIFO" },
#endif
#if (defined(HAVE_PATHCONF) && defined(HAVE_FPATHCONF)) && (defined(_PC_FILESIZEBITS))
  { ":FILESIZEBITS" },
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  { ":FILETIME" },
#endif
#if (defined(WIN32_NATIVE) || (defined(HAVE_STATVFS) && defined(HAVE_SYS_STATVFS_H))) && (defined(FILE_NAMED_STREAMS))
  { ":FILE_NAMED_STREAMS" },
#endif
#if (defined(WIN32_NATIVE) || (defined(HAVE_STATVFS) && defined(HAVE_SYS_STATVFS_H))) && (defined(FILE_READ_ONLY_VOLUME))
  { ":FILE_READ_ONLY_VOLUME" },
#endif
#if (defined(WIN32_NATIVE) || (defined(HAVE_STATVFS) && defined(HAVE_SYS_STATVFS_H))) && (defined(FILE_SUPPORTS_ENCRYPTION))
  { ":FILE_SUPPORTS_ENCRYPTION" },
#endif
#if (defined(WIN32_NATIVE) || (defined(HAVE_STATVFS) && defined(HAVE_SYS_STATVFS_H))) && (defined(FILE_SUPPORTS_OBJECT_IDS))
  { ":FILE_SUPPORTS_OBJECT_IDS" },
#endif
#if (defined(WIN32_NATIVE) || (defined(HAVE_STATVFS) && defined(HAVE_SYS_STATVFS_H))) && (defined(FILE_SUPPORTS_REPARSE_POINTS))
  { ":FILE_SUPPORTS_REPARSE_POINTS" },
#endif
#if (defined(WIN32_NATIVE) || (defined(HAVE_STATVFS) && defined(HAVE_SYS_STATVFS_H))) && (defined(FILE_SUPPORTS_SPARSE_FILES))
  { ":FILE_SUPPORTS_SPARSE_FILES" },
#endif
#if (defined(WIN32_NATIVE) || (defined(HAVE_STATVFS) && defined(HAVE_SYS_STATVFS_H))) && (defined(FILE_VOLUME_QUOTAS))
  { ":FILE_VOLUME_QUOTAS" },
#endif
#if (defined(HAVE_FCNTL)) && (defined(F_GETFL))
  { ":FL" },
#endif
#if defined(S_IFREG)
  { ":FREG" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(FRS_ERR_AUTHENTICATION))
  { ":FRS_ERR_AUTHENTICATION" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(FRS_ERR_CHILD_TO_PARENT_COMM))
  { ":FRS_ERR_CHILD_TO_PARENT_COMM" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(FRS_ERR_INSUFFICIENT_PRIV))
  { ":FRS_ERR_INSUFFICIENT_PRIV" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(FRS_ERR_INTERNAL))
  { ":FRS_ERR_INTERNAL" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(FRS_ERR_INTERNAL_API))
  { ":FRS_ERR_INTERNAL_API" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(FRS_ERR_INVALID_API_SEQUENCE))
  { ":FRS_ERR_INVALID_API_SEQUENCE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(FRS_ERR_INVALID_SERVICE_PARAMETER))
  { ":FRS_ERR_INVALID_SERVICE_PARAMETER" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(FRS_ERR_PARENT_AUTHENTICATION))
  { ":FRS_ERR_PARENT_AUTHENTICATION" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(FRS_ERR_PARENT_INSUFFICIENT_PRIV))
  { ":FRS_ERR_PARENT_INSUFFICIENT_PRIV" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(FRS_ERR_PARENT_TO_CHILD_COMM))
  { ":FRS_ERR_PARENT_TO_CHILD_COMM" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(FRS_ERR_SERVICE_COMM))
  { ":FRS_ERR_SERVICE_COMM" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(FRS_ERR_STARTING_SERVICE))
  { ":FRS_ERR_STARTING_SERVICE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(FRS_ERR_STOPPING_SERVICE))
  { ":FRS_ERR_STOPPING_SERVICE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(FRS_ERR_SYSVOL_DEMOTE))
  { ":FRS_ERR_SYSVOL_DEMOTE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(FRS_ERR_SYSVOL_IS_BUSY))
  { ":FRS_ERR_SYSVOL_IS_BUSY" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(FRS_ERR_SYSVOL_POPULATE))
  { ":FRS_ERR_SYSVOL_POPULATE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(FRS_ERR_SYSVOL_POPULATE_TIMEOUT))
  { ":FRS_ERR_SYSVOL_POPULATE_TIMEOUT" },
#endif
#if (defined(HAVE_GETRLIMIT) || defined(HAVE_SETRLIMIT)) && (defined(RLIMIT_FSIZE))
  { ":FSIZE" },
#endif
#if defined(S_IFSOCK)
  { ":FSOCK" },
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_FSYNC))
  { ":FSYNC" },
#endif
#if (defined(WIN32_NATIVE) || (defined(HAVE_STATVFS) && defined(HAVE_SYS_STATVFS_H))) && (defined(FS_CASE_IS_PRESERVED))
  { ":FS_CASE_IS_PRESERVED" },
#endif
#if (defined(WIN32_NATIVE) || (defined(HAVE_STATVFS) && defined(HAVE_SYS_STATVFS_H))) && (defined(FS_CASE_SENSITIVE))
  { ":FS_CASE_SENSITIVE" },
#endif
#if (defined(WIN32_NATIVE) || (defined(HAVE_STATVFS) && defined(HAVE_SYS_STATVFS_H))) && (defined(FS_FILE_COMPRESSION))
  { ":FS_FILE_COMPRESSION" },
#endif
#if (defined(WIN32_NATIVE) || (defined(HAVE_STATVFS) && defined(HAVE_SYS_STATVFS_H))) && (defined(FS_FILE_ENCRYPTION))
  { ":FS_FILE_ENCRYPTION" },
#endif
#if (defined(WIN32_NATIVE) || (defined(HAVE_STATVFS) && defined(HAVE_SYS_STATVFS_H))) && (defined(FS_PERSISTENT_ACLS))
  { ":FS_PERSISTENT_ACLS" },
#endif
#if (defined(WIN32_NATIVE) || (defined(HAVE_STATVFS) && defined(HAVE_SYS_STATVFS_H))) && (defined(FS_UNICODE_STORED_ON_DISK))
  { ":FS_UNICODE_STORED_ON_DISK" },
#endif
#if (defined(WIN32_NATIVE) || (defined(HAVE_STATVFS) && defined(HAVE_SYS_STATVFS_H))) && (defined(FS_VOL_IS_COMPRESSED))
  { ":FS_VOL_IS_COMPRESSED" },
#endif
#if (defined(HAVE_SYSLOG)) && (defined(LOG_FTP))
  { ":FTP" },
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_GETGR_R_SIZE_MAX))
  { ":GETGR-R-SIZE-MAX" },
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_GETPW_R_SIZE_MAX))
  { ":GETPW-R-SIZE-MAX" },
#endif
#if defined(HAVE_STAT) && (defined(HAVE_CHMOD) || defined(HAVE_CHOWN) || defined(HAVE_UTIME))
  { ":GID" },
#endif
  { ":HARDLINK" },
  { ":HARDLINK-OR-COPY" },
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(FILE_ATTRIBUTE_HIDDEN))
  { ":HIDDEN" },
#endif
#if ((defined(WIN32_NATIVE)) && (defined(HIGH_PRIORITY_CLASS))) || (!(defined(WIN32_NATIVE)))
  { ":HIGH" },
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_HOST_NAME_MAX))
  { ":HOST-NAME-MAX" },
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  { ":HOT-KEY" },
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  { ":I1" },
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  { ":I2" },
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  { ":I4" },
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  { ":I8" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(PROCESSOR_ARCHITECTURE_IA32_ON_WIN64))
  { ":IA32_ON_WIN64" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(PROCESSOR_ARCHITECTURE_IA64))
  { ":IA64" },
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  { ":ICON" },
#endif
#if ((defined(WIN32_NATIVE)) && (defined(IDLE_PRIORITY_CLASS))) || (!(defined(WIN32_NATIVE)))
  { ":IDLE" },
#endif
  { ":IF-DOES-NOT-EXIST" },
  { ":IF-EXISTS" },
#if (defined(HAVE_SYSLOG)) && (defined(LOG_INFO))
  { ":INFO" },
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  { ":INITID" },
#endif
#if (defined(HAVE_UTMPX_H)) && (defined(INIT_PROCESS))
  { ":INIT-PROCESS" },
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  { ":INT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(PROCESSOR_ARCHITECTURE_INTEL))
  { ":INTEL" },
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_IOV_MAX))
  { ":IOV-MAX" },
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_IPV6))
  { ":IPV6" },
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_JOB_CONTROL))
  { ":JOB-CONTROL" },
#endif
#if (defined(HAVE_SYSLOG)) && (defined(LOG_KERN))
  { ":KERN" },
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  { ":KEYWORDS" },
#endif
#if (defined(HAVE_FCNTL)) && (defined(O_LARGEFILE))
  { ":LARGEFILE" },
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  { ":LASTAUTHOR" },
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  { ":LASTPRINTED" },
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  { ":LASTSAVE-DTM" },
#endif
#if defined(HAVE_FCNTL) || defined(WIN32_NATIVE)
  { ":LENGTH" },
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_LINE_MAX))
  { ":LINE-MAX" },
#endif
#if (defined(HAVE_PATHCONF) && defined(HAVE_FPATHCONF)) && (defined(_PC_LINK_MAX))
  { ":LINK-MAX" },
#endif
#if (defined(HAVE_SYSLOG)) && (defined(LOG_LOCAL0))
  { ":LOCAL0" },
#endif
#if (defined(HAVE_SYSLOG)) && (defined(LOG_LOCAL1))
  { ":LOCAL1" },
#endif
#if (defined(HAVE_SYSLOG)) && (defined(LOG_LOCAL2))
  { ":LOCAL2" },
#endif
#if (defined(HAVE_SYSLOG)) && (defined(LOG_LOCAL3))
  { ":LOCAL3" },
#endif
#if (defined(HAVE_SYSLOG)) && (defined(LOG_LOCAL4))
  { ":LOCAL4" },
#endif
#if (defined(HAVE_SYSLOG)) && (defined(LOG_LOCAL5))
  { ":LOCAL5" },
#endif
#if (defined(HAVE_SYSLOG)) && (defined(LOG_LOCAL6))
  { ":LOCAL6" },
#endif
#if (defined(HAVE_SYSLOG)) && (defined(LOG_LOCAL7))
  { ":LOCAL7" },
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  { ":LOCALE" },
#endif
#if (defined(HAVE_GETRLIMIT) || defined(HAVE_SETRLIMIT)) && (defined(RLIMIT_LOCKS))
  { ":LOCKS" },
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_LOGIN_NAME_MAX))
  { ":LOGIN-NAME-MAX" },
#endif
#if (defined(HAVE_UTMPX_H)) && (defined(LOGIN_PROCESS))
  { ":LOGIN-PROCESS" },
#endif
#if ((defined(WIN32_NATIVE)) && (defined(LOW_PRIORITY_CLASS))) || (!(defined(WIN32_NATIVE)))
  { ":LOW" },
#endif
#if (defined(HAVE_SYSLOG)) && (defined(LOG_LPR))
  { ":LPR" },
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  { ":LPSTR" },
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  { ":LPWSTR" },
#endif
#if (defined(HAVE_SYS_RESOURCE_H)) && (defined(HAVE_GETRUSAGE)) && (defined(RUSAGE_LWP))
  { ":LWP" },
#endif
#if (defined(HAVE_SYSLOG)) && (defined(LOG_MAIL))
  { ":MAIL" },
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_MAPPED_FILES))
  { ":MAPPED-FILES" },
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  { ":MAX" },
#endif
#if (defined(HAVE_PATHCONF) && defined(HAVE_FPATHCONF)) && (defined(_PC_MAX_CANON))
  { ":MAX-CANON" },
#endif
#if (defined(HAVE_PATHCONF) && defined(HAVE_FPATHCONF)) && (defined(_PC_MAX_INPUT))
  { ":MAX-INPUT" },
#endif
#if ((defined(HAVE_SYSCONF)) && (defined(_SC_MEMLOCK))) || ((defined(HAVE_GETRLIMIT) || defined(HAVE_SETRLIMIT)) && (defined(RLIMIT_MEMLOCK)))
  { ":MEMLOCK" },
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_MEMLOCK_RANGE))
  { ":MEMLOCK-RANGE" },
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_MEMORY_PROTECTION))
  { ":MEMORY-PROTECTION" },
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_MESSAGE_PASSING))
  { ":MESSAGE-PASSING" },
#endif
  { ":METHOD" },
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  { ":MIN" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(PROCESSOR_ARCHITECTURE_MIPS))
  { ":MIPS" },
#endif
#if defined(HAVE_STAT) && (defined(HAVE_CHMOD) || defined(HAVE_CHOWN) || defined(HAVE_UTIME))
  { ":MODE" },
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_MONOTONIC_CLOCK))
  { ":MONOTONIC-CLOCK" },
#endif
#if defined(HAVE_NFTW)
  { ":MOUNT" },
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_MQ_OPEN_MAX))
  { ":MQ-OPEN-MAX" },
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_MQ_PRIO_MAX))
  { ":MQ-PRIO-MAX" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(PROCESSOR_ARCHITECTURE_MSIL))
  { ":MSIL" },
#endif
#if defined(HAVE_STAT) && (defined(HAVE_CHMOD) || defined(HAVE_CHOWN) || defined(HAVE_UTIME))
  { ":MTIME" },
#endif
#if (defined(HAVE_PATHCONF) && defined(HAVE_FPATHCONF)) && (defined(_PC_NAME_MAX))
  { ":NAME-MAX" },
#endif
#if (defined(HAVE_SYSLOG)) && (defined(HAVE_OPENLOG))
  { ":NDELAY" },
#endif
#if (defined(HAVE_SYSLOG)) && (defined(LOG_NEWS))
  { ":NEWS" },
#endif
#if (defined(HAVE_UTMPX_H)) && (defined(NEW_TIME))
  { ":NEW-TIME" },
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_NGROUPS_MAX))
  { ":NGROUPS-MAX" },
#endif
#if (defined(HAVE_FCNTL)) && (defined(O_NOCTTY))
  { ":NOCTTY" },
#endif
  { ":NOESCAPE" },
#if (defined(HAVE_GETRLIMIT) || defined(HAVE_SETRLIMIT)) && (defined(RLIMIT_NOFILE))
  { ":NOFILE" },
#endif
#if (defined(HAVE_FCNTL)) && (defined(O_NOFOLLOW))
  { ":NOFOLLOW" },
#endif
#if defined(HAVE_SYS_RESOURCE_H)
  { ":NOHANG" },
#endif
#if (defined(HAVE_FCNTL)) && (defined(O_NOINHERIT))
  { ":NOINHERIT" },
#endif
#if (defined(HAVE_FCNTL)) && (defined(O_NONBLOCK))
  { ":NONBLOCK" },
#endif
#if ((defined(WIN32_NATIVE)) && (defined(NORMAL_PRIORITY_CLASS))) || (!(defined(WIN32_NATIVE))) || ((defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(FILE_ATTRIBUTE_NORMAL)))
  { ":NORMAL" },
#endif
#if (defined(HAVE_SYSLOG)) && (defined(LOG_NOTICE))
  { ":NOTICE" },
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  { ":NOTIMPLEMENTED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(FILE_ATTRIBUTE_NOT_CONTENT_INDEXED))
  { ":NOT-CONTENT-INDEXED" },
#endif
#if ((defined(HAVE_SYSLOG)) && (defined(HAVE_OPENLOG))) || (defined(HAVE_SYS_RESOURCE_H))
  { ":NOWAIT" },
#endif
#if (defined(HAVE_PATHCONF) && defined(HAVE_FPATHCONF)) && (defined(_PC_NO_TRUNC))
  { ":NO-TRUNC" },
#endif
#if (defined(HAVE_GETRLIMIT) || defined(HAVE_SETRLIMIT)) && (defined(RLIMIT_NPROC))
  { ":NPROC" },
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_NPROCESSORS_CONF))
  { ":NPROCESSORS-CONF" },
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_NPROCESSORS_ONLN))
  { ":NPROCESSORS-ONLN" },
#endif
#if (defined(HAVE_NFTW)) && (defined(FTW_NS))
  { ":NS" },
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  { ":NT" },
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  { ":NULL" },
#endif
#if (defined(HAVE_SYSLOG)) && (defined(HAVE_OPENLOG))
  { ":ODELAY" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(FILE_ATTRIBUTE_OFFLINE))
  { ":OFFLINE" },
#endif
#if (defined(HAVE_UTMPX_H)) && (defined(OLD_TIME))
  { ":OLD-TIME" },
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_OPEN_MAX))
  { ":OPEN-MAX" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(OR_INVALID_OID))
  { ":OR_INVALID_OID" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(OR_INVALID_OXID))
  { ":OR_INVALID_OXID" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(OR_INVALID_SET))
  { ":OR_INVALID_SET" },
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  { ":PAGECOUNT" },
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_PAGESIZE))
  { ":PAGESIZE" },
#endif
#if ((defined(HAVE_CONFSTR)) && (defined(_CS_PATH))) || (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN))
  { ":PATH" },
#endif
  { ":PATHNAME" },
#if (defined(HAVE_PATHCONF) && defined(HAVE_FPATHCONF)) && (defined(_PC_PATH_MAX))
  { ":PATH-MAX" },
#endif
  { ":PERIOD" },
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  { ":PERSONAL" },
#endif
#if defined(PRIO_PGRP)
  { ":PGRP" },
#endif
#if defined(HAVE_NFTW)
  { ":PHYS" },
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_PHYS_PAGES))
  { ":PHYS-PAGES" },
#endif
#if ((defined(HAVE_SYSLOG)) && (defined(HAVE_OPENLOG))) || (defined(HAVE_SYS_RESOURCE_H))
  { ":PID" },
#endif
#if (defined(HAVE_PATHCONF) && defined(HAVE_FPATHCONF)) && (defined(_PC_PIPE_BUF))
  { ":PIPE-BUF" },
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_POSIX_V6_ILP32_OFF32_CFLAGS))
  { ":POSIX-V6-ILP32-OFF32-CFLAGS" },
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_POSIX_V6_ILP32_OFF32_LDFLAGS))
  { ":POSIX-V6-ILP32-OFF32-LDFLAGS" },
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_POSIX_V6_ILP32_OFF32_LIBS))
  { ":POSIX-V6-ILP32-OFF32-LIBS" },
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_POSIX_V6_ILP32_OFFBIG_CFLAGS))
  { ":POSIX-V6-ILP32-OFFBIG-CFLAGS" },
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_POSIX_V6_ILP32_OFFBIG_LDFLAGS))
  { ":POSIX-V6-ILP32-OFFBIG-LDFLAGS" },
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_POSIX_V6_ILP32_OFFBIG_LIBS))
  { ":POSIX-V6-ILP32-OFFBIG-LIBS" },
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_POSIX_V6_LP64_OFF64_CFLAGS))
  { ":POSIX-V6-LP64-OFF64-CFLAGS" },
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_POSIX_V6_LP64_OFF64_LDFLAGS))
  { ":POSIX-V6-LP64-OFF64-LDFLAGS" },
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_POSIX_V6_LP64_OFF64_LIBS))
  { ":POSIX-V6-LP64-OFF64-LIBS" },
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_POSIX_V6_LPBIG_OFFBIG_CFLAGS))
  { ":POSIX-V6-LPBIG-OFFBIG-CFLAGS" },
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_POSIX_V6_LPBIG_OFFBIG_LDFLAGS))
  { ":POSIX-V6-LPBIG-OFFBIG-LDFLAGS" },
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_POSIX_V6_LPBIG_OFFBIG_LIBS))
  { ":POSIX-V6-LPBIG-OFFBIG-LIBS" },
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_POSIX_V6_WIDTH_RESTRICTED_ENVS))
  { ":POSIX-V6-WIDTH-RESTRICTED-ENVS" },
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_POSIX_V7_ILP32_OFF32_CFLAGS))
  { ":POSIX-V7-ILP32-OFF32-CFLAGS" },
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_POSIX_V7_ILP32_OFF32_LDFLAGS))
  { ":POSIX-V7-ILP32-OFF32-LDFLAGS" },
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_POSIX_V7_ILP32_OFF32_LIBS))
  { ":POSIX-V7-ILP32-OFF32-LIBS" },
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_POSIX_V7_ILP32_OFFBIG_CFLAGS))
  { ":POSIX-V7-ILP32-OFFBIG-CFLAGS" },
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_POSIX_V7_ILP32_OFFBIG_LDFLAGS))
  { ":POSIX-V7-ILP32-OFFBIG-LDFLAGS" },
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_POSIX_V7_ILP32_OFFBIG_LIBS))
  { ":POSIX-V7-ILP32-OFFBIG-LIBS" },
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_POSIX_V7_LP64_OFF64_CFLAGS))
  { ":POSIX-V7-LP64-OFF64-CFLAGS" },
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_POSIX_V7_LP64_OFF64_LDFLAGS))
  { ":POSIX-V7-LP64-OFF64-LDFLAGS" },
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_POSIX_V7_LP64_OFF64_LIBS))
  { ":POSIX-V7-LP64-OFF64-LIBS" },
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_POSIX_V7_LPBIG_OFFBIG_CFLAGS))
  { ":POSIX-V7-LPBIG-OFFBIG-CFLAGS" },
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_POSIX_V7_LPBIG_OFFBIG_LDFLAGS))
  { ":POSIX-V7-LPBIG-OFFBIG-LDFLAGS" },
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_POSIX_V7_LPBIG_OFFBIG_LIBS))
  { ":POSIX-V7-LPBIG-OFFBIG-LIBS" },
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_POSIX_V7_THREADS_CFLAGS))
  { ":POSIX-V7-THREADS-CFLAGS" },
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_POSIX_V7_THREADS_LDFLAGS))
  { ":POSIX-V7-THREADS-LDFLAGS" },
#endif
#if (defined(HAVE_CONFSTR)) && (defined(_CS_POSIX_V7_WIDTH_RESTRICTED_ENVS))
  { ":POSIX-V7-WIDTH-RESTRICTED-ENVS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(PROCESSOR_ARCHITECTURE_PPC))
  { ":PPC" },
#endif
  { ":PRESERVE" },
#if (defined(HAVE_SYSCONF)) && (defined(_SC_PRIORITIZED_IO))
  { ":PRIORITIZED-IO" },
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_PRIORITY_SCHEDULING))
  { ":PRIORITY-SCHEDULING" },
#endif
#if (defined(HAVE_PATHCONF) && defined(HAVE_FPATHCONF)) && (defined(_PC_PRIO_IO))
  { ":PRIO-IO" },
#endif
#if defined(PRIO_PROCESS)
  { ":PROCESS" },
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  { ":R4" },
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  { ":R8" },
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_RAW_SOCKETS))
  { ":RAW-SOCKETS" },
#endif
#if defined(HAVE_FCNTL)
  { ":RDONLY" },
#endif
#if defined(HAVE_FCNTL)
  { ":RDWR" },
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_READER_WRITER_LOCKS))
  { ":READER-WRITER-LOCKS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(FILE_ATTRIBUTE_READONLY))
  { ":READONLY" },
#endif
#if ((defined(WIN32_NATIVE)) && (defined(REALTIME_PRIORITY_CLASS))) || (!(defined(WIN32_NATIVE)))
  { ":REALTIME" },
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_REALTIME_SIGNALS))
  { ":REALTIME-SIGNALS" },
#endif
#if (defined(HAVE_PATHCONF) && defined(HAVE_FPATHCONF)) && (defined(_PC_REC_INCR_XFER_SIZE))
  { ":REC-INCR-XFER-SIZE" },
#endif
#if (defined(HAVE_PATHCONF) && defined(HAVE_FPATHCONF)) && (defined(_PC_REC_MAX_XFER_SIZE))
  { ":REC-MAX-XFER-SIZE" },
#endif
#if (defined(HAVE_PATHCONF) && defined(HAVE_FPATHCONF)) && (defined(_PC_REC_MIN_XFER_SIZE))
  { ":REC-MIN-XFER-SIZE" },
#endif
#if (defined(HAVE_PATHCONF) && defined(HAVE_FPATHCONF)) && (defined(_PC_REC_XFER_ALIGN))
  { ":REC-XFER-ALIGN" },
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_REGEXP))
  { ":REGEXP" },
#endif
  { ":RENAME" },
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(FILE_ATTRIBUTE_REPARSE_POINT))
  { ":REPARSE-POINT" },
#endif
#if defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)
  { ":REVNUMBER" },
#endif
#if (defined(HAVE_SYSCONF)) && (defined(_SC_RE_DUP_MAX))
  { ":RE-DUP-MAX" },
#endif
#if defined(S_IRGRP)
  { ":RGRP" },
#endif
#if defined(S_IROTH)
  { ":ROTH" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_ADDRESS_ERROR))
  { ":RPC_S_ADDRESS_ERROR" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_ALREADY_LISTENING))
  { ":RPC_S_ALREADY_LISTENING" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_ALREADY_REGISTERED))
  { ":RPC_S_ALREADY_REGISTERED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_BINDING_HAS_NO_AUTH))
  { ":RPC_S_BINDING_HAS_NO_AUTH" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_BINDING_INCOMPLETE))
  { ":RPC_S_BINDING_INCOMPLETE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_CALL_CANCELLED))
  { ":RPC_S_CALL_CANCELLED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_CALL_FAILED))
  { ":RPC_S_CALL_FAILED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_CALL_FAILED_DNE))
  { ":RPC_S_CALL_FAILED_DNE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_CALL_IN_PROGRESS))
  { ":RPC_S_CALL_IN_PROGRESS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_CANNOT_SUPPORT))
  { ":RPC_S_CANNOT_SUPPORT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_CANT_CREATE_ENDPOINT))
  { ":RPC_S_CANT_CREATE_ENDPOINT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_COMM_FAILURE))
  { ":RPC_S_COMM_FAILURE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_DUPLICATE_ENDPOINT))
  { ":RPC_S_DUPLICATE_ENDPOINT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_ENTRY_ALREADY_EXISTS))
  { ":RPC_S_ENTRY_ALREADY_EXISTS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_ENTRY_NOT_FOUND))
  { ":RPC_S_ENTRY_NOT_FOUND" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_ENTRY_TYPE_MISMATCH))
  { ":RPC_S_ENTRY_TYPE_MISMATCH" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_FP_DIV_ZERO))
  { ":RPC_S_FP_DIV_ZERO" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_FP_OVERFLOW))
  { ":RPC_S_FP_OVERFLOW" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_FP_UNDERFLOW))
  { ":RPC_S_FP_UNDERFLOW" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_GROUP_MEMBER_NOT_FOUND))
  { ":RPC_S_GROUP_MEMBER_NOT_FOUND" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_GRP_ELT_NOT_ADDED))
  { ":RPC_S_GRP_ELT_NOT_ADDED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_GRP_ELT_NOT_REMOVED))
  { ":RPC_S_GRP_ELT_NOT_REMOVED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_INCOMPLETE_NAME))
  { ":RPC_S_INCOMPLETE_NAME" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_INTERFACE_NOT_EXPORTED))
  { ":RPC_S_INTERFACE_NOT_EXPORTED" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_INTERFACE_NOT_FOUND))
  { ":RPC_S_INTERFACE_NOT_FOUND" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_INTERNAL_ERROR))
  { ":RPC_S_INTERNAL_ERROR" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_INVALID_ASYNC_CALL))
  { ":RPC_S_INVALID_ASYNC_CALL" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_INVALID_ASYNC_HANDLE))
  { ":RPC_S_INVALID_ASYNC_HANDLE" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_INVALID_AUTH_IDENTITY))
  { ":RPC_S_INVALID_AUTH_IDENTITY" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_INVALID_BINDING))
  { ":RPC_S_INVALID_BINDING" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_INVALID_BOUND))
  { ":RPC_S_INVALID_BOUND" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_INVALID_ENDPOINT_FORMAT))
  { ":RPC_S_INVALID_ENDPOINT_FORMAT" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_INVALID_NAF_ID))
  { ":RPC_S_INVALID_NAF_ID" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_INVALID_NAME_SYNTAX))
  { ":RPC_S_INVALID_NAME_SYNTAX" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_INVALID_NETWORK_OPTIONS))
  { ":RPC_S_INVALID_NETWORK_OPTIONS" },
#endif
#if (defined(WIN32_NATIVE) || defined(UNIX_CYGWIN)) && (defined(RPC_S_I