/* ExportTool.c generated by valac 0.56.17, the Vala compiler
 * generated from ExportTool.vala, do not modify */

/*
Copyright (C) 2012 2014 2015 2019 Johan Mattsson

This library is free software; you can redistribute it and/or modify 
it under the terms of the GNU Lesser General Public License as 
published by the Free Software Foundation; either version 3 of the 
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
Lesser General Public License for more details.
*/

#include "birdfont.h"
#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gee.h>
#include <gio/gio.h>
#include <stdio.h>
#include <glib/gstdio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BIRD_FONT_EXPORT_TOOL_0_PROPERTY,
	BIRD_FONT_EXPORT_TOOL_NUM_PROPERTIES
};
static GParamSpec* bird_font_export_tool_properties[BIRD_FONT_EXPORT_TOOL_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define BIRD_FONT_TYPE_SVG_FONT_FORMAT_WRITER (bird_font_svg_font_format_writer_get_type ())
#define BIRD_FONT_SVG_FONT_FORMAT_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BIRD_FONT_TYPE_SVG_FONT_FORMAT_WRITER, BirdFontSvgFontFormatWriter))
#define BIRD_FONT_SVG_FONT_FORMAT_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BIRD_FONT_TYPE_SVG_FONT_FORMAT_WRITER, BirdFontSvgFontFormatWriterClass))
#define BIRD_FONT_IS_SVG_FONT_FORMAT_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BIRD_FONT_TYPE_SVG_FONT_FORMAT_WRITER))
#define BIRD_FONT_IS_SVG_FONT_FORMAT_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BIRD_FONT_TYPE_SVG_FONT_FORMAT_WRITER))
#define BIRD_FONT_SVG_FONT_FORMAT_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BIRD_FONT_TYPE_SVG_FONT_FORMAT_WRITER, BirdFontSvgFontFormatWriterClass))

typedef struct _BirdFontSvgFontFormatWriter BirdFontSvgFontFormatWriter;
typedef struct _BirdFontSvgFontFormatWriterClass BirdFontSvgFontFormatWriterClass;

#define BIRD_FONT_TYPE_EOT_WRITER (bird_font_eot_writer_get_type ())
#define BIRD_FONT_EOT_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BIRD_FONT_TYPE_EOT_WRITER, BirdFontEotWriter))
#define BIRD_FONT_EOT_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BIRD_FONT_TYPE_EOT_WRITER, BirdFontEotWriterClass))
#define BIRD_FONT_IS_EOT_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BIRD_FONT_TYPE_EOT_WRITER))
#define BIRD_FONT_IS_EOT_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BIRD_FONT_TYPE_EOT_WRITER))
#define BIRD_FONT_EOT_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BIRD_FONT_TYPE_EOT_WRITER, BirdFontEotWriterClass))

typedef struct _BirdFontEotWriter BirdFontEotWriter;
typedef struct _BirdFontEotWriterClass BirdFontEotWriterClass;

static gpointer bird_font_export_tool_parent_class = NULL;
gchar* bird_font_export_tool_error_message = NULL;

VALA_EXTERN gchar* bird_font_bird_font_file_encode (const gchar* s);
static gchar* bird_font_export_tool_get_svg_path_elements (BirdFontGlyph* glyph,
                                                    gboolean only_selected_paths);
static void __lambda125_ (const gchar* selected_file);
static void ___lambda125__bird_font_file_chooser_file_selected (BirdFontFileChooser* _sender,
                                                         const gchar* path,
                                                         gpointer self);
VALA_EXTERN GFile* bird_font_bird_font_get_settings_directory (void);
static void bird_font_export_tool_write_ttf (const gchar* ttf,
                                      const gchar* ttf_mac);
static void bird_font_export_tool_write_eot (const gchar* ttf,
                                      const gchar* eot);
VALA_EXTERN GType bird_font_svg_font_format_writer_get_type (void) G_GNUC_CONST ;
VALA_EXTERN BirdFontSvgFontFormatWriter* bird_font_svg_font_format_writer_new (void);
VALA_EXTERN BirdFontSvgFontFormatWriter* bird_font_svg_font_format_writer_construct (GType object_type);
VALA_EXTERN void bird_font_svg_font_format_writer_open (BirdFontSvgFontFormatWriter* self,
                                            GFile* file,
                                            GError** error);
VALA_EXTERN void bird_font_svg_font_format_writer_write_font_file (BirdFontSvgFontFormatWriter* self,
                                                       BirdFontFont* font,
                                                       GError** error);
VALA_EXTERN void bird_font_svg_font_format_writer_close (BirdFontSvgFontFormatWriter* self,
                                             GError** error);
VALA_EXTERN GType bird_font_eot_writer_get_type (void) G_GNUC_CONST ;
VALA_EXTERN BirdFontEotWriter* bird_font_eot_writer_new (const gchar* ttf_file,
                                             const gchar* eot_file);
VALA_EXTERN BirdFontEotWriter* bird_font_eot_writer_construct (GType object_type,
                                                   const gchar* ttf_file,
                                                   const gchar* eot_file);
VALA_EXTERN void bird_font_eot_writer_write (BirdFontEotWriter* self,
                                 GError** error);
static void bird_font_export_tool_finalize (GObject * obj);
static GType bird_font_export_tool_get_type_once (void);

BirdFontExportTool*
bird_font_export_tool_construct (GType object_type,
                                 const gchar* n)
{
	BirdFontExportTool * self = NULL;
	g_return_val_if_fail (n != NULL, NULL);
	self = (BirdFontExportTool*) g_object_new (object_type, NULL);
	return self;
}

BirdFontExportTool*
bird_font_export_tool_new (const gchar* n)
{
	return bird_font_export_tool_construct (BIRD_FONT_TYPE_EXPORT_TOOL, n);
}

void
bird_font_export_tool_set_output_directory (void)
{
}

gchar*
bird_font_export_tool_export_selected_paths_to_svg (void)
{
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = bird_font_export_tool_export_current_glyph_to_string (TRUE);
	result = _tmp0_;
	return result;
}

gchar*
bird_font_export_tool_export_selected_paths_to_inkscape_clipboard (void)
{
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = bird_font_export_tool_export_current_glyph_to_inkscape_clipboard (TRUE);
	result = _tmp0_;
	return result;
}

gchar*
bird_font_export_tool_export_current_glyph_to_string (gboolean only_selected_paths)
{
	BirdFontGlyph* _tmp0_;
	BirdFontGlyph* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	_tmp0_ = bird_font_main_window_get_current_glyph ();
	_tmp1_ = _tmp0_;
	_tmp2_ = bird_font_export_tool_export_to_string (_tmp1_, only_selected_paths);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	result = _tmp3_;
	return result;
}

static gchar*
double_to_string (gdouble self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = G_ASCII_DTOSTR_BUF_SIZE;
	_tmp2_ = g_ascii_dtostr (_tmp1_, (gint) G_ASCII_DTOSTR_BUF_SIZE, self);
	_tmp3_ = g_strdup (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp1_ = (g_free (_tmp1_), NULL);
	result = _tmp4_;
	return result;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

gchar*
bird_font_export_tool_export_to_string (BirdFontGlyph* glyph,
                                        gboolean only_selected_paths)
{
	gchar* name = NULL;
	GString* s = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GString* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	const gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	const gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* result;
	g_return_val_if_fail (glyph != NULL, NULL);
	_tmp0_ = bird_font_font_display_get_name ((BirdFontFontDisplay*) glyph);
	_tmp1_ = _tmp0_;
	_tmp2_ = bird_font_bird_font_file_encode (_tmp1_);
	_g_free0 (name);
	name = _tmp2_;
	_g_free0 (_tmp1_);
	_tmp3_ = g_string_new ("");
	_g_string_free0 (s);
	s = _tmp3_;
	_tmp4_ = g_strconcat ("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n" \
"<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.0//EN\" \"http://www.w3.org/T" \
"R/2001/REC-SVG-20010904/DTD/svg10.dtd\">\n" \
"<svg version=\"1.0\" \n" \
"\tid=\"glyph_", name, NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat (_tmp5_, "\" \n" \
"\txmlns=\"http://www.w3.org/2000/svg\" \n" \
"\txmlns:xlink=\"http://www.w3.org/1999/xlink\"\n" \
"\tx=\"0px\"\n" \
"\ty=\"0px\"\n" \
"\twidth=", NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strconcat (_tmp7_, "\"", NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = double_to_string (bird_font_glyph_get_width (glyph));
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strconcat (_tmp9_, _tmp11_, NULL);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_strconcat (_tmp13_, "px\" \n\theight=", NULL);
	_tmp15_ = _tmp14_;
	_tmp16_ = g_strconcat (_tmp15_, "\"", NULL);
	_tmp17_ = _tmp16_;
	_tmp18_ = g_strdup_printf ("%i", bird_font_glyph_get_height (glyph));
	_tmp19_ = _tmp18_;
	_tmp20_ = g_strconcat (_tmp17_, _tmp19_, NULL);
	_tmp21_ = _tmp20_;
	_tmp22_ = g_strconcat (_tmp21_, "px\">\n", NULL);
	_tmp23_ = _tmp22_;
	g_string_append (s, _tmp23_);
	_g_free0 (_tmp23_);
	_g_free0 (_tmp21_);
	_g_free0 (_tmp19_);
	_g_free0 (_tmp17_);
	_g_free0 (_tmp15_);
	_g_free0 (_tmp13_);
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	_tmp24_ = string_to_string (name);
	_tmp25_ = g_strconcat ("<g id=\"", _tmp24_, "\">\n", NULL);
	_tmp26_ = _tmp25_;
	g_string_append (s, _tmp26_);
	_g_free0 (_tmp26_);
	_tmp27_ = bird_font_export_tool_get_svg_path_elements (glyph, only_selected_paths);
	_tmp28_ = _tmp27_;
	g_string_append (s, _tmp28_);
	_g_free0 (_tmp28_);
	g_string_append (s, "</g>\n");
	g_string_append (s, "</svg>");
	_tmp29_ = s->str;
	_tmp30_ = g_strdup (_tmp29_);
	result = _tmp30_;
	_g_string_free0 (s);
	_g_free0 (name);
	return result;
}

gchar*
bird_font_export_tool_export_current_glyph_to_inkscape_clipboard (gboolean only_selected_paths)
{
	BirdFontGlyph* _tmp0_;
	BirdFontGlyph* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	_tmp0_ = bird_font_main_window_get_current_glyph ();
	_tmp1_ = _tmp0_;
	_tmp2_ = bird_font_export_tool_export_to_inkscape_clipboard (_tmp1_, only_selected_paths);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	result = _tmp3_;
	return result;
}

gchar*
bird_font_export_tool_export_to_inkscape_clipboard (BirdFontGlyph* glyph,
                                                    gboolean only_selected_paths)
{
	GString* s = NULL;
	GString* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (glyph != NULL, NULL);
	_tmp0_ = g_string_new ("");
	_g_string_free0 (s);
	s = _tmp0_;
	g_string_append (s, "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>");
	g_string_append (s, "\n");
	g_string_append (s, "<svg>\n");
	g_string_append (s, "<inkscape:clipboard\n" \
"\t\t\tid=\"clipboard3009\"\n" \
"\t\t\tstyle=\"color:#000000;fill:#000000;fill-opacity:1;fill-rule:nonz" \
"ero;stroke:none;marker:none;visibility:visible;display:inline;overflow" \
":visible;enable-background:accumulate\"\n" \
"\t\t\tmin=\"0,0\"\n" \
"\t\t\tmax=\"0,0\" />\n" \
"\t ");
	_tmp1_ = bird_font_export_tool_get_svg_path_elements (glyph, only_selected_paths);
	_tmp2_ = _tmp1_;
	g_string_append (s, _tmp2_);
	_g_free0 (_tmp2_);
	g_string_append (s, "</svg>");
	_tmp3_ = s->str;
	_tmp4_ = g_strdup (_tmp3_);
	result = _tmp4_;
	_g_string_free0 (s);
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gchar*
bird_font_export_tool_get_svg_path_elements (BirdFontGlyph* glyph,
                                             gboolean only_selected_paths)
{
	gchar* glyph_svg = NULL;
	GString* s = NULL;
	gchar* name = NULL;
	gint id = 0;
	gchar* _tmp0_;
	GeeArrayList* pl = NULL;
	GString* _tmp1_;
	gchar* _tmp2_;
	GeeArrayList* _tmp3_ = NULL;
	GeeArrayList* _tmp7_;
	const gchar* _tmp80_;
	GString* _tmp93_;
	const gchar* _tmp94_;
	gchar* _tmp95_;
	gchar* result;
	g_return_val_if_fail (glyph != NULL, NULL);
	id = 0;
	_tmp0_ = bird_font_font_display_get_name ((BirdFontFontDisplay*) glyph);
	_g_free0 (name);
	name = _tmp0_;
	_tmp1_ = g_string_new ("");
	_g_string_free0 (s);
	s = _tmp1_;
	_tmp2_ = g_strdup ("");
	_g_free0 (glyph_svg);
	glyph_svg = _tmp2_;
	if (only_selected_paths) {
		GeeArrayList* _tmp4_;
		GeeArrayList* _tmp5_;
		_tmp4_ = glyph->active_paths;
		_tmp5_ = _g_object_ref0 (_tmp4_);
		_g_object_unref0 (_tmp3_);
		_tmp3_ = _tmp5_;
	} else {
		GeeArrayList* _tmp6_;
		_tmp6_ = bird_font_glyph_get_visible_paths (glyph);
		_g_object_unref0 (_tmp3_);
		_tmp3_ = _tmp6_;
	}
	_tmp7_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (pl);
	pl = _tmp7_;
	{
		GeeArrayList* _p_list = NULL;
		GeeArrayList* _tmp8_;
		gint _p_size = 0;
		GeeArrayList* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gint _p_index = 0;
		_tmp8_ = pl;
		_p_list = _tmp8_;
		_tmp9_ = _p_list;
		_tmp10_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp9_);
		_tmp11_ = _tmp10_;
		_p_size = _tmp11_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp12_;
			gint _tmp13_;
			BirdFontPath* p = NULL;
			GeeArrayList* _tmp14_;
			gpointer _tmp15_;
			BirdFontPath* _tmp16_;
			gdouble _tmp17_;
			gdouble _tmp18_;
			_p_index = _p_index + 1;
			_tmp12_ = _p_index;
			_tmp13_ = _p_size;
			if (!(_tmp12_ < _tmp13_)) {
				break;
			}
			_tmp14_ = _p_list;
			_tmp15_ = gee_abstract_list_get ((GeeAbstractList*) _tmp14_, _p_index);
			p = (BirdFontPath*) _tmp15_;
			_tmp16_ = p;
			_tmp17_ = bird_font_path_get_stroke (_tmp16_);
			_tmp18_ = _tmp17_;
			if (_tmp18_ > ((gdouble) 0)) {
				GString* _tmp19_;
				GString* _tmp20_;
				GString* _tmp21_;
				GString* _tmp22_;
				GString* _tmp23_;
				BirdFontPath* _tmp24_;
				gdouble _tmp25_;
				gdouble _tmp26_;
				gchar* _tmp27_;
				gchar* _tmp28_;
				gchar* _tmp29_;
				gchar* _tmp30_;
				BirdFontPath* _tmp31_;
				GString* _tmp35_;
				GString* _tmp36_;
				BirdFontPath* _tmp37_;
				gchar* _tmp38_;
				gchar* _tmp39_;
				const gchar* _tmp40_;
				const gchar* _tmp41_;
				const gchar* _tmp42_;
				gchar* _tmp43_;
				gchar* _tmp44_;
				gchar* _tmp45_;
				gchar* _tmp46_;
				gint _tmp47_;
				_tmp19_ = s;
				g_string_append (_tmp19_, "<path ");
				_tmp20_ = s;
				g_string_append (_tmp20_, "style=\"");
				_tmp21_ = s;
				g_string_append (_tmp21_, "fill:none;");
				_tmp22_ = s;
				g_string_append (_tmp22_, "stroke:#000000;");
				_tmp23_ = s;
				_tmp24_ = p;
				_tmp25_ = bird_font_path_get_stroke (_tmp24_);
				_tmp26_ = _tmp25_;
				_tmp27_ = double_to_string (_tmp26_);
				_tmp28_ = _tmp27_;
				_tmp29_ = g_strconcat ("stroke-width:", _tmp28_, "px;", NULL);
				_tmp30_ = _tmp29_;
				g_string_append (_tmp23_, _tmp30_);
				_g_free0 (_tmp30_);
				_g_free0 (_tmp28_);
				_tmp31_ = p;
				if (_tmp31_->line_cap == BIRD_FONT_LINE_CAP_ROUND) {
					GString* _tmp32_;
					_tmp32_ = s;
					g_string_append (_tmp32_, "stroke-linecap:round;");
				} else {
					BirdFontPath* _tmp33_;
					_tmp33_ = p;
					if (_tmp33_->line_cap == BIRD_FONT_LINE_CAP_SQUARE) {
						GString* _tmp34_;
						_tmp34_ = s;
						g_string_append (_tmp34_, "stroke-linecap:square;");
					}
				}
				_tmp35_ = s;
				g_string_append (_tmp35_, "\" ");
				_tmp36_ = s;
				_tmp37_ = p;
				_tmp38_ = bird_font_svg_to_svg_path (_tmp37_, glyph);
				_tmp39_ = _tmp38_;
				_tmp40_ = string_to_string (_tmp39_);
				_tmp41_ = name;
				_tmp42_ = string_to_string (_tmp41_);
				_tmp43_ = g_strdup_printf ("%i", id);
				_tmp44_ = _tmp43_;
				_tmp45_ = g_strconcat ("d=\"", _tmp40_, "\" id=\"path_", _tmp42_, "_", _tmp44_, "\" />\n", NULL);
				_tmp46_ = _tmp45_;
				g_string_append (_tmp36_, _tmp46_);
				_g_free0 (_tmp46_);
				_g_free0 (_tmp44_);
				_g_free0 (_tmp39_);
				_tmp47_ = id;
				id = _tmp47_ + 1;
			}
			_g_object_unref0 (p);
		}
	}
	if (only_selected_paths) {
		{
			GeeArrayList* _p_list = NULL;
			GeeArrayList* _tmp48_;
			gint _p_size = 0;
			GeeArrayList* _tmp49_;
			gint _tmp50_;
			gint _tmp51_;
			gint _p_index = 0;
			_tmp48_ = glyph->active_paths;
			_p_list = _tmp48_;
			_tmp49_ = _p_list;
			_tmp50_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp49_);
			_tmp51_ = _tmp50_;
			_p_size = _tmp51_;
			_p_index = -1;
			while (TRUE) {
				gint _tmp52_;
				gint _tmp53_;
				BirdFontPath* p = NULL;
				GeeArrayList* _tmp54_;
				gpointer _tmp55_;
				BirdFontPath* _tmp56_;
				gdouble _tmp57_;
				gdouble _tmp58_;
				_p_index = _p_index + 1;
				_tmp52_ = _p_index;
				_tmp53_ = _p_size;
				if (!(_tmp52_ < _tmp53_)) {
					break;
				}
				_tmp54_ = _p_list;
				_tmp55_ = gee_abstract_list_get ((GeeAbstractList*) _tmp54_, _p_index);
				p = (BirdFontPath*) _tmp55_;
				_tmp56_ = p;
				_tmp57_ = bird_font_path_get_stroke (_tmp56_);
				_tmp58_ = _tmp57_;
				if (_tmp58_ == ((gdouble) 0)) {
					const gchar* _tmp59_;
					BirdFontPath* _tmp60_;
					gchar* _tmp61_;
					gchar* _tmp62_;
					gchar* _tmp63_;
					_tmp59_ = glyph_svg;
					_tmp60_ = p;
					_tmp61_ = bird_font_svg_to_svg_path (_tmp60_, glyph);
					_tmp62_ = _tmp61_;
					_tmp63_ = g_strconcat (_tmp59_, _tmp62_, NULL);
					_g_free0 (glyph_svg);
					glyph_svg = _tmp63_;
					_g_free0 (_tmp62_);
				}
				_g_object_unref0 (p);
			}
		}
	} else {
		{
			GeeArrayList* _p_list = NULL;
			GeeArrayList* _tmp64_;
			gint _p_size = 0;
			GeeArrayList* _tmp65_;
			gint _tmp66_;
			gint _tmp67_;
			gint _p_index = 0;
			_tmp64_ = bird_font_glyph_get_visible_paths (glyph);
			_p_list = _tmp64_;
			_tmp65_ = _p_list;
			_tmp66_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp65_);
			_tmp67_ = _tmp66_;
			_p_size = _tmp67_;
			_p_index = -1;
			while (TRUE) {
				gint _tmp68_;
				gint _tmp69_;
				BirdFontPath* p = NULL;
				GeeArrayList* _tmp70_;
				gpointer _tmp71_;
				BirdFontPath* _tmp72_;
				gdouble _tmp73_;
				gdouble _tmp74_;
				_p_index = _p_index + 1;
				_tmp68_ = _p_index;
				_tmp69_ = _p_size;
				if (!(_tmp68_ < _tmp69_)) {
					break;
				}
				_tmp70_ = _p_list;
				_tmp71_ = gee_abstract_list_get ((GeeAbstractList*) _tmp70_, _p_index);
				p = (BirdFontPath*) _tmp71_;
				_tmp72_ = p;
				_tmp73_ = bird_font_path_get_stroke (_tmp72_);
				_tmp74_ = _tmp73_;
				if (_tmp74_ == ((gdouble) 0)) {
					const gchar* _tmp75_;
					BirdFontPath* _tmp76_;
					gchar* _tmp77_;
					gchar* _tmp78_;
					gchar* _tmp79_;
					_tmp75_ = glyph_svg;
					_tmp76_ = p;
					_tmp77_ = bird_font_svg_to_svg_path (_tmp76_, glyph);
					_tmp78_ = _tmp77_;
					_tmp79_ = g_strconcat (_tmp75_, _tmp78_, NULL);
					_g_free0 (glyph_svg);
					glyph_svg = _tmp79_;
					_g_free0 (_tmp78_);
				}
				_g_object_unref0 (p);
			}
			_g_object_unref0 (_p_list);
		}
	}
	_tmp80_ = glyph_svg;
	if (g_strcmp0 (_tmp80_, "") != 0) {
		GString* _tmp81_;
		GString* _tmp82_;
		GString* _tmp83_;
		const gchar* _tmp84_;
		const gchar* _tmp85_;
		const gchar* _tmp86_;
		const gchar* _tmp87_;
		gchar* _tmp88_;
		gchar* _tmp89_;
		gchar* _tmp90_;
		gchar* _tmp91_;
		gint _tmp92_;
		_tmp81_ = s;
		g_string_append (_tmp81_, "<path ");
		_tmp82_ = s;
		g_string_append (_tmp82_, "style=\"fill:#000000;stroke-width:0px\" ");
		_tmp83_ = s;
		_tmp84_ = glyph_svg;
		_tmp85_ = string_to_string (_tmp84_);
		_tmp86_ = name;
		_tmp87_ = string_to_string (_tmp86_);
		_tmp88_ = g_strdup_printf ("%i", id);
		_tmp89_ = _tmp88_;
		_tmp90_ = g_strconcat ("d=\"", _tmp85_, "\" id=\"path_", _tmp87_, "_", _tmp89_, "\" />\n", NULL);
		_tmp91_ = _tmp90_;
		g_string_append (_tmp83_, _tmp91_);
		_g_free0 (_tmp91_);
		_g_free0 (_tmp89_);
		_tmp92_ = id;
		id = _tmp92_ + 1;
	}
	_tmp93_ = s;
	_tmp94_ = _tmp93_->str;
	_tmp95_ = g_strdup (_tmp94_);
	result = _tmp95_;
	_g_object_unref0 (_tmp3_);
	_g_object_unref0 (pl);
	_g_free0 (name);
	_g_string_free0 (s);
	_g_free0 (glyph_svg);
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
__lambda125_ (const gchar* selected_file)
{
	BirdFontGlyph* glyph = NULL;
	BirdFontGlyph* _tmp0_;
	BirdFontFontDisplay* fd = NULL;
	BirdFontFontDisplay* _tmp1_;
	gchar* glyph_svg = NULL;
	gchar* svg_file = NULL;
	GFile* file = NULL;
	GDataOutputStream* os = NULL;
	gchar* name = NULL;
	gchar* fn = NULL;
	gint i = 0;
	gboolean _tmp2_ = FALSE;
	BirdFontFontDisplay* _tmp3_;
	BirdFontGlyph* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	GError* _inner_error0_ = NULL;
	_tmp0_ = bird_font_main_window_get_current_glyph ();
	glyph = _tmp0_;
	_tmp1_ = bird_font_main_window_get_current_display ();
	fd = _tmp1_;
	_tmp3_ = fd;
	if (BIRD_FONT_IS_GLYPH_TAB (_tmp3_)) {
		_tmp2_ = TRUE;
	} else {
		BirdFontFontDisplay* _tmp4_;
		_tmp4_ = fd;
		_tmp2_ = BIRD_FONT_IS_GLYPH (_tmp4_);
	}
	if (_tmp2_) {
		BirdFontGlyph* _tmp5_;
		_tmp5_ = bird_font_main_window_get_current_glyph ();
		_g_object_unref0 (glyph);
		glyph = _tmp5_;
	} else {
		BirdFontFontDisplay* _tmp6_;
		_tmp6_ = fd;
		if (BIRD_FONT_IS_OVERVIEW (_tmp6_)) {
			BirdFontOverview* overview = NULL;
			BirdFontOverview* _tmp7_;
			BirdFontGlyph* g = NULL;
			BirdFontOverview* _tmp8_;
			BirdFontGlyph* _tmp9_;
			BirdFontGlyph* _tmp10_;
			BirdFontGlyph* _tmp11_;
			BirdFontGlyph* _tmp12_;
			_tmp7_ = bird_font_main_window_get_overview ();
			overview = _tmp7_;
			_tmp8_ = overview;
			_tmp9_ = bird_font_overview_get_selected_glyph (_tmp8_);
			g = _tmp9_;
			_tmp10_ = g;
			if (_tmp10_ == NULL) {
				g_warning ("ExportTool.vala:193: No glyph selected in overview.");
				_g_object_unref0 (g);
				_g_object_unref0 (overview);
				_g_free0 (fn);
				_g_free0 (name);
				_g_object_unref0 (os);
				_g_object_unref0 (file);
				_g_free0 (svg_file);
				_g_free0 (glyph_svg);
				_g_object_unref0 (fd);
				_g_object_unref0 (glyph);
				return;
			}
			_tmp11_ = g;
			_tmp12_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, BIRD_FONT_TYPE_GLYPH, BirdFontGlyph));
			_g_object_unref0 (glyph);
			glyph = _tmp12_;
			_g_object_unref0 (g);
			_g_object_unref0 (overview);
		} else {
			_g_free0 (fn);
			_g_free0 (name);
			_g_object_unref0 (os);
			_g_object_unref0 (file);
			_g_free0 (svg_file);
			_g_free0 (glyph_svg);
			_g_object_unref0 (fd);
			_g_object_unref0 (glyph);
			return;
		}
	}
	_tmp13_ = glyph;
	_tmp14_ = bird_font_font_display_get_name ((BirdFontFontDisplay*) _tmp13_);
	_g_free0 (name);
	name = _tmp14_;
	if (selected_file == NULL) {
		g_warning ("ExportTool.vala:205: No selected file.");
		_g_free0 (fn);
		_g_free0 (name);
		_g_object_unref0 (os);
		_g_object_unref0 (file);
		_g_free0 (svg_file);
		_g_free0 (glyph_svg);
		_g_object_unref0 (fd);
		_g_object_unref0 (glyph);
		return;
	}
	_tmp15_ = g_strdup ((const gchar*) selected_file);
	_g_free0 (svg_file);
	svg_file = _tmp15_;
	{
		const gchar* _tmp16_;
		gchar* _tmp17_;
		const gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		GFile* _tmp21_;
		BirdFontGlyph* _tmp32_;
		gchar* _tmp33_;
		GFileOutputStream* _tmp34_ = NULL;
		GFile* _tmp35_;
		GFileOutputStream* _tmp36_;
		GDataOutputStream* _tmp37_;
		GDataOutputStream* _tmp38_;
		const gchar* _tmp39_;
		i = 1;
		_tmp16_ = svg_file;
		_tmp17_ = string_replace (_tmp16_, ".svg", "");
		_g_free0 (fn);
		fn = _tmp17_;
		_tmp18_ = fn;
		_tmp19_ = g_strconcat (_tmp18_, ".svg", NULL);
		_tmp20_ = _tmp19_;
		_tmp21_ = g_file_new_for_path (_tmp20_);
		_g_object_unref0 (file);
		file = _tmp21_;
		_g_free0 (_tmp20_);
		while (TRUE) {
			GFile* _tmp22_;
			const gchar* _tmp23_;
			gchar* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			gchar* _tmp27_;
			gchar* _tmp28_;
			gchar* _tmp29_;
			GFile* _tmp30_;
			gint _tmp31_;
			_tmp22_ = file;
			if (!g_file_query_exists (_tmp22_, NULL)) {
				break;
			}
			_tmp23_ = fn;
			_tmp24_ = g_strdup_printf ("%i", i);
			_tmp25_ = _tmp24_;
			_tmp26_ = g_strconcat (_tmp25_, ".svg", NULL);
			_tmp27_ = _tmp26_;
			_tmp28_ = g_strconcat (_tmp23_, _tmp27_, NULL);
			_tmp29_ = _tmp28_;
			_tmp30_ = g_file_new_for_path (_tmp29_);
			_g_object_unref0 (file);
			file = _tmp30_;
			_g_free0 (_tmp29_);
			_g_free0 (_tmp27_);
			_g_free0 (_tmp25_);
			_tmp31_ = i;
			i = _tmp31_ + 1;
		}
		_tmp32_ = glyph;
		_tmp33_ = bird_font_export_tool_export_to_string (_tmp32_, FALSE);
		_g_free0 (glyph_svg);
		glyph_svg = _tmp33_;
		_tmp35_ = file;
		_tmp36_ = g_file_create (_tmp35_, G_FILE_CREATE_REPLACE_DESTINATION, NULL, &_inner_error0_);
		_tmp34_ = _tmp36_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp37_ = g_data_output_stream_new ((GOutputStream*) _tmp34_);
		_g_object_unref0 (os);
		os = _tmp37_;
		_tmp38_ = os;
		_tmp39_ = glyph_svg;
		g_data_output_stream_put_string (_tmp38_, _tmp39_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp34_);
			goto __catch0_g_error;
		}
		_g_object_unref0 (_tmp34_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		FILE* _tmp40_;
		const gchar* _tmp41_;
		const gchar* _tmp42_;
		gchar* _tmp43_;
		gchar* _tmp44_;
		GError* _tmp45_;
		const gchar* _tmp46_;
		const gchar* _tmp47_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp40_ = stderr;
		_tmp41_ = svg_file;
		_tmp42_ = string_to_string (_tmp41_);
		_tmp43_ = g_strconcat ("Export \"", _tmp42_, "\" \n", NULL);
		_tmp44_ = _tmp43_;
		fprintf (_tmp40_, "%s", _tmp44_);
		_g_free0 (_tmp44_);
		_tmp45_ = e;
		_tmp46_ = _tmp45_->message;
		_tmp47_ = string_to_string (_tmp46_);
		g_critical ("ExportTool.vala:228: %s", _tmp47_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (fn);
		_g_free0 (name);
		_g_object_unref0 (os);
		_g_object_unref0 (file);
		_g_free0 (svg_file);
		_g_free0 (glyph_svg);
		_g_object_unref0 (fd);
		_g_object_unref0 (glyph);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (fn);
	_g_free0 (name);
	_g_object_unref0 (os);
	_g_object_unref0 (file);
	_g_free0 (svg_file);
	_g_free0 (glyph_svg);
	_g_object_unref0 (fd);
	_g_object_unref0 (glyph);
}

static void
___lambda125__bird_font_file_chooser_file_selected (BirdFontFileChooser* _sender,
                                                    const gchar* path,
                                                    gpointer self)
{
	__lambda125_ (path);
}

void
bird_font_export_tool_export_current_glyph (void)
{
	BirdFontFileChooser* fc = NULL;
	BirdFontFileChooser* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	_tmp0_ = bird_font_file_chooser_new ();
	fc = _tmp0_;
	g_signal_connect (fc, "file-selected", (GCallback) ___lambda125__bird_font_file_chooser_file_selected, NULL);
	bird_font_file_chooser_add_extension (fc, "svg");
	_tmp1_ = bird_font_t_ ("Save");
	_tmp2_ = _tmp1_;
	bird_font_main_window_file_chooser (_tmp2_, fc, BIRD_FONT_FILE_CHOOSER_SAVE);
	_g_free0 (_tmp2_);
	_g_object_unref0 (fc);
}

void
bird_font_export_tool_generate_html_template (void)
{
	GFile* config_dir = NULL;
	GFile* _tmp0_;
	GFile* file = NULL;
	GFile* _tmp1_;
	GFile* _tmp2_;
	gchar* name = NULL;
	gchar* _tmp3_;
	GDataOutputStream* os = NULL;
	GFile* _tmp4_;
	GError* _inner_error0_ = NULL;
	_tmp0_ = bird_font_bird_font_get_settings_directory ();
	config_dir = _tmp0_;
	_tmp1_ = config_dir;
	_tmp2_ = bird_font_get_child (_tmp1_, "preview.html");
	file = _tmp2_;
	_tmp3_ = g_strdup ("_NAME_");
	name = _tmp3_;
	_tmp4_ = file;
	if (g_file_query_exists (_tmp4_, NULL)) {
		bird_font_printd ("Preview template exists.\n");
		_g_object_unref0 (os);
		_g_free0 (name);
		_g_object_unref0 (file);
		_g_object_unref0 (config_dir);
		return;
	}
	{
		GFileOutputStream* _tmp5_ = NULL;
		GFile* _tmp6_;
		GFileOutputStream* _tmp7_;
		GDataOutputStream* _tmp8_;
		GDataOutputStream* _tmp9_;
		GDataOutputStream* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		GDataOutputStream* _tmp13_;
		GDataOutputStream* _tmp14_;
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		const gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		GDataOutputStream* _tmp21_;
		GDataOutputStream* _tmp22_;
		GDataOutputStream* _tmp23_;
		const gchar* _tmp24_;
		const gchar* _tmp25_;
		GDataOutputStream* _tmp26_;
		GDataOutputStream* _tmp27_;
		const gchar* _tmp28_;
		const gchar* _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		GDataOutputStream* _tmp32_;
		GDataOutputStream* _tmp33_;
		GDataOutputStream* _tmp34_;
		const gchar* _tmp35_;
		const gchar* _tmp36_;
		GDataOutputStream* _tmp37_;
		GDataOutputStream* _tmp38_;
		const gchar* _tmp39_;
		const gchar* _tmp40_;
		gchar* _tmp41_;
		gchar* _tmp42_;
		GDataOutputStream* _tmp43_;
		GDataOutputStream* _tmp44_;
		GDataOutputStream* _tmp45_;
		const gchar* _tmp46_;
		const gchar* _tmp47_;
		GDataOutputStream* _tmp48_;
		GDataOutputStream* _tmp49_;
		const gchar* _tmp50_;
		const gchar* _tmp51_;
		gchar* _tmp52_;
		gchar* _tmp53_;
		GDataOutputStream* _tmp54_;
		GDataOutputStream* _tmp55_;
		GDataOutputStream* _tmp56_;
		GDataOutputStream* _tmp57_;
		const gchar* _tmp58_;
		const gchar* _tmp59_;
		GDataOutputStream* _tmp60_;
		GDataOutputStream* _tmp61_;
		GDataOutputStream* _tmp62_;
		const gchar* _tmp63_;
		const gchar* _tmp64_;
		GDataOutputStream* _tmp65_;
		GDataOutputStream* _tmp66_;
		GDataOutputStream* _tmp67_;
		const gchar* _tmp68_;
		const gchar* _tmp69_;
		GDataOutputStream* _tmp70_;
		GDataOutputStream* _tmp71_;
		GDataOutputStream* _tmp72_;
		const gchar* _tmp73_;
		const gchar* _tmp74_;
		GDataOutputStream* _tmp75_;
		GDataOutputStream* _tmp76_;
		GDataOutputStream* _tmp77_;
		GDataOutputStream* _tmp78_;
		const gchar* _tmp79_;
		gchar* _tmp80_;
		gchar* _tmp81_;
		gchar* _tmp82_;
		gchar* _tmp83_;
		gchar* _tmp84_;
		gchar* _tmp85_;
		gchar* _tmp86_;
		gchar* _tmp87_;
		gchar* _tmp88_;
		gchar* _tmp89_;
		gchar* _tmp90_;
		gchar* _tmp91_;
		gchar* _tmp92_;
		gchar* _tmp93_;
		gchar* _tmp94_;
		gchar* _tmp95_;
		gchar* _tmp96_;
		gchar* _tmp97_;
		gchar* _tmp98_;
		gchar* _tmp99_;
		gchar* _tmp100_;
		gchar* _tmp101_;
		_tmp6_ = file;
		_tmp7_ = g_file_create (_tmp6_, G_FILE_CREATE_REPLACE_DESTINATION, NULL, &_inner_error0_);
		_tmp5_ = _tmp7_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp8_ = g_data_output_stream_new ((GOutputStream*) _tmp5_);
		_g_object_unref0 (os);
		os = _tmp8_;
		_tmp9_ = os;
		g_data_output_stream_put_string (_tmp9_, "<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01//EN\" \"http://www.w3.or" \
"g/TR/html4/strict.dtd\">\n" \
"<html>\n" \
"<head>\n" \
"\n" \
"\t<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8" \
"\">\n" \
"\t<title>Lorem ipsum</title>\n" \
"\t\n" \
"\t<style type=\"text/css\">\n" \
"\n" \
"\t\tbody {\n" \
"\t\t\ttext-rendering: optimizeLegibility;\n" \
"\t\t\tfont-feature-settings: \"kern\";\n" \
"\t\t\tmargin: 0 0 0 0;\n" \
"\t\t}\n" \
"\n" \
"\t\t@font-face {\n" \
"\t\t\tfont-family: '", NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp5_);
			goto __catch0_g_error;
		}
		_tmp10_ = os;
		_tmp11_ = name;
		_tmp12_ = string_to_string (_tmp11_);
		g_data_output_stream_put_string (_tmp10_, _tmp12_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp5_);
			goto __catch0_g_error;
		}
		_tmp13_ = os;
		g_data_output_stream_put_string (_tmp13_, "SVG';\n\t\t\tsrc: url('", NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp5_);
			goto __catch0_g_error;
		}
		_tmp14_ = os;
		_tmp15_ = name;
		_tmp16_ = string_to_string (_tmp15_);
		_tmp17_ = name;
		_tmp18_ = string_to_string (_tmp17_);
		_tmp19_ = g_strconcat (_tmp16_, ".svg#", _tmp18_, NULL);
		_tmp20_ = _tmp19_;
		g_data_output_stream_put_string (_tmp14_, _tmp20_, NULL, &_inner_error0_);
		_g_free0 (_tmp20_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp5_);
			goto __catch0_g_error;
		}
		_tmp21_ = os;
		g_data_output_stream_put_string (_tmp21_, "') format('svg');\n\t\t}\n\t", NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp5_);
			goto __catch0_g_error;
		}
		_tmp22_ = os;
		g_data_output_stream_put_string (_tmp22_, "\n\t\t@font-face {\n\t\t\tfont-family: '", NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp5_);
			goto __catch0_g_error;
		}
		_tmp23_ = os;
		_tmp24_ = name;
		_tmp25_ = string_to_string (_tmp24_);
		g_data_output_stream_put_string (_tmp23_, _tmp25_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp5_);
			goto __catch0_g_error;
		}
		_tmp26_ = os;
		g_data_output_stream_put_string (_tmp26_, "OTF';\n\t\t\tsrc: url('", NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp5_);
			goto __catch0_g_error;
		}
		_tmp27_ = os;
		_tmp28_ = name;
		_tmp29_ = string_to_string (_tmp28_);
		_tmp30_ = g_strconcat (_tmp29_, ".otf", NULL);
		_tmp31_ = _tmp30_;
		g_data_output_stream_put_string (_tmp27_, _tmp31_, NULL, &_inner_error0_);
		_g_free0 (_tmp31_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp5_);
			goto __catch0_g_error;
		}
		_tmp32_ = os;
		g_data_output_stream_put_string (_tmp32_, "') format('opentype');\n\t\t} \n\t\t", NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp5_);
			goto __catch0_g_error;
		}
		_tmp33_ = os;
		g_data_output_stream_put_string (_tmp33_, "\n\t\t@font-face {\n\t\t\tfont-family: '", NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp5_);
			goto __catch0_g_error;
		}
		_tmp34_ = os;
		_tmp35_ = name;
		_tmp36_ = string_to_string (_tmp35_);
		g_data_output_stream_put_string (_tmp34_, _tmp36_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp5_);
			goto __catch0_g_error;
		}
		_tmp37_ = os;
		g_data_output_stream_put_string (_tmp37_, "TTF';\n\t\t\tsrc: url('", NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp5_);
			goto __catch0_g_error;
		}
		_tmp38_ = os;
		_tmp39_ = name;
		_tmp40_ = string_to_string (_tmp39_);
		_tmp41_ = g_strconcat (_tmp40_, ".ttf", NULL);
		_tmp42_ = _tmp41_;
		g_data_output_stream_put_string (_tmp38_, _tmp42_, NULL, &_inner_error0_);
		_g_free0 (_tmp42_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp5_);
			goto __catch0_g_error;
		}
		_tmp43_ = os;
		g_data_output_stream_put_string (_tmp43_, "') format('truetype');\n\t\t} \n\t\t", NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp5_);
			goto __catch0_g_error;
		}
		_tmp44_ = os;
		g_data_output_stream_put_string (_tmp44_, "\n\t\t@font-face {\n\t\t\tfont-family: '", NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp5_);
			goto __catch0_g_error;
		}
		_tmp45_ = os;
		_tmp46_ = name;
		_tmp47_ = string_to_string (_tmp46_);
		g_data_output_stream_put_string (_tmp45_, _tmp47_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp5_);
			goto __catch0_g_error;
		}
		_tmp48_ = os;
		g_data_output_stream_put_string (_tmp48_, "EOT';\n\t\t\tsrc: url('", NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp5_);
			goto __catch0_g_error;
		}
		_tmp49_ = os;
		_tmp50_ = name;
		_tmp51_ = string_to_string (_tmp50_);
		_tmp52_ = g_strconcat (_tmp51_, ".eot", NULL);
		_tmp53_ = _tmp52_;
		g_data_output_stream_put_string (_tmp49_, _tmp53_, NULL, &_inner_error0_);
		_g_free0 (_tmp53_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp5_);
			goto __catch0_g_error;
		}
		_tmp54_ = os;
		g_data_output_stream_put_string (_tmp54_, "');\n\t\t} \n\t\t\n\t\t", NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp5_);
			goto __catch0_g_error;
		}
		_tmp55_ = os;
		g_data_output_stream_put_string (_tmp55_, "\n" \
"\t\n" \
"\t\tsection {\n" \
"\t\t\tpadding-left: 25px;\n" \
"\t\t}\n" \
"\t\t\n" \
"\t\th1 {\n" \
"\t\t\tfont-weight:normal;\n" \
"\t\t\tmargin: 10px 0 5px 0;\n" \
"\t\t\tcolor: #afafaf;\n" \
"\t\t}\n" \
"\n" \
"\t\th2 {\n" \
"\t\t\tfont-weight:normal;\n" \
"\t\t\tmargin: 0 0 5px 0;\n" \
"\t\t\tcolor: #afafaf;\n" \
"\t\t}\n" \
"\t\t\n" \
"\t\th3 {\n" \
"\t\t\tfont-weight:normal;\n" \
"\t\t\tmargin: 0 0 5px 0;\n" \
"\t\t\tcolor: #afafaf;\n" \
"\t\t}\n" \
"\t\t\n" \
"\t\th4 {\n" \
"\t\t\tfont-weight:normal;\n" \
"\t\t\tmargin: 0 0 5px 0;\n" \
"\t\t\tcolor: #afafaf;\n" \
"\t\t}\n" \
"\t\t\n" \
"\t\tp {\n" \
"\t\t\tmargin: 0 0 5px 0;\n" \
"\t\t\tcolor: #000000;\n" \
"\t\t}\n" \
"\n" \
"\t\tdiv {\n" \
"\t\t\tfont-family: ", NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp5_);
			goto __catch0_g_error;
		}
		_tmp56_ = os;
		g_data_output_stream_put_string (_tmp56_, "'", NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp5_);
			goto __catch0_g_error;
		}
		_tmp57_ = os;
		_tmp58_ = name;
		_tmp59_ = string_to_string (_tmp58_);
		g_data_output_stream_put_string (_tmp57_, _tmp59_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp5_);
			goto __catch0_g_error;
		}
		_tmp60_ = os;
		g_data_output_stream_put_string (_tmp60_, "EOT'", NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp5_);
			goto __catch0_g_error;
		}
		_tmp61_ = os;
		g_data_output_stream_put_string (_tmp61_, ", '", NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp5_);
			goto __catch0_g_error;
		}
		_tmp62_ = os;
		_tmp63_ = name;
		_tmp64_ = string_to_string (_tmp63_);
		g_data_output_stream_put_string (_tmp62_, _tmp64_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp5_);
			goto __catch0_g_error;
		}
		_tmp65_ = os;
		g_data_output_stream_put_string (_tmp65_, "OTF'", NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp5_);
			goto __catch0_g_error;
		}
		_tmp66_ = os;
		g_data_output_stream_put_string (_tmp66_, ", '", NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp5_);
			goto __catch0_g_error;
		}
		_tmp67_ = os;
		_tmp68_ = name;
		_tmp69_ = string_to_string (_tmp68_);
		g_data_output_stream_put_string (_tmp67_, _tmp69_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp5_);
			goto __catch0_g_error;
		}
		_tmp70_ = os;
		g_data_output_stream_put_string (_tmp70_, "TTF'", NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp5_);
			goto __catch0_g_error;
		}
		_tmp71_ = os;
		g_data_output_stream_put_string (_tmp71_, ", '", NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp5_);
			goto __catch0_g_error;
		}
		_tmp72_ = os;
		_tmp73_ = name;
		_tmp74_ = string_to_string (_tmp73_);
		g_data_output_stream_put_string (_tmp72_, _tmp74_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp5_);
			goto __catch0_g_error;
		}
		_tmp75_ = os;
		g_data_output_stream_put_string (_tmp75_, "SVG'", NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp5_);
			goto __catch0_g_error;
		}
		_tmp76_ = os;
		g_data_output_stream_put_string (_tmp76_, ";", NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp5_);
			goto __catch0_g_error;
		}
		_tmp77_ = os;
		g_data_output_stream_put_string (_tmp77_, "\n" \
"\t\t\tmargin: 0 0 30px 0;\n" \
"\t\t}\n" \
"\n" \
"\t\th1.bigger {\n" \
"\t\t\tfont-size: 58pt;\n" \
"\t\t}\n" \
"\n" \
"\t\th2.big {\n" \
"\t\t\tfont-size: 40pt;\n" \
"\t\t}\n" \
"\t\t\n" \
"\t\th3.small {\n" \
"\t\t\tfont-size: 32pt;\n" \
"\t\t}\n" \
"\n" \
"\t\th4.smaller {\n" \
"\t\t\tfont-size: 18pt;\n" \
"\t\t}\n" \
"\n" \
"\t\th1.percent {\n" \
"\t\t\tfont-size: 100%;\n" \
"\t\t}\t\t\n" \
"\t\t\n" \
"\t\tp.bigger {\n" \
"\t\t\tfont-size: 32pt;\n" \
"\t\t}\n" \
"\n" \
"\t\tp.big {\n" \
"\t\t\tfont-size: 24pt;\n" \
"\t\t}\n" \
"\t\t\n" \
"\t\tp.small {\n" \
"\t\t\tfont-size: 18pt;\n" \
"\t\t}\n" \
"\n" \
"\t\tp.smaller {\n" \
"\t\t\tfont-size: 12pt;\n" \
"\t\t}\n" \
"\n" \
"\t\tspan.swashes {\n" \
"\t\t\tfont-feature-settings: \"swsh\";\t\n" \
"\t\t}\n" \
"\t\t\n" \
"\t\tspan.alternates {\t\n" \
"\t\t\tfont-feature-settings: \"salt\" 1;\n" \
"\t\t}\n" \
"\t\t\n" \
"\t\tspan.smallcaps {\n" \
"\t\t\tfont-variant-caps: small-caps;\n" \
"\t\t\tfont-feature-settings: \"smcp\";\n" \
"\t\t}\n" \
"\n" \
"\t\tspan.capstosmallcaps {\n" \
"\t\t\tfont-variant-caps: all-small-caps;\n" \
"\t\t\tfont-feature-settings: \"c2sc\", \"smcp\";\n" \
"\t\t}\n" \
"\t</style>\n", NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp5_);
			goto __catch0_g_error;
		}
		_tmp78_ = os;
		_tmp79_ = name;
		_tmp80_ = g_strconcat ("\t\n" \
"</head>\n" \
"<body>\n" \
"<section>\n" \
"\t<div>\n" \
"\t\t<h1 class=\"bigger\">Lorem ipsum</h1>\n" \
"\t\t<p class=\"bigger\">Dolor sit amet!</p>\n" \
"\t</div>\n" \
"\n" \
"\t<div>\n" \
"\t\t<h2 class=\"big\">Hamburgefonstiv</h2>\n" \
"\t\t<p class=\"big\">", _tmp79_, NULL);
		_tmp81_ = _tmp80_;
		_tmp82_ = g_strconcat (_tmp81_, "</p>\n" \
"\t</div>\n" \
"\n" \
"\t<div>\n" \
"\t\t<h4 class=\"smaller\">Headline 16pt</h4>\n" \
"\t\t<p class=\"smaller\">The quick brown fox jumps over the lazy dog</" \
"p>\t\n" \
"\t</div>\n" \
"\n" \
"\t<div>\n" \
"\t\t<h4 class=\"smaller\">", NULL);
		_tmp83_ = _tmp82_;
		_tmp84_ = bird_font_t_ ("Alphabet");
		_tmp85_ = _tmp84_;
		_tmp86_ = g_strconcat (_tmp83_, _tmp85_, NULL);
		_tmp87_ = _tmp86_;
		_tmp88_ = g_strconcat (_tmp87_, "</h4>\n\t\t<p class=\"smaller\">", NULL);
		_tmp89_ = _tmp88_;
		_tmp90_ = bird_font_t_ ("a b c d e f g h i j k l m n o p q r s t u v w x y z");
		_tmp91_ = _tmp90_;
		_tmp92_ = g_strconcat (_tmp89_, _tmp91_, NULL);
		_tmp93_ = _tmp92_;
		_tmp94_ = g_strconcat (_tmp93_, "</p>\n\t\t<p class=\"smaller\">", NULL);
		_tmp95_ = _tmp94_;
		_tmp96_ = bird_font_t_ ("A B C D E F G H I J K L M N O P Q R S T U V W X Y Z");
		_tmp97_ = _tmp96_;
		_tmp98_ = g_strconcat (_tmp95_, _tmp97_, NULL);
		_tmp99_ = _tmp98_;
		_tmp100_ = g_strconcat (_tmp99_, "</p>\n" \
"\t\t<p class=\"smaller\">0 1 2 3 4 5 6 7 8 9</p>\n" \
"\t</div>\n" \
"</section>\n" \
"</body>\n" \
"</html>\n", NULL);
		_tmp101_ = _tmp100_;
		g_data_output_stream_put_string (_tmp78_, _tmp101_, NULL, &_inner_error0_);
		_g_free0 (_tmp101_);
		_g_free0 (_tmp99_);
		_g_free0 (_tmp97_);
		_g_free0 (_tmp95_);
		_g_free0 (_tmp93_);
		_g_free0 (_tmp91_);
		_g_free0 (_tmp89_);
		_g_free0 (_tmp87_);
		_g_free0 (_tmp85_);
		_g_free0 (_tmp83_);
		_g_free0 (_tmp81_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp5_);
			goto __catch0_g_error;
		}
		_g_object_unref0 (_tmp5_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp102_;
		const gchar* _tmp103_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp102_ = e;
		_tmp103_ = _tmp102_->message;
		g_warning ("ExportTool.vala:441: %s", _tmp103_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (os);
		_g_free0 (name);
		_g_object_unref0 (file);
		_g_object_unref0 (config_dir);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (os);
	_g_free0 (name);
	_g_object_unref0 (file);
	_g_object_unref0 (config_dir);
}

void
bird_font_export_tool_generate_html_document (const gchar* html_file,
                                              BirdFontFont* font)
{
	GFile* config_dir = NULL;
	GFile* _tmp0_;
	GFile* template = NULL;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp7_;
	gchar* html_data = NULL;
	gchar* name = NULL;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (html_file != NULL);
	g_return_if_fail (font != NULL);
	_tmp0_ = bird_font_bird_font_get_settings_directory ();
	config_dir = _tmp0_;
	_tmp1_ = config_dir;
	_tmp2_ = bird_font_get_child (_tmp1_, "preview.html");
	template = _tmp2_;
	_tmp3_ = template;
	if (!g_file_query_exists (_tmp3_, NULL)) {
		GFile* _tmp4_;
		GFile* _tmp5_;
		GFile* _tmp6_;
		bird_font_export_tool_generate_html_template ();
		_tmp4_ = config_dir;
		_tmp5_ = bird_font_get_child (_tmp4_, "preview.html");
		_tmp6_ = _tmp5_;
		_g_object_unref0 (_tmp6_);
	} else {
		g_print ("HTML template exits.");
	}
	_tmp7_ = template;
	if (!g_file_query_exists (_tmp7_, NULL)) {
		g_warning ("ExportTool.vala:457: Preview template does not exists.");
		_g_object_unref0 (template);
		_g_object_unref0 (config_dir);
		return;
	}
	{
		GFile* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_ = NULL;
		_tmp8_ = template;
		_tmp9_ = g_file_get_path (_tmp8_);
		_tmp10_ = (gchar*) _tmp9_;
		g_file_get_contents (_tmp10_, &_tmp11_, NULL, &_inner_error0_);
		_g_free0 (html_data);
		html_data = _tmp11_;
		_g_free0 (_tmp10_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			_g_free0 (html_data);
			_g_object_unref0 (template);
			_g_object_unref0 (config_dir);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		GError* e = NULL;
		GError* _tmp12_;
		const gchar* _tmp13_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp12_ = e;
		_tmp13_ = _tmp12_->message;
		g_warning ("ExportTool.vala:465: %s", _tmp13_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (html_data);
		_g_object_unref0 (template);
		_g_object_unref0 (config_dir);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp14_ = bird_font_export_settings_get_file_name (font);
	_g_free0 (name);
	name = _tmp14_;
	_tmp15_ = html_data;
	_tmp16_ = name;
	_tmp17_ = string_replace (_tmp15_, "_NAME_", _tmp16_);
	_g_free0 (html_data);
	html_data = _tmp17_;
	{
		const gchar* _tmp18_;
		const gchar* _tmp19_;
		_tmp18_ = html_data;
		g_print ("%s", _tmp18_);
		_tmp19_ = html_data;
		g_file_set_contents (html_file, _tmp19_, (gssize) -1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch1_g_file_error;
			}
			_g_free0 (name);
			_g_free0 (html_data);
			_g_object_unref0 (template);
			_g_object_unref0 (config_dir);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally1;
	__catch1_g_file_error:
	{
		GError* e = NULL;
		GError* _tmp20_;
		const gchar* _tmp21_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp20_ = e;
		_tmp21_ = _tmp20_->message;
		g_warning ("ExportTool.vala:481: %s", _tmp21_);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (name);
		_g_free0 (html_data);
		_g_object_unref0 (template);
		_g_object_unref0 (config_dir);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (name);
	_g_free0 (html_data);
	_g_object_unref0 (template);
	_g_object_unref0 (config_dir);
}

gchar*
bird_font_export_tool_get_export_folder (void)
{
	BirdFontFont* font = NULL;
	BirdFontFont* _tmp0_;
	gchar* d = NULL;
	BirdFontFont* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* result;
	_tmp0_ = bird_font_bird_font_get_current_font ();
	font = _tmp0_;
	_tmp1_ = font;
	_tmp2_ = bird_font_font_get_export_directory (_tmp1_);
	d = _tmp2_;
	_tmp3_ = d;
	if (_tmp3_ == NULL) {
		gchar* _tmp4_;
		g_warning ("ExportTool.vala:491: No export path is not set");
		_tmp4_ = g_strdup ("");
		result = _tmp4_;
		_g_free0 (d);
		_g_object_unref0 (font);
		return result;
	}
	_tmp5_ = d;
	_tmp6_ = g_strdup ((const gchar*) _tmp5_);
	result = _tmp6_;
	_g_free0 (d);
	_g_object_unref0 (font);
	return result;
}

GFile*
bird_font_export_tool_get_export_dir (void)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* result;
	_tmp0_ = bird_font_export_tool_get_export_folder ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_file_new_for_path (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}

gboolean
bird_font_export_tool_export_ttf_font (void)
{
	GFile* f = NULL;
	GFile* _tmp0_;
	BirdFontFont* font = NULL;
	BirdFontFont* _tmp1_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	BirdFontFont* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	BirdFontFont* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	GFile* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	const gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	GFile* _tmp30_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	_tmp0_ = bird_font_export_tool_get_export_dir ();
	f = _tmp0_;
	_tmp1_ = bird_font_bird_font_get_current_font ();
	font = _tmp1_;
	{
		GFile* _tmp2_;
		_tmp2_ = f;
		if (!g_file_query_exists (_tmp2_, NULL)) {
			GFile* _tmp3_;
			_tmp3_ = f;
			g_file_make_directory (_tmp3_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("ExportTool.vala:511: %s", _tmp5_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp6_ = FALSE;
		_g_object_unref0 (font);
		_g_object_unref0 (f);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp6_;
	}
	bird_font_printd ("export_ttf_font:\n");
	_tmp7_ = bird_font_export_tool_get_export_folder ();
	_tmp8_ = _tmp7_;
	_tmp9_ = string_to_string (_tmp8_);
	_tmp10_ = g_strconcat ("get_export_folder (): ", _tmp9_, "\n", NULL);
	_tmp11_ = _tmp10_;
	bird_font_printd (_tmp11_);
	_g_free0 (_tmp11_);
	_g_free0 (_tmp8_);
	_tmp12_ = font;
	_tmp13_ = bird_font_font_get_path (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = string_to_string (_tmp14_);
	_tmp16_ = g_strconcat ("font.get_path (): ", _tmp15_, "\n", NULL);
	_tmp17_ = _tmp16_;
	bird_font_printd (_tmp17_);
	_g_free0 (_tmp17_);
	_g_free0 (_tmp14_);
	_tmp18_ = font;
	_tmp19_ = bird_font_font_get_folder_path (_tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = string_to_string (_tmp20_);
	_tmp22_ = g_strconcat ("font.get_folder_path (): ", _tmp21_, "\n", NULL);
	_tmp23_ = _tmp22_;
	bird_font_printd (_tmp23_);
	_g_free0 (_tmp23_);
	_g_free0 (_tmp20_);
	_tmp24_ = f;
	_tmp25_ = g_file_get_path (_tmp24_);
	_tmp26_ = (gchar*) _tmp25_;
	_tmp27_ = string_to_string (_tmp26_);
	_tmp28_ = g_strconcat ("font.get_folder (): ", _tmp27_, "\n", NULL);
	_tmp29_ = _tmp28_;
	bird_font_printd (_tmp29_);
	_g_free0 (_tmp29_);
	_g_free0 (_tmp26_);
	_tmp30_ = f;
	result = bird_font_export_tool_export_ttf_font_path (_tmp30_, TRUE);
	_g_object_unref0 (font);
	_g_object_unref0 (f);
	return result;
}

gboolean
bird_font_export_tool_export_ttf_font_path (GFile* folder,
                                            gboolean use_export_settings)
{
	BirdFontFont* current_font = NULL;
	BirdFontFont* _tmp0_;
	GFile* ttf_file = NULL;
	GFile* ttf_file_mac = NULL;
	GFile* eot_file = NULL;
	gboolean done = FALSE;
	gchar* ttf_name = NULL;
	gchar* ttf_name_mac = NULL;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (folder != NULL, FALSE);
	_tmp0_ = bird_font_bird_font_get_current_font ();
	current_font = _tmp0_;
	done = TRUE;
	{
		BirdFontFont* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		BirdFontFont* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp15_;
		GFile* _tmp16_;
		const gchar* _tmp17_;
		GFile* _tmp18_;
		BirdFontFont* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		GFile* _tmp24_;
		GFile* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		const gchar* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		GFile* _tmp31_;
		GFile* _tmp33_;
		GFile* _tmp35_;
		GFile* _tmp37_;
		gchar* _tmp38_;
		gchar* _tmp39_;
		GFile* _tmp40_;
		gchar* _tmp41_;
		gchar* _tmp42_;
		gboolean _tmp43_ = FALSE;
		gboolean _tmp51_ = FALSE;
		_tmp1_ = current_font;
		_tmp2_ = bird_font_export_settings_get_file_name (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_strconcat (_tmp3_, ".ttf", NULL);
		_g_free0 (ttf_name);
		ttf_name = _tmp4_;
		_g_free0 (_tmp3_);
		_tmp5_ = current_font;
		_tmp6_ = bird_font_export_settings_get_file_name_mac (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strconcat (_tmp7_, ".ttf", NULL);
		_g_free0 (ttf_name_mac);
		ttf_name_mac = _tmp8_;
		_g_free0 (_tmp7_);
		_tmp9_ = ttf_name;
		_tmp10_ = ttf_name_mac;
		if (g_strcmp0 (_tmp9_, _tmp10_) == 0) {
			BirdFontFont* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			g_warning ("ExportTool.vala:537: Same file name for the two ttf files.");
			_tmp11_ = current_font;
			_tmp12_ = bird_font_export_settings_get_file_name_mac (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = g_strconcat (_tmp13_, " Mac.ttf", NULL);
			_g_free0 (ttf_name_mac);
			ttf_name_mac = _tmp14_;
			_g_free0 (_tmp13_);
		}
		_tmp15_ = ttf_name;
		_tmp16_ = bird_font_get_child (folder, _tmp15_);
		_g_object_unref0 (ttf_file);
		ttf_file = _tmp16_;
		_tmp17_ = ttf_name_mac;
		_tmp18_ = bird_font_get_child (folder, _tmp17_);
		_g_object_unref0 (ttf_file_mac);
		ttf_file_mac = _tmp18_;
		_tmp19_ = current_font;
		_tmp20_ = bird_font_export_settings_get_file_name (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = g_strconcat (_tmp21_, ".eot", NULL);
		_tmp23_ = _tmp22_;
		_tmp24_ = bird_font_get_child (folder, _tmp23_);
		_g_object_unref0 (eot_file);
		eot_file = _tmp24_;
		_g_free0 (_tmp23_);
		_g_free0 (_tmp21_);
		_tmp25_ = ttf_file;
		_tmp26_ = g_file_get_path (_tmp25_);
		_tmp27_ = (gchar*) _tmp26_;
		_tmp28_ = string_to_string (_tmp27_);
		_tmp29_ = g_strconcat ("Writing TTF fonts to ", _tmp28_, "\n", NULL);
		_tmp30_ = _tmp29_;
		bird_font_printd (_tmp30_);
		_g_free0 (_tmp30_);
		_g_free0 (_tmp27_);
		_tmp31_ = ttf_file;
		if (g_file_query_exists (_tmp31_, NULL)) {
			GFile* _tmp32_;
			_tmp32_ = ttf_file;
			g_file_delete (_tmp32_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		_tmp33_ = ttf_file_mac;
		if (g_file_query_exists (_tmp33_, NULL)) {
			GFile* _tmp34_;
			_tmp34_ = ttf_file_mac;
			g_file_delete (_tmp34_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		_tmp35_ = eot_file;
		if (g_file_query_exists (_tmp35_, NULL)) {
			GFile* _tmp36_;
			_tmp36_ = eot_file;
			g_file_delete (_tmp36_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		_tmp37_ = ttf_file;
		_tmp38_ = g_file_get_path (_tmp37_);
		_tmp39_ = (gchar*) _tmp38_;
		_tmp40_ = ttf_file_mac;
		_tmp41_ = g_file_get_path (_tmp40_);
		_tmp42_ = (gchar*) _tmp41_;
		bird_font_export_tool_write_ttf (_tmp39_, _tmp42_);
		_g_free0 (_tmp42_);
		_g_free0 (_tmp39_);
		if (!use_export_settings) {
			_tmp43_ = TRUE;
		} else {
			BirdFontFont* _tmp44_;
			_tmp44_ = current_font;
			_tmp43_ = bird_font_export_settings_export_eot_setting (_tmp44_);
		}
		if (_tmp43_) {
			GFile* _tmp45_;
			gchar* _tmp46_;
			gchar* _tmp47_;
			GFile* _tmp48_;
			gchar* _tmp49_;
			gchar* _tmp50_;
			_tmp45_ = ttf_file;
			_tmp46_ = g_file_get_path (_tmp45_);
			_tmp47_ = (gchar*) _tmp46_;
			_tmp48_ = eot_file;
			_tmp49_ = g_file_get_path (_tmp48_);
			_tmp50_ = (gchar*) _tmp49_;
			bird_font_export_tool_write_eot (_tmp47_, _tmp50_);
			_g_free0 (_tmp50_);
			_g_free0 (_tmp47_);
		}
		if (use_export_settings) {
			BirdFontFont* _tmp52_;
			_tmp52_ = current_font;
			_tmp51_ = !bird_font_export_settings_export_ttf_setting (_tmp52_);
		} else {
			_tmp51_ = FALSE;
		}
		if (_tmp51_) {
			GFile* _tmp53_;
			_tmp53_ = ttf_file;
			if (g_file_query_exists (_tmp53_, NULL)) {
				GFile* _tmp54_;
				_tmp54_ = ttf_file;
				g_file_delete (_tmp54_, NULL, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
			}
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp55_;
		const gchar* _tmp56_;
		const gchar* _tmp57_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp55_ = e;
		_tmp56_ = _tmp55_->message;
		_tmp57_ = string_to_string (_tmp56_);
		g_critical ("ExportTool.vala:571: %s", _tmp57_);
		done = FALSE;
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp58_ = FALSE;
		_g_free0 (ttf_name_mac);
		_g_free0 (ttf_name);
		_g_object_unref0 (eot_file);
		_g_object_unref0 (ttf_file_mac);
		_g_object_unref0 (ttf_file);
		_g_object_unref0 (current_font);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp58_;
	}
	result = done;
	_g_free0 (ttf_name_mac);
	_g_free0 (ttf_name);
	_g_object_unref0 (eot_file);
	_g_object_unref0 (ttf_file_mac);
	_g_object_unref0 (ttf_file);
	_g_object_unref0 (current_font);
	return result;
}

gboolean
bird_font_export_tool_export_svg_font (void)
{
	GFile* _tmp0_;
	GFile* _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	_tmp0_ = bird_font_export_tool_get_export_dir ();
	_tmp1_ = _tmp0_;
	_tmp2_ = bird_font_export_tool_export_svg_font_path (_tmp1_);
	_g_object_unref0 (_tmp1_);
	result = _tmp2_;
	return result;
}

gboolean
bird_font_export_tool_export_svg_font_path (GFile* folder)
{
	BirdFontFont* font = NULL;
	BirdFontFont* _tmp0_;
	gchar* file_name = NULL;
	BirdFontFont* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GFile* file = NULL;
	BirdFontSvgFontFormatWriter* fo = NULL;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (folder != NULL, FALSE);
	_tmp0_ = bird_font_bird_font_get_current_font ();
	font = _tmp0_;
	_tmp1_ = font;
	_tmp2_ = bird_font_export_settings_get_file_name (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = string_to_string (_tmp3_);
	_tmp5_ = g_strconcat (_tmp4_, ".svg", NULL);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp3_);
	file_name = _tmp6_;
	{
		const gchar* _tmp7_;
		GFile* _tmp8_;
		GFile* _tmp9_;
		BirdFontSvgFontFormatWriter* _tmp11_;
		BirdFontSvgFontFormatWriter* _tmp12_;
		GFile* _tmp13_;
		BirdFontSvgFontFormatWriter* _tmp14_;
		BirdFontFont* _tmp15_;
		BirdFontSvgFontFormatWriter* _tmp16_;
		_tmp7_ = file_name;
		_tmp8_ = bird_font_get_child (folder, _tmp7_);
		_g_object_unref0 (file);
		file = _tmp8_;
		_tmp9_ = file;
		if (g_file_query_exists (_tmp9_, NULL)) {
			GFile* _tmp10_;
			_tmp10_ = file;
			g_file_delete (_tmp10_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		_tmp11_ = bird_font_svg_font_format_writer_new ();
		_g_object_unref0 (fo);
		fo = _tmp11_;
		_tmp12_ = fo;
		_tmp13_ = file;
		bird_font_svg_font_format_writer_open (_tmp12_, _tmp13_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp14_ = fo;
		_tmp15_ = font;
		bird_font_svg_font_format_writer_write_font_file (_tmp14_, _tmp15_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp16_ = fo;
		bird_font_svg_font_format_writer_close (_tmp16_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp17_;
		const gchar* _tmp18_;
		const gchar* _tmp19_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp17_ = e;
		_tmp18_ = _tmp17_->message;
		_tmp19_ = string_to_string (_tmp18_);
		g_critical ("ExportTool.vala:600: %s", _tmp19_);
		result = FALSE;
		_g_error_free0 (e);
		_g_object_unref0 (fo);
		_g_object_unref0 (file);
		_g_free0 (file_name);
		_g_object_unref0 (font);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp20_ = FALSE;
		_g_object_unref0 (fo);
		_g_object_unref0 (file);
		_g_free0 (file_name);
		_g_object_unref0 (font);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp20_;
	}
	result = TRUE;
	_g_object_unref0 (fo);
	_g_object_unref0 (file);
	_g_free0 (file_name);
	_g_object_unref0 (font);
	return result;
}

static void
bird_font_export_tool_write_ttf (const gchar* ttf,
                                 const gchar* ttf_mac)
{
	BirdFontFont* f = NULL;
	BirdFontFont* _tmp0_;
	BirdFontOpenFontFormatWriter* fo = NULL;
	BirdFontFont* _tmp1_;
	BirdFontOpenFontFormatWriter* _tmp2_;
	GFile* file = NULL;
	GFile* _tmp3_;
	GFile* file_mac = NULL;
	GFile* _tmp4_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (ttf != NULL);
	g_return_if_fail (ttf_mac != NULL);
	_tmp0_ = bird_font_bird_font_get_current_font ();
	f = _tmp0_;
	_tmp1_ = f;
	_tmp2_ = bird_font_open_font_format_writer_new (_tmp1_->units_per_em);
	fo = _tmp2_;
	_tmp3_ = g_file_new_for_path (ttf);
	file = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, g_file_get_type (), GFile);
	_tmp4_ = g_file_new_for_path (ttf_mac);
	file_mac = G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, g_file_get_type (), GFile);
	_g_free0 (bird_font_export_tool_error_message);
	bird_font_export_tool_error_message = NULL;
	{
		BirdFontOpenFontFormatWriter* _tmp5_;
		GFile* _tmp6_;
		GFile* _tmp7_;
		BirdFontOpenFontFormatWriter* _tmp8_;
		BirdFontFont* _tmp9_;
		BirdFontOpenFontFormatWriter* _tmp10_;
		_tmp5_ = fo;
		_tmp6_ = file;
		_tmp7_ = file_mac;
		bird_font_open_font_format_writer_open (_tmp5_, _tmp6_, _tmp7_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp8_ = fo;
		_tmp9_ = f;
		bird_font_open_font_format_writer_write_ttf_font (_tmp8_, _tmp9_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp10_ = fo;
		bird_font_open_font_format_writer_close (_tmp10_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		GError* _tmp14_;
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		GError* _tmp17_;
		const gchar* _tmp18_;
		gchar* _tmp19_;
		BirdFontFont* _tmp20_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp11_ = string_to_string (ttf);
		_tmp12_ = g_strconcat ("Can't create TTF font to ", _tmp11_, NULL);
		_tmp13_ = _tmp12_;
		g_warning ("ExportTool.vala:621: %s", _tmp13_);
		_g_free0 (_tmp13_);
		_tmp14_ = e;
		_tmp15_ = _tmp14_->message;
		_tmp16_ = string_to_string (_tmp15_);
		g_critical ("ExportTool.vala:622: %s", _tmp16_);
		_tmp17_ = e;
		_tmp18_ = _tmp17_->message;
		_tmp19_ = g_strdup (_tmp18_);
		_g_free0 (bird_font_export_tool_error_message);
		bird_font_export_tool_error_message = _tmp19_;
		_tmp20_ = f;
		_g_free0 (_tmp20_->export_directory);
		_tmp20_->export_directory = NULL;
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (file_mac);
		_g_object_unref0 (file);
		_g_object_unref0 (fo);
		_g_object_unref0 (f);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (file_mac);
	_g_object_unref0 (file);
	_g_object_unref0 (fo);
	_g_object_unref0 (f);
}

static void
bird_font_export_tool_write_eot (const gchar* ttf,
                                 const gchar* eot)
{
	BirdFontEotWriter* fo = NULL;
	BirdFontEotWriter* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (ttf != NULL);
	g_return_if_fail (eot != NULL);
	_tmp0_ = bird_font_eot_writer_new (ttf, eot);
	fo = _tmp0_;
	{
		bird_font_eot_writer_write (fo, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GError* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = string_to_string (ttf);
		_tmp2_ = string_to_string (eot);
		_tmp3_ = g_strconcat ("EOF conversion falied, ", _tmp1_, " -> ", _tmp2_, NULL);
		_tmp4_ = _tmp3_;
		g_warning ("ExportTool.vala:634: %s", _tmp4_);
		_g_free0 (_tmp4_);
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		_tmp7_ = string_to_string (_tmp6_);
		g_critical ("ExportTool.vala:635: %s", _tmp7_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (fo);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (fo);
}

static void
bird_font_export_tool_class_init (BirdFontExportToolClass * klass,
                                  gpointer klass_data)
{
	bird_font_export_tool_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = bird_font_export_tool_finalize;
}

static void
bird_font_export_tool_instance_init (BirdFontExportTool * self,
                                     gpointer klass)
{
}

static void
bird_font_export_tool_finalize (GObject * obj)
{
	BirdFontExportTool * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_EXPORT_TOOL, BirdFontExportTool);
	G_OBJECT_CLASS (bird_font_export_tool_parent_class)->finalize (obj);
}

static GType
bird_font_export_tool_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontExportToolClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_export_tool_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontExportTool), 0, (GInstanceInitFunc) bird_font_export_tool_instance_init, NULL };
	GType bird_font_export_tool_type_id;
	bird_font_export_tool_type_id = g_type_register_static (G_TYPE_OBJECT, "BirdFontExportTool", &g_define_type_info, 0);
	return bird_font_export_tool_type_id;
}

GType
bird_font_export_tool_get_type (void)
{
	static volatile gsize bird_font_export_tool_type_id__once = 0;
	if (g_once_init_enter (&bird_font_export_tool_type_id__once)) {
		GType bird_font_export_tool_type_id;
		bird_font_export_tool_type_id = bird_font_export_tool_get_type_once ();
		g_once_init_leave (&bird_font_export_tool_type_id__once, bird_font_export_tool_type_id);
	}
	return bird_font_export_tool_type_id__once;
}

