/* src/bazaar.p/bz-curated-row.c
 *
 * Copyright 2026 AUTOGEN
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include "src/bazaar.p/bz-curated-row.h"



struct _BzCuratedRow
{
  GObject parent_instance;

  GListModel *sections;
};

G_DEFINE_FINAL_TYPE (BzCuratedRow, bz_curated_row, G_TYPE_OBJECT);

enum
{
  PROP_0,

  PROP_SECTIONS,

  LAST_PROP
};
static GParamSpec *props[LAST_PROP] = { 0 };

static void
bz_curated_row_dispose (GObject *object)
{
  BzCuratedRow *self = BZ_CURATED_ROW (object);

  g_clear_pointer (&self->sections, g_object_unref);

  G_OBJECT_CLASS (bz_curated_row_parent_class)->dispose (object);
}

static void
bz_curated_row_get_property (GObject    *object,
                       guint       prop_id,
                       GValue     *value,
                       GParamSpec *pspec)
{
  BzCuratedRow *self = BZ_CURATED_ROW (object);

  switch (prop_id)
    {
    case PROP_SECTIONS:
      g_value_set_object (value, bz_curated_row_get_sections (self));
      break;
    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
    }
}

static void
bz_curated_row_set_property (GObject      *object,
                       guint         prop_id,
                       const GValue *value,
                       GParamSpec   *pspec)
{
  BzCuratedRow *self = BZ_CURATED_ROW (object);

  switch (prop_id)
    {
    case PROP_SECTIONS:
      bz_curated_row_set_sections (self, g_value_get_object (value));
      break;
    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
    }
}

static void
bz_curated_row_class_init (BzCuratedRowClass *klass)
{
  GObjectClass *object_class = G_OBJECT_CLASS (klass);



  object_class->set_property = bz_curated_row_set_property;
  object_class->get_property = bz_curated_row_get_property;
  object_class->dispose      = bz_curated_row_dispose;

  props[PROP_SECTIONS] =
      g_param_spec_object (
          "sections",
          NULL, NULL,
          G_TYPE_LIST_MODEL,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  g_object_class_install_properties (object_class, LAST_PROP, props);
}

static void
bz_curated_row_init (BzCuratedRow *self)
{
}

BzCuratedRow *
bz_curated_row_new (void){
  return g_object_new (BZ_TYPE_CURATED_ROW, NULL);
}

GListModel *
bz_curated_row_get_sections (BzCuratedRow *self){
  g_return_val_if_fail (BZ_IS_CURATED_ROW (self), NULL);
  return self->sections;
}

void
bz_curated_row_set_sections (BzCuratedRow *self,
    GListModel *sections){
  g_return_if_fail (BZ_IS_CURATED_ROW (self));

  if (sections == self->sections)
    return;

  g_clear_pointer (&self->sections, g_object_unref);
  if (sections != NULL)
    self->sections = g_object_ref (sections);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_SECTIONS]);
}

/* End of src/bazaar.p/bz-curated-row.c */
