/*   -*- buffer-read-only: t -*- vi: set ro:
 *
 *  DO NOT EDIT THIS FILE   (xmlopts.h)
 *
 *  It has been AutoGen-ed
 *  From the definitions    ./xmlopts.def
 *  and the template file   options
 *
 * Generated from AutoOpts 42:1:17 templates.
 *
 *  AutoOpts is a copyrighted work.  This header file is not encumbered
 *  by AutoOpts licensing, but is provided under the licensing terms chosen
 *  by the xml2ag author or copyright holder.  AutoOpts is
 *  licensed under the terms of the LGPL.  The redistributable library
 *  (``libopts'') is licensed under the terms of either the LGPL or, at the
 *  users discretion, the BSD license.  See the AutoOpts and/or libopts sources
 *  for details.
 *
 * The xml2ag program is copyrighted and licensed
 * under the following terms:
 *
 *  Copyright (C) 1992-2018 Bruce Korb, all rights reserved.
 *  This is free software. It is licensed for use, modification and
 *  redistribution under the terms of the GNU General Public License,
 *  version 3 or later <http://gnu.org/licenses/gpl.html>
 *
 *  xml2ag is free software: you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by the
 *  Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  xml2ag is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  See the GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/** \file xmlopts.h
 *  \addtogroup xml2ag
 *  @{
 */
/**
 *  This file contains the programmatic interface to the Automated
 *  Options generated for the xml2ag program.
 *  These macros are documented in the AutoGen info file in the
 *  "AutoOpts" chapter.  Please refer to that doc for usage help.
 */
#ifndef AUTOOPTS_XMLOPTS_H_GUARD
#define AUTOOPTS_XMLOPTS_H_GUARD 1
#include <autoopts/options.h>
#include <stdarg.h>
#include <stdnoreturn.h>

/**
 *  Ensure that the library used for compiling this generated header is at
 *  least as new as the version current when the header template was released
 *  (not counting patch version increments).  Also ensure that the oldest
 *  tolerable version is at least as old as what was current when the header
 *  template was released.
 */
#define AO_TEMPLATE_VERSION 172033
#if (AO_TEMPLATE_VERSION < OPTIONS_MINIMUM_VERSION) \
 || (AO_TEMPLATE_VERSION > OPTIONS_STRUCT_VERSION)
# error option template version mismatches autoopts/options.h header
  Choke Me.
#endif

#if GCC_VERSION > 40400
#define NOT_REACHED __builtin_unreachable();
#else
#define NOT_REACHED
#endif

/**
 *  Enumeration of each option type for xml2ag
 */
typedef enum {
    INDEX_OPT_OUTPUT             =  1,
    INDEX_OPT_TEMPL_DIRS         =  3,
    INDEX_OPT_OVERRIDE_TPL       =  4,
    INDEX_OPT_DEFINITIONS        =  5,
    INDEX_OPT_SHELL              =  6,
    INDEX_OPT_NO_FMEMOPEN        =  7,
    INDEX_OPT_EQUATE             =  8,
    INDEX_OPT_BASE_NAME          =  9,
    INDEX_OPT_SOURCE_TIME        = 10,
    INDEX_OPT_WRITABLE           = 11,
    INDEX_OPT_LOOP_LIMIT         = 12,
    INDEX_OPT_TIMEOUT            = 13,
    INDEX_OPT_TRACE              = 14,
    INDEX_OPT_TRACE_OUT          = 15,
    INDEX_OPT_SHOW_DEFS          = 16,
    INDEX_OPT_USED_DEFINES       = 17,
    INDEX_OPT_CORE               = 18,
    INDEX_OPT_SKIP_SUFFIX        = 19,
    INDEX_OPT_SELECT_SUFFIX      = 20,
    INDEX_OPT_DEFINE             = 21,
    INDEX_OPT_UNDEFINE           = 22,
    INDEX_OPT_MAKE_DEP           = 23,
    INDEX_OPT_VERSION            = 24,
    INDEX_OPT_HELP               = 25,
    INDEX_OPT_MORE_HELP          = 26
} teOptIndex;
/** count of all options for xml2ag */
#define OPTION_CT    27
/** xml2ag version */
#define XML2AG_VERSION       "5.18.16"
/** Full xml2ag version text */
#define XML2AG_FULL_VERSION  "xml2ag (GNU AutoGen) 5.18.16"

/**
 *  Interface defines for all options.  Replace "n" with the UPPER_CASED
 *  option name (as in the teOptIndex enumeration above).
 *  e.g. HAVE_OPT(THE_XML2AG_OPTION)
 */
#define         DESC(n) (xml2agOptions.pOptDesc[INDEX_OPT_## n])
/** 'true' if an option has been specified in any way */
#define     HAVE_OPT(n) (! UNUSED_OPT(& DESC(n)))
/** The string argument to an option. The argument type must be \"string\". */
#define      OPT_ARG(n) (DESC(n).optArg.argString)
/** Mask the option state revealing how an option was specified.
 *  It will be one and only one of \a OPTST_SET, \a OPTST_PRESET,
 * \a OPTST_DEFINED, \a OPTST_RESET or zero.
 */
#define    STATE_OPT(n) (DESC(n).fOptState & OPTST_SET_MASK)
/** Count of option's occurrances *on the command line*. */
#define    COUNT_OPT(n) (DESC(n).optOccCt)
/** mask of \a OPTST_SET and \a OPTST_DEFINED. */
#define    ISSEL_OPT(n) (SELECTED_OPT(&DESC(n)))
/** 'true' if \a HAVE_OPT would yield 'false'. */
#define ISUNUSED_OPT(n) (UNUSED_OPT(& DESC(n)))
/** 'true' if OPTST_DISABLED bit not set. */
#define  ENABLED_OPT(n) (! DISABLED_OPT(& DESC(n)))
/** number of stacked option arguments.
 *  Valid only for stacked option arguments. */
#define  STACKCT_OPT(n) (((tArgList*)(DESC(n).optCookie))->useCt)
/** stacked argument vector.
 *  Valid only for stacked option arguments. */
#define STACKLST_OPT(n) (((tArgList*)(DESC(n).optCookie))->apzArgs)
/** Reset an option. */
#define    CLEAR_OPT(n) STMTS( \
                DESC(n).fOptState &= OPTST_PERSISTENT_MASK;   \
                if ((DESC(n).fOptState & OPTST_INITENABLED) == 0) \
                    DESC(n).fOptState |= OPTST_DISABLED; \
                DESC(n).optCookie = NULL )
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/**
 *  Enumeration of xml2ag exit codes
 */
typedef enum {
    XML2AG_EXIT_SUCCESS         = 0,
    XML2AG_EXIT_FAILURE         = 1,
    XML2AG_EXIT_USAGE_ERROR     = 64,
    XML2AG_EXIT_LIBOPTS_FAILURE = 70
}   xml2ag_exit_code_t;
/**
 *  Interface defines for specific options.
 * @{
 */
#define VALUE_OPT_OUTPUT         'O'
#define VALUE_OPT_TEMPL_DIRS     'L'
#define VALUE_OPT_OVERRIDE_TPL   'T'
#define VALUE_OPT_DEFINITIONS    0x1001
#define VALUE_OPT_SHELL          0x1002
#define VALUE_OPT_NO_FMEMOPEN    'm'
#define VALUE_OPT_EQUATE         0x1003
#define VALUE_OPT_BASE_NAME      'b'

#define SET_OPT_BASE_NAME(a)   STMTS( \
        DESC(BASE_NAME).optActualIndex = 9; \
        DESC(BASE_NAME).optActualValue = VALUE_OPT_BASE_NAME; \
        DESC(BASE_NAME).fOptState &= OPTST_PERSISTENT_MASK; \
        DESC(BASE_NAME).fOptState |= OPTST_SET; \
        DESC(BASE_NAME).optArg.argString = (a) )
#define VALUE_OPT_SOURCE_TIME    0x1004
#define VALUE_OPT_WRITABLE       0x1005
#define VALUE_OPT_LOOP_LIMIT     0x1006

#define OPT_VALUE_LOOP_LIMIT     (DESC(LOOP_LIMIT).optArg.argInt)
#define VALUE_OPT_TIMEOUT        't'

#define OPT_VALUE_TIMEOUT        (DESC(TIMEOUT).optArg.argInt)
#define VALUE_OPT_TRACE          0x1007

typedef enum {
    TRACE_NOTHING,         TRACE_DEBUG_MESSAGE,   TRACE_SERVER_SHELL,
    TRACE_TEMPLATES,       TRACE_BLOCK_MACROS,    TRACE_EXPRESSIONS,
    TRACE_EVERYTHING
} te_Trace;
#define OPT_TRACE_VAL2STR(_v)    optionKeywordName(&DESC(TRACE), (_v))
#define OPT_VALUE_TRACE          (DESC(TRACE).optArg.argEnum)
#define VALUE_OPT_TRACE_OUT      0x1008
#define VALUE_OPT_SHOW_DEFS      0x1009
#define VALUE_OPT_USED_DEFINES   0x100A
#define VALUE_OPT_CORE           'C'
#define VALUE_OPT_SKIP_SUFFIX    's'
#define VALUE_OPT_SELECT_SUFFIX  'o'
#define VALUE_OPT_DEFINE         'D'
#define VALUE_OPT_UNDEFINE       'U'
#define VALUE_OPT_MAKE_DEP       'M'
/** option flag (value) for help-value option */
#define VALUE_OPT_HELP          '?'
/** option flag (value) for more-help-value option */
#define VALUE_OPT_MORE_HELP     '!'
/** option flag (value) for version-value option */
#define VALUE_OPT_VERSION       'v'
/*
 *  Interface defines not associated with particular options
 */
#define ERRSKIP_OPTERR  STMTS(xml2agOptions.fOptSet &= ~OPTPROC_ERRSTOP)
#define ERRSTOP_OPTERR  STMTS(xml2agOptions.fOptSet |= OPTPROC_ERRSTOP)
#define RESTART_OPT(n)  STMTS( \
                xml2agOptions.curOptIdx = (n); \
                xml2agOptions.pzCurOpt  = NULL )
#define START_OPT       RESTART_OPT(1)
#define USAGE(c)        (*xml2agOptions.pUsageProc)(&xml2agOptions, c)

#ifdef  __cplusplus
extern "C" {
#endif
/*
 *  global exported definitions
 */
#include <sys/types.h>
#include <sys/stat.h>

#ifndef __USE_POSIX
#  define __USE_POSIX /* for glib's pedantic needs */
#endif
#ifndef __USE_XOPEN_EXTENDED
#  define __USE_XOPEN_EXTENDED  /* ditto */
#endif
#include <stdio.h>
#include <ctype.h>
#include <errno.h>
#include <fcntl.h>
#include <limits.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include <libxml/parser.h>
#include <libxml/tree.h>

extern FILE * ag_pipe_fp;
#ifndef NUL
#  define NUL '\0'
#endif
extern void fork_ag(char const * pzInput);


/* * * * * *
 *
 *  Declare the xml2ag option descriptor.
 */
extern tOptions xml2agOptions;
# define OPT_NO_XLAT_CFG_NAMES
# define OPT_NO_XLAT_OPT_NAMES

# define OPT_XLAT_CFG_NAMES
# define OPT_XLAT_OPT_NAMES

# ifndef _
#   define _(_s)  _s
# endif


#ifdef  __cplusplus
}
#endif
#endif /* AUTOOPTS_XMLOPTS_H_GUARD */

/** @} */
/* xmlopts.h ends here */
